!{\src2tex{textfont=tt}}
!!****m* etsf_split/etsf_io_split_free
!! NAME
!!  etsf_io_split_free
!!
!! FUNCTION
!!    Deallocate a split defintions, previously allocated with
!!    etsf_io_split_allocate().
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! SIDE EFFECTS
!! * split <type(etsf_split)> = 
!!     free all associated array in the split definition.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_split_free(split)

  !Arguments ------------------------------------
  type(etsf_split), intent(inout) :: split

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_split_free'


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_split_free : enter'
!ENDDEBUG

  if (associated(split%my_kpoints)) then
    deallocate(split%my_kpoints)
  end if
  if (associated(split%my_grid_points_vector3)) then
    deallocate(split%my_grid_points_vector3)
  end if
  if (associated(split%my_spins)) then
    deallocate(split%my_spins)
  end if
  if (associated(split%my_grid_points_vector1)) then
    deallocate(split%my_grid_points_vector1)
  end if
  if (associated(split%my_grid_points_vector2)) then
    deallocate(split%my_grid_points_vector2)
  end if
  if (associated(split%my_coefficients)) then
    deallocate(split%my_coefficients)
  end if
  if (associated(split%my_components)) then
    deallocate(split%my_components)
  end if
  if (associated(split%my_states)) then
    deallocate(split%my_states)
  end if


!DEBUG
!write (*,*) 'etsf_io_split_free : exit'
!ENDDEBUG

end subroutine etsf_io_split_free
!!***
