// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the findings for the specified Network Access Scope analysis.
func (c *Client) GetNetworkInsightsAccessScopeAnalysisFindings(ctx context.Context, params *GetNetworkInsightsAccessScopeAnalysisFindingsInput, optFns ...func(*Options)) (*GetNetworkInsightsAccessScopeAnalysisFindingsOutput, error) {
	if params == nil {
		params = &GetNetworkInsightsAccessScopeAnalysisFindingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetNetworkInsightsAccessScopeAnalysisFindings", params, optFns, c.addOperationGetNetworkInsightsAccessScopeAnalysisFindingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetNetworkInsightsAccessScopeAnalysisFindingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetNetworkInsightsAccessScopeAnalysisFindingsInput struct {

	// The ID of the Network Access Scope analysis.
	//
	// This member is required.
	NetworkInsightsAccessScopeAnalysisId *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it is
	// UnauthorizedOperation.
	DryRun *bool

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetNetworkInsightsAccessScopeAnalysisFindingsOutput struct {

	// The findings associated with Network Access Scope Analysis.
	AnalysisFindings []types.AccessScopeAnalysisFinding

	// The status of Network Access Scope Analysis.
	AnalysisStatus types.AnalysisStatus

	// The ID of the Network Access Scope analysis.
	NetworkInsightsAccessScopeAnalysisId *string

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetNetworkInsightsAccessScopeAnalysisFindingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetNetworkInsightsAccessScopeAnalysisFindings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetNetworkInsightsAccessScopeAnalysisFindings{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetNetworkInsightsAccessScopeAnalysisFindingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetNetworkInsightsAccessScopeAnalysisFindings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetNetworkInsightsAccessScopeAnalysisFindings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "GetNetworkInsightsAccessScopeAnalysisFindings",
	}
}
