// Code generated by smithy-go-codegen DO NOT EDIT.

package iotwireless

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotwireless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sends a decrypted application data frame to a device.
func (c *Client) SendDataToWirelessDevice(ctx context.Context, params *SendDataToWirelessDeviceInput, optFns ...func(*Options)) (*SendDataToWirelessDeviceOutput, error) {
	if params == nil {
		params = &SendDataToWirelessDeviceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SendDataToWirelessDevice", params, optFns, c.addOperationSendDataToWirelessDeviceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SendDataToWirelessDeviceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SendDataToWirelessDeviceInput struct {

	// The ID of the wireless device to receive the data.
	//
	// This member is required.
	Id *string

	// The binary to be sent to the end device, encoded in base64.
	//
	// This member is required.
	PayloadData *string

	// The transmit mode to use to send data to the wireless device. Can be: 0 for UM
	// (unacknowledge mode) or 1 for AM (acknowledge mode).
	//
	// This member is required.
	TransmitMode *int32

	// Metadata about the message request.
	WirelessMetadata *types.WirelessMetadata

	noSmithyDocumentSerde
}

type SendDataToWirelessDeviceOutput struct {

	// The ID of the message sent to the wireless device.
	MessageId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSendDataToWirelessDeviceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSendDataToWirelessDevice{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSendDataToWirelessDevice{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSendDataToWirelessDeviceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSendDataToWirelessDevice(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSendDataToWirelessDevice(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "iotwireless",
		OperationName: "SendDataToWirelessDevice",
	}
}
