// Code generated by smithy-go-codegen DO NOT EDIT.

package sns

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows a topic owner to set an attribute of the topic to a new value.
func (c *Client) SetTopicAttributes(ctx context.Context, params *SetTopicAttributesInput, optFns ...func(*Options)) (*SetTopicAttributesOutput, error) {
	if params == nil {
		params = &SetTopicAttributesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SetTopicAttributes", params, optFns, c.addOperationSetTopicAttributesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SetTopicAttributesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input for SetTopicAttributes action.
type SetTopicAttributesInput struct {

	// A map of attributes with their corresponding values. The following lists the
	// names, descriptions, and values of the special request parameters that the
	// SetTopicAttributes action uses:
	//
	// * DeliveryPolicy – The policy that defines how
	// Amazon SNS retries failed deliveries to HTTP/S endpoints.
	//
	// * DisplayName – The
	// display name to use for a topic with SMS subscriptions.
	//
	// * Policy – The policy
	// that defines who can access your topic. By default, only the topic owner can
	// publish or subscribe to the topic.
	//
	// The following attribute applies only to
	// server-side-encryption
	// (https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
	//
	// *
	// KmsMasterKeyId – The ID of an Amazon Web Services managed customer master key
	// (CMK) for Amazon SNS or a custom CMK. For more information, see Key Terms
	// (https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms).
	// For more examples, see KeyId
	// (https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)
	// in the Key Management Service API Reference.
	//
	// The following attribute applies
	// only to FIFO topics
	// (https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
	//
	// *
	// ContentBasedDeduplication – Enables content-based deduplication for FIFO
	// topics.
	//
	// * By default, ContentBasedDeduplication is set to false. If you create
	// a FIFO topic and this attribute is false, you must specify a value for the
	// MessageDeduplicationId parameter for the Publish
	// (https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action.
	//
	// * When
	// you set ContentBasedDeduplication to true, Amazon SNS uses a SHA-256 hash to
	// generate the MessageDeduplicationId using the body of the message (but not the
	// attributes of the message). (Optional) To override the generated value, you can
	// specify a value for the MessageDeduplicationId parameter for the Publish action.
	//
	// This member is required.
	AttributeName *string

	// The ARN of the topic to modify.
	//
	// This member is required.
	TopicArn *string

	// The new value for the attribute.
	AttributeValue *string

	noSmithyDocumentSerde
}

type SetTopicAttributesOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSetTopicAttributesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpSetTopicAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpSetTopicAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSetTopicAttributesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSetTopicAttributes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSetTopicAttributes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sns",
		OperationName: "SetTopicAttributes",
	}
}
