package billing

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// TransactionsClient is the billing client provides access to billing resources for Azure subscriptions.
type TransactionsClient struct {
	BaseClient
}

// NewTransactionsClient creates an instance of the TransactionsClient client.
func NewTransactionsClient(subscriptionID string) TransactionsClient {
	return NewTransactionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewTransactionsClientWithBaseURI creates an instance of the TransactionsClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewTransactionsClientWithBaseURI(baseURI string, subscriptionID string) TransactionsClient {
	return TransactionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListByInvoice lists the transactions for an invoice. Transactions include purchases, refunds and Azure usage
// charges.
// Parameters:
// billingAccountName - the ID that uniquely identifies a billing account.
// invoiceName - the ID that uniquely identifies an invoice.
func (client TransactionsClient) ListByInvoice(ctx context.Context, billingAccountName string, invoiceName string) (result TransactionListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionsClient.ListByInvoice")
		defer func() {
			sc := -1
			if result.tlr.Response.Response != nil {
				sc = result.tlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByInvoiceNextResults
	req, err := client.ListByInvoicePreparer(ctx, billingAccountName, invoiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.TransactionsClient", "ListByInvoice", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByInvoiceSender(req)
	if err != nil {
		result.tlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.TransactionsClient", "ListByInvoice", resp, "Failure sending request")
		return
	}

	result.tlr, err = client.ListByInvoiceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.TransactionsClient", "ListByInvoice", resp, "Failure responding to request")
		return
	}
	if result.tlr.hasNextLink() && result.tlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByInvoicePreparer prepares the ListByInvoice request.
func (client TransactionsClient) ListByInvoicePreparer(ctx context.Context, billingAccountName string, invoiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"invoiceName":        autorest.Encode("path", invoiceName),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}/transactions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByInvoiceSender sends the ListByInvoice request. The method will close the
// http.Response Body if it receives an error.
func (client TransactionsClient) ListByInvoiceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByInvoiceResponder handles the response to the ListByInvoice request. The method always
// closes the http.Response Body.
func (client TransactionsClient) ListByInvoiceResponder(resp *http.Response) (result TransactionListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByInvoiceNextResults retrieves the next set of results, if any.
func (client TransactionsClient) listByInvoiceNextResults(ctx context.Context, lastResults TransactionListResult) (result TransactionListResult, err error) {
	req, err := lastResults.transactionListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "billing.TransactionsClient", "listByInvoiceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByInvoiceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "billing.TransactionsClient", "listByInvoiceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByInvoiceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.TransactionsClient", "listByInvoiceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByInvoiceComplete enumerates all values, automatically crossing page boundaries as required.
func (client TransactionsClient) ListByInvoiceComplete(ctx context.Context, billingAccountName string, invoiceName string) (result TransactionListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionsClient.ListByInvoice")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByInvoice(ctx, billingAccountName, invoiceName)
	return
}
