/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.io;

import java.io.File;
import java.io.FilenameFilter;

/**
 * Die Klasse <code>EndsWithFilter</code> überprüft ob der Name einer
 * Datei mit dem definierten Anfang übereinstimmt.
 *
 * @author <a href="mailto:michael.fuchs@unico-group.com">Michael Fuchs</a>
 * @version 1.0
 */
public class StartsWithFilter
    implements FilenameFilter {

    /** Der Anfang, der überprüft werden soll. */
    private String start;
    
    /**
     * Erzeugt eine neue Instanz der Klasse
     * <code>StartsWithFileNameFilter</code>.
     *
     * @param start <code>String</code>
     */
    public StartsWithFilter(String start) {
        this.start = start;
    }
    
    /**
     * Die Methode <code>accept</code> überprüft ob der angegebene Dateiname auf
     * den definierten Anfang passt.
     *
     * Die Überprüfung des Anfangs erfolgt ohne Beachtung der Groß- und
     * Kleinschreibung.
     *
     * @param file <code>File</code>
     * @param name <code>String</code>
     * @return <code>boolean</code>
     */
    public boolean accept(File file, String name) {

        String s1 = name.toLowerCase();
        String s2 = start.toLowerCase();

        return s1.startsWith(s2);
    }
}
/*
 * $Log: StartsWithFileNameFilter.java,v $
 * Revision 1.1.1.1  2004/12/21 14:06:38  mfuchs
 * Reimport
 *
 * Revision 1.3  2004/09/03 08:26:54  mfuchs
 * Sicherung
 *
 * Revision 1.2  2004/08/27 19:30:32  mfuchs
 * Dokumentation
 *
 * Revision 1.1.1.1  2004/05/13 17:14:37  mfuchs
 * Services
 *
 */
