// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: powerpc-registered-target
// RUN: %clang_cc1 -triple powerpc64-unknown-linux-gnu \
// RUN:    -emit-llvm %s -o -  -target-cpu pwr8 | FileCheck %s
// RUN: %clang_cc1 -triple powerpc64le-unknown-linux-gnu \
// RUN:   -emit-llvm %s -o -  -target-cpu pwr8 | FileCheck %s


// CHECK-LABEL: @test_builtin_ppc_compare_and_swap(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store i32 [[A:%.*]], i32* [[A_ADDR]], align 4
// CHECK-NEXT:    store i32 [[B:%.*]], i32* [[B_ADDR]], align 4
// CHECK-NEXT:    store i32 [[C:%.*]], i32* [[C_ADDR]], align 4
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[C_ADDR]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg weak volatile i32* [[A_ADDR]], i32 [[TMP1]], i32 [[TMP0]] monotonic monotonic, align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP2]], 0
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { i32, i1 } [[TMP2]], 1
// CHECK-NEXT:    store i32 [[TMP3]], i32* [[B_ADDR]], align 4
// CHECK-NEXT:    ret void
//
void test_builtin_ppc_compare_and_swap(int a, int b, int c) {
  __compare_and_swap(&a, &b, c);
}


// CHECK-LABEL: @test_builtin_ppc_compare_and_swaplp(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    store i64 [[A:%.*]], i64* [[A_ADDR]], align 8
// CHECK-NEXT:    store i64 [[B:%.*]], i64* [[B_ADDR]], align 8
// CHECK-NEXT:    store i64 [[C:%.*]], i64* [[C_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, i64* [[C_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i64, i64* [[B_ADDR]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg weak volatile i64* [[A_ADDR]], i64 [[TMP1]], i64 [[TMP0]] monotonic monotonic, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { i64, i1 } [[TMP2]], 0
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { i64, i1 } [[TMP2]], 1
// CHECK-NEXT:    store i64 [[TMP3]], i64* [[B_ADDR]], align 8
// CHECK-NEXT:    ret void
//
void test_builtin_ppc_compare_and_swaplp(long a, long b, long c) {
  __compare_and_swaplp(&a, &b, c);
}

