/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.attribute.table.TableColumnAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableRowAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableTableAttribute;

/**
 * DOM implementation of OpenDocument element  {@odf.element table:cell-address}.
 *
 */
public class TableCellAddressElement extends OdfElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TABLE, "cell-address");

	/**
	 * Create the instance of <code>TableCellAddressElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableCellAddressElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:cell-address}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableColumnAttribute</code> , See {@odf.attribute table:column}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableColumnAttribute() {
		TableColumnAttribute attr = (TableColumnAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "column");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableColumnAttribute</code> , See {@odf.attribute table:column}
	 *
	 * @param tableColumnValue   The type is <code>Integer</code>
	 */
	public void setTableColumnAttribute(Integer tableColumnValue) {
		TableColumnAttribute attr = new TableColumnAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableColumnValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableRowAttribute</code> , See {@odf.attribute table:row}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableRowAttribute() {
		TableRowAttribute attr = (TableRowAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "row");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableRowAttribute</code> , See {@odf.attribute table:row}
	 *
	 * @param tableRowValue   The type is <code>Integer</code>
	 */
	public void setTableRowAttribute(Integer tableRowValue) {
		TableRowAttribute attr = new TableRowAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableRowValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableTableAttribute</code> , See {@odf.attribute table:table}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableTableAttribute() {
		TableTableAttribute attr = (TableTableAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "table");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableTableAttribute</code> , See {@odf.attribute table:table}
	 *
	 * @param tableTableValue   The type is <code>Integer</code>
	 */
	public void setTableTableAttribute(Integer tableTableValue) {
		TableTableAttribute attr = new TableTableAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableTableValue.intValue());
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
