# 7/16/2020

### Attending:

* Cary Phillips
* Christina Tempelaar-Lietz
* Joseph Goldstone
* Kimball Thurston
* Larry Gritz
* Nick Porcino
* Owen Thompson
* Peter Hillman
* Rod Bogart

### Discussion:

* The CLA. Disney refuses to sign the current one, although Disney
  employees already authorized have apparently somehow slipped
  through. This came to a head with OSL. We (OpenEXR TSC) have no
  concerns about moving to the new CLA that the ASWF Governing Board
  legal committee settled on, which is Apache 2. We will request help
  from John Mertic to navigate through changing the forms in EasyCLA,
  and getting respetive companies to sign the new one, without anyone
  getting locked out of push access to the repo. Also, we need to
  update the documents in repo and make sure there are no references
  to the outdated form. Cary will request help from John Mertic.

* Review the logo concepts from Ali Rowan, graphic designer with the
  Linux Foundation. The red version is nicely suggestive of the old
  logo. The trapezoidal shapes were intended to suggest a perspective
  projection, although the shape in the concept designs provided is
  not a perspective, and this feature has relatively minor appeal to
  the group. Therefore, we settle on the square-ish red logo. Note
  that we need several variations: text on the bottom, text to the
  right, no text, gray-scale, very small "favicon". Cary will request
  that of Ali.


* Open Source Day

  * Outline:

    * Brief recap of the year
    * Overview of OpenEXR 3.0 release
    * Overview of Imath (given by Owen)
    * Introduction of new openexr.com (hopefully given by Sarah Martin)

  * Arkell agreed to provide some updated images for the
    openexr-images repo, although he reports that he's not prepared to
    generate and deep exr images.

  * Cary requested 25 minutes, but given that Imath is a major topic,
    we expect enough comments and feedback that we should increase
    that to 55 minutes. Cary will follow up with Emily Olin.

  * Larry notes: This is the biggest release in a very long time, with
    signficant implications to the user community. Everyone who builds
    openexr is going to be affected.

  * We should expect lots of questions and vigorous discussion. We had
   good questions last year (e.g. “Is OpenEXR appropriate for ML?”)

  * The title of session should prominently feature "Imath".

* 3.0 Release: time to get in any changes that break compatibility.

  We should make a pass at cleaning up exceptions in the OpenEXR tree.

  Some Issues for potential inclusion:

  * getChunkOffsetTableSize https://github.com/AcademySoftwareFoundation/openexr/issues/740

  * Include guards https://github.com/AcademySoftwareFoundation/openexr/issues/636

  * Signed strides: https://github.com/AcademySoftwareFoundation/openexr/issues/614

  We will need to take care with how OpenEXR references Imath. It
  could potentially be an external project path in cmake that
  auto-clones imath repo. Nick reports that this works well with
  OpenTimelineIO.

  We should remove legacy thread support, just use std::thread We
  still want to provide the semaphore class. Lock is slower than a
  semaphore class.  Keep the shim layer.

  We should we move some of the directories up a level, so the OpenEXR repo has subfolders:

  * src

  * test

  * tools

* OSS-Fuzz: Going well so far, around a dozen issues, which have been
  easy to reproduce and identify. It takes some thought to determine
  how to resolve them. Do we want to break compatibility, or suppress
  it?

  Peter points out that the most recent report, the test case is
  broken, the exr is bad data. Peter will follow up with fuzz folks.

* Owen reports on progress with Imath.

  * Initial push of constexpr changes

  * A small set of tests. There are some python binding missing.

  * Cuda: The strategy is when compiling with Cuda, put half into Imath internal namespace.

    What is different between cuda and imath half? Bit layout is the
    same. Our class has HasInf, could use std::isinf override.  Rod:
    We tried to merge with NVIDIA.

    Owen will write a test that verifies the behavior.  Should still
    support C++11.

  * Create a RC3 branch.

* clang-format: Would like to reformat before the 3.0 release.  Nick
  says that OpenTimelineIO used the openexr template with
  success. Larry notes: Whatever we choose, there will be sections
  that don't format nicely, so just turn off formatting.  But, a year
  later, you'll forget about what you didn't like.

  Don't like #include sorting, it can break the build; alphabetical
  order is not always what you want.

