use strict;
use warnings;
package Debian::PkgPerl::Util;

=head1 NAME

Debian::PkgPerl::Util - utility functions for PkgPerl tools

=head1 SYNOPSIS

 use Debian::PkgPer:Util;
 ...
 $dep = "$dep <!nocheck>"
    unless Debian::PkgPerl::Util->probable_build_dependency($pkg);

=head1 DESCRIPTION

=over 4

=item B<probable_build_dependency>(I<package name>)

Returns true if the package name is likely to be used for building, and
not only at runtime or only for testing.

=back

=cut

sub probable_build_dependency {
    my ($class, $pkg) = @_;

    return $pkg =~ /-dev(?::.+)?$/ || $pkg =~ /^(?x:
        .^ # a placeholder to help with aesthetics
        | autoconf
        | automake
        | bash-completion
        | bison
        | cdbs
        | chrpath
        | debhelper
        | dh-
        | flex
        | gnulib
        | help2man
        | install-info
        | libalien-
        | libcanary-stability-perl
        | libconfig-autoconf-perl
        | libcrypt-openssl-guess-perl
        | libdevel-checklib-perl
        | libdevel-mat-dumper-perl
        | libextutils-
        | libffi-checklib-perl
        | libfile-sharedir-
        | libmodule-build-
        | libmodule-install-
        | libparse-recdescent-perl
        | libparse-yapp-perl
        | libpkgconfig-perl
        | libtool
        | libxs-parse-sublike-perl
        | llvm
        | perl
        | pkg-config
        | pkgconf
        | po-debconf
        | po4a
        | rename
        | swig
        | ucf
        )/;
}

1;
__END__

=head1 COPYRIGHT AND LICENSE

=over 4

=item Copyright 2022 gregor herrmann <gregoa@debian.org>

=item Copyright 2022 Damyan Ivanov <dmn@debian.org>

=back

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See L<http://dev.perl.org/licenses/> for more information.

=cut
