text = """
    Pmw is a toolkit for building high-level compound widgets, or
    'megawidgets', constructed using other widgets as component parts. 
    It promotes consistent look and feel within and between graphical
    applications, is highly configurable to your needs and is easy to
    use.
    
    Pmw consists of:

	- A few base classes, providing a foundation for building
	  megawidgets.

	- A library of flexible and extensible megawidgets built on
          the base classes, such as buttonboxes, notebooks,
          comboboxes, selection widgets, paned widgets, scrolled
          widgets and dialog windows.

	- A lazy importer/dynamic loader which is automatically
	  invoked when Pmw is first imported.  This gives unified
	  access to all Pmw classes and functions through the *Pmw.*
	  prefix.  It also speeds up module loading time by only
	  importing Pmw sub-modules when needed.

	- Complete reference documentation, covering all classes and
          functions including all megawidgets and their options,
          methods and components.  Helpful tutorial material is also
          available.

	- A test framework and tests for Pmw megawidgets.

	- A slick demonstration of the megawidgets.

	- An interface to the BLT busy, graph and vector commands.

    The interface to Pmw megawidgets is similar to basic Tk widgets, so it
    is easy for developers to include both megawidgets and basic Tk
    widgets in their graphical applications.  In addition, Pmw
    megawidgets may themselves be extended, using either inheritance or
    composition.

    The use of the Pmw megawidgets replaces common widget combinations
    with higher level abstractions.  This simplifies code, making it
    more readable and maintainable.  The ability to extend Pmw
    megawidgets enables developers to create new megawidgets based on
    previous work.

"""
