# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class AddressConfigurationTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.conversations.v1.address_configurations.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://conversations.twilio.com/v1/Configuration/Addresses',
        ))

    def test_read_all_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://conversations.twilio.com/v1/Configuration/Addresses?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://conversations.twilio.com/v1/Configuration/Addresses?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "address_configurations"
                },
                "address_configurations": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sid": "IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "address": "+37256123457",
                        "type": "sms",
                        "friendly_name": "My Test Configuration",
                        "auto_creation": {
                            "enabled": true,
                            "type": "webhook",
                            "conversation_service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "webhook_url": "https://example.com",
                            "webhook_method": "POST",
                            "webhook_filters": [
                                "onParticipantAdded",
                                "onMessageAdded"
                            ]
                        },
                        "date_created": "2016-03-24T21:05:50Z",
                        "date_updated": "2016-03-24T21:05:50Z",
                        "url": "https://conversations.twilio.com/v1/Configuration/Addresses/IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    },
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sid": "IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab",
                        "address": "+37256123458",
                        "type": "sms",
                        "friendly_name": "Studio Test Configuration",
                        "auto_creation": {
                            "enabled": false,
                            "type": "studio",
                            "conversation_service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "studio_flow_sid": "FWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "studio_retry_count": 3
                        },
                        "date_created": "2016-03-24T21:05:50Z",
                        "date_updated": "2016-03-24T21:05:50Z",
                        "url": "https://conversations.twilio.com/v1/Configuration/Addresses/IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"
                    },
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sid": "IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac",
                        "address": "+37256123459",
                        "type": "sms",
                        "friendly_name": "Default Test Configuration",
                        "auto_creation": {
                            "enabled": true,
                            "type": "default"
                        },
                        "date_created": "2016-03-24T21:05:50Z",
                        "date_updated": "2016-03-24T21:05:50Z",
                        "url": "https://conversations.twilio.com/v1/Configuration/Addresses/IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac"
                    }
                ]
            }
            '''
        ))

        actual = self.client.conversations.v1.address_configurations.list()

        self.assertIsNotNone(actual)

    def test_read_blank_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://conversations.twilio.com/v1/Configuration/Addresses?PageSize=50&Page=0",
                    "url": "https://conversations.twilio.com/v1/Configuration/Addresses?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "next_page_url": null,
                    "key": "address_configurations"
                },
                "address_configurations": []
            }
            '''
        ))

        actual = self.client.conversations.v1.address_configurations.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.conversations.v1.address_configurations("IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://conversations.twilio.com/v1/Configuration/Addresses/IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "address": "+37256123457",
                "type": "sms",
                "friendly_name": "My Test Configuration",
                "auto_creation": {
                    "enabled": true,
                    "type": "webhook",
                    "conversation_service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "webhook_url": "https://example.com",
                    "webhook_method": "POST",
                    "webhook_filters": [
                        "onParticipantAdded",
                        "onMessageAdded"
                    ]
                },
                "date_created": "2016-03-24T21:05:50Z",
                "date_updated": "2016-03-24T21:05:50Z",
                "url": "https://conversations.twilio.com/v1/Configuration/Addresses/IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.conversations.v1.address_configurations("IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.conversations.v1.address_configurations.create(type="sms", address="address")

        values = {'Type': "sms", 'Address': "address", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://conversations.twilio.com/v1/Configuration/Addresses',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "address": "+37256123457",
                "type": "sms",
                "friendly_name": "My Test Configuration",
                "auto_creation": {
                    "enabled": true,
                    "type": "webhook",
                    "conversation_service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "webhook_url": "https://example.com",
                    "webhook_method": "POST",
                    "webhook_filters": [
                        "onParticipantAdded",
                        "onMessageAdded"
                    ]
                },
                "date_created": "2016-03-24T21:05:50Z",
                "date_updated": "2016-03-24T21:05:50Z",
                "url": "https://conversations.twilio.com/v1/Configuration/Addresses/IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.conversations.v1.address_configurations.create(type="sms", address="address")

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.conversations.v1.address_configurations("IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://conversations.twilio.com/v1/Configuration/Addresses/IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "address": "+37256123457",
                "type": "sms",
                "friendly_name": "My Test Configuration Updated",
                "auto_creation": {
                    "enabled": false,
                    "type": "studio",
                    "conversation_service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "studio_flow_sid": "FWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "studio_retry_count": 3
                },
                "date_created": "2016-03-24T21:05:50Z",
                "date_updated": "2016-03-24T21:05:51Z",
                "url": "https://conversations.twilio.com/v1/Configuration/Addresses/IGaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.conversations.v1.address_configurations("IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.conversations.v1.address_configurations("IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://conversations.twilio.com/v1/Configuration/Addresses/IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.conversations.v1.address_configurations("IGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)
