% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{themes}
\alias{themes}
\title{CLI themes}
\description{
CLI elements can be styled via a CSS-like language of selectors and
properties. Note that while most of the CSS3 language is supported,
a lot visual properties cannot be implemented on a terminal, so these
will be ignored.
}
\section{Adding themes}{

The style of an element is calculated from themes from four sources.
These form a stack, and the styles on the top of the stack take
precedence, over styles in the bottom.
\enumerate{
\item The cliapp package has a builtin theme. This is always active.
See \code{\link[=builtin_theme]{builtin_theme()}}.
\item When an app object is created via \code{\link[=start_app]{start_app()}}, the caller can
specify a theme, that is added to theme stack. If no theme is
specified for \code{\link[=start_app]{start_app()}}, the content of the \code{cli.theme} option
is used. Removed when the corresponding app stops.
\item The user may speficy a theme in the \code{cli.user_theme} option. This
is added to the stack \emph{after} the app's theme (step 2.), so it can
override its settings. Removed when the app that added it stops.
\item Themes specified explicitly in \code{\link[=cli_div]{cli_div()}} elements. These are
removed from the theme stack, when the corresponding \code{\link[=cli_div]{cli_div()}}
elements are closed.
}
}

\section{Writing themes}{

A theme is a named list of lists. The name of each entry is a CSS
selector. Most features of CSS selectors are supported here:, for a
complete reference, see the selectr package.

The content of a theme list entry is another named list, where the
names are CSS properties, e.g. \code{color}, or \code{font-weight} or
\code{margin-left}, and the list entries themselves define the values of
the properties. See \code{\link[=builtin_theme]{builtin_theme()}} and \code{\link[=simple_theme]{simple_theme()}} for examples.
}

\section{CSS pseudo elements}{

Currently only the \verb{::before} and \verb{::after} pseudo elements are
supported.
}

\section{Formatter callbacks}{

For flexibility, themes may also define formatter functions, with
property name \code{fmt}. These will be called once the other styles are
applied to an element. They are only called on elements that produce
output, i.e. \emph{not} on container elements.
}

\section{Supported properties}{

Right now only a limited set of properties are supported. These include
left, right, top and bottom margins, background and foreground colors,
bold and italic fonts, underlined text. The \code{content} property is
supported to insert text via \verb{::before} and \verb{::after} selectors.

More properties might be adder later.

Please see the example themes and the source code for now for the
details.
}

\section{Examples}{

Color of headers, that are only active in paragraphs with an
'output' class:\preformatted{list(
  "par.output h1" = list("background-color" = "red", color = "#e0e0e0"),
  "par.output h2" = list("background-color" = "orange", color = "#e0e0e0"),
  "par.output h3" = list("background-color" = "blue", color = "#e0e0e0")
)
}

Create a custom alert type:\preformatted{list(
  ".alert-start::before" = list(content = symbol$play),
  ".alert-stop::before"  = list(content = symbol$stop)
)
}
}

