% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-perform.R
\name{req_stream}
\alias{req_stream}
\title{Perform a request, streaming data back to R}
\usage{
req_stream(req, callback, timeout_sec = Inf, buffer_kb = 64)
}
\arguments{
\item{req}{A \link{request}.}

\item{callback}{A single argument callback function. It will be called
repeatedly with a raw vector whenever there is at least \code{buffer_kb}
worth of data to process. It must return \code{TRUE} to continue streaming.}

\item{timeout_sec}{Number of seconds to processs stream for.}

\item{buffer_kb}{Buffer size, in kilobytes.}
}
\value{
An HTTP \link{response}.
}
\description{
After preparing a request, call \code{req_stream()} to perform the request
and handle the result with a streaming callback. This is useful for
streaming HTTP APIs where potentially the stream never ends.
}
\examples{
show_bytes <- function(x) {
  cat("Got ", length(x), " bytes\n", sep = "")
  TRUE
}
resp <- request("http://httpbin.org/stream-bytes/100000") \%>\%
  req_stream(show_bytes, buffer_kb = 32)
}
