% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_frame.R
\name{get_frame}
\alias{get_frame}
\alias{get_raw_frames}
\title{Extract a frame from a generator}
\usage{
get_frame(generator, at, ...)

get_raw_frames(generator, at, before = 0, after = 0, ...)
}
\arguments{
\item{generator}{A \code{frame_generator} object}

\item{at}{A scalar numeric between 0 and 1}

\item{...}{Arguments passed on to methods}

\item{before, after}{Scalar numerics that define the time before and after
\code{at} to search for raw data}
}
\description{
Using the generators in tweenr you can avoid calculating all needed frames up
front, which can be prohibitive in memory. With a generator you can use
\code{get_frame()} to extract any frame at a fractional location between 0 and 1
one by one as you need them. You can further get all raw data before and/or
after a given point in time using \code{get_raw_frames()}.
}
\examples{
data <- data.frame(
  x = c(1, 2, 2, 1, 2, 2),
  y = c(1, 2, 2, 2, 1, 1),
  time = c(1, 4, 8, 4, 8, 10),
  id = c(1, 1, 1, 2, 2, 2)
)

gen <- gen_components(data, 'cubic-in-out', time = time, id = id)

get_frame(gen, 0.3)

get_raw_frames(gen, 0.5, before = 0.5, after = 0.2)
}
