#------------------------------------------------------------------------------
#$Author: andrius $
#$Date: 2020-01-30 04:56:57 -0500 (Thu, 30 Jan 2020) $ 
#$Revision: 5865 $
#$URL: svn://saulius-grazulis.lt/restful/tags/v0.16.0/lib/Database/Lock.pm $
#------------------------------------------------------------------------------
#*
#  An object to encapsulate a lock on database tables.
#**

package Database::Lock;
use strict;
use warnings;

use Database;
use DBI;

#=======================================================================
# Constructor

sub new
{
    my( $class, $db, @tables ) = @_;

    my $self = { db => $db };
    if( $db->{db}{content}{engine} eq 'mysql' ) {
        my $delim = $db->{db}{content}{delim};
        my $lock_sql = 'LOCK TABLES ' .
                       join ', ',
                       map { $delim . $_ . $delim . ' WRITE' }
                           @tables;

        print STDERR "$lock_sql\n" if $Database::debug_sql;
        $db->{db}{content}{dbh}->do( $lock_sql ) || die DBI::errstr;
        $self->{locked} = 1;
    }

    return bless $self, $class;
}

#=======================================================================
# Destructor

sub DESTROY
{
    my( $self ) = @_;
    $self->unlock;
}

#=======================================================================
# Methods

sub unlock
{
    my( $self ) = @_;
    return unless $self->{locked};

    my $unlock_sql = 'UNLOCK TABLES';
    print STDERR "$unlock_sql\n" if $Database::debug_sql;
    $self->{db}{db}{content}{dbh}->do( $unlock_sql ) || die DBI::errstr;

    delete $self->{locked};
}

1;
