# 2021-08-11 Triage Log

A quiet week for performance. Changes, both positive and negative, tended to be isolated to few benchmarks.

Triage done by **@pnkfelix**.
Revision range: [3354a44d2fa8d5ba6b8d6b40d2596de2c8292ec1..6b20506d17f4e5e5bf5bcad7e94add4d754b0ae3](https://perf.rust-lang.org/?start=3354a44d2fa8d5ba6b8d6b40d2596de2c8292ec1&end=6b20506d17f4e5e5bf5bcad7e94add4d754b0ae3&absolute=false&stat=instructions%3Au)

2 Regressions, 1 Improvements, 0 Mixed; 0 of them in rollups

#### Regressions

Use zeroed allocations in the mir interpreter instead eagerly touching the memory [#87777](https://github.com/rust-lang/rust/issues/87777)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1f94abcda6884893d4723304102089198caa0839&end=4c29cc8fd09889880880cb6081174c79744ab1b6&stat=instructions:u) (up to 1.7% on `incr-unchanged` builds of `ctfe-stress-4-check`)
- The motivation for this PR was to reduce the number of page faults, for the same family of ctfe-stress-4 benchmarks.
- So, perf runs were done on the PR itself, to illustrate the motivated change.
- The number of page faults [did decrease (by up to 25%)](https://perf.rust-lang.org/compare.html?start=1f94abcda6884893d4723304102089198caa0839&end=4c29cc8fd09889880880cb6081174c79744ab1b6&stat=faults).
- The regression with respect to instruction counts appears isolated to just the ctfe-stress-4 family; the page fault reduction outweighs instruction count hit.
- (Unfortunately the page fault decrease did not yield a corresponding improvement to reported wall-clock or task-clock times.)

Hide allocator details from TryReserveError [#87408](https://github.com/rust-lang/rust/issues/87408)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=db3cb435c1197ef3e3919c03b7f81ca8bffbd007&end=996ff2e0a0f911f52bb1de6bdd0cfd5704de1fc9&stat=instructions:u) (up to 4.2% on `full` builds of `html5ever-opt`)
- The regression with respect to instruction counts appears isolated to just the html5ever-opt benchmark; all other reported changes pale in significance.
- Potentially significant: the max-rss for html5ever-opt also regressed here, by 8%.
- (Skimming over the PR itself, I do not see any obvious reason for this significant of a regression to max-rss.)
- Some other benchmarks also regressed with respect to max-rss, but none so significantly.
- Left a [comment on the PR](https://github.com/rust-lang/rust/pull/87408#issuecomment-896924754) as a heads up.

#### Improvements

#[inline] slice::Iter::advance_by [#87736](https://github.com/rust-lang/rust/issues/87736)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7f3dc0464422ebadf3b8647f591bcf6e3107e805&end=6fe0886723c9e08b800c9951f1c6f6a57b2bf22c&stat=instructions:u) (up to -1.7% on `full` builds of `regex-opt`)
- This was put in to address the  regression previously injected by [PR #87387](https://github.com/rust-lang/rust/pull/87387).

#### Mixed



#### Untriaged Pull Requests

- [#87640 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/87640)
- [#87587 Various refactorings of the TAIT infrastructure](https://github.com/rust-lang/rust/pull/87587)
- [#87244 Better diagnostics with mismatched types due to implicit static lifetime](https://github.com/rust-lang/rust/pull/87244)
- [#86777 Include terminators in instance size estimate](https://github.com/rust-lang/rust/pull/86777)
- [#86698 Move OnDiskCache to rustc_query_impl.](https://github.com/rust-lang/rust/pull/86698)
- [#86588 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/86588)
- [#86034 Change entry point to 🛡️ against 💥 💥-payloads](https://github.com/rust-lang/rust/pull/86034)
- [#84560 Inline Iterator as IntoIterator.](https://github.com/rust-lang/rust/pull/84560)
