// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/secretmanager/v1/service.proto

package secretmanager

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [SecretManagerService.ListSecrets][google.cloud.secretmanager.v1.SecretManagerService.ListSecrets].
type ListSecretsRequest struct {
	// Required. The resource name of the project associated with the
	// [Secrets][google.cloud.secretmanager.v1.Secret], in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to be returned in a single page. If
	// set to 0, the server decides the number of results to return. If the
	// number is greater than 25000, it is capped at 25000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token, returned earlier via
	// [ListSecretsResponse.next_page_token][google.cloud.secretmanager.v1.ListSecretsResponse.next_page_token].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretsRequest) Reset()         { *m = ListSecretsRequest{} }
func (m *ListSecretsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSecretsRequest) ProtoMessage()    {}
func (*ListSecretsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{0}
}

func (m *ListSecretsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretsRequest.Unmarshal(m, b)
}
func (m *ListSecretsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretsRequest.Marshal(b, m, deterministic)
}
func (m *ListSecretsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretsRequest.Merge(m, src)
}
func (m *ListSecretsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSecretsRequest.Size(m)
}
func (m *ListSecretsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretsRequest proto.InternalMessageInfo

func (m *ListSecretsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSecretsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSecretsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [SecretManagerService.ListSecrets][google.cloud.secretmanager.v1.SecretManagerService.ListSecrets].
type ListSecretsResponse struct {
	// The list of [Secrets][google.cloud.secretmanager.v1.Secret] sorted in reverse by create_time (newest
	// first).
	Secrets []*Secret `protobuf:"bytes,1,rep,name=secrets,proto3" json:"secrets,omitempty"`
	// A token to retrieve the next page of results. Pass this value in
	// [ListSecretsRequest.page_token][google.cloud.secretmanager.v1.ListSecretsRequest.page_token] to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [Secrets][google.cloud.secretmanager.v1.Secret].
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretsResponse) Reset()         { *m = ListSecretsResponse{} }
func (m *ListSecretsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSecretsResponse) ProtoMessage()    {}
func (*ListSecretsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{1}
}

func (m *ListSecretsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretsResponse.Unmarshal(m, b)
}
func (m *ListSecretsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretsResponse.Marshal(b, m, deterministic)
}
func (m *ListSecretsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretsResponse.Merge(m, src)
}
func (m *ListSecretsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSecretsResponse.Size(m)
}
func (m *ListSecretsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretsResponse proto.InternalMessageInfo

func (m *ListSecretsResponse) GetSecrets() []*Secret {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *ListSecretsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListSecretsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for [SecretManagerService.CreateSecret][google.cloud.secretmanager.v1.SecretManagerService.CreateSecret].
type CreateSecretRequest struct {
	// Required. The resource name of the project to associate with the
	// [Secret][google.cloud.secretmanager.v1.Secret], in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This must be unique within the project.
	//
	// A secret ID is a string with a maximum length of 255 characters and can
	// contain uppercase and lowercase letters, numerals, and the hyphen (`-`) and
	// underscore (`_`) characters.
	SecretId string `protobuf:"bytes,2,opt,name=secret_id,json=secretId,proto3" json:"secret_id,omitempty"`
	// Required. A [Secret][google.cloud.secretmanager.v1.Secret] with initial field values.
	Secret               *Secret  `protobuf:"bytes,3,opt,name=secret,proto3" json:"secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSecretRequest) Reset()         { *m = CreateSecretRequest{} }
func (m *CreateSecretRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSecretRequest) ProtoMessage()    {}
func (*CreateSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{2}
}

func (m *CreateSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSecretRequest.Unmarshal(m, b)
}
func (m *CreateSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSecretRequest.Marshal(b, m, deterministic)
}
func (m *CreateSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSecretRequest.Merge(m, src)
}
func (m *CreateSecretRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSecretRequest.Size(m)
}
func (m *CreateSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSecretRequest proto.InternalMessageInfo

func (m *CreateSecretRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSecretRequest) GetSecretId() string {
	if m != nil {
		return m.SecretId
	}
	return ""
}

func (m *CreateSecretRequest) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

// Request message for [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.AddSecretVersion].
type AddSecretVersionRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret] to associate with the
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the format `projects/*/secrets/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The secret payload of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	Payload              *SecretPayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AddSecretVersionRequest) Reset()         { *m = AddSecretVersionRequest{} }
func (m *AddSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*AddSecretVersionRequest) ProtoMessage()    {}
func (*AddSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{3}
}

func (m *AddSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddSecretVersionRequest.Unmarshal(m, b)
}
func (m *AddSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *AddSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSecretVersionRequest.Merge(m, src)
}
func (m *AddSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_AddSecretVersionRequest.Size(m)
}
func (m *AddSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddSecretVersionRequest proto.InternalMessageInfo

func (m *AddSecretVersionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *AddSecretVersionRequest) GetPayload() *SecretPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Request message for [SecretManagerService.GetSecret][google.cloud.secretmanager.v1.SecretManagerService.GetSecret].
type GetSecretRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret], in the format `projects/*/secrets/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSecretRequest) Reset()         { *m = GetSecretRequest{} }
func (m *GetSecretRequest) String() string { return proto.CompactTextString(m) }
func (*GetSecretRequest) ProtoMessage()    {}
func (*GetSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{4}
}

func (m *GetSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSecretRequest.Unmarshal(m, b)
}
func (m *GetSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSecretRequest.Marshal(b, m, deterministic)
}
func (m *GetSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSecretRequest.Merge(m, src)
}
func (m *GetSecretRequest) XXX_Size() int {
	return xxx_messageInfo_GetSecretRequest.Size(m)
}
func (m *GetSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSecretRequest proto.InternalMessageInfo

func (m *GetSecretRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.ListSecretVersions][google.cloud.secretmanager.v1.SecretManagerService.ListSecretVersions].
type ListSecretVersionsRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret] associated with the
	// [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] to list, in the format
	// `projects/*/secrets/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to be returned in a single page. If
	// set to 0, the server decides the number of results to return. If the
	// number is greater than 25000, it is capped at 25000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token, returned earlier via
	// ListSecretVersionsResponse.next_page_token][].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretVersionsRequest) Reset()         { *m = ListSecretVersionsRequest{} }
func (m *ListSecretVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSecretVersionsRequest) ProtoMessage()    {}
func (*ListSecretVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{5}
}

func (m *ListSecretVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretVersionsRequest.Unmarshal(m, b)
}
func (m *ListSecretVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretVersionsRequest.Marshal(b, m, deterministic)
}
func (m *ListSecretVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretVersionsRequest.Merge(m, src)
}
func (m *ListSecretVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSecretVersionsRequest.Size(m)
}
func (m *ListSecretVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretVersionsRequest proto.InternalMessageInfo

func (m *ListSecretVersionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSecretVersionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSecretVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [SecretManagerService.ListSecretVersions][google.cloud.secretmanager.v1.SecretManagerService.ListSecretVersions].
type ListSecretVersionsResponse struct {
	// The list of [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] sorted in reverse by
	// create_time (newest first).
	Versions []*SecretVersion `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
	// A token to retrieve the next page of results. Pass this value in
	// [ListSecretVersionsRequest.page_token][google.cloud.secretmanager.v1.ListSecretVersionsRequest.page_token] to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSecretVersionsResponse) Reset()         { *m = ListSecretVersionsResponse{} }
func (m *ListSecretVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSecretVersionsResponse) ProtoMessage()    {}
func (*ListSecretVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{6}
}

func (m *ListSecretVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSecretVersionsResponse.Unmarshal(m, b)
}
func (m *ListSecretVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSecretVersionsResponse.Marshal(b, m, deterministic)
}
func (m *ListSecretVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecretVersionsResponse.Merge(m, src)
}
func (m *ListSecretVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSecretVersionsResponse.Size(m)
}
func (m *ListSecretVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecretVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecretVersionsResponse proto.InternalMessageInfo

func (m *ListSecretVersionsResponse) GetVersions() []*SecretVersion {
	if m != nil {
		return m.Versions
	}
	return nil
}

func (m *ListSecretVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListSecretVersionsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for [SecretManagerService.GetSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.GetSecretVersion].
type GetSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the format
	// `projects/*/secrets/*/versions/*`.
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSecretVersionRequest) Reset()         { *m = GetSecretVersionRequest{} }
func (m *GetSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetSecretVersionRequest) ProtoMessage()    {}
func (*GetSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{7}
}

func (m *GetSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSecretVersionRequest.Unmarshal(m, b)
}
func (m *GetSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *GetSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSecretVersionRequest.Merge(m, src)
}
func (m *GetSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetSecretVersionRequest.Size(m)
}
func (m *GetSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSecretVersionRequest proto.InternalMessageInfo

func (m *GetSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.UpdateSecret][google.cloud.secretmanager.v1.SecretManagerService.UpdateSecret].
type UpdateSecretRequest struct {
	// Required. [Secret][google.cloud.secretmanager.v1.Secret] with updated field values.
	Secret *Secret `protobuf:"bytes,1,opt,name=secret,proto3" json:"secret,omitempty"`
	// Required. Specifies the fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSecretRequest) Reset()         { *m = UpdateSecretRequest{} }
func (m *UpdateSecretRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSecretRequest) ProtoMessage()    {}
func (*UpdateSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{8}
}

func (m *UpdateSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSecretRequest.Unmarshal(m, b)
}
func (m *UpdateSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSecretRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSecretRequest.Merge(m, src)
}
func (m *UpdateSecretRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSecretRequest.Size(m)
}
func (m *UpdateSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSecretRequest proto.InternalMessageInfo

func (m *UpdateSecretRequest) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *UpdateSecretRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [SecretManagerService.AccessSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.AccessSecretVersion].
type AccessSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccessSecretVersionRequest) Reset()         { *m = AccessSecretVersionRequest{} }
func (m *AccessSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*AccessSecretVersionRequest) ProtoMessage()    {}
func (*AccessSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{9}
}

func (m *AccessSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessSecretVersionRequest.Unmarshal(m, b)
}
func (m *AccessSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *AccessSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessSecretVersionRequest.Merge(m, src)
}
func (m *AccessSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_AccessSecretVersionRequest.Size(m)
}
func (m *AccessSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AccessSecretVersionRequest proto.InternalMessageInfo

func (m *AccessSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for [SecretManagerService.AccessSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.AccessSecretVersion].
type AccessSecretVersionResponse struct {
	// The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the format
	// `projects/*/secrets/*/versions/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Secret payload
	Payload              *SecretPayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AccessSecretVersionResponse) Reset()         { *m = AccessSecretVersionResponse{} }
func (m *AccessSecretVersionResponse) String() string { return proto.CompactTextString(m) }
func (*AccessSecretVersionResponse) ProtoMessage()    {}
func (*AccessSecretVersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{10}
}

func (m *AccessSecretVersionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessSecretVersionResponse.Unmarshal(m, b)
}
func (m *AccessSecretVersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessSecretVersionResponse.Marshal(b, m, deterministic)
}
func (m *AccessSecretVersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessSecretVersionResponse.Merge(m, src)
}
func (m *AccessSecretVersionResponse) XXX_Size() int {
	return xxx_messageInfo_AccessSecretVersionResponse.Size(m)
}
func (m *AccessSecretVersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessSecretVersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AccessSecretVersionResponse proto.InternalMessageInfo

func (m *AccessSecretVersionResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AccessSecretVersionResponse) GetPayload() *SecretPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Request message for [SecretManagerService.DeleteSecret][google.cloud.secretmanager.v1.SecretManagerService.DeleteSecret].
type DeleteSecretRequest struct {
	// Required. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret] to delete in the format
	// `projects/*/secrets/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSecretRequest) Reset()         { *m = DeleteSecretRequest{} }
func (m *DeleteSecretRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSecretRequest) ProtoMessage()    {}
func (*DeleteSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{11}
}

func (m *DeleteSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSecretRequest.Unmarshal(m, b)
}
func (m *DeleteSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSecretRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSecretRequest.Merge(m, src)
}
func (m *DeleteSecretRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSecretRequest.Size(m)
}
func (m *DeleteSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSecretRequest proto.InternalMessageInfo

func (m *DeleteSecretRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.DisableSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.DisableSecretVersion].
type DisableSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to disable in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisableSecretVersionRequest) Reset()         { *m = DisableSecretVersionRequest{} }
func (m *DisableSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DisableSecretVersionRequest) ProtoMessage()    {}
func (*DisableSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{12}
}

func (m *DisableSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisableSecretVersionRequest.Unmarshal(m, b)
}
func (m *DisableSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisableSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *DisableSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisableSecretVersionRequest.Merge(m, src)
}
func (m *DisableSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DisableSecretVersionRequest.Size(m)
}
func (m *DisableSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DisableSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DisableSecretVersionRequest proto.InternalMessageInfo

func (m *DisableSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.EnableSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.EnableSecretVersion].
type EnableSecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to enable in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnableSecretVersionRequest) Reset()         { *m = EnableSecretVersionRequest{} }
func (m *EnableSecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*EnableSecretVersionRequest) ProtoMessage()    {}
func (*EnableSecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{13}
}

func (m *EnableSecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableSecretVersionRequest.Unmarshal(m, b)
}
func (m *EnableSecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableSecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *EnableSecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableSecretVersionRequest.Merge(m, src)
}
func (m *EnableSecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_EnableSecretVersionRequest.Size(m)
}
func (m *EnableSecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableSecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EnableSecretVersionRequest proto.InternalMessageInfo

func (m *EnableSecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [SecretManagerService.DestroySecretVersion][google.cloud.secretmanager.v1.SecretManagerService.DestroySecretVersion].
type DestroySecretVersionRequest struct {
	// Required. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to destroy in the format
	// `projects/*/secrets/*/versions/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestroySecretVersionRequest) Reset()         { *m = DestroySecretVersionRequest{} }
func (m *DestroySecretVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DestroySecretVersionRequest) ProtoMessage()    {}
func (*DestroySecretVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f5c4f6b657846b5, []int{14}
}

func (m *DestroySecretVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DestroySecretVersionRequest.Unmarshal(m, b)
}
func (m *DestroySecretVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DestroySecretVersionRequest.Marshal(b, m, deterministic)
}
func (m *DestroySecretVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroySecretVersionRequest.Merge(m, src)
}
func (m *DestroySecretVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DestroySecretVersionRequest.Size(m)
}
func (m *DestroySecretVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroySecretVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DestroySecretVersionRequest proto.InternalMessageInfo

func (m *DestroySecretVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*ListSecretsRequest)(nil), "google.cloud.secretmanager.v1.ListSecretsRequest")
	proto.RegisterType((*ListSecretsResponse)(nil), "google.cloud.secretmanager.v1.ListSecretsResponse")
	proto.RegisterType((*CreateSecretRequest)(nil), "google.cloud.secretmanager.v1.CreateSecretRequest")
	proto.RegisterType((*AddSecretVersionRequest)(nil), "google.cloud.secretmanager.v1.AddSecretVersionRequest")
	proto.RegisterType((*GetSecretRequest)(nil), "google.cloud.secretmanager.v1.GetSecretRequest")
	proto.RegisterType((*ListSecretVersionsRequest)(nil), "google.cloud.secretmanager.v1.ListSecretVersionsRequest")
	proto.RegisterType((*ListSecretVersionsResponse)(nil), "google.cloud.secretmanager.v1.ListSecretVersionsResponse")
	proto.RegisterType((*GetSecretVersionRequest)(nil), "google.cloud.secretmanager.v1.GetSecretVersionRequest")
	proto.RegisterType((*UpdateSecretRequest)(nil), "google.cloud.secretmanager.v1.UpdateSecretRequest")
	proto.RegisterType((*AccessSecretVersionRequest)(nil), "google.cloud.secretmanager.v1.AccessSecretVersionRequest")
	proto.RegisterType((*AccessSecretVersionResponse)(nil), "google.cloud.secretmanager.v1.AccessSecretVersionResponse")
	proto.RegisterType((*DeleteSecretRequest)(nil), "google.cloud.secretmanager.v1.DeleteSecretRequest")
	proto.RegisterType((*DisableSecretVersionRequest)(nil), "google.cloud.secretmanager.v1.DisableSecretVersionRequest")
	proto.RegisterType((*EnableSecretVersionRequest)(nil), "google.cloud.secretmanager.v1.EnableSecretVersionRequest")
	proto.RegisterType((*DestroySecretVersionRequest)(nil), "google.cloud.secretmanager.v1.DestroySecretVersionRequest")
}

func init() {
	proto.RegisterFile("google/cloud/secretmanager/v1/service.proto", fileDescriptor_3f5c4f6b657846b5)
}

var fileDescriptor_3f5c4f6b657846b5 = []byte{
	// 1352 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcd, 0x6f, 0x14, 0xe5,
	0x1f, 0xcf, 0xb3, 0xfd, 0xf1, 0xd2, 0xa7, 0xfb, 0x53, 0xf2, 0x2c, 0xd8, 0x32, 0x80, 0x2c, 0x63,
	0x20, 0x65, 0x59, 0x66, 0xd8, 0x25, 0x22, 0x4c, 0x63, 0x60, 0x5a, 0xa0, 0x20, 0x92, 0x6c, 0x76,
	0xb1, 0x07, 0x43, 0xd2, 0x3c, 0xdd, 0x79, 0x58, 0x46, 0x76, 0x5e, 0x9c, 0x67, 0xb6, 0xb5, 0x18,
	0x2e, 0x9a, 0x78, 0xf0, 0xca, 0xd1, 0x78, 0xf1, 0x80, 0x09, 0xea, 0x49, 0xe3, 0x1f, 0xa0, 0x89,
	0x31, 0x1c, 0x34, 0xd1, 0x5b, 0x4f, 0x1c, 0x3c, 0xe9, 0x3f, 0x60, 0x3c, 0x99, 0x79, 0x5e, 0xb6,
	0x33, 0xd3, 0xdd, 0x9d, 0xd9, 0xd2, 0x7a, 0x6b, 0x9f, 0xef, 0xdb, 0xe7, 0xfb, 0xfe, 0xdd, 0x81,
	0x67, 0x3a, 0x9e, 0xd7, 0xe9, 0x12, 0xbd, 0xdd, 0xf5, 0x7a, 0x96, 0x4e, 0x49, 0x3b, 0x20, 0xa1,
	0x83, 0x5d, 0xdc, 0x21, 0x81, 0xbe, 0x5a, 0xd3, 0x29, 0x09, 0x56, 0xed, 0x36, 0xd1, 0xfc, 0xc0,
	0x0b, 0x3d, 0x74, 0x8c, 0x33, 0x6b, 0x8c, 0x59, 0x4b, 0x30, 0x6b, 0xab, 0x35, 0xe5, 0xa8, 0xd0,
	0x85, 0x7d, 0x5b, 0xc7, 0xae, 0xeb, 0x85, 0x38, 0xb4, 0x3d, 0x97, 0x72, 0x61, 0x65, 0x3a, 0x46,
	0x6d, 0x77, 0x6d, 0xe2, 0x86, 0x82, 0x70, 0x3c, 0x46, 0xb8, 0x67, 0x93, 0xae, 0xb5, 0xbc, 0x42,
	0xee, 0xe3, 0x55, 0xdb, 0x0b, 0x04, 0xc3, 0xe1, 0x18, 0x43, 0x40, 0xa8, 0xd7, 0x0b, 0x24, 0x22,
	0xe5, 0xec, 0x68, 0xf8, 0x92, 0x5b, 0x62, 0x78, 0x55, 0xb0, 0xdb, 0xd8, 0x89, 0xc8, 0x36, 0x76,
	0x96, 0x7d, 0xaf, 0x6b, 0xb7, 0xd7, 0x05, 0x5d, 0x49, 0xd2, 0x13, 0xb4, 0x23, 0x82, 0xc6, 0xfe,
	0x5b, 0xe9, 0xdd, 0xd3, 0x89, 0xe3, 0x87, 0x92, 0x58, 0x4e, 0x13, 0xb9, 0x23, 0x0e, 0xa6, 0x0f,
	0x38, 0x87, 0xfa, 0x25, 0x80, 0xe8, 0x6d, 0x9b, 0x86, 0x2d, 0x86, 0x91, 0x36, 0xc9, 0xfb, 0x3d,
	0x42, 0x43, 0x74, 0x0b, 0xee, 0xf5, 0x71, 0x40, 0xdc, 0x70, 0x06, 0x94, 0xc1, 0xec, 0xe4, 0xfc,
	0xf9, 0xe7, 0x66, 0xe1, 0x1f, 0xf3, 0x2c, 0x3c, 0xc3, 0x3c, 0x92, 0xf8, 0x65, 0x90, 0xb9, 0x15,
	0xec, 0xdb, 0x54, 0x6b, 0x7b, 0x8e, 0xde, 0x08, 0xbc, 0xf7, 0x48, 0x3b, 0x6c, 0x0a, 0x15, 0xa8,
	0x0c, 0x27, 0x7d, 0xdc, 0x21, 0xcb, 0xd4, 0x7e, 0x48, 0x66, 0x0a, 0x65, 0x30, 0xbb, 0x67, 0x7e,
	0xe2, 0xb9, 0x09, 0x9a, 0xfb, 0xa3, 0xd7, 0x96, 0xfd, 0x90, 0x20, 0x15, 0x42, 0xc6, 0x11, 0x7a,
	0x0f, 0x88, 0x3b, 0x33, 0xc1, 0x4c, 0x32, 0x16, 0x26, 0x78, 0x27, 0x7a, 0x55, 0x3f, 0x07, 0xb0,
	0x94, 0x40, 0x4a, 0x7d, 0xcf, 0xa5, 0x04, 0x5d, 0x86, 0xfb, 0x78, 0x80, 0xe9, 0x0c, 0x28, 0x4f,
	0xcc, 0x4e, 0xd5, 0x4f, 0x6a, 0x23, 0xeb, 0x41, 0xe3, 0x0a, 0x9a, 0x52, 0x0a, 0x9d, 0x82, 0x2f,
	0xbb, 0xe4, 0x83, 0x70, 0x39, 0x86, 0x20, 0x02, 0x39, 0xd9, 0xfc, 0x7f, 0xf4, 0xdc, 0x90, 0x00,
	0xd0, 0x31, 0x08, 0x43, 0x2f, 0xc4, 0x5d, 0xee, 0x47, 0x04, 0x72, 0x4f, 0x73, 0x92, 0xbd, 0x44,
	0x3e, 0xa8, 0x3f, 0x03, 0x58, 0x5a, 0x08, 0x08, 0x0e, 0x89, 0x30, 0xb0, 0x4b, 0xa1, 0xe4, 0xb0,
	0x97, 0x6d, 0x8b, 0xa3, 0x8c, 0xe2, 0x54, 0x68, 0xee, 0xe7, 0xaf, 0x37, 0x2d, 0x34, 0x0f, 0xf7,
	0xf2, 0xbf, 0x19, 0xc2, 0xbc, 0xd1, 0xe0, 0x5a, 0x84, 0xa4, 0xfa, 0x15, 0x80, 0xd3, 0xa6, 0x65,
	0x71, 0xd2, 0x12, 0x09, 0xa8, 0xed, 0xb9, 0xd2, 0x9d, 0x85, 0x94, 0x3b, 0x67, 0x98, 0x3b, 0x27,
	0xe1, 0x6b, 0x49, 0xcd, 0x29, 0x3f, 0x44, 0x48, 0xa4, 0x1b, 0xb7, 0xe0, 0x3e, 0x1f, 0xaf, 0x77,
	0x3d, 0xcc, 0x9d, 0x98, 0xaa, 0x57, 0x73, 0xa1, 0x6c, 0x70, 0x19, 0x0e, 0x56, 0x6a, 0x50, 0x5b,
	0xf0, 0xc0, 0x22, 0x09, 0x93, 0x41, 0xbf, 0x0c, 0xff, 0xe7, 0x62, 0x87, 0x6c, 0x07, 0x23, 0x13,
	0x54, 0x9f, 0x00, 0x78, 0x78, 0xb3, 0xda, 0x44, 0x0c, 0xe8, 0x8e, 0x06, 0x61, 0x67, 0xda, 0xe2,
	0x1b, 0x00, 0x95, 0x41, 0x40, 0x45, 0x77, 0xdc, 0x80, 0xfb, 0x57, 0xc5, 0x9b, 0x68, 0x8f, 0x7c,
	0xa1, 0x96, 0x59, 0xef, 0x4b, 0xef, 0x54, 0x9b, 0x60, 0x38, 0xdd, 0xcf, 0x56, 0xaa, 0xb4, 0xae,
	0x27, 0x92, 0x56, 0x67, 0x31, 0xad, 0xc2, 0x4a, 0x8e, 0x98, 0x4a, 0x45, 0x3c, 0x77, 0x9f, 0x01,
	0x58, 0x7a, 0xc7, 0xb7, 0xb6, 0x74, 0xe2, 0x66, 0x6b, 0x80, 0xed, 0xb6, 0x06, 0xba, 0x02, 0xa7,
	0x7a, 0x4c, 0x35, 0x1b, 0xa2, 0xa2, 0x7a, 0x15, 0xa9, 0x48, 0xce, 0x59, 0xed, 0x7a, 0x34, 0x67,
	0x6f, 0x63, 0xfa, 0x80, 0x4b, 0x43, 0x2e, 0x13, 0x3d, 0xa8, 0x16, 0x54, 0xcc, 0x76, 0x9b, 0x50,
	0xba, 0xab, 0x31, 0x78, 0x0a, 0xe0, 0x91, 0x81, 0x66, 0x44, 0x5d, 0x2c, 0x24, 0xec, 0xe8, 0xdb,
	0x32, 0x82, 0xae, 0xbf, 0x50, 0x1b, 0x6f, 0x76, 0xf0, 0x12, 0x2c, 0x5d, 0x25, 0x5d, 0x92, 0xce,
	0xd7, 0x0b, 0x37, 0x31, 0x81, 0x47, 0xae, 0xda, 0x14, 0xaf, 0x74, 0xc9, 0xae, 0xc6, 0xda, 0x82,
	0xca, 0x35, 0x77, 0xd7, 0xad, 0x44, 0xce, 0x10, 0x1a, 0x06, 0xde, 0xfa, 0x6e, 0x9a, 0xa9, 0xff,
	0x7a, 0x08, 0x1e, 0xe4, 0xef, 0xb7, 0xb9, 0x50, 0x8b, 0xdf, 0x5a, 0xe8, 0x09, 0x80, 0x53, 0xb1,
	0xfd, 0x8b, 0x6a, 0x19, 0xb9, 0xde, 0x7a, 0x55, 0x28, 0xf5, 0x71, 0x44, 0x78, 0xa1, 0xaa, 0xe7,
	0x36, 0x4c, 0x31, 0x30, 0x3f, 0xfa, 0xfd, 0x8f, 0xc7, 0x85, 0x13, 0xe8, 0x78, 0x74, 0x02, 0x7d,
	0xc8, 0x9f, 0xde, 0xf4, 0xf9, 0x7e, 0xa4, 0x7a, 0xe5, 0x91, 0x2e, 0xf7, 0xf9, 0x77, 0x00, 0x16,
	0xe3, 0x8b, 0x18, 0x65, 0x99, 0x1d, 0xb0, 0xb5, 0x95, 0x7c, 0xb3, 0x41, 0xbd, 0xb9, 0x61, 0x4e,
	0x73, 0x28, 0xd5, 0xfe, 0x5e, 0x16, 0x7f, 0x31, 0xb8, 0xa7, 0xd5, 0x2c, 0xb8, 0x86, 0x9c, 0x2c,
	0x3f, 0x00, 0x78, 0x20, 0xbd, 0x74, 0xd1, 0x85, 0x0c, 0x18, 0x43, 0xb6, 0xb4, 0x32, 0xd6, 0x90,
	0x57, 0x6f, 0x6c, 0x98, 0x2f, 0x09, 0x2f, 0x44, 0x4b, 0x32, 0xf0, 0x35, 0xb5, 0x3a, 0x18, 0xbc,
	0xc4, 0xae, 0x57, 0x1e, 0x19, 0xd8, 0xb2, 0x84, 0x1a, 0x03, 0x54, 0xd0, 0x63, 0x00, 0x27, 0xfb,
	0xe3, 0x1d, 0xe9, 0x19, 0x28, 0xd2, 0x6b, 0x3b, 0x6f, 0xd4, 0xb5, 0x0d, 0x93, 0x15, 0x6b, 0xa2,
	0x22, 0xa2, 0x87, 0xc1, 0x18, 0xd1, 0xf7, 0x00, 0x16, 0xe3, 0x0b, 0x21, 0xb3, 0x22, 0x06, 0x6c,
	0x8f, 0xbc, 0xd8, 0x6e, 0x6d, 0x98, 0x88, 0xd3, 0xaa, 0xb1, 0x45, 0xc1, 0x90, 0x9e, 0xab, 0x9f,
	0x62, 0x48, 0x39, 0x59, 0x1b, 0x0e, 0xb8, 0x5f, 0x13, 0x9f, 0x02, 0x58, 0x8c, 0x4f, 0xc6, 0x4c,
	0xe0, 0x03, 0xc6, 0xa8, 0xf2, 0xca, 0x96, 0xed, 0x74, 0x2d, 0xfa, 0x89, 0x90, 0x8a, 0x62, 0x25,
	0x33, 0x8a, 0x3f, 0x25, 0x7e, 0x2a, 0xc8, 0x4b, 0x03, 0x5d, 0xcc, 0xdd, 0xd4, 0xa9, 0x2b, 0x4a,
	0xb9, 0xb4, 0x0d, 0x49, 0x31, 0x15, 0xe6, 0x92, 0x53, 0xa1, 0x8a, 0x2a, 0x99, 0x95, 0xaa, 0xf7,
	0x2f, 0x99, 0x6f, 0x41, 0xec, 0x62, 0xcc, 0xdb, 0x69, 0x43, 0x8e, 0x96, 0x31, 0x3b, 0xed, 0x52,
	0x3c, 0xe6, 0x12, 0xf5, 0xd0, 0x98, 0xf7, 0x21, 0x47, 0xe1, 0xff, 0x05, 0xc0, 0xd2, 0x80, 0x8d,
	0x8e, 0xb2, 0xa2, 0x38, 0xfc, 0xd8, 0x50, 0x8c, 0xed, 0x88, 0x8a, 0x0c, 0x5c, 0x89, 0x7b, 0x72,
	0x1e, 0xd5, 0xf2, 0x7b, 0x62, 0x60, 0xa6, 0x36, 0xaa, 0xa7, 0x83, 0x83, 0xd6, 0x33, 0xca, 0x82,
	0x35, 0x62, 0xa7, 0x8f, 0x99, 0x8e, 0xab, 0x71, 0x27, 0xde, 0x50, 0xeb, 0x63, 0x38, 0x61, 0x71,
	0x10, 0xd1, 0xd0, 0xfb, 0x11, 0xc0, 0xd2, 0x80, 0x03, 0x20, 0x33, 0x33, 0xc3, 0x8f, 0x86, 0x31,
	0xdd, 0x58, 0x88, 0xbb, 0x71, 0x41, 0x1d, 0x27, 0x17, 0xc4, 0x95, 0x5e, 0xb0, 0x74, 0x0c, 0x38,
	0x30, 0xb2, 0xd3, 0x31, 0xfc, 0x2a, 0xf9, 0x0f, 0xd3, 0xc1, 0x41, 0x44, 0x8e, 0x7c, 0x02, 0x60,
	0xb1, 0x45, 0xc2, 0x9b, 0xd8, 0x69, 0xb0, 0x0f, 0x25, 0x48, 0x95, 0x20, 0x6c, 0xec, 0x70, 0xa3,
	0x9b, 0x44, 0x09, 0xf4, 0x50, 0x8a, 0x87, 0x53, 0xd5, 0x39, 0x06, 0xe5, 0x75, 0xf5, 0x1c, 0x83,
	0x22, 0x7f, 0xac, 0x0f, 0x99, 0xda, 0x34, 0xa6, 0x37, 0x02, 0xf2, 0x31, 0x80, 0xc5, 0xc5, 0x51,
	0x40, 0x16, 0xf3, 0x03, 0xb9, 0xc8, 0x80, 0xd4, 0x51, 0x2e, 0x20, 0x9d, 0xb8, 0xd1, 0xaf, 0x01,
	0x44, 0x77, 0x08, 0x65, 0x2f, 0x24, 0x70, 0x6c, 0xca, 0x87, 0xe0, 0x6c, 0xca, 0xce, 0x56, 0x16,
	0x89, 0xe8, 0x74, 0x0e, 0x4e, 0x31, 0x14, 0x4c, 0x86, 0x72, 0x4e, 0xbd, 0x90, 0x07, 0x65, 0xb8,
	0x45, 0x8f, 0x01, 0x2a, 0x4a, 0xe3, 0x99, 0x79, 0x74, 0xd4, 0xd1, 0xfa, 0x9b, 0xa9, 0xdd, 0x0f,
	0x43, 0x9f, 0x1a, 0xba, 0xbe, 0xb6, 0xb6, 0x96, 0xbe, 0x68, 0x71, 0x2f, 0xbc, 0xcf, 0xbf, 0xba,
	0x9d, 0xf5, 0xbb, 0x38, 0xbc, 0xe7, 0x05, 0xce, 0xfc, 0x5f, 0x00, 0x9e, 0x68, 0x7b, 0xce, 0xe8,
	0x4a, 0x9c, 0x2f, 0x8a, 0x3b, 0xb7, 0x11, 0x2d, 0xc9, 0x06, 0x78, 0xf7, 0x2d, 0xc1, 0xde, 0xf1,
	0xba, 0xd8, 0xed, 0x68, 0x5e, 0xd0, 0xd1, 0x3b, 0xc4, 0x65, 0x2b, 0x54, 0xdf, 0x34, 0x3a, 0xe4,
	0x0b, 0xdf, 0x5c, 0xe2, 0xe1, 0x6f, 0x00, 0xbe, 0x28, 0x4c, 0x2c, 0xb6, 0x6e, 0x3f, 0x2d, 0x1c,
	0x5b, 0xe4, 0x5a, 0x17, 0x18, 0x88, 0xc4, 0x9d, 0xad, 0x2d, 0xd5, 0x9e, 0x49, 0xfa, 0x5d, 0x46,
	0xbf, 0x9b, 0xa0, 0xdf, 0x5d, 0xaa, 0xfd, 0x59, 0x28, 0x73, 0xba, 0x61, 0x30, 0x06, 0xc3, 0x48,
	0x70, 0x18, 0xc6, 0x52, 0x6d, 0x65, 0x2f, 0x83, 0x78, 0xfe, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x76, 0xf2, 0xc7, 0x28, 0x42, 0x15, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecretManagerServiceClient is the client API for SecretManagerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecretManagerServiceClient interface {
	// Lists [Secrets][google.cloud.secretmanager.v1.Secret].
	ListSecrets(ctx context.Context, in *ListSecretsRequest, opts ...grpc.CallOption) (*ListSecretsResponse, error)
	// Creates a new [Secret][google.cloud.secretmanager.v1.Secret] containing no [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
	CreateSecret(ctx context.Context, in *CreateSecretRequest, opts ...grpc.CallOption) (*Secret, error)
	// Creates a new [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] containing secret data and attaches
	// it to an existing [Secret][google.cloud.secretmanager.v1.Secret].
	AddSecretVersion(ctx context.Context, in *AddSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Gets metadata for a given [Secret][google.cloud.secretmanager.v1.Secret].
	GetSecret(ctx context.Context, in *GetSecretRequest, opts ...grpc.CallOption) (*Secret, error)
	// Updates metadata of an existing [Secret][google.cloud.secretmanager.v1.Secret].
	UpdateSecret(ctx context.Context, in *UpdateSecretRequest, opts ...grpc.CallOption) (*Secret, error)
	// Deletes a [Secret][google.cloud.secretmanager.v1.Secret].
	DeleteSecret(ctx context.Context, in *DeleteSecretRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists [SecretVersions][google.cloud.secretmanager.v1.SecretVersion]. This call does not return secret
	// data.
	ListSecretVersions(ctx context.Context, in *ListSecretVersionsRequest, opts ...grpc.CallOption) (*ListSecretVersionsResponse, error)
	// Gets metadata for a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	GetSecretVersion(ctx context.Context, in *GetSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Accesses a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. This call returns the secret data.
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	AccessSecretVersion(ctx context.Context, in *AccessSecretVersionRequest, opts ...grpc.CallOption) (*AccessSecretVersionResponse, error)
	// Disables a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// Sets the [state][google.cloud.secretmanager.v1.SecretVersion.state] of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to
	// [DISABLED][google.cloud.secretmanager.v1.SecretVersion.State.DISABLED].
	DisableSecretVersion(ctx context.Context, in *DisableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Enables a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// Sets the [state][google.cloud.secretmanager.v1.SecretVersion.state] of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to
	// [ENABLED][google.cloud.secretmanager.v1.SecretVersion.State.ENABLED].
	EnableSecretVersion(ctx context.Context, in *EnableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Destroys a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// Sets the [state][google.cloud.secretmanager.v1.SecretVersion.state] of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to
	// [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED] and irrevocably destroys the
	// secret data.
	DestroySecretVersion(ctx context.Context, in *DestroySecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error)
	// Sets the access control policy on the specified secret. Replaces any
	// existing policy.
	//
	// Permissions on [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] are enforced according
	// to the policy set on the associated [Secret][google.cloud.secretmanager.v1.Secret].
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a secret.
	// Returns empty policy if the secret exists and does not have a policy set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has for the specified secret.
	// If the secret does not exist, this call returns an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type secretManagerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSecretManagerServiceClient(cc grpc.ClientConnInterface) SecretManagerServiceClient {
	return &secretManagerServiceClient{cc}
}

func (c *secretManagerServiceClient) ListSecrets(ctx context.Context, in *ListSecretsRequest, opts ...grpc.CallOption) (*ListSecretsResponse, error) {
	out := new(ListSecretsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/ListSecrets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) CreateSecret(ctx context.Context, in *CreateSecretRequest, opts ...grpc.CallOption) (*Secret, error) {
	out := new(Secret)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/CreateSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) AddSecretVersion(ctx context.Context, in *AddSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/AddSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) GetSecret(ctx context.Context, in *GetSecretRequest, opts ...grpc.CallOption) (*Secret, error) {
	out := new(Secret)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/GetSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) UpdateSecret(ctx context.Context, in *UpdateSecretRequest, opts ...grpc.CallOption) (*Secret, error) {
	out := new(Secret)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/UpdateSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) DeleteSecret(ctx context.Context, in *DeleteSecretRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/DeleteSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) ListSecretVersions(ctx context.Context, in *ListSecretVersionsRequest, opts ...grpc.CallOption) (*ListSecretVersionsResponse, error) {
	out := new(ListSecretVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/ListSecretVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) GetSecretVersion(ctx context.Context, in *GetSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/GetSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) AccessSecretVersion(ctx context.Context, in *AccessSecretVersionRequest, opts ...grpc.CallOption) (*AccessSecretVersionResponse, error) {
	out := new(AccessSecretVersionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/AccessSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) DisableSecretVersion(ctx context.Context, in *DisableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/DisableSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) EnableSecretVersion(ctx context.Context, in *EnableSecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/EnableSecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) DestroySecretVersion(ctx context.Context, in *DestroySecretVersionRequest, opts ...grpc.CallOption) (*SecretVersion, error) {
	out := new(SecretVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/DestroySecretVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretManagerServiceClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.secretmanager.v1.SecretManagerService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecretManagerServiceServer is the server API for SecretManagerService service.
type SecretManagerServiceServer interface {
	// Lists [Secrets][google.cloud.secretmanager.v1.Secret].
	ListSecrets(context.Context, *ListSecretsRequest) (*ListSecretsResponse, error)
	// Creates a new [Secret][google.cloud.secretmanager.v1.Secret] containing no [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
	CreateSecret(context.Context, *CreateSecretRequest) (*Secret, error)
	// Creates a new [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] containing secret data and attaches
	// it to an existing [Secret][google.cloud.secretmanager.v1.Secret].
	AddSecretVersion(context.Context, *AddSecretVersionRequest) (*SecretVersion, error)
	// Gets metadata for a given [Secret][google.cloud.secretmanager.v1.Secret].
	GetSecret(context.Context, *GetSecretRequest) (*Secret, error)
	// Updates metadata of an existing [Secret][google.cloud.secretmanager.v1.Secret].
	UpdateSecret(context.Context, *UpdateSecretRequest) (*Secret, error)
	// Deletes a [Secret][google.cloud.secretmanager.v1.Secret].
	DeleteSecret(context.Context, *DeleteSecretRequest) (*empty.Empty, error)
	// Lists [SecretVersions][google.cloud.secretmanager.v1.SecretVersion]. This call does not return secret
	// data.
	ListSecretVersions(context.Context, *ListSecretVersionsRequest) (*ListSecretVersionsResponse, error)
	// Gets metadata for a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	GetSecretVersion(context.Context, *GetSecretVersionRequest) (*SecretVersion, error)
	// Accesses a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. This call returns the secret data.
	//
	// `projects/*/secrets/*/versions/latest` is an alias to the `latest`
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	AccessSecretVersion(context.Context, *AccessSecretVersionRequest) (*AccessSecretVersionResponse, error)
	// Disables a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// Sets the [state][google.cloud.secretmanager.v1.SecretVersion.state] of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to
	// [DISABLED][google.cloud.secretmanager.v1.SecretVersion.State.DISABLED].
	DisableSecretVersion(context.Context, *DisableSecretVersionRequest) (*SecretVersion, error)
	// Enables a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// Sets the [state][google.cloud.secretmanager.v1.SecretVersion.state] of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to
	// [ENABLED][google.cloud.secretmanager.v1.SecretVersion.State.ENABLED].
	EnableSecretVersion(context.Context, *EnableSecretVersionRequest) (*SecretVersion, error)
	// Destroys a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// Sets the [state][google.cloud.secretmanager.v1.SecretVersion.state] of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] to
	// [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED] and irrevocably destroys the
	// secret data.
	DestroySecretVersion(context.Context, *DestroySecretVersionRequest) (*SecretVersion, error)
	// Sets the access control policy on the specified secret. Replaces any
	// existing policy.
	//
	// Permissions on [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] are enforced according
	// to the policy set on the associated [Secret][google.cloud.secretmanager.v1.Secret].
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a secret.
	// Returns empty policy if the secret exists and does not have a policy set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has for the specified secret.
	// If the secret does not exist, this call returns an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedSecretManagerServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSecretManagerServiceServer struct {
}

func (*UnimplementedSecretManagerServiceServer) ListSecrets(ctx context.Context, req *ListSecretsRequest) (*ListSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSecrets not implemented")
}
func (*UnimplementedSecretManagerServiceServer) CreateSecret(ctx context.Context, req *CreateSecretRequest) (*Secret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) AddSecretVersion(ctx context.Context, req *AddSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) GetSecret(ctx context.Context, req *GetSecretRequest) (*Secret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) UpdateSecret(ctx context.Context, req *UpdateSecretRequest) (*Secret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) DeleteSecret(ctx context.Context, req *DeleteSecretRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSecret not implemented")
}
func (*UnimplementedSecretManagerServiceServer) ListSecretVersions(ctx context.Context, req *ListSecretVersionsRequest) (*ListSecretVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSecretVersions not implemented")
}
func (*UnimplementedSecretManagerServiceServer) GetSecretVersion(ctx context.Context, req *GetSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) AccessSecretVersion(ctx context.Context, req *AccessSecretVersionRequest) (*AccessSecretVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AccessSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) DisableSecretVersion(ctx context.Context, req *DisableSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) EnableSecretVersion(ctx context.Context, req *EnableSecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableSecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) DestroySecretVersion(ctx context.Context, req *DestroySecretVersionRequest) (*SecretVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DestroySecretVersion not implemented")
}
func (*UnimplementedSecretManagerServiceServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedSecretManagerServiceServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedSecretManagerServiceServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterSecretManagerServiceServer(s *grpc.Server, srv SecretManagerServiceServer) {
	s.RegisterService(&_SecretManagerService_serviceDesc, srv)
}

func _SecretManagerService_ListSecrets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).ListSecrets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/ListSecrets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).ListSecrets(ctx, req.(*ListSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_CreateSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).CreateSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/CreateSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).CreateSecret(ctx, req.(*CreateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_AddSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).AddSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/AddSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).AddSecretVersion(ctx, req.(*AddSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_GetSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).GetSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/GetSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).GetSecret(ctx, req.(*GetSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_UpdateSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).UpdateSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/UpdateSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).UpdateSecret(ctx, req.(*UpdateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_DeleteSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).DeleteSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/DeleteSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).DeleteSecret(ctx, req.(*DeleteSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_ListSecretVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecretVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).ListSecretVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/ListSecretVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).ListSecretVersions(ctx, req.(*ListSecretVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_GetSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).GetSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/GetSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).GetSecretVersion(ctx, req.(*GetSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_AccessSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccessSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).AccessSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/AccessSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).AccessSecretVersion(ctx, req.(*AccessSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_DisableSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).DisableSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/DisableSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).DisableSecretVersion(ctx, req.(*DisableSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_EnableSecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableSecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).EnableSecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/EnableSecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).EnableSecretVersion(ctx, req.(*EnableSecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_DestroySecretVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroySecretVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).DestroySecretVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/DestroySecretVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).DestroySecretVersion(ctx, req.(*DestroySecretVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretManagerService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretManagerServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.secretmanager.v1.SecretManagerService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretManagerServiceServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecretManagerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.secretmanager.v1.SecretManagerService",
	HandlerType: (*SecretManagerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSecrets",
			Handler:    _SecretManagerService_ListSecrets_Handler,
		},
		{
			MethodName: "CreateSecret",
			Handler:    _SecretManagerService_CreateSecret_Handler,
		},
		{
			MethodName: "AddSecretVersion",
			Handler:    _SecretManagerService_AddSecretVersion_Handler,
		},
		{
			MethodName: "GetSecret",
			Handler:    _SecretManagerService_GetSecret_Handler,
		},
		{
			MethodName: "UpdateSecret",
			Handler:    _SecretManagerService_UpdateSecret_Handler,
		},
		{
			MethodName: "DeleteSecret",
			Handler:    _SecretManagerService_DeleteSecret_Handler,
		},
		{
			MethodName: "ListSecretVersions",
			Handler:    _SecretManagerService_ListSecretVersions_Handler,
		},
		{
			MethodName: "GetSecretVersion",
			Handler:    _SecretManagerService_GetSecretVersion_Handler,
		},
		{
			MethodName: "AccessSecretVersion",
			Handler:    _SecretManagerService_AccessSecretVersion_Handler,
		},
		{
			MethodName: "DisableSecretVersion",
			Handler:    _SecretManagerService_DisableSecretVersion_Handler,
		},
		{
			MethodName: "EnableSecretVersion",
			Handler:    _SecretManagerService_EnableSecretVersion_Handler,
		},
		{
			MethodName: "DestroySecretVersion",
			Handler:    _SecretManagerService_DestroySecretVersion_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecretManagerService_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecretManagerService_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecretManagerService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/secretmanager/v1/service.proto",
}
