/*
    This file is part of the KDE Baloo Project
    SPDX-FileCopyrightText: 2013-2015 Vishesh Handa <vhanda@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef BALOO_SEARCHSTORE_H
#define BALOO_SEARCHSTORE_H

#include <QString>
#include <QDateTime>
#include "term.h"

namespace Baloo {

class Term;
class Database;
class Transaction;
class EngineQuery;
class PostingIterator;

class SearchStore
{
public:
    SearchStore();
    ~SearchStore();

    QStringList exec(const Term& term, uint offset, int limit, bool sortResults);

private:
    Database* m_db;

    PostingIterator* constructQuery(Transaction* tr, const Term& term);

    EngineQuery constructContainsQuery(const QByteArray& prefix, const QString& value);
    EngineQuery constructEqualsQuery(const QByteArray& prefix, const QString& value);
    EngineQuery constructTypeQuery(const QString& type);
};

}

#endif // BALOO_SEARCHSTORE_H
