#pragma once

#include "icameraview.h"
#include "imousetoolevent.h"

namespace ui
{

// Special type for events generated by the camera view.
class CameraMouseToolEvent :
    public MouseToolEvent
{
    camera::ICameraView& _camView;

public:
    CameraMouseToolEvent(camera::ICameraView& camView, IInteractiveView& iView,
                         const Vector2& devicePos) :
        MouseToolEvent(iView, devicePos),
        _camView(camView)
    {}

    CameraMouseToolEvent(camera::ICameraView& camView, IInteractiveView& iView,
                         const Vector2& devicePos, const Vector2& delta) :
        MouseToolEvent(iView, devicePos, delta),
        _camView(camView)
    {}

    /// Return the ICameraView which generated this event
    camera::ICameraView& getView()
    {
        return _camView;
    }
};

}
