/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.math;
public class BigIntegerMathTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.math.testModule";
}
public void testBinomialOutside() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testBinomialOutside();
}

public void testBinomialSmall() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testBinomialSmall();
}

public void testCeilingPowerOfTwo() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testCeilingPowerOfTwo();
}

public void testCeilingPowerOfTwoNegative() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testCeilingPowerOfTwoNegative();
}

public void testCeilingPowerOfTwoZero() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testCeilingPowerOfTwoZero();
}

public void testFactorial() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testFactorial();
}

public void testFactorial0() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testFactorial0();
}

public void testFactorialNegative() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testFactorialNegative();
}

public void testFloorPowerOfTwo() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testFloorPowerOfTwo();
}

public void testFloorPowerOfTwoNegative() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testFloorPowerOfTwoNegative();
}

public void testFloorPowerOfTwoZero() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testFloorPowerOfTwoZero();
}

public void testIsPowerOfTwo() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testIsPowerOfTwo();
}

public void testLog2Ceiling() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2Ceiling();
}

public void testLog2Exact() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2Exact();
}

public void testLog2Floor() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2Floor();
}

public void testLog2HalfDown() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2HalfDown();
}

public void testLog2HalfEven() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2HalfEven();
}

public void testLog2HalfUp() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2HalfUp();
}

public void testLog2NegativeAlwaysThrows() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2NegativeAlwaysThrows();
}

public void testLog2ZeroAlwaysThrows() throws Exception {
  com.google.common.math.BigIntegerMathTest testCase = new com.google.common.math.BigIntegerMathTest();
  testCase.testLog2ZeroAlwaysThrows();
}
}
