/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _gc_9_1_OFFSET_HEADER
#define _gc_9_1_OFFSET_HEADER

#define mmSQ_DEBUG_STS_GLOBAL                                                                          0x0309
#define mmSQ_DEBUG_STS_GLOBAL_BASE_IDX                                                                 0
#define mmSQ_DEBUG_STS_GLOBAL2                                                                         0x0310
#define mmSQ_DEBUG_STS_GLOBAL2_BASE_IDX                                                                0
#define mmSQ_DEBUG_STS_GLOBAL3                                                                         0x0311
#define mmSQ_DEBUG_STS_GLOBAL3_BASE_IDX                                                                0

// addressBlock: gc_grbmdec
// base address: 0x8000
#define mmGRBM_CNTL                                                                                    0x0000
#define mmGRBM_CNTL_BASE_IDX                                                                           0
#define mmGRBM_SKEW_CNTL                                                                               0x0001
#define mmGRBM_SKEW_CNTL_BASE_IDX                                                                      0
#define mmGRBM_STATUS2                                                                                 0x0002
#define mmGRBM_STATUS2_BASE_IDX                                                                        0
#define mmGRBM_PWR_CNTL                                                                                0x0003
#define mmGRBM_PWR_CNTL_BASE_IDX                                                                       0
#define mmGRBM_STATUS                                                                                  0x0004
#define mmGRBM_STATUS_BASE_IDX                                                                         0
#define mmGRBM_STATUS_SE0                                                                              0x0005
#define mmGRBM_STATUS_SE0_BASE_IDX                                                                     0
#define mmGRBM_STATUS_SE1                                                                              0x0006
#define mmGRBM_STATUS_SE1_BASE_IDX                                                                     0
#define mmGRBM_SOFT_RESET                                                                              0x0008
#define mmGRBM_SOFT_RESET_BASE_IDX                                                                     0
#define mmGRBM_CGTT_CLK_CNTL                                                                           0x000b
#define mmGRBM_CGTT_CLK_CNTL_BASE_IDX                                                                  0
#define mmGRBM_GFX_CLKEN_CNTL                                                                          0x000c
#define mmGRBM_GFX_CLKEN_CNTL_BASE_IDX                                                                 0
#define mmGRBM_WAIT_IDLE_CLOCKS                                                                        0x000d
#define mmGRBM_WAIT_IDLE_CLOCKS_BASE_IDX                                                               0
#define mmGRBM_STATUS_SE2                                                                              0x000e
#define mmGRBM_STATUS_SE2_BASE_IDX                                                                     0
#define mmGRBM_STATUS_SE3                                                                              0x000f
#define mmGRBM_STATUS_SE3_BASE_IDX                                                                     0
#define mmGRBM_READ_ERROR                                                                              0x0016
#define mmGRBM_READ_ERROR_BASE_IDX                                                                     0
#define mmGRBM_READ_ERROR2                                                                             0x0017
#define mmGRBM_READ_ERROR2_BASE_IDX                                                                    0
#define mmGRBM_INT_CNTL                                                                                0x0018
#define mmGRBM_INT_CNTL_BASE_IDX                                                                       0
#define mmGRBM_TRAP_OP                                                                                 0x0019
#define mmGRBM_TRAP_OP_BASE_IDX                                                                        0
#define mmGRBM_TRAP_ADDR                                                                               0x001a
#define mmGRBM_TRAP_ADDR_BASE_IDX                                                                      0
#define mmGRBM_TRAP_ADDR_MSK                                                                           0x001b
#define mmGRBM_TRAP_ADDR_MSK_BASE_IDX                                                                  0
#define mmGRBM_TRAP_WD                                                                                 0x001c
#define mmGRBM_TRAP_WD_BASE_IDX                                                                        0
#define mmGRBM_TRAP_WD_MSK                                                                             0x001d
#define mmGRBM_TRAP_WD_MSK_BASE_IDX                                                                    0
#define mmGRBM_DSM_BYPASS                                                                              0x001e
#define mmGRBM_DSM_BYPASS_BASE_IDX                                                                     0
#define mmGRBM_WRITE_ERROR                                                                             0x001f
#define mmGRBM_WRITE_ERROR_BASE_IDX                                                                    0
#define mmGRBM_IOV_ERROR                                                                               0x0020
#define mmGRBM_IOV_ERROR_BASE_IDX                                                                      0
#define mmGRBM_CHIP_REVISION                                                                           0x0021
#define mmGRBM_CHIP_REVISION_BASE_IDX                                                                  0
#define mmGRBM_GFX_CNTL                                                                                0x0022
#define mmGRBM_GFX_CNTL_BASE_IDX                                                                       0
#define mmGRBM_RSMU_CFG                                                                                0x0023
#define mmGRBM_RSMU_CFG_BASE_IDX                                                                       0
#define mmGRBM_IH_CREDIT                                                                               0x0024
#define mmGRBM_IH_CREDIT_BASE_IDX                                                                      0
#define mmGRBM_PWR_CNTL2                                                                               0x0025
#define mmGRBM_PWR_CNTL2_BASE_IDX                                                                      0
#define mmGRBM_UTCL2_INVAL_RANGE_START                                                                 0x0026
#define mmGRBM_UTCL2_INVAL_RANGE_START_BASE_IDX                                                        0
#define mmGRBM_UTCL2_INVAL_RANGE_END                                                                   0x0027
#define mmGRBM_UTCL2_INVAL_RANGE_END_BASE_IDX                                                          0
#define mmGRBM_RSMU_READ_ERROR                                                                         0x0028
#define mmGRBM_RSMU_READ_ERROR_BASE_IDX                                                                0
#define mmGRBM_CHICKEN_BITS                                                                            0x0029
#define mmGRBM_CHICKEN_BITS_BASE_IDX                                                                   0
#define mmGRBM_NOWHERE                                                                                 0x003f
#define mmGRBM_NOWHERE_BASE_IDX                                                                        0
#define mmGRBM_SCRATCH_REG0                                                                            0x0040
#define mmGRBM_SCRATCH_REG0_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG1                                                                            0x0041
#define mmGRBM_SCRATCH_REG1_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG2                                                                            0x0042
#define mmGRBM_SCRATCH_REG2_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG3                                                                            0x0043
#define mmGRBM_SCRATCH_REG3_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG4                                                                            0x0044
#define mmGRBM_SCRATCH_REG4_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG5                                                                            0x0045
#define mmGRBM_SCRATCH_REG5_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG6                                                                            0x0046
#define mmGRBM_SCRATCH_REG6_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG7                                                                            0x0047
#define mmGRBM_SCRATCH_REG7_BASE_IDX                                                                   0


// addressBlock: gc_cpdec
// base address: 0x8200
#define mmCP_CPC_STATUS                                                                                0x0084
#define mmCP_CPC_STATUS_BASE_IDX                                                                       0
#define mmCP_CPC_BUSY_STAT                                                                             0x0085
#define mmCP_CPC_BUSY_STAT_BASE_IDX                                                                    0
#define mmCP_CPC_STALLED_STAT1                                                                         0x0086
#define mmCP_CPC_STALLED_STAT1_BASE_IDX                                                                0
#define mmCP_CPF_STATUS                                                                                0x0087
#define mmCP_CPF_STATUS_BASE_IDX                                                                       0
#define mmCP_CPF_BUSY_STAT                                                                             0x0088
#define mmCP_CPF_BUSY_STAT_BASE_IDX                                                                    0
#define mmCP_CPF_STALLED_STAT1                                                                         0x0089
#define mmCP_CPF_STALLED_STAT1_BASE_IDX                                                                0
#define mmCP_CPC_GRBM_FREE_COUNT                                                                       0x008b
#define mmCP_CPC_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define mmCP_MEC_CNTL                                                                                  0x008d
#define mmCP_MEC_CNTL_BASE_IDX                                                                         0
#define mmCP_MEC_ME1_HEADER_DUMP                                                                       0x008e
#define mmCP_MEC_ME1_HEADER_DUMP_BASE_IDX                                                              0
#define mmCP_MEC_ME2_HEADER_DUMP                                                                       0x008f
#define mmCP_MEC_ME2_HEADER_DUMP_BASE_IDX                                                              0
#define mmCP_CPC_SCRATCH_INDEX                                                                         0x0090
#define mmCP_CPC_SCRATCH_INDEX_BASE_IDX                                                                0
#define mmCP_CPC_SCRATCH_DATA                                                                          0x0091
#define mmCP_CPC_SCRATCH_DATA_BASE_IDX                                                                 0
#define mmCP_CPF_GRBM_FREE_COUNT                                                                       0x0092
#define mmCP_CPF_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define mmCP_CPC_HALT_HYST_COUNT                                                                       0x00a7
#define mmCP_CPC_HALT_HYST_COUNT_BASE_IDX                                                              0
#define mmCP_PRT_LOD_STATS_CNTL0                                                                       0x00ad
#define mmCP_PRT_LOD_STATS_CNTL0_BASE_IDX                                                              0
#define mmCP_PRT_LOD_STATS_CNTL1                                                                       0x00ae
#define mmCP_PRT_LOD_STATS_CNTL1_BASE_IDX                                                              0
#define mmCP_PRT_LOD_STATS_CNTL2                                                                       0x00af
#define mmCP_PRT_LOD_STATS_CNTL2_BASE_IDX                                                              0
#define mmCP_PRT_LOD_STATS_CNTL3                                                                       0x00b0
#define mmCP_PRT_LOD_STATS_CNTL3_BASE_IDX                                                              0
#define mmCP_CE_COMPARE_COUNT                                                                          0x00c0
#define mmCP_CE_COMPARE_COUNT_BASE_IDX                                                                 0
#define mmCP_CE_DE_COUNT                                                                               0x00c1
#define mmCP_CE_DE_COUNT_BASE_IDX                                                                      0
#define mmCP_DE_CE_COUNT                                                                               0x00c2
#define mmCP_DE_CE_COUNT_BASE_IDX                                                                      0
#define mmCP_DE_LAST_INVAL_COUNT                                                                       0x00c3
#define mmCP_DE_LAST_INVAL_COUNT_BASE_IDX                                                              0
#define mmCP_DE_DE_COUNT                                                                               0x00c4
#define mmCP_DE_DE_COUNT_BASE_IDX                                                                      0
#define mmCP_STALLED_STAT3                                                                             0x019c
#define mmCP_STALLED_STAT3_BASE_IDX                                                                    0
#define mmCP_STALLED_STAT1                                                                             0x019d
#define mmCP_STALLED_STAT1_BASE_IDX                                                                    0
#define mmCP_STALLED_STAT2                                                                             0x019e
#define mmCP_STALLED_STAT2_BASE_IDX                                                                    0
#define mmCP_BUSY_STAT                                                                                 0x019f
#define mmCP_BUSY_STAT_BASE_IDX                                                                        0
#define mmCP_STAT                                                                                      0x01a0
#define mmCP_STAT_BASE_IDX                                                                             0
#define mmCP_ME_HEADER_DUMP                                                                            0x01a1
#define mmCP_ME_HEADER_DUMP_BASE_IDX                                                                   0
#define mmCP_PFP_HEADER_DUMP                                                                           0x01a2
#define mmCP_PFP_HEADER_DUMP_BASE_IDX                                                                  0
#define mmCP_GRBM_FREE_COUNT                                                                           0x01a3
#define mmCP_GRBM_FREE_COUNT_BASE_IDX                                                                  0
#define mmCP_CE_HEADER_DUMP                                                                            0x01a4
#define mmCP_CE_HEADER_DUMP_BASE_IDX                                                                   0
#define mmCP_PFP_INSTR_PNTR                                                                            0x01a5
#define mmCP_PFP_INSTR_PNTR_BASE_IDX                                                                   0
#define mmCP_ME_INSTR_PNTR                                                                             0x01a6
#define mmCP_ME_INSTR_PNTR_BASE_IDX                                                                    0
#define mmCP_CE_INSTR_PNTR                                                                             0x01a7
#define mmCP_CE_INSTR_PNTR_BASE_IDX                                                                    0
#define mmCP_MEC1_INSTR_PNTR                                                                           0x01a8
#define mmCP_MEC1_INSTR_PNTR_BASE_IDX                                                                  0
#define mmCP_MEC2_INSTR_PNTR                                                                           0x01a9
#define mmCP_MEC2_INSTR_PNTR_BASE_IDX                                                                  0
#define mmCP_CSF_STAT                                                                                  0x01b4
#define mmCP_CSF_STAT_BASE_IDX                                                                         0
#define mmCP_ME_CNTL                                                                                   0x01b6
#define mmCP_ME_CNTL_BASE_IDX                                                                          0
#define mmCP_CNTX_STAT                                                                                 0x01b8
#define mmCP_CNTX_STAT_BASE_IDX                                                                        0
#define mmCP_ME_PREEMPTION                                                                             0x01b9
#define mmCP_ME_PREEMPTION_BASE_IDX                                                                    0
#define mmCP_ROQ_THRESHOLDS                                                                            0x01bc
#define mmCP_ROQ_THRESHOLDS_BASE_IDX                                                                   0
#define mmCP_MEQ_STQ_THRESHOLD                                                                         0x01bd
#define mmCP_MEQ_STQ_THRESHOLD_BASE_IDX                                                                0
#define mmCP_RB2_RPTR                                                                                  0x01be
#define mmCP_RB2_RPTR_BASE_IDX                                                                         0
#define mmCP_RB1_RPTR                                                                                  0x01bf
#define mmCP_RB1_RPTR_BASE_IDX                                                                         0
#define mmCP_RB0_RPTR                                                                                  0x01c0
#define mmCP_RB0_RPTR_BASE_IDX                                                                         0
#define mmCP_RB_RPTR                                                                                   0x01c0
#define mmCP_RB_RPTR_BASE_IDX                                                                          0
#define mmCP_RB_WPTR_DELAY                                                                             0x01c1
#define mmCP_RB_WPTR_DELAY_BASE_IDX                                                                    0
#define mmCP_RB_WPTR_POLL_CNTL                                                                         0x01c2
#define mmCP_RB_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define mmCP_ROQ1_THRESHOLDS                                                                           0x01d5
#define mmCP_ROQ1_THRESHOLDS_BASE_IDX                                                                  0
#define mmCP_ROQ2_THRESHOLDS                                                                           0x01d6
#define mmCP_ROQ2_THRESHOLDS_BASE_IDX                                                                  0
#define mmCP_STQ_THRESHOLDS                                                                            0x01d7
#define mmCP_STQ_THRESHOLDS_BASE_IDX                                                                   0
#define mmCP_QUEUE_THRESHOLDS                                                                          0x01d8
#define mmCP_QUEUE_THRESHOLDS_BASE_IDX                                                                 0
#define mmCP_MEQ_THRESHOLDS                                                                            0x01d9
#define mmCP_MEQ_THRESHOLDS_BASE_IDX                                                                   0
#define mmCP_ROQ_AVAIL                                                                                 0x01da
#define mmCP_ROQ_AVAIL_BASE_IDX                                                                        0
#define mmCP_STQ_AVAIL                                                                                 0x01db
#define mmCP_STQ_AVAIL_BASE_IDX                                                                        0
#define mmCP_ROQ2_AVAIL                                                                                0x01dc
#define mmCP_ROQ2_AVAIL_BASE_IDX                                                                       0
#define mmCP_MEQ_AVAIL                                                                                 0x01dd
#define mmCP_MEQ_AVAIL_BASE_IDX                                                                        0
#define mmCP_CMD_INDEX                                                                                 0x01de
#define mmCP_CMD_INDEX_BASE_IDX                                                                        0
#define mmCP_CMD_DATA                                                                                  0x01df
#define mmCP_CMD_DATA_BASE_IDX                                                                         0
#define mmCP_ROQ_RB_STAT                                                                               0x01e0
#define mmCP_ROQ_RB_STAT_BASE_IDX                                                                      0
#define mmCP_ROQ_IB1_STAT                                                                              0x01e1
#define mmCP_ROQ_IB1_STAT_BASE_IDX                                                                     0
#define mmCP_ROQ_IB2_STAT                                                                              0x01e2
#define mmCP_ROQ_IB2_STAT_BASE_IDX                                                                     0
#define mmCP_STQ_STAT                                                                                  0x01e3
#define mmCP_STQ_STAT_BASE_IDX                                                                         0
#define mmCP_STQ_WR_STAT                                                                               0x01e4
#define mmCP_STQ_WR_STAT_BASE_IDX                                                                      0
#define mmCP_MEQ_STAT                                                                                  0x01e5
#define mmCP_MEQ_STAT_BASE_IDX                                                                         0
#define mmCP_CEQ1_AVAIL                                                                                0x01e6
#define mmCP_CEQ1_AVAIL_BASE_IDX                                                                       0
#define mmCP_CEQ2_AVAIL                                                                                0x01e7
#define mmCP_CEQ2_AVAIL_BASE_IDX                                                                       0
#define mmCP_CE_ROQ_RB_STAT                                                                            0x01e8
#define mmCP_CE_ROQ_RB_STAT_BASE_IDX                                                                   0
#define mmCP_CE_ROQ_IB1_STAT                                                                           0x01e9
#define mmCP_CE_ROQ_IB1_STAT_BASE_IDX                                                                  0
#define mmCP_CE_ROQ_IB2_STAT                                                                           0x01ea
#define mmCP_CE_ROQ_IB2_STAT_BASE_IDX                                                                  0


// addressBlock: gc_padec
// base address: 0x8800
#define mmVGT_VTX_VECT_EJECT_REG                                                                       0x022c
#define mmVGT_VTX_VECT_EJECT_REG_BASE_IDX                                                              0
#define mmVGT_DMA_DATA_FIFO_DEPTH                                                                      0x022d
#define mmVGT_DMA_DATA_FIFO_DEPTH_BASE_IDX                                                             0
#define mmVGT_DMA_REQ_FIFO_DEPTH                                                                       0x022e
#define mmVGT_DMA_REQ_FIFO_DEPTH_BASE_IDX                                                              0
#define mmVGT_DRAW_INIT_FIFO_DEPTH                                                                     0x022f
#define mmVGT_DRAW_INIT_FIFO_DEPTH_BASE_IDX                                                            0
#define mmVGT_LAST_COPY_STATE                                                                          0x0230
#define mmVGT_LAST_COPY_STATE_BASE_IDX                                                                 0
#define mmVGT_CACHE_INVALIDATION                                                                       0x0231
#define mmVGT_CACHE_INVALIDATION_BASE_IDX                                                              0
#define mmVGT_STRMOUT_DELAY                                                                            0x0233
#define mmVGT_STRMOUT_DELAY_BASE_IDX                                                                   0
#define mmVGT_FIFO_DEPTHS                                                                              0x0234
#define mmVGT_FIFO_DEPTHS_BASE_IDX                                                                     0
#define mmVGT_GS_VERTEX_REUSE                                                                          0x0235
#define mmVGT_GS_VERTEX_REUSE_BASE_IDX                                                                 0
#define mmVGT_MC_LAT_CNTL                                                                              0x0236
#define mmVGT_MC_LAT_CNTL_BASE_IDX                                                                     0
#define mmIA_CNTL_STATUS                                                                               0x0237
#define mmIA_CNTL_STATUS_BASE_IDX                                                                      0
#define mmVGT_CNTL_STATUS                                                                              0x023c
#define mmVGT_CNTL_STATUS_BASE_IDX                                                                     0
#define mmWD_CNTL_STATUS                                                                               0x023f
#define mmWD_CNTL_STATUS_BASE_IDX                                                                      0
#define mmCC_GC_PRIM_CONFIG                                                                            0x0240
#define mmCC_GC_PRIM_CONFIG_BASE_IDX                                                                   0
#define mmGC_USER_PRIM_CONFIG                                                                          0x0241
#define mmGC_USER_PRIM_CONFIG_BASE_IDX                                                                 0
#define mmWD_QOS                                                                                       0x0242
#define mmWD_QOS_BASE_IDX                                                                              0
#define mmWD_UTCL1_CNTL                                                                                0x0243
#define mmWD_UTCL1_CNTL_BASE_IDX                                                                       0
#define mmWD_UTCL1_STATUS                                                                              0x0244
#define mmWD_UTCL1_STATUS_BASE_IDX                                                                     0
#define mmIA_UTCL1_CNTL                                                                                0x0246
#define mmIA_UTCL1_CNTL_BASE_IDX                                                                       0
#define mmIA_UTCL1_STATUS                                                                              0x0247
#define mmIA_UTCL1_STATUS_BASE_IDX                                                                     0
#define mmVGT_SYS_CONFIG                                                                               0x0263
#define mmVGT_SYS_CONFIG_BASE_IDX                                                                      0
#define mmVGT_VS_MAX_WAVE_ID                                                                           0x0268
#define mmVGT_VS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define mmVGT_GS_MAX_WAVE_ID                                                                           0x0269
#define mmVGT_GS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define mmGFX_PIPE_CONTROL                                                                             0x026d
#define mmGFX_PIPE_CONTROL_BASE_IDX                                                                    0
#define mmCC_GC_SHADER_ARRAY_CONFIG                                                                    0x026f
#define mmCC_GC_SHADER_ARRAY_CONFIG_BASE_IDX                                                           0
#define mmGC_USER_SHADER_ARRAY_CONFIG                                                                  0x0270
#define mmGC_USER_SHADER_ARRAY_CONFIG_BASE_IDX                                                         0
#define mmVGT_DMA_PRIMITIVE_TYPE                                                                       0x0271
#define mmVGT_DMA_PRIMITIVE_TYPE_BASE_IDX                                                              0
#define mmVGT_DMA_CONTROL                                                                              0x0272
#define mmVGT_DMA_CONTROL_BASE_IDX                                                                     0
#define mmVGT_DMA_LS_HS_CONFIG                                                                         0x0273
#define mmVGT_DMA_LS_HS_CONFIG_BASE_IDX                                                                0
#define mmWD_BUF_RESOURCE_1                                                                            0x0276
#define mmWD_BUF_RESOURCE_1_BASE_IDX                                                                   0
#define mmWD_BUF_RESOURCE_2                                                                            0x0277
#define mmWD_BUF_RESOURCE_2_BASE_IDX                                                                   0
#define mmPA_CL_CNTL_STATUS                                                                            0x0284
#define mmPA_CL_CNTL_STATUS_BASE_IDX                                                                   0
#define mmPA_CL_ENHANCE                                                                                0x0285
#define mmPA_CL_ENHANCE_BASE_IDX                                                                       0
#define mmPA_SU_CNTL_STATUS                                                                            0x0294
#define mmPA_SU_CNTL_STATUS_BASE_IDX                                                                   0
#define mmPA_SC_FIFO_DEPTH_CNTL                                                                        0x0295
#define mmPA_SC_FIFO_DEPTH_CNTL_BASE_IDX                                                               0
#define mmPA_SC_P3D_TRAP_SCREEN_HV_LOCK                                                                0x02c0
#define mmPA_SC_P3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                       0
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_LOCK                                                               0x02c1
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                      0
#define mmPA_SC_TRAP_SCREEN_HV_LOCK                                                                    0x02c2
#define mmPA_SC_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                           0
#define mmPA_SC_FORCE_EOV_MAX_CNTS                                                                     0x02c9
#define mmPA_SC_FORCE_EOV_MAX_CNTS_BASE_IDX                                                            0
#define mmPA_SC_BINNER_EVENT_CNTL_0                                                                    0x02cc
#define mmPA_SC_BINNER_EVENT_CNTL_0_BASE_IDX                                                           0
#define mmPA_SC_BINNER_EVENT_CNTL_1                                                                    0x02cd
#define mmPA_SC_BINNER_EVENT_CNTL_1_BASE_IDX                                                           0
#define mmPA_SC_BINNER_EVENT_CNTL_2                                                                    0x02ce
#define mmPA_SC_BINNER_EVENT_CNTL_2_BASE_IDX                                                           0
#define mmPA_SC_BINNER_EVENT_CNTL_3                                                                    0x02cf
#define mmPA_SC_BINNER_EVENT_CNTL_3_BASE_IDX                                                           0
#define mmPA_SC_BINNER_TIMEOUT_COUNTER                                                                 0x02d0
#define mmPA_SC_BINNER_TIMEOUT_COUNTER_BASE_IDX                                                        0
#define mmPA_SC_BINNER_PERF_CNTL_0                                                                     0x02d1
#define mmPA_SC_BINNER_PERF_CNTL_0_BASE_IDX                                                            0
#define mmPA_SC_BINNER_PERF_CNTL_1                                                                     0x02d2
#define mmPA_SC_BINNER_PERF_CNTL_1_BASE_IDX                                                            0
#define mmPA_SC_BINNER_PERF_CNTL_2                                                                     0x02d3
#define mmPA_SC_BINNER_PERF_CNTL_2_BASE_IDX                                                            0
#define mmPA_SC_BINNER_PERF_CNTL_3                                                                     0x02d4
#define mmPA_SC_BINNER_PERF_CNTL_3_BASE_IDX                                                            0
#define mmPA_SC_FIFO_SIZE                                                                              0x02f3
#define mmPA_SC_FIFO_SIZE_BASE_IDX                                                                     0
#define mmPA_SC_IF_FIFO_SIZE                                                                           0x02f5
#define mmPA_SC_IF_FIFO_SIZE_BASE_IDX                                                                  0
#define mmPA_SC_PKR_WAVE_TABLE_CNTL                                                                    0x02f8
#define mmPA_SC_PKR_WAVE_TABLE_CNTL_BASE_IDX                                                           0
#define mmPA_UTCL1_CNTL1                                                                               0x02f9
#define mmPA_UTCL1_CNTL1_BASE_IDX                                                                      0
#define mmPA_UTCL1_CNTL2                                                                               0x02fa
#define mmPA_UTCL1_CNTL2_BASE_IDX                                                                      0
#define mmPA_SIDEBAND_REQUEST_DELAYS                                                                   0x02fb
#define mmPA_SIDEBAND_REQUEST_DELAYS_BASE_IDX                                                          0
#define mmPA_SC_ENHANCE                                                                                0x02fc
#define mmPA_SC_ENHANCE_BASE_IDX                                                                       0
#define mmPA_SC_ENHANCE_1                                                                              0x02fd
#define mmPA_SC_ENHANCE_1_BASE_IDX                                                                     0
#define mmPA_SC_DSM_CNTL                                                                               0x02fe
#define mmPA_SC_DSM_CNTL_BASE_IDX                                                                      0
#define mmPA_SC_TILE_STEERING_CREST_OVERRIDE                                                           0x02ff
#define mmPA_SC_TILE_STEERING_CREST_OVERRIDE_BASE_IDX                                                  0


// addressBlock: gc_sqdec
// base address: 0x8c00
#define mmSQ_CONFIG                                                                                    0x0300
#define mmSQ_CONFIG_BASE_IDX                                                                           0
#define mmSQC_CONFIG                                                                                   0x0301
#define mmSQC_CONFIG_BASE_IDX                                                                          0
#define mmLDS_CONFIG                                                                                   0x0302
#define mmLDS_CONFIG_BASE_IDX                                                                          0
#define mmSQ_RANDOM_WAVE_PRI                                                                           0x0303
#define mmSQ_RANDOM_WAVE_PRI_BASE_IDX                                                                  0
#define mmSQ_REG_CREDITS                                                                               0x0304
#define mmSQ_REG_CREDITS_BASE_IDX                                                                      0
#define mmSQ_FIFO_SIZES                                                                                0x0305
#define mmSQ_FIFO_SIZES_BASE_IDX                                                                       0
#define mmSQ_DSM_CNTL                                                                                  0x0306
#define mmSQ_DSM_CNTL_BASE_IDX                                                                         0
#define mmSQ_DSM_CNTL2                                                                                 0x0307
#define mmSQ_DSM_CNTL2_BASE_IDX                                                                        0
#define mmSQ_RUNTIME_CONFIG                                                                            0x0308
#define mmSQ_RUNTIME_CONFIG_BASE_IDX                                                                   0
#define mmSH_MEM_BASES                                                                                 0x030a
#define mmSH_MEM_BASES_BASE_IDX                                                                        0
#define mmSH_MEM_CONFIG                                                                                0x030d
#define mmSH_MEM_CONFIG_BASE_IDX                                                                       0
#define mmCC_GC_SHADER_RATE_CONFIG                                                                     0x0312
#define mmCC_GC_SHADER_RATE_CONFIG_BASE_IDX                                                            0
#define mmGC_USER_SHADER_RATE_CONFIG                                                                   0x0313
#define mmGC_USER_SHADER_RATE_CONFIG_BASE_IDX                                                          0
#define mmSQ_INTERRUPT_AUTO_MASK                                                                       0x0314
#define mmSQ_INTERRUPT_AUTO_MASK_BASE_IDX                                                              0
#define mmSQ_INTERRUPT_MSG_CTRL                                                                        0x0315
#define mmSQ_INTERRUPT_MSG_CTRL_BASE_IDX                                                               0
#define mmSQ_UTCL1_CNTL1                                                                               0x0317
#define mmSQ_UTCL1_CNTL1_BASE_IDX                                                                      0
#define mmSQ_UTCL1_CNTL2                                                                               0x0318
#define mmSQ_UTCL1_CNTL2_BASE_IDX                                                                      0
#define mmSQ_UTCL1_STATUS                                                                              0x0319
#define mmSQ_UTCL1_STATUS_BASE_IDX                                                                     0
#define mmSQ_SHADER_TBA_LO                                                                             0x031c
#define mmSQ_SHADER_TBA_LO_BASE_IDX                                                                    0
#define mmSQ_SHADER_TBA_HI                                                                             0x031d
#define mmSQ_SHADER_TBA_HI_BASE_IDX                                                                    0
#define mmSQ_SHADER_TMA_LO                                                                             0x031e
#define mmSQ_SHADER_TMA_LO_BASE_IDX                                                                    0
#define mmSQ_SHADER_TMA_HI                                                                             0x031f
#define mmSQ_SHADER_TMA_HI_BASE_IDX                                                                    0
#define mmSQC_DSM_CNTL                                                                                 0x0320
#define mmSQC_DSM_CNTL_BASE_IDX                                                                        0
#define mmSQC_DSM_CNTLA                                                                                0x0321
#define mmSQC_DSM_CNTLA_BASE_IDX                                                                       0
#define mmSQC_DSM_CNTLB                                                                                0x0322
#define mmSQC_DSM_CNTLB_BASE_IDX                                                                       0
#define mmSQC_DSM_CNTL2                                                                                0x0325
#define mmSQC_DSM_CNTL2_BASE_IDX                                                                       0
#define mmSQC_DSM_CNTL2A                                                                               0x0326
#define mmSQC_DSM_CNTL2A_BASE_IDX                                                                      0
#define mmSQC_DSM_CNTL2B                                                                               0x0327
#define mmSQC_DSM_CNTL2B_BASE_IDX                                                                      0
#define mmSQC_EDC_FUE_CNTL                                                                             0x032b
#define mmSQC_EDC_FUE_CNTL_BASE_IDX                                                                    0
#define mmSQC_EDC_CNT2                                                                                 0x032c
#define mmSQC_EDC_CNT2_BASE_IDX                                                                        0
#define mmSQC_EDC_CNT3                                                                                 0x032d
#define mmSQC_EDC_CNT3_BASE_IDX                                                                        0
#define mmSQ_REG_TIMESTAMP                                                                             0x0374
#define mmSQ_REG_TIMESTAMP_BASE_IDX                                                                    0
#define mmSQ_CMD_TIMESTAMP                                                                             0x0375
#define mmSQ_CMD_TIMESTAMP_BASE_IDX                                                                    0
#define mmSQ_IND_INDEX                                                                                 0x0378
#define mmSQ_IND_INDEX_BASE_IDX                                                                        0
#define mmSQ_IND_DATA                                                                                  0x0379
#define mmSQ_IND_DATA_BASE_IDX                                                                         0
#define mmSQ_CMD                                                                                       0x037b
#define mmSQ_CMD_BASE_IDX                                                                              0
#define mmSQ_TIME_HI                                                                                   0x037c
#define mmSQ_TIME_HI_BASE_IDX                                                                          0
#define mmSQ_TIME_LO                                                                                   0x037d
#define mmSQ_TIME_LO_BASE_IDX                                                                          0
#define mmSQ_DS_0                                                                                      0x037f
#define mmSQ_DS_0_BASE_IDX                                                                             0
#define mmSQ_DS_1                                                                                      0x037f
#define mmSQ_DS_1_BASE_IDX                                                                             0
#define mmSQ_EXP_0                                                                                     0x037f
#define mmSQ_EXP_0_BASE_IDX                                                                            0
#define mmSQ_EXP_1                                                                                     0x037f
#define mmSQ_EXP_1_BASE_IDX                                                                            0
#define mmSQ_FLAT_0                                                                                    0x037f
#define mmSQ_FLAT_0_BASE_IDX                                                                           0
#define mmSQ_FLAT_1                                                                                    0x037f
#define mmSQ_FLAT_1_BASE_IDX                                                                           0
#define mmSQ_GLBL_0                                                                                    0x037f
#define mmSQ_GLBL_0_BASE_IDX                                                                           0
#define mmSQ_GLBL_1                                                                                    0x037f
#define mmSQ_GLBL_1_BASE_IDX                                                                           0
#define mmSQ_INST                                                                                      0x037f
#define mmSQ_INST_BASE_IDX                                                                             0
#define mmSQ_MIMG_0                                                                                    0x037f
#define mmSQ_MIMG_0_BASE_IDX                                                                           0
#define mmSQ_MIMG_1                                                                                    0x037f
#define mmSQ_MIMG_1_BASE_IDX                                                                           0
#define mmSQ_MTBUF_0                                                                                   0x037f
#define mmSQ_MTBUF_0_BASE_IDX                                                                          0
#define mmSQ_MTBUF_1                                                                                   0x037f
#define mmSQ_MTBUF_1_BASE_IDX                                                                          0
#define mmSQ_MUBUF_0                                                                                   0x037f
#define mmSQ_MUBUF_0_BASE_IDX                                                                          0
#define mmSQ_MUBUF_1                                                                                   0x037f
#define mmSQ_MUBUF_1_BASE_IDX                                                                          0
#define mmSQ_SCRATCH_0                                                                                 0x037f
#define mmSQ_SCRATCH_0_BASE_IDX                                                                        0
#define mmSQ_SCRATCH_1                                                                                 0x037f
#define mmSQ_SCRATCH_1_BASE_IDX                                                                        0
#define mmSQ_SMEM_0                                                                                    0x037f
#define mmSQ_SMEM_0_BASE_IDX                                                                           0
#define mmSQ_SMEM_1                                                                                    0x037f
#define mmSQ_SMEM_1_BASE_IDX                                                                           0
#define mmSQ_SOP1                                                                                      0x037f
#define mmSQ_SOP1_BASE_IDX                                                                             0
#define mmSQ_SOP2                                                                                      0x037f
#define mmSQ_SOP2_BASE_IDX                                                                             0
#define mmSQ_SOPC                                                                                      0x037f
#define mmSQ_SOPC_BASE_IDX                                                                             0
#define mmSQ_SOPK                                                                                      0x037f
#define mmSQ_SOPK_BASE_IDX                                                                             0
#define mmSQ_SOPP                                                                                      0x037f
#define mmSQ_SOPP_BASE_IDX                                                                             0
#define mmSQ_VINTRP                                                                                    0x037f
#define mmSQ_VINTRP_BASE_IDX                                                                           0
#define mmSQ_VOP1                                                                                      0x037f
#define mmSQ_VOP1_BASE_IDX                                                                             0
#define mmSQ_VOP2                                                                                      0x037f
#define mmSQ_VOP2_BASE_IDX                                                                             0
#define mmSQ_VOP3P_0                                                                                   0x037f
#define mmSQ_VOP3P_0_BASE_IDX                                                                          0
#define mmSQ_VOP3P_1                                                                                   0x037f
#define mmSQ_VOP3P_1_BASE_IDX                                                                          0
#define mmSQ_VOP3_0                                                                                    0x037f
#define mmSQ_VOP3_0_BASE_IDX                                                                           0
#define mmSQ_VOP3_0_SDST_ENC                                                                           0x037f
#define mmSQ_VOP3_0_SDST_ENC_BASE_IDX                                                                  0
#define mmSQ_VOP3_1                                                                                    0x037f
#define mmSQ_VOP3_1_BASE_IDX                                                                           0
#define mmSQ_VOPC                                                                                      0x037f
#define mmSQ_VOPC_BASE_IDX                                                                             0
#define mmSQ_VOP_DPP                                                                                   0x037f
#define mmSQ_VOP_DPP_BASE_IDX                                                                          0
#define mmSQ_VOP_SDWA                                                                                  0x037f
#define mmSQ_VOP_SDWA_BASE_IDX                                                                         0
#define mmSQ_VOP_SDWA_SDST_ENC                                                                         0x037f
#define mmSQ_VOP_SDWA_SDST_ENC_BASE_IDX                                                                0
#define mmSQ_LB_CTR_CTRL                                                                               0x0398
#define mmSQ_LB_CTR_CTRL_BASE_IDX                                                                      0
#define mmSQ_LB_DATA0                                                                                  0x0399
#define mmSQ_LB_DATA0_BASE_IDX                                                                         0
#define mmSQ_LB_DATA1                                                                                  0x039a
#define mmSQ_LB_DATA1_BASE_IDX                                                                         0
#define mmSQ_LB_DATA2                                                                                  0x039b
#define mmSQ_LB_DATA2_BASE_IDX                                                                         0
#define mmSQ_LB_DATA3                                                                                  0x039c
#define mmSQ_LB_DATA3_BASE_IDX                                                                         0
#define mmSQ_LB_CTR_SEL                                                                                0x039d
#define mmSQ_LB_CTR_SEL_BASE_IDX                                                                       0
#define mmSQ_LB_CTR0_CU                                                                                0x039e
#define mmSQ_LB_CTR0_CU_BASE_IDX                                                                       0
#define mmSQ_LB_CTR1_CU                                                                                0x039f
#define mmSQ_LB_CTR1_CU_BASE_IDX                                                                       0
#define mmSQ_LB_CTR2_CU                                                                                0x03a0
#define mmSQ_LB_CTR2_CU_BASE_IDX                                                                       0
#define mmSQ_LB_CTR3_CU                                                                                0x03a1
#define mmSQ_LB_CTR3_CU_BASE_IDX                                                                       0
#define mmSQC_EDC_CNT                                                                                  0x03a2
#define mmSQC_EDC_CNT_BASE_IDX                                                                         0
#define mmSQ_EDC_SEC_CNT                                                                               0x03a3
#define mmSQ_EDC_SEC_CNT_BASE_IDX                                                                      0
#define mmSQ_EDC_DED_CNT                                                                               0x03a4
#define mmSQ_EDC_DED_CNT_BASE_IDX                                                                      0
#define mmSQ_EDC_INFO                                                                                  0x03a5
#define mmSQ_EDC_INFO_BASE_IDX                                                                         0
#define mmSQ_EDC_CNT                                                                                   0x03a6
#define mmSQ_EDC_CNT_BASE_IDX                                                                          0
#define mmSQ_EDC_FUE_CNTL                                                                              0x03a7
#define mmSQ_EDC_FUE_CNTL_BASE_IDX                                                                     0
#define mmSQ_THREAD_TRACE_WORD_CMN                                                                     0x03b0
#define mmSQ_THREAD_TRACE_WORD_CMN_BASE_IDX                                                            0
#define mmSQ_THREAD_TRACE_WORD_EVENT                                                                   0x03b0
#define mmSQ_THREAD_TRACE_WORD_EVENT_BASE_IDX                                                          0
#define mmSQ_THREAD_TRACE_WORD_INST                                                                    0x03b0
#define mmSQ_THREAD_TRACE_WORD_INST_BASE_IDX                                                           0
#define mmSQ_THREAD_TRACE_WORD_INST_PC_1_OF_2                                                          0x03b0
#define mmSQ_THREAD_TRACE_WORD_INST_PC_1_OF_2_BASE_IDX                                                 0
#define mmSQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2                                                    0x03b0
#define mmSQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2_BASE_IDX                                           0
#define mmSQ_THREAD_TRACE_WORD_ISSUE                                                                   0x03b0
#define mmSQ_THREAD_TRACE_WORD_ISSUE_BASE_IDX                                                          0
#define mmSQ_THREAD_TRACE_WORD_MISC                                                                    0x03b0
#define mmSQ_THREAD_TRACE_WORD_MISC_BASE_IDX                                                           0
#define mmSQ_THREAD_TRACE_WORD_PERF_1_OF_2                                                             0x03b0
#define mmSQ_THREAD_TRACE_WORD_PERF_1_OF_2_BASE_IDX                                                    0
#define mmSQ_THREAD_TRACE_WORD_REG_1_OF_2                                                              0x03b0
#define mmSQ_THREAD_TRACE_WORD_REG_1_OF_2_BASE_IDX                                                     0
#define mmSQ_THREAD_TRACE_WORD_REG_2_OF_2                                                              0x03b0
#define mmSQ_THREAD_TRACE_WORD_REG_2_OF_2_BASE_IDX                                                     0
#define mmSQ_THREAD_TRACE_WORD_REG_CS_1_OF_2                                                           0x03b0
#define mmSQ_THREAD_TRACE_WORD_REG_CS_1_OF_2_BASE_IDX                                                  0
#define mmSQ_THREAD_TRACE_WORD_REG_CS_2_OF_2                                                           0x03b0
#define mmSQ_THREAD_TRACE_WORD_REG_CS_2_OF_2_BASE_IDX                                                  0
#define mmSQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2                                                        0x03b0
#define mmSQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2_BASE_IDX                                               0
#define mmSQ_THREAD_TRACE_WORD_WAVE                                                                    0x03b0
#define mmSQ_THREAD_TRACE_WORD_WAVE_BASE_IDX                                                           0
#define mmSQ_THREAD_TRACE_WORD_WAVE_START                                                              0x03b0
#define mmSQ_THREAD_TRACE_WORD_WAVE_START_BASE_IDX                                                     0
#define mmSQ_THREAD_TRACE_WORD_INST_PC_2_OF_2                                                          0x03b1
#define mmSQ_THREAD_TRACE_WORD_INST_PC_2_OF_2_BASE_IDX                                                 0
#define mmSQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2                                                    0x03b1
#define mmSQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2_BASE_IDX                                           0
#define mmSQ_THREAD_TRACE_WORD_PERF_2_OF_2                                                             0x03b1
#define mmSQ_THREAD_TRACE_WORD_PERF_2_OF_2_BASE_IDX                                                    0
#define mmSQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2                                                        0x03b1
#define mmSQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2_BASE_IDX                                               0
#define mmSQ_WREXEC_EXEC_HI                                                                            0x03b1
#define mmSQ_WREXEC_EXEC_HI_BASE_IDX                                                                   0
#define mmSQ_WREXEC_EXEC_LO                                                                            0x03b1
#define mmSQ_WREXEC_EXEC_LO_BASE_IDX                                                                   0
#define mmSQ_BUF_RSRC_WORD0                                                                            0x03c0
#define mmSQ_BUF_RSRC_WORD0_BASE_IDX                                                                   0
#define mmSQ_BUF_RSRC_WORD1                                                                            0x03c1
#define mmSQ_BUF_RSRC_WORD1_BASE_IDX                                                                   0
#define mmSQ_BUF_RSRC_WORD2                                                                            0x03c2
#define mmSQ_BUF_RSRC_WORD2_BASE_IDX                                                                   0
#define mmSQ_BUF_RSRC_WORD3                                                                            0x03c3
#define mmSQ_BUF_RSRC_WORD3_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD0                                                                            0x03c4
#define mmSQ_IMG_RSRC_WORD0_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD1                                                                            0x03c5
#define mmSQ_IMG_RSRC_WORD1_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD2                                                                            0x03c6
#define mmSQ_IMG_RSRC_WORD2_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD3                                                                            0x03c7
#define mmSQ_IMG_RSRC_WORD3_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD4                                                                            0x03c8
#define mmSQ_IMG_RSRC_WORD4_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD5                                                                            0x03c9
#define mmSQ_IMG_RSRC_WORD5_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD6                                                                            0x03ca
#define mmSQ_IMG_RSRC_WORD6_BASE_IDX                                                                   0
#define mmSQ_IMG_RSRC_WORD7                                                                            0x03cb
#define mmSQ_IMG_RSRC_WORD7_BASE_IDX                                                                   0
#define mmSQ_IMG_SAMP_WORD0                                                                            0x03cc
#define mmSQ_IMG_SAMP_WORD0_BASE_IDX                                                                   0
#define mmSQ_IMG_SAMP_WORD1                                                                            0x03cd
#define mmSQ_IMG_SAMP_WORD1_BASE_IDX                                                                   0
#define mmSQ_IMG_SAMP_WORD2                                                                            0x03ce
#define mmSQ_IMG_SAMP_WORD2_BASE_IDX                                                                   0
#define mmSQ_IMG_SAMP_WORD3                                                                            0x03cf
#define mmSQ_IMG_SAMP_WORD3_BASE_IDX                                                                   0
#define mmSQ_FLAT_SCRATCH_WORD0                                                                        0x03d0
#define mmSQ_FLAT_SCRATCH_WORD0_BASE_IDX                                                               0
#define mmSQ_FLAT_SCRATCH_WORD1                                                                        0x03d1
#define mmSQ_FLAT_SCRATCH_WORD1_BASE_IDX                                                               0
#define mmSQ_M0_GPR_IDX_WORD                                                                           0x03d2
#define mmSQ_M0_GPR_IDX_WORD_BASE_IDX                                                                  0
#define mmSQC_ICACHE_UTCL1_CNTL1                                                                       0x03d3
#define mmSQC_ICACHE_UTCL1_CNTL1_BASE_IDX                                                              0
#define mmSQC_ICACHE_UTCL1_CNTL2                                                                       0x03d4
#define mmSQC_ICACHE_UTCL1_CNTL2_BASE_IDX                                                              0
#define mmSQC_DCACHE_UTCL1_CNTL1                                                                       0x03d5
#define mmSQC_DCACHE_UTCL1_CNTL1_BASE_IDX                                                              0
#define mmSQC_DCACHE_UTCL1_CNTL2                                                                       0x03d6
#define mmSQC_DCACHE_UTCL1_CNTL2_BASE_IDX                                                              0
#define mmSQC_ICACHE_UTCL1_STATUS                                                                      0x03d7
#define mmSQC_ICACHE_UTCL1_STATUS_BASE_IDX                                                             0
#define mmSQC_DCACHE_UTCL1_STATUS                                                                      0x03d8
#define mmSQC_DCACHE_UTCL1_STATUS_BASE_IDX                                                             0


// addressBlock: gc_shsdec
// base address: 0x9000
#define mmSX_DEBUG_1                                                                                   0x0419
#define mmSX_DEBUG_1_BASE_IDX                                                                          0
#define mmSPI_PS_MAX_WAVE_ID                                                                           0x043a
#define mmSPI_PS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define mmSPI_START_PHASE                                                                              0x043b
#define mmSPI_START_PHASE_BASE_IDX                                                                     0
#define mmSPI_GFX_CNTL                                                                                 0x043c
#define mmSPI_GFX_CNTL_BASE_IDX                                                                        0
#define mmSPI_DSM_CNTL                                                                                 0x0443
#define mmSPI_DSM_CNTL_BASE_IDX                                                                        0
#define mmSPI_DSM_CNTL2                                                                                0x0444
#define mmSPI_DSM_CNTL2_BASE_IDX                                                                       0
#define mmSPI_EDC_CNT                                                                                  0x0445
#define mmSPI_EDC_CNT_BASE_IDX                                                                         0
#define mmSPI_CONFIG_PS_CU_EN                                                                          0x0452
#define mmSPI_CONFIG_PS_CU_EN_BASE_IDX                                                                 0
#define mmSPI_WF_LIFETIME_CNTL                                                                         0x04aa
#define mmSPI_WF_LIFETIME_CNTL_BASE_IDX                                                                0
#define mmSPI_WF_LIFETIME_LIMIT_0                                                                      0x04ab
#define mmSPI_WF_LIFETIME_LIMIT_0_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_1                                                                      0x04ac
#define mmSPI_WF_LIFETIME_LIMIT_1_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_2                                                                      0x04ad
#define mmSPI_WF_LIFETIME_LIMIT_2_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_3                                                                      0x04ae
#define mmSPI_WF_LIFETIME_LIMIT_3_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_4                                                                      0x04af
#define mmSPI_WF_LIFETIME_LIMIT_4_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_5                                                                      0x04b0
#define mmSPI_WF_LIFETIME_LIMIT_5_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_6                                                                      0x04b1
#define mmSPI_WF_LIFETIME_LIMIT_6_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_7                                                                      0x04b2
#define mmSPI_WF_LIFETIME_LIMIT_7_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_8                                                                      0x04b3
#define mmSPI_WF_LIFETIME_LIMIT_8_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_LIMIT_9                                                                      0x04b4
#define mmSPI_WF_LIFETIME_LIMIT_9_BASE_IDX                                                             0
#define mmSPI_WF_LIFETIME_STATUS_0                                                                     0x04b5
#define mmSPI_WF_LIFETIME_STATUS_0_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_1                                                                     0x04b6
#define mmSPI_WF_LIFETIME_STATUS_1_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_2                                                                     0x04b7
#define mmSPI_WF_LIFETIME_STATUS_2_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_3                                                                     0x04b8
#define mmSPI_WF_LIFETIME_STATUS_3_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_4                                                                     0x04b9
#define mmSPI_WF_LIFETIME_STATUS_4_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_5                                                                     0x04ba
#define mmSPI_WF_LIFETIME_STATUS_5_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_6                                                                     0x04bb
#define mmSPI_WF_LIFETIME_STATUS_6_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_7                                                                     0x04bc
#define mmSPI_WF_LIFETIME_STATUS_7_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_8                                                                     0x04bd
#define mmSPI_WF_LIFETIME_STATUS_8_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_9                                                                     0x04be
#define mmSPI_WF_LIFETIME_STATUS_9_BASE_IDX                                                            0
#define mmSPI_WF_LIFETIME_STATUS_10                                                                    0x04bf
#define mmSPI_WF_LIFETIME_STATUS_10_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_11                                                                    0x04c0
#define mmSPI_WF_LIFETIME_STATUS_11_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_12                                                                    0x04c1
#define mmSPI_WF_LIFETIME_STATUS_12_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_13                                                                    0x04c2
#define mmSPI_WF_LIFETIME_STATUS_13_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_14                                                                    0x04c3
#define mmSPI_WF_LIFETIME_STATUS_14_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_15                                                                    0x04c4
#define mmSPI_WF_LIFETIME_STATUS_15_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_16                                                                    0x04c5
#define mmSPI_WF_LIFETIME_STATUS_16_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_17                                                                    0x04c6
#define mmSPI_WF_LIFETIME_STATUS_17_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_18                                                                    0x04c7
#define mmSPI_WF_LIFETIME_STATUS_18_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_19                                                                    0x04c8
#define mmSPI_WF_LIFETIME_STATUS_19_BASE_IDX                                                           0
#define mmSPI_WF_LIFETIME_STATUS_20                                                                    0x04c9
#define mmSPI_WF_LIFETIME_STATUS_20_BASE_IDX                                                           0
#define mmSPI_LB_CTR_CTRL                                                                              0x04d4
#define mmSPI_LB_CTR_CTRL_BASE_IDX                                                                     0
#define mmSPI_LB_CU_MASK                                                                               0x04d5
#define mmSPI_LB_CU_MASK_BASE_IDX                                                                      0
#define mmSPI_LB_DATA_REG                                                                              0x04d6
#define mmSPI_LB_DATA_REG_BASE_IDX                                                                     0
#define mmSPI_PG_ENABLE_STATIC_CU_MASK                                                                 0x04d7
#define mmSPI_PG_ENABLE_STATIC_CU_MASK_BASE_IDX                                                        0
#define mmSPI_GDS_CREDITS                                                                              0x04d8
#define mmSPI_GDS_CREDITS_BASE_IDX                                                                     0
#define mmSPI_SX_EXPORT_BUFFER_SIZES                                                                   0x04d9
#define mmSPI_SX_EXPORT_BUFFER_SIZES_BASE_IDX                                                          0
#define mmSPI_SX_SCOREBOARD_BUFFER_SIZES                                                               0x04da
#define mmSPI_SX_SCOREBOARD_BUFFER_SIZES_BASE_IDX                                                      0
#define mmSPI_CSQ_WF_ACTIVE_STATUS                                                                     0x04db
#define mmSPI_CSQ_WF_ACTIVE_STATUS_BASE_IDX                                                            0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_0                                                                    0x04dc
#define mmSPI_CSQ_WF_ACTIVE_COUNT_0_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_1                                                                    0x04dd
#define mmSPI_CSQ_WF_ACTIVE_COUNT_1_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_2                                                                    0x04de
#define mmSPI_CSQ_WF_ACTIVE_COUNT_2_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_3                                                                    0x04df
#define mmSPI_CSQ_WF_ACTIVE_COUNT_3_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_4                                                                    0x04e0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_4_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_5                                                                    0x04e1
#define mmSPI_CSQ_WF_ACTIVE_COUNT_5_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_6                                                                    0x04e2
#define mmSPI_CSQ_WF_ACTIVE_COUNT_6_BASE_IDX                                                           0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_7                                                                    0x04e3
#define mmSPI_CSQ_WF_ACTIVE_COUNT_7_BASE_IDX                                                           0
#define mmSPI_LB_DATA_WAVES                                                                            0x04e4
#define mmSPI_LB_DATA_WAVES_BASE_IDX                                                                   0
#define mmSPI_LB_DATA_PERCU_WAVE_HSGS                                                                  0x04e5
#define mmSPI_LB_DATA_PERCU_WAVE_HSGS_BASE_IDX                                                         0
#define mmSPI_LB_DATA_PERCU_WAVE_VSPS                                                                  0x04e6
#define mmSPI_LB_DATA_PERCU_WAVE_VSPS_BASE_IDX                                                         0
#define mmSPI_LB_DATA_PERCU_WAVE_CS                                                                    0x04e7
#define mmSPI_LB_DATA_PERCU_WAVE_CS_BASE_IDX                                                           0
#define mmSPI_P0_TRAP_SCREEN_PSBA_LO                                                                   0x04ec
#define mmSPI_P0_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_PSBA_HI                                                                   0x04ed
#define mmSPI_P0_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_PSMA_LO                                                                   0x04ee
#define mmSPI_P0_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_PSMA_HI                                                                   0x04ef
#define mmSPI_P0_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define mmSPI_P0_TRAP_SCREEN_GPR_MIN                                                                   0x04f0
#define mmSPI_P0_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSBA_LO                                                                   0x04f1
#define mmSPI_P1_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSBA_HI                                                                   0x04f2
#define mmSPI_P1_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSMA_LO                                                                   0x04f3
#define mmSPI_P1_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_PSMA_HI                                                                   0x04f4
#define mmSPI_P1_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define mmSPI_P1_TRAP_SCREEN_GPR_MIN                                                                   0x04f5
#define mmSPI_P1_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0


// addressBlock: gc_tpdec
// base address: 0x9400
#define mmTD_CNTL                                                                                      0x0525
#define mmTD_CNTL_BASE_IDX                                                                             0
#define mmTD_STATUS                                                                                    0x0526
#define mmTD_STATUS_BASE_IDX                                                                           0
#define mmTD_DSM_CNTL                                                                                  0x052f
#define mmTD_DSM_CNTL_BASE_IDX                                                                         0
#define mmTD_DSM_CNTL2                                                                                 0x0530
#define mmTD_DSM_CNTL2_BASE_IDX                                                                        0
#define mmTD_SCRATCH                                                                                   0x0533
#define mmTD_SCRATCH_BASE_IDX                                                                          0
#define mmTA_CNTL                                                                                      0x0541
#define mmTA_CNTL_BASE_IDX                                                                             0
#define mmTA_CNTL_AUX                                                                                  0x0542
#define mmTA_CNTL_AUX_BASE_IDX                                                                         0
#define mmTA_RESERVED_010C                                                                             0x0543
#define mmTA_RESERVED_010C_BASE_IDX                                                                    0
#define mmTA_STATUS                                                                                    0x0548
#define mmTA_STATUS_BASE_IDX                                                                           0
#define mmTA_SCRATCH                                                                                   0x0564
#define mmTA_SCRATCH_BASE_IDX                                                                          0


// addressBlock: gc_gdsdec
// base address: 0x9700
#define mmGDS_CONFIG                                                                                   0x05c0
#define mmGDS_CONFIG_BASE_IDX                                                                          0
#define mmGDS_CNTL_STATUS                                                                              0x05c1
#define mmGDS_CNTL_STATUS_BASE_IDX                                                                     0
#define mmGDS_ENHANCE2                                                                                 0x05c2
#define mmGDS_ENHANCE2_BASE_IDX                                                                        0
#define mmGDS_PROTECTION_FAULT                                                                         0x05c3
#define mmGDS_PROTECTION_FAULT_BASE_IDX                                                                0
#define mmGDS_VM_PROTECTION_FAULT                                                                      0x05c4
#define mmGDS_VM_PROTECTION_FAULT_BASE_IDX                                                             0
#define mmGDS_EDC_CNT                                                                                  0x05c5
#define mmGDS_EDC_CNT_BASE_IDX                                                                         0
#define mmGDS_EDC_GRBM_CNT                                                                             0x05c6
#define mmGDS_EDC_GRBM_CNT_BASE_IDX                                                                    0
#define mmGDS_EDC_OA_DED                                                                               0x05c7
#define mmGDS_EDC_OA_DED_BASE_IDX                                                                      0
#define mmGDS_DSM_CNTL                                                                                 0x05ca
#define mmGDS_DSM_CNTL_BASE_IDX                                                                        0
#define mmGDS_EDC_OA_PHY_CNT                                                                           0x05cb
#define mmGDS_EDC_OA_PHY_CNT_BASE_IDX                                                                  0
#define mmGDS_EDC_OA_PIPE_CNT                                                                          0x05cc
#define mmGDS_EDC_OA_PIPE_CNT_BASE_IDX                                                                 0
#define mmGDS_DSM_CNTL2                                                                                0x05cd
#define mmGDS_DSM_CNTL2_BASE_IDX                                                                       0
#define mmGDS_WD_GDS_CSB                                                                               0x05ce
#define mmGDS_WD_GDS_CSB_BASE_IDX                                                                      0


// addressBlock: gc_rbdec
// base address: 0x9800
#define mmDB_DEBUG                                                                                     0x060c
#define mmDB_DEBUG_BASE_IDX                                                                            0
#define mmDB_DEBUG2                                                                                    0x060d
#define mmDB_DEBUG2_BASE_IDX                                                                           0
#define mmDB_DEBUG3                                                                                    0x060e
#define mmDB_DEBUG3_BASE_IDX                                                                           0
#define mmDB_DEBUG4                                                                                    0x060f
#define mmDB_DEBUG4_BASE_IDX                                                                           0
#define mmDB_CREDIT_LIMIT                                                                              0x0614
#define mmDB_CREDIT_LIMIT_BASE_IDX                                                                     0
#define mmDB_WATERMARKS                                                                                0x0615
#define mmDB_WATERMARKS_BASE_IDX                                                                       0
#define mmDB_SUBTILE_CONTROL                                                                           0x0616
#define mmDB_SUBTILE_CONTROL_BASE_IDX                                                                  0
#define mmDB_FREE_CACHELINES                                                                           0x0617
#define mmDB_FREE_CACHELINES_BASE_IDX                                                                  0
#define mmDB_FIFO_DEPTH1                                                                               0x0618
#define mmDB_FIFO_DEPTH1_BASE_IDX                                                                      0
#define mmDB_FIFO_DEPTH2                                                                               0x0619
#define mmDB_FIFO_DEPTH2_BASE_IDX                                                                      0
#define mmDB_EXCEPTION_CONTROL                                                                         0x061a
#define mmDB_EXCEPTION_CONTROL_BASE_IDX                                                                0
#define mmDB_RING_CONTROL                                                                              0x061b
#define mmDB_RING_CONTROL_BASE_IDX                                                                     0
#define mmDB_MEM_ARB_WATERMARKS                                                                        0x061c
#define mmDB_MEM_ARB_WATERMARKS_BASE_IDX                                                               0
#define mmDB_RMI_CACHE_POLICY                                                                          0x061e
#define mmDB_RMI_CACHE_POLICY_BASE_IDX                                                                 0
#define mmDB_DFSM_CONFIG                                                                               0x0630
#define mmDB_DFSM_CONFIG_BASE_IDX                                                                      0
#define mmDB_DFSM_WATERMARK                                                                            0x0631
#define mmDB_DFSM_WATERMARK_BASE_IDX                                                                   0
#define mmDB_DFSM_TILES_IN_FLIGHT                                                                      0x0632
#define mmDB_DFSM_TILES_IN_FLIGHT_BASE_IDX                                                             0
#define mmDB_DFSM_PRIMS_IN_FLIGHT                                                                      0x0633
#define mmDB_DFSM_PRIMS_IN_FLIGHT_BASE_IDX                                                             0
#define mmDB_DFSM_WATCHDOG                                                                             0x0634
#define mmDB_DFSM_WATCHDOG_BASE_IDX                                                                    0
#define mmDB_DFSM_FLUSH_ENABLE                                                                         0x0635
#define mmDB_DFSM_FLUSH_ENABLE_BASE_IDX                                                                0
#define mmDB_DFSM_FLUSH_AUX_EVENT                                                                      0x0636
#define mmDB_DFSM_FLUSH_AUX_EVENT_BASE_IDX                                                             0
#define mmCC_RB_REDUNDANCY                                                                             0x063c
#define mmCC_RB_REDUNDANCY_BASE_IDX                                                                    0
#define mmCC_RB_BACKEND_DISABLE                                                                        0x063d
#define mmCC_RB_BACKEND_DISABLE_BASE_IDX                                                               0
#define mmGB_ADDR_CONFIG                                                                               0x063e
#define mmGB_ADDR_CONFIG_BASE_IDX                                                                      0
#define mmGB_BACKEND_MAP                                                                               0x063f
#define mmGB_BACKEND_MAP_BASE_IDX                                                                      0
#define mmGB_GPU_ID                                                                                    0x0640
#define mmGB_GPU_ID_BASE_IDX                                                                           0
#define mmCC_RB_DAISY_CHAIN                                                                            0x0641
#define mmCC_RB_DAISY_CHAIN_BASE_IDX                                                                   0
#define mmGB_ADDR_CONFIG_READ                                                                          0x0642
#define mmGB_ADDR_CONFIG_READ_BASE_IDX                                                                 0
#define mmGB_TILE_MODE0                                                                                0x0644
#define mmGB_TILE_MODE0_BASE_IDX                                                                       0
#define mmGB_TILE_MODE1                                                                                0x0645
#define mmGB_TILE_MODE1_BASE_IDX                                                                       0
#define mmGB_TILE_MODE2                                                                                0x0646
#define mmGB_TILE_MODE2_BASE_IDX                                                                       0
#define mmGB_TILE_MODE3                                                                                0x0647
#define mmGB_TILE_MODE3_BASE_IDX                                                                       0
#define mmGB_TILE_MODE4                                                                                0x0648
#define mmGB_TILE_MODE4_BASE_IDX                                                                       0
#define mmGB_TILE_MODE5                                                                                0x0649
#define mmGB_TILE_MODE5_BASE_IDX                                                                       0
#define mmGB_TILE_MODE6                                                                                0x064a
#define mmGB_TILE_MODE6_BASE_IDX                                                                       0
#define mmGB_TILE_MODE7                                                                                0x064b
#define mmGB_TILE_MODE7_BASE_IDX                                                                       0
#define mmGB_TILE_MODE8                                                                                0x064c
#define mmGB_TILE_MODE8_BASE_IDX                                                                       0
#define mmGB_TILE_MODE9                                                                                0x064d
#define mmGB_TILE_MODE9_BASE_IDX                                                                       0
#define mmGB_TILE_MODE10                                                                               0x064e
#define mmGB_TILE_MODE10_BASE_IDX                                                                      0
#define mmGB_TILE_MODE11                                                                               0x064f
#define mmGB_TILE_MODE11_BASE_IDX                                                                      0
#define mmGB_TILE_MODE12                                                                               0x0650
#define mmGB_TILE_MODE12_BASE_IDX                                                                      0
#define mmGB_TILE_MODE13                                                                               0x0651
#define mmGB_TILE_MODE13_BASE_IDX                                                                      0
#define mmGB_TILE_MODE14                                                                               0x0652
#define mmGB_TILE_MODE14_BASE_IDX                                                                      0
#define mmGB_TILE_MODE15                                                                               0x0653
#define mmGB_TILE_MODE15_BASE_IDX                                                                      0
#define mmGB_TILE_MODE16                                                                               0x0654
#define mmGB_TILE_MODE16_BASE_IDX                                                                      0
#define mmGB_TILE_MODE17                                                                               0x0655
#define mmGB_TILE_MODE17_BASE_IDX                                                                      0
#define mmGB_TILE_MODE18                                                                               0x0656
#define mmGB_TILE_MODE18_BASE_IDX                                                                      0
#define mmGB_TILE_MODE19                                                                               0x0657
#define mmGB_TILE_MODE19_BASE_IDX                                                                      0
#define mmGB_TILE_MODE20                                                                               0x0658
#define mmGB_TILE_MODE20_BASE_IDX                                                                      0
#define mmGB_TILE_MODE21                                                                               0x0659
#define mmGB_TILE_MODE21_BASE_IDX                                                                      0
#define mmGB_TILE_MODE22                                                                               0x065a
#define mmGB_TILE_MODE22_BASE_IDX                                                                      0
#define mmGB_TILE_MODE23                                                                               0x065b
#define mmGB_TILE_MODE23_BASE_IDX                                                                      0
#define mmGB_TILE_MODE24                                                                               0x065c
#define mmGB_TILE_MODE24_BASE_IDX                                                                      0
#define mmGB_TILE_MODE25                                                                               0x065d
#define mmGB_TILE_MODE25_BASE_IDX                                                                      0
#define mmGB_TILE_MODE26                                                                               0x065e
#define mmGB_TILE_MODE26_BASE_IDX                                                                      0
#define mmGB_TILE_MODE27                                                                               0x065f
#define mmGB_TILE_MODE27_BASE_IDX                                                                      0
#define mmGB_TILE_MODE28                                                                               0x0660
#define mmGB_TILE_MODE28_BASE_IDX                                                                      0
#define mmGB_TILE_MODE29                                                                               0x0661
#define mmGB_TILE_MODE29_BASE_IDX                                                                      0
#define mmGB_TILE_MODE30                                                                               0x0662
#define mmGB_TILE_MODE30_BASE_IDX                                                                      0
#define mmGB_TILE_MODE31                                                                               0x0663
#define mmGB_TILE_MODE31_BASE_IDX                                                                      0
#define mmGB_MACROTILE_MODE0                                                                           0x0664
#define mmGB_MACROTILE_MODE0_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE1                                                                           0x0665
#define mmGB_MACROTILE_MODE1_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE2                                                                           0x0666
#define mmGB_MACROTILE_MODE2_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE3                                                                           0x0667
#define mmGB_MACROTILE_MODE3_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE4                                                                           0x0668
#define mmGB_MACROTILE_MODE4_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE5                                                                           0x0669
#define mmGB_MACROTILE_MODE5_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE6                                                                           0x066a
#define mmGB_MACROTILE_MODE6_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE7                                                                           0x066b
#define mmGB_MACROTILE_MODE7_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE8                                                                           0x066c
#define mmGB_MACROTILE_MODE8_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE9                                                                           0x066d
#define mmGB_MACROTILE_MODE9_BASE_IDX                                                                  0
#define mmGB_MACROTILE_MODE10                                                                          0x066e
#define mmGB_MACROTILE_MODE10_BASE_IDX                                                                 0
#define mmGB_MACROTILE_MODE11                                                                          0x066f
#define mmGB_MACROTILE_MODE11_BASE_IDX                                                                 0
#define mmGB_MACROTILE_MODE12                                                                          0x0670
#define mmGB_MACROTILE_MODE12_BASE_IDX                                                                 0
#define mmGB_MACROTILE_MODE13                                                                          0x0671
#define mmGB_MACROTILE_MODE13_BASE_IDX                                                                 0
#define mmGB_MACROTILE_MODE14                                                                          0x0672
#define mmGB_MACROTILE_MODE14_BASE_IDX                                                                 0
#define mmGB_MACROTILE_MODE15                                                                          0x0673
#define mmGB_MACROTILE_MODE15_BASE_IDX                                                                 0
#define mmCB_HW_CONTROL                                                                                0x0680
#define mmCB_HW_CONTROL_BASE_IDX                                                                       0
#define mmCB_HW_CONTROL_1                                                                              0x0681
#define mmCB_HW_CONTROL_1_BASE_IDX                                                                     0
#define mmCB_HW_CONTROL_2                                                                              0x0682
#define mmCB_HW_CONTROL_2_BASE_IDX                                                                     0
#define mmCB_HW_CONTROL_3                                                                              0x0683
#define mmCB_HW_CONTROL_3_BASE_IDX                                                                     0
#define mmCB_HW_MEM_ARBITER_RD                                                                         0x0686
#define mmCB_HW_MEM_ARBITER_RD_BASE_IDX                                                                0
#define mmCB_HW_MEM_ARBITER_WR                                                                         0x0687
#define mmCB_HW_MEM_ARBITER_WR_BASE_IDX                                                                0
#define mmCB_DCC_CONFIG                                                                                0x0688
#define mmCB_DCC_CONFIG_BASE_IDX                                                                       0
#define mmGC_USER_RB_REDUNDANCY                                                                        0x06de
#define mmGC_USER_RB_REDUNDANCY_BASE_IDX                                                               0
#define mmGC_USER_RB_BACKEND_DISABLE                                                                   0x06df
#define mmGC_USER_RB_BACKEND_DISABLE_BASE_IDX                                                          0


// addressBlock: gc_ea_gceadec2
// base address: 0x9c00
#define mmGCEA_EDC_CNT                                                                                 0x0701
#define mmGCEA_EDC_CNT_BASE_IDX                                                                        0
#define mmGCEA_EDC_CNT2                                                                                0x0702
#define mmGCEA_EDC_CNT2_BASE_IDX                                                                       0
#define mmGCEA_DSM_CNTL                                                                                0x0703
#define mmGCEA_DSM_CNTL_BASE_IDX                                                                       0
#define mmGCEA_DSM_CNTLA                                                                               0x0704
#define mmGCEA_DSM_CNTLA_BASE_IDX                                                                      0
#define mmGCEA_DSM_CNTLB                                                                               0x0705
#define mmGCEA_DSM_CNTLB_BASE_IDX                                                                      0
#define mmGCEA_DSM_CNTL2                                                                               0x0706
#define mmGCEA_DSM_CNTL2_BASE_IDX                                                                      0
#define mmGCEA_DSM_CNTL2A                                                                              0x0707
#define mmGCEA_DSM_CNTL2A_BASE_IDX                                                                     0
#define mmGCEA_DSM_CNTL2B                                                                              0x0708
#define mmGCEA_DSM_CNTL2B_BASE_IDX                                                                     0
#define mmGCEA_TCC_XBR_CREDITS                                                                         0x0709
#define mmGCEA_TCC_XBR_CREDITS_BASE_IDX                                                                0
#define mmGCEA_TCC_XBR_MAXBURST                                                                        0x070a
#define mmGCEA_TCC_XBR_MAXBURST_BASE_IDX                                                               0
#define mmGCEA_PROBE_CNTL                                                                              0x070b
#define mmGCEA_PROBE_CNTL_BASE_IDX                                                                     0
#define mmGCEA_PROBE_MAP                                                                               0x070c
#define mmGCEA_PROBE_MAP_BASE_IDX                                                                      0
#define mmGCEA_ERR_STATUS                                                                              0x070d
#define mmGCEA_ERR_STATUS_BASE_IDX                                                                     0
#define mmGCEA_MISC2                                                                                   0x070e
#define mmGCEA_MISC2_BASE_IDX                                                                          0
#define mmGCEA_SDP_BACKDOOR_CMDCREDITS0                                                                0x070f
#define mmGCEA_SDP_BACKDOOR_CMDCREDITS0_BASE_IDX                                                       0
#define mmGCEA_SDP_BACKDOOR_CMDCREDITS1                                                                0x0710
#define mmGCEA_SDP_BACKDOOR_CMDCREDITS1_BASE_IDX                                                       0
#define mmGCEA_SDP_BACKDOOR_DATACREDITS0                                                               0x0711
#define mmGCEA_SDP_BACKDOOR_DATACREDITS0_BASE_IDX                                                      0
#define mmGCEA_SDP_BACKDOOR_DATACREDITS1                                                               0x0712
#define mmGCEA_SDP_BACKDOOR_DATACREDITS1_BASE_IDX                                                      0
#define mmGCEA_SDP_BACKDOOR_MISCCREDITS                                                                0x0713
#define mmGCEA_SDP_BACKDOOR_MISCCREDITS_BASE_IDX                                                       0
#define mmGCEA_SDP_ENABLE                                                                              0x0714
#define mmGCEA_SDP_ENABLE_BASE_IDX                                                                     0


// addressBlock: gc_rmi_rmidec
// base address: 0x9e00
#define mmRMI_GENERAL_CNTL                                                                             0x0780
#define mmRMI_GENERAL_CNTL_BASE_IDX                                                                    0
#define mmRMI_GENERAL_CNTL1                                                                            0x0781
#define mmRMI_GENERAL_CNTL1_BASE_IDX                                                                   0
#define mmRMI_GENERAL_STATUS                                                                           0x0782
#define mmRMI_GENERAL_STATUS_BASE_IDX                                                                  0
#define mmRMI_SUBBLOCK_STATUS0                                                                         0x0783
#define mmRMI_SUBBLOCK_STATUS0_BASE_IDX                                                                0
#define mmRMI_SUBBLOCK_STATUS1                                                                         0x0784
#define mmRMI_SUBBLOCK_STATUS1_BASE_IDX                                                                0
#define mmRMI_SUBBLOCK_STATUS2                                                                         0x0785
#define mmRMI_SUBBLOCK_STATUS2_BASE_IDX                                                                0
#define mmRMI_SUBBLOCK_STATUS3                                                                         0x0786
#define mmRMI_SUBBLOCK_STATUS3_BASE_IDX                                                                0
#define mmRMI_XBAR_CONFIG                                                                              0x0787
#define mmRMI_XBAR_CONFIG_BASE_IDX                                                                     0
#define mmRMI_PROBE_POP_LOGIC_CNTL                                                                     0x0788
#define mmRMI_PROBE_POP_LOGIC_CNTL_BASE_IDX                                                            0
#define mmRMI_UTC_XNACK_N_MISC_CNTL                                                                    0x0789
#define mmRMI_UTC_XNACK_N_MISC_CNTL_BASE_IDX                                                           0
#define mmRMI_DEMUX_CNTL                                                                               0x078a
#define mmRMI_DEMUX_CNTL_BASE_IDX                                                                      0
#define mmRMI_UTCL1_CNTL1                                                                              0x078b
#define mmRMI_UTCL1_CNTL1_BASE_IDX                                                                     0
#define mmRMI_UTCL1_CNTL2                                                                              0x078c
#define mmRMI_UTCL1_CNTL2_BASE_IDX                                                                     0
#define mmRMI_UTC_UNIT_CONFIG                                                                          0x078d
#define mmRMI_UTC_UNIT_CONFIG_BASE_IDX                                                                 0
#define mmRMI_TCIW_FORMATTER0_CNTL                                                                     0x078e
#define mmRMI_TCIW_FORMATTER0_CNTL_BASE_IDX                                                            0
#define mmRMI_TCIW_FORMATTER1_CNTL                                                                     0x078f
#define mmRMI_TCIW_FORMATTER1_CNTL_BASE_IDX                                                            0
#define mmRMI_SCOREBOARD_CNTL                                                                          0x0790
#define mmRMI_SCOREBOARD_CNTL_BASE_IDX                                                                 0
#define mmRMI_SCOREBOARD_STATUS0                                                                       0x0791
#define mmRMI_SCOREBOARD_STATUS0_BASE_IDX                                                              0
#define mmRMI_SCOREBOARD_STATUS1                                                                       0x0792
#define mmRMI_SCOREBOARD_STATUS1_BASE_IDX                                                              0
#define mmRMI_SCOREBOARD_STATUS2                                                                       0x0793
#define mmRMI_SCOREBOARD_STATUS2_BASE_IDX                                                              0
#define mmRMI_XBAR_ARBITER_CONFIG                                                                      0x0794
#define mmRMI_XBAR_ARBITER_CONFIG_BASE_IDX                                                             0
#define mmRMI_XBAR_ARBITER_CONFIG_1                                                                    0x0795
#define mmRMI_XBAR_ARBITER_CONFIG_1_BASE_IDX                                                           0
#define mmRMI_CLOCK_CNTRL                                                                              0x0796
#define mmRMI_CLOCK_CNTRL_BASE_IDX                                                                     0
#define mmRMI_UTCL1_STATUS                                                                             0x0797
#define mmRMI_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmRMI_SPARE                                                                                    0x079e
#define mmRMI_SPARE_BASE_IDX                                                                           0
#define mmRMI_SPARE_1                                                                                  0x079f
#define mmRMI_SPARE_1_BASE_IDX                                                                         0
#define mmRMI_SPARE_2                                                                                  0x07a0
#define mmRMI_SPARE_2_BASE_IDX                                                                         0


// addressBlock: gc_dbgu_gfx_dbgudec
// base address: 0x9f00
#define mmport_a_addr                                                                                  0x07c0
#define mmport_a_addr_BASE_IDX                                                                         0
#define mmport_a_data_lo                                                                               0x07c1
#define mmport_a_data_lo_BASE_IDX                                                                      0
#define mmport_a_data_hi                                                                               0x07c2
#define mmport_a_data_hi_BASE_IDX                                                                      0
#define mmport_b_addr                                                                                  0x07c3
#define mmport_b_addr_BASE_IDX                                                                         0
#define mmport_b_data_lo                                                                               0x07c4
#define mmport_b_data_lo_BASE_IDX                                                                      0
#define mmport_b_data_hi                                                                               0x07c5
#define mmport_b_data_hi_BASE_IDX                                                                      0
#define mmport_c_addr                                                                                  0x07c6
#define mmport_c_addr_BASE_IDX                                                                         0
#define mmport_c_data_lo                                                                               0x07c7
#define mmport_c_data_lo_BASE_IDX                                                                      0
#define mmport_c_data_hi                                                                               0x07c8
#define mmport_c_data_hi_BASE_IDX                                                                      0
#define mmport_d_addr                                                                                  0x07c9
#define mmport_d_addr_BASE_IDX                                                                         0
#define mmport_d_data_lo                                                                               0x07ca
#define mmport_d_data_lo_BASE_IDX                                                                      0
#define mmport_d_data_hi                                                                               0x07cb
#define mmport_d_data_hi_BASE_IDX                                                                      0


// addressBlock: gc_utcl2_atcl2dec
// base address: 0xa000
#define mmATC_L2_CNTL                                                                                  0x0800
#define mmATC_L2_CNTL_BASE_IDX                                                                         0
#define mmATC_L2_CNTL2                                                                                 0x0801
#define mmATC_L2_CNTL2_BASE_IDX                                                                        0
#define mmATC_L2_CACHE_DATA0                                                                           0x0804
#define mmATC_L2_CACHE_DATA0_BASE_IDX                                                                  0
#define mmATC_L2_CACHE_DATA1                                                                           0x0805
#define mmATC_L2_CACHE_DATA1_BASE_IDX                                                                  0
#define mmATC_L2_CACHE_DATA2                                                                           0x0806
#define mmATC_L2_CACHE_DATA2_BASE_IDX                                                                  0
#define mmATC_L2_CNTL3                                                                                 0x0807
#define mmATC_L2_CNTL3_BASE_IDX                                                                        0
#define mmATC_L2_STATUS                                                                                0x0808
#define mmATC_L2_STATUS_BASE_IDX                                                                       0
#define mmATC_L2_STATUS2                                                                               0x0809
#define mmATC_L2_STATUS2_BASE_IDX                                                                      0
#define mmATC_L2_MISC_CG                                                                               0x080a
#define mmATC_L2_MISC_CG_BASE_IDX                                                                      0
#define mmATC_L2_MEM_POWER_LS                                                                          0x080b
#define mmATC_L2_MEM_POWER_LS_BASE_IDX                                                                 0
#define mmATC_L2_CGTT_CLK_CTRL                                                                         0x080c
#define mmATC_L2_CGTT_CLK_CTRL_BASE_IDX                                                                0


// addressBlock: gc_utcl2_vml2pfdec
// base address: 0xa100
#define mmVM_L2_CNTL                                                                                   0x0840
#define mmVM_L2_CNTL_BASE_IDX                                                                          0
#define mmVM_L2_CNTL2                                                                                  0x0841
#define mmVM_L2_CNTL2_BASE_IDX                                                                         0
#define mmVM_L2_CNTL3                                                                                  0x0842
#define mmVM_L2_CNTL3_BASE_IDX                                                                         0
#define mmVM_L2_STATUS                                                                                 0x0843
#define mmVM_L2_STATUS_BASE_IDX                                                                        0
#define mmVM_DUMMY_PAGE_FAULT_CNTL                                                                     0x0844
#define mmVM_DUMMY_PAGE_FAULT_CNTL_BASE_IDX                                                            0
#define mmVM_DUMMY_PAGE_FAULT_ADDR_LO32                                                                0x0845
#define mmVM_DUMMY_PAGE_FAULT_ADDR_LO32_BASE_IDX                                                       0
#define mmVM_DUMMY_PAGE_FAULT_ADDR_HI32                                                                0x0846
#define mmVM_DUMMY_PAGE_FAULT_ADDR_HI32_BASE_IDX                                                       0
#define mmVM_L2_PROTECTION_FAULT_CNTL                                                                  0x0847
#define mmVM_L2_PROTECTION_FAULT_CNTL_BASE_IDX                                                         0
#define mmVM_L2_PROTECTION_FAULT_CNTL2                                                                 0x0848
#define mmVM_L2_PROTECTION_FAULT_CNTL2_BASE_IDX                                                        0
#define mmVM_L2_PROTECTION_FAULT_MM_CNTL3                                                              0x0849
#define mmVM_L2_PROTECTION_FAULT_MM_CNTL3_BASE_IDX                                                     0
#define mmVM_L2_PROTECTION_FAULT_MM_CNTL4                                                              0x084a
#define mmVM_L2_PROTECTION_FAULT_MM_CNTL4_BASE_IDX                                                     0
#define mmVM_L2_PROTECTION_FAULT_STATUS                                                                0x084b
#define mmVM_L2_PROTECTION_FAULT_STATUS_BASE_IDX                                                       0
#define mmVM_L2_PROTECTION_FAULT_ADDR_LO32                                                             0x084c
#define mmVM_L2_PROTECTION_FAULT_ADDR_LO32_BASE_IDX                                                    0
#define mmVM_L2_PROTECTION_FAULT_ADDR_HI32                                                             0x084d
#define mmVM_L2_PROTECTION_FAULT_ADDR_HI32_BASE_IDX                                                    0
#define mmVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32                                                     0x084e
#define mmVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32_BASE_IDX                                            0
#define mmVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32                                                     0x084f
#define mmVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32_BASE_IDX                                            0
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32                                               0x0851
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32_BASE_IDX                                      0
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32                                               0x0852
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32_BASE_IDX                                      0
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32                                              0x0853
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32_BASE_IDX                                     0
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32                                              0x0854
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32_BASE_IDX                                     0
#define mmVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32                                                  0x0855
#define mmVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32_BASE_IDX                                         0
#define mmVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32                                                  0x0856
#define mmVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32_BASE_IDX                                         0
#define mmVM_L2_CNTL4                                                                                  0x0857
#define mmVM_L2_CNTL4_BASE_IDX                                                                         0
#define mmVM_L2_MM_GROUP_RT_CLASSES                                                                    0x0858
#define mmVM_L2_MM_GROUP_RT_CLASSES_BASE_IDX                                                           0
#define mmVM_L2_BANK_SELECT_RESERVED_CID                                                               0x0859
#define mmVM_L2_BANK_SELECT_RESERVED_CID_BASE_IDX                                                      0
#define mmVM_L2_BANK_SELECT_RESERVED_CID2                                                              0x085a
#define mmVM_L2_BANK_SELECT_RESERVED_CID2_BASE_IDX                                                     0
#define mmVM_L2_CACHE_PARITY_CNTL                                                                      0x085b
#define mmVM_L2_CACHE_PARITY_CNTL_BASE_IDX                                                             0
#define mmVM_L2_CGTT_CLK_CTRL                                                                          0x085e
#define mmVM_L2_CGTT_CLK_CTRL_BASE_IDX                                                                 0


// addressBlock: gc_utcl2_vml2vcdec
// base address: 0xa200
#define mmVM_CONTEXT0_CNTL                                                                             0x0880
#define mmVM_CONTEXT0_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT1_CNTL                                                                             0x0881
#define mmVM_CONTEXT1_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT2_CNTL                                                                             0x0882
#define mmVM_CONTEXT2_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT3_CNTL                                                                             0x0883
#define mmVM_CONTEXT3_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT4_CNTL                                                                             0x0884
#define mmVM_CONTEXT4_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT5_CNTL                                                                             0x0885
#define mmVM_CONTEXT5_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT6_CNTL                                                                             0x0886
#define mmVM_CONTEXT6_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT7_CNTL                                                                             0x0887
#define mmVM_CONTEXT7_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT8_CNTL                                                                             0x0888
#define mmVM_CONTEXT8_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT9_CNTL                                                                             0x0889
#define mmVM_CONTEXT9_CNTL_BASE_IDX                                                                    0
#define mmVM_CONTEXT10_CNTL                                                                            0x088a
#define mmVM_CONTEXT10_CNTL_BASE_IDX                                                                   0
#define mmVM_CONTEXT11_CNTL                                                                            0x088b
#define mmVM_CONTEXT11_CNTL_BASE_IDX                                                                   0
#define mmVM_CONTEXT12_CNTL                                                                            0x088c
#define mmVM_CONTEXT12_CNTL_BASE_IDX                                                                   0
#define mmVM_CONTEXT13_CNTL                                                                            0x088d
#define mmVM_CONTEXT13_CNTL_BASE_IDX                                                                   0
#define mmVM_CONTEXT14_CNTL                                                                            0x088e
#define mmVM_CONTEXT14_CNTL_BASE_IDX                                                                   0
#define mmVM_CONTEXT15_CNTL                                                                            0x088f
#define mmVM_CONTEXT15_CNTL_BASE_IDX                                                                   0
#define mmVM_CONTEXTS_DISABLE                                                                          0x0890
#define mmVM_CONTEXTS_DISABLE_BASE_IDX                                                                 0
#define mmVM_INVALIDATE_ENG0_SEM                                                                       0x0891
#define mmVM_INVALIDATE_ENG0_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG1_SEM                                                                       0x0892
#define mmVM_INVALIDATE_ENG1_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG2_SEM                                                                       0x0893
#define mmVM_INVALIDATE_ENG2_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG3_SEM                                                                       0x0894
#define mmVM_INVALIDATE_ENG3_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG4_SEM                                                                       0x0895
#define mmVM_INVALIDATE_ENG4_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG5_SEM                                                                       0x0896
#define mmVM_INVALIDATE_ENG5_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG6_SEM                                                                       0x0897
#define mmVM_INVALIDATE_ENG6_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG7_SEM                                                                       0x0898
#define mmVM_INVALIDATE_ENG7_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG8_SEM                                                                       0x0899
#define mmVM_INVALIDATE_ENG8_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG9_SEM                                                                       0x089a
#define mmVM_INVALIDATE_ENG9_SEM_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG10_SEM                                                                      0x089b
#define mmVM_INVALIDATE_ENG10_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG11_SEM                                                                      0x089c
#define mmVM_INVALIDATE_ENG11_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG12_SEM                                                                      0x089d
#define mmVM_INVALIDATE_ENG12_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG13_SEM                                                                      0x089e
#define mmVM_INVALIDATE_ENG13_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG14_SEM                                                                      0x089f
#define mmVM_INVALIDATE_ENG14_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG15_SEM                                                                      0x08a0
#define mmVM_INVALIDATE_ENG15_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG16_SEM                                                                      0x08a1
#define mmVM_INVALIDATE_ENG16_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG17_SEM                                                                      0x08a2
#define mmVM_INVALIDATE_ENG17_SEM_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG0_REQ                                                                       0x08a3
#define mmVM_INVALIDATE_ENG0_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG1_REQ                                                                       0x08a4
#define mmVM_INVALIDATE_ENG1_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG2_REQ                                                                       0x08a5
#define mmVM_INVALIDATE_ENG2_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG3_REQ                                                                       0x08a6
#define mmVM_INVALIDATE_ENG3_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG4_REQ                                                                       0x08a7
#define mmVM_INVALIDATE_ENG4_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG5_REQ                                                                       0x08a8
#define mmVM_INVALIDATE_ENG5_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG6_REQ                                                                       0x08a9
#define mmVM_INVALIDATE_ENG6_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG7_REQ                                                                       0x08aa
#define mmVM_INVALIDATE_ENG7_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG8_REQ                                                                       0x08ab
#define mmVM_INVALIDATE_ENG8_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG9_REQ                                                                       0x08ac
#define mmVM_INVALIDATE_ENG9_REQ_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG10_REQ                                                                      0x08ad
#define mmVM_INVALIDATE_ENG10_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG11_REQ                                                                      0x08ae
#define mmVM_INVALIDATE_ENG11_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG12_REQ                                                                      0x08af
#define mmVM_INVALIDATE_ENG12_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG13_REQ                                                                      0x08b0
#define mmVM_INVALIDATE_ENG13_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG14_REQ                                                                      0x08b1
#define mmVM_INVALIDATE_ENG14_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG15_REQ                                                                      0x08b2
#define mmVM_INVALIDATE_ENG15_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG16_REQ                                                                      0x08b3
#define mmVM_INVALIDATE_ENG16_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG17_REQ                                                                      0x08b4
#define mmVM_INVALIDATE_ENG17_REQ_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG0_ACK                                                                       0x08b5
#define mmVM_INVALIDATE_ENG0_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG1_ACK                                                                       0x08b6
#define mmVM_INVALIDATE_ENG1_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG2_ACK                                                                       0x08b7
#define mmVM_INVALIDATE_ENG2_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG3_ACK                                                                       0x08b8
#define mmVM_INVALIDATE_ENG3_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG4_ACK                                                                       0x08b9
#define mmVM_INVALIDATE_ENG4_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG5_ACK                                                                       0x08ba
#define mmVM_INVALIDATE_ENG5_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG6_ACK                                                                       0x08bb
#define mmVM_INVALIDATE_ENG6_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG7_ACK                                                                       0x08bc
#define mmVM_INVALIDATE_ENG7_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG8_ACK                                                                       0x08bd
#define mmVM_INVALIDATE_ENG8_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG9_ACK                                                                       0x08be
#define mmVM_INVALIDATE_ENG9_ACK_BASE_IDX                                                              0
#define mmVM_INVALIDATE_ENG10_ACK                                                                      0x08bf
#define mmVM_INVALIDATE_ENG10_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG11_ACK                                                                      0x08c0
#define mmVM_INVALIDATE_ENG11_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG12_ACK                                                                      0x08c1
#define mmVM_INVALIDATE_ENG12_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG13_ACK                                                                      0x08c2
#define mmVM_INVALIDATE_ENG13_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG14_ACK                                                                      0x08c3
#define mmVM_INVALIDATE_ENG14_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG15_ACK                                                                      0x08c4
#define mmVM_INVALIDATE_ENG15_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG16_ACK                                                                      0x08c5
#define mmVM_INVALIDATE_ENG16_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG17_ACK                                                                      0x08c6
#define mmVM_INVALIDATE_ENG17_ACK_BASE_IDX                                                             0
#define mmVM_INVALIDATE_ENG0_ADDR_RANGE_LO32                                                           0x08c7
#define mmVM_INVALIDATE_ENG0_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG0_ADDR_RANGE_HI32                                                           0x08c8
#define mmVM_INVALIDATE_ENG0_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG1_ADDR_RANGE_LO32                                                           0x08c9
#define mmVM_INVALIDATE_ENG1_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG1_ADDR_RANGE_HI32                                                           0x08ca
#define mmVM_INVALIDATE_ENG1_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG2_ADDR_RANGE_LO32                                                           0x08cb
#define mmVM_INVALIDATE_ENG2_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG2_ADDR_RANGE_HI32                                                           0x08cc
#define mmVM_INVALIDATE_ENG2_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG3_ADDR_RANGE_LO32                                                           0x08cd
#define mmVM_INVALIDATE_ENG3_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG3_ADDR_RANGE_HI32                                                           0x08ce
#define mmVM_INVALIDATE_ENG3_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG4_ADDR_RANGE_LO32                                                           0x08cf
#define mmVM_INVALIDATE_ENG4_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG4_ADDR_RANGE_HI32                                                           0x08d0
#define mmVM_INVALIDATE_ENG4_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG5_ADDR_RANGE_LO32                                                           0x08d1
#define mmVM_INVALIDATE_ENG5_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG5_ADDR_RANGE_HI32                                                           0x08d2
#define mmVM_INVALIDATE_ENG5_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG6_ADDR_RANGE_LO32                                                           0x08d3
#define mmVM_INVALIDATE_ENG6_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG6_ADDR_RANGE_HI32                                                           0x08d4
#define mmVM_INVALIDATE_ENG6_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG7_ADDR_RANGE_LO32                                                           0x08d5
#define mmVM_INVALIDATE_ENG7_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG7_ADDR_RANGE_HI32                                                           0x08d6
#define mmVM_INVALIDATE_ENG7_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG8_ADDR_RANGE_LO32                                                           0x08d7
#define mmVM_INVALIDATE_ENG8_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG8_ADDR_RANGE_HI32                                                           0x08d8
#define mmVM_INVALIDATE_ENG8_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG9_ADDR_RANGE_LO32                                                           0x08d9
#define mmVM_INVALIDATE_ENG9_ADDR_RANGE_LO32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG9_ADDR_RANGE_HI32                                                           0x08da
#define mmVM_INVALIDATE_ENG9_ADDR_RANGE_HI32_BASE_IDX                                                  0
#define mmVM_INVALIDATE_ENG10_ADDR_RANGE_LO32                                                          0x08db
#define mmVM_INVALIDATE_ENG10_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG10_ADDR_RANGE_HI32                                                          0x08dc
#define mmVM_INVALIDATE_ENG10_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG11_ADDR_RANGE_LO32                                                          0x08dd
#define mmVM_INVALIDATE_ENG11_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG11_ADDR_RANGE_HI32                                                          0x08de
#define mmVM_INVALIDATE_ENG11_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG12_ADDR_RANGE_LO32                                                          0x08df
#define mmVM_INVALIDATE_ENG12_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG12_ADDR_RANGE_HI32                                                          0x08e0
#define mmVM_INVALIDATE_ENG12_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG13_ADDR_RANGE_LO32                                                          0x08e1
#define mmVM_INVALIDATE_ENG13_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG13_ADDR_RANGE_HI32                                                          0x08e2
#define mmVM_INVALIDATE_ENG13_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG14_ADDR_RANGE_LO32                                                          0x08e3
#define mmVM_INVALIDATE_ENG14_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG14_ADDR_RANGE_HI32                                                          0x08e4
#define mmVM_INVALIDATE_ENG14_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG15_ADDR_RANGE_LO32                                                          0x08e5
#define mmVM_INVALIDATE_ENG15_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG15_ADDR_RANGE_HI32                                                          0x08e6
#define mmVM_INVALIDATE_ENG15_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG16_ADDR_RANGE_LO32                                                          0x08e7
#define mmVM_INVALIDATE_ENG16_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG16_ADDR_RANGE_HI32                                                          0x08e8
#define mmVM_INVALIDATE_ENG16_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG17_ADDR_RANGE_LO32                                                          0x08e9
#define mmVM_INVALIDATE_ENG17_ADDR_RANGE_LO32_BASE_IDX                                                 0
#define mmVM_INVALIDATE_ENG17_ADDR_RANGE_HI32                                                          0x08ea
#define mmVM_INVALIDATE_ENG17_ADDR_RANGE_HI32_BASE_IDX                                                 0
#define mmVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08eb
#define mmVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08ec
#define mmVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08ed
#define mmVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08ee
#define mmVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08ef
#define mmVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08f0
#define mmVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08f1
#define mmVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08f2
#define mmVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08f3
#define mmVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08f4
#define mmVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08f5
#define mmVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08f6
#define mmVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08f7
#define mmVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08f8
#define mmVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08f9
#define mmVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08fa
#define mmVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08fb
#define mmVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08fc
#define mmVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                        0x08fd
#define mmVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                        0x08fe
#define mmVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                       0x08ff
#define mmVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                       0x0900
#define mmVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                       0x0901
#define mmVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                       0x0902
#define mmVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                       0x0903
#define mmVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                       0x0904
#define mmVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                       0x0905
#define mmVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                       0x0906
#define mmVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                       0x0907
#define mmVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                       0x0908
#define mmVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                       0x0909
#define mmVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                       0x090a
#define mmVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                       0x090b
#define mmVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                       0x090c
#define mmVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                       0x090d
#define mmVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                       0x090e
#define mmVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                       0x090f
#define mmVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                       0x0910
#define mmVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                       0x0911
#define mmVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                       0x0912
#define mmVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                       0x0913
#define mmVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                       0x0914
#define mmVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                       0x0915
#define mmVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                       0x0916
#define mmVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                       0x0917
#define mmVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                       0x0918
#define mmVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                       0x0919
#define mmVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                       0x091a
#define mmVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                       0x091b
#define mmVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                       0x091c
#define mmVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                       0x091d
#define mmVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                              0
#define mmVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                       0x091e
#define mmVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                              0
#define mmVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                      0x091f
#define mmVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define mmVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                      0x0920
#define mmVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define mmVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                      0x0921
#define mmVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define mmVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                      0x0922
#define mmVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define mmVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                      0x0923
#define mmVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define mmVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                      0x0924
#define mmVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define mmVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                      0x0925
#define mmVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define mmVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                      0x0926
#define mmVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define mmVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                      0x0927
#define mmVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define mmVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                      0x0928
#define mmVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define mmVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                      0x0929
#define mmVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                             0
#define mmVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                      0x092a
#define mmVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                             0
#define mmVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                         0x092b
#define mmVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                         0x092c
#define mmVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                         0x092d
#define mmVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                         0x092e
#define mmVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                         0x092f
#define mmVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                         0x0930
#define mmVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                         0x0931
#define mmVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                         0x0932
#define mmVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                         0x0933
#define mmVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                         0x0934
#define mmVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                         0x0935
#define mmVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                         0x0936
#define mmVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                         0x0937
#define mmVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                         0x0938
#define mmVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                         0x0939
#define mmVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                         0x093a
#define mmVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                         0x093b
#define mmVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                         0x093c
#define mmVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                         0x093d
#define mmVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                                0
#define mmVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                         0x093e
#define mmVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                                0
#define mmVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                        0x093f
#define mmVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                        0x0940
#define mmVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                        0x0941
#define mmVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                        0x0942
#define mmVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                        0x0943
#define mmVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                        0x0944
#define mmVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                        0x0945
#define mmVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                        0x0946
#define mmVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                        0x0947
#define mmVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                        0x0948
#define mmVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0
#define mmVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                        0x0949
#define mmVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                               0
#define mmVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                        0x094a
#define mmVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                               0


// addressBlock: gc_utcl2_vmsharedpfdec
// base address: 0xa590
#define mmMC_VM_NB_MMIOBASE                                                                            0x0964
#define mmMC_VM_NB_MMIOBASE_BASE_IDX                                                                   0
#define mmMC_VM_NB_MMIOLIMIT                                                                           0x0965
#define mmMC_VM_NB_MMIOLIMIT_BASE_IDX                                                                  0
#define mmMC_VM_NB_PCI_CTRL                                                                            0x0966
#define mmMC_VM_NB_PCI_CTRL_BASE_IDX                                                                   0
#define mmMC_VM_NB_PCI_ARB                                                                             0x0967
#define mmMC_VM_NB_PCI_ARB_BASE_IDX                                                                    0
#define mmMC_VM_NB_TOP_OF_DRAM_SLOT1                                                                   0x0968
#define mmMC_VM_NB_TOP_OF_DRAM_SLOT1_BASE_IDX                                                          0
#define mmMC_VM_NB_LOWER_TOP_OF_DRAM2                                                                  0x0969
#define mmMC_VM_NB_LOWER_TOP_OF_DRAM2_BASE_IDX                                                         0
#define mmMC_VM_NB_UPPER_TOP_OF_DRAM2                                                                  0x096a
#define mmMC_VM_NB_UPPER_TOP_OF_DRAM2_BASE_IDX                                                         0
#define mmMC_VM_FB_OFFSET                                                                              0x096b
#define mmMC_VM_FB_OFFSET_BASE_IDX                                                                     0
#define mmMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB                                                       0x096c
#define mmMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB_BASE_IDX                                              0
#define mmMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB                                                       0x096d
#define mmMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB_BASE_IDX                                              0
#define mmMC_VM_STEERING                                                                               0x096e
#define mmMC_VM_STEERING_BASE_IDX                                                                      0
#define mmMC_SHARED_VIRT_RESET_REQ                                                                     0x096f
#define mmMC_SHARED_VIRT_RESET_REQ_BASE_IDX                                                            0
#define mmMC_MEM_POWER_LS                                                                              0x0970
#define mmMC_MEM_POWER_LS_BASE_IDX                                                                     0
#define mmMC_VM_CACHEABLE_DRAM_ADDRESS_START                                                           0x0971
#define mmMC_VM_CACHEABLE_DRAM_ADDRESS_START_BASE_IDX                                                  0
#define mmMC_VM_CACHEABLE_DRAM_ADDRESS_END                                                             0x0972
#define mmMC_VM_CACHEABLE_DRAM_ADDRESS_END_BASE_IDX                                                    0
#define mmMC_VM_APT_CNTL                                                                               0x0973
#define mmMC_VM_APT_CNTL_BASE_IDX                                                                      0
#define mmMC_VM_LOCAL_HBM_ADDRESS_START                                                                0x0974
#define mmMC_VM_LOCAL_HBM_ADDRESS_START_BASE_IDX                                                       0
#define mmMC_VM_LOCAL_HBM_ADDRESS_END                                                                  0x0975
#define mmMC_VM_LOCAL_HBM_ADDRESS_END_BASE_IDX                                                         0
#define mmMC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL                                                            0x0976
#define mmMC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL_BASE_IDX                                                   0


// addressBlock: gc_utcl2_vmsharedvcdec
// base address: 0xa600
#define mmMC_VM_FB_LOCATION_BASE                                                                       0x0980
#define mmMC_VM_FB_LOCATION_BASE_BASE_IDX                                                              0
#define mmMC_VM_FB_LOCATION_TOP                                                                        0x0981
#define mmMC_VM_FB_LOCATION_TOP_BASE_IDX                                                               0
#define mmMC_VM_AGP_TOP                                                                                0x0982
#define mmMC_VM_AGP_TOP_BASE_IDX                                                                       0
#define mmMC_VM_AGP_BOT                                                                                0x0983
#define mmMC_VM_AGP_BOT_BASE_IDX                                                                       0
#define mmMC_VM_AGP_BASE                                                                               0x0984
#define mmMC_VM_AGP_BASE_BASE_IDX                                                                      0
#define mmMC_VM_SYSTEM_APERTURE_LOW_ADDR                                                               0x0985
#define mmMC_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                                      0
#define mmMC_VM_SYSTEM_APERTURE_HIGH_ADDR                                                              0x0986
#define mmMC_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                                     0
#define mmMC_VM_MX_L1_TLB_CNTL                                                                         0x0987
#define mmMC_VM_MX_L1_TLB_CNTL_BASE_IDX                                                                0


// addressBlock: gc_ea_gceadec
// base address: 0xa800
#define mmGCEA_DRAM_RD_CLI2GRP_MAP0                                                                    0x0a00
#define mmGCEA_DRAM_RD_CLI2GRP_MAP0_BASE_IDX                                                           0
#define mmGCEA_DRAM_RD_CLI2GRP_MAP1                                                                    0x0a01
#define mmGCEA_DRAM_RD_CLI2GRP_MAP1_BASE_IDX                                                           0
#define mmGCEA_DRAM_WR_CLI2GRP_MAP0                                                                    0x0a02
#define mmGCEA_DRAM_WR_CLI2GRP_MAP0_BASE_IDX                                                           0
#define mmGCEA_DRAM_WR_CLI2GRP_MAP1                                                                    0x0a03
#define mmGCEA_DRAM_WR_CLI2GRP_MAP1_BASE_IDX                                                           0
#define mmGCEA_DRAM_RD_GRP2VC_MAP                                                                      0x0a04
#define mmGCEA_DRAM_RD_GRP2VC_MAP_BASE_IDX                                                             0
#define mmGCEA_DRAM_WR_GRP2VC_MAP                                                                      0x0a05
#define mmGCEA_DRAM_WR_GRP2VC_MAP_BASE_IDX                                                             0
#define mmGCEA_DRAM_RD_LAZY                                                                            0x0a06
#define mmGCEA_DRAM_RD_LAZY_BASE_IDX                                                                   0
#define mmGCEA_DRAM_WR_LAZY                                                                            0x0a07
#define mmGCEA_DRAM_WR_LAZY_BASE_IDX                                                                   0
#define mmGCEA_DRAM_RD_CAM_CNTL                                                                        0x0a08
#define mmGCEA_DRAM_RD_CAM_CNTL_BASE_IDX                                                               0
#define mmGCEA_DRAM_WR_CAM_CNTL                                                                        0x0a09
#define mmGCEA_DRAM_WR_CAM_CNTL_BASE_IDX                                                               0
#define mmGCEA_DRAM_PAGE_BURST                                                                         0x0a0a
#define mmGCEA_DRAM_PAGE_BURST_BASE_IDX                                                                0
#define mmGCEA_DRAM_RD_PRI_AGE                                                                         0x0a0b
#define mmGCEA_DRAM_RD_PRI_AGE_BASE_IDX                                                                0
#define mmGCEA_DRAM_WR_PRI_AGE                                                                         0x0a0c
#define mmGCEA_DRAM_WR_PRI_AGE_BASE_IDX                                                                0
#define mmGCEA_DRAM_RD_PRI_QUEUING                                                                     0x0a0d
#define mmGCEA_DRAM_RD_PRI_QUEUING_BASE_IDX                                                            0
#define mmGCEA_DRAM_WR_PRI_QUEUING                                                                     0x0a0e
#define mmGCEA_DRAM_WR_PRI_QUEUING_BASE_IDX                                                            0
#define mmGCEA_DRAM_RD_PRI_FIXED                                                                       0x0a0f
#define mmGCEA_DRAM_RD_PRI_FIXED_BASE_IDX                                                              0
#define mmGCEA_DRAM_WR_PRI_FIXED                                                                       0x0a10
#define mmGCEA_DRAM_WR_PRI_FIXED_BASE_IDX                                                              0
#define mmGCEA_DRAM_RD_PRI_URGENCY                                                                     0x0a11
#define mmGCEA_DRAM_RD_PRI_URGENCY_BASE_IDX                                                            0
#define mmGCEA_DRAM_WR_PRI_URGENCY                                                                     0x0a12
#define mmGCEA_DRAM_WR_PRI_URGENCY_BASE_IDX                                                            0
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI1                                                                  0x0a13
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI1_BASE_IDX                                                         0
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI2                                                                  0x0a14
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI2_BASE_IDX                                                         0
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI3                                                                  0x0a15
#define mmGCEA_DRAM_RD_PRI_QUANT_PRI3_BASE_IDX                                                         0
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI1                                                                  0x0a16
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI1_BASE_IDX                                                         0
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI2                                                                  0x0a17
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI2_BASE_IDX                                                         0
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI3                                                                  0x0a18
#define mmGCEA_DRAM_WR_PRI_QUANT_PRI3_BASE_IDX                                                         0
#define mmGCEA_ADDRNORM_BASE_ADDR0                                                                     0x0a32
#define mmGCEA_ADDRNORM_BASE_ADDR0_BASE_IDX                                                            0
#define mmGCEA_ADDRNORM_LIMIT_ADDR0                                                                    0x0a33
#define mmGCEA_ADDRNORM_LIMIT_ADDR0_BASE_IDX                                                           0
#define mmGCEA_ADDRNORM_BASE_ADDR1                                                                     0x0a34
#define mmGCEA_ADDRNORM_BASE_ADDR1_BASE_IDX                                                            0
#define mmGCEA_ADDRNORM_LIMIT_ADDR1                                                                    0x0a35
#define mmGCEA_ADDRNORM_LIMIT_ADDR1_BASE_IDX                                                           0
#define mmGCEA_ADDRNORM_OFFSET_ADDR1                                                                   0x0a36
#define mmGCEA_ADDRNORM_OFFSET_ADDR1_BASE_IDX                                                          0
#define mmGCEA_ADDRNORM_HOLE_CNTL                                                                      0x0a41
#define mmGCEA_ADDRNORM_HOLE_CNTL_BASE_IDX                                                             0
#define mmGCEA_ADDRDEC_BANK_CFG                                                                        0x0a42
#define mmGCEA_ADDRDEC_BANK_CFG_BASE_IDX                                                               0
#define mmGCEA_ADDRDEC_MISC_CFG                                                                        0x0a43
#define mmGCEA_ADDRDEC_MISC_CFG_BASE_IDX                                                               0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK0                                                             0x0a44
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK0_BASE_IDX                                                    0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK1                                                             0x0a45
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK1_BASE_IDX                                                    0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK2                                                             0x0a46
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK2_BASE_IDX                                                    0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK3                                                             0x0a47
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK3_BASE_IDX                                                    0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK4                                                             0x0a48
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_BANK4_BASE_IDX                                                    0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_PC                                                                0x0a49
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_PC_BASE_IDX                                                       0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_PC2                                                               0x0a4a
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_PC2_BASE_IDX                                                      0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_CS0                                                               0x0a4b
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_CS0_BASE_IDX                                                      0
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_CS1                                                               0x0a4c
#define mmGCEA_ADDRDECDRAM_ADDR_HASH_CS1_BASE_IDX                                                      0
#define mmGCEA_ADDRDECDRAM_HARVEST_ENABLE                                                              0x0a4d
#define mmGCEA_ADDRDECDRAM_HARVEST_ENABLE_BASE_IDX                                                     0
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS0                                                                  0x0a58
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS0_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS1                                                                  0x0a59
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS1_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS2                                                                  0x0a5a
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS2_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS3                                                                  0x0a5b
#define mmGCEA_ADDRDEC0_BASE_ADDR_CS3_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS0                                                               0x0a5c
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS0_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS1                                                               0x0a5d
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS1_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS2                                                               0x0a5e
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS2_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS3                                                               0x0a5f
#define mmGCEA_ADDRDEC0_BASE_ADDR_SECCS3_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC0_ADDR_MASK_CS01                                                                 0x0a60
#define mmGCEA_ADDRDEC0_ADDR_MASK_CS01_BASE_IDX                                                        0
#define mmGCEA_ADDRDEC0_ADDR_MASK_CS23                                                                 0x0a61
#define mmGCEA_ADDRDEC0_ADDR_MASK_CS23_BASE_IDX                                                        0
#define mmGCEA_ADDRDEC0_ADDR_MASK_SECCS01                                                              0x0a62
#define mmGCEA_ADDRDEC0_ADDR_MASK_SECCS01_BASE_IDX                                                     0
#define mmGCEA_ADDRDEC0_ADDR_MASK_SECCS23                                                              0x0a63
#define mmGCEA_ADDRDEC0_ADDR_MASK_SECCS23_BASE_IDX                                                     0
#define mmGCEA_ADDRDEC0_ADDR_CFG_CS01                                                                  0x0a64
#define mmGCEA_ADDRDEC0_ADDR_CFG_CS01_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_ADDR_CFG_CS23                                                                  0x0a65
#define mmGCEA_ADDRDEC0_ADDR_CFG_CS23_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_ADDR_SEL_CS01                                                                  0x0a66
#define mmGCEA_ADDRDEC0_ADDR_SEL_CS01_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_ADDR_SEL_CS23                                                                  0x0a67
#define mmGCEA_ADDRDEC0_ADDR_SEL_CS23_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC0_COL_SEL_LO_CS01                                                                0x0a68
#define mmGCEA_ADDRDEC0_COL_SEL_LO_CS01_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC0_COL_SEL_LO_CS23                                                                0x0a69
#define mmGCEA_ADDRDEC0_COL_SEL_LO_CS23_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC0_COL_SEL_HI_CS01                                                                0x0a6a
#define mmGCEA_ADDRDEC0_COL_SEL_HI_CS01_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC0_COL_SEL_HI_CS23                                                                0x0a6b
#define mmGCEA_ADDRDEC0_COL_SEL_HI_CS23_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC0_RM_SEL_CS01                                                                    0x0a6c
#define mmGCEA_ADDRDEC0_RM_SEL_CS01_BASE_IDX                                                           0
#define mmGCEA_ADDRDEC0_RM_SEL_CS23                                                                    0x0a6d
#define mmGCEA_ADDRDEC0_RM_SEL_CS23_BASE_IDX                                                           0
#define mmGCEA_ADDRDEC0_RM_SEL_SECCS01                                                                 0x0a6e
#define mmGCEA_ADDRDEC0_RM_SEL_SECCS01_BASE_IDX                                                        0
#define mmGCEA_ADDRDEC0_RM_SEL_SECCS23                                                                 0x0a6f
#define mmGCEA_ADDRDEC0_RM_SEL_SECCS23_BASE_IDX                                                        0
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS0                                                                  0x0a70
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS0_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS1                                                                  0x0a71
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS1_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS2                                                                  0x0a72
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS2_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS3                                                                  0x0a73
#define mmGCEA_ADDRDEC1_BASE_ADDR_CS3_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS0                                                               0x0a74
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS0_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS1                                                               0x0a75
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS1_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS2                                                               0x0a76
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS2_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS3                                                               0x0a77
#define mmGCEA_ADDRDEC1_BASE_ADDR_SECCS3_BASE_IDX                                                      0
#define mmGCEA_ADDRDEC1_ADDR_MASK_CS01                                                                 0x0a78
#define mmGCEA_ADDRDEC1_ADDR_MASK_CS01_BASE_IDX                                                        0
#define mmGCEA_ADDRDEC1_ADDR_MASK_CS23                                                                 0x0a79
#define mmGCEA_ADDRDEC1_ADDR_MASK_CS23_BASE_IDX                                                        0
#define mmGCEA_ADDRDEC1_ADDR_MASK_SECCS01                                                              0x0a7a
#define mmGCEA_ADDRDEC1_ADDR_MASK_SECCS01_BASE_IDX                                                     0
#define mmGCEA_ADDRDEC1_ADDR_MASK_SECCS23                                                              0x0a7b
#define mmGCEA_ADDRDEC1_ADDR_MASK_SECCS23_BASE_IDX                                                     0
#define mmGCEA_ADDRDEC1_ADDR_CFG_CS01                                                                  0x0a7c
#define mmGCEA_ADDRDEC1_ADDR_CFG_CS01_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_ADDR_CFG_CS23                                                                  0x0a7d
#define mmGCEA_ADDRDEC1_ADDR_CFG_CS23_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_ADDR_SEL_CS01                                                                  0x0a7e
#define mmGCEA_ADDRDEC1_ADDR_SEL_CS01_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_ADDR_SEL_CS23                                                                  0x0a7f
#define mmGCEA_ADDRDEC1_ADDR_SEL_CS23_BASE_IDX                                                         0
#define mmGCEA_ADDRDEC1_COL_SEL_LO_CS01                                                                0x0a80
#define mmGCEA_ADDRDEC1_COL_SEL_LO_CS01_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC1_COL_SEL_LO_CS23                                                                0x0a81
#define mmGCEA_ADDRDEC1_COL_SEL_LO_CS23_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC1_COL_SEL_HI_CS01                                                                0x0a82
#define mmGCEA_ADDRDEC1_COL_SEL_HI_CS01_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC1_COL_SEL_HI_CS23                                                                0x0a83
#define mmGCEA_ADDRDEC1_COL_SEL_HI_CS23_BASE_IDX                                                       0
#define mmGCEA_ADDRDEC1_RM_SEL_CS01                                                                    0x0a84
#define mmGCEA_ADDRDEC1_RM_SEL_CS01_BASE_IDX                                                           0
#define mmGCEA_ADDRDEC1_RM_SEL_CS23                                                                    0x0a85
#define mmGCEA_ADDRDEC1_RM_SEL_CS23_BASE_IDX                                                           0
#define mmGCEA_ADDRDEC1_RM_SEL_SECCS01                                                                 0x0a86
#define mmGCEA_ADDRDEC1_RM_SEL_SECCS01_BASE_IDX                                                        0
#define mmGCEA_ADDRDEC1_RM_SEL_SECCS23                                                                 0x0a87
#define mmGCEA_ADDRDEC1_RM_SEL_SECCS23_BASE_IDX                                                        0
#define mmGCEA_IO_RD_CLI2GRP_MAP0                                                                      0x0ad0
#define mmGCEA_IO_RD_CLI2GRP_MAP0_BASE_IDX                                                             0
#define mmGCEA_IO_RD_CLI2GRP_MAP1                                                                      0x0ad1
#define mmGCEA_IO_RD_CLI2GRP_MAP1_BASE_IDX                                                             0
#define mmGCEA_IO_WR_CLI2GRP_MAP0                                                                      0x0ad2
#define mmGCEA_IO_WR_CLI2GRP_MAP0_BASE_IDX                                                             0
#define mmGCEA_IO_WR_CLI2GRP_MAP1                                                                      0x0ad3
#define mmGCEA_IO_WR_CLI2GRP_MAP1_BASE_IDX                                                             0
#define mmGCEA_IO_RD_COMBINE_FLUSH                                                                     0x0ad4
#define mmGCEA_IO_RD_COMBINE_FLUSH_BASE_IDX                                                            0
#define mmGCEA_IO_WR_COMBINE_FLUSH                                                                     0x0ad5
#define mmGCEA_IO_WR_COMBINE_FLUSH_BASE_IDX                                                            0
#define mmGCEA_IO_GROUP_BURST                                                                          0x0ad6
#define mmGCEA_IO_GROUP_BURST_BASE_IDX                                                                 0
#define mmGCEA_IO_RD_PRI_AGE                                                                           0x0ad7
#define mmGCEA_IO_RD_PRI_AGE_BASE_IDX                                                                  0
#define mmGCEA_IO_WR_PRI_AGE                                                                           0x0ad8
#define mmGCEA_IO_WR_PRI_AGE_BASE_IDX                                                                  0
#define mmGCEA_IO_RD_PRI_QUEUING                                                                       0x0ad9
#define mmGCEA_IO_RD_PRI_QUEUING_BASE_IDX                                                              0
#define mmGCEA_IO_WR_PRI_QUEUING                                                                       0x0ada
#define mmGCEA_IO_WR_PRI_QUEUING_BASE_IDX                                                              0
#define mmGCEA_IO_RD_PRI_FIXED                                                                         0x0adb
#define mmGCEA_IO_RD_PRI_FIXED_BASE_IDX                                                                0
#define mmGCEA_IO_WR_PRI_FIXED                                                                         0x0adc
#define mmGCEA_IO_WR_PRI_FIXED_BASE_IDX                                                                0
#define mmGCEA_IO_RD_PRI_URGENCY                                                                       0x0add
#define mmGCEA_IO_RD_PRI_URGENCY_BASE_IDX                                                              0
#define mmGCEA_IO_WR_PRI_URGENCY                                                                       0x0ade
#define mmGCEA_IO_WR_PRI_URGENCY_BASE_IDX                                                              0
#define mmGCEA_IO_RD_PRI_URGENCY_MASK                                                                  0x0adf
#define mmGCEA_IO_RD_PRI_URGENCY_MASK_BASE_IDX                                                         0
#define mmGCEA_IO_WR_PRI_URGENCY_MASK                                                                  0x0ae0
#define mmGCEA_IO_WR_PRI_URGENCY_MASK_BASE_IDX                                                         0
#define mmGCEA_IO_RD_PRI_QUANT_PRI1                                                                    0x0ae1
#define mmGCEA_IO_RD_PRI_QUANT_PRI1_BASE_IDX                                                           0
#define mmGCEA_IO_RD_PRI_QUANT_PRI2                                                                    0x0ae2
#define mmGCEA_IO_RD_PRI_QUANT_PRI2_BASE_IDX                                                           0
#define mmGCEA_IO_RD_PRI_QUANT_PRI3                                                                    0x0ae3
#define mmGCEA_IO_RD_PRI_QUANT_PRI3_BASE_IDX                                                           0
#define mmGCEA_IO_WR_PRI_QUANT_PRI1                                                                    0x0ae4
#define mmGCEA_IO_WR_PRI_QUANT_PRI1_BASE_IDX                                                           0
#define mmGCEA_IO_WR_PRI_QUANT_PRI2                                                                    0x0ae5
#define mmGCEA_IO_WR_PRI_QUANT_PRI2_BASE_IDX                                                           0
#define mmGCEA_IO_WR_PRI_QUANT_PRI3                                                                    0x0ae6
#define mmGCEA_IO_WR_PRI_QUANT_PRI3_BASE_IDX                                                           0
#define mmGCEA_SDP_ARB_DRAM                                                                            0x0ae7
#define mmGCEA_SDP_ARB_DRAM_BASE_IDX                                                                   0
#define mmGCEA_SDP_ARB_FINAL                                                                           0x0ae9
#define mmGCEA_SDP_ARB_FINAL_BASE_IDX                                                                  0
#define mmGCEA_SDP_DRAM_PRIORITY                                                                       0x0aea
#define mmGCEA_SDP_DRAM_PRIORITY_BASE_IDX                                                              0
#define mmGCEA_SDP_IO_PRIORITY                                                                         0x0aec
#define mmGCEA_SDP_IO_PRIORITY_BASE_IDX                                                                0
#define mmGCEA_SDP_CREDITS                                                                             0x0aed
#define mmGCEA_SDP_CREDITS_BASE_IDX                                                                    0
#define mmGCEA_SDP_TAG_RESERVE0                                                                        0x0aee
#define mmGCEA_SDP_TAG_RESERVE0_BASE_IDX                                                               0
#define mmGCEA_SDP_TAG_RESERVE1                                                                        0x0aef
#define mmGCEA_SDP_TAG_RESERVE1_BASE_IDX                                                               0
#define mmGCEA_SDP_VCC_RESERVE0                                                                        0x0af0
#define mmGCEA_SDP_VCC_RESERVE0_BASE_IDX                                                               0
#define mmGCEA_SDP_VCC_RESERVE1                                                                        0x0af1
#define mmGCEA_SDP_VCC_RESERVE1_BASE_IDX                                                               0
#define mmGCEA_SDP_VCD_RESERVE0                                                                        0x0af2
#define mmGCEA_SDP_VCD_RESERVE0_BASE_IDX                                                               0
#define mmGCEA_SDP_VCD_RESERVE1                                                                        0x0af3
#define mmGCEA_SDP_VCD_RESERVE1_BASE_IDX                                                               0
#define mmGCEA_SDP_REQ_CNTL                                                                            0x0af4
#define mmGCEA_SDP_REQ_CNTL_BASE_IDX                                                                   0
#define mmGCEA_MISC                                                                                    0x0af5
#define mmGCEA_MISC_BASE_IDX                                                                           0
#define mmGCEA_LATENCY_SAMPLING                                                                        0x0af6
#define mmGCEA_LATENCY_SAMPLING_BASE_IDX                                                               0
#define mmGCEA_PERFCOUNTER_LO                                                                          0x0af7
#define mmGCEA_PERFCOUNTER_LO_BASE_IDX                                                                 0
#define mmGCEA_PERFCOUNTER_HI                                                                          0x0af8
#define mmGCEA_PERFCOUNTER_HI_BASE_IDX                                                                 0
#define mmGCEA_PERFCOUNTER0_CFG                                                                        0x0af9
#define mmGCEA_PERFCOUNTER0_CFG_BASE_IDX                                                               0
#define mmGCEA_PERFCOUNTER1_CFG                                                                        0x0afa
#define mmGCEA_PERFCOUNTER1_CFG_BASE_IDX                                                               0
#define mmGCEA_PERFCOUNTER_RSLT_CNTL                                                                   0x0afb
#define mmGCEA_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                          0


// addressBlock: gc_tcdec
// base address: 0xac00
#define mmTCP_INVALIDATE                                                                               0x0b00
#define mmTCP_INVALIDATE_BASE_IDX                                                                      0
#define mmTCP_STATUS                                                                                   0x0b01
#define mmTCP_STATUS_BASE_IDX                                                                          0
#define mmTCP_CNTL                                                                                     0x0b02
#define mmTCP_CNTL_BASE_IDX                                                                            0
#define mmTCP_CHAN_STEER_LO                                                                            0x0b03
#define mmTCP_CHAN_STEER_LO_BASE_IDX                                                                   0
#define mmTCP_CHAN_STEER_HI                                                                            0x0b04
#define mmTCP_CHAN_STEER_HI_BASE_IDX                                                                   0
#define mmTCP_ADDR_CONFIG                                                                              0x0b05
#define mmTCP_ADDR_CONFIG_BASE_IDX                                                                     0
#define mmTCP_CREDIT                                                                                   0x0b06
#define mmTCP_CREDIT_BASE_IDX                                                                          0
#define mmTCP_BUFFER_ADDR_HASH_CNTL                                                                    0x0b16
#define mmTCP_BUFFER_ADDR_HASH_CNTL_BASE_IDX                                                           0
#define mmTCP_EDC_CNT                                                                                  0x0b17
#define mmTCP_EDC_CNT_BASE_IDX                                                                         0
#define mmTC_CFG_L1_LOAD_POLICY0                                                                       0x0b1a
#define mmTC_CFG_L1_LOAD_POLICY0_BASE_IDX                                                              0
#define mmTC_CFG_L1_LOAD_POLICY1                                                                       0x0b1b
#define mmTC_CFG_L1_LOAD_POLICY1_BASE_IDX                                                              0
#define mmTC_CFG_L1_STORE_POLICY                                                                       0x0b1c
#define mmTC_CFG_L1_STORE_POLICY_BASE_IDX                                                              0
#define mmTC_CFG_L2_LOAD_POLICY0                                                                       0x0b1d
#define mmTC_CFG_L2_LOAD_POLICY0_BASE_IDX                                                              0
#define mmTC_CFG_L2_LOAD_POLICY1                                                                       0x0b1e
#define mmTC_CFG_L2_LOAD_POLICY1_BASE_IDX                                                              0
#define mmTC_CFG_L2_STORE_POLICY0                                                                      0x0b1f
#define mmTC_CFG_L2_STORE_POLICY0_BASE_IDX                                                             0
#define mmTC_CFG_L2_STORE_POLICY1                                                                      0x0b20
#define mmTC_CFG_L2_STORE_POLICY1_BASE_IDX                                                             0
#define mmTC_CFG_L2_ATOMIC_POLICY                                                                      0x0b21
#define mmTC_CFG_L2_ATOMIC_POLICY_BASE_IDX                                                             0
#define mmTC_CFG_L1_VOLATILE                                                                           0x0b22
#define mmTC_CFG_L1_VOLATILE_BASE_IDX                                                                  0
#define mmTC_CFG_L2_VOLATILE                                                                           0x0b23
#define mmTC_CFG_L2_VOLATILE_BASE_IDX                                                                  0
#define mmTCI_STATUS                                                                                   0x0b61
#define mmTCI_STATUS_BASE_IDX                                                                          0
#define mmTCI_CNTL_1                                                                                   0x0b62
#define mmTCI_CNTL_1_BASE_IDX                                                                          0
#define mmTCI_CNTL_2                                                                                   0x0b63
#define mmTCI_CNTL_2_BASE_IDX                                                                          0
#define mmTCC_CTRL                                                                                     0x0b80
#define mmTCC_CTRL_BASE_IDX                                                                            0
#define mmTCC_CTRL2                                                                                    0x0b81
#define mmTCC_CTRL2_BASE_IDX                                                                           0
#define mmTCC_EDC_CNT                                                                                  0x0b82
#define mmTCC_EDC_CNT_BASE_IDX                                                                         0
#define mmTCC_EDC_CNT2                                                                                 0x0b83
#define mmTCC_EDC_CNT2_BASE_IDX                                                                        0
#define mmTCC_REDUNDANCY                                                                               0x0b84
#define mmTCC_REDUNDANCY_BASE_IDX                                                                      0
#define mmTCC_EXE_DISABLE                                                                              0x0b85
#define mmTCC_EXE_DISABLE_BASE_IDX                                                                     0
#define mmTCC_DSM_CNTL                                                                                 0x0b86
#define mmTCC_DSM_CNTL_BASE_IDX                                                                        0
#define mmTCC_DSM_CNTLA                                                                                0x0b87
#define mmTCC_DSM_CNTLA_BASE_IDX                                                                       0
#define mmTCC_DSM_CNTL2                                                                                0x0b88
#define mmTCC_DSM_CNTL2_BASE_IDX                                                                       0
#define mmTCC_DSM_CNTL2A                                                                               0x0b89
#define mmTCC_DSM_CNTL2A_BASE_IDX                                                                      0
#define mmTCC_DSM_CNTL2B                                                                               0x0b8a
#define mmTCC_DSM_CNTL2B_BASE_IDX                                                                      0
#define mmTCC_WBINVL2                                                                                  0x0b8b
#define mmTCC_WBINVL2_BASE_IDX                                                                         0
#define mmTCC_SOFT_RESET                                                                               0x0b8c
#define mmTCC_SOFT_RESET_BASE_IDX                                                                      0
#define mmTCA_CTRL                                                                                     0x0bc0
#define mmTCA_CTRL_BASE_IDX                                                                            0
#define mmTCA_BURST_MASK                                                                               0x0bc1
#define mmTCA_BURST_MASK_BASE_IDX                                                                      0
#define mmTCA_BURST_CTRL                                                                               0x0bc2
#define mmTCA_BURST_CTRL_BASE_IDX                                                                      0
#define mmTCA_DSM_CNTL                                                                                 0x0bc3
#define mmTCA_DSM_CNTL_BASE_IDX                                                                        0
#define mmTCA_DSM_CNTL2                                                                                0x0bc4
#define mmTCA_DSM_CNTL2_BASE_IDX                                                                       0
#define mmTCA_EDC_CNT                                                                                  0x0bc5
#define mmTCA_EDC_CNT_BASE_IDX                                                                         0


// addressBlock: gc_shdec
// base address: 0xb000
#define mmSPI_SHADER_PGM_RSRC3_PS                                                                      0x0c07
#define mmSPI_SHADER_PGM_RSRC3_PS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_LO_PS                                                                         0x0c08
#define mmSPI_SHADER_PGM_LO_PS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_PS                                                                         0x0c09
#define mmSPI_SHADER_PGM_HI_PS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_PS                                                                      0x0c0a
#define mmSPI_SHADER_PGM_RSRC1_PS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_PS                                                                      0x0c0b
#define mmSPI_SHADER_PGM_RSRC2_PS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_PS_0                                                                    0x0c0c
#define mmSPI_SHADER_USER_DATA_PS_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_1                                                                    0x0c0d
#define mmSPI_SHADER_USER_DATA_PS_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_2                                                                    0x0c0e
#define mmSPI_SHADER_USER_DATA_PS_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_3                                                                    0x0c0f
#define mmSPI_SHADER_USER_DATA_PS_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_4                                                                    0x0c10
#define mmSPI_SHADER_USER_DATA_PS_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_5                                                                    0x0c11
#define mmSPI_SHADER_USER_DATA_PS_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_6                                                                    0x0c12
#define mmSPI_SHADER_USER_DATA_PS_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_7                                                                    0x0c13
#define mmSPI_SHADER_USER_DATA_PS_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_8                                                                    0x0c14
#define mmSPI_SHADER_USER_DATA_PS_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_9                                                                    0x0c15
#define mmSPI_SHADER_USER_DATA_PS_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_PS_10                                                                   0x0c16
#define mmSPI_SHADER_USER_DATA_PS_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_11                                                                   0x0c17
#define mmSPI_SHADER_USER_DATA_PS_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_12                                                                   0x0c18
#define mmSPI_SHADER_USER_DATA_PS_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_13                                                                   0x0c19
#define mmSPI_SHADER_USER_DATA_PS_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_14                                                                   0x0c1a
#define mmSPI_SHADER_USER_DATA_PS_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_15                                                                   0x0c1b
#define mmSPI_SHADER_USER_DATA_PS_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_16                                                                   0x0c1c
#define mmSPI_SHADER_USER_DATA_PS_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_17                                                                   0x0c1d
#define mmSPI_SHADER_USER_DATA_PS_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_18                                                                   0x0c1e
#define mmSPI_SHADER_USER_DATA_PS_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_19                                                                   0x0c1f
#define mmSPI_SHADER_USER_DATA_PS_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_20                                                                   0x0c20
#define mmSPI_SHADER_USER_DATA_PS_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_21                                                                   0x0c21
#define mmSPI_SHADER_USER_DATA_PS_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_22                                                                   0x0c22
#define mmSPI_SHADER_USER_DATA_PS_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_23                                                                   0x0c23
#define mmSPI_SHADER_USER_DATA_PS_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_24                                                                   0x0c24
#define mmSPI_SHADER_USER_DATA_PS_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_25                                                                   0x0c25
#define mmSPI_SHADER_USER_DATA_PS_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_26                                                                   0x0c26
#define mmSPI_SHADER_USER_DATA_PS_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_27                                                                   0x0c27
#define mmSPI_SHADER_USER_DATA_PS_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_28                                                                   0x0c28
#define mmSPI_SHADER_USER_DATA_PS_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_29                                                                   0x0c29
#define mmSPI_SHADER_USER_DATA_PS_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_30                                                                   0x0c2a
#define mmSPI_SHADER_USER_DATA_PS_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_PS_31                                                                   0x0c2b
#define mmSPI_SHADER_USER_DATA_PS_31_BASE_IDX                                                          0
#define mmSPI_SHADER_PGM_RSRC3_VS                                                                      0x0c46
#define mmSPI_SHADER_PGM_RSRC3_VS_BASE_IDX                                                             0
#define mmSPI_SHADER_LATE_ALLOC_VS                                                                     0x0c47
#define mmSPI_SHADER_LATE_ALLOC_VS_BASE_IDX                                                            0
#define mmSPI_SHADER_PGM_LO_VS                                                                         0x0c48
#define mmSPI_SHADER_PGM_LO_VS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_VS                                                                         0x0c49
#define mmSPI_SHADER_PGM_HI_VS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_VS                                                                      0x0c4a
#define mmSPI_SHADER_PGM_RSRC1_VS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_VS                                                                      0x0c4b
#define mmSPI_SHADER_PGM_RSRC2_VS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_VS_0                                                                    0x0c4c
#define mmSPI_SHADER_USER_DATA_VS_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_1                                                                    0x0c4d
#define mmSPI_SHADER_USER_DATA_VS_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_2                                                                    0x0c4e
#define mmSPI_SHADER_USER_DATA_VS_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_3                                                                    0x0c4f
#define mmSPI_SHADER_USER_DATA_VS_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_4                                                                    0x0c50
#define mmSPI_SHADER_USER_DATA_VS_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_5                                                                    0x0c51
#define mmSPI_SHADER_USER_DATA_VS_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_6                                                                    0x0c52
#define mmSPI_SHADER_USER_DATA_VS_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_7                                                                    0x0c53
#define mmSPI_SHADER_USER_DATA_VS_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_8                                                                    0x0c54
#define mmSPI_SHADER_USER_DATA_VS_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_9                                                                    0x0c55
#define mmSPI_SHADER_USER_DATA_VS_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_VS_10                                                                   0x0c56
#define mmSPI_SHADER_USER_DATA_VS_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_11                                                                   0x0c57
#define mmSPI_SHADER_USER_DATA_VS_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_12                                                                   0x0c58
#define mmSPI_SHADER_USER_DATA_VS_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_13                                                                   0x0c59
#define mmSPI_SHADER_USER_DATA_VS_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_14                                                                   0x0c5a
#define mmSPI_SHADER_USER_DATA_VS_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_15                                                                   0x0c5b
#define mmSPI_SHADER_USER_DATA_VS_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_16                                                                   0x0c5c
#define mmSPI_SHADER_USER_DATA_VS_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_17                                                                   0x0c5d
#define mmSPI_SHADER_USER_DATA_VS_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_18                                                                   0x0c5e
#define mmSPI_SHADER_USER_DATA_VS_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_19                                                                   0x0c5f
#define mmSPI_SHADER_USER_DATA_VS_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_20                                                                   0x0c60
#define mmSPI_SHADER_USER_DATA_VS_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_21                                                                   0x0c61
#define mmSPI_SHADER_USER_DATA_VS_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_22                                                                   0x0c62
#define mmSPI_SHADER_USER_DATA_VS_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_23                                                                   0x0c63
#define mmSPI_SHADER_USER_DATA_VS_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_24                                                                   0x0c64
#define mmSPI_SHADER_USER_DATA_VS_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_25                                                                   0x0c65
#define mmSPI_SHADER_USER_DATA_VS_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_26                                                                   0x0c66
#define mmSPI_SHADER_USER_DATA_VS_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_27                                                                   0x0c67
#define mmSPI_SHADER_USER_DATA_VS_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_28                                                                   0x0c68
#define mmSPI_SHADER_USER_DATA_VS_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_29                                                                   0x0c69
#define mmSPI_SHADER_USER_DATA_VS_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_30                                                                   0x0c6a
#define mmSPI_SHADER_USER_DATA_VS_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_VS_31                                                                   0x0c6b
#define mmSPI_SHADER_USER_DATA_VS_31_BASE_IDX                                                          0
#define mmSPI_SHADER_PGM_RSRC2_GS_VS                                                                   0x0c7c
#define mmSPI_SHADER_PGM_RSRC2_GS_VS_BASE_IDX                                                          0
#define mmSPI_SHADER_PGM_RSRC4_GS                                                                      0x0c81
#define mmSPI_SHADER_PGM_RSRC4_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_ADDR_LO_GS                                                              0x0c82
#define mmSPI_SHADER_USER_DATA_ADDR_LO_GS_BASE_IDX                                                     0
#define mmSPI_SHADER_USER_DATA_ADDR_HI_GS                                                              0x0c83
#define mmSPI_SHADER_USER_DATA_ADDR_HI_GS_BASE_IDX                                                     0
#define mmSPI_SHADER_PGM_LO_ES                                                                         0x0c84
#define mmSPI_SHADER_PGM_LO_ES_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_ES                                                                         0x0c85
#define mmSPI_SHADER_PGM_HI_ES_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC3_GS                                                                      0x0c87
#define mmSPI_SHADER_PGM_RSRC3_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_LO_GS                                                                         0x0c88
#define mmSPI_SHADER_PGM_LO_GS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_GS                                                                         0x0c89
#define mmSPI_SHADER_PGM_HI_GS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_GS                                                                      0x0c8a
#define mmSPI_SHADER_PGM_RSRC1_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_GS                                                                      0x0c8b
#define mmSPI_SHADER_PGM_RSRC2_GS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_ES_0                                                                    0x0ccc
#define mmSPI_SHADER_USER_DATA_ES_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_1                                                                    0x0ccd
#define mmSPI_SHADER_USER_DATA_ES_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_2                                                                    0x0cce
#define mmSPI_SHADER_USER_DATA_ES_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_3                                                                    0x0ccf
#define mmSPI_SHADER_USER_DATA_ES_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_4                                                                    0x0cd0
#define mmSPI_SHADER_USER_DATA_ES_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_5                                                                    0x0cd1
#define mmSPI_SHADER_USER_DATA_ES_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_6                                                                    0x0cd2
#define mmSPI_SHADER_USER_DATA_ES_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_7                                                                    0x0cd3
#define mmSPI_SHADER_USER_DATA_ES_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_8                                                                    0x0cd4
#define mmSPI_SHADER_USER_DATA_ES_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_9                                                                    0x0cd5
#define mmSPI_SHADER_USER_DATA_ES_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_ES_10                                                                   0x0cd6
#define mmSPI_SHADER_USER_DATA_ES_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_11                                                                   0x0cd7
#define mmSPI_SHADER_USER_DATA_ES_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_12                                                                   0x0cd8
#define mmSPI_SHADER_USER_DATA_ES_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_13                                                                   0x0cd9
#define mmSPI_SHADER_USER_DATA_ES_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_14                                                                   0x0cda
#define mmSPI_SHADER_USER_DATA_ES_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_15                                                                   0x0cdb
#define mmSPI_SHADER_USER_DATA_ES_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_16                                                                   0x0cdc
#define mmSPI_SHADER_USER_DATA_ES_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_17                                                                   0x0cdd
#define mmSPI_SHADER_USER_DATA_ES_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_18                                                                   0x0cde
#define mmSPI_SHADER_USER_DATA_ES_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_19                                                                   0x0cdf
#define mmSPI_SHADER_USER_DATA_ES_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_20                                                                   0x0ce0
#define mmSPI_SHADER_USER_DATA_ES_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_21                                                                   0x0ce1
#define mmSPI_SHADER_USER_DATA_ES_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_22                                                                   0x0ce2
#define mmSPI_SHADER_USER_DATA_ES_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_23                                                                   0x0ce3
#define mmSPI_SHADER_USER_DATA_ES_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_24                                                                   0x0ce4
#define mmSPI_SHADER_USER_DATA_ES_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_25                                                                   0x0ce5
#define mmSPI_SHADER_USER_DATA_ES_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_26                                                                   0x0ce6
#define mmSPI_SHADER_USER_DATA_ES_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_27                                                                   0x0ce7
#define mmSPI_SHADER_USER_DATA_ES_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_28                                                                   0x0ce8
#define mmSPI_SHADER_USER_DATA_ES_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_29                                                                   0x0ce9
#define mmSPI_SHADER_USER_DATA_ES_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_30                                                                   0x0cea
#define mmSPI_SHADER_USER_DATA_ES_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_ES_31                                                                   0x0ceb
#define mmSPI_SHADER_USER_DATA_ES_31_BASE_IDX                                                          0
#define mmSPI_SHADER_PGM_RSRC4_HS                                                                      0x0d01
#define mmSPI_SHADER_PGM_RSRC4_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_ADDR_LO_HS                                                              0x0d02
#define mmSPI_SHADER_USER_DATA_ADDR_LO_HS_BASE_IDX                                                     0
#define mmSPI_SHADER_USER_DATA_ADDR_HI_HS                                                              0x0d03
#define mmSPI_SHADER_USER_DATA_ADDR_HI_HS_BASE_IDX                                                     0
#define mmSPI_SHADER_PGM_LO_LS                                                                         0x0d04
#define mmSPI_SHADER_PGM_LO_LS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_LS                                                                         0x0d05
#define mmSPI_SHADER_PGM_HI_LS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC3_HS                                                                      0x0d07
#define mmSPI_SHADER_PGM_RSRC3_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_LO_HS                                                                         0x0d08
#define mmSPI_SHADER_PGM_LO_HS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_HI_HS                                                                         0x0d09
#define mmSPI_SHADER_PGM_HI_HS_BASE_IDX                                                                0
#define mmSPI_SHADER_PGM_RSRC1_HS                                                                      0x0d0a
#define mmSPI_SHADER_PGM_RSRC1_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_PGM_RSRC2_HS                                                                      0x0d0b
#define mmSPI_SHADER_PGM_RSRC2_HS_BASE_IDX                                                             0
#define mmSPI_SHADER_USER_DATA_LS_0                                                                    0x0d0c
#define mmSPI_SHADER_USER_DATA_LS_0_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_1                                                                    0x0d0d
#define mmSPI_SHADER_USER_DATA_LS_1_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_2                                                                    0x0d0e
#define mmSPI_SHADER_USER_DATA_LS_2_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_3                                                                    0x0d0f
#define mmSPI_SHADER_USER_DATA_LS_3_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_4                                                                    0x0d10
#define mmSPI_SHADER_USER_DATA_LS_4_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_5                                                                    0x0d11
#define mmSPI_SHADER_USER_DATA_LS_5_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_6                                                                    0x0d12
#define mmSPI_SHADER_USER_DATA_LS_6_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_7                                                                    0x0d13
#define mmSPI_SHADER_USER_DATA_LS_7_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_8                                                                    0x0d14
#define mmSPI_SHADER_USER_DATA_LS_8_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_9                                                                    0x0d15
#define mmSPI_SHADER_USER_DATA_LS_9_BASE_IDX                                                           0
#define mmSPI_SHADER_USER_DATA_LS_10                                                                   0x0d16
#define mmSPI_SHADER_USER_DATA_LS_10_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_11                                                                   0x0d17
#define mmSPI_SHADER_USER_DATA_LS_11_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_12                                                                   0x0d18
#define mmSPI_SHADER_USER_DATA_LS_12_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_13                                                                   0x0d19
#define mmSPI_SHADER_USER_DATA_LS_13_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_14                                                                   0x0d1a
#define mmSPI_SHADER_USER_DATA_LS_14_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_15                                                                   0x0d1b
#define mmSPI_SHADER_USER_DATA_LS_15_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_16                                                                   0x0d1c
#define mmSPI_SHADER_USER_DATA_LS_16_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_17                                                                   0x0d1d
#define mmSPI_SHADER_USER_DATA_LS_17_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_18                                                                   0x0d1e
#define mmSPI_SHADER_USER_DATA_LS_18_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_19                                                                   0x0d1f
#define mmSPI_SHADER_USER_DATA_LS_19_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_20                                                                   0x0d20
#define mmSPI_SHADER_USER_DATA_LS_20_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_21                                                                   0x0d21
#define mmSPI_SHADER_USER_DATA_LS_21_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_22                                                                   0x0d22
#define mmSPI_SHADER_USER_DATA_LS_22_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_23                                                                   0x0d23
#define mmSPI_SHADER_USER_DATA_LS_23_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_24                                                                   0x0d24
#define mmSPI_SHADER_USER_DATA_LS_24_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_25                                                                   0x0d25
#define mmSPI_SHADER_USER_DATA_LS_25_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_26                                                                   0x0d26
#define mmSPI_SHADER_USER_DATA_LS_26_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_27                                                                   0x0d27
#define mmSPI_SHADER_USER_DATA_LS_27_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_28                                                                   0x0d28
#define mmSPI_SHADER_USER_DATA_LS_28_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_29                                                                   0x0d29
#define mmSPI_SHADER_USER_DATA_LS_29_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_30                                                                   0x0d2a
#define mmSPI_SHADER_USER_DATA_LS_30_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_LS_31                                                                   0x0d2b
#define mmSPI_SHADER_USER_DATA_LS_31_BASE_IDX                                                          0
#define mmSPI_SHADER_USER_DATA_COMMON_0                                                                0x0d4c
#define mmSPI_SHADER_USER_DATA_COMMON_0_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_1                                                                0x0d4d
#define mmSPI_SHADER_USER_DATA_COMMON_1_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_2                                                                0x0d4e
#define mmSPI_SHADER_USER_DATA_COMMON_2_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_3                                                                0x0d4f
#define mmSPI_SHADER_USER_DATA_COMMON_3_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_4                                                                0x0d50
#define mmSPI_SHADER_USER_DATA_COMMON_4_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_5                                                                0x0d51
#define mmSPI_SHADER_USER_DATA_COMMON_5_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_6                                                                0x0d52
#define mmSPI_SHADER_USER_DATA_COMMON_6_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_7                                                                0x0d53
#define mmSPI_SHADER_USER_DATA_COMMON_7_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_8                                                                0x0d54
#define mmSPI_SHADER_USER_DATA_COMMON_8_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_9                                                                0x0d55
#define mmSPI_SHADER_USER_DATA_COMMON_9_BASE_IDX                                                       0
#define mmSPI_SHADER_USER_DATA_COMMON_10                                                               0x0d56
#define mmSPI_SHADER_USER_DATA_COMMON_10_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_11                                                               0x0d57
#define mmSPI_SHADER_USER_DATA_COMMON_11_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_12                                                               0x0d58
#define mmSPI_SHADER_USER_DATA_COMMON_12_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_13                                                               0x0d59
#define mmSPI_SHADER_USER_DATA_COMMON_13_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_14                                                               0x0d5a
#define mmSPI_SHADER_USER_DATA_COMMON_14_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_15                                                               0x0d5b
#define mmSPI_SHADER_USER_DATA_COMMON_15_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_16                                                               0x0d5c
#define mmSPI_SHADER_USER_DATA_COMMON_16_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_17                                                               0x0d5d
#define mmSPI_SHADER_USER_DATA_COMMON_17_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_18                                                               0x0d5e
#define mmSPI_SHADER_USER_DATA_COMMON_18_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_19                                                               0x0d5f
#define mmSPI_SHADER_USER_DATA_COMMON_19_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_20                                                               0x0d60
#define mmSPI_SHADER_USER_DATA_COMMON_20_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_21                                                               0x0d61
#define mmSPI_SHADER_USER_DATA_COMMON_21_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_22                                                               0x0d62
#define mmSPI_SHADER_USER_DATA_COMMON_22_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_23                                                               0x0d63
#define mmSPI_SHADER_USER_DATA_COMMON_23_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_24                                                               0x0d64
#define mmSPI_SHADER_USER_DATA_COMMON_24_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_25                                                               0x0d65
#define mmSPI_SHADER_USER_DATA_COMMON_25_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_26                                                               0x0d66
#define mmSPI_SHADER_USER_DATA_COMMON_26_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_27                                                               0x0d67
#define mmSPI_SHADER_USER_DATA_COMMON_27_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_28                                                               0x0d68
#define mmSPI_SHADER_USER_DATA_COMMON_28_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_29                                                               0x0d69
#define mmSPI_SHADER_USER_DATA_COMMON_29_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_30                                                               0x0d6a
#define mmSPI_SHADER_USER_DATA_COMMON_30_BASE_IDX                                                      0
#define mmSPI_SHADER_USER_DATA_COMMON_31                                                               0x0d6b
#define mmSPI_SHADER_USER_DATA_COMMON_31_BASE_IDX                                                      0
#define mmCOMPUTE_DISPATCH_INITIATOR                                                                   0x0e00
#define mmCOMPUTE_DISPATCH_INITIATOR_BASE_IDX                                                          0
#define mmCOMPUTE_DIM_X                                                                                0x0e01
#define mmCOMPUTE_DIM_X_BASE_IDX                                                                       0
#define mmCOMPUTE_DIM_Y                                                                                0x0e02
#define mmCOMPUTE_DIM_Y_BASE_IDX                                                                       0
#define mmCOMPUTE_DIM_Z                                                                                0x0e03
#define mmCOMPUTE_DIM_Z_BASE_IDX                                                                       0
#define mmCOMPUTE_START_X                                                                              0x0e04
#define mmCOMPUTE_START_X_BASE_IDX                                                                     0
#define mmCOMPUTE_START_Y                                                                              0x0e05
#define mmCOMPUTE_START_Y_BASE_IDX                                                                     0
#define mmCOMPUTE_START_Z                                                                              0x0e06
#define mmCOMPUTE_START_Z_BASE_IDX                                                                     0
#define mmCOMPUTE_NUM_THREAD_X                                                                         0x0e07
#define mmCOMPUTE_NUM_THREAD_X_BASE_IDX                                                                0
#define mmCOMPUTE_NUM_THREAD_Y                                                                         0x0e08
#define mmCOMPUTE_NUM_THREAD_Y_BASE_IDX                                                                0
#define mmCOMPUTE_NUM_THREAD_Z                                                                         0x0e09
#define mmCOMPUTE_NUM_THREAD_Z_BASE_IDX                                                                0
#define mmCOMPUTE_PIPELINESTAT_ENABLE                                                                  0x0e0a
#define mmCOMPUTE_PIPELINESTAT_ENABLE_BASE_IDX                                                         0
#define mmCOMPUTE_PERFCOUNT_ENABLE                                                                     0x0e0b
#define mmCOMPUTE_PERFCOUNT_ENABLE_BASE_IDX                                                            0
#define mmCOMPUTE_PGM_LO                                                                               0x0e0c
#define mmCOMPUTE_PGM_LO_BASE_IDX                                                                      0
#define mmCOMPUTE_PGM_HI                                                                               0x0e0d
#define mmCOMPUTE_PGM_HI_BASE_IDX                                                                      0
#define mmCOMPUTE_DISPATCH_PKT_ADDR_LO                                                                 0x0e0e
#define mmCOMPUTE_DISPATCH_PKT_ADDR_LO_BASE_IDX                                                        0
#define mmCOMPUTE_DISPATCH_PKT_ADDR_HI                                                                 0x0e0f
#define mmCOMPUTE_DISPATCH_PKT_ADDR_HI_BASE_IDX                                                        0
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_LO                                                             0x0e10
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_LO_BASE_IDX                                                    0
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_HI                                                             0x0e11
#define mmCOMPUTE_DISPATCH_SCRATCH_BASE_HI_BASE_IDX                                                    0
#define mmCOMPUTE_PGM_RSRC1                                                                            0x0e12
#define mmCOMPUTE_PGM_RSRC1_BASE_IDX                                                                   0
#define mmCOMPUTE_PGM_RSRC2                                                                            0x0e13
#define mmCOMPUTE_PGM_RSRC2_BASE_IDX                                                                   0
#define mmCOMPUTE_VMID                                                                                 0x0e14
#define mmCOMPUTE_VMID_BASE_IDX                                                                        0
#define mmCOMPUTE_RESOURCE_LIMITS                                                                      0x0e15
#define mmCOMPUTE_RESOURCE_LIMITS_BASE_IDX                                                             0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE0                                                               0x0e16
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE0_BASE_IDX                                                      0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE1                                                               0x0e17
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE1_BASE_IDX                                                      0
#define mmCOMPUTE_TMPRING_SIZE                                                                         0x0e18
#define mmCOMPUTE_TMPRING_SIZE_BASE_IDX                                                                0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE2                                                               0x0e19
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE2_BASE_IDX                                                      0
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE3                                                               0x0e1a
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE3_BASE_IDX                                                      0
#define mmCOMPUTE_RESTART_X                                                                            0x0e1b
#define mmCOMPUTE_RESTART_X_BASE_IDX                                                                   0
#define mmCOMPUTE_RESTART_Y                                                                            0x0e1c
#define mmCOMPUTE_RESTART_Y_BASE_IDX                                                                   0
#define mmCOMPUTE_RESTART_Z                                                                            0x0e1d
#define mmCOMPUTE_RESTART_Z_BASE_IDX                                                                   0
#define mmCOMPUTE_THREAD_TRACE_ENABLE                                                                  0x0e1e
#define mmCOMPUTE_THREAD_TRACE_ENABLE_BASE_IDX                                                         0
#define mmCOMPUTE_MISC_RESERVED                                                                        0x0e1f
#define mmCOMPUTE_MISC_RESERVED_BASE_IDX                                                               0
#define mmCOMPUTE_DISPATCH_ID                                                                          0x0e20
#define mmCOMPUTE_DISPATCH_ID_BASE_IDX                                                                 0
#define mmCOMPUTE_THREADGROUP_ID                                                                       0x0e21
#define mmCOMPUTE_THREADGROUP_ID_BASE_IDX                                                              0
#define mmCOMPUTE_RELAUNCH                                                                             0x0e22
#define mmCOMPUTE_RELAUNCH_BASE_IDX                                                                    0
#define mmCOMPUTE_WAVE_RESTORE_ADDR_LO                                                                 0x0e23
#define mmCOMPUTE_WAVE_RESTORE_ADDR_LO_BASE_IDX                                                        0
#define mmCOMPUTE_WAVE_RESTORE_ADDR_HI                                                                 0x0e24
#define mmCOMPUTE_WAVE_RESTORE_ADDR_HI_BASE_IDX                                                        0
#define mmCOMPUTE_USER_DATA_0                                                                          0x0e40
#define mmCOMPUTE_USER_DATA_0_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_1                                                                          0x0e41
#define mmCOMPUTE_USER_DATA_1_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_2                                                                          0x0e42
#define mmCOMPUTE_USER_DATA_2_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_3                                                                          0x0e43
#define mmCOMPUTE_USER_DATA_3_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_4                                                                          0x0e44
#define mmCOMPUTE_USER_DATA_4_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_5                                                                          0x0e45
#define mmCOMPUTE_USER_DATA_5_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_6                                                                          0x0e46
#define mmCOMPUTE_USER_DATA_6_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_7                                                                          0x0e47
#define mmCOMPUTE_USER_DATA_7_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_8                                                                          0x0e48
#define mmCOMPUTE_USER_DATA_8_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_9                                                                          0x0e49
#define mmCOMPUTE_USER_DATA_9_BASE_IDX                                                                 0
#define mmCOMPUTE_USER_DATA_10                                                                         0x0e4a
#define mmCOMPUTE_USER_DATA_10_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_11                                                                         0x0e4b
#define mmCOMPUTE_USER_DATA_11_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_12                                                                         0x0e4c
#define mmCOMPUTE_USER_DATA_12_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_13                                                                         0x0e4d
#define mmCOMPUTE_USER_DATA_13_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_14                                                                         0x0e4e
#define mmCOMPUTE_USER_DATA_14_BASE_IDX                                                                0
#define mmCOMPUTE_USER_DATA_15                                                                         0x0e4f
#define mmCOMPUTE_USER_DATA_15_BASE_IDX                                                                0
#define mmCOMPUTE_NOWHERE                                                                              0x0e7f
#define mmCOMPUTE_NOWHERE_BASE_IDX                                                                     0


// addressBlock: gc_cppdec
// base address: 0xc080
#define mmCP_DFY_CNTL                                                                                  0x1020
#define mmCP_DFY_CNTL_BASE_IDX                                                                         0
#define mmCP_DFY_STAT                                                                                  0x1021
#define mmCP_DFY_STAT_BASE_IDX                                                                         0
#define mmCP_DFY_ADDR_HI                                                                               0x1022
#define mmCP_DFY_ADDR_HI_BASE_IDX                                                                      0
#define mmCP_DFY_ADDR_LO                                                                               0x1023
#define mmCP_DFY_ADDR_LO_BASE_IDX                                                                      0
#define mmCP_DFY_DATA_0                                                                                0x1024
#define mmCP_DFY_DATA_0_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_1                                                                                0x1025
#define mmCP_DFY_DATA_1_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_2                                                                                0x1026
#define mmCP_DFY_DATA_2_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_3                                                                                0x1027
#define mmCP_DFY_DATA_3_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_4                                                                                0x1028
#define mmCP_DFY_DATA_4_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_5                                                                                0x1029
#define mmCP_DFY_DATA_5_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_6                                                                                0x102a
#define mmCP_DFY_DATA_6_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_7                                                                                0x102b
#define mmCP_DFY_DATA_7_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_8                                                                                0x102c
#define mmCP_DFY_DATA_8_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_9                                                                                0x102d
#define mmCP_DFY_DATA_9_BASE_IDX                                                                       0
#define mmCP_DFY_DATA_10                                                                               0x102e
#define mmCP_DFY_DATA_10_BASE_IDX                                                                      0
#define mmCP_DFY_DATA_11                                                                               0x102f
#define mmCP_DFY_DATA_11_BASE_IDX                                                                      0
#define mmCP_DFY_DATA_12                                                                               0x1030
#define mmCP_DFY_DATA_12_BASE_IDX                                                                      0
#define mmCP_DFY_DATA_13                                                                               0x1031
#define mmCP_DFY_DATA_13_BASE_IDX                                                                      0
#define mmCP_DFY_DATA_14                                                                               0x1032
#define mmCP_DFY_DATA_14_BASE_IDX                                                                      0
#define mmCP_DFY_DATA_15                                                                               0x1033
#define mmCP_DFY_DATA_15_BASE_IDX                                                                      0
#define mmCP_DFY_CMD                                                                                   0x1034
#define mmCP_DFY_CMD_BASE_IDX                                                                          0
#define mmCP_EOPQ_WAIT_TIME                                                                            0x1035
#define mmCP_EOPQ_WAIT_TIME_BASE_IDX                                                                   0
#define mmCP_CPC_MGCG_SYNC_CNTL                                                                        0x1036
#define mmCP_CPC_MGCG_SYNC_CNTL_BASE_IDX                                                               0
#define mmCPC_INT_INFO                                                                                 0x1037
#define mmCPC_INT_INFO_BASE_IDX                                                                        0
#define mmCP_VIRT_STATUS                                                                               0x1038
#define mmCP_VIRT_STATUS_BASE_IDX                                                                      0
#define mmCPC_INT_ADDR                                                                                 0x1039
#define mmCPC_INT_ADDR_BASE_IDX                                                                        0
#define mmCPC_INT_PASID                                                                                0x103a
#define mmCPC_INT_PASID_BASE_IDX                                                                       0
#define mmCP_GFX_ERROR                                                                                 0x103b
#define mmCP_GFX_ERROR_BASE_IDX                                                                        0
#define mmCPG_UTCL1_CNTL                                                                               0x103c
#define mmCPG_UTCL1_CNTL_BASE_IDX                                                                      0
#define mmCPC_UTCL1_CNTL                                                                               0x103d
#define mmCPC_UTCL1_CNTL_BASE_IDX                                                                      0
#define mmCPF_UTCL1_CNTL                                                                               0x103e
#define mmCPF_UTCL1_CNTL_BASE_IDX                                                                      0
#define mmCP_AQL_SMM_STATUS                                                                            0x103f
#define mmCP_AQL_SMM_STATUS_BASE_IDX                                                                   0
#define mmCP_RB0_BASE                                                                                  0x1040
#define mmCP_RB0_BASE_BASE_IDX                                                                         0
#define mmCP_RB_BASE                                                                                   0x1040
#define mmCP_RB_BASE_BASE_IDX                                                                          0
#define mmCP_RB0_CNTL                                                                                  0x1041
#define mmCP_RB0_CNTL_BASE_IDX                                                                         0
#define mmCP_RB_CNTL                                                                                   0x1041
#define mmCP_RB_CNTL_BASE_IDX                                                                          0
#define mmCP_RB_RPTR_WR                                                                                0x1042
#define mmCP_RB_RPTR_WR_BASE_IDX                                                                       0
#define mmCP_RB0_RPTR_ADDR                                                                             0x1043
#define mmCP_RB0_RPTR_ADDR_BASE_IDX                                                                    0
#define mmCP_RB_RPTR_ADDR                                                                              0x1043
#define mmCP_RB_RPTR_ADDR_BASE_IDX                                                                     0
#define mmCP_RB0_RPTR_ADDR_HI                                                                          0x1044
#define mmCP_RB0_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_RB_RPTR_ADDR_HI                                                                           0x1044
#define mmCP_RB_RPTR_ADDR_HI_BASE_IDX                                                                  0
#define mmCP_RB0_BUFSZ_MASK                                                                            0x1045
#define mmCP_RB0_BUFSZ_MASK_BASE_IDX                                                                   0
#define mmCP_RB_BUFSZ_MASK                                                                             0x1045
#define mmCP_RB_BUFSZ_MASK_BASE_IDX                                                                    0
#define mmCP_RB_WPTR_POLL_ADDR_LO                                                                      0x1046
#define mmCP_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                             0
#define mmCP_RB_WPTR_POLL_ADDR_HI                                                                      0x1047
#define mmCP_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                             0
#define mmGC_PRIV_MODE                                                                                 0x1048
#define mmGC_PRIV_MODE_BASE_IDX                                                                        0
#define mmCP_INT_CNTL                                                                                  0x1049
#define mmCP_INT_CNTL_BASE_IDX                                                                         0
#define mmCP_INT_STATUS                                                                                0x104a
#define mmCP_INT_STATUS_BASE_IDX                                                                       0
#define mmCP_DEVICE_ID                                                                                 0x104b
#define mmCP_DEVICE_ID_BASE_IDX                                                                        0
#define mmCP_ME0_PIPE_PRIORITY_CNTS                                                                    0x104c
#define mmCP_ME0_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define mmCP_RING_PRIORITY_CNTS                                                                        0x104c
#define mmCP_RING_PRIORITY_CNTS_BASE_IDX                                                               0
#define mmCP_ME0_PIPE0_PRIORITY                                                                        0x104d
#define mmCP_ME0_PIPE0_PRIORITY_BASE_IDX                                                               0
#define mmCP_RING0_PRIORITY                                                                            0x104d
#define mmCP_RING0_PRIORITY_BASE_IDX                                                                   0
#define mmCP_ME0_PIPE1_PRIORITY                                                                        0x104e
#define mmCP_ME0_PIPE1_PRIORITY_BASE_IDX                                                               0
#define mmCP_RING1_PRIORITY                                                                            0x104e
#define mmCP_RING1_PRIORITY_BASE_IDX                                                                   0
#define mmCP_ME0_PIPE2_PRIORITY                                                                        0x104f
#define mmCP_ME0_PIPE2_PRIORITY_BASE_IDX                                                               0
#define mmCP_RING2_PRIORITY                                                                            0x104f
#define mmCP_RING2_PRIORITY_BASE_IDX                                                                   0
#define mmCP_FATAL_ERROR                                                                               0x1050
#define mmCP_FATAL_ERROR_BASE_IDX                                                                      0
#define mmCP_RB_VMID                                                                                   0x1051
#define mmCP_RB_VMID_BASE_IDX                                                                          0
#define mmCP_ME0_PIPE0_VMID                                                                            0x1052
#define mmCP_ME0_PIPE0_VMID_BASE_IDX                                                                   0
#define mmCP_ME0_PIPE1_VMID                                                                            0x1053
#define mmCP_ME0_PIPE1_VMID_BASE_IDX                                                                   0
#define mmCP_RB0_WPTR                                                                                  0x1054
#define mmCP_RB0_WPTR_BASE_IDX                                                                         0
#define mmCP_RB_WPTR                                                                                   0x1054
#define mmCP_RB_WPTR_BASE_IDX                                                                          0
#define mmCP_RB0_WPTR_HI                                                                               0x1055
#define mmCP_RB0_WPTR_HI_BASE_IDX                                                                      0
#define mmCP_RB_WPTR_HI                                                                                0x1055
#define mmCP_RB_WPTR_HI_BASE_IDX                                                                       0
#define mmCP_RB1_WPTR                                                                                  0x1056
#define mmCP_RB1_WPTR_BASE_IDX                                                                         0
#define mmCP_RB1_WPTR_HI                                                                               0x1057
#define mmCP_RB1_WPTR_HI_BASE_IDX                                                                      0
#define mmCP_RB2_WPTR                                                                                  0x1058
#define mmCP_RB2_WPTR_BASE_IDX                                                                         0
#define mmCP_RB_DOORBELL_CONTROL                                                                       0x1059
#define mmCP_RB_DOORBELL_CONTROL_BASE_IDX                                                              0
#define mmCP_RB_DOORBELL_RANGE_LOWER                                                                   0x105a
#define mmCP_RB_DOORBELL_RANGE_LOWER_BASE_IDX                                                          0
#define mmCP_RB_DOORBELL_RANGE_UPPER                                                                   0x105b
#define mmCP_RB_DOORBELL_RANGE_UPPER_BASE_IDX                                                          0
#define mmCP_MEC_DOORBELL_RANGE_LOWER                                                                  0x105c
#define mmCP_MEC_DOORBELL_RANGE_LOWER_BASE_IDX                                                         0
#define mmCP_MEC_DOORBELL_RANGE_UPPER                                                                  0x105d
#define mmCP_MEC_DOORBELL_RANGE_UPPER_BASE_IDX                                                         0
#define mmCPG_UTCL1_ERROR                                                                              0x105e
#define mmCPG_UTCL1_ERROR_BASE_IDX                                                                     0
#define mmCPC_UTCL1_ERROR                                                                              0x105f
#define mmCPC_UTCL1_ERROR_BASE_IDX                                                                     0
#define mmCP_RB1_BASE                                                                                  0x1060
#define mmCP_RB1_BASE_BASE_IDX                                                                         0
#define mmCP_RB1_CNTL                                                                                  0x1061
#define mmCP_RB1_CNTL_BASE_IDX                                                                         0
#define mmCP_RB1_RPTR_ADDR                                                                             0x1062
#define mmCP_RB1_RPTR_ADDR_BASE_IDX                                                                    0
#define mmCP_RB1_RPTR_ADDR_HI                                                                          0x1063
#define mmCP_RB1_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_RB2_BASE                                                                                  0x1065
#define mmCP_RB2_BASE_BASE_IDX                                                                         0
#define mmCP_RB2_CNTL                                                                                  0x1066
#define mmCP_RB2_CNTL_BASE_IDX                                                                         0
#define mmCP_RB2_RPTR_ADDR                                                                             0x1067
#define mmCP_RB2_RPTR_ADDR_BASE_IDX                                                                    0
#define mmCP_RB2_RPTR_ADDR_HI                                                                          0x1068
#define mmCP_RB2_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_RB0_ACTIVE                                                                                0x1069
#define mmCP_RB0_ACTIVE_BASE_IDX                                                                       0
#define mmCP_RB_ACTIVE                                                                                 0x1069
#define mmCP_RB_ACTIVE_BASE_IDX                                                                        0
#define mmCP_INT_CNTL_RING0                                                                            0x106a
#define mmCP_INT_CNTL_RING0_BASE_IDX                                                                   0
#define mmCP_INT_CNTL_RING1                                                                            0x106b
#define mmCP_INT_CNTL_RING1_BASE_IDX                                                                   0
#define mmCP_INT_CNTL_RING2                                                                            0x106c
#define mmCP_INT_CNTL_RING2_BASE_IDX                                                                   0
#define mmCP_INT_STATUS_RING0                                                                          0x106d
#define mmCP_INT_STATUS_RING0_BASE_IDX                                                                 0
#define mmCP_INT_STATUS_RING1                                                                          0x106e
#define mmCP_INT_STATUS_RING1_BASE_IDX                                                                 0
#define mmCP_INT_STATUS_RING2                                                                          0x106f
#define mmCP_INT_STATUS_RING2_BASE_IDX                                                                 0
#define mmCP_PWR_CNTL                                                                                  0x1078
#define mmCP_PWR_CNTL_BASE_IDX                                                                         0
#define mmCP_MEM_SLP_CNTL                                                                              0x1079
#define mmCP_MEM_SLP_CNTL_BASE_IDX                                                                     0
#define mmCP_ECC_FIRSTOCCURRENCE                                                                       0x107a
#define mmCP_ECC_FIRSTOCCURRENCE_BASE_IDX                                                              0
#define mmCP_ECC_FIRSTOCCURRENCE_RING0                                                                 0x107b
#define mmCP_ECC_FIRSTOCCURRENCE_RING0_BASE_IDX                                                        0
#define mmCP_ECC_FIRSTOCCURRENCE_RING1                                                                 0x107c
#define mmCP_ECC_FIRSTOCCURRENCE_RING1_BASE_IDX                                                        0
#define mmCP_ECC_FIRSTOCCURRENCE_RING2                                                                 0x107d
#define mmCP_ECC_FIRSTOCCURRENCE_RING2_BASE_IDX                                                        0
#define mmGB_EDC_MODE                                                                                  0x107e
#define mmGB_EDC_MODE_BASE_IDX                                                                         0
#define mmCP_PQ_WPTR_POLL_CNTL                                                                         0x1083
#define mmCP_PQ_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define mmCP_PQ_WPTR_POLL_CNTL1                                                                        0x1084
#define mmCP_PQ_WPTR_POLL_CNTL1_BASE_IDX                                                               0
#define mmCP_ME1_PIPE0_INT_CNTL                                                                        0x1085
#define mmCP_ME1_PIPE0_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE1_INT_CNTL                                                                        0x1086
#define mmCP_ME1_PIPE1_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE2_INT_CNTL                                                                        0x1087
#define mmCP_ME1_PIPE2_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE3_INT_CNTL                                                                        0x1088
#define mmCP_ME1_PIPE3_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE0_INT_CNTL                                                                        0x1089
#define mmCP_ME2_PIPE0_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE1_INT_CNTL                                                                        0x108a
#define mmCP_ME2_PIPE1_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE2_INT_CNTL                                                                        0x108b
#define mmCP_ME2_PIPE2_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME2_PIPE3_INT_CNTL                                                                        0x108c
#define mmCP_ME2_PIPE3_INT_CNTL_BASE_IDX                                                               0
#define mmCP_ME1_PIPE0_INT_STATUS                                                                      0x108d
#define mmCP_ME1_PIPE0_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME1_PIPE1_INT_STATUS                                                                      0x108e
#define mmCP_ME1_PIPE1_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME1_PIPE2_INT_STATUS                                                                      0x108f
#define mmCP_ME1_PIPE2_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME1_PIPE3_INT_STATUS                                                                      0x1090
#define mmCP_ME1_PIPE3_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE0_INT_STATUS                                                                      0x1091
#define mmCP_ME2_PIPE0_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE1_INT_STATUS                                                                      0x1092
#define mmCP_ME2_PIPE1_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE2_INT_STATUS                                                                      0x1093
#define mmCP_ME2_PIPE2_INT_STATUS_BASE_IDX                                                             0
#define mmCP_ME2_PIPE3_INT_STATUS                                                                      0x1094
#define mmCP_ME2_PIPE3_INT_STATUS_BASE_IDX                                                             0
#define mmCC_GC_EDC_CONFIG                                                                             0x1098
#define mmCC_GC_EDC_CONFIG_BASE_IDX                                                                    0
#define mmCP_ME1_PIPE_PRIORITY_CNTS                                                                    0x1099
#define mmCP_ME1_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define mmCP_ME1_PIPE0_PRIORITY                                                                        0x109a
#define mmCP_ME1_PIPE0_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME1_PIPE1_PRIORITY                                                                        0x109b
#define mmCP_ME1_PIPE1_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME1_PIPE2_PRIORITY                                                                        0x109c
#define mmCP_ME1_PIPE2_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME1_PIPE3_PRIORITY                                                                        0x109d
#define mmCP_ME1_PIPE3_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE_PRIORITY_CNTS                                                                    0x109e
#define mmCP_ME2_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define mmCP_ME2_PIPE0_PRIORITY                                                                        0x109f
#define mmCP_ME2_PIPE0_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE1_PRIORITY                                                                        0x10a0
#define mmCP_ME2_PIPE1_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE2_PRIORITY                                                                        0x10a1
#define mmCP_ME2_PIPE2_PRIORITY_BASE_IDX                                                               0
#define mmCP_ME2_PIPE3_PRIORITY                                                                        0x10a2
#define mmCP_ME2_PIPE3_PRIORITY_BASE_IDX                                                               0
#define mmCP_CE_PRGRM_CNTR_START                                                                       0x10a3
#define mmCP_CE_PRGRM_CNTR_START_BASE_IDX                                                              0
#define mmCP_PFP_PRGRM_CNTR_START                                                                      0x10a4
#define mmCP_PFP_PRGRM_CNTR_START_BASE_IDX                                                             0
#define mmCP_ME_PRGRM_CNTR_START                                                                       0x10a5
#define mmCP_ME_PRGRM_CNTR_START_BASE_IDX                                                              0
#define mmCP_MEC1_PRGRM_CNTR_START                                                                     0x10a6
#define mmCP_MEC1_PRGRM_CNTR_START_BASE_IDX                                                            0
#define mmCP_MEC2_PRGRM_CNTR_START                                                                     0x10a7
#define mmCP_MEC2_PRGRM_CNTR_START_BASE_IDX                                                            0
#define mmCP_CE_INTR_ROUTINE_START                                                                     0x10a8
#define mmCP_CE_INTR_ROUTINE_START_BASE_IDX                                                            0
#define mmCP_PFP_INTR_ROUTINE_START                                                                    0x10a9
#define mmCP_PFP_INTR_ROUTINE_START_BASE_IDX                                                           0
#define mmCP_ME_INTR_ROUTINE_START                                                                     0x10aa
#define mmCP_ME_INTR_ROUTINE_START_BASE_IDX                                                            0
#define mmCP_MEC1_INTR_ROUTINE_START                                                                   0x10ab
#define mmCP_MEC1_INTR_ROUTINE_START_BASE_IDX                                                          0
#define mmCP_MEC2_INTR_ROUTINE_START                                                                   0x10ac
#define mmCP_MEC2_INTR_ROUTINE_START_BASE_IDX                                                          0
#define mmCP_CONTEXT_CNTL                                                                              0x10ad
#define mmCP_CONTEXT_CNTL_BASE_IDX                                                                     0
#define mmCP_MAX_CONTEXT                                                                               0x10ae
#define mmCP_MAX_CONTEXT_BASE_IDX                                                                      0
#define mmCP_IQ_WAIT_TIME1                                                                             0x10af
#define mmCP_IQ_WAIT_TIME1_BASE_IDX                                                                    0
#define mmCP_IQ_WAIT_TIME2                                                                             0x10b0
#define mmCP_IQ_WAIT_TIME2_BASE_IDX                                                                    0
#define mmCP_RB0_BASE_HI                                                                               0x10b1
#define mmCP_RB0_BASE_HI_BASE_IDX                                                                      0
#define mmCP_RB1_BASE_HI                                                                               0x10b2
#define mmCP_RB1_BASE_HI_BASE_IDX                                                                      0
#define mmCP_VMID_RESET                                                                                0x10b3
#define mmCP_VMID_RESET_BASE_IDX                                                                       0
#define mmCPC_INT_CNTL                                                                                 0x10b4
#define mmCPC_INT_CNTL_BASE_IDX                                                                        0
#define mmCPC_INT_STATUS                                                                               0x10b5
#define mmCPC_INT_STATUS_BASE_IDX                                                                      0
#define mmCP_VMID_PREEMPT                                                                              0x10b6
#define mmCP_VMID_PREEMPT_BASE_IDX                                                                     0
#define mmCPC_INT_CNTX_ID                                                                              0x10b7
#define mmCPC_INT_CNTX_ID_BASE_IDX                                                                     0
#define mmCP_PQ_STATUS                                                                                 0x10b8
#define mmCP_PQ_STATUS_BASE_IDX                                                                        0
#define mmCP_CPC_IC_BASE_LO                                                                            0x10b9
#define mmCP_CPC_IC_BASE_LO_BASE_IDX                                                                   0
#define mmCP_CPC_IC_BASE_HI                                                                            0x10ba
#define mmCP_CPC_IC_BASE_HI_BASE_IDX                                                                   0
#define mmCP_CPC_IC_BASE_CNTL                                                                          0x10bb
#define mmCP_CPC_IC_BASE_CNTL_BASE_IDX                                                                 0
#define mmCP_CPC_IC_OP_CNTL                                                                            0x10bc
#define mmCP_CPC_IC_OP_CNTL_BASE_IDX                                                                   0
#define mmCP_MEC1_F32_INT_DIS                                                                          0x10bd
#define mmCP_MEC1_F32_INT_DIS_BASE_IDX                                                                 0
#define mmCP_MEC2_F32_INT_DIS                                                                          0x10be
#define mmCP_MEC2_F32_INT_DIS_BASE_IDX                                                                 0
#define mmCP_VMID_STATUS                                                                               0x10bf
#define mmCP_VMID_STATUS_BASE_IDX                                                                      0


// addressBlock: gc_cppdec2
// base address: 0xc600
#define mmCP_RB_DOORBELL_CONTROL_SCH_0                                                                 0x1180
#define mmCP_RB_DOORBELL_CONTROL_SCH_0_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CONTROL_SCH_1                                                                 0x1181
#define mmCP_RB_DOORBELL_CONTROL_SCH_1_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CONTROL_SCH_2                                                                 0x1182
#define mmCP_RB_DOORBELL_CONTROL_SCH_2_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CONTROL_SCH_3                                                                 0x1183
#define mmCP_RB_DOORBELL_CONTROL_SCH_3_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CONTROL_SCH_4                                                                 0x1184
#define mmCP_RB_DOORBELL_CONTROL_SCH_4_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CONTROL_SCH_5                                                                 0x1185
#define mmCP_RB_DOORBELL_CONTROL_SCH_5_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CONTROL_SCH_6                                                                 0x1186
#define mmCP_RB_DOORBELL_CONTROL_SCH_6_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CONTROL_SCH_7                                                                 0x1187
#define mmCP_RB_DOORBELL_CONTROL_SCH_7_BASE_IDX                                                        0
#define mmCP_RB_DOORBELL_CLEAR                                                                         0x1188
#define mmCP_RB_DOORBELL_CLEAR_BASE_IDX                                                                0
#define mmCP_GFX_MQD_CONTROL                                                                           0x11a0
#define mmCP_GFX_MQD_CONTROL_BASE_IDX                                                                  0
#define mmCP_GFX_MQD_BASE_ADDR                                                                         0x11a1
#define mmCP_GFX_MQD_BASE_ADDR_BASE_IDX                                                                0
#define mmCP_GFX_MQD_BASE_ADDR_HI                                                                      0x11a2
#define mmCP_GFX_MQD_BASE_ADDR_HI_BASE_IDX                                                             0
#define mmCP_RB_STATUS                                                                                 0x11a3
#define mmCP_RB_STATUS_BASE_IDX                                                                        0
#define mmCPG_UTCL1_STATUS                                                                             0x11b4
#define mmCPG_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmCPC_UTCL1_STATUS                                                                             0x11b5
#define mmCPC_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmCPF_UTCL1_STATUS                                                                             0x11b6
#define mmCPF_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmCP_SD_CNTL                                                                                   0x11b7
#define mmCP_SD_CNTL_BASE_IDX                                                                          0
#define mmCP_SOFT_RESET_CNTL                                                                           0x11b9
#define mmCP_SOFT_RESET_CNTL_BASE_IDX                                                                  0
#define mmCP_CPC_GFX_CNTL                                                                              0x11ba
#define mmCP_CPC_GFX_CNTL_BASE_IDX                                                                     0


// addressBlock: gc_spipdec
// base address: 0xc700
#define mmSPI_ARB_PRIORITY                                                                             0x11c0
#define mmSPI_ARB_PRIORITY_BASE_IDX                                                                    0
#define mmSPI_ARB_CYCLES_0                                                                             0x11c1
#define mmSPI_ARB_CYCLES_0_BASE_IDX                                                                    0
#define mmSPI_ARB_CYCLES_1                                                                             0x11c2
#define mmSPI_ARB_CYCLES_1_BASE_IDX                                                                    0
#define mmSPI_WCL_PIPE_PERCENT_GFX                                                                     0x11c7
#define mmSPI_WCL_PIPE_PERCENT_GFX_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_HP3D                                                                    0x11c8
#define mmSPI_WCL_PIPE_PERCENT_HP3D_BASE_IDX                                                           0
#define mmSPI_WCL_PIPE_PERCENT_CS0                                                                     0x11c9
#define mmSPI_WCL_PIPE_PERCENT_CS0_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS1                                                                     0x11ca
#define mmSPI_WCL_PIPE_PERCENT_CS1_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS2                                                                     0x11cb
#define mmSPI_WCL_PIPE_PERCENT_CS2_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS3                                                                     0x11cc
#define mmSPI_WCL_PIPE_PERCENT_CS3_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS4                                                                     0x11cd
#define mmSPI_WCL_PIPE_PERCENT_CS4_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS5                                                                     0x11ce
#define mmSPI_WCL_PIPE_PERCENT_CS5_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS6                                                                     0x11cf
#define mmSPI_WCL_PIPE_PERCENT_CS6_BASE_IDX                                                            0
#define mmSPI_WCL_PIPE_PERCENT_CS7                                                                     0x11d0
#define mmSPI_WCL_PIPE_PERCENT_CS7_BASE_IDX                                                            0
#define mmSPI_COMPUTE_QUEUE_RESET                                                                      0x11db
#define mmSPI_COMPUTE_QUEUE_RESET_BASE_IDX                                                             0
#define mmSPI_RESOURCE_RESERVE_CU_0                                                                    0x11dc
#define mmSPI_RESOURCE_RESERVE_CU_0_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_1                                                                    0x11dd
#define mmSPI_RESOURCE_RESERVE_CU_1_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_2                                                                    0x11de
#define mmSPI_RESOURCE_RESERVE_CU_2_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_3                                                                    0x11df
#define mmSPI_RESOURCE_RESERVE_CU_3_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_4                                                                    0x11e0
#define mmSPI_RESOURCE_RESERVE_CU_4_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_5                                                                    0x11e1
#define mmSPI_RESOURCE_RESERVE_CU_5_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_6                                                                    0x11e2
#define mmSPI_RESOURCE_RESERVE_CU_6_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_7                                                                    0x11e3
#define mmSPI_RESOURCE_RESERVE_CU_7_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_8                                                                    0x11e4
#define mmSPI_RESOURCE_RESERVE_CU_8_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_CU_9                                                                    0x11e5
#define mmSPI_RESOURCE_RESERVE_CU_9_BASE_IDX                                                           0
#define mmSPI_RESOURCE_RESERVE_EN_CU_0                                                                 0x11e6
#define mmSPI_RESOURCE_RESERVE_EN_CU_0_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_1                                                                 0x11e7
#define mmSPI_RESOURCE_RESERVE_EN_CU_1_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_2                                                                 0x11e8
#define mmSPI_RESOURCE_RESERVE_EN_CU_2_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_3                                                                 0x11e9
#define mmSPI_RESOURCE_RESERVE_EN_CU_3_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_4                                                                 0x11ea
#define mmSPI_RESOURCE_RESERVE_EN_CU_4_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_5                                                                 0x11eb
#define mmSPI_RESOURCE_RESERVE_EN_CU_5_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_6                                                                 0x11ec
#define mmSPI_RESOURCE_RESERVE_EN_CU_6_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_7                                                                 0x11ed
#define mmSPI_RESOURCE_RESERVE_EN_CU_7_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_8                                                                 0x11ee
#define mmSPI_RESOURCE_RESERVE_EN_CU_8_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_EN_CU_9                                                                 0x11ef
#define mmSPI_RESOURCE_RESERVE_EN_CU_9_BASE_IDX                                                        0
#define mmSPI_RESOURCE_RESERVE_CU_10                                                                   0x11f0
#define mmSPI_RESOURCE_RESERVE_CU_10_BASE_IDX                                                          0
#define mmSPI_RESOURCE_RESERVE_CU_11                                                                   0x11f1
#define mmSPI_RESOURCE_RESERVE_CU_11_BASE_IDX                                                          0
#define mmSPI_RESOURCE_RESERVE_EN_CU_10                                                                0x11f2
#define mmSPI_RESOURCE_RESERVE_EN_CU_10_BASE_IDX                                                       0
#define mmSPI_RESOURCE_RESERVE_EN_CU_11                                                                0x11f3
#define mmSPI_RESOURCE_RESERVE_EN_CU_11_BASE_IDX                                                       0
#define mmSPI_RESOURCE_RESERVE_CU_12                                                                   0x11f4
#define mmSPI_RESOURCE_RESERVE_CU_12_BASE_IDX                                                          0
#define mmSPI_RESOURCE_RESERVE_CU_13                                                                   0x11f5
#define mmSPI_RESOURCE_RESERVE_CU_13_BASE_IDX                                                          0
#define mmSPI_RESOURCE_RESERVE_CU_14                                                                   0x11f6
#define mmSPI_RESOURCE_RESERVE_CU_14_BASE_IDX                                                          0
#define mmSPI_RESOURCE_RESERVE_CU_15                                                                   0x11f7
#define mmSPI_RESOURCE_RESERVE_CU_15_BASE_IDX                                                          0
#define mmSPI_RESOURCE_RESERVE_EN_CU_12                                                                0x11f8
#define mmSPI_RESOURCE_RESERVE_EN_CU_12_BASE_IDX                                                       0
#define mmSPI_RESOURCE_RESERVE_EN_CU_13                                                                0x11f9
#define mmSPI_RESOURCE_RESERVE_EN_CU_13_BASE_IDX                                                       0
#define mmSPI_RESOURCE_RESERVE_EN_CU_14                                                                0x11fa
#define mmSPI_RESOURCE_RESERVE_EN_CU_14_BASE_IDX                                                       0
#define mmSPI_RESOURCE_RESERVE_EN_CU_15                                                                0x11fb
#define mmSPI_RESOURCE_RESERVE_EN_CU_15_BASE_IDX                                                       0
#define mmSPI_COMPUTE_WF_CTX_SAVE                                                                      0x11fc
#define mmSPI_COMPUTE_WF_CTX_SAVE_BASE_IDX                                                             0
#define mmSPI_ARB_CNTL_0                                                                               0x11fd
#define mmSPI_ARB_CNTL_0_BASE_IDX                                                                      0


// addressBlock: gc_cpphqddec
// base address: 0xc800
#define mmCP_HQD_GFX_CONTROL                                                                           0x123e
#define mmCP_HQD_GFX_CONTROL_BASE_IDX                                                                  0
#define mmCP_HQD_GFX_STATUS                                                                            0x123f
#define mmCP_HQD_GFX_STATUS_BASE_IDX                                                                   0
#define mmCP_HPD_ROQ_OFFSETS                                                                           0x1240
#define mmCP_HPD_ROQ_OFFSETS_BASE_IDX                                                                  0
#define mmCP_HPD_STATUS0                                                                               0x1241
#define mmCP_HPD_STATUS0_BASE_IDX                                                                      0
#define mmCP_HPD_UTCL1_CNTL                                                                            0x1242
#define mmCP_HPD_UTCL1_CNTL_BASE_IDX                                                                   0
#define mmCP_HPD_UTCL1_ERROR                                                                           0x1243
#define mmCP_HPD_UTCL1_ERROR_BASE_IDX                                                                  0
#define mmCP_HPD_UTCL1_ERROR_ADDR                                                                      0x1244
#define mmCP_HPD_UTCL1_ERROR_ADDR_BASE_IDX                                                             0
#define mmCP_MQD_BASE_ADDR                                                                             0x1245
#define mmCP_MQD_BASE_ADDR_BASE_IDX                                                                    0
#define mmCP_MQD_BASE_ADDR_HI                                                                          0x1246
#define mmCP_MQD_BASE_ADDR_HI_BASE_IDX                                                                 0
#define mmCP_HQD_ACTIVE                                                                                0x1247
#define mmCP_HQD_ACTIVE_BASE_IDX                                                                       0
#define mmCP_HQD_VMID                                                                                  0x1248
#define mmCP_HQD_VMID_BASE_IDX                                                                         0
#define mmCP_HQD_PERSISTENT_STATE                                                                      0x1249
#define mmCP_HQD_PERSISTENT_STATE_BASE_IDX                                                             0
#define mmCP_HQD_PIPE_PRIORITY                                                                         0x124a
#define mmCP_HQD_PIPE_PRIORITY_BASE_IDX                                                                0
#define mmCP_HQD_QUEUE_PRIORITY                                                                        0x124b
#define mmCP_HQD_QUEUE_PRIORITY_BASE_IDX                                                               0
#define mmCP_HQD_QUANTUM                                                                               0x124c
#define mmCP_HQD_QUANTUM_BASE_IDX                                                                      0
#define mmCP_HQD_PQ_BASE                                                                               0x124d
#define mmCP_HQD_PQ_BASE_BASE_IDX                                                                      0
#define mmCP_HQD_PQ_BASE_HI                                                                            0x124e
#define mmCP_HQD_PQ_BASE_HI_BASE_IDX                                                                   0
#define mmCP_HQD_PQ_RPTR                                                                               0x124f
#define mmCP_HQD_PQ_RPTR_BASE_IDX                                                                      0
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR                                                                   0x1250
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR_BASE_IDX                                                          0
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR_HI                                                                0x1251
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR_HI_BASE_IDX                                                       0
#define mmCP_HQD_PQ_WPTR_POLL_ADDR                                                                     0x1252
#define mmCP_HQD_PQ_WPTR_POLL_ADDR_BASE_IDX                                                            0
#define mmCP_HQD_PQ_WPTR_POLL_ADDR_HI                                                                  0x1253
#define mmCP_HQD_PQ_WPTR_POLL_ADDR_HI_BASE_IDX                                                         0
#define mmCP_HQD_PQ_DOORBELL_CONTROL                                                                   0x1254
#define mmCP_HQD_PQ_DOORBELL_CONTROL_BASE_IDX                                                          0
#define mmCP_HQD_PQ_CONTROL                                                                            0x1256
#define mmCP_HQD_PQ_CONTROL_BASE_IDX                                                                   0
#define mmCP_HQD_IB_BASE_ADDR                                                                          0x1257
#define mmCP_HQD_IB_BASE_ADDR_BASE_IDX                                                                 0
#define mmCP_HQD_IB_BASE_ADDR_HI                                                                       0x1258
#define mmCP_HQD_IB_BASE_ADDR_HI_BASE_IDX                                                              0
#define mmCP_HQD_IB_RPTR                                                                               0x1259
#define mmCP_HQD_IB_RPTR_BASE_IDX                                                                      0
#define mmCP_HQD_IB_CONTROL                                                                            0x125a
#define mmCP_HQD_IB_CONTROL_BASE_IDX                                                                   0
#define mmCP_HQD_IQ_TIMER                                                                              0x125b
#define mmCP_HQD_IQ_TIMER_BASE_IDX                                                                     0
#define mmCP_HQD_IQ_RPTR                                                                               0x125c
#define mmCP_HQD_IQ_RPTR_BASE_IDX                                                                      0
#define mmCP_HQD_DEQUEUE_REQUEST                                                                       0x125d
#define mmCP_HQD_DEQUEUE_REQUEST_BASE_IDX                                                              0
#define mmCP_HQD_DMA_OFFLOAD                                                                           0x125e
#define mmCP_HQD_DMA_OFFLOAD_BASE_IDX                                                                  0
#define mmCP_HQD_OFFLOAD                                                                               0x125e
#define mmCP_HQD_OFFLOAD_BASE_IDX                                                                      0
#define mmCP_HQD_SEMA_CMD                                                                              0x125f
#define mmCP_HQD_SEMA_CMD_BASE_IDX                                                                     0
#define mmCP_HQD_MSG_TYPE                                                                              0x1260
#define mmCP_HQD_MSG_TYPE_BASE_IDX                                                                     0
#define mmCP_HQD_ATOMIC0_PREOP_LO                                                                      0x1261
#define mmCP_HQD_ATOMIC0_PREOP_LO_BASE_IDX                                                             0
#define mmCP_HQD_ATOMIC0_PREOP_HI                                                                      0x1262
#define mmCP_HQD_ATOMIC0_PREOP_HI_BASE_IDX                                                             0
#define mmCP_HQD_ATOMIC1_PREOP_LO                                                                      0x1263
#define mmCP_HQD_ATOMIC1_PREOP_LO_BASE_IDX                                                             0
#define mmCP_HQD_ATOMIC1_PREOP_HI                                                                      0x1264
#define mmCP_HQD_ATOMIC1_PREOP_HI_BASE_IDX                                                             0
#define mmCP_HQD_HQ_SCHEDULER0                                                                         0x1265
#define mmCP_HQD_HQ_SCHEDULER0_BASE_IDX                                                                0
#define mmCP_HQD_HQ_STATUS0                                                                            0x1265
#define mmCP_HQD_HQ_STATUS0_BASE_IDX                                                                   0
#define mmCP_HQD_HQ_CONTROL0                                                                           0x1266
#define mmCP_HQD_HQ_CONTROL0_BASE_IDX                                                                  0
#define mmCP_HQD_HQ_SCHEDULER1                                                                         0x1266
#define mmCP_HQD_HQ_SCHEDULER1_BASE_IDX                                                                0
#define mmCP_MQD_CONTROL                                                                               0x1267
#define mmCP_MQD_CONTROL_BASE_IDX                                                                      0
#define mmCP_HQD_HQ_STATUS1                                                                            0x1268
#define mmCP_HQD_HQ_STATUS1_BASE_IDX                                                                   0
#define mmCP_HQD_HQ_CONTROL1                                                                           0x1269
#define mmCP_HQD_HQ_CONTROL1_BASE_IDX                                                                  0
#define mmCP_HQD_EOP_BASE_ADDR                                                                         0x126a
#define mmCP_HQD_EOP_BASE_ADDR_BASE_IDX                                                                0
#define mmCP_HQD_EOP_BASE_ADDR_HI                                                                      0x126b
#define mmCP_HQD_EOP_BASE_ADDR_HI_BASE_IDX                                                             0
#define mmCP_HQD_EOP_CONTROL                                                                           0x126c
#define mmCP_HQD_EOP_CONTROL_BASE_IDX                                                                  0
#define mmCP_HQD_EOP_RPTR                                                                              0x126d
#define mmCP_HQD_EOP_RPTR_BASE_IDX                                                                     0
#define mmCP_HQD_EOP_WPTR                                                                              0x126e
#define mmCP_HQD_EOP_WPTR_BASE_IDX                                                                     0
#define mmCP_HQD_EOP_EVENTS                                                                            0x126f
#define mmCP_HQD_EOP_EVENTS_BASE_IDX                                                                   0
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_LO                                                                 0x1270
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_LO_BASE_IDX                                                        0
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_HI                                                                 0x1271
#define mmCP_HQD_CTX_SAVE_BASE_ADDR_HI_BASE_IDX                                                        0
#define mmCP_HQD_CTX_SAVE_CONTROL                                                                      0x1272
#define mmCP_HQD_CTX_SAVE_CONTROL_BASE_IDX                                                             0
#define mmCP_HQD_CNTL_STACK_OFFSET                                                                     0x1273
#define mmCP_HQD_CNTL_STACK_OFFSET_BASE_IDX                                                            0
#define mmCP_HQD_CNTL_STACK_SIZE                                                                       0x1274
#define mmCP_HQD_CNTL_STACK_SIZE_BASE_IDX                                                              0
#define mmCP_HQD_WG_STATE_OFFSET                                                                       0x1275
#define mmCP_HQD_WG_STATE_OFFSET_BASE_IDX                                                              0
#define mmCP_HQD_CTX_SAVE_SIZE                                                                         0x1276
#define mmCP_HQD_CTX_SAVE_SIZE_BASE_IDX                                                                0
#define mmCP_HQD_GDS_RESOURCE_STATE                                                                    0x1277
#define mmCP_HQD_GDS_RESOURCE_STATE_BASE_IDX                                                           0
#define mmCP_HQD_ERROR                                                                                 0x1278
#define mmCP_HQD_ERROR_BASE_IDX                                                                        0
#define mmCP_HQD_EOP_WPTR_MEM                                                                          0x1279
#define mmCP_HQD_EOP_WPTR_MEM_BASE_IDX                                                                 0
#define mmCP_HQD_AQL_CONTROL                                                                           0x127a
#define mmCP_HQD_AQL_CONTROL_BASE_IDX                                                                  0
#define mmCP_HQD_PQ_WPTR_LO                                                                            0x127b
#define mmCP_HQD_PQ_WPTR_LO_BASE_IDX                                                                   0
#define mmCP_HQD_PQ_WPTR_HI                                                                            0x127c
#define mmCP_HQD_PQ_WPTR_HI_BASE_IDX                                                                   0


// addressBlock: gc_didtdec
// base address: 0xca00
#define mmDIDT_IND_INDEX                                                                               0x1280
#define mmDIDT_IND_INDEX_BASE_IDX                                                                      0
#define mmDIDT_IND_DATA                                                                                0x1281
#define mmDIDT_IND_DATA_BASE_IDX                                                                       0


// addressBlock: gc_gccacdec
// base address: 0xca10
#define mmGC_CAC_CTRL_1                                                                                0x1284
#define mmGC_CAC_CTRL_1_BASE_IDX                                                                       0
#define mmGC_CAC_CTRL_2                                                                                0x1285
#define mmGC_CAC_CTRL_2_BASE_IDX                                                                       0
#define mmGC_CAC_CGTT_CLK_CTRL                                                                         0x1286
#define mmGC_CAC_CGTT_CLK_CTRL_BASE_IDX                                                                0
#define mmGC_CAC_AGGR_LOWER                                                                            0x1287
#define mmGC_CAC_AGGR_LOWER_BASE_IDX                                                                   0
#define mmGC_CAC_AGGR_UPPER                                                                            0x1288
#define mmGC_CAC_AGGR_UPPER_BASE_IDX                                                                   0
#define mmGC_CAC_PG_AGGR_LOWER                                                                         0x128b
#define mmGC_CAC_PG_AGGR_LOWER_BASE_IDX                                                                0
#define mmGC_CAC_PG_AGGR_UPPER                                                                         0x128c
#define mmGC_CAC_PG_AGGR_UPPER_BASE_IDX                                                                0
#define mmGC_CAC_SOFT_CTRL                                                                             0x128d
#define mmGC_CAC_SOFT_CTRL_BASE_IDX                                                                    0
#define mmGC_DIDT_CTRL0                                                                                0x128e
#define mmGC_DIDT_CTRL0_BASE_IDX                                                                       0
#define mmGC_DIDT_CTRL1                                                                                0x128f
#define mmGC_DIDT_CTRL1_BASE_IDX                                                                       0
#define mmGC_DIDT_CTRL2                                                                                0x1290
#define mmGC_DIDT_CTRL2_BASE_IDX                                                                       0
#define mmGC_DIDT_WEIGHT                                                                               0x1291
#define mmGC_DIDT_WEIGHT_BASE_IDX                                                                      0
#define mmGC_EDC_CTRL                                                                                  0x1293
#define mmGC_EDC_CTRL_BASE_IDX                                                                         0
#define mmGC_EDC_THRESHOLD                                                                             0x1294
#define mmGC_EDC_THRESHOLD_BASE_IDX                                                                    0
#define mmGC_EDC_STATUS                                                                                0x1295
#define mmGC_EDC_STATUS_BASE_IDX                                                                       0
#define mmGC_EDC_OVERFLOW                                                                              0x1296
#define mmGC_EDC_OVERFLOW_BASE_IDX                                                                     0
#define mmGC_EDC_ROLLING_POWER_DELTA                                                                   0x1297
#define mmGC_EDC_ROLLING_POWER_DELTA_BASE_IDX                                                          0
#define mmGC_DIDT_DROOP_CTRL                                                                           0x1298
#define mmGC_DIDT_DROOP_CTRL_BASE_IDX                                                                  0
#define mmGC_EDC_DROOP_CTRL                                                                            0x1299
#define mmGC_EDC_DROOP_CTRL_BASE_IDX                                                                   0
#define mmGC_CAC_IND_INDEX                                                                             0x129a
#define mmGC_CAC_IND_INDEX_BASE_IDX                                                                    0
#define mmGC_CAC_IND_DATA                                                                              0x129b
#define mmGC_CAC_IND_DATA_BASE_IDX                                                                     0
#define mmSE_CAC_CGTT_CLK_CTRL                                                                         0x129c
#define mmSE_CAC_CGTT_CLK_CTRL_BASE_IDX                                                                0
#define mmSE_CAC_IND_INDEX                                                                             0x129d
#define mmSE_CAC_IND_INDEX_BASE_IDX                                                                    0
#define mmSE_CAC_IND_DATA                                                                              0x129e
#define mmSE_CAC_IND_DATA_BASE_IDX                                                                     0


// addressBlock: gc_tcpdec
// base address: 0xca80
#define mmTCP_WATCH0_ADDR_H                                                                            0x12a0
#define mmTCP_WATCH0_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH0_ADDR_L                                                                            0x12a1
#define mmTCP_WATCH0_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH0_CNTL                                                                              0x12a2
#define mmTCP_WATCH0_CNTL_BASE_IDX                                                                     0
#define mmTCP_WATCH1_ADDR_H                                                                            0x12a3
#define mmTCP_WATCH1_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH1_ADDR_L                                                                            0x12a4
#define mmTCP_WATCH1_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH1_CNTL                                                                              0x12a5
#define mmTCP_WATCH1_CNTL_BASE_IDX                                                                     0
#define mmTCP_WATCH2_ADDR_H                                                                            0x12a6
#define mmTCP_WATCH2_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH2_ADDR_L                                                                            0x12a7
#define mmTCP_WATCH2_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH2_CNTL                                                                              0x12a8
#define mmTCP_WATCH2_CNTL_BASE_IDX                                                                     0
#define mmTCP_WATCH3_ADDR_H                                                                            0x12a9
#define mmTCP_WATCH3_ADDR_H_BASE_IDX                                                                   0
#define mmTCP_WATCH3_ADDR_L                                                                            0x12aa
#define mmTCP_WATCH3_ADDR_L_BASE_IDX                                                                   0
#define mmTCP_WATCH3_CNTL                                                                              0x12ab
#define mmTCP_WATCH3_CNTL_BASE_IDX                                                                     0
#define mmTCP_GATCL1_CNTL                                                                              0x12b0
#define mmTCP_GATCL1_CNTL_BASE_IDX                                                                     0
#define mmTCP_ATC_EDC_GATCL1_CNT                                                                       0x12b1
#define mmTCP_ATC_EDC_GATCL1_CNT_BASE_IDX                                                              0
#define mmTCP_GATCL1_DSM_CNTL                                                                          0x12b2
#define mmTCP_GATCL1_DSM_CNTL_BASE_IDX                                                                 0
#define mmTCP_CNTL2                                                                                    0x12b4
#define mmTCP_CNTL2_BASE_IDX                                                                           0
#define mmTCP_UTCL1_CNTL1                                                                              0x12b5
#define mmTCP_UTCL1_CNTL1_BASE_IDX                                                                     0
#define mmTCP_UTCL1_CNTL2                                                                              0x12b6
#define mmTCP_UTCL1_CNTL2_BASE_IDX                                                                     0
#define mmTCP_UTCL1_STATUS                                                                             0x12b7
#define mmTCP_UTCL1_STATUS_BASE_IDX                                                                    0
#define mmTCP_PERFCOUNTER_FILTER                                                                       0x12b9
#define mmTCP_PERFCOUNTER_FILTER_BASE_IDX                                                              0
#define mmTCP_PERFCOUNTER_FILTER_EN                                                                    0x12ba
#define mmTCP_PERFCOUNTER_FILTER_EN_BASE_IDX                                                           0


// addressBlock: gc_gdspdec
// base address: 0xcc00
#define mmGDS_VMID0_BASE                                                                               0x1300
#define mmGDS_VMID0_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID0_SIZE                                                                               0x1301
#define mmGDS_VMID0_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID1_BASE                                                                               0x1302
#define mmGDS_VMID1_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID1_SIZE                                                                               0x1303
#define mmGDS_VMID1_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID2_BASE                                                                               0x1304
#define mmGDS_VMID2_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID2_SIZE                                                                               0x1305
#define mmGDS_VMID2_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID3_BASE                                                                               0x1306
#define mmGDS_VMID3_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID3_SIZE                                                                               0x1307
#define mmGDS_VMID3_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID4_BASE                                                                               0x1308
#define mmGDS_VMID4_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID4_SIZE                                                                               0x1309
#define mmGDS_VMID4_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID5_BASE                                                                               0x130a
#define mmGDS_VMID5_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID5_SIZE                                                                               0x130b
#define mmGDS_VMID5_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID6_BASE                                                                               0x130c
#define mmGDS_VMID6_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID6_SIZE                                                                               0x130d
#define mmGDS_VMID6_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID7_BASE                                                                               0x130e
#define mmGDS_VMID7_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID7_SIZE                                                                               0x130f
#define mmGDS_VMID7_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID8_BASE                                                                               0x1310
#define mmGDS_VMID8_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID8_SIZE                                                                               0x1311
#define mmGDS_VMID8_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID9_BASE                                                                               0x1312
#define mmGDS_VMID9_BASE_BASE_IDX                                                                      0
#define mmGDS_VMID9_SIZE                                                                               0x1313
#define mmGDS_VMID9_SIZE_BASE_IDX                                                                      0
#define mmGDS_VMID10_BASE                                                                              0x1314
#define mmGDS_VMID10_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID10_SIZE                                                                              0x1315
#define mmGDS_VMID10_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID11_BASE                                                                              0x1316
#define mmGDS_VMID11_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID11_SIZE                                                                              0x1317
#define mmGDS_VMID11_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID12_BASE                                                                              0x1318
#define mmGDS_VMID12_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID12_SIZE                                                                              0x1319
#define mmGDS_VMID12_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID13_BASE                                                                              0x131a
#define mmGDS_VMID13_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID13_SIZE                                                                              0x131b
#define mmGDS_VMID13_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID14_BASE                                                                              0x131c
#define mmGDS_VMID14_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID14_SIZE                                                                              0x131d
#define mmGDS_VMID14_SIZE_BASE_IDX                                                                     0
#define mmGDS_VMID15_BASE                                                                              0x131e
#define mmGDS_VMID15_BASE_BASE_IDX                                                                     0
#define mmGDS_VMID15_SIZE                                                                              0x131f
#define mmGDS_VMID15_SIZE_BASE_IDX                                                                     0
#define mmGDS_GWS_VMID0                                                                                0x1320
#define mmGDS_GWS_VMID0_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID1                                                                                0x1321
#define mmGDS_GWS_VMID1_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID2                                                                                0x1322
#define mmGDS_GWS_VMID2_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID3                                                                                0x1323
#define mmGDS_GWS_VMID3_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID4                                                                                0x1324
#define mmGDS_GWS_VMID4_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID5                                                                                0x1325
#define mmGDS_GWS_VMID5_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID6                                                                                0x1326
#define mmGDS_GWS_VMID6_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID7                                                                                0x1327
#define mmGDS_GWS_VMID7_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID8                                                                                0x1328
#define mmGDS_GWS_VMID8_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID9                                                                                0x1329
#define mmGDS_GWS_VMID9_BASE_IDX                                                                       0
#define mmGDS_GWS_VMID10                                                                               0x132a
#define mmGDS_GWS_VMID10_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID11                                                                               0x132b
#define mmGDS_GWS_VMID11_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID12                                                                               0x132c
#define mmGDS_GWS_VMID12_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID13                                                                               0x132d
#define mmGDS_GWS_VMID13_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID14                                                                               0x132e
#define mmGDS_GWS_VMID14_BASE_IDX                                                                      0
#define mmGDS_GWS_VMID15                                                                               0x132f
#define mmGDS_GWS_VMID15_BASE_IDX                                                                      0
#define mmGDS_OA_VMID0                                                                                 0x1330
#define mmGDS_OA_VMID0_BASE_IDX                                                                        0
#define mmGDS_OA_VMID1                                                                                 0x1331
#define mmGDS_OA_VMID1_BASE_IDX                                                                        0
#define mmGDS_OA_VMID2                                                                                 0x1332
#define mmGDS_OA_VMID2_BASE_IDX                                                                        0
#define mmGDS_OA_VMID3                                                                                 0x1333
#define mmGDS_OA_VMID3_BASE_IDX                                                                        0
#define mmGDS_OA_VMID4                                                                                 0x1334
#define mmGDS_OA_VMID4_BASE_IDX                                                                        0
#define mmGDS_OA_VMID5                                                                                 0x1335
#define mmGDS_OA_VMID5_BASE_IDX                                                                        0
#define mmGDS_OA_VMID6                                                                                 0x1336
#define mmGDS_OA_VMID6_BASE_IDX                                                                        0
#define mmGDS_OA_VMID7                                                                                 0x1337
#define mmGDS_OA_VMID7_BASE_IDX                                                                        0
#define mmGDS_OA_VMID8                                                                                 0x1338
#define mmGDS_OA_VMID8_BASE_IDX                                                                        0
#define mmGDS_OA_VMID9                                                                                 0x1339
#define mmGDS_OA_VMID9_BASE_IDX                                                                        0
#define mmGDS_OA_VMID10                                                                                0x133a
#define mmGDS_OA_VMID10_BASE_IDX                                                                       0
#define mmGDS_OA_VMID11                                                                                0x133b
#define mmGDS_OA_VMID11_BASE_IDX                                                                       0
#define mmGDS_OA_VMID12                                                                                0x133c
#define mmGDS_OA_VMID12_BASE_IDX                                                                       0
#define mmGDS_OA_VMID13                                                                                0x133d
#define mmGDS_OA_VMID13_BASE_IDX                                                                       0
#define mmGDS_OA_VMID14                                                                                0x133e
#define mmGDS_OA_VMID14_BASE_IDX                                                                       0
#define mmGDS_OA_VMID15                                                                                0x133f
#define mmGDS_OA_VMID15_BASE_IDX                                                                       0
#define mmGDS_GWS_RESET0                                                                               0x1344
#define mmGDS_GWS_RESET0_BASE_IDX                                                                      0
#define mmGDS_GWS_RESET1                                                                               0x1345
#define mmGDS_GWS_RESET1_BASE_IDX                                                                      0
#define mmGDS_GWS_RESOURCE_RESET                                                                       0x1346
#define mmGDS_GWS_RESOURCE_RESET_BASE_IDX                                                              0
#define mmGDS_COMPUTE_MAX_WAVE_ID                                                                      0x1348
#define mmGDS_COMPUTE_MAX_WAVE_ID_BASE_IDX                                                             0
#define mmGDS_OA_RESET_MASK                                                                            0x1349
#define mmGDS_OA_RESET_MASK_BASE_IDX                                                                   0
#define mmGDS_OA_RESET                                                                                 0x134a
#define mmGDS_OA_RESET_BASE_IDX                                                                        0
#define mmGDS_ENHANCE                                                                                  0x134b
#define mmGDS_ENHANCE_BASE_IDX                                                                         0
#define mmGDS_OA_CGPG_RESTORE                                                                          0x134c
#define mmGDS_OA_CGPG_RESTORE_BASE_IDX                                                                 0
#define mmGDS_CS_CTXSW_STATUS                                                                          0x134d
#define mmGDS_CS_CTXSW_STATUS_BASE_IDX                                                                 0
#define mmGDS_CS_CTXSW_CNT0                                                                            0x134e
#define mmGDS_CS_CTXSW_CNT0_BASE_IDX                                                                   0
#define mmGDS_CS_CTXSW_CNT1                                                                            0x134f
#define mmGDS_CS_CTXSW_CNT1_BASE_IDX                                                                   0
#define mmGDS_CS_CTXSW_CNT2                                                                            0x1350
#define mmGDS_CS_CTXSW_CNT2_BASE_IDX                                                                   0
#define mmGDS_CS_CTXSW_CNT3                                                                            0x1351
#define mmGDS_CS_CTXSW_CNT3_BASE_IDX                                                                   0
#define mmGDS_GFX_CTXSW_STATUS                                                                         0x1352
#define mmGDS_GFX_CTXSW_STATUS_BASE_IDX                                                                0
#define mmGDS_VS_CTXSW_CNT0                                                                            0x1353
#define mmGDS_VS_CTXSW_CNT0_BASE_IDX                                                                   0
#define mmGDS_VS_CTXSW_CNT1                                                                            0x1354
#define mmGDS_VS_CTXSW_CNT1_BASE_IDX                                                                   0
#define mmGDS_VS_CTXSW_CNT2                                                                            0x1355
#define mmGDS_VS_CTXSW_CNT2_BASE_IDX                                                                   0
#define mmGDS_VS_CTXSW_CNT3                                                                            0x1356
#define mmGDS_VS_CTXSW_CNT3_BASE_IDX                                                                   0
#define mmGDS_PS0_CTXSW_CNT0                                                                           0x1357
#define mmGDS_PS0_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS0_CTXSW_CNT1                                                                           0x1358
#define mmGDS_PS0_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS0_CTXSW_CNT2                                                                           0x1359
#define mmGDS_PS0_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS0_CTXSW_CNT3                                                                           0x135a
#define mmGDS_PS0_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_PS1_CTXSW_CNT0                                                                           0x135b
#define mmGDS_PS1_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS1_CTXSW_CNT1                                                                           0x135c
#define mmGDS_PS1_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS1_CTXSW_CNT2                                                                           0x135d
#define mmGDS_PS1_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS1_CTXSW_CNT3                                                                           0x135e
#define mmGDS_PS1_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_PS2_CTXSW_CNT0                                                                           0x135f
#define mmGDS_PS2_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS2_CTXSW_CNT1                                                                           0x1360
#define mmGDS_PS2_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS2_CTXSW_CNT2                                                                           0x1361
#define mmGDS_PS2_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS2_CTXSW_CNT3                                                                           0x1362
#define mmGDS_PS2_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_PS3_CTXSW_CNT0                                                                           0x1363
#define mmGDS_PS3_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS3_CTXSW_CNT1                                                                           0x1364
#define mmGDS_PS3_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS3_CTXSW_CNT2                                                                           0x1365
#define mmGDS_PS3_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS3_CTXSW_CNT3                                                                           0x1366
#define mmGDS_PS3_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_PS4_CTXSW_CNT0                                                                           0x1367
#define mmGDS_PS4_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS4_CTXSW_CNT1                                                                           0x1368
#define mmGDS_PS4_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS4_CTXSW_CNT2                                                                           0x1369
#define mmGDS_PS4_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS4_CTXSW_CNT3                                                                           0x136a
#define mmGDS_PS4_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_PS5_CTXSW_CNT0                                                                           0x136b
#define mmGDS_PS5_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS5_CTXSW_CNT1                                                                           0x136c
#define mmGDS_PS5_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS5_CTXSW_CNT2                                                                           0x136d
#define mmGDS_PS5_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS5_CTXSW_CNT3                                                                           0x136e
#define mmGDS_PS5_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_PS6_CTXSW_CNT0                                                                           0x136f
#define mmGDS_PS6_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS6_CTXSW_CNT1                                                                           0x1370
#define mmGDS_PS6_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS6_CTXSW_CNT2                                                                           0x1371
#define mmGDS_PS6_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS6_CTXSW_CNT3                                                                           0x1372
#define mmGDS_PS6_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_PS7_CTXSW_CNT0                                                                           0x1373
#define mmGDS_PS7_CTXSW_CNT0_BASE_IDX                                                                  0
#define mmGDS_PS7_CTXSW_CNT1                                                                           0x1374
#define mmGDS_PS7_CTXSW_CNT1_BASE_IDX                                                                  0
#define mmGDS_PS7_CTXSW_CNT2                                                                           0x1375
#define mmGDS_PS7_CTXSW_CNT2_BASE_IDX                                                                  0
#define mmGDS_PS7_CTXSW_CNT3                                                                           0x1376
#define mmGDS_PS7_CTXSW_CNT3_BASE_IDX                                                                  0
#define mmGDS_GS_CTXSW_CNT0                                                                            0x1377
#define mmGDS_GS_CTXSW_CNT0_BASE_IDX                                                                   0
#define mmGDS_GS_CTXSW_CNT1                                                                            0x1378
#define mmGDS_GS_CTXSW_CNT1_BASE_IDX                                                                   0
#define mmGDS_GS_CTXSW_CNT2                                                                            0x1379
#define mmGDS_GS_CTXSW_CNT2_BASE_IDX                                                                   0
#define mmGDS_GS_CTXSW_CNT3                                                                            0x137a
#define mmGDS_GS_CTXSW_CNT3_BASE_IDX                                                                   0


// addressBlock: gc_rasdec
// base address: 0xce00
#define mmRAS_SIGNATURE_CONTROL                                                                        0x1380
#define mmRAS_SIGNATURE_CONTROL_BASE_IDX                                                               0
#define mmRAS_SIGNATURE_MASK                                                                           0x1381
#define mmRAS_SIGNATURE_MASK_BASE_IDX                                                                  0
#define mmRAS_SX_SIGNATURE0                                                                            0x1382
#define mmRAS_SX_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_SX_SIGNATURE1                                                                            0x1383
#define mmRAS_SX_SIGNATURE1_BASE_IDX                                                                   0
#define mmRAS_SX_SIGNATURE2                                                                            0x1384
#define mmRAS_SX_SIGNATURE2_BASE_IDX                                                                   0
#define mmRAS_SX_SIGNATURE3                                                                            0x1385
#define mmRAS_SX_SIGNATURE3_BASE_IDX                                                                   0
#define mmRAS_DB_SIGNATURE0                                                                            0x138b
#define mmRAS_DB_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_PA_SIGNATURE0                                                                            0x138c
#define mmRAS_PA_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_VGT_SIGNATURE0                                                                           0x138d
#define mmRAS_VGT_SIGNATURE0_BASE_IDX                                                                  0
#define mmRAS_SQ_SIGNATURE0                                                                            0x138e
#define mmRAS_SQ_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE0                                                                            0x138f
#define mmRAS_SC_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE1                                                                            0x1390
#define mmRAS_SC_SIGNATURE1_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE2                                                                            0x1391
#define mmRAS_SC_SIGNATURE2_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE3                                                                            0x1392
#define mmRAS_SC_SIGNATURE3_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE4                                                                            0x1393
#define mmRAS_SC_SIGNATURE4_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE5                                                                            0x1394
#define mmRAS_SC_SIGNATURE5_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE6                                                                            0x1395
#define mmRAS_SC_SIGNATURE6_BASE_IDX                                                                   0
#define mmRAS_SC_SIGNATURE7                                                                            0x1396
#define mmRAS_SC_SIGNATURE7_BASE_IDX                                                                   0
#define mmRAS_IA_SIGNATURE0                                                                            0x1397
#define mmRAS_IA_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_IA_SIGNATURE1                                                                            0x1398
#define mmRAS_IA_SIGNATURE1_BASE_IDX                                                                   0
#define mmRAS_SPI_SIGNATURE0                                                                           0x1399
#define mmRAS_SPI_SIGNATURE0_BASE_IDX                                                                  0
#define mmRAS_SPI_SIGNATURE1                                                                           0x139a
#define mmRAS_SPI_SIGNATURE1_BASE_IDX                                                                  0
#define mmRAS_TA_SIGNATURE0                                                                            0x139b
#define mmRAS_TA_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_TD_SIGNATURE0                                                                            0x139c
#define mmRAS_TD_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_CB_SIGNATURE0                                                                            0x139d
#define mmRAS_CB_SIGNATURE0_BASE_IDX                                                                   0
#define mmRAS_BCI_SIGNATURE0                                                                           0x139e
#define mmRAS_BCI_SIGNATURE0_BASE_IDX                                                                  0
#define mmRAS_BCI_SIGNATURE1                                                                           0x139f
#define mmRAS_BCI_SIGNATURE1_BASE_IDX                                                                  0
#define mmRAS_TA_SIGNATURE1                                                                            0x13a0
#define mmRAS_TA_SIGNATURE1_BASE_IDX                                                                   0


// addressBlock: gc_gfxdec0
// base address: 0x28000
#define mmDB_RENDER_CONTROL                                                                            0x0000
#define mmDB_RENDER_CONTROL_BASE_IDX                                                                   1
#define mmDB_COUNT_CONTROL                                                                             0x0001
#define mmDB_COUNT_CONTROL_BASE_IDX                                                                    1
#define mmDB_DEPTH_VIEW                                                                                0x0002
#define mmDB_DEPTH_VIEW_BASE_IDX                                                                       1
#define mmDB_RENDER_OVERRIDE                                                                           0x0003
#define mmDB_RENDER_OVERRIDE_BASE_IDX                                                                  1
#define mmDB_RENDER_OVERRIDE2                                                                          0x0004
#define mmDB_RENDER_OVERRIDE2_BASE_IDX                                                                 1
#define mmDB_HTILE_DATA_BASE                                                                           0x0005
#define mmDB_HTILE_DATA_BASE_BASE_IDX                                                                  1
#define mmDB_HTILE_DATA_BASE_HI                                                                        0x0006
#define mmDB_HTILE_DATA_BASE_HI_BASE_IDX                                                               1
#define mmDB_DEPTH_SIZE                                                                                0x0007
#define mmDB_DEPTH_SIZE_BASE_IDX                                                                       1
#define mmDB_DEPTH_BOUNDS_MIN                                                                          0x0008
#define mmDB_DEPTH_BOUNDS_MIN_BASE_IDX                                                                 1
#define mmDB_DEPTH_BOUNDS_MAX                                                                          0x0009
#define mmDB_DEPTH_BOUNDS_MAX_BASE_IDX                                                                 1
#define mmDB_STENCIL_CLEAR                                                                             0x000a
#define mmDB_STENCIL_CLEAR_BASE_IDX                                                                    1
#define mmDB_DEPTH_CLEAR                                                                               0x000b
#define mmDB_DEPTH_CLEAR_BASE_IDX                                                                      1
#define mmPA_SC_SCREEN_SCISSOR_TL                                                                      0x000c
#define mmPA_SC_SCREEN_SCISSOR_TL_BASE_IDX                                                             1
#define mmPA_SC_SCREEN_SCISSOR_BR                                                                      0x000d
#define mmPA_SC_SCREEN_SCISSOR_BR_BASE_IDX                                                             1
#define mmDB_Z_INFO                                                                                    0x000e
#define mmDB_Z_INFO_BASE_IDX                                                                           1
#define mmDB_STENCIL_INFO                                                                              0x000f
#define mmDB_STENCIL_INFO_BASE_IDX                                                                     1
#define mmDB_Z_READ_BASE                                                                               0x0010
#define mmDB_Z_READ_BASE_BASE_IDX                                                                      1
#define mmDB_Z_READ_BASE_HI                                                                            0x0011
#define mmDB_Z_READ_BASE_HI_BASE_IDX                                                                   1
#define mmDB_STENCIL_READ_BASE                                                                         0x0012
#define mmDB_STENCIL_READ_BASE_BASE_IDX                                                                1
#define mmDB_STENCIL_READ_BASE_HI                                                                      0x0013
#define mmDB_STENCIL_READ_BASE_HI_BASE_IDX                                                             1
#define mmDB_Z_WRITE_BASE                                                                              0x0014
#define mmDB_Z_WRITE_BASE_BASE_IDX                                                                     1
#define mmDB_Z_WRITE_BASE_HI                                                                           0x0015
#define mmDB_Z_WRITE_BASE_HI_BASE_IDX                                                                  1
#define mmDB_STENCIL_WRITE_BASE                                                                        0x0016
#define mmDB_STENCIL_WRITE_BASE_BASE_IDX                                                               1
#define mmDB_STENCIL_WRITE_BASE_HI                                                                     0x0017
#define mmDB_STENCIL_WRITE_BASE_HI_BASE_IDX                                                            1
#define mmDB_DFSM_CONTROL                                                                              0x0018
#define mmDB_DFSM_CONTROL_BASE_IDX                                                                     1
#define mmDB_Z_INFO2                                                                                   0x001a
#define mmDB_Z_INFO2_BASE_IDX                                                                          1
#define mmDB_STENCIL_INFO2                                                                             0x001b
#define mmDB_STENCIL_INFO2_BASE_IDX                                                                    1
#define mmTA_BC_BASE_ADDR                                                                              0x0020
#define mmTA_BC_BASE_ADDR_BASE_IDX                                                                     1
#define mmTA_BC_BASE_ADDR_HI                                                                           0x0021
#define mmTA_BC_BASE_ADDR_HI_BASE_IDX                                                                  1
#define mmCOHER_DEST_BASE_HI_0                                                                         0x007a
#define mmCOHER_DEST_BASE_HI_0_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_HI_1                                                                         0x007b
#define mmCOHER_DEST_BASE_HI_1_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_HI_2                                                                         0x007c
#define mmCOHER_DEST_BASE_HI_2_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_HI_3                                                                         0x007d
#define mmCOHER_DEST_BASE_HI_3_BASE_IDX                                                                1
#define mmCOHER_DEST_BASE_2                                                                            0x007e
#define mmCOHER_DEST_BASE_2_BASE_IDX                                                                   1
#define mmCOHER_DEST_BASE_3                                                                            0x007f
#define mmCOHER_DEST_BASE_3_BASE_IDX                                                                   1
#define mmPA_SC_WINDOW_OFFSET                                                                          0x0080
#define mmPA_SC_WINDOW_OFFSET_BASE_IDX                                                                 1
#define mmPA_SC_WINDOW_SCISSOR_TL                                                                      0x0081
#define mmPA_SC_WINDOW_SCISSOR_TL_BASE_IDX                                                             1
#define mmPA_SC_WINDOW_SCISSOR_BR                                                                      0x0082
#define mmPA_SC_WINDOW_SCISSOR_BR_BASE_IDX                                                             1
#define mmPA_SC_CLIPRECT_RULE                                                                          0x0083
#define mmPA_SC_CLIPRECT_RULE_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_0_TL                                                                          0x0084
#define mmPA_SC_CLIPRECT_0_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_0_BR                                                                          0x0085
#define mmPA_SC_CLIPRECT_0_BR_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_1_TL                                                                          0x0086
#define mmPA_SC_CLIPRECT_1_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_1_BR                                                                          0x0087
#define mmPA_SC_CLIPRECT_1_BR_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_2_TL                                                                          0x0088
#define mmPA_SC_CLIPRECT_2_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_2_BR                                                                          0x0089
#define mmPA_SC_CLIPRECT_2_BR_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_3_TL                                                                          0x008a
#define mmPA_SC_CLIPRECT_3_TL_BASE_IDX                                                                 1
#define mmPA_SC_CLIPRECT_3_BR                                                                          0x008b
#define mmPA_SC_CLIPRECT_3_BR_BASE_IDX                                                                 1
#define mmPA_SC_EDGERULE                                                                               0x008c
#define mmPA_SC_EDGERULE_BASE_IDX                                                                      1
#define mmPA_SU_HARDWARE_SCREEN_OFFSET                                                                 0x008d
#define mmPA_SU_HARDWARE_SCREEN_OFFSET_BASE_IDX                                                        1
#define mmCB_TARGET_MASK                                                                               0x008e
#define mmCB_TARGET_MASK_BASE_IDX                                                                      1
#define mmCB_SHADER_MASK                                                                               0x008f
#define mmCB_SHADER_MASK_BASE_IDX                                                                      1
#define mmPA_SC_GENERIC_SCISSOR_TL                                                                     0x0090
#define mmPA_SC_GENERIC_SCISSOR_TL_BASE_IDX                                                            1
#define mmPA_SC_GENERIC_SCISSOR_BR                                                                     0x0091
#define mmPA_SC_GENERIC_SCISSOR_BR_BASE_IDX                                                            1
#define mmCOHER_DEST_BASE_0                                                                            0x0092
#define mmCOHER_DEST_BASE_0_BASE_IDX                                                                   1
#define mmCOHER_DEST_BASE_1                                                                            0x0093
#define mmCOHER_DEST_BASE_1_BASE_IDX                                                                   1
#define mmPA_SC_VPORT_SCISSOR_0_TL                                                                     0x0094
#define mmPA_SC_VPORT_SCISSOR_0_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_0_BR                                                                     0x0095
#define mmPA_SC_VPORT_SCISSOR_0_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_1_TL                                                                     0x0096
#define mmPA_SC_VPORT_SCISSOR_1_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_1_BR                                                                     0x0097
#define mmPA_SC_VPORT_SCISSOR_1_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_2_TL                                                                     0x0098
#define mmPA_SC_VPORT_SCISSOR_2_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_2_BR                                                                     0x0099
#define mmPA_SC_VPORT_SCISSOR_2_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_3_TL                                                                     0x009a
#define mmPA_SC_VPORT_SCISSOR_3_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_3_BR                                                                     0x009b
#define mmPA_SC_VPORT_SCISSOR_3_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_4_TL                                                                     0x009c
#define mmPA_SC_VPORT_SCISSOR_4_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_4_BR                                                                     0x009d
#define mmPA_SC_VPORT_SCISSOR_4_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_5_TL                                                                     0x009e
#define mmPA_SC_VPORT_SCISSOR_5_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_5_BR                                                                     0x009f
#define mmPA_SC_VPORT_SCISSOR_5_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_6_TL                                                                     0x00a0
#define mmPA_SC_VPORT_SCISSOR_6_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_6_BR                                                                     0x00a1
#define mmPA_SC_VPORT_SCISSOR_6_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_7_TL                                                                     0x00a2
#define mmPA_SC_VPORT_SCISSOR_7_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_7_BR                                                                     0x00a3
#define mmPA_SC_VPORT_SCISSOR_7_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_8_TL                                                                     0x00a4
#define mmPA_SC_VPORT_SCISSOR_8_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_8_BR                                                                     0x00a5
#define mmPA_SC_VPORT_SCISSOR_8_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_9_TL                                                                     0x00a6
#define mmPA_SC_VPORT_SCISSOR_9_TL_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_9_BR                                                                     0x00a7
#define mmPA_SC_VPORT_SCISSOR_9_BR_BASE_IDX                                                            1
#define mmPA_SC_VPORT_SCISSOR_10_TL                                                                    0x00a8
#define mmPA_SC_VPORT_SCISSOR_10_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_10_BR                                                                    0x00a9
#define mmPA_SC_VPORT_SCISSOR_10_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_11_TL                                                                    0x00aa
#define mmPA_SC_VPORT_SCISSOR_11_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_11_BR                                                                    0x00ab
#define mmPA_SC_VPORT_SCISSOR_11_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_12_TL                                                                    0x00ac
#define mmPA_SC_VPORT_SCISSOR_12_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_12_BR                                                                    0x00ad
#define mmPA_SC_VPORT_SCISSOR_12_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_13_TL                                                                    0x00ae
#define mmPA_SC_VPORT_SCISSOR_13_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_13_BR                                                                    0x00af
#define mmPA_SC_VPORT_SCISSOR_13_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_14_TL                                                                    0x00b0
#define mmPA_SC_VPORT_SCISSOR_14_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_14_BR                                                                    0x00b1
#define mmPA_SC_VPORT_SCISSOR_14_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_15_TL                                                                    0x00b2
#define mmPA_SC_VPORT_SCISSOR_15_TL_BASE_IDX                                                           1
#define mmPA_SC_VPORT_SCISSOR_15_BR                                                                    0x00b3
#define mmPA_SC_VPORT_SCISSOR_15_BR_BASE_IDX                                                           1
#define mmPA_SC_VPORT_ZMIN_0                                                                           0x00b4
#define mmPA_SC_VPORT_ZMIN_0_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_0                                                                           0x00b5
#define mmPA_SC_VPORT_ZMAX_0_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_1                                                                           0x00b6
#define mmPA_SC_VPORT_ZMIN_1_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_1                                                                           0x00b7
#define mmPA_SC_VPORT_ZMAX_1_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_2                                                                           0x00b8
#define mmPA_SC_VPORT_ZMIN_2_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_2                                                                           0x00b9
#define mmPA_SC_VPORT_ZMAX_2_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_3                                                                           0x00ba
#define mmPA_SC_VPORT_ZMIN_3_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_3                                                                           0x00bb
#define mmPA_SC_VPORT_ZMAX_3_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_4                                                                           0x00bc
#define mmPA_SC_VPORT_ZMIN_4_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_4                                                                           0x00bd
#define mmPA_SC_VPORT_ZMAX_4_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_5                                                                           0x00be
#define mmPA_SC_VPORT_ZMIN_5_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_5                                                                           0x00bf
#define mmPA_SC_VPORT_ZMAX_5_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_6                                                                           0x00c0
#define mmPA_SC_VPORT_ZMIN_6_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_6                                                                           0x00c1
#define mmPA_SC_VPORT_ZMAX_6_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_7                                                                           0x00c2
#define mmPA_SC_VPORT_ZMIN_7_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_7                                                                           0x00c3
#define mmPA_SC_VPORT_ZMAX_7_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_8                                                                           0x00c4
#define mmPA_SC_VPORT_ZMIN_8_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_8                                                                           0x00c5
#define mmPA_SC_VPORT_ZMAX_8_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_9                                                                           0x00c6
#define mmPA_SC_VPORT_ZMIN_9_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMAX_9                                                                           0x00c7
#define mmPA_SC_VPORT_ZMAX_9_BASE_IDX                                                                  1
#define mmPA_SC_VPORT_ZMIN_10                                                                          0x00c8
#define mmPA_SC_VPORT_ZMIN_10_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_10                                                                          0x00c9
#define mmPA_SC_VPORT_ZMAX_10_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_11                                                                          0x00ca
#define mmPA_SC_VPORT_ZMIN_11_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_11                                                                          0x00cb
#define mmPA_SC_VPORT_ZMAX_11_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_12                                                                          0x00cc
#define mmPA_SC_VPORT_ZMIN_12_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_12                                                                          0x00cd
#define mmPA_SC_VPORT_ZMAX_12_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_13                                                                          0x00ce
#define mmPA_SC_VPORT_ZMIN_13_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_13                                                                          0x00cf
#define mmPA_SC_VPORT_ZMAX_13_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_14                                                                          0x00d0
#define mmPA_SC_VPORT_ZMIN_14_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_14                                                                          0x00d1
#define mmPA_SC_VPORT_ZMAX_14_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMIN_15                                                                          0x00d2
#define mmPA_SC_VPORT_ZMIN_15_BASE_IDX                                                                 1
#define mmPA_SC_VPORT_ZMAX_15                                                                          0x00d3
#define mmPA_SC_VPORT_ZMAX_15_BASE_IDX                                                                 1
#define mmPA_SC_RASTER_CONFIG                                                                          0x00d4
#define mmPA_SC_RASTER_CONFIG_BASE_IDX                                                                 1
#define mmPA_SC_RASTER_CONFIG_1                                                                        0x00d5
#define mmPA_SC_RASTER_CONFIG_1_BASE_IDX                                                               1
#define mmPA_SC_SCREEN_EXTENT_CONTROL                                                                  0x00d6
#define mmPA_SC_SCREEN_EXTENT_CONTROL_BASE_IDX                                                         1
#define mmPA_SC_TILE_STEERING_OVERRIDE                                                                 0x00d7
#define mmPA_SC_TILE_STEERING_OVERRIDE_BASE_IDX                                                        1
#define mmCP_PERFMON_CNTX_CNTL                                                                         0x00d8
#define mmCP_PERFMON_CNTX_CNTL_BASE_IDX                                                                1
#define mmCP_PIPEID                                                                                    0x00d9
#define mmCP_PIPEID_BASE_IDX                                                                           1
#define mmCP_RINGID                                                                                    0x00d9
#define mmCP_RINGID_BASE_IDX                                                                           1
#define mmCP_VMID                                                                                      0x00da
#define mmCP_VMID_BASE_IDX                                                                             1
#define mmPA_SC_RIGHT_VERT_GRID                                                                        0x00e8
#define mmPA_SC_RIGHT_VERT_GRID_BASE_IDX                                                               1
#define mmPA_SC_LEFT_VERT_GRID                                                                         0x00e9
#define mmPA_SC_LEFT_VERT_GRID_BASE_IDX                                                                1
#define mmPA_SC_HORIZ_GRID                                                                             0x00ea
#define mmPA_SC_HORIZ_GRID_BASE_IDX                                                                    1
#define mmVGT_MULTI_PRIM_IB_RESET_INDX                                                                 0x0103
#define mmVGT_MULTI_PRIM_IB_RESET_INDX_BASE_IDX                                                        1
#define mmCB_BLEND_RED                                                                                 0x0105
#define mmCB_BLEND_RED_BASE_IDX                                                                        1
#define mmCB_BLEND_GREEN                                                                               0x0106
#define mmCB_BLEND_GREEN_BASE_IDX                                                                      1
#define mmCB_BLEND_BLUE                                                                                0x0107
#define mmCB_BLEND_BLUE_BASE_IDX                                                                       1
#define mmCB_BLEND_ALPHA                                                                               0x0108
#define mmCB_BLEND_ALPHA_BASE_IDX                                                                      1
#define mmCB_DCC_CONTROL                                                                               0x0109
#define mmCB_DCC_CONTROL_BASE_IDX                                                                      1
#define mmDB_STENCIL_CONTROL                                                                           0x010b
#define mmDB_STENCIL_CONTROL_BASE_IDX                                                                  1
#define mmDB_STENCILREFMASK                                                                            0x010c
#define mmDB_STENCILREFMASK_BASE_IDX                                                                   1
#define mmDB_STENCILREFMASK_BF                                                                         0x010d
#define mmDB_STENCILREFMASK_BF_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XSCALE                                                                           0x010f
#define mmPA_CL_VPORT_XSCALE_BASE_IDX                                                                  1
#define mmPA_CL_VPORT_XOFFSET                                                                          0x0110
#define mmPA_CL_VPORT_XOFFSET_BASE_IDX                                                                 1
#define mmPA_CL_VPORT_YSCALE                                                                           0x0111
#define mmPA_CL_VPORT_YSCALE_BASE_IDX                                                                  1
#define mmPA_CL_VPORT_YOFFSET                                                                          0x0112
#define mmPA_CL_VPORT_YOFFSET_BASE_IDX                                                                 1
#define mmPA_CL_VPORT_ZSCALE                                                                           0x0113
#define mmPA_CL_VPORT_ZSCALE_BASE_IDX                                                                  1
#define mmPA_CL_VPORT_ZOFFSET                                                                          0x0114
#define mmPA_CL_VPORT_ZOFFSET_BASE_IDX                                                                 1
#define mmPA_CL_VPORT_XSCALE_1                                                                         0x0115
#define mmPA_CL_VPORT_XSCALE_1_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_1                                                                        0x0116
#define mmPA_CL_VPORT_XOFFSET_1_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_1                                                                         0x0117
#define mmPA_CL_VPORT_YSCALE_1_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_1                                                                        0x0118
#define mmPA_CL_VPORT_YOFFSET_1_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_1                                                                         0x0119
#define mmPA_CL_VPORT_ZSCALE_1_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_1                                                                        0x011a
#define mmPA_CL_VPORT_ZOFFSET_1_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_2                                                                         0x011b
#define mmPA_CL_VPORT_XSCALE_2_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_2                                                                        0x011c
#define mmPA_CL_VPORT_XOFFSET_2_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_2                                                                         0x011d
#define mmPA_CL_VPORT_YSCALE_2_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_2                                                                        0x011e
#define mmPA_CL_VPORT_YOFFSET_2_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_2                                                                         0x011f
#define mmPA_CL_VPORT_ZSCALE_2_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_2                                                                        0x0120
#define mmPA_CL_VPORT_ZOFFSET_2_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_3                                                                         0x0121
#define mmPA_CL_VPORT_XSCALE_3_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_3                                                                        0x0122
#define mmPA_CL_VPORT_XOFFSET_3_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_3                                                                         0x0123
#define mmPA_CL_VPORT_YSCALE_3_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_3                                                                        0x0124
#define mmPA_CL_VPORT_YOFFSET_3_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_3                                                                         0x0125
#define mmPA_CL_VPORT_ZSCALE_3_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_3                                                                        0x0126
#define mmPA_CL_VPORT_ZOFFSET_3_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_4                                                                         0x0127
#define mmPA_CL_VPORT_XSCALE_4_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_4                                                                        0x0128
#define mmPA_CL_VPORT_XOFFSET_4_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_4                                                                         0x0129
#define mmPA_CL_VPORT_YSCALE_4_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_4                                                                        0x012a
#define mmPA_CL_VPORT_YOFFSET_4_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_4                                                                         0x012b
#define mmPA_CL_VPORT_ZSCALE_4_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_4                                                                        0x012c
#define mmPA_CL_VPORT_ZOFFSET_4_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_5                                                                         0x012d
#define mmPA_CL_VPORT_XSCALE_5_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_5                                                                        0x012e
#define mmPA_CL_VPORT_XOFFSET_5_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_5                                                                         0x012f
#define mmPA_CL_VPORT_YSCALE_5_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_5                                                                        0x0130
#define mmPA_CL_VPORT_YOFFSET_5_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_5                                                                         0x0131
#define mmPA_CL_VPORT_ZSCALE_5_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_5                                                                        0x0132
#define mmPA_CL_VPORT_ZOFFSET_5_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_6                                                                         0x0133
#define mmPA_CL_VPORT_XSCALE_6_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_6                                                                        0x0134
#define mmPA_CL_VPORT_XOFFSET_6_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_6                                                                         0x0135
#define mmPA_CL_VPORT_YSCALE_6_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_6                                                                        0x0136
#define mmPA_CL_VPORT_YOFFSET_6_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_6                                                                         0x0137
#define mmPA_CL_VPORT_ZSCALE_6_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_6                                                                        0x0138
#define mmPA_CL_VPORT_ZOFFSET_6_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_7                                                                         0x0139
#define mmPA_CL_VPORT_XSCALE_7_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_7                                                                        0x013a
#define mmPA_CL_VPORT_XOFFSET_7_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_7                                                                         0x013b
#define mmPA_CL_VPORT_YSCALE_7_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_7                                                                        0x013c
#define mmPA_CL_VPORT_YOFFSET_7_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_7                                                                         0x013d
#define mmPA_CL_VPORT_ZSCALE_7_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_7                                                                        0x013e
#define mmPA_CL_VPORT_ZOFFSET_7_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_8                                                                         0x013f
#define mmPA_CL_VPORT_XSCALE_8_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_8                                                                        0x0140
#define mmPA_CL_VPORT_XOFFSET_8_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_8                                                                         0x0141
#define mmPA_CL_VPORT_YSCALE_8_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_8                                                                        0x0142
#define mmPA_CL_VPORT_YOFFSET_8_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_8                                                                         0x0143
#define mmPA_CL_VPORT_ZSCALE_8_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_8                                                                        0x0144
#define mmPA_CL_VPORT_ZOFFSET_8_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_9                                                                         0x0145
#define mmPA_CL_VPORT_XSCALE_9_BASE_IDX                                                                1
#define mmPA_CL_VPORT_XOFFSET_9                                                                        0x0146
#define mmPA_CL_VPORT_XOFFSET_9_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YSCALE_9                                                                         0x0147
#define mmPA_CL_VPORT_YSCALE_9_BASE_IDX                                                                1
#define mmPA_CL_VPORT_YOFFSET_9                                                                        0x0148
#define mmPA_CL_VPORT_YOFFSET_9_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZSCALE_9                                                                         0x0149
#define mmPA_CL_VPORT_ZSCALE_9_BASE_IDX                                                                1
#define mmPA_CL_VPORT_ZOFFSET_9                                                                        0x014a
#define mmPA_CL_VPORT_ZOFFSET_9_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XSCALE_10                                                                        0x014b
#define mmPA_CL_VPORT_XSCALE_10_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_10                                                                       0x014c
#define mmPA_CL_VPORT_XOFFSET_10_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_10                                                                        0x014d
#define mmPA_CL_VPORT_YSCALE_10_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_10                                                                       0x014e
#define mmPA_CL_VPORT_YOFFSET_10_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_10                                                                        0x014f
#define mmPA_CL_VPORT_ZSCALE_10_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_10                                                                       0x0150
#define mmPA_CL_VPORT_ZOFFSET_10_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_11                                                                        0x0151
#define mmPA_CL_VPORT_XSCALE_11_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_11                                                                       0x0152
#define mmPA_CL_VPORT_XOFFSET_11_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_11                                                                        0x0153
#define mmPA_CL_VPORT_YSCALE_11_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_11                                                                       0x0154
#define mmPA_CL_VPORT_YOFFSET_11_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_11                                                                        0x0155
#define mmPA_CL_VPORT_ZSCALE_11_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_11                                                                       0x0156
#define mmPA_CL_VPORT_ZOFFSET_11_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_12                                                                        0x0157
#define mmPA_CL_VPORT_XSCALE_12_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_12                                                                       0x0158
#define mmPA_CL_VPORT_XOFFSET_12_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_12                                                                        0x0159
#define mmPA_CL_VPORT_YSCALE_12_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_12                                                                       0x015a
#define mmPA_CL_VPORT_YOFFSET_12_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_12                                                                        0x015b
#define mmPA_CL_VPORT_ZSCALE_12_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_12                                                                       0x015c
#define mmPA_CL_VPORT_ZOFFSET_12_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_13                                                                        0x015d
#define mmPA_CL_VPORT_XSCALE_13_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_13                                                                       0x015e
#define mmPA_CL_VPORT_XOFFSET_13_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_13                                                                        0x015f
#define mmPA_CL_VPORT_YSCALE_13_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_13                                                                       0x0160
#define mmPA_CL_VPORT_YOFFSET_13_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_13                                                                        0x0161
#define mmPA_CL_VPORT_ZSCALE_13_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_13                                                                       0x0162
#define mmPA_CL_VPORT_ZOFFSET_13_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_14                                                                        0x0163
#define mmPA_CL_VPORT_XSCALE_14_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_14                                                                       0x0164
#define mmPA_CL_VPORT_XOFFSET_14_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_14                                                                        0x0165
#define mmPA_CL_VPORT_YSCALE_14_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_14                                                                       0x0166
#define mmPA_CL_VPORT_YOFFSET_14_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_14                                                                        0x0167
#define mmPA_CL_VPORT_ZSCALE_14_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_14                                                                       0x0168
#define mmPA_CL_VPORT_ZOFFSET_14_BASE_IDX                                                              1
#define mmPA_CL_VPORT_XSCALE_15                                                                        0x0169
#define mmPA_CL_VPORT_XSCALE_15_BASE_IDX                                                               1
#define mmPA_CL_VPORT_XOFFSET_15                                                                       0x016a
#define mmPA_CL_VPORT_XOFFSET_15_BASE_IDX                                                              1
#define mmPA_CL_VPORT_YSCALE_15                                                                        0x016b
#define mmPA_CL_VPORT_YSCALE_15_BASE_IDX                                                               1
#define mmPA_CL_VPORT_YOFFSET_15                                                                       0x016c
#define mmPA_CL_VPORT_YOFFSET_15_BASE_IDX                                                              1
#define mmPA_CL_VPORT_ZSCALE_15                                                                        0x016d
#define mmPA_CL_VPORT_ZSCALE_15_BASE_IDX                                                               1
#define mmPA_CL_VPORT_ZOFFSET_15                                                                       0x016e
#define mmPA_CL_VPORT_ZOFFSET_15_BASE_IDX                                                              1
#define mmPA_CL_UCP_0_X                                                                                0x016f
#define mmPA_CL_UCP_0_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_0_Y                                                                                0x0170
#define mmPA_CL_UCP_0_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_0_Z                                                                                0x0171
#define mmPA_CL_UCP_0_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_0_W                                                                                0x0172
#define mmPA_CL_UCP_0_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_X                                                                                0x0173
#define mmPA_CL_UCP_1_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_Y                                                                                0x0174
#define mmPA_CL_UCP_1_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_Z                                                                                0x0175
#define mmPA_CL_UCP_1_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_1_W                                                                                0x0176
#define mmPA_CL_UCP_1_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_X                                                                                0x0177
#define mmPA_CL_UCP_2_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_Y                                                                                0x0178
#define mmPA_CL_UCP_2_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_Z                                                                                0x0179
#define mmPA_CL_UCP_2_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_2_W                                                                                0x017a
#define mmPA_CL_UCP_2_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_X                                                                                0x017b
#define mmPA_CL_UCP_3_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_Y                                                                                0x017c
#define mmPA_CL_UCP_3_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_Z                                                                                0x017d
#define mmPA_CL_UCP_3_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_3_W                                                                                0x017e
#define mmPA_CL_UCP_3_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_X                                                                                0x017f
#define mmPA_CL_UCP_4_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_Y                                                                                0x0180
#define mmPA_CL_UCP_4_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_Z                                                                                0x0181
#define mmPA_CL_UCP_4_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_4_W                                                                                0x0182
#define mmPA_CL_UCP_4_W_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_X                                                                                0x0183
#define mmPA_CL_UCP_5_X_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_Y                                                                                0x0184
#define mmPA_CL_UCP_5_Y_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_Z                                                                                0x0185
#define mmPA_CL_UCP_5_Z_BASE_IDX                                                                       1
#define mmPA_CL_UCP_5_W                                                                                0x0186
#define mmPA_CL_UCP_5_W_BASE_IDX                                                                       1
#define mmSPI_PS_INPUT_CNTL_0                                                                          0x0191
#define mmSPI_PS_INPUT_CNTL_0_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_1                                                                          0x0192
#define mmSPI_PS_INPUT_CNTL_1_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_2                                                                          0x0193
#define mmSPI_PS_INPUT_CNTL_2_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_3                                                                          0x0194
#define mmSPI_PS_INPUT_CNTL_3_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_4                                                                          0x0195
#define mmSPI_PS_INPUT_CNTL_4_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_5                                                                          0x0196
#define mmSPI_PS_INPUT_CNTL_5_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_6                                                                          0x0197
#define mmSPI_PS_INPUT_CNTL_6_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_7                                                                          0x0198
#define mmSPI_PS_INPUT_CNTL_7_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_8                                                                          0x0199
#define mmSPI_PS_INPUT_CNTL_8_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_9                                                                          0x019a
#define mmSPI_PS_INPUT_CNTL_9_BASE_IDX                                                                 1
#define mmSPI_PS_INPUT_CNTL_10                                                                         0x019b
#define mmSPI_PS_INPUT_CNTL_10_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_11                                                                         0x019c
#define mmSPI_PS_INPUT_CNTL_11_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_12                                                                         0x019d
#define mmSPI_PS_INPUT_CNTL_12_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_13                                                                         0x019e
#define mmSPI_PS_INPUT_CNTL_13_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_14                                                                         0x019f
#define mmSPI_PS_INPUT_CNTL_14_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_15                                                                         0x01a0
#define mmSPI_PS_INPUT_CNTL_15_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_16                                                                         0x01a1
#define mmSPI_PS_INPUT_CNTL_16_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_17                                                                         0x01a2
#define mmSPI_PS_INPUT_CNTL_17_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_18                                                                         0x01a3
#define mmSPI_PS_INPUT_CNTL_18_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_19                                                                         0x01a4
#define mmSPI_PS_INPUT_CNTL_19_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_20                                                                         0x01a5
#define mmSPI_PS_INPUT_CNTL_20_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_21                                                                         0x01a6
#define mmSPI_PS_INPUT_CNTL_21_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_22                                                                         0x01a7
#define mmSPI_PS_INPUT_CNTL_22_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_23                                                                         0x01a8
#define mmSPI_PS_INPUT_CNTL_23_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_24                                                                         0x01a9
#define mmSPI_PS_INPUT_CNTL_24_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_25                                                                         0x01aa
#define mmSPI_PS_INPUT_CNTL_25_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_26                                                                         0x01ab
#define mmSPI_PS_INPUT_CNTL_26_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_27                                                                         0x01ac
#define mmSPI_PS_INPUT_CNTL_27_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_28                                                                         0x01ad
#define mmSPI_PS_INPUT_CNTL_28_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_29                                                                         0x01ae
#define mmSPI_PS_INPUT_CNTL_29_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_30                                                                         0x01af
#define mmSPI_PS_INPUT_CNTL_30_BASE_IDX                                                                1
#define mmSPI_PS_INPUT_CNTL_31                                                                         0x01b0
#define mmSPI_PS_INPUT_CNTL_31_BASE_IDX                                                                1
#define mmSPI_VS_OUT_CONFIG                                                                            0x01b1
#define mmSPI_VS_OUT_CONFIG_BASE_IDX                                                                   1
#define mmSPI_PS_INPUT_ENA                                                                             0x01b3
#define mmSPI_PS_INPUT_ENA_BASE_IDX                                                                    1
#define mmSPI_PS_INPUT_ADDR                                                                            0x01b4
#define mmSPI_PS_INPUT_ADDR_BASE_IDX                                                                   1
#define mmSPI_INTERP_CONTROL_0                                                                         0x01b5
#define mmSPI_INTERP_CONTROL_0_BASE_IDX                                                                1
#define mmSPI_PS_IN_CONTROL                                                                            0x01b6
#define mmSPI_PS_IN_CONTROL_BASE_IDX                                                                   1
#define mmSPI_BARYC_CNTL                                                                               0x01b8
#define mmSPI_BARYC_CNTL_BASE_IDX                                                                      1
#define mmSPI_TMPRING_SIZE                                                                             0x01ba
#define mmSPI_TMPRING_SIZE_BASE_IDX                                                                    1
#define mmSPI_SHADER_POS_FORMAT                                                                        0x01c3
#define mmSPI_SHADER_POS_FORMAT_BASE_IDX                                                               1
#define mmSPI_SHADER_Z_FORMAT                                                                          0x01c4
#define mmSPI_SHADER_Z_FORMAT_BASE_IDX                                                                 1
#define mmSPI_SHADER_COL_FORMAT                                                                        0x01c5
#define mmSPI_SHADER_COL_FORMAT_BASE_IDX                                                               1
#define mmSX_PS_DOWNCONVERT                                                                            0x01d5
#define mmSX_PS_DOWNCONVERT_BASE_IDX                                                                   1
#define mmSX_BLEND_OPT_EPSILON                                                                         0x01d6
#define mmSX_BLEND_OPT_EPSILON_BASE_IDX                                                                1
#define mmSX_BLEND_OPT_CONTROL                                                                         0x01d7
#define mmSX_BLEND_OPT_CONTROL_BASE_IDX                                                                1
#define mmSX_MRT0_BLEND_OPT                                                                            0x01d8
#define mmSX_MRT0_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT1_BLEND_OPT                                                                            0x01d9
#define mmSX_MRT1_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT2_BLEND_OPT                                                                            0x01da
#define mmSX_MRT2_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT3_BLEND_OPT                                                                            0x01db
#define mmSX_MRT3_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT4_BLEND_OPT                                                                            0x01dc
#define mmSX_MRT4_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT5_BLEND_OPT                                                                            0x01dd
#define mmSX_MRT5_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT6_BLEND_OPT                                                                            0x01de
#define mmSX_MRT6_BLEND_OPT_BASE_IDX                                                                   1
#define mmSX_MRT7_BLEND_OPT                                                                            0x01df
#define mmSX_MRT7_BLEND_OPT_BASE_IDX                                                                   1
#define mmCB_BLEND0_CONTROL                                                                            0x01e0
#define mmCB_BLEND0_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND1_CONTROL                                                                            0x01e1
#define mmCB_BLEND1_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND2_CONTROL                                                                            0x01e2
#define mmCB_BLEND2_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND3_CONTROL                                                                            0x01e3
#define mmCB_BLEND3_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND4_CONTROL                                                                            0x01e4
#define mmCB_BLEND4_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND5_CONTROL                                                                            0x01e5
#define mmCB_BLEND5_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND6_CONTROL                                                                            0x01e6
#define mmCB_BLEND6_CONTROL_BASE_IDX                                                                   1
#define mmCB_BLEND7_CONTROL                                                                            0x01e7
#define mmCB_BLEND7_CONTROL_BASE_IDX                                                                   1
#define mmCB_MRT0_EPITCH                                                                               0x01e8
#define mmCB_MRT0_EPITCH_BASE_IDX                                                                      1
#define mmCB_MRT1_EPITCH                                                                               0x01e9
#define mmCB_MRT1_EPITCH_BASE_IDX                                                                      1
#define mmCB_MRT2_EPITCH                                                                               0x01ea
#define mmCB_MRT2_EPITCH_BASE_IDX                                                                      1
#define mmCB_MRT3_EPITCH                                                                               0x01eb
#define mmCB_MRT3_EPITCH_BASE_IDX                                                                      1
#define mmCB_MRT4_EPITCH                                                                               0x01ec
#define mmCB_MRT4_EPITCH_BASE_IDX                                                                      1
#define mmCB_MRT5_EPITCH                                                                               0x01ed
#define mmCB_MRT5_EPITCH_BASE_IDX                                                                      1
#define mmCB_MRT6_EPITCH                                                                               0x01ee
#define mmCB_MRT6_EPITCH_BASE_IDX                                                                      1
#define mmCB_MRT7_EPITCH                                                                               0x01ef
#define mmCB_MRT7_EPITCH_BASE_IDX                                                                      1
#define mmCS_COPY_STATE                                                                                0x01f3
#define mmCS_COPY_STATE_BASE_IDX                                                                       1
#define mmGFX_COPY_STATE                                                                               0x01f4
#define mmGFX_COPY_STATE_BASE_IDX                                                                      1
#define mmPA_CL_POINT_X_RAD                                                                            0x01f5
#define mmPA_CL_POINT_X_RAD_BASE_IDX                                                                   1
#define mmPA_CL_POINT_Y_RAD                                                                            0x01f6
#define mmPA_CL_POINT_Y_RAD_BASE_IDX                                                                   1
#define mmPA_CL_POINT_SIZE                                                                             0x01f7
#define mmPA_CL_POINT_SIZE_BASE_IDX                                                                    1
#define mmPA_CL_POINT_CULL_RAD                                                                         0x01f8
#define mmPA_CL_POINT_CULL_RAD_BASE_IDX                                                                1
#define mmVGT_DMA_BASE_HI                                                                              0x01f9
#define mmVGT_DMA_BASE_HI_BASE_IDX                                                                     1
#define mmVGT_DMA_BASE                                                                                 0x01fa
#define mmVGT_DMA_BASE_BASE_IDX                                                                        1
#define mmVGT_DRAW_INITIATOR                                                                           0x01fc
#define mmVGT_DRAW_INITIATOR_BASE_IDX                                                                  1
#define mmVGT_IMMED_DATA                                                                               0x01fd
#define mmVGT_IMMED_DATA_BASE_IDX                                                                      1
#define mmVGT_EVENT_ADDRESS_REG                                                                        0x01fe
#define mmVGT_EVENT_ADDRESS_REG_BASE_IDX                                                               1
#define mmDB_DEPTH_CONTROL                                                                             0x0200
#define mmDB_DEPTH_CONTROL_BASE_IDX                                                                    1
#define mmDB_EQAA                                                                                      0x0201
#define mmDB_EQAA_BASE_IDX                                                                             1
#define mmCB_COLOR_CONTROL                                                                             0x0202
#define mmCB_COLOR_CONTROL_BASE_IDX                                                                    1
#define mmDB_SHADER_CONTROL                                                                            0x0203
#define mmDB_SHADER_CONTROL_BASE_IDX                                                                   1
#define mmPA_CL_CLIP_CNTL                                                                              0x0204
#define mmPA_CL_CLIP_CNTL_BASE_IDX                                                                     1
#define mmPA_SU_SC_MODE_CNTL                                                                           0x0205
#define mmPA_SU_SC_MODE_CNTL_BASE_IDX                                                                  1
#define mmPA_CL_VTE_CNTL                                                                               0x0206
#define mmPA_CL_VTE_CNTL_BASE_IDX                                                                      1
#define mmPA_CL_VS_OUT_CNTL                                                                            0x0207
#define mmPA_CL_VS_OUT_CNTL_BASE_IDX                                                                   1
#define mmPA_CL_NANINF_CNTL                                                                            0x0208
#define mmPA_CL_NANINF_CNTL_BASE_IDX                                                                   1
#define mmPA_SU_LINE_STIPPLE_CNTL                                                                      0x0209
#define mmPA_SU_LINE_STIPPLE_CNTL_BASE_IDX                                                             1
#define mmPA_SU_LINE_STIPPLE_SCALE                                                                     0x020a
#define mmPA_SU_LINE_STIPPLE_SCALE_BASE_IDX                                                            1
#define mmPA_SU_PRIM_FILTER_CNTL                                                                       0x020b
#define mmPA_SU_PRIM_FILTER_CNTL_BASE_IDX                                                              1
#define mmPA_SU_SMALL_PRIM_FILTER_CNTL                                                                 0x020c
#define mmPA_SU_SMALL_PRIM_FILTER_CNTL_BASE_IDX                                                        1
#define mmPA_CL_OBJPRIM_ID_CNTL                                                                        0x020d
#define mmPA_CL_OBJPRIM_ID_CNTL_BASE_IDX                                                               1
#define mmPA_CL_NGG_CNTL                                                                               0x020e
#define mmPA_CL_NGG_CNTL_BASE_IDX                                                                      1
#define mmPA_SU_OVER_RASTERIZATION_CNTL                                                                0x020f
#define mmPA_SU_OVER_RASTERIZATION_CNTL_BASE_IDX                                                       1
#define mmPA_SU_POINT_SIZE                                                                             0x0280
#define mmPA_SU_POINT_SIZE_BASE_IDX                                                                    1
#define mmPA_SU_POINT_MINMAX                                                                           0x0281
#define mmPA_SU_POINT_MINMAX_BASE_IDX                                                                  1
#define mmPA_SU_LINE_CNTL                                                                              0x0282
#define mmPA_SU_LINE_CNTL_BASE_IDX                                                                     1
#define mmPA_SC_LINE_STIPPLE                                                                           0x0283
#define mmPA_SC_LINE_STIPPLE_BASE_IDX                                                                  1
#define mmVGT_OUTPUT_PATH_CNTL                                                                         0x0284
#define mmVGT_OUTPUT_PATH_CNTL_BASE_IDX                                                                1
#define mmVGT_HOS_CNTL                                                                                 0x0285
#define mmVGT_HOS_CNTL_BASE_IDX                                                                        1
#define mmVGT_HOS_MAX_TESS_LEVEL                                                                       0x0286
#define mmVGT_HOS_MAX_TESS_LEVEL_BASE_IDX                                                              1
#define mmVGT_HOS_MIN_TESS_LEVEL                                                                       0x0287
#define mmVGT_HOS_MIN_TESS_LEVEL_BASE_IDX                                                              1
#define mmVGT_HOS_REUSE_DEPTH                                                                          0x0288
#define mmVGT_HOS_REUSE_DEPTH_BASE_IDX                                                                 1
#define mmVGT_GROUP_PRIM_TYPE                                                                          0x0289
#define mmVGT_GROUP_PRIM_TYPE_BASE_IDX                                                                 1
#define mmVGT_GROUP_FIRST_DECR                                                                         0x028a
#define mmVGT_GROUP_FIRST_DECR_BASE_IDX                                                                1
#define mmVGT_GROUP_DECR                                                                               0x028b
#define mmVGT_GROUP_DECR_BASE_IDX                                                                      1
#define mmVGT_GROUP_VECT_0_CNTL                                                                        0x028c
#define mmVGT_GROUP_VECT_0_CNTL_BASE_IDX                                                               1
#define mmVGT_GROUP_VECT_1_CNTL                                                                        0x028d
#define mmVGT_GROUP_VECT_1_CNTL_BASE_IDX                                                               1
#define mmVGT_GROUP_VECT_0_FMT_CNTL                                                                    0x028e
#define mmVGT_GROUP_VECT_0_FMT_CNTL_BASE_IDX                                                           1
#define mmVGT_GROUP_VECT_1_FMT_CNTL                                                                    0x028f
#define mmVGT_GROUP_VECT_1_FMT_CNTL_BASE_IDX                                                           1
#define mmVGT_GS_MODE                                                                                  0x0290
#define mmVGT_GS_MODE_BASE_IDX                                                                         1
#define mmVGT_GS_ONCHIP_CNTL                                                                           0x0291
#define mmVGT_GS_ONCHIP_CNTL_BASE_IDX                                                                  1
#define mmPA_SC_MODE_CNTL_0                                                                            0x0292
#define mmPA_SC_MODE_CNTL_0_BASE_IDX                                                                   1
#define mmPA_SC_MODE_CNTL_1                                                                            0x0293
#define mmPA_SC_MODE_CNTL_1_BASE_IDX                                                                   1
#define mmVGT_ENHANCE                                                                                  0x0294
#define mmVGT_ENHANCE_BASE_IDX                                                                         1
#define mmVGT_GS_PER_ES                                                                                0x0295
#define mmVGT_GS_PER_ES_BASE_IDX                                                                       1
#define mmVGT_ES_PER_GS                                                                                0x0296
#define mmVGT_ES_PER_GS_BASE_IDX                                                                       1
#define mmVGT_GS_PER_VS                                                                                0x0297
#define mmVGT_GS_PER_VS_BASE_IDX                                                                       1
#define mmVGT_GSVS_RING_OFFSET_1                                                                       0x0298
#define mmVGT_GSVS_RING_OFFSET_1_BASE_IDX                                                              1
#define mmVGT_GSVS_RING_OFFSET_2                                                                       0x0299
#define mmVGT_GSVS_RING_OFFSET_2_BASE_IDX                                                              1
#define mmVGT_GSVS_RING_OFFSET_3                                                                       0x029a
#define mmVGT_GSVS_RING_OFFSET_3_BASE_IDX                                                              1
#define mmVGT_GS_OUT_PRIM_TYPE                                                                         0x029b
#define mmVGT_GS_OUT_PRIM_TYPE_BASE_IDX                                                                1
#define mmIA_ENHANCE                                                                                   0x029c
#define mmIA_ENHANCE_BASE_IDX                                                                          1
#define mmVGT_DMA_SIZE                                                                                 0x029d
#define mmVGT_DMA_SIZE_BASE_IDX                                                                        1
#define mmVGT_DMA_MAX_SIZE                                                                             0x029e
#define mmVGT_DMA_MAX_SIZE_BASE_IDX                                                                    1
#define mmVGT_DMA_INDEX_TYPE                                                                           0x029f
#define mmVGT_DMA_INDEX_TYPE_BASE_IDX                                                                  1
#define mmWD_ENHANCE                                                                                   0x02a0
#define mmWD_ENHANCE_BASE_IDX                                                                          1
#define mmVGT_PRIMITIVEID_EN                                                                           0x02a1
#define mmVGT_PRIMITIVEID_EN_BASE_IDX                                                                  1
#define mmVGT_DMA_NUM_INSTANCES                                                                        0x02a2
#define mmVGT_DMA_NUM_INSTANCES_BASE_IDX                                                               1
#define mmVGT_PRIMITIVEID_RESET                                                                        0x02a3
#define mmVGT_PRIMITIVEID_RESET_BASE_IDX                                                               1
#define mmVGT_EVENT_INITIATOR                                                                          0x02a4
#define mmVGT_EVENT_INITIATOR_BASE_IDX                                                                 1
#define mmVGT_GS_MAX_PRIMS_PER_SUBGROUP                                                                0x02a5
#define mmVGT_GS_MAX_PRIMS_PER_SUBGROUP_BASE_IDX                                                       1
#define mmVGT_DRAW_PAYLOAD_CNTL                                                                        0x02a6
#define mmVGT_DRAW_PAYLOAD_CNTL_BASE_IDX                                                               1
#define mmVGT_INSTANCE_STEP_RATE_0                                                                     0x02a8
#define mmVGT_INSTANCE_STEP_RATE_0_BASE_IDX                                                            1
#define mmVGT_INSTANCE_STEP_RATE_1                                                                     0x02a9
#define mmVGT_INSTANCE_STEP_RATE_1_BASE_IDX                                                            1
#define mmVGT_ESGS_RING_ITEMSIZE                                                                       0x02ab
#define mmVGT_ESGS_RING_ITEMSIZE_BASE_IDX                                                              1
#define mmVGT_GSVS_RING_ITEMSIZE                                                                       0x02ac
#define mmVGT_GSVS_RING_ITEMSIZE_BASE_IDX                                                              1
#define mmVGT_REUSE_OFF                                                                                0x02ad
#define mmVGT_REUSE_OFF_BASE_IDX                                                                       1
#define mmVGT_VTX_CNT_EN                                                                               0x02ae
#define mmVGT_VTX_CNT_EN_BASE_IDX                                                                      1
#define mmDB_HTILE_SURFACE                                                                             0x02af
#define mmDB_HTILE_SURFACE_BASE_IDX                                                                    1
#define mmDB_SRESULTS_COMPARE_STATE0                                                                   0x02b0
#define mmDB_SRESULTS_COMPARE_STATE0_BASE_IDX                                                          1
#define mmDB_SRESULTS_COMPARE_STATE1                                                                   0x02b1
#define mmDB_SRESULTS_COMPARE_STATE1_BASE_IDX                                                          1
#define mmDB_PRELOAD_CONTROL                                                                           0x02b2
#define mmDB_PRELOAD_CONTROL_BASE_IDX                                                                  1
#define mmVGT_STRMOUT_BUFFER_SIZE_0                                                                    0x02b4
#define mmVGT_STRMOUT_BUFFER_SIZE_0_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_0                                                                     0x02b5
#define mmVGT_STRMOUT_VTX_STRIDE_0_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_0                                                                  0x02b7
#define mmVGT_STRMOUT_BUFFER_OFFSET_0_BASE_IDX                                                         1
#define mmVGT_STRMOUT_BUFFER_SIZE_1                                                                    0x02b8
#define mmVGT_STRMOUT_BUFFER_SIZE_1_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_1                                                                     0x02b9
#define mmVGT_STRMOUT_VTX_STRIDE_1_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_1                                                                  0x02bb
#define mmVGT_STRMOUT_BUFFER_OFFSET_1_BASE_IDX                                                         1
#define mmVGT_STRMOUT_BUFFER_SIZE_2                                                                    0x02bc
#define mmVGT_STRMOUT_BUFFER_SIZE_2_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_2                                                                     0x02bd
#define mmVGT_STRMOUT_VTX_STRIDE_2_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_2                                                                  0x02bf
#define mmVGT_STRMOUT_BUFFER_OFFSET_2_BASE_IDX                                                         1
#define mmVGT_STRMOUT_BUFFER_SIZE_3                                                                    0x02c0
#define mmVGT_STRMOUT_BUFFER_SIZE_3_BASE_IDX                                                           1
#define mmVGT_STRMOUT_VTX_STRIDE_3                                                                     0x02c1
#define mmVGT_STRMOUT_VTX_STRIDE_3_BASE_IDX                                                            1
#define mmVGT_STRMOUT_BUFFER_OFFSET_3                                                                  0x02c3
#define mmVGT_STRMOUT_BUFFER_OFFSET_3_BASE_IDX                                                         1
#define mmVGT_STRMOUT_DRAW_OPAQUE_OFFSET                                                               0x02ca
#define mmVGT_STRMOUT_DRAW_OPAQUE_OFFSET_BASE_IDX                                                      1
#define mmVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE                                                   0x02cb
#define mmVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE_BASE_IDX                                          1
#define mmVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE                                                        0x02cc
#define mmVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE_BASE_IDX                                               1
#define mmVGT_GS_MAX_VERT_OUT                                                                          0x02ce
#define mmVGT_GS_MAX_VERT_OUT_BASE_IDX                                                                 1
#define mmVGT_TESS_DISTRIBUTION                                                                        0x02d4
#define mmVGT_TESS_DISTRIBUTION_BASE_IDX                                                               1
#define mmVGT_SHADER_STAGES_EN                                                                         0x02d5
#define mmVGT_SHADER_STAGES_EN_BASE_IDX                                                                1
#define mmVGT_LS_HS_CONFIG                                                                             0x02d6
#define mmVGT_LS_HS_CONFIG_BASE_IDX                                                                    1
#define mmVGT_GS_VERT_ITEMSIZE                                                                         0x02d7
#define mmVGT_GS_VERT_ITEMSIZE_BASE_IDX                                                                1
#define mmVGT_GS_VERT_ITEMSIZE_1                                                                       0x02d8
#define mmVGT_GS_VERT_ITEMSIZE_1_BASE_IDX                                                              1
#define mmVGT_GS_VERT_ITEMSIZE_2                                                                       0x02d9
#define mmVGT_GS_VERT_ITEMSIZE_2_BASE_IDX                                                              1
#define mmVGT_GS_VERT_ITEMSIZE_3                                                                       0x02da
#define mmVGT_GS_VERT_ITEMSIZE_3_BASE_IDX                                                              1
#define mmVGT_TF_PARAM                                                                                 0x02db
#define mmVGT_TF_PARAM_BASE_IDX                                                                        1
#define mmDB_ALPHA_TO_MASK                                                                             0x02dc
#define mmDB_ALPHA_TO_MASK_BASE_IDX                                                                    1
#define mmVGT_DISPATCH_DRAW_INDEX                                                                      0x02dd
#define mmVGT_DISPATCH_DRAW_INDEX_BASE_IDX                                                             1
#define mmPA_SU_POLY_OFFSET_DB_FMT_CNTL                                                                0x02de
#define mmPA_SU_POLY_OFFSET_DB_FMT_CNTL_BASE_IDX                                                       1
#define mmPA_SU_POLY_OFFSET_CLAMP                                                                      0x02df
#define mmPA_SU_POLY_OFFSET_CLAMP_BASE_IDX                                                             1
#define mmPA_SU_POLY_OFFSET_FRONT_SCALE                                                                0x02e0
#define mmPA_SU_POLY_OFFSET_FRONT_SCALE_BASE_IDX                                                       1
#define mmPA_SU_POLY_OFFSET_FRONT_OFFSET                                                               0x02e1
#define mmPA_SU_POLY_OFFSET_FRONT_OFFSET_BASE_IDX                                                      1
#define mmPA_SU_POLY_OFFSET_BACK_SCALE                                                                 0x02e2
#define mmPA_SU_POLY_OFFSET_BACK_SCALE_BASE_IDX                                                        1
#define mmPA_SU_POLY_OFFSET_BACK_OFFSET                                                                0x02e3
#define mmPA_SU_POLY_OFFSET_BACK_OFFSET_BASE_IDX                                                       1
#define mmVGT_GS_INSTANCE_CNT                                                                          0x02e4
#define mmVGT_GS_INSTANCE_CNT_BASE_IDX                                                                 1
#define mmVGT_STRMOUT_CONFIG                                                                           0x02e5
#define mmVGT_STRMOUT_CONFIG_BASE_IDX                                                                  1
#define mmVGT_STRMOUT_BUFFER_CONFIG                                                                    0x02e6
#define mmVGT_STRMOUT_BUFFER_CONFIG_BASE_IDX                                                           1
#define mmVGT_DMA_EVENT_INITIATOR                                                                      0x02e7
#define mmVGT_DMA_EVENT_INITIATOR_BASE_IDX                                                             1
#define mmPA_SC_CENTROID_PRIORITY_0                                                                    0x02f5
#define mmPA_SC_CENTROID_PRIORITY_0_BASE_IDX                                                           1
#define mmPA_SC_CENTROID_PRIORITY_1                                                                    0x02f6
#define mmPA_SC_CENTROID_PRIORITY_1_BASE_IDX                                                           1
#define mmPA_SC_LINE_CNTL                                                                              0x02f7
#define mmPA_SC_LINE_CNTL_BASE_IDX                                                                     1
#define mmPA_SC_AA_CONFIG                                                                              0x02f8
#define mmPA_SC_AA_CONFIG_BASE_IDX                                                                     1
#define mmPA_SU_VTX_CNTL                                                                               0x02f9
#define mmPA_SU_VTX_CNTL_BASE_IDX                                                                      1
#define mmPA_CL_GB_VERT_CLIP_ADJ                                                                       0x02fa
#define mmPA_CL_GB_VERT_CLIP_ADJ_BASE_IDX                                                              1
#define mmPA_CL_GB_VERT_DISC_ADJ                                                                       0x02fb
#define mmPA_CL_GB_VERT_DISC_ADJ_BASE_IDX                                                              1
#define mmPA_CL_GB_HORZ_CLIP_ADJ                                                                       0x02fc
#define mmPA_CL_GB_HORZ_CLIP_ADJ_BASE_IDX                                                              1
#define mmPA_CL_GB_HORZ_DISC_ADJ                                                                       0x02fd
#define mmPA_CL_GB_HORZ_DISC_ADJ_BASE_IDX                                                              1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0                                                            0x02fe
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1                                                            0x02ff
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2                                                            0x0300
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3                                                            0x0301
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0                                                            0x0302
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1                                                            0x0303
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2                                                            0x0304
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3                                                            0x0305
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0                                                            0x0306
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1                                                            0x0307
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2                                                            0x0308
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3                                                            0x0309
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0                                                            0x030a
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1                                                            0x030b
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2                                                            0x030c
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2_BASE_IDX                                                   1
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3                                                            0x030d
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3_BASE_IDX                                                   1
#define mmPA_SC_AA_MASK_X0Y0_X1Y0                                                                      0x030e
#define mmPA_SC_AA_MASK_X0Y0_X1Y0_BASE_IDX                                                             1
#define mmPA_SC_AA_MASK_X0Y1_X1Y1                                                                      0x030f
#define mmPA_SC_AA_MASK_X0Y1_X1Y1_BASE_IDX                                                             1
#define mmPA_SC_SHADER_CONTROL                                                                         0x0310
#define mmPA_SC_SHADER_CONTROL_BASE_IDX                                                                1
#define mmPA_SC_BINNER_CNTL_0                                                                          0x0311
#define mmPA_SC_BINNER_CNTL_0_BASE_IDX                                                                 1
#define mmPA_SC_BINNER_CNTL_1                                                                          0x0312
#define mmPA_SC_BINNER_CNTL_1_BASE_IDX                                                                 1
#define mmPA_SC_CONSERVATIVE_RASTERIZATION_CNTL                                                        0x0313
#define mmPA_SC_CONSERVATIVE_RASTERIZATION_CNTL_BASE_IDX                                               1
#define mmPA_SC_NGG_MODE_CNTL                                                                          0x0314
#define mmPA_SC_NGG_MODE_CNTL_BASE_IDX                                                                 1
#define mmVGT_VERTEX_REUSE_BLOCK_CNTL                                                                  0x0316
#define mmVGT_VERTEX_REUSE_BLOCK_CNTL_BASE_IDX                                                         1
#define mmVGT_OUT_DEALLOC_CNTL                                                                         0x0317
#define mmVGT_OUT_DEALLOC_CNTL_BASE_IDX                                                                1
#define mmCB_COLOR0_BASE                                                                               0x0318
#define mmCB_COLOR0_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR0_BASE_EXT                                                                           0x0319
#define mmCB_COLOR0_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR0_ATTRIB2                                                                            0x031a
#define mmCB_COLOR0_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR0_VIEW                                                                               0x031b
#define mmCB_COLOR0_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR0_INFO                                                                               0x031c
#define mmCB_COLOR0_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR0_ATTRIB                                                                             0x031d
#define mmCB_COLOR0_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR0_DCC_CONTROL                                                                        0x031e
#define mmCB_COLOR0_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR0_CMASK                                                                              0x031f
#define mmCB_COLOR0_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR0_CMASK_BASE_EXT                                                                     0x0320
#define mmCB_COLOR0_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR0_FMASK                                                                              0x0321
#define mmCB_COLOR0_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR0_FMASK_BASE_EXT                                                                     0x0322
#define mmCB_COLOR0_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR0_CLEAR_WORD0                                                                        0x0323
#define mmCB_COLOR0_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR0_CLEAR_WORD1                                                                        0x0324
#define mmCB_COLOR0_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR0_DCC_BASE                                                                           0x0325
#define mmCB_COLOR0_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR0_DCC_BASE_EXT                                                                       0x0326
#define mmCB_COLOR0_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR1_BASE                                                                               0x0327
#define mmCB_COLOR1_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR1_BASE_EXT                                                                           0x0328
#define mmCB_COLOR1_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR1_ATTRIB2                                                                            0x0329
#define mmCB_COLOR1_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR1_VIEW                                                                               0x032a
#define mmCB_COLOR1_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR1_INFO                                                                               0x032b
#define mmCB_COLOR1_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR1_ATTRIB                                                                             0x032c
#define mmCB_COLOR1_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR1_DCC_CONTROL                                                                        0x032d
#define mmCB_COLOR1_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR1_CMASK                                                                              0x032e
#define mmCB_COLOR1_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR1_CMASK_BASE_EXT                                                                     0x032f
#define mmCB_COLOR1_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR1_FMASK                                                                              0x0330
#define mmCB_COLOR1_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR1_FMASK_BASE_EXT                                                                     0x0331
#define mmCB_COLOR1_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR1_CLEAR_WORD0                                                                        0x0332
#define mmCB_COLOR1_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR1_CLEAR_WORD1                                                                        0x0333
#define mmCB_COLOR1_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR1_DCC_BASE                                                                           0x0334
#define mmCB_COLOR1_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR1_DCC_BASE_EXT                                                                       0x0335
#define mmCB_COLOR1_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR2_BASE                                                                               0x0336
#define mmCB_COLOR2_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR2_BASE_EXT                                                                           0x0337
#define mmCB_COLOR2_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR2_ATTRIB2                                                                            0x0338
#define mmCB_COLOR2_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR2_VIEW                                                                               0x0339
#define mmCB_COLOR2_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR2_INFO                                                                               0x033a
#define mmCB_COLOR2_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR2_ATTRIB                                                                             0x033b
#define mmCB_COLOR2_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR2_DCC_CONTROL                                                                        0x033c
#define mmCB_COLOR2_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR2_CMASK                                                                              0x033d
#define mmCB_COLOR2_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR2_CMASK_BASE_EXT                                                                     0x033e
#define mmCB_COLOR2_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR2_FMASK                                                                              0x033f
#define mmCB_COLOR2_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR2_FMASK_BASE_EXT                                                                     0x0340
#define mmCB_COLOR2_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR2_CLEAR_WORD0                                                                        0x0341
#define mmCB_COLOR2_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR2_CLEAR_WORD1                                                                        0x0342
#define mmCB_COLOR2_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR2_DCC_BASE                                                                           0x0343
#define mmCB_COLOR2_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR2_DCC_BASE_EXT                                                                       0x0344
#define mmCB_COLOR2_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR3_BASE                                                                               0x0345
#define mmCB_COLOR3_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR3_BASE_EXT                                                                           0x0346
#define mmCB_COLOR3_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR3_ATTRIB2                                                                            0x0347
#define mmCB_COLOR3_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR3_VIEW                                                                               0x0348
#define mmCB_COLOR3_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR3_INFO                                                                               0x0349
#define mmCB_COLOR3_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR3_ATTRIB                                                                             0x034a
#define mmCB_COLOR3_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR3_DCC_CONTROL                                                                        0x034b
#define mmCB_COLOR3_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR3_CMASK                                                                              0x034c
#define mmCB_COLOR3_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR3_CMASK_BASE_EXT                                                                     0x034d
#define mmCB_COLOR3_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR3_FMASK                                                                              0x034e
#define mmCB_COLOR3_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR3_FMASK_BASE_EXT                                                                     0x034f
#define mmCB_COLOR3_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR3_CLEAR_WORD0                                                                        0x0350
#define mmCB_COLOR3_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR3_CLEAR_WORD1                                                                        0x0351
#define mmCB_COLOR3_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR3_DCC_BASE                                                                           0x0352
#define mmCB_COLOR3_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR3_DCC_BASE_EXT                                                                       0x0353
#define mmCB_COLOR3_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR4_BASE                                                                               0x0354
#define mmCB_COLOR4_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR4_BASE_EXT                                                                           0x0355
#define mmCB_COLOR4_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR4_ATTRIB2                                                                            0x0356
#define mmCB_COLOR4_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR4_VIEW                                                                               0x0357
#define mmCB_COLOR4_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR4_INFO                                                                               0x0358
#define mmCB_COLOR4_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR4_ATTRIB                                                                             0x0359
#define mmCB_COLOR4_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR4_DCC_CONTROL                                                                        0x035a
#define mmCB_COLOR4_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR4_CMASK                                                                              0x035b
#define mmCB_COLOR4_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR4_CMASK_BASE_EXT                                                                     0x035c
#define mmCB_COLOR4_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR4_FMASK                                                                              0x035d
#define mmCB_COLOR4_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR4_FMASK_BASE_EXT                                                                     0x035e
#define mmCB_COLOR4_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR4_CLEAR_WORD0                                                                        0x035f
#define mmCB_COLOR4_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR4_CLEAR_WORD1                                                                        0x0360
#define mmCB_COLOR4_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR4_DCC_BASE                                                                           0x0361
#define mmCB_COLOR4_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR4_DCC_BASE_EXT                                                                       0x0362
#define mmCB_COLOR4_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR5_BASE                                                                               0x0363
#define mmCB_COLOR5_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR5_BASE_EXT                                                                           0x0364
#define mmCB_COLOR5_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR5_ATTRIB2                                                                            0x0365
#define mmCB_COLOR5_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR5_VIEW                                                                               0x0366
#define mmCB_COLOR5_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR5_INFO                                                                               0x0367
#define mmCB_COLOR5_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR5_ATTRIB                                                                             0x0368
#define mmCB_COLOR5_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR5_DCC_CONTROL                                                                        0x0369
#define mmCB_COLOR5_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR5_CMASK                                                                              0x036a
#define mmCB_COLOR5_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR5_CMASK_BASE_EXT                                                                     0x036b
#define mmCB_COLOR5_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR5_FMASK                                                                              0x036c
#define mmCB_COLOR5_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR5_FMASK_BASE_EXT                                                                     0x036d
#define mmCB_COLOR5_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR5_CLEAR_WORD0                                                                        0x036e
#define mmCB_COLOR5_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR5_CLEAR_WORD1                                                                        0x036f
#define mmCB_COLOR5_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR5_DCC_BASE                                                                           0x0370
#define mmCB_COLOR5_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR5_DCC_BASE_EXT                                                                       0x0371
#define mmCB_COLOR5_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR6_BASE                                                                               0x0372
#define mmCB_COLOR6_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR6_BASE_EXT                                                                           0x0373
#define mmCB_COLOR6_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR6_ATTRIB2                                                                            0x0374
#define mmCB_COLOR6_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR6_VIEW                                                                               0x0375
#define mmCB_COLOR6_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR6_INFO                                                                               0x0376
#define mmCB_COLOR6_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR6_ATTRIB                                                                             0x0377
#define mmCB_COLOR6_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR6_DCC_CONTROL                                                                        0x0378
#define mmCB_COLOR6_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR6_CMASK                                                                              0x0379
#define mmCB_COLOR6_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR6_CMASK_BASE_EXT                                                                     0x037a
#define mmCB_COLOR6_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR6_FMASK                                                                              0x037b
#define mmCB_COLOR6_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR6_FMASK_BASE_EXT                                                                     0x037c
#define mmCB_COLOR6_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR6_CLEAR_WORD0                                                                        0x037d
#define mmCB_COLOR6_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR6_CLEAR_WORD1                                                                        0x037e
#define mmCB_COLOR6_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR6_DCC_BASE                                                                           0x037f
#define mmCB_COLOR6_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR6_DCC_BASE_EXT                                                                       0x0380
#define mmCB_COLOR6_DCC_BASE_EXT_BASE_IDX                                                              1
#define mmCB_COLOR7_BASE                                                                               0x0381
#define mmCB_COLOR7_BASE_BASE_IDX                                                                      1
#define mmCB_COLOR7_BASE_EXT                                                                           0x0382
#define mmCB_COLOR7_BASE_EXT_BASE_IDX                                                                  1
#define mmCB_COLOR7_ATTRIB2                                                                            0x0383
#define mmCB_COLOR7_ATTRIB2_BASE_IDX                                                                   1
#define mmCB_COLOR7_VIEW                                                                               0x0384
#define mmCB_COLOR7_VIEW_BASE_IDX                                                                      1
#define mmCB_COLOR7_INFO                                                                               0x0385
#define mmCB_COLOR7_INFO_BASE_IDX                                                                      1
#define mmCB_COLOR7_ATTRIB                                                                             0x0386
#define mmCB_COLOR7_ATTRIB_BASE_IDX                                                                    1
#define mmCB_COLOR7_DCC_CONTROL                                                                        0x0387
#define mmCB_COLOR7_DCC_CONTROL_BASE_IDX                                                               1
#define mmCB_COLOR7_CMASK                                                                              0x0388
#define mmCB_COLOR7_CMASK_BASE_IDX                                                                     1
#define mmCB_COLOR7_CMASK_BASE_EXT                                                                     0x0389
#define mmCB_COLOR7_CMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR7_FMASK                                                                              0x038a
#define mmCB_COLOR7_FMASK_BASE_IDX                                                                     1
#define mmCB_COLOR7_FMASK_BASE_EXT                                                                     0x038b
#define mmCB_COLOR7_FMASK_BASE_EXT_BASE_IDX                                                            1
#define mmCB_COLOR7_CLEAR_WORD0                                                                        0x038c
#define mmCB_COLOR7_CLEAR_WORD0_BASE_IDX                                                               1
#define mmCB_COLOR7_CLEAR_WORD1                                                                        0x038d
#define mmCB_COLOR7_CLEAR_WORD1_BASE_IDX                                                               1
#define mmCB_COLOR7_DCC_BASE                                                                           0x038e
#define mmCB_COLOR7_DCC_BASE_BASE_IDX                                                                  1
#define mmCB_COLOR7_DCC_BASE_EXT                                                                       0x038f
#define mmCB_COLOR7_DCC_BASE_EXT_BASE_IDX                                                              1


// addressBlock: gc_gfxudec
// base address: 0x30000
#define mmCP_EOP_DONE_ADDR_LO                                                                          0x2000
#define mmCP_EOP_DONE_ADDR_LO_BASE_IDX                                                                 1
#define mmCP_EOP_DONE_ADDR_HI                                                                          0x2001
#define mmCP_EOP_DONE_ADDR_HI_BASE_IDX                                                                 1
#define mmCP_EOP_DONE_DATA_LO                                                                          0x2002
#define mmCP_EOP_DONE_DATA_LO_BASE_IDX                                                                 1
#define mmCP_EOP_DONE_DATA_HI                                                                          0x2003
#define mmCP_EOP_DONE_DATA_HI_BASE_IDX                                                                 1
#define mmCP_EOP_LAST_FENCE_LO                                                                         0x2004
#define mmCP_EOP_LAST_FENCE_LO_BASE_IDX                                                                1
#define mmCP_EOP_LAST_FENCE_HI                                                                         0x2005
#define mmCP_EOP_LAST_FENCE_HI_BASE_IDX                                                                1
#define mmCP_STREAM_OUT_ADDR_LO                                                                        0x2006
#define mmCP_STREAM_OUT_ADDR_LO_BASE_IDX                                                               1
#define mmCP_STREAM_OUT_ADDR_HI                                                                        0x2007
#define mmCP_STREAM_OUT_ADDR_HI_BASE_IDX                                                               1
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_LO                                                                0x2008
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_HI                                                                0x2009
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT0_LO                                                                 0x200a
#define mmCP_NUM_PRIM_NEEDED_COUNT0_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT0_HI                                                                 0x200b
#define mmCP_NUM_PRIM_NEEDED_COUNT0_HI_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_LO                                                                0x200c
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_HI                                                                0x200d
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT1_LO                                                                 0x200e
#define mmCP_NUM_PRIM_NEEDED_COUNT1_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT1_HI                                                                 0x200f
#define mmCP_NUM_PRIM_NEEDED_COUNT1_HI_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_LO                                                                0x2010
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_HI                                                                0x2011
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT2_LO                                                                 0x2012
#define mmCP_NUM_PRIM_NEEDED_COUNT2_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT2_HI                                                                 0x2013
#define mmCP_NUM_PRIM_NEEDED_COUNT2_HI_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_LO                                                                0x2014
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_LO_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_HI                                                                0x2015
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_HI_BASE_IDX                                                       1
#define mmCP_NUM_PRIM_NEEDED_COUNT3_LO                                                                 0x2016
#define mmCP_NUM_PRIM_NEEDED_COUNT3_LO_BASE_IDX                                                        1
#define mmCP_NUM_PRIM_NEEDED_COUNT3_HI                                                                 0x2017
#define mmCP_NUM_PRIM_NEEDED_COUNT3_HI_BASE_IDX                                                        1
#define mmCP_PIPE_STATS_ADDR_LO                                                                        0x2018
#define mmCP_PIPE_STATS_ADDR_LO_BASE_IDX                                                               1
#define mmCP_PIPE_STATS_ADDR_HI                                                                        0x2019
#define mmCP_PIPE_STATS_ADDR_HI_BASE_IDX                                                               1
#define mmCP_VGT_IAVERT_COUNT_LO                                                                       0x201a
#define mmCP_VGT_IAVERT_COUNT_LO_BASE_IDX                                                              1
#define mmCP_VGT_IAVERT_COUNT_HI                                                                       0x201b
#define mmCP_VGT_IAVERT_COUNT_HI_BASE_IDX                                                              1
#define mmCP_VGT_IAPRIM_COUNT_LO                                                                       0x201c
#define mmCP_VGT_IAPRIM_COUNT_LO_BASE_IDX                                                              1
#define mmCP_VGT_IAPRIM_COUNT_HI                                                                       0x201d
#define mmCP_VGT_IAPRIM_COUNT_HI_BASE_IDX                                                              1
#define mmCP_VGT_GSPRIM_COUNT_LO                                                                       0x201e
#define mmCP_VGT_GSPRIM_COUNT_LO_BASE_IDX                                                              1
#define mmCP_VGT_GSPRIM_COUNT_HI                                                                       0x201f
#define mmCP_VGT_GSPRIM_COUNT_HI_BASE_IDX                                                              1
#define mmCP_VGT_VSINVOC_COUNT_LO                                                                      0x2020
#define mmCP_VGT_VSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_VSINVOC_COUNT_HI                                                                      0x2021
#define mmCP_VGT_VSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_VGT_GSINVOC_COUNT_LO                                                                      0x2022
#define mmCP_VGT_GSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_GSINVOC_COUNT_HI                                                                      0x2023
#define mmCP_VGT_GSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_VGT_HSINVOC_COUNT_LO                                                                      0x2024
#define mmCP_VGT_HSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_HSINVOC_COUNT_HI                                                                      0x2025
#define mmCP_VGT_HSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_VGT_DSINVOC_COUNT_LO                                                                      0x2026
#define mmCP_VGT_DSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_DSINVOC_COUNT_HI                                                                      0x2027
#define mmCP_VGT_DSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_PA_CINVOC_COUNT_LO                                                                        0x2028
#define mmCP_PA_CINVOC_COUNT_LO_BASE_IDX                                                               1
#define mmCP_PA_CINVOC_COUNT_HI                                                                        0x2029
#define mmCP_PA_CINVOC_COUNT_HI_BASE_IDX                                                               1
#define mmCP_PA_CPRIM_COUNT_LO                                                                         0x202a
#define mmCP_PA_CPRIM_COUNT_LO_BASE_IDX                                                                1
#define mmCP_PA_CPRIM_COUNT_HI                                                                         0x202b
#define mmCP_PA_CPRIM_COUNT_HI_BASE_IDX                                                                1
#define mmCP_SC_PSINVOC_COUNT0_LO                                                                      0x202c
#define mmCP_SC_PSINVOC_COUNT0_LO_BASE_IDX                                                             1
#define mmCP_SC_PSINVOC_COUNT0_HI                                                                      0x202d
#define mmCP_SC_PSINVOC_COUNT0_HI_BASE_IDX                                                             1
#define mmCP_SC_PSINVOC_COUNT1_LO                                                                      0x202e
#define mmCP_SC_PSINVOC_COUNT1_LO_BASE_IDX                                                             1
#define mmCP_SC_PSINVOC_COUNT1_HI                                                                      0x202f
#define mmCP_SC_PSINVOC_COUNT1_HI_BASE_IDX                                                             1
#define mmCP_VGT_CSINVOC_COUNT_LO                                                                      0x2030
#define mmCP_VGT_CSINVOC_COUNT_LO_BASE_IDX                                                             1
#define mmCP_VGT_CSINVOC_COUNT_HI                                                                      0x2031
#define mmCP_VGT_CSINVOC_COUNT_HI_BASE_IDX                                                             1
#define mmCP_PIPE_STATS_CONTROL                                                                        0x203d
#define mmCP_PIPE_STATS_CONTROL_BASE_IDX                                                               1
#define mmCP_STREAM_OUT_CONTROL                                                                        0x203e
#define mmCP_STREAM_OUT_CONTROL_BASE_IDX                                                               1
#define mmCP_STRMOUT_CNTL                                                                              0x203f
#define mmCP_STRMOUT_CNTL_BASE_IDX                                                                     1
#define mmSCRATCH_REG0                                                                                 0x2040
#define mmSCRATCH_REG0_BASE_IDX                                                                        1
#define mmSCRATCH_REG1                                                                                 0x2041
#define mmSCRATCH_REG1_BASE_IDX                                                                        1
#define mmSCRATCH_REG2                                                                                 0x2042
#define mmSCRATCH_REG2_BASE_IDX                                                                        1
#define mmSCRATCH_REG3                                                                                 0x2043
#define mmSCRATCH_REG3_BASE_IDX                                                                        1
#define mmSCRATCH_REG4                                                                                 0x2044
#define mmSCRATCH_REG4_BASE_IDX                                                                        1
#define mmSCRATCH_REG5                                                                                 0x2045
#define mmSCRATCH_REG5_BASE_IDX                                                                        1
#define mmSCRATCH_REG6                                                                                 0x2046
#define mmSCRATCH_REG6_BASE_IDX                                                                        1
#define mmSCRATCH_REG7                                                                                 0x2047
#define mmSCRATCH_REG7_BASE_IDX                                                                        1
#define mmCP_APPEND_DATA_HI                                                                            0x204c
#define mmCP_APPEND_DATA_HI_BASE_IDX                                                                   1
#define mmCP_APPEND_LAST_CS_FENCE_HI                                                                   0x204d
#define mmCP_APPEND_LAST_CS_FENCE_HI_BASE_IDX                                                          1
#define mmCP_APPEND_LAST_PS_FENCE_HI                                                                   0x204e
#define mmCP_APPEND_LAST_PS_FENCE_HI_BASE_IDX                                                          1
#define mmSCRATCH_UMSK                                                                                 0x2050
#define mmSCRATCH_UMSK_BASE_IDX                                                                        1
#define mmSCRATCH_ADDR                                                                                 0x2051
#define mmSCRATCH_ADDR_BASE_IDX                                                                        1
#define mmCP_PFP_ATOMIC_PREOP_LO                                                                       0x2052
#define mmCP_PFP_ATOMIC_PREOP_LO_BASE_IDX                                                              1
#define mmCP_PFP_ATOMIC_PREOP_HI                                                                       0x2053
#define mmCP_PFP_ATOMIC_PREOP_HI_BASE_IDX                                                              1
#define mmCP_PFP_GDS_ATOMIC0_PREOP_LO                                                                  0x2054
#define mmCP_PFP_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                         1
#define mmCP_PFP_GDS_ATOMIC0_PREOP_HI                                                                  0x2055
#define mmCP_PFP_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                         1
#define mmCP_PFP_GDS_ATOMIC1_PREOP_LO                                                                  0x2056
#define mmCP_PFP_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                         1
#define mmCP_PFP_GDS_ATOMIC1_PREOP_HI                                                                  0x2057
#define mmCP_PFP_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                         1
#define mmCP_APPEND_ADDR_LO                                                                            0x2058
#define mmCP_APPEND_ADDR_LO_BASE_IDX                                                                   1
#define mmCP_APPEND_ADDR_HI                                                                            0x2059
#define mmCP_APPEND_ADDR_HI_BASE_IDX                                                                   1
#define mmCP_APPEND_DATA_LO                                                                            0x205a
#define mmCP_APPEND_DATA_LO_BASE_IDX                                                                   1
#define mmCP_APPEND_LAST_CS_FENCE_LO                                                                   0x205b
#define mmCP_APPEND_LAST_CS_FENCE_LO_BASE_IDX                                                          1
#define mmCP_APPEND_LAST_PS_FENCE_LO                                                                   0x205c
#define mmCP_APPEND_LAST_PS_FENCE_LO_BASE_IDX                                                          1
#define mmCP_ATOMIC_PREOP_LO                                                                           0x205d
#define mmCP_ATOMIC_PREOP_LO_BASE_IDX                                                                  1
#define mmCP_ME_ATOMIC_PREOP_LO                                                                        0x205d
#define mmCP_ME_ATOMIC_PREOP_LO_BASE_IDX                                                               1
#define mmCP_ATOMIC_PREOP_HI                                                                           0x205e
#define mmCP_ATOMIC_PREOP_HI_BASE_IDX                                                                  1
#define mmCP_ME_ATOMIC_PREOP_HI                                                                        0x205e
#define mmCP_ME_ATOMIC_PREOP_HI_BASE_IDX                                                               1
#define mmCP_GDS_ATOMIC0_PREOP_LO                                                                      0x205f
#define mmCP_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC0_PREOP_LO                                                                   0x205f
#define mmCP_ME_GDS_ATOMIC0_PREOP_LO_BASE_IDX                                                          1
#define mmCP_GDS_ATOMIC0_PREOP_HI                                                                      0x2060
#define mmCP_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC0_PREOP_HI                                                                   0x2060
#define mmCP_ME_GDS_ATOMIC0_PREOP_HI_BASE_IDX                                                          1
#define mmCP_GDS_ATOMIC1_PREOP_LO                                                                      0x2061
#define mmCP_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC1_PREOP_LO                                                                   0x2061
#define mmCP_ME_GDS_ATOMIC1_PREOP_LO_BASE_IDX                                                          1
#define mmCP_GDS_ATOMIC1_PREOP_HI                                                                      0x2062
#define mmCP_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                             1
#define mmCP_ME_GDS_ATOMIC1_PREOP_HI                                                                   0x2062
#define mmCP_ME_GDS_ATOMIC1_PREOP_HI_BASE_IDX                                                          1
#define mmCP_ME_MC_WADDR_LO                                                                            0x2069
#define mmCP_ME_MC_WADDR_LO_BASE_IDX                                                                   1
#define mmCP_ME_MC_WADDR_HI                                                                            0x206a
#define mmCP_ME_MC_WADDR_HI_BASE_IDX                                                                   1
#define mmCP_ME_MC_WDATA_LO                                                                            0x206b
#define mmCP_ME_MC_WDATA_LO_BASE_IDX                                                                   1
#define mmCP_ME_MC_WDATA_HI                                                                            0x206c
#define mmCP_ME_MC_WDATA_HI_BASE_IDX                                                                   1
#define mmCP_ME_MC_RADDR_LO                                                                            0x206d
#define mmCP_ME_MC_RADDR_LO_BASE_IDX                                                                   1
#define mmCP_ME_MC_RADDR_HI                                                                            0x206e
#define mmCP_ME_MC_RADDR_HI_BASE_IDX                                                                   1
#define mmCP_SEM_WAIT_TIMER                                                                            0x206f
#define mmCP_SEM_WAIT_TIMER_BASE_IDX                                                                   1
#define mmCP_SIG_SEM_ADDR_LO                                                                           0x2070
#define mmCP_SIG_SEM_ADDR_LO_BASE_IDX                                                                  1
#define mmCP_SIG_SEM_ADDR_HI                                                                           0x2071
#define mmCP_SIG_SEM_ADDR_HI_BASE_IDX                                                                  1
#define mmCP_WAIT_REG_MEM_TIMEOUT                                                                      0x2074
#define mmCP_WAIT_REG_MEM_TIMEOUT_BASE_IDX                                                             1
#define mmCP_WAIT_SEM_ADDR_LO                                                                          0x2075
#define mmCP_WAIT_SEM_ADDR_LO_BASE_IDX                                                                 1
#define mmCP_WAIT_SEM_ADDR_HI                                                                          0x2076
#define mmCP_WAIT_SEM_ADDR_HI_BASE_IDX                                                                 1
#define mmCP_DMA_PFP_CONTROL                                                                           0x2077
#define mmCP_DMA_PFP_CONTROL_BASE_IDX                                                                  1
#define mmCP_DMA_ME_CONTROL                                                                            0x2078
#define mmCP_DMA_ME_CONTROL_BASE_IDX                                                                   1
#define mmCP_COHER_BASE_HI                                                                             0x2079
#define mmCP_COHER_BASE_HI_BASE_IDX                                                                    1
#define mmCP_COHER_START_DELAY                                                                         0x207b
#define mmCP_COHER_START_DELAY_BASE_IDX                                                                1
#define mmCP_COHER_CNTL                                                                                0x207c
#define mmCP_COHER_CNTL_BASE_IDX                                                                       1
#define mmCP_COHER_SIZE                                                                                0x207d
#define mmCP_COHER_SIZE_BASE_IDX                                                                       1
#define mmCP_COHER_BASE                                                                                0x207e
#define mmCP_COHER_BASE_BASE_IDX                                                                       1
#define mmCP_COHER_STATUS                                                                              0x207f
#define mmCP_COHER_STATUS_BASE_IDX                                                                     1
#define mmCP_DMA_ME_SRC_ADDR                                                                           0x2080
#define mmCP_DMA_ME_SRC_ADDR_BASE_IDX                                                                  1
#define mmCP_DMA_ME_SRC_ADDR_HI                                                                        0x2081
#define mmCP_DMA_ME_SRC_ADDR_HI_BASE_IDX                                                               1
#define mmCP_DMA_ME_DST_ADDR                                                                           0x2082
#define mmCP_DMA_ME_DST_ADDR_BASE_IDX                                                                  1
#define mmCP_DMA_ME_DST_ADDR_HI                                                                        0x2083
#define mmCP_DMA_ME_DST_ADDR_HI_BASE_IDX                                                               1
#define mmCP_DMA_ME_COMMAND                                                                            0x2084
#define mmCP_DMA_ME_COMMAND_BASE_IDX                                                                   1
#define mmCP_DMA_PFP_SRC_ADDR                                                                          0x2085
#define mmCP_DMA_PFP_SRC_ADDR_BASE_IDX                                                                 1
#define mmCP_DMA_PFP_SRC_ADDR_HI                                                                       0x2086
#define mmCP_DMA_PFP_SRC_ADDR_HI_BASE_IDX                                                              1
#define mmCP_DMA_PFP_DST_ADDR                                                                          0x2087
#define mmCP_DMA_PFP_DST_ADDR_BASE_IDX                                                                 1
#define mmCP_DMA_PFP_DST_ADDR_HI                                                                       0x2088
#define mmCP_DMA_PFP_DST_ADDR_HI_BASE_IDX                                                              1
#define mmCP_DMA_PFP_COMMAND                                                                           0x2089
#define mmCP_DMA_PFP_COMMAND_BASE_IDX                                                                  1
#define mmCP_DMA_CNTL                                                                                  0x208a
#define mmCP_DMA_CNTL_BASE_IDX                                                                         1
#define mmCP_DMA_READ_TAGS                                                                             0x208b
#define mmCP_DMA_READ_TAGS_BASE_IDX                                                                    1
#define mmCP_COHER_SIZE_HI                                                                             0x208c
#define mmCP_COHER_SIZE_HI_BASE_IDX                                                                    1
#define mmCP_PFP_IB_CONTROL                                                                            0x208d
#define mmCP_PFP_IB_CONTROL_BASE_IDX                                                                   1
#define mmCP_PFP_LOAD_CONTROL                                                                          0x208e
#define mmCP_PFP_LOAD_CONTROL_BASE_IDX                                                                 1
#define mmCP_SCRATCH_INDEX                                                                             0x208f
#define mmCP_SCRATCH_INDEX_BASE_IDX                                                                    1
#define mmCP_SCRATCH_DATA                                                                              0x2090
#define mmCP_SCRATCH_DATA_BASE_IDX                                                                     1
#define mmCP_RB_OFFSET                                                                                 0x2091
#define mmCP_RB_OFFSET_BASE_IDX                                                                        1
#define mmCP_IB1_OFFSET                                                                                0x2092
#define mmCP_IB1_OFFSET_BASE_IDX                                                                       1
#define mmCP_IB2_OFFSET                                                                                0x2093
#define mmCP_IB2_OFFSET_BASE_IDX                                                                       1
#define mmCP_IB1_PREAMBLE_BEGIN                                                                        0x2094
#define mmCP_IB1_PREAMBLE_BEGIN_BASE_IDX                                                               1
#define mmCP_IB1_PREAMBLE_END                                                                          0x2095
#define mmCP_IB1_PREAMBLE_END_BASE_IDX                                                                 1
#define mmCP_IB2_PREAMBLE_BEGIN                                                                        0x2096
#define mmCP_IB2_PREAMBLE_BEGIN_BASE_IDX                                                               1
#define mmCP_IB2_PREAMBLE_END                                                                          0x2097
#define mmCP_IB2_PREAMBLE_END_BASE_IDX                                                                 1
#define mmCP_CE_IB1_OFFSET                                                                             0x2098
#define mmCP_CE_IB1_OFFSET_BASE_IDX                                                                    1
#define mmCP_CE_IB2_OFFSET                                                                             0x2099
#define mmCP_CE_IB2_OFFSET_BASE_IDX                                                                    1
#define mmCP_CE_COUNTER                                                                                0x209a
#define mmCP_CE_COUNTER_BASE_IDX                                                                       1
#define mmCP_CE_RB_OFFSET                                                                              0x209b
#define mmCP_CE_RB_OFFSET_BASE_IDX                                                                     1
#define mmCP_CE_INIT_CMD_BUFSZ                                                                         0x20bd
#define mmCP_CE_INIT_CMD_BUFSZ_BASE_IDX                                                                1
#define mmCP_CE_IB1_CMD_BUFSZ                                                                          0x20be
#define mmCP_CE_IB1_CMD_BUFSZ_BASE_IDX                                                                 1
#define mmCP_CE_IB2_CMD_BUFSZ                                                                          0x20bf
#define mmCP_CE_IB2_CMD_BUFSZ_BASE_IDX                                                                 1
#define mmCP_IB1_CMD_BUFSZ                                                                             0x20c0
#define mmCP_IB1_CMD_BUFSZ_BASE_IDX                                                                    1
#define mmCP_IB2_CMD_BUFSZ                                                                             0x20c1
#define mmCP_IB2_CMD_BUFSZ_BASE_IDX                                                                    1
#define mmCP_ST_CMD_BUFSZ                                                                              0x20c2
#define mmCP_ST_CMD_BUFSZ_BASE_IDX                                                                     1
#define mmCP_CE_INIT_BASE_LO                                                                           0x20c3
#define mmCP_CE_INIT_BASE_LO_BASE_IDX                                                                  1
#define mmCP_CE_INIT_BASE_HI                                                                           0x20c4
#define mmCP_CE_INIT_BASE_HI_BASE_IDX                                                                  1
#define mmCP_CE_INIT_BUFSZ                                                                             0x20c5
#define mmCP_CE_INIT_BUFSZ_BASE_IDX                                                                    1
#define mmCP_CE_IB1_BASE_LO                                                                            0x20c6
#define mmCP_CE_IB1_BASE_LO_BASE_IDX                                                                   1
#define mmCP_CE_IB1_BASE_HI                                                                            0x20c7
#define mmCP_CE_IB1_BASE_HI_BASE_IDX                                                                   1
#define mmCP_CE_IB1_BUFSZ                                                                              0x20c8
#define mmCP_CE_IB1_BUFSZ_BASE_IDX                                                                     1
#define mmCP_CE_IB2_BASE_LO                                                                            0x20c9
#define mmCP_CE_IB2_BASE_LO_BASE_IDX                                                                   1
#define mmCP_CE_IB2_BASE_HI                                                                            0x20ca
#define mmCP_CE_IB2_BASE_HI_BASE_IDX                                                                   1
#define mmCP_CE_IB2_BUFSZ                                                                              0x20cb
#define mmCP_CE_IB2_BUFSZ_BASE_IDX                                                                     1
#define mmCP_IB1_BASE_LO                                                                               0x20cc
#define mmCP_IB1_BASE_LO_BASE_IDX                                                                      1
#define mmCP_IB1_BASE_HI                                                                               0x20cd
#define mmCP_IB1_BASE_HI_BASE_IDX                                                                      1
#define mmCP_IB1_BUFSZ                                                                                 0x20ce
#define mmCP_IB1_BUFSZ_BASE_IDX                                                                        1
#define mmCP_IB2_BASE_LO                                                                               0x20cf
#define mmCP_IB2_BASE_LO_BASE_IDX                                                                      1
#define mmCP_IB2_BASE_HI                                                                               0x20d0
#define mmCP_IB2_BASE_HI_BASE_IDX                                                                      1
#define mmCP_IB2_BUFSZ                                                                                 0x20d1
#define mmCP_IB2_BUFSZ_BASE_IDX                                                                        1
#define mmCP_ST_BASE_LO                                                                                0x20d2
#define mmCP_ST_BASE_LO_BASE_IDX                                                                       1
#define mmCP_ST_BASE_HI                                                                                0x20d3
#define mmCP_ST_BASE_HI_BASE_IDX                                                                       1
#define mmCP_ST_BUFSZ                                                                                  0x20d4
#define mmCP_ST_BUFSZ_BASE_IDX                                                                         1
#define mmCP_EOP_DONE_EVENT_CNTL                                                                       0x20d5
#define mmCP_EOP_DONE_EVENT_CNTL_BASE_IDX                                                              1
#define mmCP_EOP_DONE_DATA_CNTL                                                                        0x20d6
#define mmCP_EOP_DONE_DATA_CNTL_BASE_IDX                                                               1
#define mmCP_EOP_DONE_CNTX_ID                                                                          0x20d7
#define mmCP_EOP_DONE_CNTX_ID_BASE_IDX                                                                 1
#define mmCP_PFP_COMPLETION_STATUS                                                                     0x20ec
#define mmCP_PFP_COMPLETION_STATUS_BASE_IDX                                                            1
#define mmCP_CE_COMPLETION_STATUS                                                                      0x20ed
#define mmCP_CE_COMPLETION_STATUS_BASE_IDX                                                             1
#define mmCP_PRED_NOT_VISIBLE                                                                          0x20ee
#define mmCP_PRED_NOT_VISIBLE_BASE_IDX                                                                 1
#define mmCP_PFP_METADATA_BASE_ADDR                                                                    0x20f0
#define mmCP_PFP_METADATA_BASE_ADDR_BASE_IDX                                                           1
#define mmCP_PFP_METADATA_BASE_ADDR_HI                                                                 0x20f1
#define mmCP_PFP_METADATA_BASE_ADDR_HI_BASE_IDX                                                        1
#define mmCP_CE_METADATA_BASE_ADDR                                                                     0x20f2
#define mmCP_CE_METADATA_BASE_ADDR_BASE_IDX                                                            1
#define mmCP_CE_METADATA_BASE_ADDR_HI                                                                  0x20f3
#define mmCP_CE_METADATA_BASE_ADDR_HI_BASE_IDX                                                         1
#define mmCP_DRAW_INDX_INDR_ADDR                                                                       0x20f4
#define mmCP_DRAW_INDX_INDR_ADDR_BASE_IDX                                                              1
#define mmCP_DRAW_INDX_INDR_ADDR_HI                                                                    0x20f5
#define mmCP_DRAW_INDX_INDR_ADDR_HI_BASE_IDX                                                           1
#define mmCP_DISPATCH_INDR_ADDR                                                                        0x20f6
#define mmCP_DISPATCH_INDR_ADDR_BASE_IDX                                                               1
#define mmCP_DISPATCH_INDR_ADDR_HI                                                                     0x20f7
#define mmCP_DISPATCH_INDR_ADDR_HI_BASE_IDX                                                            1
#define mmCP_INDEX_BASE_ADDR                                                                           0x20f8
#define mmCP_INDEX_BASE_ADDR_BASE_IDX                                                                  1
#define mmCP_INDEX_BASE_ADDR_HI                                                                        0x20f9
#define mmCP_INDEX_BASE_ADDR_HI_BASE_IDX                                                               1
#define mmCP_INDEX_TYPE                                                                                0x20fa
#define mmCP_INDEX_TYPE_BASE_IDX                                                                       1
#define mmCP_GDS_BKUP_ADDR                                                                             0x20fb
#define mmCP_GDS_BKUP_ADDR_BASE_IDX                                                                    1
#define mmCP_GDS_BKUP_ADDR_HI                                                                          0x20fc
#define mmCP_GDS_BKUP_ADDR_HI_BASE_IDX                                                                 1
#define mmCP_SAMPLE_STATUS                                                                             0x20fd
#define mmCP_SAMPLE_STATUS_BASE_IDX                                                                    1
#define mmCP_ME_COHER_CNTL                                                                             0x20fe
#define mmCP_ME_COHER_CNTL_BASE_IDX                                                                    1
#define mmCP_ME_COHER_SIZE                                                                             0x20ff
#define mmCP_ME_COHER_SIZE_BASE_IDX                                                                    1
#define mmCP_ME_COHER_SIZE_HI                                                                          0x2100
#define mmCP_ME_COHER_SIZE_HI_BASE_IDX                                                                 1
#define mmCP_ME_COHER_BASE                                                                             0x2101
#define mmCP_ME_COHER_BASE_BASE_IDX                                                                    1
#define mmCP_ME_COHER_BASE_HI                                                                          0x2102
#define mmCP_ME_COHER_BASE_HI_BASE_IDX                                                                 1
#define mmCP_ME_COHER_STATUS                                                                           0x2103
#define mmCP_ME_COHER_STATUS_BASE_IDX                                                                  1
#define mmRLC_GPM_PERF_COUNT_0                                                                         0x2140
#define mmRLC_GPM_PERF_COUNT_0_BASE_IDX                                                                1
#define mmRLC_GPM_PERF_COUNT_1                                                                         0x2141
#define mmRLC_GPM_PERF_COUNT_1_BASE_IDX                                                                1
#define mmGRBM_GFX_INDEX                                                                               0x2200
#define mmGRBM_GFX_INDEX_BASE_IDX                                                                      1
#define mmVGT_GSVS_RING_SIZE                                                                           0x2241
#define mmVGT_GSVS_RING_SIZE_BASE_IDX                                                                  1
#define mmVGT_PRIMITIVE_TYPE                                                                           0x2242
#define mmVGT_PRIMITIVE_TYPE_BASE_IDX                                                                  1
#define mmVGT_INDEX_TYPE                                                                               0x2243
#define mmVGT_INDEX_TYPE_BASE_IDX                                                                      1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_0                                                             0x2244
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_0_BASE_IDX                                                    1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_1                                                             0x2245
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_1_BASE_IDX                                                    1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_2                                                             0x2246
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_2_BASE_IDX                                                    1
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_3                                                             0x2247
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_3_BASE_IDX                                                    1
#define mmVGT_MAX_VTX_INDX                                                                             0x2248
#define mmVGT_MAX_VTX_INDX_BASE_IDX                                                                    1
#define mmVGT_MIN_VTX_INDX                                                                             0x2249
#define mmVGT_MIN_VTX_INDX_BASE_IDX                                                                    1
#define mmVGT_INDX_OFFSET                                                                              0x224a
#define mmVGT_INDX_OFFSET_BASE_IDX                                                                     1
#define mmVGT_MULTI_PRIM_IB_RESET_EN                                                                   0x224b
#define mmVGT_MULTI_PRIM_IB_RESET_EN_BASE_IDX                                                          1
#define mmVGT_NUM_INDICES                                                                              0x224c
#define mmVGT_NUM_INDICES_BASE_IDX                                                                     1
#define mmVGT_NUM_INSTANCES                                                                            0x224d
#define mmVGT_NUM_INSTANCES_BASE_IDX                                                                   1
#define mmVGT_TF_RING_SIZE                                                                             0x224e
#define mmVGT_TF_RING_SIZE_BASE_IDX                                                                    1
#define mmVGT_HS_OFFCHIP_PARAM                                                                         0x224f
#define mmVGT_HS_OFFCHIP_PARAM_BASE_IDX                                                                1
#define mmVGT_TF_MEMORY_BASE                                                                           0x2250
#define mmVGT_TF_MEMORY_BASE_BASE_IDX                                                                  1
#define mmVGT_TF_MEMORY_BASE_HI                                                                        0x2251
#define mmVGT_TF_MEMORY_BASE_HI_BASE_IDX                                                               1
#define mmWD_POS_BUF_BASE                                                                              0x2252
#define mmWD_POS_BUF_BASE_BASE_IDX                                                                     1
#define mmWD_POS_BUF_BASE_HI                                                                           0x2253
#define mmWD_POS_BUF_BASE_HI_BASE_IDX                                                                  1
#define mmWD_CNTL_SB_BUF_BASE                                                                          0x2254
#define mmWD_CNTL_SB_BUF_BASE_BASE_IDX                                                                 1
#define mmWD_CNTL_SB_BUF_BASE_HI                                                                       0x2255
#define mmWD_CNTL_SB_BUF_BASE_HI_BASE_IDX                                                              1
#define mmWD_INDEX_BUF_BASE                                                                            0x2256
#define mmWD_INDEX_BUF_BASE_BASE_IDX                                                                   1
#define mmWD_INDEX_BUF_BASE_HI                                                                         0x2257
#define mmWD_INDEX_BUF_BASE_HI_BASE_IDX                                                                1
#define mmIA_MULTI_VGT_PARAM                                                                           0x2258
#define mmIA_MULTI_VGT_PARAM_BASE_IDX                                                                  1
#define mmVGT_INSTANCE_BASE_ID                                                                         0x225a
#define mmVGT_INSTANCE_BASE_ID_BASE_IDX                                                                1
#define mmPA_SU_LINE_STIPPLE_VALUE                                                                     0x2280
#define mmPA_SU_LINE_STIPPLE_VALUE_BASE_IDX                                                            1
#define mmPA_SC_LINE_STIPPLE_STATE                                                                     0x2281
#define mmPA_SC_LINE_STIPPLE_STATE_BASE_IDX                                                            1
#define mmPA_SC_SCREEN_EXTENT_MIN_0                                                                    0x2284
#define mmPA_SC_SCREEN_EXTENT_MIN_0_BASE_IDX                                                           1
#define mmPA_SC_SCREEN_EXTENT_MAX_0                                                                    0x2285
#define mmPA_SC_SCREEN_EXTENT_MAX_0_BASE_IDX                                                           1
#define mmPA_SC_SCREEN_EXTENT_MIN_1                                                                    0x2286
#define mmPA_SC_SCREEN_EXTENT_MIN_1_BASE_IDX                                                           1
#define mmPA_SC_SCREEN_EXTENT_MAX_1                                                                    0x228b
#define mmPA_SC_SCREEN_EXTENT_MAX_1_BASE_IDX                                                           1
#define mmPA_SC_P3D_TRAP_SCREEN_HV_EN                                                                  0x22a0
#define mmPA_SC_P3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                         1
#define mmPA_SC_P3D_TRAP_SCREEN_H                                                                      0x22a1
#define mmPA_SC_P3D_TRAP_SCREEN_H_BASE_IDX                                                             1
#define mmPA_SC_P3D_TRAP_SCREEN_V                                                                      0x22a2
#define mmPA_SC_P3D_TRAP_SCREEN_V_BASE_IDX                                                             1
#define mmPA_SC_P3D_TRAP_SCREEN_OCCURRENCE                                                             0x22a3
#define mmPA_SC_P3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                    1
#define mmPA_SC_P3D_TRAP_SCREEN_COUNT                                                                  0x22a4
#define mmPA_SC_P3D_TRAP_SCREEN_COUNT_BASE_IDX                                                         1
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_EN                                                                 0x22a8
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                        1
#define mmPA_SC_HP3D_TRAP_SCREEN_H                                                                     0x22a9
#define mmPA_SC_HP3D_TRAP_SCREEN_H_BASE_IDX                                                            1
#define mmPA_SC_HP3D_TRAP_SCREEN_V                                                                     0x22aa
#define mmPA_SC_HP3D_TRAP_SCREEN_V_BASE_IDX                                                            1
#define mmPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE                                                            0x22ab
#define mmPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                   1
#define mmPA_SC_HP3D_TRAP_SCREEN_COUNT                                                                 0x22ac
#define mmPA_SC_HP3D_TRAP_SCREEN_COUNT_BASE_IDX                                                        1
#define mmPA_SC_TRAP_SCREEN_HV_EN                                                                      0x22b0
#define mmPA_SC_TRAP_SCREEN_HV_EN_BASE_IDX                                                             1
#define mmPA_SC_TRAP_SCREEN_H                                                                          0x22b1
#define mmPA_SC_TRAP_SCREEN_H_BASE_IDX                                                                 1
#define mmPA_SC_TRAP_SCREEN_V                                                                          0x22b2
#define mmPA_SC_TRAP_SCREEN_V_BASE_IDX                                                                 1
#define mmPA_SC_TRAP_SCREEN_OCCURRENCE                                                                 0x22b3
#define mmPA_SC_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                        1
#define mmPA_SC_TRAP_SCREEN_COUNT                                                                      0x22b4
#define mmPA_SC_TRAP_SCREEN_COUNT_BASE_IDX                                                             1
#define mmSQ_THREAD_TRACE_BASE                                                                         0x2330
#define mmSQ_THREAD_TRACE_BASE_BASE_IDX                                                                1
#define mmSQ_THREAD_TRACE_SIZE                                                                         0x2331
#define mmSQ_THREAD_TRACE_SIZE_BASE_IDX                                                                1
#define mmSQ_THREAD_TRACE_MASK                                                                         0x2332
#define mmSQ_THREAD_TRACE_MASK_BASE_IDX                                                                1
#define mmSQ_THREAD_TRACE_TOKEN_MASK                                                                   0x2333
#define mmSQ_THREAD_TRACE_TOKEN_MASK_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_PERF_MASK                                                                    0x2334
#define mmSQ_THREAD_TRACE_PERF_MASK_BASE_IDX                                                           1
#define mmSQ_THREAD_TRACE_CTRL                                                                         0x2335
#define mmSQ_THREAD_TRACE_CTRL_BASE_IDX                                                                1
#define mmSQ_THREAD_TRACE_MODE                                                                         0x2336
#define mmSQ_THREAD_TRACE_MODE_BASE_IDX                                                                1
#define mmSQ_THREAD_TRACE_BASE2                                                                        0x2337
#define mmSQ_THREAD_TRACE_BASE2_BASE_IDX                                                               1
#define mmSQ_THREAD_TRACE_TOKEN_MASK2                                                                  0x2338
#define mmSQ_THREAD_TRACE_TOKEN_MASK2_BASE_IDX                                                         1
#define mmSQ_THREAD_TRACE_WPTR                                                                         0x2339
#define mmSQ_THREAD_TRACE_WPTR_BASE_IDX                                                                1
#define mmSQ_THREAD_TRACE_STATUS                                                                       0x233a
#define mmSQ_THREAD_TRACE_STATUS_BASE_IDX                                                              1
#define mmSQ_THREAD_TRACE_HIWATER                                                                      0x233b
#define mmSQ_THREAD_TRACE_HIWATER_BASE_IDX                                                             1
#define mmSQ_THREAD_TRACE_CNTR                                                                         0x233c
#define mmSQ_THREAD_TRACE_CNTR_BASE_IDX                                                                1
#define mmSQ_THREAD_TRACE_USERDATA_0                                                                   0x2340
#define mmSQ_THREAD_TRACE_USERDATA_0_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_1                                                                   0x2341
#define mmSQ_THREAD_TRACE_USERDATA_1_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_2                                                                   0x2342
#define mmSQ_THREAD_TRACE_USERDATA_2_BASE_IDX                                                          1
#define mmSQ_THREAD_TRACE_USERDATA_3                                                                   0x2343
#define mmSQ_THREAD_TRACE_USERDATA_3_BASE_IDX                                                          1
#define mmSQC_CACHES                                                                                   0x2348
#define mmSQC_CACHES_BASE_IDX                                                                          1
#define mmSQC_WRITEBACK                                                                                0x2349
#define mmSQC_WRITEBACK_BASE_IDX                                                                       1
#define mmTA_CS_BC_BASE_ADDR                                                                           0x2380
#define mmTA_CS_BC_BASE_ADDR_BASE_IDX                                                                  1
#define mmTA_CS_BC_BASE_ADDR_HI                                                                        0x2381
#define mmTA_CS_BC_BASE_ADDR_HI_BASE_IDX                                                               1
#define mmDB_OCCLUSION_COUNT0_LOW                                                                      0x23c0
#define mmDB_OCCLUSION_COUNT0_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT0_HI                                                                       0x23c1
#define mmDB_OCCLUSION_COUNT0_HI_BASE_IDX                                                              1
#define mmDB_OCCLUSION_COUNT1_LOW                                                                      0x23c2
#define mmDB_OCCLUSION_COUNT1_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT1_HI                                                                       0x23c3
#define mmDB_OCCLUSION_COUNT1_HI_BASE_IDX                                                              1
#define mmDB_OCCLUSION_COUNT2_LOW                                                                      0x23c4
#define mmDB_OCCLUSION_COUNT2_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT2_HI                                                                       0x23c5
#define mmDB_OCCLUSION_COUNT2_HI_BASE_IDX                                                              1
#define mmDB_OCCLUSION_COUNT3_LOW                                                                      0x23c6
#define mmDB_OCCLUSION_COUNT3_LOW_BASE_IDX                                                             1
#define mmDB_OCCLUSION_COUNT3_HI                                                                       0x23c7
#define mmDB_OCCLUSION_COUNT3_HI_BASE_IDX                                                              1
#define mmDB_ZPASS_COUNT_LOW                                                                           0x23fe
#define mmDB_ZPASS_COUNT_LOW_BASE_IDX                                                                  1
#define mmDB_ZPASS_COUNT_HI                                                                            0x23ff
#define mmDB_ZPASS_COUNT_HI_BASE_IDX                                                                   1
#define mmGDS_RD_ADDR                                                                                  0x2400
#define mmGDS_RD_ADDR_BASE_IDX                                                                         1
#define mmGDS_RD_DATA                                                                                  0x2401
#define mmGDS_RD_DATA_BASE_IDX                                                                         1
#define mmGDS_RD_BURST_ADDR                                                                            0x2402
#define mmGDS_RD_BURST_ADDR_BASE_IDX                                                                   1
#define mmGDS_RD_BURST_COUNT                                                                           0x2403
#define mmGDS_RD_BURST_COUNT_BASE_IDX                                                                  1
#define mmGDS_RD_BURST_DATA                                                                            0x2404
#define mmGDS_RD_BURST_DATA_BASE_IDX                                                                   1
#define mmGDS_WR_ADDR                                                                                  0x2405
#define mmGDS_WR_ADDR_BASE_IDX                                                                         1
#define mmGDS_WR_DATA                                                                                  0x2406
#define mmGDS_WR_DATA_BASE_IDX                                                                         1
#define mmGDS_WR_BURST_ADDR                                                                            0x2407
#define mmGDS_WR_BURST_ADDR_BASE_IDX                                                                   1
#define mmGDS_WR_BURST_DATA                                                                            0x2408
#define mmGDS_WR_BURST_DATA_BASE_IDX                                                                   1
#define mmGDS_WRITE_COMPLETE                                                                           0x2409
#define mmGDS_WRITE_COMPLETE_BASE_IDX                                                                  1
#define mmGDS_ATOM_CNTL                                                                                0x240a
#define mmGDS_ATOM_CNTL_BASE_IDX                                                                       1
#define mmGDS_ATOM_COMPLETE                                                                            0x240b
#define mmGDS_ATOM_COMPLETE_BASE_IDX                                                                   1
#define mmGDS_ATOM_BASE                                                                                0x240c
#define mmGDS_ATOM_BASE_BASE_IDX                                                                       1
#define mmGDS_ATOM_SIZE                                                                                0x240d
#define mmGDS_ATOM_SIZE_BASE_IDX                                                                       1
#define mmGDS_ATOM_OFFSET0                                                                             0x240e
#define mmGDS_ATOM_OFFSET0_BASE_IDX                                                                    1
#define mmGDS_ATOM_OFFSET1                                                                             0x240f
#define mmGDS_ATOM_OFFSET1_BASE_IDX                                                                    1
#define mmGDS_ATOM_DST                                                                                 0x2410
#define mmGDS_ATOM_DST_BASE_IDX                                                                        1
#define mmGDS_ATOM_OP                                                                                  0x2411
#define mmGDS_ATOM_OP_BASE_IDX                                                                         1
#define mmGDS_ATOM_SRC0                                                                                0x2412
#define mmGDS_ATOM_SRC0_BASE_IDX                                                                       1
#define mmGDS_ATOM_SRC0_U                                                                              0x2413
#define mmGDS_ATOM_SRC0_U_BASE_IDX                                                                     1
#define mmGDS_ATOM_SRC1                                                                                0x2414
#define mmGDS_ATOM_SRC1_BASE_IDX                                                                       1
#define mmGDS_ATOM_SRC1_U                                                                              0x2415
#define mmGDS_ATOM_SRC1_U_BASE_IDX                                                                     1
#define mmGDS_ATOM_READ0                                                                               0x2416
#define mmGDS_ATOM_READ0_BASE_IDX                                                                      1
#define mmGDS_ATOM_READ0_U                                                                             0x2417
#define mmGDS_ATOM_READ0_U_BASE_IDX                                                                    1
#define mmGDS_ATOM_READ1                                                                               0x2418
#define mmGDS_ATOM_READ1_BASE_IDX                                                                      1
#define mmGDS_ATOM_READ1_U                                                                             0x2419
#define mmGDS_ATOM_READ1_U_BASE_IDX                                                                    1
#define mmGDS_GWS_RESOURCE_CNTL                                                                        0x241a
#define mmGDS_GWS_RESOURCE_CNTL_BASE_IDX                                                               1
#define mmGDS_GWS_RESOURCE                                                                             0x241b
#define mmGDS_GWS_RESOURCE_BASE_IDX                                                                    1
#define mmGDS_GWS_RESOURCE_CNT                                                                         0x241c
#define mmGDS_GWS_RESOURCE_CNT_BASE_IDX                                                                1
#define mmGDS_OA_CNTL                                                                                  0x241d
#define mmGDS_OA_CNTL_BASE_IDX                                                                         1
#define mmGDS_OA_COUNTER                                                                               0x241e
#define mmGDS_OA_COUNTER_BASE_IDX                                                                      1
#define mmGDS_OA_ADDRESS                                                                               0x241f
#define mmGDS_OA_ADDRESS_BASE_IDX                                                                      1
#define mmGDS_OA_INCDEC                                                                                0x2420
#define mmGDS_OA_INCDEC_BASE_IDX                                                                       1
#define mmGDS_OA_RING_SIZE                                                                             0x2421
#define mmGDS_OA_RING_SIZE_BASE_IDX                                                                    1
#define mmSPI_CONFIG_CNTL                                                                              0x2440
#define mmSPI_CONFIG_CNTL_BASE_IDX                                                                     1
#define mmSPI_CONFIG_CNTL_1                                                                            0x2441
#define mmSPI_CONFIG_CNTL_1_BASE_IDX                                                                   1
#define mmSPI_CONFIG_CNTL_2                                                                            0x2442
#define mmSPI_CONFIG_CNTL_2_BASE_IDX                                                                   1


// addressBlock: gc_perfddec
// base address: 0x34000
#define mmCPG_PERFCOUNTER1_LO                                                                          0x3000
#define mmCPG_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCPG_PERFCOUNTER1_HI                                                                          0x3001
#define mmCPG_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCPG_PERFCOUNTER0_LO                                                                          0x3002
#define mmCPG_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCPG_PERFCOUNTER0_HI                                                                          0x3003
#define mmCPG_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER1_LO                                                                          0x3004
#define mmCPC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER1_HI                                                                          0x3005
#define mmCPC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER0_LO                                                                          0x3006
#define mmCPC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCPC_PERFCOUNTER0_HI                                                                          0x3007
#define mmCPC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER1_LO                                                                          0x3008
#define mmCPF_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER1_HI                                                                          0x3009
#define mmCPF_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER0_LO                                                                          0x300a
#define mmCPF_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmCPF_PERFCOUNTER0_HI                                                                          0x300b
#define mmCPF_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmCPF_LATENCY_STATS_DATA                                                                       0x300c
#define mmCPF_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define mmCPG_LATENCY_STATS_DATA                                                                       0x300d
#define mmCPG_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define mmCPC_LATENCY_STATS_DATA                                                                       0x300e
#define mmCPC_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define mmGRBM_PERFCOUNTER0_LO                                                                         0x3040
#define mmGRBM_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define mmGRBM_PERFCOUNTER0_HI                                                                         0x3041
#define mmGRBM_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define mmGRBM_PERFCOUNTER1_LO                                                                         0x3043
#define mmGRBM_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define mmGRBM_PERFCOUNTER1_HI                                                                         0x3044
#define mmGRBM_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define mmGRBM_SE0_PERFCOUNTER_LO                                                                      0x3045
#define mmGRBM_SE0_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE0_PERFCOUNTER_HI                                                                      0x3046
#define mmGRBM_SE0_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmGRBM_SE1_PERFCOUNTER_LO                                                                      0x3047
#define mmGRBM_SE1_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE1_PERFCOUNTER_HI                                                                      0x3048
#define mmGRBM_SE1_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmGRBM_SE2_PERFCOUNTER_LO                                                                      0x3049
#define mmGRBM_SE2_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE2_PERFCOUNTER_HI                                                                      0x304a
#define mmGRBM_SE2_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmGRBM_SE3_PERFCOUNTER_LO                                                                      0x304b
#define mmGRBM_SE3_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmGRBM_SE3_PERFCOUNTER_HI                                                                      0x304c
#define mmGRBM_SE3_PERFCOUNTER_HI_BASE_IDX                                                             1
#define mmWD_PERFCOUNTER0_LO                                                                           0x3080
#define mmWD_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmWD_PERFCOUNTER0_HI                                                                           0x3081
#define mmWD_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmWD_PERFCOUNTER1_LO                                                                           0x3082
#define mmWD_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmWD_PERFCOUNTER1_HI                                                                           0x3083
#define mmWD_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmWD_PERFCOUNTER2_LO                                                                           0x3084
#define mmWD_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmWD_PERFCOUNTER2_HI                                                                           0x3085
#define mmWD_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmWD_PERFCOUNTER3_LO                                                                           0x3086
#define mmWD_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmWD_PERFCOUNTER3_HI                                                                           0x3087
#define mmWD_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER0_LO                                                                           0x3088
#define mmIA_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER0_HI                                                                           0x3089
#define mmIA_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER1_LO                                                                           0x308a
#define mmIA_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER1_HI                                                                           0x308b
#define mmIA_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER2_LO                                                                           0x308c
#define mmIA_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER2_HI                                                                           0x308d
#define mmIA_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER3_LO                                                                           0x308e
#define mmIA_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmIA_PERFCOUNTER3_HI                                                                           0x308f
#define mmIA_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmVGT_PERFCOUNTER0_LO                                                                          0x3090
#define mmVGT_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmVGT_PERFCOUNTER0_HI                                                                          0x3091
#define mmVGT_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmVGT_PERFCOUNTER1_LO                                                                          0x3092
#define mmVGT_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmVGT_PERFCOUNTER1_HI                                                                          0x3093
#define mmVGT_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmVGT_PERFCOUNTER2_LO                                                                          0x3094
#define mmVGT_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmVGT_PERFCOUNTER2_HI                                                                          0x3095
#define mmVGT_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmVGT_PERFCOUNTER3_LO                                                                          0x3096
#define mmVGT_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmVGT_PERFCOUNTER3_HI                                                                          0x3097
#define mmVGT_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmPA_SU_PERFCOUNTER0_LO                                                                        0x3100
#define mmPA_SU_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER0_HI                                                                        0x3101
#define mmPA_SU_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER1_LO                                                                        0x3102
#define mmPA_SU_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER1_HI                                                                        0x3103
#define mmPA_SU_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER2_LO                                                                        0x3104
#define mmPA_SU_PERFCOUNTER2_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER2_HI                                                                        0x3105
#define mmPA_SU_PERFCOUNTER2_HI_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER3_LO                                                                        0x3106
#define mmPA_SU_PERFCOUNTER3_LO_BASE_IDX                                                               1
#define mmPA_SU_PERFCOUNTER3_HI                                                                        0x3107
#define mmPA_SU_PERFCOUNTER3_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER0_LO                                                                        0x3140
#define mmPA_SC_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER0_HI                                                                        0x3141
#define mmPA_SC_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER1_LO                                                                        0x3142
#define mmPA_SC_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER1_HI                                                                        0x3143
#define mmPA_SC_PERFCOUNTER1_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER2_LO                                                                        0x3144
#define mmPA_SC_PERFCOUNTER2_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER2_HI                                                                        0x3145
#define mmPA_SC_PERFCOUNTER2_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER3_LO                                                                        0x3146
#define mmPA_SC_PERFCOUNTER3_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER3_HI                                                                        0x3147
#define mmPA_SC_PERFCOUNTER3_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER4_LO                                                                        0x3148
#define mmPA_SC_PERFCOUNTER4_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER4_HI                                                                        0x3149
#define mmPA_SC_PERFCOUNTER4_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER5_LO                                                                        0x314a
#define mmPA_SC_PERFCOUNTER5_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER5_HI                                                                        0x314b
#define mmPA_SC_PERFCOUNTER5_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER6_LO                                                                        0x314c
#define mmPA_SC_PERFCOUNTER6_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER6_HI                                                                        0x314d
#define mmPA_SC_PERFCOUNTER6_HI_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER7_LO                                                                        0x314e
#define mmPA_SC_PERFCOUNTER7_LO_BASE_IDX                                                               1
#define mmPA_SC_PERFCOUNTER7_HI                                                                        0x314f
#define mmPA_SC_PERFCOUNTER7_HI_BASE_IDX                                                               1
#define mmSPI_PERFCOUNTER0_HI                                                                          0x3180
#define mmSPI_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER0_LO                                                                          0x3181
#define mmSPI_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER1_HI                                                                          0x3182
#define mmSPI_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER1_LO                                                                          0x3183
#define mmSPI_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER2_HI                                                                          0x3184
#define mmSPI_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER2_LO                                                                          0x3185
#define mmSPI_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER3_HI                                                                          0x3186
#define mmSPI_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER3_LO                                                                          0x3187
#define mmSPI_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER4_HI                                                                          0x3188
#define mmSPI_PERFCOUNTER4_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER4_LO                                                                          0x3189
#define mmSPI_PERFCOUNTER4_LO_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER5_HI                                                                          0x318a
#define mmSPI_PERFCOUNTER5_HI_BASE_IDX                                                                 1
#define mmSPI_PERFCOUNTER5_LO                                                                          0x318b
#define mmSPI_PERFCOUNTER5_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER0_LO                                                                           0x31c0
#define mmSQ_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER0_HI                                                                           0x31c1
#define mmSQ_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER1_LO                                                                           0x31c2
#define mmSQ_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER1_HI                                                                           0x31c3
#define mmSQ_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER2_LO                                                                           0x31c4
#define mmSQ_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER2_HI                                                                           0x31c5
#define mmSQ_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER3_LO                                                                           0x31c6
#define mmSQ_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER3_HI                                                                           0x31c7
#define mmSQ_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER4_LO                                                                           0x31c8
#define mmSQ_PERFCOUNTER4_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER4_HI                                                                           0x31c9
#define mmSQ_PERFCOUNTER4_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER5_LO                                                                           0x31ca
#define mmSQ_PERFCOUNTER5_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER5_HI                                                                           0x31cb
#define mmSQ_PERFCOUNTER5_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER6_LO                                                                           0x31cc
#define mmSQ_PERFCOUNTER6_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER6_HI                                                                           0x31cd
#define mmSQ_PERFCOUNTER6_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER7_LO                                                                           0x31ce
#define mmSQ_PERFCOUNTER7_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER7_HI                                                                           0x31cf
#define mmSQ_PERFCOUNTER7_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER8_LO                                                                           0x31d0
#define mmSQ_PERFCOUNTER8_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER8_HI                                                                           0x31d1
#define mmSQ_PERFCOUNTER8_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER9_LO                                                                           0x31d2
#define mmSQ_PERFCOUNTER9_LO_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER9_HI                                                                           0x31d3
#define mmSQ_PERFCOUNTER9_HI_BASE_IDX                                                                  1
#define mmSQ_PERFCOUNTER10_LO                                                                          0x31d4
#define mmSQ_PERFCOUNTER10_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER10_HI                                                                          0x31d5
#define mmSQ_PERFCOUNTER10_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER11_LO                                                                          0x31d6
#define mmSQ_PERFCOUNTER11_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER11_HI                                                                          0x31d7
#define mmSQ_PERFCOUNTER11_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER12_LO                                                                          0x31d8
#define mmSQ_PERFCOUNTER12_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER12_HI                                                                          0x31d9
#define mmSQ_PERFCOUNTER12_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER13_LO                                                                          0x31da
#define mmSQ_PERFCOUNTER13_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER13_HI                                                                          0x31db
#define mmSQ_PERFCOUNTER13_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER14_LO                                                                          0x31dc
#define mmSQ_PERFCOUNTER14_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER14_HI                                                                          0x31dd
#define mmSQ_PERFCOUNTER14_HI_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER15_LO                                                                          0x31de
#define mmSQ_PERFCOUNTER15_LO_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER15_HI                                                                          0x31df
#define mmSQ_PERFCOUNTER15_HI_BASE_IDX                                                                 1
#define mmSX_PERFCOUNTER0_LO                                                                           0x3240
#define mmSX_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER0_HI                                                                           0x3241
#define mmSX_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER1_LO                                                                           0x3242
#define mmSX_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER1_HI                                                                           0x3243
#define mmSX_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER2_LO                                                                           0x3244
#define mmSX_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER2_HI                                                                           0x3245
#define mmSX_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER3_LO                                                                           0x3246
#define mmSX_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmSX_PERFCOUNTER3_HI                                                                           0x3247
#define mmSX_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmGDS_PERFCOUNTER0_LO                                                                          0x3280
#define mmGDS_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER0_HI                                                                          0x3281
#define mmGDS_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER1_LO                                                                          0x3282
#define mmGDS_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER1_HI                                                                          0x3283
#define mmGDS_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER2_LO                                                                          0x3284
#define mmGDS_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER2_HI                                                                          0x3285
#define mmGDS_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER3_LO                                                                          0x3286
#define mmGDS_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmGDS_PERFCOUNTER3_HI                                                                          0x3287
#define mmGDS_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmTA_PERFCOUNTER0_LO                                                                           0x32c0
#define mmTA_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmTA_PERFCOUNTER0_HI                                                                           0x32c1
#define mmTA_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmTA_PERFCOUNTER1_LO                                                                           0x32c2
#define mmTA_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmTA_PERFCOUNTER1_HI                                                                           0x32c3
#define mmTA_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER0_LO                                                                           0x3300
#define mmTD_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER0_HI                                                                           0x3301
#define mmTD_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER1_LO                                                                           0x3302
#define mmTD_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmTD_PERFCOUNTER1_HI                                                                           0x3303
#define mmTD_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmTCP_PERFCOUNTER0_LO                                                                          0x3340
#define mmTCP_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER0_HI                                                                          0x3341
#define mmTCP_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER1_LO                                                                          0x3342
#define mmTCP_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER1_HI                                                                          0x3343
#define mmTCP_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER2_LO                                                                          0x3344
#define mmTCP_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER2_HI                                                                          0x3345
#define mmTCP_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER3_LO                                                                          0x3346
#define mmTCP_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmTCP_PERFCOUNTER3_HI                                                                          0x3347
#define mmTCP_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER0_LO                                                                          0x3380
#define mmTCC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER0_HI                                                                          0x3381
#define mmTCC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER1_LO                                                                          0x3382
#define mmTCC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER1_HI                                                                          0x3383
#define mmTCC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER2_LO                                                                          0x3384
#define mmTCC_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER2_HI                                                                          0x3385
#define mmTCC_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER3_LO                                                                          0x3386
#define mmTCC_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmTCC_PERFCOUNTER3_HI                                                                          0x3387
#define mmTCC_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER0_LO                                                                          0x3390
#define mmTCA_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER0_HI                                                                          0x3391
#define mmTCA_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER1_LO                                                                          0x3392
#define mmTCA_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER1_HI                                                                          0x3393
#define mmTCA_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER2_LO                                                                          0x3394
#define mmTCA_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER2_HI                                                                          0x3395
#define mmTCA_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER3_LO                                                                          0x3396
#define mmTCA_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmTCA_PERFCOUNTER3_HI                                                                          0x3397
#define mmTCA_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define mmCB_PERFCOUNTER0_LO                                                                           0x3406
#define mmCB_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER0_HI                                                                           0x3407
#define mmCB_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER1_LO                                                                           0x3408
#define mmCB_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER1_HI                                                                           0x3409
#define mmCB_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER2_LO                                                                           0x340a
#define mmCB_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER2_HI                                                                           0x340b
#define mmCB_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER3_LO                                                                           0x340c
#define mmCB_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmCB_PERFCOUNTER3_HI                                                                           0x340d
#define mmCB_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER0_LO                                                                           0x3440
#define mmDB_PERFCOUNTER0_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER0_HI                                                                           0x3441
#define mmDB_PERFCOUNTER0_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER1_LO                                                                           0x3442
#define mmDB_PERFCOUNTER1_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER1_HI                                                                           0x3443
#define mmDB_PERFCOUNTER1_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER2_LO                                                                           0x3444
#define mmDB_PERFCOUNTER2_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER2_HI                                                                           0x3445
#define mmDB_PERFCOUNTER2_HI_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER3_LO                                                                           0x3446
#define mmDB_PERFCOUNTER3_LO_BASE_IDX                                                                  1
#define mmDB_PERFCOUNTER3_HI                                                                           0x3447
#define mmDB_PERFCOUNTER3_HI_BASE_IDX                                                                  1
#define mmRLC_PERFCOUNTER0_LO                                                                          0x3480
#define mmRLC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmRLC_PERFCOUNTER0_HI                                                                          0x3481
#define mmRLC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmRLC_PERFCOUNTER1_LO                                                                          0x3482
#define mmRLC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmRLC_PERFCOUNTER1_HI                                                                          0x3483
#define mmRLC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER0_LO                                                                          0x34c0
#define mmRMI_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER0_HI                                                                          0x34c1
#define mmRMI_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER1_LO                                                                          0x34c2
#define mmRMI_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER1_HI                                                                          0x34c3
#define mmRMI_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER2_LO                                                                          0x34c4
#define mmRMI_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER2_HI                                                                          0x34c5
#define mmRMI_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER3_LO                                                                          0x34c6
#define mmRMI_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define mmRMI_PERFCOUNTER3_HI                                                                          0x34c7
#define mmRMI_PERFCOUNTER3_HI_BASE_IDX                                                                 1


// addressBlock: gc_utcl2_atcl2pfcntrdec
// base address: 0x35400
#define mmATC_L2_PERFCOUNTER_LO                                                                        0x3500
#define mmATC_L2_PERFCOUNTER_LO_BASE_IDX                                                               1
#define mmATC_L2_PERFCOUNTER_HI                                                                        0x3501
#define mmATC_L2_PERFCOUNTER_HI_BASE_IDX                                                               1


// addressBlock: gc_utcl2_vml2prdec
// base address: 0x35420
#define mmMC_VM_L2_PERFCOUNTER_LO                                                                      0x3508
#define mmMC_VM_L2_PERFCOUNTER_LO_BASE_IDX                                                             1
#define mmMC_VM_L2_PERFCOUNTER_HI                                                                      0x3509
#define mmMC_VM_L2_PERFCOUNTER_HI_BASE_IDX                                                             1


// addressBlock: gc_perfsdec
// base address: 0x36000
#define mmCPG_PERFCOUNTER1_SELECT                                                                      0x3800
#define mmCPG_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCPG_PERFCOUNTER0_SELECT1                                                                     0x3801
#define mmCPG_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCPG_PERFCOUNTER0_SELECT                                                                      0x3802
#define mmCPG_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCPC_PERFCOUNTER1_SELECT                                                                      0x3803
#define mmCPC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCPC_PERFCOUNTER0_SELECT1                                                                     0x3804
#define mmCPC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCPF_PERFCOUNTER1_SELECT                                                                      0x3805
#define mmCPF_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmCPF_PERFCOUNTER0_SELECT1                                                                     0x3806
#define mmCPF_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmCPF_PERFCOUNTER0_SELECT                                                                      0x3807
#define mmCPF_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCP_PERFMON_CNTL                                                                              0x3808
#define mmCP_PERFMON_CNTL_BASE_IDX                                                                     1
#define mmCPC_PERFCOUNTER0_SELECT                                                                      0x3809
#define mmCPC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmCPF_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380a
#define mmCPF_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define mmCPG_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380b
#define mmCPG_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define mmCPF_LATENCY_STATS_SELECT                                                                     0x380c
#define mmCPF_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define mmCPG_LATENCY_STATS_SELECT                                                                     0x380d
#define mmCPG_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define mmCPC_LATENCY_STATS_SELECT                                                                     0x380e
#define mmCPC_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define mmCP_DRAW_OBJECT                                                                               0x3810
#define mmCP_DRAW_OBJECT_BASE_IDX                                                                      1
#define mmCP_DRAW_OBJECT_COUNTER                                                                       0x3811
#define mmCP_DRAW_OBJECT_COUNTER_BASE_IDX                                                              1
#define mmCP_DRAW_WINDOW_MASK_HI                                                                       0x3812
#define mmCP_DRAW_WINDOW_MASK_HI_BASE_IDX                                                              1
#define mmCP_DRAW_WINDOW_HI                                                                            0x3813
#define mmCP_DRAW_WINDOW_HI_BASE_IDX                                                                   1
#define mmCP_DRAW_WINDOW_LO                                                                            0x3814
#define mmCP_DRAW_WINDOW_LO_BASE_IDX                                                                   1
#define mmCP_DRAW_WINDOW_CNTL                                                                          0x3815
#define mmCP_DRAW_WINDOW_CNTL_BASE_IDX                                                                 1
#define mmGRBM_PERFCOUNTER0_SELECT                                                                     0x3840
#define mmGRBM_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define mmGRBM_PERFCOUNTER1_SELECT                                                                     0x3841
#define mmGRBM_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define mmGRBM_SE0_PERFCOUNTER_SELECT                                                                  0x3842
#define mmGRBM_SE0_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmGRBM_SE1_PERFCOUNTER_SELECT                                                                  0x3843
#define mmGRBM_SE1_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmGRBM_SE2_PERFCOUNTER_SELECT                                                                  0x3844
#define mmGRBM_SE2_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmGRBM_SE3_PERFCOUNTER_SELECT                                                                  0x3845
#define mmGRBM_SE3_PERFCOUNTER_SELECT_BASE_IDX                                                         1
#define mmWD_PERFCOUNTER0_SELECT                                                                       0x3880
#define mmWD_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmWD_PERFCOUNTER1_SELECT                                                                       0x3881
#define mmWD_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmWD_PERFCOUNTER2_SELECT                                                                       0x3882
#define mmWD_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmWD_PERFCOUNTER3_SELECT                                                                       0x3883
#define mmWD_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmIA_PERFCOUNTER0_SELECT                                                                       0x3884
#define mmIA_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmIA_PERFCOUNTER1_SELECT                                                                       0x3885
#define mmIA_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmIA_PERFCOUNTER2_SELECT                                                                       0x3886
#define mmIA_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmIA_PERFCOUNTER3_SELECT                                                                       0x3887
#define mmIA_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmIA_PERFCOUNTER0_SELECT1                                                                      0x3888
#define mmIA_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmVGT_PERFCOUNTER0_SELECT                                                                      0x388c
#define mmVGT_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmVGT_PERFCOUNTER1_SELECT                                                                      0x388d
#define mmVGT_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmVGT_PERFCOUNTER2_SELECT                                                                      0x388e
#define mmVGT_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmVGT_PERFCOUNTER3_SELECT                                                                      0x388f
#define mmVGT_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmVGT_PERFCOUNTER0_SELECT1                                                                     0x3890
#define mmVGT_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmVGT_PERFCOUNTER1_SELECT1                                                                     0x3891
#define mmVGT_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmVGT_PERFCOUNTER_SEID_MASK                                                                    0x3894
#define mmVGT_PERFCOUNTER_SEID_MASK_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER0_SELECT                                                                    0x3900
#define mmPA_SU_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER0_SELECT1                                                                   0x3901
#define mmPA_SU_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmPA_SU_PERFCOUNTER1_SELECT                                                                    0x3902
#define mmPA_SU_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER1_SELECT1                                                                   0x3903
#define mmPA_SU_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1
#define mmPA_SU_PERFCOUNTER2_SELECT                                                                    0x3904
#define mmPA_SU_PERFCOUNTER2_SELECT_BASE_IDX                                                           1
#define mmPA_SU_PERFCOUNTER3_SELECT                                                                    0x3905
#define mmPA_SU_PERFCOUNTER3_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER0_SELECT                                                                    0x3940
#define mmPA_SC_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER0_SELECT1                                                                   0x3941
#define mmPA_SC_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define mmPA_SC_PERFCOUNTER1_SELECT                                                                    0x3942
#define mmPA_SC_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER2_SELECT                                                                    0x3943
#define mmPA_SC_PERFCOUNTER2_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER3_SELECT                                                                    0x3944
#define mmPA_SC_PERFCOUNTER3_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER4_SELECT                                                                    0x3945
#define mmPA_SC_PERFCOUNTER4_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER5_SELECT                                                                    0x3946
#define mmPA_SC_PERFCOUNTER5_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER6_SELECT                                                                    0x3947
#define mmPA_SC_PERFCOUNTER6_SELECT_BASE_IDX                                                           1
#define mmPA_SC_PERFCOUNTER7_SELECT                                                                    0x3948
#define mmPA_SC_PERFCOUNTER7_SELECT_BASE_IDX                                                           1
#define mmSPI_PERFCOUNTER0_SELECT                                                                      0x3980
#define mmSPI_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER1_SELECT                                                                      0x3981
#define mmSPI_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER2_SELECT                                                                      0x3982
#define mmSPI_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER3_SELECT                                                                      0x3983
#define mmSPI_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER0_SELECT1                                                                     0x3984
#define mmSPI_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER1_SELECT1                                                                     0x3985
#define mmSPI_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER2_SELECT1                                                                     0x3986
#define mmSPI_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER3_SELECT1                                                                     0x3987
#define mmSPI_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1
#define mmSPI_PERFCOUNTER4_SELECT                                                                      0x3988
#define mmSPI_PERFCOUNTER4_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER5_SELECT                                                                      0x3989
#define mmSPI_PERFCOUNTER5_SELECT_BASE_IDX                                                             1
#define mmSPI_PERFCOUNTER_BINS                                                                         0x398a
#define mmSPI_PERFCOUNTER_BINS_BASE_IDX                                                                1
#define mmSQ_PERFCOUNTER0_SELECT                                                                       0x39c0
#define mmSQ_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER1_SELECT                                                                       0x39c1
#define mmSQ_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER2_SELECT                                                                       0x39c2
#define mmSQ_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER3_SELECT                                                                       0x39c3
#define mmSQ_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER4_SELECT                                                                       0x39c4
#define mmSQ_PERFCOUNTER4_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER5_SELECT                                                                       0x39c5
#define mmSQ_PERFCOUNTER5_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER6_SELECT                                                                       0x39c6
#define mmSQ_PERFCOUNTER6_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER7_SELECT                                                                       0x39c7
#define mmSQ_PERFCOUNTER7_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER8_SELECT                                                                       0x39c8
#define mmSQ_PERFCOUNTER8_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER9_SELECT                                                                       0x39c9
#define mmSQ_PERFCOUNTER9_SELECT_BASE_IDX                                                              1
#define mmSQ_PERFCOUNTER10_SELECT                                                                      0x39ca
#define mmSQ_PERFCOUNTER10_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER11_SELECT                                                                      0x39cb
#define mmSQ_PERFCOUNTER11_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER12_SELECT                                                                      0x39cc
#define mmSQ_PERFCOUNTER12_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER13_SELECT                                                                      0x39cd
#define mmSQ_PERFCOUNTER13_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER14_SELECT                                                                      0x39ce
#define mmSQ_PERFCOUNTER14_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER15_SELECT                                                                      0x39cf
#define mmSQ_PERFCOUNTER15_SELECT_BASE_IDX                                                             1
#define mmSQ_PERFCOUNTER_CTRL                                                                          0x39e0
#define mmSQ_PERFCOUNTER_CTRL_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER_MASK                                                                          0x39e1
#define mmSQ_PERFCOUNTER_MASK_BASE_IDX                                                                 1
#define mmSQ_PERFCOUNTER_CTRL2                                                                         0x39e2
#define mmSQ_PERFCOUNTER_CTRL2_BASE_IDX                                                                1
#define mmSX_PERFCOUNTER0_SELECT                                                                       0x3a40
#define mmSX_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER1_SELECT                                                                       0x3a41
#define mmSX_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER2_SELECT                                                                       0x3a42
#define mmSX_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER3_SELECT                                                                       0x3a43
#define mmSX_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmSX_PERFCOUNTER0_SELECT1                                                                      0x3a44
#define mmSX_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmSX_PERFCOUNTER1_SELECT1                                                                      0x3a45
#define mmSX_PERFCOUNTER1_SELECT1_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER0_SELECT                                                                      0x3a80
#define mmGDS_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER1_SELECT                                                                      0x3a81
#define mmGDS_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER2_SELECT                                                                      0x3a82
#define mmGDS_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER3_SELECT                                                                      0x3a83
#define mmGDS_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmGDS_PERFCOUNTER0_SELECT1                                                                     0x3a84
#define mmGDS_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmTA_PERFCOUNTER0_SELECT                                                                       0x3ac0
#define mmTA_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmTA_PERFCOUNTER0_SELECT1                                                                      0x3ac1
#define mmTA_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmTA_PERFCOUNTER1_SELECT                                                                       0x3ac2
#define mmTA_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmTD_PERFCOUNTER0_SELECT                                                                       0x3b00
#define mmTD_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmTD_PERFCOUNTER0_SELECT1                                                                      0x3b01
#define mmTD_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmTD_PERFCOUNTER1_SELECT                                                                       0x3b02
#define mmTD_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmTCP_PERFCOUNTER0_SELECT                                                                      0x3b40
#define mmTCP_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmTCP_PERFCOUNTER0_SELECT1                                                                     0x3b41
#define mmTCP_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmTCP_PERFCOUNTER1_SELECT                                                                      0x3b42
#define mmTCP_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmTCP_PERFCOUNTER1_SELECT1                                                                     0x3b43
#define mmTCP_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmTCP_PERFCOUNTER2_SELECT                                                                      0x3b44
#define mmTCP_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmTCP_PERFCOUNTER3_SELECT                                                                      0x3b45
#define mmTCP_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmTCC_PERFCOUNTER0_SELECT                                                                      0x3b80
#define mmTCC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmTCC_PERFCOUNTER0_SELECT1                                                                     0x3b81
#define mmTCC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmTCC_PERFCOUNTER1_SELECT                                                                      0x3b82
#define mmTCC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmTCC_PERFCOUNTER1_SELECT1                                                                     0x3b83
#define mmTCC_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmTCC_PERFCOUNTER2_SELECT                                                                      0x3b84
#define mmTCC_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmTCC_PERFCOUNTER3_SELECT                                                                      0x3b85
#define mmTCC_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmTCA_PERFCOUNTER0_SELECT                                                                      0x3b90
#define mmTCA_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmTCA_PERFCOUNTER0_SELECT1                                                                     0x3b91
#define mmTCA_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmTCA_PERFCOUNTER1_SELECT                                                                      0x3b92
#define mmTCA_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmTCA_PERFCOUNTER1_SELECT1                                                                     0x3b93
#define mmTCA_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define mmTCA_PERFCOUNTER2_SELECT                                                                      0x3b94
#define mmTCA_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmTCA_PERFCOUNTER3_SELECT                                                                      0x3b95
#define mmTCA_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmCB_PERFCOUNTER_FILTER                                                                        0x3c00
#define mmCB_PERFCOUNTER_FILTER_BASE_IDX                                                               1
#define mmCB_PERFCOUNTER0_SELECT                                                                       0x3c01
#define mmCB_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmCB_PERFCOUNTER0_SELECT1                                                                      0x3c02
#define mmCB_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmCB_PERFCOUNTER1_SELECT                                                                       0x3c03
#define mmCB_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmCB_PERFCOUNTER2_SELECT                                                                       0x3c04
#define mmCB_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmCB_PERFCOUNTER3_SELECT                                                                       0x3c05
#define mmCB_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER0_SELECT                                                                       0x3c40
#define mmDB_PERFCOUNTER0_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER0_SELECT1                                                                      0x3c41
#define mmDB_PERFCOUNTER0_SELECT1_BASE_IDX                                                             1
#define mmDB_PERFCOUNTER1_SELECT                                                                       0x3c42
#define mmDB_PERFCOUNTER1_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER1_SELECT1                                                                      0x3c43
#define mmDB_PERFCOUNTER1_SELECT1_BASE_IDX                                                             1
#define mmDB_PERFCOUNTER2_SELECT                                                                       0x3c44
#define mmDB_PERFCOUNTER2_SELECT_BASE_IDX                                                              1
#define mmDB_PERFCOUNTER3_SELECT                                                                       0x3c46
#define mmDB_PERFCOUNTER3_SELECT_BASE_IDX                                                              1
#define mmRLC_SPM_PERFMON_CNTL                                                                         0x3c80
#define mmRLC_SPM_PERFMON_CNTL_BASE_IDX                                                                1
#define mmRLC_SPM_PERFMON_RING_BASE_LO                                                                 0x3c81
#define mmRLC_SPM_PERFMON_RING_BASE_LO_BASE_IDX                                                        1
#define mmRLC_SPM_PERFMON_RING_BASE_HI                                                                 0x3c82
#define mmRLC_SPM_PERFMON_RING_BASE_HI_BASE_IDX                                                        1
#define mmRLC_SPM_PERFMON_RING_SIZE                                                                    0x3c83
#define mmRLC_SPM_PERFMON_RING_SIZE_BASE_IDX                                                           1
#define mmRLC_SPM_PERFMON_SEGMENT_SIZE                                                                 0x3c84
#define mmRLC_SPM_PERFMON_SEGMENT_SIZE_BASE_IDX                                                        1
#define mmRLC_SPM_SE_MUXSEL_ADDR                                                                       0x3c85
#define mmRLC_SPM_SE_MUXSEL_ADDR_BASE_IDX                                                              1
#define mmRLC_SPM_SE_MUXSEL_DATA                                                                       0x3c86
#define mmRLC_SPM_SE_MUXSEL_DATA_BASE_IDX                                                              1
#define mmRLC_SPM_CPG_PERFMON_SAMPLE_DELAY                                                             0x3c87
#define mmRLC_SPM_CPG_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_CPC_PERFMON_SAMPLE_DELAY                                                             0x3c88
#define mmRLC_SPM_CPC_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_CPF_PERFMON_SAMPLE_DELAY                                                             0x3c89
#define mmRLC_SPM_CPF_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_CB_PERFMON_SAMPLE_DELAY                                                              0x3c8a
#define mmRLC_SPM_CB_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_DB_PERFMON_SAMPLE_DELAY                                                              0x3c8b
#define mmRLC_SPM_DB_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_PA_PERFMON_SAMPLE_DELAY                                                              0x3c8c
#define mmRLC_SPM_PA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_GDS_PERFMON_SAMPLE_DELAY                                                             0x3c8d
#define mmRLC_SPM_GDS_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_IA_PERFMON_SAMPLE_DELAY                                                              0x3c8e
#define mmRLC_SPM_IA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_SC_PERFMON_SAMPLE_DELAY                                                              0x3c90
#define mmRLC_SPM_SC_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_TCC_PERFMON_SAMPLE_DELAY                                                             0x3c91
#define mmRLC_SPM_TCC_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_TCA_PERFMON_SAMPLE_DELAY                                                             0x3c92
#define mmRLC_SPM_TCA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_TCP_PERFMON_SAMPLE_DELAY                                                             0x3c93
#define mmRLC_SPM_TCP_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_TA_PERFMON_SAMPLE_DELAY                                                              0x3c94
#define mmRLC_SPM_TA_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_TD_PERFMON_SAMPLE_DELAY                                                              0x3c95
#define mmRLC_SPM_TD_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_VGT_PERFMON_SAMPLE_DELAY                                                             0x3c96
#define mmRLC_SPM_VGT_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_SPI_PERFMON_SAMPLE_DELAY                                                             0x3c97
#define mmRLC_SPM_SPI_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_SQG_PERFMON_SAMPLE_DELAY                                                             0x3c98
#define mmRLC_SPM_SQG_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_SPM_SX_PERFMON_SAMPLE_DELAY                                                              0x3c9a
#define mmRLC_SPM_SX_PERFMON_SAMPLE_DELAY_BASE_IDX                                                     1
#define mmRLC_SPM_GLOBAL_MUXSEL_ADDR                                                                   0x3c9b
#define mmRLC_SPM_GLOBAL_MUXSEL_ADDR_BASE_IDX                                                          1
#define mmRLC_SPM_GLOBAL_MUXSEL_DATA                                                                   0x3c9c
#define mmRLC_SPM_GLOBAL_MUXSEL_DATA_BASE_IDX                                                          1
#define mmRLC_SPM_RING_RDPTR                                                                           0x3c9d
#define mmRLC_SPM_RING_RDPTR_BASE_IDX                                                                  1
#define mmRLC_SPM_SEGMENT_THRESHOLD                                                                    0x3c9e
#define mmRLC_SPM_SEGMENT_THRESHOLD_BASE_IDX                                                           1
#define mmRLC_SPM_RMI_PERFMON_SAMPLE_DELAY                                                             0x3ca3
#define mmRLC_SPM_RMI_PERFMON_SAMPLE_DELAY_BASE_IDX                                                    1
#define mmRLC_PERFMON_CLK_CNTL                                                                         0x3cbf
#define mmRLC_PERFMON_CLK_CNTL_BASE_IDX                                                                1
#define mmRLC_PERFMON_CNTL                                                                             0x3cc0
#define mmRLC_PERFMON_CNTL_BASE_IDX                                                                    1
#define mmRLC_PERFCOUNTER0_SELECT                                                                      0x3cc1
#define mmRLC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmRLC_PERFCOUNTER1_SELECT                                                                      0x3cc2
#define mmRLC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmRLC_GPU_IOV_PERF_CNT_CNTL                                                                    0x3cc3
#define mmRLC_GPU_IOV_PERF_CNT_CNTL_BASE_IDX                                                           1
#define mmRLC_GPU_IOV_PERF_CNT_WR_ADDR                                                                 0x3cc4
#define mmRLC_GPU_IOV_PERF_CNT_WR_ADDR_BASE_IDX                                                        1
#define mmRLC_GPU_IOV_PERF_CNT_WR_DATA                                                                 0x3cc5
#define mmRLC_GPU_IOV_PERF_CNT_WR_DATA_BASE_IDX                                                        1
#define mmRLC_GPU_IOV_PERF_CNT_RD_ADDR                                                                 0x3cc6
#define mmRLC_GPU_IOV_PERF_CNT_RD_ADDR_BASE_IDX                                                        1
#define mmRLC_GPU_IOV_PERF_CNT_RD_DATA                                                                 0x3cc7
#define mmRLC_GPU_IOV_PERF_CNT_RD_DATA_BASE_IDX                                                        1
#define mmRMI_PERFCOUNTER0_SELECT                                                                      0x3d00
#define mmRMI_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define mmRMI_PERFCOUNTER0_SELECT1                                                                     0x3d01
#define mmRMI_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define mmRMI_PERFCOUNTER1_SELECT                                                                      0x3d02
#define mmRMI_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define mmRMI_PERFCOUNTER2_SELECT                                                                      0x3d03
#define mmRMI_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define mmRMI_PERFCOUNTER2_SELECT1                                                                     0x3d04
#define mmRMI_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define mmRMI_PERFCOUNTER3_SELECT                                                                      0x3d05
#define mmRMI_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define mmRMI_PERF_COUNTER_CNTL                                                                        0x3d06
#define mmRMI_PERF_COUNTER_CNTL_BASE_IDX                                                               1


// addressBlock: gc_utcl2_atcl2pfcntldec
// base address: 0x37500
#define mmATC_L2_PERFCOUNTER0_CFG                                                                      0x3d40
#define mmATC_L2_PERFCOUNTER0_CFG_BASE_IDX                                                             1
#define mmATC_L2_PERFCOUNTER1_CFG                                                                      0x3d41
#define mmATC_L2_PERFCOUNTER1_CFG_BASE_IDX                                                             1
#define mmATC_L2_PERFCOUNTER_RSLT_CNTL                                                                 0x3d42
#define mmATC_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                        1


// addressBlock: gc_utcl2_vml2pldec
// base address: 0x37530
#define mmMC_VM_L2_PERFCOUNTER0_CFG                                                                    0x3d4c
#define mmMC_VM_L2_PERFCOUNTER0_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER1_CFG                                                                    0x3d4d
#define mmMC_VM_L2_PERFCOUNTER1_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER2_CFG                                                                    0x3d4e
#define mmMC_VM_L2_PERFCOUNTER2_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER3_CFG                                                                    0x3d4f
#define mmMC_VM_L2_PERFCOUNTER3_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER4_CFG                                                                    0x3d50
#define mmMC_VM_L2_PERFCOUNTER4_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER5_CFG                                                                    0x3d51
#define mmMC_VM_L2_PERFCOUNTER5_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER6_CFG                                                                    0x3d52
#define mmMC_VM_L2_PERFCOUNTER6_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER7_CFG                                                                    0x3d53
#define mmMC_VM_L2_PERFCOUNTER7_CFG_BASE_IDX                                                           1
#define mmMC_VM_L2_PERFCOUNTER_RSLT_CNTL                                                               0x3d54
#define mmMC_VM_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                      1


// addressBlock: gc_rlcpdec
// base address: 0x3b000
#define mmRLC_CNTL                                                                                     0x4c00
#define mmRLC_CNTL_BASE_IDX                                                                            1
#define mmRLC_STAT                                                                                     0x4c04
#define mmRLC_STAT_BASE_IDX                                                                            1
#define mmRLC_SAFE_MODE                                                                                0x4c05
#define mmRLC_SAFE_MODE_BASE_IDX                                                                       1
#define mmRLC_MEM_SLP_CNTL                                                                             0x4c06
#define mmRLC_MEM_SLP_CNTL_BASE_IDX                                                                    1
#define mmSMU_RLC_RESPONSE                                                                             0x4c07
#define mmSMU_RLC_RESPONSE_BASE_IDX                                                                    1
#define mmRLC_RLCV_SAFE_MODE                                                                           0x4c08
#define mmRLC_RLCV_SAFE_MODE_BASE_IDX                                                                  1
#define mmRLC_SMU_SAFE_MODE                                                                            0x4c09
#define mmRLC_SMU_SAFE_MODE_BASE_IDX                                                                   1
#define mmRLC_RLCV_COMMAND                                                                             0x4c0a
#define mmRLC_RLCV_COMMAND_BASE_IDX                                                                    1
#define mmRLC_REFCLOCK_TIMESTAMP_LSB                                                                   0x4c0c
#define mmRLC_REFCLOCK_TIMESTAMP_LSB_BASE_IDX                                                          1
#define mmRLC_REFCLOCK_TIMESTAMP_MSB                                                                   0x4c0d
#define mmRLC_REFCLOCK_TIMESTAMP_MSB_BASE_IDX                                                          1
#define mmRLC_GPM_TIMER_INT_0                                                                          0x4c0e
#define mmRLC_GPM_TIMER_INT_0_BASE_IDX                                                                 1
#define mmRLC_GPM_TIMER_INT_1                                                                          0x4c0f
#define mmRLC_GPM_TIMER_INT_1_BASE_IDX                                                                 1
#define mmRLC_GPM_TIMER_INT_2                                                                          0x4c10
#define mmRLC_GPM_TIMER_INT_2_BASE_IDX                                                                 1
#define mmRLC_GPM_TIMER_CTRL                                                                           0x4c11
#define mmRLC_GPM_TIMER_CTRL_BASE_IDX                                                                  1
#define mmRLC_LB_CNTR_MAX                                                                              0x4c12
#define mmRLC_LB_CNTR_MAX_BASE_IDX                                                                     1
#define mmRLC_GPM_TIMER_STAT                                                                           0x4c13
#define mmRLC_GPM_TIMER_STAT_BASE_IDX                                                                  1
#define mmRLC_GPM_TIMER_INT_3                                                                          0x4c15
#define mmRLC_GPM_TIMER_INT_3_BASE_IDX                                                                 1
#define mmRLC_SERDES_WR_NONCU_MASTER_MASK_1                                                            0x4c16
#define mmRLC_SERDES_WR_NONCU_MASTER_MASK_1_BASE_IDX                                                   1
#define mmRLC_SERDES_NONCU_MASTER_BUSY_1                                                               0x4c17
#define mmRLC_SERDES_NONCU_MASTER_BUSY_1_BASE_IDX                                                      1
#define mmRLC_INT_STAT                                                                                 0x4c18
#define mmRLC_INT_STAT_BASE_IDX                                                                        1
#define mmRLC_LB_CNTL                                                                                  0x4c19
#define mmRLC_LB_CNTL_BASE_IDX                                                                         1
#define mmRLC_MGCG_CTRL                                                                                0x4c1a
#define mmRLC_MGCG_CTRL_BASE_IDX                                                                       1
#define mmRLC_LB_CNTR_INIT                                                                             0x4c1b
#define mmRLC_LB_CNTR_INIT_BASE_IDX                                                                    1
#define mmRLC_LOAD_BALANCE_CNTR                                                                        0x4c1c
#define mmRLC_LOAD_BALANCE_CNTR_BASE_IDX                                                               1
#define mmRLC_JUMP_TABLE_RESTORE                                                                       0x4c1e
#define mmRLC_JUMP_TABLE_RESTORE_BASE_IDX                                                              1
#define mmRLC_PG_DELAY_2                                                                               0x4c1f
#define mmRLC_PG_DELAY_2_BASE_IDX                                                                      1
#define mmRLC_GPU_CLOCK_COUNT_LSB                                                                      0x4c24
#define mmRLC_GPU_CLOCK_COUNT_LSB_BASE_IDX                                                             1
#define mmRLC_GPU_CLOCK_COUNT_MSB                                                                      0x4c25
#define mmRLC_GPU_CLOCK_COUNT_MSB_BASE_IDX                                                             1
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT                                                                  0x4c26
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT_BASE_IDX                                                         1
#define mmRLC_UCODE_CNTL                                                                               0x4c27
#define mmRLC_UCODE_CNTL_BASE_IDX                                                                      1
#define mmRLC_GPM_THREAD_RESET                                                                         0x4c28
#define mmRLC_GPM_THREAD_RESET_BASE_IDX                                                                1
#define mmRLC_GPM_CP_DMA_COMPLETE_T0                                                                   0x4c29
#define mmRLC_GPM_CP_DMA_COMPLETE_T0_BASE_IDX                                                          1
#define mmRLC_GPM_CP_DMA_COMPLETE_T1                                                                   0x4c2a
#define mmRLC_GPM_CP_DMA_COMPLETE_T1_BASE_IDX                                                          1
#define mmRLC_FIREWALL_VIOLATION                                                                       0x4c2b
#define mmRLC_FIREWALL_VIOLATION_BASE_IDX                                                              1
#define mmRLC_GPM_STAT                                                                                 0x4c40
#define mmRLC_GPM_STAT_BASE_IDX                                                                        1
#define mmRLC_GPU_CLOCK_32_RES_SEL                                                                     0x4c41
#define mmRLC_GPU_CLOCK_32_RES_SEL_BASE_IDX                                                            1
#define mmRLC_GPU_CLOCK_32                                                                             0x4c42
#define mmRLC_GPU_CLOCK_32_BASE_IDX                                                                    1
#define mmRLC_PG_CNTL                                                                                  0x4c43
#define mmRLC_PG_CNTL_BASE_IDX                                                                         1
#define mmRLC_GPM_THREAD_PRIORITY                                                                      0x4c44
#define mmRLC_GPM_THREAD_PRIORITY_BASE_IDX                                                             1
#define mmRLC_GPM_THREAD_ENABLE                                                                        0x4c45
#define mmRLC_GPM_THREAD_ENABLE_BASE_IDX                                                               1
#define mmRLC_CGTT_MGCG_OVERRIDE                                                                       0x4c48
#define mmRLC_CGTT_MGCG_OVERRIDE_BASE_IDX                                                              1
#define mmRLC_CGCG_CGLS_CTRL                                                                           0x4c49
#define mmRLC_CGCG_CGLS_CTRL_BASE_IDX                                                                  1
#define mmRLC_CGCG_RAMP_CTRL                                                                           0x4c4a
#define mmRLC_CGCG_RAMP_CTRL_BASE_IDX                                                                  1
#define mmRLC_DYN_PG_STATUS                                                                            0x4c4b
#define mmRLC_DYN_PG_STATUS_BASE_IDX                                                                   1
#define mmRLC_DYN_PG_REQUEST                                                                           0x4c4c
#define mmRLC_DYN_PG_REQUEST_BASE_IDX                                                                  1
#define mmRLC_PG_DELAY                                                                                 0x4c4d
#define mmRLC_PG_DELAY_BASE_IDX                                                                        1
#define mmRLC_CU_STATUS                                                                                0x4c4e
#define mmRLC_CU_STATUS_BASE_IDX                                                                       1
#define mmRLC_LB_INIT_CU_MASK                                                                          0x4c4f
#define mmRLC_LB_INIT_CU_MASK_BASE_IDX                                                                 1
#define mmRLC_LB_ALWAYS_ACTIVE_CU_MASK                                                                 0x4c50
#define mmRLC_LB_ALWAYS_ACTIVE_CU_MASK_BASE_IDX                                                        1
#define mmRLC_LB_PARAMS                                                                                0x4c51
#define mmRLC_LB_PARAMS_BASE_IDX                                                                       1
#define mmRLC_THREAD1_DELAY                                                                            0x4c52
#define mmRLC_THREAD1_DELAY_BASE_IDX                                                                   1
#define mmRLC_PG_ALWAYS_ON_CU_MASK                                                                     0x4c53
#define mmRLC_PG_ALWAYS_ON_CU_MASK_BASE_IDX                                                            1
#define mmRLC_MAX_PG_CU                                                                                0x4c54
#define mmRLC_MAX_PG_CU_BASE_IDX                                                                       1
#define mmRLC_AUTO_PG_CTRL                                                                             0x4c55
#define mmRLC_AUTO_PG_CTRL_BASE_IDX                                                                    1
#define mmRLC_SMU_GRBM_REG_SAVE_CTRL                                                                   0x4c56
#define mmRLC_SMU_GRBM_REG_SAVE_CTRL_BASE_IDX                                                          1
#define mmRLC_SERDES_RD_MASTER_INDEX                                                                   0x4c59
#define mmRLC_SERDES_RD_MASTER_INDEX_BASE_IDX                                                          1
#define mmRLC_SERDES_RD_DATA_0                                                                         0x4c5a
#define mmRLC_SERDES_RD_DATA_0_BASE_IDX                                                                1
#define mmRLC_SERDES_RD_DATA_1                                                                         0x4c5b
#define mmRLC_SERDES_RD_DATA_1_BASE_IDX                                                                1
#define mmRLC_SERDES_RD_DATA_2                                                                         0x4c5c
#define mmRLC_SERDES_RD_DATA_2_BASE_IDX                                                                1
#define mmRLC_SERDES_WR_CU_MASTER_MASK                                                                 0x4c5d
#define mmRLC_SERDES_WR_CU_MASTER_MASK_BASE_IDX                                                        1
#define mmRLC_SERDES_WR_NONCU_MASTER_MASK                                                              0x4c5e
#define mmRLC_SERDES_WR_NONCU_MASTER_MASK_BASE_IDX                                                     1
#define mmRLC_SERDES_WR_CTRL                                                                           0x4c5f
#define mmRLC_SERDES_WR_CTRL_BASE_IDX                                                                  1
#define mmRLC_SERDES_WR_DATA                                                                           0x4c60
#define mmRLC_SERDES_WR_DATA_BASE_IDX                                                                  1
#define mmRLC_SERDES_CU_MASTER_BUSY                                                                    0x4c61
#define mmRLC_SERDES_CU_MASTER_BUSY_BASE_IDX                                                           1
#define mmRLC_SERDES_NONCU_MASTER_BUSY                                                                 0x4c62
#define mmRLC_SERDES_NONCU_MASTER_BUSY_BASE_IDX                                                        1
#define mmRLC_GPM_GENERAL_0                                                                            0x4c63
#define mmRLC_GPM_GENERAL_0_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_1                                                                            0x4c64
#define mmRLC_GPM_GENERAL_1_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_2                                                                            0x4c65
#define mmRLC_GPM_GENERAL_2_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_3                                                                            0x4c66
#define mmRLC_GPM_GENERAL_3_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_4                                                                            0x4c67
#define mmRLC_GPM_GENERAL_4_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_5                                                                            0x4c68
#define mmRLC_GPM_GENERAL_5_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_6                                                                            0x4c69
#define mmRLC_GPM_GENERAL_6_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_7                                                                            0x4c6a
#define mmRLC_GPM_GENERAL_7_BASE_IDX                                                                   1
#define mmRLC_GPM_SCRATCH_ADDR                                                                         0x4c6c
#define mmRLC_GPM_SCRATCH_ADDR_BASE_IDX                                                                1
#define mmRLC_GPM_SCRATCH_DATA                                                                         0x4c6d
#define mmRLC_GPM_SCRATCH_DATA_BASE_IDX                                                                1
#define mmRLC_STATIC_PG_STATUS                                                                         0x4c6e
#define mmRLC_STATIC_PG_STATUS_BASE_IDX                                                                1
#define mmRLC_SPM_MC_CNTL                                                                              0x4c71
#define mmRLC_SPM_MC_CNTL_BASE_IDX                                                                     1
#define mmRLC_SPM_INT_CNTL                                                                             0x4c72
#define mmRLC_SPM_INT_CNTL_BASE_IDX                                                                    1
#define mmRLC_SPM_INT_STATUS                                                                           0x4c73
#define mmRLC_SPM_INT_STATUS_BASE_IDX                                                                  1
#define mmRLC_SMU_MESSAGE                                                                              0x4c76
#define mmRLC_SMU_MESSAGE_BASE_IDX                                                                     1
#define mmRLC_GPM_LOG_SIZE                                                                             0x4c77
#define mmRLC_GPM_LOG_SIZE_BASE_IDX                                                                    1
#define mmRLC_PG_DELAY_3                                                                               0x4c78
#define mmRLC_PG_DELAY_3_BASE_IDX                                                                      1
#define mmRLC_GPR_REG1                                                                                 0x4c79
#define mmRLC_GPR_REG1_BASE_IDX                                                                        1
#define mmRLC_GPR_REG2                                                                                 0x4c7a
#define mmRLC_GPR_REG2_BASE_IDX                                                                        1
#define mmRLC_GPM_LOG_CONT                                                                             0x4c7b
#define mmRLC_GPM_LOG_CONT_BASE_IDX                                                                    1
#define mmRLC_GPM_INT_DISABLE_TH0                                                                      0x4c7c
#define mmRLC_GPM_INT_DISABLE_TH0_BASE_IDX                                                             1
#define mmRLC_GPM_INT_DISABLE_TH1                                                                      0x4c7d
#define mmRLC_GPM_INT_DISABLE_TH1_BASE_IDX                                                             1
#define mmRLC_GPM_INT_FORCE_TH0                                                                        0x4c7e
#define mmRLC_GPM_INT_FORCE_TH0_BASE_IDX                                                               1
#define mmRLC_GPM_INT_FORCE_TH1                                                                        0x4c7f
#define mmRLC_GPM_INT_FORCE_TH1_BASE_IDX                                                               1
#define mmRLC_SRM_CNTL                                                                                 0x4c80
#define mmRLC_SRM_CNTL_BASE_IDX                                                                        1
#define mmRLC_SRM_ARAM_ADDR                                                                            0x4c83
#define mmRLC_SRM_ARAM_ADDR_BASE_IDX                                                                   1
#define mmRLC_SRM_ARAM_DATA                                                                            0x4c84
#define mmRLC_SRM_ARAM_DATA_BASE_IDX                                                                   1
#define mmRLC_SRM_DRAM_ADDR                                                                            0x4c85
#define mmRLC_SRM_DRAM_ADDR_BASE_IDX                                                                   1
#define mmRLC_SRM_DRAM_DATA                                                                            0x4c86
#define mmRLC_SRM_DRAM_DATA_BASE_IDX                                                                   1
#define mmRLC_SRM_GPM_COMMAND                                                                          0x4c87
#define mmRLC_SRM_GPM_COMMAND_BASE_IDX                                                                 1
#define mmRLC_SRM_GPM_COMMAND_STATUS                                                                   0x4c88
#define mmRLC_SRM_GPM_COMMAND_STATUS_BASE_IDX                                                          1
#define mmRLC_SRM_RLCV_COMMAND                                                                         0x4c89
#define mmRLC_SRM_RLCV_COMMAND_BASE_IDX                                                                1
#define mmRLC_SRM_RLCV_COMMAND_STATUS                                                                  0x4c8a
#define mmRLC_SRM_RLCV_COMMAND_STATUS_BASE_IDX                                                         1
#define mmRLC_SRM_INDEX_CNTL_ADDR_0                                                                    0x4c8b
#define mmRLC_SRM_INDEX_CNTL_ADDR_0_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_1                                                                    0x4c8c
#define mmRLC_SRM_INDEX_CNTL_ADDR_1_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_2                                                                    0x4c8d
#define mmRLC_SRM_INDEX_CNTL_ADDR_2_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_3                                                                    0x4c8e
#define mmRLC_SRM_INDEX_CNTL_ADDR_3_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_4                                                                    0x4c8f
#define mmRLC_SRM_INDEX_CNTL_ADDR_4_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_5                                                                    0x4c90
#define mmRLC_SRM_INDEX_CNTL_ADDR_5_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_6                                                                    0x4c91
#define mmRLC_SRM_INDEX_CNTL_ADDR_6_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_ADDR_7                                                                    0x4c92
#define mmRLC_SRM_INDEX_CNTL_ADDR_7_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_0                                                                    0x4c93
#define mmRLC_SRM_INDEX_CNTL_DATA_0_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_1                                                                    0x4c94
#define mmRLC_SRM_INDEX_CNTL_DATA_1_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_2                                                                    0x4c95
#define mmRLC_SRM_INDEX_CNTL_DATA_2_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_3                                                                    0x4c96
#define mmRLC_SRM_INDEX_CNTL_DATA_3_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_4                                                                    0x4c97
#define mmRLC_SRM_INDEX_CNTL_DATA_4_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_5                                                                    0x4c98
#define mmRLC_SRM_INDEX_CNTL_DATA_5_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_6                                                                    0x4c99
#define mmRLC_SRM_INDEX_CNTL_DATA_6_BASE_IDX                                                           1
#define mmRLC_SRM_INDEX_CNTL_DATA_7                                                                    0x4c9a
#define mmRLC_SRM_INDEX_CNTL_DATA_7_BASE_IDX                                                           1
#define mmRLC_SRM_STAT                                                                                 0x4c9b
#define mmRLC_SRM_STAT_BASE_IDX                                                                        1
#define mmRLC_SRM_GPM_ABORT                                                                            0x4c9c
#define mmRLC_SRM_GPM_ABORT_BASE_IDX                                                                   1
#define mmRLC_CSIB_ADDR_LO                                                                             0x4ca2
#define mmRLC_CSIB_ADDR_LO_BASE_IDX                                                                    1
#define mmRLC_CSIB_ADDR_HI                                                                             0x4ca3
#define mmRLC_CSIB_ADDR_HI_BASE_IDX                                                                    1
#define mmRLC_CSIB_LENGTH                                                                              0x4ca4
#define mmRLC_CSIB_LENGTH_BASE_IDX                                                                     1
#define mmRLC_SMU_COMMAND                                                                              0x4ca9
#define mmRLC_SMU_COMMAND_BASE_IDX                                                                     1
#define mmRLC_CP_SCHEDULERS                                                                            0x4caa
#define mmRLC_CP_SCHEDULERS_BASE_IDX                                                                   1
#define mmRLC_SMU_ARGUMENT_1                                                                           0x4cab
#define mmRLC_SMU_ARGUMENT_1_BASE_IDX                                                                  1
#define mmRLC_SMU_ARGUMENT_2                                                                           0x4cac
#define mmRLC_SMU_ARGUMENT_2_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_8                                                                            0x4cad
#define mmRLC_GPM_GENERAL_8_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_9                                                                            0x4cae
#define mmRLC_GPM_GENERAL_9_BASE_IDX                                                                   1
#define mmRLC_GPM_GENERAL_10                                                                           0x4caf
#define mmRLC_GPM_GENERAL_10_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_11                                                                           0x4cb0
#define mmRLC_GPM_GENERAL_11_BASE_IDX                                                                  1
#define mmRLC_GPM_GENERAL_12                                                                           0x4cb1
#define mmRLC_GPM_GENERAL_12_BASE_IDX                                                                  1
#define mmRLC_GPM_UTCL1_CNTL_0                                                                         0x4cb2
#define mmRLC_GPM_UTCL1_CNTL_0_BASE_IDX                                                                1
#define mmRLC_GPM_UTCL1_CNTL_1                                                                         0x4cb3
#define mmRLC_GPM_UTCL1_CNTL_1_BASE_IDX                                                                1
#define mmRLC_GPM_UTCL1_CNTL_2                                                                         0x4cb4
#define mmRLC_GPM_UTCL1_CNTL_2_BASE_IDX                                                                1
#define mmRLC_SPM_UTCL1_CNTL                                                                           0x4cb5
#define mmRLC_SPM_UTCL1_CNTL_BASE_IDX                                                                  1
#define mmRLC_UTCL1_STATUS_2                                                                           0x4cb6
#define mmRLC_UTCL1_STATUS_2_BASE_IDX                                                                  1
#define mmRLC_LB_THR_CONFIG_2                                                                          0x4cb8
#define mmRLC_LB_THR_CONFIG_2_BASE_IDX                                                                 1
#define mmRLC_LB_THR_CONFIG_3                                                                          0x4cb9
#define mmRLC_LB_THR_CONFIG_3_BASE_IDX                                                                 1
#define mmRLC_LB_THR_CONFIG_4                                                                          0x4cba
#define mmRLC_LB_THR_CONFIG_4_BASE_IDX                                                                 1
#define mmRLC_SPM_UTCL1_ERROR_1                                                                        0x4cbc
#define mmRLC_SPM_UTCL1_ERROR_1_BASE_IDX                                                               1
#define mmRLC_SPM_UTCL1_ERROR_2                                                                        0x4cbd
#define mmRLC_SPM_UTCL1_ERROR_2_BASE_IDX                                                               1
#define mmRLC_GPM_UTCL1_TH0_ERROR_1                                                                    0x4cbe
#define mmRLC_GPM_UTCL1_TH0_ERROR_1_BASE_IDX                                                           1
#define mmRLC_LB_THR_CONFIG_1                                                                          0x4cbf
#define mmRLC_LB_THR_CONFIG_1_BASE_IDX                                                                 1
#define mmRLC_GPM_UTCL1_TH0_ERROR_2                                                                    0x4cc0
#define mmRLC_GPM_UTCL1_TH0_ERROR_2_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH1_ERROR_1                                                                    0x4cc1
#define mmRLC_GPM_UTCL1_TH1_ERROR_1_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH1_ERROR_2                                                                    0x4cc2
#define mmRLC_GPM_UTCL1_TH1_ERROR_2_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH2_ERROR_1                                                                    0x4cc3
#define mmRLC_GPM_UTCL1_TH2_ERROR_1_BASE_IDX                                                           1
#define mmRLC_GPM_UTCL1_TH2_ERROR_2                                                                    0x4cc4
#define mmRLC_GPM_UTCL1_TH2_ERROR_2_BASE_IDX                                                           1
#define mmRLC_CGCG_CGLS_CTRL_3D                                                                        0x4cc5
#define mmRLC_CGCG_CGLS_CTRL_3D_BASE_IDX                                                               1
#define mmRLC_CGCG_RAMP_CTRL_3D                                                                        0x4cc6
#define mmRLC_CGCG_RAMP_CTRL_3D_BASE_IDX                                                               1
#define mmRLC_SEMAPHORE_0                                                                              0x4cc7
#define mmRLC_SEMAPHORE_0_BASE_IDX                                                                     1
#define mmRLC_SEMAPHORE_1                                                                              0x4cc8
#define mmRLC_SEMAPHORE_1_BASE_IDX                                                                     1
#define mmRLC_CP_EOF_INT                                                                               0x4cca
#define mmRLC_CP_EOF_INT_BASE_IDX                                                                      1
#define mmRLC_CP_EOF_INT_CNT                                                                           0x4ccb
#define mmRLC_CP_EOF_INT_CNT_BASE_IDX                                                                  1
#define mmRLC_SPARE_INT                                                                                0x4ccc
#define mmRLC_SPARE_INT_BASE_IDX                                                                       1
#define mmRLC_PREWALKER_UTCL1_CNTL                                                                     0x4ccd
#define mmRLC_PREWALKER_UTCL1_CNTL_BASE_IDX                                                            1
#define mmRLC_PREWALKER_UTCL1_TRIG                                                                     0x4cce
#define mmRLC_PREWALKER_UTCL1_TRIG_BASE_IDX                                                            1
#define mmRLC_PREWALKER_UTCL1_ADDR_LSB                                                                 0x4ccf
#define mmRLC_PREWALKER_UTCL1_ADDR_LSB_BASE_IDX                                                        1
#define mmRLC_PREWALKER_UTCL1_ADDR_MSB                                                                 0x4cd0
#define mmRLC_PREWALKER_UTCL1_ADDR_MSB_BASE_IDX                                                        1
#define mmRLC_PREWALKER_UTCL1_SIZE_LSB                                                                 0x4cd1
#define mmRLC_PREWALKER_UTCL1_SIZE_LSB_BASE_IDX                                                        1
#define mmRLC_PREWALKER_UTCL1_SIZE_MSB                                                                 0x4cd2
#define mmRLC_PREWALKER_UTCL1_SIZE_MSB_BASE_IDX                                                        1
#define mmRLC_DSM_TRIG                                                                                 0x4cd3
#define mmRLC_DSM_TRIG_BASE_IDX                                                                        1
#define mmRLC_UTCL1_STATUS                                                                             0x4cd4
#define mmRLC_UTCL1_STATUS_BASE_IDX                                                                    1
#define mmRLC_R2I_CNTL_0                                                                               0x4cd5
#define mmRLC_R2I_CNTL_0_BASE_IDX                                                                      1
#define mmRLC_R2I_CNTL_1                                                                               0x4cd6
#define mmRLC_R2I_CNTL_1_BASE_IDX                                                                      1
#define mmRLC_R2I_CNTL_2                                                                               0x4cd7
#define mmRLC_R2I_CNTL_2_BASE_IDX                                                                      1
#define mmRLC_R2I_CNTL_3                                                                               0x4cd8
#define mmRLC_R2I_CNTL_3_BASE_IDX                                                                      1
#define mmRLC_UTCL2_CNTL                                                                               0x4cd9
#define mmRLC_UTCL2_CNTL_BASE_IDX                                                                      1
#define mmRLC_LBPW_CU_STAT                                                                             0x4cda
#define mmRLC_LBPW_CU_STAT_BASE_IDX                                                                    1
#define mmRLC_DS_CNTL                                                                                  0x4cdb
#define mmRLC_DS_CNTL_BASE_IDX                                                                         1
#define mmRLC_RLCV_SPARE_INT                                                                           0x4f30
#define mmRLC_RLCV_SPARE_INT_BASE_IDX                                                                  1


// addressBlock: gc_pwrdec
// base address: 0x3c000
#define mmCGTS_SM_CTRL_REG                                                                             0x5000
#define mmCGTS_SM_CTRL_REG_BASE_IDX                                                                    1
#define mmCGTS_RD_CTRL_REG                                                                             0x5001
#define mmCGTS_RD_CTRL_REG_BASE_IDX                                                                    1
#define mmCGTS_RD_REG                                                                                  0x5002
#define mmCGTS_RD_REG_BASE_IDX                                                                         1
#define mmCGTS_TCC_DISABLE                                                                             0x5003
#define mmCGTS_TCC_DISABLE_BASE_IDX                                                                    1
#define mmCGTS_USER_TCC_DISABLE                                                                        0x5004
#define mmCGTS_USER_TCC_DISABLE_BASE_IDX                                                               1
#define mmCGTS_CU0_SP0_CTRL_REG                                                                        0x5008
#define mmCGTS_CU0_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU0_LDS_SQ_CTRL_REG                                                                     0x5009
#define mmCGTS_CU0_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU0_TA_SQC_CTRL_REG                                                                     0x500a
#define mmCGTS_CU0_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU0_SP1_CTRL_REG                                                                        0x500b
#define mmCGTS_CU0_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU0_TD_TCP_CTRL_REG                                                                     0x500c
#define mmCGTS_CU0_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU1_SP0_CTRL_REG                                                                        0x500d
#define mmCGTS_CU1_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU1_LDS_SQ_CTRL_REG                                                                     0x500e
#define mmCGTS_CU1_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU1_TA_SQC_CTRL_REG                                                                     0x500f
#define mmCGTS_CU1_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU1_SP1_CTRL_REG                                                                        0x5010
#define mmCGTS_CU1_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU1_TD_TCP_CTRL_REG                                                                     0x5011
#define mmCGTS_CU1_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU2_SP0_CTRL_REG                                                                        0x5012
#define mmCGTS_CU2_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU2_LDS_SQ_CTRL_REG                                                                     0x5013
#define mmCGTS_CU2_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU2_TA_SQC_CTRL_REG                                                                     0x5014
#define mmCGTS_CU2_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU2_SP1_CTRL_REG                                                                        0x5015
#define mmCGTS_CU2_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU2_TD_TCP_CTRL_REG                                                                     0x5016
#define mmCGTS_CU2_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU3_SP0_CTRL_REG                                                                        0x5017
#define mmCGTS_CU3_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU3_LDS_SQ_CTRL_REG                                                                     0x5018
#define mmCGTS_CU3_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU3_TA_SQC_CTRL_REG                                                                     0x5019
#define mmCGTS_CU3_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU3_SP1_CTRL_REG                                                                        0x501a
#define mmCGTS_CU3_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU3_TD_TCP_CTRL_REG                                                                     0x501b
#define mmCGTS_CU3_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU4_SP0_CTRL_REG                                                                        0x501c
#define mmCGTS_CU4_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU4_LDS_SQ_CTRL_REG                                                                     0x501d
#define mmCGTS_CU4_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU4_TA_SQC_CTRL_REG                                                                     0x501e
#define mmCGTS_CU4_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU4_SP1_CTRL_REG                                                                        0x501f
#define mmCGTS_CU4_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU4_TD_TCP_CTRL_REG                                                                     0x5020
#define mmCGTS_CU4_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU5_SP0_CTRL_REG                                                                        0x5021
#define mmCGTS_CU5_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU5_LDS_SQ_CTRL_REG                                                                     0x5022
#define mmCGTS_CU5_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU5_TA_SQC_CTRL_REG                                                                     0x5023
#define mmCGTS_CU5_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU5_SP1_CTRL_REG                                                                        0x5024
#define mmCGTS_CU5_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU5_TD_TCP_CTRL_REG                                                                     0x5025
#define mmCGTS_CU5_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU6_SP0_CTRL_REG                                                                        0x5026
#define mmCGTS_CU6_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU6_LDS_SQ_CTRL_REG                                                                     0x5027
#define mmCGTS_CU6_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU6_TA_SQC_CTRL_REG                                                                     0x5028
#define mmCGTS_CU6_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU6_SP1_CTRL_REG                                                                        0x5029
#define mmCGTS_CU6_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU6_TD_TCP_CTRL_REG                                                                     0x502a
#define mmCGTS_CU6_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU7_SP0_CTRL_REG                                                                        0x502b
#define mmCGTS_CU7_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU7_LDS_SQ_CTRL_REG                                                                     0x502c
#define mmCGTS_CU7_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU7_TA_SQC_CTRL_REG                                                                     0x502d
#define mmCGTS_CU7_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU7_SP1_CTRL_REG                                                                        0x502e
#define mmCGTS_CU7_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU7_TD_TCP_CTRL_REG                                                                     0x502f
#define mmCGTS_CU7_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU8_SP0_CTRL_REG                                                                        0x5030
#define mmCGTS_CU8_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU8_LDS_SQ_CTRL_REG                                                                     0x5031
#define mmCGTS_CU8_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU8_TA_SQC_CTRL_REG                                                                     0x5032
#define mmCGTS_CU8_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU8_SP1_CTRL_REG                                                                        0x5033
#define mmCGTS_CU8_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU8_TD_TCP_CTRL_REG                                                                     0x5034
#define mmCGTS_CU8_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU9_SP0_CTRL_REG                                                                        0x5035
#define mmCGTS_CU9_SP0_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU9_LDS_SQ_CTRL_REG                                                                     0x5036
#define mmCGTS_CU9_LDS_SQ_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU9_TA_SQC_CTRL_REG                                                                     0x5037
#define mmCGTS_CU9_TA_SQC_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU9_SP1_CTRL_REG                                                                        0x5038
#define mmCGTS_CU9_SP1_CTRL_REG_BASE_IDX                                                               1
#define mmCGTS_CU9_TD_TCP_CTRL_REG                                                                     0x5039
#define mmCGTS_CU9_TD_TCP_CTRL_REG_BASE_IDX                                                            1
#define mmCGTS_CU10_SP0_CTRL_REG                                                                       0x503a
#define mmCGTS_CU10_SP0_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU10_LDS_SQ_CTRL_REG                                                                    0x503b
#define mmCGTS_CU10_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU10_TA_SQC_CTRL_REG                                                                    0x503c
#define mmCGTS_CU10_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU10_SP1_CTRL_REG                                                                       0x503d
#define mmCGTS_CU10_SP1_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU10_TD_TCP_CTRL_REG                                                                    0x503e
#define mmCGTS_CU10_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU11_SP0_CTRL_REG                                                                       0x503f
#define mmCGTS_CU11_SP0_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU11_LDS_SQ_CTRL_REG                                                                    0x5040
#define mmCGTS_CU11_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU11_TA_SQC_CTRL_REG                                                                    0x5041
#define mmCGTS_CU11_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU11_SP1_CTRL_REG                                                                       0x5042
#define mmCGTS_CU11_SP1_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU11_TD_TCP_CTRL_REG                                                                    0x5043
#define mmCGTS_CU11_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU12_SP0_CTRL_REG                                                                       0x5044
#define mmCGTS_CU12_SP0_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU12_LDS_SQ_CTRL_REG                                                                    0x5045
#define mmCGTS_CU12_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU12_TA_SQC_CTRL_REG                                                                    0x5046
#define mmCGTS_CU12_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU12_SP1_CTRL_REG                                                                       0x5047
#define mmCGTS_CU12_SP1_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU12_TD_TCP_CTRL_REG                                                                    0x5048
#define mmCGTS_CU12_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU13_SP0_CTRL_REG                                                                       0x5049
#define mmCGTS_CU13_SP0_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU13_LDS_SQ_CTRL_REG                                                                    0x504a
#define mmCGTS_CU13_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU13_TA_SQC_CTRL_REG                                                                    0x504b
#define mmCGTS_CU13_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU13_SP1_CTRL_REG                                                                       0x504c
#define mmCGTS_CU13_SP1_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU13_TD_TCP_CTRL_REG                                                                    0x504d
#define mmCGTS_CU13_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU14_SP0_CTRL_REG                                                                       0x504e
#define mmCGTS_CU14_SP0_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU14_LDS_SQ_CTRL_REG                                                                    0x504f
#define mmCGTS_CU14_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU14_TA_SQC_CTRL_REG                                                                    0x5050
#define mmCGTS_CU14_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU14_SP1_CTRL_REG                                                                       0x5051
#define mmCGTS_CU14_SP1_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU14_TD_TCP_CTRL_REG                                                                    0x5052
#define mmCGTS_CU14_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU15_SP0_CTRL_REG                                                                       0x5053
#define mmCGTS_CU15_SP0_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU15_LDS_SQ_CTRL_REG                                                                    0x5054
#define mmCGTS_CU15_LDS_SQ_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU15_TA_SQC_CTRL_REG                                                                    0x5055
#define mmCGTS_CU15_TA_SQC_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU15_SP1_CTRL_REG                                                                       0x5056
#define mmCGTS_CU15_SP1_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU15_TD_TCP_CTRL_REG                                                                    0x5057
#define mmCGTS_CU15_TD_TCP_CTRL_REG_BASE_IDX                                                           1
#define mmCGTS_CU0_TCPI_CTRL_REG                                                                       0x5058
#define mmCGTS_CU0_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU1_TCPI_CTRL_REG                                                                       0x5059
#define mmCGTS_CU1_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU2_TCPI_CTRL_REG                                                                       0x505a
#define mmCGTS_CU2_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU3_TCPI_CTRL_REG                                                                       0x505b
#define mmCGTS_CU3_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU4_TCPI_CTRL_REG                                                                       0x505c
#define mmCGTS_CU4_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU5_TCPI_CTRL_REG                                                                       0x505d
#define mmCGTS_CU5_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU6_TCPI_CTRL_REG                                                                       0x505e
#define mmCGTS_CU6_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU7_TCPI_CTRL_REG                                                                       0x505f
#define mmCGTS_CU7_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU8_TCPI_CTRL_REG                                                                       0x5060
#define mmCGTS_CU8_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU9_TCPI_CTRL_REG                                                                       0x5061
#define mmCGTS_CU9_TCPI_CTRL_REG_BASE_IDX                                                              1
#define mmCGTS_CU10_TCPI_CTRL_REG                                                                      0x5062
#define mmCGTS_CU10_TCPI_CTRL_REG_BASE_IDX                                                             1
#define mmCGTS_CU11_TCPI_CTRL_REG                                                                      0x5063
#define mmCGTS_CU11_TCPI_CTRL_REG_BASE_IDX                                                             1
#define mmCGTS_CU12_TCPI_CTRL_REG                                                                      0x5064
#define mmCGTS_CU12_TCPI_CTRL_REG_BASE_IDX                                                             1
#define mmCGTS_CU13_TCPI_CTRL_REG                                                                      0x5065
#define mmCGTS_CU13_TCPI_CTRL_REG_BASE_IDX                                                             1
#define mmCGTS_CU14_TCPI_CTRL_REG                                                                      0x5066
#define mmCGTS_CU14_TCPI_CTRL_REG_BASE_IDX                                                             1
#define mmCGTS_CU15_TCPI_CTRL_REG                                                                      0x5067
#define mmCGTS_CU15_TCPI_CTRL_REG_BASE_IDX                                                             1
#define mmCGTT_SPI_CLK_CTRL                                                                            0x5080
#define mmCGTT_SPI_CLK_CTRL_BASE_IDX                                                                   1
#define mmCGTT_PC_CLK_CTRL                                                                             0x5081
#define mmCGTT_PC_CLK_CTRL_BASE_IDX                                                                    1
#define mmCGTT_BCI_CLK_CTRL                                                                            0x5082
#define mmCGTT_BCI_CLK_CTRL_BASE_IDX                                                                   1
#define mmCGTT_VGT_CLK_CTRL                                                                            0x5084
#define mmCGTT_VGT_CLK_CTRL_BASE_IDX                                                                   1
#define mmCGTT_IA_CLK_CTRL                                                                             0x5085
#define mmCGTT_IA_CLK_CTRL_BASE_IDX                                                                    1
#define mmCGTT_WD_CLK_CTRL                                                                             0x5086
#define mmCGTT_WD_CLK_CTRL_BASE_IDX                                                                    1
#define mmCGTT_PA_CLK_CTRL                                                                             0x5088
#define mmCGTT_PA_CLK_CTRL_BASE_IDX                                                                    1
#define mmCGTT_SC_CLK_CTRL0                                                                            0x5089
#define mmCGTT_SC_CLK_CTRL0_BASE_IDX                                                                   1
#define mmCGTT_SC_CLK_CTRL1                                                                            0x508a
#define mmCGTT_SC_CLK_CTRL1_BASE_IDX                                                                   1
#define mmCGTT_SQ_CLK_CTRL                                                                             0x508c
#define mmCGTT_SQ_CLK_CTRL_BASE_IDX                                                                    1
#define mmCGTT_SQG_CLK_CTRL                                                                            0x508d
#define mmCGTT_SQG_CLK_CTRL_BASE_IDX                                                                   1
#define mmSQ_ALU_CLK_CTRL                                                                              0x508e
#define mmSQ_ALU_CLK_CTRL_BASE_IDX                                                                     1
#define mmSQ_TEX_CLK_CTRL                                                                              0x508f
#define mmSQ_TEX_CLK_CTRL_BASE_IDX                                                                     1
#define mmSQ_LDS_CLK_CTRL                                                                              0x5090
#define mmSQ_LDS_CLK_CTRL_BASE_IDX                                                                     1
#define mmSQ_POWER_THROTTLE                                                                            0x5091
#define mmSQ_POWER_THROTTLE_BASE_IDX                                                                   1
#define mmSQ_POWER_THROTTLE2                                                                           0x5092
#define mmSQ_POWER_THROTTLE2_BASE_IDX                                                                  1
#define mmCGTT_SX_CLK_CTRL0                                                                            0x5094
#define mmCGTT_SX_CLK_CTRL0_BASE_IDX                                                                   1
#define mmCGTT_SX_CLK_CTRL1                                                                            0x5095
#define mmCGTT_SX_CLK_CTRL1_BASE_IDX                                                                   1
#define mmCGTT_SX_CLK_CTRL2                                                                            0x5096
#define mmCGTT_SX_CLK_CTRL2_BASE_IDX                                                                   1
#define mmCGTT_SX_CLK_CTRL3                                                                            0x5097
#define mmCGTT_SX_CLK_CTRL3_BASE_IDX                                                                   1
#define mmCGTT_SX_CLK_CTRL4                                                                            0x5098
#define mmCGTT_SX_CLK_CTRL4_BASE_IDX                                                                   1
#define mmTD_CGTT_CTRL                                                                                 0x509c
#define mmTD_CGTT_CTRL_BASE_IDX                                                                        1
#define mmTA_CGTT_CTRL                                                                                 0x509d
#define mmTA_CGTT_CTRL_BASE_IDX                                                                        1
#define mmCGTT_TCPI_CLK_CTRL                                                                           0x509e
#define mmCGTT_TCPI_CLK_CTRL_BASE_IDX                                                                  1
#define mmCGTT_TCI_CLK_CTRL                                                                            0x509f
#define mmCGTT_TCI_CLK_CTRL_BASE_IDX                                                                   1
#define mmCGTT_GDS_CLK_CTRL                                                                            0x50a0
#define mmCGTT_GDS_CLK_CTRL_BASE_IDX                                                                   1
#define mmDB_CGTT_CLK_CTRL_0                                                                           0x50a4
#define mmDB_CGTT_CLK_CTRL_0_BASE_IDX                                                                  1
#define mmCB_CGTT_SCLK_CTRL                                                                            0x50a8
#define mmCB_CGTT_SCLK_CTRL_BASE_IDX                                                                   1
#define mmTCC_CGTT_SCLK_CTRL                                                                           0x50ac
#define mmTCC_CGTT_SCLK_CTRL_BASE_IDX                                                                  1
#define mmTCA_CGTT_SCLK_CTRL                                                                           0x50ad
#define mmTCA_CGTT_SCLK_CTRL_BASE_IDX                                                                  1
#define mmCGTT_CP_CLK_CTRL                                                                             0x50b0
#define mmCGTT_CP_CLK_CTRL_BASE_IDX                                                                    1
#define mmCGTT_CPF_CLK_CTRL                                                                            0x50b1
#define mmCGTT_CPF_CLK_CTRL_BASE_IDX                                                                   1
#define mmCGTT_CPC_CLK_CTRL                                                                            0x50b2
#define mmCGTT_CPC_CLK_CTRL_BASE_IDX                                                                   1
#define mmRLC_PWR_CTRL                                                                                 0x50b4
#define mmRLC_PWR_CTRL_BASE_IDX                                                                        1
#define mmCGTT_RLC_CLK_CTRL                                                                            0x50b5
#define mmCGTT_RLC_CLK_CTRL_BASE_IDX                                                                   1
#define mmRLC_GFX_RM_CNTL                                                                              0x50b6
#define mmRLC_GFX_RM_CNTL_BASE_IDX                                                                     1
#define mmRMI_CGTT_SCLK_CTRL                                                                           0x50c0
#define mmRMI_CGTT_SCLK_CTRL_BASE_IDX                                                                  1
#define mmCGTT_TCPF_CLK_CTRL                                                                           0x50c1
#define mmCGTT_TCPF_CLK_CTRL_BASE_IDX                                                                  1


// addressBlock: gc_ea_pwrdec
// base address: 0x3c000
#define mmGCEA_CGTT_CLK_CTRL                                                                           0x50c4
#define mmGCEA_CGTT_CLK_CTRL_BASE_IDX                                                                  1


// addressBlock: gc_utcl2_vmsharedhvdec
// base address: 0x3ea00
#define mmMC_VM_FB_SIZE_OFFSET_VF0                                                                     0x5a80
#define mmMC_VM_FB_SIZE_OFFSET_VF0_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF1                                                                     0x5a81
#define mmMC_VM_FB_SIZE_OFFSET_VF1_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF2                                                                     0x5a82
#define mmMC_VM_FB_SIZE_OFFSET_VF2_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF3                                                                     0x5a83
#define mmMC_VM_FB_SIZE_OFFSET_VF3_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF4                                                                     0x5a84
#define mmMC_VM_FB_SIZE_OFFSET_VF4_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF5                                                                     0x5a85
#define mmMC_VM_FB_SIZE_OFFSET_VF5_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF6                                                                     0x5a86
#define mmMC_VM_FB_SIZE_OFFSET_VF6_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF7                                                                     0x5a87
#define mmMC_VM_FB_SIZE_OFFSET_VF7_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF8                                                                     0x5a88
#define mmMC_VM_FB_SIZE_OFFSET_VF8_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF9                                                                     0x5a89
#define mmMC_VM_FB_SIZE_OFFSET_VF9_BASE_IDX                                                            1
#define mmMC_VM_FB_SIZE_OFFSET_VF10                                                                    0x5a8a
#define mmMC_VM_FB_SIZE_OFFSET_VF10_BASE_IDX                                                           1
#define mmMC_VM_FB_SIZE_OFFSET_VF11                                                                    0x5a8b
#define mmMC_VM_FB_SIZE_OFFSET_VF11_BASE_IDX                                                           1
#define mmMC_VM_FB_SIZE_OFFSET_VF12                                                                    0x5a8c
#define mmMC_VM_FB_SIZE_OFFSET_VF12_BASE_IDX                                                           1
#define mmMC_VM_FB_SIZE_OFFSET_VF13                                                                    0x5a8d
#define mmMC_VM_FB_SIZE_OFFSET_VF13_BASE_IDX                                                           1
#define mmMC_VM_FB_SIZE_OFFSET_VF14                                                                    0x5a8e
#define mmMC_VM_FB_SIZE_OFFSET_VF14_BASE_IDX                                                           1
#define mmMC_VM_FB_SIZE_OFFSET_VF15                                                                    0x5a8f
#define mmMC_VM_FB_SIZE_OFFSET_VF15_BASE_IDX                                                           1
#define mmVM_IOMMU_MMIO_CNTRL_1                                                                        0x5a90
#define mmVM_IOMMU_MMIO_CNTRL_1_BASE_IDX                                                               1
#define mmMC_VM_MARC_BASE_LO_0                                                                         0x5a91
#define mmMC_VM_MARC_BASE_LO_0_BASE_IDX                                                                1
#define mmMC_VM_MARC_BASE_LO_1                                                                         0x5a92
#define mmMC_VM_MARC_BASE_LO_1_BASE_IDX                                                                1
#define mmMC_VM_MARC_BASE_LO_2                                                                         0x5a93
#define mmMC_VM_MARC_BASE_LO_2_BASE_IDX                                                                1
#define mmMC_VM_MARC_BASE_LO_3                                                                         0x5a94
#define mmMC_VM_MARC_BASE_LO_3_BASE_IDX                                                                1
#define mmMC_VM_MARC_BASE_HI_0                                                                         0x5a95
#define mmMC_VM_MARC_BASE_HI_0_BASE_IDX                                                                1
#define mmMC_VM_MARC_BASE_HI_1                                                                         0x5a96
#define mmMC_VM_MARC_BASE_HI_1_BASE_IDX                                                                1
#define mmMC_VM_MARC_BASE_HI_2                                                                         0x5a97
#define mmMC_VM_MARC_BASE_HI_2_BASE_IDX                                                                1
#define mmMC_VM_MARC_BASE_HI_3                                                                         0x5a98
#define mmMC_VM_MARC_BASE_HI_3_BASE_IDX                                                                1
#define mmMC_VM_MARC_RELOC_LO_0                                                                        0x5a99
#define mmMC_VM_MARC_RELOC_LO_0_BASE_IDX                                                               1
#define mmMC_VM_MARC_RELOC_LO_1                                                                        0x5a9a
#define mmMC_VM_MARC_RELOC_LO_1_BASE_IDX                                                               1
#define mmMC_VM_MARC_RELOC_LO_2                                                                        0x5a9b
#define mmMC_VM_MARC_RELOC_LO_2_BASE_IDX                                                               1
#define mmMC_VM_MARC_RELOC_LO_3                                                                        0x5a9c
#define mmMC_VM_MARC_RELOC_LO_3_BASE_IDX                                                               1
#define mmMC_VM_MARC_RELOC_HI_0                                                                        0x5a9d
#define mmMC_VM_MARC_RELOC_HI_0_BASE_IDX                                                               1
#define mmMC_VM_MARC_RELOC_HI_1                                                                        0x5a9e
#define mmMC_VM_MARC_RELOC_HI_1_BASE_IDX                                                               1
#define mmMC_VM_MARC_RELOC_HI_2                                                                        0x5a9f
#define mmMC_VM_MARC_RELOC_HI_2_BASE_IDX                                                               1
#define mmMC_VM_MARC_RELOC_HI_3                                                                        0x5aa0
#define mmMC_VM_MARC_RELOC_HI_3_BASE_IDX                                                               1
#define mmMC_VM_MARC_LEN_LO_0                                                                          0x5aa1
#define mmMC_VM_MARC_LEN_LO_0_BASE_IDX                                                                 1
#define mmMC_VM_MARC_LEN_LO_1                                                                          0x5aa2
#define mmMC_VM_MARC_LEN_LO_1_BASE_IDX                                                                 1
#define mmMC_VM_MARC_LEN_LO_2                                                                          0x5aa3
#define mmMC_VM_MARC_LEN_LO_2_BASE_IDX                                                                 1
#define mmMC_VM_MARC_LEN_LO_3                                                                          0x5aa4
#define mmMC_VM_MARC_LEN_LO_3_BASE_IDX                                                                 1
#define mmMC_VM_MARC_LEN_HI_0                                                                          0x5aa5
#define mmMC_VM_MARC_LEN_HI_0_BASE_IDX                                                                 1
#define mmMC_VM_MARC_LEN_HI_1                                                                          0x5aa6
#define mmMC_VM_MARC_LEN_HI_1_BASE_IDX                                                                 1
#define mmMC_VM_MARC_LEN_HI_2                                                                          0x5aa7
#define mmMC_VM_MARC_LEN_HI_2_BASE_IDX                                                                 1
#define mmMC_VM_MARC_LEN_HI_3                                                                          0x5aa8
#define mmMC_VM_MARC_LEN_HI_3_BASE_IDX                                                                 1
#define mmVM_IOMMU_CONTROL_REGISTER                                                                    0x5aa9
#define mmVM_IOMMU_CONTROL_REGISTER_BASE_IDX                                                           1
#define mmVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER                                           0x5aaa
#define mmVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER_BASE_IDX                                  1
#define mmVM_PCIE_ATS_CNTL                                                                             0x5aab
#define mmVM_PCIE_ATS_CNTL_BASE_IDX                                                                    1
#define mmVM_PCIE_ATS_CNTL_VF_0                                                                        0x5aac
#define mmVM_PCIE_ATS_CNTL_VF_0_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_1                                                                        0x5aad
#define mmVM_PCIE_ATS_CNTL_VF_1_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_2                                                                        0x5aae
#define mmVM_PCIE_ATS_CNTL_VF_2_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_3                                                                        0x5aaf
#define mmVM_PCIE_ATS_CNTL_VF_3_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_4                                                                        0x5ab0
#define mmVM_PCIE_ATS_CNTL_VF_4_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_5                                                                        0x5ab1
#define mmVM_PCIE_ATS_CNTL_VF_5_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_6                                                                        0x5ab2
#define mmVM_PCIE_ATS_CNTL_VF_6_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_7                                                                        0x5ab3
#define mmVM_PCIE_ATS_CNTL_VF_7_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_8                                                                        0x5ab4
#define mmVM_PCIE_ATS_CNTL_VF_8_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_9                                                                        0x5ab5
#define mmVM_PCIE_ATS_CNTL_VF_9_BASE_IDX                                                               1
#define mmVM_PCIE_ATS_CNTL_VF_10                                                                       0x5ab6
#define mmVM_PCIE_ATS_CNTL_VF_10_BASE_IDX                                                              1
#define mmVM_PCIE_ATS_CNTL_VF_11                                                                       0x5ab7
#define mmVM_PCIE_ATS_CNTL_VF_11_BASE_IDX                                                              1
#define mmVM_PCIE_ATS_CNTL_VF_12                                                                       0x5ab8
#define mmVM_PCIE_ATS_CNTL_VF_12_BASE_IDX                                                              1
#define mmVM_PCIE_ATS_CNTL_VF_13                                                                       0x5ab9
#define mmVM_PCIE_ATS_CNTL_VF_13_BASE_IDX                                                              1
#define mmVM_PCIE_ATS_CNTL_VF_14                                                                       0x5aba
#define mmVM_PCIE_ATS_CNTL_VF_14_BASE_IDX                                                              1
#define mmVM_PCIE_ATS_CNTL_VF_15                                                                       0x5abb
#define mmVM_PCIE_ATS_CNTL_VF_15_BASE_IDX                                                              1
#define mmUTCL2_CGTT_CLK_CTRL                                                                          0x5abc
#define mmUTCL2_CGTT_CLK_CTRL_BASE_IDX                                                                 1


// addressBlock: gc_hypdec
// base address: 0x3e000
#define mmCP_HYP_PFP_UCODE_ADDR                                                                        0x5814
#define mmCP_HYP_PFP_UCODE_ADDR_BASE_IDX                                                               1
#define mmCP_PFP_UCODE_ADDR                                                                            0x5814
#define mmCP_PFP_UCODE_ADDR_BASE_IDX                                                                   1
#define mmCP_HYP_PFP_UCODE_DATA                                                                        0x5815
#define mmCP_HYP_PFP_UCODE_DATA_BASE_IDX                                                               1
#define mmCP_PFP_UCODE_DATA                                                                            0x5815
#define mmCP_PFP_UCODE_DATA_BASE_IDX                                                                   1
#define mmCP_HYP_ME_UCODE_ADDR                                                                         0x5816
#define mmCP_HYP_ME_UCODE_ADDR_BASE_IDX                                                                1
#define mmCP_ME_RAM_RADDR                                                                              0x5816
#define mmCP_ME_RAM_RADDR_BASE_IDX                                                                     1
#define mmCP_ME_RAM_WADDR                                                                              0x5816
#define mmCP_ME_RAM_WADDR_BASE_IDX                                                                     1
#define mmCP_HYP_ME_UCODE_DATA                                                                         0x5817
#define mmCP_HYP_ME_UCODE_DATA_BASE_IDX                                                                1
#define mmCP_ME_RAM_DATA                                                                               0x5817
#define mmCP_ME_RAM_DATA_BASE_IDX                                                                      1
#define mmCP_CE_UCODE_ADDR                                                                             0x5818
#define mmCP_CE_UCODE_ADDR_BASE_IDX                                                                    1
#define mmCP_HYP_CE_UCODE_ADDR                                                                         0x5818
#define mmCP_HYP_CE_UCODE_ADDR_BASE_IDX                                                                1
#define mmCP_CE_UCODE_DATA                                                                             0x5819
#define mmCP_CE_UCODE_DATA_BASE_IDX                                                                    1
#define mmCP_HYP_CE_UCODE_DATA                                                                         0x5819
#define mmCP_HYP_CE_UCODE_DATA_BASE_IDX                                                                1
#define mmCP_HYP_MEC1_UCODE_ADDR                                                                       0x581a
#define mmCP_HYP_MEC1_UCODE_ADDR_BASE_IDX                                                              1
#define mmCP_MEC_ME1_UCODE_ADDR                                                                        0x581a
#define mmCP_MEC_ME1_UCODE_ADDR_BASE_IDX                                                               1
#define mmCP_HYP_MEC1_UCODE_DATA                                                                       0x581b
#define mmCP_HYP_MEC1_UCODE_DATA_BASE_IDX                                                              1
#define mmCP_MEC_ME1_UCODE_DATA                                                                        0x581b
#define mmCP_MEC_ME1_UCODE_DATA_BASE_IDX                                                               1
#define mmCP_HYP_MEC2_UCODE_ADDR                                                                       0x581c
#define mmCP_HYP_MEC2_UCODE_ADDR_BASE_IDX                                                              1
#define mmCP_MEC_ME2_UCODE_ADDR                                                                        0x581c
#define mmCP_MEC_ME2_UCODE_ADDR_BASE_IDX                                                               1
#define mmCP_HYP_MEC2_UCODE_DATA                                                                       0x581d
#define mmCP_HYP_MEC2_UCODE_DATA_BASE_IDX                                                              1
#define mmCP_MEC_ME2_UCODE_DATA                                                                        0x581d
#define mmCP_MEC_ME2_UCODE_DATA_BASE_IDX                                                               1
#define mmRLC_GPM_UCODE_ADDR                                                                           0x583c
#define mmRLC_GPM_UCODE_ADDR_BASE_IDX                                                                  1
#define mmRLC_GPM_UCODE_DATA                                                                           0x583d
#define mmRLC_GPM_UCODE_DATA_BASE_IDX                                                                  1
#define mmGRBM_GFX_INDEX_SR_SELECT                                                                     0x5a00
#define mmGRBM_GFX_INDEX_SR_SELECT_BASE_IDX                                                            1
#define mmGRBM_GFX_INDEX_SR_DATA                                                                       0x5a01
#define mmGRBM_GFX_INDEX_SR_DATA_BASE_IDX                                                              1
#define mmGRBM_GFX_CNTL_SR_SELECT                                                                      0x5a02
#define mmGRBM_GFX_CNTL_SR_SELECT_BASE_IDX                                                             1
#define mmGRBM_GFX_CNTL_SR_DATA                                                                        0x5a03
#define mmGRBM_GFX_CNTL_SR_DATA_BASE_IDX                                                               1
#define mmGRBM_CAM_INDEX                                                                               0x5a04
#define mmGRBM_CAM_INDEX_BASE_IDX                                                                      1
#define mmGRBM_HYP_CAM_INDEX                                                                           0x5a04
#define mmGRBM_HYP_CAM_INDEX_BASE_IDX                                                                  1
#define mmGRBM_CAM_DATA                                                                                0x5a05
#define mmGRBM_CAM_DATA_BASE_IDX                                                                       1
#define mmGRBM_HYP_CAM_DATA                                                                            0x5a05
#define mmGRBM_HYP_CAM_DATA_BASE_IDX                                                                   1
#define mmRLC_GPU_IOV_VF_ENABLE                                                                        0x5b00
#define mmRLC_GPU_IOV_VF_ENABLE_BASE_IDX                                                               1
#define mmRLC_GFX_RM_CNTL_ADJ                                                                          0x5b01
#define mmRLC_GFX_RM_CNTL_ADJ_BASE_IDX                                                                 1
#define mmRLC_GPU_IOV_CFG_REG6                                                                         0x5b06
#define mmRLC_GPU_IOV_CFG_REG6_BASE_IDX                                                                1
#define mmRLC_GPU_IOV_CFG_REG8                                                                         0x5b20
#define mmRLC_GPU_IOV_CFG_REG8_BASE_IDX                                                                1
#define mmRLC_RLCV_TIMER_INT_0                                                                         0x5b25
#define mmRLC_RLCV_TIMER_INT_0_BASE_IDX                                                                1
#define mmRLC_RLCV_TIMER_CTRL                                                                          0x5b26
#define mmRLC_RLCV_TIMER_CTRL_BASE_IDX                                                                 1
#define mmRLC_RLCV_TIMER_STAT                                                                          0x5b27
#define mmRLC_RLCV_TIMER_STAT_BASE_IDX                                                                 1
#define mmRLC_GPU_IOV_VF_DOORBELL_STATUS                                                               0x5b2a
#define mmRLC_GPU_IOV_VF_DOORBELL_STATUS_BASE_IDX                                                      1
#define mmRLC_GPU_IOV_VF_DOORBELL_STATUS_SET                                                           0x5b2b
#define mmRLC_GPU_IOV_VF_DOORBELL_STATUS_SET_BASE_IDX                                                  1
#define mmRLC_GPU_IOV_VF_DOORBELL_STATUS_CLR                                                           0x5b2c
#define mmRLC_GPU_IOV_VF_DOORBELL_STATUS_CLR_BASE_IDX                                                  1
#define mmRLC_GPU_IOV_VF_MASK                                                                          0x5b2d
#define mmRLC_GPU_IOV_VF_MASK_BASE_IDX                                                                 1
#define mmRLC_HYP_SEMAPHORE_2                                                                          0x5b2e
#define mmRLC_HYP_SEMAPHORE_2_BASE_IDX                                                                 1
#define mmRLC_HYP_SEMAPHORE_3                                                                          0x5b2f
#define mmRLC_HYP_SEMAPHORE_3_BASE_IDX                                                                 1
#define mmRLC_CLK_CNTL                                                                                 0x5b31
#define mmRLC_CLK_CNTL_BASE_IDX                                                                        1
#define mmRLC_GPU_IOV_SCH_BLOCK                                                                        0x5b34
#define mmRLC_GPU_IOV_SCH_BLOCK_BASE_IDX                                                               1
#define mmRLC_GPU_IOV_CFG_REG1                                                                         0x5b35
#define mmRLC_GPU_IOV_CFG_REG1_BASE_IDX                                                                1
#define mmRLC_GPU_IOV_CFG_REG2                                                                         0x5b36
#define mmRLC_GPU_IOV_CFG_REG2_BASE_IDX                                                                1
#define mmRLC_GPU_IOV_VM_BUSY_STATUS                                                                   0x5b37
#define mmRLC_GPU_IOV_VM_BUSY_STATUS_BASE_IDX                                                          1
#define mmRLC_GPU_IOV_SCH_0                                                                            0x5b38
#define mmRLC_GPU_IOV_SCH_0_BASE_IDX                                                                   1
#define mmRLC_GPU_IOV_ACTIVE_FCN_ID                                                                    0x5b39
#define mmRLC_GPU_IOV_ACTIVE_FCN_ID_BASE_IDX                                                           1
#define mmRLC_GPU_IOV_SCH_3                                                                            0x5b3a
#define mmRLC_GPU_IOV_SCH_3_BASE_IDX                                                                   1
#define mmRLC_GPU_IOV_SCH_1                                                                            0x5b3b
#define mmRLC_GPU_IOV_SCH_1_BASE_IDX                                                                   1
#define mmRLC_GPU_IOV_SCH_2                                                                            0x5b3c
#define mmRLC_GPU_IOV_SCH_2_BASE_IDX                                                                   1
#define mmRLC_GPU_IOV_UCODE_ADDR                                                                       0x5b42
#define mmRLC_GPU_IOV_UCODE_ADDR_BASE_IDX                                                              1
#define mmRLC_GPU_IOV_UCODE_DATA                                                                       0x5b43
#define mmRLC_GPU_IOV_UCODE_DATA_BASE_IDX                                                              1
#define mmRLC_GPU_IOV_SCRATCH_ADDR                                                                     0x5b44
#define mmRLC_GPU_IOV_SCRATCH_ADDR_BASE_IDX                                                            1
#define mmRLC_GPU_IOV_SCRATCH_DATA                                                                     0x5b45
#define mmRLC_GPU_IOV_SCRATCH_DATA_BASE_IDX                                                            1
#define mmRLC_GPU_IOV_F32_CNTL                                                                         0x5b46
#define mmRLC_GPU_IOV_F32_CNTL_BASE_IDX                                                                1
#define mmRLC_GPU_IOV_F32_RESET                                                                        0x5b47
#define mmRLC_GPU_IOV_F32_RESET_BASE_IDX                                                               1
#define mmRLC_GPU_IOV_SDMA0_STATUS                                                                     0x5b48
#define mmRLC_GPU_IOV_SDMA0_STATUS_BASE_IDX                                                            1
#define mmRLC_GPU_IOV_SDMA1_STATUS                                                                     0x5b49
#define mmRLC_GPU_IOV_SDMA1_STATUS_BASE_IDX                                                            1
#define mmRLC_GPU_IOV_SMU_RESPONSE                                                                     0x5b4a
#define mmRLC_GPU_IOV_SMU_RESPONSE_BASE_IDX                                                            1
#define mmRLC_GPU_IOV_VIRT_RESET_REQ                                                                   0x5b4c
#define mmRLC_GPU_IOV_VIRT_RESET_REQ_BASE_IDX                                                          1
#define mmRLC_GPU_IOV_RLC_RESPONSE                                                                     0x5b4d
#define mmRLC_GPU_IOV_RLC_RESPONSE_BASE_IDX                                                            1
#define mmRLC_GPU_IOV_INT_DISABLE                                                                      0x5b4e
#define mmRLC_GPU_IOV_INT_DISABLE_BASE_IDX                                                             1
#define mmRLC_GPU_IOV_INT_FORCE                                                                        0x5b4f
#define mmRLC_GPU_IOV_INT_FORCE_BASE_IDX                                                               1
#define mmRLC_GPU_IOV_SDMA0_BUSY_STATUS                                                                0x5b50
#define mmRLC_GPU_IOV_SDMA0_BUSY_STATUS_BASE_IDX                                                       1
#define mmRLC_GPU_IOV_SDMA1_BUSY_STATUS                                                                0x5b51
#define mmRLC_GPU_IOV_SDMA1_BUSY_STATUS_BASE_IDX                                                       1


// addressBlock: gccacind
// base address: 0x0
#define ixGC_CAC_CNTL                                                                                  0x0000
#define ixGC_CAC_OVR_SEL                                                                               0x0001
#define ixGC_CAC_OVR_VAL                                                                               0x0002
#define ixGC_CAC_WEIGHT_BCI_0                                                                          0x0003
#define ixGC_CAC_WEIGHT_CB_0                                                                           0x0004
#define ixGC_CAC_WEIGHT_CB_1                                                                           0x0005
#define ixGC_CAC_WEIGHT_CP_0                                                                           0x0008
#define ixGC_CAC_WEIGHT_CP_1                                                                           0x0009
#define ixGC_CAC_WEIGHT_DB_0                                                                           0x000a
#define ixGC_CAC_WEIGHT_DB_1                                                                           0x000b
#define ixGC_CAC_WEIGHT_GDS_0                                                                          0x000e
#define ixGC_CAC_WEIGHT_GDS_1                                                                          0x000f
#define ixGC_CAC_WEIGHT_IA_0                                                                           0x0010
#define ixGC_CAC_WEIGHT_LDS_0                                                                          0x0011
#define ixGC_CAC_WEIGHT_LDS_1                                                                          0x0012
#define ixGC_CAC_WEIGHT_PA_0                                                                           0x0013
#define ixGC_CAC_WEIGHT_PC_0                                                                           0x0014
#define ixGC_CAC_WEIGHT_SC_0                                                                           0x0015
#define ixGC_CAC_WEIGHT_SPI_0                                                                          0x0016
#define ixGC_CAC_WEIGHT_SPI_1                                                                          0x0017
#define ixGC_CAC_WEIGHT_SPI_2                                                                          0x0018
#define ixGC_CAC_WEIGHT_SQ_0                                                                           0x001a
#define ixGC_CAC_WEIGHT_SQ_1                                                                           0x001b
#define ixGC_CAC_WEIGHT_SQ_2                                                                           0x001c
#define ixGC_CAC_WEIGHT_SQ_3                                                                           0x001d
#define ixGC_CAC_WEIGHT_SQ_4                                                                           0x001e
#define ixGC_CAC_WEIGHT_SX_0                                                                           0x001f
#define ixGC_CAC_WEIGHT_SXRB_0                                                                         0x0020
#define ixGC_CAC_WEIGHT_TA_0                                                                           0x0021
#define ixGC_CAC_WEIGHT_TCC_0                                                                          0x0022
#define ixGC_CAC_WEIGHT_TCC_1                                                                          0x0023
#define ixGC_CAC_WEIGHT_TCC_2                                                                          0x0024
#define ixGC_CAC_WEIGHT_TCP_0                                                                          0x0025
#define ixGC_CAC_WEIGHT_TCP_1                                                                          0x0026
#define ixGC_CAC_WEIGHT_TCP_2                                                                          0x0027
#define ixGC_CAC_WEIGHT_TD_0                                                                           0x0028
#define ixGC_CAC_WEIGHT_TD_1                                                                           0x0029
#define ixGC_CAC_WEIGHT_TD_2                                                                           0x002a
#define ixGC_CAC_WEIGHT_VGT_0                                                                          0x002b
#define ixGC_CAC_WEIGHT_VGT_1                                                                          0x002c
#define ixGC_CAC_WEIGHT_WD_0                                                                           0x002d
#define ixGC_CAC_WEIGHT_CU_0                                                                           0x0032
#define ixGC_CAC_WEIGHT_CU_1                                                                           0x0033
#define ixGC_CAC_WEIGHT_CU_2                                                                           0x0034
#define ixGC_CAC_WEIGHT_CU_3                                                                           0x0035
#define ixGC_CAC_WEIGHT_CU_4                                                                           0x0036
#define ixGC_CAC_WEIGHT_CU_5                                                                           0x0037
#define ixGC_CAC_ACC_BCI0                                                                              0x0042
#define ixGC_CAC_ACC_CB0                                                                               0x0043
#define ixGC_CAC_ACC_CB1                                                                               0x0044
#define ixGC_CAC_ACC_CB2                                                                               0x0045
#define ixGC_CAC_ACC_CB3                                                                               0x0046
#define ixGC_CAC_ACC_CP0                                                                               0x004b
#define ixGC_CAC_ACC_CP1                                                                               0x004c
#define ixGC_CAC_ACC_CP2                                                                               0x004d
#define ixGC_CAC_ACC_DB0                                                                               0x004e
#define ixGC_CAC_ACC_DB1                                                                               0x004f
#define ixGC_CAC_ACC_DB2                                                                               0x0050
#define ixGC_CAC_ACC_DB3                                                                               0x0051
#define ixGC_CAC_ACC_GDS0                                                                              0x0056
#define ixGC_CAC_ACC_GDS1                                                                              0x0057
#define ixGC_CAC_ACC_GDS2                                                                              0x0058
#define ixGC_CAC_ACC_GDS3                                                                              0x0059
#define ixGC_CAC_ACC_IA0                                                                               0x005a
#define ixGC_CAC_ACC_LDS0                                                                              0x005b
#define ixGC_CAC_ACC_LDS1                                                                              0x005c
#define ixGC_CAC_ACC_LDS2                                                                              0x005d
#define ixGC_CAC_ACC_LDS3                                                                              0x005e
#define ixGC_CAC_ACC_PA0                                                                               0x005f
#define ixGC_CAC_ACC_PA1                                                                               0x0060
#define ixGC_CAC_ACC_PC0                                                                               0x0061
#define ixGC_CAC_ACC_SC0                                                                               0x0062
#define ixGC_CAC_ACC_SPI0                                                                              0x0063
#define ixGC_CAC_ACC_SPI1                                                                              0x0064
#define ixGC_CAC_ACC_SPI2                                                                              0x0065
#define ixGC_CAC_ACC_SPI3                                                                              0x0066
#define ixGC_CAC_ACC_SPI4                                                                              0x0067
#define ixGC_CAC_ACC_SPI5                                                                              0x0068
#define ixGC_CAC_WEIGHT_PG_0                                                                           0x0069
#define ixGC_CAC_ACC_PG0                                                                               0x006a
#define ixGC_CAC_OVRD_PG                                                                               0x006b
#define ixGC_CAC_WEIGHT_UTCL2_ATCL2_0                                                                  0x006f
#define ixGC_CAC_ACC_EA0                                                                               0x0070
#define ixGC_CAC_ACC_EA1                                                                               0x0071
#define ixGC_CAC_ACC_EA2                                                                               0x0072
#define ixGC_CAC_ACC_EA3                                                                               0x0073
#define ixGC_CAC_ACC_UTCL2_ATCL20                                                                      0x0074
#define ixGC_CAC_OVRD_EA                                                                               0x0075
#define ixGC_CAC_OVRD_UTCL2_ATCL2                                                                      0x0076
#define ixGC_CAC_WEIGHT_EA_0                                                                           0x0077
#define ixGC_CAC_WEIGHT_EA_1                                                                           0x0078
#define ixGC_CAC_WEIGHT_RMI_0                                                                          0x0079
#define ixGC_CAC_ACC_RMI0                                                                              0x007a
#define ixGC_CAC_OVRD_RMI                                                                              0x007b
#define ixGC_CAC_WEIGHT_UTCL2_ATCL2_1                                                                  0x007c
#define ixGC_CAC_ACC_UTCL2_ATCL21                                                                      0x007d
#define ixGC_CAC_ACC_UTCL2_ATCL22                                                                      0x007e
#define ixGC_CAC_ACC_UTCL2_ATCL23                                                                      0x007f
#define ixGC_CAC_ACC_EA4                                                                               0x0080
#define ixGC_CAC_ACC_EA5                                                                               0x0081
#define ixGC_CAC_WEIGHT_EA_2                                                                           0x0082
#define ixGC_CAC_ACC_SQ0_LOWER                                                                         0x0089
#define ixGC_CAC_ACC_SQ0_UPPER                                                                         0x008a
#define ixGC_CAC_ACC_SQ1_LOWER                                                                         0x008b
#define ixGC_CAC_ACC_SQ1_UPPER                                                                         0x008c
#define ixGC_CAC_ACC_SQ2_LOWER                                                                         0x008d
#define ixGC_CAC_ACC_SQ2_UPPER                                                                         0x008e
#define ixGC_CAC_ACC_SQ3_LOWER                                                                         0x008f
#define ixGC_CAC_ACC_SQ3_UPPER                                                                         0x0090
#define ixGC_CAC_ACC_SQ4_LOWER                                                                         0x0091
#define ixGC_CAC_ACC_SQ4_UPPER                                                                         0x0092
#define ixGC_CAC_ACC_SQ5_LOWER                                                                         0x0093
#define ixGC_CAC_ACC_SQ5_UPPER                                                                         0x0094
#define ixGC_CAC_ACC_SQ6_LOWER                                                                         0x0095
#define ixGC_CAC_ACC_SQ6_UPPER                                                                         0x0096
#define ixGC_CAC_ACC_SQ7_LOWER                                                                         0x0097
#define ixGC_CAC_ACC_SQ7_UPPER                                                                         0x0098
#define ixGC_CAC_ACC_SQ8_LOWER                                                                         0x0099
#define ixGC_CAC_ACC_SQ8_UPPER                                                                         0x009a
#define ixGC_CAC_ACC_SX0                                                                               0x009b
#define ixGC_CAC_ACC_SXRB0                                                                             0x009c
#define ixGC_CAC_ACC_SXRB1                                                                             0x009d
#define ixGC_CAC_ACC_TA0                                                                               0x009e
#define ixGC_CAC_ACC_TCC0                                                                              0x009f
#define ixGC_CAC_ACC_TCC1                                                                              0x00a0
#define ixGC_CAC_ACC_TCC2                                                                              0x00a1
#define ixGC_CAC_ACC_TCC3                                                                              0x00a2
#define ixGC_CAC_ACC_TCC4                                                                              0x00a3
#define ixGC_CAC_ACC_TCP0                                                                              0x00a4
#define ixGC_CAC_ACC_TCP1                                                                              0x00a5
#define ixGC_CAC_ACC_TCP2                                                                              0x00a6
#define ixGC_CAC_ACC_TCP3                                                                              0x00a7
#define ixGC_CAC_ACC_TCP4                                                                              0x00a8
#define ixGC_CAC_ACC_TD0                                                                               0x00a9
#define ixGC_CAC_ACC_TD1                                                                               0x00aa
#define ixGC_CAC_ACC_TD2                                                                               0x00ab
#define ixGC_CAC_ACC_TD3                                                                               0x00ac
#define ixGC_CAC_ACC_TD4                                                                               0x00ad
#define ixGC_CAC_ACC_TD5                                                                               0x00ae
#define ixGC_CAC_ACC_VGT0                                                                              0x00af
#define ixGC_CAC_ACC_VGT1                                                                              0x00b0
#define ixGC_CAC_ACC_VGT2                                                                              0x00b1
#define ixGC_CAC_ACC_WD0                                                                               0x00b2
#define ixGC_CAC_ACC_CU0                                                                               0x00ba
#define ixGC_CAC_ACC_CU1                                                                               0x00bb
#define ixGC_CAC_ACC_CU2                                                                               0x00bc
#define ixGC_CAC_ACC_CU3                                                                               0x00bd
#define ixGC_CAC_ACC_CU4                                                                               0x00be
#define ixGC_CAC_ACC_CU5                                                                               0x00bf
#define ixGC_CAC_ACC_CU6                                                                               0x00c0
#define ixGC_CAC_ACC_CU7                                                                               0x00c1
#define ixGC_CAC_ACC_CU8                                                                               0x00c2
#define ixGC_CAC_ACC_CU9                                                                               0x00c3
#define ixGC_CAC_ACC_CU10                                                                              0x00c4
#define ixGC_CAC_OVRD_BCI                                                                              0x00da
#define ixGC_CAC_OVRD_CB                                                                               0x00db
#define ixGC_CAC_OVRD_CP                                                                               0x00dd
#define ixGC_CAC_OVRD_DB                                                                               0x00de
#define ixGC_CAC_OVRD_GDS                                                                              0x00e0
#define ixGC_CAC_OVRD_IA                                                                               0x00e1
#define ixGC_CAC_OVRD_LDS                                                                              0x00e2
#define ixGC_CAC_OVRD_PA                                                                               0x00e3
#define ixGC_CAC_OVRD_PC                                                                               0x00e4
#define ixGC_CAC_OVRD_SC                                                                               0x00e5
#define ixGC_CAC_OVRD_SPI                                                                              0x00e6
#define ixGC_CAC_OVRD_CU                                                                               0x00e7
#define ixGC_CAC_OVRD_SQ                                                                               0x00e8
#define ixGC_CAC_OVRD_SX                                                                               0x00e9
#define ixGC_CAC_OVRD_SXRB                                                                             0x00ea
#define ixGC_CAC_OVRD_TA                                                                               0x00eb
#define ixGC_CAC_OVRD_TCC                                                                              0x00ec
#define ixGC_CAC_OVRD_TCP                                                                              0x00ed
#define ixGC_CAC_OVRD_TD                                                                               0x00ee
#define ixGC_CAC_OVRD_VGT                                                                              0x00ef
#define ixGC_CAC_OVRD_WD                                                                               0x00f0
#define ixGC_CAC_ACC_BCI1                                                                              0x00ff
#define ixGC_CAC_WEIGHT_UTCL2_ATCL2_2                                                                  0x0100
#define ixGC_CAC_WEIGHT_UTCL2_ROUTER_0                                                                 0x0101
#define ixGC_CAC_WEIGHT_UTCL2_ROUTER_1                                                                 0x0102
#define ixGC_CAC_WEIGHT_UTCL2_ROUTER_2                                                                 0x0103
#define ixGC_CAC_WEIGHT_UTCL2_ROUTER_3                                                                 0x0104
#define ixGC_CAC_WEIGHT_UTCL2_ROUTER_4                                                                 0x0105
#define ixGC_CAC_WEIGHT_UTCL2_VML2_0                                                                   0x0106
#define ixGC_CAC_WEIGHT_UTCL2_VML2_1                                                                   0x0107
#define ixGC_CAC_WEIGHT_UTCL2_VML2_2                                                                   0x0108
#define ixGC_CAC_ACC_UTCL2_ATCL24                                                                      0x0109
#define ixGC_CAC_ACC_UTCL2_ROUTER0                                                                     0x010a
#define ixGC_CAC_ACC_UTCL2_ROUTER1                                                                     0x010b
#define ixGC_CAC_ACC_UTCL2_ROUTER2                                                                     0x010c
#define ixGC_CAC_ACC_UTCL2_ROUTER3                                                                     0x010d
#define ixGC_CAC_ACC_UTCL2_ROUTER4                                                                     0x010e
#define ixGC_CAC_ACC_UTCL2_ROUTER5                                                                     0x010f
#define ixGC_CAC_ACC_UTCL2_ROUTER6                                                                     0x0110
#define ixGC_CAC_ACC_UTCL2_ROUTER7                                                                     0x0111
#define ixGC_CAC_ACC_UTCL2_ROUTER8                                                                     0x0112
#define ixGC_CAC_ACC_UTCL2_ROUTER9                                                                     0x0113
#define ixGC_CAC_ACC_UTCL2_VML20                                                                       0x0114
#define ixGC_CAC_ACC_UTCL2_VML21                                                                       0x0115
#define ixGC_CAC_ACC_UTCL2_VML22                                                                       0x0116
#define ixGC_CAC_ACC_UTCL2_VML23                                                                       0x0117
#define ixGC_CAC_ACC_UTCL2_VML24                                                                       0x0118
#define ixGC_CAC_OVRD_UTCL2_ROUTER                                                                     0x0119
#define ixGC_CAC_OVRD_UTCL2_VML2                                                                       0x011a
#define ixGC_CAC_WEIGHT_UTCL2_WALKER_0                                                                 0x011b
#define ixGC_CAC_WEIGHT_UTCL2_WALKER_1                                                                 0x011c
#define ixGC_CAC_WEIGHT_UTCL2_WALKER_2                                                                 0x011d
#define ixGC_CAC_ACC_UTCL2_WALKER0                                                                     0x011e
#define ixGC_CAC_ACC_UTCL2_WALKER1                                                                     0x011f
#define ixGC_CAC_ACC_UTCL2_WALKER2                                                                     0x0120
#define ixGC_CAC_ACC_UTCL2_WALKER3                                                                     0x0121
#define ixGC_CAC_ACC_UTCL2_WALKER4                                                                     0x0122
#define ixGC_CAC_OVRD_UTCL2_WALKER                                                                     0x0123


// addressBlock: secacind
// base address: 0x0
#define ixSE_CAC_CNTL                                                                                  0x0000
#define ixSE_CAC_OVR_SEL                                                                               0x0001
#define ixSE_CAC_OVR_VAL                                                                               0x0002


// addressBlock: sqind
// base address: 0x0
#define ixSQ_DEBUG_STS_LOCAL                                                                           0x0008
#define ixSQ_WAVE_MODE                                                                                 0x0011
#define ixSQ_WAVE_STATUS                                                                               0x0012
#define ixSQ_WAVE_TRAPSTS                                                                              0x0013
#define ixSQ_WAVE_HW_ID                                                                                0x0014
#define ixSQ_WAVE_GPR_ALLOC                                                                            0x0015
#define ixSQ_WAVE_LDS_ALLOC                                                                            0x0016
#define ixSQ_WAVE_IB_STS                                                                               0x0017
#define ixSQ_WAVE_PC_LO                                                                                0x0018
#define ixSQ_WAVE_PC_HI                                                                                0x0019
#define ixSQ_WAVE_INST_DW0                                                                             0x001a
#define ixSQ_WAVE_INST_DW1                                                                             0x001b
#define ixSQ_WAVE_IB_DBG0                                                                              0x001c
#define ixSQ_WAVE_IB_DBG1                                                                              0x001d
#define ixSQ_WAVE_FLUSH_IB                                                                             0x001e
#define ixSQ_WAVE_TTMP0                                                                                0x026c
#define ixSQ_WAVE_TTMP1                                                                                0x026d
#define ixSQ_WAVE_TTMP2                                                                                0x026e
#define ixSQ_WAVE_TTMP3                                                                                0x026f
#define ixSQ_WAVE_TTMP4                                                                                0x0270
#define ixSQ_WAVE_TTMP5                                                                                0x0271
#define ixSQ_WAVE_TTMP6                                                                                0x0272
#define ixSQ_WAVE_TTMP7                                                                                0x0273
#define ixSQ_WAVE_TTMP8                                                                                0x0274
#define ixSQ_WAVE_TTMP9                                                                                0x0275
#define ixSQ_WAVE_TTMP10                                                                               0x0276
#define ixSQ_WAVE_TTMP11                                                                               0x0277
#define ixSQ_WAVE_TTMP12                                                                               0x0278
#define ixSQ_WAVE_TTMP13                                                                               0x0279
#define ixSQ_WAVE_TTMP14                                                                               0x027a
#define ixSQ_WAVE_TTMP15                                                                               0x027b
#define ixSQ_WAVE_M0                                                                                   0x027c
#define ixSQ_WAVE_EXEC_LO                                                                              0x027e
#define ixSQ_WAVE_EXEC_HI                                                                              0x027f
#define ixSQ_INTERRUPT_WORD_AUTO_CTXID                                                                 0x20c0
#define ixSQ_INTERRUPT_WORD_AUTO_HI                                                                    0x20c0
#define ixSQ_INTERRUPT_WORD_AUTO_LO                                                                    0x20c0
#define ixSQ_INTERRUPT_WORD_CMN_CTXID                                                                  0x20c0
#define ixSQ_INTERRUPT_WORD_CMN_HI                                                                     0x20c0
#define ixSQ_INTERRUPT_WORD_WAVE_CTXID                                                                 0x20c0
#define ixSQ_INTERRUPT_WORD_WAVE_HI                                                                    0x20c0
#define ixSQ_INTERRUPT_WORD_WAVE_LO                                                                    0x20c0


// addressBlock: didtind
// base address: 0x0
#define ixDIDT_SQ_CTRL0                                                                                0x0000
#define ixDIDT_SQ_CTRL1                                                                                0x0001
#define ixDIDT_SQ_CTRL2                                                                                0x0002
#define ixDIDT_SQ_STALL_CTRL                                                                           0x0004
#define ixDIDT_SQ_TUNING_CTRL                                                                          0x0005
#define ixDIDT_SQ_STALL_AUTO_RELEASE_CTRL                                                              0x0006
#define ixDIDT_SQ_CTRL3                                                                                0x0007
#define ixDIDT_SQ_STALL_PATTERN_1_2                                                                    0x0008
#define ixDIDT_SQ_STALL_PATTERN_3_4                                                                    0x0009
#define ixDIDT_SQ_STALL_PATTERN_5_6                                                                    0x000a
#define ixDIDT_SQ_STALL_PATTERN_7                                                                      0x000b
#define ixDIDT_SQ_WEIGHT0_3                                                                            0x0010
#define ixDIDT_SQ_WEIGHT4_7                                                                            0x0011
#define ixDIDT_SQ_WEIGHT8_11                                                                           0x0012
#define ixDIDT_SQ_EDC_CTRL                                                                             0x0013
#define ixDIDT_SQ_EDC_THRESHOLD                                                                        0x0014
#define ixDIDT_SQ_EDC_STALL_PATTERN_1_2                                                                0x0015
#define ixDIDT_SQ_EDC_STALL_PATTERN_3_4                                                                0x0016
#define ixDIDT_SQ_EDC_STALL_PATTERN_5_6                                                                0x0017
#define ixDIDT_SQ_EDC_STALL_PATTERN_7                                                                  0x0018
#define ixDIDT_SQ_EDC_STATUS                                                                           0x0019
#define ixDIDT_SQ_EDC_STALL_DELAY_1                                                                    0x001a
#define ixDIDT_SQ_EDC_STALL_DELAY_2                                                                    0x001b
#define ixDIDT_SQ_EDC_STALL_DELAY_3                                                                    0x001c
#define ixDIDT_SQ_EDC_OVERFLOW                                                                         0x001e
#define ixDIDT_SQ_EDC_ROLLING_POWER_DELTA                                                              0x001f
#define ixDIDT_DB_CTRL0                                                                                0x0020
#define ixDIDT_DB_CTRL1                                                                                0x0021
#define ixDIDT_DB_CTRL2                                                                                0x0022
#define ixDIDT_DB_STALL_CTRL                                                                           0x0024
#define ixDIDT_DB_TUNING_CTRL                                                                          0x0025
#define ixDIDT_DB_STALL_AUTO_RELEASE_CTRL                                                              0x0026
#define ixDIDT_DB_CTRL3                                                                                0x0027
#define ixDIDT_DB_STALL_PATTERN_1_2                                                                    0x0028
#define ixDIDT_DB_STALL_PATTERN_3_4                                                                    0x0029
#define ixDIDT_DB_STALL_PATTERN_5_6                                                                    0x002a
#define ixDIDT_DB_STALL_PATTERN_7                                                                      0x002b
#define ixDIDT_DB_WEIGHT0_3                                                                            0x0030
#define ixDIDT_DB_WEIGHT4_7                                                                            0x0031
#define ixDIDT_DB_WEIGHT8_11                                                                           0x0032
#define ixDIDT_DB_EDC_CTRL                                                                             0x0033
#define ixDIDT_DB_EDC_THRESHOLD                                                                        0x0034
#define ixDIDT_DB_EDC_STALL_PATTERN_1_2                                                                0x0035
#define ixDIDT_DB_EDC_STALL_PATTERN_3_4                                                                0x0036
#define ixDIDT_DB_EDC_STALL_PATTERN_5_6                                                                0x0037
#define ixDIDT_DB_EDC_STALL_PATTERN_7                                                                  0x0038
#define ixDIDT_DB_EDC_STATUS                                                                           0x0039
#define ixDIDT_DB_EDC_STALL_DELAY_1                                                                    0x003a
#define ixDIDT_DB_EDC_OVERFLOW                                                                         0x003e
#define ixDIDT_DB_EDC_ROLLING_POWER_DELTA                                                              0x003f
#define ixDIDT_TD_CTRL0                                                                                0x0040
#define ixDIDT_TD_CTRL1                                                                                0x0041
#define ixDIDT_TD_CTRL2                                                                                0x0042
#define ixDIDT_TD_STALL_CTRL                                                                           0x0044
#define ixDIDT_TD_TUNING_CTRL                                                                          0x0045
#define ixDIDT_TD_STALL_AUTO_RELEASE_CTRL                                                              0x0046
#define ixDIDT_TD_CTRL3                                                                                0x0047
#define ixDIDT_TD_STALL_PATTERN_1_2                                                                    0x0048
#define ixDIDT_TD_STALL_PATTERN_3_4                                                                    0x0049
#define ixDIDT_TD_STALL_PATTERN_5_6                                                                    0x004a
#define ixDIDT_TD_STALL_PATTERN_7                                                                      0x004b
#define ixDIDT_TD_WEIGHT0_3                                                                            0x0050
#define ixDIDT_TD_WEIGHT4_7                                                                            0x0051
#define ixDIDT_TD_WEIGHT8_11                                                                           0x0052
#define ixDIDT_TD_EDC_CTRL                                                                             0x0053
#define ixDIDT_TD_EDC_THRESHOLD                                                                        0x0054
#define ixDIDT_TD_EDC_STALL_PATTERN_1_2                                                                0x0055
#define ixDIDT_TD_EDC_STALL_PATTERN_3_4                                                                0x0056
#define ixDIDT_TD_EDC_STALL_PATTERN_5_6                                                                0x0057
#define ixDIDT_TD_EDC_STALL_PATTERN_7                                                                  0x0058
#define ixDIDT_TD_EDC_STATUS                                                                           0x0059
#define ixDIDT_TD_EDC_STALL_DELAY_1                                                                    0x005a
#define ixDIDT_TD_EDC_STALL_DELAY_2                                                                    0x005b
#define ixDIDT_TD_EDC_STALL_DELAY_3                                                                    0x005c
#define ixDIDT_TD_EDC_OVERFLOW                                                                         0x005e
#define ixDIDT_TD_EDC_ROLLING_POWER_DELTA                                                              0x005f
#define ixDIDT_TCP_CTRL0                                                                               0x0060
#define ixDIDT_TCP_CTRL1                                                                               0x0061
#define ixDIDT_TCP_CTRL2                                                                               0x0062
#define ixDIDT_TCP_STALL_CTRL                                                                          0x0064
#define ixDIDT_TCP_TUNING_CTRL                                                                         0x0065
#define ixDIDT_TCP_STALL_AUTO_RELEASE_CTRL                                                             0x0066
#define ixDIDT_TCP_CTRL3                                                                               0x0067
#define ixDIDT_TCP_STALL_PATTERN_1_2                                                                   0x0068
#define ixDIDT_TCP_STALL_PATTERN_3_4                                                                   0x0069
#define ixDIDT_TCP_STALL_PATTERN_5_6                                                                   0x006a
#define ixDIDT_TCP_STALL_PATTERN_7                                                                     0x006b
#define ixDIDT_TCP_WEIGHT0_3                                                                           0x0070
#define ixDIDT_TCP_WEIGHT4_7                                                                           0x0071
#define ixDIDT_TCP_WEIGHT8_11                                                                          0x0072
#define ixDIDT_TCP_EDC_CTRL                                                                            0x0073
#define ixDIDT_TCP_EDC_THRESHOLD                                                                       0x0074
#define ixDIDT_TCP_EDC_STALL_PATTERN_1_2                                                               0x0075
#define ixDIDT_TCP_EDC_STALL_PATTERN_3_4                                                               0x0076
#define ixDIDT_TCP_EDC_STALL_PATTERN_5_6                                                               0x0077
#define ixDIDT_TCP_EDC_STALL_PATTERN_7                                                                 0x0078
#define ixDIDT_TCP_EDC_STATUS                                                                          0x0079
#define ixDIDT_TCP_EDC_STALL_DELAY_1                                                                   0x007a
#define ixDIDT_TCP_EDC_STALL_DELAY_2                                                                   0x007b
#define ixDIDT_TCP_EDC_STALL_DELAY_3                                                                   0x007c
#define ixDIDT_TCP_EDC_OVERFLOW                                                                        0x007e
#define ixDIDT_TCP_EDC_ROLLING_POWER_DELTA                                                             0x007f
#define ixDIDT_DBR_CTRL0                                                                               0x0080
#define ixDIDT_DBR_CTRL1                                                                               0x0081
#define ixDIDT_DBR_CTRL2                                                                               0x0082
#define ixDIDT_DBR_STALL_CTRL                                                                          0x0084
#define ixDIDT_DBR_TUNING_CTRL                                                                         0x0085
#define ixDIDT_DBR_STALL_AUTO_RELEASE_CTRL                                                             0x0086
#define ixDIDT_DBR_CTRL3                                                                               0x0087
#define ixDIDT_DBR_STALL_PATTERN_1_2                                                                   0x0088
#define ixDIDT_DBR_STALL_PATTERN_3_4                                                                   0x0089
#define ixDIDT_DBR_STALL_PATTERN_5_6                                                                   0x008a
#define ixDIDT_DBR_STALL_PATTERN_7                                                                     0x008b
#define ixDIDT_DBR_WEIGHT0_3                                                                           0x0090
#define ixDIDT_DBR_WEIGHT4_7                                                                           0x0091
#define ixDIDT_DBR_WEIGHT8_11                                                                          0x0092
#define ixDIDT_DBR_EDC_CTRL                                                                            0x0093
#define ixDIDT_DBR_EDC_THRESHOLD                                                                       0x0094
#define ixDIDT_DBR_EDC_STALL_PATTERN_1_2                                                               0x0095
#define ixDIDT_DBR_EDC_STALL_PATTERN_3_4                                                               0x0096
#define ixDIDT_DBR_EDC_STALL_PATTERN_5_6                                                               0x0097
#define ixDIDT_DBR_EDC_STALL_PATTERN_7                                                                 0x0098
#define ixDIDT_DBR_EDC_STATUS                                                                          0x0099
#define ixDIDT_DBR_EDC_STALL_DELAY_1                                                                   0x009a
#define ixDIDT_DBR_EDC_OVERFLOW                                                                        0x009e
#define ixDIDT_DBR_EDC_ROLLING_POWER_DELTA                                                             0x009f
#define ixDIDT_SQ_STALL_EVENT_COUNTER                                                                  0x00a0
#define ixDIDT_DB_STALL_EVENT_COUNTER                                                                  0x00a1
#define ixDIDT_TD_STALL_EVENT_COUNTER                                                                  0x00a2
#define ixDIDT_TCP_STALL_EVENT_COUNTER                                                                 0x00a3
#define ixDIDT_DBR_STALL_EVENT_COUNTER                                                                 0x00a4


#endif
