# 0.94 Release “Tricks or Tracebacks?”

The Pitivi team is proud to announce the fourth release of the new
version of Pitivi based on [GES](GES.md), the GStreamer Editing
Services library. This is mostly a incremental bugfixing release, so
make sure to see the [0.91](releases/0.91.md), [0.92](releases/0.92.md)
and [0.93](releases/0.93.md) release notes to get the full picture.

This is considered a **beta** release. As per the feedback we've
received since 0.91 and the many fixes we've made since then, we are
confident that the new release series is of much higher quality than the
0.15 series and older.

This release works well for us and we make nice movies with it. Try it
out, have fun and report detailed bugs for issues you may encounter!

## Changes and fixed bugs

Executive summary:

-   The main toolbar and menubar have been replaced by a headerbar and
    menubutton, saving a significant amount of precious vertical space
    and using the horizontal space better.
-   The viewer has been ported to use a GStreamer GL video output sink
    instead of the Clutter sink. This solves crashes when running Pitivi
    outside of GNOME Shell and is expected to be a more future-proof
    solution.
-   We dropped our use of CoGL APIs, namely path\_round\_rectangle which
    caused crashes on various Linux distributions shipping a broken
    version of CoGL
-   Pitivi has been ported to Python 3
-   Text wrapping in the rendering progress dialog and title editor has
    been fixed
-   Effects can now be reordered within a clip's properties
-   The default positioning of UI components (when starting from a fresh
    install) has been improved to be balanced properly
-   Undocked window components do not shift position on startup anymore
-   Docked window components do not shift position on startup anymore,
    when the window is not maximized. When the window is maximized, the
    issue remains (your help to investigate this problem is very much
    welcome, see [bug
    723061](https://bugzilla.gnome.org/show_bug.cgi?id=723061))
-   The title editor's UI has been simplified, and now supports decimal
    font sizes
-   Educational infobars throughout the UI have been tweaked to make
    their colors less intrusive
-   Various issues have been corrected regarding:
    -   Drag and drop in the media library
    -   Audio waveforms
    -   Undo/redo
-   The user manual is now up to date with the state of the new Pitivi
    series
-   Pitivi has been ported to GtkApplication, allowing us to remove a
    lot of old code.
-   Port deprecated GTK+ widgets to new ones
-   Timeline UI animations have been tweaked
-   Code refactoring and cleanup all over the place
-   Various build and packaging fixes
-   Various fixes to the test suite
-   Translations have been updated

See the list of [reported bugs that have been resolved in
0.94](https://bugzilla.gnome.org/buglist.cgi?product=pitivi;target_milestone=0.94).

Since the 0.93 release, 240 commits were made across 159 files. Here is
a summary of some noteworthy commits:

```
8f252a4 viewer: Do not call the expose function when we set the aspect ratio
2846425 viewer: Do not forget to set ViewerWidget sink when setting our pipeline
c6b12b7 Show an error dialog when encountering Unicode decoding errors/broken locales
8776f73 clipmediaprops: Handle potentially broken framerates such as 1000 fps
10d82cd pitivi: Remove our hard dependency to GdkX11
4ef394b timeline: Fix dragging of second clip from the media library to the timeline
b019640 Make the title editor's infobar more compact to avoid excessive wrapping
f0d8f4f Make the “User Manual” menu item work in the main MenuButton
4c6e137 Fix the text wrapping in the rendering progress dialog
8bc597f effects: Allow reordering the effects of a clip
ba5a7a8 timeline: Fix effects dragged onto clips
d9e89f8 effects: Display the human names in the list of effects of a clip
b054f9f clipproperties: Disable sorting of the clip's effects
e4702c5 clipproperties: Fix effects tooltips
374aa64 mainwindow: Better default placement for panes
279b6ed previewers: Avoid removing sources already running
a1985ae previewers: Always set lastUpdate when computing geometry
ae0ef1f video previewer: remove unused self._callback_id
67b9d5c previewers: Fix initial value of AudioPreviewer.lastUpdate
fb3f3da timeline: Get rid of some clip animations
9e39466 project: Fix setting of restriction caps values
e34bbfe Set emblem-system-symbolic for menu icon before gtk 3.13
c671383 render: Play the rendered file without blocking the UI
860d904 timeline: make sure not to set a negative size on elements.
89a9349 Change some infobars to be more discrete
af65ef5 elements: Don't use Cogl anymore.
c4c11de elements: Don't use path_round_rectangle.
9d171bf Use Gio.SimpleActions to handle global app keyboard events
f7e23b0 Make Pitivi a GtkApplication
d48a39c mainwindow: Replace the menubar and main toolbar by HeaderBar and MenuButton
2696f41 Port Pitivi to Python 3
4c09ca6 mainwindow: Fix main window's panes shifting position
6e894d8 tabsmanager: Fix utility windows' shifting behaviour
```

## Requirements

In this release:

-   We have dropped the dependency on ClutterGst
-   We now depend on GStreamer 1.4
-   We now depend on GTK+ 3.10

Generally speaking, you can refer to Pitivi's check.py for the
dependencies' versions specific to a given release. See also
[dependencies](attic/Dependencies.md) for additional tips.

## Known issues

-   Layer management interface is missing features.
-   The title editor UI is still quite primitive. Please join us to make
    it work up to your expectations! See the existing [title editor
    bugs](https://bugzilla.gnome.org/buglist.cgi?product=pitivi&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&component=Title%20editor).
-   The transformation box reimplementation is still ongoing (see [bug
    708495](https://bugzilla.gnome.org/show_bug.cgi?id=708495)).
-   Translations are not all fully up to date.
-   The automated codecs installer is (still) broken. See [bug
    686182](https://bugzilla.gnome.org/show_bug.cgi?id=686182) and [GES
    bug 686181](https://bugzilla.gnome.org/show_bug.cgi?id=686181).
-   The automatic clip aligner feature does not work. We need someone to
    [port it to use our new audio waveforms processing
    module](https://bugzilla.gnome.org/show_bug.cgi?id=708401).
-   [No dialog to install missing codecs after discovering
    clips](https://bugzilla.gnome.org/show_bug.cgi?id=686182), and no
    error gets raised in that case. This means that the clip will
    “appear” to have imported correctly, but if you try inserting it
    into the timeline you may get errors in the background or Pitivi's
    UI may hang.

See the list of [currently known
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_severity=blocker;bug_severity=critical;bug_severity=major;bug_severity=normal;bug_severity=minor;bug_severity=trivial;bug_status=NEW;bug_status=ASSIGNED;bug_status=REOPENED;product=pitivi),
the [0.91, 0.92, 0.93 and 0.94-specific
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced&version=0.91&version=0.92&version=0.93&version=0.94&resolution=---&product=pitivi)
and the list of [bugs that need re-testing with
0.91](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_status=NEEDINFO;target_milestone=0.91;product=pitivi)
(you can help!)

# Contributors for this release

In Pitivi:

```
94  Alexandru Băluț
33  Tomas Karger
24  Thibault Saunier
22  Jean-François Fortin Tam
20  Lubosz Sarnecki
 8  Mathieu Duponchelle
 2  Fabian Orccon
 2  Georges Basile Stavracas Neto
 2  Ken MacLeod
 1  Brion Vibber
 1  Dominique Leuenberger
```

In GES:

```
53  Thibault Saunier
15  Mathieu Duponchelle
 5  Edward Hervey
 5  Lubosz Sarnecki
 4  Sebastian Dröge
 3  Tim-Philipp Müller
 2  Christoph Reiter
 1  Alexandru Băluț
 1  Lazar Claudiu
 1  Vincent Penquerc'h
```

Translations:

```
   cs  Marek Černocký
   de  Bernd Homuth
   el  Tom Tryfonidis, Dimitris Spingos
   es  Daniel Mustieles, Milagros Alessandra Infante Montero
   fi  Lasse Liehu
   fr  Alexandre Franke, Jean-François Fortin Tam
   hu  Balázs Úr
   lt  Aurimas Černius
   pl  Piotr Drąg
pt_BR  Rafael Ferreira
   ru  Alexandre Prokoudine, Yuri Myasoedov
   sk  Dušan Kazik
   sl  Martin Srebotnjak
   sr  Мирослав Николић
zh_TW  Cheng-Chia Tseng
```

# Download, additional information and feedback

A tarball is available on
<https://download.gnome.org/sources/pitivi/0.94/>

A bundle usable on any linux distribution is avalaible at:

 * 64 bits platforms: [http://pitivi.ecchi.ca/bundles/releases/pitivi-0.94-beta-x86_64.tar](http://pitivi.ecchi.ca/bundles/releases/pitivi-0.94-beta-x86_64.tar)
 * 32 bits platforms: [http://pitivi.ecchi.ca/bundles/releases/pitivi-0.94-beta-x86.tar](http://pitivi.ecchi.ca/bundles/releases/pitivi-0.94-beta-x86.tar)

See [the Pitivi website](http://www.pitivi.org) and [building with
GES](attic/building_with_ges.md) for download and installation
instructions.

Feedback is welcome. See [bug reporting](Bug_reporting.md) for
tips and tricks.
