/* $Cambridge: hermes/src/prayer/cmd/cmd_dir_check.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

/* Unix Date conversion is ghastly. Stole following from c-client */

static char *current_time(void)
{
    static char current[64];
    time_t tn = time(0);
    struct tm *t = gmtime(&tn);
    int zone = t->tm_hour * 60 + t->tm_min;
    int julian = t->tm_yday;
    t = localtime(&tn);         /* get local time now */
    /* minus UTC minutes since midnight */
    zone = t->tm_hour * 60 + t->tm_min - zone;
    /* julian can be one of:
     *  36x  local time is December 31, UTC is January 1, offset -24 hours
     *    1  local time is 1 day ahead of UTC, offset +24 hours
     *    0  local time is same day as UTC, no offset
     *   -1  local time is 1 day behind UTC, offset -24 hours
     * -36x  local time is January 1, UTC is December 31, offset +24 hours
     */
    if ((julian = t->tm_yday - julian) != 0)
        zone += ((julian < 0) == (abs(julian) == 1)) ? -24 * 60 : 24 * 60;
    /* output the time */

    sprintf(current, "%02d:%02d:%02d %+03d%02d",
            t->tm_hour, t->tm_min, t->tm_sec, zone / 60, abs(zone) % 60);

    return (current);
}

void cmd_dir_check(struct session *session)
{
    struct request *request = session->request;

    folderlist_invalidate(session->folderlist);
    session_message(session, "Refreshed mailbox list cache at %s",
                    current_time());

    if (request->argc >= 2)
        session_redirect(session, request, request->argv[1]);
    else
        session_redirect(session, request, "folders");
}
