% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunable.R
\name{tunable.recipe}
\alias{tunable.recipe}
\alias{tunable.step}
\alias{tunable.check}
\title{Find recommended methods for generating parameter values}
\usage{
\method{tunable}{recipe}(x, ...)

\method{tunable}{step}(x, ...)

\method{tunable}{check}(x, ...)
}
\arguments{
\item{x}{A recipe, recipe step, or recipe check object}

\item{...}{Not currently used.}
}
\value{
A tibble with a column for the parameter \code{name}, information on the
\emph{default} method for generating a corresponding parameter object, the
\code{source} of the parameter (e.g. "recipe", etc.), and the \code{component} within
the source. For the \code{component} column, a little more specificity is given
about the location of the parameter (e.g. "step_normalize" for recipes).
The \code{component_id} column contains the unique step \code{id} field.
}
\description{
\code{\link[=tunable]{tunable()}} determines which parameters in an object \emph{can} be tuned along
with information about the parameters.
}
\details{
These functions define what parameters \emph{can} be tuned for specific steps.
They also define the recommended objects from the \code{dials} package that can
be used to generate new parameter values and other characteristics.

If the object has no tunable parameters, a tibble with no rows is returned.

The information about the default parameter object takes the form of a
named list with an element for the function call and an optional element for
the source of the function (e.g. the \code{dials} package).
}
\examples{
\donttest{
library(recipes)

recipe(mpg ~ ., data = mtcars) \%>\%
  step_knnimpute(all_predictors()) \%>\%
  step_pca(all_predictors()) \%>\%
  tunable()

recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_predictors()) \%>\%
  tunable()
}

}
\keyword{internal}
