#! /usr/bin/env perl

use strict;
use warnings;

use lib 'lib';
use RestfulDB::Spreadsheet qw( sprintf_csv_line );

my @cases = (
    [ 1, 1/3, 'string', 'string with spaces' ],
    [ 'value , with, ,commas', '"quoted"', '""dquoted""' ],
    [ 'value,"value",value', "'single quote'" ],
);

my $csv = Text::CSV->new();

foreach my $values (@cases) {
    my $encoded;
    do {
        local *STDOUT;
        open( *STDOUT, '>', \$encoded );
        print sprintf_csv_line( $values, $csv );
    };
    print $encoded, "\n";
}
