(include "Scheme-to-C-compatibility")
(include "xlib")

(let ((display (xopendisplay "")))
 (when (zero? display) (panic "Can't open display"))
 (let* ((screen (xdefaultscreen display))
	(root (xrootwindow display screen))
	(window (xcreatesimplewindow
		 display root 100 200 300 50 0
		 (xblackpixel display screen)
		 (xwhitepixel display screen))))
  (when (zero? window) (panic "Can't open window"))
  (let ((font (xloadfont display "10x20")))
   (when (zero? font) (panic "Can't load font"))
   (let ((gc (xcreategc display window 0 (integer->pointer 0)))
	 (event (make-xevent)))
    (xsetforeground display gc (xblackpixel display screen))
    (xsetbackground display gc (xwhitepixel display screen))
    (xsetfunction display gc gxcopy)
    (xsetfont display gc font)
    (xselectinput display window (bitwise-or exposuremask buttonpressmask))
    (xmapwindow display window)
    (xnextevent display event)
    (xdrawstring display window gc 100 30 "Hello World!" 12)
    (xflush display)
    (xnextevent display event)))))
