'\"
'\" Generated from file 'to\&.inc' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "pt::peg::to::param" n 1 tcllib "Parser Tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
pt::peg::to::param \- PEG Conversion\&. Write PARAM format
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBpt::peg::to::param  ?1?\fR
.sp
package require \fBpt::peg \fR
.sp
package require \fBpt::pe \fR
.sp
\fBpt::peg::to::param\fR \fBreset\fR
.sp
\fBpt::peg::to::param\fR \fBconfigure\fR
.sp
\fBpt::peg::to::param\fR \fBconfigure\fR \fIoption\fR
.sp
\fBpt::peg::to::param\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR\&.\&.\&.
.sp
\fBpt::peg::to::param\fR \fBconvert\fR \fIserial\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR\&. This document is the
entrypoint to the whole system the current package is a part of\&.
.PP
This package implements the converter from parsing expression grammars
to PARAM markup\&.
.PP
It resides in the Export section of the Core Layer of Parser Tools,
and can be used either directly with the other packages of this layer,
or indirectly through the export manager provided by
\fBpt::peg::export\fR\&. The latter is intented for use in untrusted
environments and done through the corresponding export plugin
\fBpt::peg::export::param\fR sitting between converter
and export manager\&.
.PP
IMAGE: arch_core_eplugins
.PP
.SH API
The API provided by this package satisfies the specification of the
Converter API found in the \fIParser Tools Export API\fR
specification\&.
.TP
\fBpt::peg::to::param\fR \fBreset\fR
This command resets the configuration of the package to its default
settings\&.
.TP
\fBpt::peg::to::param\fR \fBconfigure\fR
This command returns a dictionary containing the current configuration
of the package\&.
.TP
\fBpt::peg::to::param\fR \fBconfigure\fR \fIoption\fR
This command returns the current value of the specified configuration
\fIoption\fR of the package\&. For the set of legal options, please read
the section \fBOptions\fR\&.
.TP
\fBpt::peg::to::param\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR\&.\&.\&.
This command sets the given configuration \fIoption\fRs of the
package, to the specified \fIvalue\fRs\&. For the set of legal options,
please read the section \fBOptions\fR\&.
.TP
\fBpt::peg::to::param\fR \fBconvert\fR \fIserial\fR
This command takes the canonical serialization of a parsing expression
grammar, as specified in section \fBPEG serialization format\fR,
and contained in \fIserial\fR, and generates PARAM markup
encoding the grammar, per the current package configuration\&.
The created string is then returned as the result of the command\&.
.PP
.SH OPTIONS
The converter to PARAM markup recognizes the following configuration
variables and changes its behaviour as they specify\&.
.TP
\fB-template\fR string
The value of this configuration variable is a string into which to put
the generated text and the other configuration settings\&. The various
locations for user-data are expected to be specified with the
placeholders listed below\&. The default value is "\fB@code@\fR"\&.
.RS
.TP
\fB@user@\fR
To be replaced with the value of the configuration variable \fB-user\fR\&.
.TP
\fB@format@\fR
To be replaced with the the constant \fBPARAM\fR\&.
.TP
\fB@file@\fR
To be replaced with the value of the configuration variable \fB-file\fR\&.
.TP
\fB@name@\fR
To be replaced with the value of the configuration variable \fB-name\fR\&.
.TP
\fB@code@\fR
To be replaced with the generated text\&.
.RE
.TP
\fB-name\fR string
The value of this configuration variable is the name of the grammar
for which the conversion is run\&. The default value is \fBa_pe_grammar\fR\&.
.TP
\fB-user\fR string
The value of this configuration variable is the name of the user for
which the conversion is run\&. The default value is \fBunknown\fR\&.
.TP
\fB-file\fR string
The value of this configuration variable is the name of the file or
other entity from which the grammar came, for which the conversion is
run\&. The default value is \fBunknown\fR\&.
.PP
.SH "PARAM CODE REPRESENTATION OF PARSING EXPRESSION GRAMMARS"
The PARAM code representation of parsing expression grammars is
assembler-like text using the instructions of the virtual machine
documented in the \fIPackRat Machine Specification\fR, plus a
few more for control flow (jump ok, jump fail, call symbol, return)\&.
.PP
It is not really useful, except possibly as a tool demonstrating how a
grammar is compiled in general, without getting distracted by the
incidentials of a framework, i\&.e\&. like the supporting C and Tcl code
generated by the other PARAM-derived formats\&.
.PP
It has no direct formal specification beyond what was said above\&.
.SS EXAMPLE
Assuming the following PEG for simple mathematical expressions
.PP
.CS


PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'       ;
    Sign       <- '-' / '+'                                     ;
    Number     <- Sign? Digit+                                  ;
    Expression <- Term (AddOp Term)*                            ;
    MulOp      <- '*' / '/'                                     ;
    Term       <- Factor (MulOp Factor)*                        ;
    AddOp      <- '+'/'-'                                       ;
    Factor     <- '(' Expression ')' / Number                   ;
END;

.CE
.PP
one possible PARAM serialization for it is
.PP
.CS


# -*- text -*-
# Parsing Expression Grammar 'TEMPLATE'\&.
# Generated for unknown, from file 'TEST'

#
# Grammar Start Expression
#

<<MAIN>>:
         call              sym_Expression
         halt

#
# value Symbol 'AddOp'
#

sym_AddOp:
# /
#     '-'
#     '+'

         symbol_restore    AddOp
  found! jump              found_7
         loc_push

         call              choice_5

   fail! value_clear
     ok! value_leaf        AddOp
         symbol_save       AddOp
         error_nonterminal AddOp
         loc_pop_discard

found_7:
     ok! ast_value_push
         return

choice_5:
# /
#     '-'
#     '+'

         error_clear

         loc_push
         error_push

         input_next        "t -"
     ok! test_char         "-"

         error_pop_merge
     ok! jump              oknoast_4

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t +"
     ok! test_char         "+"

         error_pop_merge
     ok! jump              oknoast_4

         loc_pop_rewind
         status_fail
         return

oknoast_4:
         loc_pop_discard
         return
#
# value Symbol 'Digit'
#

sym_Digit:
# /
#     '0'
#     '1'
#     '2'
#     '3'
#     '4'
#     '5'
#     '6'
#     '7'
#     '8'
#     '9'

         symbol_restore    Digit
  found! jump              found_22
         loc_push

         call              choice_20

   fail! value_clear
     ok! value_leaf        Digit
         symbol_save       Digit
         error_nonterminal Digit
         loc_pop_discard

found_22:
     ok! ast_value_push
         return

choice_20:
# /
#     '0'
#     '1'
#     '2'
#     '3'
#     '4'
#     '5'
#     '6'
#     '7'
#     '8'
#     '9'

         error_clear

         loc_push
         error_push

         input_next        "t 0"
     ok! test_char         "0"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 1"
     ok! test_char         "1"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 2"
     ok! test_char         "2"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 3"
     ok! test_char         "3"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 4"
     ok! test_char         "4"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 5"
     ok! test_char         "5"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 6"
     ok! test_char         "6"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 7"
     ok! test_char         "7"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 8"
     ok! test_char         "8"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t 9"
     ok! test_char         "9"

         error_pop_merge
     ok! jump              oknoast_19

         loc_pop_rewind
         status_fail
         return

oknoast_19:
         loc_pop_discard
         return
#
# value Symbol 'Expression'
#

sym_Expression:
# /
#     x
#         '\\('
#         (Expression)
#         '\\)'
#     x
#         (Factor)
#         *
#             x
#                 (MulOp)
#                 (Factor)

         symbol_restore    Expression
  found! jump              found_46
         loc_push
         ast_push

         call              choice_44

   fail! value_clear
     ok! value_reduce      Expression
         symbol_save       Expression
         error_nonterminal Expression
         ast_pop_rewind
         loc_pop_discard

found_46:
     ok! ast_value_push
         return

choice_44:
# /
#     x
#         '\\('
#         (Expression)
#         '\\)'
#     x
#         (Factor)
#         *
#             x
#                 (MulOp)
#                 (Factor)

         error_clear

         ast_push
         loc_push
         error_push

         call              sequence_27

         error_pop_merge
     ok! jump              ok_43

         ast_pop_rewind
         loc_pop_rewind
         ast_push
         loc_push
         error_push

         call              sequence_40

         error_pop_merge
     ok! jump              ok_43

         ast_pop_rewind
         loc_pop_rewind
         status_fail
         return

ok_43:
         ast_pop_discard
         loc_pop_discard
         return

sequence_27:
# x
#     '\\('
#     (Expression)
#     '\\)'

         loc_push
         error_clear

         error_push

         input_next        "t ("
     ok! test_char         "("

         error_pop_merge
   fail! jump              failednoast_29
         ast_push
         error_push

         call              sym_Expression

         error_pop_merge
   fail! jump              failed_28
         error_push

         input_next        "t )"
     ok! test_char         ")"

         error_pop_merge
   fail! jump              failed_28

         ast_pop_discard
         loc_pop_discard
         return

failed_28:
         ast_pop_rewind

failednoast_29:
         loc_pop_rewind
         return

sequence_40:
# x
#     (Factor)
#     *
#         x
#             (MulOp)
#             (Factor)

         ast_push
         loc_push
         error_clear

         error_push

         call              sym_Factor

         error_pop_merge
   fail! jump              failed_41
         error_push

         call              kleene_37

         error_pop_merge
   fail! jump              failed_41

         ast_pop_discard
         loc_pop_discard
         return

failed_41:
         ast_pop_rewind
         loc_pop_rewind
         return

kleene_37:
# *
#     x
#         (MulOp)
#         (Factor)

         loc_push
         error_push

         call              sequence_34

         error_pop_merge
   fail! jump              failed_38
         loc_pop_discard
         jump              kleene_37

failed_38:
         loc_pop_rewind
         status_ok
         return

sequence_34:
# x
#     (MulOp)
#     (Factor)

         ast_push
         loc_push
         error_clear

         error_push

         call              sym_MulOp

         error_pop_merge
   fail! jump              failed_35
         error_push

         call              sym_Factor

         error_pop_merge
   fail! jump              failed_35

         ast_pop_discard
         loc_pop_discard
         return

failed_35:
         ast_pop_rewind
         loc_pop_rewind
         return
#
# value Symbol 'Factor'
#

sym_Factor:
# x
#     (Term)
#     *
#         x
#             (AddOp)
#             (Term)

         symbol_restore    Factor
  found! jump              found_60
         loc_push
         ast_push

         call              sequence_57

   fail! value_clear
     ok! value_reduce      Factor
         symbol_save       Factor
         error_nonterminal Factor
         ast_pop_rewind
         loc_pop_discard

found_60:
     ok! ast_value_push
         return

sequence_57:
# x
#     (Term)
#     *
#         x
#             (AddOp)
#             (Term)

         ast_push
         loc_push
         error_clear

         error_push

         call              sym_Term

         error_pop_merge
   fail! jump              failed_58
         error_push

         call              kleene_54

         error_pop_merge
   fail! jump              failed_58

         ast_pop_discard
         loc_pop_discard
         return

failed_58:
         ast_pop_rewind
         loc_pop_rewind
         return

kleene_54:
# *
#     x
#         (AddOp)
#         (Term)

         loc_push
         error_push

         call              sequence_51

         error_pop_merge
   fail! jump              failed_55
         loc_pop_discard
         jump              kleene_54

failed_55:
         loc_pop_rewind
         status_ok
         return

sequence_51:
# x
#     (AddOp)
#     (Term)

         ast_push
         loc_push
         error_clear

         error_push

         call              sym_AddOp

         error_pop_merge
   fail! jump              failed_52
         error_push

         call              sym_Term

         error_pop_merge
   fail! jump              failed_52

         ast_pop_discard
         loc_pop_discard
         return

failed_52:
         ast_pop_rewind
         loc_pop_rewind
         return
#
# value Symbol 'MulOp'
#

sym_MulOp:
# /
#     '*'
#     '/'

         symbol_restore    MulOp
  found! jump              found_67
         loc_push

         call              choice_65

   fail! value_clear
     ok! value_leaf        MulOp
         symbol_save       MulOp
         error_nonterminal MulOp
         loc_pop_discard

found_67:
     ok! ast_value_push
         return

choice_65:
# /
#     '*'
#     '/'

         error_clear

         loc_push
         error_push

         input_next        "t *"
     ok! test_char         "*"

         error_pop_merge
     ok! jump              oknoast_64

         loc_pop_rewind
         loc_push
         error_push

         input_next        "t /"
     ok! test_char         "/"

         error_pop_merge
     ok! jump              oknoast_64

         loc_pop_rewind
         status_fail
         return

oknoast_64:
         loc_pop_discard
         return
#
# value Symbol 'Number'
#

sym_Number:
# x
#     ?
#         (Sign)
#     +
#         (Digit)

         symbol_restore    Number
  found! jump              found_80
         loc_push
         ast_push

         call              sequence_77

   fail! value_clear
     ok! value_reduce      Number
         symbol_save       Number
         error_nonterminal Number
         ast_pop_rewind
         loc_pop_discard

found_80:
     ok! ast_value_push
         return

sequence_77:
# x
#     ?
#         (Sign)
#     +
#         (Digit)

         ast_push
         loc_push
         error_clear

         error_push

         call              optional_70

         error_pop_merge
   fail! jump              failed_78
         error_push

         call              poskleene_73

         error_pop_merge
   fail! jump              failed_78

         ast_pop_discard
         loc_pop_discard
         return

failed_78:
         ast_pop_rewind
         loc_pop_rewind
         return

optional_70:
# ?
#     (Sign)

         loc_push
         error_push

         call              sym_Sign

         error_pop_merge
   fail! loc_pop_rewind
     ok! loc_pop_discard
         status_ok
         return

poskleene_73:
# +
#     (Digit)

         loc_push

         call              sym_Digit

   fail! jump              failed_74

loop_75:
         loc_pop_discard
         loc_push
         error_push

         call              sym_Digit

         error_pop_merge
     ok! jump              loop_75
         status_ok

failed_74:
         loc_pop_rewind
         return
#
# value Symbol 'Sign'
#

sym_Sign:
# /
#     '-'
#     '+'

         symbol_restore    Sign
  found! jump              found_86
         loc_push

         call              choice_5

   fail! value_clear
     ok! value_leaf        Sign
         symbol_save       Sign
         error_nonterminal Sign
         loc_pop_discard

found_86:
     ok! ast_value_push
         return
#
# value Symbol 'Term'
#

sym_Term:
# (Number)

         symbol_restore    Term
  found! jump              found_89
         loc_push
         ast_push

         call              sym_Number

   fail! value_clear
     ok! value_reduce      Term
         symbol_save       Term
         error_nonterminal Term
         ast_pop_rewind
         loc_pop_discard

found_89:
     ok! ast_value_push
         return

#
#

.CE
.PP
.SH "PEG SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expression Grammars as immutable values for transport,
comparison, etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&.
While a PEG may have more than one regular serialization only exactly
one of them will be \fIcanonical\fR\&.
.TP
regular serialization
.RS
.IP [1]
The serialization of any PEG is a nested Tcl dictionary\&.
.IP [2]
This dictionary holds a single key, \fBpt::grammar::peg\fR, and its
value\&. This value holds the contents of the grammar\&.
.IP [3]
The contents of the grammar are a Tcl dictionary holding the set of
nonterminal symbols and the starting expression\&. The relevant keys and
their values are
.RS
.TP
\fBrules\fR
The value is a Tcl dictionary whose keys are the names of the
nonterminal symbols known to the grammar\&.
.RS
.IP [1]
Each nonterminal symbol may occur only once\&.
.IP [2]
The empty string is not a legal nonterminal symbol\&.
.IP [3]
The value for each symbol is a Tcl dictionary itself\&. The relevant
keys and their values in this dictionary are
.RS
.TP
\fBis\fR
The value is the serialization of the parsing expression describing
the symbols sentennial structure, as specified in the section
\fBPE serialization format\fR\&.
.TP
\fBmode\fR
The value can be one of three values specifying how a parser should
handle the semantic value produced by the symbol\&.
.RS
.TP
\fBvalue\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal itself,
which has the ASTs of the symbol's right hand side as its children\&.
.TP
\fBleaf\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal, without any
children\&. Any ASTs generated by the symbol's right hand side are
discarded\&.
.TP
\fBvoid\fR
The nonterminal has no semantic value\&. Any ASTs generated by the
symbol's right hand side are discarded (as well)\&.
.RE
.RE
.RE
.TP
\fBstart\fR
The value is the serialization of the start parsing expression of the
grammar, as specified in the section \fBPE serialization format\fR\&.
.RE
.IP [4]
The terminal symbols of the grammar are specified implicitly as the
set of all terminal symbols used in the start expression and on the
RHS of the grammar rules\&.
.RE
.TP
canonical serialization
The canonical serialization of a grammar has the format as specified
in the previous item, and then additionally satisfies the constraints
below, which make it unique among all the possible serializations of
this grammar\&.
.RS
.IP [1]
The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
\fBlsort -increasing -dict\fR\&.
.IP [2]
The string representation of the value is the canonical representation
of a Tcl dictionary\&. I\&.e\&. it does not contain superfluous whitespace\&.
.RE
.PP
.SS EXAMPLE
Assuming the following PEG for simple mathematical expressions
.PP
.CS


PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'       ;
    Sign       <- '-' / '+'                                     ;
    Number     <- Sign? Digit+                                  ;
    Expression <- Term (AddOp Term)*                            ;
    MulOp      <- '*' / '/'                                     ;
    Term       <- Factor (MulOp Factor)*                        ;
    AddOp      <- '+'/'-'                                       ;
    Factor     <- '(' Expression ')' / Number                   ;
END;

.CE
.PP
then its canonical serialization (except for whitespace) is
.PP
.CS


pt::grammar::peg {
    rules {
        AddOp      {is {/ {t -} {t +}}                                                                mode value}
        Digit      {is {/ {t 0} {t 1} {t 2} {t 3} {t 4} {t 5} {t 6} {t 7} {t 8} {t 9}}                mode value}
        Expression {is {x {n Term} {* {x {n AddOp} {n Term}}}}                                        mode value}
        Factor     {is {/ {x {t (} {n Expression} {t )}} {n Number}}                                  mode value}
        MulOp      {is {/ {t *} {t /}}                                                                mode value}
        Number     {is {x {? {n Sign}} {+ {n Digit}}}                                                 mode value}
        Sign       {is {/ {t -} {t +}}                                                                mode value}
        Term       {is {x {n Factor} {* {x {n MulOp} {n Factor}}}}                                    mode value}
    }
    start {n Expression}
}

.CE
.PP
.SH "PE SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expressions as immutable values for transport, comparison,
etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&.
While a parsing expression may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR\&.
.TP
Regular serialization
.RS
.TP
\fBAtomic Parsing Expressions\fR
.RS
.IP [1]
The string \fBepsilon\fR is an atomic parsing expression\&. It matches
the empty string\&.
.IP [2]
The string \fBdot\fR is an atomic parsing expression\&. It matches
any character\&.
.IP [3]
The string \fBalnum\fR is an atomic parsing expression\&. It matches
any Unicode alphabet or digit character\&. This is a custom extension of
PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [4]
The string \fBalpha\fR is an atomic parsing expression\&. It matches
any Unicode alphabet character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [5]
The string \fBascii\fR is an atomic parsing expression\&. It matches
any Unicode character below U0080\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [6]
The string \fBcontrol\fR is an atomic parsing expression\&. It matches
any Unicode control character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR\&.
.IP [7]
The string \fBdigit\fR is an atomic parsing expression\&. It matches
any Unicode digit character\&. Note that this includes characters
outside of the [0\&.\&.9] range\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [8]
The string \fBgraph\fR is an atomic parsing expression\&. It matches
any Unicode printing character, except for space\&. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [9]
The string \fBlower\fR is an atomic parsing expression\&. It matches
any Unicode lower-case alphabet character\&. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [10]
The string \fBprint\fR is an atomic parsing expression\&. It matches
any Unicode printing character, including space\&. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [11]
The string \fBpunct\fR is an atomic parsing expression\&. It matches
any Unicode punctuation character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [12]
The string \fBspace\fR is an atomic parsing expression\&. It matches
any Unicode space character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR\&.
.IP [13]
The string \fBupper\fR is an atomic parsing expression\&. It matches
any Unicode upper-case alphabet character\&. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [14]
The string \fBwordchar\fR is an atomic parsing expression\&. It
matches any Unicode word character\&. This is any alphanumeric character
(see alnum), and any connector punctuation characters (e\&.g\&.
underscore)\&. This is a custom extension of PEs based on Tcl's builtin
command \fBstring is\fR\&.
.IP [15]
The string \fBxdigit\fR is an atomic parsing expression\&. It matches
any hexadecimal digit character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [16]
The string \fBddigit\fR is an atomic parsing expression\&. It matches
any decimal digit character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBregexp\fR\&.
.IP [17]
The expression
[list t \fBx\fR]
is an atomic parsing expression\&. It matches the terminal string \fBx\fR\&.
.IP [18]
The expression
[list n \fBA\fR]
is an atomic parsing expression\&. It matches the nonterminal \fBA\fR\&.
.RE
.TP
\fBCombined Parsing Expressions\fR
.RS
.IP [1]
For parsing expressions \fBe1\fR, \fBe2\fR, \&.\&.\&. the result of
[list / \fBe1\fR \fBe2\fR \&.\&.\&. ]
is a parsing expression as well\&.
This is the \fIordered choice\fR, aka \fIprioritized choice\fR\&.
.IP [2]
For parsing expressions \fBe1\fR, \fBe2\fR, \&.\&.\&. the result of
[list x \fBe1\fR \fBe2\fR \&.\&.\&. ]
is a parsing expression as well\&.
This is the \fIsequence\fR\&.
.IP [3]
For a parsing expression \fBe\fR the result of
[list * \fBe\fR]
is a parsing expression as well\&.
This is the \fIkleene closure\fR, describing zero or more
repetitions\&.
.IP [4]
For a parsing expression \fBe\fR the result of
[list + \fBe\fR]
is a parsing expression as well\&.
This is the \fIpositive kleene closure\fR, describing one or more
repetitions\&.
.IP [5]
For a parsing expression \fBe\fR the result of
[list & \fBe\fR]
is a parsing expression as well\&.
This is the \fIand lookahead predicate\fR\&.
.IP [6]
For a parsing expression \fBe\fR the result of
[list ! \fBe\fR]
is a parsing expression as well\&.
This is the \fInot lookahead predicate\fR\&.
.IP [7]
For a parsing expression \fBe\fR the result of
[list ? \fBe\fR]
is a parsing expression as well\&.
This is the \fIoptional input\fR\&.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of a parsing expression has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this parsing expression\&.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list\&. I\&.e\&. it does not contain superfluous whitespace\&.
.IP [2]
Terminals are \fInot\fR encoded as ranges (where start and end of the
range are identical)\&.
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression shown on the right-hand side of the
rule
.PP
.CS


    Expression <- Term (AddOp Term)*

.CE
.PP
then its canonical serialization (except for whitespace) is
.PP
.CS


    {x {n Term} {* {x {n AddOp} {n Term}}}}

.CE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIpt\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
EBNF, LL(k), PARAM, PEG, TDPL, context-free languages, conversion, expression, format conversion, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, serialization, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
