/* <<< Start of information >>>                                             */
/* This file is part of the xcolmix package.                                */
/* Copyright (C) 1996  Karel Kubat. All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xcolmix.h"

void makecolor ()
{
    char
        buf [80];

                                        /* define colors to use */
    fl_mapcolor (FG_COL, fg_red, fg_green, fg_blue);
    fl_mapcolor (BG_COL, bg_red, bg_green, bg_blue);
    
    if (! logo)                         /* done when forms not yet on screen */
        return;


    /* make sure logo affects the colors */
    fl_redraw_object (logo);

    /* show hexadecimal color selection */
    fl_clear_browser (hexdisplay);         
    sprintf (buf, "Hex fg: #%2.2X%2.2X%2.2X\n", fg_red, fg_green, fg_blue);
    fl_add_browser_line (hexdisplay, buf);
    sprintf (buf, "Hex bg: #%2.2X%2.2X%2.2X\n", bg_red, bg_green, bg_blue);
    fl_add_browser_line (hexdisplay, buf);
    fl_redraw_object (hexdisplay);

    /* update rgb sliders */
    if (foreground_selected)
    {
	fl_set_slider_value (red_slider, fg_red);
	fl_set_slider_value (green_slider, fg_green);
	fl_set_slider_value (blue_slider, fg_blue);
    }
    else
    {
	fl_set_slider_value (red_slider, bg_red);
	fl_set_slider_value (green_slider, bg_green);
	fl_set_slider_value (blue_slider, bg_blue);
    }

    /* redraw rgb sliders */
    fl_redraw_object (red_slider);
    fl_redraw_object (green_slider);
    fl_redraw_object (blue_slider);
}
