## BEDOPS v2.4.35: high-performance genomic feature operations ##

[![Build Status](https://travis-ci.org/bedops/bedops.svg?branch=master)](https://travis-ci.org/bedops/bedops) [![GitHub stars](https://img.shields.io/github/stars/bedops/bedops.svg)](https://github.com/bedops/bedops/stargazers) [![Project license](https://img.shields.io/badge/license-GPLv2-blue.svg)](https://github.com/bedops/bedops/blob/master/LICENSE) [![Documentation Status](https://readthedocs.org/projects/bedops/badge/?version=latest)](https://readthedocs.org/projects/bedops/?badge=latest)

<!-- <img src="http://bedops.readthedocs.io/en/latest/_static/logo_with_label_v2.png" align="right" style="max-width:33%" /> -->

### About ###

**BEDOPS v2.4.35** is a suite of tools to address common questions raised in genomic studies — mostly with regard to overlap and proximity relationships between data sets. It aims to be scalable and flexible, facilitating the efficient and accurate analysis and management of large-scale genomic data. 

The <a href="https://bedops.readthedocs.io/en/latest/content/overview.html#overview">overview</a> section of the **BEDOPS v2.4.35** documentation summarizes the toolkit, functionality and performance enhancements. The <a href="https://bedops.readthedocs.io/en/latest/index.html#reference">reference</a> table offers documentation for all applications and scripts.


### Downloads ###

<table width="100%">
<tr>
<th width="33%" align="left">
<img src="https://bedops.readthedocs.io/en/latest/_images/linux_v2.png" height="26px" style="height:26px !important; width: auto !important; margin-bottom:10px;">
</th>
<th width="33%" align="left">
<img src="https://bedops.readthedocs.io/en/latest/_images/macosx_v2.png" height="26px" style="height:26px !important; width: auto !important; margin-bottom:10px;">
</th>
<th width="34%" align="left">
<img src="https://bedops.readthedocs.io/en/latest/_images/source_v2.png" height="26px" style="height:26px !important; width: auto !important; margin-bottom:10px;">
</th>
</tr>
<tr>
<td valign="top">
<ul style="list-style-type:square; font-size:smaller; margin-left:0; margin-right:0px; padding-right:0px; padding-left:20px;">
<li><a href="https://github.com/bedops/bedops/releases/download/v2.4.35/bedops_linux_x86_64-v2.4.35.tar.bz2">x86-64 (64-bit)</a> binaries</li>
<li><a href="http://bedops.readthedocs.io/en/latest/content/installation.html#linux">Installation instructions</a> for Linux hosts</li>
</ul>
</td>
<td valign="top">
<ul style="list-style-type:square; font-size:smaller; margin-left:0; margin-right:0px; padding-right:0px; padding-left:20px;">
<li><a href="https://github.com/bedops/bedops/releases/download/v2.4.35/BEDOPS.2.4.35.pkg.zip">Intel (64-bit, 10.10-10.13)</a> installer package</li>
<li><a href="http://bedops.readthedocs.io/en/latest/content/installation.html#mac-os-x">Installation instructions</a> for Mac OS X hosts</li>
</ul>
</td>
<td valign="top">
<ul style="list-style-type:square; font-size:smaller; margin-left:0; margin-right:0px; padding-right:0px; padding-left:20px;">
<li><a href="https://github.com/bedops/bedops/archive/v2.4.35.tar.gz">Source code</a> (tar.gz)</li>
<li><a href="https://github.com/bedops/bedops/archive/v2.4.35.zip">Source code</a> (zip)</li>
<li><a href="http://bedops.readthedocs.io/en/latest/content/installation.html#installation-via-source-code">Compilation instructions</a></li>
</ul>
</td>
</tr>
</table>

### Documentation ###

Complete documentation for **BEDOPS v2.4.35** tools is available at: <a href="https://bedops.readthedocs.io/en/latest/index.html">https://bedops.readthedocs.io/</a>

### Citation ###

If you use **BEDOPS v2.4.35** in your research, please cite the following manuscript:

> Shane Neph, M. Scott Kuehn, Alex P. Reynolds, et al.  
> [**BEDOPS: high-performance genomic feature operations**  
> *Bioinformatics* (2012) 28 (14): 1919-1920.] (http://bioinformatics.oxfordjournals.org/content/28/14/1919.abstract)

### Copyright ###

> Copyright (C) 2011-2018 Shane J. Neph, M. Scott Kuehn and Alex P. Reynolds
>
> Source code, documentation and media assets released under <a href="https://github.com/bedops/bedops/blob/master/LICENSE">GNU Public License Version 2</a> (GPL v2).

