/*
 * Copyright (C) 2015-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
	unsigned int in[10];
	unsigned int state;
	int running;
} NAME;

#endif /*STATE*/


#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)	    x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

enum NAME_(pin) {
	NAME_(SET),
	NAME_(SET_TRIG0),
	NAME_(SET_GATE0),
	NAME_(SET_TRIG1),
	NAME_(SET_GATE1),
	NAME_(RESET),
	NAME_(RESET_TRIG0),
	NAME_(RESET_GATE0),
	NAME_(RESET_TRIG1),
	NAME_(RESET_GATE1),
};

static void
NAME_(update)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->NAME.running = 0;

#if DEBUG
	fprintf(stderr, "%s(%p): %d\n", SNAME, &cpssp->NAME, cpssp->NAME.state);
#endif

	EVALUATOR(NAME, OUTP_OUT, out_set)(cpssp,
			cpssp->NAME.state ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
	EVALUATOR(NAME, OUTP_nOUT, out_set)(cpssp,
			cpssp->NAME.state ? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_1);
}

static void
NAME_(inN_set)(struct cpssp *cpssp, int n, unsigned int val)
{
	unsigned int state;

	switch (val) {
	case SIG_STD_LOGIC_L:
	case SIG_STD_LOGIC_0:
		val = SIG_STD_LOGIC_0;
		break;
	case SIG_STD_LOGIC_H:
	case SIG_STD_LOGIC_1:
		val = SIG_STD_LOGIC_1;
		break;
	case SIG_STD_LOGIC_U:
	case SIG_STD_LOGIC_X:
	case SIG_STD_LOGIC_Z:
		val = val;
		break;
	default:
		assert(0);
	}
	if (val == cpssp->NAME.in[n]) {
		return;
	}

	state = cpssp->NAME.state;

	switch (n) {
	case NAME_(SET):
		if (val != SIG_STD_LOGIC_1) {
			break;
		}
		state = 1;
		break;
	case NAME_(SET_TRIG0):
		if (cpssp->NAME.in[NAME_(SET)] == SIG_STD_LOGIC_1
		 || cpssp->NAME.in[NAME_(RESET)] == SIG_STD_LOGIC_1) {
			break;
		}
		if (cpssp->NAME.in[NAME_(SET_GATE0)] == SIG_STD_LOGIC_0
		 || val != SIG_STD_LOGIC_1) {
			break;
		}
		state = 1;
		break;
	case NAME_(SET_GATE0):
		break;
	case NAME_(SET_TRIG1):
		if (cpssp->NAME.in[NAME_(SET)] == SIG_STD_LOGIC_1
		 || cpssp->NAME.in[NAME_(RESET)] == SIG_STD_LOGIC_1) {
			break;
		}
		if (cpssp->NAME.in[NAME_(SET_GATE1)] == SIG_STD_LOGIC_0
		 || val != SIG_STD_LOGIC_1) {
			break;
		}
		state = 1;
		break;
	case NAME_(SET_GATE1):
		break;
	case NAME_(RESET):
		if (val != SIG_STD_LOGIC_1) {
			break;
		}
		state = 0;
		break;
	case NAME_(RESET_TRIG0):
		if (cpssp->NAME.in[NAME_(SET)] == SIG_STD_LOGIC_1
		 || cpssp->NAME.in[NAME_(RESET)] == SIG_STD_LOGIC_1) {
			break;
		}
		if (cpssp->NAME.in[NAME_(RESET_GATE0)] == SIG_STD_LOGIC_0
		 || val != SIG_STD_LOGIC_1) {
			break;
		}
		state = 0;
		break;
	case NAME_(RESET_GATE0):
		break;
	case NAME_(RESET_TRIG1):
		if (cpssp->NAME.in[NAME_(SET)] == SIG_STD_LOGIC_1
		 || cpssp->NAME.in[NAME_(RESET)] == SIG_STD_LOGIC_1) {
			break;
		}
		if (cpssp->NAME.in[NAME_(RESET_GATE1)] == SIG_STD_LOGIC_0
		 || val != SIG_STD_LOGIC_1) {
			break;
		}
		state = 0;
		break;
	case NAME_(RESET_GATE1):
		break;
	default:
		assert(0);
	}

#if DEBUG
    {
	int i;
	fprintf(stderr, "%s(%p):", SNAME, &cpssp->NAME);
	for (i = 0; i < 10; i++) {
	    switch (i) {
		case NAME_(SET): fprintf(stderr, " set:"); break;
		case NAME_(SET_TRIG0): fprintf(stderr, " set_trig0:"); break;
		case NAME_(SET_GATE0): fprintf(stderr, " set_gate0:"); break;
		case NAME_(SET_TRIG1): fprintf(stderr, " set_trig1:"); break;
		case NAME_(SET_GATE1): fprintf(stderr, " set_gate1:"); break;
		case NAME_(RESET): fprintf(stderr, " reset:"); break;
		case NAME_(RESET_TRIG0): fprintf(stderr, " reset_trig0:"); break;
		case NAME_(RESET_GATE0): fprintf(stderr, " reset_gate0:"); break;
		case NAME_(RESET_TRIG1): fprintf(stderr, " reset_trig1:"); break;
		case NAME_(RESET_GATE1): fprintf(stderr, " reset_gate1:"); break;
	    }
	    switch (cpssp->NAME.in[i]) {
		case SIG_STD_LOGIC_L:
		case SIG_STD_LOGIC_0:
		    fprintf(stderr, " 0");
		    break;
		case SIG_STD_LOGIC_H:
		case SIG_STD_LOGIC_1:
		    fprintf(stderr, " 1");
		    break;
		case SIG_STD_LOGIC_Z:
		    fprintf(stderr, " Z");
		    break;
		default:
		    fprintf(stderr, " %08x", cpssp->NAME.in[i]);
		    break;
	    }
	    if (i == n) {
		fprintf(stderr, "->");
		switch (val) {
		    case SIG_STD_LOGIC_L:
		    case SIG_STD_LOGIC_0:
			fprintf(stderr, "0");
			break;
		    case SIG_STD_LOGIC_H:
		    case SIG_STD_LOGIC_1:
			fprintf(stderr, "1");
			break;
		    case SIG_STD_LOGIC_Z:
			fprintf(stderr, "Z");
			break;
		    default:
			fprintf(stderr, "%08x", val);
			break;
		}
	    }
	}
	fprintf(stderr, " => %d\n", cpssp->NAME.state);
    }
#endif /* DEBUG */

	cpssp->NAME.in[n] = val;

	if (state == cpssp->NAME.state) {
		return;
	}
	cpssp->NAME.state = state;

	if (! cpssp->NAME.running) {
		cpssp->NAME.running = 1;
		time_call_after(TIME_HZ / 1000000, NAME_(update), cpssp);
	}
}

#ifdef INP_SR_TRIG
static void
EVALUATOR(NAME, INP_SR_TRIG, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(SET_TRIG0), val);
    NAME_(inN_set)(cpssp, NAME_(RESET_TRIG0), val);
}
#endif

#ifdef INP_SET
static void
EVALUATOR(NAME, INP_SET, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(SET), val);
}
#endif

#ifdef INP_SET_TRIG0
static void
EVALUATOR(NAME, INP_SET_TRIG0, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(SET_TRIG0), val);
}
#endif

#ifdef INP_SET_GATE0
static void
EVALUATOR(NAME, INP_SET_GATE0, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(SET_GATE0), val);
}
#endif

#ifdef INP_SET_TRIG1
static void
EVALUATOR(NAME, INP_SET_TRIG1, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(SET_TRIG1), val);
}
#endif

#ifdef INP_SET_GATE1
static void
EVALUATOR(NAME, INP_SET_GATE1, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(SET_GATE1), val);
}
#endif

#ifdef INP_RESET
static void
EVALUATOR(NAME, INP_RESET, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(RESET), val);
}
#endif

#ifdef INP_RESET_TRIG0
static void
EVALUATOR(NAME, INP_RESET_TRIG0, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(RESET_TRIG0), val);
}
#endif

#ifdef INP_RESET_GATE0
static void
EVALUATOR(NAME, INP_RESET_GATE0, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(RESET_GATE0), val);
}
#endif

#ifdef INP_RESET_TRIG1
static void
EVALUATOR(NAME, INP_RESET_TRIG1, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(RESET_TRIG1), val);
}
#endif

#ifdef INP_RESET_GATE1
static void
EVALUATOR(NAME, INP_RESET_GATE1, in_set)(struct cpssp *cpssp, unsigned int val)
{
    NAME_(inN_set)(cpssp, NAME_(RESET_GATE1), val);
}
#endif

static void
NAME_(create)(struct cpssp *cpssp)
{
    int i;

    for (i = 0; i < 10; i++) {
	cpssp->NAME.in[i] = SIG_STD_LOGIC_Z;
    }
    cpssp->NAME.state = 0;
    cpssp->NAME.running = 0;

    EVALUATOR(NAME, OUTP_OUT, out_set)(cpssp,
				       cpssp->NAME.state ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    EVALUATOR(NAME, OUTP_nOUT, out_set)(cpssp,
					cpssp->NAME.state ? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_1);

    if (0) {
	/* Just to make gcc happy... */
#ifdef INP_SR_TRIG
	EVALUATOR(NAME, INP_SR_TRIG, in_set)(cpssp, 0);
#endif
#ifdef INP_SET
	EVALUATOR(NAME, INP_SET, in_set)(cpssp, 0);
#endif
#ifdef INP_SET_TRIG0
	EVALUATOR(NAME, INP_SET_TRIG0, in_set)(cpssp, 0);
#endif
#ifdef INP_SET_GATE0
	EVALUATOR(NAME, INP_SET_GATE0, in_set)(cpssp, 0);
#endif
#ifdef INP_SET_TRIG1
	EVALUATOR(NAME, INP_SET_TRIG1, in_set)(cpssp, 0);
#endif
#ifdef INP_SET_GATE1
	EVALUATOR(NAME, INP_SET_GATE1, in_set)(cpssp, 0);
#endif
#ifdef INP_RESET
	EVALUATOR(NAME, INP_RESET, in_set)(cpssp, 0);
#endif
#ifdef INP_RESET_TRIG0
	EVALUATOR(NAME, INP_RESET_TRIG0, in_set)(cpssp, 0);
#endif
#ifdef INP_RESET_GATE0
	EVALUATOR(NAME, INP_RESET_GATE0, in_set)(cpssp, 0);
#endif
#ifdef INP_RESET_TRIG1
	EVALUATOR(NAME, INP_RESET_TRIG1, in_set)(cpssp, 0);
#endif
#ifdef INP_RESET_GATE1
	EVALUATOR(NAME, INP_RESET_GATE1, in_set)(cpssp, 0);
#endif
    }
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#undef PASTER
#undef EVALUATOR

#endif /*BEHAVIOUR*/
