/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include "glue.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-text-control.h"
#include "sig_integer.h"
#include "sig_manage.h"
#include "sig_std_logic.h"

typedef struct {
	GtkVBoxClass parent_class;

} GuiGtkTextControlClass;

enum{
	VALUE_CHANGED_GUI,
	GUI_GTK_TEXT_CONTROL_LAST_SIGNAL
};

static guint gui_gtk_text_control_signals[GUI_GTK_TEXT_CONTROL_LAST_SIGNAL] = { 0 };

static void
gui_gtk_text_control_class_init(GuiGtkTextControlClass *class)
{	
    gui_gtk_text_control_signals[VALUE_CHANGED_GUI] =
	g_signal_new("value-changed-gui",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

}

static void
on_text_changed(GtkComboBox *widget, void *_text_control)
{

	GuiGtkTextControl *text_control = _text_control;
	g_signal_emit(G_OBJECT(text_control),
			gui_gtk_text_control_signals[VALUE_CHANGED_GUI], 0);
}

static void
gui_gtk_text_control_init(GuiGtkTextControl *text_control)
{
}

GType
gui_gtk_text_control_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkTextControlClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_text_control_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkTextControl),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_text_control_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_HBOX,
				"TextControl", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKTEXTCONTROL_TYPE gui_gtk_text_control_get_type()

GtkWidget *
gui_gtk_text_control_new(const char *desc)
{
	GtkWidget *vbox;
	GuiGtkTextControl *text_control;
	GtkEntry *entry;
	
	text_control = GUI_GTK_TEXT_CONTROL(g_object_new(GUIGTKTEXTCONTROL_TYPE, NULL));
	
	vbox = gtk_vbox_new(FALSE, 1);
	
	text_control->title_label = gtk_label_new(desc);
	text_control->value_label = gtk_label_new("");
	entry = GTK_ENTRY(gtk_entry_new());
	gtk_entry_set_width_chars(entry, 10);
	
	g_signal_connect (entry,
		    "activate",
		    G_CALLBACK (on_text_changed),
		    text_control);

	text_control->entry = GTK_WIDGET(entry);	
	
	gtk_box_pack_start(GTK_BOX(vbox), 
				text_control->title_label, 
				FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), 
				text_control->entry, 
				FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), 
				text_control->value_label, 
				FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(text_control), 
				vbox, 
				FALSE, FALSE, 1);
	gtk_widget_show(text_control->title_label);
	gtk_widget_show(text_control->entry);
	gtk_widget_show(text_control->value_label);
	gtk_widget_show(vbox);
	gtk_widget_show(GTK_WIDGET(text_control));	
	on_text_changed(NULL, text_control); 
	return GTK_WIDGET(text_control);
}

void
gui_gtk_text_control_set_value(gpointer _text_control, const char *value_string)
{
	GuiGtkTextControl *text_control;
	text_control = _text_control;
	gtk_label_set_text(GTK_LABEL(text_control->value_label), value_string);
	gtk_entry_set_text(GTK_ENTRY(text_control->entry), "");
}

void
gui_gtk_text_control_destroy(gpointer _text_control)
{
	/*
	GuiGtkTextControl *text_control; 
	text_control = (GuiGtkTextControl*) _text_control;
	*/
	
}
