/*
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_shugart_bus.h"

/* Controller -> Drive */
void
sig_shugart_bus_writeid(struct sig_shugart_bus *b, void *s,
		unsigned char cyl, unsigned char sec)
{
	unsigned int nr;

	assert(b);

	for (nr = 0; nr < b->nmembers; nr++) {
		void (*func)(void *, unsigned char, unsigned char);

		func = b->member[nr].f->writeid;
		if (func) {
			func(b->member[nr].s, cyl, sec);
		}
	}
}

void
sig_shugart_bus_writedata(
	struct sig_shugart_bus *b,
	void *s,
	unsigned char *buf,
	unsigned int bufsize
)
{
	unsigned int nr;

	assert(b);

	for (nr = 0; nr < b->nmembers; nr++) {
		void (*func)(void *, unsigned char *, unsigned int);

		func = b->member[nr].f->writedata;
		if (func) {
			func(b->member[nr].s, buf, bufsize);
		}
	}
}

void
sig_shugart_bus_read_start(struct sig_shugart_bus *b, void *s)
{
	unsigned int nr;

	assert(b);

	for (nr = 0; nr < b->nmembers; nr++) {
		void (*func)(void *);

		func = b->member[nr].f->read_start;
		if (func) {
			func(b->member[nr].s);
		}
	}
}

/* Drive -> Controller */

void
sig_shugart_bus_readid(
	struct sig_shugart_bus *b,
	void *s,
	unsigned char cyl,
	unsigned char sec
)
{
	unsigned int nr;

	assert(b);

	for (nr = 0; nr < b->nmembers; nr++) {
		void (*func)(void *, unsigned char, unsigned char);

		func = b->member[nr].f->readid;
		if (func) {
			func(b->member[nr].s, cyl, sec);
		}
	}
}

void
sig_shugart_bus_readdata(
	struct sig_shugart_bus *b,
	void *s,
	unsigned char *buf,
	unsigned int bufsize
)
{
	unsigned int nr;

	assert(b);

	for (nr = 0; nr < b->nmembers; nr++) {
		void (*func)(void *, unsigned char *, unsigned int);

		func = b->member[nr].f->readdata;
		if (func) {
			func(b->member[nr].s, buf, bufsize);
		}
	}
}

void
sig_shugart_bus_connect(
	struct sig_shugart_bus *b,
	void *s,
	const struct sig_shugart_bus_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_SHUGART_BUS);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_shugart_bus_merge *
sig_shugart_bus_merge(struct sig_shugart_bus *s0, struct sig_shugart_bus *s1)
{
	fixme();
	return NULL;
}

void
sig_shugart_bus_split(struct sig_shugart_bus_merge *m)
{
	fixme();
}

struct sig_shugart_bus *
sig_shugart_bus_create(const char *name)
{
	struct sig_shugart_bus *b;

	b = shm_alloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_SHUGART_BUS;
	b->nmembers = 0;

	return b;
}

void
sig_shugart_bus_destroy(struct sig_shugart_bus *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_SHUGART_BUS);

	shm_free(sig);
}

void
sig_shugart_bus_suspend(struct sig_shugart_bus *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_shugart_bus_resume(struct sig_shugart_bus *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
