/* $Id: localio.c,v 1.5 2003/06/01 10:21:20 sjoerd Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>

#include "global.h"
#include "localio.h"
#include "list.h"

Local_io *new_local_io(uint32_t players) {
	Local_io *io;
	
	io = malloc(sizeof(Local_io));
	io->numplayers = players;
	io->events = calloc(players, sizeof(uint32_t));
	io->key_actions = new_list();

	return io;
}

void del_local_io(Local_io *io) {
  Key_Action *key;
  while ((key = list_pop(io->key_actions)) != NULL) {
      free(key);
  }
	del_list(io->key_actions);
	free(io->events);
	free(io);

	return;
}

void local_io_register_key(Local_io *io, SDLKey key,
		uint32_t player, uint32_t action) {
	Key_Action *key_action;
	key_action = malloc(sizeof(Key_Action));
	key_action->player = player;
	key_action->key = key;
	key_action->action = action;
	
	list_append(io->key_actions, key_action);
}

static int cmp_key(void *key_action, void *key) {
	if(((Key_Action*)key_action)->key == ((SDL_KeyboardEvent*)key)->keysym.sym) {
		return TRUE;
	}
	return FALSE;
}

static void handle_event(Local_io *io, SDL_KeyboardEvent key) {
	Key_Action *key_action = 
		(Key_Action*) list_search(io->key_actions, cmp_key, &key);

	if(key_action != NULL) {
		if(key.type==SDL_KEYDOWN)
			io->events[key_action->player] |= key_action->action;
		else if(key.type==SDL_KEYUP)
			io->events[key_action->player] &= ~(key_action->action);
	}
	
	return;
}

void local_io_update(Local_io *io) {
	SDL_Event event;
	
	while(SDL_PollEvent(&event)) {
		switch(event.type) {
			case SDL_KEYDOWN:
			case SDL_KEYUP:
				handle_event(io, event.key);
				break;
			default:
				break;
		}
	}
	return;
}

uint32_t local_io_get_events(Local_io *io, uint32_t player) {
	return io->events[player];
}
