package CParse::Parser::Token::Integer;

use 5.6.0;
use strict;
use warnings;

use Math::BigInt;
use CParse::Integer;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $str = shift;
    my $line = shift;
    my $pos = shift;

    my $number;

    if ($str =~ /^0[0-7]/)
      {
        # Math::BigInt unhelpfully does not support octal
        $number = Math::BigInt->bzero();
        # Kill the leading zero
        substr($str, 0, 1, '');
        # Put the pesky thing together by hand
        while (length $str)
          {
            my $digit = substr($str, 0, 1, '');
            $number *= 8;
            $number += $digit;
          }
      }
    else
      {
        $number = Math::BigInt->new($str);
      }

    my $self = {value => $number,
                line => $line,
                pos => $pos,
               };
    bless $self, $class;
    return $self;
  }

sub line
  {
    my $self = shift;
    return $self->{line};
  }

sub pos
  {
    my $self = shift;
    return $self->{pos};
  }

sub dump_c
  {
    my $self = shift;

    return $self->{value};
  }

sub process
  {
    my $self = shift;

    return new CParse::Integer $self->{value};
  }

1;
