#    Copyright (C) 2013 Ahmet Öztürk (aoz_2@yahoo.com)
#
#    This file is part of Lifeograph.
#
#    Lifeograph is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Lifeograph is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.


include( ${CMAKE_SOURCE_DIR}/cmake/definitions.cmake )

if( EXISTS ${CMAKE_SOURCE_DIR}/.bzr )
	if( EXISTS ${LOCAL_INCL_DIR}/rev_no.h )
		file( READ ${LOCAL_INCL_DIR}/rev_no.h rev_no_content )
	endif()

	execute_process( COMMAND bzr revno OUTPUT_VARIABLE REVISION_NO )
	string( REGEX REPLACE \n "" REVISION_NO "${REVISION_NO}" )
	#message( "Building revision ${REVISION_NO}" )

	if( NOT ( ${rev_no_content} MATCHES "#define REVISION_NO \" r${REVISION_NO}\"" ) )
		file( WRITE ${LOCAL_INCL_DIR}/rev_no.h "#define REVISION_NO \" r${REVISION_NO}\"" )
	endif()
endif()

# BUILD TIME STAMP
set( TS_REQUIRED NO )

if( EXISTS "${BIN_DIR}/${PACKAGE_NAME}" )
    execute_process( COMMAND stat -c %Y "${BIN_DIR}/${PACKAGE_NAME}" OUTPUT_VARIABLE MODIFIED_BIN )

    file( GLOB src_files src/*.* )
    foreach( src_file ${src_files} )
        execute_process( COMMAND stat -c %Y ${src_file} OUTPUT_VARIABLE MODIFIED_SRC )
        if( MODIFIED_BIN LESS MODIFIED_SRC )
            set( TS_REQUIRED YES )
            break()
        endif()
    endforeach()
else()
    set( TS_REQUIRED YES )
endif()

if( TS_REQUIRED )
    execute_process( COMMAND date "+%Y-%m-%d  %H-%M-%S" OUTPUT_VARIABLE BUILD_TIMESTAMP )
    string( REGEX REPLACE \n "" BUILD_TIMESTAMP "${BUILD_TIMESTAMP}" )
    file( WRITE ${LOCAL_INCL_DIR}/build_time.h "#define BUILD_TIMESTAMP \" ${BUILD_TIMESTAMP}\"" )
endif()

