/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * PanelOptionsVisual.java
 *
 * Created on Mar 13, 2009, 3:28:57 PM
 */

package org.netbeans.modules.groovy.grailsproject.ui.wizards.impl;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.NbBundle;

/**
 *
 * @author Petr Hejl
 */
public class PanelOptionsVisual extends SettingsPanel implements ChangeListener {

    private PanelConfigureProject panel;

    /** Creates new form PanelOptionsVisual */
    public PanelOptionsVisual(PanelConfigureProject panel) {
        initComponents();
        this.panel = panel;
    }

    @Override
    void read(WizardDescriptor settings) {
        GrailsPlatform.getDefault().addChangeListener(this);
    }

    @Override
    void store(WizardDescriptor settings) {
        GrailsPlatform.getDefault().removeChangeListener(this);
    }

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        if(!GrailsPlatform.getDefault().isConfigured()) {
            wizardDescriptor.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE,
                NbBundle.getMessage(PanelOptionsVisual.class,
                "NewGrailsProjectWizardIterator.NoGrailsServerConfigured"));
            return false;
        }
        return true;
    }

    @Override
    void validate(WizardDescriptor settings) throws WizardValidationException {
        // nothing to validate
    }

    public void stateChanged(ChangeEvent e) {
        panel.fireChangeEvent();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        configureButton = new javax.swing.JButton();

        org.openide.awt.Mnemonics.setLocalizedText(configureButton, org.openide.util.NbBundle.getMessage(PanelOptionsVisual.class, "PanelOptionsVisual.configureButton.text")); // NOI18N
        configureButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                configureButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(configureButton)
                .addContainerGap(246, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(configureButton)
                .addContainerGap(75, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void configureButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_configureButtonActionPerformed
        // TODO add your handling code here:
        OptionsDisplayer.getDefault().open(GroovySettings.GROOVY_OPTIONS_CATEGORY);
    }//GEN-LAST:event_configureButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton configureButton;
    // End of variables declaration//GEN-END:variables

}
