.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_lo_write n "March 2018" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_lo_write \- write to a large object
.SH SYNOPSIS
.nf

pg_lo_write \*(T<conn\*(T> \*(T<descriptor\*(T> \*(T<buf\*(T> \*(T<len\*(T>
.fi
.SH DESCRIPTION
\*(T<\fBpg_lo_write\fR\*(T> writes at most
\*(T<len\*(T> bytes from a variable
\*(T<buf\*(T> to a large object.
.SH ARGUMENTS
.TP 
\*(T<conn\*(T>
The handle of a connection to the database in which the large object
exists.
.TP 
\*(T<descriptor\*(T>
A descriptor for the large object from
\*(T<\fBpg_lo_open\fR\*(T>.
.TP 
\*(T<buf\*(T>
The string to write to the large object (not a variable name,
but the value itself).
.TP 
\*(T<len\*(T>
The maximum number of bytes to write. The number written will
be the smaller of this value and the length of the string.
.SH "RETURN VALUE"
The number of bytes actually written is returned; this will ordinarily
be the same as the number requested.
In event of an error, the return value is negative.
