# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureBlobFileSystemReference(Model):
    """Provides required information, for the service to be able to mount Azure
    Blob Storage container on the cluster nodes.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. Name of the Azure Blob Storage account.
    :type account_name: str
    :param container_name: Required. Name of the Azure Blob Storage container
     to mount on the cluster.
    :type container_name: str
    :param credentials: Required. Information of the Azure Blob Storage
     account credentials.
    :type credentials: ~azure.mgmt.batchai.models.AzureStorageCredentialsInfo
    :param relative_mount_path: Required. Specifies the relative path on the
     compute node where the Azure Blob file system will be mounted. Note that
     all cluster level blob file systems will be mounted under
     $AZ_BATCHAI_MOUNT_ROOT location and all job level blob file systems will
     be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
    :type relative_mount_path: str
    :param mount_options: Specifies the various mount options that can be used
     to configure Blob file system.
    :type mount_options: str
    """

    _validation = {
        'account_name': {'required': True},
        'container_name': {'required': True},
        'credentials': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'AzureStorageCredentialsInfo'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureBlobFileSystemReference, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.credentials = kwargs.get('credentials', None)
        self.relative_mount_path = kwargs.get('relative_mount_path', None)
        self.mount_options = kwargs.get('mount_options', None)
