# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectToSourceNonSqlTaskOutput(Model):
    """Output for connect to Oracle, MySQL type source.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Result identifier
    :vartype id: str
    :ivar source_server_brand_version: Server brand version
    :vartype source_server_brand_version: str
    :ivar server_properties: Server properties
    :vartype server_properties:
     ~azure.mgmt.datamigration.models.ServerProperties
    :ivar databases: List of databases on the server
    :vartype databases: list[str]
    :ivar validation_errors: Validation errors associated with the task
    :vartype validation_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'server_properties': {'readonly': True},
        'databases': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'server_properties': {'key': 'serverProperties', 'type': 'ServerProperties'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(self, **kwargs):
        super(ConnectToSourceNonSqlTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.source_server_brand_version = None
        self.server_properties = None
        self.databases = None
        self.validation_errors = None
