# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ComplianceSegment(Model):
    """A segment of a compliance assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar segment_type: The segment type, e.g. compliant, non-compliance,
     insufficient coverage, N/A, etc.
    :vartype segment_type: str
    :ivar percentage: The size (%) of the segment.
    :vartype percentage: float
    """

    _validation = {
        'segment_type': {'readonly': True},
        'percentage': {'readonly': True},
    }

    _attribute_map = {
        'segment_type': {'key': 'segmentType', 'type': 'str'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ComplianceSegment, self).__init__(**kwargs)
        self.segment_type = None
        self.percentage = None
