% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodist.R
\name{step_geodist}
\alias{step_geodist}
\alias{tidy.step_geodist}
\title{Distance between two locations}
\usage{
step_geodist(recipe, lat = NULL, lon = NULL, role = "predictor",
  trained = FALSE, ref_lat = NULL, ref_lon = NULL, log = FALSE,
  name = "geo_dist", columns = NULL, skip = FALSE,
  id = rand_id("geodist"))

\method{tidy}{step_geodist}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{lon, lat}{Selector functions to choose which variables are
affected by the step. See selections() for more details.}

\item{role}{or model term created by this step, what analysis
role should be assigned?. By default, the function assumes
that resulting distance will be used as a predictor in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{ref_lon, ref_lat}{Single numeric values for the location
of the reference point.}

\item{log}{A logical: should the distance be transformed by
the natural log function?}

\item{name}{A single character value to use for the new
predictor column. If a column exists with this name, an error is
issued.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_geodist} object.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any). For the \code{tidy}
method, a tibble with columns echoing the values of \code{lat},
\code{lon}, \code{ref_lat}, \code{ref_lon}, \code{name}, and \code{id}.
}
\description{
\code{step_geodist} creates a a \emph{specification} of a
recipe step that will calculate the distance between
points on a map to a reference location.
}
\details{
\code{step_geodist} will create a
}
\examples{

data(Smithsonian)

# How close are the museums to Union Station?
near_station <- recipe( ~ ., data = Smithsonian) \%>\%
  update_role(name, new_role = "location") \%>\%
  step_geodist(lat = latitude, lon = longitude, log = FALSE,
               ref_lat = 38.8986312, ref_lon = -77.0062457) \%>\%
  prep(training = Smithsonian, retain = TRUE)

juice(near_station) \%>\%
  arrange(geo_dist)

tidy(near_station, number = 1)
}
\concept{preprocessing}
\keyword{datagen}
