% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nbnid.R
\name{get_nbnid}
\alias{get_nbnid}
\alias{as.nbnid}
\alias{as.nbnid.nbnid}
\alias{as.nbnid.character}
\alias{as.nbnid.list}
\alias{as.nbnid.data.frame}
\alias{as.data.frame.nbnid}
\alias{get_nbnid_}
\title{Get the UK National Biodiversity Network ID from taxonomic names.}
\usage{
get_nbnid(name, ask = TRUE, messages = TRUE, rec_only = FALSE,
  rank = NULL, rows = NA, ...)

as.nbnid(x, check = TRUE)

\method{as.nbnid}{nbnid}(x, check = TRUE)

\method{as.nbnid}{character}(x, check = TRUE)

\method{as.nbnid}{list}(x, check = TRUE)

\method{as.nbnid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{nbnid}(x, ...)

get_nbnid_(name, messages = TRUE, rec_only = FALSE, rank = NULL,
  rows = NA, ...)
}
\arguments{
\item{name}{character; scientific name.}

\item{ask}{logical; should get_nbnid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{messages}{logical; If TRUE the actual taxon queried is printed on the
console.}

\item{rec_only}{(logical) If \code{TRUE} ids of recommended names are
returned (i.e. synonyms are removed). Defaults to \code{FALSE}. Remember,
the id of a synonym is a taxa with 'recommended' name status.}

\item{rank}{(character) If given, we attempt to limit the results to those
taxa with the matching rank.}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all
rows are considered. Note that this function still only gives back a nbnid
class object with one to many identifiers. See
\code{\link[taxize]{get_nbnid_}} to get back all, or a subset, of the raw
data that you are presented during the ask process.}

\item{...}{Further args passed on to \code{nbn_search}}

\item{x}{Input to \code{\link{as.nbnid}}}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link{as.nbnid}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions

an object of class nbnid, a light wrapper around a character
string that is the taxonomic ID - includes attributes with relavant
metadata
}
\description{
Get the UK National Biodiversity Network ID from taxonomic names.
}
\examples{
\dontrun{
get_nbnid(name='Poa annua')
get_nbnid(name='Poa annua', rec_only=TRUE)
get_nbnid(name='Poa annua', rank='Species')
get_nbnid(name='Poa annua', rec_only=TRUE, rank='Species')
get_nbnid(name='Pinus contorta')

# The NBN service handles common names too
get_nbnid(name='red-winged blackbird')

# specify rows to limit choices available
get_nbnid('Poa annua')
get_nbnid('Poa annua', rows=1)
get_nbnid('Poa annua', rows=25)
get_nbnid('Poa annua', rows=1:2)

# When not found
get_nbnid(name="uaudnadndj")
get_nbnid(c("Zootoca vivipara", "uaudnadndj"))
get_nbnid(c("Zootoca vivipara","Chironomus riparius", "uaudnadndj"))

# Convert an nbnid without class information to a nbnid class
as.nbnid(get_nbnid("Zootoca vivipara")) # already a nbnid, returns the same
as.nbnid(get_nbnid(c("Zootoca vivipara","Pinus contorta"))) # same
as.nbnid('NHMSYS0001706186') # character
# character vector, length > 1
as.nbnid(c("NHMSYS0001706186","NHMSYS0000494848","NBNSYS0000010867"))
# list
as.nbnid(list("NHMSYS0001706186","NHMSYS0000494848","NBNSYS0000010867"))
## dont check, much faster
as.nbnid('NHMSYS0001706186', check=FALSE)
as.nbnid(list("NHMSYS0001706186","NHMSYS0000494848","NBNSYS0000010867"),
  check=FALSE)

(out <- as.nbnid(c("NHMSYS0001706186","NHMSYS0000494848",
  "NBNSYS0000010867")))
data.frame(out)
as.nbnid( data.frame(out) )

# Get all data back
get_nbnid_("Zootoca vivipara")
get_nbnid_("Poa annua", rows=2)
get_nbnid_("Poa annua", rows=1:2)
get_nbnid_(c("asdfadfasd","Pinus contorta"), rows=1:5)

# use curl options
invisible(get_nbnid("Quercus douglasii", verbose = TRUE))
}
}
\references{
<https://api.nbnatlas.org/>
}
\seealso{
\code{\link[taxize]{classification}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_ids}},
  \code{\link{get_iucn}}, \code{\link{get_natservid}},
  \code{\link{get_tolid}}, \code{\link{get_tpsid}},
  \code{\link{get_tsn}}, \code{\link{get_uid}},
  \code{\link{get_wiki}}, \code{\link{get_wormsid}}

Other nbn: \code{\link{nbn_classification}},
  \code{\link{nbn_search}}, \code{\link{nbn_synonyms}}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\concept{nbn}
\concept{taxonomic-ids}
