//filter_quantify.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2019
 *
 *  This file is part of libroardsp a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroardsp is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "libroardsp.h"

int roardsp_quantify_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id) {

 (void)stream, (void)id;

 roardsp_filter_reset(filter, ROARDSP_RESET_FULL);

 return 0;
}

static inline int16_t _calc(int16_t val, void * inst) {
 register float s = val;
 s       /= 32768;
 s       *= (ROAR_INSTINT)inst;
 s        = (int16_t)s;
 s       /= (ROAR_INSTINT)inst;
 s       *= 32768;
 return s;
}

#define _calcX(bits,rshift,lshift,ibits) \
/* this code is buggy for 8 bit filters */ \
int roardsp_quantify_calc##bits  (struct roardsp_filter * filter, void * data, size_t samples) { \
 int##bits##_t * samp = (int##bits##_t *) data; \
 size_t i; \
\
 for (i = 0; i < samples; i++) { \
  samp[i]  = (int##ibits##_t)_calc((int##ibits##_t)samp[i] rshift, filter->inst) lshift; \
 } \
\
 ROAR_DBG("roardsp_quantify_calc%i(*) = 0", bits); \
 return 0; \
}

/* look at our nice parameters ;) */
_calcX(8,<< 8,>> 8,16)
_calcX(16,,,16)
_calcX(32,>> 16,<< 16,32)

int roardsp_quantify_ctl   (struct roardsp_filter * filter, int cmd, void * data) {
 int32_t old;

 if ( cmd == ROARDSP_FCTL_N ) {
  old = (ROAR_INSTINT)filter->inst;
  filter->inst = (void*)(ROAR_INSTINT)*(int32_t*)data;
  *(int32_t*)data = old;
 } else {
  ROAR_DBG("roardsp_quantify_ctl(*) = -1");
  return -1;
 }


 ROAR_DBG("roardsp_quantify_ctl(*) = 0");
 return 0;
}

int roardsp_quantify_reset (struct roardsp_filter * filter, int what) {
 int n = 64;

 if ( filter == NULL )
  return -1;

 switch (what) {
  case ROARDSP_RESET_NONE:
  case ROARDSP_RESET_STATE:
    return  0;
   break;
  case ROARDSP_RESET_FULL:
    roardsp_quantify_ctl(filter, ROARDSP_FCTL_N, &n);
    return  0;
   break;
  default:
    return -1;
 }

 return -1;
}

//ll
