// run-rustfix

#![warn(clippy::or_fun_call)]
#![allow(dead_code)]
#![allow(clippy::unnecessary_wraps)]

use std::collections::BTreeMap;
use std::collections::HashMap;
use std::time::Duration;

/// Checks implementation of the `OR_FUN_CALL` lint.
fn or_fun_call() {
    struct Foo;

    impl Foo {
        fn new() -> Foo {
            Foo
        }
    }

    struct FakeDefault;
    impl FakeDefault {
        fn default() -> Self {
            FakeDefault
        }
    }

    impl Default for FakeDefault {
        fn default() -> Self {
            FakeDefault
        }
    }

    enum Enum {
        A(i32),
    }

    fn make<T>() -> T {
        unimplemented!();
    }

    let with_enum = Some(Enum::A(1));
    with_enum.unwrap_or(Enum::A(5));

    let with_const_fn = Some(Duration::from_secs(1));
    with_const_fn.unwrap_or(Duration::from_secs(5));

    let with_constructor = Some(vec![1]);
    with_constructor.unwrap_or(make());

    let with_new = Some(vec![1]);
    with_new.unwrap_or(Vec::new());

    let with_const_args = Some(vec![1]);
    with_const_args.unwrap_or(Vec::with_capacity(12));

    let with_err: Result<_, ()> = Ok(vec![1]);
    with_err.unwrap_or(make());

    let with_err_args: Result<_, ()> = Ok(vec![1]);
    with_err_args.unwrap_or(Vec::with_capacity(12));

    let with_default_trait = Some(1);
    with_default_trait.unwrap_or(Default::default());

    let with_default_type = Some(1);
    with_default_type.unwrap_or(u64::default());

    let self_default = None::<FakeDefault>;
    self_default.unwrap_or(<FakeDefault>::default());

    let real_default = None::<FakeDefault>;
    real_default.unwrap_or(<FakeDefault as Default>::default());

    let with_vec = Some(vec![1]);
    with_vec.unwrap_or(vec![]);

    let without_default = Some(Foo);
    without_default.unwrap_or(Foo::new());

    let mut map = HashMap::<u64, String>::new();
    map.entry(42).or_insert(String::new());

    let mut map_vec = HashMap::<u64, Vec<i32>>::new();
    map_vec.entry(42).or_insert(vec![]);

    let mut btree = BTreeMap::<u64, String>::new();
    btree.entry(42).or_insert(String::new());

    let mut btree_vec = BTreeMap::<u64, Vec<i32>>::new();
    btree_vec.entry(42).or_insert(vec![]);

    let stringy = Some(String::from(""));
    let _ = stringy.unwrap_or("".to_owned());

    let opt = Some(1);
    let hello = "Hello";
    let _ = opt.ok_or(format!("{} world.", hello));

    // index
    let map = HashMap::<u64, u64>::new();
    let _ = Some(1).unwrap_or(map[&1]);
    let map = BTreeMap::<u64, u64>::new();
    let _ = Some(1).unwrap_or(map[&1]);
    // don't lint index vec
    let vec = vec![1];
    let _ = Some(1).unwrap_or(vec[1]);
}

struct Foo(u8);
struct Bar(String, Duration);
#[rustfmt::skip]
fn test_or_with_ctors() {
    let opt = Some(1);
    let opt_opt = Some(Some(1));
    // we also test for const promotion, this makes sure we don't hit that
    let two = 2;

    let _ = opt_opt.unwrap_or(Some(2));
    let _ = opt_opt.unwrap_or(Some(two));
    let _ = opt.ok_or(Some(2));
    let _ = opt.ok_or(Some(two));
    let _ = opt.ok_or(Foo(2));
    let _ = opt.ok_or(Foo(two));
    let _ = opt.or(Some(2));
    let _ = opt.or(Some(two));

    let _ = Some("a".to_string()).or(Some("b".to_string()));

    let b = "b".to_string();
    let _ = Some(Bar("a".to_string(), Duration::from_secs(1)))
        .or(Some(Bar(b, Duration::from_secs(2))));

    let vec = vec!["foo"];
    let _ = opt.ok_or(vec.len());

    let array = ["foo"];
    let _ = opt.ok_or(array.len());

    let slice = &["foo"][..];
    let _ = opt.ok_or(slice.len());

    let string = "foo";
    let _ = opt.ok_or(string.len());
}

// Issue 4514 - early return
fn f() -> Option<()> {
    let a = Some(1);
    let b = 1i32;

    let _ = a.unwrap_or(b.checked_mul(3)?.min(240));

    Some(())
}

mod issue6675 {
    unsafe fn ptr_to_ref<'a, T>(p: *const T) -> &'a T {
        #[allow(unused)]
        let x = vec![0; 1000]; // future-proofing, make this function expensive.
        &*p
    }

    unsafe fn foo() {
        let s = "test".to_owned();
        let s = &s as *const _;
        None.unwrap_or(ptr_to_ref(s));
    }

    fn bar() {
        let s = "test".to_owned();
        let s = &s as *const _;
        None.unwrap_or(unsafe { ptr_to_ref(s) });
        #[rustfmt::skip]
        None.unwrap_or( unsafe { ptr_to_ref(s) }    );
    }
}

fn main() {}
