/**************************************************************************
 * This file is part of TraceTuner, the DNA sequencing quality value,
 * base calling and trace processing software.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received (LICENSE.txt) a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/

/* 
 * Copyright (c) 1999-2003 Paracel, Inc.  All rights reserved.
 *
 * 2.25 2003/11/06 18:18:28
 */

/*
 *  Btk_default_table.c  $Revision: 1.8 $
 */

#include "Btk_lookup_table.h"

static TraceParamEntry DefaultParam3700pop5Entries[] = {
/*   phr3_t            phr7_t             psr_t              pres_t  */
{0.001562500000000, 0.001754385964912, 1.171568627450981, 0.021943525030327},
{0.017064919377098, 0.040545175589812, 1.184659090909091, 0.028081905164711},
{0.027808677720786, 0.064699371679541, 1.258333333333334, 0.031895499316503},
{0.038633232956305, 0.087291302513029, 1.279220779220779, 0.035523981477579},
{0.049626602139079, 0.109148767367184, 1.303846153846154, 0.039061270504544},
{0.060583409599661, 0.129979103115718, 1.369318181818182, 0.042476616906231},
{0.071165621377686, 0.149400234545604, 1.405882352941176, 0.045775508088622},
{0.081322206988758, 0.167331104740132, 1.449494949494949, 0.048981526216352},
{0.091015203810460, 0.184244080422937, 1.516666666666667, 0.052119748642982},
{0.100264233761185, 0.200413581707390, 1.559027777777778, 0.055197352752798},
{0.109131404114520, 0.216114362176456, 1.607692307692307, 0.058233951431195},
{0.117600125719193, 0.231510387631998, 1.630681818181818, 0.061238054832227},
{0.125796549663144, 0.246887069515021, 1.675438596491228, 0.064223539621450},
{0.133860305716510, 0.262532680688003, 1.720779220779221, 0.067192975886384},
{0.141978776568978, 0.278747302586559, 1.759615384615385, 0.070154065621297},
{0.150359174159023, 0.295832283169964, 1.781746031746032, 0.073122965127240},
{0.159311409412588, 0.313877635317241, 1.861904761904762, 0.076105345974963},
{0.168967486660073, 0.333421588800758, 1.881944444444445, 0.079108017475995},
{0.179436583167726, 0.354820209151263, 1.912878787878788, 0.082132674222117},
{0.190795504060296, 0.378545271937262, 2.035714285714286, 0.085198726404001},
{0.203168596841342, 0.405419983487930, 2.133928571428572, 0.088310724877011},
{0.216663125266383, 0.435966781334740, 2.148351648351649, 0.091474627349177},
{0.231391680342692, 0.471053527148678, 2.258333333333334, 0.094708761496501},
{0.247629460508557, 0.512332809396270, 2.292857142857143, 0.098018963226478},
{0.265681399795044, 0.560361289332732, 2.341666666666666, 0.101426077688011},
{0.285770387401998, 0.616441233321227, 2.436507936507937, 0.104949186962166},
{0.308274771889641, 0.679837050582157, 2.519230769230769, 0.108607540949439},
{0.333709771630311, 0.750000056002470, 2.607692307692307, 0.112437904236049},
{0.362285728989395, 0.825915707586100, 2.720779220779221, 0.116478227905741},
{0.394691128136250, 0.906011417406772, 2.839743589743589, 0.120761859719618},
{0.431451712909995, 0.990162583367834, 3.035714285714286, 0.125363858474244},
{0.473163098226663, 1.079362829944119, 3.207142857142857, 0.130354054973690},
{0.521085469426411, 1.180396820419179, 3.408333333333333, 0.135873358408378},
{0.576507989918533, 1.296474797733151, 3.679487179487180, 0.142103126060185},
{0.641300019443719, 1.435105294745004, 4.035714285714286, 0.149515603320536},
{0.719326084060871, 1.612860831755714, 4.679487179487180, 0.159398697148393},
{0.816731978591524, 1.862505590331423, 5.348484848484848, 0.175087291682876},
{0.948746877194928, 2.277145965819360, 7.041666666666667, 0.200364044610507},
{1.187501358952452, 3.257203560995353, 12.100000000000001, 0.247848136867717},
{231.577074416497339, 320.000000000000000, 100.000000000000000, 11.929277481999005}};

static BtkLookupEntry DefaultTable3700pop5Entries[] = {
/* qv ind1 ind2 ind3 ind4 */
{43,	39,	25,	0,	0},
{39,	39,	9,	0,	1},
{39,	4,	15,	1,	0},
{37,	27,	24,	1,	1},
{37,	0,	2,	1,	1},
{37,	39,	10,	0,	1},
{36,	26,	24,	1,	3},
{38,	29,	21,	1,	2},
{36,	17,	15,	4,	1},
{40,	19,	16,	3,	8},
{40,	11,	19,	4,	4},
{36,	11,	18,	4,	13},
{37,	16,	17,	4,	13},
{37,	24,	17,	3,	4},
{36,	39,	13,	3,	16},
{38,	21,	15,	4,	10},
{36,	9,	21,	3,	9},
{36,	16,	20,	3,	9},
{36,	16,	25,	0,	36},
{35,	13,	17,	4,	23},
{38,	39,	10,	4,	20},
{37,	10,	18,	4,	21},
{36,	5,	19,	4,	21},
{36,	39,	13,	3,	20},
{35,	2,	7,	6,	4},
{36,	5,	7,	6,	3},
{35,	3,	26,	1,	36},
{35,	7,	30,	1,	14},
{35,	28,	19,	1,	36},
{35,	24,	16,	3,	12},
{34,	12,	21,	4,	31},
{37,	39,	8,	4,	28},
{35,	5,	22,	3,	27},
{35,	16,	10,	4,	28},
{35,	16,	15,	3,	24},
{35,	19,	12,	4,	22},
{35,	16,	17,	4,	20},
{35,	16,	20,	3,	24},
{34,	4,	8,	6,	9},
{38,	39,	4,	6,	7},
{34,	24,	21,	1,	37},
{35,	16,	25,	1,	37},
{34,	24,	19,	0,	38},
{34,	39,	15,	4,	6},
{36,	26,	17,	3,	12},
{34,	13,	19,	4,	27},
{34,	15,	19,	4,	24},
{33,	17,	15,	9,	28},
{38,	19,	14,	9,	4},
{36,	16,	16,	5,	15},
{36,	17,	20,	3,	26},
{35,	26,	19,	3,	12},
{35,	39,	13,	3,	28},
{36,	22,	12,	4,	28},
{35,	19,	15,	6,	8},
{35,	21,	11,	9,	5},
{35,	21,	15,	6,	8},
{34,	16,	16,	6,	22},
{36,	14,	18,	6,	2},
{35,	12,	16,	7,	15},
{35,	14,	17,	6,	6},
{34,	16,	17,	5,	22},
{34,	18,	19,	4,	12},
{33,	39,	19,	4,	35},
{34,	39,	21,	1,	35},
{34,	17,	20,	3,	35},
{34,	30,	22,	1,	33},
{33,	21,	15,	7,	28},
{36,	20,	16,	6,	22},
{35,	18,	14,	9,	27},
{35,	21,	11,	8,	24},
{35,	20,	14,	8,	27},
{34,	23,	13,	6,	28},
{35,	22,	15,	9,	4},
{34,	24,	14,	6,	16},
{34,	39,	12,	8,	17},
{33,	19,	15,	6,	30},
{33,	17,	18,	5,	22},
{33,	19,	21,	4,	9},
{34,	13,	21,	4,	33},
{34,	5,	22,	3,	35},
{33,	23,	25,	1,	36},
{33,	4,	17,	6,	12},
{33,	22,	14,	9,	8},
{32,	13,	18,	6,	31},
{35,	39,	12,	6,	31},
{34,	19,	16,	6,	30},
{32,	18,	15,	9,	29},
{33,	20,	15,	8,	29},
{32,	21,	18,	6,	30},
{33,	23,	16,	6,	30},
{34,	39,	15,	6,	14},
{33,	25,	18,	6,	6},
{33,	23,	15,	8,	14},
{32,	19,	22,	3,	34},
{32,	24,	19,	1,	38},
{32,	29,	20,	3,	33},
{34,	27,	21,	4,	6},
{33,	26,	22,	3,	15},
{32,	20,	16,	8,	7},
{33,	3,	17,	8,	5},
{32,	39,	10,	9,	22},
{33,	22,	15,	9,	12},
{32,	3,	18,	8,	4},
{31,	4,	2,	12,	10},
{38,	39,	6,	10,	10},
{34,	15,	12,	10,	9},
{32,	14,	7,	10,	11},
{32,	1,	6,	12,	1},
{31,	39,	16,	6,	35},
{33,	18,	18,	6,	32},
{33,	5,	18,	6,	34},
{31,	25,	16,	4,	38},
{34,	26,	17,	3,	38},
{32,	26,	19,	3,	37},
{32,	13,	19,	4,	37},
{31,	19,	13,	9,	30},
{32,	39,	11,	9,	29},
{31,	19,	21,	4,	35},
{32,	22,	20,	4,	35},
{31,	23,	15,	8,	29},
{31,	25,	16,	8,	4},
{31,	23,	16,	7,	15},
{31,	21,	14,	8,	30},
{31,	27,	24,	1,	36},
{30,	22,	13,	12,	31},
{34,	39,	12,	12,	28},
{32,	20,	14,	9,	31},
{31,	39,	14,	12,	1},
{31,	13,	15,	10,	24},
{32,	10,	16,	11,	2},
{31,	3,	15,	12,	14},
{31,	10,	18,	10,	3},
{32,	23,	17,	7,	7},
{31,	17,	17,	7,	31},
{35,	4,	18,	7,	27},
{32,	9,	18,	8,	7},
{31,	7,	17,	10,	5},
{30,	17,	20,	9,	34},
{35,	21,	17,	9,	10},
{34,	13,	18,	10,	13},
{33,	15,	19,	6,	35},
{33,	10,	22,	6,	1},
{32,	20,	20,	6,	12},
{32,	19,	16,	9,	24},
{32,	39,	11,	8,	34},
{31,	17,	21,	6,	22},
{32,	5,	21,	6,	26},
{31,	23,	19,	6,	28},
{33,	22,	19,	7,	13},
{32,	24,	18,	6,	28},
{32,	23,	20,	6,	12},
{31,	21,	16,	10,	14},
{31,	22,	12,	9,	33},
{30,	17,	24,	4,	34},
{37,	8,	25,	3,	26},
{34,	1,	25,	4,	26},
{33,	10,	22,	6,	15},
{32,	9,	22,	5,	26},
{32,	3,	24,	5,	7},
{32,	19,	23,	3,	34},
{30,	17,	15,	12,	14},
{32,	23,	14,	12,	11},
{32,	25,	17,	10,	3},
{31,	23,	14,	9,	28},
{31,	21,	16,	9,	30},
{30,	22,	26,	1,	37},
{30,	22,	14,	12,	22},
{30,	39,	19,	0,	39},
{30,	3,	16,	12,	17},
{32,	14,	16,	12,	10},
{30,	18,	18,	9,	33},
{30,	21,	15,	10,	29},
{30,	2,	15,	10,	32},
{30,	1,	14,	12,	30},
{30,	39,	14,	12,	7},
{31,	24,	17,	8,	10},
{30,	22,	17,	6,	35},
{30,	22,	14,	9,	33},
{30,	28,	22,	3,	14},
{30,	23,	19,	5,	35},
{30,	24,	14,	12,	13},
{32,	39,	14,	7,	33},
{30,	18,	28,	1,	11},
{30,	23,	20,	7,	10},
{30,	27,	19,	6,	3},
{30,	27,	19,	5,	14},
{30,	23,	20,	5,	22},
{30,	39,	20,	4,	33},
{30,	28,	21,	4,	14},
{30,	3,	15,	12,	21},
{30,	26,	25,	0,	36},
{30,	26,	26,	0,	33},
{30,	3,	18,	10,	19},
{29,	22,	15,	15,	32},
{31,	21,	16,	12,	9},
{29,	26,	18,	6,	37},
{32,	14,	19,	6,	37},
{31,	25,	19,	6,	24},
{31,	27,	19,	6,	14},
{31,	27,	18,	6,	26},
{30,	39,	17,	6,	36},
{30,	19,	19,	6,	37},
{29,	21,	18,	9,	35},
{31,	22,	20,	7,	16},
{30,	17,	19,	9,	35},
{29,	25,	23,	4,	29},
{33,	22,	23,	4,	34},
{30,	25,	23,	3,	33},
{29,	5,	22,	6,	31},
{31,	5,	21,	6,	34},
{29,	11,	21,	4,	38},
{31,	21,	22,	3,	36},
{30,	17,	24,	0,	39},
{29,	21,	22,	6,	11},
{30,	14,	22,	6,	23},
{30,	17,	24,	5,	6},
{29,	6,	26,	4,	18},
{29,	10,	26,	3,	35},
{32,	1,	26,	4,	32},
{29,	39,	18,	6,	33},
{29,	9,	24,	5,	16},
{30,	12,	23,	5,	26},
{29,	17,	23,	6,	10},
{29,	39,	17,	7,	19},
{31,	39,	15,	7,	35},
{30,	25,	19,	7,	17},
{29,	9,	29,	1,	22},
{30,	11,	27,	1,	32},
{29,	17,	21,	7,	8},
{29,	18,	20,	8,	26},
{29,	26,	24,	3,	7},
{29,	15,	24,	6,	5},
{29,	39,	22,	1,	18},
{29,	13,	25,	3,	30},
{29,	0,	22,	7,	7},
{29,	27,	21,	4,	26},
{29,	24,	15,	12,	13},
{29,	39,	16,	9,	9},
{31,	24,	18,	9,	9},
{30,	23,	16,	9,	21},
{30,	24,	19,	8,	8},
{30,	19,	20,	9,	17},
{29,	19,	19,	9,	34},
{29,	29,	22,	1,	37},
{29,	25,	15,	12,	12},
{29,	39,	15,	9,	26},
{30,	26,	16,	9,	17},
{29,	25,	17,	10,	10},
{29,	18,	22,	5,	24},
{29,	22,	18,	9,	19},
{28,	23,	14,	21,	15},
{29,	24,	14,	21,	7},
{29,	23,	13,	15,	28},
{29,	6,	16,	20,	0},
{28,	20,	17,	12,	34},
{30,	19,	18,	10,	21},
{29,	13,	17,	15,	17},
{32,	10,	17,	14,	22},
{32,	16,	17,	15,	13},
{31,	13,	16,	14,	27},
{29,	2,	18,	12,	8},
{30,	19,	18,	11,	11},
{28,	25,	18,	9,	36},
{31,	39,	16,	8,	32},
{31,	18,	19,	9,	36},
{30,	25,	19,	7,	27},
{30,	22,	16,	12,	26},
{29,	39,	17,	7,	36},
{29,	26,	16,	9,	33},
{28,	24,	25,	1,	39},
{29,	11,	25,	3,	38},
{28,	39,	23,	1,	35},
{32,	29,	26,	0,	25},
{31,	32,	25,	0,	25},
{28,	14,	23,	6,	22},
{28,	16,	20,	6,	37},
{30,	17,	20,	9,	35},
{28,	23,	16,	15,	13},
{29,	21,	17,	15,	7},
{28,	6,	19,	10,	21},
{29,	19,	20,	10,	4},
{28,	39,	20,	4,	35},
{28,	18,	20,	9,	31},
{28,	25,	19,	6,	31},
{28,	22,	19,	7,	35},
{28,	4,	23,	4,	36},
{28,	28,	22,	4,	15},
{28,	28,	23,	3,	12},
{28,	21,	22,	6,	13},
{28,	19,	21,	6,	22},
{28,	28,	21,	4,	29},
{28,	15,	20,	8,	36},
{28,	23,	22,	6,	4},
{28,	39,	24,	0,	29},
{28,	28,	23,	1,	38},
{28,	25,	24,	4,	7},
{29,	18,	24,	4,	34},
{29,	23,	24,	5,	5},
{28,	22,	24,	4,	30},
{30,	26,	24,	4,	12},
{28,	20,	24,	3,	36},
{28,	5,	23,	5,	31},
{28,	12,	22,	6,	26},
{28,	12,	21,	6,	34},
{27,	22,	12,	18,	30},
{31,	11,	14,	18,	18},
{29,	22,	14,	18,	18},
{27,	23,	13,	20,	22},
{30,	6,	13,	18,	28},
{30,	22,	14,	18,	21},
{27,	20,	17,	12,	35},
{27,	16,	21,	9,	36},
{31,	0,	22,	9,	3},
{29,	14,	22,	6,	30},
{28,	8,	21,	10,	18},
{28,	17,	21,	7,	34},
{27,	19,	16,	15,	33},
{30,	13,	17,	15,	23},
{29,	39,	12,	15,	33},
{28,	22,	16,	15,	26},
{28,	20,	17,	15,	14},
{27,	0,	22,	9,	31},
{28,	0,	22,	10,	10},
{27,	26,	20,	6,	35},
{29,	28,	19,	6,	28},
{29,	26,	24,	5,	5},
{28,	24,	21,	6,	14},
{28,	19,	22,	5,	30},
{28,	39,	19,	5,	33},
{27,	20,	16,	18,	12},
{31,	23,	15,	19,	4},
{30,	18,	15,	19,	9},
{28,	23,	15,	20,	6},
{27,	15,	23,	6,	31},
{27,	4,	24,	6,	23},
{30,	6,	24,	5,	31},
{27,	22,	25,	3,	30},
{30,	25,	25,	3,	13},
{28,	20,	25,	3,	36},
{27,	39,	15,	12,	29},
{30,	26,	16,	11,	28},
{28,	23,	16,	15,	26},
{27,	23,	15,	18,	21},
{27,	6,	29,	3,	14},
{27,	16,	24,	6,	19},
{28,	25,	24,	5,	8},
{28,	24,	22,	6,	11},
{27,	39,	18,	9,	10},
{27,	17,	26,	3,	36},
{29,	18,	27,	3,	9},
{27,	19,	22,	6,	30},
{30,	17,	24,	6,	20},
{30,	23,	22,	6,	16},
{27,	0,	23,	7,	14},
{27,	19,	18,	12,	8},
{27,	17,	21,	9,	32},
{28,	19,	21,	9,	14},
{27,	0,	24,	7,	11},
{27,	15,	21,	11,	2},
{29,	6,	20,	11,	8},
{27,	22,	17,	12,	23},
{27,	20,	26,	3,	28},
{27,	15,	14,	20,	19},
{27,	17,	30,	0,	18},
{28,	17,	28,	0,	31},
{27,	9,	29,	1,	29},
{27,	39,	17,	4,	38},
{27,	0,	22,	10,	18},
{27,	23,	14,	19,	20},
{27,	18,	17,	14,	23},
{27,	20,	20,	7,	34},
{27,	22,	27,	3,	5},
{27,	21,	22,	9,	0},
{27,	29,	24,	3,	3},
{27,	28,	21,	3,	34},
{26,	39,	14,	21,	31},
{32,	23,	15,	17,	26},
{31,	25,	15,	15,	31},
{27,	25,	15,	12,	35},
{27,	21,	17,	12,	33},
{27,	39,	16,	15,	3},
{26,	19,	20,	15,	35},
{29,	20,	18,	12,	31},
{30,	21,	18,	15,	15},
{29,	25,	18,	10,	26},
{28,	21,	17,	15,	28},
{27,	26,	18,	15,	1},
{27,	22,	18,	12,	22},
{27,	39,	12,	15,	35},
{27,	15,	21,	10,	18},
{27,	15,	21,	15,	0},
{27,	26,	17,	11,	17},
{27,	39,	17,	9,	25},
{27,	6,	22,	15,	0},
{26,	24,	24,	6,	38},
{30,	25,	23,	4,	38},
{29,	25,	24,	4,	33},
{28,	28,	22,	4,	34},
{31,	26,	24,	4,	30},
{29,	27,	23,	4,	30},
{28,	1,	25,	4,	37},
{27,	23,	25,	4,	26},
{28,	25,	25,	3,	32},
{28,	27,	25,	1,	32},
{28,	25,	25,	4,	26},
{27,	8,	27,	4,	14},
{27,	27,	21,	4,	38},
{27,	27,	24,	4,	18},
{27,	0,	22,	9,	32},
{27,	28,	25,	1,	25},
{27,	28,	24,	4,	13},
{27,	25,	20,	6,	38},
{26,	23,	22,	9,	32},
{29,	20,	19,	12,	33},
{26,	26,	25,	4,	39},
{28,	27,	25,	4,	18},
{27,	23,	26,	3,	35},
{27,	39,	22,	1,	39},
{27,	26,	26,	1,	23},
{26,	4,	24,	9,	32},
{30,	11,	24,	9,	4},
{28,	10,	23,	8,	32},
{27,	18,	24,	7,	9},
{29,	16,	23,	8,	11},
{27,	5,	23,	7,	34},
{26,	24,	15,	18,	32},
{26,	28,	21,	6,	36},
{30,	26,	23,	5,	28},
{28,	29,	20,	5,	35},
{27,	25,	23,	6,	28},
{27,	27,	18,	7,	36},
{27,	39,	18,	9,	24},
{26,	39,	22,	4,	33},
{29,	29,	23,	4,	20},
{27,	29,	23,	5,	6},
{26,	18,	16,	18,	32},
{27,	2,	17,	18,	26},
{26,	13,	18,	10,	36},
{26,	15,	23,	9,	30},
{27,	21,	23,	7,	14},
{26,	4,	27,	4,	31},
{28,	3,	28,	3,	22},
{27,	10,	27,	4,	20},
{26,	23,	20,	9,	36},
{26,	19,	17,	18,	10},
{26,	13,	27,	1,	39},
{26,	29,	24,	1,	39},
{27,	30,	25,	0,	39},
{26,	27,	19,	7,	35},
{26,	39,	19,	8,	13},
{27,	25,	19,	9,	14},
{26,	22,	16,	17,	26},
{26,	8,	16,	20,	3},
{26,	29,	20,	6,	13},
{26,	20,	20,	11,	35},
{26,	39,	24,	0,	37},
{26,	39,	19,	7,	21},
{27,	39,	19,	6,	35},
{26,	39,	22,	3,	35},
{26,	10,	33,	1,	5},
{26,	9,	31,	0,	28},
{26,	30,	27,	1,	2},
{27,	28,	26,	1,	33},
{27,	29,	26,	1,	30},
{26,	22,	20,	12,	3},
{26,	26,	16,	11,	33},
{26,	3,	29,	3,	22},
{26,	12,	28,	4,	3},
{25,	39,	20,	9,	38},
{31,	16,	21,	8,	38},
{29,	39,	22,	3,	38},
{27,	5,	23,	7,	37},
{27,	39,	20,	10,	4},
{27,	25,	22,	7,	10},
{27,	39,	21,	5,	17},
{27,	16,	21,	9,	37},
{25,	39,	12,	21,	34},
{32,	17,	14,	19,	33},
{25,	15,	7,	25,	10},
{27,	39,	8,	23,	6},
{28,	14,	13,	23,	1},
{28,	14,	10,	23,	4},
{26,	14,	9,	23,	9},
{25,	19,	26,	6,	38},
{30,	0,	26,	7,	7},
{30,	2,	27,	5,	15},
{28,	22,	26,	4,	26},
{27,	20,	25,	6,	20},
{27,	26,	26,	1,	39},
{27,	6,	27,	4,	33},
{26,	3,	25,	9,	7},
{25,	39,	14,	12,	36},
{26,	13,	15,	12,	36},
{25,	19,	21,	15,	29},
{29,	7,	22,	10,	27},
{26,	6,	22,	15,	1},
{26,	5,	21,	13,	30},
{25,	17,	16,	21,	32},
{26,	18,	15,	21,	32},
{26,	3,	15,	20,	33},
{25,	18,	20,	17,	10},
{27,	21,	18,	17,	9},
{26,	18,	19,	18,	10},
{25,	20,	23,	9,	31},
{27,	22,	23,	7,	29},
{26,	19,	23,	9,	32},
{25,	28,	23,	6,	25},
{25,	2,	27,	6,	30},
{25,	3,	25,	9,	16},
{27,	3,	25,	7,	22},
{25,	28,	27,	1,	26},
{26,	22,	29,	0,	19},
{26,	19,	28,	1,	27},
{26,	26,	28,	0,	22},
{26,	23,	28,	1,	26},
{26,	22,	29,	1,	19},
{25,	2,	28,	5,	24},
{26,	2,	28,	6,	10},
{26,	3,	28,	3,	29},
{25,	33,	25,	1,	24},
{26,	31,	24,	3,	6},
{26,	39,	23,	3,	20},
{26,	32,	25,	1,	30},
{25,	5,	19,	18,	16},
{25,	25,	20,	10,	30},
{25,	22,	20,	12,	20},
{25,	25,	26,	3,	37},
{27,	24,	26,	4,	26},
{25,	6,	27,	4,	38},
{25,	26,	22,	6,	38},
{26,	27,	23,	6,	29},
{25,	20,	23,	7,	36},
{25,	29,	22,	6,	22},
{26,	29,	21,	6,	36},
{25,	39,	21,	6,	32},
{25,	39,	22,	6,	22},
{25,	28,	28,	1,	20},
{25,	18,	26,	8,	0},
{25,	18,	16,	20,	31},
{25,	25,	24,	5,	35},
{25,	25,	15,	18,	25},
{25,	21,	18,	14,	26},
{27,	21,	19,	12,	33},
{27,	22,	20,	12,	26},
{25,	21,	17,	15,	32},
{25,	27,	24,	4,	26},
{25,	18,	24,	7,	14},
{25,	6,	22,	17,	0},
{25,	39,	15,	14,	31},
{25,	23,	22,	7,	36},
{25,	23,	17,	12,	22},
{25,	2,	27,	7,	3},
{25,	28,	23,	4,	31},
{24,	39,	11,	28,	29},
{28,	1,	14,	23,	5},
{26,	21,	13,	25,	8},
{28,	21,	14,	23,	8},
{26,	22,	14,	25,	3},
{25,	22,	12,	26,	8},
{24,	26,	19,	18,	35},
{30,	24,	20,	12,	27},
{29,	15,	15,	19,	34},
{27,	39,	19,	10,	28},
{26,	39,	18,	12,	34},
{25,	25,	16,	21,	31},
{28,	39,	15,	20,	32},
{25,	39,	17,	18,	33},
{25,	39,	20,	10,	28},
{24,	18,	13,	25,	31},
{26,	13,	12,	26,	25},
{25,	17,	12,	28,	18},
{25,	21,	14,	23,	11},
{25,	22,	13,	28,	2},
{25,	18,	13,	26,	24},
{26,	21,	13,	27,	12},
{24,	24,	18,	21,	32},
{25,	17,	19,	20,	8},
{24,	25,	16,	15,	36},
{24,	19,	22,	12,	27},
{24,	30,	24,	4,	37},
{26,	31,	24,	3,	26},
{24,	24,	25,	6,	35},
{24,	27,	28,	1,	39},
{27,	28,	28,	1,	37},
{25,	9,	31,	0,	39},
{25,	3,	28,	3,	34},
{24,	15,	23,	10,	27},
{24,	27,	24,	6,	26},
{24,	23,	26,	6,	23},
{25,	22,	26,	6,	28},
{26,	20,	26,	6,	38},
{24,	22,	20,	17,	11},
{25,	24,	20,	14,	13},
{24,	29,	28,	1,	35},
{25,	32,	25,	1,	37},
{24,	22,	23,	8,	26},
{26,	21,	23,	9,	24},
{24,	5,	31,	3,	11},
{24,	21,	21,	12,	17},
{25,	21,	21,	15,	9},
{24,	39,	23,	4,	23},
{24,	25,	22,	7,	26},
{24,	28,	21,	9,	27},
{26,	39,	21,	7,	25},
{25,	24,	22,	9,	16},
{26,	24,	22,	8,	30},
{26,	25,	21,	9,	32},
{24,	28,	22,	7,	22},
{24,	26,	16,	21,	21},
{24,	27,	19,	12,	34},
{24,	27,	24,	4,	39},
{24,	24,	22,	10,	12},
{25,	20,	22,	12,	15},
{24,	4,	24,	7,	36},
{24,	25,	22,	8,	26},
{24,	25,	25,	6,	9},
{24,	13,	24,	9,	5},
{24,	7,	17,	25,	0},
{24,	21,	19,	19,	7},
{24,	19,	27,	3,	13},
{24,	20,	23,	10,	11},
{24,	1,	20,	18,	8},
{24,	21,	23,	9,	31},
{24,	39,	17,	20,	4},
{24,	4,	30,	1,	29},
{24,	5,	14,	21,	34},
{24,	1,	32,	2,	11},
{25,	1,	33,	0,	35},
{24,	30,	24,	5,	6},
{24,	18,	26,	7,	3},
{24,	7,	27,	5,	25},
{24,	28,	25,	5,	3},
{25,	30,	25,	3,	7},
{24,	11,	29,	1,	35},
{24,	39,	17,	16,	35},
{24,	23,	29,	1,	22},
{24,	5,	27,	6,	30},
{24,	29,	21,	10,	4},
{23,	21,	24,	12,	37},
{27,	39,	15,	12,	37},
{27,	23,	22,	9,	35},
{27,	9,	23,	16,	0},
{26,	24,	20,	12,	33},
{26,	6,	25,	9,	16},
{25,	12,	21,	15,	32},
{25,	23,	22,	10,	28},
{25,	8,	25,	9,	14},
{25,	12,	17,	15,	36},
{25,	25,	19,	12,	36},
{25,	26,	21,	10,	27},
{25,	4,	23,	13,	5},
{24,	15,	25,	9,	10},
{28,	22,	25,	8,	4},
{25,	18,	25,	8,	10},
{24,	18,	25,	8,	22},
{24,	9,	25,	9,	20},
{24,	22,	21,	12,	27},
{24,	21,	25,	8,	12},
{24,	5,	18,	15,	36},
{24,	11,	22,	15,	2},
{24,	22,	22,	12,	13},
{23,	18,	11,	31,	15},
{27,	15,	12,	30,	10},
{25,	16,	13,	29,	6},
{23,	19,	28,	6,	39},
{33,	24,	24,	6,	39},
{25,	39,	17,	6,	39},
{25,	26,	22,	6,	39},
{24,	22,	28,	4,	30},
{25,	22,	26,	6,	33},
{26,	22,	27,	4,	37},
{25,	23,	26,	4,	39},
{24,	23,	27,	5,	5},
{25,	24,	27,	4,	9},
{24,	18,	29,	3,	6},
{25,	14,	29,	3,	19},
{23,	39,	17,	21,	35},
{26,	24,	18,	21,	33},
{24,	26,	18,	20,	14},
{23,	19,	26,	9,	33},
{27,	15,	25,	7,	36},
{23,	22,	20,	20,	33},
{26,	21,	20,	18,	34},
{25,	20,	21,	15,	29},
{25,	16,	20,	21,	2},
{24,	24,	19,	20,	23},
{24,	14,	20,	18,	35},
{24,	24,	20,	15,	15},
{23,	39,	11,	25,	33},
{23,	16,	22,	18,	24},
{29,	12,	21,	17,	29},
{26,	16,	22,	14,	26},
{25,	17,	21,	18,	27},
{26,	21,	21,	18,	8},
{24,	23,	22,	13,	4},
{23,	12,	24,	15,	20},
{26,	15,	23,	15,	9},
{26,	18,	23,	13,	22},
{25,	15,	23,	15,	20},
{23,	24,	20,	7,	39},
{24,	19,	22,	7,	39},
{26,	16,	22,	8,	38},
{24,	27,	19,	7,	39},
{23,	7,	25,	12,	31},
{26,	11,	25,	12,	11},
{23,	17,	18,	23,	13},
{26,	9,	14,	22,	28},
{25,	17,	16,	25,	2},
{25,	1,	15,	22,	28},
{24,	20,	18,	22,	12},
{24,	17,	14,	23,	17},
{25,	9,	14,	23,	27},
{24,	8,	18,	25,	2},
{23,	29,	25,	4,	37},
{24,	32,	25,	3,	9},
{23,	23,	21,	15,	31},
{24,	25,	21,	12,	8},
{24,	24,	22,	13,	7},
{23,	1,	31,	5,	11},
{27,	1,	29,	6,	7},
{24,	1,	29,	6,	11},
{23,	23,	19,	21,	28},
{23,	28,	23,	6,	36},
{24,	26,	23,	6,	39},
{23,	22,	24,	8,	37},
{23,	18,	11,	29,	16},
{23,	26,	22,	8,	32},
{23,	21,	25,	8,	33},
{23,	16,	25,	8,	36},
{23,	16,	22,	14,	30},
{23,	26,	21,	9,	36},
{23,	26,	22,	9,	33},
{24,	27,	22,	9,	21},
{25,	28,	22,	8,	21},
{24,	25,	22,	12,	8},
{23,	5,	29,	3,	35},
{23,	12,	24,	7,	39},
{23,	12,	22,	9,	38},
{23,	15,	15,	28,	3},
{24,	16,	14,	29,	4},
{24,	15,	18,	24,	5},
{23,	28,	20,	11,	30},
{23,	3,	23,	15,	23},
{24,	3,	24,	15,	21},
{23,	23,	29,	1,	35},
{24,	17,	29,	3,	30},
{23,	26,	22,	11,	14},
{25,	24,	21,	12,	27},
{23,	7,	27,	9,	0},
{23,	11,	33,	0,	39},
{23,	10,	32,	1,	29},
{23,	14,	24,	15,	18},
{23,	26,	26,	3,	23},
{23,	20,	29,	3,	28},
{23,	13,	25,	10,	31},
{23,	6,	27,	8,	2},
{23,	28,	25,	6,	2},
{23,	39,	23,	1,	39},
{23,	25,	30,	1,	4},
{23,	39,	22,	4,	37},
{23,	39,	12,	26,	12},
{23,	39,	14,	28,	2},
{23,	22,	28,	3,	37},
{23,	1,	29,	4,	17},
{23,	28,	24,	5,	26},
{23,	30,	24,	5,	17},
{23,	33,	26,	1,	4},
{23,	31,	28,	1,	25},
{24,	33,	27,	0,	13},
{23,	33,	26,	1,	19},
{23,	1,	16,	22,	21},
{23,	18,	21,	18,	26},
{23,	13,	25,	12,	11},
{23,	30,	26,	0,	39},
{23,	28,	23,	3,	39},
{23,	26,	21,	7,	38},
{24,	24,	21,	8,	38},
{23,	24,	22,	7,	39},
{23,	9,	14,	27,	7},
{25,	9,	14,	24,	25},
{25,	21,	14,	25,	11},
{24,	10,	18,	24,	9},
{24,	18,	14,	28,	7},
{25,	17,	13,	28,	15},
{23,	15,	13,	31,	9},
{23,	21,	15,	24,	10},
{23,	8,	25,	13,	3},
{23,	2,	32,	5,	1},
{23,	28,	22,	8,	25},
{22,	24,	16,	28,	34},
{26,	8,	18,	27,	4},
{26,	26,	17,	23,	9},
{24,	24,	17,	24,	12},
{23,	39,	14,	28,	20},
{23,	25,	15,	23,	34},
{23,	22,	17,	26,	4},
{24,	15,	18,	28,	2},
{22,	24,	18,	21,	36},
{23,	25,	17,	21,	36},
{22,	18,	11,	31,	25},
{22,	27,	21,	12,	38},
{24,	26,	20,	15,	29},
{24,	28,	20,	12,	30},
{24,	24,	20,	15,	35},
{24,	28,	22,	12,	2},
{23,	25,	20,	18,	11},
{24,	23,	21,	18,	8},
{23,	17,	22,	10,	38},
{23,	25,	22,	12,	13},
{24,	23,	22,	12,	21},
{23,	27,	20,	14,	7},
{23,	27,	18,	15,	35},
{23,	27,	19,	14,	32},
{23,	28,	19,	13,	30},
{23,	39,	18,	18,	3},
{22,	30,	21,	9,	39},
{25,	29,	22,	5,	39},
{25,	39,	21,	8,	38},
{24,	29,	22,	8,	22},
{23,	29,	22,	9,	25},
{23,	39,	22,	6,	35},
{24,	30,	22,	7,	27},
{23,	30,	21,	10,	32},
{23,	29,	25,	3,	39},
{23,	30,	22,	6,	37},
{22,	24,	20,	15,	37},
{22,	27,	24,	9,	33},
{26,	25,	24,	10,	8},
{25,	28,	24,	5,	37},
{25,	23,	24,	9,	35},
{24,	28,	23,	7,	27},
{23,	29,	22,	9,	32},
{23,	27,	24,	6,	37},
{23,	26,	24,	6,	39},
{22,	13,	27,	10,	30},
{25,	14,	27,	10,	13},
{24,	13,	27,	7,	33},
{22,	23,	21,	20,	32},
{24,	12,	22,	20,	4},
{23,	2,	21,	18,	33},
{22,	13,	11,	32,	18},
{23,	21,	11,	32,	10},
{23,	15,	14,	32,	2},
{22,	0,	30,	6,	36},
{24,	1,	32,	5,	13},
{24,	16,	29,	1,	39},
{23,	1,	31,	3,	35},
{22,	18,	23,	15,	30},
{25,	21,	22,	16,	6},
{24,	11,	22,	15,	31},
{23,	9,	22,	18,	25},
{23,	23,	22,	18,	1},
{23,	23,	22,	15,	16},
{24,	22,	23,	15,	2},
{25,	20,	23,	15,	13},
{24,	19,	23,	15,	24},
{22,	39,	11,	29,	27},
{23,	39,	11,	31,	21},
{22,	13,	26,	12,	12},
{23,	13,	25,	12,	22},
{22,	39,	19,	15,	27},
{24,	39,	19,	17,	7},
{23,	29,	20,	12,	14},
{22,	32,	24,	4,	33},
{23,	31,	24,	4,	36},
{23,	39,	23,	4,	38},
{22,	22,	20,	21,	28},
{24,	15,	21,	21,	8},
{24,	12,	22,	21,	4},
{22,	13,	24,	15,	28},
{22,	20,	29,	4,	36},
{25,	5,	30,	6,	28},
{25,	13,	29,	6,	8},
{24,	6,	31,	5,	14},
{22,	25,	27,	3,	39},
{23,	24,	27,	4,	35},
{23,	23,	28,	4,	28},
{22,	21,	32,	1,	27},
{25,	25,	32,	1,	10},
{24,	22,	33,	1,	13},
{22,	19,	22,	15,	33},
{23,	22,	21,	17,	33},
{22,	28,	23,	9,	33},
{22,	27,	26,	4,	23},
{22,	22,	22,	9,	39},
{22,	30,	22,	9,	33},
{22,	20,	26,	9,	21},
{22,	10,	18,	27,	10},
{24,	10,	18,	25,	13},
{23,	24,	17,	25,	11},
{22,	14,	26,	9,	34},
{23,	5,	25,	9,	35},
{22,	17,	26,	10,	30},
{22,	8,	29,	4,	39},
{25,	1,	30,	4,	38},
{22,	24,	25,	6,	39},
{22,	14,	20,	18,	36},
{22,	28,	24,	6,	30},
{22,	21,	25,	9,	33},
{22,	39,	24,	3,	24},
{22,	1,	32,	3,	34},
{22,	24,	26,	6,	23},
{23,	25,	26,	6,	9},
{22,	22,	27,	5,	33},
{24,	20,	28,	6,	12},
{22,	26,	26,	4,	34},
{23,	27,	26,	3,	34},
{22,	29,	26,	3,	36},
{22,	28,	27,	3,	35},
{22,	30,	23,	5,	38},
{22,	22,	29,	4,	21},
{22,	2,	33,	4,	11},
{22,	19,	21,	15,	34},
{22,	32,	25,	3,	16},
{22,	16,	27,	9,	12},
{22,	23,	30,	0,	39},
{22,	25,	24,	10,	14},
{23,	23,	24,	10,	23},
{22,	18,	33,	0,	39},
{22,	10,	13,	30,	12},
{22,	13,	29,	5,	23},
{22,	39,	22,	9,	1},
{22,	39,	20,	12,	14},
{22,	28,	26,	4,	16},
{22,	23,	22,	14,	20},
{22,	18,	25,	11,	8},
{22,	39,	21,	12,	2},
{22,	39,	12,	31,	7},
{22,	33,	25,	0,	37},
{22,	14,	22,	16,	27},
{22,	20,	22,	16,	18},
{22,	24,	17,	23,	14},
{22,	20,	17,	24,	24},
{23,	20,	17,	22,	29},
{22,	19,	17,	28,	5},
{22,	15,	18,	27,	8},
{22,	7,	31,	5,	14},
{22,	10,	30,	3,	25},
{21,	39,	12,	31,	35},
{21,	39,	10,	34,	20},
{21,	24,	22,	15,	38},
{26,	24,	24,	10,	30},
{24,	25,	22,	10,	38},
{25,	26,	22,	9,	38},
{24,	25,	24,	8,	35},
{23,	24,	23,	15,	2},
{23,	26,	23,	9,	35},
{23,	24,	24,	10,	35},
{22,	24,	23,	12,	35},
{24,	22,	24,	12,	32},
{22,	20,	21,	18,	34},
{22,	25,	22,	12,	30},
{22,	26,	22,	11,	36},
{22,	27,	22,	12,	32},
{22,	23,	23,	9,	37},
{22,	25,	24,	10,	26},
{22,	25,	16,	15,	38},
{22,	39,	16,	15,	37},
{21,	22,	22,	18,	37},
{23,	23,	22,	20,	2},
{23,	39,	15,	18,	37},
{22,	24,	22,	18,	11},
{22,	22,	22,	19,	4},
{22,	23,	21,	18,	36},
{21,	20,	24,	18,	30},
{22,	23,	23,	14,	17},
{23,	24,	23,	13,	30},
{22,	21,	24,	15,	9},
{21,	9,	29,	10,	26},
{25,	14,	29,	6,	23},
{24,	9,	28,	8,	29},
{23,	4,	28,	10,	30},
{23,	12,	28,	8,	9},
{21,	25,	25,	9,	38},
{23,	26,	24,	7,	39},
{23,	15,	25,	7,	39},
{22,	13,	24,	12,	38},
{22,	21,	23,	9,	39},
{22,	18,	25,	10,	35},
{25,	9,	25,	12,	32},
{24,	8,	26,	10,	34},
{22,	6,	27,	10,	31},
{22,	26,	22,	9,	39},
{22,	13,	25,	12,	27},
{21,	18,	23,	20,	17},
{25,	21,	22,	19,	17},
{25,	5,	23,	21,	6},
{23,	15,	22,	19,	22},
{23,	21,	23,	19,	4},
{22,	18,	22,	20,	19},
{21,	32,	24,	6,	35},
{24,	30,	23,	8,	5},
{22,	30,	24,	7,	5},
{21,	28,	26,	6,	33},
{25,	27,	25,	6,	37},
{24,	27,	25,	7,	12},
{22,	26,	25,	8,	34},
{22,	26,	25,	6,	39},
{21,	18,	24,	15,	37},
{22,	12,	23,	14,	38},
{21,	39,	25,	3,	34},
{25,	39,	24,	1,	39},
{22,	30,	25,	4,	37},
{22,	32,	24,	3,	38},
{22,	34,	26,	0,	19},
{21,	31,	29,	1,	37},
{23,	25,	31,	0,	30},
{24,	26,	32,	1,	15},
{22,	31,	26,	3,	28},
{22,	33,	29,	0,	8},
{21,	20,	36,	1,	37},
{25,	13,	38,	1,	26},
{24,	3,	31,	3,	38},
{23,	21,	33,	1,	38},
{23,	2,	37,	3,	2},
{23,	2,	33,	3,	20},
{22,	7,	30,	6,	31},
{21,	15,	14,	31,	28},
{25,	14,	13,	30,	34},
{22,	14,	14,	29,	34},
{21,	21,	18,	23,	29},
{22,	10,	18,	25,	17},
{23,	15,	17,	25,	21},
{22,	24,	17,	23,	29},
{21,	25,	23,	15,	20},
{23,	25,	22,	18,	6},
{22,	25,	23,	12,	33},
{22,	25,	21,	14,	31},
{21,	25,	24,	9,	39},
{21,	29,	31,	1,	26},
{23,	25,	30,	1,	38},
{22,	28,	31,	1,	30},
{22,	30,	30,	0,	35},
{21,	6,	30,	7,	25},
{21,	24,	23,	15,	33},
{23,	19,	24,	15,	37},
{21,	8,	25,	13,	25},
{22,	0,	25,	13,	29},
{21,	8,	26,	15,	8},
{21,	29,	22,	9,	38},
{25,	27,	23,	9,	37},
{22,	27,	24,	9,	36},
{22,	27,	25,	6,	38},
{21,	19,	26,	9,	35},
{22,	13,	27,	7,	35},
{21,	34,	26,	1,	33},
{23,	33,	27,	0,	29},
{22,	32,	27,	1,	37},
{21,	2,	30,	6,	38},
{21,	14,	22,	23,	1},
{25,	9,	19,	24,	5},
{23,	19,	19,	23,	5},
{23,	14,	23,	23,	0},
{21,	19,	22,	20,	23},
{21,	15,	21,	21,	21},
{21,	25,	26,	6,	37},
{22,	22,	26,	6,	39},
{21,	26,	25,	9,	35},
{21,	29,	27,	3,	36},
{21,	16,	27,	8,	28},
{21,	18,	27,	8,	24},
{22,	19,	27,	7,	28},
{22,	20,	27,	7,	18},
{21,	26,	23,	12,	18},
{22,	27,	23,	11,	15},
{21,	14,	15,	31,	8},
{21,	23,	24,	12,	21},
{21,	39,	18,	15,	35},
{23,	29,	20,	10,	37},
{21,	1,	24,	18,	31},
{21,	39,	24,	4,	18},
{21,	28,	21,	12,	20},
{22,	30,	21,	11,	16},
{21,	9,	25,	12,	33},
{21,	23,	21,	21,	9},
{23,	21,	22,	21,	6},
{22,	18,	21,	21,	22},
{21,	23,	24,	15,	6},
{22,	22,	25,	13,	0},
{21,	29,	20,	18,	0},
{21,	21,	18,	25,	8},
{22,	20,	18,	24,	19},
{21,	24,	19,	21,	28},
{21,	8,	16,	29,	7},
{21,	24,	19,	18,	37},
{21,	26,	26,	6,	36},
{21,	23,	27,	5,	23},
{21,	39,	21,	9,	36},
{21,	22,	23,	15,	35},
{21,	30,	31,	1,	14},
{21,	28,	19,	19,	1},
{21,	26,	21,	15,	7},
{21,	26,	23,	15,	2},
{21,	15,	31,	3,	3},
{21,	2,	34,	4,	5},
{21,	7,	31,	5,	16},
{21,	2,	32,	4,	22},
{21,	23,	24,	14,	11},
{21,	25,	27,	5,	4},
{21,	3,	20,	23,	4},
{21,	16,	25,	10,	36},
{21,	7,	25,	10,	38},
{21,	20,	26,	8,	28},
{21,	20,	23,	19,	11},
{21,	17,	29,	5,	14},
{21,	12,	28,	8,	16},
{22,	10,	29,	8,	23},
{21,	33,	25,	3,	35},
{21,	28,	26,	6,	34},
{21,	20,	28,	5,	36},
{21,	8,	19,	26,	1},
{21,	22,	34,	1,	31},
{21,	24,	32,	1,	35},
{21,	24,	33,	0,	39},
{21,	9,	29,	7,	28},
{20,	15,	27,	15,	35},
{25,	16,	25,	14,	22},
{22,	16,	25,	15,	30},
{22,	17,	25,	15,	9},
{21,	20,	27,	7,	35},
{21,	23,	27,	6,	31},
{21,	21,	25,	14,	4},
{21,	21,	27,	6,	39},
{21,	16,	27,	15,	7},
{22,	19,	26,	12,	4},
{21,	22,	27,	6,	37},
{21,	17,	25,	12,	21},
{21,	16,	25,	15,	35},
{20,	22,	23,	21,	33},
{22,	20,	24,	16,	32},
{22,	23,	22,	20,	12},
{21,	3,	24,	17,	33},
{21,	12,	24,	18,	32},
{20,	25,	27,	9,	35},
{22,	18,	27,	11,	9},
{21,	27,	27,	4,	31},
{21,	20,	27,	10,	6},
{20,	17,	28,	9,	38},
{24,	16,	27,	10,	36},
{23,	22,	26,	9,	36},
{22,	15,	28,	7,	39},
{22,	21,	26,	9,	38},
{21,	19,	27,	7,	39},
{20,	39,	21,	15,	36},
{22,	25,	21,	14,	38},
{23,	26,	18,	18,	37},
{20,	39,	8,	35,	14},
{20,	26,	22,	20,	32},
{25,	25,	22,	18,	34},
{23,	24,	20,	21,	32},
{22,	26,	23,	15,	13},
{22,	25,	23,	15,	28},
{22,	26,	20,	18,	36},
{21,	27,	22,	15,	34},
{22,	28,	22,	15,	17},
{22,	28,	22,	10,	37},
{21,	39,	20,	18,	2},
{21,	27,	20,	21,	2},
{21,	25,	20,	21,	32},
{22,	25,	22,	21,	8},
{21,	25,	22,	21,	20},
{21,	26,	19,	21,	33},
{21,	24,	21,	18,	37},
{21,	25,	22,	18,	35},
{20,	39,	23,	9,	34},
{20,	19,	25,	18,	24},
{24,	19,	25,	12,	31},
{23,	20,	25,	12,	16},
{23,	22,	25,	10,	22},
{22,	19,	25,	12,	35},
{22,	19,	25,	15,	28},
{20,	17,	33,	4,	39},
{24,	18,	33,	3,	25},
{23,	15,	35,	3,	5},
{22,	4,	31,	5,	26},
{22,	4,	32,	5,	19},
{21,	15,	34,	4,	12},
{22,	8,	34,	4,	17},
{22,	5,	35,	3,	13},
{21,	11,	31,	5,	9},
{21,	4,	37,	3,	7},
{21,	8,	30,	5,	36},
{20,	39,	12,	32,	29},
{22,	9,	14,	32,	13},
{21,	13,	12,	34,	4},
{20,	39,	15,	23,	36},
{22,	39,	17,	23,	12},
{21,	12,	13,	27,	35},
{20,	21,	20,	25,	18},
{24,	20,	21,	23,	3},
{22,	21,	22,	23,	2},
{22,	21,	18,	25,	20},
{21,	21,	19,	23,	30},
{21,	6,	21,	25,	3},
{20,	26,	28,	6,	29},
{23,	25,	29,	3,	7},
{21,	29,	28,	3,	25},
{21,	25,	29,	3,	29},
{21,	26,	27,	6,	33},
{22,	26,	27,	4,	37},
{21,	27,	27,	3,	38},
{21,	29,	26,	3,	39},
{20,	6,	30,	10,	24},
{20,	21,	18,	28,	25},
{21,	8,	19,	26,	13},
{21,	23,	17,	28,	16},
{20,	6,	26,	15,	37},
{22,	10,	25,	14,	37},
{21,	7,	26,	10,	38},
{20,	9,	32,	9,	2},
{20,	9,	32,	6,	25},
{22,	7,	31,	9,	3},
{21,	8,	31,	6,	31},
{21,	3,	31,	6,	34},
{21,	8,	32,	5,	32},
{20,	30,	26,	5,	30},
{23,	30,	25,	7,	2},
{20,	39,	24,	6,	34},
{20,	21,	29,	6,	28},
{20,	23,	30,	3,	39},
{24,	20,	30,	4,	36},
{22,	24,	28,	4,	37},
{21,	19,	31,	3,	37},
{21,	27,	28,	3,	31},
{21,	26,	28,	3,	39},
{22,	26,	28,	5,	32},
{21,	23,	28,	5,	38},
{21,	23,	27,	6,	38},
{20,	19,	26,	12,	33},
{24,	22,	26,	10,	21},
{20,	22,	25,	12,	32},
{22,	21,	26,	11,	21},
{21,	23,	25,	12,	5},
{20,	23,	14,	31,	30},
{20,	11,	27,	18,	1},
{23,	15,	26,	17,	2},
{20,	9,	33,	6,	14},
{23,	9,	34,	5,	4},
{22,	4,	34,	5,	12},
{21,	3,	37,	5,	1},
{20,	33,	25,	4,	33},
{20,	27,	27,	6,	33},
{20,	20,	20,	23,	26},
{21,	4,	20,	22,	30},
{20,	18,	21,	23,	19},
{20,	15,	18,	23,	34},
{20,	27,	24,	10,	33},
{20,	14,	15,	31,	20},
{22,	0,	16,	29,	20},
{20,	3,	29,	7,	38},
{20,	4,	33,	6,	24},
{20,	7,	30,	11,	1},
{20,	13,	28,	15,	0},
{20,	27,	23,	14,	17},
{20,	16,	26,	12,	37},
{21,	21,	25,	11,	36},
{20,	29,	23,	6,	39},
{21,	28,	24,	6,	38},
{21,	27,	24,	7,	39},
{20,	10,	26,	18,	4},
{20,	26,	25,	10,	16},
{20,	16,	29,	7,	23},
{20,	4,	34,	6,	12},
{20,	3,	37,	4,	11},
{20,	22,	20,	25,	11},
{22,	23,	18,	28,	11},
{21,	24,	18,	25,	18},
{20,	24,	19,	25,	17},
{20,	6,	31,	7,	12},
{20,	5,	31,	9,	9},
{20,	5,	32,	9,	5},
{20,	23,	28,	6,	36},
{20,	39,	22,	6,	37},
{20,	29,	28,	4,	5},
{20,	39,	16,	23,	30},
{21,	39,	17,	23,	23},
{22,	39,	17,	24,	18},
{20,	22,	24,	12,	37},
{21,	24,	23,	12,	37},
{20,	3,	35,	5,	12},
{21,	3,	35,	6,	5},
{20,	20,	26,	12,	21},
{20,	33,	28,	1,	11},
{21,	32,	28,	0,	35},
{20,	4,	31,	8,	12},
{20,	18,	26,	12,	36},
{20,	24,	24,	15,	2},
{21,	25,	25,	12,	1},
{20,	23,	15,	29,	11},
{20,	26,	33,	0,	30},
{20,	27,	28,	3,	38},
{20,	13,	34,	5,	3},
{20,	10,	33,	5,	22},
{20,	2,	34,	2,	30},
{20,	9,	32,	9,	4},
{20,	18,	13,	33,	4},
{20,	21,	28,	6,	39},
{20,	39,	13,	29,	32},
{20,	26,	21,	19,	33},
{21,	24,	21,	21,	33},
{20,	27,	23,	12,	20},
{20,	25,	29,	3,	35},
{20,	16,	25,	14,	37},
{20,	12,	36,	5,	1},
{20,	4,	38,	5,	1},
{20,	9,	38,	4,	3},
{20,	10,	39,	4,	1},
{20,	27,	23,	15,	15},
{20,	39,	23,	5,	37},
{20,	12,	37,	0,	38},
{20,	17,	10,	35,	3},
{20,	10,	33,	6,	14},
{20,	10,	31,	6,	29},
{20,	32,	29,	0,	33},
{20,	22,	22,	24,	0},
{20,	24,	17,	23,	32},
{20,	6,	21,	25,	5},
{20,	33,	26,	0,	38},
{20,	25,	24,	10,	37},
{20,	39,	20,	17,	5},
{20,	16,	26,	15,	17},
{19,	20,	23,	21,	38},
{25,	22,	21,	18,	38},
{23,	23,	20,	21,	35},
{23,	22,	23,	15,	38},
{23,	22,	25,	10,	38},
{22,	21,	15,	21,	38},
{22,	23,	17,	19,	37},
{20,	19,	24,	12,	38},
{19,	13,	8,	35,	33},
{24,	14,	9,	33,	33},
{24,	39,	12,	32,	33},
{22,	39,	8,	35,	29},
{19,	26,	25,	12,	39},
{22,	27,	22,	15,	36},
{22,	24,	24,	15,	9},
{21,	23,	26,	7,	39},
{20,	23,	24,	15,	33},
{24,	24,	24,	15,	23},
{20,	26,	26,	6,	39},
{20,	21,	24,	18,	30},
{20,	29,	26,	4,	38},
{21,	27,	26,	6,	37},
{20,	26,	23,	15,	26},
{20,	26,	23,	18,	19},
{20,	24,	23,	17,	33},
{20,	27,	23,	15,	24},
{20,	25,	26,	7,	39},
{20,	22,	24,	14,	36},
{20,	26,	27,	4,	39},
{19,	9,	30,	15,	29},
{24,	9,	28,	14,	30},
{24,	8,	30,	8,	30},
{21,	10,	30,	13,	3},
{22,	10,	29,	10,	29},
{21,	9,	32,	8,	6},
{20,	3,	29,	8,	32},
{19,	20,	25,	21,	31},
{23,	3,	24,	20,	33},
{22,	14,	24,	23,	0},
{21,	20,	24,	19,	32},
{20,	20,	26,	15,	8},
{20,	19,	25,	15,	37},
{20,	14,	24,	24,	0},
{19,	31,	25,	9,	29},
{25,	29,	24,	9,	32},
{23,	27,	25,	9,	36},
{21,	29,	26,	6,	22},
{21,	32,	25,	6,	5},
{20,	28,	24,	10,	34},
{20,	32,	25,	5,	30},
{20,	29,	25,	10,	1},
{20,	29,	25,	9,	30},
{19,	39,	20,	21,	33},
{22,	39,	18,	24,	6},
{22,	29,	20,	18,	34},
{21,	26,	21,	21,	31},
{20,	25,	22,	21,	30},
{19,	9,	6,	36,	10},
{22,	15,	7,	36,	7},
{22,	10,	9,	36,	6},
{19,	8,	32,	9,	29},
{19,	39,	22,	15,	34},
{23,	29,	22,	15,	36},
{21,	29,	24,	10,	25},
{20,	29,	23,	12,	7},
{21,	28,	23,	15,	7},
{20,	30,	22,	10,	37},
{20,	30,	23,	10,	25},
{19,	5,	26,	18,	29},
{20,	8,	26,	17,	26},
{19,	3,	33,	9,	27},
{20,	9,	33,	9,	2},
{20,	3,	34,	7,	1},
{19,	14,	23,	23,	21},
{22,	17,	22,	23,	14},
{20,	2,	24,	22,	3},
{19,	3,	26,	20,	18},
{22,	8,	26,	20,	5},
{22,	9,	26,	21,	1},
{19,	26,	24,	18,	21},
{21,	25,	24,	15,	25},
{20,	22,	24,	20,	3},
{19,	17,	32,	6,	28},
{23,	16,	33,	6,	14},
{21,	14,	33,	6,	27},
{20,	19,	30,	6,	14},
{20,	12,	33,	7,	3},
{19,	14,	30,	10,	27},
{23,	12,	30,	13,	5},
{21,	12,	28,	13,	25},
{21,	16,	30,	9,	6},
{21,	14,	30,	9,	29},
{21,	17,	28,	10,	15},
{22,	16,	29,	10,	13},
{20,	12,	31,	7,	29},
{20,	17,	29,	9,	9},
{20,	18,	29,	7,	14},
{20,	13,	29,	12,	7},
{21,	13,	29,	11,	26},
{20,	15,	32,	5,	31},
{20,	12,	33,	5,	36},
{20,	14,	30,	6,	38},
{21,	16,	30,	6,	35},
{21,	14,	29,	8,	32},
{21,	12,	31,	6,	35},
{20,	14,	29,	10,	30},
{20,	1,	30,	12,	30},
{20,	14,	29,	9,	32},
{20,	17,	32,	5,	35},
{19,	3,	36,	5,	30},
{23,	5,	35,	3,	34},
{22,	3,	37,	5,	11},
{21,	10,	35,	2,	36},
{20,	10,	36,	3,	32},
{21,	9,	37,	5,	6},
{20,	6,	39,	5,	5},
{20,	5,	38,	4,	11},
{19,	21,	18,	28,	30},
{21,	21,	17,	26,	32},
{22,	15,	18,	24,	34},
{21,	14,	17,	26,	34},
{20,	15,	18,	25,	32},
{19,	30,	27,	4,	37},
{20,	31,	27,	3,	7},
{20,	31,	26,	3,	35},
{19,	31,	26,	6,	33},
{20,	29,	25,	6,	35},
{19,	23,	16,	31,	20},
{21,	15,	18,	31,	3},
{21,	12,	18,	32,	1},
{20,	23,	15,	31,	28},
{22,	14,	15,	29,	34},
{19,	2,	27,	20,	4},
{19,	3,	28,	18,	15},
{21,	13,	28,	18,	0},
{20,	8,	27,	17,	15},
{19,	0,	27,	18,	27},
{23,	1,	28,	17,	17},
{21,	6,	27,	18,	20},
{20,	3,	28,	18,	17},
{19,	19,	21,	25,	18},
{19,	24,	19,	28,	11},
{21,	2,	20,	29,	0},
{20,	11,	19,	27,	16},
{20,	15,	19,	29,	3},
{19,	19,	25,	15,	38},
{19,	22,	24,	21,	31},
{20,	22,	24,	20,	32},
{19,	22,	25,	17,	31},
{20,	23,	25,	16,	4},
{19,	3,	35,	9,	3},
{19,	22,	17,	31,	16},
{21,	22,	18,	29,	6},
{20,	19,	18,	29,	14},
{21,	3,	18,	30,	16},
{19,	28,	21,	21,	20},
{22,	28,	21,	17,	29},
{21,	29,	21,	18,	16},
{20,	39,	21,	18,	2},
{19,	3,	28,	20,	3},
{19,	22,	26,	12,	29},
{21,	21,	26,	12,	33},
{20,	24,	26,	13,	0},
{21,	23,	26,	10,	30},
{19,	33,	26,	4,	22},
{20,	33,	27,	4,	1},
{19,	27,	24,	12,	34},
{20,	27,	24,	13,	21},
{19,	23,	32,	3,	29},
{19,	27,	29,	3,	37},
{19,	39,	12,	34,	18},
{19,	9,	30,	6,	39},
{19,	9,	29,	8,	36},
{19,	22,	32,	4,	22},
{20,	21,	30,	5,	14},
{19,	8,	31,	10,	12},
{19,	25,	26,	9,	38},
{19,	18,	26,	14,	34},
{19,	8,	10,	34,	33},
{19,	25,	19,	18,	38},
{20,	26,	21,	15,	37},
{20,	39,	16,	16,	38},
{19,	9,	24,	17,	35},
{19,	39,	14,	31,	30},
{20,	24,	16,	31,	20},
{20,	26,	16,	30,	2},
{20,	26,	20,	25,	3},
{21,	25,	20,	22,	18},
{20,	39,	18,	23,	13},
{19,	24,	16,	29,	31},
{20,	24,	16,	30,	23},
{19,	25,	19,	23,	30},
{20,	24,	18,	25,	24},
{19,	21,	17,	29,	30},
{22,	10,	17,	31,	21},
{20,	1,	18,	30,	22},
{19,	2,	20,	26,	18},
{20,	2,	20,	27,	7},
{19,	15,	26,	17,	16},
{19,	27,	27,	7,	10},
{19,	4,	31,	12,	1},
{19,	27,	24,	9,	39},
{20,	27,	23,	12,	38},
{19,	27,	24,	15,	20},
{19,	3,	22,	24,	17},
{20,	1,	22,	26,	6},
{21,	2,	22,	28,	0},
{21,	17,	22,	25,	3},
{19,	3,	19,	31,	8},
{19,	28,	24,	15,	7},
{20,	29,	24,	13,	3},
{19,	30,	28,	1,	39},
{19,	20,	24,	20,	33},
{19,	39,	21,	20,	4},
{19,	39,	16,	23,	35},
{20,	17,	16,	23,	36},
{19,	22,	33,	3,	29},
{19,	14,	29,	10,	32},
{19,	13,	16,	25,	35},
{19,	12,	16,	33,	5},
{20,	16,	14,	33,	9},
{19,	2,	21,	33,	0},
{19,	2,	20,	31,	6},
{19,	30,	26,	5,	36},
{20,	29,	25,	5,	38},
{19,	22,	19,	28,	14},
{19,	15,	26,	15,	37},
{19,	3,	27,	21,	1},
{19,	29,	26,	7,	7},
{19,	23,	25,	16,	11},
{19,	39,	18,	14,	37},
{20,	28,	21,	13,	37},
{20,	39,	18,	11,	39},
{19,	30,	21,	12,	38},
{19,	17,	14,	30,	33},
{21,	9,	15,	30,	34},
{19,	24,	24,	20,	1},
{19,	2,	28,	20,	4},
{19,	3,	19,	23,	33},
{19,	17,	29,	6,	38},
{19,	24,	22,	18,	37},
{19,	10,	26,	17,	26},
{19,	4,	27,	10,	37},
{19,	26,	21,	23,	2},
{19,	24,	22,	26,	0},
{21,	11,	21,	26,	8},
{19,	5,	20,	26,	22},
{22,	22,	19,	25,	22},
{21,	3,	22,	24,	21},
{20,	17,	19,	25,	31},
{23,	5,	20,	26,	26},
{21,	12,	19,	26,	30},
{20,	21,	19,	26,	26},
{20,	19,	20,	25,	26},
{19,	19,	21,	25,	21},
{19,	18,	20,	29,	2},
{19,	14,	24,	18,	34},
{19,	7,	34,	5,	28},
{20,	8,	36,	5,	17},
{21,	8,	38,	5,	11},
{19,	13,	20,	29,	6},
{19,	23,	22,	20,	34},
{19,	17,	22,	23,	21},
{19,	21,	26,	11,	36},
{19,	31,	30,	0,	27},
{19,	32,	33,	0,	6},
{20,	27,	32,	1,	28},
{19,	26,	33,	1,	39},
{20,	24,	34,	1,	34},
{19,	7,	11,	34,	24},
{20,	15,	12,	34,	21},
{19,	25,	23,	15,	33},
{20,	25,	24,	14,	29},
{19,	22,	27,	10,	8},
{19,	20,	15,	25,	35},
{19,	20,	27,	15,	0},
{21,	19,	27,	12,	6},
{19,	39,	16,	24,	33},
{20,	39,	15,	25,	30},
{20,	25,	18,	25,	21},
{19,	25,	15,	29,	27},
{19,	39,	16,	26,	21},
{19,	28,	21,	11,	39},
{19,	21,	25,	18,	31},
{19,	20,	27,	9,	36},
{19,	22,	20,	22,	28},
{19,	10,	31,	5,	37},
{19,	8,	19,	27,	20},
{19,	39,	14,	20,	37},
{19,	22,	23,	21,	34},
{19,	15,	8,	36,	9},
{19,	9,	39,	5,	6},
{19,	8,	39,	2,	26},
{20,	0,	38,	4,	23},
{19,	16,	39,	1,	20},
{19,	16,	39,	0,	33},
{19,	20,	25,	14,	37},
{19,	21,	25,	15,	34},
{19,	39,	21,	18,	8},
{19,	29,	21,	19,	16},
{19,	2,	35,	2,	38},
{19,	5,	37,	3,	30},
{19,	21,	18,	21,	38},
{19,	26,	23,	14,	33},
{19,	26,	23,	18,	29},
{19,	27,	31,	1,	37},
{19,	8,	27,	17,	22},
{19,	25,	39,	1,	2},
{20,	24,	35,	1,	29},
{19,	16,	29,	8,	23},
{19,	39,	16,	22,	36},
{19,	22,	23,	18,	36},
{19,	24,	23,	17,	36},
{21,	24,	23,	15,	38},
{21,	26,	23,	15,	35},
{19,	23,	23,	18,	37},
{19,	26,	29,	3,	39},
{19,	28,	28,	3,	31},
{19,	28,	26,	6,	36},
{19,	14,	29,	11,	25},
{19,	32,	24,	7,	7},
{19,	21,	26,	14,	8},
{19,	28,	27,	3,	39},
{19,	14,	35,	2,	37},
{19,	14,	34,	3,	35},
{19,	6,	27,	18,	26},
{19,	4,	27,	17,	29},
{19,	6,	29,	11,	31},
{19,	39,	12,	33,	23},
{19,	16,	31,	6,	35},
{19,	25,	27,	10,	2},
{18,	4,	32,	20,	24},
{22,	4,	31,	10,	29},
{21,	5,	29,	18,	16},
{20,	4,	33,	18,	1},
{20,	6,	28,	18,	24},
{20,	9,	27,	19,	3},
{20,	8,	31,	11,	16},
{21,	5,	31,	16,	14},
{21,	12,	31,	14,	0},
{20,	7,	32,	13,	3},
{20,	7,	32,	10,	25},
{19,	3,	33,	10,	17},
{21,	1,	34,	10,	3},
{19,	6,	28,	18,	25},
{19,	4,	33,	15,	2},
{19,	5,	31,	18,	14},
{19,	9,	28,	19,	1},
{21,	7,	28,	18,	21},
{19,	10,	26,	18,	26},
{19,	8,	28,	18,	16},
{19,	7,	30,	18,	2},
{19,	4,	31,	11,	27},
{18,	25,	29,	10,	38},
{21,	26,	27,	6,	37},
{21,	25,	28,	5,	39},
{20,	23,	30,	4,	27},
{20,	23,	30,	5,	14},
{20,	27,	27,	6,	36},
{20,	21,	30,	4,	39},
{19,	19,	27,	12,	31},
{20,	18,	27,	12,	35},
{19,	21,	28,	12,	14},
{21,	21,	27,	12,	19},
{20,	16,	28,	13,	15},
{19,	16,	28,	14,	9},
{21,	13,	28,	14,	19},
{19,	22,	28,	12,	2},
{19,	21,	27,	12,	23},
{19,	26,	28,	8,	0},
{18,	30,	21,	15,	39},
{18,	39,	8,	37,	16},
{21,	10,	10,	37,	4},
{19,	2,	4,	36,	19},
{19,	0,	7,	36,	19},
{18,	29,	26,	9,	39},
{20,	27,	27,	7,	23},
{20,	26,	27,	8,	12},
{19,	21,	27,	10,	39},
{19,	26,	26,	10,	38},
{18,	20,	31,	9,	37},
{23,	20,	30,	10,	16},
{23,	11,	30,	10,	34},
{22,	13,	31,	10,	25},
{21,	12,	33,	9,	2},
{21,	21,	31,	4,	39},
{20,	13,	32,	10,	23},
{20,	19,	32,	6,	19},
{20,	12,	33,	12,	0},
{20,	19,	33,	5,	14},
{19,	8,	32,	8,	36},
{19,	17,	31,	10,	23},
{19,	8,	33,	6,	32},
{19,	22,	32,	4,	29},
{19,	22,	30,	5,	35},
{19,	22,	30,	7,	3},
{19,	19,	31,	10,	16},
{19,	10,	33,	12,	2},
{19,	18,	30,	5,	39},
{18,	22,	15,	24,	37},
{18,	19,	10,	36,	29},
{21,	17,	10,	37,	10},
{19,	15,	12,	33,	30},
{21,	9,	11,	34,	32},
{18,	4,	36,	9,	24},
{21,	4,	39,	6,	1},
{21,	5,	36,	7,	24},
{20,	5,	39,	8,	0},
{20,	7,	36,	6,	17},
{20,	5,	34,	9,	19},
{20,	5,	38,	7,	2},
{19,	4,	34,	9,	27},
{19,	0,	37,	6,	18},
{19,	5,	38,	5,	17},
{18,	39,	16,	26,	36},
{20,	12,	15,	29,	35},
{21,	24,	15,	28,	35},
{20,	25,	16,	28,	34},
{19,	9,	15,	30,	35},
{18,	22,	26,	18,	31},
{19,	22,	26,	12,	36},
{21,	19,	26,	15,	35},
{19,	21,	26,	14,	35},
{19,	24,	26,	16,	0},
{19,	16,	28,	18,	0},
{18,	28,	23,	20,	24},
{22,	29,	22,	18,	16},
{22,	25,	23,	21,	16},
{21,	25,	23,	20,	27},
{21,	28,	23,	11,	38},
{20,	26,	24,	19,	2},
{20,	28,	21,	20,	27},
{19,	29,	22,	18,	24},
{19,	24,	23,	21,	27},
{19,	29,	21,	18,	30},
{19,	27,	21,	18,	34},
{19,	27,	24,	20,	0},
{18,	11,	11,	34,	34},
{19,	39,	9,	33,	34},
{18,	14,	25,	23,	19},
{19,	14,	24,	24,	1},
{18,	31,	24,	12,	28},
{22,	28,	24,	12,	33},
{21,	28,	24,	15,	19},
{21,	29,	23,	10,	39},
{19,	31,	23,	12,	32},
{20,	29,	24,	12,	32},
{18,	25,	22,	23,	27},
{21,	20,	23,	23,	10},
{21,	4,	21,	22,	30},
{20,	8,	20,	26,	27},
{20,	13,	23,	23,	22},
{20,	23,	21,	22,	29},
{19,	20,	25,	22,	1},
{19,	22,	21,	24,	17},
{18,	30,	28,	4,	39},
{19,	29,	29,	3,	35},
{19,	39,	23,	4,	39},
{19,	28,	29,	3,	39},
{19,	30,	29,	3,	7},
{19,	31,	24,	4,	39},
{19,	27,	33,	0,	39},
{19,	27,	34,	0,	34},
{18,	1,	37,	18,	0},
{20,	1,	34,	15,	1},
{19,	4,	36,	15,	0},
{19,	5,	34,	10,	6},
{18,	25,	25,	18,	25},
{20,	23,	25,	17,	30},
{18,	27,	29,	6,	27},
{21,	27,	28,	5,	36},
{18,	5,	29,	15,	33},
{20,	5,	30,	12,	31},
{19,	12,	29,	11,	33},
{19,	9,	29,	14,	31},
{18,	26,	31,	3,	39},
{21,	24,	30,	4,	35},
{20,	26,	33,	3,	3},
{20,	27,	30,	5,	1},
{18,	3,	27,	21,	17},
{19,	2,	28,	21,	5},
{19,	3,	26,	21,	22},
{18,	17,	31,	9,	38},
{18,	4,	32,	12,	30},
{18,	22,	26,	12,	39},
{19,	11,	26,	15,	38},
{18,	21,	19,	28,	30},
{19,	2,	20,	27,	21},
{19,	21,	20,	25,	27},
{18,	18,	21,	28,	19},
{22,	19,	22,	28,	1},
{20,	17,	20,	29,	8},
{19,	18,	20,	26,	27},
{19,	18,	20,	27,	25},
{18,	8,	28,	12,	36},
{18,	12,	32,	10,	33},
{18,	5,	33,	10,	32},
{19,	2,	34,	7,	29},
{18,	6,	34,	10,	27},
{21,	6,	36,	8,	17},
{19,	11,	34,	8,	4},
{21,	8,	36,	9,	2},
{20,	12,	36,	6,	4},
{19,	7,	34,	17,	0},
{20,	5,	32,	18,	14},
{19,	5,	33,	15,	4},
{19,	13,	34,	10,	1},
{19,	9,	32,	15,	2},
{19,	15,	33,	7,	8},
{19,	2,	34,	11,	5},
{19,	11,	39,	5,	6},
{19,	11,	35,	5,	17},
{19,	11,	35,	6,	14},
{18,	39,	21,	20,	21},
{18,	16,	24,	25,	3},
{20,	16,	25,	23,	10},
{18,	15,	28,	15,	25},
{20,	20,	28,	12,	17},
{19,	11,	32,	15,	1},
{19,	10,	33,	15,	2},
{19,	15,	29,	15,	1},
{18,	21,	23,	14,	39},
{20,	21,	24,	13,	39},
{18,	14,	17,	31,	29},
{19,	25,	16,	31,	23},
{18,	25,	17,	21,	38},
{19,	26,	17,	21,	37},
{18,	4,	32,	15,	26},
{19,	4,	32,	13,	27},
{19,	4,	31,	14,	28},
{18,	6,	27,	18,	31},
{18,	31,	31,	1,	32},
{18,	5,	35,	9,	27},
{20,	4,	36,	9,	25},
{18,	29,	20,	21,	34},
{22,	25,	21,	19,	35},
{19,	25,	18,	20,	37},
{18,	33,	25,	5,	30},
{18,	22,	30,	6,	35},
{18,	29,	25,	10,	21},
{22,	28,	25,	10,	34},
{18,	6,	34,	15,	3},
{18,	4,	38,	9,	2},
{21,	1,	38,	12,	0},
{19,	7,	39,	9,	0},
{18,	12,	15,	31,	35},
{18,	29,	27,	7,	2},
{19,	28,	27,	6,	5},
{18,	12,	33,	5,	38},
{18,	17,	27,	21,	0},
{19,	11,	26,	21,	4},
{19,	17,	26,	19,	3},
{18,	11,	33,	6,	36},
{19,	17,	32,	6,	35},
{18,	6,	29,	13,	34},
{18,	20,	33,	6,	14},
{19,	22,	32,	6,	1},
{18,	27,	27,	8,	12},
{18,	30,	29,	3,	24},
{18,	18,	20,	31,	3},
{19,	12,	20,	33,	1},
{19,	12,	17,	33,	5},
{18,	39,	22,	8,	36},
{18,	30,	26,	6,	36},
{18,	19,	18,	29,	25},
{19,	16,	18,	30,	20},
{20,	17,	20,	30,	7},
{18,	26,	23,	21,	20},
{18,	23,	18,	28,	26},
{20,	24,	19,	28,	17},
{18,	27,	19,	18,	37},
{18,	24,	23,	21,	31},
{18,	39,	15,	31,	28},
{18,	30,	22,	8,	39},
{18,	33,	30,	1,	7},
{19,	32,	29,	1,	20},
{18,	18,	28,	12,	23},
{18,	7,	34,	8,	27},
{19,	9,	34,	8,	13},
{18,	10,	33,	10,	30},
{20,	13,	33,	10,	9},
{19,	8,	34,	10,	14},
{18,	30,	27,	5,	7},
{19,	30,	28,	5,	1},
{18,	20,	17,	31,	26},
{18,	24,	20,	26,	8},
{21,	20,	20,	28,	18},
{19,	22,	20,	27,	17},
{18,	27,	22,	21,	24},
{18,	4,	30,	12,	32},
{18,	13,	29,	17,	1},
{18,	26,	22,	17,	36},
{18,	21,	17,	26,	34},
{18,	23,	23,	19,	35},
{18,	12,	28,	15,	30},
{18,	11,	29,	13,	30},
{18,	5,	31,	18,	22},
{18,	15,	28,	15,	27},
{18,	13,	29,	12,	28},
{18,	19,	26,	13,	38},
{19,	20,	26,	14,	37},
{18,	20,	28,	12,	21},
{18,	39,	17,	21,	36},
{18,	24,	21,	17,	38},
{18,	23,	24,	18,	32},
{18,	21,	33,	4,	25},
{18,	22,	27,	12,	9},
{18,	15,	33,	9,	1},
{18,	18,	32,	8,	7},
{19,	18,	33,	10,	0},
{18,	8,	24,	21,	32},
{18,	18,	13,	32,	16},
{18,	13,	14,	34,	15},
{20,	12,	17,	34,	1},
{19,	1,	13,	34,	20},
{18,	18,	13,	36,	0},
{20,	20,	11,	35,	9},
{19,	12,	16,	35,	1},
{18,	14,	11,	36,	29},
{19,	14,	11,	37,	10},
{18,	25,	27,	11,	1},
{18,	26,	22,	15,	37},
{18,	39,	23,	12,	0},
{18,	39,	26,	1,	5},
{18,	5,	20,	32,	4},
{18,	15,	18,	26,	32},
{18,	33,	26,	1,	37},
{18,	15,	18,	25,	34},
{18,	6,	29,	18,	21},
{18,	31,	24,	13,	2},
{18,	10,	34,	13,	2},
{18,	26,	19,	17,	38},
{18,	13,	32,	8,	35},
{18,	16,	29,	11,	23},
{18,	18,	28,	15,	1},
{18,	17,	27,	13,	24},
{18,	34,	28,	0,	6},
{18,	27,	30,	4,	4},
{18,	19,	30,	9,	38},
{18,	22,	21,	25,	10},
{18,	26,	21,	25,	3},
{18,	18,	14,	34,	11},
{18,	32,	26,	6,	1},
{18,	24,	34,	3,	2},
{19,	17,	35,	4,	7},
{18,	0,	38,	5,	20},
{18,	27,	21,	19,	33},
{18,	27,	22,	19,	32},
{19,	29,	22,	18,	27},
{18,	29,	22,	18,	34},
{18,	20,	35,	0,	39},
{18,	8,	27,	17,	31},
{17,	6,	35,	20,	30},
{21,	8,	36,	12,	2},
{22,	1,	38,	12,	1},
{21,	7,	28,	20,	13},
{21,	8,	32,	13,	14},
{21,	5,	28,	17,	31},
{20,	7,	26,	20,	31},
{20,	7,	36,	14,	1},
{20,	8,	26,	20,	24},
{19,	5,	34,	10,	32},
{19,	10,	26,	20,	30},
{21,	9,	27,	19,	15},
{19,	11,	34,	6,	33},
{20,	16,	34,	4,	33},
{20,	11,	35,	5,	31},
{20,	8,	34,	10,	30},
{19,	8,	35,	9,	30},
{19,	10,	29,	20,	0},
{19,	10,	26,	21,	17},
{19,	9,	34,	8,	32},
{19,	3,	36,	5,	32},
{19,	10,	35,	6,	32},
{20,	3,	35,	10,	31},
{18,	16,	26,	19,	10},
{19,	12,	26,	19,	21},
{19,	11,	26,	20,	30},
{18,	6,	31,	13,	31},
{20,	4,	31,	12,	32},
{19,	6,	32,	12,	31},
{18,	3,	35,	10,	32},
{18,	7,	31,	15,	29},
{18,	5,	33,	12,	31},
{18,	10,	36,	5,	25},
{18,	8,	36,	10,	4},
{18,	4,	36,	10,	24},
{18,	6,	36,	10,	20},
{18,	8,	28,	17,	29},
{18,	7,	32,	13,	30},
{18,	12,	30,	18,	0},
{18,	10,	33,	16,	1},
{17,	17,	8,	38,	33},
{20,	5,	10,	38,	10},
{19,	10,	9,	37,	20},
{18,	39,	10,	34,	32},
{18,	10,	10,	37,	20},
{18,	5,	10,	38,	17},
{17,	19,	25,	28,	27},
{22,	20,	24,	24,	14},
{19,	21,	23,	26,	2},
{20,	20,	24,	26,	10},
{19,	20,	23,	28,	10},
{18,	15,	22,	25,	30},
{24,	19,	21,	26,	29},
{20,	18,	25,	23,	28},
{20,	21,	20,	27,	28},
{19,	25,	20,	23,	30},
{19,	20,	21,	25,	29},
{19,	21,	22,	26,	17},
{18,	20,	25,	28,	3},
{18,	15,	22,	26,	29},
{18,	22,	22,	25,	14},
{18,	21,	20,	26,	30},
{17,	19,	26,	21,	37},
{20,	22,	24,	21,	34},
{18,	22,	24,	17,	36},
{20,	20,	24,	21,	37},
{19,	21,	25,	17,	35},
{18,	20,	25,	21,	37},
{18,	8,	27,	17,	32},
{18,	5,	28,	16,	32},
{17,	20,	28,	15,	39},
{19,	21,	27,	15,	24},
{18,	8,	29,	15,	34},
{18,	12,	29,	13,	33},
{18,	12,	30,	13,	9},
{17,	25,	24,	17,	39},
{20,	25,	25,	15,	30},
{21,	25,	25,	18,	28},
{20,	26,	22,	18,	37},
{19,	17,	25,	17,	38},
{18,	26,	24,	18,	29},
{18,	26,	24,	14,	34},
{18,	27,	21,	18,	36},
{17,	24,	20,	28,	36},
{20,	25,	18,	25,	33},
{19,	19,	18,	29,	31},
{19,	25,	19,	24,	34},
{19,	4,	21,	24,	31},
{19,	12,	21,	22,	33},
{19,	25,	20,	21,	36},
{18,	19,	18,	29,	32},
{17,	29,	28,	9,	34},
{20,	29,	28,	5,	36},
{20,	30,	27,	6,	5},
{19,	30,	27,	5,	32},
{19,	30,	27,	6,	14},
{19,	26,	28,	6,	37},
{19,	30,	28,	5,	10},
{18,	31,	27,	6,	24},
{18,	29,	27,	6,	39},
{20,	24,	27,	8,	39},
{19,	29,	27,	7,	36},
{18,	24,	28,	10,	39},
{18,	32,	27,	3,	16},
{18,	32,	27,	5,	7},
{18,	28,	28,	5,	38},
{18,	27,	28,	6,	39},
{19,	27,	28,	7,	37},
{18,	33,	26,	5,	7},
{17,	39,	24,	15,	31},
{22,	31,	25,	9,	31},
{20,	29,	23,	18,	26},
{19,	31,	25,	8,	33},
{19,	30,	24,	8,	36},
{18,	30,	23,	9,	37},
{20,	30,	25,	6,	37},
{18,	30,	25,	7,	37},
{17,	27,	26,	15,	34},
{21,	29,	27,	10,	1},
{19,	26,	25,	18,	24},
{19,	28,	25,	11,	13},
{19,	23,	26,	16,	15},
{19,	23,	25,	13,	39},
{19,	22,	25,	15,	37},
{19,	27,	23,	15,	36},
{18,	25,	25,	15,	39},
{18,	23,	26,	18,	15},
{18,	28,	27,	10,	6},
{18,	25,	27,	11,	10},
{18,	26,	25,	15,	35},
{19,	26,	24,	14,	37},
{18,	21,	26,	15,	38},
{18,	27,	25,	12,	35},
{18,	29,	24,	10,	38},
{19,	27,	25,	12,	37},
{18,	28,	24,	11,	38},
{17,	33,	26,	6,	39},
{19,	32,	27,	5,	11},
{19,	32,	27,	1,	39},
{18,	32,	27,	6,	7},
{17,	15,	10,	36,	35},
{19,	14,	11,	36,	32},
{17,	19,	21,	31,	25},
{21,	20,	20,	31,	12},
{19,	22,	20,	31,	5},
{18,	18,	21,	32,	1},
{17,	39,	25,	9,	30},
{21,	39,	25,	5,	34},
{18,	32,	25,	7,	34},
{18,	31,	25,	8,	36},
{18,	39,	23,	7,	36},
{17,	19,	14,	31,	36},
{18,	39,	14,	31,	35},
{17,	22,	26,	21,	34},
{21,	23,	25,	18,	35},
{19,	25,	24,	18,	37},
{17,	20,	27,	20,	25},
{22,	17,	27,	17,	29},
{22,	16,	28,	17,	6},
{21,	11,	27,	20,	28},
{20,	16,	28,	17,	10},
{21,	11,	28,	17,	19},
{20,	11,	27,	21,	11},
{19,	8,	28,	19,	28},
{19,	20,	27,	17,	29},
{19,	11,	27,	19,	30},
{18,	7,	29,	21,	1},
{18,	15,	28,	17,	15},
{18,	11,	27,	21,	17},
{17,	8,	27,	28,	6},
{21,	14,	26,	23,	6},
{19,	10,	27,	24,	6},
{18,	4,	26,	28,	7},
{18,	10,	27,	27,	2},
{17,	5,	29,	18,	35},
{19,	13,	27,	18,	32},
{17,	39,	26,	4,	34},
{17,	39,	18,	28,	34},
{19,	26,	16,	30,	26},
{18,	25,	19,	28,	31},
{18,	25,	20,	28,	26},
{19,	25,	22,	26,	2},
{19,	25,	20,	26,	33},
{17,	4,	37,	10,	24},
{19,	4,	37,	14,	1},
{19,	2,	38,	4,	27},
{18,	2,	39,	4,	25},
{20,	11,	39,	5,	9},
{18,	4,	38,	12,	2},
{18,	8,	37,	5,	24},
{18,	10,	39,	4,	17},
{17,	8,	27,	23,	16},
{19,	8,	26,	25,	8},
{18,	14,	26,	23,	15},
{18,	11,	27,	22,	16},
{17,	25,	27,	12,	34},
{19,	24,	27,	14,	1},
{17,	39,	22,	20,	20},
{17,	1,	36,	10,	33},
{21,	8,	33,	8,	34},
{19,	4,	33,	8,	36},
{18,	7,	36,	7,	30},
{17,	8,	26,	28,	15},
{17,	6,	35,	21,	3},
{17,	6,	33,	21,	13},
{17,	22,	33,	6,	25},
{19,	22,	31,	6,	35},
{17,	21,	15,	33,	27},
{23,	22,	14,	34,	21},
{20,	23,	13,	32,	33},
{20,	22,	17,	33,	5},
{19,	13,	14,	33,	30},
{20,	3,	14,	32,	35},
{19,	18,	17,	33,	7},
{18,	15,	17,	32,	14},
{17,	32,	31,	1,	39},
{17,	4,	28,	21,	27},
{20,	2,	30,	21,	17},
{18,	5,	33,	21,	14},
{17,	28,	24,	18,	28},
{18,	27,	24,	20,	4},
{18,	29,	23,	18,	29},
{17,	29,	24,	12,	39},
{20,	30,	22,	13,	37},
{20,	27,	25,	12,	39},
{18,	29,	22,	15,	37},
{17,	18,	21,	25,	35},
{19,	21,	21,	23,	35},
{18,	11,	21,	23,	36},
{17,	39,	22,	18,	33},
{20,	39,	21,	19,	24},
{18,	30,	22,	18,	34},
{18,	29,	21,	21,	22},
{18,	29,	22,	21,	11},
{17,	7,	29,	14,	37},
{20,	7,	29,	15,	36},
{19,	7,	29,	11,	38},
{19,	15,	29,	11,	36},
{17,	18,	23,	32,	2},
{20,	18,	23,	33,	0},
{18,	6,	24,	29,	2},
{18,	0,	26,	29,	1},
{17,	4,	37,	13,	8},
{18,	4,	37,	14,	2},
{18,	7,	36,	14,	3},
{17,	4,	36,	15,	14},
{21,	4,	36,	13,	16},
{19,	1,	36,	17,	1},
{18,	5,	36,	14,	15},
{17,	5,	28,	22,	11},
{21,	5,	28,	24,	0},
{17,	15,	24,	21,	38},
{21,	17,	25,	18,	38},
{17,	12,	31,	7,	39},
{21,	14,	32,	5,	39},
{17,	25,	29,	8,	39},
{20,	20,	30,	7,	39},
{18,	17,	30,	8,	39},
{17,	39,	25,	6,	37},
{20,	34,	26,	0,	39},
{18,	39,	25,	1,	39},
{18,	34,	26,	1,	38},
{18,	39,	26,	1,	36},
{17,	39,	21,	20,	33},
{18,	27,	23,	20,	28},
{17,	29,	24,	15,	36},
{20,	30,	24,	15,	33},
{20,	27,	25,	15,	36},
{19,	31,	25,	9,	33},
{18,	39,	23,	11,	33},
{18,	31,	24,	10,	34},
{17,	29,	23,	18,	35},
{21,	26,	24,	17,	36},
{20,	27,	23,	20,	30},
{17,	30,	28,	6,	25},
{17,	32,	27,	4,	31},
{18,	31,	27,	5,	31},
{17,	27,	24,	20,	11},
{18,	26,	24,	20,	12},
{17,	8,	30,	18,	29},
{18,	10,	30,	16,	7},
{17,	24,	29,	10,	39},
{17,	4,	37,	18,	2},
{17,	8,	34,	7,	36},
{20,	8,	34,	5,	37},
{19,	12,	35,	3,	37},
{18,	8,	34,	8,	35},
{18,	1,	36,	3,	37},
{18,	10,	37,	3,	36},
{18,	3,	37,	4,	34},
{18,	0,	38,	3,	33},
{18,	10,	39,	2,	30},
{17,	16,	29,	12,	33},
{18,	16,	29,	15,	3},
{17,	21,	27,	15,	38},
{17,	21,	27,	19,	25},
{17,	26,	32,	3,	29},
{18,	25,	33,	3,	23},
{17,	8,	29,	20,	27},
{18,	7,	30,	20,	11},
{17,	13,	33,	10,	26},
{18,	14,	33,	7,	28},
{18,	14,	32,	8,	35},
{18,	14,	33,	8,	27},
{17,	24,	25,	20,	9},
{19,	23,	26,	20,	9},
{17,	39,	17,	21,	38},
{17,	25,	22,	24,	22},
{19,	22,	21,	26,	22},
{18,	23,	22,	25,	16},
{19,	26,	21,	26,	5},
{18,	26,	21,	25,	8},
{17,	4,	33,	9,	35},
{17,	21,	27,	18,	31},
{17,	4,	30,	12,	34},
{17,	26,	28,	9,	37},
{17,	26,	19,	28,	31},
{20,	26,	20,	24,	29},
{18,	26,	21,	23,	22},
{17,	7,	33,	16,	21},
{20,	8,	33,	15,	12},
{17,	17,	30,	9,	39},
{17,	39,	25,	4,	39},
{17,	27,	20,	27,	7},
{17,	10,	15,	34,	17},
{18,	11,	15,	35,	3},
{18,	11,	12,	37,	4},
{18,	22,	17,	34,	2},
{17,	17,	18,	31,	28},
{17,	26,	22,	23,	22},
{18,	27,	22,	25,	1},
{17,	9,	28,	20,	19},
{17,	4,	37,	11,	14},
{17,	15,	35,	7,	2},
{18,	9,	35,	8,	33},
{20,	14,	35,	9,	2},
{18,	10,	36,	8,	5},
{17,	27,	18,	17,	39},
{17,	5,	39,	6,	6},
{17,	22,	26,	15,	38},
{17,	27,	23,	19,	32},
{17,	29,	22,	14,	38},
{17,	5,	21,	34,	0},
{17,	27,	29,	4,	35},
{17,	22,	19,	29,	21},
{17,	20,	21,	31,	16},
{18,	20,	23,	28,	16},
{18,	20,	24,	23,	24},
{17,	21,	23,	23,	32},
{18,	17,	24,	23,	30},
{17,	24,	23,	23,	28},
{19,	26,	23,	23,	6},
{18,	25,	23,	23,	20},
{17,	11,	28,	17,	29},
{17,	14,	34,	6,	18},
{19,	15,	34,	5,	33},
{18,	15,	33,	6,	35},
{18,	14,	33,	8,	33},
{17,	21,	28,	15,	6},
{17,	23,	24,	18,	38},
{18,	20,	25,	18,	38},
{17,	13,	14,	32,	35},
{17,	17,	34,	3,	37},
{17,	21,	27,	20,	21},
{17,	27,	35,	0,	24},
{18,	26,	39,	1,	4},
{18,	20,	37,	1,	35},
{17,	17,	26,	26,	0},
{18,	14,	26,	24,	12},
{17,	24,	14,	33,	20},
{17,	10,	29,	21,	1},
{17,	31,	24,	13,	33},
{17,	24,	15,	24,	37},
{17,	21,	31,	7,	9},
{17,	21,	14,	34,	22},
{18,	5,	13,	34,	26},
{17,	21,	12,	34,	27},
{17,	26,	23,	23,	17},
{17,	2,	34,	4,	38},
{17,	26,	30,	4,	11},
{17,	9,	38,	8,	1},
{18,	6,	37,	6,	25},
{18,	8,	39,	8,	1},
{17,	3,	37,	5,	32},
{17,	11,	38,	7,	2},
{17,	17,	14,	38,	0},
{17,	17,	29,	15,	1},
{18,	17,	29,	12,	12},
{17,	18,	29,	11,	19},
{17,	18,	29,	15,	2},
{18,	20,	29,	12,	5},
{19,	21,	29,	15,	0},
{17,	18,	29,	12,	19},
{17,	22,	29,	14,	0},
{17,	22,	26,	18,	35},
{17,	28,	25,	11,	22},
{17,	11,	27,	17,	34},
{17,	7,	28,	17,	35},
{17,	18,	18,	32,	7},
{18,	16,	20,	32,	6},
{17,	26,	20,	26,	21},
{17,	26,	34,	1,	27},
{18,	25,	37,	1,	12},
{18,	22,	36,	1,	37},
{18,	22,	39,	0,	33},
{18,	25,	37,	1,	22},
{17,	26,	38,	0,	28},
{17,	2,	36,	3,	38},
{17,	39,	21,	12,	38},
{17,	29,	21,	19,	34},
{17,	15,	18,	31,	29},
{17,	10,	15,	30,	36},
{17,	8,	16,	29,	36},
{19,	14,	17,	29,	34},
{17,	14,	16,	31,	34},
{17,	11,	34,	7,	30},
{17,	24,	22,	26,	8},
{17,	10,	38,	5,	20},
{17,	3,	39,	4,	30},
{17,	26,	29,	7,	6},
{17,	7,	36,	10,	15},
{17,	7,	36,	8,	29},
{16,	19,	33,	15,	38},
{20,	6,	34,	15,	32},
{20,	8,	34,	7,	37},
{19,	20,	33,	6,	32},
{19,	20,	30,	10,	38},
{19,	20,	29,	12,	15},
{18,	13,	29,	13,	39},
{18,	9,	33,	6,	39},
{19,	8,	32,	7,	39},
{18,	17,	30,	10,	39},
{18,	3,	35,	15,	31},
{18,	9,	33,	16,	8},
{18,	9,	30,	16,	29},
{18,	1,	34,	12,	33},
{18,	19,	29,	12,	39},
{18,	1,	34,	10,	34},
{17,	9,	30,	18,	29},
{21,	13,	29,	17,	11},
{19,	9,	29,	20,	16},
{17,	3,	35,	14,	32},
{17,	21,	29,	12,	13},
{17,	19,	31,	6,	39},
{17,	9,	28,	19,	29},
{17,	22,	29,	14,	1},
{17,	20,	31,	11,	2},
{19,	20,	31,	10,	36},
{16,	15,	30,	20,	36},
{21,	2,	31,	18,	31},
{19,	16,	28,	18,	22},
{18,	15,	30,	21,	0},
{17,	5,	27,	20,	37},
{17,	2,	32,	18,	31},
{17,	6,	33,	16,	31},
{16,	10,	36,	20,	25},
{22,	9,	36,	21,	0},
{21,	7,	35,	20,	28},
{20,	10,	34,	15,	30},
{20,	10,	34,	18,	27},
{19,	11,	33,	17,	25},
{21,	12,	31,	18,	17},
{21,	14,	31,	18,	11},
{21,	14,	33,	17,	5},
{18,	14,	34,	18,	0},
{19,	11,	34,	13,	12},
{18,	9,	34,	21,	3},
{18,	9,	34,	18,	29},
{18,	15,	31,	18,	11},
{18,	10,	37,	13,	0},
{18,	7,	35,	14,	32},
{18,	8,	35,	20,	27},
{18,	9,	35,	18,	30},
{18,	10,	35,	20,	26},
{17,	9,	37,	13,	12},
{19,	10,	38,	12,	1},
{18,	5,	37,	11,	18},
{17,	12,	31,	20,	26},
{18,	14,	31,	20,	4},
{18,	13,	31,	18,	26},
{17,	1,	36,	12,	30},
{17,	14,	34,	13,	9},
{18,	13,	35,	8,	8},
{17,	10,	32,	20,	30},
{17,	7,	36,	15,	26},
{17,	9,	35,	15,	32},
{17,	15,	31,	18,	22},
{17,	10,	37,	11,	12},
{17,	9,	37,	12,	13},
{17,	10,	35,	18,	29},
{17,	11,	39,	6,	6},
{17,	10,	37,	16,	0},
{17,	12,	32,	18,	10},
{17,	11,	32,	20,	5},
{17,	11,	32,	21,	3},
{16,	4,	28,	28,	25},
{19,	6,	28,	27,	5},
{18,	10,	27,	23,	21},
{20,	8,	26,	28,	20},
{18,	8,	27,	28,	9},
{18,	14,	26,	23,	21},
{17,	7,	28,	21,	35},
{20,	8,	27,	21,	36},
{17,	3,	26,	26,	27},
{18,	4,	27,	22,	26},
{17,	19,	26,	23,	19},
{17,	9,	28,	28,	0},
{16,	39,	19,	28,	37},
{22,	29,	20,	24,	10},
{20,	29,	21,	19,	35},
{18,	39,	20,	24,	16},
{20,	27,	20,	26,	27},
{18,	29,	22,	24,	1},
{17,	28,	23,	17,	36},
{17,	22,	19,	21,	38},
{17,	28,	20,	24,	25},
{16,	26,	33,	6,	39},
{19,	27,	29,	6,	31},
{18,	27,	30,	6,	4},
{16,	6,	34,	28,	2},
{19,	6,	29,	23,	3},
{17,	1,	29,	28,	4},
{19,	4,	29,	25,	5},
{17,	9,	35,	22,	0},
{19,	9,	30,	23,	2},
{17,	8,	31,	28,	1},
{16,	28,	29,	9,	39},
{21,	30,	29,	5,	2},
{20,	29,	28,	6,	37},
{17,	29,	28,	8,	35},
{17,	30,	29,	5,	4},
{16,	27,	25,	21,	31},
{21,	28,	24,	18,	33},
{19,	24,	25,	18,	36},
{17,	28,	23,	21,	28},
{17,	27,	25,	17,	33},
{17,	25,	23,	23,	28},
{17,	29,	22,	19,	26},
{17,	39,	22,	19,	25},
{16,	25,	29,	12,	39},
{19,	24,	26,	14,	36},
{19,	20,	29,	13,	38},
{17,	27,	26,	12,	35},
{16,	31,	25,	15,	33},
{20,	29,	25,	10,	39},
{19,	28,	25,	18,	18},
{19,	29,	25,	17,	1},
{18,	28,	25,	12,	37},
{17,	32,	25,	10,	27},
{17,	28,	25,	19,	0},
{17,	28,	25,	15,	35},
{16,	10,	39,	10,	21},
{19,	10,	39,	11,	2},
{17,	4,	38,	12,	6},
{17,	12,	39,	7,	3},
{17,	9,	39,	4,	30},
{17,	7,	37,	7,	30},
{17,	9,	37,	9,	26},
{16,	12,	24,	31,	20},
{19,	17,	22,	31,	20},
{18,	13,	24,	32,	1},
{17,	19,	22,	30,	23},
{17,	10,	24,	29,	23},
{17,	11,	26,	29,	1},
{17,	17,	22,	31,	22},
{16,	7,	37,	18,	26},
{20,	9,	37,	14,	25},
{17,	8,	37,	17,	25},
{16,	29,	31,	5,	35},
{21,	28,	30,	4,	38},
{18,	28,	32,	3,	3},
{17,	27,	30,	6,	34},
{17,	28,	30,	4,	39},
{17,	27,	32,	3,	14},
{17,	28,	31,	3,	37},
{17,	30,	31,	3,	1},
{16,	32,	25,	9,	39},
{20,	39,	22,	11,	37},
{17,	39,	22,	15,	35},
{17,	33,	25,	9,	31},
{16,	20,	21,	31,	33},
{21,	26,	16,	30,	33},
{19,	15,	22,	28,	29},
{18,	5,	22,	30,	29},
{18,	15,	17,	31,	34},
{18,	21,	21,	25,	35},
{17,	19,	22,	30,	27},
{17,	22,	15,	31,	35},
{17,	22,	19,	29,	29},
{16,	24,	30,	10,	39},
{19,	21,	31,	9,	9},
{18,	21,	31,	7,	35},
{18,	21,	31,	8,	18},
{17,	22,	31,	8,	5},
{16,	26,	27,	15,	34},
{22,	22,	28,	15,	10},
{19,	27,	27,	10,	19},
{18,	26,	27,	12,	39},
{18,	24,	29,	13,	2},
{17,	27,	26,	12,	39},
{18,	27,	27,	10,	38},
{17,	22,	29,	13,	10},
{16,	34,	28,	3,	34},
{22,	33,	29,	0,	37},
{20,	34,	27,	1,	38},
{18,	31,	27,	4,	39},
{20,	32,	27,	3,	39},
{18,	32,	28,	4,	12},
{20,	31,	28,	4,	26},
{18,	31,	29,	4,	7},
{20,	31,	29,	3,	16},
{17,	33,	27,	4,	21},
{17,	33,	28,	4,	13},
{17,	31,	27,	5,	36},
{17,	30,	28,	5,	36},
{17,	31,	28,	3,	37},
{16,	30,	28,	9,	34},
{18,	31,	27,	6,	32},
{18,	30,	27,	10,	1},
{17,	31,	27,	9,	0},
{18,	31,	27,	7,	4},
{17,	31,	28,	7,	2},
{16,	22,	35,	6,	36},
{19,	22,	34,	6,	37},
{19,	23,	34,	3,	37},
{18,	18,	34,	8,	6},
{18,	13,	34,	7,	37},
{18,	23,	35,	6,	3},
{18,	8,	37,	4,	36},
{18,	8,	36,	5,	35},
{18,	19,	34,	9,	1},
{18,	16,	34,	13,	2},
{17,	14,	35,	3,	39},
{19,	17,	34,	4,	39},
{17,	7,	38,	2,	38},
{18,	0,	38,	3,	38},
{17,	11,	38,	1,	39},
{17,	3,	36,	7,	34},
{17,	0,	39,	3,	34},
{17,	16,	34,	12,	6},
{17,	6,	36,	10,	31},
{17,	7,	36,	18,	27},
{18,	3,	36,	13,	30},
{17,	23,	34,	5,	19},
{17,	15,	35,	10,	2},
{17,	15,	35,	13,	0},
{17,	12,	37,	12,	0},
{16,	18,	22,	28,	36},
{18,	19,	22,	25,	36},
{17,	21,	21,	28,	34},
{17,	8,	22,	29,	31},
{17,	23,	23,	27,	0},
{17,	22,	21,	28,	15},
{18,	27,	21,	28,	1},
{16,	2,	35,	20,	32},
{19,	7,	33,	19,	31},
{16,	9,	10,	38,	34},
{19,	14,	10,	37,	34},
{18,	16,	11,	38,	8},
{16,	14,	34,	12,	37},
{18,	16,	34,	9,	11},
{17,	9,	35,	12,	33},
{16,	18,	23,	28,	34},
{19,	19,	23,	22,	35},
{16,	27,	19,	31,	33},
{17,	39,	18,	29,	30},
{17,	23,	21,	31,	2},
{16,	23,	26,	18,	38},
{18,	20,	26,	20,	37},
{17,	23,	26,	20,	32},
{16,	22,	29,	15,	31},
{17,	21,	29,	15,	34},
{16,	22,	37,	3,	39},
{20,	11,	38,	6,	22},
{20,	12,	39,	4,	30},
{19,	14,	39,	5,	5},
{18,	15,	37,	4,	31},
{18,	18,	39,	3,	10},
{16,	14,	37,	9,	26},
{22,	13,	39,	7,	16},
{18,	12,	35,	12,	26},
{18,	14,	39,	8,	8},
{18,	14,	35,	12,	11},
{18,	14,	35,	9,	30},
{17,	14,	39,	9,	8},
{19,	13,	38,	9,	20},
{17,	11,	39,	10,	21},
{17,	15,	36,	6,	26},
{17,	11,	36,	12,	26},
{17,	14,	35,	9,	33},
{17,	12,	37,	10,	25},
{16,	2,	36,	25,	1},
{19,	6,	36,	24,	1},
{16,	28,	33,	3,	39},
{17,	32,	33,	0,	27},
{17,	27,	34,	5,	0},
{17,	27,	35,	1,	15},
{17,	24,	34,	4,	13},
{17,	24,	34,	3,	34},
{16,	19,	23,	23,	37},
{16,	7,	35,	18,	33},
{16,	12,	37,	20,	1},
{18,	15,	35,	15,	1},
{17,	11,	33,	20,	25},
{17,	13,	33,	18,	7},
{16,	39,	23,	12,	38},
{19,	31,	24,	11,	36},
{17,	31,	24,	12,	36},
{17,	39,	22,	15,	36},
{18,	30,	23,	15,	36},
{17,	30,	25,	10,	38},
{16,	25,	22,	20,	38},
{19,	23,	23,	20,	36},
{18,	26,	21,	19,	37},
{17,	22,	25,	20,	36},
{17,	22,	21,	25,	35},
{19,	23,	21,	24,	35},
{17,	26,	20,	21,	37},
{17,	24,	21,	21,	38},
{17,	26,	19,	21,	38},
{16,	6,	33,	9,	39},
{16,	31,	28,	6,	35},
{17,	31,	27,	6,	39},
{17,	32,	28,	5,	3},
{16,	20,	31,	15,	30},
{20,	20,	31,	14,	35},
{19,	22,	30,	12,	3},
{17,	21,	29,	15,	38},
{17,	20,	30,	13,	38},
{16,	8,	18,	33,	28},
{20,	15,	18,	33,	15},
{17,	21,	18,	32,	15},
{17,	26,	17,	32,	6},
{16,	10,	27,	32,	0},
{18,	13,	25,	30,	1},
{16,	6,	28,	24,	27},
{18,	17,	26,	23,	22},
{19,	17,	26,	22,	26},
{18,	5,	28,	26,	23},
{17,	5,	28,	28,	23},
{16,	24,	24,	23,	28},
{19,	24,	25,	23,	1},
{17,	26,	24,	22,	5},
{16,	4,	39,	14,	3},
{18,	4,	39,	12,	5},
{17,	5,	38,	14,	4},
{17,	12,	39,	11,	3},
{17,	12,	36,	12,	26},
{16,	18,	34,	9,	35},
{17,	18,	34,	12,	11},
{16,	20,	30,	13,	39},
{16,	20,	27,	21,	25},
{19,	14,	27,	21,	32},
{18,	11,	27,	22,	27},
{17,	11,	27,	23,	27},
{18,	13,	27,	24,	5},
{17,	9,	26,	23,	28},
{17,	8,	26,	26,	25},
{17,	14,	31,	21,	2},
{17,	12,	29,	21,	12},
{17,	8,	28,	28,	9},
{19,	7,	28,	24,	27},
{17,	14,	29,	23,	3},
{18,	18,	27,	22,	5},
{17,	8,	33,	21,	13},
{17,	13,	31,	23,	0},
{17,	15,	30,	22,	1},
{17,	12,	28,	22,	9},
{17,	9,	28,	22,	20},
{18,	14,	28,	21,	16},
{17,	6,	27,	28,	22},
{16,	28,	27,	10,	38},
{16,	28,	26,	15,	33},
{16,	29,	29,	6,	32},
{18,	30,	29,	6,	4},
{16,	30,	23,	15,	38},
{17,	27,	23,	15,	39},
{16,	23,	21,	28,	36},
{16,	26,	21,	28,	28},
{16,	17,	20,	36,	1},
{17,	9,	19,	35,	2},
{17,	3,	18,	38,	0},
{17,	13,	15,	36,	3},
{16,	14,	19,	34,	14},
{18,	7,	19,	36,	3},
{17,	21,	16,	34,	15},
{17,	2,	20,	33,	7},
{16,	16,	19,	36,	8},
{18,	9,	14,	37,	8},
{18,	20,	17,	35,	7},
{17,	14,	12,	35,	27},
{17,	14,	13,	35,	18},
{17,	6,	15,	37,	10},
{19,	2,	14,	35,	22},
{18,	7,	14,	36,	14},
{17,	2,	16,	35,	14},
{16,	21,	33,	9,	7},
{18,	20,	33,	14,	0},
{17,	20,	34,	8,	6},
{17,	20,	32,	12,	6},
{17,	21,	32,	12,	0},
{17,	19,	34,	12,	3},
{16,	20,	33,	9,	38},
{21,	21,	33,	7,	34},
{18,	21,	34,	7,	16},
{16,	21,	34,	8,	25},
{16,	29,	25,	18,	12},
{16,	33,	28,	4,	30},
{16,	3,	37,	20,	4},
{16,	10,	34,	15,	35},
{16,	12,	26,	28,	19},
{20,	16,	26,	26,	9},
{17,	12,	27,	25,	9},
{16,	25,	22,	26,	22},
{19,	26,	22,	25,	19},
{18,	20,	23,	28,	23},
{16,	32,	32,	1,	28},
{19,	30,	33,	1,	20},
{17,	29,	34,	1,	20},
{18,	29,	39,	0,	11},
{18,	29,	37,	0,	24},
{17,	29,	32,	3,	17},
{18,	29,	32,	2,	35},
{16,	33,	29,	1,	39},
{16,	39,	21,	21,	31},
{16,	17,	24,	23,	32},
{16,	5,	35,	21,	7},
{18,	5,	34,	21,	9},
{17,	5,	34,	21,	13},
{16,	28,	27,	12,	4},
{18,	28,	27,	13,	3},
{16,	13,	39,	5,	27},
{16,	20,	30,	18,	0},
{18,	18,	28,	18,	4},
{16,	20,	28,	21,	2},
{19,	16,	28,	20,	15},
{17,	19,	28,	21,	3},
{16,	8,	24,	32,	5},
{17,	2,	23,	32,	7},
{16,	7,	22,	29,	34},
{16,	2,	30,	21,	19},
{18,	4,	29,	21,	22},
{16,	4,	29,	21,	32},
{16,	30,	24,	12,	39},
{17,	39,	22,	11,	39},
{16,	22,	36,	5,	11},
{19,	18,	36,	6,	14},
{17,	20,	39,	4,	3},
{17,	23,	36,	4,	10},
{16,	7,	36,	20,	26},
{16,	29,	23,	20,	9},
{16,	6,	23,	29,	28},
{16,	26,	26,	15,	36},
{16,	14,	12,	35,	32},
{18,	21,	12,	34,	32},
{18,	14,	13,	34,	29},
{17,	2,	13,	35,	30},
{17,	7,	12,	34,	34},
{16,	7,	12,	37,	32},
{18,	14,	12,	37,	21},
{17,	7,	15,	36,	15},
{16,	29,	29,	7,	17},
{16,	16,	22,	31,	28},
{16,	24,	21,	28,	36},
{16,	15,	34,	12,	37},
{16,	27,	24,	15,	38},
{16,	26,	25,	15,	39},
{16,	14,	11,	38,	23},
{16,	28,	20,	28,	17},
{16,	39,	20,	27,	15},
{17,	29,	20,	28,	16},
{16,	8,	27,	23,	28},
{16,	21,	32,	9,	23},
{16,	10,	34,	14,	36},
{16,	20,	33,	10,	35},
{16,	20,	32,	12,	31},
{16,	15,	28,	21,	26},
{16,	18,	28,	21,	17},
{16,	14,	35,	12,	25},
{16,	9,	14,	38,	8},
{17,	7,	16,	38,	4},
{17,	3,	17,	37,	7},
{16,	2,	37,	21,	0},
{16,	7,	34,	26,	2},
{16,	10,	28,	23,	20},
{16,	14,	37,	12,	3},
{16,	27,	27,	12,	10},
{16,	28,	25,	12,	39},
{16,	7,	36,	6,	36},
{16,	28,	25,	18,	23},
{17,	28,	25,	17,	27},
{16,	23,	24,	20,	36},
{16,	16,	12,	36,	32},
{17,	20,	14,	35,	15},
{17,	20,	12,	35,	29},
{17,	39,	12,	35,	21},
{16,	14,	35,	7,	36},
{16,	28,	25,	17,	33},
{16,	39,	26,	5,	2},
{16,	14,	32,	19,	4},
{17,	12,	35,	19,	2},
{16,	12,	32,	20,	25},
{16,	19,	36,	4,	36},
{16,	24,	28,	13,	13},
{16,	12,	21,	34,	2},
{16,	6,	24,	29,	25},
{16,	11,	34,	19,	9},
{16,	20,	23,	28,	26},
{16,	11,	18,	31,	34},
{16,	25,	22,	27,	5},
{16,	20,	27,	22,	3},
{17,	19,	27,	22,	8},
{16,	30,	29,	6,	7},
{16,	3,	18,	38,	4},
{16,	29,	22,	15,	39},
{16,	20,	24,	23,	31},
{16,	11,	18,	32,	25},
{16,	13,	32,	18,	16},
{16,	8,	27,	29,	1},
{16,	29,	27,	7,	39},
{16,	8,	16,	30,	36},
{16,	18,	34,	10,	25},
{16,	16,	15,	37,	8},
{16,	28,	24,	18,	34},
{16,	30,	21,	19,	34},
{16,	30,	28,	5,	38},
{16,	24,	28,	15,	0},
{16,	39,	18,	30,	20},
{17,	39,	19,	31,	2},
{16,	39,	19,	30,	18},
{16,	16,	28,	21,	22},
{17,	18,	28,	19,	19},
{16,	17,	28,	21,	23},
{16,	17,	26,	25,	9},
{16,	20,	35,	8,	0},
{16,	22,	39,	0,	37},
{16,	0,	39,	4,	35},
{16,	15,	36,	5,	36},
{16,	13,	39,	5,	30},
{16,	0,	38,	5,	33},
{16,	8,	16,	34,	19},
{16,	20,	36,	6,	12},
{16,	10,	33,	21,	6},
{17,	11,	34,	23,	0},
{16,	30,	31,	4,	1},
{16,	27,	22,	20,	33},
{16,	21,	24,	20,	37},
{16,	23,	18,	32,	15},
{16,	7,	37,	8,	27},
{16,	13,	38,	12,	3},
{17,	8,	39,	12,	5},
{16,	22,	22,	21,	38},
{16,	24,	26,	14,	38},
{17,	26,	26,	14,	37},
{16,	21,	33,	9,	20},
{16,	13,	34,	16,	7},
{16,	14,	34,	18,	3},
{16,	13,	34,	17,	9},
{16,	12,	35,	17,	9},
{16,	39,	15,	32,	20},
{16,	26,	18,	32,	15},
{16,	28,	20,	27,	25},
{16,	26,	22,	23,	28},
{16,	10,	31,	20,	31},
{16,	23,	37,	2,	26},
{16,	9,	37,	17,	11},
{15,	11,	34,	28,	32},
{20,	18,	25,	28,	29},
{21,	17,	25,	25,	31},
{20,	11,	35,	18,	26},
{19,	14,	26,	23,	32},
{19,	11,	34,	18,	33},
{17,	5,	35,	22,	8},
{17,	4,	36,	22,	4},
{17,	12,	27,	28,	24},
{18,	15,	28,	26,	0},
{17,	14,	27,	23,	24},
{17,	6,	24,	29,	28},
{17,	19,	25,	25,	30},
{17,	13,	28,	24,	9},
{17,	13,	30,	21,	14},
{17,	12,	32,	18,	33},
{17,	12,	32,	19,	31},
{16,	10,	35,	21,	16},
{17,	11,	35,	22,	2},
{17,	9,	36,	21,	5},
{16,	13,	35,	15,	27},
{17,	12,	35,	17,	15},
{16,	14,	30,	21,	32},
{18,	15,	29,	21,	32},
{16,	14,	26,	26,	25},
{16,	12,	35,	17,	26},
{16,	11,	36,	18,	14},
{18,	12,	36,	20,	3},
{16,	14,	27,	23,	32},
{16,	18,	26,	23,	25},
{16,	16,	25,	25,	32},
{16,	13,	36,	17,	2},
{15,	27,	28,	21,	39},
{20,	28,	27,	15,	3},
{18,	23,	29,	13,	26},
{18,	30,	21,	21,	34},
{17,	28,	26,	18,	9},
{17,	26,	29,	12,	9},
{17,	28,	23,	18,	37},
{17,	28,	24,	18,	36},
{17,	28,	28,	10,	4},
{16,	30,	21,	20,	39},
{19,	30,	22,	18,	37},
{19,	39,	20,	21,	37},
{16,	26,	21,	28,	33},
{16,	23,	29,	15,	19},
{16,	39,	22,	18,	36},
{16,	28,	21,	21,	39},
{16,	24,	22,	23,	32},
{17,	25,	23,	23,	30},
{16,	24,	29,	14,	4},
{16,	29,	23,	18,	37},
{16,	25,	21,	25,	35},
{16,	25,	20,	23,	37},
{16,	26,	29,	10,	16},
{16,	28,	25,	17,	35},
{15,	14,	39,	20,	25},
{19,	14,	33,	18,	28},
{19,	7,	38,	6,	30},
{19,	2,	38,	21,	0},
{17,	14,	39,	6,	29},
{17,	14,	39,	9,	26},
{19,	14,	39,	7,	28},
{17,	16,	39,	3,	30},
{17,	2,	39,	21,	0},
{17,	13,	32,	18,	33},
{16,	7,	39,	25,	0},
{17,	10,	38,	22,	0},
{16,	13,	33,	21,	26},
{16,	18,	36,	6,	33},
{16,	15,	31,	18,	33},
{16,	19,	39,	1,	35},
{16,	11,	36,	10,	29},
{16,	13,	33,	18,	32},
{16,	12,	33,	21,	30},
{16,	25,	38,	1,	26},
{15,	24,	25,	26,	38},
{20,	20,	25,	27,	28},
{20,	27,	19,	23,	38},
{19,	26,	23,	25,	7},
{18,	26,	22,	25,	29},
{18,	14,	26,	22,	33},
{17,	15,	24,	28,	34},
{17,	26,	23,	24,	27},
{17,	19,	25,	28,	31},
{18,	20,	23,	28,	34},
{17,	21,	24,	28,	5},
{17,	25,	23,	27,	5},
{17,	28,	23,	25,	0},
{17,	26,	17,	26,	38},
{17,	24,	20,	27,	37},
{16,	21,	23,	28,	32},
{19,	21,	25,	27,	28},
{16,	26,	22,	26,	29},
{16,	24,	23,	27,	13},
{17,	22,	22,	27,	35},
{16,	25,	23,	28,	7},
{17,	26,	22,	28,	10},
{17,	23,	22,	28,	32},
{16,	26,	22,	28,	27},
{18,	24,	22,	28,	35},
{16,	25,	21,	25,	38},
{16,	23,	23,	28,	17},
{16,	29,	22,	26,	1},
{16,	24,	24,	28,	2},
{16,	23,	25,	27,	5},
{16,	21,	24,	28,	19},
{15,	19,	33,	21,	36},
{19,	17,	30,	22,	2},
{18,	20,	31,	19,	0},
{17,	6,	34,	18,	34},
{17,	20,	31,	19,	1},
{16,	3,	34,	21,	33},
{15,	31,	27,	15,	35},
{18,	29,	26,	18,	1},
{18,	28,	27,	12,	36},
{18,	29,	26,	10,	39},
{16,	32,	26,	9,	35},
{17,	32,	26,	12,	2},
{16,	30,	27,	10,	38},
{17,	32,	26,	9,	36},
{17,	31,	27,	7,	37},
{17,	30,	26,	8,	39},
{16,	33,	26,	8,	31},
{16,	28,	26,	12,	39},
{16,	31,	25,	10,	39},
{16,	29,	26,	17,	5},
{16,	32,	25,	15,	0},
{15,	26,	31,	12,	39},
{20,	27,	30,	8,	4},
{19,	21,	32,	9,	34},
{18,	22,	33,	10,	0},
{18,	26,	33,	7,	0},
{17,	21,	30,	15,	30},
{17,	9,	33,	9,	39},
{17,	21,	31,	15,	3},
{16,	27,	30,	7,	34},
{16,	21,	31,	13,	37},
{17,	21,	31,	14,	19},
{16,	21,	32,	10,	34},
{17,	21,	32,	12,	11},
{16,	22,	30,	13,	30},
{17,	23,	30,	13,	18},
{16,	25,	32,	8,	0},
{16,	21,	33,	10,	18},
{15,	31,	24,	21,	36},
{17,	29,	25,	20,	0},
{16,	30,	25,	16,	4},
{15,	25,	33,	9,	38},
{18,	22,	33,	10,	14},
{16,	23,	34,	9,	1},
{16,	20,	34,	10,	25},
{16,	23,	35,	7,	4},
{16,	25,	32,	10,	2},
{16,	23,	34,	10,	1},
{16,	20,	35,	10,	0},
{15,	19,	38,	6,	39},
{18,	18,	39,	3,	34},
{17,	21,	36,	4,	38},
{17,	20,	39,	6,	1},
{16,	15,	34,	10,	38},
{16,	6,	35,	7,	39},
{16,	10,	39,	5,	35},
{16,	14,	39,	6,	31},
{16,	20,	36,	6,	25},
{15,	27,	22,	31,	30},
{19,	28,	20,	28,	32},
{18,	27,	21,	26,	34},
{18,	29,	21,	22,	16},
{18,	25,	20,	30,	33},
{18,	28,	20,	23,	37},
{17,	27,	20,	27,	36},
{17,	20,	23,	32,	1},
{16,	22,	23,	31,	18},
{19,	21,	23,	29,	24},
{18,	24,	23,	30,	7},
{17,	15,	24,	30,	7},
{17,	24,	24,	30,	0},
{16,	29,	20,	28,	33},
{18,	39,	20,	24,	32},
{16,	27,	23,	28,	7},
{17,	29,	23,	27,	1},
{17,	27,	23,	23,	16},
{16,	27,	21,	23,	38},
{16,	24,	21,	30,	33},
{16,	17,	22,	29,	33},
{16,	21,	22,	31,	31},
{15,	39,	25,	9,	39},
{18,	33,	26,	8,	34},
{16,	39,	24,	12,	33},
{17,	32,	24,	10,	38},
{17,	32,	24,	12,	35},
{16,	39,	24,	12,	35},
{16,	33,	26,	7,	37},
{15,	39,	27,	4,	34},
{19,	32,	27,	4,	39},
{18,	39,	27,	0,	37},
{17,	39,	26,	1,	38},
{16,	33,	28,	4,	34},
{15,	18,	35,	12,	36},
{21,	5,	36,	10,	34},
{19,	6,	35,	8,	38},
{19,	11,	35,	13,	35},
{17,	10,	35,	15,	34},
{17,	18,	36,	7,	13},
{17,	15,	39,	8,	9},
{18,	18,	36,	8,	9},
{16,	5,	36,	10,	35},
{16,	15,	37,	16,	1},
{16,	18,	34,	12,	37},
{16,	16,	36,	9,	10},
{16,	18,	34,	10,	38},
{16,	13,	34,	14,	36},
{18,	13,	34,	20,	29},
{16,	18,	35,	7,	38},
{16,	17,	37,	8,	4},
{17,	16,	39,	12,	0},
{17,	19,	37,	9,	0},
{16,	18,	36,	9,	9},
{16,	16,	39,	7,	9},
{16,	12,	35,	15,	34},
{16,	13,	35,	18,	29},
{15,	33,	28,	6,	29},
{19,	32,	27,	6,	32},
{16,	33,	27,	6,	31},
{15,	31,	31,	3,	39},
{16,	29,	31,	4,	37},
{16,	30,	31,	4,	5},
{15,	30,	30,	6,	35},
{17,	30,	29,	4,	38},
{16,	30,	31,	4,	26},
{15,	39,	26,	6,	35},
{16,	34,	26,	7,	7},
{15,	11,	39,	21,	14},
{15,	2,	36,	25,	12},
{18,	4,	36,	24,	12},
{16,	6,	35,	23,	12},
{15,	4,	35,	28,	15},
{15,	39,	14,	29,	37},
{15,	32,	27,	9,	36},
{19,	32,	27,	6,	38},
{17,	32,	27,	6,	39},
{17,	33,	27,	8,	0},
{17,	33,	27,	6,	33},
{15,	39,	21,	27,	31},
{18,	30,	23,	23,	2},
{17,	28,	21,	28,	31},
{16,	30,	23,	27,	2},
{16,	28,	21,	22,	38},
{15,	6,	37,	15,	31},
{18,	6,	36,	17,	28},
{16,	8,	37,	7,	33},
{15,	27,	25,	23,	28},
{20,	27,	24,	28,	0},
{19,	25,	25,	24,	15},
{17,	26,	24,	26,	7},
{17,	25,	25,	24,	25},
{16,	25,	24,	25,	28},
{16,	26,	25,	26,	2},
{17,	25,	25,	25,	16},
{16,	27,	25,	27,	0},
{16,	27,	25,	25,	7},
{16,	25,	25,	23,	30},
{15,	29,	29,	9,	36},
{15,	30,	27,	12,	39},
{15,	17,	15,	36,	31},
{19,	21,	15,	35,	27},
{19,	20,	15,	32,	34},
{18,	8,	16,	34,	27},
{17,	15,	19,	36,	9},
{16,	5,	18,	33,	31},
{16,	3,	18,	34,	21},
{16,	13,	16,	33,	31},
{16,	21,	15,	34,	31},
{16,	22,	16,	35,	10},
{16,	1,	15,	34,	32},
{15,	5,	37,	28,	1},
{18,	7,	37,	28,	0},
{17,	3,	36,	28,	2},
{17,	5,	38,	22,	1},
{15,	30,	24,	18,	39},
{16,	29,	24,	19,	38},
{15,	34,	31,	1,	34},
{20,	33,	31,	1,	39},
{15,	39,	23,	18,	34},
{18,	39,	24,	14,	33},
{16,	32,	24,	15,	35},
{15,	20,	31,	18,	36},
{19,	21,	30,	15,	37},
{17,	21,	31,	14,	34},
{16,	20,	29,	20,	17},
{17,	20,	30,	19,	8},
{15,	11,	29,	30,	1},
{17,	11,	29,	31,	0},
{16,	8,	30,	29,	0},
{16,	8,	26,	31,	1},
{15,	17,	27,	28,	13},
{17,	17,	27,	23,	25},
{17,	15,	28,	29,	1},
{17,	19,	27,	22,	20},
{17,	19,	27,	23,	14},
{17,	15,	26,	26,	25},
{19,	17,	26,	27,	17},
{16,	17,	27,	29,	1},
{15,	7,	39,	15,	27},
{19,	7,	38,	11,	28},
{16,	7,	38,	9,	29},
{18,	8,	38,	7,	33},
{15,	39,	26,	4,	39},
{15,	28,	29,	10,	36},
{17,	27,	29,	11,	16},
{16,	27,	29,	12,	23},
{16,	29,	29,	10,	3},
{16,	30,	28,	10,	4},
{15,	27,	19,	30,	35},
{18,	13,	18,	31,	35},
{17,	8,	19,	29,	36},
{17,	16,	20,	29,	35},
{15,	8,	34,	29,	0},
{15,	3,	38,	29,	0},
{16,	8,	35,	29,	0},
{15,	3,	36,	12,	36},
{16,	8,	36,	7,	37},
{15,	28,	22,	28,	30},
{17,	28,	23,	24,	8},
{16,	30,	22,	23,	19},
{17,	29,	23,	24,	10},
{17,	28,	23,	23,	20},
{15,	21,	29,	15,	39},
{15,	18,	27,	25,	23},
{19,	19,	27,	24,	19},
{16,	20,	26,	27,	2},
{15,	21,	23,	28,	36},
{15,	12,	35,	12,	37},
{16,	5,	35,	10,	38},
{15,	15,	28,	25,	17},
{17,	14,	28,	24,	21},
{15,	27,	30,	8,	29},
{15,	28,	26,	18,	22},
{15,	7,	37,	18,	28},
{15,	28,	30,	6,	39},
{15,	14,	39,	7,	33},
{16,	16,	36,	7,	35},
{15,	34,	27,	5,	34},
{16,	34,	27,	7,	0},
{15,	22,	33,	12,	7},
{16,	21,	33,	12,	13},
{16,	23,	33,	11,	3},
{15,	22,	30,	15,	22},
{15,	7,	32,	29,	1},
{15,	32,	25,	12,	17},
{15,	4,	36,	8,	38},
{18,	4,	36,	9,	37},
{15,	10,	36,	23,	7},
{16,	7,	36,	24,	7},
{16,	5,	35,	28,	11},
{15,	25,	22,	26,	38},
{19,	27,	22,	26,	33},
{15,	34,	29,	1,	39},
{15,	1,	14,	34,	35},
{15,	32,	29,	4,	7},
{17,	32,	29,	2,	19},
{16,	32,	29,	3,	19},
{15,	10,	22,	35,	1},
{18,	16,	23,	33,	2},
{15,	34,	26,	8,	4},
{15,	35,	27,	5,	10},
{15,	39,	27,	1,	38},
{15,	7,	37,	20,	26},
{15,	27,	34,	3,	14},
{16,	25,	34,	5,	25},
{16,	26,	37,	2,	7},
{16,	26,	34,	3,	27},
{16,	26,	37,	3,	3},
{15,	20,	27,	27,	3},
{15,	19,	26,	27,	16},
{18,	19,	27,	26,	13},
{16,	18,	26,	28,	15},
{15,	12,	35,	15,	35},
{15,	31,	25,	12,	37},
{15,	25,	24,	26,	29},
{15,	17,	20,	38,	0},
{18,	8,	19,	37,	7},
{15,	23,	34,	5,	39},
{15,	39,	22,	23,	7},
{15,	24,	37,	5,	2},
{15,	30,	36,	0,	24},
{16,	30,	35,	1,	11},
{16,	31,	36,	0,	12},
{15,	7,	28,	32,	0},
{15,	29,	22,	20,	39},
{16,	30,	22,	20,	38},
{15,	34,	26,	6,	36},
{15,	29,	32,	3,	35},
{15,	13,	30,	23,	8},
{16,	12,	30,	25,	5},
{16,	12,	30,	24,	21},
{16,	12,	33,	25,	0},
{15,	35,	30,	0,	5},
{16,	35,	28,	1,	8},
{15,	35,	29,	1,	29},
{19,	35,	28,	1,	38},
{15,	32,	24,	13,	36},
{15,	39,	24,	12,	36},
{15,	20,	34,	12,	7},
{15,	8,	22,	33,	5},
{15,	10,	21,	35,	3},
{15,	14,	34,	21,	15},
{16,	14,	34,	22,	0},
{15,	25,	29,	14,	3},
{15,	1,	22,	29,	35},
{15,	18,	28,	22,	11},
{16,	18,	28,	27,	0},
{16,	18,	30,	22,	3},
{16,	18,	29,	23,	2},
{16,	18,	28,	25,	3},
{16,	18,	28,	24,	7},
{15,	19,	34,	10,	33},
{15,	39,	26,	8,	0},
{15,	39,	8,	38,	32},
{16,	39,	10,	36,	32},
{15,	20,	34,	9,	29},
{15,	3,	36,	7,	39},
{15,	16,	24,	30,	9},
{15,	17,	17,	37,	7},
{15,	16,	37,	9,	10},
{15,	10,	14,	34,	33},
{15,	26,	24,	28,	3},
{15,	18,	28,	24,	11},
{15,	9,	19,	38,	4},
{15,	29,	23,	20,	38},
{15,	32,	24,	11,	38},
{15,	15,	21,	27,	37},
{15,	29,	22,	25,	15},
{15,	12,	30,	23,	25},
{15,	12,	29,	25,	23},
{15,	19,	24,	29,	9},
{15,	21,	36,	6,	11},
{15,	22,	34,	8,	8},
{15,	8,	11,	38,	29},
{15,	19,	35,	13,	0},
{15,	27,	31,	6,	2},
{15,	27,	18,	31,	34},
{15,	19,	25,	28,	32},
{15,	17,	8,	38,	34},
{15,	7,	35,	20,	32},
{15,	39,	19,	32,	2},
{15,	6,	36,	13,	32},
{15,	4,	15,	34,	34},
{15,	32,	27,	10,	1},
{15,	21,	30,	15,	38},
{15,	27,	25,	22,	29},
{15,	22,	34,	6,	39},
{15,	12,	35,	16,	33},
{15,	12,	34,	21,	32},
{15,	28,	23,	25,	10},
{15,	26,	24,	25,	21},
{16,	26,	25,	24,	23},
{15,	16,	38,	7,	23},
{16,	16,	37,	7,	34},
{15,	16,	37,	7,	37},
{15,	4,	37,	9,	36},
{19,	6,	37,	8,	37},
{15,	5,	39,	9,	32},
{16,	5,	39,	11,	28},
{15,	25,	24,	30,	0},
{15,	27,	23,	31,	1},
{15,	12,	30,	28,	1},
{15,	13,	30,	28,	0},
{15,	18,	29,	24,	1},
{15,	34,	27,	8,	0},
{15,	27,	30,	9,	1},
{15,	27,	30,	12,	0},
{14,	17,	36,	31,	28},
{20,	18,	34,	15,	22},
{20,	20,	23,	31,	28},
{20,	12,	31,	28,	30},
{19,	17,	35,	14,	33},
{19,	16,	37,	11,	15},
{19,	20,	24,	29,	19},
{18,	18,	28,	27,	11},
{18,	14,	29,	27,	29},
{17,	17,	37,	9,	26},
{17,	18,	36,	10,	25},
{17,	11,	23,	31,	29},
{17,	12,	34,	28,	30},
{17,	17,	37,	16,	1},
{17,	16,	37,	20,	1},
{17,	19,	34,	15,	8},
{17,	5,	37,	29,	1},
{17,	14,	30,	25,	30},
{16,	16,	36,	10,	35},
{18,	13,	36,	13,	31},
{16,	12,	37,	15,	29},
{18,	12,	39,	12,	27},
{16,	13,	36,	8,	38},
{16,	19,	34,	19,	1},
{16,	15,	38,	10,	25},
{18,	15,	39,	13,	5},
{17,	15,	37,	21,	3},
{17,	14,	37,	21,	14},
{16,	12,	34,	26,	31},
{16,	8,	35,	21,	29},
{16,	21,	23,	31,	28},
{16,	14,	34,	23,	29},
{16,	18,	27,	26,	24},
{16,	8,	37,	27,	1},
{17,	9,	38,	26,	0},
{16,	18,	30,	23,	6},
{16,	17,	37,	11,	15},
{16,	10,	37,	29,	0},
{16,	17,	27,	32,	0},
{16,	20,	25,	32,	0},
{17,	18,	25,	29,	26},
{15,	17,	30,	27,	30},
{16,	16,	26,	26,	32},
{16,	17,	32,	25,	29},
{15,	18,	26,	31,	25},
{15,	16,	37,	9,	36},
{16,	12,	37,	15,	30},
{16,	17,	37,	8,	35},
{15,	5,	37,	31,	0},
{15,	16,	38,	12,	22},
{15,	15,	38,	20,	24},
{19,	16,	37,	16,	22},
{18,	15,	38,	21,	7},
{17,	16,	37,	18,	22},
{17,	16,	38,	18,	5},
{17,	16,	37,	19,	15},
{16,	15,	37,	13,	29},
{16,	14,	37,	20,	26},
{15,	18,	28,	26,	25},
{15,	13,	30,	28,	32},
{18,	15,	28,	27,	32},
{16,	13,	33,	26,	31},
{15,	15,	36,	12,	35},
{16,	17,	36,	14,	30},
{15,	20,	24,	31,	19},
{16,	19,	24,	31,	28},
{15,	8,	25,	32,	3},
{15,	19,	24,	29,	29},
{15,	16,	26,	23,	33},
{15,	2,	23,	31,	30},
{17,	17,	24,	29,	30},
{16,	17,	23,	29,	31},
{15,	17,	28,	24,	32},
{16,	17,	26,	28,	32},
{15,	25,	25,	29,	0},
{15,	18,	34,	14,	33},
{15,	20,	25,	30,	4},
{15,	21,	26,	28,	0},
{16,	21,	27,	25,	1},
{17,	23,	27,	22,	0},
{16,	23,	26,	25,	0},
{15,	16,	37,	19,	22},
{15,	18,	26,	31,	27},
{16,	18,	26,	26,	31},
{16,	18,	28,	24,	28},
{15,	15,	39,	15,	7},
{15,	26,	26,	22,	0},
{15,	12,	32,	28,	32},
{14,	23,	34,	21,	38},
{20,	17,	35,	18,	31},
{19,	24,	29,	21,	2},
{19,	25,	29,	18,	1},
{17,	7,	35,	18,	35},
{17,	23,	29,	15,	39},
{17,	25,	29,	18,	3},
{16,	24,	29,	21,	7},
{16,	24,	30,	21,	5},
{18,	24,	31,	18,	0},
{16,	25,	32,	10,	27},
{16,	25,	30,	16,	2},
{16,	13,	34,	25,	32},
{16,	26,	31,	13,	0},
{16,	17,	35,	15,	34},
{15,	27,	29,	15,	34},
{17,	26,	30,	15,	4},
{17,	25,	29,	18,	8},
{16,	27,	29,	12,	36},
{15,	9,	35,	15,	37},
{15,	14,	36,	15,	33},
{15,	25,	29,	21,	7},
{15,	26,	30,	13,	16},
{16,	24,	30,	18,	8},
{16,	24,	30,	15,	13},
{15,	26,	30,	15,	9},
{15,	25,	30,	18,	8},
{16,	25,	30,	19,	5},
{15,	27,	30,	13,	1},
{15,	16,	35,	16,	34},
{14,	25,	22,	31,	38},
{16,	26,	22,	30,	33},
{16,	26,	20,	29,	37},
{14,	29,	28,	20,	37},
{18,	30,	25,	15,	37},
{17,	30,	28,	15,	0},
{16,	30,	28,	10,	19},
{16,	30,	28,	12,	1},
{16,	28,	29,	12,	0},
{15,	29,	29,	9,	37},
{15,	30,	30,	5,	37},
{16,	30,	30,	6,	36},
{15,	29,	29,	6,	38},
{15,	28,	29,	15,	0},
{15,	29,	25,	21,	5},
{14,	31,	30,	9,	39},
{18,	32,	28,	8,	0},
{18,	31,	29,	10,	0},
{17,	29,	30,	10,	1},
{16,	31,	27,	10,	37},
{15,	33,	29,	4,	29},
{16,	32,	29,	3,	34},
{15,	32,	28,	9,	20},
{15,	27,	30,	12,	36},
{15,	31,	31,	4,	31},
{15,	27,	30,	15,	5},
{15,	34,	29,	3,	2},
{14,	20,	39,	18,	27},
{18,	20,	36,	13,	29},
{18,	21,	38,	3,	39},
{17,	19,	36,	7,	38},
{17,	20,	39,	4,	35},
{17,	18,	35,	15,	35},
{16,	21,	35,	15,	1},
{16,	23,	36,	7,	2},
{16,	16,	37,	15,	30},
{16,	22,	35,	7,	15},
{16,	15,	39,	21,	2},
{16,	21,	37,	7,	7},
{15,	8,	38,	20,	26},
{15,	20,	35,	12,	34},
{16,	19,	37,	10,	30},
{16,	20,	37,	8,	31},
{15,	21,	36,	15,	2},
{15,	21,	35,	20,	0},
{15,	15,	39,	19,	23},
{15,	21,	36,	6,	34},
{15,	18,	36,	19,	5},
{17,	18,	35,	20,	10},
{15,	18,	35,	19,	19},
{15,	19,	39,	5,	35},
{15,	20,	39,	8,	28},
{16,	11,	38,	9,	32},
{17,	19,	39,	11,	28},
{15,	19,	38,	15,	28},
{15,	21,	37,	5,	25},
{15,	22,	37,	4,	38},
{15,	23,	37,	7,	2},
{14,	33,	25,	21,	28},
{21,	39,	23,	20,	32},
{20,	31,	26,	18,	0},
{18,	31,	25,	18,	30},
{17,	33,	25,	10,	33},
{16,	32,	24,	20,	32},
{16,	39,	23,	20,	34},
{16,	28,	25,	21,	36},
{16,	30,	26,	19,	0},
{16,	32,	24,	18,	34},
{16,	33,	25,	11,	31},
{16,	31,	26,	17,	1},
{16,	30,	26,	18,	26},
{18,	31,	26,	16,	10},
{16,	31,	26,	18,	4},
{15,	30,	26,	20,	18},
{15,	31,	26,	20,	2},
{15,	32,	24,	18,	35},
{15,	32,	26,	16,	0},
{15,	32,	26,	15,	3},
{15,	33,	25,	12,	30},
{15,	30,	25,	18,	32},
{15,	30,	25,	21,	29},
{14,	26,	19,	34,	36},
{17,	39,	12,	36,	31},
{18,	39,	16,	36,	4},
{16,	39,	19,	33,	14},
{17,	39,	17,	33,	35},
{16,	21,	21,	32,	6},
{15,	12,	17,	35,	31},
{16,	12,	17,	36,	16},
{16,	21,	16,	35,	27},
{15,	17,	15,	36,	34},
{17,	12,	17,	35,	34},
{15,	39,	16,	35,	31},
{16,	25,	16,	36,	10},
{16,	20,	15,	36,	31},
{15,	19,	9,	37,	34},
{16,	18,	9,	38,	34},
{15,	18,	22,	33,	5},
{16,	18,	24,	32,	5},
{15,	15,	27,	32,	3},
{17,	5,	27,	32,	4},
{15,	6,	28,	32,	1},
{15,	9,	12,	36,	35},
{15,	9,	15,	35,	35},
{15,	20,	19,	35,	8},
{15,	20,	20,	35,	3},
{15,	20,	23,	33,	2},
{15,	17,	11,	37,	27},
{14,	17,	37,	20,	35},
{16,	17,	39,	20,	0},
{16,	18,	35,	17,	35},
{15,	17,	38,	12,	34},
{17,	7,	39,	10,	33},
{17,	19,	39,	10,	29},
{15,	19,	38,	7,	37},
{16,	18,	38,	13,	30},
{16,	19,	39,	8,	31},
{15,	17,	38,	19,	8},
{15,	18,	36,	16,	33},
{15,	18,	38,	12,	33},
{15,	17,	39,	19,	5},
{15,	19,	35,	18,	30},
{14,	23,	28,	23,	38},
{17,	20,	27,	26,	14},
{20,	22,	27,	24,	14},
{16,	12,	27,	25,	33},
{15,	8,	33,	23,	34},
{20,	6,	34,	23,	33},
{15,	24,	26,	23,	38},
{18,	24,	27,	23,	5},
{16,	27,	26,	23,	0},
{16,	27,	26,	22,	2},
{15,	19,	29,	27,	2},
{17,	19,	30,	23,	5},
{16,	21,	29,	23,	1},
{15,	18,	33,	27,	0},
{15,	21,	26,	27,	12},
{16,	23,	27,	26,	1},
{16,	21,	27,	26,	8},
{15,	27,	27,	23,	0},
{17,	26,	28,	22,	0},
{16,	25,	27,	22,	5},
{15,	19,	28,	27,	8},
{15,	18,	28,	26,	29},
{15,	18,	31,	24,	4},
{15,	27,	27,	22,	2},
{15,	20,	29,	23,	6},
{14,	28,	34,	6,	39},
{18,	25,	36,	1,	38},
{16,	31,	31,	6,	0},
{15,	25,	36,	4,	38},
{16,	27,	35,	5,	0},
{16,	27,	37,	2,	7},
{16,	28,	35,	3,	5},
{15,	28,	35,	3,	38},
{15,	32,	35,	0,	39},
{18,	30,	33,	1,	33},
{16,	30,	35,	1,	33},
{15,	32,	32,	1,	37},
{15,	30,	34,	1,	39},
{15,	23,	36,	5,	13},
{15,	29,	31,	5,	38},
{14,	24,	32,	21,	25},
{19,	25,	29,	17,	16},
{18,	25,	29,	21,	10},
{16,	25,	30,	15,	27},
{18,	25,	30,	18,	12},
{16,	25,	32,	11,	10},
{15,	24,	29,	18,	35},
{15,	24,	33,	12,	1},
{15,	24,	33,	10,	13},
{15,	24,	31,	18,	26},
{14,	39,	26,	9,	36},
{14,	23,	33,	15,	39},
{15,	24,	33,	8,	39},
{14,	39,	25,	15,	36},
{15,	39,	23,	15,	38},
{18,	39,	21,	20,	39},
{15,	39,	22,	19,	38},
{15,	31,	23,	18,	37},
{14,	13,	39,	25,	5},
{17,	13,	37,	22,	6},
{16,	16,	37,	24,	1},
{16,	17,	37,	21,	12},
{16,	13,	37,	23,	6},
{16,	17,	39,	21,	2},
{15,	11,	39,	27,	0},
{15,	13,	37,	27,	1},
{14,	21,	30,	21,	39},
{15,	22,	30,	17,	39},
{14,	17,	11,	38,	35},
{15,	17,	16,	35,	35},
{14,	23,	35,	12,	36},
{18,	21,	36,	13,	6},
{16,	21,	37,	10,	4},
{16,	21,	35,	15,	9},
{15,	23,	36,	13,	0},
{16,	23,	36,	12,	1},
{15,	21,	39,	10,	0},
{15,	21,	39,	5,	19},
{16,	21,	38,	9,	6},
{17,	21,	38,	6,	23},
{15,	21,	39,	8,	17},
{18,	21,	36,	8,	31},
{15,	24,	38,	6,	1},
{16,	22,	38,	4,	27},
{16,	23,	39,	2,	26},
{15,	22,	38,	6,	15},
{15,	22,	36,	6,	34},
{15,	21,	36,	9,	31},
{17,	21,	38,	9,	17},
{15,	21,	36,	13,	10},
{14,	19,	24,	31,	35},
{14,	15,	30,	23,	37},
{17,	14,	30,	28,	32},
{16,	14,	31,	23,	34},
{16,	15,	30,	28,	32},
{16,	16,	30,	23,	36},
{15,	14,	33,	23,	34},
{15,	16,	32,	23,	32},
{14,	26,	33,	9,	39},
{14,	29,	28,	18,	39},
{15,	28,	25,	19,	38},
{14,	39,	24,	15,	39},
{16,	31,	25,	15,	37},
{15,	32,	25,	12,	37},
{14,	19,	29,	28,	29},
{19,	18,	30,	28,	9},
{18,	18,	30,	24,	23},
{16,	18,	29,	23,	37},
{16,	17,	29,	25,	32},
{16,	18,	29,	30,	1},
{16,	20,	29,	24,	6},
{15,	18,	29,	31,	15},
{15,	22,	27,	28,	5},
{17,	21,	25,	28,	19},
{16,	22,	24,	28,	19},
{16,	22,	26,	26,	12},
{16,	20,	25,	30,	10},
{15,	22,	28,	24,	14},
{17,	20,	28,	24,	23},
{15,	23,	26,	25,	11},
{15,	19,	29,	24,	31},
{15,	23,	26,	24,	18},
{16,	22,	27,	24,	21},
{15,	19,	30,	23,	13},
{15,	22,	25,	28,	13},
{14,	25,	21,	33,	24},
{16,	18,	23,	32,	13},
{16,	10,	22,	32,	16},
{15,	16,	20,	36,	10},
{17,	16,	21,	34,	7},
{16,	27,	21,	34,	0},
{15,	9,	20,	36,	11},
{16,	20,	20,	34,	13},
{16,	9,	20,	36,	12},
{15,	3,	19,	35,	26},
{15,	21,	23,	32,	8},
{15,	22,	22,	33,	8},
{16,	5,	22,	33,	12},
{14,	25,	20,	32,	37},
{17,	13,	20,	33,	33},
{17,	24,	21,	33,	25},
{15,	9,	20,	33,	36},
{14,	30,	28,	15,	32},
{15,	30,	28,	10,	39},
{14,	24,	34,	12,	36},
{16,	24,	33,	15,	14},
{16,	26,	34,	8,	4},
{16,	26,	34,	9,	2},
{15,	24,	33,	12,	37},
{15,	26,	34,	7,	9},
{14,	9,	19,	39,	2},
{14,	28,	31,	8,	34},
{17,	27,	31,	9,	4},
{16,	27,	31,	10,	4},
{15,	28,	33,	7,	0},
{14,	27,	31,	15,	18},
{18,	25,	31,	15,	25},
{16,	27,	31,	9,	28},
{17,	27,	31,	14,	19},
{16,	26,	31,	13,	26},
{16,	26,	31,	14,	23},
{14,	14,	33,	32,	2},
{14,	22,	36,	15,	28},
{16,	22,	38,	10,	4},
{19,	23,	37,	14,	0},
{15,	22,	38,	8,	14},
{16,	22,	37,	9,	17},
{15,	23,	37,	7,	17},
{16,	23,	37,	10,	3},
{15,	23,	37,	5,	25},
{15,	23,	37,	8,	6},
{14,	32,	31,	3,	39},
{15,	33,	31,	2,	11},
{16,	33,	31,	3,	6},
{15,	32,	28,	4,	39},
{14,	25,	29,	21,	33},
{14,	19,	39,	19,	17},
{17,	19,	38,	20,	2},
{15,	19,	38,	20,	6},
{16,	19,	37,	20,	10},
{15,	18,	36,	23,	0},
{14,	15,	29,	33,	2},
{15,	8,	27,	33,	3},
{19,	5,	23,	33,	12},
{14,	39,	28,	1,	38},
{15,	39,	29,	0,	6},
{14,	32,	26,	12,	36},
{16,	32,	27,	10,	21},
{16,	32,	26,	13,	16},
{15,	33,	26,	10,	11},
{15,	31,	26,	12,	37},
{15,	32,	26,	15,	5},
{14,	24,	34,	10,	39},
{14,	4,	35,	25,	31},
{14,	11,	39,	21,	20},
{16,	14,	38,	21,	18},
{14,	23,	25,	28,	32},
{18,	21,	24,	29,	30},
{16,	20,	24,	31,	30},
{16,	22,	23,	31,	27},
{17,	22,	24,	29,	25},
{16,	23,	25,	29,	5},
{15,	24,	24,	27,	36},
{16,	24,	24,	28,	26},
{15,	23,	23,	29,	30},
{16,	23,	24,	29,	23},
{17,	24,	24,	29,	15},
{16,	24,	23,	30,	22},
{15,	25,	23,	29,	29},
{15,	27,	23,	29,	21},
{18,	27,	24,	24,	27},
{17,	28,	23,	25,	20},
{16,	28,	23,	26,	20},
{15,	25,	24,	28,	9},
{14,	21,	28,	28,	29},
{18,	21,	26,	28,	31},
{17,	22,	28,	27,	3},
{15,	22,	27,	26,	14},
{15,	20,	30,	25,	1},
{14,	25,	31,	18,	25},
{14,	19,	39,	7,	37},
{17,	21,	39,	2,	38},
{14,	39,	22,	26,	21},
{16,	31,	23,	27,	0},
{14,	32,	28,	9,	32},
{15,	32,	28,	5,	36},
{14,	17,	26,	30,	30},
{17,	14,	25,	29,	31},
{16,	18,	25,	31,	29},
{14,	21,	31,	24,	7},
{16,	19,	33,	25,	0},
{16,	22,	30,	22,	2},
{16,	20,	31,	25,	2},
{15,	18,	31,	23,	26},
{15,	22,	31,	24,	1},
{15,	25,	29,	23,	0},
{16,	23,	31,	22,	1},
{15,	19,	31,	22,	16},
{15,	19,	31,	28,	0},
{15,	19,	30,	28,	4},
{15,	19,	30,	24,	16},
{14,	1,	39,	30,	0},
{14,	34,	27,	6,	34},
{14,	12,	30,	25,	33},
{14,	18,	39,	12,	31},
{15,	18,	39,	13,	30},
{16,	5,	39,	14,	29},
{14,	2,	15,	37,	33},
{17,	17,	13,	37,	18},
{14,	30,	21,	28,	33},
{14,	4,	37,	21,	29},
{17,	4,	36,	22,	29},
{17,	4,	38,	21,	22},
{14,	16,	30,	29,	29},
{15,	4,	28,	30,	29},
{14,	13,	38,	23,	7},
{14,	31,	25,	15,	39},
{14,	32,	35,	1,	28},
{14,	25,	25,	24,	36},
{17,	27,	23,	24,	33},
{14,	33,	27,	7,	28},
{14,	18,	34,	22,	26},
{17,	18,	36,	22,	6},
{14,	11,	17,	36,	32},
{14,	5,	22,	34,	12},
{17,	16,	22,	34,	8},
{16,	14,	21,	34,	16},
{15,	18,	22,	34,	8},
{14,	20,	35,	10,	38},
{16,	16,	36,	9,	37},
{14,	16,	35,	9,	39},
{14,	30,	32,	3,	27},
{16,	30,	32,	4,	3},
{14,	17,	37,	29,	1},
{16,	17,	38,	23,	1},
{14,	32,	25,	18,	34},
{15,	33,	25,	18,	29},
{15,	39,	24,	17,	31},
{14,	26,	36,	4,	34},
{15,	28,	36,	1,	30},
{16,	27,	39,	1,	16},
{14,	33,	33,	1,	20},
{16,	36,	32,	1,	0},
{15,	33,	35,	0,	27},
{14,	25,	30,	19,	20},
{14,	8,	36,	15,	36},
{14,	6,	37,	14,	36},
{14,	7,	24,	34,	2},
{16,	7,	23,	35,	1},
{14,	26,	21,	32,	30},
{15,	27,	21,	33,	10},
{14,	4,	35,	21,	35},
{14,	4,	37,	21,	33},
{15,	15,	36,	21,	31},
{14,	9,	36,	23,	32},
{16,	13,	36,	23,	31},
{15,	17,	36,	22,	29},
{14,	5,	36,	25,	31},
{14,	30,	25,	20,	35},
{14,	25,	33,	12,	6},
{16,	25,	32,	14,	3},
{16,	26,	34,	10,	0},
{14,	39,	24,	18,	35},
{14,	11,	39,	26,	1},
{14,	14,	14,	37,	33},
{14,	19,	29,	30,	4},
{16,	20,	26,	30,	8},
{17,	21,	27,	29,	3},
{15,	20,	28,	30,	1},
{14,	29,	34,	4,	6},
{15,	29,	35,	3,	6},
{14,	27,	32,	7,	32},
{15,	27,	32,	8,	5},
{15,	27,	33,	10,	0},
{14,	23,	36,	15,	4},
{15,	23,	35,	14,	9},
{14,	24,	36,	12,	2},
{15,	24,	38,	8,	0},
{14,	21,	24,	28,	36},
{14,	16,	36,	9,	38},
{14,	15,	18,	37,	12},
{16,	12,	20,	36,	13},
{15,	9,	16,	37,	18},
{14,	28,	29,	15,	2},
{14,	22,	27,	24,	33},
{14,	15,	27,	26,	33},
{15,	20,	26,	26,	33},
{14,	39,	21,	26,	34},
{15,	39,	20,	23,	36},
{15,	29,	20,	25,	36},
{14,	20,	36,	19,	6},
{15,	20,	38,	19,	2},
{15,	20,	39,	20,	0},
{14,	23,	21,	33,	29},
{14,	39,	18,	32,	35},
{14,	24,	38,	4,	16},
{16,	25,	37,	3,	26},
{14,	30,	26,	19,	23},
{14,	22,	38,	4,	39},
{14,	9,	14,	38,	14},
{14,	33,	30,	4,	5},
{14,	39,	11,	37,	30},
{18,	20,	15,	37,	14},
{16,	21,	17,	37,	8},
{15,	18,	13,	37,	30},
{15,	20,	15,	37,	21},
{14,	25,	24,	24,	38},
{14,	24,	36,	15,	0},
{14,	20,	39,	7,	35},
{14,	27,	27,	23,	2},
{15,	25,	26,	23,	9},
{14,	32,	25,	12,	38},
{14,	19,	36,	19,	21},
{14,	35,	28,	2,	13},
{14,	39,	23,	18,	36},
{14,	27,	25,	29,	0},
{14,	34,	32,	1,	12},
{14,	18,	23,	34,	3},
{14,	3,	23,	34,	11},
{15,	18,	23,	34,	6},
{14,	31,	35,	1,	37},
{14,	20,	39,	4,	38},
{14,	19,	30,	26,	12},
{14,	33,	31,	4,	2},
{14,	18,	27,	31,	27},
{15,	18,	29,	29,	24},
{14,	22,	37,	9,	22},
{14,	22,	37,	7,	34},
{17,	21,	37,	9,	31},
{15,	20,	37,	14,	29},
{16,	20,	39,	14,	28},
{14,	18,	31,	27,	7},
{16,	18,	32,	27,	3},
{14,	21,	31,	25,	5},
{15,	19,	31,	27,	7},
{14,	18,	33,	23,	26},
{14,	22,	31,	26,	0},
{14,	20,	29,	31,	1},
{14,	22,	29,	30,	0},
{15,	26,	25,	30,	0},
{14,	28,	23,	26,	22},
{14,	12,	19,	36,	15},
{15,	12,	18,	37,	15},
{14,	3,	18,	36,	26},
{14,	21,	25,	33,	0},
{15,	21,	28,	31,	1},
{16,	21,	25,	31,	5},
{15,	21,	25,	32,	3},
{14,	20,	26,	31,	14},
{15,	20,	25,	29,	25},
{14,	24,	25,	30,	2},
{14,	9,	20,	37,	6},
{14,	28,	33,	8,	0},
{14,	23,	27,	26,	4},
{14,	23,	27,	25,	14},
{14,	26,	29,	17,	0},
{14,	25,	37,	5,	2},
{15,	26,	35,	6,	2},
{14,	21,	20,	33,	35},
{14,	32,	24,	21,	31},
{14,	13,	34,	23,	33},
{14,	25,	32,	10,	34},
{14,	25,	38,	1,	35},
{14,	24,	37,	4,	32},
{14,	25,	38,	3,	32},
{14,	23,	39,	3,	32},
{14,	22,	39,	8,	9},
{15,	23,	39,	6,	7},
{15,	22,	39,	9,	6},
{14,	27,	31,	13,	20},
{14,	16,	38,	21,	12},
{15,	17,	38,	23,	3},
{14,	23,	29,	18,	39},
{14,	17,	30,	23,	36},
{14,	30,	26,	16,	32},
{14,	34,	30,	0,	39},
{14,	18,	36,	7,	39},
{14,	25,	25,	25,	24},
{14,	15,	39,	23,	1},
{14,	18,	24,	34,	1},
{14,	32,	30,	4,	10},
{14,	39,	19,	29,	30},
{14,	26,	25,	24,	29},
{14,	21,	11,	36,	35},
{14,	13,	39,	21,	18},
{14,	25,	32,	15,	3},
{14,	22,	36,	16,	0},
{14,	28,	33,	7,	1},
{14,	28,	32,	7,	25},
{14,	30,	33,	4,	1},
{14,	27,	20,	30,	35},
{14,	22,	39,	4,	37},
{14,	23,	39,	4,	35},
{14,	21,	39,	5,	35},
{14,	21,	38,	9,	29},
{14,	21,	20,	35,	8},
{14,	21,	30,	26,	2},
{14,	33,	30,	3,	11},
{14,	14,	13,	39,	2},
{14,	24,	29,	21,	34},
{14,	19,	16,	35,	35},
{14,	39,	16,	35,	34},
{14,	20,	14,	36,	35},
{14,	32,	32,	1,	39},
{14,	29,	31,	5,	39},
{14,	29,	23,	22,	21},
{14,	23,	37,	7,	20},
{14,	23,	35,	14,	13},
{14,	8,	24,	34,	3},
{13,	22,	39,	28,	31},
{20,	6,	37,	29,	4},
{19,	22,	29,	25,	32},
{18,	20,	33,	23,	32},
{18,	23,	37,	14,	5},
{17,	11,	38,	14,	32},
{17,	23,	34,	23,	0},
{16,	3,	38,	29,	4},
{17,	3,	39,	29,	1},
{16,	23,	34,	23,	1},
{16,	22,	28,	26,	32},
{15,	9,	37,	22,	32},
{15,	23,	38,	13,	2},
{15,	23,	38,	5,	29},
{15,	22,	27,	25,	33},
{15,	21,	29,	23,	34},
{15,	20,	30,	22,	35},
{15,	19,	30,	23,	36},
{15,	22,	39,	6,	35},
{15,	11,	38,	15,	32},
{15,	24,	37,	11,	1},
{14,	22,	36,	21,	34},
{16,	22,	35,	15,	35},
{15,	18,	37,	22,	32},
{15,	19,	36,	15,	35},
{14,	22,	27,	25,	35},
{14,	9,	35,	21,	36},
{14,	22,	37,	16,	34},
{17,	21,	38,	10,	34},
{16,	21,	37,	18,	34},
{14,	11,	38,	15,	34},
{14,	6,	36,	18,	36},
{14,	20,	26,	26,	35},
{14,	22,	29,	28,	32},
{14,	23,	36,	14,	10},
{14,	24,	36,	10,	13},
{17,	24,	38,	5,	18},
{17,	24,	35,	7,	22},
{17,	24,	35,	10,	18},
{16,	26,	35,	6,	5},
{16,	24,	37,	6,	18},
{16,	24,	37,	10,	8},
{15,	24,	35,	7,	27},
{15,	25,	37,	5,	7},
{14,	26,	35,	6,	27},
{17,	26,	36,	5,	17},
{14,	28,	35,	5,	10},
{16,	27,	35,	5,	24},
{16,	27,	35,	6,	7},
{16,	27,	36,	5,	4},
{15,	27,	36,	5,	10},
{14,	27,	36,	4,	28},
{14,	28,	36,	3,	35},
{15,	28,	37,	3,	10},
{16,	29,	37,	4,	0},
{16,	31,	39,	1,	2},
{14,	28,	36,	4,	28},
{14,	16,	31,	29,	29},
{14,	23,	30,	23,	6},
{14,	18,	30,	29,	23},
{16,	21,	30,	30,	0},
{15,	18,	36,	29,	2},
{14,	18,	38,	15,	33},
{14,	27,	35,	6,	23},
{14,	22,	39,	6,	36},
{14,	21,	38,	15,	32},
{14,	18,	36,	20,	35},
{14,	19,	33,	29,	1},
{15,	21,	31,	29,	1},
{14,	19,	32,	30,	1},
{14,	5,	39,	30,	0},
{14,	18,	37,	21,	33},
{14,	23,	36,	8,	20},
{14,	28,	35,	5,	17},
{14,	16,	29,	25,	33},
{14,	27,	36,	3,	37},
{14,	23,	33,	23,	2},
{15,	23,	32,	23,	4},
{13,	28,	32,	21,	36},
{17,	29,	26,	21,	8},
{17,	26,	32,	12,	37},
{15,	26,	29,	18,	38},
{17,	24,	31,	16,	37},
{15,	26,	29,	21,	37},
{15,	24,	31,	14,	38},
{15,	26,	32,	11,	38},
{14,	29,	31,	12,	2},
{14,	25,	33,	12,	36},
{14,	26,	29,	18,	39},
{16,	26,	30,	13,	39},
{14,	27,	29,	15,	37},
{14,	29,	26,	21,	29},
{14,	30,	26,	21,	23},
{14,	24,	32,	13,	39},
{15,	24,	33,	12,	39},
{14,	27,	30,	10,	38},
{14,	28,	33,	10,	0},
{13,	27,	26,	28,	39},
{21,	28,	19,	27,	39},
{18,	22,	27,	27,	33},
{17,	24,	27,	25,	5},
{17,	27,	26,	29,	0},
{16,	27,	27,	23,	5},
{16,	23,	27,	29,	1},
{16,	24,	25,	29,	8},
{16,	26,	20,	30,	38},
{15,	28,	22,	23,	39},
{15,	22,	27,	24,	36},
{15,	28,	22,	26,	34},
{14,	10,	27,	26,	36},
{14,	10,	25,	29,	34},
{14,	13,	28,	27,	33},
{14,	24,	27,	25,	13},
{18,	27,	27,	23,	7},
{16,	25,	27,	23,	13},
{14,	22,	27,	24,	37},
{14,	27,	26,	29,	2},
{17,	26,	24,	29,	12},
{16,	27,	25,	30,	1},
{15,	24,	26,	29,	7},
{15,	26,	24,	29,	16},
{14,	21,	26,	31,	14},
{15,	24,	25,	30,	8},
{16,	22,	24,	30,	20},
{15,	21,	24,	31,	28},
{14,	23,	27,	28,	12},
{14,	21,	25,	29,	30},
{14,	22,	28,	29,	3},
{13,	13,	32,	34,	20},
{18,	15,	20,	34,	23},
{17,	14,	25,	33,	19},
{16,	14,	27,	34,	8},
{15,	15,	20,	34,	29},
{15,	18,	22,	33,	21},
{17,	18,	22,	32,	23},
{17,	10,	23,	32,	23},
{16,	6,	22,	34,	22},
{15,	6,	24,	33,	22},
{15,	16,	27,	34,	1},
{15,	21,	25,	32,	6},
{14,	15,	24,	32,	30},
{14,	13,	24,	34,	26},
{18,	13,	23,	33,	28},
{15,	13,	22,	34,	27},
{14,	7,	33,	33,	2},
{17,	15,	33,	33,	0},
{14,	18,	25,	34,	6},
{14,	14,	32,	32,	12},
{15,	15,	29,	32,	10},
{15,	14,	29,	33,	12},
{14,	18,	23,	32,	25},
{14,	10,	23,	33,	29},
{14,	22,	22,	33,	13},
{14,	20,	25,	32,	9},
{15,	18,	26,	32,	10},
{14,	16,	27,	34,	4},
{13,	30,	29,	21,	35},
{17,	31,	27,	16,	4},
{17,	29,	30,	15,	0},
{15,	29,	31,	13,	1},
{15,	29,	30,	11,	4},
{14,	29,	29,	10,	37},
{13,	19,	38,	31,	24},
{18,	20,	25,	31,	29},
{17,	7,	38,	29,	26},
{16,	11,	39,	30,	2},
{16,	21,	26,	31,	17},
{14,	17,	38,	29,	26},
{14,	19,	27,	29,	29},
{14,	21,	30,	31,	1},
{13,	26,	35,	18,	34},
{15,	26,	33,	10,	38},
{15,	24,	35,	8,	36},
{14,	23,	35,	21,	34},
{14,	24,	35,	8,	38},
{16,	26,	35,	6,	38},
{16,	22,	36,	6,	38},
{14,	24,	34,	13,	37},
{14,	23,	35,	10,	37},
{13,	23,	29,	28,	37},
{14,	23,	27,	25,	38},
{14,	23,	30,	24,	30},
{16,	23,	30,	22,	34},
{15,	22,	33,	23,	32},
{14,	24,	29,	22,	12},
{14,	24,	28,	23,	18},
{15,	24,	27,	25,	18},
{15,	24,	29,	22,	18},
{14,	24,	28,	24,	11},
{14,	25,	27,	22,	18},
{13,	15,	15,	39,	24},
{16,	14,	14,	38,	26},
{15,	18,	15,	38,	25},
{15,	8,	13,	38,	30},
{14,	18,	14,	39,	12},
{14,	13,	19,	39,	3},
{15,	18,	20,	39,	0},
{14,	10,	21,	39,	0},
{14,	10,	21,	37,	2},
{13,	20,	13,	37,	37},
{14,	5,	15,	35,	37},
{15,	5,	17,	35,	36},
{14,	24,	14,	34,	37},
{13,	21,	38,	15,	38},
{17,	22,	38,	5,	39},
{16,	14,	35,	20,	36},
{15,	22,	38,	15,	33},
{15,	18,	35,	18,	36},
{14,	18,	36,	18,	36},
{14,	22,	36,	10,	37},
{15,	22,	36,	15,	36},
{14,	17,	35,	20,	36},
{13,	34,	29,	6,	39},
{20,	32,	29,	7,	10},
{15,	32,	28,	9,	33},
{14,	33,	27,	9,	35},
{13,	31,	31,	9,	39},
{16,	27,	32,	8,	38},
{16,	27,	32,	10,	37},
{14,	28,	32,	9,	38},
{14,	28,	31,	10,	37},
{13,	30,	26,	26,	25},
{16,	28,	26,	27,	2},
{16,	39,	22,	26,	23},
{15,	31,	26,	22,	1},
{15,	31,	23,	24,	23},
{18,	31,	24,	24,	6},
{16,	31,	26,	23,	1},
{16,	31,	25,	23,	6},
{16,	31,	25,	26,	0},
{14,	31,	24,	26,	23},
{14,	28,	25,	23,	35},
{16,	29,	23,	25,	27},
{16,	28,	23,	24,	36},
{15,	29,	23,	24,	34},
{16,	29,	23,	25,	32},
{14,	31,	23,	27,	3},
{13,	31,	27,	21,	36},
{15,	30,	27,	15,	38},
{14,	30,	26,	14,	39},
{14,	32,	25,	20,	30},
{13,	26,	28,	28,	27},
{18,	26,	27,	23,	30},
{16,	27,	27,	28,	0},
{16,	24,	29,	22,	28},
{14,	28,	28,	23,	2},
{17,	28,	27,	27,	0},
{16,	29,	27,	26,	0},
{16,	28,	27,	23,	5},
{14,	26,	27,	23,	34},
{14,	24,	27,	27,	31},
{14,	26,	27,	28,	30},
{14,	25,	28,	22,	33},
{14,	25,	28,	25,	30},
{15,	25,	28,	24,	32},
{14,	26,	29,	23,	0},
{14,	26,	28,	23,	30},
{14,	24,	27,	29,	2},
{13,	2,	27,	35,	25},
{19,	4,	28,	35,	0},
{18,	7,	24,	35,	15},
{16,	10,	25,	35,	4},
{16,	14,	26,	32,	23},
{17,	7,	26,	34,	25},
{15,	7,	30,	32,	21},
{15,	13,	26,	34,	23},
{15,	2,	23,	35,	26},
{15,	13,	25,	35,	3},
{14,	5,	27,	35,	7},
{14,	11,	27,	33,	23},
{14,	13,	25,	34,	25},
{14,	13,	21,	37,	3},
{14,	18,	22,	35,	3},
{14,	18,	24,	35,	1},
{14,	18,	23,	35,	6},
{16,	14,	21,	35,	15},
{14,	21,	17,	35,	21},
{14,	21,	19,	35,	15},
{13,	28,	34,	10,	38},
{17,	27,	35,	10,	0},
{15,	28,	31,	10,	39},
{15,	26,	34,	12,	36},
{14,	27,	35,	10,	13},
{15,	27,	35,	8,	19},
{14,	28,	34,	11,	0},
{14,	25,	34,	9,	39},
{14,	27,	33,	13,	0},
{15,	28,	33,	12,	0},
{13,	15,	31,	31,	32},
{16,	17,	29,	29,	33},
{15,	22,	33,	24,	32},
{15,	17,	28,	31,	30},
{14,	8,	32,	29,	31},
{16,	8,	32,	30,	29},
{14,	10,	26,	29,	34},
{14,	15,	25,	30,	33},
{14,	2,	26,	30,	33},
{14,	19,	25,	30,	32},
{15,	16,	30,	30,	32},
{13,	25,	35,	21,	34},
{16,	26,	34,	20,	0},
{14,	26,	33,	19,	1},
{13,	39,	27,	9,	19},
{18,	34,	27,	9,	21},
{17,	34,	27,	8,	24},
{13,	15,	37,	26,	33},
{18,	16,	30,	27,	33},
{18,	13,	30,	28,	33},
{16,	21,	33,	22,	33},
{15,	14,	30,	26,	34},
{15,	20,	31,	24,	33},
{14,	20,	31,	27,	33},
{15,	20,	30,	25,	34},
{14,	17,	37,	22,	33},
{14,	17,	33,	25,	33},
{14,	16,	33,	23,	34},
{14,	21,	33,	22,	34},
{13,	32,	33,	4,	32},
{16,	29,	35,	4,	9},
{15,	32,	33,	1,	39},
{14,	29,	34,	4,	36},
{16,	29,	34,	3,	38},
{14,	33,	31,	4,	7},
{13,	33,	28,	9,	37},
{13,	32,	29,	9,	39},
{13,	27,	30,	20,	39},
{16,	26,	30,	21,	37},
{16,	24,	31,	17,	38},
{15,	27,	32,	12,	37},
{14,	24,	32,	15,	39},
{14,	28,	29,	11,	38},
{13,	13,	36,	32,	11},
{14,	14,	36,	32,	3},
{13,	34,	26,	12,	35},
{15,	33,	26,	13,	4},
{14,	39,	26,	10,	5},
{13,	33,	27,	15,	31},
{16,	33,	26,	15,	32},
{14,	33,	26,	21,	2},
{17,	32,	26,	18,	5},
{15,	32,	26,	18,	7},
{14,	32,	27,	12,	33},
{14,	32,	26,	13,	36},
{13,	32,	30,	9,	31},
{13,	39,	21,	31,	36},
{16,	27,	22,	31,	35},
{16,	29,	22,	25,	36},
{15,	28,	20,	34,	2},
{15,	27,	18,	30,	38},
{14,	27,	21,	30,	38},
{14,	39,	20,	32,	11},
{13,	31,	28,	15,	31},
{14,	32,	28,	10,	21},
{15,	32,	28,	13,	0},
{13,	18,	36,	18,	38},
{13,	13,	24,	37,	12},
{16,	3,	21,	36,	16},
{15,	15,	24,	38,	0},
{15,	10,	22,	36,	15},
{15,	15,	19,	37,	15},
{14,	15,	23,	37,	5},
{14,	15,	25,	35,	6},
{14,	14,	24,	35,	15},
{14,	15,	24,	36,	9},
{14,	17,	24,	34,	9},
{14,	15,	24,	35,	14},
{14,	18,	23,	35,	13},
{14,	15,	21,	37,	13},
{14,	14,	24,	36,	15},
{14,	3,	23,	36,	16},
{13,	24,	32,	18,	39},
{14,	24,	32,	21,	37},
{13,	25,	31,	23,	22},
{16,	24,	29,	23,	32},
{14,	24,	29,	28,	21},
{17,	24,	31,	24,	2},
{16,	25,	29,	25,	7},
{17,	25,	29,	28,	1},
{16,	25,	31,	24,	2},
{16,	26,	29,	26,	0},
{14,	23,	31,	26,	4},
{14,	24,	29,	24,	32},
{14,	24,	29,	28,	23},
{13,	29,	30,	12,	39},
{16,	29,	31,	10,	15},
{15,	29,	31,	10,	38},
{13,	33,	30,	6,	35},
{16,	32,	30,	8,	35},
{16,	32,	30,	4,	39},
{14,	34,	30,	3,	12},
{17,	34,	31,	3,	5},
{13,	36,	31,	1,	35},
{18,	36,	30,	0,	38},
{17,	35,	32,	0,	18},
{13,	23,	39,	13,	23},
{16,	24,	37,	10,	12},
{15,	23,	36,	14,	23},
{15,	24,	38,	7,	9},
{14,	23,	36,	9,	37},
{16,	24,	36,	6,	38},
{15,	23,	36,	5,	39},
{14,	23,	39,	5,	35},
{14,	23,	37,	6,	39},
{14,	24,	37,	11,	7},
{14,	23,	38,	5,	39},
{14,	26,	38,	0,	39},
{14,	24,	35,	6,	39},
{15,	28,	35,	3,	39},
{14,	26,	38,	1,	38},
{13,	23,	36,	20,	35},
{17,	23,	36,	21,	18},
{14,	23,	36,	23,	1},
{14,	23,	36,	21,	33},
{14,	23,	35,	21,	35},
{14,	23,	35,	13,	37},
{14,	24,	35,	12,	37},
{13,	22,	30,	26,	36},
{14,	21,	33,	23,	34},
{14,	19,	33,	26,	33},
{14,	23,	30,	23,	36},
{13,	19,	39,	29,	13},
{13,	8,	35,	21,	38},
{13,	39,	27,	6,	33},
{13,	13,	26,	33,	30},
{13,	31,	29,	15,	10},
{14,	31,	29,	10,	31},
{14,	32,	29,	10,	19},
{13,	19,	23,	31,	38},
{19,	19,	24,	29,	36},
{15,	18,	24,	31,	36},
{14,	25,	23,	29,	37},
{13,	34,	26,	9,	39},
{15,	33,	27,	7,	39},
{15,	33,	27,	9,	38},
{13,	23,	31,	28,	23},
{15,	23,	30,	27,	26},
{14,	23,	32,	27,	0},
{14,	23,	35,	24,	0},
{14,	23,	33,	27,	0},
{14,	23,	33,	24,	3},
{13,	7,	39,	10,	37},
{13,	29,	27,	23,	19},
{14,	29,	28,	22,	1},
{13,	6,	22,	34,	33},
{17,	15,	20,	34,	35},
{16,	4,	21,	32,	35},
{14,	6,	23,	33,	33},
{14,	9,	20,	34,	36},
{13,	6,	38,	32,	3},
{14,	11,	38,	32,	0},
{13,	23,	29,	23,	38},
{13,	15,	39,	30,	6},
{15,	19,	39,	30,	0},
{13,	32,	26,	18,	31},
{13,	27,	31,	18,	38},
{16,	25,	31,	19,	38},
{16,	26,	31,	14,	39},
{15,	26,	32,	15,	37},
{13,	25,	24,	31,	20},
{16,	25,	23,	31,	25},
{15,	22,	30,	31,	0},
{14,	27,	25,	31,	0},
{15,	24,	25,	31,	8},
{15,	23,	26,	31,	2},
{15,	23,	25,	32,	1},
{14,	23,	26,	30,	7},
{14,	22,	25,	32,	7},
{13,	0,	39,	32,	3},
{17,	19,	39,	31,	0},
{13,	32,	28,	12,	20},
{15,	32,	29,	11,	1},
{13,	27,	34,	21,	0},
{13,	17,	36,	20,	36},
{13,	33,	31,	3,	39},
{14,	34,	31,	3,	8},
{13,	15,	35,	23,	34},
{13,	34,	31,	3,	28},
{13,	33,	25,	12,	39},
{13,	28,	35,	6,	34},
{13,	24,	36,	10,	37},
{14,	23,	36,	12,	37},
{13,	39,	23,	25,	12},
{16,	39,	23,	26,	10},
{13,	28,	33,	18,	1},
{13,	39,	26,	15,	0},
{13,	33,	32,	4,	13},
{14,	34,	32,	3,	6},
{14,	33,	33,	4,	1},
{13,	26,	35,	9,	38},
{13,	14,	37,	18,	36},
{13,	10,	29,	29,	34},
{13,	2,	22,	36,	22},
{13,	33,	29,	7,	19},
{16,	33,	29,	8,	0},
{13,	35,	27,	3,	38},
{13,	2,	34,	33,	2},
{13,	29,	29,	21,	36},
{13,	29,	23,	21,	39},
{14,	29,	24,	21,	38},
{14,	28,	28,	21,	37},
{14,	39,	19,	26,	38},
{13,	26,	36,	9,	2},
{16,	25,	37,	7,	3},
{14,	26,	36,	12,	0},
{13,	23,	37,	13,	34},
{16,	23,	39,	11,	26},
{13,	24,	36,	20,	2},
{14,	24,	36,	15,	6},
{13,	26,	21,	34,	13},
{14,	22,	20,	35,	13},
{14,	19,	22,	35,	13},
{15,	19,	25,	34,	4},
{13,	7,	37,	30,	26},
{13,	34,	27,	10,	21},
{14,	35,	27,	10,	2},
{13,	31,	39,	1,	16},
{16,	29,	37,	3,	8},
{13,	27,	36,	4,	39},
{13,	28,	23,	25,	38},
{16,	28,	21,	28,	38},
{17,	28,	22,	26,	39},
{14,	28,	24,	22,	38},
{13,	30,	28,	12,	38},
{13,	21,	15,	38,	24},
{15,	22,	16,	39,	3},
{14,	39,	15,	36,	21},
{14,	21,	11,	38,	35},
{14,	24,	14,	39,	5},
{13,	30,	27,	18,	37},
{13,	31,	27,	24,	0},
{14,	30,	28,	23,	0},
{13,	27,	25,	32,	1},
{14,	27,	23,	33,	0},
{14,	22,	23,	33,	9},
{13,	20,	25,	35,	4},
{14,	23,	25,	33,	1},
{13,	30,	23,	26,	29},
{14,	29,	22,	26,	36},
{13,	31,	23,	23,	35},
{16,	31,	23,	25,	27},
{15,	30,	22,	26,	34},
{15,	39,	22,	23,	36},
{14,	31,	24,	23,	26},
{14,	30,	24,	24,	27},
{13,	28,	25,	28,	28},
{16,	28,	26,	26,	27},
{16,	29,	26,	26,	26},
{14,	28,	23,	31,	3},
{16,	30,	22,	31,	1},
{14,	31,	24,	27,	3},
{14,	28,	26,	27,	11},
{14,	28,	24,	26,	30},
{15,	30,	23,	26,	32},
{13,	28,	25,	29,	20},
{15,	25,	26,	29,	10},
{15,	24,	26,	29,	13},
{14,	27,	26,	29,	7},
{14,	28,	22,	31,	12},
{14,	23,	26,	30,	10},
{14,	28,	22,	29,	31},
{14,	24,	25,	30,	11},
{14,	23,	25,	31,	15},
{13,	30,	22,	29,	31},
{17,	39,	23,	27,	6},
{14,	31,	23,	27,	18},
{13,	32,	30,	7,	37},
{14,	32,	30,	8,	36},
{13,	29,	31,	15,	1},
{13,	29,	30,	17,	4},
{15,	29,	30,	19,	0},
{13,	36,	29,	0,	39},
{14,	35,	28,	1,	39},
{13,	30,	28,	18,	36},
{13,	35,	27,	3,	39},
{13,	22,	39,	9,	33},
{16,	15,	39,	8,	36},
{14,	13,	39,	10,	36},
{13,	22,	35,	9,	39},
{13,	24,	26,	31,	8},
{13,	30,	27,	24,	2},
{14,	29,	27,	25,	1},
{14,	31,	27,	22,	2},
{13,	29,	23,	29,	18},
{16,	29,	25,	28,	1},
{13,	39,	26,	7,	37},
{15,	39,	26,	5,	38},
{13,	28,	38,	1,	37},
{13,	26,	31,	24,	0},
{13,	25,	29,	23,	31},
{13,	36,	28,	2,	10},
{13,	31,	29,	11,	21},
{13,	13,	30,	29,	33},
{13,	35,	27,	11,	1},
{13,	39,	22,	17,	39},
{13,	24,	34,	15,	37},
{14,	24,	33,	18,	37},
{13,	26,	33,	18,	35},
{14,	25,	34,	14,	36},
{13,	32,	29,	13,	0},
{13,	18,	36,	25,	32},
{14,	22,	34,	24,	32},
{14,	19,	34,	23,	34},
{14,	20,	34,	26,	32},
{13,	23,	30,	22,	37},
{13,	32,	24,	20,	34},
{13,	25,	24,	32,	6},
{14,	23,	25,	33,	4},
{13,	13,	21,	39,	2},
{13,	19,	20,	34,	35},
{15,	18,	23,	35,	15},
{13,	16,	22,	34,	25},
{14,	18,	23,	34,	18},
{13,	24,	38,	8,	9},
{13,	31,	24,	27,	11},
{14,	29,	24,	28,	11},
{13,	31,	25,	23,	11},
{13,	25,	31,	18,	39},
{13,	7,	19,	36,	25},
{16,	7,	24,	35,	23},
{15,	15,	20,	36,	17},
{14,	22,	18,	35,	23},
{15,	12,	19,	36,	25},
{15,	16,	21,	35,	22},
{15,	11,	22,	35,	26},
{15,	12,	21,	36,	23},
{14,	11,	24,	35,	23},
{13,	27,	34,	7,	39},
{13,	23,	23,	34,	5},
{14,	24,	22,	35,	2},
{13,	22,	24,	35,	4},
{13,	26,	32,	13,	38},
{14,	27,	32,	12,	38},
{13,	23,	13,	37,	31},
{14,	22,	17,	37,	11},
{13,	28,	26,	28,	9},
{13,	29,	27,	28,	0},
{13,	33,	29,	9,	0},
{13,	20,	17,	35,	35},
{14,	24,	17,	35,	33},
{13,	22,	31,	31,	0},
{13,	28,	21,	28,	39},
{13,	25,	28,	24,	33},
{13,	12,	21,	36,	24},
{13,	26,	37,	3,	25},
{13,	5,	25,	35,	25},
{13,	27,	25,	31,	2},
{13,	10,	38,	32,	2},
{13,	15,	38,	32,	1},
{13,	28,	36,	5,	5},
{13,	25,	31,	20,	38},
{13,	24,	32,	20,	38},
{13,	25,	27,	23,	35},
{13,	25,	27,	22,	38},
{13,	17,	29,	30,	32},
{13,	22,	38,	6,	39},
{13,	21,	25,	30,	28},
{15,	21,	26,	31,	19},
{13,	34,	27,	8,	25},
{13,	25,	39,	3,	16},
{13,	16,	28,	33,	3},
{13,	22,	30,	23,	37},
{13,	20,	30,	28,	33},
{13,	31,	23,	26,	27},
{13,	14,	21,	34,	31},
{13,	29,	25,	27,	6},
{13,	14,	29,	34,	6},
{13,	29,	30,	14,	5},
{13,	28,	19,	30,	37},
{13,	18,	37,	20,	35},
{13,	19,	37,	19,	35},
{13,	34,	30,	1,	39},
{14,	36,	30,	1,	36},
{13,	35,	29,	1,	39},
{13,	24,	37,	4,	39},
{14,	25,	38,	3,	37},
{13,	22,	24,	31,	25},
{13,	22,	13,	38,	28},
{13,	29,	22,	30,	12},
{13,	30,	37,	1,	22},
{13,	26,	16,	38,	3},
{14,	23,	15,	38,	21},
{13,	25,	37,	5,	15},
{13,	33,	36,	0,	10},
{13,	13,	22,	38,	2},
{13,	27,	20,	31,	38},
{13,	30,	22,	21,	37},
{13,	23,	26,	29,	16},
{13,	18,	22,	35,	18},
{13,	34,	27,	9,	23},
{13,	18,	39,	30,	3},
{13,	23,	33,	25,	2},
{13,	39,	26,	12,	1},
{13,	24,	39,	7,	5},
{13,	34,	33,	0,	6},
{14,	34,	36,	0,	4},
{13,	36,	29,	2,	0},
{13,	35,	29,	2,	18},
{13,	35,	28,	2,	32},
{13,	30,	25,	26,	26},
{12,	26,	38,	28,	37},
{18,	25,	39,	9,	3},
{17,	26,	38,	6,	38},
{16,	26,	39,	4,	16},
{15,	24,	39,	21,	0},
{15,	24,	29,	22,	38},
{14,	26,	39,	6,	21},
{16,	26,	39,	12,	0},
{14,	24,	39,	13,	19},
{16,	26,	39,	7,	17},
{14,	21,	35,	18,	38},
{14,	25,	39,	9,	15},
{14,	23,	39,	10,	31},
{14,	25,	27,	24,	38},
{14,	22,	37,	9,	38},
{14,	25,	37,	5,	39},
{14,	12,	35,	19,	38},
{14,	23,	39,	14,	13},
{14,	27,	38,	5,	0},
{16,	28,	39,	2,	10},
{14,	24,	39,	23,	0},
{13,	28,	36,	6,	30},
{14,	27,	37,	9,	3},
{13,	24,	39,	18,	18},
{14,	23,	39,	16,	23},
{13,	23,	39,	28,	9},
{14,	24,	39,	23,	5},
{13,	28,	38,	4,	28},
{15,	27,	38,	5,	11},
{14,	28,	37,	5,	13},
{13,	27,	39,	3,	37},
{15,	24,	39,	5,	37},
{16,	24,	39,	13,	23},
{13,	21,	35,	21,	38},
{13,	25,	39,	19,	1},
{13,	24,	39,	27,	5},
{14,	24,	39,	26,	6},
{13,	22,	38,	13,	38},
{15,	26,	35,	10,	38},
{13,	26,	36,	6,	39},
{13,	28,	35,	6,	39},
{13,	27,	38,	6,	9},
{13,	24,	39,	8,	30},
{13,	27,	39,	0,	39},
{13,	23,	36,	9,	38},
{13,	26,	39,	7,	23},
{13,	25,	39,	9,	20},
{13,	24,	39,	22,	8},
{13,	25,	39,	10,	16},
{13,	25,	39,	24,	2},
{14,	25,	39,	12,	16},
{13,	28,	37,	6,	4},
{12,	16,	39,	35,	26},
{17,	18,	39,	31,	14},
{16,	18,	24,	33,	23},
{16,	18,	25,	33,	20},
{15,	18,	39,	31,	24},
{14,	11,	28,	33,	27},
{14,	15,	23,	36,	17},
{13,	12,	26,	34,	29},
{13,	17,	39,	32,	13},
{13,	16,	37,	31,	27},
{13,	17,	31,	32,	20},
{15,	17,	27,	32,	27},
{13,	17,	29,	33,	25},
{15,	17,	28,	35,	4},
{14,	17,	30,	34,	7},
{13,	23,	26,	33,	2},
{13,	20,	31,	32,	1},
{14,	20,	30,	33,	0},
{14,	19,	35,	32,	0},
{14,	18,	32,	32,	4},
{13,	19,	35,	33,	0},
{14,	17,	33,	33,	5},
{13,	18,	38,	33,	0},
{15,	18,	39,	32,	3},
{13,	17,	35,	35,	0},
{13,	17,	32,	34,	12},
{14,	17,	27,	34,	18},
{14,	17,	32,	35,	4},
{13,	22,	28,	33,	0},
{13,	18,	26,	32,	27},
{13,	18,	25,	32,	29},
{13,	17,	22,	35,	24},
{14,	17,	27,	34,	24},
{13,	20,	21,	34,	29},
{13,	20,	29,	32,	2},
{13,	19,	39,	29,	24},
{13,	19,	27,	33,	4},
{13,	17,	39,	31,	25},
{13,	25,	21,	34,	15},
{13,	22,	21,	34,	26},
{14,	26,	20,	34,	24},
{13,	19,	39,	32,	0},
{13,	25,	26,	32,	0},
{13,	26,	26,	30,	1},
{12,	30,	35,	15,	36},
{18,	30,	35,	3,	38},
{15,	32,	33,	4,	33},
{15,	30,	30,	10,	37},
{14,	31,	32,	8,	29},
{14,	27,	33,	18,	10},
{14,	31,	30,	10,	5},
{14,	29,	33,	5,	37},
{14,	30,	36,	2,	13},
{15,	29,	36,	3,	22},
{14,	31,	32,	3,	36},
{14,	30,	36,	2,	25},
{14,	32,	34,	3,	0},
{14,	31,	35,	4,	6},
{15,	31,	35,	3,	10},
{14,	31,	35,	3,	33},
{14,	31,	39,	2,	0},
{13,	30,	30,	18,	6},
{13,	30,	30,	21,	3},
{13,	31,	34,	6,	3},
{17,	31,	34,	7,	1},
{15,	31,	34,	5,	6},
{15,	31,	33,	8,	0},
{13,	29,	33,	10,	37},
{13,	27,	33,	21,	4},
{13,	30,	37,	6,	0},
{15,	30,	37,	3,	6},
{15,	31,	36,	3,	11},
{13,	33,	34,	3,	3},
{13,	32,	32,	3,	36},
{13,	29,	37,	3,	22},
{13,	31,	37,	3,	6},
{12,	22,	39,	31,	33},
{16,	23,	25,	31,	22},
{15,	22,	24,	30,	36},
{14,	12,	39,	12,	34},
{14,	23,	27,	32,	2},
{14,	20,	33,	33,	0},
{14,	23,	25,	29,	29},
{14,	23,	25,	31,	28},
{15,	23,	23,	31,	34},
{15,	25,	23,	31,	30},
{14,	20,	39,	32,	0},
{13,	23,	31,	31,	0},
{13,	24,	27,	32,	2},
{12,	35,	27,	21,	31},
{16,	39,	27,	8,	22},
{15,	39,	24,	19,	33},
{15,	39,	26,	11,	34},
{14,	39,	25,	18,	32},
{14,	39,	27,	9,	22},
{14,	34,	27,	7,	35},
{13,	35,	27,	8,	32},
{13,	32,	25,	19,	34},
{13,	39,	26,	12,	32},
{12,	27,	39,	23,	32},
{17,	27,	37,	13,	33},
{16,	28,	27,	23,	24},
{14,	24,	39,	25,	25},
{15,	25,	39,	24,	17},
{14,	27,	36,	12,	36},
{16,	27,	36,	6,	39},
{15,	27,	36,	15,	35},
{14,	27,	35,	21,	33},
{14,	28,	38,	5,	20},
{15,	28,	39,	6,	3},
{14,	26,	39,	24,	8},
{14,	28,	39,	5,	17},
{14,	28,	39,	4,	28},
{13,	27,	27,	28,	31},
{15,	29,	27,	26,	2},
{13,	27,	28,	27,	31},
{13,	28,	33,	18,	17},
{13,	28,	30,	22,	6},
{14,	28,	30,	23,	0},
{13,	28,	39,	10,	0},
{13,	29,	27,	28,	2},
{13,	28,	28,	22,	13},
{13,	28,	39,	8,	1},
{14,	28,	36,	7,	9},
{13,	30,	37,	7,	0},
{13,	25,	39,	25,	7},
{13,	28,	37,	7,	8},
{13,	27,	39,	6,	33},
{13,	25,	39,	24,	25},
{13,	25,	39,	25,	23},
{13,	23,	39,	26,	19},
{13,	24,	39,	26,	12},
{12,	29,	32,	21,	39},
{14,	28,	33,	12,	37},
{14,	28,	34,	7,	39},
{14,	30,	30,	21,	4},
{13,	30,	33,	18,	0},
{14,	30,	32,	16,	1},
{13,	29,	35,	6,	39},
{16,	30,	35,	3,	39},
{13,	29,	34,	7,	39},
{13,	30,	30,	17,	7},
{13,	26,	33,	10,	39},
{13,	27,	34,	12,	37},
{12,	31,	31,	18,	39},
{15,	32,	26,	10,	39},
{14,	30,	32,	17,	2},
{13,	32,	26,	13,	39},
{13,	30,	31,	21,	1},
{13,	30,	32,	17,	8},
{13,	30,	29,	19,	36},
{13,	30,	31,	19,	2},
{12,	26,	36,	20,	39},
{16,	23,	37,	15,	38},
{15,	24,	38,	12,	38},
{15,	25,	37,	12,	38},
{13,	23,	36,	21,	38},
{13,	27,	33,	13,	39},
{13,	26,	38,	12,	38},
{13,	29,	33,	13,	37},
{13,	28,	33,	10,	39},
{12,	16,	35,	36,	26},
{18,	11,	36,	36,	0},
{15,	19,	24,	37,	0},
{14,	20,	16,	36,	33},
{14,	20,	23,	36,	2},
{13,	14,	26,	37,	2},
{13,	16,	36,	36,	1},
{12,	21,	28,	31,	38},
{15,	22,	28,	31,	34},
{15,	22,	24,	30,	38},
{15,	23,	27,	28,	38},
{14,	25,	28,	24,	38},
{13,	25,	23,	30,	37},
{13,	26,	23,	31,	32},
{15,	27,	23,	32,	6},
{13,	28,	24,	29,	29},
{14,	24,	24,	31,	28},
{13,	28,	25,	29,	25},
{14,	26,	25,	29,	28},
{13,	24,	25,	29,	34},
{13,	23,	26,	29,	33},
{13,	25,	29,	23,	38},
{13,	26,	23,	30,	35},
{13,	27,	24,	29,	33},
{13,	28,	24,	29,	31},
{13,	22,	28,	29,	35},
{12,	11,	36,	31,	36},
{14,	14,	34,	31,	34},
{16,	12,	35,	31,	35},
{14,	16,	32,	30,	34},
{13,	19,	32,	29,	36},
{14,	19,	35,	29,	35},
{14,	21,	29,	29,	36},
{13,	14,	30,	31,	36},
{12,	34,	28,	15,	31},
{14,	34,	28,	8,	34},
{14,	32,	28,	16,	1},
{13,	32,	30,	10,	27},
{13,	32,	30,	12,	0},
{12,	11,	25,	37,	33},
{16,	17,	20,	35,	33},
{16,	4,	19,	35,	35},
{15,	11,	26,	35,	28},
{15,	11,	26,	32,	31},
{15,	12,	25,	34,	32},
{15,	18,	22,	32,	33},
{15,	14,	23,	34,	33},
{14,	12,	26,	32,	33},
{14,	17,	18,	36,	33},
{14,	12,	26,	36,	27},
{14,	13,	24,	37,	19},
{14,	14,	20,	37,	26},
{14,	16,	20,	37,	20},
{13,	16,	25,	34,	32},
{16,	21,	21,	34,	33},
{14,	16,	25,	36,	27},
{13,	16,	23,	35,	33},
{13,	4,	21,	35,	34},
{13,	7,	26,	36,	28},
{13,	12,	25,	36,	32},
{12,	36,	28,	6,	37},
{14,	35,	29,	3,	17},
{14,	36,	29,	5,	6},
{15,	35,	29,	6,	4},
{14,	36,	29,	3,	17},
{14,	35,	27,	7,	35},
{14,	35,	29,	4,	13},
{14,	39,	29,	3,	0},
{13,	35,	28,	6,	39},
{13,	35,	27,	9,	35},
{13,	35,	28,	9,	0},
{13,	35,	29,	5,	13},
{12,	10,	37,	33,	31},
{14,	5,	27,	32,	33},
{14,	8,	26,	33,	32},
{13,	7,	36,	32,	32},
{13,	5,	29,	34,	27},
{13,	12,	32,	32,	28},
{13,	16,	26,	33,	31},
{12,	32,	32,	9,	32},
{16,	32,	34,	5,	0},
{15,	33,	32,	5,	0},
{14,	31,	32,	5,	35},
{13,	31,	32,	6,	36},
{14,	31,	32,	9,	34},
{13,	33,	34,	5,	0},
{13,	32,	30,	9,	33},
{12,	20,	31,	28,	38},
{15,	21,	29,	28,	38},
{14,	23,	30,	23,	38},
{13,	21,	31,	24,	38},
{12,	32,	25,	28,	26},
{17,	31,	26,	28,	0},
{15,	31,	27,	24,	2},
{13,	39,	23,	29,	24},
{13,	30,	26,	28,	7},
{13,	30,	23,	29,	30},
{13,	31,	26,	28,	2},
{13,	30,	24,	28,	27},
{12,	32,	25,	21,	39},
{14,	30,	26,	21,	39},
{14,	39,	24,	21,	33},
{13,	31,	26,	21,	39},
{13,	39,	24,	18,	36},
{12,	32,	29,	18,	26},
{13,	32,	29,	13,	31},
{12,	26,	22,	36,	33},
{16,	21,	23,	35,	16},
{16,	27,	23,	36,	0},
{16,	19,	23,	36,	19},
{18,	23,	23,	32,	26},
{15,	26,	20,	34,	36},
{15,	28,	21,	36,	2},
{14,	23,	24,	36,	1},
{14,	28,	22,	34,	1},
{13,	26,	22,	33,	34},
{14,	15,	22,	34,	34},
{13,	26,	23,	32,	25},
{13,	17,	29,	36,	6},
{16,	19,	25,	35,	8},
{13,	22,	16,	37,	28},
{15,	19,	19,	37,	20},
{14,	21,	14,	37,	34},
{13,	18,	21,	35,	34},
{13,	18,	19,	36,	35},
{13,	12,	20,	37,	34},
{13,	23,	14,	38,	28},
{13,	19,	23,	34,	26},
{13,	19,	18,	37,	28},
{13,	15,	22,	37,	26},
{13,	18,	22,	37,	17},
{13,	17,	25,	36,	15},
{13,	20,	25,	33,	11},
{13,	16,	25,	36,	29},
{13,	19,	21,	37,	20},
{13,	29,	22,	33,	1},
{12,	33,	30,	9,	33},
{12,	23,	32,	31,	32},
{15,	24,	24,	30,	35},
{13,	24,	28,	29,	24},
{15,	24,	26,	29,	33},
{13,	27,	26,	29,	25},
{13,	23,	33,	29,	17},
{13,	23,	27,	31,	34},
{13,	24,	25,	30,	34},
{13,	24,	27,	29,	34},
{13,	25,	27,	29,	29},
{14,	25,	28,	29,	2},
{13,	25,	31,	29,	1},
{13,	24,	29,	31,	1},
{13,	25,	27,	31,	1},
{13,	24,	29,	29,	7},
{12,	29,	28,	25,	24},
{15,	28,	27,	28,	4},
{16,	29,	27,	26,	7},
{15,	28,	28,	27,	4},
{14,	29,	28,	26,	4},
{12,	24,	39,	14,	37},
{16,	18,	39,	15,	34},
{14,	26,	39,	15,	33},
{14,	26,	39,	13,	35},
{14,	18,	39,	16,	34},
{13,	26,	39,	18,	33},
{14,	23,	39,	24,	33},
{13,	25,	39,	13,	36},
{13,	25,	39,	11,	37},
{12,	13,	22,	38,	31},
{14,	13,	20,	39,	8},
{14,	19,	17,	37,	34},
{14,	20,	16,	38,	28},
{14,	19,	19,	38,	20},
{15,	17,	20,	39,	8},
{13,	16,	22,	38,	17},
{13,	23,	17,	39,	6},
{13,	13,	23,	37,	33},
{12,	22,	37,	15,	39},
{16,	23,	37,	13,	39},
{12,	27,	29,	28,	29},
{16,	28,	29,	25,	0},
{13,	27,	29,	27,	31},
{12,	29,	26,	29,	27},
{14,	32,	24,	29,	4},
{13,	30,	25,	29,	6},
{12,	31,	35,	6,	26},
{13,	31,	33,	6,	36},
{14,	31,	35,	2,	37},
{13,	32,	33,	5,	22},
{13,	32,	33,	3,	36},
{13,	31,	35,	7,	1},
{12,	32,	28,	15,	37},
{13,	32,	27,	20,	34},
{13,	32,	26,	14,	38},
{13,	32,	26,	18,	35},
{12,	17,	29,	37,	4},
{14,	15,	26,	37,	8},
{12,	5,	38,	36,	7},
{16,	14,	38,	36,	0},
{13,	10,	36,	36,	7},
{12,	39,	25,	15,	39},
{12,	25,	39,	12,	38},
{13,	26,	39,	6,	38},
{12,	39,	27,	12,	31},
{13,	39,	27,	13,	0},
{12,	30,	30,	21,	26},
{13,	30,	30,	19,	27},
{12,	39,	24,	21,	39},
{12,	12,	13,	38,	36},
{15,	13,	16,	38,	33},
{13,	12,	15,	38,	35},
{12,	24,	38,	29,	9},
{16,	23,	39,	29,	9},
{13,	23,	34,	29,	14},
{12,	34,	29,	8,	23},
{12,	24,	35,	21,	39},
{13,	25,	33,	21,	39},
{12,	11,	30,	30,	37},
{12,	26,	39,	20,	34},
{12,	36,	28,	10,	2},
{15,	35,	28,	8,	4},
{13,	39,	28,	10,	0},
{12,	31,	23,	30,	27},
{14,	30,	22,	31,	15},
{13,	30,	23,	30,	29},
{12,	27,	25,	31,	29},
{15,	27,	24,	30,	32},
{13,	29,	25,	30,	6},
{15,	30,	24,	30,	6},
{13,	28,	24,	31,	9},
{14,	30,	23,	31,	9},
{13,	25,	24,	30,	36},
{13,	31,	24,	30,	6},
{13,	24,	25,	31,	34},
{13,	24,	24,	31,	36},
{13,	26,	24,	30,	35},
{12,	39,	25,	21,	35},
{13,	33,	26,	21,	32},
{12,	29,	28,	23,	32},
{14,	30,	24,	23,	31},
{13,	28,	26,	28,	28},
{14,	28,	26,	24,	32},
{12,	28,	33,	21,	15},
{12,	24,	38,	30,	3},
{14,	23,	34,	31,	5},
{16,	23,	33,	30,	14},
{14,	23,	39,	30,	3},
{13,	24,	30,	31,	2},
{12,	22,	38,	9,	39},
{12,	21,	27,	33,	18},
{16,	20,	26,	33,	21},
{15,	21,	28,	32,	12},
{14,	22,	27,	33,	6},
{14,	18,	29,	32,	18},
{13,	20,	29,	32,	6},
{13,	18,	29,	32,	26},
{12,	19,	27,	36,	15},
{17,	20,	30,	34,	0},
{14,	18,	28,	34,	8},
{14,	17,	29,	36,	12},
{14,	17,	31,	35,	12},
{14,	21,	28,	34,	0},
{14,	21,	26,	34,	9},
{13,	21,	26,	34,	17},
{15,	21,	25,	34,	19},
{14,	20,	25,	35,	15},
{13,	18,	25,	36,	19},
{13,	20,	24,	36,	16},
{13,	19,	26,	36,	17},
{13,	20,	27,	34,	10},
{13,	18,	26,	37,	5},
{13,	22,	25,	34,	7},
{13,	18,	25,	37,	8},
{13,	19,	29,	35,	0},
{12,	27,	29,	23,	38},
{18,	27,	35,	23,	33},
{14,	26,	27,	26,	38},
{14,	27,	30,	23,	35},
{12,	28,	29,	24,	25},
{14,	28,	30,	23,	7},
{12,	29,	29,	23,	32},
{14,	30,	29,	23,	0},
{12,	31,	33,	8,	24},
{14,	31,	34,	7,	22},
{13,	31,	35,	7,	4},
{12,	20,	30,	34,	10},
{14,	20,	30,	32,	16},
{14,	18,	29,	35,	12},
{13,	18,	39,	32,	15},
{13,	20,	28,	34,	12},
{13,	17,	38,	32,	18},
{13,	17,	33,	32,	25},
{12,	32,	30,	12,	20},
{13,	32,	30,	13,	5},
{12,	32,	31,	15,	2},
{12,	32,	31,	12,	21},
{15,	32,	31,	10,	27},
{12,	39,	22,	23,	39},
{14,	39,	19,	28,	39},
{14,	39,	19,	29,	38},
{12,	26,	23,	35,	19},
{14,	27,	23,	33,	10},
{12,	15,	22,	34,	36},
{15,	22,	22,	33,	36},
{12,	29,	28,	25,	30},
{14,	29,	24,	26,	31},
{13,	29,	26,	28,	28},
{12,	29,	36,	5,	38},
{14,	30,	37,	1,	38},
{12,	27,	31,	24,	29},
{14,	28,	30,	25,	0},
{12,	30,	29,	21,	37},
{13,	31,	27,	19,	37},
{12,	27,	28,	26,	37},
{13,	27,	29,	27,	32},
{13,	27,	27,	25,	38},
{13,	27,	29,	24,	36},
{12,	33,	29,	13,	3},
{15,	33,	29,	10,	7},
{13,	33,	29,	14,	0},
{12,	32,	32,	10,	15},
{13,	31,	33,	10,	0},
{13,	31,	33,	9,	15},
{12,	33,	29,	9,	37},
{15,	33,	30,	8,	34},
{12,	29,	33,	12,	39},
{12,	28,	27,	23,	37},
{16,	28,	24,	24,	38},
{14,	28,	26,	24,	35},
{12,	29,	25,	23,	39},
{15,	29,	26,	24,	33},
{15,	30,	23,	23,	38},
{14,	29,	23,	26,	36},
{13,	29,	27,	23,	34},
{12,	35,	28,	13,	4},
{13,	35,	28,	15,	0},
{12,	27,	27,	29,	20},
{15,	26,	30,	29,	0},
{13,	26,	27,	29,	25},
{12,	27,	34,	21,	35},
{13,	27,	34,	22,	34},
{12,	16,	38,	33,	27},
{14,	12,	37,	33,	28},
{13,	13,	37,	33,	28},
{12,	28,	39,	6,	28},
{13,	28,	39,	7,	6},
{12,	16,	27,	38,	0},
{12,	31,	27,	24,	6},
{13,	31,	26,	25,	4},
{12,	32,	37,	1,	34},
{13,	31,	36,	2,	35},
{13,	31,	39,	0,	30},
{13,	29,	39,	1,	36},
{13,	32,	39,	1,	14},
{13,	33,	39,	0,	17},
{12,	26,	20,	36,	35},
{13,	25,	20,	35,	36},
{13,	24,	14,	37,	36},
{13,	26,	16,	37,	21},
{12,	31,	33,	4,	39},
{12,	25,	36,	29,	2},
{12,	28,	39,	8,	8},
{12,	33,	26,	18,	35},
{13,	33,	26,	19,	34},
{13,	33,	26,	21,	33},
{12,	30,	22,	25,	38},
{14,	30,	22,	26,	37},
{13,	30,	23,	26,	35},
{12,	32,	30,	12,	28},
{12,	22,	30,	33,	4},
{16,	22,	36,	32,	0},
{13,	22,	32,	32,	4},
{14,	19,	31,	32,	16},
{14,	19,	33,	32,	10},
{14,	19,	37,	32,	3},
{12,	27,	25,	32,	10},
{14,	24,	24,	32,	16},
{13,	22,	25,	32,	20},
{14,	22,	27,	32,	12},
{12,	26,	29,	31,	0},
{13,	27,	26,	31,	4},
{13,	25,	27,	32,	2},
{12,	30,	23,	28,	35},
{14,	30,	22,	30,	34},
{13,	28,	22,	31,	35},
{12,	39,	22,	29,	34},
{12,	24,	25,	34,	8},
{15,	25,	24,	34,	8},
{15,	27,	24,	35,	0},
{14,	23,	26,	33,	7},
{13,	28,	24,	33,	2},
{14,	28,	25,	32,	2},
{13,	29,	23,	32,	9},
{13,	28,	23,	36,	1},
{13,	24,	25,	35,	0},
{14,	21,	26,	35,	4},
{12,	18,	31,	35,	11},
{13,	18,	30,	36,	7},
{13,	18,	29,	37,	4},
{12,	31,	36,	5,	6},
{12,	29,	33,	21,	0},
{12,	30,	33,	20,	0},
{12,	9,	29,	37,	5},
{12,	16,	32,	32,	30},
{14,	18,	29,	32,	28},
{12,	32,	28,	17,	31},
{12,	27,	32,	25,	1},
{12,	27,	31,	28,	2},
{13,	27,	30,	27,	3},
{12,	27,	31,	25,	25},
{12,	27,	30,	25,	36},
{12,	27,	30,	26,	35},
{12,	27,	31,	28,	16},
{12,	34,	26,	10,	38},
{12,	30,	27,	21,	38},
{12,	22,	22,	32,	37},
{12,	10,	29,	31,	37},
{12,	31,	32,	10,	33},
{12,	30,	27,	25,	6},
{12,	19,	35,	30,	34},
{12,	10,	26,	37,	12},
{12,	31,	23,	23,	39},
{12,	26,	39,	28,	0},
{12,	34,	31,	3,	32},
{12,	33,	25,	23,	0},
{12,	27,	33,	15,	39},
{12,	27,	34,	15,	38},
{12,	16,	26,	33,	33},
{12,	35,	29,	6,	10},
{12,	32,	30,	9,	36},
{12,	29,	36,	11,	0},
{12,	25,	28,	26,	38},
{12,	28,	24,	28,	35},
{16,	28,	25,	25,	36},
{13,	28,	24,	26,	38},
{13,	28,	23,	28,	38},
{14,	29,	22,	29,	36},
{14,	26,	24,	30,	36},
{13,	28,	22,	31,	36},
{12,	34,	26,	18,	32},
{12,	29,	28,	28,	1},
{13,	28,	28,	28,	5},
{12,	9,	28,	37,	6},
{12,	26,	21,	34,	36},
{12,	33,	32,	1,	39},
{12,	33,	32,	3,	33},
{12,	33,	32,	4,	27},
{12,	33,	33,	1,	38},
{12,	29,	37,	10,	0},
{12,	17,	29,	34,	26},
{12,	31,	34,	5,	33},
{12,	31,	26,	28,	6},
{12,	20,	27,	36,	7},
{13,	24,	25,	36,	0},
{12,	28,	26,	23,	39},
{12,	27,	39,	9,	34},
{13,	27,	39,	6,	35},
{12,	24,	31,	29,	13},
{12,	30,	24,	23,	36},
{12,	31,	32,	6,	37},
{13,	30,	35,	5,	37},
{12,	31,	36,	4,	37},
{13,	31,	39,	0,	38},
{12,	31,	34,	4,	39},
{12,	30,	35,	6,	39},
{13,	30,	33,	7,	38},
{12,	31,	33,	6,	38},
{12,	34,	28,	9,	34},
{12,	9,	21,	35,	36},
{12,	34,	26,	14,	34},
{12,	39,	26,	15,	33},
{12,	28,	29,	28,	0},
{12,	29,	29,	25,	0},
{12,	16,	21,	39,	7},
{12,	18,	31,	33,	17},
{12,	30,	23,	30,	32},
{12,	39,	22,	25,	36},
{12,	27,	31,	25,	30},
{12,	31,	34,	5,	38},
{12,	31,	33,	11,	0},
{12,	32,	33,	4,	35},
{13,	32,	31,	4,	39},
{12,	32,	31,	9,	34},
{13,	32,	32,	5,	36},
{14,	32,	32,	6,	34},
{13,	32,	32,	8,	33},
{12,	19,	29,	35,	10},
{12,	21,	35,	33,	0},
{12,	31,	27,	25,	2},
{12,	7,	29,	37,	6},
{12,	39,	15,	37,	34},
{12,	28,	26,	25,	34},
{12,	30,	24,	25,	32},
{12,	30,	25,	24,	30},
{14,	30,	26,	22,	29},
{12,	20,	27,	32,	25},
{12,	19,	31,	32,	25},
{12,	5,	27,	35,	27},
{12,	27,	28,	24,	38},
{12,	28,	37,	5,	32},
{12,	28,	39,	3,	37},
{12,	33,	36,	0,	30},
{12,	14,	24,	37,	22},
{12,	23,	34,	31,	7},
{12,	25,	37,	29,	1},
{12,	20,	39,	32,	1},
{12,	29,	27,	26,	9},
{13,	28,	28,	26,	8},
{12,	39,	18,	32,	37},
{12,	27,	31,	24,	33},
{12,	39,	26,	10,	36},
{12,	39,	26,	12,	35},
{12,	32,	26,	15,	38},
{12,	39,	27,	1,	39},
{12,	15,	17,	37,	35},
{12,	15,	22,	38,	26},
{12,	17,	32,	34,	14},
{13,	17,	33,	33,	18},
{12,	18,	36,	33,	11},
{13,	17,	39,	33,	11},
{12,	17,	35,	35,	1},
{12,	23,	25,	32,	16},
{12,	29,	24,	31,	9},
{12,	28,	25,	30,	10},
{12,	21,	30,	33,	6},
{12,	21,	29,	32,	20},
{12,	19,	34,	33,	2},
{12,	30,	26,	29,	0},
{12,	21,	27,	36,	1},
{12,	37,	31,	0,	3},
{12,	39,	11,	38,	36},
{12,	39,	19,	32,	28},
{13,	27,	19,	33,	34},
{12,	28,	23,	25,	39},
{12,	30,	38,	1,	38},
{12,	19,	32,	33,	9},
{12,	24,	17,	38,	11},
{12,	22,	33,	33,	0},
{12,	30,	32,	16,	10},
{12,	29,	22,	36,	0},
{12,	23,	27,	33,	3},
{12,	19,	28,	37,	0},
{12,	32,	36,	2,	0},
{11,	30,	39,	31,	33},
{18,	29,	33,	19,	34},
{16,	31,	37,	5,	6},
{15,	29,	36,	6,	36},
{15,	29,	37,	7,	34},
{16,	28,	36,	9,	36},
{14,	27,	24,	31,	36},
{14,	30,	27,	23,	34},
{14,	28,	26,	28,	34},
{14,	31,	27,	27,	0},
{13,	27,	34,	26,	34},
{13,	31,	36,	6,	7},
{13,	28,	24,	31,	35},
{13,	28,	37,	12,	34},
{14,	27,	39,	14,	34},
{13,	30,	24,	26,	34},
{13,	31,	36,	7,	2},
{13,	28,	37,	7,	35},
{13,	30,	37,	3,	37},
{13,	30,	38,	3,	36},
{13,	28,	33,	18,	35},
{13,	29,	36,	8,	36},
{12,	28,	32,	32,	2},
{16,	26,	34,	32,	0},
{13,	25,	32,	32,	3},
{12,	28,	27,	31,	34},
{14,	27,	29,	27,	35},
{12,	26,	27,	31,	35},
{15,	28,	25,	31,	35},
{13,	24,	26,	29,	36},
{12,	24,	33,	29,	34},
{12,	27,	32,	26,	35},
{12,	24,	27,	32,	11},
{12,	29,	24,	25,	38},
{12,	31,	23,	31,	24},
{12,	29,	36,	7,	37},
{12,	30,	26,	23,	35},
{12,	29,	24,	29,	35},
{12,	30,	25,	29,	34},
{12,	29,	34,	18,	34},
{13,	28,	34,	19,	34},
{12,	32,	24,	31,	0},
{12,	27,	31,	25,	36},
{12,	31,	27,	28,	1},
{12,	30,	32,	18,	34},
{12,	32,	24,	30,	2},
{12,	27,	26,	31,	35},
{12,	24,	28,	31,	34},
{12,	27,	23,	29,	37},
{12,	30,	25,	23,	36},
{12,	29,	38,	7,	34},
{12,	31,	36,	5,	12},
{11,	33,	33,	23,	32},
{15,	33,	31,	5,	35},
{14,	31,	31,	20,	33},
{14,	31,	26,	25,	9},
{14,	31,	28,	20,	34},
{13,	35,	27,	10,	35},
{15,	34,	28,	10,	34},
{14,	33,	27,	11,	35},
{13,	32,	29,	15,	33},
{13,	32,	24,	28,	27},
{15,	32,	25,	24,	29},
{13,	39,	23,	23,	35},
{13,	34,	26,	22,	0},
{13,	39,	23,	26,	29},
{13,	31,	31,	21,	33},
{13,	32,	24,	28,	28},
{13,	32,	31,	11,	33},
{13,	33,	31,	4,	36},
{13,	32,	26,	24,	1},
{13,	39,	25,	22,	4},
{12,	32,	29,	15,	37},
{14,	33,	30,	10,	34},
{12,	33,	29,	15,	34},
{13,	33,	27,	13,	35},
{12,	32,	31,	12,	35},
{14,	32,	30,	15,	33},
{12,	34,	28,	18,	3},
{14,	34,	28,	16,	6},
{12,	33,	27,	15,	36},
{13,	33,	28,	10,	36},
{12,	34,	28,	14,	33},
{14,	35,	27,	12,	32},
{12,	35,	28,	18,	0},
{12,	32,	30,	12,	36},
{12,	33,	31,	10,	33},
{12,	32,	25,	28,	28},
{12,	33,	32,	6,	33},
{11,	18,	39,	39,	11},
{16,	18,	38,	34,	12},
{14,	18,	24,	37,	19},
{14,	18,	21,	39,	12},
{14,	18,	32,	36,	12},
{14,	19,	23,	39,	4},
{13,	15,	20,	39,	19},
{15,	1,	18,	39,	22},
{12,	7,	24,	39,	13},
{12,	21,	33,	34,	0},
{12,	19,	34,	35,	2},
{12,	15,	25,	37,	26},
{12,	18,	18,	39,	20},
{13,	19,	19,	39,	17},
{13,	39,	12,	39,	20},
{12,	24,	16,	39,	13},
{12,	16,	24,	39,	12},
{12,	18,	38,	35,	12},
{12,	19,	22,	38,	13},
{11,	25,	39,	34,	30},
{16,	28,	28,	33,	0},
{16,	22,	25,	33,	31},
{16,	26,	24,	32,	30},
{14,	22,	25,	33,	32},
{15,	20,	26,	32,	33},
{13,	17,	32,	36,	19},
{14,	18,	33,	35,	14},
{13,	27,	26,	32,	10},
{13,	19,	37,	35,	0},
{13,	26,	29,	32,	4},
{13,	25,	26,	35,	0},
{13,	19,	28,	32,	31},
{13,	24,	23,	35,	23},
{13,	26,	27,	33,	2},
{12,	10,	26,	36,	33},
{12,	19,	39,	35,	9},
{12,	10,	27,	35,	31},
{12,	21,	39,	35,	0},
{13,	20,	39,	35,	2},
{13,	21,	32,	35,	2},
{12,	25,	33,	35,	1},
{15,	23,	38,	35,	0},
{14,	24,	28,	35,	2},
{12,	22,	30,	35,	9},
{15,	21,	26,	35,	17},
{14,	21,	25,	36,	9},
{13,	23,	26,	36,	2},
{12,	23,	29,	36,	1},
{13,	21,	28,	36,	5},
{12,	19,	38,	36,	9},
{14,	22,	34,	36,	0},
{14,	19,	33,	36,	11},
{13,	22,	38,	36,	0},
{13,	19,	39,	36,	7},
{12,	21,	30,	35,	14},
{12,	22,	30,	35,	13},
{12,	23,	30,	35,	11},
{13,	25,	31,	35,	2},
{13,	25,	24,	36,	3},
{13,	25,	25,	35,	7},
{12,	23,	28,	35,	14},
{12,	21,	28,	36,	11},
{12,	21,	25,	33,	33},
{12,	17,	29,	33,	31},
{12,	13,	37,	33,	31},
{12,	17,	37,	32,	31},
{12,	14,	26,	35,	32},
{12,	26,	30,	33,	0},
{12,	26,	29,	34,	1},
{13,	26,	27,	35,	0},
{12,	26,	26,	34,	10},
{13,	26,	29,	34,	4},
{13,	27,	25,	33,	8},
{12,	28,	27,	34,	0},
{13,	28,	25,	35,	0},
{12,	28,	25,	34,	2},
{12,	26,	24,	35,	9},
{12,	25,	34,	35,	0},
{11,	23,	29,	32,	39},
{18,	24,	21,	32,	39},
{17,	20,	30,	31,	35},
{16,	15,	35,	32,	32},
{15,	26,	20,	30,	39},
{15,	26,	24,	32,	34},
{15,	24,	25,	30,	37},
{14,	21,	23,	33,	36},
{13,	28,	27,	23,	39},
{16,	25,	29,	23,	39},
{13,	24,	29,	29,	37},
{13,	25,	28,	28,	38},
{13,	23,	31,	32,	31},
{13,	26,	29,	24,	38},
{13,	20,	35,	30,	34},
{13,	25,	21,	32,	38},
{13,	26,	18,	32,	39},
{12,	39,	15,	33,	38},
{12,	21,	30,	32,	33},
{12,	22,	35,	32,	31},
{12,	25,	26,	32,	34},
{12,	27,	23,	29,	38},
{13,	26,	22,	29,	39},
{12,	26,	27,	28,	38},
{12,	25,	23,	32,	36},
{13,	24,	27,	32,	35},
{13,	25,	27,	33,	31},
{12,	19,	33,	31,	34},
{12,	23,	31,	30,	34},
{12,	22,	33,	31,	34},
{12,	24,	25,	31,	37},
{12,	25,	23,	31,	38},
{11,	27,	38,	28,	38},
{15,	27,	39,	20,	34},
{14,	27,	39,	13,	35},
{14,	27,	39,	6,	38},
{13,	28,	36,	8,	38},
{14,	29,	36,	7,	38},
{13,	29,	33,	17,	36},
{13,	27,	33,	18,	39},
{13,	29,	37,	4,	38},
{14,	29,	39,	5,	35},
{13,	28,	34,	16,	36},
{12,	28,	35,	10,	39},
{13,	27,	35,	11,	39},
{13,	27,	36,	8,	39},
{12,	28,	33,	21,	36},
{12,	28,	37,	18,	34},
{12,	27,	37,	6,	39},
{12,	28,	36,	16,	35},
{12,	27,	35,	13,	39},
{11,	31,	36,	20,	34},
{16,	29,	37,	15,	34},
{14,	31,	35,	5,	37},
{13,	30,	31,	21,	34},
{12,	31,	32,	16,	35},
{14,	31,	33,	9,	35},
{12,	31,	36,	8,	35},
{13,	31,	34,	6,	37},
{14,	31,	34,	7,	36},
{13,	31,	35,	7,	36},
{12,	29,	36,	10,	36},
{12,	32,	32,	7,	35},
{12,	28,	36,	21,	34},
{12,	31,	33,	21,	33},
{11,	20,	17,	39,	38},
{16,	22,	15,	39,	36},
{14,	9,	19,	38,	33},
{13,	25,	17,	37,	23},
{13,	24,	15,	34,	38},
{13,	24,	14,	35,	38},
{12,	24,	21,	37,	19},
{13,	25,	20,	37,	20},
{13,	23,	19,	38,	11},
{12,	25,	19,	38,	7},
{12,	39,	17,	33,	37},
{13,	24,	17,	34,	38},
{12,	24,	18,	39,	8},
{12,	23,	15,	39,	32},
{12,	14,	20,	38,	32},
{12,	16,	24,	37,	27},
{11,	34,	30,	20,	30},
{18,	34,	29,	15,	31},
{14,	34,	28,	21,	6},
{13,	34,	29,	21,	0},
{13,	34,	32,	4,	0},
{12,	34,	29,	7,	33},
{11,	27,	39,	31,	35},
{16,	24,	29,	30,	36},
{15,	24,	30,	29,	36},
{13,	13,	39,	15,	36},
{13,	14,	32,	30,	36},
{13,	12,	36,	29,	36},
{12,	25,	39,	18,	36},
{12,	26,	30,	29,	36},
{13,	25,	29,	30,	36},
{12,	25,	25,	31,	37},
{13,	25,	29,	29,	37},
{11,	39,	27,	15,	39},
{15,	34,	28,	13,	34},
{13,	34,	27,	18,	32},
{12,	32,	27,	18,	38},
{12,	33,	28,	12,	37},
{11,	29,	33,	23,	39},
{15,	30,	28,	22,	35},
{13,	28,	33,	24,	35},
{15,	28,	28,	25,	35},
{14,	28,	33,	25,	34},
{13,	28,	34,	24,	34},
{12,	30,	30,	23,	35},
{12,	28,	29,	25,	36},
{13,	29,	26,	24,	36},
{13,	29,	27,	27,	34},
{12,	28,	27,	26,	37},
{14,	28,	26,	25,	38},
{13,	29,	27,	24,	37},
{12,	28,	29,	29,	34},
{12,	30,	29,	24,	34},
{12,	30,	27,	23,	36},
{12,	30,	30,	20,	36},
{12,	30,	26,	28,	34},
{12,	30,	31,	23,	34},
{12,	30,	33,	21,	34},
{12,	26,	34,	21,	39},
{12,	28,	28,	26,	36},
{11,	21,	32,	34,	35},
{16,	22,	26,	34,	35},
{15,	9,	27,	35,	33},
{14,	23,	26,	33,	35},
{14,	22,	27,	34,	35},
{13,	9,	27,	35,	34},
{15,	9,	23,	35,	35},
{13,	20,	34,	33,	31},
{13,	15,	26,	35,	33},
{12,	21,	35,	34,	31},
{12,	12,	25,	37,	34},
{14,	9,	23,	36,	35},
{12,	21,	23,	35,	34},
{12,	17,	31,	35,	26},
{13,	18,	24,	36,	30},
{14,	18,	25,	36,	28},
{14,	18,	26,	36,	26},
{12,	0,	25,	35,	35},
{12,	23,	26,	34,	35},
{14,	25,	27,	34,	31},
{12,	9,	26,	36,	34},
{12,	17,	36,	32,	32},
{11,	36,	28,	12,	34},
{12,	35,	28,	13,	18},
{11,	29,	26,	36,	21},
{18,	39,	18,	35,	32},
{16,	27,	21,	36,	27},
{14,	29,	29,	32,	1},
{14,	24,	26,	36,	22},
{14,	26,	25,	33,	26},
{14,	30,	21,	32,	19},
{13,	28,	19,	34,	33},
{14,	29,	20,	33,	28},
{13,	20,	24,	35,	32},
{13,	27,	23,	32,	29},
{13,	28,	20,	34,	33},
{12,	30,	23,	34,	11},
{12,	39,	23,	33,	10},
{12,	24,	30,	35,	11},
{12,	28,	25,	32,	29},
{14,	29,	22,	35,	23},
{13,	30,	22,	32,	24},
{12,	22,	29,	36,	12},
{12,	20,	28,	36,	20},
{16,	20,	30,	35,	19},
{13,	18,	33,	35,	17},
{12,	19,	28,	36,	26},
{14,	18,	31,	35,	26},
{12,	28,	28,	33,	2},
{12,	39,	20,	34,	28},
{12,	30,	24,	32,	17},
{12,	29,	21,	35,	27},
{12,	39,	22,	34,	6},
{12,	25,	25,	35,	23},
{12,	23,	29,	36,	5},
{12,	22,	30,	36,	4},
{12,	29,	25,	32,	25},
{12,	18,	29,	36,	26},
{12,	29,	27,	33,	1},
{11,	35,	33,	4,	35},
{15,	36,	29,	2,	28},
{13,	34,	33,	5,	2},
{13,	35,	34,	1,	3},
{13,	35,	35,	0,	21},
{14,	36,	35,	0,	1},
{13,	34,	38,	0,	10},
{13,	34,	34,	0,	30},
{13,	35,	30,	5,	0},
{12,	34,	31,	10,	0},
{14,	34,	31,	7,	1},
{12,	35,	30,	5,	15},
{12,	36,	29,	3,	29},
{12,	34,	34,	1,	30},
{14,	33,	37,	1,	7},
{13,	35,	35,	1,	6},
{12,	36,	33,	1,	9},
{14,	36,	32,	0,	23},
{13,	36,	34,	0,	13},
{12,	34,	33,	0,	39},
{14,	35,	32,	0,	37},
{13,	36,	31,	1,	36},
{13,	35,	32,	1,	37},
{12,	36,	29,	4,	17},
{13,	36,	29,	5,	9},
{12,	36,	32,	0,	36},
{12,	35,	35,	0,	27},
{12,	35,	34,	1,	26},
{12,	36,	38,	0,	1},
{11,	15,	29,	39,	18},
{15,	7,	22,	39,	20},
{13,	16,	27,	39,	13},
{13,	18,	27,	38,	13},
{12,	2,	26,	37,	23},
{13,	15,	26,	37,	21},
{11,	33,	34,	9,	26},
{14,	32,	34,	10,	4},
{13,	32,	35,	6,	4},
{16,	32,	35,	3,	15},
{13,	32,	36,	6,	0},
{13,	33,	35,	3,	3},
{13,	33,	34,	5,	27},
{12,	32,	37,	5,	3},
{12,	32,	36,	5,	6},
{12,	32,	35,	2,	24},
{12,	32,	36,	6,	2},
{12,	32,	38,	2,	4},
{12,	31,	39,	3,	4},
{11,	21,	37,	34,	33},
{11,	10,	31,	36,	32},
{15,	12,	30,	35,	31},
{13,	6,	27,	36,	34},
{13,	15,	30,	35,	28},
{11,	28,	32,	32,	28},
{15,	26,	30,	32,	30},
{14,	26,	33,	32,	8},
{13,	26,	29,	34,	5},
{12,	26,	28,	32,	32},
{11,	39,	27,	21,	33},
{13,	34,	26,	17,	34},
{11,	11,	38,	36,	26},
{12,	14,	36,	36,	25},
{11,	32,	32,	9,	39},
{15,	32,	30,	11,	37},
{14,	32,	31,	12,	36},
{13,	30,	32,	12,	39},
{13,	31,	34,	9,	36},
{13,	31,	32,	12,	37},
{13,	30,	33,	9,	37},
{12,	30,	33,	11,	39},
{15,	30,	33,	12,	38},
{13,	31,	33,	8,	38},
{12,	32,	34,	3,	39},
{12,	31,	33,	13,	36},
{12,	31,	34,	7,	38},
{11,	32,	27,	26,	29},
{16,	31,	26,	27,	23},
{14,	31,	26,	28,	23},
{13,	32,	26,	28,	3},
{13,	31,	25,	26,	30},
{13,	31,	24,	28,	30},
{13,	32,	24,	25,	30},
{13,	31,	25,	25,	31},
{12,	32,	26,	29,	0},
{11,	33,	25,	29,	25},
{15,	39,	24,	25,	29},
{14,	39,	23,	29,	29},
{13,	31,	27,	29,	1},
{13,	32,	24,	30,	9},
{12,	31,	23,	29,	32},
{12,	31,	25,	29,	28},
{11,	39,	25,	21,	39},
{12,	33,	26,	18,	36},
{11,	34,	33,	6,	28},
{15,	34,	31,	6,	30},
{11,	23,	21,	36,	38},
{13,	15,	23,	36,	35},
{13,	13,	25,	37,	34},
{12,	25,	20,	34,	37},
{13,	39,	16,	34,	38},
{11,	36,	28,	20,	2},
{15,	35,	28,	21,	2},
{12,	39,	28,	16,	0},
{11,	20,	30,	32,	38},
{13,	17,	32,	30,	36},
{11,	14,	33,	31,	37},
{11,	5,	30,	34,	36},
{15,	19,	25,	33,	36},
{12,	19,	27,	33,	36},
{12,	20,	24,	34,	36},
{11,	31,	38,	20,	1},
{15,	31,	37,	11,	2},
{15,	31,	38,	6,	4},
{12,	31,	37,	14,	2},
{12,	31,	37,	6,	7},
{13,	32,	37,	4,	7},
{11,	27,	33,	35,	2},
{14,	26,	34,	34,	0},
{12,	26,	31,	36,	0},
{14,	23,	38,	36,	0},
{13,	24,	34,	36,	0},
{12,	26,	36,	34,	0},
{14,	27,	35,	32,	0},
{12,	26,	31,	34,	5},
{12,	26,	35,	32,	1},
{11,	20,	36,	34,	34},
{12,	21,	36,	33,	34},
{11,	32,	29,	18,	38},
{12,	32,	29,	12,	39},
{11,	6,	33,	38,	14},
{15,	10,	32,	38,	13},
{12,	6,	30,	37,	16},
{14,	6,	30,	38,	15},
{12,	18,	30,	37,	12},
{12,	18,	29,	39,	12},
{11,	28,	34,	21,	39},
{14,	28,	35,	20,	35},
{13,	28,	35,	21,	36},
{13,	27,	35,	15,	39},
{11,	32,	30,	25,	3},
{12,	32,	31,	25,	0},
{13,	31,	32,	24,	0},
{11,	23,	38,	36,	4},
{16,	20,	39,	36,	5},
{15,	20,	39,	36,	6},
{13,	20,	38,	36,	7},
{14,	20,	37,	35,	9},
{12,	22,	39,	35,	4},
{12,	20,	38,	36,	8},
{13,	22,	30,	36,	12},
{13,	20,	34,	36,	10},
{12,	19,	37,	36,	11},
{11,	27,	29,	28,	39},
{11,	15,	21,	38,	37},
{14,	18,	20,	37,	35},
{13,	15,	22,	37,	35},
{12,	24,	18,	37,	33},
{12,	19,	18,	38,	34},
{11,	16,	33,	29,	38},
{11,	29,	35,	15,	38},
{13,	30,	34,	8,	38},
{14,	30,	34,	10,	37},
{13,	30,	35,	8,	37},
{12,	29,	36,	9,	38},
{12,	28,	35,	16,	38},
{11,	30,	33,	21,	36},
{12,	30,	35,	18,	35},
{12,	31,	32,	17,	36},
{12,	29,	35,	19,	35},
{11,	39,	25,	25,	26},
{14,	39,	25,	23,	32},
{13,	34,	26,	23,	0},
{11,	30,	26,	25,	38},
{15,	30,	27,	25,	36},
{14,	30,	27,	23,	37},
{12,	30,	26,	26,	35},
{13,	30,	25,	28,	35},
{11,	27,	30,	25,	39},
{11,	22,	25,	39,	8},
{14,	24,	23,	39,	1},
{14,	21,	23,	37,	20},
{13,	23,	25,	37,	5},
{12,	21,	22,	38,	13},
{12,	24,	20,	38,	13},
{12,	24,	23,	38,	5},
{13,	24,	24,	38,	4},
{12,	24,	25,	37,	5},
{12,	24,	26,	37,	0},
{11,	30,	37,	6,	39},
{13,	29,	37,	7,	38},
{12,	30,	37,	18,	34},
{12,	29,	37,	8,	38},
{12,	28,	39,	5,	38},
{12,	28,	36,	8,	39},
{12,	30,	38,	4,	37},
{11,	12,	34,	31,	37},
{11,	31,	28,	25,	31},
{13,	32,	29,	25,	4},
{13,	32,	27,	25,	30},
{12,	31,	29,	24,	8},
{12,	31,	26,	26,	31},
{11,	39,	28,	23,	0},
{11,	23,	39,	15,	38},
{11,	20,	34,	37,	11},
{15,	19,	31,	37,	12},
{14,	20,	36,	37,	1},
{13,	21,	24,	37,	17},
{13,	21,	24,	38,	13},
{12,	20,	31,	36,	20},
{15,	19,	32,	36,	19},
{12,	21,	28,	37,	2},
{12,	20,	24,	39,	13},
{11,	8,	32,	32,	37},
{13,	15,	32,	32,	36},
{11,	32,	30,	23,	33},
{13,	31,	32,	22,	33},
{11,	11,	37,	31,	36},
{11,	32,	36,	5,	24},
{11,	30,	22,	28,	39},
{14,	39,	20,	29,	38},
{13,	28,	22,	29,	38},
{13,	39,	21,	28,	39},
{12,	29,	20,	30,	38},
{12,	28,	23,	28,	39},
{11,	28,	39,	26,	34},
{12,	29,	39,	9,	34},
{11,	35,	30,	6,	18},
{11,	39,	23,	29,	35},
{12,	39,	22,	26,	37},
{11,	31,	24,	31,	34},
{12,	39,	23,	31,	29},
{12,	39,	24,	24,	33},
{12,	31,	26,	25,	32},
{12,	31,	23,	30,	35},
{11,	31,	27,	23,	37},
{13,	31,	25,	24,	35},
{12,	31,	27,	24,	33},
{11,	22,	23,	34,	37},
{11,	6,	32,	35,	32},
{11,	30,	29,	26,	35},
{11,	29,	35,	21,	36},
{14,	30,	34,	18,	36},
{13,	30,	36,	21,	34},
{11,	32,	36,	4,	36},
{13,	32,	34,	4,	37},
{11,	32,	37,	4,	35},
{12,	31,	37,	6,	14},
{11,	34,	28,	12,	36},
{12,	34,	29,	7,	35},
{11,	35,	30,	4,	37},
{13,	34,	31,	4,	36},
{11,	31,	29,	25,	18},
{11,	24,	28,	34,	34},
{14,	23,	29,	34,	33},
{13,	25,	25,	34,	33},
{11,	21,	37,	33,	34},
{11,	29,	39,	21,	34},
{11,	29,	20,	31,	39},
{11,	33,	35,	3,	28},
{13,	34,	35,	1,	22},
{12,	33,	37,	1,	19},
{11,	33,	35,	6,	15},
{13,	33,	36,	4,	6},
{13,	32,	35,	6,	24},
{11,	35,	35,	1,	35},
{13,	34,	34,	0,	39},
{12,	34,	37,	0,	35},
{12,	33,	35,	3,	33},
{12,	33,	34,	4,	34},
{11,	32,	36,	9,	0},
{12,	32,	35,	10,	0},
{11,	6,	21,	39,	27},
{14,	19,	18,	39,	30},
{12,	6,	22,	39,	22},
{11,	32,	29,	24,	19},
{11,	34,	29,	11,	34},
{11,	29,	29,	32,	12},
{11,	13,	23,	36,	36},
{11,	31,	31,	24,	10},
{11,	28,	29,	35,	1},
{11,	22,	26,	36,	27},
{12,	22,	26,	35,	28},
{12,	22,	24,	35,	34},
{12,	16,	30,	35,	28},
{11,	29,	36,	12,	37},
{12,	28,	36,	11,	38},
{11,	28,	36,	21,	36},
{11,	32,	30,	15,	36},
{11,	33,	26,	25,	12},
{12,	34,	26,	26,	0},
{11,	31,	37,	6,	34},
{11,	15,	24,	39,	20},
{12,	12,	19,	39,	30},
{11,	26,	33,	32,	30},
{11,	32,	31,	21,	33},
{11,	31,	27,	25,	35},
{11,	30,	30,	23,	36},
{11,	35,	28,	12,	35},
{11,	25,	29,	30,	37},
{11,	31,	27,	21,	38},
{11,	29,	32,	32,	1},
{11,	36,	34,	0,	35},
{11,	33,	31,	4,	39},
{11,	27,	35,	20,	39},
{11,	10,	28,	36,	33},
{11,	4,	28,	36,	34},
{11,	32,	31,	15,	35},
{11,	37,	31,	3,	0},
{13,	36,	31,	4,	0},
{13,	36,	30,	3,	3},
{12,	36,	30,	3,	5},
{11,	32,	27,	25,	32},
{11,	24,	32,	29,	36},
{11,	24,	31,	29,	37},
{13,	23,	30,	29,	38},
{11,	36,	30,	2,	29},
{11,	29,	29,	33,	2},
{11,	29,	28,	33,	5},
{11,	28,	27,	33,	20},
{13,	26,	30,	34,	6},
{11,	27,	28,	33,	16},
{12,	26,	29,	34,	7},
{11,	27,	24,	32,	36},
{14,	28,	24,	32,	34},
{12,	28,	21,	33,	34},
{11,	20,	28,	38,	7},
{13,	21,	26,	38,	9},
{13,	22,	26,	38,	6},
{12,	19,	26,	39,	12},
{11,	39,	22,	25,	39},
{11,	22,	22,	33,	38},
{11,	33,	36,	6,	1},
{11,	28,	27,	32,	31},
{12,	28,	29,	32,	29},
{11,	33,	32,	6,	35},
{11,	36,	30,	3,	16},
{11,	30,	39,	12,	34},
{11,	30,	23,	33,	23},
{11,	30,	24,	32,	32},
{13,	29,	20,	34,	33},
{12,	29,	26,	32,	26},
{11,	28,	36,	16,	37},
{11,	30,	34,	8,	39},
{11,	33,	31,	10,	34},
{11,	34,	31,	2,	39},
{12,	34,	30,	4,	39},
{11,	28,	31,	33,	1},
{11,	28,	32,	34,	0},
{11,	31,	33,	15,	36},
{11,	25,	33,	35,	3},
{13,	25,	27,	35,	12},
{12,	27,	27,	35,	4},
{11,	28,	37,	10,	37},
{11,	15,	25,	39,	19},
{11,	15,	26,	38,	21},
{11,	36,	28,	13,	6},
{11,	29,	37,	9,	38},
{11,	34,	26,	20,	34},
{11,	22,	39,	36,	3},
{11,	32,	26,	29,	4},
{12,	32,	26,	27,	14},
{11,	39,	25,	29,	0},
{11,	28,	21,	31,	39},
{11,	27,	23,	31,	38},
{14,	27,	24,	31,	37},
{13,	27,	22,	30,	39},
{11,	32,	28,	24,	29},
{11,	30,	24,	33,	20},
{13,	30,	24,	34,	4},
{11,	14,	26,	36,	34},
{13,	16,	28,	36,	28},
{12,	11,	31,	36,	31},
{11,	36,	31,	3,	5},
{11,	36,	31,	2,	25},
{11,	36,	31,	3,	16},
{11,	34,	26,	16,	36},
{11,	24,	27,	35,	17},
{12,	23,	28,	35,	17},
{12,	21,	30,	35,	18},
{11,	21,	29,	35,	26},
{13,	22,	27,	36,	19},
{12,	19,	32,	35,	22},
{12,	21,	30,	35,	23},
{11,	39,	23,	34,	1},
{11,	31,	32,	25,	0},
{11,	30,	37,	21,	34},
{11,	30,	29,	27,	34},
{11,	23,	30,	32,	35},
{13,	22,	30,	34,	33},
{11,	22,	28,	36,	19},
{12,	22,	30,	36,	14},
{11,	32,	30,	25,	4},
{11,	23,	26,	39,	0},
{12,	20,	26,	39,	11},
{11,	21,	28,	39,	1},
{12,	20,	28,	39,	6},
{11,	26,	24,	33,	34},
{11,	29,	37,	12,	35},
{11,	31,	32,	13,	37},
{11,	31,	33,	6,	39},
{11,	33,	37,	0,	38},
{11,	31,	23,	32,	20},
{11,	20,	32,	30,	36},
{11,	20,	31,	30,	37},
{11,	30,	35,	10,	37},
{11,	26,	39,	32,	0},
{11,	29,	27,	35,	0},
{11,	32,	31,	24,	3},
{11,	32,	38,	2,	14},
{11,	31,	38,	6,	33},
{13,	32,	38,	4,	7},
{12,	31,	39,	2,	25},
{12,	32,	38,	4,	14},
{11,	32,	39,	5,	22},
{12,	32,	39,	3,	25},
{12,	32,	38,	4,	32},
{11,	33,	39,	0,	38},
{11,	32,	39,	3,	35},
{11,	32,	38,	1,	38},
{11,	36,	30,	5,	1},
{11,	30,	35,	16,	36},
{11,	32,	26,	25,	33},
{11,	30,	38,	14,	34},
{11,	26,	23,	34,	31},
{11,	16,	31,	36,	27},
{11,	33,	30,	12,	33},
{11,	20,	19,	39,	23},
{12,	15,	19,	39,	31},
{11,	6,	20,	39,	31},
{11,	33,	35,	4,	22},
{11,	31,	31,	25,	1},
{11,	26,	25,	32,	35},
{11,	26,	27,	33,	24},
{11,	31,	36,	6,	36},
{11,	19,	30,	36,	23},
{11,	29,	38,	1,	39},
{11,	34,	33,	1,	38},
{11,	15,	23,	39,	21},
{11,	27,	36,	32,	0},
{11,	39,	17,	36,	35},
{11,	39,	19,	36,	34},
{12,	28,	20,	36,	33},
{11,	29,	22,	35,	33},
{14,	28,	22,	36,	32},
{14,	27,	21,	34,	36},
{11,	39,	20,	36,	32},
{11,	30,	25,	31,	34},
{11,	27,	22,	32,	37},
{12,	26,	21,	34,	37},
{11,	26,	23,	32,	38},
{12,	27,	24,	32,	37},
{11,	31,	28,	25,	32},
{11,	32,	24,	25,	34},
{11,	39,	24,	22,	35},
{11,	19,	22,	36,	36},
{11,	20,	27,	36,	27},
{11,	19,	28,	36,	28},
{11,	34,	28,	15,	33},
{11,	21,	30,	36,	19},
{11,	31,	29,	25,	20},
{11,	31,	29,	24,	33},
{11,	32,	29,	24,	21},
{11,	24,	19,	37,	25},
{12,	20,	19,	37,	37},
{11,	16,	18,	39,	37},
{11,	2,	20,	39,	33},
{11,	16,	21,	37,	37},
{11,	20,	37,	36,	10},
{11,	19,	35,	37,	11},
{11,	19,	39,	37,	7},
{13,	20,	38,	37,	2},
{11,	16,	28,	39,	14},
{11,	16,	26,	37,	21},
{12,	20,	25,	37,	17},
{11,	17,	28,	37,	18},
{11,	20,	29,	37,	14},
{11,	26,	34,	34,	1},
{11,	33,	37,	1,	23},
{11,	28,	27,	35,	2},
{11,	32,	26,	29,	5},
{11,	31,	30,	25,	5},
{11,	33,	37,	3,	1},
{10,	32,	39,	31,	37},
{15,	32,	33,	5,	39},
{14,	20,	32,	32,	36},
{13,	21,	33,	29,	38},
{13,	30,	23,	28,	38},
{13,	21,	30,	32,	38},
{13,	31,	33,	9,	38},
{12,	32,	34,	8,	38},
{12,	32,	37,	5,	38},
{14,	31,	36,	6,	38},
{12,	33,	25,	23,	36},
{12,	28,	26,	27,	38},
{12,	29,	28,	24,	38},
{12,	32,	33,	6,	39},
{11,	32,	34,	21,	38},
{13,	30,	32,	15,	39},
{12,	32,	26,	21,	39},
{12,	29,	35,	18,	38},
{12,	31,	32,	10,	39},
{11,	27,	27,	31,	39},
{11,	31,	31,	20,	39},
{11,	31,	39,	9,	38},
{13,	30,	35,	7,	39},
{12,	31,	35,	12,	38},
{11,	31,	35,	21,	38},
{12,	28,	35,	23,	38},
{11,	34,	28,	28,	0},
{12,	33,	27,	24,	4},
{11,	31,	34,	10,	39},
{13,	32,	34,	5,	39},
{12,	29,	34,	20,	39},
{11,	30,	31,	23,	38},
{11,	33,	27,	28,	5},
{11,	28,	36,	23,	38},
{11,	33,	29,	28,	0},
{12,	33,	30,	24,	0},
{11,	28,	28,	28,	38},
{12,	28,	24,	28,	39},
{11,	29,	31,	25,	38},
{12,	28,	29,	28,	38},
{11,	34,	26,	21,	35},
{11,	33,	26,	17,	39},
{11,	33,	26,	20,	38},
{11,	33,	34,	12,	0},
{11,	28,	37,	15,	38},
{11,	30,	26,	26,	38},
{11,	33,	26,	23,	35},
{11,	33,	27,	29,	0},
{11,	32,	34,	6,	39},
{11,	28,	38,	12,	38},
{11,	32,	33,	7,	39},
{11,	29,	21,	31,	39},
{11,	29,	22,	31,	38},
{11,	30,	27,	24,	38},
{11,	25,	23,	32,	39},
{11,	30,	34,	11,	39},
{11,	39,	20,	31,	39},
{11,	28,	22,	31,	39},
{11,	32,	38,	5,	38},
{11,	33,	27,	27,	6},
{11,	22,	30,	31,	38},
{10,	27,	39,	38,	31},
{16,	10,	33,	35,	32},
{16,	22,	26,	36,	32},
{15,	23,	30,	39,	0},
{15,	22,	29,	39,	5},
{14,	22,	18,	39,	34},
{14,	28,	25,	34,	24},
{13,	23,	25,	35,	34},
{14,	25,	25,	36,	32},
{13,	21,	21,	39,	18},
{13,	22,	21,	37,	35},
{13,	25,	20,	37,	35},
{13,	24,	18,	39,	22},
{13,	19,	33,	39,	2},
{13,	24,	31,	39,	0},
{14,	21,	32,	39,	2},
{13,	16,	28,	39,	18},
{12,	11,	37,	35,	32},
{15,	24,	28,	35,	32},
{13,	13,	32,	36,	32},
{12,	28,	27,	35,	13},
{12,	28,	33,	32,	14},
{14,	28,	33,	33,	1},
{12,	28,	30,	32,	30},
{12,	24,	17,	39,	32},
{12,	26,	28,	33,	32},
{12,	18,	28,	35,	33},
{13,	19,	27,	35,	34},
{12,	17,	21,	39,	25},
{13,	17,	23,	39,	22},
{12,	22,	20,	39,	24},
{12,	19,	39,	39,	0},
{12,	29,	33,	32,	0},
{11,	23,	38,	32,	33},
{12,	23,	39,	32,	32},
{12,	22,	31,	32,	36},
{11,	16,	24,	39,	25},
{14,	7,	25,	39,	23},
{11,	26,	34,	33,	32},
{14,	24,	33,	33,	33},
{12,	22,	32,	34,	33},
{11,	28,	34,	32,	14},
{13,	28,	35,	32,	0},
{12,	28,	34,	33,	0},
{11,	20,	38,	39,	3},
{13,	21,	32,	39,	5},
{12,	21,	30,	39,	6},
{11,	26,	24,	35,	34},
{13,	27,	25,	34,	32},
{11,	28,	28,	34,	8},
{11,	29,	29,	33,	7},
{11,	29,	27,	34,	20},
{11,	13,	33,	36,	32},
{11,	19,	26,	36,	34},
{14,	25,	25,	36,	33},
{11,	28,	37,	32,	0},
{11,	23,	27,	39,	3},
{13,	24,	20,	39,	24},
{11,	21,	27,	36,	33},
{11,	26,	28,	36,	32},
{12,	21,	28,	36,	33},
{11,	21,	28,	35,	34},
{11,	29,	27,	32,	27},
{11,	22,	30,	39,	6},
{11,	14,	28,	36,	34},
{11,	18,	21,	38,	35},
{11,	23,	37,	33,	32},
{11,	22,	21,	37,	36},
{11,	28,	25,	34,	25},
{12,	28,	24,	34,	28},
{11,	29,	26,	33,	29},
{13,	28,	26,	36,	22},
{12,	29,	27,	33,	23},
{11,	27,	27,	33,	32},
{11,	39,	20,	37,	3},
{10,	35,	32,	21,	35},
{16,	39,	27,	20,	34},
{15,	35,	29,	5,	37},
{14,	34,	33,	7,	1},
{13,	33,	29,	11,	36},
{13,	39,	27,	17,	35},
{13,	35,	33,	5,	0},
{13,	36,	31,	5,	0},
{12,	33,	28,	18,	36},
{15,	33,	28,	15,	37},
{12,	39,	27,	18,	36},
{12,	34,	33,	5,	32},
{12,	34,	33,	7,	3},
{11,	33,	33,	21,	34},
{13,	34,	33,	5,	35},
{11,	33,	34,	9,	34},
{11,	35,	31,	22,	0},
{12,	34,	29,	23,	0},
{11,	36,	28,	20,	3},
{11,	36,	28,	15,	27},
{12,	36,	28,	16,	6},
{12,	36,	28,	13,	31},
{11,	34,	28,	14,	36},
{10,	21,	37,	36,	37},
{14,	22,	25,	36,	36},
{13,	22,	37,	32,	35},
{13,	23,	26,	35,	35},
{14,	22,	27,	35,	36},
{11,	22,	38,	32,	36},
{11,	24,	23,	35,	37},
{14,	26,	22,	34,	37},
{12,	23,	24,	36,	37},
{12,	24,	27,	33,	35},
{11,	24,	33,	32,	35},
{14,	24,	32,	33,	34},
{13,	23,	33,	32,	36},
{11,	26,	24,	33,	36},
{11,	24,	15,	37,	38},
{11,	23,	15,	39,	37},
{12,	25,	19,	38,	35},
{10,	39,	33,	21,	0},
{13,	36,	29,	6,	3},
{12,	34,	33,	8,	1},
{12,	37,	32,	0,	5},
{12,	36,	33,	2,	2},
{11,	36,	29,	9,	1},
{11,	38,	35,	1,	0},
{13,	38,	38,	0,	0},
{11,	37,	34,	0,	5},
{10,	33,	35,	20,	36},
{13,	35,	30,	5,	36},
{13,	33,	27,	21,	36},
{13,	34,	33,	3,	36},
{11,	33,	31,	9,	37},
{12,	34,	30,	5,	37},
{11,	33,	32,	4,	39},
{13,	33,	32,	6,	37},
{11,	35,	30,	6,	36},
{11,	34,	33,	5,	36},
{11,	35,	32,	4,	36},
{11,	34,	35,	1,	38},
{11,	33,	36,	1,	38},
{10,	30,	38,	21,	39},
{11,	31,	33,	12,	39},
{11,	31,	28,	21,	39},
{10,	34,	35,	9,	39},
{16,	35,	34,	2,	10},
{14,	35,	34,	4,	0},
{13,	35,	31,	6,	36},
{12,	34,	33,	10,	3},
{11,	35,	35,	4,	21},
{11,	34,	33,	12,	7},
{11,	35,	35,	3,	35},
{11,	35,	31,	8,	36},
{11,	31,	36,	9,	39},
{11,	33,	28,	12,	38},
{11,	36,	34,	3,	1},
{11,	37,	34,	3,	0},
{11,	32,	36,	3,	39},
{11,	32,	39,	0,	39},
{10,	26,	36,	28,	39},
{13,	27,	35,	22,	39},
{12,	27,	30,	27,	39},
{12,	27,	32,	24,	39},
{10,	35,	37,	23,	0},
{13,	33,	35,	21,	1},
{11,	35,	36,	4,	6},
{14,	35,	37,	1,	10},
{13,	35,	37,	0,	26},
{11,	35,	36,	3,	10},
{11,	34,	34,	12,	1},
{10,	33,	32,	28,	29},
{12,	33,	25,	27,	32},
{11,	34,	31,	25,	0},
{11,	33,	25,	24,	35},
{11,	39,	24,	25,	34},
{10,	21,	33,	35,	38},
{11,	9,	23,	36,	38},
{13,	23,	22,	36,	38},
{11,	22,	33,	30,	38},
{10,	35,	28,	25,	31},
{15,	34,	26,	22,	33},
{13,	33,	26,	24,	35},
{13,	34,	27,	23,	32},
{12,	34,	29,	22,	3},
{12,	34,	31,	22,	2},
{11,	39,	27,	23,	9},
{11,	34,	32,	23,	1},
{11,	39,	27,	26,	0},
{11,	34,	30,	22,	3},
{11,	33,	26,	27,	31},
{11,	33,	27,	26,	32},
{10,	16,	36,	39,	24},
{11,	19,	29,	39,	14},
{12,	21,	25,	39,	14},
{11,	21,	23,	39,	22},
{11,	22,	27,	39,	9},
{11,	20,	30,	39,	11},
{11,	18,	27,	39,	17},
{11,	17,	26,	39,	24},
{10,	30,	30,	34,	16},
{14,	29,	28,	33,	19},
{13,	30,	26,	34,	17},
{12,	31,	27,	32,	1},
{13,	32,	24,	34,	0},
{12,	31,	24,	32,	19},
{12,	29,	28,	33,	20},
{12,	29,	28,	32,	27},
{12,	32,	24,	32,	10},
{11,	28,	30,	36,	1},
{13,	28,	28,	37,	0},
{13,	28,	27,	36,	10},
{11,	29,	27,	36,	7},
{11,	30,	28,	32,	18},
{11,	29,	28,	34,	19},
{11,	32,	27,	32,	0},
{11,	28,	27,	36,	16},
{10,	27,	35,	31,	38},
{10,	35,	33,	10,	36},
{13,	35,	34,	6,	1},
{11,	34,	35,	10,	27},
{12,	34,	34,	10,	29},
{11,	35,	34,	6,	18},
{13,	35,	34,	7,	2},
{11,	36,	33,	0,	38},
{11,	35,	31,	4,	39},
{12,	35,	33,	3,	37},
{12,	35,	29,	5,	38},
{11,	36,	31,	1,	39},
{11,	35,	33,	1,	38},
{10,	32,	28,	24,	39},
{13,	30,	25,	25,	39},
{12,	31,	25,	25,	39},
{12,	28,	30,	24,	39},
{12,	29,	25,	26,	39},
{11,	31,	31,	23,	38},
{11,	29,	23,	29,	39},
{11,	31,	32,	22,	38},
{11,	30,	26,	25,	39},
{11,	28,	27,	26,	39},
{11,	30,	29,	24,	38},
{10,	26,	39,	34,	33},
{11,	26,	28,	34,	34},
{11,	26,	28,	36,	33},
{11,	22,	27,	36,	37},
{11,	26,	25,	33,	37},
{13,	24,	25,	34,	37},
{11,	24,	32,	32,	36},
{11,	27,	25,	32,	37},
{10,	39,	26,	21,	39},
{10,	29,	39,	20,	38},
{10,	34,	32,	23,	22},
{10,	39,	26,	28,	32},
{14,	39,	27,	27,	0},
{13,	39,	25,	29,	7},
{11,	34,	28,	28,	1},
{11,	39,	26,	29,	0},
{10,	39,	29,	3,	35},
{14,	39,	29,	5,	1},
{13,	37,	33,	0,	13},
{13,	39,	29,	1,	36},
{12,	36,	30,	2,	34},
{10,	36,	29,	6,	39},
{11,	39,	28,	3,	39},
{10,	36,	29,	10,	35},
{12,	36,	28,	12,	35},
{10,	36,	29,	21,	17},
{10,	28,	39,	36,	2},
{13,	28,	39,	32,	4},
{11,	28,	30,	36,	4},
{10,	33,	36,	14,	11},
{10,	32,	31,	21,	39},
{10,	34,	35,	12,	19},
{10,	29,	26,	38,	20},
{16,	28,	22,	37,	32},
{14,	29,	21,	38,	25},
{12,	28,	27,	38,	1},
{11,	28,	26,	37,	24},
{12,	28,	23,	37,	31},
{11,	28,	25,	37,	25},
{10,	16,	39,	39,	16},
{16,	4,	37,	39,	18},
{10,	39,	31,	23,	0},
{10,	28,	38,	28,	38},
{10,	27,	36,	30,	38},
{10,	21,	25,	39,	31},
{11,	15,	21,	39,	33},
{11,	5,	26,	39,	25},
{10,	34,	31,	28,	2},
{14,	35,	27,	27,	2},
{11,	34,	31,	25,	3},
{10,	24,	38,	36,	33},
{13,	25,	35,	36,	32},
{13,	26,	31,	36,	32},
{13,	26,	37,	35,	32},
{10,	35,	36,	4,	31},
{13,	34,	36,	3,	33},
{11,	34,	37,	1,	33},
{10,	33,	35,	21,	31},
{11,	33,	34,	22,	6},
{11,	33,	34,	23,	1},
{10,	35,	29,	9,	39},
{10,	25,	39,	39,	1},
{16,	25,	27,	39,	3},
{13,	26,	28,	39,	0},
{14,	27,	19,	39,	19},
{12,	39,	15,	39,	36},
{11,	25,	28,	39,	3},
{10,	22,	38,	34,	35},
{13,	22,	31,	33,	36},
{11,	22,	37,	36,	34},
{11,	22,	37,	35,	35},
{10,	17,	21,	39,	38},
{12,	18,	21,	39,	37},
{11,	20,	19,	39,	37},
{10,	24,	24,	39,	33},
{13,	13,	23,	38,	34},
{13,	22,	25,	39,	31},
{12,	26,	21,	39,	17},
{11,	23,	26,	39,	19},
{11,	26,	28,	39,	3},
{11,	13,	24,	38,	34},
{11,	22,	21,	38,	36},
{11,	17,	25,	37,	34},
{10,	33,	32,	12,	38},
{12,	33,	29,	15,	37},
{12,	34,	29,	10,	37},
{10,	29,	33,	32,	21},
{12,	29,	29,	32,	24},
{12,	29,	29,	33,	18},
{11,	30,	33,	32,	4},
{11,	29,	30,	33,	18},
{10,	28,	31,	35,	16},
{11,	29,	28,	35,	6},
{10,	39,	23,	36,	19},
{13,	30,	22,	36,	23},
{12,	39,	23,	33,	21},
{11,	30,	25,	35,	16},
{11,	30,	25,	36,	1},
{10,	17,	27,	37,	35},
{12,	17,	28,	37,	32},
{11,	8,	29,	37,	32},
{11,	25,	27,	37,	32},
{10,	36,	30,	4,	39},
{10,	31,	38,	18,	38},
{10,	32,	35,	12,	39},
{11,	32,	35,	13,	38},
{10,	34,	37,	13,	1},
{10,	35,	33,	21,	1},
{11,	34,	33,	17,	2},
{10,	28,	36,	33,	12},
{11,	28,	37,	32,	7},
{10,	29,	36,	34,	7},
{12,	29,	32,	33,	9},
{12,	28,	32,	35,	5},
{11,	29,	38,	32,	0},
{11,	28,	32,	34,	10},
{11,	29,	31,	33,	12},
{12,	29,	33,	33,	10},
{10,	28,	35,	36,	9},
{10,	31,	38,	12,	39},
{13,	33,	37,	1,	39},
{11,	32,	38,	4,	39},
{10,	36,	29,	15,	27},
{10,	35,	27,	26,	30},
{11,	34,	28,	26,	27},
{11,	34,	30,	27,	3},
{10,	34,	31,	26,	7},
{10,	33,	37,	5,	25},
{13,	35,	37,	4,	2},
{12,	33,	37,	2,	34},
{10,	33,	25,	28,	36},
{10,	36,	32,	3,	29},
{13,	36,	32,	1,	37},
{11,	36,	33,	1,	17},
{10,	5,	36,	39,	25},
{12,	16,	28,	39,	25},
{10,	5,	35,	39,	28},
{11,	10,	28,	39,	27},
{10,	33,	37,	14,	4},
{12,	33,	37,	8,	6},
{10,	39,	22,	30,	39},
{12,	31,	25,	26,	38},
{10,	33,	37,	10,	11},
{10,	26,	29,	31,	39},
{10,	26,	26,	39,	15},
{11,	25,	23,	39,	28},
{11,	24,	25,	39,	24},
{11,	25,	24,	39,	25},
{10,	33,	37,	18,	2},
{11,	33,	36,	15,	3},
{10,	33,	36,	23,	2},
{11,	33,	35,	22,	4},
{10,	39,	28,	8,	22},
{15,	39,	28,	13,	5},
{14,	39,	28,	12,	10},
{12,	39,	29,	5,	2},
{12,	39,	28,	15,	8},
{11,	39,	28,	5,	37},
{10,	39,	28,	26,	0},
{10,	22,	39,	39,	5},
{10,	36,	31,	4,	30},
{10,	27,	34,	26,	39},
{10,	30,	31,	25,	38},
{10,	35,	33,	12,	7},
{13,	35,	33,	15,	2},
{12,	35,	33,	13,	4},
{10,	31,	24,	33,	28},
{12,	30,	21,	36,	28},
{11,	39,	23,	33,	28},
{10,	36,	34,	1,	38},
{11,	36,	32,	1,	39},
{10,	39,	21,	33,	37},
{13,	30,	22,	35,	33},
{11,	30,	23,	34,	30},
{11,	28,	24,	32,	36},
{11,	39,	23,	34,	22},
{10,	33,	33,	23,	33},
{10,	33,	28,	28,	34},
{12,	33,	29,	28,	30},
{11,	33,	29,	24,	32},
{10,	33,	36,	6,	31},
{11,	33,	37,	6,	14},
{10,	33,	37,	7,	24},
{11,	33,	37,	9,	12},
{10,	33,	37,	9,	22},
{13,	33,	37,	8,	24},
{11,	33,	36,	11,	15},
{10,	33,	36,	9,	31},
{10,	18,	26,	39,	31},
{12,	7,	27,	39,	29},
{10,	34,	32,	12,	36},
{10,	34,	30,	12,	37},
{11,	34,	32,	10,	37},
{10,	36,	29,	18,	19},
{10,	28,	22,	35,	36},
{14,	39,	21,	35,	35},
{11,	30,	21,	36,	35},
{10,	34,	32,	22,	24},
{14,	34,	29,	22,	26},
{11,	34,	31,	23,	23},
{10,	39,	25,	32,	1},
{13,	32,	26,	32,	3},
{11,	39,	24,	34,	0},
{10,	37,	33,	1,	9},
{13,	37,	30,	4,	1},
{11,	37,	30,	1,	14},
{10,	34,	32,	26,	0},
{10,	28,	31,	25,	39},
{10,	11,	24,	38,	35},
{10,	35,	34,	9,	2},
{10,	36,	33,	3,	12},
{10,	30,	32,	32,	9},
{10,	39,	29,	7,	2},
{10,	29,	28,	36,	8},
{10,	31,	39,	13,	38},
{10,	35,	34,	6,	23},
{10,	35,	34,	7,	20},
{10,	35,	34,	9,	5},
{10,	27,	29,	39,	0},
{12,	27,	25,	39,	3},
{10,	21,	27,	39,	23},
{12,	21,	28,	39,	15},
{12,	18,	32,	39,	15},
{11,	20,	26,	39,	30},
{11,	22,	27,	39,	19},
{10,	19,	30,	39,	22},
{10,	39,	27,	28,	1},
{10,	35,	39,	4,	0},
{10,	33,	38,	8,	11},
{14,	33,	38,	3,	24},
{13,	35,	38,	5,	0},
{12,	33,	39,	1,	38},
{11,	35,	38,	3,	2},
{11,	34,	39,	3,	1},
{10,	33,	38,	7,	23},
{10,	35,	38,	8,	0},
{11,	34,	38,	6,	1},
{10,	33,	38,	9,	8},
{10,	27,	35,	25,	39},
{10,	24,	24,	34,	38},
{10,	16,	37,	39,	19},
{10,	24,	33,	34,	34},
{10,	29,	25,	36,	25},
{13,	30,	23,	36,	27},
{12,	29,	24,	37,	24},
{10,	39,	27,	23,	18},
{10,	27,	24,	37,	33},
{10,	26,	25,	38,	32},
{12,	2,	25,	39,	32},
{10,	4,	22,	37,	37},
{10,	29,	27,	38,	3},
{10,	29,	28,	37,	5},
{10,	24,	25,	35,	37},
{10,	32,	39,	1,	39},
{10,	39,	28,	19,	7},
{11,	39,	28,	22,	1},
{10,	35,	39,	6,	0},
{10,	33,	39,	6,	23},
{10,	22,	36,	32,	37},
{10,	31,	23,	28,	39},
{12,	31,	25,	26,	39},
{10,	39,	25,	29,	20},
{10,	28,	33,	34,	12},
{10,	28,	29,	37,	5},
{10,	35,	28,	28,	0},
{10,	35,	29,	27,	0},
{10,	37,	34,	3,	1},
{10,	26,	31,	39,	1},
{10,	28,	24,	35,	31},
{10,	39,	27,	26,	6},
{10,	39,	33,	1,	2},
{10,	31,	30,	24,	38},
{10,	30,	27,	26,	38},
{10,	33,	36,	17,	3},
{10,	29,	28,	32,	30},
{11,	29,	27,	32,	31},
{10,	30,	24,	34,	29},
{11,	30,	24,	35,	25},
{10,	35,	30,	22,	1},
{11,	35,	29,	25,	2},
{10,	37,	31,	5,	1},
{10,	24,	26,	33,	37},
{10,	33,	37,	8,	25},
{10,	33,	34,	23,	5},
{10,	28,	21,	36,	36},
{10,	24,	28,	39,	6},
{11,	24,	27,	39,	13},
{10,	35,	34,	11,	1},
{10,	22,	35,	36,	35},
{10,	18,	32,	39,	22},
{11,	17,	33,	39,	20},
{10,	34,	33,	11,	22},
{10,	38,	33,	0,	4},
{10,	39,	31,	0,	10},
{10,	26,	30,	36,	33},
{11,	25,	32,	36,	33},
{10,	27,	25,	36,	33},
{10,	26,	20,	34,	38},
{10,	28,	36,	32,	14},
{10,	28,	32,	33,	16},
{10,	35,	39,	1,	8},
{10,	37,	39,	1,	1},
{11,	39,	38,	1,	0},
{11,	39,	34,	3,	0},
{10,	23,	32,	33,	35},
{10,	25,	28,	33,	35},
{10,	22,	29,	34,	36},
{10,	27,	25,	34,	34},
{10,	33,	30,	25,	30},
{10,	19,	27,	37,	34},
{10,	28,	27,	33,	27},
{10,	39,	22,	37,	4},
{10,	34,	30,	24,	8},
{10,	34,	32,	24,	1},
{10,	34,	39,	3,	4},
{10,	34,	39,	5,	1},
{10,	34,	39,	4,	4},
{10,	28,	21,	37,	34},
{10,	25,	24,	32,	39},
{10,	21,	20,	38,	37},
{10,	29,	29,	33,	20},
{10,	28,	29,	33,	25},
{10,	28,	31,	34,	23},
{12,	29,	28,	34,	21},
{10,	28,	30,	36,	23},
{10,	28,	28,	37,	19},
{10,	28,	30,	37,	7},
{10,	28,	34,	37,	3},
{10,	28,	31,	33,	27},
{10,	28,	35,	37,	1},
{10,	29,	30,	33,	21},
{10,	26,	24,	39,	19},
{10,	28,	39,	32,	5},
{10,	29,	34,	33,	8},
{10,	33,	37,	15,	3},
{10,	27,	31,	27,	39},
{10,	28,	23,	36,	33},
{11,	30,	23,	33,	33},
{10,	23,	27,	33,	37},
{10,	22,	27,	33,	38},
{10,	22,	26,	34,	38},
{10,	29,	29,	32,	29},
{10,	28,	24,	33,	34},
{10,	23,	21,	39,	34},
{10,	28,	31,	35,	18},
{10,	33,	36,	4,	34},
{10,	32,	24,	35,	0},
{10,	31,	24,	35,	2},
{10,	34,	33,	18,	2},
{10,	39,	30,	5,	1},
{10,	36,	34,	3,	2},
{9,	37,	39,	36,	32},
{15,	39,	29,	4,	34},
{15,	34,	33,	12,	34},
{14,	39,	23,	35,	33},
{14,	33,	25,	30,	33},
{14,	39,	35,	3,	0},
{13,	33,	31,	25,	33},
{13,	36,	39,	1,	33},
{12,	35,	34,	6,	34},
{12,	35,	37,	4,	33},
{12,	39,	29,	4,	35},
{12,	39,	28,	11,	34},
{12,	27,	26,	36,	33},
{12,	27,	38,	32,	33},
{12,	31,	28,	32,	33},
{12,	36,	29,	11,	35},
{12,	35,	35,	5,	34},
{11,	28,	38,	34,	33},
{15,	29,	28,	34,	33},
{14,	29,	26,	35,	33},
{12,	30,	25,	35,	33},
{12,	30,	27,	34,	33},
{11,	30,	35,	33,	33},
{13,	29,	38,	33,	33},
{11,	33,	36,	20,	33},
{11,	31,	24,	33,	35},
{15,	29,	25,	34,	34},
{14,	39,	22,	35,	35},
{11,	36,	35,	4,	33},
{12,	36,	33,	3,	34},
{11,	30,	28,	32,	34},
{13,	28,	28,	33,	34},
{11,	34,	35,	10,	36},
{11,	35,	34,	10,	34},
{11,	29,	27,	37,	16},
{11,	34,	36,	10,	33},
{11,	33,	29,	26,	34},
{12,	33,	30,	23,	34},
{11,	34,	29,	22,	33},
{11,	39,	23,	35,	34},
{13,	32,	26,	32,	34},
{11,	35,	34,	6,	35},
{11,	36,	30,	6,	33},
{11,	36,	31,	3,	36},
{11,	39,	30,	8,	1},
{11,	32,	24,	32,	35},
{11,	36,	28,	13,	33},
{11,	28,	39,	32,	33},
{11,	27,	27,	37,	32},
{11,	33,	39,	5,	33},
{12,	35,	39,	4,	33},
{10,	39,	29,	11,	35},
{10,	39,	31,	28,	0},
{10,	39,	28,	18,	34},
{11,	39,	28,	15,	35},
{10,	37,	30,	1,	39},
{11,	37,	30,	2,	34},
{10,	24,	39,	36,	33},
{10,	34,	35,	15,	33},
{11,	34,	36,	12,	33},
{10,	29,	38,	34,	33},
{10,	28,	26,	38,	27},
{10,	39,	29,	12,	33},
{10,	39,	35,	4,	0},
{10,	39,	34,	6,	0},
{10,	34,	29,	23,	33},
{10,	37,	30,	4,	33},
{10,	39,	24,	32,	34},
{10,	33,	28,	29,	33},
{10,	35,	36,	3,	34},
{10,	30,	24,	32,	36},
{10,	35,	35,	5,	35},
{10,	39,	30,	0,	17},
{10,	28,	39,	33,	33},
{10,	31,	27,	33,	33},
{10,	36,	31,	3,	37},
{10,	39,	22,	36,	34},
{10,	31,	24,	36,	33},
{10,	30,	26,	36,	33},
{10,	28,	22,	38,	31},
{10,	35,	34,	7,	35},
{10,	39,	31,	0,	12},
{9,	30,	39,	39,	36},
{16,	31,	23,	38,	8},
{13,	31,	27,	33,	35},
{13,	39,	22,	37,	28},
{13,	39,	23,	37,	15},
{12,	4,	23,	37,	37},
{11,	9,	26,	37,	37},
{11,	26,	26,	34,	37},
{13,	23,	27,	36,	37},
{12,	24,	26,	36,	37},
{11,	29,	26,	33,	37},
{11,	39,	22,	37,	35},
{11,	31,	23,	37,	34},
{10,	26,	31,	36,	37},
{13,	22,	37,	33,	37},
{11,	22,	32,	35,	37},
{11,	24,	33,	34,	37},
{11,	27,	27,	33,	37},
{10,	31,	32,	37,	0},
{12,	39,	25,	37,	0},
{12,	31,	24,	37,	11},
{10,	24,	28,	33,	38},
{13,	25,	28,	32,	38},
{11,	25,	26,	32,	39},
{10,	26,	24,	34,	38},
{10,	20,	24,	37,	37},
{10,	24,	34,	33,	37},
{10,	22,	37,	34,	37},
{10,	23,	27,	34,	38},
{10,	25,	29,	32,	38},
{10,	24,	29,	32,	39},
{10,	21,	21,	37,	38},
{10,	28,	27,	32,	37},
{10,	17,	25,	37,	37},
{10,	31,	25,	37,	5},
{10,	39,	23,	34,	35},
{10,	32,	26,	33,	35},
{10,	32,	24,	34,	34},
{10,	30,	23,	33,	37},
{10,	24,	19,	37,	37},
{10,	31,	23,	39,	0},
{10,	39,	22,	39,	27},
{11,	31,	23,	38,	34},
{9,	39,	39,	32,	3},
{13,	38,	39,	0,	5},
{9,	33,	37,	31,	38},
{16,	33,	39,	4,	37},
{14,	39,	24,	24,	39},
{13,	30,	23,	30,	39},
{12,	31,	38,	20,	38},
{12,	33,	39,	4,	38},
{12,	33,	38,	9,	33},
{12,	33,	25,	22,	39},
{11,	33,	38,	10,	35},
{11,	34,	39,	3,	35},
{11,	30,	25,	27,	39},
{11,	33,	25,	24,	39},
{11,	33,	38,	5,	38},
{11,	31,	23,	30,	39},
{11,	39,	24,	33,	35},
{11,	33,	37,	3,	39},
{10,	33,	25,	30,	39},
{10,	33,	31,	15,	39},
{11,	34,	28,	12,	39},
{10,	33,	30,	21,	39},
{10,	39,	25,	29,	38},
{12,	34,	26,	27,	33},
{10,	33,	38,	29,	34},
{12,	33,	38,	12,	35},
{10,	31,	27,	28,	39},
{11,	31,	28,	26,	39},
{11,	29,	29,	25,	39},
{10,	34,	27,	21,	37},
{11,	35,	27,	16,	37},
{10,	32,	36,	12,	39},
{10,	33,	39,	10,	35},
{10,	35,	27,	18,	37},
{10,	33,	36,	7,	39},
{11,	33,	38,	4,	39},
{10,	33,	33,	10,	39},
{10,	34,	36,	7,	35},
{12,	34,	39,	4,	35},
{10,	35,	37,	4,	35},
{10,	29,	31,	24,	39},
{12,	29,	30,	25,	39},
{10,	34,	35,	10,	37},
{10,	33,	32,	11,	39},
{9,	29,	30,	36,	39},
{13,	30,	28,	28,	39},
{11,	28,	31,	27,	39},
{10,	29,	31,	34,	37},
{10,	32,	25,	31,	39},
{10,	27,	31,	35,	37},
{10,	31,	28,	27,	39},
{9,	36,	30,	21,	39},
{10,	37,	30,	9,	33},
{10,	35,	32,	12,	36},
{10,	39,	28,	21,	34},
{9,	28,	38,	34,	38},
{12,	29,	35,	32,	37},
{10,	21,	35,	35,	38},
{10,	26,	39,	32,	37},
{10,	29,	33,	33,	37},
{9,	26,	36,	31,	39},
{9,	33,	39,	39,	3},
{13,	39,	25,	38,	3},
{12,	31,	37,	37,	4},
{12,	39,	23,	39,	9},
{11,	31,	37,	37,	5},
{11,	39,	23,	38,	28},
{11,	32,	27,	37,	4},
{12,	32,	25,	39,	5},
{12,	32,	24,	38,	11},
{12,	31,	30,	38,	4},
{12,	32,	28,	38,	4},
{10,	39,	25,	39,	5},
{11,	39,	24,	38,	11},
{11,	33,	27,	37,	4},
{10,	31,	24,	38,	22},
{10,	32,	31,	37,	4},
{10,	34,	26,	38,	0},
{10,	32,	26,	39,	5},
{9,	31,	39,	15,	39},
{13,	33,	39,	4,	39},
{9,	27,	38,	26,	39},
{10,	28,	37,	22,	39},
{9,	34,	33,	21,	38},
{11,	34,	35,	10,	38},
{9,	35,	36,	15,	36},
{12,	34,	37,	1,	38},
{11,	34,	38,	3,	36},
{10,	35,	34,	3,	39},
{10,	35,	31,	18,	36},
{10,	34,	34,	11,	38},
{10,	36,	34,	0,	39},
{9,	33,	36,	18,	39},
{10,	31,	37,	16,	39},
{9,	35,	29,	31,	35},
{12,	39,	27,	31,	33},
{12,	39,	27,	23,	34},
{11,	34,	27,	23,	36},
{11,	39,	25,	32,	34},
{10,	36,	29,	23,	35},
{10,	34,	30,	25,	35},
{11,	34,	30,	30,	33},
{10,	34,	33,	23,	34},
{13,	34,	33,	24,	33},
{10,	35,	30,	27,	33},
{12,	35,	31,	22,	33},
{10,	34,	31,	23,	35},
{10,	39,	25,	30,	36},
{10,	39,	28,	23,	34},
{10,	34,	32,	22,	35},
{9,	31,	32,	29,	39},
{13,	30,	33,	22,	39},
{11,	30,	26,	31,	39},
{10,	28,	32,	31,	39},
{14,	29,	31,	30,	39},
{12,	29,	31,	31,	39},
{10,	32,	29,	24,	39},
{9,	35,	33,	10,	39},
{13,	35,	34,	5,	37},
{12,	35,	34,	5,	38},
{10,	35,	31,	12,	37},
{9,	27,	29,	38,	37},
{10,	25,	21,	37,	38},
{10,	24,	20,	39,	37},
{9,	31,	35,	36,	35},
{11,	32,	25,	34,	34},
{10,	31,	37,	34,	33},
{9,	28,	39,	25,	38},
{9,	34,	38,	21,	34},
{11,	35,	39,	6,	33},
{10,	34,	38,	24,	33},
{10,	35,	37,	5,	35},
{9,	31,	39,	34,	36},
{11,	32,	26,	32,	36},
{10,	32,	27,	32,	36},
{10,	35,	27,	32,	34},
{10,	31,	23,	36,	36},
{10,	32,	27,	33,	34},
{9,	31,	39,	37,	15},
{11,	31,	25,	37,	22},
{10,	31,	25,	38,	22},
{10,	39,	25,	39,	6},
{10,	39,	25,	37,	8},
{10,	32,	25,	37,	20},
{9,	26,	38,	36,	37},
{10,	25,	34,	35,	38},
{10,	28,	32,	35,	37},
{10,	27,	31,	35,	38},
{10,	23,	35,	35,	38},
{9,	34,	35,	20,	37},
{10,	34,	34,	12,	38},
{9,	35,	39,	21,	33},
{11,	35,	33,	18,	34},
{10,	35,	33,	19,	34},
{10,	33,	39,	12,	34},
{9,	30,	39,	33,	37},
{10,	30,	30,	32,	38},
{10,	30,	26,	36,	37},
{10,	39,	24,	32,	37},
{12,	31,	25,	34,	37},
{10,	39,	23,	34,	37},
{9,	33,	29,	38,	13},
{13,	33,	25,	37,	20},
{12,	33,	25,	38,	16},
{12,	32,	30,	37,	6},
{11,	33,	28,	37,	15},
{12,	32,	29,	37,	15},
{10,	32,	27,	39,	8},
{12,	33,	27,	39,	6},
{10,	33,	30,	38,	4},
{10,	32,	26,	37,	16},
{9,	35,	31,	21,	38},
{9,	32,	39,	38,	6},
{11,	31,	34,	38,	8},
{11,	32,	31,	37,	8},
{10,	31,	31,	38,	13},
{9,	36,	33,	21,	33},
{9,	22,	34,	36,	38},
{9,	25,	23,	39,	38},
{9,	30,	39,	16,	39},
{9,	31,	31,	39,	15},
{11,	33,	25,	39,	10},
{11,	32,	28,	38,	15},
{10,	31,	37,	39,	4},
{11,	31,	32,	39,	7},
{9,	31,	36,	33,	37},
{9,	33,	30,	23,	39},
{9,	39,	28,	15,	39},
{9,	39,	29,	9,	36},
{9,	34,	32,	28,	34},
{10,	34,	37,	25,	33},
{10,	34,	33,	25,	34},
{9,	31,	29,	31,	39},
{9,	35,	35,	25,	33},
{9,	34,	27,	31,	36},
{9,	34,	27,	22,	39},
{13,	34,	26,	24,	37},
{9,	29,	38,	31,	38},
{9,	39,	25,	29,	39},
{9,	34,	36,	12,	37},
{10,	34,	37,	3,	38},
{10,	34,	37,	5,	37},
{10,	35,	37,	5,	36},
{10,	35,	38,	3,	36},
{9,	31,	34,	38,	15},
{9,	35,	34,	10,	37},
{9,	32,	31,	24,	39},
{9,	35,	36,	6,	37},
{9,	36,	38,	1,	38},
{9,	32,	32,	20,	39},
{9,	33,	39,	37,	4},
{10,	33,	32,	38,	4},
{9,	32,	24,	32,	39},
{9,	34,	37,	9,	36},
{9,	39,	26,	37,	15},
{9,	36,	34,	3,	36},
{9,	36,	33,	3,	39},
{9,	36,	32,	4,	39},
{9,	33,	27,	34,	34},
{9,	31,	25,	38,	34},
{9,	35,	35,	9,	37},
{9,	32,	31,	39,	6},
{10,	32,	28,	39,	9},
{9,	28,	34,	35,	37},
{9,	30,	34,	22,	39},
{9,	33,	38,	17,	35},
{9,	36,	31,	5,	37},
{9,	35,	36,	8,	37},
{9,	34,	37,	3,	39},
{11,	36,	37,	0,	39},
{10,	35,	37,	1,	39},
{9,	35,	34,	7,	38},
{9,	35,	34,	6,	39},
{9,	34,	39,	13,	34},
{9,	35,	39,	7,	34},
{9,	34,	37,	15,	35},
{9,	34,	37,	13,	36},
{9,	29,	39,	23,	38},
{9,	26,	31,	36,	38},
{9,	34,	33,	26,	34},
{9,	34,	26,	23,	38},
{9,	35,	36,	2,	39},
{9,	25,	35,	35,	38},
{9,	32,	24,	34,	36},
{9,	34,	31,	11,	39},
{9,	32,	34,	37,	7},
{9,	39,	24,	33,	37},
{9,	27,	22,	37,	38},
{9,	35,	32,	16,	36},
{9,	39,	28,	17,	37},
{9,	33,	39,	13,	35},
{9,	34,	38,	5,	36},
{9,	36,	34,	3,	37},
{9,	27,	22,	39,	37},
{9,	35,	36,	3,	38},
{8,	38,	39,	38,	36},
{12,	36,	32,	5,	37},
{11,	39,	33,	33,	0},
{10,	36,	30,	39,	0},
{10,	36,	31,	9,	37},
{10,	35,	28,	39,	1},
{11,	34,	29,	39,	2},
{9,	39,	39,	38,	0},
{9,	33,	30,	33,	37},
{10,	32,	37,	32,	37},
{9,	36,	31,	12,	38},
{9,	39,	31,	3,	37},
{11,	39,	32,	0,	37},
{12,	37,	39,	0,	37},
{11,	37,	31,	1,	38},
{9,	36,	32,	10,	37},
{9,	39,	29,	2,	39},
{9,	31,	37,	33,	37},
{9,	38,	39,	0,	37},
{9,	37,	34,	1,	38},
{9,	34,	31,	39,	0},
{9,	34,	29,	39,	3},
{9,	36,	28,	39,	1},
{8,	35,	39,	37,	38},
{13,	28,	23,	39,	37},
{11,	39,	27,	23,	38},
{11,	34,	39,	2,	39},
{10,	36,	32,	12,	37},
{9,	36,	29,	23,	38},
{9,	32,	24,	36,	39},
{9,	36,	28,	25,	37},
{10,	39,	27,	25,	38},
{9,	15,	30,	38,	37},
{8,	33,	38,	31,	39},
{10,	32,	39,	5,	39},
{9,	32,	39,	7,	39},
{9,	39,	24,	32,	39},
{8,	38,	39,	39,	32},
{10,	39,	36,	39,	0},
{9,	32,	38,	39,	33},
{13,	39,	25,	39,	34},
{11,	33,	29,	39,	33},
{9,	39,	38,	39,	0},
{8,	29,	36,	35,	39},
{8,	37,	30,	21,	39},
{13,	37,	31,	4,	37},
{9,	37,	31,	6,	37},
{8,	32,	39,	39,	37},
{11,	33,	29,	39,	34},
{8,	23,	25,	39,	39},
{15,	26,	23,	37,	39},
{9,	25,	25,	39,	38},
{8,	34,	36,	23,	39},
{9,	35,	36,	4,	39},
{10,	35,	37,	3,	39},
{8,	31,	39,	20,	39},
{8,	39,	33,	35,	12},
{10,	39,	34,	16,	4},
{12,	39,	36,	4,	4},
{13,	39,	36,	0,	8},
{12,	39,	35,	0,	12},
{12,	39,	37,	3,	4},
{10,	39,	33,	7,	13},
{10,	39,	36,	6,	4},
{9,	39,	35,	11,	4},
{8,	29,	31,	39,	38},
{8,	39,	30,	20,	39},
{9,	39,	31,	1,	38},
{8,	39,	39,	36,	1},
{10,	39,	33,	39,	1},
{9,	39,	33,	38,	4},
{8,	21,	29,	37,	39},
{10,	23,	26,	37,	39},
{8,	35,	27,	28,	39},
{9,	34,	29,	24,	39},
{8,	39,	32,	3,	39},
{13,	37,	33,	2,	38},
{10,	37,	32,	6,	37},
{9,	38,	34,	0,	39},
{10,	37,	33,	1,	39},
{8,	39,	28,	33,	37},
{8,	36,	33,	7,	39},
{8,	36,	28,	24,	39},
{8,	35,	32,	15,	39},
{8,	33,	39,	39,	35},
{8,	39,	26,	31,	39},
{9,	34,	27,	29,	39},
{8,	36,	31,	12,	39},
{8,	34,	31,	25,	39},
{8,	23,	32,	38,	38},
{8,	39,	34,	29,	4},
{8,	34,	37,	9,	39},
{8,	39,	34,	5,	11},
{10,	39,	36,	2,	5},
{8,	39,	34,	25,	5},
{8,	39,	37,	7,	5},
{8,	39,	31,	39,	33},
{8,	30,	31,	38,	38},
{8,	35,	31,	18,	39},
{8,	39,	34,	2,	22},
{11,	39,	33,	4,	16},
{11,	39,	33,	0,	30},
{9,	39,	34,	0,	35},
{11,	39,	33,	0,	38},
{8,	26,	22,	39,	39},
{8,	39,	35,	34,	2},
{10,	39,	35,	33,	3},
{8,	30,	28,	39,	38},
{8,	39,	35,	5,	7},
{8,	35,	28,	25,	39},
{8,	39,	33,	2,	30},
{8,	39,	33,	13,	24},
{8,	27,	21,	39,	39},
{8,	39,	33,	6,	25},
{8,	39,	33,	3,	30},
{8,	31,	24,	38,	38},
{8,	33,	39,	6,	39},
{8,	39,	38,	1,	7},
{8,	39,	36,	5,	6},
{8,	38,	34,	1,	37},
{8,	39,	24,	38,	37},
{8,	39,	28,	22,	38},
{8,	39,	33,	39,	3},
{8,	39,	36,	4,	7},
{7,	38,	39,	39,	38},
{9,	38,	37,	0,	39},
{9,	37,	32,	4,	39},
{8,	36,	31,	15,	39},
{8,	37,	33,	3,	39},
{7,	39,	37,	37,	33},
{13,	39,	38,	2,	9},
{13,	39,	33,	1,	38},
{10,	39,	38,	1,	15},
{9,	39,	35,	39,	2},
{9,	39,	33,	6,	34},
{9,	39,	36,	38,	2},
{9,	39,	34,	4,	34},
{8,	39,	39,	36,	3},
{8,	39,	38,	15,	4},
{8,	39,	33,	39,	23},
{8,	39,	34,	38,	15},
{8,	39,	36,	1,	35},
{10,	39,	35,	1,	36},
{8,	39,	34,	1,	38},
{8,	39,	34,	2,	35},
{7,	35,	39,	28,	39},
{7,	33,	38,	36,	39},
{7,	39,	38,	39,	12},
{10,	39,	36,	38,	13},
{10,	39,	38,	4,	13},
{8,	39,	35,	39,	15},
{8,	39,	36,	39,	13},
{7,	36,	38,	14,	39},
{12,	36,	39,	3,	39},
{7,	27,	35,	37,	39},
{7,	39,	33,	39,	36},
{7,	39,	31,	18,	39},
{8,	39,	32,	5,	39},
{8,	37,	32,	6,	39},
{7,	39,	39,	29,	6},
{11,	39,	39,	5,	7},
{7,	29,	27,	39,	39},
{9,	28,	31,	37,	39},
{8,	39,	21,	39,	39},
{7,	34,	35,	31,	39},
{7,	36,	28,	31,	39},
{7,	39,	39,	39,	4},
{7,	39,	29,	25,	39},
{7,	37,	31,	21,	39},
{7,	39,	36,	39,	21},
{7,	31,	27,	38,	39},
{8,	32,	24,	38,	39},
{8,	30,	28,	37,	39},
{8,	39,	22,	39,	39},
{7,	39,	33,	3,	39},
{7,	39,	33,	10,	37},
{7,	37,	34,	5,	39},
{7,	38,	37,	1,	39},
{7,	37,	38,	3,	39},
{7,	39,	36,	38,	22},
{8,	39,	34,	38,	24},
{7,	37,	33,	6,	39},
{7,	31,	28,	37,	39},
{7,	39,	28,	29,	39},
{7,	39,	37,	38,	13},
{7,	39,	39,	6,	7},
{7,	37,	39,	1,	39},
{6,	36,	39,	39,	39},
{6,	39,	38,	39,	37},
{7,	39,	35,	0,	38},
{6,	39,	39,	38,	24},
{7,	39,	39,	3,	25},
{6,	37,	39,	23,	39},
{6,	39,	36,	36,	38},
{6,	39,	34,	12,	39},
{9,	38,	35,	3,	39},
{7,	38,	35,	6,	39},
{7,	39,	35,	0,	39},
{6,	39,	30,	31,	39},
{7,	39,	29,	32,	39},
{6,	39,	29,	34,	39},
{6,	39,	39,	7,	25},
{6,	39,	28,	36,	39},
{6,	39,	39,	0,	28},
{5,	38,	39,	39,	39},
{6,	39,	33,	15,	39},
{5,	39,	39,	39,	34},
{5,	39,	38,	39,	38},
{5,	39,	37,	10,	39},
{6,	39,	38,	0,	39},
{5,	39,	33,	29,	39},
{5,	39,	38,	4,	39},
{4,	39,	39,	39,	39}};

static BtkLookupTable DefaultTable3700pop5 = { 
    sizeof(DefaultParam3700pop5Entries)/ sizeof(DefaultParam3700pop5Entries[0]),
    DefaultParam3700pop5Entries, 
    sizeof(DefaultTable3700pop5Entries)/ sizeof(DefaultTable3700pop5Entries[0]),
    DefaultTable3700pop5Entries 
};

BtkLookupTable *  
Btk_get_3700pop5_table(void) 
{ 
    return &DefaultTable3700pop5; 
}


static TraceParamEntry DefaultParam3700pop6Entries[] = {
/*   phr3_t            phr7_t             psr_t              pres_t  */
{0.001562500000000, 0.001562500000000, 1.184659090909091, 0.020810789442626},
{0.028353089285710, 0.064705653637827, 1.275252525252526, 0.030740829754654},
{0.046711443782112, 0.105363362369955, 1.303846153846154, 0.037194844435056},
{0.062329167050785, 0.135492091190261, 1.369318181818182, 0.042264811922103},
{0.075441979689763, 0.159675303608889, 1.405882352941176, 0.046615680260770},
{0.086984598796127, 0.180789986092878, 1.447222222222222, 0.050466534799575},
{0.097562586078877, 0.200298630563661, 1.510869565217392, 0.053966135689439},
{0.107784453789058, 0.219206751176590, 1.559027777777778, 0.057212893255268},
{0.117768278090337, 0.237837523118993, 1.607692307692307, 0.060266253593409},
{0.127700233892705, 0.256953327347392, 1.630681818181818, 0.063189784439105},
{0.137614137980992, 0.276642046740125, 1.679487179487180, 0.066007184637824},
{0.147746420657286, 0.297324264199749, 1.720779220779221, 0.068749036834001},
{0.158267880348340, 0.319320991879722, 1.759615384615385, 0.071427380966325},
{0.169197627762390, 0.343023073675901, 1.781746031746032, 0.074072637792753},
{0.180683852486397, 0.368636848233494, 1.861904761904762, 0.076693685845344},
{0.192771105606936, 0.396436335856937, 1.881944444444445, 0.079304522327698},
{0.205535383527183, 0.426849284415619, 1.894444444444445, 0.081919841543084},
{0.219071388174969, 0.460265119269550, 2.025000000000000, 0.084550970079756},
{0.233448934418499, 0.496920085983560, 2.133928571428572, 0.087212485401258},
{0.248792815706079, 0.536683783909963, 2.148351648351649, 0.089911569690640},
{0.265226153106161, 0.580036013549081, 2.261363636363637, 0.092663999538135},
{0.282905621250473, 0.626704626987155, 2.292857142857143, 0.095488685693490},
{0.301927927500013, 0.676429102635395, 2.345238095238095, 0.098399559383629},
{0.322583306767116, 0.728767501274685, 2.436507936507937, 0.101411186808747},
{0.344902336451092, 0.783917130115990, 2.519230769230769, 0.104563533003588},
{0.369206637877968, 0.841355517740375, 2.607692307692307, 0.107877080705813},
{0.395759539975860, 0.901293542044251, 2.679487179487180, 0.111404685173198},
{0.424822519225174, 0.964127236550866, 2.809090909090909, 0.115211759718641},
{0.456703529923560, 1.026376400410880, 2.866071428571428, 0.119412659703430},
{0.491935577070693, 1.098980059503328, 3.035714285714286, 0.124084808541466},
{0.530850677183830, 1.179827387431921, 3.211111111111111, 0.129360332200720},
{0.574543144794342, 1.271193410761383, 3.405882352941177, 0.135380803219113},
{0.623726422962637, 1.377048913869656, 3.605555555555556, 0.142391406809672},
{0.679577030141760, 1.503345166268247, 3.839743589743589, 0.150921329879935},
{0.744820792984539, 1.662369839952990, 4.261363636363636, 0.161742367845043},
{0.823099508129256, 1.875055823199285, 4.759615384615385, 0.175859965644843},
{0.922035222823721, 2.181761056276527, 5.679487179487180, 0.194174542578769},
{1.058319112845616, 2.693246355487178, 7.348484848484848, 0.220162294391546},
{1.359496701120311, 3.871039251922288, 11.062500000000000, 0.266926456861402},
{123.920896495380489, 284.000000000000000, 100.000000000000000, 12.439673315911705}};

static BtkLookupEntry DefaultTable3700pop6Entries[] = {
/* qv ind1 ind2 ind3 ind4 */
{36,	1,	17,	0,	5},
{35,	5,	17,	0,	15},
{38,	8,	17,	0,	9},
{35,	17,	8,	0,	5},
{34,	10,	15,	2,	8},
{39,	17,	8,	2,	8},
{35,	11,	17,	1,	4},
{34,	11,	17,	0,	26},
{36,	39,	7,	0,	26},
{33,	19,	12,	2,	28},
{37,	9,	15,	2,	11},
{37,	10,	14,	1,	18},
{37,	1,	14,	1,	28},
{35,	0,	15,	1,	28},
{34,	20,	11,	0,	32},
{35,	11,	17,	0,	30},
{34,	21,	12,	2,	10},
{33,	5,	17,	0,	35},
{33,	18,	16,	0,	27},
{36,	16,	15,	2,	7},
{34,	20,	16,	0,	24},
{33,	16,	13,	2,	21},
{34,	12,	14,	1,	28},
{33,	0,	16,	1,	16},
{33,	8,	19,	1,	3},
{35,	3,	23,	0,	8},
{35,	11,	18,	0,	29},
{33,	5,	19,	2,	5},
{33,	16,	16,	2,	7},
{32,	14,	12,	10,	24},
{39,	2,	13,	4,	14},
{39,	18,	12,	3,	24},
{37,	15,	12,	5,	16},
{36,	13,	13,	3,	21},
{35,	19,	12,	4,	6},
{34,	15,	10,	9,	15},
{34,	16,	7,	8,	16},
{34,	39,	9,	5,	10},
{32,	8,	9,	4,	29},
{35,	12,	7,	4,	28},
{34,	7,	13,	3,	25},
{35,	7,	13,	2,	29},
{33,	7,	14,	2,	29},
{34,	0,	15,	2,	28},
{33,	10,	10,	4,	26},
{33,	5,	14,	3,	27},
{34,	16,	14,	3,	10},
{32,	4,	13,	2,	30},
{32,	0,	18,	1,	28},
{33,	0,	16,	2,	22},
{32,	0,	15,	3,	27},
{33,	17,	15,	4,	2},
{32,	14,	13,	6,	12},
{33,	16,	14,	4,	8},
{33,	11,	13,	4,	21},
{33,	17,	13,	3,	23},
{33,	13,	15,	4,	5},
{32,	18,	9,	4,	24},
{33,	18,	12,	4,	17},
{32,	17,	13,	5,	10},
{32,	19,	15,	0,	31},
{32,	7,	19,	2,	7},
{32,	23,	15,	2,	2},
{32,	20,	11,	0,	33},
{31,	18,	9,	8,	26},
{35,	17,	10,	9,	15},
{33,	19,	11,	6,	14},
{35,	18,	11,	9,	14},
{33,	15,	9,	10,	24},
{33,	18,	12,	3,	27},
{33,	18,	13,	6,	6},
{32,	16,	11,	10,	11},
{32,	13,	11,	4,	26},
{33,	9,	11,	6,	25},
{31,	21,	12,	2,	32},
{32,	21,	13,	1,	24},
{31,	39,	7,	10,	25},
{31,	10,	13,	10,	9},
{33,	8,	13,	8,	12},
{32,	13,	13,	9,	10},
{31,	7,	19,	3,	7},
{31,	3,	17,	3,	12},
{31,	10,	17,	4,	3},
{31,	22,	12,	2,	29},
{31,	39,	13,	0,	33},
{33,	39,	14,	1,	10},
{31,	18,	11,	10,	11},
{31,	9,	12,	6,	25},
{31,	39,	9,	7,	15},
{31,	39,	14,	0,	30},
{30,	12,	15,	10,	30},
{34,	4,	16,	4,	11},
{33,	4,	16,	2,	30},
{33,	13,	13,	10,	22},
{32,	17,	14,	5,	17},
{33,	13,	14,	10,	19},
{32,	4,	16,	4,	23},
{33,	4,	17,	3,	18},
{32,	6,	17,	10,	0},
{32,	13,	15,	8,	14},
{34,	18,	15,	1,	24},
{33,	18,	14,	3,	24},
{32,	14,	14,	8,	22},
{33,	15,	14,	10,	6},
{32,	17,	13,	10,	6},
{31,	4,	5,	4,	31},
{31,	8,	15,	2,	32},
{31,	9,	17,	4,	6},
{31,	2,	7,	4,	31},
{32,	2,	15,	3,	31},
{31,	6,	18,	1,	27},
{32,	13,	16,	4,	9},
{31,	16,	11,	3,	30},
{31,	23,	14,	1,	22},
{30,	39,	7,	15,	10},
{32,	39,	7,	16,	0},
{32,	39,	0,	16,	1},
{30,	22,	13,	2,	34},
{33,	20,	15,	1,	28},
{32,	13,	14,	5,	28},
{32,	13,	7,	10,	30},
{32,	8,	15,	2,	34},
{31,	15,	7,	10,	29},
{31,	22,	12,	0,	35},
{31,	13,	12,	10,	27},
{30,	12,	17,	7,	21},
{35,	20,	16,	1,	27},
{33,	7,	16,	7,	23},
{33,	16,	16,	10,	1},
{32,	7,	16,	5,	25},
{31,	0,	16,	3,	31},
{31,	14,	16,	2,	27},
{31,	13,	15,	6,	27},
{30,	2,	18,	5,	22},
{33,	7,	18,	4,	22},
{32,	2,	17,	2,	31},
{30,	16,	17,	4,	17},
{33,	16,	17,	5,	13},
{32,	16,	17,	6,	6},
{32,	16,	18,	0,	27},
{32,	16,	17,	3,	22},
{31,	15,	20,	0,	27},
{31,	2,	19,	2,	17},
{32,	7,	19,	4,	10},
{31,	15,	19,	4,	2},
{32,	14,	19,	1,	13},
{31,	18,	16,	2,	24},
{30,	20,	19,	0,	22},
{32,	17,	18,	1,	21},
{31,	24,	17,	0,	11},
{31,	21,	15,	1,	30},
{31,	20,	19,	1,	7},
{30,	7,	10,	4,	31},
{32,	15,	13,	3,	31},
{30,	2,	20,	1,	15},
{30,	13,	21,	0,	25},
{30,	0,	18,	3,	27},
{32,	0,	17,	4,	27},
{31,	6,	17,	5,	26},
{30,	17,	17,	7,	2},
{30,	17,	9,	8,	27},
{32,	14,	12,	10,	27},
{30,	11,	20,	0,	31},
{30,	39,	9,	4,	26},
{31,	20,	10,	3,	31},
{30,	7,	9,	15,	0},
{30,	39,	15,	1,	11},
{30,	8,	29,	0,	3},
{30,	3,	24,	2,	5},
{31,	4,	21,	3,	5},
{31,	3,	22,	1,	10},
{31,	4,	21,	3,	12},
{32,	2,	20,	4,	13},
{31,	3,	23,	2,	10},
{30,	1,	21,	2,	31},
{33,	0,	19,	3,	27},
{30,	8,	19,	3,	19},
{30,	10,	21,	1,	15},
{31,	8,	25,	2,	4},
{30,	17,	19,	1,	21},
{30,	19,	11,	9,	11},
{30,	17,	17,	3,	20},
{29,	16,	11,	16,	28},
{32,	16,	11,	8,	30},
{32,	17,	9,	12,	27},
{33,	18,	9,	10,	28},
{32,	17,	13,	4,	25},
{33,	18,	11,	5,	30},
{32,	14,	12,	11,	13},
{31,	17,	11,	12,	19},
{31,	18,	12,	5,	28},
{31,	18,	10,	10,	25},
{31,	16,	15,	5,	22},
{31,	17,	11,	8,	30},
{30,	17,	13,	8,	23},
{33,	16,	14,	10,	11},
{31,	18,	13,	10,	9},
{31,	17,	14,	6,	22},
{30,	16,	15,	7,	19},
{30,	16,	12,	10,	28},
{30,	15,	11,	10,	30},
{30,	1,	12,	12,	4},
{30,	17,	17,	7,	4},
{29,	22,	12,	7,	32},
{31,	13,	14,	4,	31},
{31,	19,	12,	8,	30},
{31,	20,	13,	13,	0},
{30,	7,	15,	4,	32},
{30,	22,	13,	7,	3},
{30,	19,	12,	11,	8},
{29,	1,	15,	13,	13},
{31,	18,	14,	15,	0},
{30,	17,	13,	12,	14},
{33,	8,	15,	13,	7},
{31,	15,	14,	10,	22},
{31,	18,	13,	9,	19},
{31,	7,	15,	12,	14},
{30,	14,	12,	13,	13},
{29,	2,	18,	7,	19},
{29,	20,	10,	15,	24},
{31,	39,	9,	10,	30},
{30,	20,	12,	10,	14},
{30,	19,	10,	16,	25},
{29,	2,	24,	2,	23},
{33,	3,	25,	0,	31},
{32,	0,	23,	2,	28},
{30,	2,	28,	0,	31},
{29,	22,	17,	2,	24},
{31,	10,	17,	5,	26},
{30,	26,	17,	0,	17},
{29,	7,	19,	4,	23},
{29,	0,	16,	6,	27},
{29,	2,	21,	4,	10},
{29,	2,	27,	0,	34},
{29,	12,	16,	6,	25},
{29,	8,	16,	11,	2},
{29,	17,	13,	4,	31},
{29,	16,	16,	6,	13},
{29,	12,	18,	3,	14},
{29,	20,	13,	3,	31},
{29,	22,	14,	2,	30},
{29,	22,	16,	2,	27},
{29,	2,	25,	2,	11},
{29,	15,	13,	11,	17},
{29,	12,	14,	12,	10},
{28,	39,	10,	19,	23},
{29,	0,	1,	22,	0},
{28,	19,	12,	8,	33},
{31,	22,	12,	7,	33},
{29,	7,	14,	8,	32},
{31,	8,	15,	8,	31},
{29,	13,	13,	6,	32},
{28,	19,	12,	10,	32},
{31,	9,	14,	10,	31},
{30,	39,	10,	14,	27},
{28,	22,	12,	2,	36},
{31,	7,	20,	0,	36},
{29,	1,	2,	0,	37},
{28,	15,	17,	10,	24},
{33,	2,	18,	8,	15},
{32,	16,	15,	6,	26},
{31,	17,	16,	6,	20},
{30,	17,	17,	7,	9},
{30,	16,	17,	7,	20},
{29,	2,	18,	8,	23},
{29,	11,	16,	12,	6},
{30,	15,	15,	13,	3},
{31,	11,	15,	13,	10},
{29,	17,	14,	6,	27},
{30,	17,	13,	6,	32},
{29,	16,	14,	7,	29},
{32,	15,	15,	10,	27},
{31,	18,	13,	7,	30},
{30,	17,	13,	9,	31},
{29,	22,	13,	5,	30},
{29,	0,	16,	7,	27},
{29,	17,	16,	9,	9},
{29,	2,	16,	13,	6},
{29,	5,	18,	9,	4},
{28,	15,	12,	13,	29},
{29,	15,	13,	12,	23},
{31,	6,	15,	12,	16},
{31,	7,	14,	12,	20},
{29,	7,	15,	13,	15},
{29,	7,	14,	11,	26},
{28,	23,	18,	4,	27},
{33,	20,	15,	5,	27},
{32,	18,	15,	9,	10},
{31,	14,	19,	2,	25},
{31,	14,	19,	4,	11},
{31,	3,	18,	8,	24},
{31,	39,	12,	5,	32},
{30,	39,	14,	3,	12},
{30,	20,	20,	2,	3},
{31,	12,	21,	1,	25},
{30,	18,	15,	6,	24},
{29,	26,	17,	2,	26},
{31,	39,	15,	3,	24},
{31,	24,	15,	4,	23},
{30,	25,	15,	4,	23},
{29,	0,	20,	4,	28},
{30,	4,	16,	4,	31},
{29,	4,	21,	3,	27},
{29,	2,	21,	4,	21},
{29,	11,	16,	4,	30},
{29,	18,	17,	7,	6},
{30,	20,	16,	9,	2},
{29,	39,	17,	0,	22},
{29,	27,	18,	2,	13},
{29,	26,	19,	1,	18},
{29,	22,	19,	4,	3},
{29,	10,	20,	4,	7},
{29,	22,	15,	4,	28},
{29,	18,	14,	6,	30},
{29,	24,	14,	3,	30},
{29,	18,	22,	2,	2},
{29,	12,	19,	4,	19},
{28,	20,	19,	4,	21},
{30,	14,	19,	4,	26},
{29,	19,	19,	4,	24},
{29,	25,	19,	2,	15},
{29,	9,	20,	3,	24},
{29,	10,	20,	4,	19},
{29,	14,	20,	4,	13},
{30,	13,	21,	2,	19},
{30,	13,	22,	2,	11},
{29,	15,	22,	0,	25},
{29,	26,	19,	0,	26},
{28,	13,	18,	4,	30},
{32,	19,	17,	0,	34},
{30,	22,	16,	2,	30},
{29,	16,	15,	2,	34},
{29,	21,	16,	2,	31},
{28,	13,	21,	1,	33},
{32,	14,	17,	2,	34},
{30,	3,	22,	1,	34},
{28,	25,	21,	0,	28},
{30,	26,	17,	0,	32},
{29,	18,	22,	2,	9},
{29,	22,	15,	2,	33},
{29,	16,	20,	4,	13},
{28,	3,	22,	3,	28},
{28,	4,	14,	13,	21},
{28,	3,	17,	7,	27},
{28,	15,	12,	15,	3},
{28,	11,	16,	5,	31},
{29,	5,	16,	6,	29},
{28,	11,	16,	10,	28},
{31,	12,	16,	9,	29},
{29,	13,	17,	7,	26},
{29,	2,	17,	7,	28},
{28,	3,	18,	6,	28},
{28,	4,	16,	7,	31},
{28,	1,	14,	0,	37},
{28,	22,	13,	8,	6},
{28,	10,	13,	13,	22},
{28,	8,	32,	2,	0},
{28,	3,	16,	16,	0},
{28,	3,	18,	5,	30},
{29,	5,	17,	6,	30},
{28,	20,	12,	12,	9},
{28,	39,	11,	16,	2},
{28,	39,	11,	12,	9},
{28,	20,	10,	12,	29},
{28,	23,	14,	5,	15},
{28,	19,	17,	6,	6},
{28,	5,	21,	4,	22},
{28,	23,	16,	1,	33},
{28,	19,	20,	1,	19},
{28,	22,	16,	3,	30},
{28,	3,	17,	10,	25},
{27,	20,	12,	10,	34},
{28,	22,	12,	7,	34},
{28,	39,	11,	8,	34},
{27,	1,	21,	10,	22},
{30,	4,	20,	8,	8},
{32,	5,	18,	10,	22},
{29,	0,	19,	6,	28},
{29,	6,	19,	8,	9},
{30,	14,	20,	5,	4},
{29,	1,	18,	10,	24},
{29,	1,	19,	8,	24},
{28,	17,	18,	8,	1},
{29,	13,	19,	6,	4},
{29,	11,	18,	10,	4},
{28,	2,	21,	9,	18},
{28,	15,	19,	6,	21},
{31,	9,	18,	6,	29},
{30,	8,	18,	10,	16},
{29,	19,	18,	6,	6},
{29,	14,	18,	6,	26},
{29,	15,	17,	7,	27},
{29,	14,	19,	5,	27},
{29,	11,	20,	5,	19},
{28,	17,	19,	6,	17},
{28,	17,	18,	5,	27},
{28,	12,	19,	7,	6},
{28,	9,	18,	8,	22},
{27,	3,	12,	4,	36},
{32,	8,	5,	4,	36},
{27,	3,	24,	4,	22},
{31,	5,	25,	4,	5},
{28,	5,	23,	4,	18},
{28,	18,	22,	1,	18},
{29,	13,	22,	2,	23},
{28,	18,	22,	2,	16},
{27,	24,	17,	0,	38},
{29,	3,	24,	0,	37},
{28,	39,	13,	1,	35},
{28,	16,	16,	1,	36},
{30,	6,	22,	1,	35},
{29,	16,	16,	2,	35},
{29,	2,	17,	2,	36},
{27,	0,	1,	25,	0},
{27,	15,	13,	13,	26},
{27,	5,	13,	8,	34},
{28,	17,	13,	7,	33},
{27,	17,	14,	5,	34},
{29,	3,	14,	4,	35},
{28,	17,	16,	3,	32},
{27,	21,	13,	7,	30},
{28,	22,	13,	6,	31},
{28,	21,	14,	6,	13},
{28,	22,	14,	8,	6},
{28,	19,	14,	10,	8},
{28,	18,	15,	10,	10},
{27,	19,	21,	2,	24},
{28,	19,	20,	1,	28},
{28,	17,	19,	5,	27},
{29,	21,	19,	3,	26},
{27,	18,	23,	1,	23},
{29,	12,	29,	0,	9},
{27,	28,	17,	2,	26},
{29,	39,	18,	0,	28},
{27,	2,	17,	10,	28},
{27,	0,	19,	8,	28},
{27,	14,	19,	7,	11},
{28,	15,	18,	7,	15},
{27,	9,	25,	3,	9},
{28,	16,	22,	3,	7},
{28,	6,	21,	9,	3},
{28,	7,	21,	5,	19},
{28,	7,	21,	7,	11},
{30,	11,	20,	6,	15},
{28,	8,	25,	4,	7},
{27,	14,	15,	10,	30},
{28,	18,	15,	6,	29},
{27,	39,	12,	6,	30},
{28,	39,	12,	11,	5},
{27,	39,	14,	6,	18},
{27,	9,	17,	7,	30},
{28,	10,	17,	10,	28},
{27,	17,	20,	4,	17},
{27,	19,	20,	4,	15},
{28,	19,	20,	3,	24},
{27,	3,	25,	4,	11},
{27,	6,	23,	0,	38},
{27,	16,	16,	3,	33},
{27,	8,	16,	4,	33},
{27,	22,	14,	5,	30},
{27,	19,	15,	6,	29},
{27,	1,	19,	9,	26},
{27,	39,	11,	16,	6},
{28,	19,	13,	13,	6},
{27,	39,	13,	16,	0},
{27,	11,	17,	9,	29},
{27,	0,	19,	8,	29},
{28,	4,	21,	3,	30},
{27,	9,	22,	7,	0},
{27,	19,	22,	1,	24},
{27,	19,	13,	7,	33},
{27,	22,	13,	5,	34},
{27,	22,	16,	3,	32},
{27,	14,	21,	2,	28},
{27,	6,	21,	2,	32},
{27,	39,	9,	16,	28},
{27,	23,	13,	9,	7},
{28,	39,	12,	7,	29},
{27,	15,	17,	11,	3},
{27,	9,	29,	0,	16},
{28,	9,	24,	2,	23},
{27,	17,	28,	0,	24},
{28,	15,	24,	1,	23},
{27,	13,	24,	0,	33},
{28,	19,	22,	1,	28},
{27,	11,	24,	0,	38},
{26,	19,	15,	16,	31},
{30,	20,	11,	16,	31},
{29,	17,	16,	10,	20},
{28,	20,	12,	16,	25},
{27,	17,	17,	8,	27},
{29,	17,	16,	10,	27},
{28,	17,	18,	6,	26},
{27,	4,	16,	10,	31},
{27,	17,	17,	10,	18},
{28,	18,	17,	10,	7},
{29,	20,	16,	5,	27},
{28,	19,	17,	9,	7},
{27,	17,	16,	6,	30},
{27,	19,	16,	5,	31},
{27,	18,	14,	7,	32},
{27,	18,	19,	5,	19},
{26,	17,	13,	19,	28},
{31,	20,	11,	17,	27},
{29,	39,	12,	19,	2},
{26,	25,	17,	7,	32},
{30,	18,	17,	9,	28},
{30,	13,	18,	3,	33},
{29,	39,	15,	6,	10},
{29,	21,	17,	8,	12},
{29,	19,	18,	6,	18},
{28,	19,	21,	1,	31},
{29,	20,	18,	4,	30},
{28,	28,	17,	3,	21},
{28,	39,	13,	5,	34},
{28,	19,	15,	5,	33},
{28,	7,	15,	9,	32},
{28,	20,	20,	5,	4},
{29,	21,	18,	5,	27},
{29,	21,	18,	6,	18},
{29,	21,	19,	5,	19},
{28,	19,	18,	4,	31},
{28,	24,	18,	2,	30},
{28,	24,	18,	4,	23},
{28,	7,	18,	5,	32},
{27,	25,	21,	1,	23},
{30,	22,	20,	4,	15},
{28,	26,	21,	1,	18},
{28,	23,	20,	4,	8},
{28,	24,	19,	4,	21},
{28,	25,	19,	4,	12},
{28,	26,	21,	0,	30},
{27,	21,	18,	6,	29},
{27,	21,	19,	6,	17},
{27,	28,	17,	2,	32},
{27,	19,	16,	10,	25},
{27,	39,	15,	5,	27},
{29,	39,	15,	7,	16},
{27,	25,	20,	2,	16},
{27,	16,	20,	3,	28},
{26,	1,	26,	7,	22},
{29,	0,	26,	1,	27},
{29,	3,	23,	6,	21},
{28,	3,	27,	2,	7},
{28,	7,	23,	6,	8},
{28,	9,	28,	5,	0},
{28,	3,	28,	7,	0},
{28,	0,	25,	1,	30},
{27,	1,	27,	6,	6},
{27,	5,	24,	9,	0},
{27,	3,	22,	8,	16},
{27,	7,	25,	4,	13},
{28,	7,	23,	6,	14},
{27,	9,	23,	5,	9},
{27,	11,	23,	4,	8},
{27,	14,	19,	7,	15},
{28,	4,	23,	7,	19},
{29,	7,	22,	7,	17},
{26,	1,	20,	13,	26},
{31,	14,	17,	12,	7},
{28,	0,	20,	8,	28},
{28,	1,	17,	11,	29},
{29,	6,	16,	12,	27},
{28,	7,	18,	12,	10},
{27,	2,	16,	15,	17},
{27,	1,	21,	8,	26},
{27,	12,	16,	12,	15},
{27,	1,	17,	13,	27},
{26,	39,	1,	22,	5},
{27,	4,	6,	20,	1},
{27,	39,	3,	21,	1},
{26,	0,	20,	2,	37},
{27,	11,	20,	2,	34},
{27,	1,	22,	1,	37},
{26,	39,	2,	24,	3},
{27,	3,	2,	22,	5},
{26,	24,	14,	4,	35},
{30,	15,	7,	4,	36},
{30,	23,	17,	2,	34},
{28,	23,	17,	2,	35},
{27,	24,	15,	5,	34},
{27,	4,	14,	4,	36},
{26,	22,	14,	11,	24},
{28,	20,	17,	9,	16},
{29,	21,	16,	8,	29},
{27,	20,	15,	10,	30},
{27,	20,	17,	10,	15},
{27,	21,	12,	13,	24},
{26,	3,	14,	19,	13},
{26,	13,	15,	17,	16},
{29,	14,	14,	18,	15},
{28,	6,	15,	19,	3},
{28,	14,	14,	19,	13},
{26,	14,	14,	17,	27},
{26,	1,	27,	5,	22},
{27,	1,	27,	6,	14},
{26,	1,	29,	4,	16},
{26,	4,	34,	0,	31},
{27,	0,	30,	1,	24},
{27,	2,	29,	2,	22},
{26,	1,	23,	8,	21},
{26,	7,	16,	10,	32},
{26,	22,	23,	0,	31},
{28,	22,	23,	1,	18},
{26,	20,	17,	5,	33},
{28,	7,	16,	5,	34},
{26,	10,	20,	4,	33},
{29,	6,	19,	5,	33},
{26,	7,	21,	5,	32},
{28,	1,	20,	8,	29},
{27,	12,	20,	5,	27},
{29,	22,	20,	5,	9},
{27,	16,	20,	6,	14},
{28,	20,	20,	6,	8},
{26,	15,	20,	7,	26},
{29,	5,	21,	6,	28},
{27,	13,	20,	9,	9},
{28,	16,	19,	9,	5},
{28,	16,	20,	7,	14},
{28,	9,	20,	8,	20},
{27,	20,	18,	7,	21},
{28,	18,	20,	8,	4},
{27,	3,	22,	7,	24},
{27,	16,	19,	9,	10},
{27,	1,	22,	4,	28},
{26,	0,	24,	4,	30},
{27,	1,	25,	6,	23},
{27,	14,	22,	2,	30},
{27,	1,	22,	5,	30},
{26,	1,	20,	10,	29},
{26,	2,	19,	7,	31},
{27,	2,	20,	7,	30},
{26,	9,	22,	5,	29},
{29,	11,	22,	3,	31},
{28,	5,	22,	7,	25},
{28,	7,	22,	3,	33},
{27,	0,	23,	6,	25},
{27,	1,	22,	5,	32},
{26,	12,	17,	12,	18},
{26,	0,	36,	1,	7},
{26,	23,	16,	8,	23},
{26,	7,	16,	4,	35},
{26,	17,	21,	3,	24},
{26,	10,	24,	2,	30},
{27,	2,	24,	5,	29},
{26,	4,	23,	6,	28},
{26,	8,	23,	5,	29},
{27,	9,	24,	4,	20},
{27,	8,	23,	6,	17},
{26,	11,	24,	3,	30},
{26,	11,	23,	4,	30},
{27,	15,	20,	4,	30},
{27,	11,	23,	5,	13},
{27,	10,	22,	6,	13},
{27,	9,	21,	8,	13},
{26,	15,	21,	4,	24},
{29,	15,	22,	6,	3},
{29,	13,	23,	5,	9},
{27,	20,	23,	2,	7},
{27,	19,	23,	2,	18},
{26,	15,	20,	6,	29},
{27,	15,	19,	6,	30},
{26,	9,	25,	4,	22},
{27,	13,	25,	2,	24},
{27,	4,	29,	1,	26},
{27,	14,	24,	2,	30},
{26,	8,	23,	6,	27},
{27,	9,	22,	7,	20},
{26,	5,	14,	6,	34},
{26,	0,	17,	6,	33},
{26,	6,	16,	8,	33},
{27,	5,	14,	8,	34},
{26,	3,	5,	23,	1},
{27,	3,	8,	21,	1},
{27,	15,	9,	21,	0},
{27,	39,	5,	25,	0},
{26,	20,	11,	19,	25},
{26,	7,	22,	2,	35},
{26,	23,	15,	4,	35},
{26,	7,	19,	9,	24},
{26,	14,	20,	9,	15},
{26,	20,	18,	8,	21},
{28,	20,	18,	9,	16},
{27,	21,	18,	8,	15},
{26,	7,	19,	3,	34},
{26,	16,	17,	3,	35},
{26,	28,	18,	3,	12},
{27,	39,	18,	1,	17},
{26,	15,	36,	2,	0},
{26,	3,	25,	1,	32},
{26,	23,	14,	10,	9},
{26,	39,	14,	3,	35},
{26,	25,	16,	1,	36},
{26,	39,	18,	3,	10},
{26,	19,	23,	2,	24},
{26,	17,	22,	3,	24},
{27,	14,	22,	4,	24},
{27,	14,	22,	5,	18},
{26,	3,	18,	13,	20},
{28,	15,	16,	13,	6},
{28,	12,	16,	16,	3},
{27,	12,	16,	13,	15},
{27,	19,	16,	13,	4},
{26,	3,	16,	16,	16},
{26,	7,	17,	13,	18},
{26,	6,	26,	3,	22},
{26,	22,	12,	9,	30},
{27,	39,	11,	12,	27},
{27,	22,	12,	11,	30},
{27,	39,	11,	10,	33},
{27,	21,	14,	11,	31},
{27,	21,	12,	13,	31},
{26,	21,	11,	17,	27},
{26,	16,	31,	0,	14},
{26,	20,	13,	17,	4},
{27,	20,	14,	13,	31},
{27,	21,	14,	13,	16},
{26,	20,	15,	12,	29},
{26,	13,	21,	4,	31},
{26,	16,	19,	5,	31},
{27,	10,	18,	7,	31},
{26,	15,	20,	5,	32},
{26,	15,	20,	4,	33},
{27,	19,	18,	4,	33},
{27,	21,	20,	1,	33},
{26,	24,	19,	1,	31},
{26,	25,	19,	2,	26},
{26,	10,	21,	7,	22},
{26,	12,	21,	9,	5},
{26,	17,	21,	6,	4},
{26,	17,	21,	4,	23},
{26,	17,	21,	6,	14},
{26,	19,	21,	4,	15},
{27,	19,	22,	3,	21},
{26,	15,	22,	6,	8},
{26,	7,	25,	2,	30},
{26,	1,	25,	3,	29},
{26,	2,	21,	8,	27},
{26,	18,	16,	2,	36},
{25,	14,	8,	24,	24},
{29,	12,	9,	21,	5},
{28,	16,	8,	21,	24},
{26,	17,	8,	24,	6},
{25,	21,	11,	7,	37},
{31,	21,	15,	5,	35},
{27,	13,	12,	7,	35},
{27,	12,	16,	2,	37},
{27,	4,	12,	6,	36},
{26,	13,	15,	3,	36},
{26,	8,	20,	2,	37},
{25,	17,	12,	16,	33},
{28,	21,	12,	13,	32},
{27,	7,	13,	13,	32},
{27,	7,	13,	12,	33},
{27,	6,	14,	10,	33},
{25,	16,	12,	10,	35},
{26,	39,	9,	10,	35},
{25,	15,	11,	4,	38},
{31,	12,	15,	2,	38},
{26,	8,	18,	1,	38},
{26,	39,	8,	4,	38},
{25,	12,	9,	19,	29},
{26,	12,	11,	17,	29},
{25,	2,	23,	10,	19},
{27,	6,	19,	12,	8},
{26,	10,	19,	10,	18},
{26,	10,	20,	10,	12},
{26,	7,	21,	10,	12},
{25,	12,	12,	21,	15},
{28,	9,	13,	21,	3},
{26,	17,	9,	21,	15},
{25,	11,	16,	16,	27},
{25,	14,	19,	13,	18},
{29,	11,	20,	12,	9},
{27,	14,	17,	13,	20},
{27,	4,	20,	13,	20},
{26,	18,	18,	10,	17},
{28,	18,	19,	11,	4},
{26,	15,	20,	11,	5},
{26,	14,	20,	8,	22},
{26,	15,	16,	12,	23},
{28,	19,	17,	11,	18},
{28,	19,	16,	12,	17},
{26,	14,	20,	13,	5},
{26,	15,	20,	13,	4},
{26,	16,	18,	13,	6},
{25,	24,	14,	13,	18},
{27,	39,	14,	9,	19},
{27,	39,	14,	11,	13},
{27,	22,	12,	16,	15},
{27,	39,	11,	19,	17},
{26,	24,	14,	11,	26},
{28,	39,	12,	11,	32},
{27,	24,	14,	12,	23},
{26,	39,	14,	8,	31},
{25,	4,	8,	26,	1},
{25,	9,	4,	26,	3},
{25,	2,	8,	27,	2},
{25,	20,	15,	7,	34},
{28,	5,	16,	7,	34},
{28,	23,	15,	6,	34},
{25,	4,	33,	2,	22},
{28,	1,	36,	1,	16},
{26,	1,	30,	4,	11},
{28,	1,	31,	4,	6},
{26,	4,	31,	4,	6},
{27,	4,	29,	3,	19},
{25,	20,	20,	6,	22},
{27,	19,	21,	6,	15},
{26,	23,	20,	4,	17},
{25,	21,	20,	7,	17},
{26,	22,	20,	7,	10},
{26,	18,	19,	10,	11},
{26,	18,	20,	7,	21},
{25,	11,	15,	17,	25},
{25,	14,	14,	19,	26},
{25,	12,	16,	19,	3},
{25,	21,	15,	6,	35},
{25,	0,	19,	7,	33},
{27,	15,	19,	6,	32},
{25,	4,	23,	7,	28},
{27,	2,	23,	8,	23},
{26,	10,	21,	7,	27},
{25,	22,	23,	0,	36},
{26,	16,	22,	1,	34},
{26,	9,	23,	3,	32},
{26,	3,	24,	4,	31},
{25,	1,	17,	13,	29},
{26,	3,	16,	13,	30},
{25,	39,	16,	4,	27},
{27,	27,	16,	6,	6},
{25,	11,	15,	18,	19},
{25,	11,	15,	3,	38},
{28,	9,	12,	4,	38},
{25,	3,	29,	4,	22},
{26,	3,	27,	6,	9},
{27,	2,	25,	7,	23},
{25,	18,	14,	7,	35},
{25,	24,	14,	11,	31},
{25,	7,	15,	13,	32},
{25,	6,	19,	10,	29},
{26,	7,	18,	8,	32},
{27,	6,	18,	9,	31},
{26,	14,	20,	8,	25},
{26,	14,	18,	10,	23},
{26,	18,	17,	8,	31},
{25,	6,	18,	10,	32},
{25,	9,	13,	18,	29},
{25,	29,	18,	1,	31},
{26,	28,	18,	2,	30},
{27,	26,	19,	2,	28},
{26,	23,	19,	4,	27},
{26,	19,	19,	3,	33},
{26,	19,	20,	3,	30},
{27,	22,	20,	2,	30},
{25,	2,	14,	10,	34},
{25,	20,	14,	15,	31},
{25,	13,	27,	1,	22},
{27,	8,	27,	3,	22},
{26,	7,	31,	2,	14},
{27,	7,	28,	4,	17},
{25,	13,	18,	13,	21},
{25,	19,	20,	4,	30},
{26,	19,	21,	4,	24},
{25,	14,	27,	0,	35},
{27,	17,	30,	0,	27},
{26,	7,	30,	2,	23},
{26,	5,	28,	2,	26},
{26,	11,	26,	2,	27},
{25,	1,	28,	3,	26},
{25,	8,	20,	6,	32},
{25,	22,	22,	0,	38},
{26,	24,	20,	0,	38},
{25,	20,	15,	15,	24},
{25,	20,	16,	7,	33},
{25,	18,	18,	6,	33},
{25,	25,	18,	1,	34},
{26,	24,	20,	1,	33},
{25,	26,	20,	2,	25},
{25,	26,	22,	2,	3},
{25,	22,	14,	16,	5},
{25,	27,	19,	1,	21},
{25,	28,	21,	0,	30},
{25,	7,	14,	8,	35},
{25,	17,	9,	20,	20},
{25,	13,	23,	4,	24},
{25,	13,	23,	6,	13},
{27,	10,	23,	6,	27},
{25,	14,	22,	6,	24},
{27,	12,	23,	6,	26},
{25,	39,	10,	3,	38},
{25,	7,	19,	7,	33},
{25,	17,	20,	6,	25},
{25,	20,	19,	6,	27},
{26,	19,	20,	5,	30},
{25,	10,	21,	10,	10},
{25,	17,	15,	17,	2},
{25,	16,	8,	19,	29},
{25,	21,	13,	16,	20},
{26,	21,	12,	16,	31},
{25,	39,	11,	7,	36},
{25,	25,	15,	6,	33},
{25,	39,	15,	7,	20},
{25,	11,	31,	1,	11},
{25,	13,	27,	2,	22},
{25,	18,	24,	0,	38},
{25,	4,	12,	7,	36},
{25,	26,	16,	0,	38},
{25,	15,	18,	12,	17},
{25,	23,	17,	5,	33},
{26,	21,	17,	7,	33},
{25,	13,	21,	10,	5},
{25,	13,	21,	7,	14},
{26,	14,	21,	10,	7},
{26,	14,	21,	7,	21},
{25,	9,	26,	3,	27},
{25,	9,	25,	4,	29},
{25,	11,	24,	4,	29},
{25,	6,	15,	17,	26},
{25,	20,	19,	9,	8},
{24,	14,	14,	19,	32},
{30,	18,	13,	12,	33},
{29,	14,	15,	16,	32},
{29,	16,	12,	19,	31},
{27,	16,	15,	8,	34},
{26,	17,	12,	19,	32},
{26,	18,	11,	19,	31},
{25,	23,	16,	8,	32},
{25,	39,	15,	8,	26},
{26,	25,	16,	8,	29},
{25,	11,	16,	10,	32},
{24,	27,	19,	10,	27},
{30,	24,	15,	13,	12},
{28,	23,	20,	6,	14},
{27,	19,	18,	10,	28},
{27,	25,	15,	10,	30},
{27,	19,	20,	7,	25},
{26,	23,	20,	6,	27},
{28,	23,	20,	7,	19},
{26,	21,	15,	15,	16},
{26,	25,	18,	7,	28},
{26,	23,	20,	5,	29},
{26,	24,	16,	11,	16},
{25,	25,	20,	6,	25},
{25,	20,	16,	13,	27},
{26,	13,	17,	13,	27},
{28,	9,	19,	13,	23},
{26,	15,	18,	13,	20},
{26,	22,	16,	13,	11},
{25,	17,	16,	16,	24},
{27,	22,	16,	15,	4},
{27,	39,	16,	16,	0},
{25,	39,	18,	4,	17},
{27,	28,	18,	4,	25},
{25,	27,	17,	6,	30},
{28,	39,	15,	6,	33},
{25,	8,	17,	13,	30},
{25,	16,	17,	13,	27},
{25,	20,	20,	8,	17},
{25,	19,	16,	15,	24},
{25,	39,	15,	5,	34},
{25,	9,	19,	12,	26},
{25,	16,	16,	17,	3},
{25,	16,	14,	17,	16},
{26,	18,	14,	18,	7},
{25,	19,	20,	8,	25},
{25,	39,	12,	17,	7},
{26,	24,	15,	15,	5},
{26,	23,	13,	15,	17},
{25,	13,	16,	11,	31},
{25,	16,	17,	13,	28},
{25,	28,	17,	4,	30},
{25,	4,	20,	13,	26},
{25,	15,	19,	10,	28},
{25,	23,	18,	7,	29},
{25,	12,	19,	7,	32},
{25,	15,	20,	9,	21},
{25,	11,	21,	10,	16},
{26,	14,	21,	8,	20},
{26,	9,	21,	10,	20},
{26,	8,	20,	12,	21},
{25,	22,	16,	11,	28},
{26,	22,	15,	12,	27},
{25,	22,	16,	13,	18},
{26,	23,	16,	12,	21},
{25,	16,	15,	17,	10},
{25,	2,	21,	10,	23},
{24,	14,	18,	18,	25},
{28,	15,	16,	17,	24},
{27,	14,	18,	19,	1},
{27,	16,	19,	16,	0},
{26,	15,	18,	15,	14},
{25,	16,	16,	19,	20},
{28,	4,	15,	19,	26},
{25,	11,	20,	16,	3},
{26,	5,	19,	18,	3},
{25,	3,	19,	18,	9},
{25,	6,	17,	19,	15},
{26,	16,	18,	19,	3},
{25,	5,	18,	16,	26},
{25,	16,	17,	18,	14},
{25,	8,	19,	16,	10},
{25,	16,	17,	19,	11},
{25,	13,	19,	13,	23},
{25,	7,	16,	19,	23},
{25,	15,	19,	16,	4},
{25,	9,	19,	19,	1},
{25,	16,	14,	19,	28},
{24,	14,	14,	13,	34},
{26,	14,	14,	9,	35},
{24,	4,	10,	6,	38},
{26,	7,	7,	6,	38},
{26,	11,	11,	5,	38},
{25,	4,	11,	6,	38},
{24,	7,	7,	8,	37},
{24,	2,	23,	13,	19},
{25,	3,	22,	16,	1},
{25,	0,	21,	16,	4},
{24,	22,	23,	4,	26},
{29,	25,	21,	2,	25},
{28,	15,	22,	4,	31},
{27,	15,	24,	4,	9},
{26,	14,	24,	4,	20},
{26,	22,	21,	5,	13},
{24,	9,	13,	23,	18},
{28,	2,	9,	23,	22},
{27,	2,	11,	22,	20},
{26,	12,	11,	21,	20},
{25,	10,	16,	23,	0},
{24,	12,	8,	23,	25},
{24,	1,	16,	8,	37},
{27,	9,	15,	5,	37},
{28,	9,	15,	7,	36},
{25,	0,	13,	6,	38},
{25,	18,	16,	3,	36},
{26,	39,	12,	4,	36},
{26,	17,	15,	4,	36},
{24,	23,	21,	7,	26},
{27,	24,	21,	6,	9},
{26,	14,	22,	6,	28},
{24,	7,	20,	4,	38},
{29,	5,	17,	7,	34},
{26,	0,	17,	6,	36},
{25,	6,	19,	6,	34},
{27,	4,	19,	5,	36},
{24,	21,	19,	13,	16},
{25,	19,	17,	13,	27},
{25,	17,	18,	13,	25},
{25,	22,	17,	13,	12},
{25,	23,	17,	12,	21},
{26,	21,	18,	13,	19},
{25,	24,	17,	11,	26},
{26,	25,	15,	12,	23},
{24,	3,	20,	16,	19},
{26,	3,	19,	18,	15},
{25,	3,	19,	16,	20},
{24,	27,	26,	0,	29},
{31,	25,	22,	2,	23},
{28,	23,	22,	4,	23},
{26,	24,	22,	4,	12},
{26,	26,	22,	2,	18},
{25,	20,	26,	1,	26},
{26,	18,	27,	1,	21},
{26,	19,	26,	1,	28},
{26,	5,	28,	2,	28},
{25,	23,	23,	3,	20},
{25,	0,	26,	2,	31},
{25,	8,	27,	3,	29},
{26,	0,	27,	2,	32},
{25,	3,	24,	4,	32},
{24,	3,	26,	8,	20},
{25,	5,	25,	9,	1},
{25,	8,	24,	7,	23},
{26,	7,	23,	8,	20},
{26,	9,	25,	5,	23},
{27,	7,	25,	6,	23},
{24,	2,	16,	13,	34},
{25,	2,	16,	10,	35},
{25,	13,	16,	13,	31},
{25,	8,	16,	12,	33},
{25,	14,	14,	10,	35},
{24,	2,	24,	10,	19},
{26,	3,	25,	9,	8},
{25,	3,	24,	12,	5},
{25,	1,	24,	11,	15},
{25,	2,	24,	13,	5},
{24,	20,	24,	4,	22},
{25,	16,	27,	2,	12},
{25,	19,	24,	2,	28},
{24,	14,	23,	8,	15},
{28,	11,	23,	7,	26},
{24,	16,	20,	13,	14},
{25,	14,	21,	10,	14},
{25,	17,	20,	10,	14},
{25,	15,	21,	9,	19},
{25,	19,	21,	8,	20},
{24,	8,	22,	6,	32},
{28,	8,	21,	7,	30},
{25,	9,	21,	8,	28},
{26,	4,	25,	8,	21},
{25,	6,	26,	7,	15},
{25,	9,	21,	10,	23},
{26,	10,	20,	10,	27},
{25,	17,	20,	9,	26},
{26,	15,	21,	8,	27},
{25,	22,	20,	7,	29},
{26,	17,	19,	6,	33},
{27,	15,	19,	7,	33},
{26,	11,	22,	7,	29},
{25,	17,	21,	7,	29},
{24,	2,	25,	10,	10},
{28,	3,	26,	10,	2},
{24,	19,	14,	18,	22},
{24,	21,	24,	2,	30},
{26,	25,	22,	1,	29},
{26,	23,	21,	6,	27},
{25,	16,	23,	4,	30},
{25,	16,	25,	2,	30},
{25,	17,	23,	3,	31},
{26,	20,	20,	3,	33},
{27,	22,	23,	2,	31},
{25,	16,	23,	4,	32},
{26,	19,	22,	2,	34},
{25,	16,	21,	4,	33},
{25,	16,	25,	2,	32},
{24,	10,	27,	1,	35},
{27,	14,	20,	2,	36},
{26,	19,	23,	2,	34},
{25,	13,	22,	1,	37},
{24,	10,	18,	16,	27},
{24,	6,	17,	15,	29},
{25,	11,	16,	15,	31},
{24,	16,	11,	8,	37},
{24,	4,	20,	10,	30},
{24,	25,	20,	7,	25},
{24,	8,	21,	6,	33},
{24,	5,	28,	4,	25},
{25,	5,	26,	6,	23},
{25,	5,	27,	6,	17},
{24,	7,	24,	5,	32},
{27,	7,	23,	6,	30},
{24,	4,	18,	19,	12},
{26,	15,	18,	19,	10},
{24,	3,	26,	13,	0},
{24,	14,	22,	10,	5},
{24,	23,	13,	7,	35},
{25,	25,	15,	5,	35},
{24,	16,	7,	27,	2},
{24,	16,	13,	13,	34},
{24,	39,	15,	7,	33},
{25,	27,	16,	10,	28},
{24,	12,	22,	2,	37},
{24,	21,	26,	1,	29},
{24,	17,	15,	18,	23},
{24,	6,	25,	4,	32},
{24,	11,	25,	4,	27},
{24,	27,	19,	4,	29},
{24,	7,	20,	16,	14},
{24,	24,	19,	7,	29},
{24,	12,	20,	10,	27},
{24,	18,	14,	19,	15},
{24,	3,	25,	13,	1},
{24,	6,	27,	3,	31},
{24,	11,	11,	23,	10},
{25,	17,	9,	24,	2},
{24,	6,	17,	15,	30},
{24,	25,	16,	7,	33},
{24,	24,	17,	3,	35},
{25,	22,	16,	3,	36},
{24,	10,	23,	2,	36},
{24,	21,	14,	13,	31},
{24,	24,	15,	13,	25},
{26,	39,	12,	13,	30},
{24,	39,	13,	15,	22},
{26,	22,	12,	16,	30},
{24,	39,	11,	12,	33},
{24,	9,	20,	13,	22},
{24,	28,	23,	0,	19},
{24,	39,	16,	2,	34},
{24,	23,	24,	0,	35},
{24,	22,	15,	13,	29},
{24,	20,	25,	5,	0},
{24,	19,	25,	4,	22},
{25,	15,	25,	4,	26},
{24,	5,	30,	1,	28},
{24,	18,	18,	7,	33},
{26,	18,	20,	7,	30},
{24,	14,	22,	6,	31},
{26,	16,	21,	6,	32},
{24,	20,	19,	10,	28},
{25,	23,	17,	8,	32},
{24,	21,	21,	8,	9},
{24,	17,	26,	2,	26},
{24,	9,	20,	3,	38},
{24,	4,	36,	0,	31},
{24,	6,	21,	8,	30},
{24,	39,	16,	1,	36},
{24,	11,	13,	8,	36},
{24,	17,	19,	16,	2},
{24,	8,	9,	26,	2},
{24,	22,	19,	8,	29},
{24,	12,	22,	8,	22},
{25,	14,	22,	7,	29},
{24,	12,	23,	7,	28},
{24,	19,	19,	13,	18},
{24,	16,	19,	13,	22},
{24,	14,	19,	13,	25},
{24,	9,	20,	13,	26},
{24,	5,	28,	6,	1},
{24,	5,	30,	5,	1},
{24,	23,	17,	2,	36},
{23,	39,	9,	10,	38},
{25,	9,	12,	6,	38},
{24,	18,	11,	5,	38},
{24,	21,	11,	4,	38},
{23,	16,	11,	26,	23},
{27,	4,	15,	26,	0},
{27,	20,	14,	22,	0},
{27,	9,	12,	20,	24},
{26,	16,	12,	21,	17},
{26,	17,	11,	22,	22},
{24,	21,	11,	22,	17},
{25,	20,	11,	21,	24},
{26,	16,	10,	24,	24},
{25,	8,	11,	22,	25},
{25,	39,	11,	26,	1},
{24,	16,	12,	23,	16},
{26,	14,	13,	23,	7},
{24,	9,	13,	20,	25},
{24,	4,	12,	24,	6},
{24,	39,	9,	25,	12},
{24,	14,	13,	21,	17},
{24,	18,	12,	22,	16},
{25,	18,	13,	22,	9},
{23,	21,	23,	10,	27},
{27,	15,	22,	8,	29},
{27,	23,	22,	5,	23},
{26,	2,	24,	10,	21},
{26,	16,	23,	6,	30},
{24,	2,	22,	10,	30},
{25,	14,	23,	7,	30},
{24,	11,	22,	10,	28},
{23,	19,	16,	16,	34},
{29,	22,	17,	4,	35},
{27,	39,	10,	16,	34},
{26,	14,	18,	16,	27},
{26,	13,	20,	4,	35},
{25,	39,	11,	16,	34},
{25,	39,	12,	10,	34},
{25,	18,	19,	4,	34},
{25,	17,	17,	4,	36},
{25,	20,	14,	16,	32},
{25,	14,	17,	7,	34},
{24,	25,	17,	10,	31},
{25,	20,	17,	13,	29},
{25,	11,	21,	10,	29},
{25,	19,	17,	10,	32},
{24,	18,	19,	5,	34},
{25,	18,	18,	6,	34},
{24,	20,	18,	5,	34},
{23,	10,	9,	23,	28},
{28,	10,	11,	21,	27},
{26,	5,	13,	20,	28},
{25,	9,	11,	23,	26},
{24,	18,	10,	21,	28},
{23,	17,	15,	13,	35},
{23,	1,	22,	18,	20},
{27,	4,	21,	19,	1},
{25,	2,	23,	13,	20},
{24,	3,	19,	18,	23},
{26,	2,	20,	14,	24},
{27,	3,	20,	16,	22},
{25,	2,	20,	16,	24},
{25,	3,	19,	16,	26},
{24,	2,	21,	13,	25},
{25,	3,	21,	11,	27},
{24,	12,	20,	13,	27},
{24,	2,	20,	16,	27},
{24,	2,	21,	12,	27},
{23,	28,	20,	7,	30},
{28,	22,	18,	7,	32},
{27,	25,	18,	6,	32},
{26,	28,	22,	2,	5},
{26,	29,	19,	4,	12},
{26,	39,	18,	7,	3},
{26,	30,	19,	1,	12},
{25,	23,	19,	5,	33},
{25,	29,	21,	2,	10},
{25,	28,	17,	8,	24},
{25,	26,	21,	5,	4},
{25,	28,	21,	7,	2},
{24,	26,	18,	5,	32},
{24,	39,	16,	5,	34},
{25,	25,	17,	4,	35},
{24,	29,	20,	3,	15},
{26,	39,	19,	0,	30},
{24,	28,	21,	1,	22},
{25,	26,	22,	1,	30},
{24,	23,	19,	6,	32},
{24,	28,	21,	6,	4},
{24,	30,	20,	0,	30},
{24,	27,	24,	3,	0},
{24,	21,	19,	7,	32},
{24,	26,	21,	2,	30},
{24,	22,	18,	7,	33},
{24,	24,	19,	5,	33},
{24,	28,	20,	3,	31},
{24,	39,	18,	5,	13},
{24,	39,	18,	6,	10},
{24,	39,	17,	7,	30},
{24,	29,	18,	5,	30},
{25,	29,	20,	2,	26},
{23,	14,	22,	16,	20},
{29,	12,	21,	13,	26},
{28,	8,	23,	13,	13},
{27,	3,	22,	18,	13},
{25,	15,	21,	12,	21},
{25,	10,	21,	18,	1},
{24,	12,	19,	16,	26},
{24,	14,	23,	12,	11},
{24,	14,	22,	13,	21},
{24,	12,	23,	13,	13},
{23,	26,	25,	2,	29},
{26,	20,	25,	3,	26},
{24,	21,	26,	2,	26},
{24,	27,	25,	2,	5},
{26,	27,	23,	1,	22},
{24,	22,	26,	2,	21},
{24,	23,	24,	3,	9},
{25,	21,	25,	3,	26},
{24,	21,	25,	4,	7},
{24,	19,	25,	4,	26},
{23,	2,	19,	16,	31},
{25,	14,	17,	13,	31},
{23,	2,	31,	7,	5},
{26,	3,	30,	5,	8},
{25,	5,	29,	7,	5},
{23,	17,	27,	4,	25},
{26,	19,	26,	4,	14},
{25,	16,	27,	2,	30},
{24,	14,	28,	5,	1},
{25,	10,	25,	6,	8},
{24,	18,	24,	6,	11},
{26,	14,	24,	7,	10},
{24,	12,	24,	7,	18},
{24,	14,	25,	7,	2},
{24,	14,	27,	5,	5},
{23,	1,	22,	4,	38},
{24,	6,	21,	5,	34},
{24,	1,	22,	6,	33},
{23,	7,	15,	10,	36},
{26,	17,	11,	10,	36},
{23,	12,	21,	13,	29},
{26,	3,	20,	16,	28},
{24,	4,	21,	13,	30},
{24,	6,	19,	14,	31},
{23,	7,	24,	8,	27},
{24,	11,	24,	8,	22},
{23,	22,	21,	6,	32},
{27,	19,	22,	7,	29},
{25,	22,	21,	4,	33},
{25,	28,	20,	2,	32},
{25,	23,	22,	3,	31},
{25,	30,	20,	0,	33},
{25,	18,	23,	5,	31},
{25,	23,	21,	7,	29},
{24,	21,	21,	4,	34},
{24,	21,	22,	8,	28},
{24,	19,	23,	7,	29},
{24,	17,	22,	6,	32},
{23,	23,	23,	7,	28},
{24,	23,	24,	4,	26},
{24,	24,	22,	6,	12},
{24,	25,	23,	4,	3},
{23,	21,	17,	13,	32},
{26,	39,	13,	10,	33},
{25,	39,	14,	11,	32},
{24,	24,	17,	12,	24},
{23,	2,	29,	4,	29},
{25,	3,	27,	4,	31},
{24,	2,	33,	2,	28},
{24,	6,	29,	4,	24},
{23,	21,	20,	13,	15},
{23,	1,	24,	13,	14},
{23,	39,	16,	4,	36},
{23,	11,	13,	21,	26},
{24,	17,	13,	21,	23},
{24,	1,	12,	22,	25},
{23,	11,	14,	21,	25},
{26,	17,	14,	22,	4},
{25,	14,	14,	21,	23},
{23,	6,	20,	8,	33},
{28,	2,	17,	12,	33},
{25,	16,	17,	8,	34},
{24,	3,	20,	9,	32},
{23,	9,	18,	17,	26},
{23,	3,	30,	4,	22},
{23,	19,	20,	13,	21},
{24,	21,	18,	13,	22},
{23,	24,	18,	13,	22},
{26,	23,	19,	13,	8},
{24,	23,	17,	13,	26},
{24,	23,	19,	12,	16},
{23,	27,	16,	13,	16},
{28,	25,	17,	13,	22},
{23,	12,	15,	18,	28},
{23,	6,	13,	23,	25},
{23,	18,	16,	19,	11},
{25,	20,	15,	19,	3},
{24,	17,	16,	18,	23},
{24,	19,	16,	18,	8},
{23,	17,	18,	19,	10},
{24,	17,	18,	15,	20},
{25,	17,	17,	15,	27},
{24,	15,	17,	18,	25},
{24,	17,	20,	17,	0},
{23,	16,	18,	17,	25},
{24,	17,	17,	17,	23},
{23,	28,	25,	2,	9},
{24,	28,	24,	1,	15},
{23,	28,	23,	2,	26},
{25,	28,	22,	2,	29},
{23,	39,	18,	6,	27},
{24,	29,	19,	6,	13},
{23,	25,	27,	0,	28},
{24,	19,	27,	1,	30},
{25,	23,	27,	0,	33},
{23,	16,	12,	24,	16},
{24,	10,	16,	25,	0},
{23,	18,	14,	17,	31},
{25,	18,	15,	17,	26},
{23,	20,	14,	17,	25},
{23,	0,	32,	7,	1},
{23,	2,	33,	4,	22},
{24,	1,	35,	5,	2},
{25,	1,	34,	4,	15},
{25,	1,	35,	6,	0},
{23,	27,	21,	5,	10},
{26,	25,	22,	5,	12},
{24,	25,	21,	7,	12},
{24,	28,	21,	7,	5},
{24,	29,	21,	3,	12},
{23,	11,	27,	5,	20},
{23,	10,	10,	10,	37},
{23,	0,	14,	6,	38},
{23,	19,	14,	2,	37},
{25,	21,	17,	1,	37},
{24,	39,	12,	3,	37},
{24,	39,	15,	1,	37},
{23,	17,	22,	1,	37},
{25,	25,	18,	1,	36},
{25,	19,	20,	2,	36},
{25,	23,	19,	1,	37},
{24,	21,	18,	4,	35},
{25,	16,	21,	4,	35},
{23,	18,	20,	4,	36},
{23,	20,	14,	2,	38},
{23,	2,	32,	7,	3},
{23,	2,	33,	6,	5},
{23,	26,	19,	6,	32},
{23,	16,	22,	1,	38},
{24,	12,	20,	3,	38},
{24,	39,	12,	3,	38},
{23,	28,	20,	2,	33},
{24,	26,	19,	1,	35},
{24,	28,	17,	1,	36},
{24,	27,	17,	4,	35},
{23,	6,	27,	0,	38},
{23,	1,	27,	1,	38},
{23,	16,	28,	1,	21},
{24,	14,	28,	5,	4},
{24,	13,	28,	4,	10},
{24,	9,	29,	4,	13},
{23,	3,	17,	10,	34},
{23,	21,	14,	15,	32},
{23,	23,	13,	16,	26},
{23,	19,	25,	1,	34},
{24,	20,	24,	2,	33},
{23,	25,	19,	11,	16},
{23,	26,	18,	13,	10},
{24,	25,	18,	13,	22},
{23,	27,	17,	1,	37},
{23,	39,	9,	13,	35},
{23,	13,	22,	10,	29},
{23,	19,	24,	4,	28},
{23,	30,	19,	0,	35},
{23,	3,	11,	27,	2},
{23,	22,	19,	8,	30},
{23,	14,	27,	4,	27},
{23,	11,	20,	16,	23},
{23,	12,	21,	16,	21},
{23,	6,	26,	8,	16},
{23,	24,	22,	7,	12},
{23,	7,	24,	6,	28},
{23,	13,	26,	2,	33},
{23,	2,	24,	10,	22},
{23,	26,	16,	12,	22},
{23,	20,	11,	8,	37},
{23,	14,	14,	23,	3},
{24,	20,	15,	23,	0},
{23,	15,	13,	23,	16},
{23,	24,	24,	3,	12},
{23,	21,	12,	19,	16},
{24,	20,	14,	19,	15},
{23,	16,	28,	2,	20},
{23,	10,	30,	2,	22},
{24,	16,	29,	1,	21},
{24,	15,	31,	1,	14},
{25,	14,	30,	1,	28},
{23,	7,	29,	4,	27},
{23,	9,	20,	15,	27},
{23,	20,	23,	4,	31},
{23,	4,	15,	19,	28},
{23,	27,	16,	10,	29},
{23,	20,	15,	10,	34},
{23,	21,	16,	12,	33},
{23,	20,	14,	16,	34},
{23,	21,	21,	1,	37},
{23,	10,	14,	10,	36},
{22,	1,	32,	13,	26},
{29,	4,	22,	12,	30},
{28,	2,	32,	8,	19},
{28,	5,	28,	8,	18},
{28,	2,	25,	9,	27},
{27,	2,	32,	4,	28},
{25,	6,	28,	8,	15},
{25,	4,	25,	5,	31},
{25,	7,	25,	6,	28},
{24,	12,	22,	13,	29},
{24,	3,	23,	11,	28},
{26,	20,	23,	8,	29},
{24,	2,	25,	13,	23},
{24,	21,	21,	8,	30},
{24,	6,	29,	8,	9},
{24,	7,	28,	6,	15},
{23,	2,	23,	8,	31},
{26,	4,	22,	7,	32},
{24,	17,	21,	7,	31},
{23,	2,	24,	10,	28},
{23,	2,	33,	4,	28},
{23,	4,	21,	7,	33},
{23,	7,	26,	8,	16},
{23,	14,	22,	13,	23},
{23,	7,	22,	12,	30},
{23,	7,	26,	6,	26},
{22,	17,	12,	19,	34},
{24,	12,	13,	18,	33},
{23,	18,	11,	19,	33},
{22,	15,	9,	26,	29},
{24,	6,	10,	26,	26},
{23,	14,	10,	21,	29},
{22,	6,	11,	28,	15},
{25,	16,	10,	27,	5},
{23,	8,	11,	27,	15},
{22,	39,	1,	30,	18},
{26,	2,	5,	28,	18},
{23,	11,	5,	27,	18},
{22,	26,	21,	2,	39},
{27,	24,	19,	4,	35},
{26,	17,	25,	0,	39},
{25,	27,	19,	3,	35},
{25,	27,	18,	2,	38},
{26,	28,	20,	0,	39},
{24,	8,	23,	2,	39},
{24,	1,	24,	2,	38},
{24,	28,	18,	2,	37},
{23,	22,	18,	4,	38},
{27,	20,	19,	4,	38},
{25,	39,	13,	4,	38},
{24,	24,	19,	4,	36},
{23,	29,	22,	0,	33},
{23,	29,	21,	0,	37},
{23,	29,	21,	2,	25},
{23,	28,	17,	2,	39},
{23,	30,	20,	0,	38},
{23,	2,	26,	2,	35},
{22,	1,	27,	16,	18},
{30,	1,	24,	16,	20},
{24,	5,	24,	15,	2},
{23,	3,	23,	17,	6},
{24,	5,	24,	18,	0},
{23,	5,	24,	10,	28},
{23,	4,	25,	12,	8},
{23,	8,	26,	12,	1},
{22,	12,	21,	19,	23},
{27,	14,	19,	17,	20},
{26,	2,	22,	19,	5},
{26,	5,	22,	18,	20},
{25,	14,	21,	17,	6},
{23,	1,	20,	17,	26},
{23,	4,	20,	18,	24},
{23,	17,	18,	19,	13},
{23,	14,	20,	17,	17},
{22,	26,	22,	7,	30},
{27,	27,	21,	4,	30},
{24,	17,	22,	7,	32},
{24,	29,	21,	3,	22},
{24,	24,	24,	3,	26},
{24,	12,	21,	7,	33},
{24,	18,	21,	5,	34},
{23,	22,	22,	6,	32},
{23,	18,	23,	8,	30},
{22,	21,	20,	13,	30},
{25,	12,	18,	11,	32},
{24,	25,	19,	10,	29},
{24,	11,	18,	13,	32},
{24,	17,	18,	16,	27},
{24,	14,	21,	13,	29},
{23,	17,	18,	16,	28},
{25,	13,	17,	16,	31},
{24,	11,	18,	16,	31},
{23,	12,	22,	13,	30},
{23,	8,	19,	16,	31},
{24,	12,	19,	16,	30},
{24,	14,	19,	16,	28},
{23,	13,	19,	17,	25},
{23,	23,	19,	13,	17},
{22,	2,	27,	8,	31},
{26,	2,	28,	8,	27},
{25,	1,	26,	10,	27},
{24,	2,	28,	7,	28},
{24,	6,	26,	6,	30},
{23,	7,	26,	7,	28},
{23,	2,	29,	6,	27},
{22,	22,	15,	10,	36},
{28,	20,	12,	8,	37},
{25,	17,	14,	5,	38},
{23,	18,	12,	6,	38},
{23,	18,	10,	8,	38},
{23,	39,	11,	8,	37},
{23,	22,	15,	5,	37},
{23,	39,	14,	5,	37},
{22,	25,	20,	13,	22},
{27,	22,	21,	9,	25},
{26,	27,	20,	9,	15},
{25,	22,	20,	13,	25},
{23,	26,	20,	12,	12},
{24,	26,	20,	10,	22},
{23,	22,	21,	10,	27},
{23,	22,	21,	12,	3},
{24,	20,	21,	12,	7},
{23,	25,	20,	8,	28},
{22,	23,	17,	16,	21},
{26,	21,	18,	16,	4},
{26,	23,	19,	16,	1},
{25,	19,	17,	16,	28},
{23,	39,	14,	15,	21},
{25,	39,	16,	15,	3},
{23,	22,	15,	16,	29},
{23,	19,	18,	19,	4},
{22,	24,	16,	19,	22},
{27,	39,	14,	17,	21},
{27,	19,	17,	18,	17},
{26,	24,	14,	17,	24},
{25,	19,	16,	17,	26},
{25,	22,	17,	15,	25},
{24,	20,	15,	19,	24},
{23,	24,	15,	22,	0},
{23,	16,	17,	19,	23},
{23,	13,	19,	17,	26},
{23,	39,	11,	17,	28},
{23,	20,	10,	18,	30},
{23,	19,	14,	17,	30},
{23,	19,	12,	17,	33},
{23,	22,	12,	17,	29},
{23,	20,	10,	19,	31},
{22,	11,	11,	30,	5},
{25,	2,	9,	29,	7},
{24,	2,	13,	30,	0},
{23,	2,	9,	29,	14},
{23,	16,	8,	30,	2},
{24,	16,	8,	28,	10},
{22,	25,	17,	6,	36},
{24,	39,	12,	10,	36},
{24,	16,	17,	5,	37},
{23,	10,	17,	5,	38},
{23,	22,	20,	5,	34},
{23,	39,	15,	6,	35},
{22,	11,	12,	10,	38},
{25,	17,	12,	9,	38},
{23,	0,	13,	7,	38},
{22,	11,	14,	26,	8},
{26,	2,	13,	30,	2},
{25,	15,	14,	26,	4},
{25,	15,	12,	27,	8},
{24,	14,	14,	23,	10},
{24,	9,	12,	25,	17},
{24,	13,	13,	24,	12},
{24,	16,	14,	22,	12},
{23,	4,	12,	25,	20},
{22,	9,	15,	21,	20},
{26,	17,	15,	22,	3},
{23,	12,	16,	21,	1},
{23,	4,	15,	20,	24},
{23,	23,	15,	22,	1},
{22,	28,	18,	13,	13},
{26,	28,	18,	10,	19},
{22,	17,	17,	17,	28},
{24,	17,	16,	18,	27},
{22,	1,	16,	10,	37},
{22,	23,	14,	21,	21},
{23,	39,	13,	21,	22},
{23,	21,	14,	22,	12},
{22,	1,	31,	8,	28},
{22,	5,	21,	16,	28},
{23,	4,	21,	18,	24},
{22,	2,	24,	16,	24},
{23,	3,	25,	16,	8},
{22,	2,	5,	31,	1},
{22,	0,	35,	3,	22},
{24,	0,	36,	2,	22},
{23,	0,	34,	4,	22},
{22,	21,	12,	21,	28},
{24,	2,	14,	21,	28},
{22,	3,	38,	2,	14},
{22,	16,	19,	15,	30},
{24,	21,	19,	16,	4},
{24,	16,	20,	16,	8},
{23,	20,	17,	15,	29},
{22,	30,	20,	2,	26},
{23,	39,	21,	1,	2},
{22,	6,	22,	10,	31},
{24,	6,	20,	12,	31},
{22,	11,	25,	6,	28},
{25,	14,	27,	4,	29},
{22,	1,	24,	4,	34},
{23,	20,	23,	3,	34},
{22,	1,	24,	7,	33},
{22,	27,	21,	7,	23},
{22,	8,	26,	8,	28},
{23,	10,	25,	7,	22},
{22,	10,	27,	8,	15},
{24,	11,	26,	8,	9},
{23,	11,	27,	7,	14},
{23,	13,	28,	7,	1},
{23,	10,	26,	8,	22},
{22,	22,	18,	16,	11},
{22,	24,	24,	4,	26},
{22,	13,	16,	10,	36},
{22,	39,	19,	4,	12},
{23,	39,	19,	6,	7},
{22,	2,	19,	13,	32},
{22,	2,	20,	10,	33},
{22,	39,	16,	6,	35},
{22,	15,	21,	15,	20},
{22,	16,	13,	8,	37},
{24,	12,	14,	8,	37},
{23,	9,	16,	10,	37},
{23,	14,	13,	7,	38},
{22,	4,	24,	10,	29},
{24,	2,	26,	9,	29},
{22,	1,	28,	10,	28},
{22,	2,	23,	13,	29},
{22,	15,	37,	0,	14},
{24,	12,	36,	1,	6},
{22,	12,	34,	2,	11},
{24,	12,	29,	3,	22},
{22,	21,	30,	0,	16},
{24,	23,	28,	0,	29},
{23,	19,	28,	1,	21},
{23,	17,	30,	1,	21},
{22,	17,	30,	2,	16},
{22,	9,	13,	17,	34},
{22,	18,	27,	4,	20},
{23,	19,	28,	2,	20},
{22,	21,	18,	10,	31},
{22,	22,	20,	13,	28},
{22,	23,	18,	13,	30},
{23,	39,	13,	13,	30},
{23,	39,	16,	11,	27},
{22,	14,	22,	13,	30},
{22,	39,	14,	7,	35},
{22,	39,	13,	7,	37},
{22,	20,	13,	6,	38},
{22,	18,	21,	3,	38},
{24,	10,	23,	3,	36},
{22,	12,	22,	4,	37},
{24,	16,	23,	4,	34},
{23,	12,	22,	7,	33},
{23,	20,	22,	5,	34},
{22,	13,	22,	6,	34},
{22,	8,	22,	8,	34},
{24,	16,	19,	7,	34},
{22,	2,	20,	10,	34},
{22,	1,	18,	10,	38},
{27,	11,	19,	5,	38},
{26,	16,	17,	7,	36},
{24,	7,	18,	7,	37},
{24,	15,	18,	7,	35},
{23,	11,	20,	7,	35},
{24,	9,	20,	5,	37},
{23,	19,	17,	8,	35},
{23,	15,	19,	5,	38},
{23,	14,	19,	6,	36},
{22,	24,	17,	7,	35},
{23,	21,	16,	12,	34},
{22,	21,	17,	10,	34},
{24,	18,	18,	9,	33},
{23,	10,	17,	10,	36},
{22,	20,	17,	10,	35},
{23,	22,	16,	10,	35},
{22,	11,	15,	8,	38},
{22,	17,	19,	7,	35},
{23,	19,	19,	5,	37},
{22,	22,	14,	16,	32},
{23,	23,	16,	13,	31},
{22,	21,	12,	19,	31},
{22,	39,	11,	17,	33},
{22,	7,	13,	24,	19},
{22,	12,	17,	13,	33},
{23,	21,	17,	11,	34},
{23,	7,	17,	13,	34},
{22,	0,	18,	13,	34},
{22,	26,	21,	8,	9},
{22,	24,	21,	8,	26},
{22,	2,	32,	7,	27},
{22,	28,	18,	10,	24},
{22,	39,	11,	19,	32},
{22,	39,	21,	3,	1},
{22,	28,	19,	3,	34},
{22,	1,	34,	6,	2},
{22,	23,	23,	7,	29},
{22,	0,	37,	2,	22},
{22,	17,	19,	17,	4},
{22,	16,	20,	19,	4},
{22,	5,	30,	6,	9},
{22,	11,	17,	18,	27},
{22,	8,	15,	23,	3},
{22,	19,	14,	21,	24},
{22,	15,	20,	15,	24},
{22,	13,	21,	17,	23},
{23,	14,	21,	19,	7},
{22,	13,	20,	19,	23},
{22,	28,	21,	7,	8},
{23,	28,	21,	4,	30},
{22,	19,	22,	7,	32},
{22,	12,	29,	4,	14},
{22,	26,	16,	6,	36},
{22,	9,	18,	13,	33},
{22,	7,	18,	16,	33},
{24,	16,	17,	16,	32},
{22,	23,	26,	1,	21},
{22,	3,	20,	14,	30},
{22,	3,	20,	15,	29},
{22,	0,	34,	2,	27},
{22,	22,	14,	19,	25},
{22,	10,	16,	8,	38},
{22,	8,	12,	27,	11},
{22,	17,	19,	8,	33},
{23,	15,	22,	8,	32},
{22,	14,	21,	10,	31},
{22,	4,	28,	7,	23},
{22,	39,	16,	12,	23},
{22,	5,	27,	8,	26},
{22,	6,	28,	6,	26},
{22,	23,	22,	10,	1},
{22,	24,	22,	8,	26},
{26,	22,	22,	10,	16},
{23,	23,	23,	8,	25},
{22,	16,	14,	6,	38},
{22,	10,	17,	7,	38},
{22,	22,	24,	0,	39},
{22,	29,	18,	2,	33},
{22,	23,	13,	16,	29},
{22,	39,	12,	19,	28},
{22,	39,	12,	16,	32},
{22,	17,	10,	10,	38},
{22,	14,	14,	10,	37},
{22,	22,	12,	10,	37},
{25,	20,	11,	10,	38},
{22,	23,	13,	22,	16},
{22,	27,	24,	1,	29},
{22,	28,	26,	0,	19},
{22,	20,	12,	26,	2},
{22,	18,	12,	26,	6},
{22,	22,	22,	10,	22},
{23,	22,	23,	9,	27},
{22,	22,	23,	10,	20},
{22,	21,	15,	19,	25},
{22,	3,	28,	12,	2},
{22,	2,	27,	14,	8},
{22,	18,	18,	11,	32},
{22,	14,	21,	10,	32},
{24,	9,	21,	11,	32},
{22,	26,	22,	8,	9},
{22,	2,	28,	10,	21},
{22,	12,	7,	28,	15},
{22,	5,	32,	4,	9},
{22,	27,	20,	9,	23},
{22,	11,	6,	28,	17},
{22,	1,	38,	3,	0},
{21,	24,	15,	16,	37},
{25,	25,	18,	3,	38},
{25,	24,	16,	10,	35},
{24,	21,	16,	15,	34},
{23,	39,	14,	13,	35},
{23,	39,	15,	11,	33},
{23,	39,	15,	6,	37},
{24,	39,	16,	4,	37},
{23,	23,	17,	16,	25},
{23,	24,	17,	12,	31},
{23,	24,	16,	17,	25},
{23,	39,	14,	10,	36},
{22,	20,	18,	16,	27},
{22,	24,	16,	10,	36},
{22,	25,	17,	10,	33},
{22,	18,	20,	14,	20},
{22,	22,	19,	16,	9},
{23,	17,	19,	17,	9},
{22,	18,	18,	7,	36},
{22,	39,	12,	17,	33},
{22,	18,	19,	15,	18},
{22,	25,	16,	12,	31},
{22,	25,	18,	12,	27},
{22,	24,	20,	13,	26},
{22,	26,	20,	10,	26},
{22,	24,	19,	13,	28},
{24,	24,	16,	15,	30},
{22,	26,	19,	3,	37},
{21,	16,	18,	21,	31},
{26,	19,	16,	17,	31},
{25,	20,	12,	21,	31},
{25,	5,	18,	23,	0},
{24,	18,	17,	21,	5},
{23,	3,	21,	21,	0},
{23,	19,	16,	18,	30},
{22,	16,	9,	22,	30},
{22,	39,	2,	24,	30},
{22,	13,	19,	19,	28},
{24,	4,	20,	17,	27},
{22,	0,	17,	17,	32},
{22,	3,	17,	22,	2},
{22,	10,	16,	22,	4},
{22,	10,	15,	22,	12},
{23,	10,	16,	22,	9},
{22,	8,	15,	23,	7},
{22,	21,	17,	21,	0},
{21,	21,	25,	13,	27},
{28,	22,	23,	13,	10},
{24,	23,	24,	4,	29},
{24,	13,	27,	5,	25},
{24,	15,	27,	6,	4},
{24,	14,	27,	7,	6},
{24,	17,	21,	13,	29},
{23,	4,	28,	10,	21},
{24,	10,	26,	12,	4},
{23,	4,	23,	16,	21},
{23,	5,	28,	10,	15},
{23,	17,	22,	15,	2},
{23,	16,	26,	5,	22},
{23,	11,	26,	7,	24},
{22,	23,	24,	8,	26},
{22,	11,	25,	13,	28},
{23,	10,	25,	9,	29},
{22,	22,	25,	5,	25},
{24,	22,	25,	8,	7},
{23,	23,	25,	3,	27},
{22,	18,	25,	3,	32},
{23,	16,	27,	3,	31},
{22,	17,	27,	7,	2},
{22,	18,	23,	10,	28},
{22,	8,	24,	16,	2},
{22,	3,	28,	12,	14},
{22,	5,	26,	13,	14},
{22,	3,	27,	16,	14},
{22,	12,	26,	13,	4},
{22,	14,	28,	6,	5},
{23,	8,	28,	9,	7},
{22,	23,	24,	5,	29},
{22,	17,	22,	14,	10},
{21,	3,	27,	18,	24},
{22,	2,	23,	19,	5},
{22,	3,	28,	13,	26},
{22,	2,	30,	13,	19},
{22,	3,	29,	13,	11},
{21,	2,	35,	13,	22},
{23,	2,	33,	10,	24},
{23,	10,	34,	1,	23},
{24,	15,	33,	0,	29},
{23,	7,	37,	1,	22},
{23,	2,	33,	5,	28},
{23,	2,	33,	7,	27},
{22,	6,	35,	4,	2},
{22,	7,	30,	4,	16},
{22,	0,	33,	12,	24},
{21,	9,	7,	30,	20},
{26,	5,	11,	27,	20},
{24,	8,	9,	30,	10},
{22,	9,	8,	30,	15},
{22,	11,	7,	30,	18},
{22,	16,	8,	29,	11},
{21,	13,	21,	21,	18},
{22,	15,	19,	21,	9},
{21,	9,	21,	8,	38},
{26,	8,	22,	6,	35},
{25,	1,	22,	6,	36},
{22,	1,	22,	6,	37},
{22,	15,	21,	4,	38},
{22,	18,	21,	4,	37},
{21,	22,	20,	16,	29},
{24,	13,	20,	17,	27},
{24,	13,	21,	16,	26},
{24,	16,	19,	17,	19},
{23,	23,	19,	16,	22},
{23,	16,	20,	16,	30},
{23,	15,	19,	17,	28},
{23,	15,	22,	16,	17},
{23,	23,	18,	15,	29},
{22,	17,	20,	19,	10},
{22,	24,	18,	16,	19},
{23,	25,	17,	16,	12},
{23,	24,	20,	16,	2},
{22,	13,	21,	19,	24},
{22,	17,	20,	17,	13},
{21,	22,	19,	18,	25},
{25,	23,	17,	17,	23},
{23,	17,	20,	17,	26},
{23,	18,	18,	19,	17},
{22,	18,	20,	19,	10},
{23,	19,	20,	17,	12},
{22,	17,	19,	18,	28},
{22,	19,	19,	17,	27},
{22,	14,	21,	18,	18},
{21,	24,	22,	13,	26},
{24,	22,	23,	13,	26},
{22,	22,	23,	10,	28},
{23,	21,	22,	9,	30},
{23,	18,	22,	12,	29},
{22,	21,	22,	13,	28},
{22,	24,	22,	9,	28},
{21,	14,	22,	17,	26},
{24,	3,	24,	16,	25},
{23,	3,	23,	18,	25},
{22,	16,	21,	15,	25},
{22,	19,	21,	16,	20},
{23,	19,	21,	15,	25},
{22,	7,	22,	14,	28},
{22,	8,	24,	17,	1},
{21,	1,	24,	19,	24},
{22,	5,	22,	19,	24},
{22,	4,	23,	19,	24},
{21,	3,	26,	13,	30},
{24,	2,	23,	10,	31},
{22,	15,	23,	11,	30},
{23,	10,	25,	13,	29},
{23,	21,	23,	10,	29},
{22,	2,	29,	10,	27},
{21,	15,	27,	7,	30},
{25,	18,	24,	4,	33},
{24,	7,	28,	7,	28},
{24,	17,	24,	5,	33},
{24,	10,	27,	8,	30},
{23,	16,	27,	4,	31},
{23,	9,	25,	13,	30},
{23,	17,	26,	7,	7},
{22,	19,	24,	10,	29},
{23,	17,	25,	7,	30},
{23,	18,	25,	4,	33},
{22,	14,	24,	6,	32},
{23,	10,	23,	7,	33},
{22,	21,	24,	4,	31},
{22,	21,	25,	4,	30},
{22,	26,	25,	2,	30},
{23,	26,	24,	0,	34},
{23,	26,	23,	0,	37},
{22,	17,	25,	10,	29},
{22,	21,	24,	11,	28},
{21,	7,	36,	1,	35},
{25,	14,	29,	1,	34},
{23,	7,	28,	4,	31},
{24,	1,	30,	3,	31},
{22,	1,	33,	2,	32},
{24,	2,	33,	5,	29},
{22,	0,	31,	6,	29},
{22,	7,	33,	2,	29},
{22,	2,	29,	5,	30},
{21,	8,	9,	22,	31},
{21,	9,	14,	24,	25},
{24,	2,	15,	22,	21},
{24,	12,	13,	24,	23},
{23,	23,	14,	22,	18},
{22,	1,	11,	26,	26},
{21,	29,	24,	2,	30},
{22,	29,	25,	0,	33},
{22,	28,	22,	1,	32},
{22,	28,	26,	0,	33},
{21,	2,	37,	8,	4},
{26,	2,	36,	3,	22},
{25,	2,	37,	3,	22},
{25,	2,	36,	5,	12},
{24,	2,	37,	10,	0},
{23,	2,	38,	5,	2},
{22,	1,	38,	4,	9},
{23,	3,	38,	3,	14},
{22,	6,	32,	4,	16},
{21,	4,	8,	31,	5},
{21,	24,	24,	7,	27},
{22,	25,	24,	5,	3},
{21,	3,	23,	16,	29},
{23,	9,	22,	16,	29},
{22,	9,	22,	17,	27},
{21,	25,	24,	5,	27},
{22,	26,	23,	3,	15},
{21,	39,	2,	32,	2},
{21,	9,	23,	13,	31},
{21,	9,	21,	13,	33},
{21,	4,	14,	30,	6},
{24,	11,	14,	30,	2},
{23,	6,	14,	28,	11},
{22,	8,	14,	27,	13},
{23,	6,	12,	28,	15},
{22,	10,	16,	27,	0},
{21,	20,	21,	10,	32},
{24,	21,	22,	9,	31},
{22,	20,	18,	13,	32},
{22,	17,	19,	10,	33},
{24,	21,	18,	11,	33},
{21,	32,	22,	0,	26},
{25,	30,	21,	2,	26},
{21,	27,	18,	13,	24},
{24,	27,	18,	12,	27},
{22,	25,	20,	13,	25},
{22,	26,	20,	12,	18},
{22,	39,	17,	13,	14},
{22,	39,	15,	12,	32},
{21,	8,	25,	7,	33},
{23,	13,	25,	6,	33},
{23,	14,	27,	6,	31},
{21,	10,	16,	16,	35},
{21,	5,	17,	13,	36},
{24,	12,	16,	11,	37},
{23,	26,	16,	6,	37},
{24,	15,	19,	6,	37},
{23,	25,	17,	6,	37},
{22,	39,	16,	6,	37},
{21,	28,	22,	4,	21},
{21,	22,	24,	13,	22},
{22,	22,	25,	9,	11},
{21,	17,	21,	8,	34},
{21,	2,	34,	7,	26},
{23,	0,	34,	12,	23},
{23,	3,	34,	3,	29},
{21,	39,	12,	8,	38},
{21,	2,	36,	11,	4},
{23,	2,	37,	10,	2},
{21,	22,	17,	19,	24},
{23,	19,	18,	19,	25},
{21,	6,	22,	10,	33},
{21,	3,	24,	10,	32},
{21,	20,	29,	2,	16},
{25,	21,	27,	1,	31},
{23,	22,	28,	2,	5},
{23,	24,	29,	2,	1},
{22,	19,	31,	1,	14},
{22,	21,	27,	2,	30},
{22,	19,	27,	3,	28},
{22,	19,	26,	4,	27},
{22,	18,	26,	5,	22},
{21,	17,	27,	4,	32},
{24,	1,	29,	4,	32},
{24,	1,	32,	3,	32},
{21,	23,	14,	17,	31},
{25,	22,	18,	17,	27},
{22,	24,	15,	17,	29},
{21,	5,	20,	18,	28},
{21,	3,	23,	18,	27},
{22,	12,	21,	18,	27},
{21,	39,	16,	8,	34},
{23,	27,	17,	7,	33},
{22,	26,	17,	12,	31},
{23,	25,	18,	13,	29},
{23,	26,	17,	13,	30},
{21,	0,	31,	8,	29},
{21,	39,	17,	13,	24},
{21,	17,	19,	10,	34},
{22,	12,	18,	11,	35},
{21,	16,	20,	7,	36},
{21,	14,	21,	6,	38},
{22,	18,	15,	6,	38},
{21,	7,	22,	6,	38},
{21,	0,	22,	19,	26},
{23,	8,	20,	19,	28},
{23,	12,	21,	19,	27},
{21,	39,	10,	24,	21},
{23,	39,	9,	25,	24},
{22,	19,	12,	24,	14},
{22,	20,	14,	22,	21},
{23,	16,	12,	23,	25},
{21,	16,	25,	4,	34},
{23,	14,	26,	2,	35},
{23,	20,	25,	3,	34},
{21,	3,	18,	23,	2},
{23,	1,	16,	23,	7},
{21,	10,	18,	22,	9},
{21,	39,	20,	3,	10},
{21,	26,	15,	16,	17},
{22,	39,	16,	16,	7},
{21,	18,	27,	3,	33},
{23,	1,	30,	3,	33},
{21,	7,	12,	26,	23},
{21,	1,	32,	0,	38},
{21,	1,	32,	1,	37},
{21,	19,	34,	0,	20},
{21,	20,	18,	8,	35},
{21,	11,	30,	4,	15},
{21,	18,	20,	17,	27},
{21,	14,	21,	19,	26},
{21,	5,	14,	23,	26},
{21,	8,	14,	26,	15},
{24,	4,	13,	27,	17},
{21,	3,	36,	3,	25},
{21,	12,	28,	3,	33},
{22,	10,	29,	4,	26},
{23,	8,	28,	8,	22},
{22,	9,	28,	7,	28},
{21,	12,	28,	6,	28},
{23,	13,	28,	6,	22},
{23,	19,	28,	2,	27},
{22,	15,	31,	1,	28},
{22,	11,	32,	2,	26},
{22,	8,	31,	4,	18},
{23,	6,	31,	4,	28},
{21,	18,	28,	4,	27},
{22,	14,	28,	5,	31},
{22,	16,	29,	3,	13},
{22,	15,	29,	3,	27},
{21,	4,	30,	10,	21},
{23,	6,	29,	8,	21},
{21,	25,	23,	6,	13},
{21,	19,	28,	4,	16},
{21,	27,	21,	6,	30},
{21,	14,	19,	21,	19},
{21,	10,	28,	8,	21},
{21,	25,	16,	13,	32},
{21,	15,	12,	28,	7},
{22,	16,	11,	29,	5},
{21,	39,	19,	2,	28},
{21,	13,	25,	13,	29},
{21,	29,	19,	7,	6},
{21,	39,	18,	12,	4},
{21,	26,	19,	12,	26},
{21,	17,	26,	4,	33},
{21,	8,	25,	8,	32},
{21,	23,	18,	17,	6},
{21,	39,	9,	26,	22},
{21,	25,	21,	4,	31},
{21,	12,	38,	0,	23},
{21,	0,	38,	3,	22},
{21,	26,	19,	10,	29},
{21,	30,	21,	0,	38},
{21,	25,	18,	13,	30},
{22,	24,	22,	8,	30},
{22,	24,	21,	10,	29},
{21,	13,	21,	10,	33},
{21,	17,	26,	8,	5},
{21,	7,	15,	10,	38},
{21,	39,	11,	24,	14},
{22,	39,	11,	26,	10},
{21,	12,	34,	1,	28},
{21,	5,	30,	6,	24},
{21,	39,	18,	3,	32},
{21,	23,	17,	19,	17},
{21,	19,	30,	1,	23},
{21,	26,	20,	10,	28},
{21,	17,	17,	22,	2},
{21,	23,	21,	4,	33},
{21,	20,	18,	7,	36},
{21,	21,	18,	6,	37},
{22,	16,	21,	6,	37},
{22,	22,	18,	7,	35},
{22,	25,	18,	5,	35},
{21,	16,	26,	6,	22},
{21,	17,	26,	7,	13},
{21,	1,	34,	2,	33},
{21,	39,	12,	18,	33},
{21,	27,	19,	11,	26},
{21,	17,	22,	4,	35},
{21,	29,	20,	2,	33},
{21,	29,	19,	6,	17},
{21,	27,	19,	5,	32},
{21,	25,	23,	5,	29},
{21,	26,	17,	10,	33},
{21,	0,	34,	13,	23},
{21,	14,	17,	22,	8},
{21,	27,	18,	7,	31},
{21,	24,	18,	11,	31},
{21,	24,	19,	8,	32},
{22,	23,	18,	8,	34},
{22,	23,	21,	7,	31},
{21,	23,	20,	8,	32},
{20,	8,	30,	18,	28},
{26,	2,	31,	16,	0},
{23,	9,	23,	16,	25},
{22,	11,	26,	9,	29},
{22,	12,	23,	14,	21},
{22,	11,	23,	16,	21},
{22,	10,	24,	16,	10},
{22,	6,	23,	19,	23},
{22,	12,	27,	13,	1},
{21,	12,	27,	13,	22},
{23,	10,	27,	12,	28},
{22,	12,	28,	10,	3},
{23,	9,	28,	13,	16},
{21,	16,	26,	13,	19},
{23,	13,	27,	10,	19},
{23,	13,	26,	10,	28},
{22,	17,	26,	7,	30},
{22,	17,	26,	11,	19},
{21,	14,	22,	19,	26},
{22,	7,	24,	19,	23},
{22,	4,	24,	19,	25},
{21,	3,	26,	16,	29},
{21,	15,	26,	13,	26},
{22,	16,	26,	13,	25},
{21,	0,	31,	16,	2},
{21,	18,	26,	10,	9},
{23,	18,	26,	6,	27},
{22,	19,	27,	6,	2},
{21,	10,	23,	18,	13},
{22,	10,	25,	17,	2},
{21,	8,	26,	19,	0},
{21,	7,	25,	19,	3},
{21,	9,	24,	16,	25},
{21,	2,	32,	14,	0},
{21,	14,	26,	13,	28},
{21,	5,	31,	11,	1},
{21,	0,	31,	15,	3},
{21,	8,	31,	10,	1},
{20,	15,	14,	19,	36},
{22,	39,	7,	18,	36},
{20,	12,	19,	28,	26},
{26,	13,	17,	25,	16},
{24,	8,	20,	21,	21},
{23,	14,	9,	28,	26},
{23,	16,	11,	28,	17},
{22,	13,	17,	28,	14},
{24,	16,	15,	28,	2},
{23,	16,	14,	23,	21},
{22,	14,	18,	22,	21},
{22,	14,	19,	23,	14},
{23,	16,	15,	23,	25},
{24,	15,	18,	23,	15},
{22,	5,	21,	20,	20},
{22,	16,	7,	30,	18},
{22,	17,	15,	26,	4},
{23,	19,	14,	23,	18},
{21,	12,	20,	24,	21},
{22,	14,	20,	21,	21},
{21,	39,	5,	28,	27},
{21,	13,	20,	21,	27},
{25,	5,	20,	24,	23},
{22,	13,	19,	21,	28},
{22,	5,	20,	24,	24},
{21,	4,	9,	29,	20},
{21,	9,	9,	30,	18},
{21,	10,	15,	29,	3},
{22,	9,	16,	29,	2},
{21,	19,	15,	24,	4},
{21,	16,	17,	22,	24},
{22,	19,	17,	22,	5},
{21,	16,	17,	23,	17},
{21,	19,	17,	23,	5},
{21,	39,	5,	31,	5},
{21,	12,	12,	30,	6},
{21,	11,	12,	30,	11},
{23,	9,	11,	29,	15},
{22,	5,	14,	30,	8},
{21,	9,	11,	30,	16},
{21,	3,	11,	30,	19},
{20,	23,	21,	7,	39},
{25,	7,	22,	5,	39},
{23,	39,	14,	6,	38},
{25,	24,	19,	4,	39},
{22,	22,	16,	10,	37},
{22,	39,	13,	7,	39},
{22,	12,	14,	10,	38},
{22,	19,	21,	9,	33},
{21,	22,	22,	4,	36},
{23,	26,	22,	1,	36},
{21,	21,	22,	7,	34},
{21,	19,	24,	6,	33},
{22,	25,	23,	5,	30},
{22,	22,	24,	5,	31},
{21,	17,	26,	7,	31},
{21,	16,	22,	4,	39},
{21,	23,	24,	6,	30},
{23,	22,	23,	7,	31},
{22,	21,	24,	7,	31},
{21,	19,	25,	5,	33},
{21,	19,	20,	9,	34},
{22,	21,	18,	11,	34},
{21,	20,	23,	7,	32},
{21,	21,	24,	1,	35},
{21,	22,	23,	2,	35},
{21,	10,	24,	2,	38},
{21,	20,	24,	6,	33},
{20,	13,	12,	24,	33},
{26,	7,	13,	26,	27},
{23,	14,	12,	22,	33},
{22,	4,	12,	26,	29},
{22,	39,	6,	24,	33},
{22,	16,	14,	23,	27},
{21,	18,	9,	24,	30},
{22,	20,	11,	23,	29},
{21,	4,	14,	20,	33},
{23,	15,	13,	21,	32},
{21,	10,	19,	22,	27},
{21,	18,	11,	24,	29},
{22,	15,	11,	26,	28},
{21,	16,	13,	24,	27},
{22,	14,	17,	26,	14},
{24,	17,	15,	24,	15},
{23,	19,	15,	24,	12},
{22,	19,	15,	21,	22},
{22,	17,	16,	21,	25},
{22,	14,	15,	25,	24},
{22,	23,	15,	22,	7},
{21,	20,	16,	22,	20},
{21,	19,	17,	21,	19},
{21,	21,	13,	24,	10},
{22,	20,	17,	23,	6},
{21,	22,	17,	23,	6},
{21,	14,	20,	24,	4},
{21,	21,	16,	21,	20},
{21,	19,	16,	25,	1},
{22,	19,	16,	24,	12},
{20,	12,	19,	13,	38},
{24,	20,	16,	13,	35},
{23,	19,	18,	13,	34},
{23,	14,	17,	13,	36},
{22,	17,	20,	12,	31},
{22,	18,	16,	16,	35},
{22,	16,	19,	16,	31},
{22,	11,	21,	13,	33},
{21,	15,	10,	13,	38},
{21,	17,	19,	13,	33},
{22,	21,	19,	13,	32},
{21,	23,	20,	11,	31},
{22,	25,	20,	10,	30},
{21,	21,	22,	10,	31},
{23,	16,	22,	12,	31},
{21,	15,	23,	10,	32},
{21,	21,	23,	10,	31},
{21,	14,	21,	8,	37},
{22,	13,	18,	13,	37},
{21,	18,	24,	9,	31},
{21,	16,	21,	12,	32},
{21,	13,	23,	13,	31},
{21,	18,	18,	8,	37},
{21,	22,	18,	8,	36},
{21,	17,	21,	8,	36},
{21,	18,	19,	10,	36},
{22,	21,	18,	10,	36},
{21,	21,	20,	13,	31},
{21,	20,	20,	13,	32},
{20,	27,	26,	7,	27},
{24,	28,	25,	2,	27},
{23,	26,	26,	2,	30},
{22,	24,	27,	2,	30},
{22,	21,	26,	6,	31},
{22,	27,	22,	7,	29},
{22,	20,	27,	4,	11},
{22,	25,	23,	7,	29},
{22,	20,	25,	6,	33},
{22,	22,	28,	2,	14},
{22,	20,	28,	3,	19},
{23,	21,	27,	3,	29},
{23,	24,	27,	3,	20},
{21,	24,	27,	4,	27},
{21,	19,	28,	5,	27},
{23,	16,	27,	7,	17},
{21,	28,	22,	8,	8},
{21,	28,	26,	2,	30},
{21,	19,	27,	6,	20},
{22,	16,	27,	7,	30},
{21,	29,	23,	3,	17},
{21,	28,	20,	8,	20},
{21,	17,	27,	7,	21},
{21,	22,	25,	8,	27},
{21,	18,	26,	8,	27},
{20,	16,	7,	30,	27},
{23,	8,	11,	29,	21},
{22,	16,	9,	28,	27},
{21,	17,	11,	26,	28},
{20,	39,	19,	13,	27},
{21,	28,	19,	16,	2},
{23,	26,	20,	16,	2},
{21,	39,	17,	13,	29},
{21,	25,	19,	16,	11},
{23,	27,	18,	15,	7},
{21,	30,	19,	5,	29},
{21,	28,	18,	11,	29},
{20,	2,	36,	10,	28},
{23,	1,	35,	11,	25},
{22,	1,	31,	13,	27},
{21,	2,	32,	13,	28},
{21,	3,	37,	3,	27},
{21,	0,	34,	6,	29},
{21,	2,	33,	11,	28},
{21,	0,	33,	12,	27},
{21,	0,	33,	7,	29},
{20,	17,	11,	21,	34},
{20,	15,	12,	26,	31},
{24,	15,	16,	26,	17},
{21,	16,	16,	28,	4},
{20,	21,	23,	16,	26},
{24,	13,	23,	18,	5},
{22,	24,	21,	16,	1},
{20,	1,	26,	7,	36},
{24,	10,	26,	4,	35},
{23,	15,	22,	7,	35},
{22,	5,	23,	7,	36},
{21,	1,	22,	7,	38},
{21,	4,	28,	5,	32},
{21,	4,	27,	7,	32},
{21,	11,	24,	4,	36},
{21,	9,	23,	7,	35},
{20,	3,	26,	18,	30},
{25,	9,	21,	18,	30},
{23,	18,	19,	17,	29},
{22,	11,	21,	18,	29},
{21,	8,	23,	14,	31},
{21,	5,	21,	16,	32},
{21,	2,	22,	16,	32},
{21,	11,	19,	19,	30},
{21,	8,	21,	19,	30},
{21,	16,	20,	16,	31},
{20,	3,	23,	21,	20},
{25,	9,	22,	21,	15},
{23,	11,	22,	22,	0},
{22,	7,	25,	21,	0},
{21,	7,	22,	23,	0},
{21,	4,	21,	23,	2},
{21,	5,	24,	20,	2},
{20,	7,	21,	24,	24},
{25,	13,	21,	21,	25},
{22,	12,	21,	23,	9},
{20,	2,	38,	8,	19},
{24,	2,	37,	6,	22},
{23,	2,	37,	5,	27},
{21,	1,	38,	11,	1},
{21,	0,	38,	6,	21},
{20,	14,	16,	19,	34},
{23,	6,	17,	19,	32},
{23,	16,	17,	17,	32},
{22,	19,	16,	17,	32},
{21,	21,	14,	17,	33},
{21,	18,	13,	19,	33},
{20,	6,	21,	10,	38},
{21,	17,	20,	10,	34},
{20,	7,	26,	19,	24},
{22,	8,	25,	19,	24},
{20,	30,	25,	2,	30},
{22,	30,	19,	2,	33},
{20,	39,	16,	7,	39},
{22,	39,	15,	8,	37},
{21,	25,	17,	7,	39},
{20,	22,	27,	7,	27},
{23,	24,	27,	6,	9},
{22,	23,	27,	6,	17},
{21,	18,	27,	7,	29},
{21,	21,	27,	6,	29},
{20,	2,	36,	13,	22},
{25,	1,	38,	13,	1},
{20,	2,	37,	19,	0},
{22,	0,	31,	18,	1},
{21,	7,	29,	19,	1},
{21,	0,	31,	19,	1},
{20,	5,	28,	19,	23},
{24,	2,	29,	19,	6},
{21,	8,	28,	19,	10},
{20,	32,	22,	2,	28},
{21,	39,	20,	3,	15},
{20,	16,	22,	19,	26},
{21,	17,	22,	18,	24},
{20,	19,	28,	7,	26},
{21,	13,	28,	10,	14},
{22,	15,	28,	8,	10},
{21,	21,	28,	7,	1},
{21,	14,	28,	8,	21},
{21,	15,	28,	6,	29},
{21,	4,	28,	9,	29},
{20,	23,	23,	13,	28},
{20,	21,	26,	10,	24},
{22,	22,	26,	8,	23},
{20,	28,	22,	6,	30},
{21,	29,	23,	3,	25},
{20,	29,	23,	4,	26},
{23,	29,	21,	6,	3},
{22,	29,	20,	6,	27},
{22,	29,	21,	5,	26},
{22,	30,	20,	4,	15},
{21,	28,	25,	4,	17},
{21,	29,	20,	5,	30},
{21,	28,	26,	3,	16},
{20,	13,	23,	19,	26},
{20,	1,	14,	30,	19},
{20,	10,	15,	30,	16},
{22,	3,	15,	30,	19},
{21,	13,	9,	30,	19},
{21,	13,	11,	30,	16},
{20,	19,	22,	17,	18},
{20,	8,	34,	4,	29},
{23,	6,	36,	3,	28},
{21,	11,	33,	4,	2},
{22,	9,	34,	4,	14},
{21,	10,	33,	4,	14},
{21,	11,	32,	3,	24},
{21,	10,	32,	4,	26},
{20,	14,	24,	16,	26},
{21,	15,	24,	16,	18},
{21,	12,	25,	16,	4},
{20,	3,	22,	21,	26},
{21,	3,	23,	20,	24},
{20,	27,	22,	7,	31},
{20,	26,	21,	6,	35},
{25,	27,	21,	4,	34},
{22,	24,	22,	4,	33},
{23,	27,	22,	5,	32},
{22,	27,	19,	5,	35},
{21,	27,	18,	6,	36},
{22,	26,	19,	6,	36},
{21,	26,	22,	2,	36},
{21,	24,	21,	7,	33},
{20,	27,	18,	7,	38},
{23,	24,	20,	7,	36},
{22,	26,	20,	6,	36},
{22,	25,	19,	8,	33},
{21,	28,	18,	7,	33},
{21,	26,	22,	7,	32},
{21,	25,	21,	3,	38},
{21,	39,	17,	5,	34},
{21,	28,	18,	6,	34},
{20,	13,	16,	18,	35},
{22,	14,	15,	19,	35},
{20,	8,	34,	2,	35},
{23,	2,	27,	2,	37},
{21,	10,	29,	3,	35},
{21,	13,	28,	3,	35},
{20,	16,	24,	7,	35},
{22,	20,	25,	3,	35},
{21,	20,	25,	4,	35},
{21,	15,	25,	8,	32},
{20,	1,	27,	7,	35},
{22,	12,	28,	4,	35},
{21,	2,	28,	5,	34},
{20,	4,	24,	20,	11},
{20,	39,	20,	5,	15},
{20,	2,	27,	2,	39},
{20,	2,	26,	4,	38},
{23,	5,	24,	3,	39},
{22,	4,	23,	5,	38},
{22,	13,	23,	3,	39},
{20,	7,	25,	4,	39},
{21,	10,	24,	4,	39},
{21,	5,	26,	3,	39},
{20,	39,	14,	17,	31},
{20,	39,	16,	15,	29},
{24,	25,	18,	16,	19},
{23,	26,	16,	16,	29},
{22,	23,	16,	17,	29},
{22,	25,	18,	15,	22},
{21,	27,	18,	15,	21},
{23,	26,	19,	15,	14},
{21,	26,	18,	16,	21},
{21,	27,	19,	16,	8},
{20,	26,	16,	19,	14},
{23,	39,	16,	18,	3},
{21,	25,	16,	19,	21},
{21,	26,	16,	18,	18},
{20,	11,	25,	15,	29},
{21,	11,	23,	18,	28},
{21,	11,	23,	16,	30},
{21,	5,	23,	16,	31},
{21,	6,	24,	17,	30},
{21,	7,	26,	15,	30},
{21,	12,	26,	11,	30},
{23,	14,	24,	10,	32},
{20,	11,	30,	7,	10},
{22,	11,	30,	6,	15},
{21,	9,	30,	13,	11},
{23,	11,	29,	11,	8},
{23,	12,	29,	8,	11},
{20,	10,	32,	6,	26},
{23,	5,	36,	8,	0},
{23,	3,	34,	6,	28},
{22,	8,	33,	5,	27},
{23,	4,	35,	6,	12},
{21,	8,	31,	10,	15},
{24,	4,	35,	8,	7},
{24,	3,	32,	10,	28},
{23,	6,	32,	8,	18},
{22,	5,	32,	8,	28},
{22,	4,	33,	8,	28},
{22,	8,	31,	9,	25},
{21,	9,	30,	10,	26},
{21,	4,	35,	6,	28},
{21,	3,	34,	10,	16},
{21,	4,	35,	9,	14},
{21,	5,	31,	11,	24},
{21,	5,	32,	11,	10},
{21,	3,	31,	13,	28},
{21,	14,	28,	8,	26},
{21,	12,	27,	12,	27},
{20,	18,	26,	7,	33},
{22,	21,	24,	7,	32},
{22,	14,	28,	5,	33},
{20,	39,	17,	15,	22},
{22,	28,	19,	16,	8},
{20,	0,	33,	16,	1},
{20,	14,	27,	12,	23},
{22,	13,	28,	13,	3},
{22,	11,	29,	13,	7},
{22,	10,	30,	13,	7},
{20,	39,	18,	7,	31},
{22,	39,	18,	11,	29},
{20,	29,	20,	7,	30},
{21,	29,	20,	8,	20},
{21,	29,	21,	7,	6},
{20,	27,	20,	11,	23},
{20,	20,	23,	7,	35},
{20,	1,	19,	30,	0},
{20,	17,	19,	13,	35},
{20,	4,	32,	2,	37},
{21,	4,	28,	2,	38},
{20,	39,	21,	2,	30},
{20,	20,	18,	16,	31},
{21,	21,	20,	14,	31},
{20,	17,	21,	16,	30},
{22,	21,	21,	16,	28},
{21,	13,	21,	20,	27},
{20,	20,	22,	7,	36},
{22,	10,	24,	7,	36},
{20,	13,	23,	6,	39},
{20,	13,	15,	17,	36},
{20,	6,	34,	8,	13},
{24,	9,	33,	6,	19},
{21,	5,	35,	7,	16},
{21,	7,	34,	9,	2},
{20,	20,	16,	13,	37},
{22,	17,	18,	13,	36},
{20,	1,	23,	7,	38},
{20,	24,	22,	2,	38},
{20,	19,	22,	6,	39},
{22,	22,	22,	4,	38},
{20,	23,	26,	8,	23},
{21,	27,	25,	8,	0},
{20,	32,	23,	0,	29},
{22,	32,	23,	4,	0},
{21,	39,	23,	0,	5},
{20,	6,	19,	21,	30},
{20,	14,	24,	16,	29},
{21,	21,	22,	16,	28},
{23,	17,	22,	16,	30},
{20,	20,	10,	12,	38},
{21,	18,	9,	13,	38},
{20,	29,	24,	4,	14},
{22,	29,	25,	3,	17},
{20,	5,	25,	21,	1},
{20,	3,	36,	8,	28},
{22,	3,	36,	11,	13},
{20,	16,	28,	8,	26},
{20,	16,	27,	12,	22},
{20,	11,	29,	8,	24},
{20,	17,	29,	5,	26},
{24,	18,	29,	7,	2},
{22,	13,	29,	9,	9},
{20,	22,	34,	0,	9},
{20,	18,	27,	9,	13},
{21,	23,	27,	8,	1},
{22,	23,	27,	7,	17},
{20,	25,	24,	5,	30},
{20,	17,	27,	11,	17},
{20,	39,	14,	16,	34},
{20,	39,	14,	15,	37},
{20,	21,	18,	17,	29},
{20,	14,	11,	28,	27},
{20,	19,	15,	18,	33},
{20,	28,	22,	10,	0},
{20,	27,	21,	10,	3},
{20,	26,	27,	0,	33},
{20,	24,	22,	5,	34},
{20,	21,	18,	12,	34},
{20,	29,	20,	3,	33},
{21,	39,	18,	4,	33},
{20,	15,	28,	12,	3},
{20,	9,	39,	1,	2},
{20,	14,	27,	0,	39},
{20,	4,	32,	11,	28},
{20,	8,	33,	3,	31},
{20,	5,	32,	7,	29},
{20,	8,	29,	8,	30},
{23,	0,	28,	6,	32},
{20,	5,	35,	6,	29},
{20,	0,	28,	6,	33},
{20,	39,	18,	16,	1},
{20,	39,	16,	17,	8},
{20,	22,	27,	0,	35},
{20,	18,	27,	3,	35},
{20,	15,	33,	0,	34},
{20,	39,	10,	29,	1},
{20,	21,	12,	28,	3},
{21,	39,	11,	28,	8},
{21,	19,	15,	28,	1},
{21,	18,	16,	28,	3},
{20,	21,	15,	26,	5},
{22,	21,	17,	25,	1},
{20,	39,	8,	29,	17},
{20,	12,	28,	13,	11},
{20,	26,	16,	16,	30},
{20,	26,	24,	4,	29},
{20,	22,	26,	9,	17},
{20,	21,	16,	24,	9},
{20,	15,	28,	10,	10},
{20,	19,	18,	24,	0},
{20,	24,	16,	15,	32},
{20,	23,	16,	15,	34},
{20,	24,	16,	12,	35},
{20,	25,	17,	13,	33},
{20,	22,	17,	15,	32},
{20,	5,	34,	9,	20},
{20,	26,	21,	16,	0},
{20,	21,	11,	10,	38},
{20,	16,	18,	23,	17},
{20,	11,	31,	6,	12},
{20,	32,	24,	2,	1},
{20,	31,	27,	1,	0},
{20,	17,	20,	13,	33},
{20,	14,	21,	13,	33},
{20,	21,	28,	1,	28},
{20,	16,	21,	19,	27},
{20,	13,	27,	12,	28},
{20,	2,	37,	5,	28},
{21,	4,	37,	1,	33},
{20,	19,	16,	19,	27},
{20,	18,	15,	21,	27},
{20,	19,	29,	5,	4},
{21,	18,	29,	5,	14},
{20,	10,	25,	16,	29},
{20,	6,	30,	3,	35},
{20,	6,	22,	21,	23},
{20,	6,	22,	20,	27},
{20,	4,	23,	20,	25},
{20,	1,	6,	32,	1},
{20,	27,	17,	6,	39},
{20,	28,	23,	0,	36},
{20,	29,	27,	0,	35},
{21,	29,	26,	2,	18},
{20,	28,	28,	0,	29},
{20,	30,	27,	0,	28},
{21,	30,	26,	2,	7},
{20,	30,	26,	2,	26},
{20,	22,	24,	12,	25},
{20,	10,	29,	8,	29},
{20,	10,	29,	4,	33},
{20,	0,	38,	8,	20},
{20,	17,	27,	7,	31},
{20,	1,	39,	5,	0},
{20,	39,	13,	19,	26},
{20,	18,	14,	20,	31},
{20,	39,	14,	21,	5},
{20,	19,	33,	0,	27},
{21,	19,	31,	1,	25},
{20,	21,	24,	13,	28},
{20,	18,	21,	15,	30},
{20,	39,	20,	3,	19},
{21,	39,	20,	5,	17},
{20,	30,	20,	4,	30},
{20,	16,	9,	30,	19},
{20,	9,	29,	17,	0},
{21,	9,	29,	16,	4},
{20,	39,	9,	30,	9},
{20,	24,	14,	17,	32},
{20,	13,	15,	28,	23},
{20,	15,	15,	26,	23},
{20,	6,	36,	4,	25},
{19,	4,	36,	21,	24},
{24,	7,	30,	19,	20},
{23,	4,	33,	13,	26},
{22,	5,	30,	20,	8},
{21,	5,	36,	8,	27},
{21,	5,	34,	10,	24},
{21,	7,	27,	20,	4},
{22,	7,	30,	21,	1},
{21,	4,	31,	15,	25},
{20,	4,	33,	18,	25},
{20,	5,	32,	19,	24},
{20,	7,	31,	13,	24},
{20,	6,	31,	19,	19},
{21,	8,	31,	16,	7},
{20,	5,	33,	19,	8},
{20,	4,	34,	11,	27},
{20,	4,	24,	20,	25},
{19,	13,	15,	33,	20},
{23,	16,	10,	31,	17},
{22,	14,	11,	30,	21},
{22,	17,	14,	29,	4},
{21,	16,	9,	30,	22},
{21,	39,	8,	32,	16},
{21,	13,	13,	30,	21},
{21,	10,	12,	30,	22},
{20,	15,	14,	29,	10},
{21,	14,	13,	32,	14},
{22,	18,	15,	32,	0},
{20,	18,	14,	30,	4},
{20,	20,	10,	29,	14},
{20,	17,	10,	28,	27},
{19,	18,	16,	16,	38},
{21,	39,	13,	10,	38},
{23,	21,	15,	10,	38},
{21,	14,	18,	13,	38},
{20,	20,	11,	13,	38},
{19,	4,	26,	24,	23},
{25,	6,	22,	23,	24},
{21,	8,	25,	22,	2},
{21,	4,	23,	23,	24},
{20,	7,	27,	22,	0},
{20,	10,	22,	22,	12},
{19,	28,	23,	13,	27},
{24,	25,	22,	13,	28},
{23,	29,	20,	12,	16},
{23,	24,	24,	8,	26},
{21,	29,	20,	10,	27},
{21,	27,	22,	8,	30},
{21,	29,	20,	10,	28},
{21,	28,	21,	16,	0},
{20,	27,	18,	10,	33},
{22,	25,	19,	10,	32},
{22,	27,	16,	13,	31},
{21,	23,	20,	12,	32},
{20,	24,	18,	10,	36},
{21,	24,	17,	13,	34},
{20,	25,	25,	8,	25},
{20,	25,	24,	10,	24},
{20,	29,	23,	5,	24},
{20,	29,	23,	7,	10},
{20,	29,	22,	7,	30},
{20,	31,	21,	4,	30},
{20,	30,	22,	3,	30},
{21,	31,	22,	3,	18},
{20,	30,	25,	3,	18},
{20,	23,	20,	13,	32},
{22,	26,	18,	13,	31},
{21,	22,	20,	15,	30},
{20,	26,	16,	15,	32},
{20,	25,	23,	13,	28},
{20,	30,	23,	5,	2},
{20,	29,	22,	12,	0},
{20,	26,	21,	13,	28},
{20,	27,	16,	14,	32},
{19,	3,	23,	26,	23},
{25,	3,	21,	28,	0},
{21,	6,	20,	26,	23},
{20,	12,	20,	26,	24},
{20,	14,	20,	22,	22},
{20,	12,	20,	27,	1},
{19,	12,	26,	10,	35},
{23,	17,	24,	8,	34},
{22,	2,	27,	9,	33},
{22,	15,	21,	10,	35},
{21,	10,	24,	8,	36},
{22,	6,	23,	9,	36},
{21,	15,	20,	10,	36},
{21,	13,	25,	10,	34},
{21,	17,	24,	8,	35},
{20,	1,	26,	8,	37},
{21,	5,	26,	6,	37},
{21,	2,	22,	8,	38},
{20,	6,	24,	7,	38},
{22,	12,	22,	8,	38},
{20,	6,	23,	10,	36},
{20,	7,	22,	10,	38},
{20,	0,	28,	8,	32},
{21,	10,	28,	8,	31},
{20,	19,	23,	8,	34},
{20,	23,	22,	8,	32},
{20,	23,	21,	10,	32},
{20,	23,	22,	10,	30},
{21,	22,	23,	10,	31},
{20,	22,	24,	8,	30},
{19,	27,	26,	7,	32},
{24,	23,	27,	1,	34},
{21,	26,	24,	1,	35},
{21,	29,	24,	1,	32},
{21,	22,	27,	7,	29},
{21,	20,	25,	9,	30},
{21,	23,	27,	2,	33},
{20,	28,	22,	7,	32},
{20,	23,	26,	5,	33},
{23,	21,	23,	7,	35},
{21,	21,	22,	6,	38},
{21,	25,	23,	5,	33},
{21,	21,	25,	7,	33},
{20,	28,	26,	2,	32},
{20,	26,	23,	13,	28},
{20,	18,	25,	9,	32},
{20,	29,	23,	5,	28},
{20,	19,	23,	10,	32},
{20,	28,	21,	4,	33},
{20,	22,	22,	6,	35},
{20,	22,	25,	7,	33},
{19,	17,	11,	28,	30},
{19,	25,	29,	4,	27},
{24,	22,	28,	5,	24},
{23,	22,	29,	5,	24},
{22,	23,	32,	0,	15},
{22,	28,	27,	1,	7},
{22,	27,	29,	0,	20},
{21,	25,	27,	1,	34},
{21,	25,	27,	5,	14},
{20,	22,	31,	0,	27},
{20,	26,	31,	1,	0},
{20,	26,	33,	0,	16},
{20,	25,	27,	5,	21},
{20,	30,	35,	0,	0},
{20,	30,	28,	0,	28},
{21,	29,	29,	0,	17},
{19,	31,	22,	7,	28},
{22,	31,	22,	5,	30},
{22,	30,	23,	4,	18},
{21,	30,	20,	9,	28},
{21,	31,	20,	10,	5},
{23,	31,	20,	9,	15},
{21,	39,	20,	6,	27},
{20,	31,	20,	8,	23},
{20,	39,	19,	6,	30},
{19,	21,	32,	4,	26},
{23,	15,	31,	6,	2},
{23,	15,	31,	5,	16},
{21,	13,	32,	6,	4},
{21,	18,	30,	5,	14},
{21,	24,	32,	0,	26},
{20,	19,	34,	1,	18},
{22,	21,	33,	1,	24},
{21,	16,	34,	2,	19},
{20,	19,	32,	4,	27},
{21,	14,	32,	3,	31},
{21,	16,	32,	4,	28},
{20,	13,	32,	5,	26},
{20,	12,	32,	5,	29},
{20,	15,	31,	5,	27},
{20,	17,	31,	5,	22},
{21,	16,	32,	6,	2},
{20,	14,	32,	2,	33},
{20,	18,	32,	4,	28},
{22,	19,	32,	0,	34},
{21,	25,	29,	0,	32},
{20,	17,	29,	1,	35},
{20,	17,	33,	1,	31},
{20,	23,	33,	0,	29},
{20,	15,	34,	1,	33},
{20,	21,	28,	1,	34},
{19,	28,	18,	17,	26},
{24,	26,	17,	19,	10},
{23,	25,	18,	17,	27},
{23,	29,	18,	17,	3},
{22,	24,	17,	19,	23},
{20,	29,	18,	16,	21},
{20,	29,	18,	17,	18},
{20,	26,	17,	15,	31},
{20,	27,	18,	16,	28},
{20,	29,	19,	16,	10},
{20,	39,	18,	18,	0},
{20,	27,	17,	18,	14},
{19,	28,	21,	16,	24},
{24,	26,	19,	16,	27},
{20,	29,	19,	16,	21},
{19,	10,	19,	26,	29},
{21,	13,	13,	24,	30},
{20,	8,	13,	24,	32},
{20,	15,	17,	22,	28},
{20,	11,	18,	26,	29},
{20,	12,	14,	23,	31},
{22,	13,	15,	23,	30},
{19,	3,	37,	13,	23},
{22,	3,	37,	10,	24},
{22,	1,	38,	12,	2},
{20,	3,	37,	6,	26},
{19,	1,	39,	18,	1},
{24,	1,	39,	9,	2},
{21,	2,	37,	15,	2},
{20,	1,	37,	21,	1},
{20,	2,	37,	18,	2},
{20,	3,	39,	2,	6},
{20,	1,	39,	5,	4},
{19,	6,	21,	13,	37},
{20,	16,	20,	13,	35},
{19,	2,	35,	7,	31},
{25,	8,	30,	8,	31},
{23,	6,	32,	4,	32},
{22,	12,	30,	4,	33},
{21,	9,	34,	4,	31},
{20,	6,	31,	8,	30},
{19,	0,	23,	21,	30},
{21,	11,	20,	20,	30},
{20,	13,	23,	19,	27},
{20,	3,	23,	21,	29},
{19,	17,	18,	16,	35},
{23,	22,	17,	15,	34},
{21,	19,	18,	15,	34},
{19,	9,	20,	19,	32},
{23,	11,	19,	21,	31},
{22,	12,	21,	15,	32},
{19,	21,	26,	13,	26},
{21,	22,	26,	12,	1},
{19,	29,	24,	7,	18},
{21,	28,	25,	5,	14},
{20,	29,	23,	7,	27},
{19,	10,	34,	8,	21},
{23,	8,	32,	10,	17},
{22,	9,	34,	6,	27},
{21,	11,	32,	6,	28},
{21,	10,	32,	10,	4},
{21,	6,	34,	9,	27},
{20,	7,	33,	10,	24},
{20,	10,	33,	12,	0},
{20,	11,	34,	4,	21},
{20,	9,	31,	9,	28},
{19,	32,	24,	2,	29},
{22,	31,	24,	3,	9},
{19,	26,	15,	15,	37},
{22,	27,	16,	11,	34},
{20,	26,	15,	16,	36},
{19,	39,	18,	10,	36},
{21,	28,	18,	3,	38},
{20,	39,	17,	13,	32},
{20,	30,	19,	2,	35},
{21,	29,	20,	2,	35},
{20,	39,	16,	8,	37},
{20,	23,	18,	8,	37},
{19,	30,	19,	7,	36},
{22,	30,	20,	4,	33},
{21,	39,	19,	10,	30},
{21,	39,	19,	9,	31},
{22,	31,	21,	1,	32},
{21,	30,	22,	4,	31},
{20,	28,	19,	4,	38},
{22,	27,	20,	3,	38},
{20,	28,	17,	7,	38},
{20,	29,	20,	10,	30},
{20,	39,	21,	0,	35},
{19,	14,	23,	13,	33},
{22,	12,	23,	14,	32},
{23,	4,	23,	16,	32},
{19,	4,	27,	16,	30},
{21,	12,	27,	10,	31},
{21,	9,	28,	10,	29},
{20,	14,	27,	10,	31},
{20,	20,	26,	8,	31},
{19,	3,	25,	28,	0},
{19,	11,	24,	19,	27},
{21,	4,	24,	19,	29},
{20,	10,	25,	17,	17},
{20,	13,	24,	19,	1},
{21,	12,	25,	19,	1},
{19,	9,	30,	18,	25},
{21,	10,	27,	16,	16},
{21,	9,	28,	17,	28},
{21,	10,	26,	17,	17},
{20,	12,	27,	15,	14},
{20,	10,	25,	19,	23},
{20,	11,	29,	15,	2},
{19,	3,	25,	21,	28},
{19,	14,	24,	19,	19},
{21,	17,	23,	18,	9},
{22,	15,	24,	18,	9},
{20,	16,	23,	19,	10},
{20,	14,	23,	18,	26},
{19,	13,	26,	18,	20},
{22,	12,	27,	16,	19},
{21,	12,	27,	15,	23},
{20,	14,	25,	18,	7},
{20,	12,	27,	18,	1},
{20,	17,	25,	14,	2},
{20,	15,	25,	18,	4},
{19,	10,	17,	19,	34},
{22,	16,	17,	18,	33},
{19,	5,	35,	18,	23},
{19,	29,	21,	12,	27},
{22,	29,	22,	8,	23},
{19,	21,	28,	7,	27},
{20,	20,	28,	6,	29},
{19,	7,	28,	19,	28},
{19,	23,	19,	13,	34},
{20,	21,	18,	15,	34},
{20,	18,	19,	13,	35},
{20,	19,	19,	10,	36},
{19,	1,	27,	23,	4},
{20,	1,	27,	24,	0},
{19,	16,	9,	31,	21},
{19,	3,	25,	27,	1},
{19,	4,	21,	28,	5},
{19,	3,	35,	4,	33},
{22,	8,	33,	3,	34},
{21,	14,	32,	4,	32},
{19,	22,	27,	7,	32},
{22,	11,	27,	6,	35},
{22,	18,	27,	7,	33},
{20,	15,	27,	6,	34},
{19,	22,	22,	16,	27},
{19,	7,	25,	7,	38},
{19,	7,	25,	6,	39},
{19,	15,	17,	16,	36},
{19,	21,	22,	15,	30},
{19,	18,	20,	19,	27},
{20,	18,	17,	20,	29},
{20,	20,	19,	18,	27},
{20,	39,	13,	19,	31},
{20,	20,	16,	18,	31},
{20,	18,	16,	21,	29},
{20,	23,	13,	21,	29},
{21,	19,	14,	21,	31},
{20,	20,	16,	19,	31},
{19,	8,	31,	4,	35},
{19,	26,	16,	19,	26},
{20,	24,	15,	19,	28},
{19,	16,	28,	10,	20},
{19,	9,	16,	29,	15},
{19,	22,	26,	11,	15},
{20,	22,	25,	12,	15},
{19,	9,	21,	18,	31},
{19,	17,	13,	19,	35},
{19,	30,	23,	5,	28},
{19,	30,	25,	3,	27},
{20,	29,	24,	4,	27},
{21,	28,	25,	4,	27},
{19,	11,	16,	17,	36},
{19,	26,	18,	13,	34},
{22,	39,	16,	12,	35},
{19,	39,	14,	22,	21},
{22,	39,	14,	23,	9},
{21,	24,	15,	26,	0},
{20,	39,	11,	22,	30},
{21,	39,	11,	21,	32},
{19,	7,	31,	3,	36},
{20,	8,	32,	2,	37},
{20,	14,	28,	0,	39},
{19,	16,	19,	21,	26},
{20,	16,	19,	22,	22},
{20,	16,	19,	23,	15},
{19,	22,	19,	21,	19},
{23,	21,	18,	19,	27},
{22,	21,	19,	23,	6},
{21,	18,	20,	22,	4},
{21,	19,	19,	19,	28},
{20,	22,	19,	22,	7},
{20,	19,	19,	22,	17},
{20,	25,	18,	20,	0},
{21,	26,	15,	21,	4},
{20,	25,	15,	21,	15},
{20,	21,	19,	19,	26},
{19,	22,	20,	19,	23},
{22,	20,	20,	22,	7},
{21,	21,	20,	18,	25},
{20,	15,	20,	21,	25},
{20,	21,	22,	17,	0},
{19,	16,	21,	22,	22},
{20,	18,	21,	22,	4},
{19,	2,	39,	7,	5},
{19,	14,	23,	15,	32},
{19,	6,	25,	16,	32},
{21,	12,	25,	13,	31},
{21,	6,	26,	11,	32},
{20,	4,	26,	13,	32},
{21,	4,	27,	13,	31},
{20,	2,	26,	12,	33},
{19,	16,	21,	18,	29},
{20,	14,	23,	18,	28},
{19,	30,	21,	2,	35},
{19,	29,	22,	7,	32},
{23,	30,	21,	6,	32},
{21,	29,	20,	6,	33},
{19,	26,	27,	4,	10},
{19,	2,	18,	33,	0},
{19,	7,	29,	7,	32},
{21,	14,	28,	6,	33},
{20,	3,	29,	5,	34},
{19,	3,	28,	22,	3},
{20,	2,	29,	22,	0},
{19,	3,	25,	28,	1},
{19,	2,	39,	19,	0},
{19,	15,	15,	25,	29},
{20,	12,	18,	26,	29},
{19,	30,	23,	4,	31},
{19,	28,	25,	4,	32},
{19,	31,	24,	0,	35},
{20,	30,	22,	1,	34},
{19,	15,	26,	16,	7},
{19,	14,	26,	15,	23},
{21,	15,	25,	16,	18},
{20,	15,	25,	17,	11},
{19,	16,	33,	4,	10},
{20,	14,	34,	4,	8},
{19,	21,	20,	19,	27},
{19,	10,	22,	22,	24},
{20,	10,	22,	21,	27},
{20,	10,	21,	21,	29},
{20,	7,	20,	21,	31},
{19,	8,	25,	20,	28},
{20,	5,	29,	20,	24},
{19,	6,	28,	10,	30},
{19,	13,	17,	25,	29},
{21,	16,	18,	23,	22},
{19,	15,	17,	25,	25},
{21,	17,	17,	24,	16},
{20,	22,	19,	23,	7},
{19,	23,	17,	23,	9},
{20,	22,	17,	22,	17},
{19,	20,	19,	24,	3},
{20,	19,	17,	24,	14},
{20,	18,	19,	23,	15},
{19,	26,	33,	0,	26},
{19,	21,	23,	15,	28},
{19,	18,	21,	18,	24},
{19,	18,	21,	19,	20},
{19,	25,	21,	7,	35},
{19,	22,	23,	10,	32},
{19,	21,	23,	13,	32},
{22,	20,	23,	15,	30},
{20,	19,	24,	13,	30},
{21,	17,	25,	11,	31},
{20,	18,	24,	10,	33},
{20,	17,	21,	10,	35},
{20,	21,	20,	10,	33},
{20,	18,	21,	13,	33},
{20,	15,	21,	13,	34},
{20,	16,	22,	16,	31},
{20,	22,	21,	13,	32},
{19,	29,	26,	2,	32},
{19,	2,	31,	5,	33},
{19,	23,	24,	13,	6},
{19,	18,	23,	13,	33},
{19,	16,	33,	5,	8},
{19,	25,	19,	10,	34},
{19,	8,	31,	16,	17},
{19,	7,	26,	8,	37},
{19,	0,	38,	7,	22},
{19,	23,	18,	17,	29},
{19,	20,	10,	16,	38},
{20,	19,	15,	16,	38},
{19,	34,	24,	0,	8},
{19,	25,	24,	12,	1},
{19,	27,	21,	10,	29},
{19,	31,	23,	4,	9},
{19,	15,	27,	10,	29},
{19,	1,	38,	14,	2},
{19,	23,	27,	1,	35},
{19,	17,	29,	2,	34},
{19,	4,	24,	19,	30},
{19,	26,	23,	5,	33},
{19,	26,	24,	4,	35},
{20,	26,	22,	6,	34},
{21,	26,	22,	7,	33},
{20,	26,	25,	4,	33},
{20,	25,	22,	7,	34},
{20,	22,	23,	7,	35},
{19,	28,	22,	4,	35},
{19,	27,	20,	6,	36},
{19,	20,	13,	19,	33},
{19,	39,	12,	19,	33},
{19,	16,	32,	3,	31},
{19,	27,	24,	0,	37},
{19,	15,	21,	12,	35},
{19,	25,	17,	21,	2},
{19,	29,	22,	3,	34},
{19,	29,	20,	6,	34},
{20,	28,	20,	5,	36},
{19,	15,	16,	19,	34},
{19,	39,	8,	28,	30},
{20,	39,	10,	27,	21},
{19,	12,	20,	21,	30},
{19,	16,	20,	17,	31},
{19,	10,	33,	4,	33},
{19,	15,	34,	2,	30},
{19,	16,	37,	0,	23},
{19,	27,	33,	0,	11},
{19,	30,	28,	1,	1},
{20,	26,	28,	4,	4},
{19,	26,	28,	1,	13},
{19,	8,	22,	10,	38},
{19,	17,	21,	10,	36},
{19,	18,	22,	18,	18},
{19,	5,	23,	24,	8},
{21,	6,	25,	21,	17},
{19,	5,	26,	23,	14},
{19,	8,	24,	21,	17},
{19,	21,	29,	6,	2},
{19,	17,	19,	18,	30},
{20,	17,	17,	18,	33},
{20,	18,	18,	18,	31},
{19,	17,	27,	12,	14},
{19,	21,	19,	17,	29},
{19,	12,	25,	19,	19},
{19,	18,	16,	28,	5},
{19,	23,	23,	16,	0},
{19,	16,	19,	8,	38},
{19,	12,	19,	17,	32},
{19,	17,	18,	17,	32},
{19,	6,	23,	9,	37},
{19,	5,	32,	20,	15},
{19,	32,	24,	0,	33},
{19,	29,	22,	8,	29},
{19,	20,	10,	27,	25},
{19,	16,	11,	31,	20},
{19,	27,	30,	0,	27},
{19,	29,	30,	0,	17},
{20,	28,	33,	0,	13},
{19,	22,	26,	12,	10},
{19,	15,	27,	15,	1},
{20,	15,	27,	13,	11},
{19,	39,	21,	2,	31},
{19,	26,	21,	4,	36},
{19,	17,	14,	18,	35},
{19,	5,	35,	19,	21},
{19,	7,	29,	19,	25},
{19,	10,	22,	23,	8},
{19,	10,	22,	24,	5},
{21,	16,	21,	24,	1},
{20,	9,	21,	24,	24},
{19,	12,	21,	23,	24},
{19,	12,	21,	24,	16},
{19,	12,	21,	26,	5},
{20,	7,	21,	26,	23},
{20,	8,	22,	28,	1},
{20,	6,	22,	25,	23},
{19,	6,	25,	24,	16},
{20,	7,	27,	23,	1},
{19,	18,	17,	20,	31},
{19,	22,	18,	21,	20},
{21,	18,	17,	21,	31},
{19,	23,	17,	21,	16},
{19,	39,	19,	16,	0},
{19,	30,	20,	10,	13},
{18,	4,	35,	26,	23},
{22,	5,	26,	26,	10},
{21,	2,	25,	28,	2},
{21,	6,	25,	25,	17},
{20,	5,	27,	25,	12},
{20,	5,	27,	23,	20},
{20,	8,	24,	22,	19},
{19,	4,	37,	23,	0},
{22,	6,	38,	3,	18},
{21,	4,	39,	14,	0},
{21,	9,	39,	3,	2},
{20,	3,	36,	23,	1},
{20,	14,	37,	3,	1},
{20,	12,	35,	4,	6},
{20,	8,	36,	6,	2},
{19,	2,	24,	28,	3},
{19,	2,	23,	28,	4},
{19,	8,	24,	21,	28},
{20,	6,	25,	25,	21},
{19,	5,	28,	25,	10},
{20,	7,	28,	24,	1},
{19,	6,	39,	2,	8},
{19,	12,	39,	3,	2},
{18,	23,	14,	19,	38},
{22,	20,	15,	18,	34},
{22,	22,	15,	16,	38},
{21,	24,	14,	19,	33},
{20,	39,	13,	14,	38},
{19,	8,	16,	18,	37},
{19,	39,	15,	10,	38},
{21,	39,	16,	8,	38},
{19,	24,	15,	19,	33},
{20,	22,	17,	17,	30},
{20,	21,	18,	17,	31},
{19,	39,	11,	21,	34},
{20,	39,	9,	22,	33},
{19,	22,	16,	19,	32},
{20,	23,	17,	17,	31},
{19,	25,	15,	19,	31},
{19,	16,	16,	17,	35},
{19,	39,	9,	25,	31},
{20,	19,	11,	24,	31},
{20,	18,	10,	23,	33},
{19,	17,	10,	24,	33},
{19,	14,	15,	17,	37},
{19,	39,	13,	19,	34},
{18,	24,	23,	10,	39},
{23,	25,	23,	8,	34},
{22,	26,	16,	9,	39},
{21,	17,	24,	10,	35},
{20,	39,	17,	10,	38},
{20,	3,	25,	7,	39},
{20,	18,	26,	2,	36},
{20,	27,	19,	7,	37},
{20,	25,	23,	10,	30},
{20,	27,	23,	8,	31},
{19,	24,	24,	3,	37},
{22,	14,	24,	4,	39},
{20,	21,	26,	2,	36},
{20,	26,	24,	2,	36},
{20,	16,	26,	2,	37},
{19,	39,	16,	10,	39},
{19,	13,	28,	2,	37},
{20,	21,	27,	2,	36},
{19,	10,	28,	2,	38},
{19,	21,	26,	2,	38},
{21,	22,	27,	1,	37},
{20,	22,	27,	1,	38},
{19,	16,	26,	3,	39},
{22,	11,	26,	8,	36},
{21,	14,	29,	3,	36},
{21,	19,	27,	1,	39},
{20,	24,	25,	0,	39},
{19,	27,	24,	0,	39},
{19,	11,	24,	8,	37},
{19,	24,	24,	5,	34},
{19,	15,	18,	13,	38},
{18,	24,	24,	19,	24},
{24,	23,	19,	21,	16},
{23,	15,	24,	19,	26},
{21,	17,	25,	16,	17},
{21,	17,	24,	15,	29},
{21,	21,	24,	16,	26},
{20,	26,	21,	17,	6},
{22,	26,	20,	17,	10},
{21,	29,	19,	18,	0},
{22,	25,	19,	19,	10},
{20,	25,	21,	18,	7},
{20,	22,	23,	15,	28},
{20,	16,	25,	16,	22},
{20,	21,	24,	15,	28},
{20,	14,	24,	18,	28},
{20,	23,	19,	23,	3},
{20,	26,	18,	18,	18},
{20,	26,	19,	19,	7},
{19,	16,	25,	19,	7},
{21,	18,	25,	17,	1},
{19,	19,	25,	16,	17},
{21,	18,	25,	15,	23},
{19,	20,	25,	16,	14},
{19,	16,	23,	18,	28},
{19,	28,	20,	17,	1},
{19,	13,	26,	19,	6},
{19,	23,	19,	17,	27},
{19,	24,	18,	23,	1},
{19,	29,	19,	18,	1},
{19,	21,	24,	16,	28},
{18,	13,	11,	26,	34},
{20,	17,	9,	25,	34},
{18,	18,	14,	30,	31},
{24,	6,	15,	29,	27},
{22,	16,	15,	28,	22},
{21,	21,	15,	26,	10},
{21,	22,	13,	22,	30},
{21,	12,	15,	28,	29},
{20,	18,	16,	22,	29},
{19,	39,	12,	24,	29},
{21,	20,	12,	28,	20},
{23,	19,	14,	26,	26},
{21,	20,	14,	26,	21},
{21,	21,	13,	24,	30},
{19,	8,	16,	29,	23},
{19,	19,	17,	24,	20},
{22,	19,	15,	26,	22},
{21,	18,	18,	22,	24},
{19,	17,	15,	24,	30},
{19,	17,	10,	26,	33},
{19,	22,	12,	24,	31},
{19,	22,	15,	22,	22},
{19,	12,	17,	27,	27},
{19,	16,	16,	26,	20},
{18,	6,	38,	19,	18},
{24,	3,	37,	15,	21},
{22,	6,	37,	8,	24},
{22,	7,	33,	14,	9},
{22,	10,	32,	13,	3},
{21,	6,	35,	13,	24},
{20,	5,	36,	17,	24},
{21,	5,	37,	14,	23},
{20,	9,	37,	6,	2},
{20,	6,	39,	6,	5},
{19,	1,	37,	21,	3},
{19,	9,	31,	16,	17},
{20,	9,	31,	12,	24},
{20,	9,	32,	10,	24},
{19,	0,	38,	10,	21},
{19,	0,	38,	13,	20},
{20,	5,	38,	15,	19},
{19,	7,	34,	13,	9},
{19,	7,	35,	12,	5},
{19,	10,	32,	9,	21},
{19,	10,	31,	10,	21},
{21,	11,	29,	10,	24},
{19,	10,	30,	15,	21},
{21,	11,	29,	16,	8},
{21,	10,	31,	13,	21},
{20,	15,	28,	11,	20},
{20,	12,	28,	15,	12},
{19,	10,	32,	13,	16},
{19,	11,	32,	13,	10},
{22,	15,	32,	9,	0},
{21,	11,	32,	8,	20},
{21,	12,	30,	9,	11},
{22,	12,	33,	9,	3},
{21,	12,	33,	7,	8},
{20,	11,	30,	16,	12},
{19,	9,	33,	11,	16},
{20,	10,	34,	10,	5},
{20,	8,	34,	12,	14},
{19,	11,	33,	13,	5},
{19,	11,	31,	14,	12},
{19,	15,	32,	7,	2},
{19,	4,	39,	16,	1},
{19,	6,	38,	0,	35},
{19,	1,	39,	9,	4},
{19,	13,	33,	9,	2},
{18,	8,	9,	35,	20},
{21,	17,	8,	35,	2},
{21,	39,	5,	35,	20},
{19,	10,	14,	34,	6},
{20,	1,	10,	34,	17},
{19,	14,	11,	34,	4},
{19,	39,	6,	35,	20},
{18,	6,	23,	18,	35},
{24,	13,	20,	15,	34},
{22,	13,	19,	17,	33},
{21,	14,	20,	16,	34},
{21,	12,	20,	15,	35},
{21,	16,	19,	16,	34},
{20,	6,	18,	19,	34},
{20,	16,	23,	15,	32},
{19,	4,	25,	18,	31},
{19,	6,	20,	19,	33},
{19,	16,	19,	16,	35},
{18,	21,	31,	8,	28},
{22,	13,	32,	6,	28},
{21,	24,	29,	2,	29},
{21,	12,	33,	9,	11},
{20,	19,	27,	8,	32},
{19,	18,	28,	10,	17},
{19,	26,	28,	2,	28},
{19,	25,	25,	8,	32},
{19,	21,	29,	7,	29},
{19,	15,	30,	7,	30},
{20,	14,	30,	7,	31},
{19,	19,	28,	10,	6},
{21,	19,	27,	11,	10},
{20,	19,	28,	12,	1},
{19,	26,	29,	1,	27},
{20,	27,	29,	1,	8},
{19,	16,	28,	12,	12},
{20,	13,	28,	14,	12},
{20,	13,	27,	14,	24},
{19,	13,	27,	17,	18},
{21,	11,	27,	19,	7},
{19,	11,	29,	17,	12},
{20,	10,	29,	18,	18},
{19,	9,	27,	10,	32},
{19,	4,	27,	10,	33},
{19,	4,	27,	12,	32},
{19,	21,	25,	12,	28},
{19,	18,	26,	10,	31},
{19,	23,	24,	10,	27},
{19,	11,	30,	17,	4},
{19,	16,	32,	7,	5},
{20,	13,	32,	7,	24},
{19,	21,	26,	10,	28},
{19,	22,	29,	1,	32},
{19,	21,	29,	5,	30},
{19,	26,	27,	2,	32},
{19,	12,	28,	17,	5},
{19,	18,	27,	12,	14},
{19,	15,	27,	15,	6},
{19,	7,	29,	8,	32},
{19,	25,	28,	4,	28},
{20,	25,	27,	4,	30},
{18,	4,	32,	18,	30},
{21,	7,	29,	15,	29},
{20,	2,	35,	10,	29},
{20,	4,	33,	14,	29},
{20,	10,	30,	9,	30},
{20,	13,	29,	9,	28},
{20,	10,	30,	10,	29},
{19,	2,	34,	8,	31},
{19,	4,	33,	13,	30},
{19,	4,	33,	16,	27},
{19,	4,	33,	15,	29},
{19,	3,	34,	10,	30},
{19,	9,	31,	11,	28},
{20,	7,	31,	16,	26},
{20,	6,	36,	11,	25},
{19,	5,	33,	16,	28},
{19,	6,	32,	15,	28},
{18,	27,	25,	13,	27},
{21,	27,	25,	8,	31},
{20,	24,	24,	13,	28},
{21,	24,	25,	9,	30},
{20,	23,	25,	13,	28},
{20,	22,	26,	10,	22},
{20,	22,	24,	16,	28},
{19,	25,	24,	15,	22},
{21,	25,	23,	16,	13},
{19,	22,	25,	16,	1},
{19,	22,	26,	13,	9},
{19,	25,	22,	18,	1},
{18,	4,	35,	21,	27},
{21,	2,	26,	21,	28},
{21,	5,	35,	17,	27},
{21,	5,	32,	20,	27},
{19,	6,	36,	13,	27},
{19,	7,	31,	19,	26},
{20,	8,	31,	17,	13},
{19,	6,	32,	17,	28},
{19,	5,	35,	10,	29},
{18,	39,	9,	21,	35},
{18,	4,	26,	28,	18},
{20,	10,	20,	28,	10},
{19,	1,	20,	28,	23},
{20,	1,	21,	27,	21},
{21,	6,	21,	28,	19},
{19,	1,	21,	28,	21},
{19,	6,	24,	27,	5},
{19,	7,	26,	28,	0},
{19,	8,	23,	27,	3},
{20,	8,	25,	24,	5},
{19,	8,	23,	24,	23},
{20,	10,	22,	24,	23},
{20,	7,	25,	24,	15},
{19,	8,	25,	24,	15},
{19,	6,	24,	26,	21},
{18,	13,	32,	16,	28},
{21,	16,	28,	12,	21},
{21,	12,	30,	17,	4},
{20,	18,	25,	15,	28},
{20,	14,	26,	16,	28},
{20,	10,	29,	18,	22},
{21,	11,	29,	17,	20},
{20,	14,	29,	10,	14},
{20,	20,	25,	14,	28},
{19,	13,	27,	17,	24},
{23,	13,	25,	19,	26},
{22,	12,	27,	17,	28},
{19,	7,	32,	18,	26},
{19,	11,	33,	8,	27},
{19,	13,	27,	15,	29},
{19,	11,	33,	10,	23},
{19,	8,	32,	17,	13},
{19,	10,	33,	16,	2},
{19,	12,	33,	9,	18},
{19,	16,	29,	11,	2},
{18,	2,	31,	10,	35},
{20,	4,	28,	13,	31},
{20,	2,	32,	10,	31},
{20,	6,	31,	6,	33},
{19,	0,	28,	13,	32},
{19,	14,	28,	7,	34},
{20,	6,	28,	8,	35},
{21,	11,	27,	10,	34},
{19,	10,	29,	10,	31},
{20,	8,	28,	10,	34},
{20,	7,	30,	10,	32},
{20,	4,	34,	9,	31},
{19,	9,	28,	13,	30},
{19,	8,	31,	9,	31},
{19,	10,	33,	7,	29},
{20,	6,	35,	11,	28},
{18,	32,	22,	7,	31},
{20,	32,	23,	4,	8},
{20,	39,	21,	6,	23},
{20,	39,	20,	8,	27},
{20,	31,	20,	8,	31},
{18,	5,	39,	10,	24},
{23,	6,	38,	1,	35},
{23,	5,	39,	12,	3},
{21,	5,	39,	4,	25},
{20,	7,	39,	1,	28},
{18,	25,	26,	13,	28},
{19,	19,	26,	11,	30},
{19,	26,	25,	12,	28},
{19,	27,	25,	9,	30},
{20,	27,	23,	10,	29},
{18,	18,	10,	31,	27},
{19,	13,	14,	31,	22},
{18,	0,	24,	25,	27},
{24,	2,	20,	23,	29},
{21,	13,	21,	22,	27},
{23,	12,	20,	26,	26},
{21,	8,	23,	23,	26},
{20,	2,	25,	23,	25},
{19,	2,	24,	26,	24},
{19,	3,	20,	25,	29},
{19,	9,	21,	25,	26},
{19,	9,	22,	25,	24},
{18,	16,	29,	16,	22},
{21,	17,	26,	16,	7},
{19,	16,	26,	18,	2},
{20,	17,	26,	17,	3},
{19,	15,	30,	13,	1},
{19,	15,	32,	10,	1},
{18,	10,	27,	8,	38},
{21,	10,	29,	3,	37},
{20,	8,	31,	4,	36},
{19,	6,	29,	4,	37},
{19,	11,	24,	7,	39},
{19,	14,	28,	4,	36},
{19,	15,	26,	4,	37},
{18,	5,	18,	18,	37},
{22,	10,	18,	16,	37},
{19,	8,	17,	18,	37},
{19,	15,	18,	16,	36},
{19,	13,	18,	16,	37},
{18,	6,	36,	7,	33},
{22,	3,	32,	9,	33},
{21,	5,	36,	10,	29},
{19,	3,	37,	5,	33},
{19,	4,	38,	2,	33},
{19,	5,	35,	9,	30},
{18,	26,	25,	16,	16},
{21,	23,	25,	15,	19},
{20,	27,	22,	16,	3},
{20,	26,	25,	14,	19},
{19,	27,	22,	15,	16},
{19,	28,	22,	16,	2},
{18,	17,	16,	21,	34},
{20,	10,	17,	21,	33},
{19,	17,	17,	21,	32},
{18,	26,	21,	19,	24},
{19,	26,	19,	17,	26},
{18,	16,	33,	7,	31},
{21,	13,	33,	9,	28},
{20,	20,	29,	7,	31},
{20,	16,	34,	3,	27},
{19,	18,	31,	7,	31},
{19,	18,	33,	2,	30},
{19,	12,	34,	5,	21},
{19,	20,	31,	6,	29},
{19,	18,	31,	2,	33},
{19,	20,	30,	1,	34},
{18,	30,	19,	13,	33},
{20,	24,	21,	12,	30},
{20,	27,	18,	16,	29},
{19,	26,	19,	16,	29},
{19,	39,	19,	13,	32},
{19,	28,	19,	14,	29},
{19,	24,	19,	15,	30},
{19,	24,	18,	15,	34},
{19,	23,	18,	18,	31},
{21,	22,	19,	19,	28},
{21,	26,	18,	19,	26},
{19,	22,	20,	19,	27},
{18,	4,	32,	16,	31},
{20,	4,	33,	13,	31},
{19,	4,	28,	16,	32},
{18,	25,	27,	7,	32},
{21,	24,	27,	8,	7},
{20,	26,	27,	6,	8},
{18,	39,	20,	13,	22},
{22,	29,	21,	13,	22},
{20,	29,	23,	13,	0},
{19,	29,	24,	10,	0},
{18,	22,	27,	10,	25},
{22,	24,	27,	9,	13},
{20,	20,	28,	9,	20},
{20,	16,	29,	13,	23},
{20,	18,	27,	12,	23},
{20,	17,	27,	13,	23},
{19,	19,	27,	13,	5},
{19,	14,	29,	16,	24},
{19,	15,	28,	13,	27},
{19,	18,	28,	10,	23},
{19,	21,	29,	9,	2},
{20,	17,	29,	10,	17},
{19,	21,	31,	9,	1},
{18,	19,	24,	19,	28},
{23,	21,	24,	19,	25},
{20,	17,	20,	17,	31},
{20,	20,	22,	19,	27},
{20,	22,	22,	17,	26},
{19,	20,	20,	15,	32},
{20,	19,	19,	15,	34},
{19,	20,	22,	19,	28},
{20,	22,	21,	17,	28},
{19,	12,	21,	22,	28},
{19,	0,	22,	23,	28},
{21,	5,	24,	22,	28},
{19,	17,	23,	15,	32},
{18,	30,	21,	13,	27},
{19,	31,	21,	11,	1},
{19,	30,	22,	8,	13},
{18,	5,	21,	16,	36},
{22,	15,	19,	16,	36},
{20,	13,	20,	13,	37},
{20,	14,	20,	15,	36},
{18,	30,	23,	7,	30},
{20,	28,	23,	7,	32},
{18,	28,	18,	16,	33},
{20,	20,	20,	16,	32},
{20,	19,	20,	17,	30},
{21,	18,	20,	18,	31},
{19,	21,	23,	16,	30},
{19,	24,	16,	17,	32},
{19,	18,	17,	21,	32},
{19,	26,	17,	15,	34},
{18,	29,	27,	2,	32},
{22,	27,	29,	1,	23},
{21,	30,	27,	1,	18},
{19,	27,	28,	1,	30},
{19,	30,	27,	1,	27},
{18,	6,	30,	7,	36},
{20,	3,	28,	7,	37},
{20,	8,	29,	7,	36},
{20,	12,	31,	7,	32},
{20,	12,	33,	5,	33},
{19,	7,	35,	6,	33},
{21,	7,	35,	12,	19},
{20,	7,	35,	10,	28},
{19,	10,	30,	10,	32},
{18,	14,	37,	3,	25},
{22,	9,	37,	5,	14},
{21,	14,	35,	4,	17},
{20,	16,	37,	2,	16},
{20,	16,	35,	2,	29},
{19,	7,	36,	11,	6},
{19,	7,	37,	7,	15},
{18,	13,	34,	10,	21},
{22,	15,	35,	6,	1},
{18,	18,	26,	17,	12},
{20,	18,	26,	15,	18},
{19,	16,	25,	17,	21},
{20,	18,	25,	17,	17},
{19,	22,	26,	14,	10},
{22,	19,	26,	16,	12},
{18,	5,	16,	32,	16},
{20,	5,	18,	34,	0},
{20,	5,	16,	31,	19},
{18,	5,	20,	30,	16},
{21,	4,	17,	30,	18},
{20,	5,	17,	34,	1},
{20,	4,	18,	30,	18},
{20,	12,	15,	34,	4},
{19,	4,	18,	29,	24},
{19,	3,	22,	29,	1},
{19,	5,	22,	30,	0},
{19,	7,	17,	30,	16},
{19,	6,	16,	29,	26},
{18,	7,	34,	7,	34},
{19,	8,	34,	4,	35},
{20,	8,	32,	4,	36},
{18,	20,	27,	8,	34},
{19,	24,	27,	4,	33},
{19,	18,	26,	5,	35},
{19,	14,	26,	8,	37},
{22,	16,	25,	8,	36},
{19,	16,	27,	5,	36},
{19,	19,	27,	5,	35},
{21,	20,	24,	8,	35},
{18,	39,	18,	6,	38},
{23,	30,	19,	2,	38},
{20,	30,	19,	5,	37},
{18,	3,	37,	19,	21},
{19,	5,	38,	17,	19},
{18,	27,	24,	10,	31},
{21,	26,	21,	10,	32},
{20,	20,	24,	10,	35},
{19,	20,	25,	11,	31},
{18,	7,	20,	16,	37},
{19,	13,	19,	16,	37},
{18,	2,	20,	19,	35},
{18,	14,	19,	28,	18},
{20,	15,	19,	23,	25},
{19,	16,	17,	27,	12},
{19,	15,	21,	26,	1},
{19,	14,	18,	28,	21},
{18,	4,	18,	29,	28},
{19,	12,	16,	28,	29},
{18,	5,	33,	23,	22},
{22,	6,	35,	21,	2},
{19,	5,	34,	22,	21},
{18,	14,	20,	13,	38},
{18,	12,	16,	28,	30},
{18,	31,	25,	2,	29},
{19,	31,	27,	2,	3},
{18,	20,	20,	16,	34},
{21,	23,	20,	12,	34},
{18,	28,	24,	11,	17},
{18,	28,	19,	17,	25},
{18,	22,	32,	3,	20},
{19,	22,	31,	4,	15},
{19,	22,	30,	3,	28},
{18,	4,	36,	21,	25},
{18,	0,	36,	18,	27},
{18,	4,	25,	21,	29},
{20,	2,	24,	20,	30},
{18,	39,	17,	9,	39},
{18,	29,	22,	10,	25},
{18,	4,	25,	28,	19},
{19,	1,	22,	28,	21},
{19,	1,	23,	28,	20},
{18,	5,	38,	5,	31},
{19,	5,	39,	4,	27},
{18,	39,	14,	17,	36},
{18,	4,	39,	12,	9},
{18,	0,	39,	17,	6},
{20,	4,	39,	15,	6},
{18,	1,	39,	13,	16},
{20,	2,	39,	15,	9},
{19,	2,	39,	16,	9},
{18,	11,	39,	4,	11},
{19,	12,	39,	2,	25},
{19,	12,	37,	5,	5},
{19,	16,	36,	4,	2},
{19,	12,	37,	4,	19},
{19,	13,	35,	5,	21},
{18,	21,	24,	18,	28},
{19,	22,	23,	17,	28},
{18,	30,	19,	2,	39},
{18,	18,	33,	4,	30},
{20,	21,	33,	3,	5},
{18,	23,	30,	0,	37},
{20,	23,	32,	0,	35},
{20,	19,	28,	1,	38},
{20,	20,	30,	1,	36},
{19,	21,	31,	1,	33},
{18,	28,	24,	6,	30},
{18,	28,	25,	6,	19},
{18,	31,	24,	3,	28},
{20,	32,	23,	4,	13},
{19,	31,	23,	3,	32},
{18,	39,	13,	24,	27},
{21,	23,	15,	26,	4},
{19,	24,	14,	23,	22},
{18,	29,	26,	3,	26},
{18,	28,	26,	6,	22},
{18,	29,	28,	2,	9},
{19,	28,	28,	2,	15},
{19,	29,	29,	1,	5},
{18,	14,	25,	19,	28},
{18,	16,	26,	17,	21},
{18,	31,	27,	1,	14},
{18,	21,	19,	26,	1},
{18,	8,	33,	17,	11},
{20,	11,	33,	13,	13},
{20,	10,	33,	16,	11},
{19,	7,	35,	18,	0},
{19,	8,	34,	16,	11},
{20,	10,	34,	16,	1},
{18,	18,	29,	10,	22},
{18,	24,	27,	10,	9},
{20,	25,	27,	10,	2},
{18,	23,	27,	10,	22},
{18,	15,	27,	17,	13},
{18,	3,	17,	32,	8},
{18,	29,	25,	1,	34},
{20,	27,	23,	4,	35},
{19,	30,	23,	1,	35},
{19,	27,	25,	4,	33},
{18,	10,	30,	17,	27},
{19,	11,	30,	17,	20},
{18,	39,	19,	7,	36},
{20,	31,	22,	2,	34},
{20,	39,	21,	1,	34},
{20,	31,	23,	1,	35},
{20,	39,	20,	2,	36},
{18,	32,	21,	4,	33},
{19,	30,	21,	4,	35},
{19,	32,	22,	4,	32},
{18,	29,	22,	7,	33},
{19,	29,	21,	5,	35},
{19,	27,	25,	5,	33},
{18,	5,	36,	10,	30},
{18,	6,	23,	26,	25},
{18,	10,	23,	21,	27},
{19,	10,	25,	21,	6},
{19,	10,	25,	20,	26},
{19,	11,	27,	21,	0},
{19,	8,	27,	21,	5},
{19,	10,	27,	21,	3},
{18,	34,	24,	0,	14},
{18,	39,	22,	1,	17},
{18,	34,	24,	0,	27},
{20,	39,	22,	1,	23},
{18,	21,	24,	10,	35},
{18,	39,	21,	1,	36},
{19,	28,	21,	2,	37},
{18,	26,	25,	15,	19},
{18,	22,	15,	26,	14},
{18,	9,	24,	25,	7},
{20,	10,	26,	23,	1},
{18,	29,	20,	16,	9},
{20,	30,	21,	16,	0},
{19,	39,	20,	16,	0},
{18,	28,	26,	4,	32},
{18,	19,	19,	11,	38},
{19,	21,	19,	11,	36},
{18,	12,	18,	34,	0},
{19,	13,	16,	29,	15},
{19,	16,	16,	29,	7},
{18,	7,	20,	30,	15},
{18,	17,	18,	13,	38},
{18,	9,	25,	26,	4},
{18,	39,	14,	13,	38},
{19,	24,	14,	16,	38},
{18,	32,	22,	8,	3},
{18,	8,	15,	19,	36},
{18,	32,	23,	5,	9},
{18,	31,	23,	5,	27},
{18,	39,	14,	24,	17},
{18,	5,	31,	1,	38},
{18,	25,	21,	10,	34},
{18,	21,	14,	23,	28},
{19,	25,	15,	20,	27},
{19,	39,	14,	21,	27},
{18,	15,	24,	15,	31},
{20,	12,	25,	16,	31},
{18,	9,	21,	18,	33},
{18,	19,	28,	10,	23},
{18,	39,	11,	22,	34},
{18,	23,	29,	4,	30},
{19,	22,	28,	5,	31},
{18,	19,	33,	4,	24},
{18,	1,	37,	20,	5},
{18,	22,	19,	22,	16},
{18,	5,	12,	23,	34},
{18,	17,	20,	16,	35},
{18,	7,	38,	9,	11},
{20,	7,	38,	17,	0},
{18,	9,	37,	10,	3},
{20,	8,	37,	11,	6},
{20,	8,	37,	9,	12},
{20,	8,	35,	11,	21},
{19,	11,	36,	8,	4},
{19,	8,	35,	16,	3},
{18,	10,	35,	10,	20},
{19,	11,	36,	12,	0},
{19,	10,	36,	16,	0},
{19,	9,	37,	9,	11},
{19,	10,	36,	9,	14},
{19,	12,	36,	6,	10},
{18,	7,	35,	18,	11},
{18,	7,	38,	16,	6},
{18,	8,	36,	17,	3},
{18,	9,	34,	17,	5},
{19,	9,	35,	18,	0},
{18,	10,	32,	17,	27},
{18,	10,	32,	18,	22},
{19,	8,	35,	18,	6},
{18,	13,	36,	9,	2},
{19,	12,	37,	9,	1},
{18,	16,	19,	13,	37},
{18,	15,	21,	12,	36},
{18,	19,	29,	10,	7},
{18,	22,	29,	9,	0},
{18,	16,	28,	13,	25},
{18,	19,	28,	10,	27},
{19,	22,	27,	9,	28},
{19,	20,	28,	9,	30},
{20,	17,	30,	8,	31},
{19,	20,	31,	8,	29},
{18,	17,	29,	11,	24},
{18,	14,	29,	10,	29},
{20,	12,	28,	13,	30},
{18,	19,	28,	10,	29},
{18,	11,	24,	12,	33},
{18,	11,	25,	15,	32},
{18,	4,	32,	8,	34},
{18,	27,	19,	18,	13},
{18,	27,	18,	18,	26},
{18,	11,	33,	15,	8},
{18,	39,	18,	16,	21},
{18,	5,	32,	24,	10},
{18,	20,	25,	9,	34},
{18,	2,	25,	24,	24},
{18,	17,	28,	12,	17},
{18,	7,	30,	23,	1},
{18,	6,	29,	23,	21},
{21,	6,	27,	26,	10},
{21,	8,	27,	22,	10},
{20,	6,	28,	21,	27},
{19,	6,	25,	26,	23},
{19,	8,	25,	22,	25},
{19,	8,	27,	22,	18},
{19,	7,	27,	24,	11},
{19,	7,	27,	21,	27},
{18,	6,	34,	21,	21},
{19,	6,	30,	23,	22},
{18,	8,	25,	22,	27},
{18,	28,	28,	4,	0},
{18,	29,	24,	6,	21},
{18,	33,	23,	1,	9},
{18,	10,	20,	29,	2},
{19,	8,	18,	30,	16},
{18,	14,	18,	29,	7},
{18,	18,	17,	29,	2},
{18,	21,	17,	29,	0},
{19,	19,	12,	30,	20},
{18,	14,	17,	29,	13},
{18,	25,	20,	14,	28},
{18,	16,	26,	13,	29},
{18,	22,	18,	22,	20},
{18,	10,	36,	10,	11},
{18,	27,	21,	17,	1},
{18,	6,	21,	30,	1},
{18,	26,	24,	1,	37},
{19,	27,	22,	1,	38},
{18,	14,	7,	35,	20},
{18,	39,	23,	0,	29},
{18,	25,	23,	6,	35},
{18,	25,	23,	15,	24},
{18,	27,	22,	15,	24},
{18,	13,	21,	21,	29},
{19,	15,	20,	19,	31},
{18,	15,	21,	19,	30},
{18,	11,	24,	19,	30},
{22,	13,	22,	18,	31},
{19,	8,	23,	21,	30},
{19,	11,	25,	19,	29},
{19,	7,	28,	18,	29},
{18,	8,	26,	16,	32},
{20,	10,	29,	13,	31},
{18,	11,	24,	17,	31},
{18,	8,	23,	18,	33},
{18,	9,	23,	13,	34},
{18,	23,	19,	22,	13},
{18,	11,	27,	23,	0},
{18,	39,	16,	11,	36},
{18,	18,	22,	15,	32},
{19,	20,	23,	15,	31},
{18,	17,	27,	10,	31},
{18,	13,	23,	17,	31},
{18,	23,	19,	21,	19},
{18,	10,	27,	20,	9},
{18,	28,	24,	0,	38},
{18,	28,	25,	0,	37},
{19,	25,	29,	0,	36},
{19,	25,	26,	1,	37},
{18,	28,	26,	0,	38},
{18,	27,	27,	0,	38},
{18,	22,	17,	19,	31},
{19,	20,	18,	19,	31},
{18,	19,	20,	19,	30},
{19,	16,	19,	21,	30},
{18,	14,	19,	23,	29},
{18,	27,	20,	15,	25},
{18,	24,	24,	16,	28},
{18,	8,	32,	18,	28},
{18,	8,	32,	9,	32},
{18,	7,	33,	10,	31},
{18,	10,	31,	10,	32},
{18,	25,	16,	21,	10},
{19,	26,	17,	21,	3},
{18,	24,	16,	21,	20},
{18,	26,	16,	21,	10},
{18,	12,	35,	9,	10},
{18,	11,	36,	9,	14},
{18,	28,	27,	1,	33},
{18,	26,	26,	4,	33},
{18,	19,	12,	29,	26},
{18,	16,	15,	27,	28},
{18,	14,	30,	3,	36},
{18,	14,	32,	3,	35},
{18,	4,	39,	19,	0},
{18,	16,	35,	7,	0},
{18,	39,	9,	30,	28},
{18,	20,	11,	29,	26},
{18,	27,	21,	10,	32},
{18,	28,	20,	10,	32},
{18,	15,	25,	18,	24},
{18,	7,	29,	11,	32},
{18,	1,	30,	13,	32},
{18,	16,	27,	17,	4},
{18,	7,	26,	27,	3},
{18,	20,	20,	17,	30},
{19,	21,	19,	19,	30},
{18,	11,	26,	18,	29},
{18,	31,	21,	9,	9},
{18,	32,	22,	8,	6},
{18,	9,	34,	13,	13},
{18,	12,	12,	35,	0},
{17,	4,	34,	30,	26},
{20,	6,	16,	30,	28},
{19,	4,	35,	28,	0},
{20,	4,	35,	27,	2},
{18,	0,	17,	31,	20},
{20,	1,	17,	32,	15},
{18,	4,	35,	25,	24},
{18,	12,	20,	27,	26},
{19,	8,	20,	30,	15},
{18,	4,	35,	23,	25},
{18,	10,	20,	29,	11},
{18,	5,	32,	22,	26},
{18,	6,	27,	29,	0},
{17,	27,	29,	13,	27},
{23,	25,	28,	7,	29},
{22,	27,	27,	9,	28},
{21,	20,	29,	10,	29},
{20,	27,	27,	7,	29},
{20,	28,	27,	6,	2},
{20,	24,	27,	14,	0},
{19,	19,	29,	13,	28},
{21,	16,	28,	12,	30},
{19,	23,	29,	10,	28},
{19,	28,	29,	6,	0},
{18,	28,	27,	5,	32},
{20,	27,	27,	7,	31},
{19,	28,	28,	3,	15},
{18,	28,	27,	6,	24},
{18,	28,	28,	3,	28},
{19,	29,	28,	1,	29},
{18,	24,	28,	6,	30},
{18,	29,	29,	1,	10},
{18,	20,	27,	11,	30},
{18,	15,	28,	11,	31},
{18,	23,	28,	14,	0},
{17,	22,	13,	23,	36},
{20,	14,	14,	20,	36},
{19,	17,	13,	24,	33},
{19,	15,	14,	22,	32},
{19,	21,	14,	21,	33},
{18,	15,	16,	22,	32},
{18,	11,	19,	24,	31},
{21,	11,	20,	22,	31},
{19,	3,	20,	23,	30},
{18,	39,	12,	21,	36},
{18,	18,	17,	22,	30},
{20,	16,	19,	23,	26},
{18,	19,	19,	24,	17},
{18,	20,	18,	23,	16},
{18,	15,	20,	26,	4},
{19,	16,	19,	27,	5},
{18,	15,	18,	25,	25},
{18,	16,	18,	26,	16},
{17,	8,	10,	30,	34},
{22,	11,	8,	30,	33},
{19,	15,	10,	30,	32},
{19,	16,	11,	29,	32},
{18,	16,	12,	29,	32},
{21,	13,	13,	25,	33},
{19,	17,	12,	26,	33},
{18,	8,	13,	27,	32},
{17,	13,	15,	34,	27},
{19,	14,	11,	34,	23},
{18,	4,	17,	31,	21},
{18,	17,	15,	34,	0},
{17,	25,	31,	10,	27},
{23,	25,	32,	2,	11},
{22,	14,	32,	10,	26},
{21,	14,	30,	13,	17},
{20,	26,	30,	3,	6},
{19,	15,	32,	12,	7},
{20,	15,	32,	10,	22},
{19,	26,	30,	7,	3},
{19,	23,	30,	6,	29},
{19,	15,	31,	10,	29},
{19,	25,	32,	1,	20},
{19,	17,	30,	11,	11},
{19,	15,	31,	13,	7},
{18,	27,	30,	1,	30},
{18,	23,	33,	1,	25},
{18,	26,	30,	5,	12},
{18,	26,	30,	3,	27},
{18,	16,	30,	13,	11},
{18,	23,	32,	4,	4},
{18,	15,	30,	10,	30},
{18,	16,	29,	12,	30},
{18,	25,	29,	3,	30},
{18,	17,	31,	9,	30},
{19,	14,	31,	10,	31},
{18,	13,	32,	10,	30},
{18,	12,	32,	13,	29},
{18,	12,	30,	13,	31},
{18,	12,	26,	16,	31},
{18,	12,	33,	9,	31},
{17,	25,	19,	16,	38},
{21,	39,	15,	14,	38},
{20,	25,	18,	10,	39},
{20,	22,	20,	12,	35},
{20,	26,	17,	16,	35},
{19,	28,	19,	16,	33},
{19,	26,	16,	13,	38},
{19,	39,	16,	13,	35},
{18,	27,	19,	10,	36},
{18,	28,	20,	10,	34},
{19,	27,	21,	10,	33},
{18,	26,	15,	15,	38},
{18,	21,	23,	15,	31},
{17,	30,	23,	13,	32},
{22,	28,	20,	13,	33},
{21,	29,	24,	9,	9},
{20,	28,	22,	10,	33},
{20,	27,	26,	12,	28},
{19,	24,	23,	14,	29},
{18,	24,	23,	16,	30},
{19,	25,	20,	16,	30},
{18,	31,	23,	4,	32},
{18,	27,	26,	13,	28},
{17,	11,	13,	21,	37},
{17,	4,	37,	24,	21},
{21,	1,	36,	24,	22},
{17,	23,	18,	26,	29},
{20,	23,	19,	26,	2},
{20,	25,	17,	26,	0},
{20,	23,	19,	24,	9},
{19,	21,	19,	21,	24},
{20,	18,	19,	21,	30},
{20,	17,	19,	23,	29},
{19,	18,	17,	28,	9},
{19,	23,	19,	27,	0},
{19,	21,	16,	21,	31},
{19,	21,	15,	25,	30},
{19,	19,	13,	28,	29},
{19,	39,	11,	28,	26},
{19,	39,	11,	29,	24},
{19,	25,	16,	21,	24},
{19,	23,	19,	26,	4},
{19,	23,	14,	27,	7},
{19,	19,	16,	28,	12},
{20,	23,	17,	27,	5},
{19,	20,	16,	28,	12},
{18,	26,	16,	22,	25},
{19,	24,	18,	23,	5},
{20,	26,	17,	21,	19},
{19,	26,	15,	21,	27},
{18,	39,	15,	17,	33},
{18,	25,	17,	23,	17},
{19,	24,	17,	24,	16},
{19,	24,	18,	26,	2},
{18,	24,	18,	26,	8},
{19,	25,	17,	25,	6},
{18,	18,	19,	24,	20},
{18,	20,	14,	28,	26},
{18,	20,	18,	21,	31},
{18,	20,	15,	24,	31},
{18,	21,	17,	28,	7},
{18,	19,	13,	31,	4},
{19,	15,	14,	32,	11},
{19,	15,	14,	31,	27},
{19,	18,	12,	31,	27},
{18,	17,	15,	34,	1},
{19,	19,	17,	30,	2},
{20,	9,	20,	30,	15},
{19,	13,	17,	30,	13},
{19,	17,	17,	34,	0},
{19,	14,	15,	32,	20},
{18,	13,	18,	30,	11},
{18,	16,	16,	27,	28},
{20,	15,	18,	28,	21},
{20,	17,	19,	30,	0},
{19,	20,	17,	28,	13},
{18,	21,	19,	22,	23},
{18,	20,	20,	24,	18},
{23,	18,	20,	23,	23},
{19,	18,	21,	24,	2},
{18,	20,	20,	21,	22},
{18,	21,	20,	25,	0},
{18,	21,	20,	22,	11},
{18,	12,	19,	24,	31},
{18,	22,	20,	20,	11},
{18,	19,	18,	31,	0},
{17,	9,	27,	18,	33},
{20,	11,	25,	15,	33},
{20,	7,	30,	15,	31},
{19,	2,	28,	12,	33},
{19,	16,	21,	16,	33},
{18,	3,	32,	11,	33},
{18,	7,	28,	17,	31},
{18,	11,	27,	17,	31},
{18,	1,	29,	12,	33},
{18,	10,	28,	13,	32},
{18,	11,	28,	11,	33},
{18,	12,	28,	10,	34},
{18,	9,	23,	15,	34},
{17,	8,	24,	23,	32},
{22,	8,	14,	26,	32},
{20,	6,	22,	19,	33},
{19,	11,	19,	23,	32},
{19,	11,	15,	24,	32},
{19,	8,	24,	25,	23},
{18,	9,	14,	24,	33},
{18,	15,	14,	23,	34},
{18,	9,	22,	22,	32},
{19,	10,	22,	23,	30},
{19,	12,	21,	24,	27},
{17,	5,	27,	16,	35},
{21,	1,	28,	11,	35},
{18,	8,	27,	12,	34},
{18,	8,	24,	13,	35},
{17,	2,	39,	29,	0},
{19,	4,	39,	22,	0},
{17,	15,	13,	31,	31},
{18,	15,	14,	31,	29},
{17,	18,	34,	7,	31},
{20,	10,	35,	7,	26},
{20,	18,	34,	1,	34},
{18,	13,	35,	8,	28},
{20,	11,	35,	8,	30},
{19,	14,	35,	7,	28},
{20,	16,	36,	6,	2},
{19,	9,	34,	10,	29},
{18,	14,	36,	6,	14},
{18,	19,	32,	4,	31},
{18,	23,	30,	5,	30},
{18,	21,	30,	7,	30},
{18,	19,	32,	2,	34},
{19,	23,	30,	2,	32},
{18,	12,	34,	9,	31},
{18,	11,	35,	4,	33},
{17,	6,	19,	18,	38},
{19,	9,	16,	18,	38},
{18,	6,	20,	17,	36},
{18,	11,	16,	18,	37},
{17,	39,	0,	36,	11},
{19,	39,	3,	36,	1},
{19,	39,	2,	36,	6},
{18,	11,	9,	37,	0},
{18,	11,	12,	36,	0},
{18,	4,	6,	36,	2},
{17,	39,	22,	7,	26},
{17,	12,	34,	4,	38},
{20,	3,	37,	1,	37},
{20,	6,	39,	0,	37},
{19,	18,	30,	1,	38},
{18,	1,	39,	4,	33},
{18,	8,	39,	1,	34},
{18,	11,	25,	7,	39},
{18,	12,	30,	5,	36},
{18,	11,	31,	7,	35},
{18,	8,	32,	10,	33},
{19,	12,	29,	10,	34},
{20,	6,	30,	10,	35},
{17,	8,	35,	18,	28},
{21,	9,	34,	13,	28},
{20,	4,	34,	13,	30},
{20,	9,	33,	18,	17},
{20,	9,	35,	13,	22},
{19,	5,	34,	15,	29},
{19,	6,	37,	17,	21},
{18,	10,	34,	13,	26},
{20,	10,	36,	12,	8},
{19,	10,	35,	16,	4},
{18,	7,	33,	19,	27},
{19,	8,	35,	19,	6},
{19,	8,	31,	21,	1},
{18,	9,	30,	20,	1},
{18,	9,	36,	17,	2},
{18,	9,	38,	18,	0},
{18,	8,	39,	8,	11},
{19,	6,	39,	10,	18},
{18,	9,	39,	12,	1},
{18,	8,	38,	19,	1},
{18,	7,	38,	18,	4},
{17,	21,	28,	16,	20},
{19,	18,	26,	17,	17},
{18,	24,	25,	16,	22},
{18,	22,	28,	14,	5},
{18,	23,	25,	14,	27},
{17,	16,	21,	16,	38},
{21,	20,	20,	13,	36},
{20,	17,	21,	13,	37},
{18,	23,	20,	12,	36},
{17,	17,	23,	13,	38},
{20,	19,	20,	13,	38},
{19,	12,	23,	15,	35},
{18,	18,	22,	12,	38},
{19,	19,	23,	13,	34},
{19,	24,	21,	13,	33},
{19,	18,	22,	13,	38},
{17,	16,	24,	21,	28},
{20,	13,	23,	24,	1},
{19,	13,	27,	23,	0},
{19,	9,	27,	21,	13},
{18,	15,	21,	22,	30},
{18,	18,	20,	21,	29},
{18,	13,	25,	25,	0},
{18,	13,	23,	22,	8},
{18,	11,	27,	20,	7},
{17,	32,	22,	10,	27},
{23,	39,	22,	11,	0},
{18,	39,	20,	13,	31},
{19,	31,	21,	10,	31},
{18,	32,	21,	10,	28},
{17,	10,	25,	11,	38},
{21,	3,	27,	9,	36},
{19,	5,	24,	13,	36},
{18,	18,	24,	10,	38},
{21,	19,	25,	4,	37},
{19,	18,	26,	3,	39},
{20,	19,	27,	3,	38},
{19,	20,	26,	4,	37},
{21,	21,	25,	4,	37},
{18,	23,	27,	5,	34},
{20,	24,	25,	4,	35},
{19,	26,	26,	4,	34},
{19,	22,	25,	3,	38},
{18,	18,	25,	8,	37},
{20,	20,	25,	9,	35},
{18,	20,	24,	10,	36},
{18,	14,	28,	4,	38},
{18,	26,	27,	3,	34},
{18,	27,	26,	1,	35},
{18,	29,	25,	1,	35},
{17,	28,	25,	10,	31},
{19,	28,	26,	7,	20},
{18,	28,	26,	10,	3},
{18,	28,	27,	7,	8},
{18,	28,	25,	8,	32},
{17,	24,	28,	13,	30},
{19,	25,	26,	12,	30},
{18,	26,	27,	13,	29},
{19,	27,	27,	10,	29},
{18,	23,	26,	9,	32},
{18,	13,	27,	15,	31},
{18,	21,	31,	9,	29},
{19,	21,	32,	2,	32},
{18,	15,	29,	12,	31},
{17,	29,	28,	4,	28},
{20,	29,	25,	5,	11},
{19,	29,	25,	5,	22},
{17,	3,	28,	21,	30},
{18,	5,	28,	20,	30},
{17,	39,	21,	7,	34},
{18,	30,	21,	6,	35},
{18,	39,	22,	4,	28},
{18,	31,	22,	7,	33},
{21,	30,	22,	4,	35},
{18,	30,	21,	8,	34},
{19,	29,	22,	10,	33},
{18,	30,	19,	10,	34},
{19,	29,	19,	9,	36},
{18,	30,	19,	10,	35},
{18,	39,	22,	6,	27},
{17,	19,	32,	10,	29},
{20,	21,	32,	5,	21},
{18,	20,	32,	6,	21},
{18,	21,	32,	6,	6},
{17,	17,	32,	13,	29},
{19,	17,	30,	13,	30},
{18,	18,	31,	13,	22},
{18,	18,	32,	12,	29},
{17,	4,	30,	16,	33},
{20,	6,	29,	16,	33},
{18,	8,	29,	14,	33},
{17,	0,	34,	13,	33},
{19,	7,	34,	8,	34},
{19,	3,	33,	13,	33},
{17,	4,	32,	17,	32},
{17,	11,	34,	3,	39},
{20,	21,	30,	0,	39},
{18,	22,	28,	1,	38},
{18,	24,	28,	4,	34},
{21,	17,	30,	6,	32},
{21,	18,	28,	8,	33},
{20,	23,	28,	6,	32},
{19,	24,	29,	2,	34},
{19,	21,	31,	3,	32},
{18,	18,	30,	3,	35},
{20,	21,	28,	3,	36},
{20,	22,	28,	2,	38},
{18,	17,	28,	9,	33},
{19,	17,	30,	11,	31},
{18,	17,	32,	3,	35},
{18,	23,	29,	2,	35},
{18,	19,	31,	2,	36},
{18,	16,	32,	3,	38},
{18,	16,	30,	2,	39},
{17,	29,	30,	2,	30},
{19,	30,	29,	0,	28},
{18,	28,	32,	0,	23},
{18,	29,	30,	0,	31},
{18,	29,	31,	0,	23},
{17,	18,	26,	19,	19},
{20,	9,	27,	19,	30},
{21,	16,	26,	19,	22},
{21,	17,	25,	19,	24},
{19,	17,	25,	18,	27},
{19,	8,	27,	22,	24},
{19,	20,	25,	19,	0},
{18,	10,	30,	19,	20},
{18,	8,	30,	21,	20},
{19,	8,	28,	20,	28},
{18,	7,	30,	24,	10},
{18,	7,	33,	21,	19},
{18,	9,	30,	20,	10},
{18,	11,	29,	19,	4},
{19,	11,	28,	20,	7},
{18,	19,	26,	17,	1},
{18,	16,	25,	19,	28},
{18,	8,	33,	19,	20},
{19,	8,	31,	21,	20},
{17,	21,	27,	13,	32},
{20,	24,	25,	13,	31},
{20,	17,	24,	15,	32},
{20,	16,	28,	13,	32},
{19,	16,	28,	10,	33},
{18,	22,	27,	13,	31},
{18,	22,	27,	11,	32},
{17,	3,	22,	28,	28},
{19,	3,	22,	24,	29},
{18,	4,	22,	29,	27},
{18,	10,	20,	26,	29},
{18,	4,	23,	26,	27},
{18,	5,	22,	27,	28},
{19,	5,	23,	28,	26},
{18,	6,	22,	30,	12},
{18,	5,	26,	28,	11},
{17,	4,	31,	28,	27},
{18,	4,	26,	29,	27},
{17,	5,	36,	16,	29},
{19,	0,	36,	18,	28},
{19,	9,	35,	13,	29},
{18,	0,	33,	18,	29},
{18,	4,	36,	18,	28},
{18,	9,	35,	14,	28},
{18,	6,	36,	17,	28},
{17,	30,	26,	4,	25},
{20,	30,	25,	5,	6},
{17,	17,	27,	19,	16},
{20,	15,	27,	19,	19},
{18,	11,	27,	21,	13},
{18,	10,	27,	21,	22},
{18,	15,	27,	19,	21},
{17,	19,	27,	18,	16},
{17,	20,	28,	17,	15},
{20,	12,	28,	18,	20},
{20,	12,	29,	18,	12},
{19,	16,	28,	19,	1},
{19,	13,	29,	17,	7},
{18,	20,	27,	19,	1},
{18,	11,	30,	18,	20},
{18,	11,	31,	18,	4},
{19,	13,	31,	18,	0},
{19,	13,	31,	17,	3},
{17,	26,	15,	18,	36},
{19,	15,	15,	17,	38},
{18,	19,	16,	17,	35},
{19,	24,	16,	17,	33},
{18,	23,	15,	17,	37},
{18,	18,	16,	21,	34},
{19,	22,	15,	19,	36},
{18,	19,	15,	17,	38},
{18,	39,	14,	19,	34},
{17,	39,	5,	35,	23},
{17,	4,	17,	23,	34},
{21,	12,	15,	24,	33},
{18,	15,	15,	23,	34},
{17,	26,	30,	10,	22},
{21,	26,	30,	8,	26},
{17,	29,	21,	7,	36},
{18,	26,	21,	6,	37},
{21,	25,	21,	6,	38},
{19,	27,	20,	4,	38},
{18,	28,	20,	6,	37},
{17,	3,	36,	11,	32},
{17,	3,	38,	22,	4},
{17,	6,	19,	21,	34},
{20,	6,	20,	20,	33},
{17,	5,	38,	14,	24},
{18,	5,	38,	16,	21},
{17,	3,	37,	16,	28},
{19,	5,	38,	16,	22},
{18,	3,	37,	17,	25},
{21,	6,	37,	18,	22},
{18,	5,	37,	6,	29},
{17,	6,	21,	18,	36},
{17,	31,	23,	7,	26},
{17,	10,	24,	13,	38},
{17,	26,	23,	7,	36},
{20,	27,	23,	4,	36},
{18,	27,	23,	10,	33},
{17,	5,	16,	34,	20},
{17,	5,	19,	34,	2},
{18,	17,	19,	32,	0},
{17,	14,	32,	16,	25},
{17,	22,	37,	1,	11},
{19,	24,	35,	0,	23},
{19,	28,	34,	0,	14},
{19,	23,	35,	0,	31},
{18,	25,	35,	0,	29},
{18,	22,	34,	1,	25},
{17,	27,	29,	6,	30},
{19,	27,	28,	4,	31},
{18,	27,	29,	3,	31},
{17,	24,	31,	10,	29},
{19,	25,	31,	7,	28},
{19,	23,	32,	1,	33},
{19,	24,	31,	5,	30},
{19,	26,	30,	7,	28},
{17,	7,	33,	23,	19},
{20,	7,	32,	24,	10},
{19,	7,	29,	22,	26},
{18,	7,	27,	23,	25},
{17,	4,	32,	18,	31},
{18,	5,	28,	18,	32},
{17,	15,	15,	22,	35},
{19,	5,	15,	20,	36},
{17,	30,	23,	10,	33},
{19,	28,	26,	3,	33},
{19,	29,	23,	3,	35},
{17,	5,	27,	19,	32},
{17,	12,	21,	27,	27},
{18,	15,	21,	27,	2},
{18,	14,	20,	30,	1},
{19,	14,	20,	28,	8},
{18,	18,	21,	27,	0},
{18,	21,	20,	26,	4},
{17,	24,	23,	17,	27},
{17,	3,	38,	24,	2},
{17,	28,	29,	4,	28},
{17,	2,	39,	12,	24},
{19,	1,	39,	13,	19},
{17,	25,	23,	19,	6},
{17,	23,	20,	13,	38},
{17,	26,	21,	10,	36},
{18,	29,	20,	9,	36},
{17,	18,	36,	4,	13},
{19,	15,	35,	6,	18},
{17,	25,	23,	18,	15},
{17,	5,	32,	28,	10},
{20,	7,	29,	26,	4},
{18,	5,	32,	30,	0},
{17,	25,	20,	16,	33},
{19,	24,	21,	16,	31},
{17,	29,	23,	4,	36},
{18,	29,	22,	0,	39},
{17,	4,	15,	28,	32},
{20,	7,	14,	29,	32},
{17,	10,	19,	26,	31},
{18,	12,	16,	26,	32},
{19,	12,	17,	24,	32},
{18,	5,	16,	28,	31},
{17,	5,	16,	30,	31},
{17,	3,	27,	10,	36},
{17,	32,	23,	5,	27},
{18,	32,	23,	3,	31},
{17,	29,	29,	4,	25},
{17,	14,	37,	6,	15},
{19,	10,	39,	8,	2},
{18,	13,	37,	9,	10},
{18,	14,	37,	5,	19},
{18,	17,	38,	4,	0},
{18,	12,	39,	6,	1},
{17,	30,	29,	0,	35},
{17,	31,	26,	2,	25},
{18,	31,	26,	1,	29},
{17,	4,	9,	37,	1},
{17,	30,	22,	8,	34},
{19,	29,	23,	5,	35},
{18,	31,	22,	6,	34},
{17,	17,	20,	26,	16},
{18,	15,	20,	27,	18},
{18,	19,	20,	26,	8},
{18,	18,	19,	26,	18},
{17,	9,	39,	10,	11},
{18,	8,	37,	10,	19},
{19,	15,	36,	6,	17},
{18,	8,	38,	13,	8},
{18,	13,	36,	9,	16},
{17,	7,	37,	13,	26},
{21,	13,	36,	7,	22},
{19,	8,	38,	12,	16},
{18,	7,	39,	8,	24},
{20,	12,	39,	3,	28},
{20,	12,	36,	3,	33},
{19,	14,	36,	6,	27},
{19,	9,	36,	10,	27},
{19,	19,	37,	0,	31},
{18,	7,	36,	18,	18},
{18,	12,	36,	6,	30},
{18,	24,	37,	0,	19},
{17,	5,	28,	6,	38},
{17,	14,	20,	30,	10},
{19,	18,	16,	30,	8},
{18,	18,	15,	31,	9},
{17,	16,	17,	18,	35},
{18,	11,	19,	18,	36},
{17,	30,	21,	13,	33},
{17,	18,	23,	24,	0},
{19,	14,	24,	24,	1},
{18,	14,	23,	27,	0},
{18,	10,	25,	30,	0},
{20,	12,	21,	29,	6},
{19,	8,	27,	30,	0},
{18,	9,	22,	30,	4},
{18,	8,	27,	26,	4},
{17,	25,	24,	4,	37},
{19,	25,	23,	4,	38},
{18,	26,	22,	6,	37},
{17,	24,	24,	6,	37},
{19,	22,	24,	10,	34},
{18,	22,	24,	6,	38},
{18,	27,	24,	6,	33},
{18,	22,	26,	8,	33},
{17,	19,	27,	6,	38},
{20,	17,	27,	8,	35},
{19,	18,	28,	4,	38},
{19,	14,	26,	8,	38},
{18,	16,	27,	8,	36},
{18,	19,	27,	8,	35},
{17,	23,	25,	6,	37},
{18,	20,	25,	9,	36},
{17,	17,	25,	7,	39},
{17,	28,	22,	16,	16},
{17,	28,	23,	15,	16},
{17,	28,	18,	18,	26},
{20,	29,	19,	18,	5},
{18,	29,	19,	17,	14},
{17,	29,	19,	19,	6},
{22,	39,	16,	19,	26},
{20,	39,	16,	24,	0},
{17,	27,	16,	24,	19},
{18,	26,	17,	24,	16},
{19,	26,	17,	25,	9},
{18,	27,	17,	24,	13},
{19,	39,	17,	22,	1},
{17,	24,	19,	21,	19},
{19,	24,	19,	24,	8},
{17,	39,	19,	6,	37},
{17,	29,	28,	4,	30},
{17,	6,	36,	9,	33},
{17,	12,	27,	13,	34},
{19,	17,	24,	11,	37},
{18,	12,	26,	12,	35},
{17,	8,	25,	26,	20},
{20,	9,	23,	27,	11},
{19,	7,	30,	26,	6},
{17,	10,	26,	23,	24},
{21,	9,	26,	26,	11},
{21,	10,	25,	25,	11},
{19,	10,	27,	23,	19},
{19,	13,	23,	22,	21},
{19,	11,	23,	23,	28},
{19,	11,	22,	25,	22},
{19,	10,	23,	28,	6},
{18,	10,	26,	26,	7},
{18,	9,	27,	26,	9},
{18,	11,	22,	30,	3},
{18,	11,	22,	26,	24},
{17,	23,	17,	17,	33},
{17,	25,	18,	17,	32},
{18,	25,	17,	17,	33},
{18,	26,	16,	17,	34},
{19,	26,	18,	17,	29},
{19,	39,	16,	19,	27},
{18,	22,	16,	17,	35},
{17,	23,	18,	21,	32},
{19,	13,	18,	18,	35},
{17,	11,	36,	10,	24},
{17,	30,	25,	5,	20},
{17,	32,	24,	5,	22},
{19,	32,	24,	4,	25},
{17,	19,	21,	21,	10},
{19,	17,	22,	21,	10},
{17,	17,	21,	24,	23},
{20,	19,	21,	20,	24},
{20,	13,	21,	26,	23},
{19,	13,	22,	23,	21},
{19,	13,	19,	28,	27},
{18,	18,	19,	25,	24},
{17,	16,	22,	23,	21},
{20,	16,	23,	24,	2},
{18,	16,	23,	22,	18},
{18,	17,	22,	23,	12},
{17,	13,	24,	23,	17},
{17,	18,	22,	24,	6},
{18,	19,	22,	20,	11},
{17,	19,	24,	20,	22},
{18,	19,	23,	21,	7},
{18,	20,	22,	21,	2},
{17,	30,	24,	6,	8},
{17,	1,	36,	21,	26},
{17,	5,	16,	31,	28},
{17,	25,	23,	10,	35},
{18,	26,	22,	9,	36},
{17,	26,	22,	7,	37},
{17,	12,	35,	6,	33},
{17,	39,	18,	15,	26},
{17,	20,	16,	19,	35},
{18,	20,	17,	19,	33},
{17,	8,	19,	29,	27},
{18,	5,	17,	30,	28},
{17,	8,	31,	21,	25},
{17,	8,	30,	23,	22},
{18,	8,	29,	22,	27},
{17,	18,	18,	30,	4},
{18,	15,	20,	29,	6},
{17,	6,	18,	28,	29},
{18,	6,	17,	28,	30},
{17,	21,	18,	17,	33},
{17,	27,	19,	21,	1},
{19,	26,	18,	26,	0},
{18,	29,	18,	23,	0},
{17,	24,	21,	17,	28},
{17,	5,	16,	33,	24},
{17,	23,	22,	13,	33},
{17,	9,	11,	29,	33},
{17,	21,	19,	21,	29},
{17,	14,	23,	15,	35},
{17,	17,	19,	28,	10},
{17,	20,	26,	16,	22},
{17,	27,	19,	7,	38},
{17,	27,	16,	21,	26},
{17,	12,	39,	3,	31},
{18,	9,	38,	4,	29},
{17,	19,	28,	7,	34},
{17,	20,	28,	9,	33},
{17,	12,	33,	8,	33},
{18,	11,	31,	10,	34},
{17,	23,	20,	26,	0},
{19,	26,	20,	22,	0},
{17,	23,	21,	21,	20},
{19,	19,	21,	21,	28},
{19,	23,	20,	26,	2},
{18,	22,	19,	21,	28},
{18,	22,	20,	23,	10},
{18,	20,	22,	20,	17},
{18,	17,	22,	21,	27},
{17,	18,	22,	23,	22},
{17,	32,	22,	1,	36},
{17,	30,	27,	0,	37},
{18,	32,	23,	0,	37},
{17,	39,	21,	2,	37},
{19,	39,	20,	1,	38},
{18,	31,	21,	0,	39},
{18,	31,	22,	3,	35},
{17,	30,	21,	5,	37},
{18,	30,	20,	7,	36},
{17,	29,	24,	1,	37},
{18,	28,	25,	1,	37},
{18,	28,	23,	2,	37},
{18,	28,	24,	2,	36},
{17,	5,	17,	31,	25},
{17,	14,	24,	24,	5},
{17,	11,	27,	24,	7},
{19,	12,	26,	25,	1},
{18,	11,	25,	24,	13},
{18,	15,	23,	26,	1},
{17,	11,	26,	22,	26},
{17,	10,	25,	26,	20},
{19,	12,	23,	24,	22},
{17,	15,	22,	24,	21},
{17,	26,	19,	13,	35},
{17,	31,	21,	3,	37},
{17,	27,	18,	19,	26},
{17,	39,	17,	19,	26},
{18,	29,	18,	19,	11},
{17,	29,	18,	18,	20},
{18,	39,	18,	19,	13},
{17,	27,	19,	19,	24},
{19,	28,	19,	19,	18},
{17,	32,	22,	11,	3},
{17,	1,	12,	35,	3},
{19,	1,	12,	37,	1},
{17,	25,	22,	7,	38},
{17,	25,	28,	7,	31},
{17,	24,	29,	7,	31},
{17,	23,	29,	6,	32},
{18,	18,	34,	5,	32},
{18,	16,	34,	3,	36},
{19,	18,	33,	2,	37},
{18,	25,	29,	4,	32},
{18,	20,	32,	1,	37},
{17,	19,	20,	19,	31},
{18,	20,	19,	20,	31},
{17,	15,	22,	21,	31},
{17,	21,	23,	18,	30},
{19,	19,	21,	21,	30},
{19,	22,	23,	17,	29},
{17,	14,	23,	17,	33},
{20,	10,	26,	18,	33},
{18,	11,	24,	19,	32},
{18,	11,	26,	19,	31},
{17,	11,	22,	18,	34},
{17,	15,	20,	21,	32},
{19,	14,	23,	18,	33},
{17,	19,	20,	19,	32},
{17,	11,	20,	19,	34},
{18,	9,	20,	21,	33},
{17,	9,	18,	21,	35},
{17,	17,	23,	17,	31},
{17,	19,	22,	19,	31},
{17,	24,	16,	26,	19},
{17,	12,	28,	17,	27},
{17,	14,	28,	17,	24},
{17,	18,	28,	17,	19},
{18,	16,	28,	17,	22},
{17,	11,	29,	19,	22},
{17,	18,	22,	24,	11},
{17,	4,	37,	28,	0},
{17,	16,	22,	27,	1},
{17,	22,	20,	16,	34},
{17,	20,	22,	18,	31},
{17,	30,	22,	2,	37},
{17,	10,	33,	16,	22},
{17,	31,	21,	9,	32},
{17,	27,	28,	0,	38},
{17,	13,	24,	24,	17},
{17,	13,	22,	25,	18},
{17,	5,	35,	21,	16},
{17,	33,	24,	2,	2},
{17,	34,	24,	1,	12},
{17,	30,	26,	1,	32},
{17,	28,	22,	15,	21},
{18,	28,	23,	15,	18},
{17,	20,	25,	18,	15},
{17,	11,	39,	4,	24},
{17,	12,	37,	5,	29},
{17,	22,	32,	6,	4},
{17,	11,	36,	16,	0},
{17,	20,	25,	16,	25},
{17,	7,	38,	16,	13},
{17,	9,	38,	9,	18},
{17,	13,	37,	8,	16},
{17,	29,	24,	10,	3},
{17,	31,	25,	5,	1},
{17,	31,	26,	3,	11},
{17,	26,	24,	12,	31},
{17,	27,	24,	11,	32},
{17,	28,	21,	8,	36},
{17,	24,	25,	6,	34},
{17,	10,	28,	20,	19},
{17,	12,	35,	10,	20},
{17,	19,	31,	11,	4},
{17,	5,	19,	31,	3},
{17,	5,	18,	33,	4},
{17,	39,	10,	30,	26},
{17,	22,	17,	30,	0},
{17,	24,	14,	28,	25},
{22,	23,	17,	28,	11},
{18,	22,	16,	28,	19},
{18,	23,	18,	28,	3},
{19,	21,	19,	30,	0},
{17,	23,	15,	30,	3},
{18,	39,	12,	31,	4},
{17,	18,	18,	28,	19},
{17,	17,	18,	28,	27},
{17,	22,	12,	30,	18},
{17,	39,	12,	28,	29},
{17,	16,	18,	28,	28},
{18,	8,	17,	29,	29},
{17,	28,	24,	11,	28},
{17,	17,	17,	21,	33},
{17,	6,	21,	29,	24},
{17,	1,	17,	32,	19},
{17,	10,	38,	10,	4},
{17,	11,	37,	10,	12},
{17,	39,	7,	28,	33},
{17,	31,	23,	5,	32},
{17,	26,	17,	18,	29},
{17,	26,	16,	19,	31},
{18,	26,	16,	18,	34},
{17,	23,	15,	28,	23},
{19,	18,	18,	28,	27},
{18,	18,	16,	28,	29},
{17,	22,	16,	27,	26},
{17,	15,	28,	6,	36},
{17,	20,	39,	0,	8},
{17,	13,	39,	3,	18},
{17,	10,	25,	27,	4},
{17,	10,	27,	27,	1},
{17,	10,	27,	30,	0},
{17,	9,	24,	30,	1},
{17,	26,	19,	16,	34},
{17,	26,	19,	14,	36},
{18,	26,	17,	13,	38},
{17,	26,	18,	15,	36},
{17,	18,	11,	31,	31},
{18,	16,	14,	31,	30},
{17,	24,	25,	16,	23},
{17,	14,	14,	28,	32},
{17,	12,	36,	0,	38},
{17,	3,	37,	1,	38},
{17,	18,	22,	26,	1},
{17,	13,	31,	17,	5},
{17,	28,	29,	0,	37},
{17,	27,	20,	10,	36},
{17,	22,	14,	26,	30},
{18,	19,	11,	30,	31},
{17,	21,	12,	29,	29},
{17,	39,	9,	31,	31},
{17,	28,	26,	4,	33},
{17,	17,	21,	22,	29},
{18,	17,	20,	25,	24},
{17,	13,	38,	3,	31},
{18,	15,	36,	3,	31},
{17,	15,	36,	4,	30},
{17,	15,	36,	6,	25},
{17,	5,	25,	26,	27},
{17,	5,	19,	29,	28},
{17,	9,	38,	12,	12},
{17,	11,	37,	12,	1},
{17,	22,	20,	18,	30},
{17,	17,	20,	16,	37},
{17,	22,	21,	19,	27},
{17,	7,	37,	16,	22},
{17,	9,	34,	16,	23},
{17,	24,	39,	0,	11},
{17,	4,	39,	12,	18},
{17,	24,	32,	3,	7},
{17,	23,	32,	3,	20},
{17,	8,	26,	30,	1},
{17,	11,	25,	28,	1},
{17,	31,	26,	4,	2},
{17,	31,	25,	5,	19},
{19,	31,	25,	4,	25},
{17,	27,	26,	1,	37},
{17,	39,	14,	28,	5},
{17,	31,	25,	4,	26},
{17,	30,	26,	4,	28},
{18,	30,	26,	2,	32},
{17,	32,	24,	4,	27},
{17,	5,	33,	18,	29},
{17,	5,	16,	34,	23},
{17,	22,	35,	1,	18},
{18,	18,	36,	4,	16},
{18,	16,	35,	5,	25},
{17,	17,	37,	4,	16},
{17,	16,	37,	5,	16},
{17,	5,	39,	5,	26},
{17,	24,	20,	24,	1},
{17,	26,	20,	23,	0},
{17,	9,	39,	11,	9},
{16,	39,	20,	16,	39},
{19,	13,	21,	12,	39},
{18,	25,	21,	7,	39},
{18,	27,	21,	4,	39},
{18,	29,	18,	17,	23},
{17,	29,	23,	15,	29},
{21,	30,	23,	15,	2},
{20,	26,	24,	15,	28},
{19,	28,	21,	15,	30},
{19,	25,	21,	17,	26},
{18,	29,	21,	16,	29},
{18,	30,	22,	15,	8},
{18,	27,	21,	15,	31},
{18,	30,	23,	16,	0},
{18,	27,	23,	16,	16},
{18,	26,	23,	15,	30},
{17,	27,	22,	17,	27},
{19,	27,	21,	19,	16},
{19,	26,	25,	16,	19},
{18,	25,	23,	18,	23},
{20,	27,	23,	16,	27},
{18,	29,	22,	16,	27},
{18,	27,	22,	18,	8},
{18,	27,	22,	19,	4},
{18,	28,	20,	19,	3},
{18,	27,	23,	17,	0},
{17,	28,	18,	18,	31},
{18,	39,	16,	18,	34},
{20,	27,	18,	18,	32},
{18,	26,	18,	19,	29},
{17,	26,	23,	17,	24},
{20,	26,	23,	19,	4},
{18,	27,	23,	17,	7},
{17,	26,	23,	15,	31},
{17,	25,	22,	7,	39},
{17,	26,	23,	4,	39},
{17,	25,	21,	17,	28},
{17,	26,	22,	18,	21},
{17,	30,	23,	15,	6},
{17,	31,	21,	5,	36},
{17,	28,	23,	16,	12},
{16,	13,	35,	23,	29},
{21,	14,	22,	23,	30},
{20,	14,	25,	21,	18},
{19,	15,	21,	24,	29},
{19,	5,	37,	24,	0},
{19,	8,	38,	21,	0},
{19,	7,	36,	23,	15},
{20,	9,	36,	23,	2},
{19,	12,	36,	13,	3},
{19,	12,	27,	18,	31},
{19,	14,	26,	17,	29},
{19,	5,	29,	19,	30},
{19,	12,	27,	24,	10},
{18,	9,	36,	18,	5},
{18,	18,	20,	23,	27},
{18,	15,	25,	19,	29},
{18,	11,	37,	12,	7},
{18,	17,	22,	23,	25},
{17,	12,	30,	24,	10},
{19,	10,	30,	26,	2},
{18,	10,	30,	25,	6},
{17,	17,	28,	19,	16},
{18,	18,	28,	18,	16},
{17,	16,	29,	18,	13},
{19,	17,	29,	19,	0},
{18,	14,	31,	17,	17},
{19,	14,	30,	17,	23},
{20,	15,	29,	18,	21},
{18,	14,	29,	17,	28},
{17,	15,	29,	18,	27},
{19,	20,	26,	14,	27},
{19,	14,	28,	19,	28},
{19,	16,	28,	19,	23},
{18,	15,	28,	15,	29},
{17,	4,	32,	19,	30},
{17,	1,	32,	21,	30},
{17,	14,	31,	23,	0},
{18,	16,	29,	21,	0},
{18,	15,	28,	23,	0},
{18,	16,	25,	24,	0},
{17,	16,	25,	21,	18},
{21,	19,	25,	20,	4},
{17,	15,	27,	20,	11},
{17,	9,	36,	16,	14},
{19,	10,	37,	13,	12},
{17,	16,	29,	18,	22},
{17,	12,	25,	17,	33},
{19,	15,	27,	14,	32},
{17,	11,	36,	16,	3},
{17,	14,	16,	25,	32},
{18,	18,	17,	25,	30},
{17,	15,	29,	17,	28},
{17,	17,	25,	21,	4},
{17,	18,	24,	24,	0},
{17,	14,	25,	16,	32},
{18,	17,	24,	18,	30},
{18,	16,	24,	18,	31},
{17,	9,	29,	17,	30},
{17,	7,	36,	23,	18},
{16,	32,	26,	10,	30},
{19,	34,	25,	0,	9},
{19,	32,	27,	0,	17},
{19,	31,	23,	13,	0},
{18,	32,	21,	9,	33},
{18,	32,	23,	5,	32},
{18,	32,	23,	11,	4},
{18,	27,	27,	10,	30},
{17,	29,	27,	7,	24},
{20,	28,	27,	7,	28},
{17,	29,	28,	6,	15},
{18,	28,	29,	6,	3},
{18,	28,	28,	5,	26},
{17,	29,	26,	7,	32},
{17,	30,	24,	5,	33},
{18,	30,	26,	5,	31},
{17,	31,	23,	12,	6},
{19,	31,	22,	13,	7},
{18,	31,	21,	13,	12},
{17,	34,	25,	1,	9},
{17,	30,	25,	4,	33},
{17,	29,	25,	10,	31},
{17,	29,	24,	10,	32},
{17,	29,	25,	9,	32},
{17,	31,	26,	1,	31},
{17,	32,	24,	1,	33},
{17,	32,	25,	1,	32},
{17,	33,	26,	1,	3},
{18,	35,	30,	0,	0},
{16,	5,	38,	28,	22},
{24,	5,	34,	28,	26},
{20,	9,	29,	24,	15},
{18,	6,	38,	20,	18},
{18,	7,	32,	24,	16},
{17,	4,	37,	29,	1},
{17,	11,	34,	24,	1},
{20,	10,	31,	24,	15},
{18,	6,	36,	24,	9},
{17,	5,	32,	24,	27},
{17,	6,	38,	17,	22},
{17,	10,	35,	24,	1},
{17,	5,	33,	30,	1},
{17,	7,	39,	10,	22},
{16,	39,	11,	26,	36},
{19,	20,	12,	28,	32},
{16,	4,	27,	32,	25},
{20,	5,	20,	32,	25},
{20,	10,	21,	32,	1},
{19,	7,	19,	33,	4},
{18,	5,	16,	34,	27},
{18,	9,	20,	33,	0},
{18,	10,	20,	32,	3},
{17,	5,	20,	31,	26},
{17,	4,	28,	31,	0},
{17,	5,	17,	32,	27},
{17,	1,	21,	33,	0},
{16,	21,	29,	19,	29},
{18,	22,	29,	13,	30},
{18,	24,	25,	16,	26},
{18,	19,	26,	14,	31},
{18,	14,	31,	16,	29},
{17,	26,	25,	15,	26},
{17,	14,	31,	19,	8},
{17,	23,	30,	8,	30},
{16,	5,	19,	21,	38},
{20,	11,	19,	19,	36},
{20,	19,	15,	19,	37},
{18,	11,	14,	22,	36},
{17,	12,	14,	21,	38},
{17,	6,	20,	19,	36},
{17,	39,	6,	20,	38},
{16,	10,	31,	28,	29},
{22,	6,	32,	28,	25},
{20,	7,	22,	30,	17},
{19,	9,	21,	29,	26},
{19,	7,	32,	26,	26},
{19,	13,	23,	24,	29},
{19,	12,	16,	29,	30},
{18,	12,	21,	28,	27},
{18,	9,	20,	30,	20},
{18,	13,	24,	24,	29},
{17,	7,	35,	28,	22},
{18,	6,	36,	26,	18},
{18,	7,	34,	28,	24},
{17,	11,	24,	24,	31},
{18,	14,	22,	23,	31},
{17,	3,	26,	24,	30},
{17,	3,	27,	23,	30},
{17,	16,	20,	28,	18},
{17,	11,	30,	28,	1},
{17,	13,	18,	24,	32},
{17,	1,	18,	26,	32},
{17,	5,	19,	29,	29},
{17,	10,	35,	26,	0},
{18,	8,	35,	26,	3},
{18,	9,	33,	24,	15},
{17,	9,	36,	26,	2},
{17,	8,	35,	24,	24},
{17,	7,	31,	30,	1},
{19,	10,	30,	30,	0},
{17,	8,	22,	30,	20},
{18,	9,	22,	29,	26},
{17,	12,	31,	25,	1},
{17,	16,	19,	28,	22},
{17,	11,	22,	23,	32},
{17,	12,	34,	24,	2},
{17,	11,	27,	24,	21},
{19,	12,	31,	24,	13},
{17,	12,	16,	29,	31},
{17,	16,	21,	28,	2},
{16,	17,	37,	13,	29},
{21,	18,	36,	6,	8},
{20,	9,	36,	16,	27},
{20,	18,	36,	3,	31},
{19,	14,	33,	15,	29},
{19,	14,	35,	15,	18},
{19,	21,	36,	1,	25},
{18,	18,	36,	1,	34},
{18,	18,	35,	5,	32},
{18,	18,	37,	6,	4},
{17,	21,	36,	3,	24},
{21,	22,	37,	3,	2},
{20,	19,	36,	4,	13},
{18,	21,	36,	2,	27},
{19,	20,	33,	2,	36},
{18,	20,	33,	4,	16},
{17,	4,	37,	9,	32},
{18,	4,	37,	6,	33},
{17,	4,	37,	11,	31},
{17,	14,	35,	3,	35},
{19,	1,	37,	2,	37},
{21,	9,	36,	4,	34},
{19,	4,	37,	3,	35},
{19,	4,	39,	3,	34},
{18,	10,	35,	5,	34},
{18,	7,	35,	6,	34},
{17,	1,	37,	15,	29},
{17,	24,	34,	0,	35},
{18,	24,	31,	2,	33},
{18,	28,	30,	2,	31},
{17,	18,	33,	12,	3},
{17,	18,	37,	5,	21},
{17,	22,	35,	2,	15},
{17,	28,	28,	3,	32},
{17,	17,	39,	0,	32},
{17,	18,	38,	2,	24},
{17,	18,	33,	10,	9},
{17,	21,	33,	4,	16},
{18,	22,	35,	4,	1},
{17,	14,	33,	16,	27},
{17,	20,	35,	2,	32},
{17,	22,	34,	1,	33},
{17,	16,	36,	3,	34},
{17,	6,	37,	10,	31},
{17,	22,	39,	0,	24},
{17,	1,	36,	2,	38},
{17,	22,	33,	5,	2},
{16,	10,	35,	8,	38},
{20,	6,	36,	5,	35},
{19,	10,	30,	10,	35},
{19,	1,	36,	3,	38},
{19,	14,	35,	3,	38},
{19,	12,	30,	7,	36},
{18,	12,	29,	7,	38},
{18,	17,	28,	6,	38},
{18,	19,	28,	6,	36},
{17,	4,	39,	2,	37},
{17,	18,	35,	2,	36},
{16,	23,	32,	13,	29},
{18,	24,	32,	4,	30},
{18,	18,	33,	13,	9},
{17,	24,	31,	13,	26},
{20,	26,	30,	11,	10},
{18,	25,	30,	13,	2},
{17,	21,	34,	3,	28},
{17,	24,	32,	1,	34},
{16,	6,	39,	21,	20},
{20,	7,	39,	17,	5},
{19,	6,	38,	22,	21},
{17,	6,	39,	13,	21},
{17,	7,	36,	23,	21},
{17,	8,	39,	20,	0},
{16,	3,	31,	18,	34},
{19,	8,	29,	13,	34},
{17,	3,	32,	17,	33},
{17,	5,	27,	17,	34},
{17,	4,	31,	16,	34},
{16,	24,	27,	16,	32},
{20,	23,	28,	16,	3},
{18,	14,	27,	18,	31},
{19,	19,	25,	17,	30},
{18,	26,	25,	15,	29},
{18,	23,	29,	16,	0},
{18,	25,	22,	16,	32},
{19,	27,	21,	16,	32},
{18,	13,	27,	17,	32},
{18,	26,	23,	15,	32},
{17,	29,	22,	16,	31},
{17,	19,	22,	18,	32},
{18,	15,	22,	21,	32},
{18,	16,	24,	18,	32},
{17,	18,	21,	16,	36},
{18,	27,	21,	15,	33},
{18,	19,	22,	14,	35},
{18,	19,	21,	15,	36},
{17,	19,	21,	19,	33},
{17,	17,	23,	17,	33},
{19,	17,	23,	15,	34},
{18,	19,	22,	18,	33},
{17,	21,	22,	12,	35},
{17,	18,	23,	16,	34},
{17,	18,	22,	19,	33},
{17,	26,	25,	11,	32},
{17,	25,	27,	10,	32},
{17,	27,	27,	10,	31},
{17,	17,	23,	15,	35},
{17,	12,	19,	19,	35},
{17,	12,	22,	18,	34},
{17,	14,	20,	17,	34},
{17,	23,	28,	15,	6},
{17,	18,	23,	17,	33},
{18,	18,	25,	17,	31},
{17,	27,	21,	16,	33},
{17,	13,	22,	18,	34},
{16,	15,	35,	19,	29},
{19,	14,	35,	22,	0},
{18,	18,	30,	14,	2},
{18,	17,	32,	14,	1},
{17,	18,	30,	19,	3},
{18,	16,	30,	16,	11},
{17,	19,	30,	16,	9},
{18,	20,	30,	14,	10},
{17,	15,	32,	21,	0},
{16,	22,	24,	23,	19},
{21,	21,	21,	26,	2},
{21,	23,	21,	23,	10},
{20,	17,	24,	22,	24},
{20,	15,	23,	24,	21},
{20,	23,	21,	23,	15},
{19,	19,	22,	23,	24},
{19,	19,	20,	23,	29},
{19,	14,	24,	23,	29},
{19,	23,	19,	24,	18},
{18,	18,	23,	24,	8},
{18,	23,	20,	22,	21},
{18,	19,	20,	24,	25},
{18,	25,	21,	23,	0},
{18,	24,	21,	26,	0},
{18,	20,	19,	23,	29},
{18,	15,	23,	23,	29},
{17,	14,	25,	23,	29},
{19,	16,	25,	22,	18},
{18,	14,	28,	23,	2},
{19,	14,	32,	23,	1},
{17,	16,	27,	21,	24},
{21,	14,	28,	21,	26},
{20,	15,	27,	22,	19},
{20,	14,	29,	22,	14},
{18,	14,	27,	23,	21},
{17,	20,	24,	22,	22},
{20,	19,	23,	23,	24},
{18,	19,	23,	21,	26},
{17,	24,	19,	23,	20},
{17,	14,	32,	23,	3},
{17,	22,	21,	28,	0},
{17,	24,	20,	22,	11},
{17,	17,	24,	22,	28},
{17,	24,	20,	25,	5},
{17,	21,	19,	23,	29},
{17,	17,	26,	21,	4},
{17,	20,	21,	24,	9},
{17,	15,	26,	20,	29},
{16,	29,	21,	19,	29},
{18,	25,	22,	17,	29},
{18,	24,	22,	19,	27},
{18,	24,	23,	17,	29},
{18,	27,	17,	19,	31},
{17,	24,	21,	18,	30},
{19,	23,	23,	17,	30},
{19,	26,	20,	17,	30},
{17,	22,	20,	19,	31},
{19,	21,	19,	17,	33},
{19,	24,	19,	17,	32},
{17,	26,	23,	17,	28},
{17,	28,	19,	17,	31},
{17,	27,	19,	17,	32},
{16,	10,	16,	34,	29},
{19,	8,	22,	30,	25},
{18,	7,	17,	32,	29},
{18,	9,	18,	34,	3},
{17,	3,	19,	34,	11},
{18,	3,	18,	34,	12},
{18,	7,	17,	33,	16},
{17,	18,	16,	30,	28},
{18,	12,	16,	34,	26},
{20,	18,	18,	31,	3},
{18,	16,	17,	31,	12},
{19,	12,	18,	33,	7},
{17,	13,	21,	29,	17},
{19,	10,	22,	29,	25},
{19,	12,	19,	29,	27},
{19,	11,	19,	30,	25},
{17,	18,	18,	30,	25},
{19,	15,	20,	29,	18},
{17,	4,	19,	33,	16},
{17,	17,	18,	33,	1},
{17,	15,	18,	32,	7},
{17,	11,	17,	31,	28},
{17,	39,	6,	34,	29},
{17,	19,	18,	31,	3},
{16,	22,	33,	13,	29},
{19,	20,	34,	7,	1},
{19,	19,	34,	7,	8},
{18,	18,	34,	8,	29},
{18,	22,	34,	3,	26},
{18,	21,	34,	3,	32},
{17,	19,	34,	7,	29},
{19,	19,	34,	8,	26},
{18,	19,	36,	4,	28},
{17,	19,	35,	6,	5},
{18,	19,	36,	5,	28},
{17,	19,	35,	6,	29},
{17,	19,	37,	5,	24},
{17,	22,	38,	2,	8},
{17,	20,	33,	5,	31},
{18,	19,	33,	7,	31},
{17,	19,	38,	2,	28},
{17,	19,	37,	3,	31},
{17,	23,	32,	6,	30},
{16,	17,	28,	16,	35},
{20,	19,	24,	16,	33},
{19,	23,	28,	10,	32},
{18,	1,	29,	15,	35},
{18,	19,	25,	16,	33},
{18,	19,	26,	10,	35},
{18,	20,	28,	10,	33},
{18,	13,	27,	17,	33},
{18,	12,	29,	17,	30},
{19,	13,	28,	17,	32},
{18,	8,	26,	17,	34},
{18,	22,	26,	10,	33},
{19,	22,	25,	10,	34},
{18,	8,	29,	14,	35},
{17,	15,	24,	13,	38},
{17,	22,	25,	7,	36},
{17,	11,	31,	16,	30},
{18,	10,	31,	15,	31},
{17,	8,	31,	13,	34},
{18,	8,	30,	15,	34},
{20,	6,	32,	16,	33},
{17,	17,	30,	13,	31},
{17,	14,	28,	7,	38},
{16,	9,	32,	7,	39},
{22,	15,	27,	6,	39},
{18,	18,	27,	4,	39},
{18,	12,	28,	7,	39},
{18,	18,	26,	6,	39},
{16,	1,	23,	28,	32},
{21,	7,	23,	26,	31},
{19,	10,	19,	28,	31},
{19,	10,	24,	25,	30},
{16,	18,	32,	18,	19},
{20,	20,	30,	14,	23},
{20,	19,	30,	15,	23},
{19,	17,	32,	19,	5},
{19,	16,	32,	18,	21},
{18,	17,	33,	18,	3},
{18,	17,	30,	15,	29},
{17,	16,	34,	19,	1},
{17,	17,	36,	14,	0},
{17,	20,	32,	14,	0},
{17,	19,	32,	15,	4},
{17,	18,	32,	14,	24},
{17,	16,	32,	19,	22},
{17,	19,	31,	14,	19},
{16,	11,	5,	36,	21},
{18,	11,	8,	36,	5},
{17,	11,	8,	37,	3},
{17,	11,	9,	36,	5},
{16,	5,	24,	18,	36},
{19,	18,	22,	16,	36},
{18,	13,	24,	16,	36},
{17,	7,	22,	17,	36},
{16,	28,	27,	13,	27},
{19,	28,	27,	10,	29},
{18,	29,	24,	12,	2},
{17,	28,	26,	11,	31},
{17,	30,	24,	12,	2},
{16,	12,	38,	13,	29},
{19,	5,	39,	7,	26},
{19,	12,	39,	10,	2},
{19,	13,	38,	7,	10},
{18,	13,	39,	7,	7},
{17,	6,	38,	10,	30},
{17,	9,	39,	16,	1},
{18,	9,	38,	15,	4},
{18,	9,	37,	14,	26},
{17,	11,	38,	14,	4},
{17,	7,	39,	13,	21},
{17,	12,	39,	5,	24},
{19,	10,	39,	7,	21},
{18,	8,	39,	11,	24},
{17,	0,	39,	6,	27},
{17,	2,	39,	5,	31},
{17,	13,	38,	5,	30},
{16,	10,	5,	31,	34},
{17,	15,	7,	31,	32},
{16,	28,	23,	19,	23},
{20,	29,	22,	17,	3},
{18,	29,	22,	19,	3},
{18,	27,	23,	17,	27},
{16,	11,	24,	16,	38},
{17,	17,	22,	16,	37},
{16,	19,	20,	19,	36},
{19,	13,	16,	18,	38},
{18,	16,	18,	18,	37},
{17,	23,	16,	18,	36},
{17,	16,	19,	17,	37},
{17,	20,	18,	18,	34},
{16,	1,	35,	10,	36},
{19,	3,	36,	10,	33},
{19,	7,	32,	10,	35},
{18,	6,	32,	11,	34},
{17,	6,	32,	11,	35},
{18,	1,	30,	12,	35},
{17,	1,	30,	13,	35},
{17,	3,	35,	11,	33},
{16,	1,	30,	10,	38},
{18,	5,	29,	9,	38},
{17,	9,	28,	9,	38},
{17,	7,	30,	10,	36},
{17,	5,	30,	10,	37},
{16,	4,	32,	32,	1},
{17,	4,	29,	32,	2},
{16,	2,	25,	19,	35},
{22,	2,	26,	19,	34},
{18,	7,	24,	19,	34},
{17,	5,	27,	17,	35},
{17,	2,	23,	19,	36},
{18,	7,	22,	19,	36},
{16,	4,	36,	29,	15},
{16,	2,	39,	25,	8},
{17,	3,	39,	23,	8},
{18,	5,	39,	23,	3},
{19,	4,	39,	29,	0},
{18,	6,	39,	26,	0},
{16,	28,	22,	13,	35},
{19,	20,	21,	15,	36},
{18,	28,	21,	10,	36},
{17,	22,	25,	13,	34},
{17,	28,	22,	7,	37},
{19,	27,	22,	4,	39},
{18,	29,	22,	6,	36},
{17,	28,	23,	2,	39},
{18,	28,	22,	4,	38},
{17,	29,	22,	10,	34},
{19,	32,	21,	9,	34},
{17,	30,	22,	5,	36},
{17,	29,	22,	8,	35},
{17,	19,	24,	15,	34},
{16,	22,	18,	30,	21},
{18,	23,	18,	27,	22},
{18,	23,	14,	29,	21},
{17,	21,	18,	27,	27},
{17,	19,	18,	31,	6},
{16,	39,	15,	24,	33},
{18,	23,	14,	27,	30},
{17,	25,	17,	20,	32},
{19,	25,	16,	23,	29},
{18,	24,	18,	23,	28},
{17,	24,	17,	24,	29},
{17,	27,	16,	21,	29},
{17,	18,	16,	24,	32},
{17,	39,	12,	26,	33},
{16,	4,	8,	35,	27},
{16,	2,	27,	10,	39},
{17,	9,	25,	9,	39},
{17,	16,	25,	8,	39},
{17,	12,	27,	8,	39},
{16,	30,	19,	19,	29},
{18,	30,	20,	19,	9},
{19,	31,	20,	19,	0},
{19,	30,	21,	17,	3},
{18,	39,	20,	17,	1},
{17,	39,	19,	18,	14},
{16,	32,	27,	3,	25},
{16,	25,	33,	4,	28},
{19,	25,	33,	2,	31},
{17,	25,	35,	0,	34},
{17,	25,	33,	3,	30},
{16,	21,	35,	6,	30},
{20,	22,	34,	6,	7},
{19,	20,	36,	5,	24},
{19,	21,	36,	5,	18},
{17,	20,	37,	5,	8},
{17,	22,	34,	4,	26},
{16,	27,	30,	7,	27},
{18,	29,	30,	3,	21},
{18,	27,	30,	8,	9},
{16,	24,	28,	16,	28},
{18,	22,	29,	16,	22},
{16,	3,	27,	23,	31},
{18,	12,	25,	20,	31},
{17,	8,	27,	20,	31},
{17,	13,	24,	24,	30},
{19,	14,	25,	19,	32},
{16,	5,	23,	34,	1},
{17,	3,	20,	34,	11},
{19,	1,	20,	33,	16},
{17,	3,	26,	33,	0},
{18,	5,	24,	33,	1},
{19,	7,	25,	33,	0},
{17,	10,	20,	33,	5},
{16,	39,	22,	4,	34},
{19,	39,	23,	0,	33},
{16,	11,	16,	32,	30},
{18,	6,	16,	31,	31},
{17,	17,	15,	30,	31},
{18,	14,	16,	31,	30},
{17,	14,	18,	26,	31},
{16,	21,	24,	17,	33},
{17,	20,	24,	16,	34},
{17,	21,	20,	19,	32},
{17,	20,	21,	19,	33},
{17,	21,	23,	16,	34},
{17,	22,	21,	17,	32},
{16,	19,	29,	7,	36},
{21,	15,	30,	8,	34},
{20,	15,	29,	10,	35},
{19,	13,	35,	4,	37},
{19,	15,	29,	6,	38},
{18,	13,	31,	7,	35},
{18,	13,	34,	7,	33},
{17,	17,	35,	5,	33},
{19,	16,	32,	7,	33},
{18,	15,	31,	6,	35},
{18,	14,	31,	5,	38},
{17,	17,	29,	10,	35},
{17,	24,	29,	7,	32},
{17,	24,	29,	4,	33},
{17,	15,	34,	4,	36},
{17,	15,	29,	13,	32},
{17,	11,	30,	11,	35},
{16,	4,	37,	30,	1},
{16,	4,	25,	33,	6},
{17,	1,	24,	33,	7},
{17,	10,	21,	33,	4},
{16,	4,	12,	39,	0},
{17,	5,	12,	38,	1},
{16,	23,	23,	19,	31},
{18,	24,	23,	19,	28},
{17,	21,	24,	19,	30},
{17,	25,	20,	19,	30},
{17,	26,	19,	18,	32},
{17,	22,	22,	18,	32},
{16,	1,	36,	13,	32},
{17,	3,	37,	13,	30},
{16,	6,	36,	16,	30},
{16,	34,	26,	0,	33},
{16,	22,	22,	21,	28},
{19,	22,	24,	20,	23},
{18,	23,	20,	20,	28},
{18,	21,	21,	22,	26},
{16,	5,	39,	28,	2},
{16,	32,	29,	0,	32},
{19,	31,	28,	0,	35},
{18,	32,	27,	0,	35},
{17,	32,	25,	0,	36},
{17,	31,	27,	0,	37},
{17,	33,	29,	0,	5},
{16,	7,	22,	20,	34},
{17,	7,	21,	20,	35},
{18,	3,	20,	21,	35},
{16,	22,	27,	8,	35},
{20,	20,	27,	6,	37},
{19,	23,	28,	4,	35},
{17,	22,	27,	11,	33},
{17,	23,	27,	6,	34},
{17,	20,	26,	10,	35},
{17,	21,	27,	4,	37},
{18,	23,	26,	5,	36},
{18,	22,	27,	4,	37},
{18,	22,	26,	7,	36},
{17,	22,	26,	6,	37},
{16,	17,	22,	26,	14},
{19,	18,	22,	26,	9},
{18,	16,	21,	27,	15},
{17,	17,	21,	25,	26},
{17,	18,	20,	24,	29},
{16,	22,	34,	7,	26},
{16,	28,	17,	24,	18},
{18,	25,	17,	23,	28},
{18,	39,	17,	22,	20},
{18,	39,	16,	22,	29},
{16,	4,	39,	7,	31},
{18,	6,	38,	10,	31},
{17,	4,	38,	7,	32},
{18,	1,	39,	5,	33},
{16,	18,	37,	9,	18},
{19,	19,	35,	7,	20},
{17,	19,	35,	8,	20},
{17,	18,	37,	6,	28},
{17,	20,	35,	7,	13},
{16,	30,	24,	9,	33},
{19,	23,	24,	9,	35},
{17,	24,	24,	9,	35},
{16,	4,	16,	24,	34},
{19,	16,	14,	24,	34},
{16,	23,	22,	23,	19},
{16,	1,	36,	9,	35},
{16,	27,	23,	19,	28},
{16,	25,	24,	19,	24},
{19,	26,	25,	16,	25},
{17,	26,	25,	16,	28},
{16,	26,	24,	19,	17},
{16,	13,	27,	18,	34},
{17,	12,	28,	18,	34},
{16,	3,	38,	17,	24},
{16,	7,	4,	37,	5},
{16,	25,	17,	26,	25},
{17,	25,	15,	26,	28},
{16,	34,	24,	1,	21},
{16,	39,	3,	36,	22},
{16,	4,	28,	31,	8},
{16,	19,	18,	21,	34},
{18,	12,	19,	21,	35},
{17,	12,	20,	21,	34},
{16,	28,	28,	10,	7},
{18,	28,	28,	7,	14},
{17,	29,	28,	9,	1},
{17,	29,	28,	7,	5},
{16,	20,	24,	16,	35},
{18,	18,	23,	13,	38},
{16,	19,	32,	16,	19},
{16,	39,	21,	5,	36},
{16,	1,	20,	34,	15},
{17,	2,	19,	34,	16},
{16,	16,	18,	17,	38},
{16,	19,	18,	18,	37},
{17,	18,	17,	17,	38},
{16,	21,	13,	24,	35},
{16,	30,	23,	7,	34},
{19,	29,	23,	6,	35},
{17,	30,	23,	3,	36},
{16,	12,	34,	16,	30},
{18,	8,	34,	13,	31},
{18,	14,	33,	10,	31},
{17,	11,	38,	10,	30},
{17,	14,	34,	13,	30},
{16,	12,	32,	20,	30},
{17,	5,	30,	18,	34},
{17,	13,	31,	19,	30},
{17,	14,	30,	18,	30},
{17,	6,	32,	17,	32},
{17,	7,	32,	18,	31},
{18,	7,	30,	17,	34},
{17,	15,	31,	16,	30},
{16,	15,	30,	21,	12},
{19,	15,	29,	22,	14},
{18,	15,	32,	21,	4},
{16,	4,	19,	33,	21},
{19,	2,	17,	34,	21},
{18,	5,	18,	33,	23},
{16,	30,	32,	0,	22},
{16,	3,	36,	7,	36},
{16,	6,	38,	14,	29},
{17,	3,	38,	17,	25},
{16,	29,	24,	4,	35},
{16,	14,	24,	19,	34},
{17,	18,	23,	19,	33},
{18,	21,	23,	19,	32},
{16,	18,	22,	19,	34},
{16,	17,	22,	18,	35},
{18,	9,	22,	19,	36},
{16,	20,	24,	19,	33},
{17,	17,	24,	19,	34},
{16,	30,	29,	2,	7},
{16,	3,	32,	18,	33},
{16,	20,	19,	26,	22},
{17,	18,	19,	27,	22},
{16,	33,	27,	0,	34},
{16,	1,	27,	19,	34},
{16,	39,	16,	18,	35},
{17,	25,	16,	18,	36},
{16,	1,	24,	28,	30},
{16,	24,	25,	6,	37},
{16,	3,	28,	33,	0},
{16,	1,	27,	33,	5},
{16,	23,	17,	17,	35},
{16,	20,	19,	19,	36},
{17,	20,	20,	17,	35},
{16,	20,	24,	10,	38},
{17,	20,	27,	7,	37},
{18,	19,	26,	7,	38},
{18,	16,	27,	8,	38},
{17,	15,	27,	9,	37},
{16,	26,	24,	16,	31},
{16,	25,	32,	5,	19},
{16,	26,	20,	17,	32},
{16,	30,	28,	3,	11},
{16,	39,	23,	0,	36},
{16,	20,	16,	23,	33},
{18,	23,	16,	25,	30},
{16,	22,	29,	7,	33},
{18,	22,	28,	7,	34},
{17,	20,	28,	7,	36},
{17,	22,	28,	7,	35},
{17,	21,	28,	7,	36},
{16,	21,	38,	3,	8},
{16,	15,	31,	15,	31},
{17,	17,	30,	15,	31},
{16,	11,	33,	15,	31},
{17,	11,	32,	12,	32},
{16,	1,	35,	18,	31},
{17,	4,	34,	18,	31},
{17,	8,	35,	17,	30},
{17,	12,	33,	19,	30},
{17,	6,	34,	18,	31},
{16,	1,	36,	16,	31},
{16,	32,	21,	10,	32},
{16,	31,	27,	3,	27},
{16,	31,	21,	18,	0},
{16,	9,	17,	24,	33},
{16,	18,	23,	16,	36},
{16,	19,	14,	28,	32},
{16,	20,	19,	29,	3},
{16,	5,	32,	32,	1},
{16,	25,	16,	19,	34},
{17,	21,	24,	19,	33},
{18,	23,	17,	19,	34},
{16,	21,	19,	18,	35},
{16,	16,	24,	10,	39},
{16,	19,	23,	24,	7},
{17,	20,	22,	27,	0},
{16,	24,	28,	11,	32},
{16,	14,	15,	34,	18},
{16,	14,	12,	34,	29},
{16,	18,	31,	19,	11},
{16,	27,	23,	4,	39},
{16,	6,	37,	25,	18},
{16,	24,	17,	29,	1},
{18,	26,	18,	28,	0},
{17,	24,	17,	28,	9},
{16,	4,	22,	34,	2},
{16,	39,	13,	18,	37},
{16,	39,	22,	2,	35},
{16,	15,	31,	8,	35},
{17,	15,	33,	8,	33},
{18,	14,	35,	7,	33},
{17,	12,	37,	9,	31},
{17,	17,	35,	9,	30},
{17,	13,	36,	6,	33},
{17,	10,	36,	11,	31},
{17,	15,	32,	13,	31},
{16,	1,	29,	16,	35},
{16,	39,	20,	17,	3},
{16,	17,	31,	20,	0},
{16,	6,	19,	32,	26},
{17,	18,	18,	31,	10},
{18,	8,	18,	33,	23},
{17,	14,	18,	31,	17},
{16,	12,	18,	33,	23},
{16,	31,	21,	15,	8},
{16,	30,	34,	0,	10},
{16,	23,	29,	15,	5},
{16,	15,	23,	24,	29},
{16,	28,	25,	2,	36},
{16,	17,	9,	27,	34},
{16,	19,	35,	9,	20},
{16,	31,	30,	0,	22},
{17,	31,	33,	0,	5},
{17,	32,	30,	0,	16},
{16,	19,	29,	10,	33},
{17,	21,	29,	9,	33},
{17,	18,	30,	8,	33},
{16,	18,	19,	27,	26},
{16,	16,	20,	28,	25},
{18,	17,	20,	26,	27},
{16,	14,	25,	26,	25},
{20,	12,	26,	26,	17},
{20,	15,	23,	26,	20},
{18,	12,	28,	25,	11},
{18,	11,	27,	25,	26},
{17,	15,	21,	27,	27},
{17,	11,	28,	28,	3},
{17,	14,	21,	28,	25},
{17,	12,	33,	25,	2},
{17,	12,	34,	26,	0},
{17,	12,	32,	26,	2},
{16,	16,	24,	26,	25},
{19,	17,	24,	24,	25},
{18,	17,	23,	28,	0},
{17,	13,	22,	30,	3},
{17,	17,	23,	26,	13},
{16,	11,	24,	28,	28},
{16,	20,	28,	4,	38},
{16,	18,	32,	15,	24},
{16,	13,	24,	28,	4},
{18,	12,	24,	28,	15},
{17,	17,	24,	28,	0},
{16,	17,	31,	15,	29},
{16,	31,	25,	4,	31},
{16,	19,	29,	5,	37},
{16,	6,	31,	17,	34},
{16,	1,	37,	12,	31},
{16,	26,	17,	26,	7},
{16,	26,	15,	27,	22},
{18,	25,	15,	28,	23},
{16,	29,	38,	0,	1},
{16,	28,	37,	0,	14},
{17,	26,	35,	0,	29},
{16,	33,	24,	2,	7},
{16,	23,	14,	26,	32},
{16,	22,	14,	22,	34},
{16,	27,	23,	5,	37},
{16,	18,	24,	13,	36},
{16,	21,	23,	21,	25},
{16,	20,	24,	21,	27},
{16,	23,	22,	20,	23},
{16,	26,	24,	17,	20},
{16,	13,	19,	30,	25},
{17,	15,	20,	30,	11},
{17,	16,	19,	31,	5},
{17,	12,	19,	32,	16},
{17,	11,	20,	32,	10},
{17,	14,	20,	31,	10},
{16,	12,	21,	33,	4},
{16,	11,	19,	17,	38},
{16,	39,	21,	9,	34},
{16,	20,	23,	20,	29},
{16,	17,	24,	24,	26},
{16,	10,	32,	24,	22},
{16,	10,	32,	28,	3},
{17,	8,	34,	27,	5},
{16,	7,	23,	24,	32},
{16,	28,	29,	6,	5},
{16,	28,	29,	5,	20},
{16,	28,	29,	7,	8},
{16,	29,	29,	5,	12},
{16,	29,	27,	4,	32},
{16,	31,	21,	17,	3},
{16,	21,	21,	25,	5},
{16,	23,	21,	24,	7},
{18,	21,	20,	25,	12},
{16,	18,	20,	26,	27},
{17,	21,	20,	26,	12},
{16,	7,	32,	30,	1},
{16,	39,	21,	0,	38},
{16,	12,	34,	18,	30},
{16,	14,	15,	32,	30},
{16,	23,	26,	5,	37},
{16,	10,	22,	19,	36},
{16,	12,	25,	11,	37},
{16,	13,	26,	10,	36},
{16,	10,	28,	10,	37},
{17,	7,	26,	10,	39},
{16,	8,	37,	18,	5},
{16,	3,	30,	31,	2},
{16,	1,	28,	33,	1},
{16,	13,	9,	37,	2},
{16,	28,	23,	16,	29},
{16,	20,	17,	26,	30},
{16,	25,	21,	9,	38},
{17,	28,	21,	8,	37},
{16,	21,	18,	17,	36},
{16,	19,	37,	1,	34},
{16,	13,	38,	1,	37},
{16,	13,	24,	20,	32},
{16,	12,	37,	6,	32},
{17,	15,	38,	2,	36},
{18,	13,	38,	4,	33},
{16,	6,	38,	2,	38},
{16,	7,	37,	7,	33},
{16,	17,	37,	3,	34},
{16,	28,	35,	0,	19},
{16,	30,	35,	0,	10},
{16,	0,	39,	22,	10},
{16,	10,	36,	20,	0},
{16,	10,	38,	19,	0},
{16,	7,	34,	27,	26},
{16,	25,	30,	1,	34},
{17,	25,	28,	4,	34},
{16,	25,	29,	3,	34},
{16,	16,	33,	1,	39},
{16,	11,	19,	33,	17},
{16,	5,	36,	0,	39},
{17,	5,	35,	1,	39},
{16,	17,	35,	16,	0},
{16,	39,	11,	30,	29},
{16,	15,	29,	15,	32},
{16,	24,	24,	7,	36},
{16,	20,	28,	6,	37},
{16,	26,	17,	26,	18},
{16,	30,	21,	14,	21},
{17,	31,	21,	15,	12},
{16,	30,	22,	17,	10},
{18,	29,	22,	18,	12},
{16,	31,	22,	17,	6},
{18,	39,	20,	17,	11},
{16,	29,	23,	18,	11},
{16,	29,	23,	16,	29},
{16,	30,	21,	18,	10},
{16,	6,	33,	10,	35},
{16,	5,	34,	18,	32},
{17,	6,	35,	10,	34},
{16,	4,	38,	15,	26},
{17,	8,	37,	15,	27},
{16,	6,	37,	18,	28},
{20,	3,	38,	19,	23},
{17,	1,	38,	17,	27},
{17,	4,	37,	21,	24},
{17,	3,	38,	20,	23},
{16,	8,	37,	16,	28},
{16,	7,	36,	18,	28},
{16,	4,	36,	4,	37},
{16,	10,	36,	15,	19},
{16,	11,	36,	15,	14},
{17,	11,	37,	14,	19},
{16,	15,	37,	14,	16},
{16,	12,	36,	18,	5},
{18,	12,	36,	20,	2},
{16,	11,	36,	20,	4},
{16,	9,	36,	24,	4},
{16,	20,	37,	5,	17},
{16,	18,	24,	24,	11},
{16,	20,	24,	26,	1},
{18,	22,	23,	24,	1},
{17,	21,	22,	26,	2},
{17,	21,	23,	27,	0},
{16,	22,	22,	24,	16},
{19,	18,	21,	26,	22},
{17,	21,	21,	24,	19},
{17,	21,	22,	26,	4},
{16,	23,	23,	24,	4},
{17,	20,	24,	26,	3},
{16,	20,	22,	26,	12},
{17,	21,	23,	25,	6},
{16,	23,	21,	25,	19},
{18,	20,	21,	26,	19},
{17,	23,	19,	26,	18},
{16,	20,	20,	28,	19},
{20,	18,	20,	28,	27},
{19,	19,	21,	27,	13},
{18,	20,	22,	27,	3},
{17,	19,	21,	28,	13},
{17,	14,	21,	28,	28},
{17,	18,	20,	30,	1},
{16,	23,	20,	26,	18},
{16,	23,	21,	27,	3},
{19,	23,	19,	27,	18},
{17,	22,	21,	28,	3},
{16,	19,	19,	31,	3},
{16,	15,	19,	29,	26},
{16,	24,	20,	27,	1},
{17,	24,	19,	28,	3},
{16,	18,	24,	27,	1},
{16,	8,	36,	23,	7},
{16,	14,	34,	16,	30},
{16,	21,	22,	15,	35},
{16,	19,	23,	21,	29},
{16,	11,	26,	26,	28},
{16,	15,	26,	21,	29},
{16,	32,	23,	3,	33},
{16,	31,	25,	2,	33},
{16,	20,	11,	27,	33},
{16,	39,	10,	28,	33},
{16,	25,	24,	5,	37},
{17,	26,	24,	6,	34},
{16,	15,	15,	28,	32},
{16,	39,	20,	17,	12},
{16,	30,	20,	19,	14},
{16,	11,	20,	30,	25},
{16,	1,	36,	4,	38},
{16,	26,	19,	25,	0},
{16,	13,	38,	14,	0},
{15,	14,	38,	30,	27},
{22,	15,	37,	16,	18},
{20,	14,	31,	23,	29},
{19,	15,	24,	28,	8},
{19,	16,	37,	16,	1},
{19,	17,	22,	29,	1},
{18,	18,	38,	4,	23},
{18,	14,	35,	23,	29},
{18,	19,	38,	3,	31},
{17,	15,	37,	19,	16},
{17,	14,	39,	16,	2},
{18,	14,	39,	5,	18},
{18,	10,	39,	17,	1},
{17,	5,	19,	30,	29},
{17,	15,	21,	29,	26},
{17,	7,	39,	17,	14},
{18,	9,	39,	14,	9},
{17,	10,	37,	18,	28},
{17,	8,	39,	26,	0},
{17,	17,	38,	4,	31},
{17,	16,	38,	5,	27},
{17,	16,	22,	28,	12},
{17,	16,	23,	28,	9},
{17,	21,	23,	27,	2},
{17,	17,	22,	30,	1},
{16,	15,	39,	16,	20},
{20,	17,	38,	13,	0},
{19,	15,	38,	18,	3},
{18,	15,	38,	13,	27},
{18,	15,	36,	19,	22},
{18,	15,	39,	4,	27},
{17,	16,	38,	10,	3},
{16,	9,	26,	30,	29},
{21,	9,	27,	30,	28},
{16,	10,	33,	28,	29},
{16,	0,	22,	30,	31},
{19,	10,	17,	32,	30},
{18,	10,	21,	30,	30},
{17,	8,	20,	29,	31},
{16,	7,	39,	17,	23},
{17,	7,	39,	13,	24},
{16,	12,	39,	16,	27},
{17,	15,	39,	7,	25},
{16,	18,	39,	6,	27},
{18,	17,	39,	13,	0},
{17,	18,	39,	7,	11},
{17,	20,	38,	5,	15},
{17,	17,	38,	7,	27},
{17,	17,	38,	9,	24},
{18,	16,	39,	10,	14},
{17,	17,	38,	12,	4},
{16,	14,	36,	20,	29},
{16,	15,	26,	26,	27},
{19,	15,	27,	25,	22},
{18,	15,	28,	24,	12},
{17,	16,	25,	24,	18},
{17,	15,	29,	24,	12},
{18,	15,	30,	24,	5},
{16,	1,	36,	18,	31},
{16,	18,	19,	30,	26},
{16,	20,	18,	29,	27},
{17,	22,	18,	29,	23},
{17,	23,	14,	30,	22},
{16,	6,	39,	30,	0},
{16,	2,	39,	9,	31},
{16,	9,	29,	29,	28},
{16,	17,	21,	30,	9},
{17,	17,	21,	31,	2},
{17,	16,	20,	30,	22},
{17,	17,	22,	30,	5},
{18,	15,	22,	30,	18},
{16,	16,	32,	23,	0},
{16,	14,	21,	31,	15},
{18,	5,	24,	32,	25},
{17,	10,	21,	32,	15},
{16,	19,	39,	5,	27},
{18,	21,	39,	3,	11},
{16,	12,	24,	33,	0},
{16,	12,	39,	6,	31},
{17,	8,	39,	9,	30},
{17,	10,	39,	10,	28},
{17,	16,	39,	4,	31},
{17,	19,	39,	1,	34},
{16,	14,	39,	18,	0},
{16,	14,	18,	30,	30},
{16,	18,	20,	30,	20},
{18,	18,	21,	29,	13},
{17,	18,	22,	29,	5},
{17,	19,	23,	28,	3},
{17,	19,	24,	28,	2},
{17,	18,	21,	29,	16},
{17,	16,	21,	29,	23},
{16,	15,	32,	21,	13},
{16,	22,	18,	27,	29},
{17,	18,	20,	28,	28},
{16,	15,	37,	16,	28},
{16,	16,	39,	3,	34},
{16,	5,	26,	32,	12},
{16,	18,	18,	30,	28},
{16,	14,	23,	28,	28},
{16,	18,	21,	30,	13},
{16,	16,	27,	23,	3},
{16,	11,	25,	33,	0},
{16,	14,	18,	29,	31},
{16,	15,	16,	28,	32},
{16,	20,	19,	28,	23},
{17,	19,	19,	27,	28},
{16,	15,	24,	29,	5},
{16,	16,	39,	13,	3},
{16,	13,	38,	9,	30},
{16,	16,	23,	29,	9},
{16,	9,	19,	32,	26},
{15,	26,	28,	23,	28},
{20,	15,	32,	20,	22},
{19,	15,	29,	23,	29},
{19,	16,	30,	22,	4},
{20,	17,	31,	20,	5},
{19,	27,	21,	20,	4},
{19,	26,	28,	13,	29},
{19,	26,	27,	16,	29},
{19,	18,	29,	21,	4},
{19,	18,	27,	21,	29},
{18,	16,	29,	23,	28},
{19,	17,	29,	21,	21},
{18,	23,	24,	19,	31},
{18,	24,	25,	18,	29},
{18,	22,	25,	24,	1},
{18,	17,	23,	24,	29},
{18,	23,	21,	24,	21},
{18,	28,	18,	21,	8},
{18,	25,	25,	17,	29},
{18,	17,	29,	23,	7},
{18,	17,	30,	23,	2},
{18,	17,	31,	21,	9},
{18,	18,	31,	21,	2},
{17,	16,	29,	24,	23},
{17,	17,	29,	24,	6},
{17,	15,	29,	25,	23},
{17,	23,	23,	20,	29},
{17,	39,	16,	23,	29},
{17,	26,	21,	20,	29},
{17,	15,	30,	21,	27},
{17,	19,	26,	24,	2},
{17,	22,	25,	17,	30},
{17,	21,	24,	24,	7},
{17,	27,	21,	21,	3},
{16,	22,	29,	19,	23},
{18,	23,	29,	18,	2},
{16,	22,	21,	25,	25},
{18,	19,	20,	28,	26},
{16,	16,	25,	26,	27},
{17,	16,	25,	28,	2},
{16,	22,	26,	20,	29},
{17,	24,	24,	20,	29},
{16,	25,	28,	10,	32},
{16,	27,	28,	8,	31},
{17,	27,	30,	7,	28},
{16,	20,	20,	26,	28},
{16,	24,	20,	20,	30},
{16,	25,	29,	10,	29},
{16,	18,	29,	21,	11},
{16,	21,	24,	28,	0},
{16,	28,	18,	20,	18},
{16,	17,	30,	24,	2},
{16,	21,	25,	24,	4},
{16,	26,	16,	25,	26},
{16,	20,	21,	26,	25},
{15,	16,	22,	17,	39},
{19,	18,	10,	17,	39},
{18,	8,	20,	18,	37},
{18,	18,	22,	13,	39},
{17,	3,	22,	18,	37},
{17,	39,	9,	17,	39},
{16,	11,	23,	18,	36},
{16,	17,	19,	17,	38},
{16,	17,	14,	17,	39},
{15,	30,	27,	16,	29},
{19,	29,	28,	10,	3},
{18,	27,	28,	15,	21},
{18,	30,	27,	4,	32},
{18,	31,	26,	11,	1},
{18,	28,	24,	13,	31},
{18,	29,	27,	7,	30},
{17,	31,	21,	15,	26},
{17,	29,	26,	13,	30},
{17,	31,	25,	13,	0},
{17,	30,	28,	7,	0},
{17,	30,	26,	12,	30},
{16,	31,	24,	16,	26},
{19,	31,	26,	11,	11},
{17,	31,	21,	17,	12},
{16,	27,	24,	19,	27},
{16,	27,	28,	13,	30},
{16,	31,	27,	5,	8},
{16,	31,	24,	11,	30},
{16,	30,	22,	16,	30},
{16,	27,	29,	10,	28},
{16,	26,	29,	13,	28},
{15,	39,	12,	26,	37},
{20,	16,	11,	21,	38},
{16,	8,	15,	26,	34},
{20,	22,	13,	26,	34},
{20,	5,	13,	26,	35},
{17,	2,	17,	26,	33},
{17,	4,	16,	26,	34},
{16,	8,	14,	28,	33},
{16,	10,	13,	24,	36},
{16,	14,	14,	21,	37},
{18,	22,	13,	21,	37},
{16,	2,	12,	29,	33},
{15,	25,	26,	13,	38},
{20,	17,	27,	10,	37},
{20,	26,	26,	9,	33},
{20,	26,	26,	7,	34},
{20,	23,	27,	13,	33},
{19,	25,	27,	6,	34},
{20,	25,	27,	11,	33},
{19,	29,	23,	12,	33},
{18,	24,	26,	1,	39},
{18,	24,	29,	7,	33},
{18,	27,	22,	10,	36},
{18,	27,	21,	10,	37},
{18,	27,	25,	9,	33},
{18,	12,	26,	10,	39},
{17,	22,	24,	7,	39},
{18,	26,	24,	3,	39},
{17,	21,	26,	7,	39},
{17,	28,	25,	4,	35},
{18,	27,	25,	6,	34},
{18,	27,	24,	8,	34},
{17,	25,	23,	8,	39},
{17,	22,	27,	2,	39},
{17,	25,	27,	14,	31},
{17,	28,	24,	7,	34},
{17,	23,	27,	8,	35},
{17,	25,	27,	6,	35},
{17,	25,	28,	4,	35},
{17,	23,	28,	7,	35},
{17,	22,	25,	7,	39},
{17,	25,	24,	4,	39},
{17,	23,	25,	6,	39},
{17,	23,	26,	5,	39},
{17,	25,	25,	3,	39},
{16,	11,	26,	16,	37},
{19,	15,	25,	16,	36},
{16,	19,	26,	10,	39},
{16,	21,	22,	15,	36},
{16,	20,	22,	13,	39},
{16,	26,	26,	9,	34},
{17,	29,	23,	9,	34},
{16,	29,	24,	8,	34},
{16,	21,	24,	15,	35},
{16,	20,	28,	6,	38},
{16,	22,	31,	0,	39},
{16,	28,	23,	13,	33},
{16,	27,	24,	13,	32},
{16,	24,	28,	2,	36},
{16,	24,	27,	4,	38},
{17,	24,	29,	1,	37},
{15,	23,	24,	30,	25},
{19,	18,	24,	28,	26},
{18,	20,	18,	30,	28},
{18,	15,	24,	30,	27},
{17,	23,	25,	24,	4},
{17,	23,	16,	28,	29},
{18,	23,	15,	30,	28},
{17,	39,	13,	30,	28},
{17,	24,	18,	29,	6},
{17,	20,	24,	25,	26},
{16,	15,	28,	30,	23},
{20,	15,	29,	27,	23},
{18,	16,	25,	30,	9},
{17,	16,	25,	30,	17},
{17,	16,	25,	28,	26},
{17,	15,	29,	28,	23},
{16,	17,	25,	28,	26},
{17,	17,	28,	24,	14},
{16,	20,	25,	28,	3},
{16,	18,	27,	28,	0},
{20,	16,	26,	26,	24},
{17,	16,	28,	30,	0},
{16,	20,	26,	27,	1},
{17,	17,	27,	25,	7},
{16,	18,	24,	31,	0},
{16,	16,	26,	28,	20},
{16,	18,	23,	25,	28},
{16,	23,	14,	28,	31},
{16,	24,	20,	28,	5},
{16,	24,	20,	29,	3},
{16,	24,	19,	30,	1},
{16,	24,	14,	30,	28},
{16,	39,	14,	27,	31},
{16,	39,	13,	26,	34},
{16,	15,	24,	28,	28},
{17,	16,	26,	25,	28},
{15,	29,	32,	7,	25},
{21,	26,	31,	9,	14},
{21,	29,	31,	1,	30},
{22,	27,	31,	6,	28},
{19,	26,	31,	8,	27},
{18,	27,	32,	4,	27},
{18,	25,	32,	9,	1},
{17,	29,	28,	6,	30},
{18,	28,	29,	7,	27},
{17,	26,	33,	2,	24},
{17,	29,	33,	1,	8},
{18,	28,	36,	1,	0},
{17,	26,	33,	4,	5},
{17,	27,	31,	0,	34},
{17,	26,	32,	3,	30},
{17,	28,	33,	0,	30},
{16,	26,	34,	4,	23},
{21,	25,	36,	1,	12},
{20,	26,	35,	2,	12},
{18,	27,	35,	2,	4},
{18,	26,	35,	3,	2},
{18,	28,	35,	3,	0},
{17,	23,	36,	4,	4},
{17,	25,	39,	1,	2},
{17,	23,	34,	3,	30},
{17,	22,	35,	2,	31},
{16,	26,	32,	8,	27},
{20,	24,	32,	9,	29},
{16,	24,	32,	7,	30},
{16,	29,	28,	7,	29},
{16,	26,	35,	4,	4},
{16,	26,	32,	9,	11},
{16,	29,	28,	10,	6},
{16,	29,	30,	3,	27},
{16,	25,	34,	3,	27},
{16,	29,	32,	0,	32},
{18,	28,	30,	0,	37},
{16,	26,	32,	7,	28},
{16,	30,	32,	2,	0},
{16,	27,	32,	2,	30},
{16,	24,	32,	12,	0},
{15,	18,	38,	18,	27},
{19,	19,	35,	10,	21},
{19,	16,	32,	19,	28},
{19,	16,	34,	19,	18},
{18,	19,	31,	16,	24},
{18,	18,	37,	13,	28},
{17,	16,	39,	16,	18},
{17,	17,	30,	17,	30},
{18,	16,	26,	17,	32},
{19,	15,	27,	17,	33},
{17,	21,	27,	17,	30},
{17,	20,	35,	7,	27},
{17,	17,	34,	19,	5},
{16,	16,	26,	19,	32},
{19,	19,	27,	19,	30},
{17,	17,	30,	18,	30},
{16,	21,	35,	7,	29},
{16,	19,	32,	14,	29},
{16,	19,	35,	13,	1},
{17,	19,	34,	11,	23},
{16,	19,	34,	13,	23},
{16,	16,	35,	16,	29},
{16,	16,	33,	18,	29},
{16,	15,	25,	18,	34},
{16,	19,	25,	19,	31},
{15,	9,	25,	26,	34},
{20,	3,	26,	26,	30},
{20,	4,	21,	21,	35},
{20,	10,	22,	25,	33},
{19,	15,	16,	24,	34},
{17,	4,	27,	22,	32},
{18,	9,	26,	26,	30},
{19,	12,	30,	21,	30},
{18,	14,	26,	23,	30},
{17,	10,	27,	26,	30},
{17,	19,	17,	22,	34},
{17,	15,	19,	24,	32},
{17,	10,	26,	22,	32},
{17,	13,	26,	22,	31},
{17,	11,	24,	22,	33},
{17,	2,	25,	27,	30},
{16,	4,	29,	25,	30},
{17,	7,	32,	22,	30},
{16,	13,	24,	21,	34},
{16,	18,	18,	24,	32},
{17,	23,	18,	23,	30},
{16,	4,	30,	23,	30},
{16,	19,	19,	24,	30},
{16,	8,	20,	28,	32},
{16,	23,	19,	22,	30},
{17,	24,	20,	22,	29},
{16,	21,	27,	21,	29},
{16,	24,	20,	23,	29},
{16,	14,	26,	24,	30},
{16,	15,	24,	24,	30},
{16,	15,	21,	23,	32},
{15,	6,	38,	18,	33},
{16,	10,	37,	18,	30},
{19,	10,	36,	15,	31},
{17,	10,	38,	17,	30},
{16,	10,	36,	16,	31},
{16,	9,	30,	18,	32},
{17,	10,	31,	18,	31},
{16,	8,	30,	17,	34},
{15,	20,	12,	35,	31},
{21,	17,	14,	32,	31},
{19,	17,	15,	33,	13},
{17,	17,	14,	34,	28},
{17,	17,	15,	33,	29},
{17,	15,	17,	33,	11},
{17,	39,	13,	33,	0},
{18,	20,	19,	31,	4},
{18,	22,	15,	34,	0},
{17,	21,	13,	31,	22},
{16,	19,	16,	35,	9},
{20,	6,	13,	38,	1},
{19,	2,	13,	35,	20},
{19,	20,	13,	34,	22},
{18,	6,	15,	38,	0},
{18,	19,	15,	34,	15},
{18,	5,	16,	35,	11},
{17,	21,	17,	34,	0},
{17,	6,	14,	38,	1},
{16,	17,	9,	36,	21},
{16,	18,	19,	31,	17},
{17,	17,	16,	31,	29},
{17,	15,	18,	32,	17},
{17,	16,	21,	31,	12},
{16,	17,	13,	33,	31},
{16,	15,	18,	33,	17},
{16,	15,	16,	33,	27},
{16,	20,	16,	34,	7},
{16,	13,	19,	33,	16},
{15,	30,	21,	23,	29},
{17,	26,	18,	21,	30},
{16,	24,	18,	21,	32},
{16,	26,	18,	21,	31},
{16,	24,	16,	21,	33},
{15,	13,	17,	28,	35},
{19,	16,	11,	28,	35},
{18,	19,	14,	26,	34},
{18,	12,	21,	24,	33},
{17,	15,	16,	24,	35},
{17,	15,	17,	26,	33},
{17,	8,	11,	29,	34},
{16,	14,	16,	21,	37},
{17,	12,	16,	22,	36},
{18,	5,	17,	22,	36},
{16,	8,	21,	20,	36},
{16,	10,	14,	24,	36},
{16,	19,	16,	24,	34},
{16,	16,	18,	21,	35},
{19,	17,	15,	25,	35},
{17,	21,	14,	22,	35},
{16,	18,	16,	21,	36},
{16,	20,	11,	28,	34},
{16,	15,	21,	24,	32},
{15,	2,	25,	19,	38},
{17,	11,	25,	18,	36},
{17,	11,	27,	17,	35},
{17,	6,	20,	19,	38},
{17,	8,	23,	17,	37},
{17,	11,	25,	15,	38},
{16,	13,	24,	18,	36},
{16,	17,	24,	18,	35},
{16,	14,	24,	18,	36},
{15,	31,	28,	7,	31},
{19,	30,	28,	4,	32},
{17,	31,	24,	5,	32},
{16,	30,	29,	4,	27},
{16,	30,	31,	2,	25},
{19,	31,	30,	0,	33},
{17,	30,	32,	2,	5},
{16,	31,	29,	2,	27},
{18,	31,	31,	2,	2},
{16,	30,	29,	5,	17},
{16,	30,	32,	1,	25},
{16,	31,	29,	3,	5},
{16,	30,	26,	9,	31},
{16,	30,	25,	7,	32},
{16,	31,	27,	8,	3},
{15,	39,	23,	7,	27},
{18,	33,	24,	2,	21},
{17,	33,	24,	4,	6},
{17,	33,	23,	2,	30},
{16,	33,	25,	3,	20},
{19,	33,	24,	4,	18},
{18,	34,	25,	2,	3},
{17,	33,	25,	1,	25},
{18,	34,	24,	1,	27},
{16,	39,	23,	5,	28},
{16,	39,	23,	9,	0},
{16,	33,	24,	2,	30},
{17,	34,	24,	1,	29},
{17,	39,	23,	1,	31},
{16,	34,	24,	2,	28},
{16,	33,	26,	3,	3},
{15,	23,	34,	13,	29},
{21,	21,	35,	8,	29},
{18,	24,	33,	7,	17},
{18,	24,	34,	7,	1},
{17,	23,	36,	5,	1},
{16,	25,	33,	6,	11},
{20,	26,	34,	5,	7},
{16,	22,	38,	5,	3},
{17,	23,	37,	4,	4},
{16,	26,	33,	6,	2},
{15,	25,	23,	17,	35},
{20,	26,	19,	18,	33},
{20,	23,	24,	15,	35},
{19,	22,	21,	18,	34},
{19,	24,	18,	19,	34},
{18,	25,	24,	15,	35},
{17,	26,	23,	16,	33},
{17,	24,	23,	18,	31},
{17,	25,	20,	18,	34},
{17,	23,	19,	19,	34},
{16,	26,	23,	17,	30},
{16,	26,	18,	17,	35},
{17,	26,	19,	18,	34},
{16,	25,	18,	18,	35},
{16,	21,	22,	19,	34},
{16,	25,	24,	17,	31},
{16,	23,	24,	16,	35},
{16,	26,	25,	17,	29},
{16,	20,	24,	17,	34},
{16,	22,	24,	17,	33},
{16,	22,	24,	19,	32},
{17,	24,	20,	19,	33},
{16,	22,	23,	19,	33},
{15,	6,	33,	19,	34},
{20,	8,	30,	19,	34},
{18,	3,	34,	12,	34},
{17,	8,	28,	20,	31},
{16,	3,	36,	13,	34},
{16,	1,	32,	13,	35},
{16,	7,	31,	13,	35},
{15,	4,	35,	23,	31},
{18,	1,	36,	20,	30},
{18,	4,	34,	19,	32},
{17,	9,	31,	20,	31},
{17,	12,	34,	20,	30},
{15,	39,	22,	13,	24},
{19,	32,	23,	11,	26},
{16,	32,	22,	13,	26},
{16,	39,	21,	15,	0},
{15,	23,	26,	26,	22},
{21,	19,	25,	27,	25},
{19,	21,	26,	28,	1},
{17,	19,	26,	28,	4},
{17,	17,	28,	24,	24},
{16,	18,	26,	28,	24},
{19,	20,	26,	28,	9},
{17,	19,	26,	27,	24},
{17,	21,	25,	27,	17},
{18,	23,	25,	27,	5},
{15,	27,	25,	22,	23},
{17,	28,	22,	22,	1},
{17,	27,	22,	22,	27},
{16,	28,	23,	20,	10},
{17,	29,	22,	20,	4},
{17,	29,	22,	22,	2},
{16,	29,	22,	23,	2},
{16,	28,	23,	23,	0},
{15,	7,	30,	18,	35},
{18,	6,	31,	14,	35},
{17,	2,	26,	19,	35},
{17,	11,	28,	18,	35},
{15,	20,	31,	18,	22},
{19,	19,	31,	19,	11},
{17,	21,	30,	19,	1},
{18,	21,	31,	17,	0},
{17,	20,	30,	16,	27},
{16,	19,	31,	20,	2},
{17,	20,	29,	21,	1},
{16,	20,	31,	15,	26},
{16,	19,	32,	16,	27},
{15,	4,	39,	32,	0},
{16,	5,	34,	31,	1},
{15,	14,	26,	13,	39},
{16,	19,	25,	11,	39},
{16,	18,	25,	13,	39},
{15,	11,	39,	21,	22},
{19,	11,	39,	18,	23},
{18,	9,	39,	22,	9},
{16,	11,	39,	18,	24},
{16,	9,	39,	26,	2},
{16,	7,	39,	24,	6},
{15,	32,	31,	2,	25},
{16,	31,	32,	1,	26},
{17,	30,	32,	0,	33},
{17,	31,	31,	1,	28},
{16,	31,	29,	2,	30},
{15,	17,	9,	36,	26},
{15,	10,	36,	26,	29},
{17,	5,	34,	27,	29},
{15,	9,	27,	16,	37},
{21,	2,	27,	11,	39},
{19,	16,	27,	12,	37},
{15,	5,	31,	13,	38},
{19,	9,	28,	12,	38},
{17,	9,	28,	13,	38},
{16,	2,	32,	13,	36},
{16,	14,	27,	10,	38},
{15,	19,	38,	10,	27},
{20,	21,	36,	7,	4},
{17,	20,	36,	13,	0},
{16,	19,	35,	13,	29},
{16,	19,	37,	11,	7},
{15,	17,	33,	21,	22},
{20,	17,	34,	19,	26},
{17,	15,	34,	21,	12},
{17,	17,	32,	23,	0},
{16,	17,	32,	23,	1},
{17,	15,	33,	24,	1},
{18,	15,	32,	24,	5},
{17,	15,	31,	24,	9},
{16,	17,	30,	19,	30},
{16,	16,	32,	23,	3},
{16,	18,	32,	19,	11},
{15,	24,	32,	8,	32},
{18,	21,	34,	5,	32},
{18,	18,	32,	7,	33},
{17,	21,	35,	8,	30},
{17,	19,	34,	5,	33},
{18,	23,	30,	7,	33},
{19,	24,	31,	5,	33},
{18,	19,	37,	3,	34},
{18,	19,	34,	3,	36},
{18,	19,	34,	4,	34},
{18,	16,	31,	7,	35},
{18,	19,	30,	4,	37},
{17,	19,	34,	4,	36},
{17,	25,	30,	4,	33},
{17,	25,	30,	10,	29},
{16,	19,	34,	13,	30},
{18,	19,	31,	12,	31},
{16,	25,	30,	8,	30},
{16,	24,	33,	4,	31},
{16,	23,	34,	5,	31},
{16,	19,	31,	5,	35},
{17,	18,	31,	7,	34},
{15,	16,	35,	18,	31},
{18,	12,	37,	13,	31},
{17,	21,	35,	6,	31},
{16,	17,	35,	7,	33},
{18,	20,	33,	6,	33},
{16,	11,	38,	14,	31},
{16,	19,	35,	6,	33},
{16,	21,	35,	6,	32},
{16,	13,	36,	18,	30},
{16,	7,	35,	20,	31},
{15,	30,	23,	18,	19},
{16,	31,	22,	18,	3},
{16,	30,	22,	18,	20},
{15,	30,	29,	7,	28},
{17,	29,	30,	6,	26},
{15,	3,	30,	16,	36},
{15,	10,	25,	35,	0},
{17,	22,	17,	35,	0},
{15,	1,	36,	13,	35},
{15,	27,	22,	26,	2},
{18,	26,	18,	26,	8},
{18,	25,	22,	26,	3},
{17,	30,	19,	24,	2},
{19,	39,	18,	25,	2},
{17,	39,	18,	26,	2},
{16,	24,	24,	27,	2},
{17,	26,	23,	24,	2},
{17,	25,	23,	26,	3},
{16,	28,	21,	25,	2},
{16,	26,	23,	26,	2},
{16,	25,	20,	24,	8},
{16,	24,	22,	28,	3},
{15,	28,	20,	26,	27},
{18,	24,	20,	27,	15},
{17,	39,	15,	27,	29},
{16,	39,	18,	24,	11},
{16,	24,	20,	28,	13},
{16,	30,	19,	26,	0},
{16,	24,	16,	28,	29},
{16,	24,	17,	29,	25},
{16,	25,	17,	28,	27},
{17,	27,	18,	27,	2},
{17,	39,	17,	28,	1},
{15,	24,	16,	28,	33},
{17,	23,	18,	24,	31},
{19,	20,	18,	26,	31},
{17,	23,	17,	24,	32},
{16,	39,	14,	26,	34},
{17,	23,	15,	20,	35},
{16,	24,	18,	21,	34},
{17,	23,	15,	21,	35},
{16,	22,	15,	21,	36},
{16,	20,	14,	28,	34},
{16,	20,	16,	21,	36},
{16,	25,	18,	20,	33},
{16,	20,	17,	24,	33},
{15,	17,	29,	10,	38},
{18,	19,	30,	4,	38},
{18,	10,	30,	10,	38},
{18,	18,	29,	8,	37},
{17,	19,	31,	1,	39},
{17,	15,	30,	8,	36},
{16,	17,	28,	11,	37},
{16,	19,	33,	1,	39},
{16,	22,	34,	0,	39},
{16,	21,	28,	8,	36},
{16,	8,	33,	9,	36},
{15,	28,	22,	7,	39},
{15,	19,	35,	16,	25},
{17,	20,	33,	16,	0},
{16,	20,	33,	15,	1},
{17,	21,	32,	15,	1},
{15,	31,	25,	2,	37},
{16,	27,	24,	2,	39},
{16,	32,	23,	3,	34},
{15,	24,	25,	19,	32},
{17,	19,	25,	18,	33},
{16,	17,	25,	18,	34},
{16,	21,	27,	19,	30},
{16,	17,	26,	17,	33},
{15,	6,	20,	28,	34},
{15,	11,	27,	20,	34},
{15,	9,	26,	25,	33},
{17,	4,	27,	23,	32},
{16,	4,	27,	22,	33},
{15,	2,	23,	17,	39},
{15,	26,	26,	9,	36},
{17,	27,	26,	4,	35},
{16,	27,	25,	7,	35},
{18,	29,	23,	8,	35},
{16,	29,	24,	7,	35},
{15,	27,	23,	13,	37},
{18,	26,	24,	11,	35},
{17,	29,	23,	10,	34},
{16,	28,	23,	6,	36},
{15,	39,	14,	19,	38},
{18,	39,	15,	19,	35},
{16,	25,	16,	19,	36},
{16,	24,	15,	21,	35},
{15,	29,	30,	2,	34},
{19,	29,	26,	2,	36},
{17,	26,	31,	3,	33},
{17,	31,	29,	2,	32},
{17,	29,	28,	3,	33},
{16,	30,	27,	2,	34},
{16,	30,	28,	3,	33},
{16,	30,	26,	2,	36},
{16,	28,	26,	2,	37},
{16,	27,	32,	2,	32},
{16,	27,	31,	3,	31},
{16,	27,	30,	5,	30},
{15,	29,	30,	4,	33},
{16,	30,	28,	4,	33},
{15,	28,	22,	16,	35},
{20,	29,	22,	16,	33},
{17,	26,	23,	15,	35},
{16,	27,	23,	15,	33},
{15,	2,	38,	23,	28},
{17,	2,	37,	24,	28},
{15,	23,	29,	19,	20},
{15,	21,	22,	31,	8},
{17,	7,	24,	32,	9},
{17,	24,	16,	32,	1},
{16,	9,	22,	34,	1},
{16,	8,	20,	34,	6},
{16,	24,	14,	31,	9},
{15,	25,	19,	29,	21},
{18,	24,	20,	29,	21},
{17,	39,	18,	28,	1},
{17,	39,	15,	32,	0},
{17,	25,	20,	27,	22},
{16,	26,	18,	27,	24},
{16,	25,	22,	27,	3},
{16,	25,	21,	28,	3},
{15,	31,	25,	7,	33},
{16,	29,	25,	9,	33},
{16,	31,	26,	3,	33},
{16,	32,	23,	5,	33},
{16,	29,	25,	5,	34},
{15,	4,	28,	28,	30},
{16,	3,	22,	30,	31},
{16,	18,	17,	30,	31},
{15,	20,	38,	7,	24},
{16,	21,	36,	7,	23},
{17,	21,	36,	4,	29},
{15,	31,	22,	7,	36},
{17,	31,	22,	9,	34},
{16,	31,	22,	8,	35},
{15,	5,	34,	17,	34},
{15,	8,	39,	28,	4},
{15,	39,	23,	10,	5},
{15,	39,	23,	16,	0},
{16,	32,	23,	13,	3},
{15,	19,	17,	19,	38},
{15,	21,	31,	16,	21},
{15,	27,	30,	10,	21},
{16,	27,	31,	8,	27},
{15,	1,	24,	33,	12},
{17,	10,	21,	33,	11},
{15,	27,	22,	13,	38},
{16,	28,	21,	8,	39},
{15,	21,	30,	11,	33},
{19,	15,	31,	10,	34},
{17,	19,	30,	12,	32},
{17,	24,	30,	9,	32},
{17,	17,	32,	10,	32},
{17,	21,	31,	11,	31},
{16,	13,	35,	9,	32},
{15,	4,	28,	23,	32},
{18,	9,	28,	21,	32},
{15,	15,	23,	28,	30},
{18,	12,	28,	26,	29},
{18,	16,	21,	27,	30},
{17,	9,	27,	28,	30},
{17,	18,	23,	25,	29},
{16,	12,	32,	26,	29},
{16,	12,	32,	28,	28},
{16,	19,	20,	27,	29},
{16,	11,	25,	26,	31},
{16,	7,	22,	30,	31},
{16,	11,	33,	28,	29},
{15,	9,	23,	35,	1},
{20,	5,	17,	35,	7},
{16,	9,	19,	35,	2},
{15,	9,	39,	29,	2},
{15,	33,	24,	6,	18},
{15,	19,	17,	25,	35},
{15,	7,	33,	29,	28},
{15,	30,	20,	17,	31},
{16,	39,	18,	19,	30},
{15,	28,	25,	23,	0},
{15,	28,	25,	18,	8},
{20,	28,	25,	20,	3},
{16,	28,	24,	17,	11},
{16,	28,	24,	20,	7},
{15,	29,	33,	2,	22},
{18,	27,	34,	2,	22},
{16,	28,	33,	3,	16},
{16,	27,	34,	3,	13},
{15,	5,	20,	32,	28},
{15,	6,	13,	36,	10},
{17,	17,	10,	36,	5},
{16,	15,	12,	36,	8},
{17,	9,	10,	36,	16},
{15,	17,	37,	12,	31},
{18,	21,	35,	8,	31},
{15,	0,	39,	27,	8},
{15,	31,	21,	8,	37},
{15,	2,	16,	35,	21},
{15,	23,	29,	7,	35},
{18,	21,	29,	6,	36},
{17,	24,	29,	6,	34},
{16,	23,	31,	4,	34},
{16,	20,	30,	4,	37},
{15,	26,	30,	3,	37},
{18,	24,	32,	1,	36},
{18,	27,	30,	1,	36},
{17,	26,	27,	4,	36},
{17,	24,	28,	3,	38},
{17,	21,	33,	3,	35},
{17,	21,	29,	4,	38},
{17,	21,	33,	1,	38},
{16,	26,	25,	9,	37},
{16,	26,	27,	3,	38},
{16,	23,	31,	3,	37},
{16,	26,	29,	1,	38},
{16,	27,	30,	1,	37},
{16,	27,	26,	2,	38},
{15,	35,	26,	0,	17},
{17,	35,	29,	0,	2},
{16,	39,	25,	1,	2},
{15,	8,	23,	30,	31},
{15,	17,	8,	38,	2},
{15,	17,	35,	7,	34},
{17,	11,	32,	11,	34},
{16,	19,	33,	6,	34},
{16,	21,	30,	8,	34},
{16,	20,	31,	6,	35},
{16,	13,	36,	6,	34},
{16,	13,	36,	5,	35},
{16,	10,	35,	9,	34},
{15,	20,	30,	6,	38},
{15,	29,	21,	8,	39},
{18,	31,	21,	1,	39},
{15,	30,	22,	4,	39},
{17,	31,	21,	4,	38},
{16,	29,	22,	6,	37},
{15,	39,	16,	23,	33},
{15,	21,	12,	21,	38},
{15,	5,	20,	35,	6},
{15,	1,	20,	35,	14},
{16,	5,	19,	35,	12},
{15,	4,	21,	21,	36},
{15,	26,	25,	8,	38},
{15,	1,	27,	33,	9},
{15,	27,	24,	23,	14},
{16,	27,	22,	23,	27},
{16,	27,	23,	23,	23},
{15,	2,	24,	32,	26},
{15,	17,	36,	19,	20},
{17,	16,	37,	19,	20},
{15,	39,	21,	3,	38},
{15,	28,	24,	17,	23},
{15,	18,	19,	33,	7},
{17,	18,	17,	35,	2},
{15,	33,	31,	0,	18},
{15,	10,	18,	33,	28},
{15,	30,	24,	3,	37},
{18,	27,	24,	4,	38},
{16,	27,	24,	4,	39},
{15,	26,	24,	8,	39},
{16,	23,	25,	8,	39},
{15,	27,	27,	10,	32},
{17,	29,	27,	7,	32},
{15,	29,	27,	7,	33},
{17,	26,	27,	6,	35},
{16,	27,	26,	7,	34},
{15,	39,	22,	5,	34},
{15,	0,	37,	4,	37},
{16,	0,	39,	4,	34},
{16,	8,	37,	3,	37},
{16,	13,	36,	4,	37},
{16,	5,	36,	5,	37},
{15,	29,	29,	10,	1},
{16,	29,	30,	8,	1},
{15,	23,	35,	12,	0},
{16,	21,	36,	12,	0},
{15,	15,	30,	29,	9},
{17,	15,	31,	30,	0},
{15,	16,	16,	29,	32},
{15,	14,	16,	30,	32},
{18,	8,	11,	30,	34},
{15,	24,	29,	16,	7},
{15,	23,	19,	28,	29},
{18,	23,	20,	26,	29},
{17,	23,	19,	25,	30},
{15,	28,	20,	25,	29},
{16,	25,	16,	26,	33},
{15,	23,	37,	4,	9},
{18,	26,	35,	4,	8},
{17,	22,	35,	3,	32},
{16,	22,	35,	5,	31},
{17,	23,	36,	5,	9},
{15,	22,	35,	8,	28},
{15,	21,	30,	16,	29},
{17,	18,	31,	16,	30},
{16,	21,	31,	15,	26},
{15,	18,	32,	19,	28},
{17,	19,	31,	19,	22},
{16,	18,	31,	18,	29},
{15,	39,	22,	4,	35},
{17,	32,	22,	5,	36},
{15,	23,	30,	7,	35},
{15,	18,	32,	3,	39},
{17,	19,	28,	4,	39},
{17,	20,	30,	3,	39},
{15,	14,	27,	30,	28},
{19,	15,	20,	30,	30},
{17,	20,	19,	30,	28},
{16,	16,	24,	30,	28},
{16,	13,	23,	29,	30},
{15,	28,	28,	10,	13},
{15,	27,	32,	8,	25},
{15,	27,	24,	7,	37},
{15,	26,	26,	10,	35},
{15,	24,	16,	25,	34},
{16,	21,	15,	25,	35},
{15,	2,	39,	25,	9},
{15,	11,	39,	23,	11},
{17,	10,	39,	28,	2},
{16,	13,	39,	22,	0},
{15,	10,	39,	25,	17},
{16,	6,	39,	27,	6},
{15,	26,	24,	20,	29},
{17,	25,	23,	18,	32},
{17,	27,	22,	19,	29},
{15,	29,	25,	13,	31},
{17,	27,	27,	12,	31},
{16,	30,	24,	13,	31},
{15,	33,	29,	0,	33},
{15,	26,	30,	4,	35},
{15,	1,	36,	20,	31},
{15,	10,	32,	13,	34},
{17,	11,	29,	14,	35},
{17,	19,	30,	12,	33},
{15,	14,	32,	13,	33},
{16,	15,	30,	15,	32},
{15,	11,	23,	18,	37},
{17,	8,	24,	18,	37},
{15,	14,	39,	26,	0},
{17,	11,	39,	26,	5},
{16,	11,	39,	25,	14},
{15,	29,	30,	5,	31},
{17,	28,	30,	6,	29},
{16,	29,	29,	6,	30},
{16,	28,	30,	7,	28},
{15,	18,	18,	26,	33},
{17,	11,	22,	26,	33},
{15,	17,	19,	28,	32},
{19,	16,	20,	26,	32},
{16,	12,	25,	26,	31},
{15,	23,	18,	24,	33},
{16,	21,	18,	26,	32},
{16,	22,	17,	28,	31},
{15,	25,	29,	13,	30},
{15,	23,	30,	11,	32},
{15,	2,	14,	35,	28},
{16,	2,	17,	35,	22},
{15,	0,	39,	26,	11},
{15,	15,	30,	9,	38},
{15,	22,	25,	17,	33},
{15,	6,	31,	15,	35},
{15,	21,	15,	19,	38},
{15,	22,	15,	21,	37},
{15,	39,	17,	18,	38},
{18,	22,	17,	19,	37},
{17,	21,	20,	19,	35},
{16,	27,	17,	20,	33},
{16,	22,	16,	19,	38},
{15,	29,	19,	17,	34},
{16,	39,	18,	17,	35},
{16,	28,	20,	17,	32},
{15,	27,	18,	17,	38},
{15,	27,	19,	17,	36},
{15,	23,	18,	19,	36},
{15,	33,	23,	5,	31},
{15,	23,	24,	17,	34},
{15,	28,	27,	1,	38},
{15,	18,	31,	19,	30},
{15,	30,	23,	8,	35},
{15,	31,	23,	6,	35},
{15,	21,	27,	15,	33},
{16,	18,	27,	16,	34},
{15,	23,	26,	15,	34},
{15,	21,	27,	11,	35},
{15,	19,	28,	15,	33},
{16,	23,	28,	13,	32},
{16,	25,	28,	13,	31},
{16,	20,	28,	19,	30},
{15,	20,	29,	7,	38},
{15,	30,	24,	10,	33},
{16,	27,	26,	11,	33},
{15,	23,	29,	16,	25},
{17,	23,	29,	18,	23},
{15,	31,	23,	9,	34},
{15,	7,	38,	13,	33},
{17,	8,	34,	13,	34},
{17,	8,	34,	18,	32},
{17,	9,	32,	16,	33},
{16,	13,	35,	10,	32},
{16,	7,	33,	10,	36},
{15,	7,	35,	14,	34},
{15,	26,	16,	27,	33},
{16,	39,	16,	25,	33},
{15,	9,	25,	19,	36},
{15,	26,	29,	16,	0},
{15,	20,	17,	30,	31},
{15,	11,	32,	17,	32},
{17,	14,	30,	17,	32},
{16,	10,	30,	16,	34},
{15,	28,	28,	2,	36},
{15,	25,	23,	19,	32},
{16,	25,	19,	19,	34},
{15,	5,	21,	31,	28},
{15,	7,	24,	32,	27},
{16,	8,	21,	32,	27},
{15,	16,	32,	26,	0},
{15,	39,	15,	22,	34},
{15,	25,	24,	26,	2},
{15,	25,	24,	25,	4},
{15,	26,	24,	24,	4},
{16,	27,	22,	26,	3},
{15,	29,	28,	10,	10},
{15,	1,	20,	33,	20},
{15,	18,	27,	7,	39},
{15,	34,	25,	2,	13},
{15,	28,	24,	9,	35},
{15,	24,	35,	8,	0},
{15,	18,	30,	23,	1},
{17,	20,	30,	22,	0},
{16,	18,	29,	22,	11},
{15,	39,	16,	27,	27},
{15,	18,	36,	13,	30},
{16,	19,	37,	6,	30},
{15,	30,	27,	7,	32},
{16,	31,	26,	5,	33},
{15,	29,	23,	5,	37},
{15,	26,	32,	6,	29},
{15,	31,	29,	2,	33},
{15,	19,	37,	11,	25},
{15,	1,	34,	19,	33},
{15,	24,	23,	30,	0},
{15,	39,	19,	22,	14},
{16,	39,	19,	25,	2},
{15,	20,	25,	28,	21},
{15,	21,	28,	11,	34},
{15,	20,	29,	10,	38},
{15,	21,	27,	11,	37},
{15,	21,	14,	23,	36},
{15,	15,	33,	23,	9},
{15,	15,	32,	10,	34},
{16,	18,	32,	10,	33},
{16,	21,	31,	11,	32},
{15,	17,	32,	13,	32},
{17,	17,	31,	13,	33},
{15,	33,	25,	2,	25},
{15,	6,	6,	31,	34},
{15,	25,	21,	29,	1},
{15,	25,	23,	30,	0},
{15,	14,	32,	24,	29},
{15,	13,	36,	19,	30},
{15,	26,	27,	11,	33},
{15,	26,	24,	11,	36},
{15,	21,	31,	13,	30},
{15,	20,	31,	12,	32},
{15,	23,	31,	5,	35},
{15,	16,	28,	6,	39},
{15,	20,	17,	33,	7},
{15,	29,	38,	0,	10},
{15,	25,	39,	0,	24},
{15,	16,	23,	32,	0},
{15,	18,	20,	32,	7},
{15,	11,	33,	29,	28},
{15,	24,	26,	15,	33},
{15,	21,	34,	10,	30},
{15,	39,	14,	31,	9},
{15,	26,	36,	0,	31},
{16,	25,	36,	0,	35},
{17,	19,	35,	1,	38},
{15,	23,	36,	3,	29},
{15,	12,	27,	21,	32},
{15,	26,	26,	11,	35},
{15,	20,	30,	16,	30},
{15,	31,	22,	4,	37},
{15,	24,	27,	5,	37},
{15,	25,	25,	4,	39},
{15,	18,	11,	28,	35},
{15,	8,	22,	28,	32},
{15,	12,	11,	30,	33},
{15,	12,	9,	29,	34},
{15,	15,	6,	31,	34},
{15,	28,	18,	27,	9},
{15,	39,	17,	28,	26},
{17,	39,	15,	30,	11},
{17,	24,	18,	30,	13},
{17,	24,	16,	30,	27},
{16,	27,	18,	28,	18},
{16,	23,	19,	30,	26},
{15,	27,	18,	27,	27},
{15,	26,	16,	28,	31},
{15,	22,	21,	31,	1},
{15,	22,	23,	31,	0},
{15,	15,	22,	32,	3},
{15,	9,	23,	32,	25},
{16,	8,	24,	32,	26},
{16,	11,	24,	31,	9},
{17,	10,	24,	31,	21},
{16,	13,	23,	31,	13},
{15,	33,	29,	2,	0},
{15,	17,	15,	34,	28},
{15,	19,	27,	13,	35},
{15,	20,	31,	3,	39},
{15,	23,	31,	3,	38},
{15,	17,	22,	17,	36},
{15,	32,	27,	1,	30},
{15,	16,	30,	29,	0},
{15,	17,	11,	36,	11},
{15,	3,	11,	36,	26},
{15,	1,	12,	36,	26},
{15,	14,	24,	31,	5},
{15,	31,	35,	0,	6},
{15,	39,	13,	31,	17},
{15,	23,	22,	19,	33},
{15,	23,	21,	19,	34},
{15,	18,	26,	12,	39},
{15,	27,	31,	1,	35},
{15,	31,	25,	3,	34},
{15,	20,	33,	4,	36},
{15,	15,	34,	21,	22},
{15,	12,	28,	12,	38},
{16,	18,	28,	11,	38},
{15,	13,	27,	13,	38},
{15,	16,	27,	13,	37},
{15,	12,	15,	21,	38},
{15,	20,	13,	35,	14},
{16,	19,	16,	35,	10},
{15,	7,	15,	36,	10},
{15,	22,	39,	1,	14},
{15,	21,	37,	4,	26},
{15,	23,	37,	3,	23},
{17,	22,	39,	2,	20},
{15,	20,	29,	22,	2},
{15,	22,	29,	21,	23},
{17,	23,	29,	21,	7},
{16,	18,	29,	22,	23},
{15,	21,	29,	21,	26},
{16,	17,	29,	21,	29},
{15,	24,	34,	9,	1},
{15,	13,	12,	38,	1},
{15,	35,	26,	1,	2},
{15,	35,	27,	1,	1},
{15,	30,	19,	17,	32},
{15,	26,	16,	19,	36},
{15,	27,	30,	3,	34},
{15,	29,	27,	5,	34},
{15,	28,	30,	4,	34},
{17,	28,	28,	3,	35},
{15,	28,	24,	5,	36},
{15,	15,	19,	24,	33},
{17,	15,	22,	20,	34},
{16,	17,	19,	21,	34},
{15,	14,	20,	26,	33},
{15,	15,	30,	10,	36},
{15,	13,	30,	10,	38},
{15,	11,	35,	5,	38},
{15,	28,	33,	1,	26},
{15,	9,	21,	21,	35},
{15,	10,	39,	30,	0},
{15,	30,	34,	0,	15},
{15,	26,	24,	26,	1},
{15,	21,	34,	14,	0},
{15,	12,	21,	34,	1},
{15,	18,	37,	12,	30},
{15,	27,	28,	4,	35},
{14,	18,	36,	34,	25},
{23,	7,	21,	34,	26},
{21,	17,	33,	24,	26},
{18,	17,	19,	33,	27},
{18,	7,	20,	35,	14},
{18,	12,	19,	33,	28},
{18,	19,	30,	20,	19},
{17,	21,	23,	31,	6},
{17,	17,	28,	25,	27},
{17,	16,	26,	28,	28},
{17,	19,	29,	23,	7},
{16,	3,	37,	31,	15},
{18,	3,	37,	32,	1},
{16,	19,	21,	33,	14},
{18,	19,	22,	34,	2},
{19,	22,	19,	35,	0},
{17,	20,	19,	34,	4},
{17,	19,	24,	34,	1},
{16,	18,	31,	28,	26},
{17,	18,	26,	25,	28},
{16,	3,	37,	32,	4},
{16,	8,	24,	33,	26},
{16,	18,	17,	34,	27},
{16,	14,	24,	31,	26},
{16,	21,	22,	33,	0},
{16,	15,	37,	24,	0},
{17,	18,	37,	20,	0},
{16,	16,	37,	21,	25},
{16,	16,	32,	23,	27},
{16,	22,	13,	31,	27},
{16,	16,	37,	23,	1},
{16,	23,	19,	32,	1},
{15,	19,	31,	23,	26},
{15,	4,	38,	34,	0},
{18,	3,	39,	33,	0},
{15,	0,	39,	32,	1},
{15,	7,	26,	35,	1},
{16,	1,	25,	35,	2},
{15,	20,	21,	31,	25},
{16,	20,	17,	31,	28},
{17,	18,	16,	32,	30},
{15,	7,	18,	35,	23},
{18,	18,	14,	35,	21},
{15,	19,	26,	34,	1},
{15,	19,	26,	30,	24},
{18,	20,	26,	28,	22},
{15,	26,	20,	31,	0},
{15,	22,	16,	31,	28},
{15,	26,	22,	30,	0},
{15,	19,	16,	34,	25},
{15,	7,	23,	34,	26},
{15,	19,	24,	33,	6},
{16,	20,	25,	31,	4},
{16,	20,	26,	32,	0},
{15,	18,	26,	26,	28},
{15,	17,	24,	29,	28},
{16,	17,	24,	32,	26},
{15,	21,	18,	31,	24},
{15,	17,	34,	24,	26},
{15,	19,	31,	19,	27},
{14,	26,	34,	19,	29},
{19,	19,	32,	20,	13},
{18,	25,	30,	13,	30},
{18,	19,	33,	21,	2},
{17,	26,	34,	3,	31},
{16,	27,	33,	7,	22},
{17,	27,	34,	7,	2},
{17,	27,	34,	4,	13},
{16,	28,	30,	7,	29},
{16,	18,	35,	18,	28},
{16,	24,	29,	21,	0},
{16,	26,	35,	6,	0},
{15,	20,	35,	14,	24},
{17,	20,	35,	16,	10},
{16,	21,	35,	14,	2},
{15,	27,	30,	13,	14},
{17,	27,	30,	14,	1},
{15,	21,	35,	13,	18},
{15,	27,	30,	11,	28},
{15,	24,	34,	7,	31},
{15,	27,	29,	15,	10},
{16,	27,	29,	14,	17},
{15,	20,	31,	19,	30},
{15,	18,	34,	17,	30},
{16,	17,	35,	15,	31},
{15,	26,	34,	5,	30},
{17,	26,	32,	4,	32},
{16,	26,	33,	5,	31},
{15,	21,	36,	11,	1},
{15,	23,	29,	20,	23},
{15,	22,	27,	18,	30},
{15,	25,	33,	7,	30},
{15,	16,	35,	19,	30},
{15,	26,	29,	11,	30},
{15,	25,	29,	21,	0},
{14,	8,	30,	19,	39},
{20,	39,	7,	19,	39},
{18,	15,	12,	19,	39},
{19,	12,	18,	18,	39},
{19,	10,	22,	19,	38},
{18,	11,	23,	17,	39},
{17,	12,	30,	12,	37},
{17,	17,	14,	18,	39},
{17,	11,	28,	11,	39},
{16,	11,	22,	18,	39},
{16,	9,	28,	15,	38},
{16,	7,	31,	13,	37},
{15,	5,	31,	14,	39},
{16,	5,	32,	8,	39},
{15,	16,	20,	18,	39},
{16,	21,	18,	18,	38},
{16,	21,	18,	19,	37},
{15,	9,	30,	18,	36},
{16,	10,	29,	18,	35},
{15,	12,	30,	17,	33},
{16,	11,	29,	18,	35},
{15,	39,	8,	19,	39},
{14,	16,	21,	26,	38},
{22,	17,	14,	26,	38},
{20,	16,	22,	19,	37},
{19,	20,	10,	24,	38},
{17,	1,	18,	28,	35},
{17,	18,	15,	28,	35},
{17,	17,	17,	21,	38},
{17,	20,	14,	28,	35},
{16,	19,	18,	25,	34},
{15,	4,	22,	23,	35},
{15,	4,	22,	22,	37},
{15,	23,	18,	24,	34},
{15,	19,	17,	22,	36},
{15,	20,	17,	21,	37},
{15,	17,	22,	19,	36},
{15,	20,	22,	19,	35},
{15,	20,	17,	24,	35},
{15,	22,	14,	26,	35},
{15,	17,	16,	28,	35},
{15,	20,	18,	19,	38},
{15,	15,	24,	18,	36},
{14,	12,	35,	30,	32},
{20,	16,	34,	19,	31},
{18,	13,	31,	21,	32},
{18,	13,	29,	24,	31},
{16,	10,	29,	19,	35},
{16,	15,	22,	27,	31},
{16,	9,	36,	16,	32},
{16,	13,	22,	24,	34},
{15,	15,	24,	22,	33},
{16,	14,	27,	21,	32},
{16,	14,	31,	21,	31},
{15,	13,	35,	18,	32},
{15,	13,	27,	19,	34},
{15,	14,	33,	26,	28},
{15,	13,	36,	25,	28},
{15,	10,	26,	25,	33},
{16,	12,	24,	26,	33},
{15,	14,	27,	23,	31},
{15,	14,	24,	22,	34},
{15,	15,	22,	30,	30},
{15,	15,	32,	16,	32},
{15,	13,	36,	11,	32},
{15,	9,	33,	16,	33},
{16,	9,	35,	11,	34},
{15,	9,	36,	13,	34},
{15,	4,	36,	7,	37},
{14,	30,	31,	13,	28},
{17,	29,	32,	4,	27},
{16,	30,	31,	2,	30},
{15,	27,	32,	13,	24},
{15,	27,	34,	11,	1},
{16,	27,	33,	9,	5},
{15,	30,	30,	5,	30},
{16,	30,	29,	4,	33},
{15,	30,	31,	3,	30},
{14,	39,	15,	30,	36},
{17,	21,	13,	26,	37},
{17,	10,	16,	27,	36},
{17,	39,	14,	20,	37},
{16,	26,	17,	29,	25},
{16,	26,	16,	30,	24},
{16,	26,	16,	29,	31},
{16,	19,	18,	26,	34},
{16,	20,	16,	24,	36},
{16,	24,	14,	21,	37},
{15,	18,	14,	31,	32},
{15,	11,	13,	31,	33},
{16,	14,	7,	31,	34},
{15,	24,	16,	28,	34},
{15,	19,	14,	26,	37},
{15,	19,	17,	29,	32},
{14,	31,	27,	18,	24},
{19,	27,	27,	19,	4},
{18,	31,	26,	16,	25},
{17,	30,	22,	17,	28},
{20,	30,	24,	17,	25},
{17,	27,	26,	17,	27},
{17,	30,	22,	18,	27},
{16,	31,	27,	10,	29},
{16,	39,	19,	17,	32},
{16,	31,	25,	16,	26},
{15,	28,	26,	23,	0},
{15,	28,	22,	18,	30},
{15,	28,	27,	20,	0},
{15,	27,	26,	21,	4},
{15,	27,	27,	21,	1},
{15,	39,	19,	23,	21},
{15,	29,	21,	18,	30},
{14,	12,	14,	38,	29},
{17,	18,	14,	35,	29},
{17,	11,	15,	36,	12},
{16,	14,	12,	36,	28},
{15,	7,	15,	36,	23},
{15,	13,	15,	38,	2},
{14,	16,	39,	23,	30},
{19,	8,	39,	25,	18},
{18,	16,	31,	23,	31},
{18,	3,	36,	24,	30},
{17,	17,	34,	23,	29},
{17,	2,	39,	10,	31},
{17,	12,	39,	25,	11},
{16,	13,	37,	25,	28},
{16,	18,	37,	15,	29},
{17,	17,	38,	18,	28},
{16,	17,	35,	23,	28},
{16,	17,	36,	24,	27},
{16,	15,	32,	24,	30},
{16,	15,	32,	28,	27},
{17,	15,	28,	29,	28},
{16,	17,	38,	20,	1},
{16,	16,	24,	22,	33},
{16,	18,	38,	11,	29},
{16,	19,	38,	7,	30},
{16,	18,	36,	16,	30},
{15,	18,	23,	22,	33},
{17,	19,	24,	20,	31},
{16,	21,	24,	20,	30},
{15,	14,	37,	24,	30},
{15,	15,	38,	24,	29},
{15,	15,	37,	29,	25},
{18,	15,	38,	26,	15},
{16,	17,	37,	26,	1},
{17,	16,	37,	27,	4},
{17,	17,	38,	24,	0},
{16,	18,	37,	25,	0},
{15,	10,	37,	26,	29},
{15,	18,	22,	23,	33},
{16,	16,	22,	25,	33},
{15,	16,	38,	7,	32},
{16,	12,	38,	10,	32},
{15,	17,	36,	13,	32},
{16,	18,	33,	9,	33},
{17,	22,	33,	8,	32},
{15,	21,	22,	23,	30},
{15,	21,	22,	22,	31},
{15,	18,	39,	7,	28},
{15,	15,	38,	10,	32},
{15,	16,	22,	24,	34},
{15,	13,	34,	21,	32},
{15,	19,	33,	7,	34},
{15,	15,	38,	28,	1},
{15,	16,	36,	6,	34},
{14,	26,	28,	26,	22},
{20,	19,	31,	26,	1},
{20,	19,	29,	24,	26},
{19,	24,	21,	29,	13},
{19,	19,	27,	30,	3},
{17,	26,	24,	24,	25},
{20,	25,	23,	26,	25},
{16,	28,	21,	24,	18},
{19,	27,	22,	25,	12},
{15,	21,	27,	28,	5},
{17,	20,	27,	28,	14},
{15,	19,	28,	28,	22},
{17,	19,	28,	30,	3},
{15,	19,	30,	25,	16},
{16,	19,	30,	28,	9},
{15,	20,	28,	24,	26},
{15,	21,	28,	28,	0},
{15,	19,	27,	30,	8},
{14,	10,	13,	34,	34},
{19,	18,	14,	32,	32},
{16,	39,	9,	32,	33},
{15,	11,	14,	31,	34},
{15,	12,	13,	32,	34},
{15,	13,	14,	32,	33},
{14,	3,	34,	16,	38},
{19,	7,	32,	11,	38},
{16,	5,	32,	10,	39},
{16,	5,	35,	10,	36},
{17,	5,	35,	9,	37},
{15,	3,	35,	16,	36},
{15,	3,	31,	15,	39},
{15,	8,	31,	13,	38},
{15,	8,	33,	10,	38},
{15,	8,	31,	11,	39},
{14,	39,	21,	21,	31},
{19,	28,	22,	18,	31},
{19,	31,	20,	23,	1},
{18,	39,	17,	20,	33},
{18,	32,	23,	14,	3},
{17,	26,	22,	19,	32},
{17,	32,	22,	15,	6},
{17,	39,	21,	12,	32},
{16,	31,	23,	16,	29},
{16,	39,	18,	18,	34},
{16,	27,	18,	21,	33},
{16,	31,	23,	13,	30},
{15,	39,	23,	17,	0},
{15,	28,	18,	25,	31},
{17,	27,	21,	23,	30},
{16,	26,	21,	22,	31},
{15,	32,	22,	15,	24},
{15,	31,	22,	21,	1},
{15,	31,	22,	23,	0},
{15,	31,	22,	20,	2},
{15,	39,	17,	22,	32},
{15,	39,	19,	18,	32},
{16,	29,	19,	18,	34},
{15,	27,	21,	19,	32},
{15,	39,	21,	13,	32},
{16,	31,	21,	13,	33},
{15,	31,	24,	12,	30},
{15,	32,	23,	18,	0},
{15,	32,	22,	19,	3},
{15,	39,	22,	19,	0},
{14,	5,	34,	23,	34},
{20,	8,	26,	24,	34},
{17,	11,	31,	20,	33},
{17,	6,	32,	21,	34},
{17,	8,	33,	20,	33},
{16,	5,	35,	22,	33},
{15,	9,	33,	20,	33},
{15,	8,	27,	23,	34},
{17,	11,	31,	21,	33},
{15,	9,	34,	21,	33},
{15,	11,	27,	22,	34},
{16,	10,	30,	21,	34},
{14,	5,	37,	18,	35},
{18,	8,	34,	13,	35},
{17,	4,	37,	7,	36},
{16,	5,	37,	10,	36},
{16,	4,	34,	16,	36},
{15,	8,	34,	12,	37},
{16,	8,	35,	12,	36},
{15,	8,	34,	13,	36},
{15,	14,	37,	4,	35},
{14,	26,	22,	28,	31},
{19,	18,	21,	28,	32},
{18,	22,	23,	27,	27},
{18,	23,	24,	27,	26},
{18,	23,	24,	20,	31},
{18,	24,	24,	27,	11},
{17,	26,	23,	26,	26},
{17,	19,	22,	29,	28},
{16,	20,	18,	29,	31},
{16,	23,	23,	21,	31},
{16,	39,	17,	28,	28},
{16,	18,	23,	26,	30},
{15,	23,	24,	30,	26},
{16,	20,	21,	30,	28},
{15,	23,	24,	28,	27},
{15,	25,	21,	29,	16},
{15,	18,	22,	25,	33},
{16,	18,	19,	26,	34},
{15,	25,	23,	27,	14},
{15,	16,	22,	26,	34},
{15,	23,	18,	29,	29},
{16,	23,	20,	30,	27},
{17,	22,	21,	30,	28},
{15,	27,	18,	27,	30},
{16,	39,	16,	27,	33},
{15,	20,	24,	22,	30},
{15,	25,	20,	29,	23},
{15,	18,	22,	28,	32},
{15,	20,	24,	29,	27},
{14,	33,	27,	6,	24},
{20,	33,	27,	4,	25},
{17,	32,	27,	4,	30},
{17,	33,	24,	4,	29},
{15,	32,	27,	10,	6},
{16,	32,	27,	7,	15},
{15,	32,	31,	2,	28},
{15,	34,	26,	1,	10},
{14,	31,	30,	10,	22},
{18,	31,	30,	4,	25},
{15,	31,	30,	3,	28},
{14,	23,	31,	21,	30},
{18,	19,	30,	24,	27},
{17,	24,	25,	21,	30},
{17,	24,	25,	20,	31},
{16,	23,	32,	16,	30},
{17,	21,	34,	14,	30},
{16,	23,	28,	15,	32},
{16,	24,	33,	12,	30},
{16,	17,	31,	23,	30},
{16,	17,	26,	23,	31},
{15,	17,	29,	22,	31},
{15,	22,	24,	23,	30},
{17,	22,	23,	24,	30},
{16,	19,	27,	23,	30},
{15,	18,	25,	26,	30},
{15,	25,	27,	21,	29},
{15,	25,	32,	13,	30},
{15,	18,	27,	22,	31},
{18,	22,	26,	18,	31},
{15,	21,	25,	23,	30},
{15,	15,	24,	30,	29},
{15,	18,	24,	28,	30},
{15,	18,	29,	23,	29},
{15,	22,	31,	11,	32},
{15,	13,	35,	26,	29},
{15,	20,	24,	27,	28},
{16,	20,	25,	24,	30},
{15,	19,	26,	26,	28},
{15,	24,	26,	19,	30},
{14,	7,	21,	36,	23},
{18,	7,	23,	35,	3},
{17,	2,	16,	38,	2},
{15,	7,	23,	35,	23},
{16,	2,	25,	35,	6},
{15,	2,	22,	37,	0},
{16,	10,	17,	37,	1},
{15,	16,	22,	35,	2},
{15,	8,	23,	35,	19},
{18,	17,	19,	35,	5},
{16,	8,	18,	36,	22},
{16,	10,	19,	36,	5},
{15,	10,	24,	35,	4},
{15,	13,	16,	38,	2},
{14,	32,	29,	7,	29},
{18,	31,	30,	5,	28},
{16,	31,	29,	5,	31},
{16,	32,	27,	7,	30},
{15,	29,	30,	7,	30},
{15,	32,	30,	3,	25},
{15,	31,	30,	5,	30},
{15,	33,	28,	5,	0},
{15,	26,	30,	6,	31},
{14,	6,	39,	30,	15},
{17,	11,	39,	26,	14},
{17,	9,	39,	27,	15},
{15,	8,	39,	26,	18},
{14,	39,	18,	18,	39},
{15,	39,	12,	19,	39},
{14,	39,	23,	10,	30},
{18,	39,	22,	11,	30},
{15,	39,	22,	13,	30},
{15,	32,	23,	12,	29},
{15,	39,	23,	4,	31},
{14,	9,	25,	26,	35},
{16,	11,	22,	20,	37},
{14,	16,	37,	32,	25},
{17,	14,	37,	33,	0},
{15,	14,	37,	34,	0},
{14,	19,	39,	16,	26},
{18,	19,	37,	14,	29},
{16,	17,	39,	17,	25},
{16,	17,	39,	20,	1},
{15,	19,	39,	10,	28},
{15,	17,	39,	24,	0},
{15,	19,	37,	16,	28},
{14,	23,	28,	13,	38},
{18,	23,	29,	11,	33},
{18,	22,	29,	6,	37},
{16,	21,	29,	10,	37},
{16,	26,	27,	6,	36},
{15,	22,	29,	10,	38},
{15,	23,	30,	11,	33},
{14,	20,	31,	18,	33},
{18,	23,	29,	15,	32},
{17,	21,	27,	18,	32},
{17,	15,	32,	16,	33},
{17,	14,	31,	19,	33},
{18,	16,	28,	21,	32},
{17,	22,	31,	14,	31},
{16,	21,	32,	15,	31},
{16,	17,	32,	20,	31},
{16,	20,	33,	13,	31},
{16,	20,	32,	13,	32},
{16,	23,	29,	13,	33},
{15,	22,	30,	17,	31},
{15,	15,	28,	18,	34},
{15,	16,	28,	22,	32},
{15,	13,	35,	22,	32},
{15,	16,	27,	18,	34},
{15,	20,	34,	9,	32},
{15,	18,	32,	19,	31},
{14,	22,	39,	7,	28},
{19,	23,	37,	5,	15},
{17,	22,	39,	8,	0},
{16,	23,	39,	2,	28},
{16,	21,	37,	5,	30},
{16,	23,	35,	4,	31},
{16,	20,	38,	7,	30},
{15,	23,	39,	3,	28},
{16,	23,	38,	5,	12},
{15,	21,	37,	1,	34},
{17,	21,	35,	1,	38},
{16,	21,	38,	1,	35},
{15,	22,	36,	12,	0},
{14,	10,	24,	32,	31},
{15,	9,	19,	33,	30},
{17,	2,	17,	33,	31},
{17,	10,	15,	34,	30},
{15,	5,	20,	33,	29},
{15,	5,	24,	33,	27},
{15,	5,	22,	33,	29},
{15,	18,	15,	34,	30},
{15,	12,	19,	32,	31},
{14,	29,	27,	7,	36},
{18,	27,	25,	4,	38},
{17,	26,	27,	8,	35},
{17,	30,	26,	3,	36},
{15,	28,	28,	4,	36},
{15,	24,	30,	7,	34},
{15,	29,	28,	4,	35},
{15,	25,	28,	4,	37},
{14,	5,	37,	23,	33},
{19,	6,	36,	24,	31},
{15,	6,	38,	23,	31},
{14,	9,	13,	39,	8},
{14,	19,	32,	30,	20},
{18,	19,	32,	23,	25},
{15,	19,	29,	33,	6},
{17,	19,	30,	32,	4},
{14,	19,	36,	21,	27},
{16,	19,	36,	24,	0},
{16,	18,	35,	23,	27},
{15,	18,	33,	23,	28},
{15,	18,	32,	20,	31},
{14,	20,	37,	20,	27},
{18,	20,	32,	21,	20},
{18,	21,	38,	11,	0},
{17,	19,	37,	21,	4},
{15,	18,	37,	25,	4},
{15,	22,	32,	21,	1},
{15,	21,	34,	21,	0},
{15,	20,	37,	10,	29},
{15,	17,	37,	21,	20},
{15,	17,	37,	24,	8},
{15,	20,	39,	8,	9},
{14,	22,	35,	19,	28},
{18,	22,	36,	15,	0},
{16,	21,	35,	21,	0},
{15,	21,	36,	21,	0},
{14,	23,	36,	13,	23},
{19,	23,	37,	6,	16},
{19,	22,	36,	11,	27},
{16,	23,	35,	7,	28},
{15,	21,	36,	16,	2},
{15,	23,	35,	13,	25},
{15,	21,	37,	10,	3},
{15,	23,	38,	6,	2},
{14,	26,	36,	7,	18},
{18,	26,	36,	2,	24},
{17,	24,	36,	5,	23},
{18,	25,	35,	6,	22},
{15,	24,	37,	3,	17},
{17,	25,	39,	1,	12},
{15,	24,	35,	3,	31},
{16,	25,	36,	3,	26},
{15,	25,	39,	1,	25},
{15,	25,	35,	7,	22},
{15,	25,	37,	3,	8},
{14,	23,	29,	26,	20},
{17,	20,	30,	22,	20},
{16,	20,	30,	23,	6},
{15,	20,	32,	23,	1},
{15,	20,	30,	28,	0},
{17,	20,	32,	25,	0},
{16,	20,	30,	24,	14},
{14,	15,	34,	13,	36},
{20,	11,	35,	8,	38},
{19,	12,	32,	11,	37},
{19,	15,	29,	18,	34},
{18,	12,	32,	10,	38},
{17,	19,	29,	11,	37},
{17,	16,	32,	7,	36},
{16,	19,	29,	13,	35},
{17,	16,	29,	13,	37},
{17,	15,	30,	13,	37},
{16,	11,	35,	11,	36},
{15,	12,	29,	17,	36},
{16,	11,	29,	16,	37},
{15,	11,	34,	19,	33},
{15,	9,	32,	10,	39},
{15,	10,	29,	19,	36},
{15,	13,	28,	16,	36},
{15,	11,	33,	10,	38},
{14,	28,	28,	18,	21},
{16,	27,	29,	16,	6},
{14,	10,	34,	10,	39},
{17,	4,	35,	5,	39},
{17,	14,	31,	5,	39},
{16,	20,	29,	4,	39},
{16,	11,	35,	4,	39},
{15,	4,	36,	2,	39},
{14,	13,	37,	35,	0},
{14,	32,	22,	30,	0},
{17,	30,	22,	24,	1},
{16,	39,	20,	24,	2},
{15,	32,	21,	23,	3},
{15,	31,	21,	25,	1},
{15,	29,	21,	26,	2},
{14,	39,	21,	7,	38},
{14,	8,	31,	36,	0},
{15,	1,	26,	37,	0},
{14,	26,	18,	19,	39},
{15,	39,	15,	21,	38},
{15,	19,	17,	21,	38},
{14,	26,	20,	19,	37},
{18,	17,	22,	19,	37},
{17,	27,	19,	18,	37},
{16,	28,	20,	17,	34},
{16,	17,	20,	18,	39},
{16,	22,	21,	19,	35},
{15,	27,	21,	17,	34},
{15,	26,	22,	18,	33},
{15,	29,	20,	17,	34},
{15,	39,	20,	17,	32},
{14,	7,	25,	20,	37},
{14,	32,	23,	10,	34},
{17,	32,	21,	12,	33},
{15,	32,	25,	7,	31},
{16,	32,	24,	6,	32},
{17,	32,	24,	4,	33},
{16,	32,	25,	2,	33},
{14,	28,	25,	7,	38},
{16,	28,	24,	4,	39},
{15,	29,	24,	5,	37},
{14,	34,	24,	6,	16},
{17,	39,	24,	5,	0},
{17,	39,	25,	2,	2},
{15,	35,	27,	2,	1},
{15,	34,	25,	3,	3},
{14,	39,	23,	4,	35},
{16,	33,	23,	5,	34},
{14,	1,	23,	25,	36},
{14,	29,	26,	16,	31},
{17,	30,	26,	14,	31},
{17,	30,	25,	16,	30},
{16,	25,	25,	17,	31},
{15,	25,	25,	15,	33},
{15,	25,	27,	16,	32},
{14,	29,	25,	19,	24},
{15,	31,	23,	20,	1},
{16,	31,	24,	19,	1},
{15,	31,	22,	19,	9},
{15,	29,	22,	19,	27},
{16,	28,	22,	19,	31},
{15,	30,	24,	19,	4},
{14,	30,	32,	8,	9},
{17,	28,	32,	10,	5},
{17,	30,	32,	2,	27},
{15,	29,	32,	8,	16},
{14,	11,	37,	31,	26},
{19,	3,	25,	31,	28},
{17,	15,	30,	31,	26},
{16,	15,	25,	32,	26},
{15,	9,	25,	33,	26},
{14,	21,	29,	28,	19},
{16,	20,	30,	28,	2},
{16,	21,	26,	28,	22},
{14,	24,	28,	13,	37},
{15,	26,	27,	6,	37},
{15,	24,	27,	6,	38},
{14,	3,	27,	35,	9},
{16,	8,	24,	35,	10},
{14,	14,	37,	33,	12},
{16,	1,	39,	33,	1},
{14,	3,	37,	10,	37},
{14,	34,	33,	0,	19},
{18,	34,	28,	0,	29},
{17,	32,	33,	0,	25},
{16,	33,	35,	0,	9},
{16,	35,	30,	0,	5},
{15,	31,	33,	0,	30},
{15,	29,	33,	2,	26},
{15,	27,	33,	2,	31},
{15,	31,	34,	0,	19},
{14,	27,	33,	13,	25},
{15,	27,	34,	12,	1},
{14,	29,	34,	4,	24},
{15,	29,	35,	1,	3},
{14,	11,	27,	32,	28},
{15,	16,	22,	33,	27},
{15,	12,	22,	32,	31},
{16,	13,	27,	32,	28},
{15,	17,	24,	31,	28},
{14,	23,	20,	18,	39},
{16,	21,	20,	19,	38},
{14,	22,	24,	23,	32},
{17,	19,	24,	22,	33},
{17,	22,	20,	21,	33},
{17,	21,	25,	23,	31},
{16,	22,	19,	26,	32},
{16,	23,	17,	26,	34},
{15,	17,	28,	22,	32},
{15,	23,	21,	22,	32},
{15,	27,	19,	22,	32},
{15,	24,	21,	22,	32},
{15,	23,	20,	21,	33},
{14,	33,	25,	1,	37},
{17,	32,	25,	2,	36},
{15,	32,	27,	0,	37},
{15,	32,	24,	2,	37},
{15,	32,	22,	4,	38},
{15,	33,	28,	0,	35},
{14,	6,	37,	26,	31},
{14,	29,	28,	16,	23},
{15,	27,	29,	14,	25},
{14,	2,	23,	32,	32},
{17,	0,	15,	31,	34},
{16,	2,	16,	33,	32},
{15,	7,	23,	31,	32},
{14,	22,	14,	35,	28},
{18,	39,	12,	33,	30},
{16,	39,	14,	32,	22},
{17,	39,	13,	33,	29},
{15,	23,	19,	31,	23},
{17,	21,	21,	31,	24},
{16,	23,	17,	32,	11},
{16,	22,	15,	33,	21},
{15,	22,	21,	31,	9},
{15,	22,	19,	32,	6},
{15,	22,	18,	32,	16},
{15,	22,	18,	34,	1},
{15,	22,	19,	33,	5},
{14,	8,	30,	24,	33},
{14,	31,	28,	13,	22},
{15,	31,	28,	12,	23},
{14,	12,	9,	36,	30},
{14,	6,	31,	18,	36},
{14,	11,	38,	24,	31},
{18,	9,	36,	23,	32},
{18,	9,	38,	18,	32},
{16,	11,	36,	23,	32},
{16,	7,	38,	18,	33},
{15,	10,	37,	23,	32},
{15,	16,	37,	12,	32},
{16,	12,	37,	17,	32},
{15,	17,	36,	16,	31},
{15,	15,	38,	14,	31},
{14,	28,	23,	12,	37},
{16,	30,	21,	9,	38},
{15,	28,	23,	8,	38},
{14,	17,	28,	18,	35},
{15,	13,	28,	17,	36},
{14,	34,	25,	6,	14},
{14,	19,	21,	18,	39},
{16,	17,	22,	17,	38},
{14,	25,	23,	16,	38},
{15,	24,	22,	17,	36},
{18,	21,	22,	18,	36},
{15,	26,	21,	16,	38},
{15,	15,	23,	16,	39},
{14,	20,	25,	16,	38},
{16,	19,	27,	16,	35},
{17,	20,	27,	15,	35},
{17,	22,	27,	16,	34},
{16,	13,	27,	16,	37},
{15,	12,	24,	16,	39},
{14,	4,	39,	27,	20},
{14,	22,	37,	7,	32},
{17,	22,	39,	1,	34},
{17,	25,	39,	0,	35},
{16,	19,	36,	5,	34},
{15,	24,	39,	1,	31},
{15,	18,	35,	7,	34},
{15,	20,	37,	3,	34},
{14,	7,	24,	21,	37},
{15,	10,	22,	23,	36},
{16,	10,	23,	22,	36},
{15,	11,	23,	20,	37},
{14,	33,	24,	10,	13},
{17,	33,	25,	10,	0},
{14,	33,	24,	8,	30},
{14,	28,	33,	6,	25},
{17,	28,	33,	10,	0},
{16,	29,	33,	5,	9},
{15,	28,	33,	11,	0},
{15,	28,	32,	13,	0},
{14,	20,	38,	16,	16},
{18,	20,	39,	9,	27},
{15,	21,	38,	13,	0},
{14,	32,	23,	26,	0},
{15,	30,	23,	28,	0},
{15,	26,	23,	27,	9},
{14,	18,	31,	8,	38},
{17,	19,	31,	4,	39},
{16,	16,	32,	8,	37},
{16,	14,	32,	10,	38},
{16,	19,	31,	8,	36},
{16,	16,	31,	13,	34},
{16,	20,	32,	8,	34},
{15,	14,	31,	6,	39},
{15,	20,	35,	7,	33},
{15,	17,	32,	7,	37},
{15,	20,	33,	8,	34},
{15,	20,	30,	8,	37},
{15,	22,	30,	9,	35},
{16,	17,	31,	12,	34},
{16,	17,	31,	10,	35},
{15,	16,	31,	13,	36},
{15,	19,	30,	10,	37},
{15,	18,	33,	10,	34},
{15,	20,	33,	13,	32},
{15,	17,	34,	4,	37},
{14,	39,	25,	7,	0},
{14,	34,	24,	10,	9},
{14,	28,	28,	1,	39},
{15,	21,	35,	1,	39},
{16,	16,	34,	3,	39},
{16,	18,	35,	2,	39},
{14,	39,	21,	4,	39},
{15,	32,	22,	1,	39},
{14,	8,	22,	36,	14},
{14,	29,	28,	17,	14},
{14,	30,	26,	5,	36},
{16,	30,	24,	6,	35},
{15,	32,	25,	4,	34},
{14,	15,	39,	14,	31},
{14,	7,	39,	10,	33},
{15,	11,	39,	10,	32},
{15,	16,	39,	7,	33},
{17,	8,	37,	13,	34},
{16,	15,	37,	7,	34},
{15,	11,	37,	6,	35},
{16,	6,	37,	14,	35},
{16,	8,	37,	12,	35},
{15,	10,	36,	8,	36},
{14,	28,	19,	18,	38},
{14,	30,	19,	18,	35},
{15,	30,	20,	17,	34},
{14,	16,	39,	6,	34},
{14,	5,	38,	17,	35},
{15,	7,	39,	10,	34},
{14,	5,	38,	10,	36},
{14,	4,	39,	9,	37},
{18,	5,	39,	10,	35},
{15,	7,	39,	4,	36},
{15,	6,	39,	9,	36},
{14,	31,	25,	5,	36},
{14,	32,	24,	9,	34},
{16,	31,	24,	10,	32},
{16,	32,	25,	5,	34},
{16,	32,	25,	7,	32},
{14,	31,	31,	10,	1},
{16,	31,	31,	4,	5},
{14,	27,	26,	26,	1},
{15,	27,	25,	23,	6},
{14,	27,	36,	2,	29},
{17,	29,	35,	0,	30},
{15,	27,	34,	4,	27},
{14,	7,	26,	36,	1},
{14,	31,	34,	1,	13},
{17,	32,	33,	1,	3},
{15,	30,	33,	1,	23},
{15,	32,	35,	1,	0},
{14,	31,	33,	3,	9},
{18,	30,	33,	5,	3},
{16,	31,	32,	4,	4},
{16,	30,	34,	3,	3},
{15,	31,	33,	2,	13},
{14,	28,	22,	23,	20},
{14,	19,	27,	33,	13},
{15,	21,	22,	31,	21},
{16,	19,	24,	31,	25},
{14,	39,	19,	24,	25},
{17,	29,	21,	24,	16},
{14,	28,	28,	4,	37},
{16,	27,	26,	4,	38},
{14,	20,	27,	10,	39},
{15,	21,	27,	8,	39},
{14,	20,	29,	7,	39},
{16,	19,	29,	8,	39},
{16,	15,	31,	8,	39},
{15,	16,	31,	7,	39},
{14,	29,	25,	2,	39},
{19,	31,	26,	0,	38},
{17,	30,	23,	3,	38},
{15,	32,	26,	0,	38},
{14,	7,	39,	25,	22},
{14,	16,	19,	35,	19},
{17,	9,	20,	36,	19},
{15,	18,	19,	35,	9},
{15,	19,	16,	35,	20},
{14,	23,	25,	29,	5},
{15,	22,	25,	29,	7},
{14,	3,	28,	24,	34},
{14,	7,	27,	25,	34},
{15,	7,	28,	25,	33},
{14,	10,	22,	23,	37},
{14,	4,	35,	20,	34},
{14,	25,	30,	6,	34},
{16,	26,	28,	5,	35},
{16,	25,	28,	11,	33},
{15,	26,	29,	6,	32},
{15,	25,	28,	9,	34},
{16,	25,	27,	10,	35},
{15,	25,	28,	12,	34},
{14,	29,	30,	7,	32},
{16,	25,	30,	9,	32},
{15,	25,	30,	13,	31},
{14,	27,	28,	13,	32},
{15,	26,	25,	15,	32},
{15,	26,	24,	17,	32},
{15,	26,	25,	17,	31},
{14,	29,	28,	7,	34},
{14,	25,	31,	8,	33},
{16,	26,	33,	6,	31},
{14,	1,	28,	36,	1},
{14,	18,	29,	13,	38},
{15,	19,	29,	13,	37},
{15,	9,	30,	16,	38},
{15,	10,	29,	16,	38},
{14,	6,	25,	32,	30},
{14,	24,	29,	8,	36},
{17,	25,	29,	5,	36},
{16,	23,	29,	10,	36},
{14,	8,	15,	38,	14},
{14,	30,	27,	13,	30},
{15,	28,	30,	8,	30},
{14,	39,	16,	19,	38},
{14,	31,	21,	10,	36},
{14,	15,	38,	30,	14},
{14,	32,	23,	13,	29},
{14,	21,	36,	19,	4},
{15,	22,	36,	15,	5},
{14,	27,	25,	10,	35},
{17,	30,	24,	10,	34},
{16,	29,	25,	9,	34},
{14,	28,	25,	8,	38},
{17,	27,	25,	9,	37},
{14,	39,	19,	21,	32},
{16,	29,	19,	19,	33},
{14,	29,	18,	19,	36},
{14,	29,	23,	19,	27},
{16,	31,	23,	17,	26},
{14,	28,	25,	21,	6},
{16,	28,	24,	21,	10},
{15,	28,	23,	21,	20},
{14,	28,	25,	26,	2},
{15,	28,	23,	23,	11},
{15,	27,	23,	24,	17},
{15,	28,	26,	23,	1},
{15,	28,	25,	23,	4},
{14,	29,	23,	21,	16},
{15,	29,	22,	21,	20},
{14,	1,	39,	31,	2},
{14,	21,	32,	21,	18},
{14,	31,	24,	16,	30},
{15,	31,	25,	15,	29},
{14,	21,	24,	31,	16},
{15,	21,	24,	33,	0},
{14,	31,	27,	16,	26},
{14,	30,	33,	3,	22},
{15,	30,	32,	5,	15},
{14,	27,	35,	4,	17},
{16,	27,	36,	3,	11},
{15,	28,	35,	4,	3},
{15,	28,	36,	3,	2},
{14,	28,	37,	3,	5},
{16,	26,	37,	2,	18},
{14,	27,	35,	7,	3},
{14,	33,	24,	5,	33},
{14,	24,	38,	1,	35},
{14,	7,	21,	35,	24},
{15,	7,	15,	35,	27},
{14,	22,	29,	5,	39},
{16,	26,	29,	1,	39},
{15,	21,	28,	8,	39},
{14,	31,	28,	12,	26},
{14,	27,	21,	16,	38},
{14,	17,	20,	21,	37},
{15,	17,	21,	22,	36},
{15,	17,	23,	21,	34},
{14,	18,	26,	28,	29},
{14,	29,	22,	19,	31},
{14,	16,	31,	22,	32},
{14,	33,	27,	3,	27},
{14,	10,	31,	21,	34},
{14,	26,	23,	27,	23},
{14,	26,	24,	13,	36},
{17,	26,	25,	15,	33},
{16,	27,	26,	12,	33},
{14,	1,	36,	4,	39},
{14,	21,	37,	9,	29},
{14,	39,	22,	14,	8},
{14,	16,	25,	18,	36},
{15,	18,	23,	17,	36},
{14,	29,	23,	7,	37},
{14,	21,	24,	17,	35},
{14,	18,	27,	18,	35},
{16,	21,	24,	18,	34},
{14,	22,	31,	4,	38},
{14,	6,	25,	34,	26},
{14,	39,	19,	19,	34},
{14,	9,	35,	11,	37},
{14,	19,	23,	34,	11},
{14,	22,	34,	15,	30},
{14,	21,	33,	18,	30},
{15,	19,	34,	19,	30},
{15,	17,	34,	20,	31},
{14,	28,	32,	3,	31},
{15,	30,	31,	2,	31},
{14,	3,	31,	16,	39},
{14,	29,	35,	1,	22},
{15,	28,	35,	3,	12},
{15,	28,	36,	3,	11},
{14,	19,	17,	23,	37},
{16,	18,	15,	23,	38},
{14,	39,	12,	24,	38},
{14,	22,	15,	24,	37},
{16,	18,	16,	26,	37},
{14,	25,	24,	30,	0},
{14,	28,	20,	26,	30},
{14,	29,	21,	10,	38},
{15,	28,	22,	10,	38},
{14,	27,	28,	21,	1},
{14,	27,	28,	16,	28},
{15,	29,	28,	16,	24},
{14,	30,	23,	29,	0},
{14,	39,	23,	18,	0},
{14,	20,	30,	30,	0},
{14,	39,	24,	2,	7},
{14,	29,	27,	11,	31},
{14,	29,	22,	24,	5},
{14,	7,	26,	35,	9},
{14,	17,	16,	36,	2},
{15,	16,	13,	36,	19},
{14,	15,	32,	17,	33},
{14,	24,	23,	23,	31},
{15,	25,	23,	23,	30},
{14,	31,	30,	5,	31},
{16,	30,	30,	4,	33},
{14,	39,	17,	29,	5},
{14,	25,	29,	13,	32},
{14,	14,	13,	34,	32},
{15,	11,	15,	33,	32},
{16,	12,	18,	33,	31},
{14,	21,	24,	30,	27},
{14,	22,	22,	29,	30},
{16,	26,	17,	29,	31},
{14,	24,	17,	30,	31},
{14,	26,	23,	25,	28},
{14,	30,	25,	17,	25},
{14,	21,	36,	14,	25},
{14,	18,	38,	24,	0},
{16,	18,	38,	19,	8},
{15,	17,	39,	19,	6},
{14,	14,	19,	28,	33},
{14,	23,	31,	22,	0},
{14,	23,	30,	22,	7},
{14,	32,	30,	6,	0},
{14,	26,	21,	22,	32},
{14,	26,	24,	15,	35},
{14,	18,	13,	26,	38},
{14,	24,	35,	6,	28},
{16,	24,	36,	4,	30},
{14,	25,	36,	3,	31},
{15,	27,	35,	2,	31},
{14,	25,	38,	1,	33},
{15,	27,	35,	2,	32},
{15,	25,	33,	5,	32},
{16,	24,	36,	4,	32},
{15,	27,	33,	3,	32},
{14,	25,	34,	1,	36},
{14,	26,	35,	1,	35},
{14,	9,	30,	17,	37},
{14,	11,	33,	10,	39},
{14,	20,	34,	24,	0},
{14,	25,	29,	23,	0},
{14,	5,	15,	39,	1},
{14,	16,	32,	28,	27},
{15,	18,	32,	25,	27},
{14,	22,	23,	26,	30},
{14,	20,	23,	22,	33},
{14,	30,	23,	3,	39},
{14,	28,	22,	17,	32},
{14,	20,	37,	5,	34},
{14,	15,	15,	34,	31},
{14,	30,	24,	1,	39},
{14,	31,	25,	2,	38},
{14,	28,	21,	28,	1},
{14,	28,	38,	1,	7},
{15,	26,	39,	1,	16},
{15,	28,	39,	1,	7},
{14,	13,	9,	39,	8},
{15,	39,	6,	38,	25},
{14,	13,	17,	38,	0},
{15,	4,	17,	39,	0},
{14,	4,	18,	39,	0},
{16,	3,	19,	38,	0},
{14,	4,	16,	39,	2},
{14,	24,	19,	18,	39},
{14,	30,	25,	9,	33},
{14,	28,	27,	2,	38},
{14,	24,	15,	32,	21},
{14,	17,	35,	4,	36},
{15,	15,	35,	7,	35},
{14,	20,	37,	4,	35},
{14,	33,	38,	0,	0},
{14,	33,	32,	1,	0},
{14,	39,	11,	25,	38},
{14,	20,	11,	26,	38},
{14,	18,	34,	22,	29},
{16,	18,	33,	20,	31},
{14,	19,	33,	21,	30},
{14,	29,	19,	24,	29},
{14,	18,	25,	28,	30},
{14,	23,	30,	16,	31},
{14,	20,	23,	31,	25},
{14,	13,	38,	14,	32},
{14,	26,	26,	6,	38},
{14,	24,	14,	33,	24},
{14,	39,	18,	31,	0},
{14,	27,	28,	19,	4},
{14,	8,	37,	26,	31},
{14,	19,	22,	26,	32},
{15,	19,	20,	26,	33},
{14,	20,	19,	25,	34},
{14,	22,	20,	21,	34},
{16,	19,	20,	26,	34},
{14,	18,	21,	21,	35},
{14,	20,	22,	23,	33},
{14,	18,	22,	20,	35},
{14,	22,	27,	17,	32},
{14,	24,	26,	18,	32},
{15,	23,	28,	18,	31},
{14,	22,	26,	17,	33},
{14,	18,	14,	33,	32},
{14,	20,	36,	7,	33},
{14,	31,	26,	3,	34},
{14,	8,	39,	27,	19},
{14,	28,	35,	1,	28},
{14,	8,	38,	12,	34},
{14,	33,	24,	9,	19},
{14,	17,	38,	26,	0},
{14,	16,	38,	28,	14},
{17,	16,	38,	26,	20},
{14,	16,	38,	29,	4},
{14,	21,	31,	23,	0},
{14,	25,	29,	20,	1},
{14,	30,	32,	9,	1},
{14,	23,	30,	17,	31},
{14,	20,	33,	16,	31},
{14,	23,	27,	18,	32},
{14,	27,	36,	0,	35},
{14,	27,	34,	0,	36},
{14,	24,	34,	6,	32},
{14,	8,	32,	23,	33},
{14,	14,	29,	19,	34},
{14,	12,	29,	20,	34},
{14,	13,	26,	22,	34},
{14,	13,	30,	21,	33},
{15,	14,	27,	22,	33},
{14,	31,	27,	0,	38},
{14,	29,	28,	0,	39},
{15,	31,	28,	0,	37},
{14,	20,	38,	3,	34},
{14,	23,	22,	11,	39},
{14,	11,	35,	12,	36},
{14,	10,	36,	13,	34},
{14,	10,	36,	16,	33},
{15,	11,	35,	18,	33},
{14,	8,	37,	23,	33},
{14,	9,	36,	14,	34},
{14,	14,	35,	11,	33},
{14,	17,	35,	10,	34},
{16,	13,	35,	12,	35},
{15,	15,	35,	13,	34},
{14,	20,	38,	14,	18},
{14,	13,	39,	0,	38},
{14,	19,	33,	22,	13},
{14,	39,	21,	25,	1},
{14,	18,	37,	26,	2},
{14,	30,	23,	19,	9},
{14,	21,	34,	22,	0},
{14,	23,	18,	34,	0},
{14,	12,	25,	35,	2},
{14,	14,	27,	30,	29},
{14,	28,	23,	13,	35},
{14,	31,	21,	9,	38},
{14,	20,	17,	26,	35},
{14,	24,	16,	26,	35},
{14,	19,	16,	26,	37},
{14,	17,	24,	23,	33},
{14,	14,	23,	24,	34},
{15,	13,	23,	29,	32},
{14,	18,	20,	20,	37},
{15,	18,	19,	21,	37},
{14,	17,	30,	10,	38},
{14,	29,	23,	4,	38},
{14,	9,	37,	33,	13},
{14,	15,	35,	6,	36},
{14,	12,	37,	7,	36},
{15,	8,	37,	10,	36},
{14,	9,	34,	11,	38},
{14,	25,	35,	7,	24},
{14,	10,	25,	20,	36},
{14,	10,	24,	21,	37},
{14,	9,	24,	18,	39},
{14,	9,	25,	17,	39},
{14,	12,	25,	16,	39},
{14,	10,	19,	36,	17},
{14,	39,	25,	0,	17},
{14,	23,	39,	6,	1},
{14,	35,	32,	0,	2},
{14,	39,	14,	31,	29},
{14,	27,	21,	21,	32},
{14,	21,	16,	28,	35},
{14,	20,	16,	27,	36},
{14,	18,	20,	33,	27},
{16,	20,	20,	31,	28},
{14,	19,	18,	31,	29},
{15,	17,	24,	30,	29},
{14,	23,	18,	30,	30},
{14,	17,	22,	31,	30},
{15,	19,	17,	31,	31},
{14,	18,	17,	32,	31},
{14,	15,	20,	32,	30},
{14,	25,	26,	17,	30},
{14,	23,	21,	18,	36},
{14,	24,	24,	27,	22},
{14,	26,	37,	1,	32},
{15,	28,	38,	0,	30},
{15,	28,	36,	1,	28},
{14,	28,	38,	1,	16},
{15,	28,	37,	3,	8},
{14,	23,	35,	10,	27},
{14,	24,	37,	3,	31},
{14,	13,	26,	23,	33},
{14,	13,	28,	16,	37},
{14,	19,	28,	32,	13},
{14,	10,	39,	8,	34},
{14,	19,	21,	33,	17},
{14,	26,	36,	4,	21},
{14,	20,	25,	31,	8},
{14,	10,	23,	35,	11},
{14,	20,	34,	21,	2},
{14,	21,	33,	21,	4},
{14,	20,	33,	24,	1},
{14,	20,	34,	23,	1},
{14,	32,	27,	10,	7},
{14,	18,	12,	36,	9},
{15,	39,	9,	36,	22},
{14,	19,	16,	36,	2},
{14,	22,	13,	36,	6},
{16,	22,	16,	36,	1},
{14,	27,	34,	10,	2},
{13,	23,	39,	26,	29},
{19,	13,	39,	24,	30},
{18,	22,	39,	7,	30},
{17,	24,	28,	26,	23},
{17,	20,	39,	4,	33},
{16,	20,	31,	23,	30},
{16,	23,	37,	7,	31},
{16,	21,	30,	28,	3},
{16,	26,	27,	25,	23},
{16,	25,	28,	24,	24},
{15,	12,	38,	25,	30},
{15,	19,	36,	28,	0},
{15,	21,	25,	28,	27},
{15,	20,	27,	28,	26},
{15,	21,	35,	12,	30},
{15,	19,	33,	27,	12},
{15,	23,	27,	22,	30},
{15,	25,	23,	25,	29},
{14,	13,	39,	29,	23},
{19,	14,	39,	28,	16},
{17,	6,	39,	30,	17},
{17,	15,	39,	30,	0},
{16,	14,	39,	29,	17},
{15,	13,	39,	28,	26},
{15,	16,	39,	27,	7},
{14,	23,	27,	22,	31},
{17,	23,	27,	19,	32},
{16,	21,	28,	21,	31},
{15,	23,	26,	23,	31},
{15,	23,	25,	24,	30},
{14,	4,	39,	30,	21},
{14,	17,	27,	30,	29},
{14,	18,	29,	30,	27},
{16,	18,	27,	29,	29},
{15,	17,	33,	28,	27},
{14,	17,	28,	31,	27},
{14,	19,	35,	27,	12},
{14,	20,	30,	28,	17},
{14,	19,	32,	29,	22},
{15,	19,	29,	28,	26},
{14,	21,	30,	28,	22},
{14,	22,	30,	28,	13},
{17,	23,	25,	28,	13},
{15,	23,	26,	28,	1},
{14,	21,	29,	28,	25},
{15,	20,	28,	28,	27},
{14,	22,	26,	28,	27},
{17,	22,	29,	27,	25},
{14,	23,	26,	28,	13},
{14,	24,	24,	26,	28},
{14,	24,	25,	27,	13},
{15,	25,	25,	27,	1},
{14,	26,	24,	27,	16},
{14,	27,	24,	28,	1},
{14,	24,	26,	28,	1},
{14,	17,	28,	30,	29},
{14,	24,	36,	6,	28},
{15,	25,	36,	6,	22},
{14,	20,	30,	28,	25},
{14,	24,	24,	27,	26},
{14,	24,	26,	21,	31},
{14,	24,	36,	7,	26},
{14,	18,	33,	23,	30},
{14,	26,	24,	26,	24},
{14,	26,	24,	28,	2},
{15,	24,	23,	28,	15},
{14,	22,	29,	28,	16},
{13,	15,	38,	36,	21},
{19,	15,	37,	34,	22},
{18,	1,	39,	32,	2},
{17,	10,	37,	34,	24},
{17,	7,	25,	35,	22},
{17,	17,	19,	36,	2},
{17,	18,	17,	36,	8},
{16,	16,	20,	36,	19},
{15,	19,	23,	35,	5},
{17,	17,	21,	36,	5},
{15,	3,	39,	31,	3},
{15,	6,	23,	36,	22},
{15,	16,	37,	33,	18},
{15,	14,	19,	36,	22},
{14,	12,	39,	36,	1},
{15,	14,	39,	31,	1},
{14,	6,	39,	31,	16},
{14,	14,	39,	30,	9},
{15,	11,	39,	32,	2},
{15,	8,	39,	30,	19},
{14,	16,	25,	35,	21},
{18,	18,	29,	35,	0},
{14,	16,	36,	35,	1},
{15,	16,	28,	35,	8},
{14,	19,	20,	36,	2},
{14,	10,	39,	31,	9},
{14,	11,	39,	32,	5},
{14,	17,	30,	35,	2},
{15,	18,	25,	35,	5},
{14,	16,	38,	33,	0},
{14,	9,	39,	31,	14},
{14,	12,	39,	30,	19},
{14,	15,	38,	28,	26},
{14,	22,	20,	35,	0},
{14,	16,	38,	31,	2},
{13,	28,	35,	19,	29},
{19,	27,	32,	6,	31},
{18,	29,	26,	19,	9},
{16,	29,	25,	19,	26},
{19,	29,	24,	17,	29},
{17,	29,	27,	17,	26},
{16,	29,	32,	7,	27},
{15,	28,	36,	3,	27},
{15,	28,	36,	2,	30},
{15,	27,	31,	4,	33},
{15,	28,	28,	13,	30},
{15,	30,	28,	10,	30},
{15,	29,	28,	16,	26},
{15,	27,	35,	3,	32},
{15,	29,	34,	5,	6},
{15,	29,	25,	18,	27},
{14,	25,	36,	7,	27},
{14,	30,	26,	18,	25},
{14,	29,	28,	9,	31},
{14,	29,	31,	7,	29},
{14,	29,	28,	16,	27},
{14,	26,	36,	7,	21},
{14,	30,	27,	17,	25},
{14,	27,	33,	4,	32},
{13,	18,	34,	21,	37},
{18,	13,	25,	17,	38},
{18,	10,	32,	13,	38},
{17,	16,	35,	19,	32},
{17,	20,	26,	15,	37},
{17,	13,	35,	16,	34},
{17,	19,	25,	22,	33},
{16,	15,	23,	17,	39},
{16,	19,	34,	14,	32},
{16,	14,	23,	23,	35},
{16,	18,	35,	22,	30},
{16,	13,	35,	19,	33},
{16,	17,	35,	13,	34},
{16,	6,	38,	16,	35},
{15,	5,	35,	18,	36},
{15,	16,	35,	19,	33},
{15,	13,	34,	10,	38},
{15,	20,	28,	21,	32},
{15,	19,	30,	13,	37},
{15,	21,	24,	19,	34},
{15,	16,	35,	10,	35},
{15,	10,	31,	16,	38},
{15,	20,	33,	6,	35},
{15,	19,	34,	23,	30},
{15,	14,	25,	17,	38},
{14,	1,	37,	19,	35},
{17,	1,	36,	20,	34},
{17,	7,	36,	19,	34},
{14,	12,	26,	23,	35},
{15,	14,	24,	24,	34},
{14,	20,	28,	16,	37},
{16,	19,	30,	16,	35},
{14,	21,	24,	17,	36},
{14,	8,	34,	16,	38},
{14,	20,	26,	15,	38},
{14,	12,	36,	16,	34},
{18,	14,	38,	10,	33},
{15,	15,	37,	9,	34},
{14,	16,	36,	13,	34},
{14,	20,	23,	17,	37},
{15,	20,	21,	19,	37},
{14,	17,	35,	22,	31},
{14,	20,	21,	18,	39},
{14,	16,	38,	9,	34},
{14,	18,	36,	3,	37},
{17,	20,	38,	1,	37},
{16,	19,	36,	1,	39},
{14,	16,	38,	4,	36},
{14,	18,	22,	25,	34},
{14,	21,	24,	16,	38},
{14,	14,	24,	28,	32},
{14,	21,	34,	10,	32},
{14,	13,	26,	28,	32},
{16,	13,	31,	26,	31},
{14,	18,	22,	17,	38},
{14,	13,	29,	28,	31},
{14,	14,	37,	11,	34},
{14,	15,	36,	14,	34},
{14,	22,	28,	14,	34},
{14,	11,	26,	25,	34},
{14,	20,	28,	19,	33},
{14,	22,	26,	19,	33},
{15,	23,	24,	19,	33},
{15,	26,	23,	18,	33},
{14,	12,	37,	13,	34},
{14,	11,	38,	16,	33},
{14,	14,	38,	13,	33},
{14,	9,	33,	16,	38},
{14,	16,	34,	22,	32},
{14,	20,	25,	22,	33},
{14,	14,	26,	25,	32},
{14,	12,	24,	24,	35},
{14,	16,	22,	26,	35},
{13,	33,	27,	18,	25},
{20,	32,	27,	10,	29},
{18,	32,	23,	15,	28},
{18,	33,	23,	13,	28},
{16,	33,	24,	10,	27},
{15,	34,	24,	13,	0},
{15,	33,	24,	10,	30},
{14,	33,	27,	9,	28},
{15,	33,	27,	1,	30},
{14,	32,	26,	13,	29},
{16,	32,	24,	17,	26},
{15,	32,	24,	15,	29},
{15,	33,	26,	11,	27},
{15,	31,	25,	17,	26},
{14,	33,	27,	6,	30},
{14,	33,	25,	5,	33},
{14,	39,	22,	16,	27},
{14,	39,	22,	18,	26},
{14,	32,	27,	9,	30},
{14,	39,	22,	19,	3},
{14,	33,	27,	10,	27},
{13,	12,	29,	30,	35},
{17,	12,	32,	23,	33},
{17,	16,	22,	28,	33},
{16,	3,	30,	26,	33},
{16,	13,	20,	29,	34},
{16,	19,	17,	29,	33},
{16,	0,	16,	31,	34},
{15,	15,	30,	23,	33},
{14,	12,	32,	28,	33},
{14,	7,	33,	28,	33},
{14,	12,	21,	27,	36},
{14,	7,	36,	24,	33},
{14,	5,	33,	22,	35},
{14,	14,	29,	23,	35},
{14,	10,	32,	23,	34},
{16,	12,	32,	22,	35},
{14,	13,	18,	30,	35},
{14,	23,	18,	30,	31},
{14,	13,	22,	30,	33},
{13,	39,	19,	21,	39},
{17,	22,	20,	21,	35},
{16,	14,	20,	20,	39},
{16,	22,	16,	23,	37},
{16,	22,	17,	25,	35},
{15,	39,	16,	27,	35},
{16,	23,	16,	27,	36},
{15,	14,	20,	21,	39},
{15,	23,	20,	21,	35},
{15,	26,	20,	21,	34},
{14,	12,	25,	19,	39},
{15,	13,	25,	19,	38},
{15,	13,	24,	19,	39},
{14,	18,	20,	21,	39},
{14,	15,	24,	16,	39},
{14,	14,	24,	18,	39},
{14,	17,	21,	19,	39},
{14,	23,	18,	22,	35},
{13,	16,	20,	30,	37},
{19,	39,	10,	29,	37},
{17,	18,	15,	29,	37},
{16,	23,	19,	29,	31},
{15,	14,	22,	30,	33},
{15,	17,	17,	28,	37},
{15,	19,	22,	29,	31},
{15,	19,	12,	30,	37},
{14,	21,	17,	28,	34},
{14,	22,	13,	27,	37},
{13,	12,	35,	34,	30},
{19,	14,	35,	32,	27},
{17,	14,	19,	34,	29},
{17,	14,	35,	33,	27},
{16,	15,	28,	31,	29},
{15,	12,	24,	33,	31},
{16,	2,	20,	33,	32},
{14,	9,	20,	34,	32},
{17,	10,	22,	34,	31},
{15,	17,	14,	34,	32},
{14,	17,	22,	34,	27},
{14,	15,	27,	32,	28},
{14,	9,	23,	32,	32},
{14,	11,	22,	32,	32},
{14,	12,	20,	33,	32},
{13,	25,	39,	18,	23},
{19,	25,	37,	6,	27},
{18,	24,	39,	4,	30},
{17,	25,	36,	13,	25},
{17,	26,	39,	3,	4},
{16,	26,	38,	5,	1},
{15,	24,	36,	19,	23},
{16,	24,	38,	19,	6},
{15,	24,	37,	6,	30},
{15,	26,	38,	3,	14},
{14,	25,	36,	11,	27},
{14,	24,	37,	17,	24},
{14,	24,	36,	15,	27},
{14,	24,	38,	3,	32},
{14,	26,	37,	3,	27},
{14,	28,	37,	4,	0},
{14,	25,	36,	8,	28},
{14,	24,	36,	12,	29},
{13,	28,	29,	23,	29},
{18,	24,	25,	23,	31},
{17,	24,	29,	24,	7},
{16,	29,	22,	20,	31},
{15,	26,	23,	23,	30},
{15,	29,	22,	21,	29},
{14,	26,	29,	24,	19},
{15,	26,	29,	25,	0},
{14,	26,	23,	19,	33},
{14,	27,	27,	24,	1},
{14,	29,	22,	21,	31},
{13,	39,	22,	13,	38},
{16,	33,	24,	8,	31},
{16,	32,	23,	11,	33},
{16,	31,	23,	12,	33},
{15,	29,	23,	10,	35},
{15,	33,	25,	0,	38},
{14,	32,	23,	13,	33},
{16,	29,	23,	13,	34},
{14,	30,	22,	16,	33},
{14,	29,	22,	16,	34},
{14,	31,	25,	12,	31},
{14,	28,	21,	16,	37},
{14,	39,	22,	0,	39},
{14,	31,	26,	13,	30},
{14,	30,	23,	10,	35},
{14,	29,	21,	16,	35},
{14,	29,	23,	8,	37},
{14,	30,	23,	12,	34},
{13,	29,	25,	28,	24},
{20,	29,	20,	26,	29},
{17,	30,	19,	25,	15},
{16,	30,	20,	24,	25},
{15,	27,	26,	25,	10},
{17,	27,	26,	24,	22},
{15,	29,	23,	23,	27},
{16,	29,	25,	23,	25},
{15,	30,	24,	21,	1},
{15,	28,	20,	27,	30},
{15,	29,	26,	20,	1},
{15,	25,	25,	27,	25},
{14,	27,	28,	24,	20},
{14,	30,	19,	26,	18},
{14,	27,	21,	27,	30},
{15,	28,	21,	24,	30},
{17,	29,	22,	24,	27},
{14,	30,	24,	23,	1},
{14,	39,	18,	28,	24},
{13,	29,	25,	13,	39},
{17,	30,	24,	13,	33},
{17,	30,	25,	3,	38},
{15,	30,	25,	12,	33},
{14,	29,	24,	16,	32},
{16,	28,	25,	15,	32},
{14,	27,	24,	19,	32},
{16,	26,	25,	18,	31},
{16,	28,	23,	19,	30},
{16,	28,	25,	17,	30},
{15,	29,	24,	19,	30},
{15,	29,	25,	17,	30},
{15,	26,	24,	23,	30},
{14,	28,	26,	18,	30},
{17,	26,	26,	18,	31},
{14,	25,	26,	22,	30},
{14,	26,	26,	13,	35},
{14,	29,	23,	20,	30},
{13,	26,	26,	30,	26},
{19,	25,	28,	25,	26},
{18,	26,	19,	29,	31},
{17,	25,	25,	24,	29},
{17,	21,	30,	29,	0},
{16,	21,	27,	30,	1},
{16,	27,	19,	30,	3},
{15,	22,	25,	30,	27},
{15,	26,	18,	30,	31},
{15,	28,	20,	30,	1},
{15,	21,	26,	32,	0},
{16,	21,	25,	31,	11},
{14,	23,	27,	28,	22},
{14,	27,	26,	30,	0},
{15,	28,	25,	29,	0},
{14,	27,	24,	25,	28},
{14,	22,	28,	30,	1},
{16,	23,	27,	30,	1},
{14,	21,	29,	33,	0},
{14,	20,	29,	29,	9},
{16,	21,	28,	29,	4},
{14,	27,	16,	30,	25},
{17,	28,	18,	29,	12},
{15,	39,	17,	29,	25},
{14,	27,	25,	27,	26},
{14,	23,	29,	27,	3},
{14,	24,	29,	27,	0},
{15,	25,	27,	27,	1},
{14,	24,	25,	26,	29},
{14,	22,	28,	30,	2},
{14,	26,	27,	25,	26},
{14,	29,	23,	30,	0},
{14,	28,	25,	24,	26},
{14,	28,	24,	24,	28},
{14,	21,	26,	31,	3},
{13,	25,	32,	24,	29},
{17,	26,	30,	20,	3},
{15,	24,	33,	24,	3},
{18,	24,	34,	23,	0},
{14,	26,	30,	20,	29},
{14,	27,	29,	24,	20},
{14,	24,	31,	26,	1},
{13,	23,	27,	19,	37},
{17,	24,	22,	17,	37},
{15,	25,	27,	15,	33},
{15,	21,	21,	17,	39},
{15,	23,	28,	15,	33},
{14,	26,	21,	17,	37},
{14,	25,	21,	16,	39},
{14,	20,	28,	18,	35},
{14,	27,	21,	17,	35},
{14,	27,	20,	17,	36},
{14,	22,	24,	16,	38},
{13,	29,	34,	13,	27},
{16,	30,	32,	11,	0},
{14,	30,	32,	9,	13},
{14,	29,	34,	5,	29},
{16,	29,	34,	3,	30},
{14,	31,	32,	2,	28},
{14,	29,	32,	2,	32},
{15,	30,	31,	2,	33},
{15,	28,	31,	1,	35},
{14,	29,	33,	0,	36},
{14,	29,	34,	6,	28},
{14,	29,	35,	0,	33},
{14,	30,	34,	0,	33},
{14,	30,	32,	11,	1},
{13,	34,	27,	6,	30},
{19,	34,	25,	2,	32},
{16,	35,	27,	6,	0},
{13,	12,	33,	26,	35},
{16,	15,	34,	22,	33},
{17,	13,	32,	23,	35},
{14,	16,	33,	23,	31},
{14,	13,	35,	22,	33},
{14,	9,	37,	22,	33},
{14,	15,	33,	23,	32},
{13,	33,	29,	7,	29},
{15,	33,	27,	9,	29},
{13,	39,	25,	18,	1},
{17,	34,	25,	8,	5},
{14,	34,	24,	11,	2},
{13,	8,	26,	21,	39},
{19,	11,	23,	21,	39},
{17,	17,	21,	21,	39},
{17,	16,	22,	21,	38},
{14,	7,	22,	23,	38},
{14,	17,	22,	21,	38},
{13,	39,	23,	10,	36},
{15,	33,	24,	6,	33},
{14,	34,	24,	6,	32},
{16,	34,	25,	4,	32},
{14,	31,	23,	13,	35},
{14,	33,	25,	2,	36},
{14,	30,	24,	13,	34},
{14,	30,	24,	6,	36},
{13,	12,	33,	23,	36},
{16,	16,	22,	24,	36},
{13,	11,	37,	18,	36},
{17,	6,	38,	11,	36},
{15,	11,	36,	19,	35},
{15,	12,	37,	11,	36},
{14,	2,	37,	11,	37},
{13,	13,	38,	31,	29},
{16,	16,	35,	28,	28},
{15,	6,	38,	33,	22},
{15,	15,	38,	31,	25},
{15,	18,	34,	28,	27},
{14,	12,	36,	33,	29},
{14,	7,	37,	27,	30},
{14,	13,	31,	28,	32},
{14,	13,	32,	24,	34},
{14,	14,	26,	24,	35},
{15,	14,	23,	24,	36},
{13,	32,	21,	16,	39},
{16,	39,	21,	13,	39},
{15,	30,	22,	7,	39},
{14,	39,	21,	17,	32},
{13,	3,	39,	18,	35},
{18,	11,	39,	15,	32},
{17,	7,	39,	14,	34},
{16,	9,	39,	18,	31},
{15,	2,	39,	12,	36},
{15,	4,	39,	18,	34},
{15,	6,	38,	18,	35},
{14,	15,	39,	13,	32},
{14,	16,	39,	8,	34},
{14,	16,	39,	12,	32},
{13,	5,	34,	19,	38},
{14,	7,	31,	19,	38},
{13,	9,	28,	32,	33},
{16,	12,	30,	31,	31},
{15,	10,	26,	32,	33},
{14,	9,	29,	31,	32},
{13,	30,	34,	8,	25},
{17,	30,	32,	4,	29},
{15,	30,	34,	4,	26},
{14,	30,	33,	5,	28},
{16,	30,	32,	7,	27},
{13,	9,	36,	10,	39},
{15,	6,	38,	3,	38},
{15,	11,	35,	8,	39},
{14,	6,	39,	6,	37},
{14,	10,	36,	11,	37},
{13,	23,	33,	8,	37},
{18,	23,	36,	3,	34},
{18,	22,	36,	7,	33},
{18,	21,	34,	2,	39},
{17,	25,	30,	4,	37},
{16,	23,	29,	10,	38},
{16,	23,	36,	6,	33},
{16,	26,	32,	4,	33},
{15,	24,	32,	5,	34},
{16,	24,	36,	3,	34},
{15,	24,	37,	2,	35},
{15,	26,	30,	4,	37},
{15,	23,	33,	2,	38},
{15,	21,	38,	4,	34},
{14,	27,	36,	0,	37},
{14,	25,	34,	2,	36},
{14,	24,	32,	7,	34},
{14,	22,	35,	1,	39},
{14,	23,	31,	5,	38},
{14,	25,	33,	3,	35},
{14,	24,	29,	7,	37},
{14,	19,	35,	5,	36},
{13,	24,	30,	28,	25},
{15,	24,	31,	26,	22},
{14,	23,	28,	30,	2},
{14,	24,	27,	28,	26},
{15,	21,	27,	27,	28},
{14,	25,	28,	28,	0},
{15,	26,	27,	28,	1},
{14,	24,	31,	25,	27},
{13,	30,	24,	24,	25},
{18,	31,	22,	19,	26},
{15,	31,	22,	21,	9},
{15,	30,	22,	23,	27},
{15,	31,	22,	23,	3},
{14,	31,	25,	19,	23},
{18,	32,	23,	19,	9},
{15,	31,	23,	21,	3},
{15,	30,	25,	20,	1},
{14,	31,	22,	26,	1},
{14,	32,	22,	25,	2},
{14,	39,	22,	19,	7},
{14,	32,	23,	21,	1},
{13,	12,	10,	36,	32},
{14,	15,	12,	35,	32},
{13,	27,	23,	19,	36},
{15,	26,	21,	19,	37},
{14,	26,	24,	16,	35},
{14,	24,	24,	16,	37},
{14,	26,	24,	16,	36},
{13,	3,	38,	15,	37},
{19,	11,	35,	15,	37},
{15,	1,	36,	16,	37},
{14,	9,	35,	13,	38},
{13,	39,	24,	5,	31},
{15,	35,	26,	0,	31},
{15,	35,	25,	6,	2},
{14,	39,	24,	1,	32},
{13,	3,	27,	26,	36},
{17,	11,	26,	24,	36},
{13,	34,	25,	10,	27},
{14,	34,	25,	16,	2},
{13,	5,	37,	10,	39},
{14,	3,	38,	8,	38},
{15,	6,	38,	7,	38},
{14,	4,	37,	11,	38},
{14,	8,	37,	4,	39},
{15,	20,	38,	1,	38},
{14,	6,	37,	12,	37},
{13,	24,	25,	26,	32},
{18,	23,	27,	21,	32},
{17,	26,	19,	24,	32},
{18,	28,	17,	27,	32},
{15,	27,	19,	23,	33},
{16,	23,	20,	22,	34},
{15,	21,	25,	22,	33},
{17,	24,	23,	20,	33},
{15,	15,	25,	28,	32},
{15,	26,	17,	26,	33},
{15,	21,	20,	22,	35},
{15,	18,	25,	28,	31},
{15,	21,	26,	24,	31},
{15,	16,	35,	24,	30},
{14,	15,	28,	30,	32},
{16,	15,	24,	31,	31},
{15,	17,	25,	30,	30},
{15,	15,	23,	29,	33},
{15,	16,	28,	26,	31},
{15,	16,	31,	26,	30},
{14,	15,	26,	30,	33},
{17,	15,	29,	25,	33},
{14,	19,	28,	26,	30},
{14,	28,	18,	22,	34},
{15,	39,	17,	25,	33},
{14,	18,	22,	23,	35},
{16,	17,	20,	24,	36},
{15,	17,	18,	23,	38},
{14,	13,	30,	31,	31},
{14,	27,	18,	22,	35},
{14,	16,	25,	26,	33},
{14,	17,	19,	25,	37},
{14,	21,	18,	25,	35},
{14,	13,	32,	25,	34},
{14,	21,	26,	21,	33},
{14,	20,	27,	21,	33},
{13,	31,	30,	13,	24},
{15,	31,	29,	12,	25},
{13,	28,	33,	7,	33},
{16,	26,	32,	10,	30},
{16,	28,	33,	1,	35},
{14,	26,	30,	8,	34},
{16,	28,	29,	7,	34},
{15,	26,	32,	8,	32},
{14,	30,	31,	4,	33},
{15,	29,	32,	4,	32},
{14,	26,	30,	9,	32},
{14,	28,	34,	2,	33},
{13,	39,	9,	31,	35},
{14,	39,	9,	32,	34},
{14,	16,	8,	34,	34},
{14,	13,	13,	34,	33},
{14,	17,	11,	34,	33},
{13,	23,	31,	18,	33},
{15,	22,	28,	16,	36},
{15,	25,	31,	13,	31},
{14,	21,	31,	20,	32},
{14,	23,	29,	16,	34},
{14,	23,	34,	9,	33},
{14,	25,	31,	13,	32},
{14,	24,	32,	13,	31},
{15,	23,	33,	10,	32},
{16,	25,	32,	10,	32},
{14,	21,	32,	18,	31},
{14,	22,	28,	15,	37},
{14,	22,	33,	9,	34},
{15,	20,	32,	9,	36},
{14,	19,	32,	19,	32},
{14,	23,	35,	11,	30},
{14,	23,	31,	9,	35},
{14,	19,	31,	11,	36},
{13,	26,	28,	17,	33},
{18,	24,	32,	16,	30},
{16,	24,	24,	19,	34},
{15,	25,	31,	17,	30},
{15,	25,	31,	16,	31},
{15,	24,	30,	16,	32},
{14,	25,	26,	19,	33},
{14,	26,	24,	17,	34},
{14,	26,	25,	19,	33},
{15,	26,	26,	22,	30},
{14,	29,	25,	19,	30},
{14,	24,	26,	22,	32},
{14,	19,	28,	23,	32},
{14,	19,	28,	25,	31},
{14,	24,	31,	18,	30},
{14,	26,	27,	19,	30},
{14,	28,	28,	14,	30},
{13,	16,	22,	30,	36},
{14,	13,	26,	27,	35},
{14,	17,	22,	25,	36},
{13,	14,	21,	35,	30},
{19,	18,	17,	35,	29},
{15,	16,	24,	35,	23},
{15,	13,	36,	32,	29},
{15,	15,	19,	35,	30},
{15,	13,	21,	36,	23},
{14,	19,	16,	35,	28},
{13,	32,	23,	10,	38},
{18,	30,	24,	6,	37},
{17,	31,	25,	3,	38},
{15,	30,	25,	5,	37},
{14,	32,	24,	1,	39},
{15,	32,	23,	2,	39},
{14,	33,	23,	3,	37},
{15,	33,	23,	2,	38},
{13,	20,	35,	28,	22},
{14,	22,	35,	27,	0},
{15,	21,	34,	28,	0},
{14,	23,	33,	27,	0},
{14,	22,	31,	28,	1},
{13,	24,	36,	21,	24},
{15,	24,	34,	24,	3},
{15,	24,	34,	22,	9},
{14,	24,	35,	21,	26},
{13,	11,	26,	28,	36},
{16,	14,	23,	27,	36},
{16,	12,	26,	27,	36},
{13,	18,	37,	32,	25},
{15,	18,	38,	29,	1},
{14,	18,	37,	33,	17},
{14,	17,	38,	27,	11},
{14,	18,	39,	27,	2},
{13,	26,	36,	16,	21},
{13,	31,	22,	16,	38},
{13,	20,	35,	29,	17},
{17,	20,	27,	30,	20},
{15,	21,	32,	29,	0},
{13,	29,	27,	10,	35},
{15,	28,	30,	8,	32},
{14,	29,	28,	10,	32},
{13,	18,	34,	8,	39},
{15,	20,	33,	6,	38},
{15,	20,	34,	3,	39},
{14,	18,	35,	4,	39},
{14,	22,	33,	5,	38},
{14,	17,	34,	9,	38},
{14,	20,	36,	3,	37},
{14,	22,	36,	2,	37},
{13,	8,	32,	16,	39},
{13,	31,	32,	0,	39},
{16,	30,	30,	2,	34},
{15,	24,	30,	5,	38},
{15,	30,	28,	2,	35},
{15,	26,	30,	1,	39},
{15,	30,	34,	0,	36},
{15,	29,	33,	0,	38},
{14,	29,	35,	0,	38},
{14,	26,	29,	2,	38},
{14,	31,	25,	1,	39},
{14,	24,	36,	0,	39},
{14,	28,	34,	0,	39},
{13,	29,	30,	15,	20},
{13,	6,	36,	23,	34},
{14,	8,	36,	21,	34},
{13,	6,	38,	22,	33},
{13,	39,	23,	4,	38},
{13,	25,	26,	16,	37},
{16,	25,	28,	16,	34},
{16,	26,	25,	15,	35},
{14,	24,	29,	16,	34},
{15,	24,	30,	14,	33},
{14,	24,	30,	11,	34},
{17,	22,	30,	11,	35},
{16,	21,	30,	10,	37},
{14,	24,	29,	10,	37},
{13,	19,	31,	28,	30},
{15,	19,	25,	29,	30},
{14,	23,	23,	27,	30},
{14,	18,	33,	27,	29},
{13,	29,	26,	22,	23},
{14,	30,	26,	19,	25},
{15,	31,	26,	19,	2},
{13,	32,	27,	7,	32},
{15,	31,	29,	5,	32},
{15,	31,	28,	4,	33},
{15,	30,	28,	7,	32},
{14,	34,	26,	1,	32},
{14,	32,	28,	1,	32},
{13,	10,	31,	30,	33},
{13,	31,	25,	12,	34},
{15,	30,	25,	13,	34},
{14,	31,	27,	8,	32},
{14,	30,	25,	6,	35},
{13,	10,	25,	35,	26},
{13,	12,	24,	36,	25},
{16,	11,	17,	36,	26},
{16,	9,	15,	36,	29},
{13,	9,	20,	36,	30},
{18,	9,	21,	36,	28},
{15,	11,	22,	36,	26},
{13,	29,	25,	15,	34},
{13,	22,	22,	21,	36},
{16,	26,	21,	20,	34},
{14,	19,	22,	23,	34},
{14,	19,	23,	21,	35},
{13,	31,	33,	3,	28},
{13,	31,	32,	7,	24},
{14,	31,	31,	10,	14},
{16,	31,	31,	8,	20},
{13,	32,	35,	1,	18},
{16,	32,	33,	1,	23},
{15,	32,	34,	0,	28},
{15,	32,	32,	2,	8},
{14,	31,	35,	0,	30},
{13,	9,	33,	13,	39},
{13,	12,	30,	29,	34},
{13,	25,	30,	26,	16},
{15,	26,	29,	25,	7},
{14,	26,	29,	25,	11},
{14,	26,	29,	26,	2},
{13,	10,	33,	19,	38},
{14,	10,	35,	13,	38},
{13,	25,	33,	21,	26},
{13,	29,	22,	16,	39},
{13,	2,	38,	18,	36},
{13,	39,	17,	26,	35},
{14,	24,	19,	23,	34},
{13,	8,	23,	34,	32},
{16,	10,	24,	33,	32},
{13,	11,	21,	31,	34},
{13,	25,	26,	23,	32},
{15,	25,	24,	25,	31},
{14,	27,	21,	23,	32},
{13,	15,	18,	33,	33},
{14,	18,	16,	31,	33},
{13,	28,	30,	2,	38},
{16,	27,	33,	2,	35},
{15,	27,	29,	5,	35},
{14,	27,	30,	4,	37},
{14,	28,	29,	3,	37},
{13,	1,	35,	16,	38},
{13,	4,	24,	29,	36},
{13,	31,	30,	2,	35},
{16,	31,	28,	3,	34},
{14,	31,	31,	1,	35},
{14,	29,	30,	1,	36},
{13,	33,	27,	2,	35},
{17,	32,	27,	4,	33},
{16,	32,	26,	5,	34},
{16,	34,	26,	1,	33},
{14,	33,	26,	6,	31},
{14,	33,	27,	4,	31},
{13,	18,	38,	4,	38},
{16,	18,	36,	4,	39},
{14,	10,	36,	10,	39},
{13,	16,	30,	36,	8},
{14,	18,	26,	36,	0},
{14,	16,	35,	36,	0},
{13,	20,	38,	7,	34},
{16,	21,	38,	6,	34},
{16,	19,	39,	7,	33},
{14,	23,	37,	6,	33},
{14,	24,	39,	3,	33},
{13,	20,	38,	12,	31},
{14,	20,	34,	15,	32},
{14,	19,	38,	8,	34},
{13,	29,	21,	27,	30},
{15,	29,	18,	26,	31},
{15,	29,	22,	25,	28},
{14,	30,	19,	23,	31},
{14,	29,	24,	26,	25},
{14,	29,	21,	28,	25},
{13,	20,	32,	8,	39},
{13,	26,	27,	28,	12},
{15,	25,	27,	27,	22},
{13,	39,	15,	24,	37},
{14,	23,	16,	24,	37},
{14,	21,	16,	26,	37},
{14,	23,	13,	23,	38},
{13,	30,	34,	11,	1},
{13,	22,	17,	33,	28},
{16,	21,	19,	33,	13},
{17,	21,	19,	32,	23},
{15,	19,	24,	32,	20},
{13,	31,	34,	3,	26},
{13,	27,	25,	19,	33},
{13,	3,	19,	39,	1},
{14,	6,	17,	38,	2},
{13,	18,	20,	30,	34},
{15,	19,	25,	30,	29},
{14,	17,	18,	31,	34},
{14,	18,	29,	30,	28},
{14,	14,	31,	29,	30},
{13,	22,	18,	28,	35},
{16,	23,	21,	27,	32},
{15,	28,	17,	27,	35},
{15,	24,	19,	25,	33},
{15,	20,	19,	28,	34},
{15,	23,	20,	28,	32},
{14,	25,	19,	28,	32},
{13,	9,	30,	35,	22},
{13,	21,	34,	23,	30},
{14,	21,	32,	19,	32},
{14,	21,	34,	12,	32},
{13,	33,	23,	7,	38},
{13,	30,	30,	1,	37},
{14,	29,	27,	4,	37},
{14,	29,	28,	2,	37},
{13,	32,	28,	13,	1},
{13,	26,	32,	16,	30},
{14,	26,	29,	16,	31},
{13,	29,	27,	18,	29},
{13,	29,	26,	17,	31},
{14,	28,	25,	19,	31},
{13,	6,	39,	31,	19},
{13,	4,	39,	32,	9},
{13,	21,	34,	19,	31},
{14,	21,	35,	15,	31},
{14,	20,	35,	23,	30},
{14,	21,	33,	16,	32},
{13,	24,	35,	16,	30},
{13,	23,	34,	22,	30},
{14,	23,	35,	18,	30},
{13,	22,	28,	29,	12},
{13,	25,	37,	13,	27},
{13,	28,	29,	15,	30},
{13,	28,	30,	10,	33},
{14,	27,	30,	13,	31},
{15,	26,	30,	13,	32},
{14,	25,	29,	13,	34},
{14,	26,	31,	10,	32},
{13,	29,	30,	10,	32},
{13,	29,	32,	13,	29},
{15,	29,	29,	13,	30},
{14,	29,	34,	7,	29},
{13,	26,	30,	12,	34},
{15,	21,	30,	12,	35},
{14,	27,	29,	10,	34},
{13,	26,	30,	21,	24},
{13,	30,	21,	21,	32},
{15,	29,	22,	18,	32},
{13,	29,	22,	19,	36},
{17,	30,	21,	19,	33},
{14,	28,	24,	19,	33},
{15,	28,	23,	17,	34},
{14,	30,	20,	17,	35},
{13,	32,	21,	19,	33},
{13,	29,	25,	17,	33},
{13,	28,	23,	18,	36},
{14,	29,	23,	15,	35},
{13,	26,	38,	6,	5},
{13,	32,	30,	10,	0},
{13,	32,	30,	7,	23},
{13,	32,	29,	8,	21},
{14,	33,	28,	8,	5},
{16,	33,	29,	9,	0},
{13,	20,	30,	30,	17},
{14,	22,	28,	30,	8},
{15,	23,	28,	30,	4},
{13,	22,	29,	18,	34},
{16,	19,	30,	17,	35},
{14,	19,	30,	19,	34},
{13,	28,	25,	15,	35},
{13,	23,	17,	30,	34},
{14,	20,	18,	30,	34},
{14,	19,	16,	31,	34},
{14,	21,	14,	31,	34},
{14,	20,	12,	35,	32},
{13,	19,	36,	29,	8},
{15,	19,	36,	28,	14},
{13,	27,	32,	15,	30},
{13,	28,	32,	9,	33},
{16,	28,	31,	10,	32},
{13,	24,	31,	17,	33},
{16,	25,	31,	17,	31},
{13,	26,	22,	18,	37},
{15,	24,	23,	18,	37},
{13,	29,	29,	13,	31},
{14,	28,	27,	15,	31},
{14,	28,	31,	11,	31},
{15,	27,	31,	13,	31},
{13,	6,	32,	31,	31},
{13,	27,	28,	8,	35},
{16,	27,	29,	6,	35},
{15,	26,	28,	10,	35},
{15,	25,	29,	6,	36},
{13,	39,	20,	24,	9},
{14,	32,	22,	22,	5},
{13,	24,	39,	13,	26},
{15,	24,	39,	5,	31},
{14,	25,	39,	6,	25},
{13,	19,	24,	26,	33},
{13,	30,	20,	29,	2},
{15,	30,	21,	27,	3},
{14,	30,	21,	26,	6},
{14,	30,	20,	30,	1},
{13,	30,	21,	25,	29},
{13,	15,	25,	17,	39},
{13,	6,	34,	24,	34},
{13,	24,	35,	24,	2},
{14,	24,	35,	22,	12},
{14,	24,	34,	22,	19},
{13,	7,	38,	2,	39},
{13,	39,	24,	6,	8},
{13,	18,	17,	37,	2},
{14,	16,	11,	37,	25},
{16,	18,	15,	37,	7},
{14,	39,	9,	37,	25},
{14,	18,	15,	38,	0},
{13,	22,	33,	4,	39},
{13,	31,	27,	4,	35},
{13,	29,	35,	10,	0},
{16,	31,	35,	3,	0},
{13,	29,	35,	4,	22},
{15,	29,	37,	3,	5},
{16,	30,	36,	2,	3},
{15,	29,	35,	2,	30},
{14,	29,	39,	1,	8},
{13,	17,	34,	31,	26},
{14,	17,	29,	31,	28},
{13,	15,	33,	25,	32},
{15,	14,	30,	25,	34},
{14,	16,	31,	26,	32},
{16,	15,	30,	26,	33},
{14,	15,	29,	30,	32},
{14,	14,	28,	28,	33},
{14,	14,	31,	30,	31},
{13,	15,	38,	26,	30},
{14,	13,	32,	29,	32},
{13,	15,	36,	26,	31},
{14,	18,	34,	23,	31},
{14,	12,	37,	22,	32},
{14,	17,	36,	19,	31},
{13,	29,	30,	8,	33},
{13,	18,	24,	36,	5},
{15,	19,	19,	36,	6},
{14,	17,	26,	36,	5},
{13,	33,	24,	13,	29},
{17,	33,	27,	13,	26},
{13,	33,	27,	11,	29},
{13,	26,	36,	18,	0},
{13,	13,	27,	30,	35},
{14,	13,	23,	29,	36},
{13,	29,	21,	20,	34},
{13,	27,	27,	26,	3},
{14,	27,	29,	26,	0},
{14,	27,	27,	25,	10},
{13,	27,	23,	16,	37},
{13,	9,	30,	31,	32},
{13,	29,	39,	0,	31},
{14,	26,	39,	2,	25},
{13,	24,	39,	19,	11},
{13,	34,	25,	13,	3},
{13,	30,	19,	23,	32},
{14,	39,	18,	22,	34},
{13,	27,	21,	17,	37},
{13,	28,	20,	19,	37},
{13,	31,	31,	13,	0},
{13,	19,	27,	20,	36},
{13,	32,	27,	12,	29},
{13,	7,	26,	33,	31},
{15,	5,	25,	33,	32},
{13,	30,	29,	10,	30},
{14,	30,	29,	7,	31},
{14,	31,	29,	7,	30},
{13,	16,	27,	36,	16},
{13,	15,	38,	17,	31},
{14,	16,	37,	21,	31},
{13,	16,	39,	13,	34},
{14,	14,	38,	16,	34},
{13,	11,	39,	16,	34},
{15,	9,	39,	17,	32},
{15,	7,	39,	18,	33},
{13,	28,	33,	3,	34},
{14,	27,	32,	3,	35},
{13,	34,	30,	0,	25},
{13,	35,	32,	0,	24},
{15,	33,	33,	0,	26},
{13,	35,	29,	0,	31},
{13,	39,	13,	34,	20},
{13,	29,	23,	22,	30},
{13,	30,	25,	6,	37},
{13,	25,	18,	27,	34},
{13,	19,	20,	22,	37},
{13,	25,	28,	7,	37},
{14,	25,	29,	6,	37},
{13,	29,	27,	7,	37},
{14,	27,	26,	7,	38},
{13,	26,	26,	12,	38},
{13,	23,	26,	8,	39},
{14,	22,	28,	6,	39},
{13,	24,	26,	7,	39},
{13,	28,	28,	2,	39},
{14,	27,	30,	2,	39},
{13,	16,	38,	36,	0},
{13,	10,	37,	11,	37},
{15,	8,	37,	10,	38},
{13,	10,	38,	7,	37},
{14,	8,	39,	6,	37},
{15,	15,	39,	3,	36},
{14,	15,	38,	5,	36},
{13,	24,	35,	17,	30},
{13,	16,	39,	27,	17},
{14,	17,	39,	27,	11},
{13,	28,	34,	4,	32},
{14,	26,	34,	5,	33},
{13,	27,	34,	6,	32},
{13,	32,	33,	0,	31},
{13,	32,	30,	0,	39},
{14,	32,	25,	1,	39},
{13,	33,	29,	0,	39},
{13,	30,	34,	12,	0},
{13,	20,	33,	19,	32},
{13,	26,	16,	26,	36},
{13,	20,	33,	27,	25},
{13,	26,	26,	24,	29},
{13,	26,	20,	29,	30},
{13,	24,	22,	30,	29},
{14,	20,	19,	31,	30},
{14,	25,	22,	29,	29},
{13,	20,	22,	32,	30},
{16,	18,	21,	34,	28},
{15,	19,	16,	33,	32},
{14,	20,	23,	32,	27},
{14,	22,	20,	32,	9},
{14,	17,	16,	34,	32},
{14,	20,	20,	34,	7},
{14,	22,	17,	32,	30},
{13,	21,	23,	32,	19},
{14,	21,	26,	32,	1},
{14,	21,	24,	32,	11},
{14,	21,	23,	33,	1},
{13,	19,	22,	33,	25},
{15,	21,	19,	33,	21},
{13,	23,	19,	30,	32},
{15,	23,	22,	30,	30},
{13,	19,	20,	30,	34},
{13,	21,	21,	34,	2},
{13,	21,	22,	32,	24},
{13,	30,	31,	5,	32},
{13,	30,	33,	6,	28},
{13,	20,	36,	5,	36},
{13,	19,	32,	31,	2},
{13,	26,	37,	10,	0},
{13,	24,	26,	28,	27},
{14,	25,	25,	28,	27},
{14,	25,	24,	29,	27},
{13,	23,	26,	25,	31},
{13,	6,	38,	34,	22},
{13,	23,	33,	12,	32},
{14,	22,	33,	14,	32},
{14,	22,	32,	18,	32},
{13,	14,	27,	13,	39},
{14,	10,	32,	13,	39},
{13,	31,	22,	23,	9},
{13,	21,	14,	37,	6},
{14,	20,	18,	37,	1},
{13,	11,	26,	37,	0},
{13,	9,	39,	37,	0},
{15,	11,	34,	37,	0},
{13,	26,	39,	6,	2},
{13,	34,	28,	1,	6},
{13,	35,	29,	1,	1},
{13,	25,	31,	18,	30},
{13,	25,	32,	16,	31},
{13,	27,	32,	13,	31},
{13,	32,	25,	10,	31},
{13,	17,	33,	35,	1},
{13,	39,	23,	5,	37},
{13,	26,	24,	16,	37},
{13,	26,	27,	27,	22},
{13,	25,	24,	20,	33},
{13,	22,	30,	11,	36},
{13,	33,	27,	7,	30},
{13,	16,	34,	30,	27},
{16,	16,	31,	30,	29},
{13,	25,	25,	24,	32},
{13,	12,	27,	32,	32},
{13,	21,	17,	31,	34},
{13,	27,	16,	24,	36},
{13,	15,	39,	28,	17},
{13,	15,	39,	30,	7},
{14,	16,	39,	29,	1},
{13,	31,	29,	12,	26},
{13,	28,	28,	7,	35},
{13,	11,	39,	1,	38},
{13,	19,	37,	29,	0},
{13,	39,	23,	16,	3},
{13,	29,	31,	15,	0},
{13,	31,	36,	2,	3},
{13,	27,	22,	27,	29},
{13,	19,	31,	29,	24},
{13,	22,	27,	29,	24},
{14,	22,	28,	30,	16},
{13,	26,	23,	23,	31},
{14,	28,	23,	21,	31},
{13,	23,	17,	32,	25},
{13,	25,	18,	32,	18},
{15,	25,	16,	31,	29},
{15,	25,	19,	31,	15},
{14,	24,	19,	34,	0},
{13,	24,	19,	32,	11},
{13,	13,	23,	36,	25},
{13,	30,	29,	5,	33},
{13,	9,	25,	21,	39},
{13,	32,	21,	23,	7},
{13,	28,	37,	3,	11},
{13,	39,	12,	35,	28},
{13,	18,	31,	29,	27},
{14,	18,	31,	31,	26},
{13,	19,	29,	25,	31},
{13,	16,	35,	20,	33},
{14,	14,	36,	22,	32},
{13,	14,	36,	19,	33},
{14,	13,	37,	18,	33},
{13,	19,	32,	30,	22},
{13,	21,	27,	30,	23},
{13,	15,	36,	17,	33},
{13,	23,	22,	20,	35},
{13,	18,	22,	25,	35},
{13,	26,	35,	5,	31},
{13,	22,	14,	23,	38},
{13,	25,	31,	25,	1},
{13,	27,	22,	30,	1},
{13,	22,	23,	31,	3},
{13,	22,	25,	32,	2},
{14,	22,	28,	32,	0},
{14,	22,	26,	32,	2},
{13,	25,	22,	32,	9},
{17,	23,	26,	32,	0},
{14,	25,	24,	32,	0},
{14,	23,	23,	32,	3},
{13,	39,	11,	32,	33},
{13,	19,	17,	32,	33},
{13,	30,	20,	25,	30},
{13,	17,	28,	30,	30},
{13,	21,	33,	20,	31},
{13,	19,	21,	29,	33},
{13,	25,	37,	10,	28},
{13,	17,	19,	34,	30},
{13,	8,	37,	19,	35},
{13,	25,	36,	4,	32},
{13,	17,	13,	32,	34},
{13,	18,	22,	17,	39},
{13,	17,	38,	28,	11},
{13,	30,	34,	1,	29},
{13,	31,	32,	4,	26},
{13,	11,	37,	6,	38},
{14,	11,	39,	5,	37},
{13,	0,	26,	35,	23},
{13,	13,	18,	38,	1},
{13,	9,	18,	39,	1},
{13,	35,	26,	3,	2},
{13,	39,	13,	26,	37},
{13,	13,	35,	29,	30},
{13,	23,	26,	29,	27},
{13,	14,	30,	32,	29},
{13,	26,	20,	30,	28},
{13,	39,	22,	14,	29},
{13,	24,	17,	29,	34},
{13,	13,	32,	22,	36},
{13,	28,	28,	16,	30},
{13,	28,	27,	19,	30},
{13,	27,	25,	16,	34},
{13,	28,	24,	16,	35},
{13,	28,	24,	17,	34},
{13,	16,	26,	26,	33},
{13,	18,	18,	32,	33},
{13,	14,	25,	34,	27},
{13,	23,	20,	23,	33},
{13,	18,	20,	26,	35},
{13,	30,	32,	8,	28},
{13,	23,	36,	8,	31},
{14,	22,	37,	10,	30},
{13,	24,	36,	10,	30},
{14,	24,	37,	7,	31},
{13,	27,	35,	6,	31},
{13,	22,	28,	30,	17},
{13,	21,	28,	30,	19},
{13,	20,	33,	29,	20},
{13,	31,	31,	2,	33},
{13,	23,	34,	1,	39},
{13,	24,	33,	1,	39},
{14,	24,	35,	1,	38},
{13,	23,	37,	2,	36},
{13,	32,	28,	1,	35},
{13,	39,	8,	39,	8},
{13,	16,	8,	36,	32},
{13,	16,	38,	31,	4},
{13,	39,	20,	25,	5},
{13,	4,	13,	35,	32},
{13,	33,	35,	0,	15},
{13,	19,	29,	34,	0},
{13,	29,	21,	29,	2},
{14,	30,	21,	30,	1},
{13,	32,	28,	9,	4},
{13,	32,	28,	13,	3},
{13,	32,	30,	10,	2},
{13,	32,	30,	8,	9},
{13,	39,	18,	28,	28},
{13,	26,	21,	29,	30},
{13,	20,	31,	27,	27},
{13,	15,	30,	27,	33},
{13,	23,	27,	22,	32},
{13,	21,	27,	23,	32},
{13,	19,	29,	23,	32},
{13,	17,	33,	23,	32},
{13,	11,	28,	31,	33},
{13,	22,	28,	16,	37},
{13,	14,	23,	29,	36},
{14,	14,	24,	30,	35},
{13,	21,	21,	22,	35},
{13,	31,	27,	9,	31},
{13,	24,	34,	7,	33},
{13,	14,	19,	32,	33},
{13,	20,	11,	34,	33},
{13,	19,	31,	12,	36},
{13,	19,	31,	16,	35},
{13,	19,	31,	17,	34},
{13,	20,	29,	12,	37},
{13,	22,	29,	12,	36},
{13,	22,	21,	17,	38},
{13,	6,	39,	18,	34},
{13,	30,	24,	3,	39},
{13,	19,	29,	32,	12},
{13,	16,	39,	29,	4},
{13,	17,	39,	29,	3},
{13,	17,	39,	28,	9},
{13,	23,	27,	30,	7},
{13,	24,	36,	22,	1},
{13,	24,	25,	32,	0},
{13,	22,	20,	34,	2},
{14,	22,	15,	36,	6},
{15,	22,	15,	35,	18},
{13,	22,	19,	35,	9},
{14,	21,	16,	35,	27},
{15,	23,	15,	34,	24},
{13,	20,	23,	34,	10},
{14,	20,	23,	35,	4},
{14,	20,	26,	34,	0},
{13,	22,	18,	36,	6},
{13,	21,	24,	33,	4},
{14,	20,	24,	35,	1},
{13,	20,	21,	33,	21},
{13,	21,	25,	33,	3},
{13,	22,	19,	34,	11},
{13,	23,	19,	34,	1},
{13,	22,	20,	35,	4},
{14,	22,	20,	34,	8},
{13,	21,	23,	35,	3},
{14,	21,	22,	34,	8},
{13,	18,	39,	29,	0},
{13,	6,	19,	39,	1},
{12,	30,	33,	30,	27},
{17,	20,	35,	30,	16},
{17,	24,	34,	26,	6},
{17,	26,	32,	23,	29},
{16,	24,	35,	22,	26},
{15,	22,	34,	28,	2},
{15,	22,	30,	31,	0},
{15,	39,	16,	30,	31},
{15,	22,	29,	27,	28},
{15,	19,	35,	31,	0},
{15,	26,	33,	22,	28},
{14,	32,	28,	16,	0},
{14,	26,	34,	22,	0},
{14,	27,	34,	20,	1},
{14,	28,	17,	30,	31},
{14,	28,	31,	22,	28},
{14,	26,	32,	24,	29},
{14,	27,	28,	24,	29},
{14,	26,	33,	24,	28},
{14,	24,	34,	23,	14},
{14,	31,	27,	19,	2},
{13,	31,	30,	16,	26},
{16,	31,	30,	7,	28},
{13,	27,	35,	21,	26},
{17,	26,	34,	22,	5},
{14,	26,	34,	23,	2},
{14,	26,	35,	22,	0},
{13,	22,	34,	30,	16},
{18,	22,	34,	28,	22},
{13,	26,	32,	26,	29},
{13,	29,	30,	19,	29},
{13,	22,	35,	27,	26},
{14,	22,	34,	28,	25},
{13,	21,	36,	28,	23},
{14,	22,	35,	28,	16},
{13,	31,	27,	19,	21},
{13,	21,	34,	32,	0},
{13,	26,	34,	26,	1},
{13,	19,	33,	32,	9},
{14,	19,	32,	31,	12},
{13,	30,	26,	19,	28},
{14,	30,	22,	27,	28},
{13,	27,	33,	25,	28},
{13,	21,	31,	32,	1},
{13,	21,	35,	30,	8},
{13,	30,	22,	21,	31},
{13,	26,	34,	23,	8},
{15,	25,	34,	24,	6},
{13,	25,	34,	23,	23},
{13,	32,	22,	18,	28},
{16,	31,	25,	17,	27},
{16,	39,	22,	18,	27},
{13,	25,	35,	22,	22},
{14,	26,	35,	22,	5},
{13,	25,	35,	24,	2},
{14,	25,	35,	25,	0},
{13,	21,	34,	30,	20},
{13,	31,	31,	7,	26},
{13,	28,	31,	24,	28},
{13,	19,	35,	31,	6},
{13,	31,	31,	5,	29},
{13,	26,	34,	21,	28},
{13,	20,	36,	30,	0},
{13,	21,	34,	31,	1},
{13,	39,	19,	27,	27},
{13,	31,	31,	7,	28},
{13,	19,	35,	27,	28},
{13,	22,	28,	32,	1},
{13,	28,	26,	25,	28},
{13,	25,	26,	25,	30},
{13,	31,	31,	8,	25},
{13,	31,	32,	5,	27},
{13,	31,	31,	14,	0},
{12,	28,	22,	26,	39},
{16,	28,	19,	27,	33},
{15,	27,	23,	20,	33},
{15,	39,	17,	26,	38},
{15,	21,	19,	28,	35},
{15,	29,	20,	21,	35},
{14,	27,	23,	23,	33},
{15,	23,	25,	22,	33},
{14,	22,	23,	26,	33},
{14,	39,	18,	23,	34},
{14,	39,	18,	22,	36},
{14,	30,	20,	23,	32},
{14,	29,	22,	23,	31},
{14,	19,	27,	20,	37},
{13,	22,	27,	19,	38},
{16,	11,	31,	17,	38},
{16,	16,	30,	13,	38},
{16,	16,	23,	21,	38},
{15,	14,	32,	12,	38},
{15,	11,	33,	17,	38},
{15,	12,	34,	13,	38},
{14,	17,	28,	15,	38},
{16,	13,	28,	19,	38},
{13,	19,	19,	30,	36},
{13,	14,	32,	16,	38},
{13,	13,	30,	13,	39},
{13,	29,	22,	23,	33},
{14,	29,	21,	25,	32},
{13,	21,	21,	28,	34},
{14,	24,	21,	27,	33},
{14,	26,	20,	28,	32},
{13,	27,	23,	25,	32},
{15,	28,	25,	25,	29},
{14,	26,	26,	24,	30},
{14,	28,	23,	24,	31},
{13,	26,	24,	23,	32},
{16,	26,	26,	22,	31},
{13,	15,	25,	19,	39},
{13,	28,	20,	27,	33},
{13,	27,	23,	26,	31},
{13,	16,	29,	15,	38},
{13,	29,	20,	21,	36},
{13,	30,	21,	21,	33},
{13,	18,	18,	28,	37},
{13,	12,	33,	10,	39},
{13,	28,	23,	22,	32},
{13,	28,	23,	21,	33},
{13,	29,	18,	23,	35},
{13,	14,	34,	11,	38},
{13,	22,	22,	27,	33},
{12,	12,	39,	38,	17},
{17,	6,	20,	39,	1},
{16,	1,	39,	32,	19},
{15,	3,	23,	38,	18},
{15,	12,	39,	34,	18},
{15,	13,	21,	37,	7},
{16,	13,	24,	38,	2},
{16,	17,	21,	37,	1},
{15,	13,	23,	37,	12},
{14,	10,	20,	37,	20},
{17,	12,	17,	38,	20},
{16,	13,	15,	37,	25},
{16,	3,	23,	37,	19},
{15,	2,	24,	37,	19},
{14,	2,	19,	37,	23},
{15,	5,	16,	38,	23},
{14,	11,	18,	37,	26},
{16,	9,	17,	37,	27},
{16,	10,	16,	38,	25},
{14,	13,	29,	37,	8},
{15,	14,	28,	37,	2},
{14,	13,	39,	31,	19},
{14,	13,	27,	38,	3},
{14,	19,	16,	37,	8},
{13,	10,	28,	39,	0},
{15,	6,	21,	39,	1},
{13,	14,	39,	36,	7},
{13,	15,	39,	35,	7},
{15,	16,	39,	31,	2},
{13,	22,	17,	37,	4},
{13,	13,	26,	37,	17},
{13,	13,	26,	38,	6},
{13,	13,	24,	38,	9},
{13,	16,	24,	37,	0},
{12,	25,	39,	30,	27},
{16,	25,	34,	24,	28},
{15,	17,	39,	33,	0},
{15,	18,	36,	28,	28},
{14,	11,	39,	29,	28},
{14,	25,	36,	23,	28},
{14,	24,	36,	26,	28},
{14,	24,	38,	7,	30},
{13,	18,	38,	34,	15},
{18,	18,	39,	32,	2},
{15,	17,	38,	31,	23},
{14,	16,	39,	32,	8},
{14,	17,	39,	31,	19},
{14,	16,	39,	34,	7},
{15,	17,	39,	34,	2},
{13,	25,	37,	26,	28},
{14,	25,	39,	11,	28},
{13,	16,	39,	35,	6},
{13,	26,	34,	24,	9},
{13,	17,	39,	34,	6},
{13,	17,	37,	34,	21},
{13,	18,	39,	31,	18},
{13,	15,	38,	31,	27},
{13,	18,	37,	31,	26},
{12,	26,	30,	34,	27},
{20,	17,	35,	34,	26},
{17,	25,	22,	32,	28},
{16,	39,	17,	32,	2},
{16,	27,	18,	34,	1},
{16,	21,	31,	32,	4},
{14,	24,	22,	32,	29},
{14,	19,	31,	32,	26},
{14,	28,	18,	34,	2},
{14,	26,	17,	33,	29},
{14,	15,	34,	34,	27},
{14,	21,	34,	31,	2},
{14,	25,	20,	33,	28},
{15,	22,	20,	34,	28},
{14,	26,	18,	34,	28},
{14,	22,	24,	35,	0},
{13,	21,	26,	35,	3},
{14,	20,	25,	35,	5},
{13,	18,	27,	31,	30},
{13,	21,	32,	31,	10},
{13,	27,	21,	31,	2},
{13,	31,	21,	31,	0},
{13,	20,	17,	35,	28},
{13,	30,	22,	31,	0},
{13,	18,	36,	33,	26},
{13,	21,	27,	35,	0},
{13,	24,	17,	32,	30},
{13,	23,	17,	31,	32},
{13,	22,	12,	35,	31},
{13,	18,	29,	35,	2},
{13,	29,	18,	33,	1},
{13,	15,	30,	32,	29},
{12,	11,	35,	24,	38},
{16,	12,	24,	23,	38},
{15,	14,	24,	22,	38},
{15,	13,	24,	24,	37},
{15,	13,	28,	24,	36},
{15,	13,	26,	24,	37},
{15,	12,	32,	23,	37},
{14,	12,	35,	23,	34},
{13,	4,	36,	18,	37},
{13,	10,	36,	24,	34},
{13,	4,	27,	27,	36},
{13,	13,	35,	20,	34},
{14,	13,	37,	17,	34},
{13,	15,	36,	17,	34},
{13,	12,	34,	16,	38},
{12,	34,	32,	7,	27},
{18,	33,	31,	8,	0},
{17,	33,	30,	5,	28},
{17,	35,	26,	8,	0},
{17,	32,	34,	1,	27},
{16,	33,	32,	0,	31},
{16,	32,	31,	8,	5},
{15,	33,	30,	3,	29},
{16,	32,	31,	4,	29},
{14,	32,	30,	7,	29},
{14,	34,	26,	8,	18},
{14,	34,	30,	0,	33},
{14,	35,	32,	0,	27},
{14,	35,	32,	1,	0},
{14,	33,	34,	1,	1},
{13,	34,	33,	2,	21},
{15,	32,	34,	2,	10},
{14,	33,	33,	2,	25},
{13,	34,	26,	10,	7},
{14,	34,	26,	12,	0},
{13,	31,	30,	7,	31},
{13,	32,	33,	3,	24},
{15,	32,	34,	3,	7},
{13,	34,	26,	13,	3},
{13,	34,	33,	3,	2},
{13,	30,	31,	9,	29},
{13,	34,	26,	8,	27},
{13,	35,	29,	4,	0},
{15,	35,	29,	3,	1},
{13,	33,	30,	0,	36},
{13,	33,	30,	7,	28},
{13,	33,	33,	0,	31},
{12,	27,	39,	19,	24},
{16,	28,	37,	5,	2},
{16,	28,	36,	4,	15},
{15,	27,	39,	3,	27},
{15,	27,	36,	6,	26},
{15,	26,	36,	16,	26},
{14,	28,	37,	3,	24},
{13,	28,	37,	7,	11},
{14,	29,	37,	6,	0},
{14,	29,	36,	4,	4},
{13,	28,	36,	10,	9},
{17,	28,	37,	8,	10},
{14,	28,	37,	9,	4},
{13,	28,	37,	6,	17},
{15,	28,	36,	9,	13},
{13,	28,	36,	6,	29},
{14,	26,	36,	19,	27},
{13,	29,	37,	2,	26},
{13,	30,	39,	1,	12},
{15,	30,	39,	0,	24},
{13,	31,	37,	1,	24},
{14,	30,	37,	2,	24},
{14,	32,	38,	1,	0},
{13,	31,	36,	2,	23},
{13,	29,	38,	5,	0},
{13,	28,	36,	9,	18},
{13,	31,	35,	2,	26},
{12,	23,	36,	18,	36},
{16,	21,	28,	19,	36},
{16,	19,	28,	19,	37},
{15,	19,	35,	19,	33},
{15,	12,	35,	23,	36},
{15,	15,	37,	10,	35},
{15,	25,	32,	17,	31},
{15,	15,	38,	7,	35},
{14,	20,	36,	23,	30},
{14,	16,	35,	20,	35},
{14,	14,	38,	7,	36},
{14,	22,	36,	3,	37},
{13,	18,	38,	10,	35},
{16,	7,	38,	15,	36},
{14,	17,	38,	8,	36},
{14,	9,	38,	10,	37},
{13,	18,	37,	19,	31},
{16,	18,	38,	16,	31},
{14,	18,	37,	14,	32},
{13,	24,	34,	16,	31},
{15,	24,	36,	11,	31},
{13,	23,	32,	19,	32},
{14,	22,	29,	20,	32},
{13,	17,	35,	6,	38},
{14,	14,	36,	5,	39},
{14,	14,	36,	6,	38},
{13,	14,	35,	18,	37},
{15,	18,	35,	8,	37},
{14,	19,	35,	5,	38},
{15,	19,	34,	8,	38},
{14,	22,	34,	5,	37},
{13,	18,	37,	16,	33},
{13,	18,	37,	13,	35},
{13,	19,	29,	19,	37},
{13,	21,	37,	10,	33},
{13,	21,	39,	10,	31},
{13,	24,	38,	3,	35},
{13,	11,	38,	13,	36},
{13,	16,	37,	17,	33},
{13,	18,	38,	20,	30},
{13,	22,	29,	21,	32},
{13,	13,	35,	12,	38},
{14,	17,	35,	8,	38},
{13,	23,	37,	10,	32},
{13,	23,	37,	13,	31},
{13,	11,	38,	6,	38},
{13,	19,	38,	6,	35},
{13,	18,	38,	13,	33},
{13,	12,	34,	24,	36},
{13,	14,	37,	18,	34},
{13,	13,	35,	8,	39},
{13,	18,	35,	23,	31},
{13,	17,	38,	17,	31},
{13,	15,	38,	12,	35},
{12,	24,	18,	30,	38},
{16,	39,	15,	28,	37},
{14,	10,	19,	27,	38},
{14,	25,	18,	28,	35},
{13,	25,	16,	30,	35},
{12,	39,	28,	24,	0},
{17,	31,	25,	26,	0},
{16,	32,	24,	21,	1},
{16,	33,	23,	19,	7},
{15,	34,	27,	10,	1},
{14,	39,	23,	20,	1},
{15,	39,	22,	23,	1},
{14,	34,	27,	9,	7},
{14,	39,	22,	25,	0},
{13,	31,	26,	25,	0},
{13,	32,	24,	22,	1},
{13,	39,	26,	1,	1},
{13,	32,	23,	22,	2},
{12,	32,	30,	16,	31},
{14,	28,	31,	16,	30},
{14,	32,	23,	14,	32},
{16,	30,	23,	16,	33},
{14,	31,	23,	15,	33},
{14,	32,	28,	2,	35},
{14,	30,	24,	14,	33},
{13,	33,	28,	10,	26},
{13,	33,	30,	8,	28},
{14,	33,	29,	9,	21},
{13,	31,	29,	8,	32},
{13,	32,	30,	2,	35},
{13,	32,	30,	4,	32},
{13,	33,	29,	3,	32},
{13,	32,	31,	5,	30},
{13,	33,	26,	5,	33},
{13,	30,	23,	17,	31},
{13,	32,	31,	6,	29},
{13,	27,	31,	15,	31},
{13,	32,	28,	4,	33},
{12,	12,	37,	30,	34},
{15,	13,	37,	28,	31},
{14,	13,	37,	20,	34},
{14,	13,	36,	22,	34},
{15,	16,	35,	21,	35},
{13,	1,	38,	20,	34},
{13,	3,	36,	31,	30},
{13,	18,	35,	21,	34},
{12,	39,	23,	13,	39},
{19,	34,	24,	12,	10},
{17,	34,	24,	11,	25},
{14,	39,	23,	15,	5},
{14,	34,	25,	12,	6},
{15,	34,	25,	11,	16},
{13,	39,	23,	15,	10},
{13,	34,	24,	12,	22},
{13,	33,	24,	13,	30},
{12,	27,	33,	7,	39},
{16,	28,	32,	6,	34},
{16,	28,	28,	7,	37},
{16,	28,	32,	1,	38},
{15,	25,	35,	4,	37},
{15,	26,	26,	8,	39},
{14,	24,	30,	8,	38},
{14,	24,	28,	13,	38},
{14,	27,	30,	8,	35},
{14,	24,	34,	7,	35},
{14,	21,	32,	8,	39},
{13,	26,	26,	13,	39},
{13,	28,	28,	7,	38},
{15,	28,	28,	3,	39},
{13,	29,	28,	6,	37},
{14,	29,	28,	7,	36},
{13,	28,	32,	2,	38},
{13,	28,	31,	7,	34},
{12,	11,	20,	39,	27},
{15,	13,	20,	39,	3},
{14,	3,	23,	38,	19},
{14,	13,	11,	39,	22},
{13,	11,	21,	37,	27},
{13,	6,	23,	39,	2},
{13,	6,	22,	39,	5},
{13,	3,	22,	37,	22},
{13,	9,	23,	38,	19},
{13,	18,	13,	39,	1},
{12,	11,	8,	38,	34},
{17,	10,	12,	35,	33},
{15,	16,	8,	36,	34},
{14,	12,	10,	37,	31},
{15,	2,	13,	38,	30},
{13,	2,	13,	37,	31},
{13,	10,	11,	36,	33},
{14,	5,	11,	37,	32},
{13,	15,	13,	35,	33},
{13,	39,	11,	35,	33},
{13,	39,	6,	38,	32},
{13,	15,	11,	36,	33},
{14,	14,	18,	36,	29},
{12,	22,	36,	30,	31},
{16,	23,	23,	30,	30},
{15,	16,	37,	30,	30},
{15,	15,	38,	30,	29},
{15,	19,	21,	30,	34},
{15,	22,	28,	23,	32},
{15,	23,	20,	30,	32},
{15,	19,	37,	28,	29},
{15,	22,	35,	19,	32},
{14,	23,	26,	30,	31},
{14,	24,	28,	29,	28},
{15,	24,	26,	28,	29},
{15,	25,	26,	27,	29},
{14,	25,	30,	27,	28},
{14,	26,	25,	27,	29},
{14,	17,	38,	30,	28},
{14,	15,	34,	32,	28},
{14,	15,	38,	31,	29},
{14,	15,	32,	28,	32},
{14,	25,	23,	28,	30},
{14,	24,	26,	28,	30},
{14,	22,	30,	21,	32},
{13,	22,	26,	29,	32},
{15,	21,	23,	28,	33},
{14,	16,	32,	28,	32},
{14,	23,	26,	27,	32},
{14,	17,	31,	25,	32},
{15,	21,	28,	24,	32},
{13,	23,	35,	21,	32},
{14,	19,	33,	21,	33},
{15,	21,	29,	20,	33},
{13,	14,	38,	29,	30},
{13,	24,	26,	30,	29},
{14,	24,	26,	29,	30},
{13,	26,	23,	28,	31},
{13,	25,	24,	27,	31},
{13,	23,	23,	29,	32},
{13,	17,	26,	30,	32},
{13,	16,	26,	30,	33},
{13,	23,	34,	22,	31},
{13,	18,	28,	27,	32},
{14,	17,	31,	27,	32},
{13,	19,	22,	28,	34},
{12,	28,	33,	17,	33},
{15,	27,	30,	18,	30},
{15,	29,	27,	11,	33},
{14,	27,	30,	19,	30},
{13,	26,	34,	17,	32},
{16,	26,	35,	8,	31},
{14,	26,	35,	16,	30},
{14,	27,	34,	11,	32},
{13,	29,	30,	16,	32},
{13,	29,	26,	14,	34},
{14,	27,	26,	13,	35},
{13,	29,	30,	17,	31},
{13,	26,	29,	16,	34},
{14,	26,	30,	13,	34},
{13,	26,	28,	13,	35},
{13,	24,	33,	13,	34},
{15,	25,	32,	11,	34},
{15,	26,	31,	8,	35},
{13,	26,	26,	15,	36},
{13,	26,	27,	15,	35},
{15,	24,	27,	16,	36},
{13,	24,	29,	16,	36},
{13,	29,	27,	19,	30},
{13,	26,	31,	19,	30},
{13,	27,	26,	16,	34},
{13,	24,	32,	9,	35},
{13,	27,	34,	15,	30},
{13,	24,	32,	19,	30},
{12,	19,	19,	32,	36},
{17,	11,	20,	32,	34},
{15,	16,	23,	31,	32},
{14,	20,	15,	32,	35},
{14,	23,	18,	32,	31},
{13,	8,	21,	32,	34},
{13,	24,	14,	33,	31},
{12,	32,	24,	26,	24},
{15,	31,	22,	21,	28},
{14,	39,	20,	23,	26},
{14,	33,	25,	19,	2},
{13,	35,	25,	25,	0},
{13,	33,	25,	19,	5},
{12,	39,	24,	13,	33},
{17,	34,	27,	7,	29},
{15,	32,	24,	12,	34},
{15,	39,	24,	16,	2},
{14,	34,	25,	5,	33},
{14,	34,	25,	10,	28},
{13,	34,	24,	14,	9},
{13,	34,	26,	2,	33},
{12,	12,	36,	35,	29},
{17,	5,	22,	36,	28},
{15,	10,	37,	35,	23},
{14,	15,	36,	34,	27},
{12,	39,	21,	19,	39},
{14,	29,	20,	21,	37},
{14,	30,	20,	20,	37},
{13,	30,	20,	22,	36},
{14,	30,	21,	21,	34},
{13,	30,	20,	21,	38},
{12,	27,	35,	28,	26},
{12,	24,	27,	18,	39},
{16,	24,	27,	19,	34},
{16,	23,	27,	19,	38},
{14,	26,	24,	17,	35},
{14,	24,	27,	19,	35},
{14,	25,	23,	16,	39},
{13,	16,	30,	13,	39},
{13,	23,	28,	13,	39},
{14,	24,	30,	8,	39},
{14,	21,	29,	10,	39},
{15,	21,	30,	9,	39},
{14,	23,	31,	8,	39},
{13,	26,	26,	17,	34},
{13,	10,	32,	16,	39},
{13,	25,	27,	19,	33},
{13,	26,	27,	19,	32},
{13,	17,	25,	19,	39},
{13,	26,	27,	18,	33},
{13,	24,	29,	9,	39},
{13,	14,	31,	10,	39},
{12,	8,	34,	33,	33},
{16,	12,	33,	32,	31},
{14,	12,	30,	33,	31},
{13,	11,	21,	33,	34},
{13,	13,	35,	31,	31},
{13,	9,	35,	33,	31},
{13,	16,	11,	34,	34},
{14,	15,	19,	33,	34},
{13,	9,	32,	32,	33},
{13,	12,	25,	33,	32},
{12,	23,	26,	24,	37},
{19,	22,	27,	21,	35},
{18,	16,	23,	30,	35},
{17,	15,	29,	25,	34},
{16,	18,	26,	27,	33},
{16,	15,	26,	25,	36},
{15,	17,	30,	22,	35},
{15,	20,	27,	21,	37},
{15,	17,	24,	28,	34},
{14,	15,	25,	24,	38},
{14,	17,	29,	23,	34},
{14,	25,	23,	20,	36},
{14,	23,	28,	20,	33},
{14,	16,	26,	25,	36},
{14,	22,	26,	25,	33},
{14,	23,	27,	21,	34},
{13,	18,	25,	23,	38},
{13,	25,	23,	23,	35},
{13,	21,	23,	22,	38},
{13,	24,	26,	21,	34},
{13,	21,	23,	27,	34},
{13,	21,	28,	20,	36},
{13,	16,	26,	28,	34},
{14,	15,	27,	29,	34},
{13,	18,	29,	23,	34},
{14,	19,	29,	23,	33},
{15,	22,	28,	22,	33},
{13,	23,	28,	19,	36},
{13,	13,	28,	21,	38},
{13,	19,	23,	26,	35},
{13,	16,	35,	22,	33},
{13,	18,	24,	24,	38},
{13,	16,	30,	23,	34},
{13,	14,	25,	26,	36},
{13,	13,	27,	26,	36},
{12,	24,	32,	16,	38},
{17,	18,	34,	10,	38},
{15,	15,	32,	10,	39},
{14,	24,	33,	14,	35},
{14,	20,	29,	18,	37},
{14,	24,	34,	11,	35},
{14,	19,	34,	10,	38},
{13,	24,	34,	15,	36},
{13,	26,	30,	13,	35},
{13,	20,	32,	10,	39},
{13,	19,	34,	16,	37},
{13,	26,	30,	15,	34},
{13,	25,	32,	15,	34},
{13,	26,	31,	13,	35},
{15,	25,	32,	13,	35},
{13,	15,	32,	11,	39},
{13,	14,	32,	13,	39},
{13,	12,	32,	14,	39},
{15,	18,	28,	14,	39},
{13,	24,	34,	16,	34},
{13,	25,	33,	9,	35},
{13,	17,	30,	12,	39},
{13,	21,	31,	10,	39},
{12,	32,	28,	19,	28},
{15,	30,	29,	19,	28},
{14,	31,	24,	20,	27},
{13,	32,	24,	20,	26},
{13,	32,	22,	21,	28},
{12,	12,	29,	30,	36},
{14,	14,	24,	30,	36},
{16,	13,	27,	30,	36},
{13,	4,	30,	25,	36},
{12,	10,	27,	28,	37},
{16,	14,	24,	27,	37},
{14,	6,	22,	29,	37},
{14,	15,	22,	28,	37},
{12,	30,	24,	16,	39},
{15,	30,	25,	10,	35},
{15,	25,	26,	15,	38},
{14,	31,	22,	15,	39},
{13,	31,	23,	15,	38},
{13,	30,	25,	9,	36},
{13,	30,	25,	4,	38},
{13,	30,	25,	7,	37},
{13,	31,	23,	16,	34},
{12,	12,	38,	23,	35},
{15,	13,	38,	19,	34},
{14,	14,	36,	21,	35},
{13,	16,	38,	17,	33},
{14,	15,	39,	14,	34},
{13,	15,	36,	21,	35},
{13,	16,	37,	20,	32},
{13,	17,	36,	22,	33},
{13,	18,	34,	22,	33},
{14,	21,	31,	22,	32},
{13,	8,	39,	17,	34},
{12,	8,	39,	39,	1},
{12,	39,	25,	4,	33},
{15,	39,	25,	5,	4},
{14,	35,	27,	0,	33},
{12,	31,	28,	23,	23},
{13,	32,	25,	20,	13},
{14,	32,	27,	21,	1},
{13,	31,	25,	23,	24},
{12,	5,	33,	36,	27},
{15,	9,	28,	36,	25},
{13,	9,	28,	36,	27},
{14,	13,	22,	36,	28},
{13,	15,	26,	36,	22},
{13,	6,	33,	36,	25},
{12,	24,	20,	36,	27},
{18,	22,	19,	36,	28},
{16,	19,	12,	37,	25},
{15,	27,	18,	35,	2},
{17,	25,	17,	35,	27},
{16,	25,	18,	37,	0},
{14,	19,	16,	37,	15},
{14,	19,	17,	36,	29},
{13,	16,	21,	37,	13},
{13,	14,	25,	37,	13},
{13,	24,	23,	35,	0},
{13,	23,	26,	35,	0},
{13,	19,	20,	37,	2},
{13,	16,	17,	36,	30},
{13,	19,	10,	36,	33},
{13,	39,	17,	36,	0},
{13,	17,	26,	36,	6},
{13,	25,	18,	35,	24},
{13,	14,	23,	36,	27},
{12,	17,	39,	36,	16},
{15,	18,	24,	35,	18},
{15,	21,	24,	35,	6},
{14,	18,	36,	35,	0},
{14,	16,	38,	33,	21},
{14,	21,	23,	35,	9},
{14,	15,	39,	34,	18},
{13,	18,	34,	35,	11},
{15,	19,	27,	35,	9},
{14,	18,	37,	35,	1},
{13,	20,	25,	35,	20},
{13,	17,	32,	35,	18},
{13,	20,	26,	35,	19},
{14,	19,	27,	35,	19},
{13,	22,	24,	35,	4},
{14,	25,	21,	35,	1},
{13,	23,	26,	35,	1},
{14,	23,	23,	35,	4},
{14,	24,	21,	35,	7},
{13,	18,	24,	36,	8},
{13,	20,	21,	36,	17},
{13,	18,	25,	35,	22},
{12,	10,	28,	26,	38},
{16,	16,	24,	25,	38},
{13,	17,	24,	26,	38},
{15,	15,	24,	30,	36},
{13,	16,	25,	29,	35},
{13,	15,	23,	28,	37},
{12,	31,	34,	7,	27},
{12,	30,	35,	10,	27},
{16,	29,	35,	4,	30},
{16,	29,	36,	6,	2},
{15,	32,	35,	3,	1},
{14,	32,	35,	2,	18},
{14,	32,	36,	2,	2},
{14,	33,	36,	0,	15},
{13,	31,	35,	4,	16},
{13,	31,	35,	2,	28},
{13,	30,	35,	2,	29},
{13,	32,	34,	2,	25},
{12,	30,	29,	26,	29},
{18,	29,	30,	26,	28},
{13,	30,	24,	17,	33},
{17,	30,	22,	18,	34},
{15,	30,	22,	22,	32},
{14,	30,	26,	17,	31},
{14,	30,	22,	23,	32},
{13,	30,	28,	17,	30},
{12,	12,	32,	30,	35},
{12,	12,	38,	28,	34},
{12,	26,	28,	16,	38},
{17,	25,	32,	8,	37},
{16,	25,	32,	8,	38},
{15,	26,	31,	8,	38},
{15,	26,	27,	10,	39},
{14,	28,	25,	16,	35},
{14,	25,	30,	8,	39},
{13,	25,	32,	9,	36},
{13,	26,	29,	9,	37},
{12,	12,	32,	28,	36},
{12,	29,	30,	18,	33},
{17,	30,	24,	18,	32},
{16,	29,	23,	22,	32},
{15,	26,	29,	19,	32},
{14,	29,	29,	19,	30},
{13,	30,	23,	19,	33},
{14,	30,	23,	21,	32},
{13,	25,	29,	19,	33},
{13,	30,	24,	19,	32},
{13,	25,	31,	18,	32},
{13,	24,	31,	18,	35},
{15,	24,	32,	17,	35},
{13,	24,	29,	17,	36},
{12,	39,	22,	16,	38},
{13,	32,	24,	14,	33},
{12,	28,	25,	19,	36},
{13,	26,	24,	17,	37},
{13,	26,	23,	18,	37},
{13,	24,	24,	20,	36},
{12,	4,	36,	19,	38},
{13,	3,	37,	13,	38},
{12,	7,	39,	22,	34},
{14,	7,	39,	23,	31},
{13,	11,	39,	19,	31},
{12,	31,	25,	12,	37},
{14,	30,	25,	13,	37},
{12,	31,	26,	6,	38},
{16,	31,	26,	1,	39},
{15,	33,	26,	2,	36},
{14,	30,	29,	1,	38},
{16,	31,	27,	1,	38},
{14,	29,	28,	1,	39},
{14,	31,	26,	7,	33},
{14,	29,	26,	7,	38},
{13,	34,	26,	1,	36},
{19,	35,	25,	0,	36},
{17,	35,	25,	1,	34},
{17,	34,	24,	0,	39},
{16,	34,	24,	2,	37},
{13,	30,	25,	11,	38},
{13,	31,	31,	1,	36},
{13,	29,	28,	2,	39},
{13,	34,	25,	1,	37},
{13,	34,	25,	0,	39},
{13,	35,	27,	0,	34},
{13,	30,	27,	1,	39},
{12,	28,	35,	21,	27},
{12,	31,	21,	21,	39},
{13,	39,	21,	20,	33},
{12,	5,	28,	32,	34},
{12,	33,	30,	10,	26},
{12,	8,	36,	24,	36},
{12,	32,	21,	28,	27},
{15,	32,	22,	24,	27},
{13,	39,	20,	25,	28},
{13,	32,	22,	28,	1},
{13,	39,	21,	24,	26},
{12,	10,	38,	25,	35},
{12,	5,	34,	28,	36},
{13,	12,	33,	28,	35},
{12,	27,	36,	21,	25},
{14,	27,	36,	22,	5},
{13,	26,	36,	24,	0},
{13,	28,	36,	7,	25},
{12,	21,	28,	21,	38},
{13,	16,	30,	17,	38},
{12,	34,	26,	14,	16},
{15,	34,	25,	13,	19},
{14,	34,	26,	9,	22},
{12,	7,	31,	19,	39},
{12,	25,	33,	13,	37},
{13,	24,	33,	10,	38},
{13,	26,	29,	13,	37},
{12,	26,	35,	30,	24},
{12,	27,	26,	23,	33},
{16,	27,	28,	19,	33},
{14,	30,	26,	19,	31},
{14,	27,	29,	19,	33},
{13,	27,	25,	24,	32},
{13,	30,	28,	18,	30},
{12,	31,	31,	10,	31},
{15,	30,	32,	11,	29},
{14,	31,	31,	5,	32},
{12,	18,	37,	18,	36},
{14,	15,	38,	12,	36},
{13,	18,	38,	17,	32},
{13,	15,	37,	19,	35},
{13,	18,	37,	19,	34},
{12,	28,	29,	23,	30},
{15,	23,	30,	26,	30},
{17,	27,	28,	24,	30},
{14,	25,	28,	21,	31},
{13,	25,	30,	21,	30},
{12,	33,	33,	4,	26},
{12,	34,	25,	13,	31},
{15,	33,	27,	13,	27},
{13,	34,	26,	9,	30},
{13,	33,	26,	11,	31},
{14,	33,	26,	12,	30},
{13,	34,	26,	10,	24},
{13,	33,	27,	7,	31},
{12,	12,	39,	31,	26},
{12,	32,	33,	6,	27},
{13,	33,	33,	6,	0},
{14,	33,	33,	5,	7},
{12,	30,	37,	4,	19},
{16,	30,	37,	3,	24},
{15,	30,	37,	6,	0},
{15,	29,	36,	5,	14},
{14,	29,	37,	5,	12},
{13,	30,	36,	3,	26},
{13,	29,	36,	5,	22},
{13,	30,	38,	5,	0},
{12,	31,	26,	15,	33},
{14,	30,	25,	15,	34},
{14,	30,	25,	18,	32},
{14,	30,	26,	17,	32},
{12,	39,	18,	25,	38},
{14,	39,	18,	23,	39},
{14,	29,	21,	25,	33},
{13,	30,	20,	22,	37},
{12,	3,	32,	25,	37},
{12,	33,	27,	18,	27},
{14,	33,	23,	15,	30},
{13,	33,	24,	14,	30},
{12,	33,	30,	4,	33},
{13,	33,	30,	5,	31},
{13,	33,	31,	6,	29},
{14,	33,	31,	5,	30},
{13,	31,	31,	4,	33},
{13,	33,	29,	6,	30},
{12,	31,	31,	3,	36},
{15,	31,	27,	2,	38},
{14,	30,	29,	4,	34},
{14,	28,	31,	3,	37},
{13,	31,	28,	4,	35},
{13,	30,	31,	4,	34},
{13,	28,	32,	3,	37},
{12,	30,	19,	25,	37},
{12,	39,	31,	3,	0},
{13,	36,	32,	2,	0},
{12,	29,	33,	7,	33},
{13,	29,	33,	2,	34},
{13,	29,	32,	2,	36},
{12,	39,	22,	17,	32},
{16,	39,	22,	18,	29},
{13,	32,	23,	17,	31},
{13,	31,	23,	17,	32},
{12,	6,	21,	35,	32},
{13,	4,	15,	36,	31},
{12,	9,	38,	16,	37},
{13,	9,	36,	14,	38},
{12,	21,	38,	19,	31},
{14,	16,	38,	19,	34},
{14,	22,	37,	18,	30},
{12,	23,	26,	31,	31},
{16,	24,	24,	32,	28},
{15,	22,	27,	31,	30},
{13,	24,	26,	31,	29},
{13,	16,	24,	34,	28},
{14,	15,	23,	33,	30},
{13,	20,	23,	34,	28},
{13,	22,	27,	31,	31},
{13,	14,	24,	34,	30},
{12,	26,	23,	31,	31},
{13,	28,	22,	30,	28},
{14,	27,	22,	29,	29},
{13,	28,	22,	28,	31},
{14,	28,	21,	29,	30},
{13,	25,	23,	32,	29},
{13,	30,	22,	28,	28},
{13,	30,	19,	29,	29},
{13,	28,	20,	28,	32},
{14,	27,	21,	28,	32},
{13,	27,	18,	29,	34},
{14,	26,	19,	30,	32},
{14,	26,	21,	29,	32},
{14,	26,	18,	29,	35},
{13,	25,	20,	31,	32},
{13,	28,	18,	28,	35},
{13,	28,	20,	28,	33},
{12,	32,	24,	11,	36},
{17,	32,	26,	4,	35},
{13,	33,	24,	8,	35},
{12,	32,	25,	4,	39},
{13,	30,	25,	9,	39},
{13,	32,	26,	2,	38},
{13,	31,	26,	2,	39},
{12,	34,	24,	4,	37},
{12,	9,	21,	34,	33},
{13,	8,	17,	35,	33},
{13,	13,	18,	34,	33},
{12,	28,	23,	18,	38},
{13,	28,	23,	19,	37},
{14,	24,	24,	20,	37},
{12,	6,	22,	39,	17},
{12,	26,	18,	34,	31},
{14,	25,	19,	33,	30},
{14,	16,	19,	34,	32},
{13,	21,	19,	34,	31},
{12,	39,	17,	33,	30},
{15,	28,	18,	31,	20},
{16,	28,	20,	31,	11},
{14,	29,	18,	32,	8},
{13,	28,	18,	35,	5},
{12,	31,	31,	13,	12},
{12,	16,	39,	17,	34},
{12,	19,	39,	31,	16},
{12,	29,	26,	10,	37},
{16,	27,	27,	10,	36},
{13,	27,	26,	10,	38},
{13,	27,	27,	8,	37},
{12,	39,	25,	21,	1},
{12,	8,	35,	32,	33},
{12,	16,	17,	36,	32},
{13,	20,	16,	35,	31},
{14,	20,	19,	35,	30},
{12,	35,	29,	3,	5},
{15,	35,	30,	2,	4},
{13,	35,	27,	2,	6},
{12,	6,	19,	30,	38},
{12,	25,	24,	22,	37},
{16,	25,	25,	20,	36},
{13,	24,	26,	22,	35},
{12,	28,	24,	21,	36},
{15,	26,	25,	20,	36},
{14,	26,	23,	21,	37},
{13,	28,	26,	20,	31},
{13,	27,	23,	21,	37},
{13,	26,	23,	23,	34},
{12,	6,	35,	36,	24},
{12,	30,	33,	7,	31},
{17,	30,	33,	1,	35},
{14,	30,	35,	2,	32},
{14,	31,	33,	2,	30},
{14,	30,	32,	8,	31},
{14,	30,	32,	10,	30},
{13,	31,	32,	1,	33},
{13,	29,	35,	4,	31},
{13,	30,	34,	2,	33},
{12,	29,	32,	15,	32},
{14,	29,	32,	16,	30},
{13,	30,	31,	12,	31},
{14,	30,	31,	16,	29},
{12,	33,	25,	19,	19},
{12,	34,	24,	8,	35},
{12,	32,	34,	6,	6},
{13,	32,	35,	4,	3},
{12,	21,	37,	18,	33},
{14,	19,	38,	14,	33},
{12,	23,	37,	13,	35},
{13,	22,	38,	6,	35},
{14,	20,	38,	9,	35},
{13,	21,	38,	15,	32},
{13,	22,	38,	16,	31},
{13,	20,	37,	16,	35},
{13,	21,	37,	17,	34},
{13,	22,	37,	16,	33},
{12,	26,	29,	16,	37},
{13,	26,	30,	15,	35},
{12,	19,	34,	15,	38},
{14,	21,	33,	13,	38},
{12,	16,	33,	19,	38},
{15,	13,	35,	16,	38},
{13,	12,	33,	20,	38},
{12,	18,	38,	36,	1},
{14,	18,	33,	36,	2},
{12,	33,	37,	0,	31},
{14,	32,	35,	2,	25},
{13,	32,	35,	1,	31},
{16,	32,	33,	3,	29},
{13,	31,	35,	1,	32},
{13,	32,	39,	0,	5},
{13,	34,	39,	0,	3},
{13,	31,	33,	3,	31},
{12,	33,	34,	3,	25},
{16,	32,	34,	4,	16},
{13,	33,	34,	1,	30},
{12,	31,	36,	4,	26},
{13,	31,	38,	3,	0},
{12,	29,	36,	8,	25},
{14,	29,	36,	6,	27},
{14,	29,	36,	3,	30},
{13,	29,	37,	6,	12},
{13,	29,	38,	1,	28},
{13,	29,	36,	6,	28},
{13,	30,	35,	5,	28},
{13,	30,	35,	3,	31},
{12,	14,	36,	18,	37},
{15,	13,	36,	11,	38},
{13,	10,	36,	15,	38},
{13,	11,	38,	7,	38},
{12,	31,	27,	6,	35},
{14,	30,	27,	8,	33},
{13,	30,	28,	5,	35},
{12,	30,	30,	8,	34},
{13,	30,	26,	7,	38},
{13,	29,	31,	8,	34},
{14,	29,	32,	5,	34},
{12,	27,	30,	10,	36},
{12,	13,	38,	18,	36},
{14,	13,	38,	20,	35},
{12,	25,	25,	19,	38},
{14,	24,	25,	21,	37},
{12,	23,	30,	30,	30},
{15,	24,	30,	28,	29},
{13,	23,	28,	31,	29},
{13,	24,	27,	28,	30},
{13,	16,	30,	32,	29},
{12,	15,	17,	34,	34},
{12,	34,	33,	3,	27},
{12,	23,	28,	16,	39},
{13,	12,	31,	15,	39},
{12,	9,	36,	20,	37},
{12,	33,	24,	15,	33},
{14,	32,	23,	15,	34},
{12,	32,	26,	6,	35},
{14,	32,	25,	7,	35},
{12,	32,	26,	13,	33},
{15,	32,	25,	11,	34},
{13,	32,	27,	8,	33},
{13,	31,	27,	8,	34},
{12,	13,	36,	38,	3},
{14,	14,	35,	37,	0},
{12,	10,	24,	22,	39},
{12,	28,	21,	31,	25},
{13,	27,	20,	31,	29},
{12,	32,	32,	7,	29},
{12,	15,	39,	28,	29},
{12,	29,	32,	23,	28},
{12,	28,	33,	19,	30},
{13,	28,	31,	18,	32},
{15,	26,	31,	19,	31},
{12,	29,	32,	19,	30},
{12,	33,	24,	19,	27},
{13,	39,	22,	19,	29},
{12,	34,	27,	9,	21},
{12,	14,	39,	36,	18},
{12,	7,	33,	29,	35},
{12,	24,	21,	36,	13},
{12,	23,	22,	36,	12},
{15,	20,	25,	36,	0},
{15,	19,	24,	36,	6},
{14,	23,	23,	36,	0},
{13,	21,	27,	36,	0},
{12,	26,	16,	30,	37},
{13,	27,	17,	30,	34},
{14,	28,	17,	31,	32},
{12,	15,	37,	32,	27},
{12,	12,	37,	35,	26},
{17,	14,	37,	33,	27},
{15,	16,	37,	34,	25},
{12,	15,	38,	34,	26},
{14,	15,	38,	32,	27},
{12,	13,	39,	32,	25},
{12,	28,	37,	5,	29},
{13,	26,	37,	19,	26},
{13,	27,	37,	1,	33},
{12,	16,	38,	30,	30},
{12,	27,	36,	19,	27},
{12,	11,	11,	36,	34},
{12,	33,	31,	8,	12},
{12,	33,	32,	8,	2},
{13,	31,	32,	10,	0},
{12,	31,	34,	9,	1},
{12,	21,	39,	19,	30},
{13,	18,	39,	15,	31},
{13,	18,	39,	12,	32},
{12,	19,	24,	29,	34},
{13,	20,	23,	29,	33},
{14,	21,	19,	31,	34},
{13,	18,	25,	25,	35},
{13,	17,	26,	26,	35},
{12,	18,	29,	27,	34},
{13,	17,	29,	24,	35},
{13,	13,	29,	30,	35},
{14,	13,	32,	30,	33},
{13,	18,	27,	25,	35},
{13,	18,	27,	23,	36},
{13,	14,	28,	28,	35},
{13,	18,	26,	25,	36},
{13,	18,	27,	28,	33},
{13,	19,	28,	25,	33},
{14,	20,	27,	25,	33},
{13,	13,	32,	25,	35},
{13,	18,	24,	25,	38},
{13,	19,	23,	25,	38},
{12,	20,	33,	26,	32},
{13,	19,	31,	28,	32},
{12,	18,	32,	25,	34},
{15,	15,	30,	25,	35},
{14,	17,	32,	26,	33},
{15,	18,	31,	27,	33},
{13,	14,	32,	25,	35},
{12,	19,	33,	25,	33},
{15,	15,	33,	27,	33},
{12,	16,	35,	24,	33},
{14,	14,	34,	24,	34},
{13,	17,	34,	25,	33},
{15,	15,	35,	27,	32},
{13,	15,	35,	26,	33},
{13,	19,	35,	23,	32},
{12,	25,	19,	36,	24},
{13,	26,	17,	36,	7},
{12,	2,	17,	35,	34},
{12,	26,	24,	19,	38},
{13,	27,	24,	19,	37},
{12,	39,	25,	6,	5},
{12,	39,	27,	0,	8},
{14,	36,	29,	0,	4},
{12,	28,	24,	27,	30},
{14,	30,	23,	28,	28},
{13,	28,	25,	25,	30},
{12,	35,	29,	8,	0},
{14,	35,	30,	6,	0},
{12,	8,	37,	19,	36},
{12,	28,	27,	6,	39},
{12,	10,	22,	37,	27},
{12,	30,	34,	1,	36},
{14,	27,	37,	1,	35},
{14,	25,	36,	4,	35},
{13,	25,	37,	4,	35},
{13,	28,	34,	3,	34},
{13,	28,	34,	1,	37},
{13,	27,	35,	1,	38},
{13,	27,	35,	3,	36},
{14,	27,	35,	2,	37},
{13,	27,	34,	1,	39},
{12,	27,	36,	11,	29},
{13,	28,	36,	8,	28},
{12,	26,	38,	9,	29},
{13,	25,	39,	6,	30},
{13,	26,	37,	6,	30},
{13,	26,	39,	4,	30},
{13,	24,	38,	12,	29},
{13,	25,	37,	14,	29},
{13,	24,	38,	10,	30},
{12,	39,	15,	31,	35},
{15,	25,	17,	31,	34},
{13,	22,	12,	32,	36},
{12,	27,	39,	12,	25},
{13,	27,	37,	18,	25},
{13,	26,	39,	9,	27},
{12,	33,	32,	0,	36},
{15,	32,	32,	0,	38},
{13,	33,	31,	0,	39},
{13,	32,	33,	1,	33},
{14,	32,	31,	1,	35},
{13,	31,	35,	0,	35},
{12,	26,	34,	22,	29},
{12,	24,	35,	19,	31},
{12,	24,	37,	12,	34},
{13,	24,	35,	10,	36},
{13,	24,	37,	6,	35},
{13,	25,	35,	9,	32},
{12,	26,	37,	8,	33},
{15,	25,	35,	10,	33},
{14,	26,	37,	5,	34},
{15,	26,	37,	4,	35},
{13,	25,	37,	12,	30},
{12,	24,	35,	7,	37},
{14,	19,	35,	8,	38},
{12,	20,	33,	10,	39},
{13,	19,	34,	8,	39},
{12,	23,	22,	35,	21},
{13,	21,	23,	35,	20},
{12,	29,	29,	6,	35},
{14,	29,	30,	4,	35},
{12,	31,	24,	28,	2},
{14,	32,	24,	27,	0},
{13,	31,	22,	28,	8},
{13,	32,	22,	28,	5},
{12,	22,	28,	19,	38},
{12,	27,	37,	4,	34},
{12,	39,	23,	17,	3},
{12,	20,	23,	34,	29},
{13,	20,	22,	33,	30},
{13,	19,	22,	34,	30},
{12,	12,	38,	29,	31},
{12,	29,	20,	23,	38},
{14,	30,	20,	24,	34},
{12,	26,	28,	10,	39},
{12,	21,	36,	22,	32},
{14,	19,	37,	20,	32},
{13,	21,	32,	23,	32},
{12,	28,	36,	10,	19},
{12,	25,	27,	19,	34},
{14,	26,	27,	17,	34},
{12,	25,	31,	18,	34},
{14,	26,	29,	17,	34},
{12,	25,	38,	9,	31},
{12,	33,	35,	3,	2},
{12,	10,	24,	36,	28},
{12,	31,	32,	6,	31},
{12,	35,	33,	0,	20},
{13,	36,	35,	0,	0},
{12,	33,	28,	11,	9},
{12,	13,	38,	33,	27},
{12,	24,	26,	29,	31},
{13,	25,	26,	24,	32},
{14,	24,	26,	27,	32},
{12,	23,	19,	31,	34},
{12,	29,	30,	1,	39},
{12,	34,	31,	2,	28},
{13,	34,	33,	1,	28},
{12,	39,	20,	21,	39},
{12,	26,	32,	10,	35},
{12,	17,	27,	19,	39},
{12,	31,	28,	6,	34},
{13,	31,	29,	6,	33},
{12,	14,	39,	8,	35},
{12,	12,	39,	17,	35},
{13,	11,	39,	12,	36},
{12,	19,	32,	33,	6},
{12,	32,	36,	1,	19},
{12,	39,	15,	28,	38},
{12,	24,	22,	27,	34},
{15,	26,	20,	28,	34},
{12,	29,	27,	8,	37},
{13,	28,	28,	8,	37},
{13,	27,	28,	8,	38},
{12,	14,	34,	37,	3},
{12,	23,	27,	31,	31},
{12,	23,	27,	27,	32},
{14,	21,	28,	28,	32},
{12,	21,	33,	26,	32},
{12,	16,	39,	32,	23},
{12,	19,	38,	23,	30},
{13,	19,	37,	21,	32},
{14,	13,	37,	27,	32},
{13,	16,	36,	25,	32},
{12,	27,	34,	6,	34},
{12,	32,	28,	6,	33},
{13,	32,	29,	6,	32},
{12,	13,	38,	38,	1},
{13,	14,	39,	37,	0},
{12,	9,	23,	38,	20},
{12,	19,	11,	37,	32},
{12,	19,	20,	37,	27},
{14,	21,	14,	37,	23},
{14,	21,	17,	37,	17},
{13,	17,	21,	37,	17},
{12,	12,	21,	38,	26},
{12,	21,	38,	2,	38},
{14,	23,	38,	1,	38},
{13,	21,	36,	3,	38},
{12,	34,	27,	2,	33},
{12,	26,	36,	23,	5},
{12,	28,	20,	33,	1},
{13,	28,	22,	33,	0},
{12,	39,	24,	16,	3},
{12,	34,	24,	17,	3},
{12,	34,	26,	17,	2},
{12,	34,	27,	16,	2},
{12,	34,	27,	21,	1},
{12,	33,	28,	19,	2},
{12,	34,	27,	18,	2},
{12,	39,	24,	19,	3},
{12,	34,	27,	13,	4},
{14,	34,	27,	15,	3},
{12,	19,	33,	31,	24},
{12,	24,	33,	12,	38},
{12,	33,	23,	16,	33},
{12,	32,	26,	16,	32},
{12,	27,	31,	8,	37},
{12,	27,	39,	5,	29},
{12,	32,	24,	5,	38},
{12,	21,	35,	31,	2},
{13,	20,	37,	31,	0},
{12,	28,	32,	3,	38},
{13,	28,	29,	3,	39},
{12,	26,	31,	19,	32},
{12,	30,	29,	17,	30},
{12,	5,	25,	36,	28},
{12,	39,	19,	25,	33},
{12,	26,	28,	21,	31},
{12,	26,	36,	22,	16},
{12,	28,	37,	8,	15},
{12,	16,	13,	38,	14},
{13,	18,	15,	38,	3},
{13,	19,	10,	39,	7},
{12,	39,	20,	22,	31},
{12,	29,	20,	25,	36},
{12,	24,	35,	17,	32},
{12,	31,	33,	0,	38},
{12,	30,	26,	8,	37},
{12,	30,	36,	3,	30},
{12,	30,	28,	4,	36},
{12,	12,	36,	9,	39},
{13,	15,	34,	10,	39},
{12,	12,	37,	25,	35},
{12,	27,	34,	17,	30},
{12,	26,	22,	27,	33},
{14,	26,	22,	29,	32},
{12,	32,	22,	26,	27},
{12,	31,	22,	21,	30},
{13,	31,	23,	18,	31},
{12,	31,	23,	20,	30},
{12,	32,	26,	8,	34},
{12,	13,	30,	37,	17},
{12,	30,	39,	1,	20},
{12,	19,	29,	35,	3},
{12,	22,	30,	35,	0},
{12,	26,	35,	29,	25},
{12,	24,	24,	31,	31},
{12,	28,	31,	18,	33},
{12,	16,	36,	23,	33},
{12,	14,	30,	27,	35},
{12,	22,	38,	13,	32},
{12,	31,	22,	23,	28},
{12,	13,	32,	23,	36},
{13,	13,	29,	23,	37},
{12,	17,	29,	19,	38},
{12,	27,	34,	8,	33},
{12,	15,	21,	36,	28},
{13,	17,	24,	35,	24},
{12,	17,	23,	35,	29},
{12,	24,	21,	36,	27},
{13,	17,	23,	36,	21},
{13,	17,	27,	36,	18},
{13,	16,	34,	36,	19},
{13,	17,	24,	36,	23},
{12,	7,	28,	31,	34},
{12,	23,	22,	36,	14},
{12,	12,	13,	38,	30},
{12,	15,	12,	39,	14},
{12,	12,	17,	39,	27},
{12,	18,	36,	34,	26},
{12,	27,	33,	26,	28},
{13,	28,	32,	26,	28},
{12,	16,	38,	34,	23},
{13,	17,	38,	34,	21},
{12,	14,	38,	16,	36},
{12,	16,	38,	14,	36},
{12,	14,	39,	14,	35},
{12,	32,	25,	12,	34},
{12,	29,	32,	6,	34},
{12,	29,	27,	9,	36},
{12,	39,	25,	0,	36},
{12,	23,	39,	0,	37},
{12,	11,	37,	14,	37},
{13,	12,	37,	8,	38},
{12,	24,	35,	2,	38},
{12,	31,	39,	0,	26},
{12,	34,	26,	11,	21},
{12,	20,	19,	37,	9},
{12,	32,	36,	3,	2},
{12,	36,	33,	1,	0},
{12,	16,	39,	29,	28},
{12,	29,	19,	24,	38},
{12,	11,	34,	33,	31},
{12,	13,	37,	24,	33},
{12,	15,	37,	21,	35},
{13,	14,	38,	21,	33},
{12,	26,	23,	23,	35},
{12,	22,	22,	28,	34},
{12,	25,	32,	14,	35},
{12,	23,	17,	31,	35},
{12,	22,	29,	21,	33},
{13,	20,	30,	22,	33},
{13,	20,	31,	19,	34},
{12,	23,	31,	19,	34},
{14,	21,	29,	21,	34},
{14,	20,	29,	20,	36},
{13,	23,	34,	19,	33},
{13,	22,	33,	20,	33},
{12,	21,	30,	25,	33},
{14,	23,	27,	24,	33},
{12,	23,	29,	19,	35},
{12,	19,	31,	20,	34},
{12,	21,	35,	19,	33},
{12,	20,	37,	19,	33},
{12,	21,	19,	30,	35},
{12,	18,	27,	35,	21},
{12,	17,	38,	36,	20},
{13,	16,	35,	36,	21},
{12,	18,	37,	35,	20},
{14,	19,	28,	35,	20},
{12,	18,	38,	34,	21},
{12,	10,	28,	36,	27},
{12,	18,	17,	36,	30},
{12,	27,	28,	9,	37},
{12,	29,	27,	9,	37},
{12,	29,	36,	6,	29},
{13,	30,	35,	5,	29},
{12,	12,	22,	34,	32},
{12,	31,	31,	4,	34},
{12,	30,	31,	1,	37},
{12,	23,	34,	3,	39},
{12,	25,	34,	3,	38},
{12,	27,	35,	2,	38},
{12,	19,	22,	36,	21},
{13,	18,	22,	36,	25},
{12,	18,	31,	36,	18},
{12,	19,	25,	36,	6},
{12,	17,	22,	36,	28},
{12,	29,	29,	3,	37},
{12,	32,	26,	1,	39},
{12,	33,	29,	1,	34},
{12,	31,	22,	28,	14},
{12,	31,	22,	27,	27},
{12,	6,	37,	13,	38},
{12,	32,	22,	27,	12},
{12,	18,	34,	36,	3},
{12,	32,	34,	4,	19},
{12,	7,	14,	37,	31},
{12,	13,	17,	39,	12},
{12,	13,	23,	38,	15},
{12,	8,	22,	39,	9},
{12,	11,	21,	39,	9},
{12,	10,	25,	39,	2},
{13,	6,	24,	39,	3},
{12,	8,	28,	39,	2},
{12,	30,	36,	7,	0},
{11,	32,	39,	34,	28},
{18,	20,	34,	31,	29},
{16,	31,	31,	16,	29},
{16,	25,	24,	31,	31},
{15,	21,	38,	35,	0},
{15,	33,	28,	21,	1},
{15,	28,	18,	35,	13},
{15,	19,	37,	35,	1},
{14,	27,	20,	34,	29},
{14,	31,	37,	2,	30},
{14,	26,	24,	28,	31},
{14,	31,	32,	8,	30},
{14,	27,	36,	14,	29},
{14,	33,	27,	22,	1},
{13,	32,	31,	13,	29},
{13,	23,	35,	28,	29},
{13,	26,	37,	12,	30},
{13,	21,	24,	34,	29},
{15,	24,	21,	33,	30},
{13,	28,	21,	33,	29},
{14,	29,	20,	33,	29},
{13,	33,	33,	7,	0},
{13,	25,	20,	34,	30},
{13,	28,	24,	28,	30},
{13,	26,	35,	20,	29},
{12,	35,	25,	30,	0},
{15,	39,	21,	34,	16},
{13,	33,	24,	30,	1},
{13,	39,	23,	26,	1},
{13,	34,	24,	24,	1},
{12,	34,	27,	30,	0},
{14,	39,	26,	25,	0},
{13,	33,	26,	25,	1},
{13,	33,	28,	26,	0},
{13,	35,	27,	25,	0},
{13,	33,	27,	23,	1},
{12,	19,	34,	35,	18},
{15,	19,	37,	35,	5},
{13,	19,	29,	35,	21},
{12,	19,	35,	36,	3},
{14,	19,	29,	36,	6},
{12,	22,	38,	35,	0},
{12,	23,	33,	28,	30},
{12,	26,	32,	23,	30},
{12,	26,	34,	25,	29},
{13,	24,	33,	28,	29},
{12,	25,	27,	31,	29},
{12,	39,	20,	35,	0},
{13,	28,	19,	35,	5},
{13,	26,	21,	35,	3},
{13,	25,	20,	35,	22},
{13,	26,	20,	35,	13},
{12,	31,	33,	6,	30},
{12,	33,	26,	28,	1},
{13,	33,	25,	30,	1},
{12,	39,	25,	29,	0},
{12,	33,	31,	8,	19},
{12,	25,	20,	36,	18},
{12,	25,	20,	37,	0},
{13,	20,	20,	37,	16},
{12,	39,	24,	24,	1},
{12,	23,	37,	27,	29},
{12,	24,	30,	25,	30},
{12,	24,	19,	36,	28},
{12,	29,	36,	7,	29},
{12,	30,	34,	7,	29},
{12,	18,	37,	36,	3},
{12,	30,	20,	35,	1},
{13,	28,	20,	35,	13},
{12,	34,	27,	22,	1},
{14,	34,	25,	24,	1},
{12,	28,	25,	28,	29},
{12,	26,	37,	9,	32},
{12,	31,	34,	4,	30},
{12,	39,	19,	31,	29},
{11,	39,	39,	23,	0},
{16,	34,	29,	24,	0},
{16,	33,	31,	10,	2},
{13,	34,	35,	1,	2},
{13,	34,	37,	1,	1},
{12,	33,	30,	21,	1},
{13,	33,	29,	11,	4},
{12,	33,	36,	1,	28},
{16,	33,	35,	3,	7},
{12,	39,	29,	24,	0},
{12,	34,	33,	4,	14},
{12,	33,	31,	10,	5},
{12,	33,	29,	26,	0},
{12,	33,	38,	1,	5},
{12,	35,	36,	0,	4},
{12,	34,	33,	5,	3},
{11,	34,	34,	21,	28},
{16,	34,	26,	12,	30},
{15,	39,	24,	21,	3},
{14,	33,	32,	7,	29},
{15,	33,	33,	5,	29},
{13,	34,	27,	13,	29},
{13,	39,	23,	14,	33},
{15,	39,	23,	16,	29},
{13,	39,	22,	21,	29},
{13,	34,	28,	22,	1},
{13,	35,	34,	0,	16},
{13,	32,	23,	20,	29},
{13,	33,	32,	3,	30},
{13,	32,	32,	5,	30},
{12,	39,	23,	17,	31},
{14,	39,	23,	18,	29},
{12,	33,	26,	13,	32},
{12,	33,	35,	13,	1},
{12,	34,	25,	9,	33},
{15,	34,	25,	13,	32},
{13,	33,	26,	9,	33},
{12,	33,	26,	6,	35},
{12,	33,	27,	15,	30},
{14,	33,	25,	15,	32},
{12,	33,	30,	9,	31},
{14,	33,	27,	11,	31},
{13,	33,	32,	9,	29},
{13,	33,	27,	8,	32},
{13,	33,	28,	10,	31},
{13,	33,	27,	13,	31},
{13,	32,	32,	10,	29},
{12,	39,	24,	17,	7},
{13,	39,	24,	16,	8},
{12,	34,	25,	5,	35},
{12,	33,	27,	23,	2},
{13,	39,	22,	23,	3},
{12,	33,	24,	23,	5},
{12,	34,	35,	3,	6},
{13,	34,	36,	0,	22},
{14,	34,	35,	1,	17},
{13,	34,	35,	2,	13},
{12,	39,	23,	23,	5},
{12,	39,	22,	22,	20},
{12,	34,	25,	3,	36},
{12,	33,	25,	7,	35},
{12,	39,	23,	19,	29},
{12,	33,	28,	11,	30},
{11,	24,	39,	37,	26},
{16,	24,	24,	36,	27},
{16,	25,	21,	37,	2},
{15,	15,	29,	35,	28},
{14,	6,	23,	38,	22},
{14,	22,	22,	37,	27},
{14,	25,	16,	37,	25},
{13,	26,	22,	35,	1},
{13,	25,	23,	36,	0},
{12,	12,	31,	38,	20},
{14,	5,	32,	38,	19},
{13,	6,	26,	38,	21},
{12,	17,	34,	38,	2},
{16,	14,	22,	38,	14},
{17,	16,	25,	38,	5},
{14,	15,	37,	38,	1},
{14,	16,	20,	39,	0},
{13,	22,	23,	38,	1},
{15,	26,	15,	38,	2},
{14,	20,	22,	38,	2},
{12,	25,	23,	35,	22},
{14,	27,	21,	35,	10},
{12,	18,	31,	38,	2},
{13,	19,	27,	38,	0},
{12,	23,	24,	38,	0},
{12,	14,	37,	38,	3},
{12,	16,	28,	38,	5},
{12,	20,	23,	35,	29},
{13,	21,	22,	36,	28},
{12,	18,	34,	38,	0},
{12,	17,	24,	36,	28},
{12,	17,	35,	38,	1},
{12,	25,	22,	37,	1},
{12,	22,	20,	38,	2},
{12,	23,	23,	35,	28},
{12,	22,	23,	36,	28},
{12,	25,	21,	36,	14},
{12,	13,	23,	38,	19},
{13,	13,	18,	38,	27},
{12,	15,	8,	39,	27},
{12,	19,	27,	38,	1},
{11,	22,	39,	29,	35},
{15,	20,	21,	30,	35},
{14,	11,	34,	26,	36},
{14,	13,	35,	30,	34},
{14,	24,	20,	28,	35},
{14,	17,	39,	6,	36},
{14,	23,	27,	24,	34},
{13,	23,	39,	11,	35},
{13,	18,	39,	30,	30},
{13,	17,	26,	30,	35},
{14,	17,	22,	30,	36},
{14,	14,	26,	30,	36},
{13,	23,	23,	27,	35},
{13,	24,	39,	5,	35},
{14,	24,	38,	9,	33},
{13,	21,	39,	2,	37},
{13,	23,	32,	19,	35},
{13,	20,	25,	25,	36},
{13,	20,	24,	26,	37},
{14,	18,	26,	26,	36},
{13,	18,	25,	27,	36},
{13,	15,	26,	30,	36},
{13,	23,	29,	20,	34},
{12,	17,	36,	30,	34},
{13,	17,	37,	30,	33},
{12,	15,	38,	30,	33},
{12,	17,	28,	31,	33},
{12,	19,	36,	31,	30},
{13,	20,	38,	31,	29},
{14,	22,	39,	30,	29},
{12,	20,	37,	18,	36},
{16,	21,	39,	5,	36},
{13,	20,	38,	9,	36},
{12,	12,	26,	32,	34},
{12,	17,	32,	30,	35},
{12,	23,	29,	21,	35},
{12,	24,	39,	10,	33},
{13,	25,	39,	11,	29},
{12,	21,	38,	11,	36},
{12,	23,	38,	7,	36},
{12,	10,	36,	31,	31},
{12,	22,	38,	3,	38},
{12,	23,	25,	25,	35},
{12,	26,	24,	25,	34},
{13,	25,	23,	27,	33},
{13,	26,	23,	26,	34},
{12,	19,	34,	19,	36},
{12,	21,	23,	30,	32},
{12,	18,	33,	30,	32},
{12,	18,	30,	30,	34},
{13,	20,	23,	31,	33},
{15,	25,	21,	31,	32},
{12,	20,	27,	31,	33},
{16,	22,	27,	30,	32},
{14,	19,	27,	30,	34},
{12,	23,	27,	24,	35},
{12,	21,	37,	13,	36},
{12,	24,	39,	11,	32},
{12,	25,	38,	6,	33},
{12,	24,	23,	26,	35},
{12,	12,	28,	31,	34},
{12,	24,	39,	6,	35},
{12,	12,	25,	33,	33},
{11,	30,	33,	13,	38},
{18,	30,	29,	16,	32},
{17,	32,	27,	10,	32},
{15,	26,	29,	15,	38},
{15,	29,	35,	11,	29},
{14,	29,	33,	1,	39},
{14,	31,	28,	10,	32},
{13,	28,	26,	16,	36},
{13,	30,	34,	2,	37},
{13,	30,	34,	11,	29},
{13,	30,	34,	0,	39},
{14,	30,	34,	1,	38},
{13,	31,	29,	4,	35},
{12,	27,	32,	16,	34},
{15,	26,	33,	14,	35},
{15,	28,	31,	14,	34},
{14,	28,	28,	16,	34},
{14,	29,	29,	14,	34},
{13,	27,	28,	16,	35},
{13,	26,	33,	16,	34},
{13,	25,	33,	15,	35},
{12,	31,	27,	6,	38},
{12,	28,	26,	13,	39},
{15,	27,	28,	10,	39},
{12,	31,	34,	12,	29},
{13,	29,	34,	14,	29},
{12,	31,	28,	16,	32},
{12,	31,	29,	12,	32},
{12,	33,	33,	7,	29},
{12,	29,	28,	3,	39},
{13,	30,	27,	3,	39},
{13,	30,	28,	2,	39},
{12,	25,	30,	9,	39},
{12,	30,	29,	1,	39},
{12,	26,	29,	16,	38},
{12,	31,	35,	0,	37},
{11,	21,	39,	19,	38},
{15,	22,	35,	7,	38},
{16,	23,	34,	8,	38},
{15,	22,	33,	16,	38},
{15,	22,	35,	10,	37},
{14,	22,	39,	5,	37},
{13,	22,	33,	18,	37},
{13,	13,	36,	23,	36},
{14,	15,	36,	20,	36},
{14,	14,	36,	20,	37},
{13,	20,	34,	8,	39},
{12,	11,	36,	26,	36},
{12,	5,	35,	28,	36},
{12,	20,	31,	21,	37},
{12,	15,	34,	20,	38},
{12,	16,	36,	8,	39},
{12,	22,	39,	7,	37},
{12,	22,	32,	19,	37},
{13,	22,	36,	19,	36},
{12,	24,	34,	11,	37},
{12,	18,	36,	6,	39},
{12,	20,	35,	7,	39},
{12,	14,	35,	21,	37},
{12,	17,	35,	21,	36},
{11,	14,	21,	34,	37},
{16,	14,	24,	33,	33},
{15,	39,	9,	33,	36},
{15,	15,	21,	34,	34},
{14,	23,	20,	34,	31},
{15,	18,	22,	34,	31},
{12,	14,	12,	35,	35},
{12,	12,	23,	34,	34},
{12,	22,	13,	31,	37},
{12,	9,	22,	31,	35},
{12,	39,	11,	33,	36},
{12,	15,	19,	34,	36},
{13,	39,	11,	34,	36},
{12,	15,	14,	34,	37},
{13,	39,	10,	32,	37},
{12,	39,	8,	34,	37},
{12,	14,	23,	34,	33},
{12,	15,	23,	32,	33},
{11,	35,	30,	9,	32},
{15,	35,	25,	12,	2},
{15,	35,	26,	12,	1},
{14,	34,	26,	10,	32},
{14,	39,	25,	5,	16},
{13,	34,	26,	7,	33},
{13,	39,	25,	6,	16},
{13,	32,	28,	10,	32},
{12,	39,	26,	3,	28},
{14,	39,	27,	0,	15},
{14,	39,	26,	0,	31},
{12,	39,	25,	10,	20},
{13,	35,	27,	13,	3},
{13,	39,	25,	6,	27},
{13,	39,	25,	13,	2},
{12,	39,	25,	21,	2},
{12,	39,	26,	1,	32},
{12,	34,	29,	2,	33},
{12,	31,	30,	11,	32},
{12,	32,	30,	10,	32},
{11,	12,	31,	30,	38},
{17,	16,	20,	29,	38},
{16,	15,	25,	28,	37},
{14,	15,	26,	28,	37},
{14,	15,	24,	29,	37},
{13,	4,	32,	25,	38},
{13,	15,	34,	21,	38},
{15,	12,	34,	23,	38},
{13,	19,	19,	28,	38},
{13,	17,	21,	27,	38},
{14,	13,	26,	28,	38},
{12,	12,	32,	26,	38},
{12,	9,	33,	26,	37},
{12,	5,	35,	25,	37},
{12,	3,	34,	26,	37},
{12,	19,	19,	30,	38},
{12,	13,	27,	28,	37},
{12,	16,	23,	27,	38},
{12,	13,	27,	24,	38},
{11,	14,	35,	35,	34},
{15,	15,	33,	31,	33},
{14,	19,	31,	31,	31},
{14,	16,	32,	33,	29},
{13,	19,	33,	35,	27},
{13,	18,	32,	31,	32},
{13,	17,	35,	31,	32},
{13,	16,	20,	35,	32},
{13,	15,	21,	35,	34},
{12,	19,	32,	32,	29},
{13,	21,	28,	33,	29},
{15,	19,	25,	35,	29},
{13,	25,	26,	32,	29},
{12,	16,	36,	32,	29},
{11,	5,	35,	23,	39},
{17,	8,	36,	11,	39},
{16,	10,	27,	21,	39},
{14,	7,	32,	19,	39},
{14,	10,	27,	22,	39},
{13,	15,	23,	26,	39},
{13,	9,	34,	13,	39},
{13,	11,	24,	23,	39},
{12,	9,	34,	15,	39},
{12,	8,	34,	17,	39},
{12,	9,	31,	19,	39},
{12,	9,	27,	23,	39},
{12,	9,	28,	20,	39},
{11,	39,	24,	13,	39},
{14,	39,	25,	0,	37},
{13,	33,	25,	3,	38},
{12,	35,	26,	0,	37},
{11,	34,	24,	19,	38},
{14,	31,	26,	16,	33},
{13,	32,	22,	20,	33},
{13,	32,	22,	21,	32},
{13,	31,	23,	21,	32},
{12,	33,	25,	18,	32},
{15,	31,	26,	19,	30},
{12,	31,	23,	23,	31},
{13,	32,	22,	22,	31},
{12,	31,	22,	27,	29},
{13,	39,	20,	29,	29},
{12,	39,	23,	21,	29},
{12,	30,	27,	16,	33},
{12,	39,	21,	21,	33},
{11,	17,	39,	39,	5},
{14,	18,	39,	38,	0},
{13,	18,	26,	39,	3},
{13,	39,	13,	39,	2},
{12,	23,	23,	39,	0},
{14,	39,	15,	39,	2},
{13,	19,	27,	39,	0},
{13,	23,	18,	39,	1},
{12,	14,	17,	39,	13},
{11,	33,	36,	21,	18},
{15,	34,	36,	3,	3},
{14,	34,	35,	2,	21},
{13,	33,	36,	3,	28},
{15,	33,	36,	5,	21},
{14,	33,	36,	6,	20},
{15,	33,	35,	13,	19},
{13,	33,	35,	11,	21},
{13,	33,	37,	4,	6},
{13,	34,	35,	3,	13},
{12,	33,	37,	6,	15},
{12,	34,	35,	5,	18},
{13,	34,	36,	5,	1},
{12,	33,	36,	9,	21},
{11,	28,	32,	24,	33},
{17,	23,	33,	24,	33},
{17,	28,	33,	18,	32},
{15,	24,	28,	20,	35},
{15,	29,	30,	24,	29},
{14,	24,	28,	26,	32},
{14,	28,	23,	25,	33},
{14,	28,	23,	23,	34},
{14,	25,	34,	19,	31},
{14,	24,	32,	18,	35},
{13,	23,	33,	21,	34},
{12,	25,	28,	28,	31},
{14,	25,	25,	30,	31},
{13,	26,	25,	26,	31},
{12,	26,	34,	28,	29},
{12,	28,	31,	28,	29},
{13,	28,	32,	26,	29},
{12,	25,	33,	18,	34},
{12,	25,	35,	28,	29},
{12,	25,	30,	26,	30},
{12,	26,	35,	25,	29},
{12,	29,	30,	19,	31},
{12,	28,	33,	19,	31},
{11,	27,	39,	26,	31},
{16,	24,	38,	28,	29},
{15,	28,	26,	27,	30},
{15,	24,	39,	13,	32},
{14,	28,	33,	20,	31},
{14,	24,	32,	25,	32},
{13,	27,	39,	4,	34},
{13,	28,	36,	20,	29},
{13,	26,	27,	25,	32},
{13,	28,	33,	25,	29},
{13,	26,	28,	28,	30},
{13,	27,	39,	2,	35},
{12,	28,	39,	21,	29},
{13,	29,	37,	10,	29},
{13,	29,	39,	8,	29},
{12,	25,	36,	16,	33},
{14,	26,	36,	13,	32},
{13,	27,	35,	12,	32},
{12,	26,	32,	26,	32},
{12,	28,	37,	6,	31},
{13,	28,	34,	13,	31},
{12,	32,	34,	6,	30},
{15,	29,	35,	6,	31},
{14,	29,	36,	6,	31},
{13,	32,	31,	10,	30},
{13,	31,	34,	5,	31},
{13,	32,	37,	1,	31},
{12,	25,	27,	28,	32},
{12,	29,	35,	9,	31},
{14,	29,	37,	7,	30},
{12,	32,	34,	8,	30},
{13,	32,	34,	10,	29},
{12,	30,	38,	1,	33},
{12,	27,	31,	27,	30},
{13,	25,	30,	27,	31},
{12,	27,	37,	27,	29},
{13,	26,	37,	28,	29},
{12,	28,	24,	28,	31},
{12,	25,	24,	30,	32},
{12,	23,	37,	18,	32},
{12,	24,	37,	13,	34},
{12,	26,	23,	30,	32},
{12,	26,	39,	4,	35},
{12,	30,	34,	10,	30},
{12,	29,	35,	10,	31},
{11,	13,	38,	23,	38},
{12,	12,	36,	24,	37},
{13,	12,	36,	26,	36},
{11,	18,	38,	34,	32},
{16,	19,	35,	34,	29},
{15,	19,	23,	33,	32},
{15,	16,	30,	32,	33},
{14,	15,	28,	35,	32},
{14,	15,	25,	35,	33},
{13,	22,	15,	34,	32},
{13,	18,	37,	30,	33},
{13,	21,	23,	33,	31},
{13,	24,	23,	32,	30},
{13,	22,	17,	32,	33},
{12,	5,	36,	33,	34},
{12,	22,	38,	32,	29},
{13,	21,	37,	33,	29},
{12,	19,	31,	33,	32},
{14,	21,	30,	30,	32},
{13,	22,	24,	33,	30},
{12,	18,	19,	34,	34},
{15,	22,	13,	33,	36},
{13,	18,	27,	33,	33},
{15,	17,	32,	32,	33},
{14,	19,	24,	33,	33},
{13,	17,	35,	32,	33},
{13,	16,	17,	34,	36},
{13,	17,	25,	34,	33},
{12,	26,	16,	33,	33},
{13,	24,	18,	32,	33},
{13,	39,	14,	34,	33},
{13,	21,	17,	34,	33},
{13,	39,	16,	34,	32},
{12,	20,	38,	34,	29},
{12,	15,	32,	32,	34},
{13,	15,	25,	35,	34},
{12,	22,	33,	30,	32},
{12,	18,	12,	35,	35},
{12,	19,	35,	32,	31},
{12,	17,	20,	34,	34},
{12,	16,	26,	33,	34},
{12,	18,	24,	33,	34},
{12,	20,	23,	31,	34},
{13,	19,	21,	31,	35},
{12,	19,	21,	32,	35},
{12,	18,	24,	34,	33},
{11,	31,	30,	8,	39},
{16,	31,	31,	2,	38},
{14,	29,	32,	3,	39},
{13,	28,	31,	7,	39},
{13,	31,	25,	10,	38},
{12,	32,	29,	1,	39},
{13,	32,	31,	1,	36},
{12,	31,	34,	1,	38},
{12,	31,	31,	4,	37},
{12,	31,	26,	9,	37},
{12,	31,	28,	10,	34},
{14,	32,	26,	10,	34},
{12,	32,	28,	9,	33},
{11,	16,	37,	38,	25},
{15,	19,	21,	38,	7},
{14,	17,	34,	38,	7},
{12,	16,	12,	38,	30},
{13,	16,	20,	38,	27},
{11,	26,	31,	18,	38},
{15,	24,	32,	17,	37},
{15,	26,	28,	19,	34},
{15,	25,	33,	15,	36},
{13,	23,	28,	19,	38},
{13,	26,	25,	19,	38},
{12,	25,	33,	17,	36},
{11,	28,	26,	21,	38},
{16,	25,	28,	21,	34},
{14,	25,	27,	20,	35},
{15,	25,	28,	19,	36},
{14,	24,	28,	19,	38},
{13,	26,	26,	22,	34},
{13,	26,	27,	21,	34},
{12,	26,	27,	21,	35},
{11,	33,	25,	29,	24},
{14,	34,	25,	24,	3},
{13,	39,	23,	23,	7},
{13,	39,	23,	24,	6},
{11,	22,	22,	39,	26},
{15,	39,	14,	39,	11},
{15,	17,	30,	38,	11},
{13,	18,	18,	39,	27},
{12,	18,	23,	39,	6},
{12,	0,	22,	38,	27},
{11,	32,	31,	7,	36},
{17,	31,	31,	8,	36},
{16,	32,	32,	8,	31},
{13,	33,	27,	3,	36},
{12,	33,	28,	2,	36},
{12,	32,	34,	4,	31},
{12,	31,	31,	10,	32},
{12,	32,	31,	10,	31},
{11,	13,	20,	31,	38},
{13,	18,	14,	31,	38},
{11,	31,	25,	19,	38},
{13,	29,	26,	14,	36},
{12,	29,	30,	21,	32},
{13,	30,	26,	20,	30},
{12,	31,	24,	23,	30},
{13,	30,	25,	22,	30},
{12,	29,	27,	19,	33},
{12,	29,	28,	22,	30},
{12,	31,	25,	22,	29},
{11,	12,	30,	39,	16},
{14,	16,	24,	39,	12},
{13,	13,	26,	39,	16},
{12,	3,	32,	39,	6},
{13,	3,	31,	39,	7},
{12,	17,	30,	39,	6},
{12,	16,	27,	39,	8},
{13,	17,	25,	39,	10},
{11,	8,	36,	28,	37},
{15,	12,	34,	28,	36},
{11,	6,	35,	36,	30},
{12,	14,	28,	36,	28},
{14,	18,	26,	36,	28},
{11,	36,	28,	20,	1},
{17,	35,	26,	18,	2},
{13,	35,	28,	11,	3},
{12,	36,	27,	3,	2},
{12,	39,	27,	4,	1},
{12,	39,	27,	3,	2},
{11,	24,	24,	30,	36},
{17,	20,	20,	28,	38},
{15,	23,	24,	26,	37},
{15,	25,	25,	23,	35},
{15,	25,	24,	28,	33},
{14,	21,	25,	27,	36},
{13,	18,	25,	30,	36},
{13,	21,	25,	31,	33},
{13,	26,	24,	26,	34},
{12,	21,	25,	29,	36},
{12,	21,	19,	29,	37},
{12,	24,	20,	28,	38},
{11,	33,	26,	7,	39},
{15,	33,	27,	2,	37},
{15,	32,	27,	3,	39},
{14,	34,	25,	5,	36},
{12,	32,	29,	3,	37},
{12,	32,	27,	4,	38},
{11,	26,	33,	35,	17},
{17,	27,	23,	35,	5},
{14,	26,	23,	35,	21},
{12,	25,	29,	36,	7},
{12,	27,	24,	35,	13},
{12,	26,	25,	35,	21},
{13,	25,	28,	35,	19},
{11,	13,	26,	26,	39},
{11,	27,	33,	17,	36},
{14,	28,	27,	17,	34},
{11,	17,	25,	36,	32},
{13,	18,	20,	36,	32},
{13,	15,	27,	36,	29},
{12,	18,	22,	36,	31},
{12,	21,	17,	35,	31},
{12,	24,	20,	35,	29},
{11,	22,	19,	39,	29},
{14,	39,	10,	36,	34},
{13,	39,	12,	38,	30},
{13,	24,	17,	37,	29},
{12,	11,	18,	37,	32},
{14,	22,	12,	37,	32},
{12,	18,	19,	37,	30},
{12,	15,	17,	38,	30},
{11,	26,	34,	15,	37},
{13,	27,	34,	11,	34},
{13,	26,	34,	16,	36},
{13,	26,	35,	13,	33},
{13,	27,	34,	14,	33},
{12,	23,	34,	13,	38},
{12,	26,	32,	16,	37},
{11,	26,	38,	35,	15},
{12,	25,	39,	35,	8},
{11,	14,	38,	36,	28},
{14,	18,	30,	36,	27},
{12,	18,	33,	36,	27},
{11,	31,	22,	23,	36},
{13,	31,	20,	23,	37},
{13,	32,	22,	22,	33},
{12,	31,	20,	25,	36},
{14,	39,	20,	25,	35},
{12,	39,	19,	24,	38},
{12,	39,	21,	23,	32},
{12,	30,	20,	25,	37},
{12,	29,	21,	23,	37},
{12,	30,	20,	22,	38},
{11,	17,	36,	23,	37},
{13,	17,	37,	21,	36},
{12,	17,	36,	24,	36},
{13,	18,	30,	24,	36},
{13,	13,	29,	28,	37},
{14,	17,	28,	24,	37},
{12,	15,	34,	28,	36},
{16,	15,	36,	26,	36},
{15,	18,	28,	26,	36},
{12,	14,	34,	23,	38},
{12,	17,	28,	24,	38},
{14,	14,	26,	27,	38},
{13,	17,	26,	26,	38},
{12,	14,	27,	27,	38},
{12,	13,	27,	30,	38},
{12,	15,	34,	22,	38},
{12,	15,	37,	20,	37},
{12,	15,	28,	29,	36},
{11,	2,	26,	38,	29},
{16,	12,	22,	38,	28},
{12,	9,	28,	38,	26},
{12,	18,	24,	38,	27},
{11,	16,	36,	13,	39},
{11,	12,	34,	26,	38},
{12,	12,	35,	26,	37},
{11,	25,	39,	37,	1},
{11,	26,	33,	21,	34},
{13,	24,	33,	25,	32},
{13,	27,	33,	19,	33},
{13,	26,	33,	23,	32},
{12,	24,	29,	22,	35},
{12,	25,	27,	23,	34},
{11,	25,	28,	28,	34},
{14,	24,	31,	25,	33},
{14,	25,	29,	26,	33},
{13,	26,	25,	25,	34},
{13,	26,	26,	24,	34},
{12,	26,	25,	23,	35},
{12,	25,	22,	28,	35},
{11,	16,	32,	37,	28},
{14,	9,	26,	38,	28},
{13,	22,	23,	37,	28},
{14,	18,	22,	37,	29},
{13,	18,	24,	38,	28},
{12,	9,	36,	37,	27},
{12,	13,	20,	39,	29},
{12,	18,	27,	37,	28},
{12,	16,	28,	35,	32},
{11,	33,	27,	24,	18},
{16,	33,	27,	26,	2},
{13,	33,	26,	24,	19},
{11,	35,	34,	0,	36},
{16,	34,	34,	2,	29},
{14,	34,	31,	6,	29},
{13,	32,	36,	1,	32},
{12,	34,	35,	1,	29},
{13,	34,	35,	3,	25},
{12,	35,	35,	0,	27},
{12,	32,	33,	0,	38},
{12,	34,	35,	0,	33},
{12,	34,	31,	9,	29},
{11,	26,	23,	26,	38},
{14,	25,	24,	27,	35},
{12,	27,	23,	23,	38},
{12,	19,	24,	26,	38},
{13,	19,	25,	24,	38},
{11,	12,	34,	19,	39},
{13,	16,	28,	17,	39},
{11,	35,	25,	14,	15},
{12,	35,	25,	16,	3},
{12,	35,	25,	15,	4},
{11,	25,	37,	32,	29},
{14,	23,	34,	29,	30},
{14,	24,	38,	30,	29},
{11,	30,	30,	29,	29},
{16,	26,	31,	30,	29},
{16,	26,	28,	32,	29},
{13,	29,	22,	28,	30},
{13,	26,	24,	31,	31},
{12,	31,	23,	29,	29},
{12,	29,	22,	25,	32},
{11,	33,	36,	22,	7},
{13,	33,	29,	22,	10},
{13,	33,	28,	22,	16},
{11,	33,	31,	23,	13},
{13,	33,	28,	23,	18},
{11,	6,	38,	7,	39},
{11,	34,	29,	8,	33},
{11,	14,	33,	38,	27},
{12,	14,	35,	38,	26},
{11,	35,	25,	11,	32},
{11,	35,	28,	10,	26},
{15,	35,	27,	11,	7},
{14,	35,	27,	12,	7},
{12,	35,	27,	13,	7},
{12,	35,	27,	12,	9},
{11,	32,	26,	29,	29},
{11,	32,	22,	25,	34},
{11,	32,	30,	21,	29},
{13,	31,	27,	27,	29},
{12,	31,	31,	18,	29},
{11,	31,	33,	5,	37},
{13,	31,	34,	2,	37},
{12,	31,	32,	8,	32},
{11,	23,	34,	18,	38},
{14,	25,	34,	16,	37},
{13,	24,	32,	17,	38},
{12,	24,	32,	18,	37},
{11,	25,	38,	36,	9},
{12,	25,	39,	36,	8},
{11,	17,	16,	39,	30},
{11,	29,	25,	25,	33},
{14,	29,	28,	22,	32},
{13,	31,	23,	21,	33},
{13,	29,	25,	20,	34},
{13,	29,	24,	20,	35},
{12,	28,	25,	26,	33},
{12,	31,	23,	20,	35},
{11,	16,	39,	38,	19},
{13,	2,	38,	38,	20},
{11,	39,	24,	15,	33},
{11,	34,	35,	9,	12},
{12,	34,	35,	7,	18},
{11,	39,	19,	26,	38},
{13,	31,	22,	28,	30},
{12,	32,	22,	27,	30},
{11,	32,	36,	8,	30},
{14,	30,	36,	5,	31},
{13,	32,	38,	3,	29},
{12,	31,	36,	10,	29},
{12,	31,	39,	2,	30},
{11,	25,	27,	18,	39},
{13,	26,	25,	15,	39},
{13,	26,	27,	12,	39},
{11,	28,	30,	10,	39},
{14,	28,	27,	12,	39},
{11,	26,	30,	13,	39},
{14,	28,	27,	13,	39},
{12,	28,	28,	11,	39},
{11,	39,	25,	10,	32},
{11,	33,	29,	26,	5},
{15,	33,	26,	28,	4},
{13,	33,	26,	25,	19},
{13,	33,	26,	28,	9},
{11,	29,	39,	6,	32},
{15,	28,	37,	4,	33},
{14,	29,	34,	3,	36},
{15,	29,	34,	6,	33},
{12,	29,	35,	7,	32},
{11,	22,	30,	16,	39},
{11,	13,	21,	35,	35},
{11,	24,	28,	21,	38},
{11,	19,	39,	39,	0},
{11,	27,	28,	17,	38},
{11,	12,	23,	39,	28},
{12,	1,	22,	39,	29},
{11,	26,	36,	7,	36},
{15,	26,	36,	3,	37},
{14,	25,	35,	10,	35},
{14,	25,	36,	8,	36},
{13,	24,	39,	7,	36},
{14,	25,	37,	1,	38},
{13,	26,	38,	3,	36},
{12,	24,	37,	4,	37},
{11,	25,	35,	18,	35},
{13,	24,	36,	17,	34},
{13,	24,	35,	21,	32},
{13,	25,	34,	21,	32},
{13,	26,	33,	18,	35},
{13,	24,	35,	13,	36},
{12,	24,	37,	18,	32},
{12,	24,	39,	14,	32},
{13,	23,	38,	15,	33},
{12,	23,	39,	18,	32},
{11,	34,	27,	4,	36},
{12,	34,	28,	2,	36},
{12,	33,	27,	6,	34},
{11,	35,	26,	2,	37},
{12,	34,	25,	5,	38},
{11,	35,	35,	4,	2},
{11,	27,	28,	35,	16},
{12,	27,	19,	35,	22},
{11,	28,	33,	17,	34},
{11,	34,	28,	30,	0},
{11,	33,	28,	33,	0},
{11,	24,	36,	18,	36},
{13,	25,	34,	17,	36},
{12,	26,	34,	17,	36},
{12,	25,	36,	9,	36},
{11,	32,	24,	16,	39},
{11,	12,	37,	24,	37},
{11,	35,	30,	13,	2},
{12,	35,	30,	14,	1},
{11,	30,	26,	21,	33},
{13,	29,	30,	20,	33},
{11,	30,	34,	15,	30},
{13,	31,	32,	15,	29},
{12,	28,	34,	15,	31},
{12,	31,	34,	13,	29},
{11,	35,	28,	23,	1},
{12,	35,	25,	24,	1},
{11,	34,	31,	12,	29},
{12,	34,	30,	13,	29},
{12,	33,	33,	10,	29},
{11,	22,	15,	38,	32},
{14,	19,	17,	38,	31},
{13,	24,	20,	35,	30},
{13,	22,	18,	35,	32},
{12,	22,	20,	36,	30},
{11,	27,	39,	35,	0},
{13,	26,	39,	35,	3},
{11,	26,	39,	37,	0},
{14,	26,	20,	36,	7},
{12,	29,	20,	36,	0},
{12,	26,	21,	37,	1},
{11,	34,	31,	5,	32},
{11,	18,	34,	21,	38},
{11,	28,	26,	16,	39},
{11,	32,	32,	8,	33},
{13,	32,	34,	3,	32},
{12,	31,	32,	6,	35},
{11,	33,	29,	18,	29},
{11,	34,	32,	24,	0},
{11,	31,	33,	9,	33},
{13,	31,	31,	9,	34},
{12,	31,	31,	9,	35},
{11,	32,	22,	17,	39},
{13,	29,	22,	19,	39},
{11,	14,	36,	34,	33},
{13,	14,	36,	31,	34},
{11,	31,	33,	2,	39},
{11,	35,	27,	16,	5},
{11,	24,	35,	15,	37},
{14,	22,	36,	13,	37},
{12,	22,	35,	19,	37},
{12,	22,	35,	11,	38},
{11,	35,	35,	6,	1},
{12,	35,	32,	5,	2},
{11,	35,	31,	21,	1},
{15,	35,	32,	9,	1},
{11,	35,	33,	15,	1},
{11,	33,	36,	23,	1},
{11,	24,	22,	27,	38},
{13,	21,	23,	27,	37},
{12,	19,	22,	28,	38},
{15,	17,	23,	29,	37},
{13,	24,	21,	28,	37},
{13,	22,	21,	28,	38},
{11,	30,	23,	28,	31},
{12,	39,	17,	32,	33},
{12,	39,	18,	29,	32},
{12,	30,	19,	28,	32},
{11,	29,	23,	26,	35},
{12,	29,	23,	21,	37},
{12,	29,	25,	26,	33},
{12,	30,	23,	21,	35},
{11,	29,	26,	20,	36},
{16,	29,	28,	16,	34},
{11,	31,	26,	16,	36},
{14,	31,	26,	10,	37},
{12,	30,	27,	16,	34},
{12,	30,	26,	14,	37},
{13,	29,	26,	15,	37},
{12,	32,	26,	12,	34},
{11,	33,	35,	11,	24},
{15,	34,	35,	4,	25},
{13,	33,	36,	4,	26},
{12,	34,	35,	5,	24},
{11,	33,	26,	30,	5},
{11,	28,	27,	17,	36},
{13,	30,	27,	14,	35},
{12,	28,	29,	14,	36},
{11,	14,	36,	35,	31},
{11,	32,	22,	23,	35},
{11,	11,	35,	17,	39},
{11,	34,	35,	1,	32},
{14,	34,	32,	2,	32},
{11,	22,	37,	31,	30},
{13,	22,	39,	30,	30},
{11,	18,	23,	29,	38},
{11,	26,	38,	10,	33},
{13,	26,	38,	12,	32},
{11,	27,	39,	7,	33},
{14,	27,	35,	7,	34},
{13,	26,	39,	10,	33},
{13,	29,	36,	7,	32},
{12,	29,	38,	7,	32},
{11,	36,	27,	0,	32},
{11,	23,	39,	19,	33},
{14,	23,	39,	21,	32},
{12,	23,	39,	22,	32},
{11,	3,	36,	36,	30},
{11,	26,	30,	28,	31},
{13,	24,	29,	28,	33},
{13,	23,	31,	27,	33},
{12,	28,	26,	28,	31},
{12,	27,	31,	28,	30},
{12,	26,	28,	28,	32},
{11,	31,	31,	13,	32},
{11,	32,	30,	13,	32},
{11,	33,	30,	10,	32},
{14,	33,	27,	13,	32},
{12,	33,	29,	15,	30},
{13,	33,	28,	12,	31},
{12,	33,	30,	11,	31},
{11,	22,	24,	38,	7},
{11,	35,	25,	26,	1},
{12,	34,	24,	25,	3},
{11,	29,	27,	11,	39},
{11,	28,	25,	32,	29},
{11,	19,	26,	33,	34},
{12,	20,	18,	33,	34},
{11,	31,	28,	19,	30},
{11,	20,	33,	21,	37},
{11,	9,	27,	36,	31},
{11,	24,	19,	30,	38},
{11,	30,	25,	13,	39},
{11,	39,	25,	4,	34},
{11,	35,	27,	25,	1},
{11,	30,	35,	13,	30},
{13,	30,	35,	15,	29},
{12,	28,	35,	13,	31},
{11,	25,	22,	37,	14},
{13,	25,	24,	37,	9},
{11,	23,	34,	7,	39},
{11,	1,	21,	38,	30},
{11,	18,	38,	21,	36},
{13,	18,	36,	21,	37},
{11,	26,	24,	34,	29},
{12,	22,	22,	35,	30},
{11,	24,	22,	37,	29},
{11,	31,	30,	10,	34},
{11,	23,	28,	29,	34},
{12,	23,	30,	29,	32},
{11,	20,	28,	17,	39},
{11,	34,	25,	4,	39},
{11,	39,	25,	14,	7},
{11,	27,	23,	17,	39},
{11,	28,	23,	35,	10},
{12,	28,	25,	35,	0},
{11,	28,	31,	35,	0},
{11,	28,	28,	36,	0},
{11,	29,	25,	36,	0},
{12,	30,	24,	35,	1},
{12,	31,	23,	35,	0},
{11,	32,	30,	9,	34},
{11,	14,	28,	30,	37},
{12,	17,	25,	29,	37},
{11,	35,	31,	24,	0},
{11,	34,	35,	13,	1},
{11,	14,	38,	38,	21},
{11,	31,	23,	21,	36},
{11,	32,	28,	17,	30},
{11,	32,	26,	17,	33},
{11,	33,	28,	18,	31},
{12,	30,	28,	21,	31},
{11,	33,	29,	17,	30},
{11,	28,	39,	23,	29},
{11,	16,	36,	26,	36},
{15,	18,	30,	26,	36},
{11,	22,	20,	35,	32},
{14,	20,	22,	32,	34},
{12,	20,	20,	34,	34},
{12,	21,	23,	33,	32},
{12,	22,	12,	34,	36},
{12,	20,	21,	35,	32},
{12,	24,	21,	34,	31},
{12,	23,	23,	33,	31},
{12,	26,	19,	34,	31},
{11,	23,	34,	32,	31},
{15,	21,	28,	33,	31},
{12,	22,	28,	33,	30},
{12,	20,	28,	31,	33},
{12,	23,	31,	28,	33},
{11,	21,	34,	32,	32},
{12,	20,	36,	31,	32},
{11,	20,	31,	34,	31},
{12,	20,	35,	33,	30},
{11,	24,	26,	34,	30},
{12,	25,	27,	33,	29},
{11,	24,	16,	34,	34},
{15,	24,	19,	32,	34},
{11,	31,	33,	13,	30},
{11,	34,	25,	8,	34},
{11,	17,	29,	24,	38},
{11,	39,	25,	2,	37},
{11,	22,	30,	21,	36},
{11,	39,	14,	39,	28},
{11,	26,	22,	33,	31},
{12,	25,	25,	34,	30},
{11,	39,	18,	34,	30},
{11,	25,	34,	28,	30},
{13,	27,	34,	27,	30},
{12,	25,	33,	27,	31},
{13,	24,	35,	27,	31},
{12,	24,	34,	28,	31},
{11,	24,	38,	30,	30},
{16,	24,	39,	27,	31},
{14,	27,	36,	27,	30},
{13,	24,	39,	29,	30},
{13,	25,	27,	30,	30},
{11,	20,	30,	35,	28},
{12,	24,	25,	35,	29},
{11,	27,	23,	27,	34},
{12,	27,	24,	27,	33},
{11,	30,	36,	8,	31},
{11,	34,	30,	4,	33},
{11,	26,	20,	36,	18},
{11,	11,	34,	28,	37},
{11,	30,	31,	5,	39},
{11,	34,	35,	6,	24},
{11,	33,	28,	28,	1},
{12,	33,	29,	27,	1},
{11,	34,	29,	26,	0},
{11,	14,	39,	0,	39},
{11,	22,	36,	18,	37},
{11,	25,	29,	24,	34},
{11,	25,	36,	12,	35},
{12,	25,	36,	10,	36},
{11,	33,	27,	4,	37},
{11,	39,	14,	33,	35},
{11,	27,	26,	22,	35},
{13,	27,	25,	23,	34},
{12,	27,	25,	24,	34},
{12,	28,	24,	22,	35},
{11,	28,	24,	26,	34},
{11,	27,	24,	25,	35},
{11,	29,	32,	20,	30},
{11,	31,	24,	23,	31},
{11,	27,	29,	16,	37},
{11,	32,	25,	15,	34},
{11,	39,	15,	31,	36},
{13,	39,	14,	32,	36},
{12,	20,	14,	31,	38},
{11,	13,	32,	28,	37},
{11,	17,	31,	24,	37},
{12,	16,	30,	24,	38},
{11,	20,	21,	37,	30},
{12,	23,	20,	37,	30},
{11,	15,	25,	37,	31},
{12,	1,	24,	38,	30},
{11,	12,	27,	37,	29},
{11,	2,	27,	37,	31},
{11,	6,	28,	37,	30},
{11,	26,	39,	28,	29},
{11,	22,	26,	30,	34},
{12,	21,	26,	30,	35},
{11,	20,	35,	21,	36},
{11,	21,	24,	34,	32},
{13,	20,	24,	34,	33},
{11,	21,	26,	33,	33},
{12,	21,	20,	33,	34},
{11,	31,	33,	6,	35},
{11,	31,	32,	7,	35},
{11,	24,	32,	29,	31},
{11,	25,	30,	30,	31},
{12,	25,	26,	31,	31},
{11,	27,	30,	29,	30},
{12,	26,	25,	32,	30},
{11,	23,	38,	20,	33},
{11,	27,	35,	3,	38},
{11,	32,	34,	1,	34},
{11,	20,	38,	20,	36},
{11,	19,	39,	20,	36},
{12,	1,	39,	20,	37},
{11,	11,	39,	22,	36},
{11,	1,	39,	23,	36},
{11,	34,	26,	1,	38},
{11,	29,	28,	22,	33},
{11,	21,	17,	32,	36},
{11,	34,	27,	5,	34},
{11,	34,	26,	10,	34},
{11,	33,	26,	10,	35},
{13,	32,	25,	9,	36},
{13,	32,	25,	8,	39},
{11,	33,	26,	9,	38},
{12,	32,	26,	8,	39},
{11,	33,	26,	12,	33},
{11,	23,	25,	26,	36},
{11,	29,	26,	13,	39},
{11,	29,	32,	4,	39},
{13,	28,	33,	4,	39},
{11,	14,	37,	4,	39},
{11,	39,	16,	33,	34},
{11,	26,	18,	32,	34},
{11,	32,	21,	31,	29},
{11,	22,	25,	35,	30},
{11,	24,	37,	18,	33},
{11,	25,	34,	20,	33},
{11,	23,	38,	6,	37},
{11,	23,	35,	31,	31},
{11,	24,	32,	28,	32},
{11,	18,	31,	26,	36},
{11,	29,	27,	17,	34},
{11,	16,	21,	33,	36},
{11,	31,	34,	5,	32},
{12,	30,	35,	7,	32},
{11,	27,	30,	27,	31},
{11,	27,	33,	23,	32},
{11,	25,	36,	17,	33},
{11,	25,	24,	25,	36},
{11,	24,	27,	23,	35},
{11,	33,	23,	22,	27},
{11,	33,	25,	25,	26},
{14,	33,	25,	27,	25},
{11,	25,	38,	5,	36},
{11,	21,	35,	7,	39},
{12,	23,	35,	3,	39},
{11,	17,	35,	25,	36},
{11,	28,	21,	27,	34},
{11,	26,	19,	29,	34},
{11,	21,	12,	35,	35},
{11,	33,	36,	11,	20},
{11,	19,	37,	1,	39},
{11,	25,	25,	37,	6},
{11,	26,	21,	36,	9},
{11,	33,	24,	31,	1},
{11,	30,	21,	36,	0},
{11,	21,	35,	31,	32},
{11,	19,	33,	35,	28},
{11,	20,	27,	33,	33},
{11,	19,	25,	36,	29},
{11,	20,	21,	34,	34},
{11,	16,	27,	28,	36},
{11,	20,	27,	27,	36},
{12,	19,	31,	23,	36},
{11,	23,	27,	23,	37},
{12,	18,	29,	24,	38},
{13,	20,	27,	22,	38},
{12,	22,	28,	22,	37},
{12,	18,	26,	25,	38},
{11,	20,	33,	22,	37},
{11,	19,	27,	29,	36},
{11,	14,	24,	30,	38},
{11,	27,	36,	7,	34},
{11,	32,	34,	4,	32},
{11,	27,	35,	4,	35},
{11,	24,	35,	4,	38},
{11,	17,	23,	21,	39},
{11,	22,	25,	38,	0},
{11,	20,	29,	38,	0},
{11,	20,	26,	39,	0},
{11,	20,	24,	39,	4},
{13,	19,	28,	39,	1},
{12,	19,	24,	39,	9},
{11,	34,	36,	2,	7},
{11,	34,	37,	3,	1},
{11,	39,	29,	0,	1},
{11,	25,	36,	27,	31},
{11,	26,	31,	31,	29},
{11,	29,	22,	33,	29},
{11,	22,	25,	29,	36},
{11,	29,	25,	27,	30},
{11,	28,	21,	28,	33},
{11,	11,	36,	27,	36},
{11,	15,	38,	20,	37},
{11,	32,	27,	19,	30},
{11,	25,	36,	11,	36},
{11,	13,	31,	25,	38},
{11,	31,	34,	10,	30},
{11,	32,	31,	8,	34},
{11,	32,	26,	13,	34},
{11,	34,	25,	12,	33},
{11,	31,	39,	4,	29},
{11,	32,	37,	2,	31},
{11,	31,	38,	2,	32},
{11,	21,	33,	9,	39},
{11,	22,	31,	10,	39},
{11,	25,	20,	37,	17},
{11,	36,	30,	0,	4},
{10,	35,	39,	34,	26},
{15,	35,	25,	12,	29},
{13,	35,	31,	3,	31},
{13,	34,	37,	2,	27},
{11,	39,	30,	31,	0},
{15,	39,	26,	32,	0},
{11,	39,	24,	17,	30},
{12,	35,	25,	18,	27},
{14,	35,	25,	13,	29},
{11,	33,	35,	18,	27},
{12,	33,	37,	4,	28},
{11,	35,	37,	2,	27},
{11,	35,	33,	8,	27},
{14,	35,	31,	4,	30},
{12,	35,	31,	8,	28},
{11,	39,	25,	24,	2},
{11,	39,	24,	16,	31},
{11,	39,	25,	15,	7},
{10,	39,	39,	31,	3},
{16,	36,	31,	2,	4},
{15,	36,	30,	4,	4},
{14,	39,	25,	18,	5},
{14,	36,	27,	3,	5},
{13,	39,	26,	32,	1},
{12,	39,	26,	9,	4},
{11,	39,	25,	25,	8},
{11,	36,	39,	1,	5},
{13,	36,	33,	0,	7},
{12,	39,	28,	0,	6},
{12,	39,	35,	0,	4},
{11,	39,	26,	34,	1},
{11,	36,	29,	34,	0},
{11,	39,	26,	4,	6},
{11,	36,	36,	2,	4},
{10,	30,	39,	36,	32},
{14,	11,	39,	30,	33},
{14,	25,	37,	18,	33},
{14,	39,	20,	31,	30},
{13,	30,	26,	23,	33},
{13,	39,	17,	37,	13},
{13,	25,	25,	37,	14},
{13,	30,	22,	26,	34},
{13,	23,	26,	30,	34},
{12,	31,	22,	30,	32},
{14,	32,	24,	31,	29},
{14,	32,	21,	27,	32},
{13,	31,	24,	32,	29},
{12,	26,	37,	16,	33},
{12,	23,	26,	31,	33},
{12,	32,	21,	30,	30},
{12,	32,	21,	29,	32},
{12,	31,	30,	15,	32},
{12,	22,	27,	31,	33},
{12,	23,	28,	30,	33},
{12,	29,	19,	37,	0},
{12,	39,	19,	36,	32},
{12,	32,	24,	32,	29},
{12,	32,	21,	32,	30},
{12,	24,	22,	37,	30},
{11,	23,	37,	37,	27},
{11,	31,	32,	18,	30},
{14,	32,	30,	17,	30},
{12,	31,	31,	14,	32},
{11,	31,	20,	26,	37},
{12,	32,	21,	26,	34},
{11,	10,	39,	37,	27},
{11,	31,	24,	28,	31},
{12,	31,	23,	28,	32},
{11,	32,	24,	28,	30},
{12,	32,	23,	20,	34},
{11,	24,	29,	37,	28},
{12,	20,	32,	37,	28},
{11,	28,	29,	25,	33},
{13,	29,	26,	26,	33},
{12,	27,	26,	26,	34},
{11,	26,	39,	14,	33},
{11,	31,	26,	35,	2},
{12,	39,	20,	36,	3},
{11,	31,	23,	23,	35},
{11,	30,	27,	22,	33},
{11,	31,	21,	35,	27},
{13,	31,	24,	35,	4},
{11,	31,	33,	18,	29},
{11,	31,	30,	35,	0},
{11,	23,	28,	30,	34},
{13,	21,	29,	30,	34},
{11,	31,	27,	17,	32},
{11,	31,	28,	35,	1},
{11,	25,	26,	37,	14},
{11,	24,	22,	32,	33},
{12,	24,	21,	31,	34},
{11,	22,	20,	34,	33},
{12,	22,	19,	34,	34},
{11,	31,	36,	10,	30},
{11,	26,	26,	27,	33},
{11,	27,	25,	27,	34},
{11,	28,	25,	28,	33},
{11,	15,	26,	37,	30},
{11,	31,	22,	36,	0},
{11,	15,	39,	30,	33},
{11,	13,	39,	31,	33},
{12,	6,	37,	32,	33},
{11,	2,	38,	32,	33},
{11,	28,	33,	19,	33},
{11,	26,	28,	26,	33},
{11,	26,	23,	28,	34},
{11,	39,	20,	36,	8},
{10,	27,	39,	39,	29},
{12,	10,	29,	37,	30},
{11,	1,	28,	38,	30},
{11,	28,	17,	38,	25},
{13,	28,	19,	39,	1},
{10,	19,	27,	34,	39},
{17,	21,	11,	30,	39},
{16,	22,	13,	30,	39},
{15,	20,	23,	25,	39},
{14,	20,	17,	29,	39},
{13,	39,	13,	29,	39},
{13,	20,	23,	32,	35},
{13,	17,	28,	25,	38},
{13,	21,	12,	31,	39},
{13,	21,	25,	26,	37},
{12,	39,	12,	34,	39},
{15,	39,	13,	32,	38},
{12,	16,	33,	31,	34},
{12,	21,	16,	34,	35},
{12,	20,	27,	25,	37},
{12,	22,	14,	33,	37},
{11,	25,	24,	21,	39},
{13,	22,	23,	23,	39},
{13,	21,	24,	23,	39},
{13,	20,	24,	27,	38},
{12,	20,	27,	23,	38},
{12,	20,	24,	26,	39},
{12,	20,	23,	27,	39},
{11,	20,	27,	22,	39},
{11,	15,	30,	28,	37},
{11,	22,	24,	23,	39},
{11,	23,	25,	26,	37},
{11,	22,	26,	25,	37},
{11,	14,	31,	28,	37},
{11,	23,	26,	25,	36},
{11,	25,	26,	26,	35},
{13,	26,	25,	25,	35},
{11,	24,	27,	26,	35},
{11,	20,	19,	32,	36},
{11,	22,	14,	32,	38},
{10,	27,	33,	30,	38},
{14,	26,	21,	32,	33},
{14,	20,	31,	31,	33},
{14,	21,	35,	21,	36},
{13,	24,	34,	18,	37},
{13,	20,	34,	30,	34},
{13,	26,	23,	31,	33},
{12,	25,	34,	30,	33},
{12,	28,	33,	19,	34},
{12,	23,	34,	27,	35},
{13,	23,	36,	19,	35},
{12,	28,	30,	21,	34},
{13,	29,	27,	20,	34},
{12,	26,	22,	33,	33},
{12,	26,	21,	31,	34},
{12,	28,	18,	27,	36},
{12,	19,	34,	20,	38},
{11,	39,	17,	29,	39},
{14,	23,	18,	28,	39},
{13,	23,	16,	30,	39},
{12,	28,	18,	28,	38},
{11,	25,	34,	29,	35},
{13,	25,	35,	19,	34},
{11,	25,	35,	29,	33},
{13,	23,	37,	22,	33},
{11,	20,	34,	30,	35},
{11,	28,	24,	25,	36},
{11,	30,	27,	19,	34},
{11,	29,	24,	25,	35},
{12,	29,	27,	21,	34},
{11,	31,	26,	17,	35},
{12,	30,	26,	19,	35},
{11,	28,	27,	21,	36},
{11,	24,	34,	16,	38},
{11,	24,	31,	31,	33},
{11,	26,	34,	6,	38},
{11,	20,	36,	30,	34},
{11,	28,	24,	28,	34},
{11,	24,	25,	32,	33},
{11,	25,	20,	32,	34},
{11,	22,	19,	28,	39},
{11,	25,	27,	31,	33},
{11,	26,	24,	32,	33},
{11,	25,	27,	32,	33},
{11,	22,	35,	20,	36},
{11,	25,	35,	19,	35},
{11,	17,	34,	22,	38},
{10,	15,	37,	36,	36},
{15,	19,	36,	30,	35},
{14,	17,	33,	31,	35},
{14,	17,	31,	34,	33},
{14,	18,	14,	35,	36},
{13,	16,	38,	23,	36},
{11,	8,	37,	28,	37},
{11,	12,	15,	38,	33},
{11,	12,	13,	37,	34},
{11,	16,	37,	28,	36},
{11,	19,	23,	35,	33},
{12,	16,	31,	35,	33},
{12,	25,	15,	35,	33},
{11,	18,	28,	31,	36},
{11,	21,	21,	35,	33},
{13,	25,	17,	35,	33},
{11,	21,	19,	35,	34},
{11,	20,	14,	36,	35},
{11,	12,	16,	37,	33},
{11,	16,	21,	35,	35},
{10,	33,	32,	19,	36},
{15,	32,	32,	20,	29},
{13,	29,	29,	21,	34},
{12,	33,	33,	14,	29},
{12,	32,	34,	16,	29},
{12,	31,	33,	12,	31},
{12,	28,	33,	14,	36},
{11,	31,	31,	12,	37},
{11,	31,	28,	12,	38},
{11,	29,	33,	19,	34},
{11,	34,	29,	4,	35},
{11,	32,	34,	19,	29},
{11,	31,	35,	22,	29},
{11,	33,	34,	7,	30},
{16,	33,	34,	13,	29},
{12,	33,	35,	5,	29},
{11,	35,	34,	4,	31},
{11,	28,	30,	20,	36},
{11,	32,	36,	10,	30},
{11,	32,	36,	16,	29},
{11,	32,	35,	15,	30},
{14,	32,	36,	12,	30},
{11,	31,	33,	19,	32},
{12,	31,	33,	10,	33},
{11,	34,	32,	10,	29},
{11,	34,	31,	9,	30},
{11,	33,	31,	20,	29},
{11,	32,	35,	19,	29},
{11,	30,	29,	21,	33},
{11,	35,	32,	2,	32},
{11,	33,	27,	5,	37},
{11,	31,	36,	19,	29},
{11,	29,	32,	20,	33},
{11,	34,	35,	3,	30},
{11,	34,	35,	13,	28},
{13,	33,	35,	7,	29},
{12,	34,	35,	5,	29},
{11,	30,	31,	20,	33},
{11,	33,	26,	21,	29},
{10,	39,	25,	23,	38},
{16,	28,	24,	24,	38},
{15,	31,	26,	23,	31},
{15,	35,	25,	0,	39},
{15,	29,	28,	22,	34},
{14,	34,	26,	19,	29},
{13,	39,	25,	25,	17},
{13,	31,	25,	26,	30},
{12,	30,	26,	21,	36},
{12,	28,	25,	24,	37},
{12,	34,	26,	14,	31},
{12,	28,	27,	22,	35},
{12,	34,	26,	23,	27},
{11,	28,	26,	26,	37},
{11,	33,	25,	13,	39},
{11,	33,	26,	10,	38},
{11,	30,	20,	23,	39},
{11,	35,	25,	2,	39},
{11,	31,	20,	24,	38},
{11,	33,	31,	22,	27},
{11,	33,	26,	8,	39},
{11,	32,	26,	21,	30},
{11,	32,	25,	26,	30},
{11,	30,	27,	20,	34},
{10,	29,	35,	19,	38},
{15,	29,	36,	6,	33},
{13,	28,	37,	7,	33},
{12,	29,	37,	1,	35},
{12,	30,	35,	1,	36},
{12,	26,	36,	18,	33},
{13,	26,	37,	17,	33},
{12,	28,	39,	2,	34},
{12,	29,	36,	0,	38},
{11,	30,	30,	16,	38},
{11,	30,	35,	6,	36},
{15,	30,	35,	9,	33},
{13,	30,	35,	10,	33},
{13,	30,	36,	6,	33},
{12,	30,	34,	8,	34},
{11,	32,	35,	4,	34},
{14,	33,	33,	2,	34},
{13,	31,	34,	4,	35},
{12,	31,	35,	5,	33},
{12,	31,	34,	4,	36},
{12,	31,	34,	3,	37},
{12,	31,	35,	3,	35},
{11,	30,	26,	19,	37},
{11,	30,	27,	18,	38},
{11,	25,	34,	7,	39},
{14,	26,	34,	4,	39},
{11,	27,	34,	21,	34},
{13,	26,	35,	21,	33},
{12,	26,	35,	23,	33},
{11,	30,	34,	13,	34},
{11,	30,	34,	12,	36},
{11,	30,	32,	14,	38},
{11,	31,	39,	5,	31},
{11,	28,	37,	9,	33},
{12,	27,	36,	9,	35},
{11,	29,	37,	8,	33},
{11,	29,	37,	6,	34},
{11,	28,	36,	10,	34},
{13,	27,	36,	10,	35},
{11,	32,	37,	8,	29},
{12,	31,	37,	11,	29},
{11,	28,	27,	20,	38},
{11,	27,	34,	4,	39},
{11,	32,	34,	2,	35},
{11,	30,	36,	7,	33},
{11,	32,	38,	6,	29},
{11,	34,	35,	3,	31},
{11,	30,	37,	5,	33},
{10,	5,	36,	28,	39},
{15,	11,	34,	28,	38},
{14,	8,	36,	25,	38},
{12,	12,	34,	28,	38},
{12,	10,	35,	26,	38},
{11,	13,	34,	28,	38},
{11,	12,	35,	26,	38},
{10,	39,	22,	30,	38},
{13,	28,	23,	28,	36},
{12,	28,	25,	30,	33},
{12,	29,	23,	29,	33},
{12,	28,	24,	28,	35},
{11,	34,	24,	25,	30},
{14,	34,	26,	25,	27},
{11,	29,	21,	26,	39},
{11,	39,	19,	32,	33},
{11,	28,	24,	28,	37},
{11,	29,	24,	28,	34},
{13,	29,	25,	29,	33},
{11,	29,	24,	26,	36},
{12,	29,	25,	24,	36},
{11,	39,	19,	31,	34},
{11,	32,	21,	31,	32},
{11,	30,	20,	24,	39},
{11,	33,	25,	25,	30},
{11,	27,	18,	33,	34},
{11,	39,	19,	24,	39},
{11,	29,	23,	27,	36},
{11,	35,	25,	24,	27},
{10,	36,	33,	4,	30},
{14,	36,	29,	1,	31},
{11,	36,	35,	0,	27},
{11,	36,	39,	1,	18},
{12,	36,	34,	1,	28},
{11,	39,	27,	1,	11},
{11,	39,	28,	3,	6},
{11,	36,	28,	2,	31},
{12,	39,	26,	2,	32},
{11,	36,	34,	2,	16},
{11,	36,	39,	0,	23},
{10,	20,	35,	38,	32},
{13,	24,	26,	37,	30},
{12,	23,	23,	37,	32},
{12,	4,	36,	37,	30},
{12,	27,	17,	37,	32},
{11,	18,	39,	37,	30},
{11,	21,	22,	38,	32},
{10,	23,	39,	26,	36},
{16,	22,	39,	10,	37},
{14,	19,	34,	23,	37},
{13,	22,	39,	12,	37},
{12,	23,	36,	29,	35},
{11,	13,	38,	24,	37},
{11,	25,	35,	23,	35},
{14,	27,	35,	20,	34},
{11,	25,	35,	24,	34},
{10,	12,	38,	17,	39},
{14,	14,	37,	8,	39},
{11,	14,	37,	16,	39},
{12,	14,	38,	9,	39},
{12,	16,	31,	16,	39},
{11,	12,	36,	18,	39},
{10,	33,	37,	34,	28},
{11,	34,	37,	9,	27},
{12,	34,	36,	5,	28},
{11,	33,	23,	32,	29},
{11,	34,	26,	22,	29},
{10,	35,	26,	13,	38},
{12,	31,	26,	16,	37},
{11,	35,	31,	15,	28},
{12,	35,	27,	13,	29},
{12,	35,	28,	16,	28},
{11,	35,	28,	4,	35},
{13,	35,	28,	5,	33},
{13,	35,	29,	3,	33},
{11,	35,	26,	16,	31},
{11,	35,	26,	19,	28},
{11,	35,	28,	13,	29},
{11,	35,	28,	1,	36},
{11,	34,	27,	5,	36},
{11,	35,	26,	14,	32},
{11,	35,	26,	21,	27},
{10,	33,	29,	8,	39},
{11,	33,	27,	10,	38},
{12,	32,	27,	11,	37},
{10,	23,	32,	19,	39},
{14,	26,	32,	8,	39},
{11,	18,	28,	21,	39},
{11,	17,	28,	22,	39},
{11,	13,	33,	19,	39},
{11,	25,	32,	9,	39},
{10,	29,	32,	24,	36},
{13,	28,	30,	25,	34},
{12,	28,	29,	25,	35},
{10,	22,	36,	25,	38},
{13,	15,	35,	26,	37},
{12,	22,	37,	12,	38},
{11,	23,	36,	18,	38},
{13,	23,	37,	12,	37},
{12,	23,	38,	9,	37},
{11,	15,	38,	20,	38},
{10,	21,	11,	39,	34},
{12,	11,	12,	39,	32},
{12,	3,	13,	38,	34},
{10,	7,	19,	38,	35},
{15,	12,	17,	38,	34},
{12,	15,	17,	37,	34},
{12,	18,	14,	38,	34},
{11,	11,	22,	38,	33},
{11,	7,	20,	37,	35},
{10,	10,	35,	30,	38},
{11,	14,	34,	30,	38},
{10,	29,	20,	32,	38},
{15,	20,	23,	32,	37},
{13,	28,	24,	32,	33},
{12,	27,	23,	33,	33},
{12,	22,	15,	33,	38},
{12,	30,	20,	32,	34},
{11,	22,	15,	32,	39},
{11,	22,	19,	33,	36},
{13,	20,	22,	33,	36},
{12,	20,	22,	34,	35},
{12,	21,	20,	34,	35},
{11,	24,	15,	34,	35},
{11,	20,	23,	31,	38},
{10,	39,	23,	18,	39},
{11,	26,	23,	21,	39},
{10,	26,	38,	16,	36},
{16,	25,	39,	9,	35},
{14,	25,	36,	17,	35},
{12,	28,	37,	8,	34},
{11,	28,	37,	11,	34},
{14,	28,	36,	12,	34},
{11,	25,	37,	18,	34},
{11,	25,	39,	13,	34},
{12,	24,	39,	10,	36},
{10,	30,	26,	18,	39},
{12,	31,	25,	15,	39},
{11,	31,	27,	10,	39},
{10,	31,	33,	19,	36},
{12,	30,	33,	14,	37},
{11,	30,	34,	19,	34},
{12,	30,	35,	14,	33},
{10,	39,	25,	11,	39},
{10,	31,	34,	35,	20},
{10,	33,	34,	35,	17},
{14,	39,	21,	35,	23},
{13,	39,	23,	35,	17},
{11,	35,	25,	36,	0},
{13,	33,	26,	36,	0},
{11,	31,	26,	36,	2},
{13,	31,	24,	36,	6},
{11,	33,	23,	35,	20},
{11,	32,	22,	36,	3},
{10,	32,	38,	13,	31},
{15,	32,	33,	16,	31},
{12,	31,	34,	14,	32},
{12,	33,	34,	7,	31},
{11,	32,	33,	13,	34},
{11,	32,	35,	6,	33},
{11,	31,	34,	9,	34},
{11,	31,	35,	11,	33},
{13,	31,	34,	14,	33},
{11,	31,	34,	16,	33},
{11,	33,	37,	3,	30},
{11,	32,	33,	15,	32},
{11,	31,	35,	6,	34},
{11,	32,	36,	3,	32},
{10,	36,	29,	5,	31},
{14,	36,	31,	5,	7},
{12,	36,	33,	5,	6},
{11,	39,	26,	6,	7},
{11,	39,	27,	5,	7},
{10,	14,	30,	31,	38},
{13,	16,	30,	31,	37},
{10,	15,	34,	32,	37},
{12,	16,	34,	30,	38},
{13,	20,	34,	26,	37},
{11,	16,	36,	26,	37},
{12,	9,	36,	28,	38},
{10,	15,	39,	32,	34},
{10,	23,	39,	30,	35},
{10,	4,	39,	29,	36},
{10,	2,	37,	21,	39},
{11,	5,	37,	19,	39},
{10,	31,	28,	30,	31},
{12,	31,	33,	20,	30},
{11,	32,	30,	21,	30},
{12,	31,	32,	21,	30},
{11,	32,	25,	32,	29},
{11,	33,	29,	20,	30},
{11,	31,	27,	20,	32},
{10,	33,	26,	24,	34},
{13,	30,	26,	23,	35},
{12,	31,	24,	28,	32},
{12,	32,	26,	26,	30},
{12,	34,	24,	24,	31},
{12,	31,	23,	25,	33},
{13,	30,	23,	26,	34},
{12,	30,	23,	26,	35},
{11,	30,	25,	29,	33},
{11,	30,	29,	24,	33},
{11,	30,	27,	26,	33},
{11,	31,	26,	20,	36},
{11,	33,	23,	27,	31},
{12,	32,	24,	28,	31},
{11,	39,	23,	24,	32},
{11,	32,	26,	26,	31},
{11,	33,	23,	26,	32},
{13,	32,	23,	25,	34},
{11,	30,	25,	24,	35},
{11,	30,	24,	24,	36},
{11,	32,	26,	27,	30},
{11,	31,	24,	26,	33},
{11,	31,	27,	22,	32},
{10,	11,	34,	37,	33},
{10,	27,	30,	16,	39},
{13,	24,	28,	18,	39},
{12,	24,	30,	18,	39},
{10,	18,	34,	34,	35},
{16,	16,	32,	32,	37},
{13,	18,	28,	32,	37},
{12,	18,	35,	32,	34},
{12,	16,	38,	31,	34},
{11,	17,	32,	36,	33},
{11,	18,	32,	35,	33},
{10,	29,	24,	37,	28},
{14,	30,	21,	37,	23},
{14,	28,	22,	38,	5},
{11,	28,	21,	39,	5},
{10,	29,	39,	37,	1},
{12,	29,	26,	37,	2},
{13,	28,	25,	37,	15},
{11,	28,	29,	38,	1},
{11,	28,	26,	37,	6},
{10,	39,	30,	34,	0},
{13,	37,	31,	32,	0},
{10,	30,	38,	37,	1},
{12,	30,	22,	37,	14},
{10,	32,	32,	28,	29},
{10,	28,	19,	30,	39},
{11,	22,	19,	31,	39},
{11,	20,	21,	30,	39},
{10,	28,	39,	13,	34},
{12,	28,	36,	16,	34},
{11,	29,	37,	13,	33},
{14,	30,	36,	11,	33},
{11,	29,	37,	9,	34},
{10,	34,	32,	18,	29},
{13,	35,	28,	15,	29},
{10,	21,	35,	13,	39},
{10,	23,	37,	8,	39},
{13,	22,	34,	10,	39},
{12,	22,	35,	10,	39},
{11,	22,	36,	10,	39},
{11,	18,	36,	13,	39},
{10,	34,	32,	3,	36},
{12,	35,	32,	3,	32},
{11,	35,	29,	1,	36},
{10,	36,	36,	33,	0},
{10,	33,	28,	13,	37},
{13,	31,	27,	13,	38},
{11,	31,	27,	15,	37},
{11,	32,	29,	10,	37},
{10,	26,	35,	31,	33},
{10,	29,	28,	16,	39},
{11,	30,	28,	10,	39},
{10,	30,	27,	18,	39},
{10,	15,	32,	31,	38},
{10,	24,	38,	22,	35},
{10,	31,	27,	38,	0},
{13,	39,	21,	37,	5},
{11,	29,	19,	38,	7},
{11,	30,	20,	38,	3},
{10,	35,	30,	0,	39},
{13,	35,	31,	0,	37},
{12,	35,	31,	0,	38},
{10,	33,	35,	6,	33},
{11,	33,	33,	9,	32},
{11,	33,	34,	9,	30},
{11,	34,	35,	4,	31},
{11,	33,	35,	1,	34},
{11,	33,	35,	7,	30},
{10,	35,	29,	10,	32},
{13,	34,	27,	14,	30},
{12,	34,	28,	15,	30},
{10,	30,	30,	19,	37},
{10,	22,	38,	19,	38},
{11,	22,	39,	17,	37},
{10,	23,	36,	23,	38},
{10,	25,	35,	25,	36},
{12,	24,	35,	20,	38},
{12,	24,	35,	26,	35},
{11,	24,	34,	22,	37},
{10,	25,	37,	20,	36},
{10,	26,	35,	26,	35},
{10,	16,	36,	28,	38},
{12,	13,	35,	30,	37},
{10,	22,	27,	23,	39},
{10,	26,	31,	16,	39},
{10,	27,	19,	34,	35},
{13,	28,	18,	34,	33},
{12,	27,	21,	34,	33},
{11,	27,	20,	33,	34},
{10,	28,	24,	21,	39},
{10,	31,	23,	21,	39},
{10,	21,	23,	39,	30},
{10,	35,	31,	15,	29},
{11,	35,	31,	6,	30},
{10,	34,	35,	21,	28},
{10,	29,	36,	11,	35},
{11,	29,	37,	5,	35},
{12,	27,	37,	7,	35},
{11,	29,	37,	12,	34},
{11,	27,	38,	5,	35},
{10,	8,	31,	23,	39},
{11,	8,	32,	20,	39},
{10,	28,	32,	20,	38},
{10,	29,	28,	23,	37},
{12,	28,	28,	21,	38},
{11,	28,	29,	21,	37},
{10,	35,	30,	35,	0},
{10,	11,	26,	38,	33},
{10,	35,	31,	18,	27},
{10,	36,	36,	5,	6},
{10,	13,	38,	25,	37},
{10,	34,	39,	10,	27},
{13,	33,	38,	14,	27},
{13,	34,	36,	13,	27},
{11,	33,	38,	8,	28},
{10,	23,	39,	1,	39},
{13,	18,	38,	4,	39},
{11,	17,	38,	8,	39},
{10,	30,	36,	12,	34},
{11,	30,	35,	11,	35},
{10,	34,	32,	4,	35},
{10,	32,	35,	13,	32},
{11,	31,	35,	12,	33},
{10,	28,	23,	30,	38},
{10,	30,	28,	19,	38},
{10,	33,	31,	1,	38},
{12,	32,	30,	6,	37},
{10,	33,	38,	6,	30},
{10,	32,	27,	35,	23},
{10,	28,	32,	8,	39},
{10,	33,	23,	19,	39},
{10,	32,	27,	10,	39},
{10,	32,	26,	13,	39},
{10,	31,	26,	16,	39},
{10,	31,	26,	17,	38},
{10,	22,	39,	37,	30},
{11,	21,	33,	38,	30},
{10,	22,	35,	37,	32},
{14,	21,	29,	38,	32},
{10,	34,	32,	23,	27},
{10,	34,	33,	14,	29},
{10,	36,	31,	5,	19},
{10,	33,	33,	7,	34},
{11,	33,	33,	9,	33},
{10,	24,	36,	6,	39},
{11,	24,	37,	3,	39},
{10,	26,	36,	8,	38},
{10,	26,	37,	13,	37},
{12,	25,	37,	8,	38},
{10,	25,	36,	18,	38},
{10,	24,	38,	8,	38},
{10,	16,	39,	27,	36},
{10,	39,	26,	6,	10},
{10,	39,	27,	0,	32},
{10,	24,	39,	20,	34},
{10,	20,	20,	34,	38},
{13,	21,	17,	34,	38},
{13,	22,	16,	34,	38},
{11,	20,	15,	35,	36},
{11,	21,	17,	35,	35},
{10,	23,	20,	34,	36},
{11,	27,	20,	34,	34},
{10,	27,	37,	17,	33},
{12,	27,	37,	16,	34},
{10,	28,	36,	15,	35},
{10,	35,	28,	7,	33},
{10,	9,	39,	29,	36},
{10,	24,	39,	6,	38},
{11,	22,	39,	12,	38},
{10,	36,	31,	32,	1},
{10,	26,	36,	14,	38},
{10,	30,	34,	20,	33},
{11,	28,	35,	20,	33},
{10,	31,	31,	13,	37},
{10,	34,	33,	2,	35},
{10,	24,	36,	30,	33},
{11,	24,	36,	24,	34},
{10,	31,	24,	18,	39},
{10,	32,	29,	13,	37},
{10,	30,	23,	30,	34},
{13,	30,	25,	30,	33},
{10,	32,	23,	27,	35},
{10,	30,	35,	16,	34},
{10,	24,	38,	21,	36},
{10,	25,	28,	18,	39},
{10,	15,	37,	26,	37},
{10,	34,	24,	26,	29},
{14,	34,	26,	27,	27},
{10,	34,	26,	27,	28},
{10,	35,	28,	18,	28},
{10,	28,	24,	28,	38},
{10,	34,	27,	28,	27},
{10,	31,	29,	10,	38},
{10,	17,	39,	31,	34},
{11,	17,	37,	31,	35},
{10,	17,	36,	36,	33},
{10,	29,	19,	28,	39},
{10,	31,	34,	13,	34},
{10,	35,	30,	1,	36},
{10,	35,	30,	4,	33},
{10,	33,	23,	24,	36},
{10,	33,	27,	36,	0},
{10,	39,	15,	31,	39},
{10,	37,	32,	32,	0},
{10,	39,	20,	39,	0},
{13,	29,	21,	39,	2},
{11,	29,	22,	38,	5},
{10,	34,	27,	17,	30},
{10,	31,	34,	6,	35},
{10,	35,	26,	1,	39},
{11,	34,	26,	2,	39},
{10,	28,	31,	25,	35},
{10,	32,	26,	29,	30},
{11,	32,	26,	28,	31},
{10,	34,	27,	27,	28},
{10,	34,	29,	23,	28},
{10,	36,	29,	32,	2},
{10,	39,	28,	33,	2},
{12,	39,	26,	34,	2},
{10,	30,	21,	31,	34},
{10,	31,	27,	25,	32},
{10,	32,	34,	0,	39},
{10,	28,	26,	38,	3},
{10,	36,	34,	4,	10},
{10,	30,	33,	3,	39},
{10,	35,	34,	2,	32},
{10,	25,	35,	28,	34},
{11,	24,	35,	28,	35},
{10,	28,	25,	25,	38},
{10,	13,	38,	14,	39},
{10,	33,	30,	3,	37},
{10,	23,	21,	39,	30},
{11,	23,	13,	39,	31},
{10,	19,	23,	36,	33},
{11,	18,	16,	36,	35},
{12,	16,	17,	38,	34},
{10,	33,	34,	10,	30},
{10,	28,	28,	37,	4},
{10,	30,	30,	37,	2},
{10,	30,	24,	38,	3},
{10,	31,	34,	23,	29},
{10,	24,	39,	9,	37},
{10,	9,	36,	19,	39},
{10,	34,	28,	5,	35},
{10,	31,	24,	35,	27},
{10,	26,	34,	21,	36},
{10,	18,	36,	26,	37},
{10,	28,	29,	21,	38},
{10,	26,	39,	16,	33},
{10,	30,	34,	13,	35},
{10,	22,	20,	36,	33},
{12,	26,	16,	36,	33},
{10,	28,	18,	36,	33},
{10,	21,	21,	31,	38},
{10,	25,	25,	31,	35},
{14,	20,	26,	32,	35},
{12,	21,	24,	31,	36},
{11,	23,	22,	31,	37},
{11,	22,	27,	31,	34},
{11,	21,	25,	31,	37},
{10,	23,	22,	31,	38},
{10,	27,	23,	31,	34},
{10,	20,	22,	30,	39},
{10,	32,	27,	11,	38},
{10,	32,	36,	1,	34},
{10,	31,	36,	12,	33},
{12,	31,	36,	5,	34},
{10,	31,	37,	0,	38},
{11,	30,	37,	5,	34},
{11,	32,	38,	0,	34},
{11,	31,	36,	2,	35},
{10,	28,	37,	1,	38},
{13,	27,	38,	3,	36},
{12,	30,	37,	1,	36},
{10,	27,	37,	13,	37},
{14,	27,	37,	16,	35},
{11,	27,	38,	6,	36},
{10,	27,	38,	13,	36},
{10,	28,	36,	8,	36},
{10,	29,	36,	5,	37},
{10,	33,	39,	0,	32},
{10,	18,	35,	35,	33},
{10,	28,	24,	37,	29},
{11,	28,	18,	37,	32},
{10,	24,	36,	23,	35},
{10,	25,	36,	21,	34},
{10,	32,	22,	35,	26},
{10,	14,	38,	22,	37},
{10,	25,	33,	8,	39},
{10,	28,	19,	39,	14},
{10,	39,	15,	38,	32},
{10,	18,	36,	31,	35},
{10,	24,	37,	24,	33},
{10,	31,	28,	35,	23},
{10,	16,	31,	33,	36},
{10,	28,	25,	28,	34},
{10,	33,	24,	35,	22},
{10,	28,	18,	33,	35},
{10,	16,	23,	36,	34},
{10,	19,	24,	35,	35},
{11,	16,	24,	35,	36},
{11,	21,	20,	35,	35},
{10,	19,	27,	36,	33},
{10,	20,	25,	35,	33},
{10,	34,	26,	14,	33},
{10,	26,	38,	1,	38},
{10,	35,	31,	1,	34},
{10,	35,	31,	3,	33},
{10,	25,	35,	2,	39},
{10,	11,	29,	20,	39},
{10,	36,	27,	1,	32},
{10,	11,	12,	39,	33},
{10,	31,	22,	38,	3},
{10,	36,	36,	4,	7},
{10,	28,	27,	24,	37},
{10,	17,	29,	32,	37},
{10,	18,	33,	31,	36},
{10,	17,	32,	31,	37},
{10,	12,	37,	28,	37},
{10,	34,	25,	25,	29},
{10,	34,	26,	24,	29},
{10,	20,	23,	32,	38},
{10,	29,	36,	12,	35},
{10,	31,	28,	14,	37},
{10,	20,	19,	32,	39},
{10,	32,	39,	5,	30},
{10,	33,	39,	3,	30},
{10,	31,	35,	5,	35},
{10,	34,	38,	0,	30},
{10,	25,	38,	0,	39},
{10,	37,	39,	0,	4},
{10,	31,	28,	9,	39},
{9,	36,	39,	38,	33},
{12,	39,	18,	39,	19},
{12,	30,	37,	8,	34},
{12,	17,	39,	32,	34},
{12,	27,	38,	16,	34},
{12,	31,	37,	4,	34},
{11,	36,	27,	3,	34},
{12,	39,	27,	0,	34},
{11,	28,	31,	28,	34},
{11,	31,	21,	33,	34},
{13,	21,	22,	32,	38},
{12,	26,	21,	34,	34},
{11,	29,	39,	12,	34},
{11,	39,	26,	0,	36},
{11,	25,	38,	19,	34},
{11,	30,	38,	7,	34},
{11,	28,	37,	16,	34},
{11,	32,	23,	28,	34},
{11,	28,	27,	26,	35},
{11,	36,	27,	0,	35},
{10,	39,	24,	26,	38},
{13,	32,	23,	27,	36},
{13,	29,	25,	24,	38},
{13,	29,	27,	24,	37},
{12,	31,	23,	27,	38},
{11,	39,	23,	28,	34},
{10,	28,	39,	39,	4},
{14,	28,	27,	39,	6},
{11,	28,	23,	39,	10},
{10,	29,	35,	23,	35},
{14,	27,	34,	25,	35},
{14,	29,	33,	24,	34},
{12,	28,	33,	23,	36},
{11,	28,	34,	21,	36},
{11,	27,	35,	25,	34},
{10,	33,	30,	20,	34},
{12,	31,	31,	20,	34},
{10,	30,	31,	26,	34},
{13,	29,	25,	25,	36},
{13,	29,	25,	28,	34},
{12,	32,	26,	25,	34},
{11,	29,	33,	25,	34},
{11,	32,	25,	25,	35},
{10,	34,	26,	19,	35},
{11,	34,	26,	15,	36},
{10,	35,	31,	5,	34},
{10,	29,	27,	39,	5},
{12,	29,	19,	39,	26},
{10,	27,	34,	21,	38},
{10,	33,	29,	21,	34},
{13,	31,	31,	21,	34},
{12,	31,	27,	24,	34},
{10,	39,	20,	31,	36},
{13,	30,	20,	32,	36},
{10,	31,	21,	33,	35},
{13,	25,	22,	32,	35},
{11,	24,	22,	33,	35},
{11,	26,	22,	32,	35},
{11,	31,	22,	31,	35},
{10,	29,	28,	26,	35},
{10,	39,	27,	8,	5},
{10,	39,	27,	38,	0},
{10,	29,	34,	25,	34},
{10,	29,	25,	27,	36},
{10,	27,	35,	21,	36},
{10,	20,	30,	32,	34},
{11,	19,	29,	32,	36},
{10,	19,	36,	32,	34},
{10,	23,	24,	32,	35},
{13,	21,	24,	32,	37},
{11,	28,	23,	32,	34},
{10,	19,	36,	31,	35},
{10,	19,	32,	34,	35},
{10,	36,	29,	1,	34},
{10,	34,	30,	5,	35},
{10,	30,	20,	39,	8},
{10,	30,	32,	21,	34},
{10,	32,	27,	23,	34},
{10,	27,	34,	26,	35},
{10,	16,	37,	34,	34},
{10,	22,	36,	33,	34},
{15,	20,	33,	34,	34},
{11,	23,	36,	31,	34},
{13,	23,	26,	33,	34},
{11,	24,	25,	32,	35},
{11,	21,	24,	33,	36},
{11,	20,	23,	35,	35},
{10,	21,	32,	35,	34},
{13,	16,	28,	35,	36},
{12,	19,	26,	35,	35},
{11,	16,	33,	35,	35},
{11,	16,	29,	36,	34},
{10,	22,	36,	31,	35},
{12,	23,	28,	31,	35},
{10,	22,	23,	34,	35},
{10,	19,	34,	34,	35},
{10,	28,	25,	28,	36},
{10,	25,	35,	20,	37},
{10,	39,	19,	39,	19},
{10,	21,	25,	32,	37},
{10,	19,	33,	35,	34},
{10,	16,	36,	33,	35},
{10,	19,	33,	31,	36},
{10,	25,	36,	23,	34},
{10,	19,	29,	31,	37},
{10,	24,	22,	34,	34},
{9,	36,	31,	28,	38},
{12,	35,	32,	2,	36},
{12,	34,	27,	2,	39},
{11,	32,	30,	8,	39},
{14,	33,	30,	2,	39},
{11,	36,	33,	0,	36},
{11,	36,	33,	1,	34},
{11,	30,	32,	15,	37},
{10,	39,	26,	2,	39},
{10,	32,	33,	2,	39},
{13,	32,	32,	4,	37},
{11,	32,	34,	1,	36},
{10,	29,	26,	30,	34},
{11,	28,	24,	30,	35},
{10,	32,	27,	13,	39},
{11,	31,	27,	16,	39},
{10,	39,	27,	0,	39},
{10,	35,	32,	4,	35},
{10,	34,	29,	1,	39},
{10,	36,	29,	0,	39},
{10,	28,	32,	21,	37},
{10,	34,	27,	3,	39},
{11,	34,	26,	4,	39},
{11,	35,	26,	3,	39},
{10,	36,	34,	0,	35},
{10,	35,	33,	1,	35},
{9,	28,	39,	34,	38},
{15,	29,	22,	32,	36},
{12,	29,	26,	32,	34},
{12,	29,	33,	24,	35},
{12,	20,	26,	35,	35},
{12,	29,	19,	33,	37},
{12,	16,	37,	35,	35},
{11,	29,	37,	5,	37},
{11,	31,	22,	31,	36},
{11,	31,	38,	0,	38},
{11,	18,	37,	35,	34},
{11,	29,	19,	33,	38},
{10,	29,	36,	18,	36},
{13,	30,	36,	14,	34},
{11,	29,	36,	20,	34},
{11,	30,	36,	15,	34},
{10,	30,	22,	34,	34},
{12,	31,	21,	34,	34},
{10,	29,	36,	7,	37},
{10,	29,	37,	6,	37},
{10,	30,	21,	33,	36},
{10,	29,	21,	33,	38},
{10,	16,	37,	35,	36},
{10,	31,	39,	0,	37},
{10,	30,	39,	1,	35},
{10,	29,	39,	7,	35},
{10,	29,	38,	6,	36},
{10,	21,	26,	35,	35},
{9,	39,	39,	38,	4},
{11,	37,	29,	1,	5},
{10,	39,	38,	1,	5},
{10,	39,	27,	10,	5},
{9,	27,	39,	38,	35},
{12,	28,	29,	35,	34},
{10,	17,	37,	36,	36},
{10,	20,	35,	35,	36},
{10,	22,	24,	36,	36},
{10,	23,	32,	35,	36},
{10,	28,	22,	36,	35},
{10,	28,	19,	35,	36},
{10,	28,	28,	35,	35},
{10,	19,	37,	35,	36},
{10,	22,	33,	35,	36},
{10,	28,	23,	36,	35},
{9,	21,	36,	30,	39},
{12,	22,	32,	20,	39},
{12,	22,	24,	24,	39},
{11,	22,	21,	28,	39},
{11,	22,	24,	25,	39},
{10,	22,	34,	18,	39},
{10,	23,	28,	21,	39},
{11,	22,	32,	21,	39},
{11,	22,	28,	22,	39},
{10,	28,	26,	23,	39},
{11,	23,	27,	23,	39},
{10,	25,	27,	21,	39},
{13,	24,	28,	21,	39},
{10,	20,	27,	31,	39},
{10,	22,	36,	13,	39},
{10,	23,	21,	28,	39},
{10,	23,	20,	30,	39},
{10,	26,	27,	19,	39},
{10,	24,	29,	19,	39},
{9,	32,	35,	19,	38},
{13,	32,	36,	1,	36},
{12,	34,	35,	0,	36},
{12,	30,	36,	2,	37},
{11,	34,	39,	0,	34},
{11,	34,	37,	0,	36},
{11,	30,	38,	1,	37},
{10,	33,	33,	8,	36},
{11,	34,	33,	2,	36},
{10,	33,	32,	4,	38},
{12,	33,	37,	0,	37},
{10,	30,	36,	19,	34},
{10,	36,	36,	0,	35},
{10,	34,	34,	0,	37},
{10,	36,	32,	0,	37},
{10,	32,	36,	2,	36},
{10,	36,	39,	0,	34},
{10,	35,	33,	1,	36},
{9,	19,	27,	36,	38},
{11,	39,	14,	35,	37},
{12,	20,	19,	35,	38},
{11,	23,	13,	35,	38},
{10,	19,	36,	36,	36},
{9,	30,	39,	39,	27},
{10,	31,	23,	39,	28},
{9,	35,	28,	30,	37},
{14,	29,	24,	29,	38},
{13,	30,	26,	31,	34},
{13,	29,	23,	32,	36},
{12,	31,	23,	30,	38},
{11,	29,	26,	32,	35},
{11,	31,	23,	31,	35},
{11,	30,	24,	29,	38},
{11,	30,	26,	31,	35},
{11,	39,	25,	30,	34},
{10,	39,	23,	30,	38},
{10,	30,	29,	30,	34},
{10,	30,	23,	31,	36},
{9,	38,	39,	21,	5},
{13,	39,	32,	21,	5},
{11,	39,	27,	33,	5},
{10,	39,	39,	1,	5},
{9,	28,	33,	21,	39},
{11,	23,	34,	16,	39},
{10,	25,	34,	16,	39},
{11,	24,	35,	8,	39},
{10,	24,	29,	23,	39},
{10,	29,	29,	16,	39},
{10,	25,	29,	22,	39},
{9,	17,	39,	17,	39},
{10,	21,	37,	18,	39},
{12,	18,	38,	14,	39},
{11,	22,	37,	11,	39},
{9,	21,	27,	38,	36},
{11,	22,	28,	36,	36},
{10,	22,	18,	38,	36},
{9,	39,	37,	27,	5},
{13,	37,	38,	25,	5},
{12,	38,	39,	22,	5},
{11,	39,	38,	4,	5},
{10,	39,	28,	28,	5},
{10,	39,	38,	5,	5},
{9,	18,	38,	23,	39},
{10,	19,	37,	19,	39},
{9,	39,	23,	26,	39},
{10,	28,	24,	26,	39},
{9,	33,	35,	26,	34},
{15,	31,	32,	27,	34},
{11,	30,	32,	22,	36},
{14,	30,	33,	21,	35},
{11,	29,	32,	26,	36},
{10,	32,	32,	25,	35},
{10,	33,	34,	7,	35},
{10,	30,	36,	22,	34},
{10,	33,	32,	22,	35},
{10,	33,	33,	11,	35},
{10,	30,	33,	20,	36},
{12,	29,	34,	20,	36},
{9,	35,	36,	17,	34},
{13,	34,	33,	4,	35},
{13,	35,	32,	5,	35},
{11,	34,	32,	8,	35},
{11,	34,	34,	4,	35},
{11,	36,	36,	1,	34},
{10,	33,	36,	22,	34},
{9,	38,	34,	0,	38},
{12,	38,	35,	0,	29},
{12,	38,	36,	0,	26},
{10,	37,	37,	3,	6},
{10,	37,	30,	0,	39},
{10,	38,	39,	0,	9},
{9,	34,	26,	19,	39},
{10,	29,	27,	19,	39},
{9,	29,	39,	28,	35},
{10,	31,	32,	27,	35},
{10,	31,	34,	27,	34},
{10,	29,	37,	9,	36},
{10,	29,	38,	8,	36},
{10,	30,	36,	23,	34},
{9,	31,	36,	18,	37},
{12,	30,	38,	4,	35},
{11,	30,	37,	4,	36},
{10,	31,	37,	2,	37},
{10,	30,	36,	19,	35},
{10,	31,	36,	1,	38},
{9,	29,	23,	39,	33},
{12,	30,	24,	39,	29},
{10,	14,	14,	39,	34},
{9,	32,	33,	8,	39},
{9,	35,	29,	7,	39},
{10,	36,	29,	1,	39},
{10,	34,	27,	8,	39},
{10,	36,	27,	2,	39},
{9,	18,	39,	39,	30},
{10,	19,	24,	39,	33},
{10,	25,	24,	39,	31},
{9,	29,	38,	16,	38},
{13,	31,	36,	3,	38},
{11,	30,	38,	3,	37},
{10,	30,	38,	2,	38},
{9,	39,	27,	3,	38},
{11,	39,	27,	5,	8},
{9,	31,	28,	19,	39},
{9,	28,	19,	34,	39},
{9,	39,	20,	30,	39},
{9,	37,	36,	1,	18},
{11,	39,	28,	2,	17},
{10,	37,	37,	2,	7},
{9,	37,	31,	1,	33},
{11,	37,	35,	1,	19},
{9,	31,	30,	13,	39},
{9,	31,	27,	21,	39},
{9,	30,	36,	19,	38},
{9,	29,	38,	29,	36},
{12,	29,	31,	30,	34},
{11,	29,	30,	29,	37},
{10,	30,	30,	29,	34},
{10,	30,	33,	21,	36},
{9,	33,	23,	31,	37},
{12,	30,	19,	33,	37},
{10,	39,	19,	33,	38},
{11,	30,	21,	31,	38},
{10,	39,	21,	31,	38},
{9,	34,	36,	6,	35},
{10,	34,	33,	8,	35},
{9,	20,	28,	35,	38},
{9,	39,	4,	39,	35},
{9,	24,	28,	26,	39},
{10,	22,	29,	24,	39},
{9,	26,	34,	18,	39},
{9,	14,	38,	36,	36},
{9,	39,	24,	30,	38},
{9,	39,	24,	18,	39},
{9,	39,	27,	29,	7},
{11,	39,	27,	11,	8},
{9,	30,	32,	29,	36},
{11,	30,	34,	28,	34},
{11,	31,	33,	28,	34},
{10,	30,	29,	29,	37},
{9,	36,	33,	1,	38},
{14,	35,	32,	2,	37},
{13,	34,	33,	2,	37},
{10,	34,	32,	3,	38},
{9,	34,	34,	4,	37},
{10,	33,	34,	5,	36},
{9,	33,	34,	6,	38},
{9,	33,	36,	7,	36},
{13,	33,	35,	1,	38},
{11,	33,	36,	1,	37},
{10,	34,	36,	2,	36},
{9,	30,	32,	32,	34},
{10,	30,	30,	30,	35},
{9,	33,	35,	10,	36},
{10,	33,	34,	16,	35},
{10,	33,	35,	11,	35},
{10,	33,	33,	11,	36},
{9,	30,	38,	10,	36},
{10,	30,	37,	11,	36},
{9,	31,	39,	13,	35},
{14,	31,	38,	5,	36},
{11,	31,	38,	6,	36},
{11,	30,	38,	14,	35},
{10,	32,	39,	1,	35},
{10,	32,	38,	1,	37},
{9,	31,	39,	25,	34},
{10,	32,	36,	25,	34},
{9,	32,	39,	11,	35},
{11,	32,	38,	3,	36},
{11,	32,	37,	5,	36},
{10,	32,	36,	8,	36},
{9,	30,	32,	11,	39},
{10,	29,	31,	13,	39},
{9,	39,	20,	36,	35},
{10,	31,	21,	35,	34},
{9,	27,	28,	23,	39},
{9,	21,	27,	36,	37},
{9,	32,	30,	29,	35},
{11,	31,	30,	30,	34},
{9,	32,	29,	31,	35},
{13,	30,	30,	31,	35},
{9,	31,	20,	33,	38},
{9,	36,	34,	5,	34},
{9,	29,	33,	31,	35},
{11,	29,	36,	30,	34},
{11,	29,	35,	30,	35},
{9,	39,	39,	1,	6},
{11,	39,	29,	1,	9},
{10,	39,	35,	0,	8},
{9,	32,	28,	13,	39},
{9,	32,	32,	28,	35},
{9,	30,	33,	20,	37},
{9,	29,	35,	22,	37},
{9,	30,	38,	5,	38},
{9,	29,	26,	30,	38},
{10,	30,	25,	29,	38},
{9,	34,	34,	3,	38},
{9,	31,	23,	32,	36},
{11,	39,	22,	32,	34},
{10,	31,	30,	32,	34},
{10,	30,	26,	32,	35},
{9,	31,	22,	35,	35},
{10,	31,	23,	34,	34},
{9,	30,	23,	33,	37},
{10,	31,	22,	33,	36},
{10,	29,	23,	35,	35},
{10,	31,	21,	33,	37},
{9,	39,	22,	32,	37},
{9,	29,	37,	17,	38},
{9,	34,	32,	12,	35},
{9,	31,	35,	28,	34},
{9,	30,	30,	30,	36},
{10,	29,	31,	30,	36},
{9,	31,	26,	33,	34},
{11,	29,	25,	33,	35},
{10,	29,	24,	34,	35},
{9,	33,	32,	7,	38},
{10,	33,	33,	7,	37},
{9,	30,	35,	29,	34},
{9,	21,	27,	31,	39},
{9,	29,	28,	21,	39},
{9,	29,	34,	30,	36},
{9,	32,	24,	21,	39},
{9,	39,	18,	33,	39},
{9,	22,	34,	21,	39},
{9,	25,	34,	20,	39},
{9,	25,	35,	6,	39},
{9,	26,	29,	23,	39},
{9,	37,	39,	24,	5},
{9,	19,	38,	35,	36},
{9,	32,	39,	1,	37},
{9,	35,	36,	1,	35},
{9,	30,	29,	30,	37},
{9,	33,	23,	32,	35},
{9,	22,	26,	35,	37},
{10,	24,	18,	35,	37},
{10,	22,	18,	36,	37},
{9,	34,	34,	7,	35},
{9,	35,	34,	1,	37},
{9,	28,	28,	36,	34},
{9,	33,	33,	0,	39},
{9,	30,	30,	29,	37},
{9,	37,	29,	4,	6},
{10,	39,	28,	4,	7},
{9,	30,	27,	33,	34},
{9,	29,	27,	34,	34},
{9,	23,	20,	32,	39},
{9,	34,	32,	4,	38},
{9,	28,	34,	3,	39},
{9,	34,	32,	5,	36},
{9,	36,	32,	2,	36},
{9,	36,	32,	3,	35},
{9,	24,	36,	7,	39},
{9,	37,	30,	2,	8},
{9,	31,	23,	39,	30},
{8,	39,	39,	39,	38},
{9,	39,	28,	1,	39},
{8,	26,	37,	35,	39},
{12,	27,	24,	28,	39},
{12,	28,	20,	32,	39},
{11,	29,	22,	27,	39},
{11,	25,	39,	1,	39},
{10,	29,	22,	29,	39},
{10,	27,	26,	26,	39},
{10,	26,	39,	1,	39},
{9,	13,	21,	36,	39},
{13,	39,	8,	36,	39},
{9,	21,	38,	23,	39},
{11,	21,	39,	3,	39},
{10,	19,	39,	5,	39},
{9,	25,	38,	14,	39},
{10,	25,	39,	3,	39},
{9,	32,	21,	29,	39},
{9,	22,	39,	8,	39},
{9,	27,	27,	25,	39},
{9,	39,	9,	36,	39},
{8,	37,	29,	19,	39},
{10,	29,	29,	20,	39},
{9,	29,	29,	21,	39},
{8,	34,	32,	18,	39},
{10,	33,	33,	2,	39},
{8,	31,	35,	21,	39},
{10,	27,	39,	0,	39},
{9,	32,	33,	11,	39},
{8,	32,	27,	32,	39},
{9,	27,	28,	27,	39},
{8,	18,	38,	29,	39},
{8,	35,	33,	8,	39},
{8,	21,	39,	18,	39},
{8,	39,	25,	21,	39},
{8,	37,	30,	7,	39},
{9,	36,	31,	4,	39},
{9,	37,	31,	0,	39},
{8,	32,	33,	18,	39},
{8,	36,	35,	1,	39},
{10,	37,	33,	0,	39},
{8,	29,	39,	3,	39},
{11,	26,	38,	5,	39},
{10,	26,	38,	7,	39},
{10,	28,	36,	5,	39},
{9,	34,	39,	0,	39},
{8,	34,	34,	4,	39},
{8,	32,	29,	21,	39},
{8,	39,	32,	0,	39},
{8,	27,	34,	22,	39},
{8,	27,	31,	32,	39},
{9,	27,	32,	26,	39},
{8,	27,	35,	26,	39},
{8,	37,	36,	0,	39},
{8,	39,	13,	36,	39},
{8,	33,	26,	21,	39},
{8,	28,	28,	24,	39},
{8,	25,	39,	6,	39},
{8,	33,	33,	10,	39},
{8,	26,	38,	11,	39},
{8,	28,	18,	35,	39},
{8,	39,	19,	33,	39},
{8,	28,	21,	33,	39},
{8,	22,	38,	16,	39},
{7,	33,	39,	32,	39},
{13,	34,	30,	19,	39},
{10,	34,	36,	1,	39},
{8,	39,	23,	32,	39},
{8,	34,	24,	22,	39},
{8,	34,	34,	5,	39},
{8,	34,	35,	2,	39},
{7,	26,	34,	39,	39},
{11,	39,	16,	36,	39},
{7,	39,	31,	19,	39},
{8,	36,	32,	9,	39},
{9,	36,	33,	2,	39},
{8,	36,	34,	2,	39},
{7,	39,	28,	28,	39},
{8,	34,	25,	29,	39},
{7,	35,	35,	18,	39},
{8,	35,	36,	4,	39},
{8,	35,	37,	1,	39},
{8,	36,	35,	2,	39},
{7,	30,	37,	34,	39},
{8,	27,	22,	36,	39},
{8,	39,	17,	36,	39},
{7,	37,	35,	8,	39},
{7,	33,	28,	34,	39},
{8,	31,	29,	34,	39},
{7,	28,	34,	36,	39},
{12,	27,	35,	35,	39},
{8,	28,	37,	35,	39},
{7,	34,	36,	19,	39},
{7,	34,	32,	23,	39},
{7,	36,	33,	16,	39},
{7,	39,	29,	21,	39},
{7,	24,	38,	33,	39},
{7,	39,	23,	35,	39},
{7,	39,	25,	30,	39},
{7,	35,	31,	21,	39},
{7,	36,	36,	5,	39},
{8,	35,	36,	8,	39},
{7,	31,	21,	36,	39},
{7,	35,	29,	23,	39},
{7,	36,	30,	20,	39},
{7,	34,	39,	2,	39},
{7,	37,	36,	2,	39},
{7,	29,	26,	35,	39},
{7,	39,	16,	37,	39},
{6,	38,	39,	37,	39},
{6,	33,	38,	38,	39},
{6,	39,	34,	16,	39},
{6,	39,	33,	20,	39},
{6,	31,	27,	39,	39},
{8,	39,	21,	39,	39},
{6,	39,	36,	0,	39},
{6,	28,	28,	39,	39},
{6,	27,	29,	39,	39},
{5,	39,	39,	39,	39}};

static BtkLookupTable DefaultTable3700pop6 = { 
    sizeof(DefaultParam3700pop6Entries)/ sizeof(DefaultParam3700pop6Entries[0]),
    DefaultParam3700pop6Entries, 
    sizeof(DefaultTable3700pop6Entries)/ sizeof(DefaultTable3700pop6Entries[0]),
    DefaultTable3700pop6Entries 
};

BtkLookupTable *  
Btk_get_3700pop6_table(void) 
{ 
    return &DefaultTable3700pop6; 
}


static TraceParamEntry DefaultParam3100pop6Entries[] = {
/*   phr3_t            phr7_t             psr_t              pres_t  */
{0.001562500000000, 0.002278942570647, 1.087121212121212, 0.024262163458378},
{0.024630905498065, 0.069912373396544, 1.171568627450981, 0.029562173216029},
{0.039378338905921, 0.105263869947514, 1.184659090909091, 0.032832782461307},
{0.051532000512136, 0.131273566374830, 1.275252525252526, 0.036153881646613},
{0.061926690671434, 0.154473363347670, 1.303846153846154, 0.039496647564024},
{0.071580433624422, 0.176041338486593, 1.366028708133971, 0.042754949490391},
{0.080618990208258, 0.197603444513657, 1.405882352941176, 0.045968513281527},
{0.089417679994350, 0.219579621250892, 1.447222222222222, 0.049156579496925},
{0.098405381117433, 0.241701419393712, 1.513157894736842, 0.052272580677953},
{0.107389194326585, 0.263996207477850, 1.559027777777778, 0.055345866769418},
{0.116647333767998, 0.287316844382877, 1.605555555555556, 0.058377421783325},
{0.126173852308643, 0.311309832152488, 1.630681818181818, 0.061413540682791},
{0.135953287173263, 0.335604592556163, 1.675438596491228, 0.064446809170496},
{0.146154229173772, 0.360919806921542, 1.720779220779221, 0.067480591626392},
{0.156793026630047, 0.386803000285852, 1.757352941176471, 0.070508095951702},
{0.167906145978309, 0.413592435843042, 1.781746031746032, 0.073545660335307},
{0.179556838832934, 0.441842170785211, 1.861904761904762, 0.076598381942820},
{0.191878287257829, 0.470836430606929, 1.881944444444445, 0.079691594433219},
{0.205045156579537, 0.501131261749491, 1.925824175824176, 0.082861720712387},
{0.218906589854574, 0.531588096707048, 2.027777777777778, 0.086035763541778},
{0.233580571279683, 0.564489516732555, 2.129166666666666, 0.089263266489965},
{0.249046796320125, 0.599416159553447, 2.148351648351649, 0.092572512868858},
{0.265676795456537, 0.636412133557402, 2.226495726495727, 0.095934543540323},
{0.283446210330042, 0.674821747148492, 2.292857142857143, 0.099400815814853},
{0.302362974291974, 0.715810943729700, 2.345238095238095, 0.102981874812322},
{0.322519308916232, 0.760301038165783, 2.436507936507937, 0.106667656208946},
{0.344596044746839, 0.808505827109097, 2.516666666666667, 0.110483046562442},
{0.368519977873160, 0.859196869234251, 2.607692307692307, 0.114482640449401},
{0.394809218781751, 0.915462172569842, 2.683333333333334, 0.118667549647398},
{0.423832830010664, 0.976147436944639, 2.809090909090909, 0.123054037588685},
{0.456335793533085, 1.043771404042048, 3.041666666666667, 0.127721413009926},
{0.492710188449086, 1.120693233625996, 3.261363636363637, 0.132665430450350},
{0.534183986081417, 1.208705175225322, 3.527777777777778, 0.138034470053062},
{0.582120090450410, 1.318010786987208, 3.816666666666666, 0.143948843738482},
{0.639604967199010, 1.453968480985737, 4.267857142857143, 0.150741366121781},
{0.709937959573689, 1.642469463225479, 4.775000000000000, 0.159179739799158},
{0.800908632378970, 1.914670670157785, 5.690476190476190, 0.172192546444171},
{0.930863791274294, 2.394024022282663, 7.550000000000000, 0.198414627976531},
{1.159238223997480, 3.489469876409354, 13.250000000000000, 0.251554425194656},
{99.000000000000000, 293.040293040292966, 100.000000000000000, 17.512017675676859}};

static BtkLookupEntry DefaultTable3100pop6Entries[] = {
/* qv ind1 ind2 ind3 ind4 */
{41,	39,	0,	2,	11},
{40,	39,	5,	1,	14},
{37,	39,	4,	2,	37},
{37,	19,	33,	2,	2},
{36,	1,	3,	7,	18},
{37,	39,	12,	4,	2},
{37,	39,	4,	7,	7},
{36,	3,	19,	0,	36},
{35,	1,	4,	4,	36},
{37,	39,	4,	3,	35},
{36,	39,	4,	4,	34},
{35,	11,	5,	2,	33},
{36,	16,	12,	4,	4},
{35,	39,	7,	5,	7},
{35,	13,	6,	2,	31},
{35,	39,	8,	4,	9},
{33,	39,	1,	7,	35},
{33,	5,	12,	4,	15},
{34,	20,	9,	1,	33},
{35,	12,	10,	2,	23},
{34,	3,	33,	2,	7},
{33,	39,	6,	7,	7},
{34,	1,	5,	6,	20},
{33,	39,	4,	7,	22},
{34,	7,	9,	6,	15},
{33,	10,	17,	7,	1},
{33,	4,	9,	2,	35},
{32,	39,	1,	9,	34},
{36,	10,	12,	9,	3},
{34,	10,	10,	6,	15},
{33,	39,	6,	9,	7},
{33,	10,	12,	9,	6},
{33,	3,	15,	9,	5},
{32,	16,	9,	5,	15},
{32,	39,	11,	9,	3},
{32,	21,	9,	6,	12},
{32,	39,	18,	2,	4},
{32,	7,	31,	2,	21},
{33,	6,	35,	0,	39},
{32,	7,	14,	4,	15},
{33,	8,	17,	7,	6},
{32,	33,	28,	0,	13},
{33,	12,	28,	2,	18},
{33,	12,	18,	7,	6},
{33,	12,	24,	3,	8},
{33,	23,	28,	0,	33},
{32,	9,	31,	6,	5},
{32,	26,	18,	2,	8},
{33,	21,	11,	6,	11},
{33,	3,	24,	6,	8},
{32,	17,	28,	2,	15},
{32,	17,	13,	2,	23},
{33,	24,	18,	2,	17},
{31,	18,	23,	4,	26},
{36,	14,	15,	4,	28},
{34,	14,	10,	6,	19},
{34,	19,	25,	4,	15},
{33,	6,	15,	2,	35},
{33,	6,	5,	5,	35},
{33,	5,	10,	5,	30},
{33,	3,	25,	6,	11},
{32,	11,	14,	7,	11},
{32,	19,	28,	2,	25},
{31,	3,	22,	7,	14},
{33,	14,	11,	6,	21},
{31,	11,	23,	6,	21},
{32,	12,	23,	5,	26},
{31,	5,	13,	5,	35},
{32,	18,	15,	4,	29},
{31,	6,	7,	9,	13},
{31,	7,	23,	6,	23},
{31,	39,	18,	1,	27},
{31,	6,	15,	4,	35},
{31,	1,	15,	4,	36},
{31,	6,	10,	2,	38},
{31,	9,	30,	5,	11},
{30,	10,	4,	9,	33},
{35,	5,	9,	6,	33},
{31,	18,	11,	6,	26},
{30,	8,	12,	9,	17},
{32,	5,	13,	8,	20},
{31,	5,	11,	7,	27},
{30,	39,	4,	7,	35},
{30,	39,	6,	9,	19},
{32,	11,	16,	8,	15},
{30,	21,	11,	6,	23},
{30,	6,	23,	6,	25},
{30,	5,	12,	6,	35},
{30,	23,	13,	9,	4},
{30,	9,	33,	2,	26},
{30,	6,	5,	9,	31},
{29,	1,	3,	9,	36},
{29,	6,	10,	4,	37},
{29,	18,	33,	2,	28},
{31,	30,	33,	1,	16},
{31,	20,	30,	3,	12},
{30,	26,	21,	2,	17},
{29,	1,	23,	6,	36},
{32,	9,	29,	2,	33},
{30,	6,	33,	1,	38},
{31,	6,	21,	2,	38},
{32,	1,	23,	4,	37},
{29,	26,	29,	2,	34},
{31,	32,	29,	0,	39},
{31,	17,	19,	4,	30},
{30,	6,	23,	6,	33},
{30,	21,	12,	6,	27},
{30,	23,	14,	3,	30},
{30,	39,	10,	7,	27},
{30,	11,	27,	2,	37},
{30,	18,	17,	6,	10},
{29,	23,	22,	3,	27},
{30,	21,	23,	4,	22},
{29,	39,	13,	4,	30},
{30,	24,	17,	5,	14},
{29,	23,	16,	6,	22},
{30,	12,	22,	7,	18},
{30,	21,	15,	9,	6},
{29,	6,	16,	7,	35},
{30,	6,	7,	9,	33},
{30,	5,	16,	8,	23},
{30,	4,	15,	8,	33},
{30,	4,	12,	9,	31},
{29,	5,	15,	9,	28},
{29,	14,	23,	6,	27},
{29,	23,	16,	7,	27},
{30,	23,	21,	4,	29},
{29,	39,	11,	8,	27},
{32,	13,	15,	9,	23},
{30,	16,	16,	9,	15},
{29,	7,	6,	9,	36},
{29,	14,	28,	6,	11},
{29,	39,	9,	9,	27},
{29,	6,	20,	7,	31},
{29,	30,	24,	2,	10},
{30,	27,	17,	5,	16},
{29,	30,	20,	2,	34},
{30,	28,	20,	3,	21},
{30,	26,	29,	3,	12},
{29,	27,	17,	6,	13},
{28,	21,	9,	12,	36},
{34,	23,	19,	4,	34},
{32,	11,	15,	8,	35},
{30,	15,	14,	13,	2},
{31,	12,	16,	11,	15},
{30,	18,	21,	3,	36},
{30,	18,	27,	2,	38},
{30,	13,	16,	7,	36},
{30,	28,	25,	2,	35},
{29,	11,	12,	12,	16},
{28,	25,	30,	3,	38},
{33,	11,	28,	4,	29},
{31,	26,	18,	4,	36},
{31,	22,	33,	2,	38},
{29,	20,	24,	4,	36},
{29,	15,	23,	6,	29},
{29,	39,	16,	3,	38},
{29,	28,	24,	3,	30},
{29,	27,	16,	6,	27},
{28,	18,	7,	14,	17},
{30,	12,	16,	14,	6},
{28,	10,	30,	6,	29},
{31,	13,	25,	6,	33},
{29,	13,	27,	6,	33},
{28,	10,	39,	2,	37},
{30,	26,	35,	2,	36},
{28,	15,	26,	6,	33},
{28,	27,	25,	4,	11},
{28,	10,	15,	9,	32},
{28,	15,	13,	11,	22},
{28,	11,	12,	13,	18},
{28,	26,	34,	1,	39},
{28,	26,	31,	4,	7},
{28,	25,	26,	4,	24},
{28,	39,	15,	6,	27},
{29,	28,	25,	4,	24},
{28,	27,	19,	4,	37},
{28,	28,	16,	6,	29},
{27,	14,	21,	9,	25},
{30,	15,	21,	13,	6},
{28,	15,	21,	10,	19},
{28,	23,	16,	8,	21},
{27,	9,	34,	3,	38},
{28,	19,	34,	3,	32},
{28,	25,	36,	3,	13},
{28,	11,	31,	4,	32},
{28,	10,	32,	5,	25},
{30,	22,	36,	4,	13},
{27,	9,	29,	6,	36},
{27,	24,	16,	6,	36},
{27,	26,	14,	8,	36},
{27,	39,	16,	7,	30},
{28,	29,	22,	4,	23},
{27,	39,	20,	3,	35},
{27,	39,	18,	6,	13},
{28,	24,	19,	7,	13},
{28,	28,	19,	6,	17},
{27,	27,	25,	6,	33},
{30,	22,	27,	6,	33},
{30,	39,	18,	6,	33},
{29,	19,	35,	4,	23},
{28,	24,	22,	7,	23},
{28,	28,	21,	7,	24},
{28,	26,	20,	9,	5},
{27,	23,	25,	6,	36},
{28,	26,	18,	7,	36},
{27,	39,	10,	9,	36},
{28,	21,	16,	9,	22},
{27,	27,	26,	7,	5},
{27,	10,	36,	6,	5},
{27,	10,	33,	6,	14},
{28,	15,	31,	6,	22},
{27,	16,	27,	7,	11},
{27,	9,	23,	7,	31},
{27,	11,	35,	4,	31},
{26,	18,	7,	15,	34},
{29,	18,	9,	13,	36},
{26,	24,	17,	6,	38},
{29,	23,	25,	4,	38},
{26,	9,	29,	6,	38},
{26,	4,	19,	9,	36},
{28,	25,	16,	8,	36},
{27,	5,	21,	9,	31},
{26,	6,	5,	15,	36},
{26,	9,	34,	4,	38},
{26,	31,	23,	2,	37},
{26,	10,	24,	9,	4},
{27,	4,	26,	8,	11},
{26,	18,	33,	6,	14},
{26,	18,	11,	13,	21},
{26,	1,	30,	13,	0},
{26,	21,	27,	8,	5},
{26,	14,	18,	9,	31},
{27,	17,	15,	9,	36},
{26,	18,	31,	6,	25},
{26,	29,	26,	2,	37},
{25,	15,	13,	17,	36},
{27,	18,	11,	16,	34},
{26,	18,	11,	18,	10},
{27,	15,	17,	18,	5},
{26,	13,	17,	14,	16},
{28,	11,	14,	17,	24},
{26,	13,	21,	13,	18},
{27,	13,	18,	13,	22},
{25,	15,	28,	9,	37},
{28,	20,	29,	6,	36},
{28,	17,	15,	10,	37},
{27,	13,	23,	11,	22},
{27,	18,	33,	7,	10},
{26,	10,	23,	11,	35},
{26,	13,	30,	12,	2},
{26,	19,	33,	4,	38},
{26,	23,	25,	6,	38},
{26,	25,	33,	3,	37},
{25,	21,	38,	4,	36},
{27,	15,	38,	3,	38},
{26,	28,	39,	2,	25},
{27,	29,	30,	4,	8},
{25,	33,	24,	3,	33},
{27,	31,	23,	4,	28},
{26,	32,	39,	1,	26},
{25,	15,	31,	7,	37},
{25,	26,	19,	8,	37},
{27,	28,	21,	8,	15},
{26,	19,	17,	9,	37},
{26,	29,	18,	8,	32},
{26,	19,	26,	8,	22},
{25,	15,	31,	9,	18},
{26,	15,	29,	9,	29},
{25,	25,	35,	4,	35},
{26,	23,	28,	6,	37},
{25,	11,	24,	12,	16},
{25,	11,	26,	10,	37},
{25,	19,	19,	10,	35},
{26,	19,	20,	12,	9},
{26,	17,	18,	13,	22},
{26,	15,	18,	15,	16},
{25,	30,	18,	9,	32},
{25,	25,	39,	4,	15},
{25,	33,	27,	2,	15},
{26,	30,	31,	3,	12},
{25,	30,	39,	2,	23},
{25,	10,	16,	12,	30},
{25,	16,	15,	17,	18},
{25,	21,	32,	5,	36},
{25,	14,	34,	6,	36},
{25,	12,	39,	6,	10},
{25,	20,	38,	5,	36},
{25,	17,	31,	8,	22},
{25,	20,	33,	6,	28},
{25,	20,	34,	7,	14},
{25,	21,	19,	12,	11},
{26,	39,	11,	12,	33},
{27,	27,	15,	11,	28},
{28,	22,	12,	16,	27},
{26,	22,	18,	13,	22},
{25,	23,	13,	11,	37},
{24,	16,	7,	19,	11},
{24,	16,	15,	18,	17},
{24,	5,	14,	18,	24},
{24,	26,	26,	8,	12},
{24,	39,	2,	19,	12},
{24,	7,	13,	19,	9},
{24,	8,	15,	14,	35},
{25,	10,	18,	12,	32},
{24,	15,	21,	13,	26},
{27,	10,	19,	13,	35},
{25,	20,	19,	13,	27},
{25,	20,	16,	12,	35},
{24,	11,	22,	12,	35},
{24,	12,	37,	6,	22},
{24,	13,	35,	7,	34},
{24,	18,	24,	8,	37},
{25,	21,	20,	9,	36},
{26,	28,	21,	8,	28},
{26,	27,	20,	9,	32},
{24,	26,	25,	9,	13},
{26,	20,	21,	13,	28},
{25,	16,	26,	10,	37},
{24,	12,	31,	6,	38},
{24,	33,	25,	3,	24},
{24,	31,	18,	9,	32},
{24,	27,	36,	4,	12},
{24,	20,	20,	12,	35},
{24,	22,	19,	13,	31},
{24,	16,	30,	9,	25},
{24,	15,	31,	8,	37},
{24,	17,	33,	8,	28},
{24,	13,	35,	8,	30},
{24,	20,	32,	9,	6},
{24,	11,	34,	10,	5},
{24,	31,	27,	4,	12},
{24,	18,	24,	11,	24},
{24,	26,	24,	7,	31},
{24,	28,	21,	9,	28},
{24,	14,	34,	6,	37},
{23,	16,	13,	19,	35},
{24,	16,	15,	19,	12},
{23,	11,	29,	9,	38},
{26,	22,	19,	9,	38},
{23,	29,	36,	3,	37},
{26,	32,	23,	3,	38},
{25,	30,	26,	4,	34},
{26,	28,	27,	5,	33},
{25,	29,	23,	6,	33},
{25,	31,	23,	8,	6},
{25,	30,	20,	9,	23},
{24,	31,	23,	6,	29},
{24,	29,	30,	4,	28},
{24,	31,	25,	4,	35},
{24,	30,	26,	4,	37},
{25,	26,	32,	4,	38},
{24,	26,	25,	6,	37},
{23,	17,	8,	15,	37},
{24,	13,	22,	12,	37},
{23,	12,	36,	9,	26},
{24,	15,	32,	9,	30},
{23,	18,	24,	12,	34},
{25,	7,	25,	12,	26},
{23,	12,	37,	7,	34},
{23,	7,	39,	8,	13},
{23,	26,	14,	17,	10},
{26,	23,	14,	15,	31},
{24,	27,	15,	12,	32},
{24,	20,	11,	18,	34},
{25,	19,	12,	19,	31},
{23,	26,	27,	6,	37},
{23,	32,	23,	4,	21},
{23,	15,	19,	15,	16},
{25,	14,	28,	15,	1},
{25,	20,	25,	13,	9},
{24,	25,	21,	14,	3},
{24,	25,	18,	12,	29},
{23,	16,	23,	13,	36},
{23,	15,	31,	9,	35},
{23,	13,	35,	9,	33},
{23,	29,	23,	5,	38},
{23,	11,	38,	10,	5},
{23,	24,	16,	14,	21},
{23,	31,	26,	7,	4},
{23,	29,	33,	3,	38},
{23,	17,	26,	11,	26},
{24,	25,	26,	12,	4},
{23,	5,	22,	15,	9},
{24,	15,	22,	14,	17},
{23,	16,	16,	17,	18},
{23,	0,	17,	19,	16},
{23,	30,	39,	2,	32},
{23,	30,	27,	4,	38},
{23,	31,	21,	9,	16},
{22,	16,	10,	22,	35},
{28,	18,	14,	22,	12},
{24,	22,	10,	22,	25},
{23,	15,	13,	20,	35},
{22,	24,	38,	6,	35},
{23,	15,	36,	8,	33},
{23,	16,	35,	9,	31},
{23,	26,	35,	6,	7},
{22,	26,	33,	2,	39},
{22,	27,	25,	9,	28},
{24,	29,	23,	9,	23},
{23,	30,	23,	8,	31},
{25,	23,	24,	9,	34},
{24,	21,	22,	12,	35},
{23,	22,	23,	12,	32},
{24,	24,	21,	13,	29},
{24,	27,	21,	12,	17},
{22,	34,	23,	4,	31},
{26,	39,	26,	2,	11},
{23,	39,	20,	6,	12},
{23,	34,	27,	3,	11},
{22,	33,	29,	4,	24},
{24,	32,	39,	2,	19},
{23,	32,	28,	3,	32},
{23,	34,	30,	3,	11},
{22,	11,	28,	10,	37},
{24,	11,	29,	11,	18},
{22,	7,	27,	13,	14},
{23,	11,	30,	12,	8},
{22,	3,	25,	14,	18},
{23,	19,	26,	14,	9},
{22,	5,	24,	18,	16},
{24,	16,	18,	19,	11},
{23,	5,	27,	15,	14},
{22,	31,	18,	8,	34},
{24,	29,	22,	9,	33},
{24,	39,	15,	9,	37},
{22,	25,	21,	12,	33},
{22,	7,	39,	6,	22},
{22,	20,	35,	7,	29},
{22,	32,	36,	3,	8},
{22,	29,	20,	8,	36},
{23,	27,	27,	6,	36},
{22,	39,	17,	9,	37},
{23,	27,	22,	9,	36},
{23,	27,	26,	7,	35},
{22,	19,	26,	9,	37},
{23,	26,	21,	8,	38},
{22,	21,	24,	14,	14},
{22,	15,	38,	7,	34},
{22,	39,	26,	0,	31},
{23,	39,	30,	0,	25},
{22,	32,	30,	4,	23},
{23,	31,	31,	3,	33},
{22,	7,	37,	9,	19},
{22,	26,	14,	12,	37},
{22,	31,	21,	12,	4},
{22,	34,	23,	3,	35},
{21,	15,	32,	13,	37},
{24,	16,	34,	10,	31},
{24,	16,	28,	14,	16},
{23,	22,	26,	12,	27},
{23,	6,	34,	11,	33},
{22,	16,	12,	17,	37},
{22,	3,	27,	15,	20},
{22,	19,	26,	14,	20},
{22,	7,	36,	13,	2},
{22,	24,	27,	12,	7},
{24,	28,	27,	7,	20},
{23,	28,	30,	6,	11},
{22,	22,	19,	15,	19},
{22,	18,	18,	17,	18},
{22,	26,	21,	17,	2},
{22,	24,	19,	17,	10},
{22,	21,	24,	17,	15},
{22,	23,	32,	9,	5},
{23,	24,	31,	7,	30},
{22,	22,	31,	9,	26},
{25,	18,	35,	9,	33},
{23,	21,	35,	8,	25},
{23,	19,	30,	9,	37},
{22,	24,	35,	9,	16},
{23,	24,	34,	8,	26},
{22,	20,	32,	9,	35},
{22,	18,	27,	14,	21},
{22,	19,	15,	22,	11},
{21,	27,	35,	6,	34},
{23,	31,	31,	4,	33},
{23,	28,	34,	5,	34},
{21,	6,	34,	13,	33},
{21,	25,	26,	12,	28},
{23,	26,	22,	13,	23},
{22,	24,	27,	12,	28},
{21,	16,	24,	10,	38},
{21,	26,	30,	6,	38},
{22,	19,	30,	8,	38},
{21,	22,	14,	17,	31},
{21,	33,	25,	6,	7},
{22,	34,	24,	6,	8},
{21,	39,	20,	6,	29},
{22,	32,	23,	6,	29},
{21,	25,	15,	15,	31},
{21,	16,	25,	18,	30},
{24,	20,	17,	18,	31},
{22,	16,	19,	17,	37},
{22,	21,	22,	15,	30},
{22,	24,	20,	14,	31},
{22,	0,	17,	19,	21},
{21,	15,	27,	16,	27},
{24,	16,	26,	18,	24},
{23,	13,	28,	16,	20},
{21,	27,	26,	10,	21},
{21,	36,	29,	1,	22},
{21,	20,	18,	17,	34},
{22,	20,	14,	17,	37},
{21,	28,	26,	9,	20},
{21,	28,	24,	8,	35},
{21,	13,	28,	14,	30},
{21,	15,	27,	17,	29},
{21,	20,	10,	22,	35},
{21,	25,	20,	15,	28},
{21,	25,	31,	7,	35},
{22,	24,	29,	8,	35},
{23,	22,	29,	10,	34},
{22,	24,	28,	13,	16},
{22,	25,	24,	14,	21},
{21,	21,	33,	9,	34},
{21,	23,	27,	12,	32},
{21,	25,	23,	15,	26},
{21,	28,	27,	6,	36},
{21,	28,	30,	6,	34},
{21,	28,	28,	7,	35},
{21,	28,	25,	10,	25},
{21,	15,	36,	9,	33},
{21,	25,	38,	6,	30},
{21,	27,	38,	4,	30},
{21,	34,	38,	2,	6},
{21,	31,	33,	6,	1},
{21,	28,	33,	6,	34},
{21,	18,	28,	12,	36},
{21,	18,	21,	14,	36},
{21,	20,	22,	17,	30},
{20,	22,	11,	29,	36},
{25,	15,	14,	27,	7},
{23,	15,	12,	22,	36},
{21,	5,	16,	28,	3},
{21,	19,	15,	27,	7},
{21,	25,	14,	15,	37},
{21,	20,	13,	19,	36},
{21,	24,	15,	20,	12},
{21,	15,	13,	22,	29},
{20,	20,	30,	6,	39},
{23,	13,	34,	3,	39},
{22,	26,	32,	3,	39},
{21,	7,	31,	6,	39},
{20,	22,	36,	9,	38},
{25,	20,	37,	7,	38},
{23,	28,	25,	8,	37},
{22,	7,	33,	5,	39},
{21,	23,	34,	8,	38},
{21,	18,	38,	7,	37},
{21,	28,	31,	6,	37},
{21,	29,	33,	4,	38},
{21,	32,	36,	4,	7},
{20,	16,	24,	12,	38},
{21,	5,	5,	14,	38},
{21,	21,	19,	12,	38},
{21,	24,	22,	12,	36},
{22,	25,	18,	14,	37},
{21,	16,	28,	11,	38},
{21,	21,	19,	17,	36},
{20,	5,	5,	17,	38},
{20,	39,	23,	6,	26},
{21,	34,	24,	5,	22},
{22,	32,	26,	5,	27},
{21,	31,	26,	6,	13},
{20,	11,	32,	15,	17},
{23,	4,	34,	14,	20},
{20,	24,	24,	17,	21},
{22,	24,	13,	19,	33},
{22,	26,	21,	16,	21},
{21,	24,	17,	18,	32},
{21,	25,	19,	16,	36},
{20,	13,	28,	18,	18},
{21,	11,	30,	17,	5},
{20,	29,	36,	4,	38},
{20,	30,	37,	4,	30},
{20,	31,	39,	3,	21},
{20,	39,	23,	8,	6},
{21,	32,	22,	7,	27},
{21,	32,	20,	9,	27},
{21,	39,	24,	7,	5},
{20,	22,	20,	17,	36},
{20,	18,	22,	17,	35},
{23,	16,	24,	14,	37},
{21,	24,	22,	15,	36},
{20,	1,	33,	18,	3},
{20,	30,	22,	8,	37},
{21,	39,	19,	9,	33},
{20,	31,	26,	6,	33},
{23,	29,	25,	9,	29},
{21,	29,	26,	9,	29},
{21,	29,	26,	8,	36},
{21,	32,	25,	6,	31},
{20,	29,	30,	6,	37},
{24,	32,	29,	5,	31},
{23,	30,	28,	6,	36},
{23,	33,	28,	6,	9},
{21,	29,	35,	5,	35},
{22,	31,	32,	6,	9},
{22,	29,	33,	6,	35},
{20,	39,	23,	6,	30},
{20,	9,	29,	17,	18},
{20,	30,	21,	9,	37},
{20,	1,	13,	23,	29},
{20,	1,	13,	26,	20},
{20,	26,	26,	9,	36},
{20,	39,	25,	5,	6},
{20,	31,	28,	6,	32},
{20,	39,	14,	16,	23},
{20,	24,	27,	12,	34},
{20,	13,	38,	9,	12},
{20,	18,	37,	9,	27},
{22,	7,	38,	8,	29},
{20,	39,	36,	0,	9},
{20,	25,	24,	16,	26},
{21,	17,	28,	14,	32},
{21,	24,	27,	13,	34},
{20,	15,	30,	14,	25},
{20,	25,	24,	14,	34},
{20,	17,	28,	17,	20},
{20,	26,	23,	9,	38},
{21,	27,	16,	12,	38},
{20,	27,	15,	17,	35},
{20,	39,	15,	18,	28},
{23,	30,	18,	12,	25},
{20,	27,	26,	12,	20},
{20,	29,	23,	12,	23},
{20,	31,	21,	12,	16},
{20,	39,	19,	12,	23},
{20,	28,	16,	14,	37},
{20,	1,	34,	17,	5},
{20,	32,	28,	2,	38},
{20,	30,	35,	5,	32},
{21,	30,	32,	6,	31},
{20,	22,	29,	13,	16},
{20,	16,	31,	15,	16},
{20,	22,	29,	11,	36},
{20,	27,	24,	4,	39},
{20,	23,	12,	22,	32},
{20,	22,	13,	21,	36},
{20,	15,	38,	7,	38},
{19,	16,	37,	13,	35},
{21,	15,	35,	11,	37},
{21,	8,	39,	10,	9},
{20,	4,	35,	14,	21},
{20,	6,	36,	13,	36},
{19,	22,	12,	22,	37},
{19,	29,	30,	8,	36},
{21,	29,	28,	9,	14},
{20,	28,	32,	8,	22},
{21,	26,	34,	7,	37},
{21,	27,	32,	9,	11},
{20,	26,	37,	7,	16},
{21,	29,	38,	6,	9},
{22,	28,	36,	6,	34},
{20,	31,	39,	5,	8},
{19,	2,	20,	20,	24},
{22,	11,	14,	22,	27},
{21,	11,	17,	20,	24},
{20,	2,	20,	26,	5},
{22,	2,	22,	22,	4},
{21,	14,	19,	26,	5},
{20,	22,	16,	20,	15},
{19,	13,	33,	13,	38},
{22,	13,	13,	15,	38},
{21,	21,	27,	12,	38},
{19,	35,	29,	2,	26},
{20,	39,	26,	2,	23},
{20,	34,	24,	6,	27},
{19,	39,	20,	9,	33},
{20,	33,	21,	11,	14},
{20,	39,	22,	8,	16},
{19,	12,	32,	17,	11},
{19,	24,	34,	9,	36},
{21,	26,	33,	8,	36},
{20,	25,	28,	11,	34},
{20,	27,	30,	9,	31},
{21,	27,	27,	12,	25},
{19,	7,	33,	6,	39},
{19,	39,	19,	9,	37},
{21,	32,	25,	4,	38},
{21,	34,	23,	6,	33},
{20,	32,	28,	4,	36},
{20,	31,	31,	4,	36},
{19,	13,	35,	3,	39},
{19,	16,	20,	18,	37},
{20,	11,	14,	20,	37},
{19,	22,	16,	20,	37},
{21,	16,	18,	20,	25},
{21,	25,	15,	20,	30},
{20,	10,	19,	19,	37},
{21,	2,	20,	19,	37},
{21,	19,	17,	20,	37},
{20,	24,	21,	21,	1},
{19,	34,	27,	2,	35},
{21,	39,	27,	1,	35},
{20,	39,	25,	2,	33},
{19,	4,	37,	14,	20},
{19,	30,	36,	5,	35},
{19,	32,	34,	4,	36},
{21,	31,	35,	5,	32},
{20,	32,	36,	5,	16},
{19,	33,	35,	4,	13},
{20,	33,	37,	1,	35},
{21,	39,	35,	0,	25},
{19,	22,	32,	10,	21},
{19,	17,	37,	11,	35},
{19,	1,	32,	18,	11},
{19,	14,	19,	24,	7},
{19,	19,	17,	22,	20},
{20,	6,	20,	22,	15},
{19,	12,	18,	26,	15},
{21,	6,	20,	26,	14},
{20,	23,	12,	26,	20},
{21,	20,	13,	23,	33},
{19,	11,	19,	26,	16},
{19,	6,	19,	22,	24},
{21,	22,	15,	21,	37},
{20,	2,	18,	21,	34},
{20,	21,	18,	21,	28},
{19,	10,	20,	21,	25},
{19,	34,	26,	5,	17},
{19,	15,	31,	18,	11},
{19,	21,	21,	20,	6},
{19,	29,	34,	6,	37},
{19,	18,	31,	13,	23},
{19,	17,	33,	13,	36},
{19,	25,	23,	13,	37},
{19,	10,	13,	28,	15},
{20,	7,	13,	27,	31},
{21,	22,	12,	26,	35},
{20,	13,	15,	24,	23},
{20,	7,	14,	27,	32},
{21,	11,	16,	26,	24},
{20,	10,	17,	26,	24},
{19,	5,	14,	27,	36},
{19,	0,	14,	24,	37},
{19,	20,	14,	24,	27},
{19,	27,	14,	20,	30},
{19,	17,	27,	17,	30},
{19,	28,	26,	12,	23},
{18,	24,	32,	17,	38},
{22,	25,	25,	17,	33},
{20,	4,	30,	18,	30},
{20,	1,	34,	18,	21},
{20,	4,	33,	15,	38},
{23,	1,	34,	18,	27},
{19,	28,	26,	12,	37},
{22,	26,	21,	16,	38},
{21,	29,	25,	12,	30},
{20,	29,	27,	9,	37},
{19,	21,	37,	11,	35},
{20,	23,	37,	8,	35},
{21,	23,	35,	10,	38},
{19,	1,	36,	15,	23},
{19,	22,	31,	18,	9},
{19,	31,	20,	12,	30},
{19,	26,	22,	17,	33},
{20,	26,	25,	17,	19},
{19,	39,	13,	20,	37},
{19,	24,	36,	10,	21},
{19,	27,	26,	15,	7},
{20,	31,	19,	14,	11},
{21,	28,	18,	17,	30},
{19,	27,	19,	16,	38},
{20,	29,	27,	6,	38},
{20,	28,	26,	9,	38},
{19,	30,	27,	6,	38},
{19,	29,	24,	10,	38},
{18,	33,	26,	10,	36},
{22,	33,	25,	7,	37},
{20,	31,	27,	9,	31},
{20,	34,	26,	4,	32},
{20,	39,	22,	4,	38},
{20,	32,	20,	10,	38},
{20,	34,	24,	6,	36},
{20,	39,	21,	11,	28},
{20,	39,	23,	10,	10},
{19,	31,	25,	12,	10},
{19,	33,	28,	3,	36},
{19,	39,	21,	12,	25},
{18,	21,	39,	10,	36},
{22,	24,	39,	5,	38},
{21,	18,	39,	8,	37},
{20,	30,	39,	4,	32},
{20,	25,	39,	6,	36},
{19,	21,	38,	11,	35},
{19,	28,	39,	6,	31},
{21,	30,	39,	5,	35},
{19,	10,	39,	11,	26},
{18,	9,	26,	20,	24},
{22,	13,	27,	20,	7},
{21,	8,	31,	20,	0},
{19,	10,	24,	22,	21},
{22,	18,	24,	22,	9},
{19,	10,	24,	24,	13},
{21,	10,	25,	23,	17},
{21,	12,	28,	21,	7},
{21,	11,	29,	23,	1},
{21,	12,	28,	23,	7},
{20,	5,	24,	27,	2},
{19,	8,	32,	20,	1},
{18,	21,	24,	19,	37},
{21,	20,	23,	21,	22},
{19,	18,	24,	22,	21},
{19,	8,	25,	19,	31},
{19,	9,	31,	18,	32},
{19,	26,	24,	18,	19},
{18,	0,	18,	24,	37},
{20,	21,	18,	21,	37},
{20,	7,	17,	26,	30},
{18,	12,	24,	22,	33},
{20,	20,	21,	21,	35},
{18,	7,	36,	15,	29},
{19,	6,	35,	14,	36},
{18,	39,	24,	3,	36},
{21,	35,	26,	5,	13},
{18,	15,	33,	16,	33},
{21,	14,	34,	17,	23},
{18,	29,	33,	8,	20},
{19,	28,	37,	7,	22},
{18,	27,	30,	11,	31},
{20,	25,	31,	12,	31},
{19,	26,	28,	12,	37},
{18,	34,	26,	6,	28},
{18,	39,	23,	7,	33},
{19,	34,	25,	9,	14},
{18,	13,	26,	23,	14},
{18,	15,	26,	20,	24},
{18,	34,	39,	1,	27},
{18,	24,	21,	6,	39},
{18,	35,	26,	6,	12},
{18,	5,	17,	27,	20},
{18,	23,	38,	8,	37},
{18,	22,	35,	11,	38},
{18,	22,	33,	12,	38},
{18,	30,	29,	6,	38},
{19,	29,	34,	6,	38},
{18,	19,	26,	18,	37},
{18,	31,	37,	3,	36},
{18,	13,	39,	9,	37},
{18,	12,	22,	22,	35},
{18,	7,	13,	29,	36},
{18,	19,	14,	25,	35},
{18,	16,	15,	28,	35},
{19,	18,	16,	26,	34},
{20,	20,	24,	26,	2},
{19,	9,	14,	29,	36},
{19,	17,	24,	24,	13},
{19,	15,	15,	29,	24},
{18,	17,	19,	27,	16},
{20,	20,	18,	29,	5},
{18,	10,	19,	29,	20},
{20,	8,	16,	29,	35},
{18,	10,	19,	29,	22},
{19,	10,	17,	28,	35},
{18,	33,	29,	6,	10},
{18,	20,	32,	6,	39},
{18,	29,	23,	4,	39},
{18,	35,	28,	2,	31},
{18,	31,	34,	6,	10},
{18,	39,	18,	17,	8},
{18,	32,	34,	5,	32},
{17,	25,	20,	32,	37},
{20,	24,	21,	24,	19},
{20,	39,	13,	32,	25},
{20,	27,	14,	25,	37},
{19,	12,	24,	23,	31},
{18,	24,	15,	33,	13},
{18,	20,	21,	23,	36},
{18,	22,	23,	23,	19},
{18,	23,	23,	19,	33},
{19,	24,	23,	28,	3},
{18,	19,	22,	33,	0},
{18,	23,	24,	20,	24},
{17,	24,	35,	10,	39},
{20,	24,	36,	11,	36},
{18,	29,	19,	9,	39},
{17,	20,	27,	22,	35},
{20,	12,	28,	21,	14},
{19,	17,	25,	23,	31},
{18,	12,	28,	19,	21},
{18,	21,	25,	19,	37},
{18,	22,	25,	25,	3},
{18,	22,	25,	24,	12},
{17,	32,	35,	6,	37},
{20,	31,	31,	6,	38},
{19,	26,	38,	7,	37},
{19,	32,	37,	3,	36},
{18,	31,	35,	7,	12},
{20,	30,	29,	8,	35},
{18,	33,	27,	7,	37},
{18,	30,	39,	6,	23},
{18,	32,	37,	6,	14},
{18,	32,	39,	3,	33},
{17,	34,	35,	4,	35},
{18,	35,	27,	3,	27},
{18,	34,	38,	3,	11},
{19,	33,	36,	3,	36},
{18,	33,	35,	4,	37},
{18,	34,	28,	7,	6},
{17,	29,	38,	8,	36},
{19,	30,	35,	7,	37},
{17,	39,	26,	5,	32},
{17,	33,	25,	12,	36},
{17,	30,	25,	14,	30},
{20,	31,	21,	15,	19},
{18,	28,	23,	14,	38},
{18,	30,	17,	17,	30},
{18,	27,	21,	17,	35},
{19,	29,	21,	17,	24},
{17,	24,	36,	12,	37},
{17,	2,	37,	18,	13},
{18,	2,	36,	17,	26},
{19,	6,	37,	16,	19},
{18,	3,	36,	16,	30},
{17,	13,	39,	18,	9},
{19,	21,	36,	15,	3},
{19,	16,	37,	18,	7},
{18,	9,	38,	14,	14},
{18,	1,	39,	13,	21},
{20,	6,	38,	12,	35},
{18,	6,	38,	14,	24},
{17,	27,	35,	9,	34},
{20,	26,	36,	10,	21},
{17,	34,	23,	11,	36},
{17,	24,	21,	28,	15},
{19,	8,	23,	28,	9},
{17,	22,	23,	26,	35},
{20,	6,	24,	25,	32},
{18,	13,	27,	25,	12},
{19,	6,	26,	25,	19},
{18,	13,	27,	23,	28},
{18,	23,	23,	26,	33},
{18,	3,	22,	27,	27},
{18,	24,	23,	26,	22},
{17,	5,	22,	32,	15},
{19,	24,	23,	29,	9},
{18,	3,	22,	29,	27},
{18,	3,	22,	31,	23},
{18,	20,	22,	30,	15},
{17,	32,	29,	7,	37},
{17,	6,	35,	13,	38},
{17,	25,	27,	17,	33},
{18,	28,	26,	14,	33},
{18,	25,	29,	15,	33},
{17,	28,	28,	14,	19},
{17,	9,	37,	14,	34},
{17,	13,	37,	17,	17},
{17,	21,	36,	14,	35},
{20,	21,	33,	17,	27},
{19,	18,	37,	18,	7},
{17,	26,	29,	15,	31},
{17,	6,	37,	17,	26},
{17,	7,	37,	15,	34},
{18,	3,	37,	16,	33},
{17,	33,	37,	5,	10},
{17,	33,	35,	6,	5},
{17,	28,	21,	9,	39},
{17,	33,	27,	8,	24},
{17,	13,	37,	17,	23},
{17,	39,	16,	19,	13},
{18,	27,	16,	21,	35},
{17,	26,	18,	32,	21},
{17,	32,	31,	4,	38},
{17,	17,	36,	17,	19},
{17,	22,	39,	6,	38},
{17,	30,	25,	15,	15},
{17,	20,	27,	25,	10},
{18,	22,	26,	26,	4},
{17,	9,	29,	27,	3},
{17,	6,	28,	25,	17},
{17,	13,	27,	25,	24},
{17,	39,	19,	12,	38},
{17,	31,	39,	6,	18},
{17,	26,	19,	22,	35},
{17,	31,	27,	10,	33},
{17,	30,	30,	10,	33},
{17,	32,	31,	8,	36},
{19,	33,	28,	10,	7},
{18,	31,	28,	12,	7},
{18,	32,	33,	7,	36},
{17,	29,	33,	9,	33},
{18,	29,	33,	10,	24},
{17,	31,	32,	9,	12},
{17,	31,	29,	8,	37},
{17,	33,	27,	10,	25},
{17,	34,	27,	9,	12},
{17,	31,	29,	9,	33},
{18,	32,	28,	10,	33},
{17,	30,	28,	11,	31},
{18,	31,	28,	12,	15},
{17,	33,	26,	12,	19},
{17,	33,	24,	2,	39},
{17,	33,	38,	1,	38},
{17,	26,	26,	17,	33},
{17,	26,	25,	18,	33},
{18,	23,	25,	21,	25},
{17,	23,	31,	18,	32},
{18,	22,	30,	18,	36},
{17,	12,	32,	25,	22},
{20,	14,	32,	26,	2},
{19,	12,	29,	21,	27},
{20,	12,	28,	21,	32},
{19,	12,	30,	20,	27},
{18,	10,	34,	20,	17},
{19,	12,	33,	20,	22},
{19,	4,	35,	19,	6},
{18,	12,	31,	23,	26},
{18,	7,	33,	22,	15},
{18,	4,	32,	27,	4},
{18,	12,	33,	19,	25},
{17,	11,	36,	18,	21},
{17,	16,	32,	18,	35},
{17,	24,	29,	21,	0},
{17,	21,	29,	19,	28},
{19,	19,	29,	25,	8},
{19,	17,	30,	19,	28},
{18,	24,	26,	20,	18},
{17,	12,	30,	21,	32},
{17,	13,	35,	19,	14},
{17,	13,	38,	20,	0},
{19,	10,	36,	20,	4},
{17,	18,	30,	19,	32},
{18,	19,	31,	24,	4},
{18,	21,	31,	20,	10},
{17,	6,	36,	22,	2},
{17,	4,	34,	22,	15},
{17,	6,	34,	23,	11},
{20,	13,	36,	24,	1},
{17,	13,	35,	25,	1},
{18,	4,	33,	28,	0},
{17,	34,	35,	5,	7},
{17,	27,	29,	14,	28},
{17,	29,	16,	19,	30},
{17,	35,	30,	2,	26},
{17,	36,	30,	1,	35},
{17,	35,	30,	2,	35},
{17,	3,	36,	17,	29},
{17,	21,	33,	17,	33},
{16,	37,	33,	4,	25},
{22,	35,	35,	4,	19},
{21,	39,	27,	5,	27},
{20,	36,	33,	2,	32},
{19,	35,	28,	7,	8},
{19,	37,	34,	3,	14},
{19,	35,	37,	2,	24},
{18,	39,	35,	1,	22},
{17,	38,	35,	2,	7},
{18,	39,	38,	2,	3},
{17,	39,	32,	2,	20},
{16,	22,	14,	34,	30},
{17,	16,	13,	35,	14},
{17,	39,	0,	35,	16},
{16,	20,	25,	21,	38},
{19,	26,	19,	20,	38},
{19,	13,	30,	18,	38},
{17,	21,	23,	25,	37},
{17,	15,	27,	22,	37},
{18,	6,	24,	25,	37},
{17,	26,	18,	29,	37},
{16,	13,	37,	20,	30},
{20,	13,	32,	21,	31},
{19,	12,	32,	22,	29},
{18,	12,	31,	22,	32},
{17,	21,	36,	17,	29},
{19,	17,	37,	16,	32},
{17,	13,	36,	23,	8},
{17,	13,	37,	21,	8},
{16,	34,	35,	6,	35},
{18,	34,	28,	7,	35},
{19,	34,	26,	9,	26},
{18,	33,	35,	6,	37},
{17,	35,	28,	6,	25},
{17,	35,	34,	6,	6},
{19,	36,	33,	5,	13},
{18,	36,	33,	6,	2},
{17,	35,	26,	6,	31},
{17,	36,	29,	5,	27},
{17,	36,	28,	4,	32},
{17,	39,	27,	4,	32},
{17,	34,	29,	7,	35},
{18,	34,	31,	7,	22},
{17,	35,	32,	7,	8},
{19,	35,	30,	6,	27},
{17,	34,	26,	8,	36},
{17,	35,	28,	3,	36},
{16,	16,	37,	12,	38},
{16,	22,	36,	6,	39},
{17,	24,	37,	4,	39},
{16,	13,	39,	12,	36},
{17,	13,	39,	11,	37},
{16,	23,	39,	12,	35},
{21,	25,	39,	9,	35},
{20,	18,	39,	17,	9},
{19,	21,	37,	16,	30},
{18,	21,	39,	17,	9},
{17,	28,	39,	8,	31},
{17,	21,	38,	14,	24},
{17,	28,	39,	7,	37},
{17,	21,	37,	18,	11},
{16,	20,	37,	20,	9},
{19,	16,	35,	19,	22},
{18,	18,	31,	20,	32},
{17,	19,	32,	24,	8},
{17,	14,	32,	22,	31},
{17,	14,	32,	25,	22},
{17,	16,	28,	23,	32},
{17,	14,	31,	23,	32},
{17,	17,	35,	23,	8},
{16,	15,	27,	26,	24},
{18,	9,	29,	27,	8},
{17,	16,	24,	26,	35},
{17,	13,	27,	24,	30},
{16,	14,	32,	26,	22},
{16,	24,	19,	33,	30},
{17,	22,	15,	34,	26},
{16,	39,	26,	6,	27},
{16,	13,	30,	26,	27},
{16,	13,	27,	25,	36},
{17,	13,	25,	26,	36},
{16,	20,	28,	20,	37},
{18,	18,	31,	19,	33},
{18,	20,	28,	22,	35},
{16,	6,	36,	19,	33},
{17,	1,	37,	19,	33},
{16,	20,	27,	25,	32},
{18,	22,	26,	25,	25},
{17,	19,	28,	24,	33},
{17,	14,	30,	26,	28},
{16,	1,	25,	22,	38},
{16,	29,	37,	9,	16},
{17,	29,	35,	9,	32},
{16,	24,	33,	15,	38},
{16,	19,	29,	25,	31},
{16,	16,	38,	18,	14},
{16,	16,	39,	18,	13},
{16,	14,	33,	26,	9},
{17,	14,	34,	25,	6},
{16,	6,	32,	20,	34},
{16,	18,	31,	23,	33},
{16,	14,	37,	25,	0},
{16,	6,	28,	30,	0},
{18,	7,	23,	32,	9},
{16,	30,	33,	8,	36},
{16,	31,	32,	9,	24},
{17,	32,	30,	9,	21},
{16,	31,	31,	9,	36},
{17,	28,	35,	9,	37},
{16,	26,	32,	17,	37},
{20,	28,	33,	11,	29},
{18,	26,	31,	18,	21},
{17,	29,	32,	11,	31},
{17,	30,	30,	12,	19},
{17,	27,	30,	14,	33},
{17,	24,	29,	19,	17},
{16,	26,	28,	19,	21},
{17,	25,	23,	20,	33},
{17,	27,	20,	25,	5},
{17,	27,	18,	20,	38},
{18,	27,	22,	19,	22},
{16,	25,	37,	12,	36},
{18,	26,	37,	12,	18},
{16,	26,	20,	32,	37},
{16,	28,	32,	9,	38},
{16,	26,	23,	26,	13},
{16,	27,	37,	12,	10},
{16,	30,	35,	6,	38},
{16,	28,	29,	14,	31},
{17,	28,	27,	14,	37},
{16,	30,	30,	12,	33},
{16,	27,	32,	14,	34},
{17,	29,	31,	12,	33},
{16,	26,	23,	24,	24},
{16,	18,	27,	26,	31},
{16,	20,	34,	22,	9},
{16,	3,	27,	32,	0},
{16,	25,	24,	33,	0},
{16,	25,	23,	31,	6},
{17,	13,	24,	31,	6},
{16,	8,	32,	18,	38},
{16,	2,	36,	18,	36},
{18,	20,	37,	16,	34},
{17,	20,	37,	16,	35},
{16,	6,	36,	15,	37},
{16,	15,	37,	21,	11},
{16,	21,	25,	28,	8},
{16,	4,	33,	28,	5},
{18,	3,	33,	29,	2},
{16,	19,	30,	25,	28},
{16,	34,	28,	3,	37},
{16,	35,	24,	2,	38},
{17,	39,	24,	4,	37},
{16,	32,	30,	12,	4},
{16,	27,	34,	16,	0},
{18,	26,	33,	15,	34},
{17,	27,	35,	12,	28},
{16,	27,	36,	10,	35},
{17,	28,	37,	9,	36},
{16,	30,	26,	12,	37},
{16,	33,	37,	6,	14},
{16,	13,	25,	31,	6},
{16,	22,	24,	34,	0},
{16,	21,	31,	19,	30},
{16,	30,	35,	8,	25},
{16,	34,	26,	11,	20},
{16,	0,	38,	18,	17},
{16,	4,	29,	29,	6},
{16,	30,	24,	12,	38},
{16,	39,	25,	3,	36},
{16,	16,	34,	19,	31},
{16,	31,	39,	6,	23},
{16,	23,	28,	20,	25},
{16,	31,	23,	15,	18},
{16,	22,	15,	35,	7},
{16,	19,	27,	35,	0},
{17,	16,	18,	35,	8},
{17,	13,	17,	34,	30},
{17,	16,	18,	35,	14},
{17,	22,	18,	34,	26},
{16,	16,	29,	29,	4},
{16,	21,	26,	29,	8},
{16,	14,	36,	26,	0},
{16,	3,	34,	29,	2},
{16,	14,	34,	27,	5},
{15,	21,	34,	32,	31},
{20,	4,	27,	29,	33},
{19,	10,	25,	32,	33},
{19,	22,	29,	30,	11},
{19,	20,	35,	21,	21},
{18,	22,	33,	21,	13},
{17,	7,	27,	33,	19},
{18,	7,	23,	33,	30},
{17,	3,	26,	34,	11},
{17,	20,	32,	24,	32},
{17,	25,	23,	28,	25},
{17,	14,	37,	21,	20},
{18,	13,	36,	22,	17},
{17,	22,	30,	32,	11},
{16,	13,	36,	23,	19},
{16,	18,	22,	32,	36},
{17,	10,	25,	29,	35},
{16,	26,	31,	19,	17},
{16,	22,	21,	33,	30},
{16,	18,	23,	31,	36},
{16,	21,	31,	20,	34},
{15,	21,	34,	14,	39},
{18,	25,	21,	14,	39},
{16,	21,	35,	13,	39},
{16,	19,	36,	15,	37},
{16,	24,	31,	13,	39},
{15,	23,	39,	17,	33},
{19,	15,	39,	18,	26},
{19,	21,	36,	18,	35},
{18,	23,	38,	17,	34},
{17,	22,	38,	17,	35},
{17,	26,	36,	16,	3},
{16,	21,	34,	19,	34},
{16,	20,	36,	20,	27},
{16,	24,	33,	21,	5},
{17,	26,	32,	18,	33},
{17,	25,	28,	20,	25},
{16,	27,	38,	16,	0},
{16,	23,	36,	18,	24},
{17,	23,	34,	21,	13},
{16,	25,	30,	20,	25},
{17,	22,	29,	29,	25},
{16,	23,	34,	21,	27},
{16,	25,	28,	19,	33},
{17,	22,	29,	30,	28},
{16,	22,	34,	26,	18},
{16,	18,	37,	20,	26},
{15,	17,	37,	26,	23},
{17,	15,	35,	28,	18},
{16,	17,	36,	23,	26},
{15,	17,	34,	20,	38},
{19,	22,	34,	18,	38},
{19,	21,	32,	20,	38},
{17,	13,	37,	20,	32},
{17,	19,	36,	17,	37},
{16,	21,	34,	21,	35},
{15,	17,	31,	31,	36},
{19,	21,	31,	28,	34},
{18,	22,	25,	29,	36},
{17,	24,	23,	22,	37},
{17,	23,	27,	21,	37},
{17,	23,	32,	21,	36},
{17,	23,	32,	20,	38},
{16,	23,	28,	26,	34},
{17,	24,	34,	23,	3},
{17,	23,	29,	28,	29},
{16,	18,	25,	26,	37},
{16,	16,	27,	22,	38},
{16,	16,	33,	27,	32},
{16,	24,	33,	18,	38},
{16,	26,	33,	16,	38},
{16,	24,	37,	17,	17},
{18,	25,	39,	15,	9},
{17,	26,	35,	18,	9},
{16,	25,	25,	31,	5},
{16,	25,	30,	20,	34},
{15,	38,	39,	2,	35},
{17,	35,	35,	4,	26},
{16,	34,	39,	3,	33},
{15,	29,	33,	14,	32},
{17,	30,	25,	14,	34},
{17,	29,	16,	19,	36},
{18,	30,	20,	15,	38},
{17,	29,	19,	17,	38},
{17,	28,	34,	12,	33},
{16,	31,	22,	13,	38},
{17,	39,	20,	13,	36},
{16,	33,	23,	13,	36},
{15,	30,	30,	14,	38},
{18,	29,	33,	14,	36},
{17,	31,	28,	14,	15},
{15,	27,	31,	18,	38},
{20,	27,	31,	19,	15},
{17,	27,	35,	18,	9},
{16,	29,	33,	15,	4},
{16,	31,	28,	15,	15},
{16,	27,	23,	25,	9},
{16,	27,	37,	15,	10},
{16,	26,	34,	18,	22},
{16,	27,	34,	13,	37},
{15,	31,	24,	19,	36},
{18,	28,	25,	19,	29},
{18,	31,	22,	17,	38},
{17,	29,	21,	22,	10},
{17,	26,	30,	19,	34},
{17,	27,	23,	20,	38},
{17,	31,	26,	14,	36},
{16,	39,	21,	17,	33},
{19,	33,	26,	14,	13},
{19,	39,	19,	19,	36},
{17,	32,	23,	17,	34},
{16,	31,	31,	11,	32},
{17,	31,	29,	13,	29},
{16,	30,	32,	14,	19},
{16,	30,	27,	15,	38},
{18,	32,	25,	15,	36},
{16,	32,	31,	10,	29},
{16,	32,	27,	13,	29},
{16,	32,	25,	19,	2},
{15,	39,	26,	7,	33},
{17,	39,	27,	3,	36},
{17,	36,	27,	3,	37},
{17,	35,	30,	7,	25},
{16,	36,	35,	7,	0},
{16,	36,	35,	6,	3},
{15,	18,	36,	13,	39},
{15,	18,	33,	26,	36},
{15,	7,	37,	28,	18},
{18,	7,	37,	29,	5},
{15,	33,	37,	6,	35},
{17,	33,	39,	4,	33},
{15,	38,	35,	4,	5},
{17,	38,	34,	3,	8},
{17,	39,	29,	4,	19},
{15,	27,	20,	27,	37},
{18,	27,	17,	32,	37},
{16,	39,	14,	29,	34},
{16,	27,	23,	26,	22},
{16,	29,	21,	21,	27},
{15,	28,	19,	26,	34},
{16,	29,	17,	29,	18},
{15,	3,	26,	35,	11},
{15,	27,	24,	12,	39},
{15,	39,	23,	11,	27},
{15,	15,	38,	21,	4},
{15,	13,	38,	29,	2},
{15,	14,	37,	28,	21},
{17,	15,	35,	27,	25},
{15,	15,	35,	25,	31},
{17,	8,	36,	24,	29},
{17,	6,	36,	28,	25},
{15,	23,	33,	32,	3},
{15,	29,	31,	15,	36},
{15,	31,	21,	20,	36},
{16,	30,	21,	24,	11},
{16,	30,	18,	21,	37},
{17,	28,	25,	19,	37},
{15,	24,	37,	13,	37},
{16,	14,	38,	15,	36},
{15,	16,	33,	28,	35},
{15,	35,	28,	5,	36},
{16,	36,	28,	5,	35},
{16,	35,	28,	7,	33},
{15,	34,	27,	11,	23},
{15,	33,	39,	4,	37},
{15,	39,	30,	4,	19},
{15,	1,	35,	20,	36},
{15,	22,	28,	31,	32},
{15,	1,	36,	20,	35},
{15,	35,	32,	7,	12},
{15,	31,	32,	14,	8},
{15,	28,	32,	15,	38},
{15,	39,	27,	5,	36},
{15,	20,	33,	25,	36},
{15,	32,	30,	9,	36},
{15,	22,	38,	18,	24},
{15,	29,	24,	8,	39},
{15,	28,	39,	9,	11},
{15,	27,	38,	15,	10},
{15,	30,	23,	28,	0},
{15,	36,	33,	5,	20},
{15,	39,	35,	1,	35},
{15,	23,	31,	24,	29},
{15,	23,	34,	22,	32},
{16,	23,	30,	27,	34},
{16,	22,	32,	31,	22},
{15,	35,	34,	5,	27},
{15,	26,	37,	15,	18},
{15,	26,	37,	13,	36},
{15,	31,	35,	7,	37},
{15,	31,	35,	9,	32},
{16,	30,	32,	14,	32},
{16,	31,	34,	9,	35},
{15,	30,	38,	9,	11},
{15,	31,	36,	9,	11},
{15,	39,	28,	3,	32},
{15,	24,	34,	20,	17},
{15,	24,	35,	20,	8},
{15,	22,	36,	26,	17},
{17,	20,	36,	25,	26},
{16,	23,	36,	25,	10},
{15,	19,	37,	26,	14},
{15,	23,	32,	30,	11},
{15,	25,	39,	17,	9},
{15,	34,	24,	17,	1},
{14,	36,	38,	7,	36},
{20,	37,	34,	3,	32},
{18,	37,	38,	3,	27},
{18,	37,	37,	4,	17},
{17,	33,	39,	6,	29},
{17,	39,	27,	6,	14},
{16,	36,	39,	6,	27},
{16,	39,	36,	3,	3},
{16,	32,	35,	8,	6},
{15,	39,	24,	8,	36},
{17,	35,	27,	10,	4},
{16,	39,	23,	11,	36},
{15,	39,	28,	4,	36},
{15,	35,	30,	3,	37},
{15,	36,	39,	0,	38},
{15,	35,	28,	10,	4},
{14,	23,	39,	24,	26},
{16,	13,	38,	25,	19},
{16,	23,	35,	24,	30},
{16,	22,	37,	26,	21},
{15,	13,	38,	21,	31},
{15,	22,	32,	28,	34},
{16,	22,	33,	25,	36},
{14,	30,	39,	15,	36},
{16,	31,	33,	15,	7},
{15,	30,	35,	12,	37},
{15,	31,	36,	9,	29},
{15,	31,	29,	15,	29},
{15,	21,	37,	17,	36},
{15,	19,	37,	16,	37},
{15,	18,	39,	15,	37},
{15,	8,	38,	12,	38},
{16,	15,	39,	8,	38},
{15,	30,	34,	15,	37},
{15,	31,	35,	15,	1},
{14,	25,	26,	27,	38},
{19,	24,	30,	23,	36},
{18,	27,	23,	24,	38},
{16,	22,	24,	29,	37},
{16,	24,	33,	22,	24},
{15,	18,	25,	31,	37},
{15,	24,	30,	27,	34},
{16,	24,	30,	30,	8},
{15,	24,	34,	30,	1},
{15,	25,	30,	20,	38},
{15,	24,	33,	25,	14},
{14,	24,	17,	35,	35},
{17,	15,	22,	33,	35},
{17,	15,	26,	34,	11},
{16,	24,	18,	35,	28},
{15,	9,	26,	35,	12},
{14,	16,	38,	31,	16},
{17,	20,	36,	31,	6},
{17,	13,	35,	32,	16},
{16,	22,	38,	26,	17},
{16,	16,	38,	28,	19},
{16,	22,	36,	27,	17},
{16,	21,	35,	30,	17},
{15,	18,	35,	30,	24},
{17,	6,	37,	29,	22},
{15,	16,	36,	31,	19},
{14,	15,	32,	34,	31},
{19,	9,	29,	35,	10},
{17,	5,	32,	35,	6},
{17,	22,	21,	34,	32},
{17,	10,	26,	34,	33},
{16,	9,	23,	35,	28},
{16,	20,	34,	33,	0},
{15,	10,	30,	34,	32},
{15,	25,	19,	34,	32},
{14,	28,	32,	15,	39},
{15,	29,	26,	14,	39},
{16,	29,	30,	11,	39},
{15,	31,	21,	10,	39},
{16,	31,	24,	7,	39},
{15,	30,	29,	3,	39},
{14,	24,	18,	36,	20},
{14,	37,	33,	6,	35},
{17,	39,	27,	7,	36},
{17,	39,	31,	6,	4},
{15,	38,	35,	6,	0},
{15,	37,	34,	4,	35},
{14,	39,	35,	4,	33},
{17,	39,	36,	4,	12},
{15,	38,	36,	3,	30},
{14,	39,	31,	6,	31},
{16,	38,	33,	6,	17},
{14,	16,	39,	29,	12},
{17,	22,	39,	27,	8},
{16,	16,	39,	30,	3},
{15,	20,	39,	28,	11},
{15,	14,	39,	31,	3},
{14,	32,	35,	9,	36},
{15,	31,	32,	9,	38},
{15,	33,	26,	9,	37},
{15,	33,	22,	11,	38},
{15,	39,	21,	14,	38},
{15,	31,	24,	17,	38},
{15,	30,	33,	11,	38},
{15,	28,	34,	12,	38},
{15,	25,	34,	17,	38},
{16,	24,	38,	17,	32},
{15,	26,	37,	17,	32},
{15,	25,	36,	18,	32},
{17,	24,	39,	20,	9},
{17,	25,	39,	18,	22},
{15,	24,	34,	19,	35},
{16,	27,	31,	19,	32},
{14,	31,	28,	19,	33},
{18,	29,	37,	18,	0},
{17,	30,	34,	18,	2},
{17,	31,	26,	17,	38},
{16,	31,	28,	15,	38},
{15,	32,	29,	13,	34},
{16,	33,	26,	12,	37},
{15,	28,	31,	18,	37},
{15,	33,	26,	16,	8},
{14,	28,	31,	19,	38},
{16,	28,	34,	19,	5},
{15,	30,	33,	19,	1},
{15,	30,	29,	19,	22},
{16,	29,	31,	16,	36},
{15,	30,	32,	18,	8},
{15,	29,	30,	19,	28},
{14,	31,	26,	21,	37},
{18,	27,	25,	25,	21},
{17,	28,	25,	22,	38},
{18,	27,	26,	24,	36},
{16,	26,	30,	20,	34},
{16,	30,	28,	20,	19},
{16,	28,	27,	21,	38},
{16,	30,	31,	21,	2},
{15,	39,	19,	21,	38},
{15,	32,	23,	21,	34},
{14,	31,	20,	25,	34},
{15,	39,	16,	27,	37},
{16,	30,	20,	24,	38},
{15,	31,	21,	24,	30},
{14,	29,	25,	25,	36},
{16,	28,	24,	26,	36},
{14,	21,	23,	28,	38},
{14,	34,	24,	13,	35},
{16,	34,	26,	11,	36},
{14,	35,	39,	3,	37},
{15,	35,	34,	4,	37},
{14,	6,	33,	31,	35},
{14,	16,	34,	29,	35},
{16,	6,	34,	30,	35},
{16,	24,	34,	22,	35},
{14,	25,	38,	20,	25},
{16,	30,	33,	20,	3},
{16,	30,	38,	16,	6},
{17,	29,	35,	17,	12},
{16,	26,	39,	19,	4},
{16,	25,	32,	21,	36},
{15,	28,	28,	21,	37},
{15,	29,	32,	19,	12},
{15,	30,	34,	18,	9},
{16,	30,	31,	17,	27},
{14,	29,	34,	17,	33},
{16,	28,	36,	16,	34},
{15,	28,	35,	18,	23},
{15,	29,	30,	19,	36},
{15,	29,	33,	17,	37},
{14,	31,	38,	8,	36},
{14,	32,	30,	13,	33},
{15,	31,	32,	16,	9},
{14,	24,	38,	20,	29},
{15,	22,	37,	19,	32},
{15,	21,	38,	21,	31},
{14,	22,	37,	24,	30},
{15,	6,	36,	25,	31},
{14,	22,	36,	22,	34},
{16,	9,	37,	24,	32},
{14,	21,	37,	20,	36},
{15,	19,	37,	18,	37},
{14,	18,	36,	20,	37},
{14,	39,	39,	2,	21},
{14,	18,	38,	24,	29},
{14,	36,	27,	8,	8},
{16,	39,	27,	10,	1},
{14,	18,	34,	26,	36},
{14,	6,	36,	32,	11},
{14,	35,	26,	8,	30},
{14,	17,	28,	33,	33},
{14,	15,	33,	33,	17},
{15,	5,	33,	35,	4},
{14,	31,	32,	14,	21},
{14,	31,	35,	11,	37},
{15,	31,	36,	13,	11},
{14,	33,	27,	8,	37},
{14,	39,	23,	12,	30},
{14,	15,	34,	33,	9},
{14,	16,	34,	32,	32},
{14,	18,	22,	34,	35},
{14,	23,	19,	35,	35},
{15,	9,	24,	35,	30},
{15,	17,	19,	36,	20},
{14,	30,	38,	3,	38},
{14,	26,	34,	8,	39},
{14,	23,	39,	27,	8},
{14,	24,	34,	23,	35},
{14,	23,	34,	25,	32},
{14,	24,	33,	25,	33},
{14,	21,	38,	17,	36},
{14,	30,	24,	14,	39},
{14,	19,	31,	35,	1},
{15,	18,	32,	34,	10},
{14,	17,	34,	33,	25},
{14,	31,	34,	18,	1},
{14,	22,	30,	31,	33},
{15,	22,	25,	31,	37},
{14,	22,	22,	34,	35},
{15,	22,	25,	33,	33},
{14,	30,	28,	19,	37},
{14,	25,	39,	20,	22},
{14,	32,	33,	10,	21},
{14,	30,	37,	18,	3},
{14,	31,	20,	32,	0},
{14,	25,	34,	20,	35},
{14,	32,	28,	13,	37},
{14,	37,	39,	3,	30},
{14,	39,	30,	4,	35},
{14,	36,	33,	1,	38},
{14,	34,	39,	7,	27},
{14,	31,	39,	10,	29},
{14,	32,	38,	9,	36},
{14,	32,	39,	8,	33},
{14,	35,	39,	6,	33},
{14,	31,	39,	15,	1},
{14,	31,	36,	15,	10},
{14,	31,	37,	11,	36},
{14,	25,	23,	30,	16},
{14,	23,	28,	32,	29},
{15,	25,	26,	31,	21},
{14,	25,	24,	31,	37},
{17,	23,	30,	31,	34},
{14,	30,	29,	18,	38},
{14,	30,	31,	19,	36},
{14,	30,	33,	18,	23},
{14,	21,	37,	22,	34},
{14,	37,	34,	5,	35},
{15,	39,	34,	6,	2},
{14,	21,	33,	15,	39},
{14,	34,	25,	12,	35},
{14,	39,	25,	8,	27},
{14,	34,	27,	11,	26},
{14,	39,	26,	8,	19},
{14,	6,	37,	32,	5},
{13,	35,	38,	12,	35},
{19,	34,	34,	11,	36},
{18,	35,	39,	8,	27},
{18,	35,	32,	13,	4},
{17,	31,	39,	15,	12},
{17,	31,	35,	13,	36},
{16,	35,	34,	9,	36},
{16,	39,	24,	13,	33},
{15,	31,	34,	16,	16},
{14,	39,	25,	9,	37},
{18,	35,	28,	9,	37},
{14,	34,	38,	6,	37},
{14,	39,	26,	14,	0},
{14,	31,	38,	13,	36},
{14,	31,	36,	14,	36},
{13,	28,	32,	21,	39},
{18,	30,	32,	20,	21},
{18,	21,	33,	17,	39},
{15,	30,	31,	20,	36},
{15,	30,	19,	21,	39},
{13,	22,	20,	37,	34},
{17,	39,	8,	36,	35},
{16,	26,	13,	37,	32},
{14,	19,	22,	35,	35},
{14,	10,	26,	35,	29},
{14,	24,	25,	36,	0},
{14,	24,	19,	37,	34},
{14,	22,	27,	35,	5},
{16,	21,	29,	33,	32},
{15,	20,	32,	34,	13},
{14,	23,	29,	33,	23},
{13,	17,	33,	33,	37},
{17,	23,	27,	25,	38},
{16,	23,	25,	33,	37},
{16,	22,	32,	27,	37},
{15,	18,	34,	24,	37},
{15,	10,	30,	34,	34},
{14,	27,	29,	22,	37},
{16,	29,	30,	22,	13},
{14,	22,	30,	30,	36},
{14,	20,	33,	33,	31},
{14,	30,	29,	23,	0},
{14,	10,	24,	35,	35},
{13,	36,	37,	9,	35},
{16,	36,	32,	13,	0},
{15,	39,	27,	9,	30},
{15,	36,	34,	11,	3},
{15,	36,	32,	13,	3},
{14,	36,	32,	11,	28},
{17,	39,	25,	12,	31},
{15,	36,	33,	12,	5},
{15,	39,	27,	11,	26},
{14,	36,	38,	10,	3},
{14,	36,	26,	12,	28},
{13,	33,	34,	15,	37},
{19,	33,	28,	16,	28},
{18,	32,	34,	17,	6},
{16,	32,	35,	15,	24},
{15,	34,	23,	15,	35},
{15,	39,	22,	17,	22},
{15,	32,	28,	17,	28},
{15,	33,	28,	16,	33},
{14,	32,	28,	19,	31},
{15,	32,	27,	20,	20},
{14,	31,	30,	19,	29},
{14,	39,	25,	14,	19},
{14,	34,	26,	15,	25},
{13,	24,	38,	8,	39},
{16,	29,	38,	7,	38},
{14,	19,	37,	10,	39},
{14,	12,	39,	2,	39},
{13,	21,	39,	20,	36},
{16,	21,	38,	22,	34},
{14,	18,	39,	17,	37},
{14,	21,	39,	21,	34},
{14,	17,	38,	23,	32},
{13,	17,	37,	29,	34},
{15,	21,	38,	23,	34},
{14,	18,	36,	26,	36},
{16,	19,	35,	23,	37},
{14,	20,	37,	27,	32},
{14,	23,	35,	23,	36},
{14,	21,	38,	22,	35},
{13,	16,	37,	21,	38},
{14,	21,	39,	21,	36},
{13,	15,	35,	32,	34},
{13,	15,	35,	34,	29},
{15,	6,	36,	33,	8},
{15,	20,	36,	33,	4},
{15,	5,	35,	35,	2},
{15,	14,	39,	32,	0},
{14,	17,	36,	32,	14},
{13,	14,	37,	32,	25},
{16,	10,	38,	30,	19},
{15,	16,	36,	32,	27},
{13,	26,	26,	30,	36},
{17,	28,	25,	30,	7},
{14,	27,	22,	27,	38},
{14,	27,	26,	25,	38},
{14,	29,	23,	33,	1},
{13,	26,	39,	20,	22},
{14,	27,	37,	18,	21},
{15,	28,	38,	16,	34},
{13,	32,	38,	12,	37},
{16,	30,	39,	13,	37},
{13,	19,	39,	26,	20},
{13,	19,	33,	21,	39},
{13,	34,	24,	10,	38},
{14,	33,	24,	15,	38},
{14,	32,	26,	15,	38},
{14,	39,	24,	4,	38},
{14,	39,	25,	3,	38},
{14,	34,	25,	10,	38},
{13,	39,	32,	6,	29},
{13,	39,	35,	3,	35},
{13,	19,	38,	21,	37},
{13,	10,	27,	35,	35},
{13,	30,	34,	17,	37},
{13,	27,	35,	20,	23},
{13,	6,	39,	12,	38},
{13,	5,	5,	37,	35},
{13,	34,	30,	13,	32},
{13,	35,	32,	13,	21},
{13,	30,	26,	22,	37},
{15,	30,	24,	25,	26},
{14,	30,	25,	23,	36},
{13,	29,	37,	15,	37},
{14,	24,	36,	15,	38},
{13,	24,	30,	30,	28},
{13,	23,	39,	29,	3},
{13,	1,	39,	25,	25},
{13,	10,	37,	33,	6},
{15,	0,	38,	35,	0},
{13,	20,	32,	34,	27},
{15,	21,	26,	35,	31},
{14,	17,	29,	35,	15},
{13,	21,	28,	33,	37},
{14,	26,	26,	31,	37},
{13,	30,	34,	12,	38},
{13,	35,	34,	7,	37},
{13,	39,	24,	16,	16},
{13,	23,	36,	32,	3},
{13,	39,	35,	5,	9},
{13,	39,	36,	6,	2},
{13,	39,	18,	26,	34},
{13,	21,	27,	35,	32},
{13,	39,	33,	0,	38},
{13,	23,	34,	27,	24},
{13,	31,	24,	12,	39},
{13,	31,	27,	5,	39},
{13,	35,	26,	15,	19},
{13,	24,	23,	35,	9},
{14,	24,	25,	33,	34},
{14,	24,	29,	33,	16},
{13,	36,	39,	10,	1},
{13,	33,	39,	9,	32},
{14,	35,	39,	12,	3},
{13,	33,	39,	11,	21},
{13,	24,	33,	26,	33},
{13,	36,	36,	8,	36},
{13,	31,	38,	15,	24},
{13,	20,	39,	10,	38},
{13,	19,	38,	27,	22},
{13,	33,	29,	16,	26},
{13,	32,	24,	4,	39},
{13,	1,	34,	15,	39},
{13,	26,	26,	32,	23},
{13,	22,	36,	26,	32},
{13,	22,	35,	26,	36},
{13,	19,	36,	24,	37},
{13,	35,	37,	6,	37},
{13,	38,	35,	4,	35},
{13,	31,	23,	24,	26},
{13,	36,	38,	9,	20},
{13,	35,	28,	2,	38},
{13,	38,	33,	6,	24},
{13,	18,	33,	32,	37},
{13,	22,	32,	31,	37},
{13,	21,	35,	29,	34},
{13,	32,	22,	21,	37},
{14,	39,	21,	18,	36},
{14,	33,	28,	16,	37},
{14,	32,	25,	18,	38},
{13,	30,	36,	8,	38},
{13,	39,	26,	6,	37},
{13,	31,	34,	16,	24},
{13,	27,	33,	21,	23},
{13,	28,	24,	27,	25},
{13,	28,	22,	29,	19},
{13,	27,	37,	19,	14},
{13,	20,	33,	35,	4},
{13,	37,	35,	6,	6},
{14,	39,	35,	6,	4},
{12,	30,	39,	30,	37},
{18,	31,	22,	30,	27},
{17,	29,	18,	32,	35},
{17,	13,	38,	31,	27},
{16,	31,	25,	28,	15},
{14,	31,	25,	32,	7},
{14,	31,	38,	16,	24},
{14,	19,	34,	32,	37},
{14,	24,	37,	18,	38},
{14,	28,	33,	21,	38},
{14,	27,	27,	33,	5},
{14,	20,	37,	33,	4},
{14,	31,	39,	17,	6},
{14,	31,	23,	28,	34},
{14,	29,	17,	33,	35},
{14,	26,	22,	33,	33},
{14,	25,	29,	33,	16},
{14,	27,	27,	33,	22},
{16,	29,	25,	33,	17},
{14,	29,	27,	31,	24},
{14,	14,	39,	32,	4},
{14,	14,	38,	33,	4},
{13,	30,	29,	24,	38},
{16,	30,	32,	21,	38},
{13,	13,	39,	31,	19},
{13,	31,	36,	17,	24},
{13,	28,	28,	25,	38},
{13,	31,	39,	17,	17},
{13,	23,	32,	31,	37},
{13,	25,	32,	33,	10},
{14,	22,	33,	35,	4},
{14,	24,	29,	34,	11},
{13,	23,	33,	21,	39},
{13,	25,	36,	13,	39},
{13,	31,	37,	18,	7},
{14,	32,	35,	18,	2},
{13,	39,	17,	33,	32},
{13,	39,	18,	32,	32},
{13,	31,	19,	26,	38},
{13,	24,	25,	34,	29},
{13,	25,	29,	34,	16},
{12,	19,	32,	39,	31},
{16,	13,	30,	37,	32},
{16,	21,	23,	38,	25},
{15,	21,	23,	37,	34},
{14,	21,	21,	38,	34},
{17,	11,	4,	38,	35},
{13,	12,	35,	37,	2},
{14,	0,	37,	36,	0},
{13,	21,	29,	38,	27},
{14,	21,	33,	37,	4},
{14,	20,	35,	37,	1},
{13,	20,	35,	34,	11},
{13,	39,	11,	39,	29},
{13,	24,	27,	38,	4},
{13,	24,	25,	38,	28},
{14,	23,	24,	38,	33},
{13,	24,	27,	36,	22},
{13,	17,	35,	34,	29},
{13,	0,	37,	37,	0},
{13,	19,	31,	37,	32},
{13,	15,	35,	34,	32},
{14,	17,	35,	33,	34},
{13,	22,	32,	38,	5},
{12,	23,	28,	33,	38},
{15,	26,	28,	30,	38},
{14,	29,	19,	31,	38},
{14,	23,	28,	37,	27},
{12,	24,	22,	37,	37},
{14,	17,	8,	34,	38},
{14,	11,	27,	35,	36},
{14,	16,	25,	35,	37},
{12,	38,	35,	7,	28},
{14,	37,	33,	7,	32},
{13,	39,	29,	7,	34},
{13,	38,	35,	5,	31},
{12,	37,	34,	11,	28},
{14,	39,	30,	9,	1},
{14,	39,	29,	11,	27},
{14,	37,	30,	9,	30},
{13,	37,	36,	10,	0},
{12,	18,	37,	34,	25},
{14,	16,	36,	34,	28},
{14,	3,	39,	31,	28},
{14,	14,	38,	34,	4},
{13,	17,	37,	31,	36},
{14,	13,	38,	31,	33},
{13,	17,	35,	33,	36},
{13,	16,	36,	33,	30},
{12,	32,	26,	28,	34},
{14,	32,	27,	23,	33},
{16,	31,	29,	28,	4},
{15,	32,	29,	20,	26},
{13,	31,	31,	28,	0},
{13,	32,	20,	30,	27},
{13,	32,	26,	21,	37},
{12,	23,	36,	18,	39},
{13,	17,	34,	21,	39},
{12,	32,	36,	12,	38},
{16,	34,	38,	2,	38},
{15,	32,	33,	15,	38},
{13,	31,	39,	5,	38},
{12,	33,	35,	9,	38},
{15,	33,	31,	15,	38},
{13,	34,	38,	3,	38},
{12,	33,	26,	9,	39},
{13,	33,	27,	4,	39},
{13,	30,	27,	14,	39},
{12,	39,	33,	9,	4},
{13,	38,	33,	8,	8},
{13,	39,	34,	9,	0},
{12,	24,	38,	18,	38},
{13,	29,	39,	9,	38},
{12,	31,	18,	36,	26},
{13,	27,	21,	35,	30},
{14,	27,	27,	34,	16},
{13,	39,	16,	38,	17},
{12,	34,	25,	8,	39},
{13,	39,	24,	4,	39},
{12,	34,	32,	14,	23},
{13,	35,	32,	14,	11},
{13,	34,	32,	15,	5},
{13,	34,	34,	13,	23},
{14,	36,	34,	13,	4},
{12,	35,	26,	8,	38},
{12,	39,	39,	3,	11},
{12,	35,	26,	15,	32},
{12,	39,	24,	17,	31},
{15,	33,	25,	17,	38},
{13,	35,	25,	16,	31},
{12,	39,	35,	6,	11},
{12,	37,	33,	14,	0},
{12,	38,	37,	9,	0},
{12,	37,	37,	4,	35},
{12,	37,	37,	7,	26},
{16,	38,	36,	7,	15},
{15,	39,	36,	6,	12},
{12,	37,	37,	6,	35},
{12,	38,	39,	5,	8},
{14,	37,	39,	7,	4},
{13,	39,	38,	6,	0},
{13,	38,	38,	9,	0},
{12,	34,	33,	14,	32},
{12,	20,	36,	34,	22},
{12,	37,	36,	3,	36},
{12,	36,	35,	11,	27},
{12,	36,	39,	10,	9},
{12,	35,	39,	12,	17},
{12,	31,	36,	18,	23},
{14,	32,	31,	18,	15},
{12,	35,	38,	2,	38},
{12,	31,	26,	16,	39},
{13,	32,	20,	18,	39},
{13,	29,	27,	21,	39},
{12,	38,	39,	7,	4},
{13,	38,	39,	6,	7},
{12,	35,	28,	11,	37},
{13,	39,	23,	13,	38},
{12,	31,	26,	24,	37},
{12,	21,	36,	31,	29},
{12,	21,	23,	37,	36},
{12,	20,	25,	39,	31},
{12,	34,	28,	16,	7},
{12,	39,	25,	12,	34},
{12,	29,	36,	2,	39},
{12,	39,	34,	5,	19},
{12,	21,	34,	32,	37},
{12,	23,	30,	33,	37},
{12,	26,	30,	33,	16},
{12,	27,	28,	33,	18},
{12,	28,	34,	33,	2},
{14,	27,	32,	31,	18},
{14,	30,	29,	31,	13},
{14,	28,	32,	31,	22},
{13,	28,	35,	32,	4},
{12,	27,	28,	34,	22},
{14,	28,	23,	34,	27},
{12,	29,	28,	33,	8},
{13,	28,	35,	33,	4},
{13,	25,	35,	34,	2},
{12,	23,	33,	34,	27},
{13,	22,	31,	38,	27},
{13,	26,	33,	32,	22},
{13,	25,	35,	33,	9},
{13,	24,	36,	31,	18},
{14,	24,	34,	34,	16},
{12,	28,	33,	31,	37},
{14,	29,	29,	31,	37},
{14,	24,	34,	32,	29},
{12,	24,	34,	37,	0},
{12,	28,	22,	32,	37},
{12,	23,	36,	33,	11},
{12,	26,	36,	33,	4},
{12,	32,	35,	14,	37},
{12,	27,	18,	36,	35},
{12,	28,	22,	34,	35},
{13,	25,	25,	33,	37},
{12,	32,	22,	25,	37},
{12,	32,	26,	24,	37},
{12,	32,	20,	30,	33},
{12,	39,	19,	30,	38},
{12,	39,	27,	9,	33},
{12,	28,	34,	33,	6},
{12,	36,	32,	14,	5},
{14,	36,	26,	14,	22},
{12,	36,	26,	15,	17},
{12,	39,	32,	10,	0},
{13,	39,	31,	12,	0},
{11,	36,	39,	24,	35},
{19,	32,	31,	21,	37},
{18,	33,	32,	24,	36},
{19,	32,	36,	20,	37},
{17,	32,	38,	20,	37},
{16,	31,	28,	28,	34},
{16,	31,	32,	25,	34},
{16,	33,	31,	17,	38},
{16,	39,	20,	29,	36},
{15,	33,	37,	20,	36},
{15,	32,	27,	28,	34},
{14,	31,	39,	21,	37},
{14,	39,	27,	11,	35},
{14,	31,	32,	26,	23},
{13,	39,	22,	29,	9},
{14,	36,	28,	25,	0},
{13,	39,	26,	22,	27},
{13,	33,	35,	17,	37},
{13,	32,	28,	28,	22},
{12,	31,	39,	25,	24},
{14,	31,	35,	26,	23},
{12,	32,	34,	26,	26},
{14,	34,	34,	25,	0},
{13,	32,	30,	27,	22},
{12,	35,	29,	25,	21},
{14,	35,	32,	25,	3},
{12,	33,	34,	25,	22},
{12,	31,	33,	30,	0},
{13,	31,	27,	32,	8},
{12,	36,	39,	8,	36},
{12,	31,	33,	26,	35},
{12,	39,	22,	24,	36},
{13,	35,	28,	14,	36},
{13,	34,	28,	14,	37},
{12,	34,	26,	15,	38},
{13,	39,	25,	15,	37},
{12,	34,	27,	24,	36},
{12,	35,	27,	19,	36},
{12,	37,	34,	11,	29},
{11,	20,	38,	35,	37},
{17,	13,	34,	36,	13},
{15,	25,	38,	31,	12},
{14,	13,	36,	36,	6},
{14,	26,	38,	32,	4},
{13,	24,	38,	32,	24},
{13,	13,	39,	32,	11},
{13,	23,	28,	35,	37},
{13,	17,	37,	37,	0},
{13,	24,	24,	37,	35},
{12,	24,	39,	32,	29},
{13,	23,	36,	33,	27},
{12,	18,	30,	37,	35},
{15,	6,	31,	36,	36},
{12,	23,	32,	34,	34},
{12,	20,	35,	36,	8},
{11,	38,	39,	9,	34},
{15,	39,	32,	8,	29},
{14,	39,	33,	9,	10},
{14,	37,	30,	9,	35},
{13,	37,	37,	8,	35},
{12,	39,	30,	5,	36},
{14,	39,	33,	3,	36},
{12,	37,	31,	9,	36},
{12,	39,	35,	8,	1},
{12,	39,	30,	11,	12},
{11,	29,	38,	27,	38},
{14,	26,	29,	31,	38},
{13,	32,	36,	15,	38},
{12,	30,	27,	29,	38},
{11,	35,	38,	12,	38},
{13,	34,	39,	12,	37},
{12,	34,	35,	14,	37},
{11,	20,	34,	39,	17},
{13,	10,	36,	39,	0},
{12,	20,	34,	36,	27},
{12,	10,	37,	38,	0},
{11,	28,	39,	32,	28},
{13,	28,	27,	33,	35},
{13,	28,	29,	32,	36},
{12,	28,	26,	34,	29},
{12,	28,	38,	31,	30},
{11,	37,	34,	13,	29},
{14,	39,	27,	13,	36},
{13,	37,	31,	14,	20},
{11,	37,	39,	13,	23},
{11,	39,	37,	6,	26},
{13,	39,	38,	6,	17},
{12,	39,	39,	6,	1},
{11,	20,	39,	33,	31},
{13,	16,	39,	34,	0},
{12,	25,	39,	33,	5},
{12,	25,	37,	33,	16},
{12,	23,	38,	33,	26},
{11,	32,	30,	30,	19},
{14,	32,	25,	29,	36},
{13,	31,	25,	31,	26},
{12,	31,	37,	28,	3},
{13,	32,	36,	27,	0},
{11,	34,	38,	25,	22},
{13,	35,	32,	25,	22},
{13,	33,	39,	25,	13},
{13,	35,	39,	25,	3},
{12,	32,	38,	28,	3},
{11,	29,	39,	18,	38},
{11,	39,	35,	6,	34},
{12,	39,	36,	5,	34},
{12,	39,	36,	2,	36},
{12,	39,	38,	2,	33},
{11,	23,	37,	14,	39},
{11,	29,	39,	31,	30},
{11,	14,	36,	39,	6},
{13,	19,	36,	38,	4},
{11,	30,	32,	11,	39},
{11,	39,	33,	8,	33},
{13,	39,	33,	9,	17},
{11,	33,	37,	28,	1},
{13,	39,	24,	27,	8},
{12,	39,	23,	27,	18},
{12,	33,	23,	29,	35},
{11,	9,	39,	37,	0},
{12,	20,	38,	37,	0},
{11,	22,	31,	39,	28},
{13,	23,	26,	39,	25},
{12,	22,	31,	37,	33},
{13,	24,	27,	36,	36},
{12,	24,	34,	39,	0},
{11,	30,	39,	31,	15},
{11,	32,	27,	30,	32},
{11,	31,	37,	27,	24},
{13,	31,	39,	28,	13},
{12,	32,	34,	28,	17},
{13,	32,	37,	27,	17},
{12,	31,	33,	30,	12},
{12,	31,	34,	28,	28},
{11,	32,	28,	9,	39},
{12,	32,	31,	2,	39},
{11,	34,	33,	2,	39},
{11,	25,	30,	31,	38},
{11,	39,	24,	9,	39},
{12,	34,	26,	9,	39},
{11,	35,	27,	25,	35},
{11,	39,	30,	11,	32},
{11,	9,	38,	9,	39},
{11,	26,	34,	36,	0},
{11,	28,	27,	35,	35},
{14,	26,	25,	36,	35},
{12,	39,	16,	37,	31},
{12,	28,	33,	34,	1},
{12,	28,	33,	36,	0},
{12,	27,	24,	39,	2},
{13,	27,	24,	38,	11},
{13,	39,	17,	37,	31},
{12,	26,	24,	37,	33},
{11,	30,	26,	36,	27},
{14,	30,	27,	36,	14},
{13,	29,	24,	37,	27},
{13,	31,	22,	36,	15},
{13,	31,	25,	32,	32},
{12,	30,	29,	34,	6},
{12,	31,	29,	33,	5},
{12,	31,	29,	32,	13},
{12,	29,	21,	39,	8},
{12,	28,	20,	39,	26},
{11,	32,	21,	35,	27},
{12,	32,	29,	31,	13},
{11,	29,	36,	32,	27},
{11,	30,	34,	32,	20},
{11,	30,	35,	33,	6},
{11,	27,	25,	38,	28},
{11,	39,	27,	5,	37},
{12,	38,	39,	1,	37},
{11,	32,	39,	25,	26},
{11,	24,	28,	37,	33},
{11,	25,	28,	38,	28},
{12,	28,	26,	37,	29},
{12,	27,	28,	35,	35},
{13,	27,	30,	33,	35},
{12,	26,	32,	33,	34},
{11,	32,	35,	28,	22},
{11,	33,	39,	21,	36},
{12,	32,	39,	21,	37},
{11,	26,	38,	33,	18},
{11,	39,	34,	7,	25},
{11,	31,	39,	25,	32},
{11,	20,	39,	32,	32},
{11,	32,	38,	23,	36},
{11,	31,	33,	28,	34},
{11,	25,	28,	34,	37},
{11,	31,	30,	30,	32},
{12,	32,	28,	31,	22},
{11,	26,	25,	38,	33},
{11,	24,	25,	38,	34},
{11,	23,	34,	21,	39},
{11,	12,	26,	36,	37},
{11,	21,	38,	35,	9},
{11,	29,	26,	38,	7},
{11,	37,	34,	14,	6},
{11,	38,	34,	10,	4},
{11,	39,	35,	10,	0},
{11,	39,	35,	9,	15},
{12,	39,	34,	8,	32},
{12,	39,	36,	7,	28},
{12,	39,	36,	9,	3},
{11,	29,	35,	32,	29},
{11,	29,	29,	32,	37},
{11,	24,	34,	34,	27},
{13,	27,	29,	34,	35},
{11,	32,	29,	5,	39},
{10,	34,	39,	39,	37},
{16,	35,	38,	26,	2},
{15,	39,	23,	31,	35},
{12,	35,	30,	26,	22},
{12,	35,	33,	26,	16},
{12,	27,	23,	33,	38},
{11,	35,	27,	29,	22},
{12,	35,	32,	31,	0},
{11,	36,	31,	28,	0},
{11,	35,	31,	30,	4},
{12,	35,	29,	29,	21},
{11,	35,	30,	29,	18},
{11,	39,	24,	29,	31},
{11,	35,	28,	29,	29},
{12,	35,	32,	26,	29},
{10,	29,	33,	30,	39},
{16,	29,	37,	28,	38},
{13,	30,	30,	19,	39},
{13,	26,	32,	31,	38},
{12,	23,	36,	29,	38},
{12,	30,	32,	30,	38},
{12,	31,	27,	17,	39},
{12,	30,	33,	10,	39},
{11,	25,	32,	33,	38},
{11,	28,	35,	18,	39},
{12,	27,	36,	14,	39},
{11,	8,	36,	30,	38},
{11,	30,	34,	10,	39},
{11,	30,	30,	22,	39},
{11,	29,	34,	30,	38},
{11,	26,	36,	18,	39},
{10,	37,	39,	20,	27},
{16,	39,	28,	20,	30},
{14,	37,	38,	14,	29},
{13,	39,	27,	19,	35},
{12,	37,	30,	22,	22},
{12,	39,	28,	28,	0},
{12,	37,	32,	22,	13},
{11,	37,	30,	17,	30},
{10,	38,	39,	9,	37},
{16,	39,	36,	3,	37},
{16,	36,	35,	11,	37},
{13,	39,	35,	6,	36},
{14,	39,	34,	6,	37},
{12,	36,	38,	5,	38},
{12,	36,	30,	9,	38},
{11,	39,	28,	3,	38},
{11,	36,	35,	12,	37},
{11,	37,	29,	10,	37},
{10,	36,	31,	34,	29},
{13,	36,	30,	25,	35},
{13,	39,	23,	39,	22},
{13,	39,	28,	27,	3},
{11,	35,	32,	29,	29},
{11,	36,	30,	28,	31},
{11,	39,	26,	37,	3},
{12,	35,	27,	36,	22},
{11,	39,	23,	35,	36},
{11,	35,	33,	27,	19},
{10,	35,	39,	32,	29},
{14,	35,	39,	28,	31},
{14,	35,	39,	26,	34},
{11,	35,	32,	34,	29},
{11,	35,	34,	33,	24},
{10,	27,	31,	37,	38},
{11,	27,	32,	34,	38},
{11,	29,	29,	32,	38},
{10,	24,	38,	18,	39},
{10,	23,	39,	30,	38},
{10,	23,	37,	33,	38},
{12,	27,	35,	33,	38},
{10,	32,	31,	31,	38},
{11,	32,	20,	24,	39},
{11,	32,	32,	24,	38},
{10,	37,	36,	14,	35},
{13,	37,	31,	17,	33},
{13,	39,	28,	22,	32},
{11,	39,	28,	19,	35},
{10,	27,	15,	38,	38},
{10,	16,	34,	27,	39},
{10,	36,	31,	39,	1},
{10,	35,	36,	39,	0},
{13,	35,	36,	33,	24},
{11,	35,	36,	34,	6},
{10,	37,	37,	4,	38},
{12,	37,	31,	5,	38},
{11,	39,	29,	3,	38},
{10,	37,	37,	22,	6},
{12,	37,	35,	22,	12},
{11,	37,	39,	22,	0},
{10,	33,	28,	26,	38},
{12,	34,	25,	19,	38},
{10,	29,	36,	11,	39},
{10,	39,	29,	12,	32},
{10,	34,	27,	9,	39},
{10,	39,	29,	4,	39},
{12,	39,	30,	2,	39},
{11,	36,	28,	5,	39},
{10,	36,	27,	7,	39},
{10,	1,	23,	38,	38},
{10,	39,	20,	24,	39},
{10,	36,	30,	34,	30},
{10,	34,	28,	19,	38},
{10,	39,	39,	2,	36},
{10,	39,	25,	15,	38},
{10,	35,	25,	19,	37},
{10,	26,	38,	8,	39},
{11,	26,	37,	18,	39},
{10,	39,	35,	8,	25},
{10,	39,	35,	7,	36},
{11,	39,	33,	8,	37},
{10,	39,	34,	8,	36},
{10,	35,	27,	8,	39},
{10,	39,	31,	11,	8},
{10,	39,	21,	31,	38},
{10,	39,	36,	5,	37},
{10,	7,	33,	35,	38},
{10,	34,	30,	3,	39},
{10,	29,	34,	32,	38},
{10,	35,	33,	34,	29},
{10,	35,	38,	14,	36},
{10,	39,	30,	11,	35},
{10,	35,	31,	36,	8},
{10,	35,	34,	35,	8},
{10,	39,	35,	9,	17},
{9,	38,	39,	35,	38},
{13,	36,	36,	36,	0},
{13,	31,	31,	37,	38},
{11,	39,	35,	11,	17},
{11,	39,	36,	16,	0},
{12,	39,	35,	12,	3},
{11,	39,	26,	37,	22},
{10,	39,	35,	14,	18},
{11,	39,	32,	22,	8},
{10,	39,	37,	18,	0},
{11,	39,	33,	20,	11},
{11,	39,	35,	18,	3},
{10,	39,	35,	20,	3},
{10,	39,	35,	5,	38},
{10,	36,	35,	39,	0},
{10,	35,	37,	39,	0},
{10,	35,	30,	37,	13},
{10,	39,	33,	17,	14},
{9,	29,	25,	35,	39},
{14,	23,	27,	32,	39},
{10,	23,	28,	32,	39},
{9,	27,	38,	28,	39},
{14,	29,	34,	28,	39},
{10,	25,	36,	30,	39},
{10,	29,	35,	29,	39},
{9,	32,	37,	39,	38},
{10,	33,	37,	36,	38},
{9,	39,	39,	20,	2},
{11,	39,	37,	7,	17},
{10,	39,	37,	13,	3},
{9,	39,	32,	30,	38},
{11,	39,	33,	26,	8},
{11,	39,	33,	29,	6},
{10,	39,	34,	23,	3},
{10,	39,	32,	31,	26},
{9,	39,	37,	13,	18},
{13,	39,	37,	8,	22},
{10,	39,	38,	13,	4},
{9,	39,	33,	28,	20},
{9,	39,	36,	21,	5},
{10,	39,	35,	23,	2},
{10,	39,	37,	18,	3},
{10,	39,	38,	15,	3},
{9,	39,	34,	8,	38},
{9,	29,	28,	33,	39},
{9,	36,	27,	39,	21},
{9,	36,	28,	38,	33},
{14,	35,	31,	37,	33},
{10,	39,	26,	37,	37},
{10,	35,	31,	36,	37},
{9,	36,	33,	36,	14},
{11,	35,	34,	39,	3},
{10,	35,	33,	38,	8},
{9,	37,	29,	37,	32},
{10,	39,	30,	37,	3},
{9,	39,	35,	17,	11},
{12,	39,	34,	23,	8},
{10,	39,	36,	17,	7},
{10,	39,	34,	22,	11},
{9,	39,	35,	8,	34},
{9,	35,	33,	36,	29},
{9,	35,	27,	39,	31},
{9,	39,	36,	5,	38},
{9,	39,	25,	8,	39},
{9,	39,	38,	6,	19},
{9,	39,	36,	19,	6},
{8,	39,	39,	37,	20},
{14,	38,	39,	36,	22},
{13,	36,	39,	36,	27},
{13,	36,	35,	39,	4},
{12,	39,	31,	37,	27},
{11,	36,	37,	39,	0},
{11,	38,	32,	37,	27},
{11,	35,	38,	38,	3},
{10,	35,	35,	39,	16},
{10,	36,	31,	37,	35},
{9,	39,	37,	14,	35},
{10,	39,	37,	15,	27},
{10,	39,	34,	11,	37},
{11,	39,	33,	12,	38},
{10,	39,	37,	4,	37},
{10,	39,	35,	21,	21},
{10,	39,	34,	33,	21},
{10,	39,	38,	15,	21},
{9,	37,	39,	36,	35},
{10,	35,	39,	36,	36},
{9,	39,	35,	19,	26},
{12,	39,	37,	17,	23},
{10,	39,	35,	20,	25},
{11,	39,	33,	25,	27},
{10,	39,	35,	18,	27},
{9,	38,	39,	37,	23},
{9,	39,	38,	4,	33},
{9,	35,	32,	39,	29},
{9,	39,	37,	7,	36},
{9,	37,	33,	36,	37},
{9,	36,	34,	36,	38},
{9,	39,	38,	9,	22},
{8,	33,	36,	34,	39},
{15,	34,	32,	6,	39},
{10,	34,	33,	7,	39},
{10,	35,	30,	7,	39},
{10,	33,	26,	35,	39},
{10,	39,	24,	10,	39},
{8,	37,	39,	39,	37},
{13,	37,	37,	36,	38},
{10,	39,	30,	38,	14},
{8,	27,	39,	21,	39},
{8,	27,	31,	38,	39},
{10,	30,	34,	35,	39},
{10,	31,	23,	37,	39},
{8,	39,	39,	39,	1},
{8,	39,	35,	28,	32},
{11,	39,	36,	15,	35},
{9,	39,	34,	37,	25},
{8,	39,	38,	9,	37},
{9,	39,	39,	9,	26},
{9,	39,	35,	15,	36},
{8,	34,	32,	19,	39},
{13,	39,	23,	19,	39},
{10,	34,	33,	11,	39},
{9,	35,	30,	11,	39},
{9,	35,	24,	16,	39},
{8,	39,	36,	31,	28},
{10,	39,	35,	37,	23},
{10,	39,	35,	35,	26},
{10,	39,	37,	20,	22},
{8,	39,	35,	20,	37},
{10,	39,	33,	24,	35},
{10,	39,	34,	23,	35},
{9,	39,	33,	32,	33},
{8,	27,	37,	32,	39},
{8,	39,	36,	28,	34},
{8,	34,	36,	11,	39},
{10,	37,	39,	0,	39},
{8,	39,	36,	39,	9},
{11,	39,	34,	39,	12},
{10,	38,	39,	39,	4},
{8,	39,	36,	9,	38},
{8,	39,	39,	15,	23},
{8,	39,	38,	14,	35},
{8,	12,	34,	36,	39},
{8,	39,	37,	13,	37},
{10,	39,	38,	10,	37},
{9,	39,	36,	10,	38},
{8,	4,	36,	35,	39},
{8,	39,	36,	20,	36},
{8,	39,	39,	15,	25},
{8,	39,	39,	4,	35},
{8,	39,	27,	7,	39},
{9,	39,	29,	5,	39},
{8,	37,	30,	37,	38},
{8,	39,	34,	32,	31},
{8,	39,	38,	39,	3},
{8,	39,	39,	38,	5},
{8,	39,	39,	0,	39},
{8,	39,	25,	11,	39},
{7,	32,	38,	39,	39},
{12,	33,	38,	7,	39},
{10,	37,	38,	36,	38},
{8,	32,	39,	38,	38},
{10,	37,	39,	36,	38},
{7,	39,	37,	10,	39},
{8,	33,	38,	28,	39},
{8,	35,	38,	8,	39},
{8,	38,	38,	2,	39},
{8,	39,	28,	11,	39},
{7,	38,	39,	39,	38},
{8,	39,	35,	39,	25},
{8,	39,	39,	38,	7},
{7,	39,	38,	31,	32},
{10,	39,	39,	19,	22},
{8,	39,	38,	20,	35},
{10,	39,	37,	28,	34},
{8,	39,	34,	39,	32},
{10,	39,	35,	38,	28},
{7,	39,	37,	20,	38},
{7,	39,	39,	10,	38},
{9,	39,	39,	12,	31},
{7,	38,	38,	9,	39},
{7,	39,	26,	16,	39},
{7,	39,	38,	5,	39},
{7,	39,	38,	20,	36},
{7,	39,	36,	21,	38},
{7,	39,	35,	38,	32},
{7,	39,	24,	19,	39},
{7,	39,	32,	34,	37},
{8,	39,	33,	34,	34},
{7,	39,	37,	30,	34},
{7,	39,	35,	33,	34},
{7,	39,	36,	38,	20},
{7,	39,	39,	38,	15},
{7,	39,	38,	11,	38},
{7,	35,	37,	11,	39},
{6,	39,	37,	38,	39},
{12,	39,	29,	39,	39},
{10,	39,	38,	36,	22},
{8,	34,	38,	28,	39},
{8,	39,	38,	32,	32},
{10,	39,	38,	36,	25},
{7,	39,	38,	32,	33},
{7,	39,	30,	39,	39},
{7,	39,	38,	38,	20},
{6,	38,	38,	39,	39},
{7,	39,	32,	39,	39},
{6,	39,	38,	15,	39},
{6,	39,	38,	38,	34},
{7,	39,	38,	23,	35},
{6,	39,	37,	39,	38},
{7,	39,	39,	39,	11},
{6,	39,	38,	31,	36},
{6,	39,	39,	35,	21},
{6,	39,	38,	19,	37},
{6,	39,	39,	27,	22},
{6,	39,	38,	39,	17},
{6,	39,	39,	1,	39},
{5,	39,	39,	39,	39}};

static BtkLookupTable DefaultTable3100pop6 = { 
    sizeof(DefaultParam3100pop6Entries)/ sizeof(DefaultParam3100pop6Entries[0]),
    DefaultParam3100pop6Entries, 
    sizeof(DefaultTable3100pop6Entries)/ sizeof(DefaultTable3100pop6Entries[0]),
    DefaultTable3100pop6Entries 
};

BtkLookupTable *  
Btk_get_3100pop6_table(void) 
{ 
    return &DefaultTable3100pop6; 
}

static TraceParamEntry DefaultParam3730pop7Entries[] = {
/*   phr3_t            phr7_t             psr_t              pres_t  */
{0.014585753560580, 0.054285869074653, 1.306275046359526, 0.024416591842920},
{0.027107776642762, 0.065251655596093, 1.312198261722234, 0.030121261731180},
{0.034021950765976, 0.072931616974851, 1.314652483323880, 0.034009234115708},
{0.039133567805487, 0.079230768701982, 1.317537180726072, 0.037362750497328},
{0.043409418694117, 0.084768705247469, 1.321589085948695, 0.040629386687571},
{0.047218875510690, 0.089806231533489, 1.331901340355628, 0.043744556628700},
{0.050767684570326, 0.094541086798867, 1.420409633193966, 0.046739380808177},
{0.054147288493225, 0.099076998704409, 1.423031044645318, 0.049782905937523},
{0.057429416638546, 0.103462770964730, 1.424013599125136, 0.052841644245381},
{0.060669361429059, 0.107769964705824, 1.425020707711348, 0.055916347810235},
{0.063889147154860, 0.112015785875210, 1.425961925417807, 0.059014326537310},
{0.067127213796827, 0.116264207882706, 1.427339660278773, 0.062139319069278},
{0.070401688577726, 0.120555917766495, 1.428635458615808, 0.065273279572247},
{0.073731895213489, 0.124898804903639, 1.430125004018719, 0.068421978769793},
{0.077137641630559, 0.129359695404811, 1.431191411056051, 0.071586413038647},
{0.080648545975034, 0.133914993944009, 1.432070754708616, 0.074772565301981},
{0.084266233369080, 0.138641477373245, 1.433282534961031, 0.077985259280746},
{0.088019795901620, 0.143553572053808, 1.435175691168715, 0.081233884608981},
{0.091925362654973, 0.148710500655958, 1.437728918718058, 0.084529103377558},
{0.096021411274445, 0.154176258728000, 1.442236157629186, 0.087873614319860},
{0.100338467093649, 0.159999356521180, 1.449152128335943, 0.091276061497427},
{0.104902151967492, 0.166237004254392, 1.460800500977379, 0.094741421176298},
{0.109775251534967, 0.173030532664488, 1.484791377203162, 0.098285112507364},
{0.115003258436920, 0.180522089036126, 1.534010123478948, 0.101914589777280},
{0.120672283136997, 0.188886565160097, 1.553760126139563, 0.105658608050814},
{0.126879718748117, 0.198327650631592, 1.565980230473689, 0.109533232288886},
{0.133750566427415, 0.209207544954971, 1.569960306444063, 0.113561669322248},
{0.141477756678968, 0.221993282855083, 1.576458099520704, 0.117790217636586},
{0.150328158615586, 0.237315806465630, 1.595291792291491, 0.122278097511103},
{0.160724754889374, 0.256279818485781, 1.622589197439162, 0.127109493314585},
{0.173307243932233, 0.280754296041057, 1.673977745409019, 0.132443416782552},
{0.189200904646254, 0.313666436740298, 1.720093967707152, 0.138567177006184},
{0.210218571748623, 0.360734356573175, 1.774299071053056, 0.146118553273819},
{0.239837837224483, 0.432415020990826, 1.844526888325611, 0.157007810690276},
{0.285045885746404, 0.545544181684017, 1.954282348815752, 0.178146595284183},
{0.359646734846770, 0.719718710719900, 2.092568833780748, 0.214178101989693},
{0.488425958918684, 0.963494014386292, 2.299966806527797, 0.269375663466151},
{0.708354025396553, 1.286236376310821, 2.609881259130352, 0.347606274502610},
{1.087409532179885, 1.796294125594336, 3.244011693641038, 0.459493028335516},
{4639.268201462031357, 8601.240510416744655, 135.397110832506343, 3.676009516334222}};

static BtkLookupEntry DefaultTable3730pop7Entries[] = {
/* qv ind1 ind2 ind3 ind4 */
{36,	10,	15,	28,	30},
{45,	7,	7,	8,	31},
{44,	0,	8,	24,	36},
{42,	6,	0,	13,	33},
{42,	6,	0,	18,	39},
{42,	3,	0,	28,	35},
{40,	2,	6,	8,	34},
{41,	3,	15,	3,	37},
{40,	4,	10,	8,	34},
{41,	6,	4,	7,	35},
{40,	2,	2,	21,	37},
{41,	4,	6,	25,	32},
{42,	4,	10,	18,	34},
{40,	8,	1,	11,	33},
{40,	7,	12,	2,	37},
{40,	3,	5,	28,	33},
{40,	1,	10,	23,	37},
{40,	5,	12,	8,	35},
{41,	4,	15,	14,	35},
{40,	5,	15,	8,	39},
{39,	2,	11,	22,	38},
{40,	3,	10,	27,	34},
{39,	6,	14,	22,	31},
{41,	5,	14,	19,	34},
{39,	5,	5,	25,	33},
{40,	5,	6,	21,	38},
{40,	5,	15,	24,	33},
{38,	8,	4,	7,	33},
{40,	8,	6,	23,	31},
{39,	8,	12,	22,	31},
{38,	0,	22,	25,	11},
{42,	0,	22,	21,	23},
{40,	0,	17,	27,	36},
{38,	12,	2,	26,	24},
{41,	12,	2,	9,	30},
{39,	13,	2,	25,	15},
{39,	12,	2,	27,	25},
{38,	11,	2,	28,	27},
{38,	0,	23,	21,	25},
{37,	10,	4,	4,	32},
{38,	10,	8,	8,	31},
{39,	9,	11,	23,	31},
{39,	10,	2,	28,	31},
{38,	11,	1,	15,	33},
{37,	13,	2,	7,	32},
{38,	13,	2,	19,	25},
{37,	10,	10,	2,	33},
{38,	9,	12,	5,	33},
{38,	9,	12,	4,	38},
{37,	1,	21,	18,	19},
{40,	1,	23,	23,	6},
{40,	1,	16,	27,	36},
{39,	5,	14,	22,	36},
{38,	2,	16,	22,	12},
{38,	1,	23,	25,	10},
{39,	1,	17,	28,	31},
{40,	1,	21,	21,	25},
{39,	1,	19,	21,	37},
{39,	0,	24,	21,	29},
{38,	3,	10,	28,	36},
{37,	1,	24,	11,	18},
{37,	1,	24,	20,	18},
{37,	6,	2,	26,	33},
{37,	10,	10,	23,	31},
{37,	2,	16,	22,	38},
{37,	2,	25,	20,	18},
{39,	2,	23,	4,	29},
{39,	2,	23,	26,	11},
{39,	2,	24,	17,	22},
{39,	2,	20,	28,	15},
{38,	1,	25,	28,	9},
{37,	4,	14,	25,	36},
{37,	0,	25,	25,	36},
{39,	1,	21,	28,	30},
{37,	2,	25,	27,	14},
{36,	8,	7,	7,	34},
{37,	9,	15,	5,	38},
{37,	9,	15,	23,	31},
{36,	13,	2,	7,	34},
{36,	2,	22,	7,	31},
{37,	2,	19,	15,	38},
{36,	2,	25,	20,	21},
{36,	5,	24,	19,	21},
{44,	5,	23,	5,	30},
{44,	5,	24,	23,	13},
{43,	5,	21,	28,	14},
{43,	5,	18,	13,	35},
{42,	6,	16,	21,	25},
{40,	5,	25,	17,	13},
{40,	7,	16,	25,	14},
{39,	5,	19,	28,	18},
{38,	4,	25,	12,	23},
{38,	5,	17,	24,	26},
{38,	3,	20,	17,	30},
{39,	5,	22,	7,	34},
{38,	3,	22,	17,	32},
{38,	4,	24,	12,	29},
{38,	3,	22,	20,	31},
{40,	5,	18,	24,	31},
{38,	2,	21,	23,	35},
{40,	5,	19,	28,	25},
{38,	6,	16,	28,	30},
{37,	5,	25,	22,	14},
{37,	5,	24,	27,	14},
{37,	4,	21,	28,	22},
{37,	4,	20,	27,	29},
{36,	8,	20,	19,	22},
{43,	7,	18,	26,	25},
{41,	8,	20,	3,	34},
{40,	7,	20,	28,	13},
{39,	8,	18,	16,	27},
{39,	8,	17,	19,	31},
{39,	6,	20,	28,	25},
{38,	10,	17,	11,	30},
{39,	10,	17,	19,	8},
{38,	8,	17,	28,	28},
{38,	10,	17,	25,	10},
{39,	9,	17,	19,	29},
{40,	10,	16,	26,	29},
{38,	8,	20,	25,	18},
{37,	6,	21,	21,	22},
{37,	10,	16,	22,	31},
{37,	7,	20,	28,	25},
{36,	10,	17,	3,	35},
{36,	7,	20,	7,	32},
{37,	7,	18,	13,	32},
{36,	7,	8,	12,	33},
{37,	7,	16,	9,	35},
{37,	8,	15,	12,	33},
{38,	8,	17,	16,	33},
{36,	10,	3,	9,	35},
{36,	5,	25,	12,	25},
{37,	5,	24,	19,	29},
{38,	7,	20,	27,	28},
{37,	6,	21,	10,	34},
{36,	10,	17,	28,	13},
{36,	4,	10,	29,	27},
{41,	10,	13,	29,	3},
{41,	3,	15,	29,	28},
{41,	4,	21,	29,	19},
{37,	5,	2,	29,	26},
{37,	10,	6,	29,	22},
{39,	5,	19,	29,	24},
{37,	9,	3,	29,	28},
{37,	10,	8,	29,	22},
{37,	1,	21,	29,	33},
{37,	4,	8,	29,	31},
{37,	2,	8,	29,	36},
{36,	3,	1,	30,	9},
{38,	3,	11,	30,	3},
{37,	9,	9,	30,	1},
{37,	5,	25,	30,	1},
{36,	4,	9,	30,	5},
{39,	0,	12,	30,	15},
{38,	0,	3,	30,	36},
{37,	0,	19,	30,	19},
{36,	4,	0,	30,	14},
{36,	8,	9,	30,	4},
{36,	6,	9,	20,	35},
{36,	9,	3,	29,	31},
{36,	5,	25,	14,	29},
{37,	5,	25,	5,	35},
{37,	1,	25,	20,	38},
{36,	10,	6,	26,	31},
{37,	6,	17,	25,	32},
{38,	10,	15,	26,	31},
{37,	5,	14,	28,	32},
{37,	5,	17,	29,	31},
{37,	2,	21,	28,	36},
{36,	6,	3,	29,	33},
{37,	4,	14,	29,	34},
{36,	6,	20,	29,	20},
{37,	10,	17,	29,	10},
{36,	5,	9,	28,	35},
{36,	8,	11,	20,	39},
{36,	8,	4,	26,	32},
{37,	8,	6,	25,	33},
{37,	11,	1,	28,	33},
{36,	8,	8,	22,	36},
{36,	7,	18,	15,	38},
{37,	5,	25,	10,	36},
{36,	3,	23,	27,	28},
{36,	5,	23,	22,	29},
{36,	8,	17,	25,	32},
{36,	7,	26,	22,	29},
{40,	8,	21,	19,	23},
{40,	1,	26,	27,	36},
{39,	8,	22,	22,	16},
{39,	7,	26,	25,	13},
{39,	7,	25,	10,	35},
{38,	8,	22,	15,	27},
{37,	7,	24,	14,	32},
{39,	7,	22,	23,	32},
{37,	7,	25,	15,	36},
{36,	8,	21,	29,	9},
{36,	5,	24,	29,	15},
{36,	7,	24,	29,	11},
{36,	6,	26,	28,	12},
{36,	8,	22,	7,	36},
{36,	7,	26,	12,	36},
{37,	7,	26,	19,	33},
{38,	3,	26,	22,	36},
{37,	7,	26,	20,	34},
{36,	6,	29,	20,	28},
{42,	0,	29,	24,	33},
{40,	6,	28,	19,	34},
{39,	7,	28,	21,	10},
{41,	4,	28,	28,	16},
{39,	3,	28,	21,	37},
{38,	1,	28,	27,	37},
{37,	6,	29,	20,	34},
{37,	2,	21,	29,	37},
{36,	5,	29,	28,	6},
{36,	2,	23,	26,	38},
{35,	13,	2,	9,	34},
{35,	13,	2,	25,	25},
{35,	4,	5,	32,	26},
{40,	0,	4,	33,	19},
{39,	6,	10,	32,	2},
{39,	4,	9,	31,	14},
{39,	3,	6,	30,	30},
{37,	8,	3,	30,	11},
{38,	10,	1,	32,	6},
{37,	4,	13,	32,	5},
{37,	5,	1,	32,	20},
{38,	8,	3,	30,	20},
{38,	8,	9,	30,	15},
{37,	7,	1,	32,	18},
{37,	2,	19,	30,	18},
{37,	6,	12,	30,	19},
{36,	3,	7,	33,	1},
{37,	5,	0,	33,	9},
{36,	3,	4,	33,	8},
{37,	6,	1,	33,	16},
{36,	1,	4,	33,	21},
{36,	4,	1,	31,	30},
{37,	1,	2,	31,	35},
{36,	2,	14,	31,	19},
{36,	1,	7,	33,	19},
{36,	10,	10,	30,	17},
{36,	11,	1,	31,	19},
{37,	8,	1,	33,	18},
{36,	5,	0,	32,	30},
{36,	9,	8,	30,	21},
{38,	8,	3,	30,	29},
{36,	4,	6,	31,	29},
{35,	10,	2,	32,	5},
{38,	5,	5,	32,	21},
{37,	6,	10,	32,	7},
{37,	5,	13,	31,	19},
{35,	13,	2,	30,	4},
{35,	10,	2,	31,	17},
{35,	11,	12,	15,	30},
{39,	11,	12,	4,	34},
{38,	11,	3,	28,	8},
{37,	11,	12,	19,	3},
{37,	11,	4,	29,	7},
{36,	11,	11,	26,	2},
{36,	11,	3,	15,	32},
{36,	11,	3,	15,	35},
{38,	10,	3,	27,	33},
{37,	11,	2,	28,	32},
{36,	11,	15,	10,	31},
{39,	11,	15,	17,	8},
{37,	11,	8,	16,	28},
{37,	11,	3,	28,	31},
{39,	11,	12,	17,	27},
{37,	11,	15,	19,	10},
{38,	11,	10,	25,	7},
{38,	11,	14,	20,	13},
{37,	11,	9,	20,	21},
{38,	11,	15,	18,	20},
{38,	11,	15,	18,	27},
{37,	11,	14,	18,	31},
{36,	11,	9,	24,	31},
{39,	11,	5,	30,	14},
{37,	11,	5,	26,	31},
{36,	9,	15,	20,	34},
{39,	11,	7,	10,	34},
{37,	10,	17,	12,	32},
{37,	10,	6,	21,	35},
{37,	9,	8,	26,	33},
{37,	10,	12,	26,	32},
{36,	11,	8,	9,	38},
{36,	11,	15,	10,	34},
{36,	10,	16,	19,	34},
{37,	11,	9,	17,	36},
{36,	11,	18,	12,	34},
{40,	9,	19,	12,	32},
{38,	9,	19,	29,	8},
{38,	9,	19,	19,	26},
{37,	11,	17,	20,	11},
{37,	11,	17,	15,	31},
{36,	11,	16,	25,	6},
{37,	11,	17,	24,	13},
{36,	11,	16,	28,	7},
{36,	11,	17,	28,	9},
{36,	11,	16,	24,	17},
{36,	11,	12,	23,	29},
{36,	10,	8,	24,	34},
{36,	10,	8,	26,	34},
{36,	8,	3,	28,	36},
{36,	10,	14,	28,	33},
{39,	8,	17,	27,	34},
{37,	11,	5,	28,	32},
{37,	10,	16,	27,	34},
{36,	9,	11,	21,	38},
{36,	6,	26,	23,	34},
{38,	2,	28,	27,	38},
{38,	4,	28,	27,	27},
{36,	7,	25,	27,	18},
{36,	4,	24,	29,	23},
{37,	7,	24,	28,	23},
{37,	6,	25,	29,	22},
{37,	2,	25,	29,	35},
{36,	4,	29,	24,	23},
{36,	6,	29,	22,	24},
{37,	5,	29,	23,	34},
{36,	4,	26,	29,	25},
{36,	7,	21,	27,	34},
{36,	7,	28,	21,	34},
{36,	3,	26,	29,	34},
{35,	11,	10,	30,	10},
{35,	8,	24,	19,	17},
{35,	8,	1,	31,	28},
{35,	8,	2,	31,	29},
{35,	8,	24,	25,	14},
{35,	13,	2,	25,	32},
{36,	13,	2,	27,	30},
{35,	3,	6,	30,	33},
{35,	4,	0,	33,	31},
{36,	1,	6,	33,	27},
{35,	4,	5,	32,	29},
{36,	4,	1,	33,	31},
{35,	4,	5,	32,	31},
{36,	2,	6,	31,	35},
{35,	11,	18,	6,	38},
{36,	10,	14,	21,	36},
{35,	8,	2,	30,	33},
{36,	4,	5,	30,	36},
{35,	13,	8,	26,	27},
{45,	12,	7,	15,	34},
{43,	13,	5,	26,	30},
{42,	13,	7,	30,	8},
{41,	13,	8,	6,	35},
{39,	13,	6,	27,	22},
{39,	11,	10,	27,	29},
{38,	13,	7,	8,	38},
{38,	13,	3,	27,	32},
{37,	13,	6,	12,	39},
{37,	11,	12,	28,	21},
{37,	12,	7,	25,	32},
{36,	12,	9,	20,	18},
{37,	12,	9,	27,	15},
{36,	11,	9,	30,	19},
{36,	11,	13,	28,	29},
{37,	11,	15,	26,	28},
{35,	12,	9,	8,	27},
{35,	13,	8,	9,	33},
{36,	13,	8,	12,	36},
{36,	13,	7,	26,	30},
{36,	13,	7,	18,	35},
{36,	13,	8,	25,	31},
{35,	12,	15,	19,	25},
{44,	12,	14,	11,	37},
{41,	12,	14,	22,	27},
{39,	12,	13,	29,	8},
{39,	12,	11,	26,	28},
{36,	12,	15,	11,	39},
{36,	12,	9,	26,	32},
{35,	12,	17,	11,	14},
{37,	12,	16,	21,	15},
{35,	12,	17,	5,	25},
{35,	12,	17,	15,	23},
{35,	12,	13,	27,	16},
{35,	12,	18,	15,	25},
{38,	11,	18,	25,	13},
{37,	10,	18,	19,	32},
{36,	12,	18,	5,	37},
{37,	12,	18,	11,	34},
{35,	16,	8,	21,	27},
{44,	16,	5,	30,	5},
{44,	16,	5,	6,	34},
{42,	15,	5,	11,	32},
{41,	14,	5,	27,	15},
{40,	14,	8,	26,	15},
{39,	16,	7,	30,	4},
{40,	16,	8,	23,	15},
{40,	15,	6,	22,	28},
{38,	16,	8,	24,	15},
{38,	14,	7,	7,	36},
{38,	16,	7,	3,	36},
{38,	14,	7,	14,	32},
{38,	15,	7,	24,	21},
{37,	14,	6,	26,	23},
{36,	16,	4,	11,	32},
{37,	16,	4,	21,	32},
{36,	15,	8,	23,	27},
{36,	14,	6,	26,	28},
{38,	15,	5,	24,	31},
{37,	14,	8,	25,	29},
{36,	14,	8,	9,	36},
{36,	16,	5,	19,	32},
{36,	16,	7,	24,	27},
{36,	14,	8,	26,	30},
{35,	14,	8,	30,	7},
{35,	16,	6,	26,	14},
{37,	15,	8,	26,	17},
{37,	16,	4,	25,	30},
{36,	15,	8,	27,	12},
{37,	17,	4,	27,	18},
{35,	17,	4,	15,	32},
{35,	16,	10,	17,	26},
{44,	14,	10,	26,	20},
{41,	14,	10,	15,	30},
{39,	16,	10,	24,	9},
{38,	15,	10,	3,	34},
{37,	16,	10,	28,	4},
{37,	16,	10,	7,	29},
{37,	16,	10,	26,	10},
{37,	16,	9,	24,	20},
{37,	16,	9,	22,	27},
{37,	14,	9,	20,	32},
{36,	16,	10,	30,	5},
{36,	16,	10,	26,	17},
{36,	16,	8,	22,	31},
{39,	16,	10,	6,	36},
{36,	16,	10,	8,	32},
{36,	15,	10,	18,	30},
{38,	16,	9,	20,	32},
{36,	13,	10,	25,	30},
{35,	17,	9,	26,	18},
{43,	17,	5,	10,	31},
{40,	17,	9,	3,	29},
{37,	17,	9,	9,	22},
{38,	17,	9,	14,	22},
{39,	17,	5,	24,	24},
{38,	17,	7,	12,	27},
{37,	17,	8,	28,	7},
{37,	17,	6,	11,	32},
{36,	17,	9,	30,	6},
{36,	17,	7,	6,	36},
{35,	17,	10,	14,	21},
{38,	17,	10,	21,	19},
{37,	17,	10,	4,	32},
{37,	17,	10,	27,	10},
{35,	17,	6,	15,	29},
{36,	17,	5,	24,	29},
{35,	17,	10,	6,	36},
{35,	17,	10,	14,	24},
{35,	17,	10,	18,	23},
{35,	18,	5,	16,	32},
{37,	17,	7,	17,	32},
{36,	18,	5,	27,	13},
{36,	17,	9,	7,	34},
{35,	18,	5,	9,	35},
{36,	16,	9,	17,	36},
{36,	17,	9,	13,	33},
{36,	17,	5,	19,	35},
{38,	12,	6,	25,	34},
{37,	15,	9,	20,	35},
{37,	16,	5,	23,	34},
{35,	18,	5,	22,	25},
{35,	17,	9,	21,	25},
{35,	12,	18,	17,	27},
{35,	12,	18,	26,	4},
{37,	12,	18,	22,	17},
{38,	10,	17,	28,	30},
{37,	11,	17,	26,	28},
{37,	10,	18,	25,	32},
{36,	8,	20,	28,	25},
{37,	10,	18,	27,	34},
{35,	16,	4,	26,	29},
{35,	15,	7,	26,	27},
{37,	17,	5,	26,	29},
{35,	17,	9,	26,	24},
{36,	16,	8,	26,	29},
{36,	16,	6,	25,	33},
{35,	17,	10,	24,	22},
{35,	16,	14,	17,	31},
{42,	16,	12,	29,	5},
{43,	16,	14,	18,	32},
{40,	15,	12,	21,	25},
{39,	15,	13,	24,	12},
{38,	16,	14,	9,	33},
{37,	15,	12,	27,	11},
{37,	16,	13,	26,	12},
{38,	16,	13,	20,	28},
{37,	15,	13,	22,	28},
{38,	16,	13,	26,	16},
{38,	15,	13,	25,	22},
{37,	13,	12,	25,	31},
{36,	17,	11,	15,	21},
{37,	17,	11,	28,	8},
{37,	17,	11,	13,	27},
{37,	17,	11,	9,	34},
{36,	17,	10,	30,	8},
{36,	13,	18,	17,	24},
{39,	13,	18,	9,	31},
{37,	13,	16,	19,	27},
{37,	15,	14,	20,	30},
{36,	13,	16,	15,	32},
{36,	13,	18,	16,	30},
{36,	16,	14,	17,	35},
{36,	17,	10,	15,	34},
{36,	17,	8,	26,	28},
{36,	13,	18,	11,	37},
{36,	15,	12,	20,	35},
{36,	15,	32,	29,	38},
{43,	16,	10,	30,	18},
{42,	17,	9,	28,	26},
{39,	16,	10,	28,	30},
{39,	16,	10,	25,	37},
{38,	16,	7,	30,	22},
{38,	15,	3,	30,	30},
{39,	15,	6,	30,	30},
{37,	16,	14,	20,	38},
{37,	16,	13,	26,	38},
{38,	16,	13,	29,	25},
{38,	16,	11,	27,	39},
{39,	8,	32,	28,	39},
{36,	18,	5,	30,	16},
{36,	16,	14,	28,	30},
{36,	6,	33,	23,	35},
{39,	4,	33,	29,	37},
{37,	7,	33,	24,	39},
{35,	5,	5,	32,	29},
{35,	9,	2,	31,	31},
{35,	8,	8,	30,	28},
{36,	16,	7,	30,	30},
{36,	17,	6,	30,	28},
{35,	15,	11,	30,	19},
{35,	15,	19,	30,	2},
{35,	9,	13,	30,	21},
{37,	6,	13,	30,	28},
{37,	4,	13,	31,	28},
{37,	2,	13,	31,	34},
{37,	4,	17,	30,	29},
{36,	4,	8,	32,	31},
{35,	6,	19,	30,	19},
{35,	11,	19,	30,	11},
{36,	14,	18,	30,	19},
{35,	13,	25,	30,	7},
{37,	14,	25,	30,	11},
{36,	0,	27,	30,	21},
{35,	2,	30,	30,	11},
{35,	5,	8,	32,	30},
{36,	5,	13,	32,	13},
{37,	0,	24,	32,	13},
{35,	5,	32,	31,	1},
{35,	12,	24,	31,	6},
{36,	10,	14,	31,	16},
{38,	7,	5,	32,	19},
{35,	12,	4,	31,	16},
{35,	15,	3,	31,	14},
{35,	7,	8,	32,	19},
{35,	4,	7,	31,	35},
{35,	15,	27,	30,	8},
{36,	15,	18,	30,	21},
{37,	13,	11,	30,	30},
{35,	17,	19,	23,	22},
{42,	17,	19,	29,	7},
{40,	16,	19,	29,	20},
{40,	16,	15,	23,	39},
{39,	17,	13,	9,	31},
{39,	17,	15,	14,	27},
{37,	17,	19,	4,	26},
{37,	17,	15,	7,	34},
{37,	17,	19,	2,	33},
{37,	17,	15,	13,	31},
{37,	17,	16,	11,	31},
{38,	16,	19,	11,	31},
{37,	17,	15,	22,	26},
{37,	17,	16,	24,	24},
{37,	17,	17,	29,	11},
{37,	16,	18,	30,	22},
{36,	17,	18,	30,	12},
{36,	16,	13,	30,	28},
{36,	16,	16,	27,	30},
{36,	16,	19,	27,	25},
{36,	16,	19,	20,	31},
{37,	16,	17,	23,	39},
{36,	17,	18,	18,	26},
{37,	17,	18,	15,	30},
{36,	17,	18,	7,	38},
{35,	17,	20,	19,	23},
{37,	17,	20,	28,	12},
{36,	17,	20,	16,	26},
{37,	17,	20,	7,	38},
{36,	17,	20,	13,	31},
{36,	16,	20,	19,	38},
{36,	17,	28,	21,	38},
{40,	16,	26,	30,	10},
{38,	17,	23,	29,	12},
{38,	17,	8,	28,	31},
{38,	16,	25,	27,	21},
{37,	17,	6,	29,	34},
{36,	17,	28,	29,	5},
{36,	16,	20,	28,	29},
{36,	17,	18,	27,	29},
{36,	16,	23,	27,	30},
{36,	17,	26,	22,	31},
{36,	16,	29,	19,	38},
{35,	17,	14,	30,	18},
{36,	17,	16,	28,	30},
{37,	17,	19,	23,	38},
{37,	17,	14,	26,	34},
{36,	17,	28,	22,	37},
{36,	16,	29,	29,	14},
{37,	16,	28,	28,	27},
{36,	16,	32,	22,	37},
{37,	17,	32,	9,	34},
{37,	17,	32,	23,	8},
{36,	17,	32,	14,	35},
{36,	16,	33,	22,	38},
{38,	16,	33,	29,	14},
{37,	17,	33,	20,	22},
{37,	11,	33,	29,	38},
{35,	2,	29,	30,	20},
{35,	20,	14,	21,	28},
{44,	18,	9,	28,	16},
{42,	18,	12,	8,	32},
{41,	20,	11,	29,	2},
{41,	18,	15,	14,	21},
{41,	19,	9,	23,	26},
{40,	19,	10,	4,	33},
{40,	18,	14,	24,	21},
{40,	19,	14,	25,	8},
{38,	18,	9,	12,	32},
{38,	19,	6,	11,	34},
{38,	18,	14,	9,	33},
{38,	18,	11,	27,	18},
{40,	18,	15,	25,	21},
{38,	18,	15,	22,	28},
{38,	18,	15,	25,	26},
{37,	20,	7,	25,	12},
{37,	20,	14,	30,	2},
{37,	18,	15,	28,	12},
{37,	18,	9,	22,	31},
{39,	18,	7,	23,	37},
{36,	19,	6,	30,	10},
{36,	20,	8,	25,	13},
{37,	20,	14,	25,	8},
{36,	19,	10,	11,	33},
{38,	20,	7,	18,	30},
{37,	19,	12,	9,	33},
{36,	19,	12,	9,	35},
{37,	19,	10,	14,	34},
{38,	19,	8,	22,	35},
{36,	19,	14,	7,	35},
{36,	20,	14,	22,	19},
{36,	20,	7,	20,	35},
{36,	20,	8,	5,	38},
{36,	18,	15,	26,	23},
{36,	18,	21,	20,	27},
{38,	18,	21,	23,	17},
{38,	18,	21,	22,	28},
{38,	18,	21,	5,	34},
{36,	18,	21,	7,	37},
{35,	18,	16,	30,	7},
{36,	18,	13,	30,	15},
{35,	20,	8,	25,	20},
{38,	19,	7,	25,	30},
{36,	18,	9,	25,	33},
{36,	19,	9,	24,	33},
{35,	20,	7,	26,	14},
{35,	19,	7,	29,	14},
{35,	20,	14,	27,	4},
{36,	20,	14,	26,	18},
{39,	20,	10,	26,	23},
{38,	20,	10,	27,	17},
{37,	19,	14,	29,	12},
{37,	20,	10,	28,	18},
{37,	20,	7,	25,	34},
{36,	19,	13,	29,	18},
{35,	20,	8,	22,	30},
{36,	20,	9,	8,	34},
{36,	20,	9,	20,	32},
{35,	20,	14,	10,	29},
{36,	20,	12,	6,	34},
{35,	20,	10,	11,	35},
{35,	20,	12,	26,	23},
{36,	19,	13,	25,	28},
{35,	19,	19,	17,	27},
{39,	19,	20,	3,	33},
{39,	19,	20,	7,	35},
{37,	19,	20,	11,	28},
{36,	19,	20,	28,	1},
{35,	19,	20,	24,	4},
{35,	19,	20,	14,	28},
{35,	18,	9,	28,	27},
{37,	20,	7,	28,	26},
{36,	19,	12,	27,	26},
{35,	19,	6,	30,	26},
{35,	19,	6,	29,	30},
{36,	18,	9,	27,	33},
{37,	20,	7,	27,	34},
{36,	18,	16,	26,	28},
{35,	18,	21,	29,	9},
{35,	19,	19,	28,	9},
{35,	18,	21,	26,	15},
{35,	19,	19,	29,	12},
{38,	19,	18,	21,	28},
{37,	19,	20,	20,	28},
{35,	19,	21,	23,	16},
{36,	19,	21,	12,	27},
{35,	19,	16,	26,	22},
{35,	18,	17,	27,	25},
{35,	19,	15,	30,	14},
{35,	12,	17,	30,	29},
{35,	19,	9,	27,	34},
{35,	20,	7,	23,	39},
{35,	20,	12,	9,	37},
{35,	20,	14,	7,	35},
{35,	20,	9,	20,	37},
{35,	20,	14,	14,	34},
{37,	19,	13,	25,	32},
{38,	20,	14,	20,	34},
{36,	19,	21,	8,	32},
{38,	19,	19,	11,	32},
{38,	19,	21,	20,	29},
{36,	20,	14,	18,	37},
{36,	20,	14,	22,	34},
{36,	20,	11,	26,	33},
{37,	20,	9,	27,	37},
{36,	18,	14,	26,	37},
{35,	19,	19,	14,	32},
{35,	19,	21,	15,	32},
{35,	24,	12,	22,	32},
{43,	22,	10,	28,	8},
{43,	21,	11,	24,	34},
{43,	22,	9,	28,	22},
{41,	22,	10,	25,	31},
{40,	23,	11,	28,	6},
{40,	23,	11,	25,	20},
{40,	23,	10,	23,	34},
{40,	21,	9,	27,	37},
{38,	23,	11,	26,	19},
{38,	23,	11,	25,	30},
{37,	22,	12,	29,	5},
{39,	22,	12,	24,	33},
{38,	24,	12,	9,	34},
{38,	23,	12,	16,	37},
{36,	24,	12,	18,	35},
{35,	23,	10,	28,	16},
{35,	22,	12,	26,	20},
{36,	23,	12,	25,	28},
{35,	24,	12,	26,	12},
{36,	24,	12,	23,	33},
{37,	24,	12,	26,	20},
{35,	24,	12,	28,	6},
{35,	21,	13,	20,	31},
{36,	21,	14,	16,	14},
{37,	21,	14,	4,	33},
{35,	21,	14,	17,	19},
{35,	21,	13,	26,	15},
{36,	21,	14,	30,	4},
{35,	21,	17,	22,	28},
{38,	21,	16,	6,	34},
{38,	21,	15,	26,	16},
{38,	21,	16,	13,	31},
{36,	21,	15,	28,	10},
{36,	20,	17,	27,	11},
{37,	21,	17,	28,	11},
{36,	20,	17,	30,	10},
{35,	20,	18,	15,	21},
{36,	20,	18,	9,	30},
{37,	20,	17,	10,	37},
{35,	22,	12,	29,	11},
{35,	20,	13,	30,	15},
{35,	21,	17,	24,	20},
{35,	21,	17,	14,	31},
{35,	23,	15,	20,	30},
{40,	23,	14,	23,	26},
{39,	23,	15,	6,	37},
{38,	18,	21,	20,	36},
{36,	24,	13,	12,	20},
{37,	24,	13,	11,	27},
{36,	24,	13,	18,	11},
{36,	24,	13,	11,	31},
{36,	22,	13,	18,	37},
{37,	21,	16,	22,	32},
{36,	22,	13,	21,	37},
{37,	20,	16,	22,	37},
{37,	19,	20,	20,	37},
{36,	21,	16,	21,	37},
{36,	21,	16,	21,	39},
{35,	13,	26,	30,	21},
{35,	17,	23,	30,	15},
{35,	19,	21,	27,	13},
{35,	17,	32,	29,	12},
{35,	20,	24,	22,	25},
{42,	20,	24,	27,	10},
{40,	19,	24,	8,	33},
{38,	18,	26,	29,	10},
{39,	18,	25,	10,	38},
{38,	20,	24,	26,	15},
{37,	18,	27,	28,	10},
{37,	20,	24,	23,	25},
{37,	19,	21,	23,	33},
{39,	18,	23,	23,	38},
{37,	19,	24,	21,	29},
{37,	18,	17,	26,	33},
{36,	18,	28,	25,	10},
{38,	18,	28,	5,	35},
{38,	18,	28,	29,	13},
{39,	18,	28,	12,	33},
{37,	18,	29,	15,	20},
{36,	20,	24,	29,	9},
{36,	20,	24,	10,	29},
{38,	20,	22,	9,	33},
{36,	20,	22,	10,	38},
{38,	19,	24,	20,	37},
{36,	20,	24,	18,	34},
{37,	20,	22,	23,	32},
{36,	18,	29,	13,	37},
{35,	18,	21,	27,	19},
{36,	18,	18,	27,	31},
{36,	20,	11,	27,	38},
{35,	20,	12,	28,	26},
{35,	20,	14,	25,	32},
{35,	22,	9,	27,	34},
{35,	23,	10,	26,	31},
{35,	24,	12,	28,	22},
{36,	23,	12,	28,	25},
{35,	23,	15,	28,	25},
{36,	20,	15,	30,	18},
{36,	23,	15,	25,	28},
{35,	24,	13,	27,	9},
{35,	21,	16,	30,	12},
{35,	22,	14,	30,	12},
{35,	20,	22,	28,	15},
{36,	21,	16,	28,	23},
{36,	20,	21,	27,	19},
{37,	20,	18,	25,	31},
{36,	20,	24,	27,	19},
{37,	18,	23,	26,	31},
{38,	20,	20,	28,	23},
{38,	17,	27,	28,	27},
{36,	20,	24,	28,	21},
{35,	20,	8,	30,	28},
{36,	19,	14,	30,	23},
{38,	19,	20,	29,	25},
{36,	17,	22,	29,	30},
{35,	18,	25,	30,	15},
{35,	20,	18,	30,	20},
{35,	20,	8,	29,	33},
{35,	18,	28,	23,	23},
{35,	20,	25,	27,	18},
{41,	20,	25,	18,	32},
{36,	19,	26,	29,	17},
{37,	19,	26,	13,	35},
{35,	18,	29,	28,	15},
{35,	24,	11,	26,	31},
{35,	26,	16,	19,	32},
{38,	26,	16,	30,	0},
{38,	24,	14,	23,	28},
{38,	25,	15,	21,	22},
{38,	25,	13,	26,	19},
{39,	25,	13,	28,	21},
{38,	23,	16,	16,	36},
{38,	23,	15,	24,	33},
{37,	22,	17,	17,	19},
{39,	22,	17,	18,	28},
{36,	26,	16,	23,	3},
{36,	26,	14,	30,	2},
{36,	25,	13,	29,	12},
{36,	23,	16,	26,	19},
{38,	22,	17,	24,	27},
{36,	24,	15,	10,	37},
{36,	24,	16,	21,	31},
{35,	27,	15,	20,	11},
{35,	25,	14,	28,	10},
{36,	25,	14,	30,	10},
{36,	25,	16,	22,	20},
{35,	22,	17,	8,	36},
{35,	24,	13,	30,	18},
{37,	23,	16,	29,	18},
{36,	21,	13,	30,	24},
{35,	25,	16,	27,	5},
{35,	25,	14,	28,	19},
{35,	26,	14,	30,	12},
{36,	26,	14,	27,	19},
{35,	26,	16,	22,	18},
{35,	19,	27,	24,	23},
{37,	19,	28,	13,	36},
{36,	19,	28,	29,	12},
{37,	19,	28,	28,	21},
{36,	17,	28,	27,	31},
{35,	12,	26,	30,	27},
{35,	20,	18,	26,	32},
{36,	20,	13,	30,	28},
{36,	22,	15,	26,	31},
{36,	23,	15,	25,	33},
{36,	22,	16,	26,	32},
{35,	22,	13,	30,	25},
{35,	23,	13,	27,	31},
{35,	18,	20,	30,	28},
{35,	21,	17,	25,	33},
{35,	19,	20,	30,	28},
{35,	19,	26,	30,	18},
{36,	14,	25,	30,	29},
{35,	0,	31,	30,	28},
{35,	3,	25,	30,	34},
{36,	1,	31,	30,	34},
{36,	15,	26,	30,	30},
{35,	10,	29,	30,	26},
{36,	10,	31,	31,	6},
{36,	3,	29,	30,	35},
{36,	3,	11,	31,	39},
{35,	8,	30,	31,	9},
{35,	10,	18,	31,	15},
{37,	5,	21,	31,	23},
{39,	1,	31,	31,	31},
{38,	0,	27,	32,	29},
{36,	5,	12,	32,	24},
{36,	5,	29,	31,	24},
{35,	2,	13,	32,	32},
{36,	1,	10,	32,	36},
{35,	4,	0,	33,	34},
{35,	0,	6,	33,	36},
{35,	22,	15,	25,	37},
{36,	23,	16,	23,	35},
{35,	24,	13,	19,	37},
{35,	20,	25,	17,	37},
{35,	20,	22,	23,	35},
{35,	19,	18,	25,	39},
{37,	17,	28,	25,	38},
{37,	19,	20,	26,	39},
{36,	18,	25,	26,	33},
{36,	20,	25,	20,	37},
{35,	18,	29,	23,	25},
{35,	22,	17,	25,	36},
{35,	20,	28,	23,	33},
{38,	20,	28,	22,	36},
{37,	19,	26,	26,	32},
{36,	20,	28,	30,	7},
{35,	16,	31,	30,	11},
{35,	12,	33,	31,	6},
{36,	1,	33,	30,	35},
{35,	8,	33,	30,	21},
{36,	10,	32,	30,	29},
{36,	3,	32,	31,	31},
{35,	17,	32,	30,	14},
{36,	17,	33,	22,	37},
{36,	17,	33,	23,	38},
{35,	20,	27,	26,	24},
{35,	19,	25,	28,	28},
{35,	19,	26,	30,	23},
{36,	20,	26,	29,	23},
{35,	4,	33,	30,	35},
{35,	19,	28,	27,	30},
{36,	19,	28,	29,	28},
{36,	19,	28,	26,	36},
{35,	20,	27,	26,	32},
{35,	16,	32,	27,	33},
{36,	18,	29,	30,	22},
{36,	18,	29,	25,	38},
{35,	16,	34,	25,	34},
{39,	11,	34,	28,	38},
{35,	8,	34,	30,	25},
{36,	8,	34,	29,	39},
{35,	4,	34,	31,	27},
{35,	17,	34,	23,	38},
{35,	11,	34,	29,	39},
{35,	24,	29,	25,	36},
{40,	24,	21,	28,	5},
{40,	23,	27,	28,	6},
{40,	22,	23,	28,	14},
{39,	24,	22,	19,	38},
{38,	24,	29,	28,	6},
{38,	24,	29,	14,	39},
{37,	25,	16,	26,	18},
{36,	24,	22,	30,	3},
{36,	27,	15,	24,	16},
{36,	27,	15,	23,	22},
{36,	22,	20,	28,	23},
{40,	22,	22,	26,	34},
{38,	24,	18,	27,	20},
{36,	20,	29,	29,	23},
{36,	21,	29,	25,	37},
{36,	19,	29,	25,	39},
{35,	22,	23,	29,	14},
{37,	23,	18,	30,	18},
{37,	23,	29,	30,	6},
{35,	27,	15,	23,	24},
{35,	25,	16,	13,	37},
{36,	26,	15,	8,	36},
{35,	26,	16,	20,	30},
{35,	26,	15,	23,	27},
{35,	23,	23,	29,	18},
{37,	21,	23,	30,	23},
{36,	24,	28,	29,	7},
{38,	21,	28,	29,	23},
{37,	23,	25,	30,	14},
{36,	22,	24,	30,	22},
{36,	21,	28,	29,	25},
{36,	22,	19,	27,	30},
{35,	26,	15,	23,	30},
{35,	22,	16,	27,	33},
{35,	23,	23,	26,	27},
{35,	21,	30,	28,	23},
{41,	21,	30,	24,	34},
{36,	19,	32,	21,	33},
{38,	19,	34,	30,	7},
{37,	18,	33,	21,	39},
{36,	20,	32,	19,	36},
{37,	20,	31,	23,	37},
{36,	20,	33,	25,	14},
{36,	19,	34,	23,	27},
{36,	21,	31,	19,	38},
{35,	21,	33,	19,	25},
{35,	24,	15,	25,	38},
{35,	18,	34,	25,	35},
{36,	21,	31,	25,	35},
{36,	21,	32,	29,	13},
{36,	21,	32,	27,	26},
{36,	21,	32,	23,	37},
{35,	21,	31,	30,	15},
{35,	23,	32,	25,	31},
{37,	24,	30,	15,	34},
{37,	22,	33,	24,	27},
{37,	23,	32,	19,	36},
{36,	23,	32,	30,	8},
{35,	24,	30,	25,	17},
{35,	23,	32,	25,	35},
{35,	18,	34,	25,	39},
{34,	10,	2,	32,	15},
{34,	15,	15,	31,	8},
{35,	14,	18,	31,	16},
{35,	17,	9,	31,	12},
{35,	19,	8,	31,	10},
{35,	14,	7,	31,	18},
{36,	19,	6,	31,	18},
{35,	17,	14,	31,	12},
{35,	19,	16,	31,	6},
{34,	21,	8,	31,	12},
{37,	22,	19,	31,	4},
{35,	24,	12,	31,	7},
{36,	18,	14,	31,	16},
{37,	20,	8,	31,	19},
{35,	21,	14,	31,	13},
{35,	24,	12,	31,	14},
{35,	13,	26,	31,	19},
{35,	10,	28,	31,	20},
{35,	9,	6,	31,	29},
{37,	9,	25,	31,	24},
{37,	7,	7,	31,	33},
{37,	8,	27,	31,	28},
{36,	6,	31,	30,	34},
{35,	9,	10,	31,	31},
{37,	17,	10,	30,	32},
{35,	21,	29,	31,	11},
{38,	18,	21,	31,	19},
{35,	15,	20,	31,	22},
{37,	13,	22,	31,	24},
{36,	11,	6,	31,	31},
{36,	19,	22,	31,	20},
{35,	22,	12,	31,	20},
{35,	23,	28,	31,	6},
{35,	6,	25,	31,	32},
{34,	8,	2,	32,	32},
{37,	7,	9,	32,	27},
{35,	6,	11,	32,	31},
{35,	3,	15,	32,	32},
{34,	10,	9,	32,	13},
{36,	9,	5,	32,	24},
{35,	10,	4,	32,	31},
{34,	5,	17,	32,	14},
{35,	2,	27,	32,	17},
{36,	5,	18,	32,	27},
{34,	8,	27,	32,	2},
{36,	10,	13,	32,	12},
{35,	8,	11,	32,	27},
{35,	9,	6,	32,	32},
{36,	8,	16,	32,	30},
{36,	10,	20,	32,	11},
{35,	15,	21,	32,	4},
{37,	18,	25,	32,	2},
{37,	18,	27,	32,	4},
{35,	15,	10,	32,	6},
{36,	11,	17,	32,	13},
{35,	14,	7,	32,	17},
{36,	18,	7,	32,	16},
{36,	16,	10,	32,	14},
{36,	20,	7,	32,	17},
{37,	21,	21,	32,	4},
{36,	12,	24,	32,	11},
{36,	10,	16,	32,	22},
{36,	21,	10,	32,	17},
{35,	21,	11,	32,	17},
{35,	23,	10,	32,	16},
{35,	19,	14,	32,	17},
{35,	18,	17,	32,	14},
{35,	16,	16,	32,	18},
{35,	14,	25,	32,	18},
{36,	6,	25,	32,	28},
{35,	12,	17,	32,	21},
{35,	14,	18,	32,	21},
{35,	3,	32,	32,	22},
{35,	14,	34,	32,	4},
{35,	1,	25,	32,	34},
{36,	4,	33,	31,	34},
{36,	0,	32,	32,	35},
{34,	11,	5,	32,	30},
{36,	10,	13,	32,	29},
{35,	11,	18,	32,	26},
{36,	14,	24,	32,	22},
{35,	9,	29,	32,	26},
{36,	10,	31,	32,	23},
{34,	22,	17,	32,	7},
{34,	0,	7,	33,	39},
{34,	19,	31,	32,	5},
{34,	22,	32,	32,	3},
{34,	26,	16,	15,	33},
{34,	23,	25,	31,	11},
{34,	24,	23,	31,	7},
{34,	0,	20,	32,	39},
{35,	0,	32,	32,	39},
{34,	25,	13,	25,	30},
{34,	25,	20,	20,	30},
{40,	25,	20,	26,	12},
{40,	25,	20,	11,	38},
{36,	25,	20,	31,	4},
{36,	25,	21,	10,	25},
{36,	25,	21,	27,	5},
{36,	25,	21,	10,	33},
{35,	25,	17,	27,	19},
{35,	25,	20,	25,	19},
{35,	25,	20,	16,	36},
{35,	25,	19,	19,	35},
{35,	25,	20,	19,	38},
{34,	25,	21,	24,	19},
{35,	25,	21,	19,	38},
{34,	25,	19,	26,	22},
{34,	26,	14,	28,	22},
{34,	26,	14,	27,	25},
{36,	25,	13,	27,	30},
{35,	24,	13,	27,	33},
{35,	24,	16,	26,	34},
{34,	24,	14,	29,	24},
{34,	25,	24,	17,	27},
{39,	25,	24,	27,	8},
{38,	25,	24,	7,	38},
{37,	25,	23,	17,	34},
{36,	25,	22,	24,	22},
{35,	25,	24,	26,	12},
{36,	24,	23,	26,	28},
{35,	25,	25,	16,	30},
{38,	25,	26,	18,	9},
{37,	25,	26,	5,	35},
{35,	25,	25,	28,	7},
{35,	25,	26,	14,	21},
{35,	25,	25,	23,	16},
{35,	25,	24,	20,	28},
{35,	25,	26,	14,	35},
{36,	25,	24,	19,	39},
{35,	23,	31,	19,	39},
{34,	24,	25,	30,	14},
{38,	24,	22,	28,	23},
{36,	25,	17,	28,	24},
{35,	24,	30,	29,	10},
{37,	24,	30,	28,	15},
{36,	24,	28,	28,	23},
{36,	24,	28,	26,	29},
{35,	25,	23,	24,	25},
{36,	25,	24,	23,	30},
{35,	23,	28,	30,	18},
{35,	24,	21,	26,	35},
{35,	22,	32,	27,	27},
{35,	23,	29,	26,	32},
{35,	18,	30,	27,	38},
{34,	26,	15,	19,	35},
{34,	25,	20,	27,	23},
{35,	25,	23,	27,	21},
{34,	25,	23,	29,	15},
{34,	25,	26,	29,	8},
{34,	27,	17,	26,	27},
{38,	27,	17,	29,	5},
{38,	27,	16,	16,	29},
{37,	27,	17,	4,	35},
{37,	27,	17,	27,	24},
{36,	26,	17,	29,	16},
{35,	27,	17,	27,	27},
{35,	26,	16,	27,	33},
{38,	25,	18,	26,	35},
{37,	25,	23,	24,	35},
{35,	26,	17,	27,	30},
{35,	27,	17,	10,	30},
{36,	27,	16,	25,	30},
{35,	27,	16,	25,	31},
{35,	26,	15,	27,	35},
{34,	26,	19,	19,	25},
{39,	26,	19,	24,	23},
{39,	26,	19,	28,	22},
{37,	26,	19,	6,	33},
{38,	26,	19,	22,	29},
{34,	26,	20,	22,	18},
{37,	26,	20,	25,	25},
{34,	26,	20,	4,	36},
{34,	26,	20,	14,	32},
{34,	26,	20,	28,	20},
{34,	26,	22,	21,	28},
{39,	26,	22,	19,	32},
{38,	26,	22,	28,	13},
{36,	26,	22,	28,	21},
{35,	26,	22,	20,	35},
{34,	26,	21,	20,	36},
{36,	26,	22,	19,	39},
{34,	26,	19,	24,	34},
{34,	24,	32,	27,	23},
{38,	24,	32,	17,	37},
{36,	24,	32,	20,	37},
{36,	24,	32,	24,	36},
{34,	26,	29,	26,	26},
{40,	26,	29,	28,	16},
{40,	25,	29,	26,	29},
{38,	26,	25,	13,	34},
{38,	26,	29,	6,	39},
{39,	25,	29,	22,	34},
{37,	26,	25,	21,	33},
{36,	26,	27,	28,	22},
{36,	26,	25,	26,	29},
{35,	26,	29,	29,	8},
{35,	25,	31,	16,	34},
{37,	25,	30,	24,	29},
{35,	26,	29,	17,	36},
{36,	26,	26,	20,	37},
{35,	25,	25,	26,	32},
{35,	26,	29,	21,	34},
{35,	26,	29,	19,	38},
{35,	26,	28,	22,	35},
{35,	26,	25,	24,	35},
{35,	26,	29,	24,	34},
{35,	26,	28,	25,	33},
{35,	26,	29,	23,	36},
{34,	26,	30,	12,	19},
{36,	26,	30,	9,	38},
{35,	26,	30,	23,	12},
{34,	25,	31,	29,	15},
{35,	25,	31,	25,	31},
{34,	26,	19,	27,	30},
{37,	26,	29,	27,	26},
{35,	26,	24,	27,	29},
{34,	20,	29,	29,	28},
{34,	26,	17,	27,	36},
{34,	26,	30,	15,	35},
{34,	25,	21,	26,	37},
{35,	22,	30,	24,	39},
{38,	26,	29,	22,	38},
{36,	24,	31,	25,	38},
{35,	22,	33,	24,	37},
{34,	32,	26,	27,	29},
{43,	31,	24,	2,	32},
{41,	30,	26,	29,	3},
{39,	29,	19,	14,	30},
{39,	32,	26,	0,	36},
{36,	32,	26,	30,	0},
{36,	31,	23,	6,	30},
{36,	29,	22,	4,	32},
{36,	29,	23,	7,	31},
{36,	29,	19,	8,	32},
{36,	32,	26,	2,	32},
{36,	25,	31,	31,	5},
{36,	32,	26,	1,	34},
{37,	29,	19,	7,	34},
{37,	29,	23,	7,	33},
{36,	32,	26,	6,	33},
{37,	29,	26,	10,	30},
{38,	28,	25,	8,	34},
{37,	27,	26,	14,	33},
{37,	28,	24,	10,	33},
{38,	31,	23,	10,	31},
{38,	28,	18,	25,	31},
{37,	32,	26,	9,	31},
{37,	32,	25,	15,	31},
{36,	24,	31,	31,	11},
{36,	28,	25,	14,	33},
{35,	32,	26,	28,	4},
{36,	30,	26,	29,	5},
{35,	28,	21,	6,	39},
{36,	30,	21,	8,	35},
{37,	32,	26,	9,	32},
{36,	32,	25,	11,	32},
{35,	31,	23,	10,	33},
{35,	27,	21,	26,	31},
{35,	28,	25,	24,	30},
{36,	30,	25,	18,	31},
{37,	30,	21,	27,	30},
{36,	31,	24,	24,	30},
{35,	29,	19,	18,	33},
{35,	28,	18,	18,	37},
{35,	28,	18,	19,	38},
{36,	27,	26,	19,	34},
{35,	28,	25,	18,	34},
{36,	28,	25,	18,	35},
{36,	32,	26,	2,	38},
{35,	32,	26,	6,	35},
{35,	28,	25,	20,	35},
{36,	28,	25,	26,	31},
{34,	27,	18,	29,	11},
{35,	31,	26,	28,	21},
{40,	30,	25,	29,	12},
{35,	30,	21,	29,	15},
{34,	31,	26,	29,	12},
{34,	32,	26,	9,	33},
{34,	27,	29,	22,	26},
{40,	27,	28,	27,	27},
{38,	27,	29,	9,	34},
{36,	27,	28,	23,	31},
{34,	27,	30,	23,	12},
{37,	27,	30,	20,	20},
{34,	31,	25,	17,	32},
{35,	29,	20,	18,	35},
{35,	29,	25,	17,	35},
{34,	29,	20,	17,	38},
{35,	28,	21,	20,	38},
{35,	29,	25,	19,	38},
{37,	31,	26,	6,	37},
{35,	27,	30,	5,	37},
{35,	30,	23,	18,	36},
{35,	29,	24,	20,	38},
{35,	29,	25,	26,	31},
{35,	27,	27,	20,	38},
{34,	32,	25,	6,	39},
{34,	32,	25,	14,	33},
{34,	29,	29,	23,	26},
{41,	29,	28,	9,	35},
{40,	29,	29,	26,	15},
{39,	29,	29,	16,	29},
{37,	30,	27,	10,	28},
{39,	30,	27,	28,	7},
{36,	30,	27,	14,	27},
{37,	30,	27,	28,	13},
{37,	30,	27,	19,	28},
{36,	29,	29,	25,	24},
{36,	28,	29,	27,	25},
{35,	30,	27,	6,	38},
{35,	29,	29,	16,	30},
{35,	28,	28,	17,	34},
{36,	29,	27,	17,	39},
{36,	30,	27,	17,	33},
{37,	32,	26,	17,	32},
{36,	29,	27,	20,	35},
{35,	29,	29,	18,	33},
{35,	29,	29,	7,	39},
{35,	27,	30,	15,	33},
{34,	28,	30,	26,	8},
{34,	28,	30,	20,	20},
{36,	28,	30,	8,	37},
{34,	28,	31,	17,	22},
{39,	28,	31,	7,	39},
{39,	27,	31,	19,	30},
{35,	28,	31,	29,	2},
{35,	28,	29,	28,	19},
{35,	28,	30,	18,	32},
{34,	28,	31,	22,	12},
{34,	32,	26,	28,	21},
{34,	32,	26,	29,	10},
{34,	29,	30,	18,	31},
{36,	29,	30,	26,	12},
{34,	28,	31,	26,	22},
{37,	28,	31,	28,	18},
{37,	29,	30,	25,	25},
{37,	28,	30,	23,	31},
{35,	29,	30,	29,	6},
{35,	28,	31,	29,	13},
{35,	29,	28,	25,	30},
{35,	29,	28,	22,	32},
{35,	29,	20,	21,	37},
{36,	27,	29,	21,	37},
{37,	29,	30,	16,	38},
{38,	29,	29,	19,	39},
{35,	27,	17,	27,	33},
{35,	27,	17,	25,	38},
{35,	30,	22,	23,	32},
{35,	30,	24,	19,	36},
{35,	27,	31,	23,	32},
{34,	30,	27,	22,	29},
{34,	30,	21,	21,	38},
{36,	29,	28,	21,	37},
{34,	30,	22,	23,	33},
{36,	28,	25,	25,	33},
{35,	30,	22,	25,	33},
{35,	29,	25,	26,	32},
{35,	29,	26,	22,	38},
{36,	29,	29,	22,	37},
{35,	30,	21,	25,	36},
{37,	29,	24,	24,	38},
{35,	29,	28,	25,	33},
{35,	28,	30,	23,	36},
{36,	26,	31,	23,	38},
{35,	28,	31,	22,	36},
{34,	32,	30,	24,	25},
{41,	32,	30,	29,	5},
{41,	30,	30,	22,	29},
{40,	32,	28,	26,	23},
{39,	32,	28,	26,	26},
{37,	31,	30,	9,	28},
{36,	32,	29,	26,	19},
{35,	32,	30,	0,	33},
{35,	32,	27,	29,	12},
{35,	31,	29,	29,	10},
{36,	29,	30,	28,	20},
{38,	31,	28,	27,	27},
{38,	32,	29,	28,	17},
{35,	32,	30,	29,	9},
{35,	31,	27,	11,	33},
{35,	32,	28,	8,	29},
{36,	32,	27,	6,	36},
{35,	32,	30,	7,	33},
{39,	30,	30,	15,	35},
{36,	32,	28,	11,	32},
{35,	32,	30,	29,	12},
{36,	31,	30,	27,	23},
{35,	32,	30,	21,	26},
{35,	32,	29,	22,	27},
{35,	32,	28,	14,	32},
{37,	32,	27,	27,	29},
{36,	32,	29,	16,	30},
{36,	32,	30,	16,	30},
{37,	32,	30,	22,	29},
{36,	32,	27,	23,	30},
{35,	30,	30,	19,	35},
{35,	31,	29,	26,	28},
{35,	30,	30,	19,	36},
{35,	27,	31,	25,	34},
{34,	32,	28,	15,	33},
{34,	29,	24,	27,	32},
{37,	22,	30,	27,	36},
{36,	30,	30,	27,	28},
{35,	26,	29,	27,	32},
{35,	28,	31,	27,	29},
{35,	28,	31,	24,	36},
{34,	32,	31,	23,	27},
{40,	31,	31,	27,	24},
{40,	30,	31,	15,	38},
{37,	32,	31,	16,	30},
{36,	32,	31,	29,	7},
{35,	31,	31,	6,	35},
{36,	31,	31,	6,	39},
{35,	32,	31,	6,	39},
{35,	31,	31,	19,	36},
{37,	31,	27,	25,	31},
{37,	30,	24,	24,	36},
{36,	32,	29,	15,	35},
{37,	32,	31,	19,	32},
{36,	32,	30,	22,	31},
{36,	30,	29,	22,	36},
{37,	32,	28,	23,	32},
{38,	31,	25,	25,	34},
{38,	31,	31,	21,	35},
{36,	31,	23,	23,	38},
{37,	31,	28,	21,	37},
{36,	31,	29,	20,	38},
{35,	32,	29,	21,	34},
{37,	32,	25,	22,	38},
{35,	32,	31,	17,	35},
{35,	31,	31,	27,	28},
{35,	31,	30,	24,	32},
{36,	32,	30,	23,	33},
{34,	20,	28,	29,	38},
{38,	19,	30,	29,	39},
{35,	23,	11,	29,	33},
{37,	22,	14,	29,	36},
{37,	21,	27,	29,	34},
{34,	22,	14,	30,	29},
{34,	24,	11,	29,	39},
{34,	32,	27,	29,	28},
{40,	26,	18,	28,	38},
{40,	30,	21,	29,	31},
{37,	25,	28,	29,	31},
{36,	31,	31,	29,	15},
{35,	25,	15,	29,	38},
{35,	32,	29,	29,	18},
{35,	28,	30,	28,	27},
{35,	25,	30,	29,	30},
{35,	29,	31,	29,	20},
{35,	22,	30,	29,	34},
{34,	22,	20,	30,	29},
{34,	18,	32,	30,	22},
{35,	23,	30,	30,	21},
{34,	23,	19,	30,	29},
{34,	23,	20,	30,	30},
{34,	28,	18,	29,	33},
{34,	19,	33,	28,	29},
{37,	28,	31,	29,	28},
{35,	18,	32,	29,	39},
{35,	22,	31,	29,	35},
{35,	29,	21,	28,	36},
{35,	24,	28,	29,	35},
{36,	30,	22,	29,	32},
{36,	28,	24,	29,	33},
{37,	26,	28,	28,	36},
{34,	31,	24,	29,	30},
{36,	31,	30,	27,	30},
{36,	27,	31,	27,	35},
{34,	31,	24,	28,	33},
{34,	32,	31,	24,	29},
{34,	30,	21,	28,	37},
{34,	31,	27,	26,	33},
{34,	32,	29,	22,	35},
{34,	32,	28,	19,	38},
{35,	32,	31,	19,	36},
{34,	22,	33,	24,	39},
{34,	28,	31,	29,	30},
{35,	26,	28,	29,	35},
{35,	26,	31,	29,	35},
{34,	29,	28,	27,	34},
{34,	31,	31,	18,	38},
{36,	29,	30,	24,	37},
{34,	32,	28,	22,	37},
{34,	32,	26,	23,	37},
{34,	32,	28,	22,	38},
{34,	29,	30,	22,	39},
{35,	30,	25,	24,	39},
{34,	32,	31,	29,	29},
{34,	27,	31,	24,	39},
{35,	31,	31,	20,	39},
{34,	33,	33,	27,	32},
{43,	29,	33,	20,	38},
{41,	31,	33,	28,	30},
{40,	32,	33,	7,	39},
{39,	28,	33,	23,	39},
{38,	33,	27,	29,	24},
{37,	31,	33,	29,	14},
{37,	33,	33,	2,	39},
{37,	33,	33,	4,	37},
{38,	33,	29,	12,	35},
{38,	33,	28,	20,	35},
{37,	31,	32,	22,	35},
{37,	32,	32,	18,	38},
{37,	29,	33,	28,	33},
{36,	33,	33,	5,	38},
{36,	33,	28,	18,	38},
{36,	19,	34,	28,	37},
{36,	28,	32,	29,	33},
{36,	26,	33,	29,	34},
{35,	33,	31,	29,	4},
{35,	32,	33,	29,	23},
{36,	32,	32,	28,	32},
{35,	33,	29,	18,	38},
{35,	23,	34,	29,	33},
{35,	23,	34,	25,	38},
{35,	33,	33,	28,	28},
{35,	33,	32,	29,	23},
{35,	31,	32,	21,	38},
{35,	29,	31,	27,	36},
{34,	33,	29,	20,	36},
{34,	31,	33,	18,	37},
{34,	33,	28,	20,	39},
{34,	19,	34,	29,	39},
{34,	28,	34,	23,	37},
{37,	29,	34,	28,	13},
{35,	28,	34,	27,	34},
{33,	4,	7,	33,	6},
{34,	8,	7,	33,	6},
{35,	11,	5,	33,	5},
{35,	6,	4,	33,	13},
{35,	8,	10,	33,	5},
{35,	1,	10,	33,	28},
{35,	0,	20,	33,	15},
{34,	4,	14,	33,	12},
{35,	8,	7,	33,	13},
{34,	4,	7,	33,	29},
{36,	9,	3,	33,	19},
{35,	8,	10,	33,	15},
{34,	2,	19,	33,	16},
{34,	4,	20,	33,	15},
{34,	7,	20,	33,	15},
{35,	11,	14,	33,	5},
{34,	9,	14,	33,	15},
{34,	0,	32,	33,	37},
{36,	7,	25,	33,	14},
{34,	2,	19,	33,	25},
{35,	1,	21,	33,	34},
{34,	1,	11,	33,	38},
{33,	15,	3,	33,	14},
{34,	11,	14,	33,	11},
{33,	7,	11,	33,	18},
{33,	4,	2,	33,	34},
{33,	5,	7,	33,	30},
{34,	7,	2,	33,	28},
{34,	7,	21,	33,	21},
{35,	5,	23,	33,	25},
{34,	1,	31,	33,	28},
{34,	7,	29,	33,	14},
{34,	11,	26,	33,	14},
{33,	4,	12,	32,	36},
{35,	4,	23,	32,	35},
{34,	7,	12,	32,	33},
{34,	5,	8,	33,	33},
{33,	10,	9,	32,	32},
{33,	21,	12,	32,	19},
{34,	18,	17,	32,	20},
{34,	18,	17,	32,	28},
{36,	14,	5,	32,	31},
{36,	21,	8,	32,	25},
{37,	22,	11,	31,	28},
{35,	13,	10,	32,	31},
{36,	22,	10,	31,	31},
{36,	19,	10,	31,	32},
{36,	18,	14,	31,	31},
{36,	23,	12,	31,	31},
{35,	23,	14,	31,	26},
{35,	12,	24,	32,	28},
{35,	14,	26,	32,	26},
{34,	18,	7,	32,	31},
{35,	16,	14,	32,	31},
{34,	15,	11,	30,	33},
{34,	24,	13,	31,	25},
{33,	14,	6,	31,	33},
{33,	7,	29,	33,	20},
{33,	7,	27,	33,	23},
{33,	21,	8,	32,	30},
{33,	23,	16,	31,	22},
{33,	25,	15,	30,	22},
{33,	24,	19,	31,	16},
{33,	26,	15,	30,	20},
{35,	30,	31,	30,	1},
{33,	27,	19,	31,	3},
{35,	31,	33,	31,	0},
{34,	29,	22,	31,	3},
{33,	26,	15,	31,	18},
{34,	27,	16,	31,	20},
{35,	27,	18,	31,	13},
{34,	28,	18,	31,	14},
{33,	25,	16,	32,	6},
{33,	30,	22,	30,	6},
{34,	26,	28,	30,	19},
{35,	26,	25,	31,	12},
{34,	29,	22,	31,	11},
{34,	29,	27,	31,	10},
{35,	32,	25,	30,	8},
{36,	31,	30,	30,	8},
{35,	33,	28,	30,	7},
{35,	28,	31,	31,	10},
{33,	17,	22,	32,	22},
{35,	20,	26,	32,	10},
{34,	18,	19,	32,	28},
{36,	19,	26,	32,	17},
{35,	26,	25,	31,	16},
{34,	22,	21,	32,	11},
{34,	20,	31,	32,	11},
{34,	19,	32,	32,	17},
{36,	23,	33,	31,	14},
{36,	16,	34,	31,	21},
{35,	11,	31,	32,	28},
{35,	25,	33,	31,	15},
{34,	6,	34,	32,	24},
{34,	20,	34,	32,	13},
{34,	0,	34,	32,	37},
{33,	26,	14,	32,	13},
{34,	25,	17,	32,	16},
{35,	23,	22,	32,	16},
{33,	11,	30,	33,	12},
{33,	15,	14,	31,	33},
{34,	15,	15,	30,	34},
{33,	11,	5,	30,	35},
{34,	5,	31,	31,	35},
{34,	15,	9,	31,	34},
{35,	6,	25,	32,	34},
{33,	26,	22,	32,	16},
{34,	24,	31,	32,	15},
{35,	25,	34,	32,	8},
{35,	26,	34,	30,	18},
{34,	25,	31,	32,	16},
{33,	29,	24,	32,	6},
{34,	28,	18,	32,	14},
{35,	29,	24,	32,	11},
{34,	28,	19,	32,	16},
{35,	29,	21,	30,	19},
{34,	28,	18,	30,	23},
{34,	27,	17,	31,	22},
{33,	28,	17,	32,	20},
{35,	24,	14,	32,	25},
{36,	27,	17,	32,	23},
{35,	23,	13,	32,	28},
{35,	23,	16,	32,	28},
{33,	22,	19,	32,	23},
{35,	28,	18,	32,	23},
{35,	25,	32,	31,	18},
{33,	22,	21,	32,	23},
{33,	10,	27,	30,	33},
{34,	18,	16,	31,	32},
{34,	9,	23,	32,	32},
{36,	12,	26,	31,	33},
{34,	19,	18,	31,	32},
{34,	23,	19,	31,	29},
{34,	13,	27,	30,	34},
{34,	9,	31,	31,	34},
{34,	20,	27,	30,	31},
{34,	19,	26,	31,	26},
{35,	23,	33,	31,	21},
{34,	19,	34,	31,	25},
{34,	12,	30,	31,	34},
{33,	29,	34,	7,	39},
{34,	29,	34,	21,	34},
{33,	23,	34,	30,	24},
{33,	24,	32,	31,	25},
{35,	25,	33,	31,	23},
{34,	27,	20,	32,	22},
{34,	29,	25,	30,	22},
{34,	33,	30,	30,	25},
{36,	26,	32,	31,	24},
{36,	27,	31,	31,	24},
{35,	27,	21,	32,	24},
{35,	28,	31,	31,	20},
{34,	28,	22,	32,	23},
{34,	30,	22,	30,	30},
{37,	28,	25,	31,	26},
{34,	33,	31,	30,	22},
{34,	29,	33,	30,	22},
{34,	31,	33,	30,	22},
{36,	33,	32,	30,	24},
{34,	33,	31,	30,	26},
{34,	27,	32,	31,	26},
{34,	33,	31,	30,	27},
{34,	24,	26,	30,	32},
{34,	14,	25,	31,	34},
{34,	23,	26,	31,	31},
{35,	22,	27,	31,	32},
{34,	28,	22,	31,	29},
{36,	25,	27,	31,	31},
{35,	27,	31,	31,	28},
{34,	28,	21,	31,	31},
{33,	33,	29,	31,	1},
{34,	30,	29,	31,	8},
{33,	30,	26,	31,	13},
{34,	29,	20,	32,	21},
{33,	26,	15,	32,	28},
{33,	28,	17,	32,	28},
{33,	26,	17,	30,	33},
{34,	25,	26,	30,	33},
{33,	28,	23,	32,	23},
{34,	25,	27,	32,	24},
{35,	18,	32,	32,	25},
{34,	22,	28,	32,	26},
{33,	28,	20,	32,	27},
{33,	17,	27,	30,	34},
{33,	30,	24,	31,	24},
{34,	30,	22,	31,	30},
{33,	29,	24,	32,	22},
{33,	25,	32,	32,	20},
{33,	22,	27,	30,	34},
{33,	19,	10,	31,	34},
{33,	30,	26,	31,	26},
{33,	30,	29,	31,	19},
{34,	30,	29,	31,	27},
{34,	28,	32,	31,	28},
{34,	9,	34,	31,	34},
{33,	4,	34,	32,	35},
{34,	3,	31,	33,	32},
{33,	2,	12,	33,	37},
{33,	4,	30,	33,	32},
{33,	2,	30,	33,	35},
{33,	13,	27,	32,	30},
{33,	16,	17,	32,	32},
{33,	14,	19,	32,	33},
{34,	8,	30,	32,	34},
{33,	22,	17,	32,	32},
{33,	33,	32,	10,	39},
{36,	33,	32,	17,	36},
{34,	33,	31,	19,	36},
{34,	33,	33,	18,	36},
{34,	33,	33,	18,	37},
{33,	35,	33,	26,	23},
{40,	35,	33,	0,	38},
{37,	35,	32,	14,	26},
{37,	36,	32,	16,	26},
{36,	34,	33,	1,	34},
{36,	34,	31,	28,	11},
{36,	34,	33,	28,	11},
{36,	34,	32,	29,	9},
{35,	35,	31,	9,	28},
{37,	34,	33,	10,	28},
{36,	34,	33,	2,	38},
{36,	35,	33,	3,	29},
{35,	34,	29,	12,	35},
{35,	34,	33,	5,	36},
{35,	34,	33,	5,	38},
{35,	34,	33,	16,	35},
{37,	34,	29,	19,	36},
{37,	34,	33,	17,	35},
{37,	34,	32,	19,	31},
{38,	34,	30,	18,	39},
{37,	34,	32,	18,	37},
{36,	35,	31,	13,	31},
{36,	35,	32,	11,	39},
{37,	35,	33,	8,	32},
{36,	34,	33,	26,	26},
{37,	35,	32,	23,	26},
{36,	34,	32,	25,	29},
{35,	35,	33,	11,	32},
{36,	35,	33,	17,	27},
{35,	35,	33,	13,	32},
{35,	35,	33,	8,	39},
{35,	35,	33,	15,	32},
{35,	35,	33,	28,	23},
{36,	35,	33,	28,	24},
{35,	34,	32,	19,	35},
{35,	36,	32,	15,	38},
{35,	35,	31,	18,	36},
{35,	34,	29,	27,	32},
{35,	34,	32,	27,	29},
{34,	34,	29,	31,	3},
{34,	34,	29,	29,	27},
{34,	35,	33,	15,	37},
{34,	35,	32,	18,	37},
{34,	34,	33,	27,	29},
{34,	35,	32,	22,	35},
{38,	34,	32,	27,	32},
{36,	32,	32,	21,	38},
{35,	33,	32,	24,	33},
{35,	35,	31,	23,	35},
{34,	33,	28,	26,	35},
{38,	34,	32,	25,	34},
{35,	34,	31,	25,	35},
{34,	35,	32,	19,	36},
{34,	33,	33,	23,	34},
{34,	32,	33,	21,	37},
{34,	34,	29,	28,	33},
{34,	33,	28,	28,	34},
{37,	30,	28,	28,	36},
{35,	32,	25,	29,	34},
{34,	29,	31,	29,	34},
{37,	33,	31,	29,	31},
{34,	33,	29,	29,	33},
{35,	33,	31,	29,	33},
{34,	35,	32,	25,	33},
{34,	36,	32,	21,	36},
{34,	34,	33,	26,	32},
{35,	34,	33,	22,	35},
{33,	32,	26,	31,	26},
{35,	33,	27,	31,	22},
{33,	31,	33,	31,	5},
{34,	33,	32,	31,	5},
{33,	32,	33,	31,	7},
{33,	33,	33,	31,	7},
{33,	35,	33,	29,	9},
{33,	32,	26,	31,	31},
{34,	32,	27,	31,	31},
{33,	33,	29,	22,	38},
{35,	34,	30,	21,	39},
{35,	35,	32,	19,	38},
{34,	34,	33,	18,	39},
{33,	30,	30,	24,	38},
{33,	33,	31,	30,	29},
{35,	27,	28,	30,	33},
{35,	26,	33,	31,	29},
{34,	33,	29,	30,	31},
{34,	16,	33,	30,	34},
{34,	21,	33,	30,	34},
{35,	29,	30,	31,	31},
{33,	33,	31,	22,	37},
{33,	27,	35,	23,	39},
{38,	27,	35,	29,	17},
{38,	18,	35,	29,	38},
{35,	0,	35,	33,	19},
{33,	17,	35,	31,	13},
{34,	24,	35,	30,	25},
{34,	21,	35,	30,	34},
{33,	6,	35,	32,	31},
{33,	14,	35,	31,	34},
{33,	30,	28,	28,	38},
{35,	25,	27,	29,	38},
{35,	27,	32,	27,	39},
{36,	23,	31,	29,	39},
{36,	30,	31,	27,	39},
{36,	28,	31,	28,	39},
{33,	34,	30,	28,	33},
{33,	25,	35,	26,	39},
{33,	24,	33,	29,	39},
{33,	36,	33,	26,	31},
{37,	36,	33,	15,	34},
{37,	36,	33,	14,	39},
{36,	35,	33,	18,	38},
{36,	36,	33,	19,	35},
{36,	35,	32,	27,	33},
{34,	35,	33,	28,	27},
{34,	36,	33,	19,	36},
{34,	36,	33,	21,	38},
{36,	35,	33,	21,	39},
{34,	36,	33,	23,	34},
{35,	35,	33,	27,	33},
{34,	35,	31,	28,	35},
{35,	31,	26,	28,	38},
{34,	36,	33,	22,	39},
{34,	33,	33,	23,	37},
{33,	36,	33,	28,	25},
{34,	36,	33,	28,	29},
{33,	32,	31,	23,	39},
{34,	34,	31,	23,	38},
{33,	34,	33,	31,	28},
{36,	35,	31,	31,	15},
{36,	30,	33,	31,	31},
{36,	35,	31,	29,	32},
{34,	31,	32,	29,	34},
{35,	30,	32,	28,	39},
{35,	32,	33,	28,	35},
{34,	33,	33,	29,	33},
{35,	36,	33,	28,	32},
{33,	36,	33,	29,	12},
{33,	35,	31,	30,	29},
{33,	24,	35,	29,	38},
{33,	34,	33,	25,	35},
{33,	31,	33,	29,	35},
{34,	29,	31,	29,	39},
{33,	35,	31,	23,	39},
{33,	34,	33,	29,	33},
{33,	34,	31,	29,	35},
{34,	34,	32,	29,	35},
{33,	32,	26,	29,	36},
{33,	32,	26,	28,	39},
{33,	33,	33,	28,	39},
{37,	34,	33,	24,	39},
{35,	35,	31,	27,	38},
{34,	28,	35,	25,	39},
{34,	29,	35,	20,	35},
{33,	29,	35,	28,	21},
{34,	29,	35,	23,	39},
{33,	32,	34,	27,	32},
{40,	32,	34,	22,	39},
{36,	31,	35,	23,	39},
{36,	31,	35,	29,	20},
{35,	31,	34,	31,	15},
{33,	32,	34,	31,	16},
{33,	31,	35,	30,	21},
{33,	21,	35,	31,	32},
{33,	34,	29,	29,	36},
{33,	29,	33,	29,	39},
{33,	34,	31,	28,	39},
{33,	34,	32,	28,	39},
{32,	17,	10,	33,	11},
{35,	19,	6,	33,	14},
{34,	21,	8,	33,	9},
{34,	13,	28,	33,	6},
{34,	17,	12,	33,	12},
{36,	21,	12,	33,	10},
{34,	16,	22,	33,	6},
{33,	14,	12,	33,	15},
{33,	19,	6,	33,	16},
{33,	21,	16,	33,	5},
{33,	18,	25,	33,	6},
{33,	19,	33,	33,	1},
{33,	10,	33,	33,	12},
{33,	1,	35,	33,	30},
{32,	16,	5,	33,	19},
{33,	17,	5,	33,	23},
{34,	8,	28,	33,	23},
{35,	14,	8,	33,	23},
{32,	23,	15,	33,	3},
{32,	7,	6,	33,	29},
{32,	18,	12,	33,	15},
{32,	16,	10,	33,	19},
{32,	18,	14,	33,	14},
{33,	20,	13,	33,	15},
{33,	22,	13,	33,	13},
{32,	11,	9,	33,	29},
{35,	13,	9,	33,	29},
{33,	17,	5,	33,	28},
{33,	16,	9,	33,	27},
{33,	8,	17,	33,	28},
{33,	12,	14,	33,	28},
{36,	11,	23,	33,	26},
{35,	10,	29,	33,	28},
{34,	16,	13,	33,	25},
{34,	17,	11,	33,	28},
{33,	20,	10,	33,	20},
{33,	20,	10,	33,	24},
{32,	22,	27,	33,	2},
{32,	18,	33,	33,	6},
{32,	22,	27,	33,	5},
{32,	12,	24,	33,	22},
{32,	17,	18,	33,	17},
{36,	17,	32,	33,	12},
{33,	14,	18,	33,	28},
{33,	12,	29,	33,	28},
{32,	15,	14,	32,	34},
{32,	12,	3,	32,	35},
{32,	16,	34,	33,	12},
{32,	20,	35,	33,	4},
{32,	4,	35,	33,	26},
{32,	5,	28,	33,	33},
{32,	25,	13,	32,	31},
{32,	4,	30,	33,	35},
{32,	2,	35,	30,	37},
{32,	28,	25,	32,	21},
{33,	26,	33,	32,	13},
{34,	27,	30,	32,	19},
{33,	28,	34,	32,	8},
{32,	16,	27,	30,	35},
{33,	6,	34,	30,	36},
{33,	16,	35,	30,	35},
{32,	13,	15,	30,	39},
{35,	11,	35,	30,	37},
{33,	15,	3,	31,	39},
{32,	25,	19,	31,	33},
{32,	19,	16,	32,	33},
{33,	23,	17,	32,	33},
{34,	23,	11,	32,	34},
{32,	21,	34,	32,	21},
{32,	14,	34,	33,	25},
{33,	10,	32,	33,	29},
{33,	25,	33,	32,	24},
{32,	18,	10,	33,	29},
{32,	6,	31,	33,	32},
{33,	9,	33,	33,	30},
{32,	18,	30,	32,	28},
{32,	14,	23,	32,	34},
{32,	10,	34,	32,	34},
{32,	17,	27,	32,	33},
{34,	24,	22,	32,	30},
{33,	22,	24,	32,	32},
{33,	22,	33,	32,	28},
{34,	17,	34,	32,	33},
{33,	14,	32,	33,	29},
{32,	28,	29,	32,	21},
{32,	25,	22,	32,	31},
{33,	29,	20,	32,	29},
{32,	25,	19,	32,	33},
{32,	29,	26,	32,	23},
{32,	28,	18,	31,	33},
{32,	20,	27,	30,	39},
{34,	1,	28,	33,	38},
{34,	3,	32,	31,	39},
{34,	20,	32,	30,	37},
{32,	2,	29,	33,	38},
{32,	13,	3,	32,	38},
{32,	23,	18,	30,	35},
{32,	18,	35,	32,	31},
{32,	33,	30,	32,	22},
{36,	33,	32,	32,	10},
{33,	32,	34,	32,	9},
{33,	32,	26,	32,	24},
{34,	33,	30,	32,	24},
{34,	31,	30,	32,	28},
{34,	29,	24,	32,	33},
{35,	31,	24,	32,	32},
{34,	33,	29,	32,	28},
{34,	34,	29,	32,	28},
{34,	32,	33,	32,	27},
{35,	33,	32,	32,	28},
{33,	34,	29,	30,	34},
{33,	29,	23,	30,	39},
{35,	23,	29,	30,	39},
{34,	20,	32,	30,	39},
{34,	31,	23,	30,	39},
{34,	30,	33,	29,	39},
{35,	32,	29,	29,	39},
{33,	29,	31,	30,	34},
{34,	30,	32,	31,	32},
{34,	31,	33,	31,	32},
{33,	33,	28,	32,	29},
{33,	23,	34,	30,	36},
{34,	24,	32,	30,	39},
{33,	32,	33,	32,	29},
{33,	34,	30,	29,	37},
{34,	32,	32,	29,	39},
{33,	35,	31,	29,	36},
{32,	35,	31,	32,	5},
{33,	34,	30,	32,	19},
{32,	34,	32,	32,	12},
{33,	34,	32,	32,	21},
{32,	13,	34,	30,	39},
{33,	2,	34,	32,	39},
{32,	36,	33,	32,	19},
{36,	35,	32,	30,	29},
{35,	36,	33,	31,	22},
{32,	30,	25,	30,	37},
{32,	35,	35,	25,	29},
{43,	34,	35,	18,	37},
{37,	34,	35,	29,	8},
{37,	35,	35,	9,	37},
{37,	35,	35,	15,	35},
{37,	35,	35,	22,	33},
{38,	34,	35,	20,	38},
{35,	34,	35,	29,	17},
{35,	34,	35,	29,	21},
{35,	34,	35,	23,	35},
{34,	35,	35,	30,	2},
{35,	35,	35,	29,	16},
{34,	35,	35,	29,	20},
{34,	35,	34,	26,	30},
{34,	35,	35,	20,	36},
{35,	35,	34,	19,	38},
{35,	35,	34,	22,	37},
{34,	35,	35,	22,	37},
{33,	35,	34,	28,	24},
{33,	35,	35,	26,	30},
{33,	35,	34,	22,	38},
{34,	33,	35,	23,	39},
{32,	35,	34,	31,	7},
{34,	34,	35,	30,	19},
{34,	34,	34,	31,	19},
{33,	32,	34,	32,	20},
{33,	32,	34,	32,	24},
{33,	35,	35,	29,	23},
{35,	36,	33,	30,	29},
{33,	35,	33,	31,	26},
{32,	35,	35,	30,	16},
{32,	36,	34,	26,	21},
{41,	36,	34,	5,	37},
{37,	36,	34,	26,	24},
{36,	36,	34,	29,	7},
{36,	36,	34,	17,	26},
{35,	36,	34,	15,	32},
{35,	36,	34,	20,	30},
{34,	36,	34,	29,	21},
{33,	36,	34,	13,	34},
{33,	36,	34,	29,	24},
{32,	36,	34,	31,	7},
{32,	36,	34,	31,	19},
{32,	35,	35,	24,	32},
{32,	25,	32,	30,	39},
{32,	30,	27,	30,	37},
{33,	29,	31,	30,	36},
{33,	28,	31,	30,	39},
{32,	34,	30,	31,	32},
{33,	35,	32,	30,	31},
{34,	33,	33,	31,	32},
{32,	33,	29,	32,	31},
{32,	32,	29,	31,	34},
{34,	29,	29,	32,	33},
{33,	26,	17,	32,	34},
{34,	18,	33,	32,	34},
{33,	28,	33,	32,	33},
{34,	32,	32,	32,	32},
{32,	18,	31,	32,	35},
{33,	12,	7,	32,	38},
{34,	6,	33,	31,	39},
{33,	26,	18,	31,	35},
{33,	12,	35,	31,	38},
{33,	13,	33,	31,	39},
{32,	24,	14,	31,	36},
{33,	15,	32,	31,	39},
{32,	23,	30,	32,	34},
{32,	34,	29,	32,	33},
{32,	30,	29,	30,	39},
{32,	26,	35,	29,	38},
{33,	35,	35,	29,	25},
{32,	36,	34,	21,	38},
{33,	36,	34,	23,	32},
{32,	32,	34,	32,	32},
{34,	35,	35,	29,	27},
{34,	35,	35,	29,	29},
{34,	34,	34,	30,	31},
{34,	28,	34,	30,	38},
{32,	36,	34,	28,	30},
{32,	33,	32,	30,	34},
{34,	30,	33,	30,	38},
{33,	33,	32,	31,	34},
{34,	32,	34,	32,	33},
{33,	36,	34,	24,	33},
{33,	33,	34,	28,	38},
{33,	35,	34,	25,	34},
{33,	31,	34,	30,	35},
{33,	33,	34,	29,	36},
{32,	32,	25,	30,	39},
{32,	35,	33,	25,	38},
{34,	36,	33,	23,	39},
{34,	36,	33,	24,	39},
{33,	35,	35,	24,	35},
{33,	35,	32,	28,	35},
{33,	35,	35,	25,	37},
{32,	35,	32,	30,	34},
{33,	36,	33,	30,	33},
{34,	36,	33,	26,	39},
{34,	34,	33,	28,	39},
{33,	36,	34,	29,	33},
{35,	35,	35,	27,	35},
{34,	34,	35,	29,	36},
{33,	34,	35,	30,	34},
{33,	35,	35,	29,	35},
{34,	36,	34,	28,	34},
{34,	35,	35,	28,	36},
{32,	34,	30,	29,	38},
{32,	34,	33,	31,	34},
{32,	30,	33,	30,	39},
{32,	35,	31,	29,	39},
{34,	35,	32,	29,	37},
{33,	35,	34,	28,	37},
{34,	35,	33,	28,	39},
{33,	34,	33,	29,	39},
{34,	32,	35,	29,	38},
{35,	35,	35,	29,	37},
{34,	33,	34,	29,	39},
{32,	34,	33,	30,	39},
{34,	35,	32,	30,	37},
{32,	35,	34,	30,	35},
{36,	36,	34,	31,	23},
{33,	36,	34,	30,	33},
{32,	33,	34,	30,	38},
{32,	33,	35,	30,	38},
{31,	0,	0,	34,	16},
{32,	0,	8,	34,	4},
{31,	3,	11,	34,	5},
{32,	0,	1,	34,	21},
{32,	1,	7,	34,	27},
{37,	3,	11,	34,	11},
{33,	2,	0,	34,	28},
{32,	5,	0,	34,	12},
{33,	9,	3,	34,	1},
{32,	10,	3,	34,	8},
{34,	10,	4,	34,	9},
{33,	4,	1,	34,	18},
{32,	7,	11,	34,	2},
{32,	1,	4,	34,	33},
{33,	1,	9,	34,	33},
{32,	1,	0,	34,	36},
{31,	5,	5,	34,	12},
{31,	13,	2,	34,	8},
{31,	10,	11,	34,	2},
{31,	9,	5,	34,	12},
{31,	8,	15,	34,	12},
{34,	0,	17,	34,	30},
{34,	7,	19,	34,	9},
{32,	10,	16,	34,	6},
{32,	10,	13,	34,	11},
{32,	12,	7,	34,	11},
{33,	11,	19,	34,	8},
{32,	1,	22,	34,	15},
{31,	2,	1,	34,	32},
{31,	4,	9,	34,	28},
{34,	4,	15,	34,	22},
{33,	6,	7,	34,	16},
{34,	8,	10,	34,	16},
{34,	5,	15,	34,	22},
{33,	5,	19,	34,	22},
{32,	12,	3,	34,	16},
{33,	11,	17,	34,	13},
{32,	4,	1,	34,	34},
{33,	3,	0,	34,	39},
{32,	5,	10,	34,	26},
{31,	9,	9,	34,	18},
{34,	7,	18,	34,	20},
{33,	11,	13,	34,	17},
{32,	6,	7,	34,	26},
{31,	7,	1,	34,	29},
{32,	6,	7,	34,	29},
{32,	5,	4,	34,	33},
{32,	5,	19,	34,	30},
{31,	26,	14,	33,	3},
{33,	25,	13,	33,	10},
{32,	26,	33,	33,	5},
{32,	23,	15,	33,	13},
{31,	5,	22,	34,	16},
{31,	26,	17,	33,	8},
{31,	20,	13,	33,	22},
{31,	5,	21,	34,	29},
{31,	24,	25,	33,	7},
{32,	20,	18,	33,	17},
{33,	22,	23,	33,	12},
{33,	20,	34,	33,	12},
{32,	30,	23,	33,	8},
{33,	29,	26,	33,	8},
{33,	32,	25,	33,	6},
{33,	33,	29,	33,	1},
{32,	20,	30,	33,	16},
{32,	30,	24,	33,	13},
{32,	30,	26,	33,	13},
{32,	22,	34,	33,	13},
{31,	20,	11,	33,	27},
{31,	12,	25,	33,	30},
{31,	12,	25,	33,	32},
{31,	17,	5,	33,	32},
{34,	14,	33,	33,	31},
{31,	15,	14,	33,	32},
{31,	19,	13,	33,	29},
{31,	20,	35,	33,	15},
{31,	0,	34,	33,	37},
{31,	32,	26,	33,	16},
{32,	26,	19,	33,	17},
{32,	34,	29,	33,	3},
{31,	26,	15,	33,	24},
{32,	16,	35,	33,	20},
{32,	24,	26,	33,	19},
{33,	28,	19,	33,	20},
{34,	23,	30,	33,	20},
{31,	21,	15,	33,	27},
{31,	24,	23,	33,	22},
{33,	15,	32,	33,	31},
{32,	28,	17,	33,	24},
{33,	23,	30,	33,	24},
{34,	21,	30,	33,	26},
{32,	19,	28,	33,	28},
{32,	23,	29,	33,	27},
{32,	24,	26,	33,	27},
{31,	27,	18,	33,	26},
{31,	20,	35,	33,	22},
{32,	23,	32,	33,	26},
{32,	19,	35,	33,	28},
{32,	4,	34,	33,	35},
{31,	14,	34,	33,	32},
{31,	20,	27,	32,	35},
{31,	26,	16,	32,	35},
{31,	14,	33,	32,	36},
{32,	14,	26,	32,	38},
{34,	12,	34,	32,	38},
{31,	23,	34,	33,	27},
{31,	18,	33,	31,	39},
{31,	36,	33,	32,	21},
{33,	33,	34,	32,	28},
{32,	33,	34,	32,	32},
{31,	35,	34,	32,	13},
{32,	35,	35,	32,	1},
{32,	35,	35,	31,	6},
{31,	35,	34,	32,	20},
{31,	29,	35,	31,	26},
{31,	33,	35,	31,	19},
{31,	36,	35,	28,	26},
{37,	36,	35,	29,	27},
{35,	36,	35,	3,	37},
{33,	36,	35,	21,	36},
{34,	36,	35,	26,	31},
{34,	36,	35,	21,	37},
{33,	36,	35,	21,	38},
{32,	36,	35,	30,	16},
{32,	36,	35,	29,	31},
{31,	35,	33,	32,	28},
{31,	35,	34,	31,	28},
{31,	34,	31,	32,	32},
{31,	27,	35,	30,	39},
{31,	36,	33,	28,	36},
{31,	36,	35,	29,	39},
{33,	36,	34,	30,	35},
{33,	35,	34,	30,	38},
{32,	33,	35,	30,	39},
{32,	36,	34,	30,	38},
{32,	36,	34,	30,	39},
{30,	12,	6,	34,	18},
{31,	12,	11,	34,	17},
{31,	12,	20,	34,	9},
{31,	12,	18,	34,	17},
{30,	7,	4,	34,	29},
{30,	12,	4,	34,	25},
{32,	11,	3,	34,	29},
{32,	10,	3,	34,	32},
{32,	12,	16,	34,	19},
{31,	12,	18,	34,	20},
{30,	12,	17,	34,	25},
{33,	8,	9,	34,	31},
{31,	8,	16,	34,	30},
{30,	11,	10,	34,	31},
{31,	12,	5,	34,	32},
{31,	12,	13,	34,	30},
{30,	12,	18,	34,	28},
{30,	19,	6,	32,	39},
{30,	36,	35,	32,	1},
{30,	2,	33,	33,	38},
{30,	35,	31,	33,	14},
{31,	34,	33,	33,	1},
{31,	34,	30,	33,	15},
{30,	29,	27,	33,	17},
{31,	31,	30,	33,	18},
{32,	25,	32,	33,	22},
{32,	27,	29,	33,	26},
{32,	26,	31,	33,	27},
{31,	28,	22,	33,	26},
{30,	33,	27,	33,	19},
{30,	14,	31,	33,	35},
{32,	13,	34,	33,	35},
{30,	11,	33,	33,	38},
{34,	14,	11,	33,	39},
{30,	36,	35,	31,	13},
{30,	28,	28,	33,	26},
{30,	12,	34,	33,	37},
{30,	14,	16,	33,	39},
{30,	32,	26,	33,	26},
{32,	33,	27,	33,	26},
{31,	30,	31,	33,	21},
{30,	24,	28,	31,	35},
{30,	14,	34,	32,	39},
{30,	14,	28,	33,	38},
{30,	11,	33,	33,	39},
{30,	34,	29,	33,	24},
{31,	34,	31,	33,	24},
{30,	35,	31,	33,	23},
{30,	35,	31,	33,	27},
{30,	34,	31,	33,	28},
{30,	27,	32,	33,	28},
{30,	35,	35,	31,	26},
{31,	36,	35,	31,	18},
{30,	36,	34,	31,	28},
{31,	36,	33,	32,	32},
{34,	35,	34,	31,	33},
{32,	34,	35,	31,	32},
{31,	35,	35,	31,	32},
{30,	35,	31,	33,	31},
{30,	20,	35,	33,	31},
{30,	33,	33,	32,	34},
{31,	35,	33,	32,	33},
{30,	32,	34,	32,	34},
{32,	24,	35,	31,	35},
{30,	22,	32,	32,	35},
{30,	34,	32,	32,	34},
{30,	35,	33,	31,	34},
{30,	31,	32,	32,	39},
{36,	30,	35,	31,	37},
{35,	33,	30,	31,	36},
{34,	34,	30,	32,	35},
{33,	33,	28,	31,	39},
{33,	35,	31,	32,	35},
{33,	32,	34,	32,	35},
{34,	27,	33,	32,	39},
{33,	31,	33,	32,	39},
{32,	34,	34,	31,	35},
{33,	35,	32,	32,	35},
{31,	35,	31,	31,	36},
{31,	34,	33,	31,	36},
{32,	32,	33,	31,	39},
{30,	23,	35,	31,	39},
{30,	32,	26,	32,	39},
{32,	34,	30,	32,	36},
{30,	30,	34,	32,	37},
{30,	36,	33,	32,	34},
{31,	36,	33,	31,	36},
{30,	34,	35,	30,	39},
{29,	16,	4,	34,	2},
{29,	3,	3,	35,	17},
{34,	0,	1,	35,	30},
{33,	3,	13,	35,	1},
{31,	2,	15,	35,	3},
{34,	0,	15,	35,	16},
{33,	0,	9,	35,	28},
{32,	0,	3,	35,	34},
{31,	1,	3,	35,	27},
{31,	2,	3,	35,	23},
{30,	5,	16,	35,	0},
{32,	4,	1,	35,	16},
{31,	4,	3,	35,	21},
{30,	4,	5,	35,	18},
{32,	3,	15,	35,	7},
{32,	4,	5,	35,	23},
{31,	1,	4,	35,	32},
{30,	4,	8,	35,	11},
{32,	2,	9,	35,	22},
{31,	4,	15,	35,	10},
{30,	0,	15,	35,	28},
{29,	7,	15,	35,	9},
{31,	8,	1,	35,	12},
{30,	6,	13,	35,	11},
{30,	3,	15,	35,	22},
{29,	1,	4,	36,	26},
{32,	0,	7,	36,	28},
{31,	2,	8,	36,	2},
{32,	2,	2,	36,	15},
{30,	0,	4,	36,	33},
{29,	2,	2,	36,	21},
{29,	6,	8,	35,	19},
{31,	6,	13,	35,	19},
{30,	6,	3,	35,	23},
{30,	6,	2,	35,	29},
{32,	6,	2,	35,	32},
{31,	5,	5,	35,	27},
{29,	8,	1,	35,	19},
{29,	7,	6,	35,	16},
{29,	8,	2,	35,	20},
{29,	8,	12,	35,	9},
{30,	9,	4,	35,	8},
{29,	8,	5,	35,	19},
{29,	8,	1,	35,	27},
{29,	1,	3,	36,	32},
{29,	2,	1,	34,	39},
{30,	5,	1,	34,	39},
{29,	13,	14,	34,	16},
{30,	17,	4,	34,	7},
{30,	15,	13,	34,	5},
{32,	16,	16,	34,	4},
{32,	18,	5,	34,	9},
{33,	14,	12,	34,	16},
{31,	14,	18,	34,	15},
{30,	16,	5,	34,	16},
{29,	16,	20,	34,	5},
{29,	3,	12,	35,	27},
{29,	6,	6,	35,	26},
{29,	6,	8,	35,	27},
{30,	6,	8,	35,	30},
{31,	6,	11,	35,	29},
{31,	4,	9,	35,	32},
{32,	9,	9,	34,	33},
{30,	3,	15,	35,	30},
{29,	5,	7,	34,	35},
{30,	1,	6,	35,	34},
{30,	1,	6,	34,	39},
{29,	2,	7,	35,	34},
{29,	6,	8,	34,	35},
{29,	13,	12,	34,	25},
{32,	13,	9,	34,	32},
{30,	13,	18,	34,	27},
{29,	18,	5,	34,	17},
{29,	3,	13,	35,	33},
{33,	3,	16,	34,	35},
{32,	1,	21,	34,	36},
{32,	8,	18,	34,	33},
{32,	13,	12,	34,	33},
{30,	6,	18,	34,	35},
{30,	3,	22,	34,	34},
{29,	0,	14,	35,	37},
{29,	9,	22,	34,	25},
{31,	13,	20,	34,	26},
{31,	12,	22,	34,	26},
{30,	14,	22,	34,	17},
{30,	7,	21,	34,	34},
{30,	8,	30,	34,	31},
{34,	5,	30,	34,	34},
{32,	0,	32,	34,	21},
{31,	12,	32,	34,	2},
{31,	13,	31,	34,	14},
{31,	1,	29,	34,	36},
{30,	14,	30,	34,	15},
{29,	5,	25,	35,	23},
{33,	0,	23,	35,	35},
{32,	8,	22,	35,	9},
{31,	1,	26,	35,	28},
{30,	6,	22,	35,	23},
{30,	3,	25,	35,	29},
{29,	12,	16,	34,	33},
{29,	0,	35,	34,	28},
{31,	7,	31,	34,	33},
{30,	4,	34,	34,	8},
{29,	15,	32,	34,	5},
{29,	0,	31,	35,	31},
{30,	2,	29,	35,	22},
{30,	4,	29,	35,	23},
{30,	8,	29,	35,	8},
{30,	0,	31,	35,	34},
{29,	9,	28,	35,	6},
{29,	8,	27,	35,	11},
{30,	7,	29,	35,	15},
{29,	7,	18,	35,	20},
{29,	0,	29,	34,	38},
{29,	34,	33,	33,	3},
{29,	0,	30,	34,	39},
{29,	13,	30,	34,	27},
{30,	14,	31,	34,	23},
{32,	15,	5,	34,	28},
{30,	14,	8,	34,	32},
{30,	14,	29,	34,	27},
{30,	9,	31,	34,	33},
{29,	14,	33,	34,	27},
{30,	2,	35,	34,	26},
{30,	12,	35,	34,	14},
{29,	16,	35,	34,	3},
{29,	34,	34,	33,	7},
{33,	30,	32,	33,	31},
{29,	34,	35,	33,	1},
{29,	9,	32,	34,	33},
{29,	9,	33,	34,	33},
{29,	34,	34,	33,	8},
{30,	35,	32,	33,	31},
{30,	35,	34,	33,	3},
{30,	35,	34,	33,	8},
{29,	35,	35,	33,	4},
{31,	23,	35,	33,	31},
{31,	34,	35,	32,	12},
{29,	26,	35,	33,	22},
{29,	13,	33,	33,	39},
{29,	34,	35,	32,	17},
{29,	26,	26,	33,	34},
{34,	25,	32,	33,	33},
{31,	15,	34,	33,	35},
{30,	31,	23,	33,	32},
{30,	29,	19,	33,	34},
{30,	31,	32,	33,	33},
{31,	33,	32,	33,	32},
{30,	28,	27,	33,	34},
{32,	32,	25,	33,	34},
{29,	36,	34,	32,	20},
{31,	36,	34,	32,	26},
{29,	36,	35,	32,	16},
{29,	26,	35,	33,	29},
{29,	36,	35,	32,	21},
{30,	36,	35,	32,	26},
{29,	33,	34,	33,	26},
{31,	35,	33,	33,	15},
{31,	32,	34,	33,	30},
{31,	29,	34,	33,	33},
{29,	32,	35,	33,	13},
{29,	34,	35,	33,	20},
{30,	35,	34,	33,	16},
{30,	35,	35,	33,	16},
{30,	33,	35,	33,	29},
{29,	36,	35,	33,	15},
{33,	36,	33,	33,	22},
{29,	26,	33,	33,	34},
{31,	29,	33,	33,	34},
{29,	36,	35,	31,	28},
{29,	36,	35,	32,	28},
{31,	35,	34,	32,	33},
{29,	34,	29,	31,	39},
{29,	35,	35,	32,	31},
{29,	32,	35,	32,	35},
{32,	31,	35,	33,	33},
{31,	7,	35,	33,	37},
{30,	20,	35,	32,	38},
{29,	36,	35,	30,	33},
{29,	35,	33,	32,	35},
{29,	31,	34,	32,	39},
{30,	31,	35,	32,	38},
{29,	24,	35,	32,	39},
{30,	31,	35,	32,	39},
{29,	32,	35,	32,	36},
{29,	34,	32,	32,	36},
{29,	32,	33,	32,	39},
{29,	35,	32,	31,	39},
{30,	33,	32,	32,	37},
{30,	34,	29,	32,	38},
{29,	35,	33,	32,	39},
{34,	36,	33,	32,	39},
{30,	34,	34,	32,	39},
{30,	36,	34,	31,	38},
{31,	36,	34,	31,	39},
{30,	35,	34,	32,	36},
{29,	34,	35,	32,	39},
{29,	36,	35,	31,	33},
{28,	2,	4,	36,	19},
{29,	2,	3,	36,	32},
{28,	1,	7,	36,	17},
{28,	3,	0,	36,	25},
{29,	3,	21,	36,	29},
{31,	2,	9,	36,	33},
{30,	1,	32,	36,	1},
{30,	10,	33,	35,	0},
{29,	14,	8,	35,	0},
{30,	12,	2,	35,	7},
{29,	12,	2,	35,	15},
{31,	9,	8,	35,	16},
{30,	11,	7,	35,	10},
{31,	10,	4,	35,	20},
{29,	12,	17,	35,	1},
{29,	13,	2,	35,	19},
{28,	14,	4,	35,	4},
{28,	18,	7,	34,	5},
{28,	10,	8,	35,	17},
{28,	1,	3,	36,	35},
{29,	1,	6,	35,	37},
{28,	2,	0,	35,	38},
{28,	1,	33,	35,	6},
{28,	24,	19,	34,	2},
{28,	19,	10,	34,	5},
{28,	19,	19,	34,	4},
{28,	18,	13,	34,	6},
{28,	19,	6,	34,	10},
{28,	10,	29,	35,	5},
{28,	10,	8,	35,	27},
{28,	11,	4,	35,	21},
{28,	19,	23,	34,	4},
{29,	25,	21,	34,	1},
{30,	27,	19,	34,	2},
{28,	24,	18,	34,	5},
{29,	24,	14,	34,	6},
{29,	28,	17,	34,	4},
{28,	23,	19,	34,	6},
{28,	21,	12,	34,	16},
{34,	16,	22,	34,	17},
{32,	24,	12,	34,	12},
{31,	16,	32,	34,	13},
{30,	21,	15,	34,	11},
{31,	26,	18,	34,	7},
{30,	23,	13,	34,	15},
{30,	19,	35,	34,	5},
{30,	24,	30,	34,	1},
{30,	26,	35,	34,	0},
{30,	16,	27,	34,	18},
{30,	16,	12,	34,	21},
{29,	20,	11,	34,	20},
{30,	20,	12,	34,	21},
{29,	25,	17,	34,	9},
{29,	20,	9,	34,	22},
{29,	15,	11,	34,	28},
{29,	15,	11,	34,	31},
{29,	25,	30,	34,	2},
{29,	18,	32,	34,	9},
{29,	17,	35,	34,	11},
{28,	1,	23,	36,	24},
{28,	1,	30,	36,	6},
{28,	19,	15,	34,	18},
{29,	17,	28,	34,	18},
{28,	8,	22,	35,	23},
{28,	9,	10,	35,	26},
{28,	5,	10,	34,	39},
{29,	3,	29,	34,	36},
{29,	3,	21,	34,	39},
{28,	17,	8,	34,	31},
{29,	21,	9,	34,	23},
{29,	23,	12,	34,	21},
{28,	24,	12,	34,	20},
{28,	3,	23,	36,	29},
{28,	24,	12,	34,	23},
{29,	17,	27,	34,	23},
{30,	17,	32,	34,	23},
{29,	15,	28,	34,	27},
{29,	16,	21,	34,	27},
{30,	17,	12,	34,	31},
{29,	23,	11,	34,	25},
{30,	19,	7,	34,	31},
{28,	20,	14,	34,	23},
{29,	24,	17,	34,	12},
{28,	21,	12,	34,	26},
{29,	23,	11,	34,	27},
{28,	0,	24,	35,	37},
{28,	25,	35,	34,	2},
{28,	5,	20,	34,	39},
{28,	0,	28,	35,	37},
{28,	17,	22,	34,	27},
{29,	17,	30,	34,	29},
{31,	14,	29,	34,	31},
{28,	0,	33,	35,	33},
{28,	1,	33,	35,	22},
{28,	8,	30,	35,	14},
{28,	10,	33,	35,	4},
{28,	4,	32,	35,	18},
{29,	3,	32,	35,	27},
{28,	2,	35,	35,	23},
{31,	8,	34,	35,	12},
{30,	1,	34,	35,	33},
{29,	3,	16,	36,	31},
{29,	3,	33,	35,	31},
{30,	2,	28,	35,	34},
{28,	1,	13,	36,	34},
{28,	3,	18,	35,	34},
{28,	4,	8,	35,	34},
{28,	1,	29,	35,	35},
{28,	2,	27,	35,	35},
{29,	4,	8,	35,	35},
{28,	2,	2,	35,	39},
{28,	3,	27,	35,	35},
{28,	24,	32,	34,	12},
{30,	25,	27,	34,	10},
{29,	22,	30,	34,	13},
{30,	19,	23,	34,	23},
{32,	22,	32,	34,	15},
{28,	22,	20,	34,	17},
{28,	22,	22,	34,	20},
{29,	22,	22,	34,	22},
{28,	20,	15,	34,	27},
{29,	18,	32,	34,	24},
{28,	25,	35,	34,	5},
{28,	23,	21,	34,	22},
{29,	23,	32,	34,	16},
{28,	3,	29,	34,	38},
{28,	16,	26,	34,	31},
{28,	18,	15,	34,	31},
{28,	24,	11,	34,	28},
{28,	20,	17,	34,	28},
{29,	21,	22,	34,	25},
{28,	20,	18,	34,	29},
{28,	20,	14,	34,	31},
{28,	21,	30,	34,	25},
{28,	22,	24,	34,	25},
{28,	22,	17,	34,	28},
{29,	21,	30,	34,	28},
{29,	20,	26,	34,	30},
{28,	23,	25,	34,	28},
{28,	31,	29,	34,	18},
{34,	32,	25,	34,	19},
{32,	32,	34,	34,	0},
{32,	32,	29,	34,	10},
{30,	31,	31,	34,	5},
{31,	29,	31,	34,	14},
{30,	32,	31,	34,	9},
{29,	25,	14,	34,	25},
{29,	33,	31,	34,	1},
{29,	27,	35,	34,	6},
{29,	30,	35,	34,	3},
{29,	33,	31,	34,	4},
{30,	35,	31,	34,	4},
{29,	31,	23,	34,	24},
{30,	28,	17,	34,	26},
{29,	30,	27,	34,	20},
{28,	33,	28,	34,	18},
{28,	15,	26,	33,	39},
{28,	17,	6,	33,	38},
{28,	13,	35,	33,	38},
{28,	15,	34,	33,	39},
{28,	16,	34,	33,	39},
{29,	17,	33,	33,	35},
{28,	18,	13,	33,	36},
{28,	37,	35,	26,	27},
{37,	37,	34,	18,	34},
{36,	37,	34,	21,	37},
{35,	37,	34,	33,	7},
{33,	37,	34,	32,	23},
{31,	37,	35,	5,	29},
{33,	37,	35,	20,	28},
{31,	37,	34,	21,	39},
{31,	37,	34,	24,	38},
{31,	37,	34,	29,	30},
{30,	37,	35,	28,	2},
{31,	37,	35,	27,	8},
{31,	37,	35,	28,	9},
{30,	37,	35,	10,	30},
{31,	37,	35,	20,	30},
{30,	37,	35,	28,	12},
{30,	37,	35,	26,	29},
{30,	37,	34,	29,	38},
{29,	37,	35,	4,	37},
{30,	37,	35,	19,	31},
{29,	37,	35,	28,	18},
{29,	37,	35,	28,	20},
{28,	37,	35,	9,	32},
{29,	37,	35,	8,	34},
{28,	37,	35,	13,	32},
{28,	37,	35,	31,	20},
{33,	37,	35,	32,	8},
{28,	37,	35,	33,	1},
{28,	37,	35,	24,	30},
{28,	32,	28,	33,	34},
{29,	33,	28,	33,	34},
{29,	32,	30,	33,	34},
{28,	37,	35,	24,	31},
{28,	33,	35,	34,	26},
{33,	24,	34,	34,	28},
{32,	35,	33,	34,	2},
{32,	15,	35,	34,	31},
{29,	30,	33,	34,	27},
{29,	33,	29,	34,	27},
{28,	34,	31,	34,	7},
{28,	34,	29,	34,	25},
{28,	24,	35,	34,	30},
{28,	25,	13,	34,	31},
{28,	27,	16,	34,	30},
{28,	19,	32,	34,	31},
{28,	36,	33,	34,	22},
{32,	34,	31,	34,	27},
{28,	35,	35,	34,	12},
{29,	36,	34,	34,	15},
{28,	37,	34,	34,	7},
{28,	37,	34,	34,	15},
{28,	34,	34,	34,	22},
{28,	36,	34,	34,	16},
{28,	36,	34,	34,	17},
{28,	37,	35,	19,	37},
{33,	37,	35,	21,	37},
{29,	37,	35,	16,	39},
{30,	37,	35,	21,	39},
{28,	33,	32,	34,	30},
{29,	33,	34,	34,	28},
{28,	34,	30,	34,	30},
{28,	36,	35,	33,	25},
{32,	34,	34,	34,	27},
{31,	36,	34,	33,	27},
{30,	35,	34,	34,	23},
{29,	36,	33,	34,	24},
{29,	35,	32,	34,	30},
{29,	35,	34,	34,	27},
{29,	35,	34,	34,	28},
{31,	36,	35,	33,	28},
{28,	32,	34,	34,	30},
{28,	33,	30,	33,	34},
{28,	32,	33,	33,	34},
{28,	34,	31,	33,	34},
{28,	37,	35,	22,	39},
{28,	35,	32,	33,	33},
{28,	37,	35,	24,	38},
{28,	35,	34,	33,	32},
{30,	35,	34,	33,	33},
{28,	34,	34,	34,	30},
{28,	36,	35,	32,	31},
{29,	36,	34,	33,	32},
{29,	36,	34,	32,	36},
{29,	37,	34,	32,	38},
{30,	36,	34,	32,	39},
{29,	37,	34,	33,	27},
{28,	36,	35,	33,	30},
{28,	36,	33,	33,	34},
{29,	36,	35,	33,	33},
{29,	35,	35,	32,	35},
{28,	35,	35,	31,	36},
{28,	36,	35,	32,	35},
{28,	36,	36,	30,	37},
{39,	33,	36,	30,	39},
{34,	36,	36,	23,	39},
{33,	28,	36,	31,	33},
{34,	7,	36,	34,	6},
{33,	35,	36,	29,	39},
{33,	36,	35,	30,	39},
{32,	4,	36,	33,	27},
{31,	4,	36,	32,	39},
{31,	36,	36,	28,	39},
{30,	4,	36,	34,	22},
{30,	35,	36,	30,	39},
{29,	24,	36,	33,	2},
{29,	36,	36,	29,	39},
{30,	36,	36,	30,	39},
{28,	0,	36,	33,	39},
{28,	8,	36,	32,	38},
{27,	14,	4,	36,	0},
{29,	8,	4,	36,	1},
{30,	5,	3,	36,	6},
{29,	4,	0,	36,	26},
{27,	5,	13,	36,	6},
{29,	4,	23,	36,	8},
{27,	6,	14,	36,	2},
{27,	12,	7,	35,	8},
{28,	13,	4,	35,	13},
{28,	12,	8,	35,	12},
{27,	4,	9,	36,	15},
{27,	14,	4,	35,	12},
{28,	14,	3,	35,	19},
{27,	16,	4,	35,	8},
{28,	16,	9,	35,	8},
{30,	13,	21,	35,	3},
{29,	17,	10,	35,	3},
{29,	14,	10,	35,	10},
{28,	19,	10,	35,	1},
{27,	4,	11,	36,	17},
{27,	4,	10,	36,	20},
{27,	3,	33,	36,	1},
{27,	5,	5,	36,	29},
{27,	7,	7,	36,	13},
{28,	8,	6,	36,	6},
{28,	8,	13,	36,	3},
{27,	7,	0,	36,	28},
{27,	6,	5,	36,	27},
{28,	6,	6,	36,	29},
{27,	3,	2,	36,	34},
{27,	13,	4,	35,	24},
{29,	13,	4,	35,	27},
{27,	13,	8,	35,	19},
{29,	13,	10,	35,	17},
{28,	14,	6,	35,	20},
{28,	13,	11,	35,	16},
{28,	10,	18,	35,	11},
{31,	9,	22,	35,	23},
{28,	13,	12,	35,	20},
{29,	10,	12,	35,	27},
{28,	9,	21,	35,	26},
{31,	4,	23,	35,	35},
{29,	4,	30,	35,	34},
{28,	6,	12,	35,	32},
{28,	9,	33,	35,	15},
{28,	6,	19,	35,	32},
{28,	6,	27,	35,	28},
{28,	6,	34,	35,	20},
{28,	6,	33,	35,	28},
{27,	2,	2,	36,	36},
{27,	3,	2,	36,	36},
{27,	0,	11,	36,	36},
{27,	10,	18,	35,	21},
{27,	2,	12,	35,	37},
{27,	16,	6,	34,	33},
{27,	3,	24,	36,	27},
{27,	19,	36,	34,	2},
{27,	2,	30,	36,	27},
{27,	1,	33,	36,	24},
{28,	3,	31,	36,	22},
{28,	4,	32,	36,	10},
{27,	5,	26,	36,	7},
{27,	7,	32,	36,	1},
{27,	6,	24,	36,	7},
{27,	21,	8,	34,	32},
{27,	13,	32,	35,	16},
{28,	13,	34,	35,	11},
{29,	13,	35,	35,	6},
{27,	14,	23,	35,	8},
{27,	10,	31,	35,	21},
{29,	9,	31,	35,	26},
{27,	9,	21,	34,	34},
{28,	8,	2,	34,	37},
{27,	11,	1,	34,	38},
{27,	9,	23,	34,	35},
{29,	9,	29,	34,	35},
{27,	2,	28,	35,	36},
{27,	8,	33,	35,	27},
{27,	10,	21,	35,	27},
{27,	2,	36,	34,	31},
{27,	0,	34,	35,	35},
{31,	0,	36,	34,	36},
{31,	0,	34,	34,	39},
{29,	4,	33,	35,	34},
{28,	1,	34,	34,	38},
{29,	7,	33,	34,	35},
{29,	4,	32,	34,	38},
{28,	2,	34,	35,	35},
{30,	8,	35,	34,	35},
{29,	3,	36,	34,	36},
{30,	4,	35,	34,	38},
{28,	11,	34,	34,	33},
{27,	23,	14,	33,	35},
{27,	1,	35,	35,	35},
{27,	36,	35,	34,	6},
{27,	37,	35,	34,	1},
{27,	3,	36,	34,	38},
{27,	5,	34,	34,	38},
{27,	5,	34,	34,	39},
{28,	5,	35,	34,	39},
{27,	8,	35,	34,	37},
{27,	7,	30,	34,	39},
{28,	8,	32,	34,	39},
{28,	8,	35,	34,	39},
{27,	9,	12,	34,	39},
{27,	23,	36,	34,	24},
{28,	28,	36,	33,	8},
{27,	27,	36,	34,	9},
{27,	25,	36,	34,	21},
{28,	28,	36,	33,	22},
{27,	18,	36,	34,	31},
{30,	8,	36,	34,	38},
{28,	24,	36,	34,	30},
{27,	12,	36,	34,	33},
{27,	34,	36,	34,	18},
{34,	35,	36,	31,	25},
{33,	35,	36,	31,	34},
{31,	29,	36,	34,	29},
{29,	34,	35,	34,	28},
{29,	31,	36,	34,	27},
{30,	34,	36,	32,	31},
{28,	34,	36,	33,	26},
{27,	36,	36,	33,	2},
{27,	36,	35,	34,	13},
{28,	36,	35,	34,	15},
{29,	35,	35,	34,	22},
{28,	35,	35,	34,	28},
{27,	37,	35,	29,	26},
{30,	37,	35,	30,	26},
{29,	37,	35,	29,	29},
{28,	37,	35,	29,	36},
{27,	37,	35,	31,	25},
{27,	35,	36,	33,	26},
{27,	36,	36,	32,	24},
{30,	36,	36,	31,	30},
{29,	36,	36,	33,	11},
{29,	36,	36,	31,	34},
{27,	33,	36,	34,	27},
{27,	30,	33,	33,	35},
{29,	36,	33,	33,	35},
{27,	37,	35,	31,	28},
{28,	37,	35,	31,	29},
{27,	37,	35,	32,	28},
{27,	36,	33,	34,	30},
{27,	37,	35,	31,	30},
{27,	37,	35,	32,	30},
{27,	36,	36,	32,	31},
{27,	37,	35,	27,	37},
{27,	35,	35,	33,	35},
{28,	36,	34,	33,	34},
{27,	31,	36,	32,	39},
{32,	35,	36,	31,	37},
{30,	30,	36,	33,	34},
{30,	35,	36,	32,	35},
{27,	14,	36,	33,	38},
{27,	36,	36,	32,	34},
{27,	32,	36,	32,	39},
{27,	37,	35,	29,	39},
{27,	34,	35,	33,	39},
{31,	27,	36,	33,	38},
{30,	27,	36,	33,	39},
{30,	35,	32,	33,	36},
{30,	35,	32,	33,	37},
{28,	36,	34,	33,	36},
{27,	33,	36,	33,	36},
{29,	34,	36,	33,	36},
{27,	35,	36,	33,	33},
{27,	36,	36,	33,	33},
{27,	35,	32,	33,	38},
{27,	36,	33,	33,	37},
{28,	35,	33,	33,	39},
{27,	37,	34,	33,	36},
{27,	36,	35,	31,	39},
{27,	36,	33,	33,	39},
{27,	36,	34,	33,	39},
{27,	35,	35,	33,	37},
{27,	35,	35,	33,	38},
{28,	35,	35,	32,	39},
{26,	11,	13,	36,	0},
{26,	15,	8,	35,	11},
{26,	19,	15,	35,	1},
{29,	15,	20,	35,	8},
{28,	15,	31,	35,	5},
{27,	17,	19,	35,	3},
{26,	18,	20,	35,	2},
{26,	6,	35,	36,	0},
{29,	2,	34,	36,	11},
{28,	0,	34,	36,	26},
{27,	3,	35,	36,	5},
{29,	0,	35,	36,	25},
{27,	6,	35,	36,	5},
{26,	11,	12,	35,	27},
{26,	10,	11,	35,	32},
{30,	10,	17,	35,	32},
{29,	13,	3,	35,	32},
{28,	9,	30,	35,	29},
{27,	7,	1,	35,	34},
{27,	11,	12,	35,	31},
{26,	7,	1,	36,	28},
{26,	15,	35,	35,	5},
{27,	14,	34,	35,	10},
{27,	14,	33,	35,	16},
{28,	15,	9,	35,	15},
{27,	16,	7,	35,	14},
{27,	17,	6,	35,	11},
{26,	15,	22,	35,	14},
{26,	7,	15,	35,	34},
{27,	5,	30,	35,	34},
{27,	6,	30,	35,	34},
{26,	12,	3,	35,	33},
{28,	8,	16,	35,	34},
{26,	10,	16,	35,	33},
{27,	9,	17,	35,	34},
{26,	2,	27,	36,	30},
{26,	13,	29,	35,	23},
{28,	11,	27,	35,	27},
{27,	13,	7,	35,	28},
{29,	12,	28,	35,	27},
{27,	13,	30,	35,	25},
{27,	13,	16,	35,	28},
{26,	14,	6,	35,	28},
{26,	17,	4,	35,	28},
{28,	15,	7,	35,	24},
{26,	0,	33,	35,	38},
{27,	0,	35,	35,	37},
{26,	0,	27,	35,	39},
{27,	0,	35,	35,	39},
{26,	2,	12,	35,	39},
{26,	1,	27,	35,	38},
{26,	1,	32,	35,	38},
{26,	13,	33,	35,	27},
{26,	13,	34,	35,	21},
{26,	9,	34,	35,	28},
{26,	14,	34,	35,	24},
{27,	15,	8,	35,	27},
{29,	14,	34,	35,	27},
{26,	14,	17,	35,	31},
{26,	16,	5,	35,	29},
{26,	16,	7,	35,	26},
{26,	16,	9,	35,	19},
{26,	16,	17,	35,	13},
{26,	17,	16,	35,	12},
{26,	17,	8,	35,	16},
{26,	14,	5,	35,	33},
{26,	14,	20,	35,	30},
{27,	13,	31,	35,	29},
{27,	13,	34,	35,	30},
{26,	7,	34,	35,	32},
{27,	10,	30,	35,	32},
{27,	8,	29,	35,	34},
{26,	11,	20,	35,	33},
{26,	14,	35,	35,	25},
{26,	36,	36,	34,	7},
{27,	35,	36,	34,	14},
{26,	14,	35,	34,	33},
{27,	35,	34,	34,	33},
{29,	25,	36,	34,	33},
{29,	36,	33,	34,	33},
{27,	37,	34,	34,	31},
{31,	36,	35,	34,	22},
{28,	36,	35,	34,	25},
{27,	37,	34,	34,	32},
{26,	7,	36,	34,	39},
{26,	34,	36,	34,	26},
{26,	36,	36,	34,	22},
{26,	36,	35,	34,	27},
{26,	37,	35,	32,	33},
{27,	37,	35,	30,	39},
{27,	37,	34,	33,	39},
{26,	37,	35,	32,	34},
{26,	32,	36,	33,	39},
{26,	37,	35,	31,	38},
{28,	37,	35,	31,	39},
{26,	33,	36,	33,	39},
{26,	36,	36,	31,	39},
{26,	36,	35,	32,	39},
{29,	36,	36,	32,	36},
{26,	36,	35,	33,	36},
{26,	37,	35,	32,	39},
{26,	36,	35,	33,	39},
{26,	36,	36,	32,	39},
{29,	34,	36,	33,	39},
{25,	10,	1,	36,	7},
{26,	13,	6,	36,	3},
{26,	10,	6,	36,	6},
{26,	14,	3,	36,	5},
{26,	9,	25,	36,	7},
{26,	7,	11,	36,	11},
{26,	7,	26,	36,	9},
{25,	16,	4,	36,	2},
{25,	10,	4,	36,	11},
{29,	9,	7,	36,	13},
{27,	9,	13,	36,	11},
{25,	10,	1,	36,	17},
{25,	19,	18,	35,	2},
{25,	7,	13,	36,	21},
{28,	9,	3,	36,	19},
{25,	10,	3,	36,	19},
{25,	10,	2,	36,	21},
{25,	7,	3,	36,	29},
{25,	11,	30,	36,	0},
{25,	7,	7,	36,	28},
{26,	7,	8,	36,	29},
{26,	7,	12,	36,	27},
{25,	4,	18,	36,	21},
{25,	7,	19,	36,	12},
{26,	9,	24,	36,	10},
{26,	6,	16,	36,	22},
{25,	5,	20,	36,	21},
{25,	6,	6,	35,	36},
{27,	6,	1,	35,	39},
{27,	5,	14,	35,	36},
{28,	5,	26,	35,	36},
{26,	9,	2,	35,	35},
{25,	7,	2,	35,	38},
{27,	3,	18,	35,	39},
{26,	3,	34,	35,	39},
{26,	3,	35,	35,	36},
{25,	0,	9,	36,	39},
{27,	3,	0,	36,	39},
{27,	1,	6,	36,	39},
{25,	17,	8,	35,	24},
{26,	17,	14,	35,	19},
{26,	17,	13,	35,	21},
{27,	17,	16,	35,	20},
{28,	16,	20,	35,	20},
{25,	7,	5,	35,	37},
{25,	7,	20,	36,	22},
{25,	1,	12,	36,	36},
{25,	16,	10,	35,	26},
{27,	15,	23,	35,	23},
{26,	17,	16,	35,	23},
{25,	17,	35,	35,	0},
{26,	16,	34,	35,	5},
{26,	18,	24,	35,	3},
{26,	17,	22,	35,	22},
{26,	19,	35,	35,	4},
{26,	19,	7,	35,	13},
{27,	18,	6,	35,	22},
{25,	19,	17,	35,	12},
{25,	26,	15,	35,	7},
{29,	23,	31,	35,	0},
{29,	27,	16,	35,	5},
{28,	21,	11,	35,	10},
{28,	26,	29,	35,	0},
{27,	22,	16,	35,	9},
{26,	26,	17,	35,	5},
{26,	34,	30,	35,	0},
{25,	21,	13,	35,	11},
{26,	24,	11,	35,	22},
{28,	20,	14,	35,	17},
{27,	25,	13,	35,	11},
{27,	25,	17,	35,	9},
{27,	19,	10,	35,	24},
{26,	22,	17,	35,	12},
{26,	23,	11,	35,	23},
{25,	25,	19,	35,	5},
{28,	23,	21,	35,	6},
{26,	21,	31,	35,	3},
{25,	28,	20,	35,	1},
{25,	20,	19,	35,	12},
{25,	24,	20,	35,	8},
{26,	24,	19,	35,	11},
{25,	7,	19,	36,	26},
{26,	7,	15,	36,	29},
{25,	20,	7,	35,	26},
{25,	20,	15,	35,	18},
{25,	7,	21,	36,	25},
{25,	5,	24,	36,	24},
{25,	13,	5,	34,	38},
{28,	11,	22,	34,	34},
{25,	10,	3,	35,	35},
{26,	11,	19,	35,	34},
{26,	14,	4,	35,	34},
{25,	21,	12,	35,	22},
{25,	11,	7,	34,	39},
{25,	6,	27,	36,	23},
{26,	4,	33,	36,	17},
{25,	20,	15,	35,	23},
{25,	3,	34,	36,	20},
{25,	7,	35,	36,	6},
{27,	6,	31,	36,	22},
{26,	6,	34,	36,	16},
{25,	6,	35,	36,	17},
{25,	1,	36,	35,	25},
{27,	2,	36,	35,	33},
{29,	10,	36,	35,	7},
{25,	35,	31,	35,	0},
{25,	27,	33,	35,	0},
{25,	23,	32,	35,	11},
{31,	16,	34,	35,	19},
{27,	22,	30,	35,	12},
{27,	20,	32,	35,	13},
{26,	19,	35,	35,	9},
{26,	18,	31,	35,	21},
{30,	20,	30,	35,	17},
{25,	22,	21,	35,	26},
{30,	22,	30,	35,	18},
{30,	15,	34,	35,	28},
{27,	21,	28,	35,	21},
{26,	24,	17,	35,	13},
{29,	23,	25,	35,	17},
{26,	21,	32,	35,	19},
{26,	19,	35,	35,	19},
{26,	22,	30,	35,	26},
{28,	16,	33,	35,	28},
{28,	19,	34,	35,	26},
{26,	22,	32,	35,	25},
{25,	24,	16,	35,	16},
{25,	21,	12,	35,	27},
{25,	16,	18,	35,	29},
{25,	20,	35,	35,	11},
{26,	22,	34,	35,	9},
{26,	30,	34,	35,	0},
{25,	23,	24,	35,	19},
{25,	22,	35,	35,	11},
{25,	12,	26,	35,	32},
{25,	13,	27,	34,	34},
{25,	13,	10,	34,	35},
{26,	13,	8,	34,	39},
{25,	21,	31,	35,	27},
{25,	18,	19,	35,	29},
{26,	21,	32,	35,	28},
{26,	20,	34,	35,	28},
{26,	20,	35,	35,	26},
{26,	21,	35,	35,	26},
{25,	22,	31,	35,	27},
{26,	24,	11,	35,	27},
{25,	22,	35,	35,	24},
{26,	22,	33,	35,	28},
{25,	33,	35,	35,	12},
{28,	27,	17,	35,	14},
{26,	28,	17,	35,	15},
{26,	29,	36,	35,	4},
{26,	31,	33,	35,	24},
{32,	31,	35,	35,	18},
{31,	23,	34,	35,	28},
{30,	31,	35,	35,	22},
{29,	26,	18,	35,	26},
{28,	32,	33,	35,	14},
{27,	28,	23,	35,	25},
{27,	30,	30,	35,	25},
{26,	26,	18,	35,	27},
{25,	35,	31,	35,	1},
{27,	34,	29,	35,	11},
{28,	35,	31,	35,	4},
{25,	13,	36,	35,	25},
{25,	25,	24,	35,	27},
{27,	24,	32,	35,	28},
{25,	15,	36,	35,	26},
{25,	35,	31,	35,	14},
{26,	35,	33,	35,	24},
{27,	34,	35,	35,	2},
{27,	33,	35,	35,	16},
{26,	35,	34,	35,	1},
{26,	35,	34,	35,	4},
{26,	33,	27,	35,	25},
{25,	36,	34,	35,	3},
{26,	36,	33,	35,	22},
{25,	10,	36,	34,	39},
{27,	11,	21,	34,	38},
{27,	13,	23,	34,	35},
{25,	13,	20,	34,	36},
{25,	14,	24,	34,	35},
{27,	14,	33,	34,	34},
{25,	12,	23,	34,	38},
{25,	15,	32,	34,	34},
{25,	18,	6,	34,	34},
{27,	16,	31,	34,	34},
{26,	19,	10,	34,	34},
{26,	16,	36,	34,	34},
{25,	12,	36,	34,	36},
{27,	15,	32,	34,	35},
{26,	12,	31,	34,	38},
{25,	13,	29,	34,	39},
{26,	11,	36,	34,	39},
{27,	13,	33,	34,	39},
{25,	32,	35,	35,	21},
{25,	37,	36,	27,	26},
{30,	37,	36,	31,	1},
{31,	37,	36,	29,	10},
{30,	37,	36,	3,	30},
{30,	37,	36,	3,	35},
{30,	37,	36,	10,	28},
{27,	37,	36,	33,	0},
{27,	37,	36,	29,	13},
{26,	37,	36,	6,	34},
{26,	37,	36,	10,	29},
{25,	37,	36,	10,	30},
{25,	37,	36,	8,	32},
{26,	37,	36,	10,	32},
{25,	37,	36,	28,	16},
{25,	34,	33,	35,	28},
{26,	35,	33,	35,	25},
{26,	35,	32,	35,	28},
{27,	36,	33,	35,	27},
{25,	31,	34,	35,	25},
{25,	31,	34,	35,	28},
{25,	35,	35,	34,	29},
{26,	36,	35,	34,	29},
{25,	35,	33,	34,	34},
{30,	34,	34,	34,	34},
{27,	36,	33,	34,	34},
{26,	25,	36,	34,	34},
{26,	35,	34,	34,	34},
{26,	37,	34,	34,	34},
{25,	28,	36,	34,	34},
{25,	36,	35,	34,	32},
{27,	35,	35,	34,	33},
{25,	32,	36,	34,	31},
{25,	37,	35,	33,	34},
{27,	37,	35,	33,	35},
{25,	36,	35,	34,	34},
{25,	36,	36,	33,	35},
{25,	35,	36,	33,	36},
{25,	37,	35,	33,	36},
{25,	35,	36,	33,	39},
{24,	2,	4,	37,	6},
{29,	1,	15,	37,	3},
{28,	4,	2,	37,	3},
{27,	1,	2,	37,	9},
{27,	13,	2,	37,	0},
{26,	1,	14,	37,	6},
{25,	1,	0,	37,	15},
{26,	2,	0,	37,	16},
{25,	4,	1,	37,	7},
{25,	2,	15,	37,	6},
{24,	0,	0,	38,	2},
{24,	1,	3,	37,	11},
{24,	1,	3,	37,	14},
{24,	2,	3,	37,	13},
{24,	2,	0,	37,	18},
{24,	12,	7,	36,	5},
{24,	3,	14,	37,	7},
{26,	3,	17,	37,	7},
{25,	2,	12,	37,	12},
{24,	1,	7,	37,	18},
{26,	0,	4,	37,	26},
{26,	1,	12,	37,	18},
{25,	2,	10,	37,	18},
{25,	0,	9,	37,	26},
{24,	14,	3,	36,	12},
{25,	12,	7,	36,	8},
{24,	11,	7,	36,	11},
{24,	3,	20,	37,	7},
{25,	0,	34,	37,	4},
{26,	3,	24,	37,	7},
{26,	0,	35,	37,	4},
{24,	2,	9,	37,	25},
{24,	8,	1,	36,	29},
{24,	12,	22,	36,	6},
{28,	12,	30,	36,	5},
{26,	13,	21,	36,	1},
{26,	11,	35,	36,	4},
{26,	10,	34,	36,	7},
{26,	10,	18,	36,	11},
{25,	10,	34,	36,	9},
{24,	13,	22,	36,	3},
{24,	14,	9,	36,	2},
{24,	8,	6,	36,	28},
{26,	8,	8,	36,	29},
{25,	8,	13,	36,	25},
{26,	9,	12,	36,	16},
{26,	8,	17,	36,	25},
{27,	9,	23,	36,	16},
{25,	8,	21,	36,	26},
{24,	8,	2,	36,	32},
{27,	5,	1,	36,	35},
{26,	5,	13,	36,	31},
{25,	5,	12,	36,	32},
{25,	3,	6,	36,	36},
{25,	3,	10,	36,	35},
{25,	5,	11,	36,	33},
{24,	0,	36,	36,	6},
{24,	9,	2,	36,	32},
{24,	5,	6,	36,	34},
{25,	4,	18,	36,	34},
{25,	6,	17,	36,	31},
{24,	10,	22,	36,	14},
{24,	9,	16,	36,	23},
{26,	9,	8,	36,	28},
{26,	9,	24,	36,	22},
{25,	10,	21,	36,	18},
{24,	10,	26,	36,	16},
{26,	7,	31,	36,	23},
{25,	10,	32,	36,	14},
{24,	7,	15,	36,	32},
{24,	9,	5,	36,	32},
{24,	6,	14,	36,	33},
{25,	9,	5,	36,	33},
{24,	9,	19,	36,	26},
{25,	9,	15,	36,	29},
{25,	9,	11,	36,	32},
{25,	9,	23,	36,	27},
{24,	1,	18,	36,	35},
{24,	10,	19,	36,	27},
{25,	10,	15,	36,	29},
{25,	10,	24,	36,	27},
{24,	10,	5,	36,	33},
{24,	13,	22,	36,	27},
{29,	13,	12,	36,	29},
{28,	12,	32,	36,	13},
{26,	11,	9,	36,	32},
{25,	15,	4,	36,	8},
{25,	15,	6,	36,	7},
{25,	13,	30,	36,	9},
{26,	13,	24,	36,	26},
{24,	15,	9,	36,	8},
{24,	15,	21,	36,	1},
{24,	15,	12,	36,	6},
{24,	11,	16,	36,	30},
{24,	10,	18,	35,	35},
{27,	8,	28,	35,	35},
{26,	9,	29,	35,	35},
{24,	7,	28,	36,	27},
{24,	6,	27,	36,	29},
{26,	13,	20,	36,	29},
{26,	9,	21,	36,	31},
{25,	8,	27,	36,	30},
{25,	8,	31,	36,	26},
{25,	8,	32,	36,	26},
{25,	8,	34,	36,	20},
{25,	10,	26,	36,	30},
{24,	12,	34,	36,	11},
{24,	15,	20,	35,	30},
{24,	18,	5,	35,	31},
{24,	15,	13,	35,	32},
{24,	14,	11,	35,	33},
{24,	20,	14,	35,	30},
{25,	21,	20,	35,	29},
{25,	20,	34,	35,	30},
{25,	16,	22,	35,	31},
{25,	19,	12,	35,	31},
{26,	19,	34,	35,	31},
{25,	28,	32,	35,	29},
{27,	29,	34,	35,	29},
{25,	21,	32,	35,	30},
{25,	25,	35,	35,	29},
{25,	5,	36,	35,	33},
{26,	12,	35,	35,	32},
{25,	19,	35,	35,	32},
{25,	30,	33,	35,	29},
{24,	24,	12,	35,	30},
{24,	6,	27,	36,	33},
{26,	4,	24,	36,	34},
{24,	1,	19,	36,	38},
{26,	0,	23,	36,	38},
{26,	2,	20,	36,	36},
{25,	2,	29,	36,	35},
{24,	1,	33,	36,	35},
{27,	4,	31,	36,	34},
{27,	8,	32,	36,	31},
{25,	0,	33,	36,	37},
{26,	0,	31,	36,	38},
{26,	2,	32,	36,	36},
{25,	0,	34,	36,	36},
{26,	0,	35,	36,	33},
{25,	1,	31,	36,	38},
{25,	1,	34,	36,	36},
{26,	7,	34,	36,	31},
{26,	4,	35,	36,	33},
{25,	7,	35,	36,	29},
{25,	3,	35,	36,	34},
{25,	0,	34,	36,	39},
{24,	12,	35,	36,	10},
{24,	0,	36,	36,	33},
{25,	0,	36,	36,	35},
{24,	2,	36,	36,	23},
{24,	7,	36,	36,	0},
{24,	5,	36,	36,	7},
{24,	37,	36,	34,	0},
{24,	1,	35,	36,	36},
{24,	2,	35,	36,	36},
{24,	36,	35,	35,	4},
{24,	0,	36,	35,	39},
{24,	11,	30,	35,	34},
{24,	0,	35,	36,	39},
{24,	2,	35,	35,	39},
{25,	1,	35,	36,	38},
{24,	3,	36,	35,	37},
{24,	6,	33,	35,	39},
{27,	9,	33,	35,	35},
{27,	6,	34,	35,	39},
{26,	10,	35,	35,	34},
{24,	8,	13,	35,	39},
{26,	8,	20,	35,	38},
{26,	8,	25,	35,	39},
{26,	7,	33,	35,	39},
{24,	36,	34,	35,	8},
{27,	34,	35,	35,	11},
{25,	36,	34,	35,	9},
{25,	36,	34,	35,	10},
{24,	35,	35,	35,	7},
{24,	4,	35,	35,	39},
{24,	6,	35,	35,	39},
{25,	7,	35,	35,	39},
{24,	37,	36,	10,	34},
{24,	37,	36,	6,	39},
{24,	14,	35,	35,	35},
{26,	13,	35,	34,	39},
{24,	12,	4,	35,	38},
{26,	12,	7,	35,	37},
{25,	9,	13,	35,	39},
{24,	13,	36,	35,	33},
{24,	36,	34,	35,	15},
{24,	37,	34,	35,	13},
{24,	37,	36,	10,	37},
{24,	37,	36,	16,	32},
{28,	37,	36,	24,	27},
{26,	37,	36,	12,	38},
{24,	15,	34,	34,	39},
{29,	15,	36,	34,	39},
{24,	16,	32,	34,	39},
{28,	17,	29,	34,	35},
{25,	16,	34,	34,	39},
{25,	18,	35,	34,	35},
{24,	17,	7,	34,	39},
{24,	38,	35,	23,	27},
{26,	38,	35,	33,	8},
{25,	38,	35,	33,	20},
{24,	38,	35,	8,	39},
{24,	37,	36,	30,	22},
{29,	37,	36,	30,	25},
{26,	37,	36,	29,	27},
{24,	37,	36,	33,	4},
{27,	37,	36,	33,	5},
{24,	37,	36,	34,	1},
{24,	16,	36,	34,	39},
{24,	37,	36,	23,	31},
{26,	37,	36,	26,	28},
{26,	37,	36,	23,	32},
{25,	37,	36,	23,	33},
{24,	35,	34,	35,	24},
{27,	34,	34,	35,	27},
{24,	37,	34,	35,	17},
{25,	37,	34,	35,	18},
{24,	33,	35,	35,	22},
{24,	35,	35,	35,	23},
{27,	31,	35,	35,	28},
{24,	36,	35,	35,	14},
{24,	37,	36,	26,	31},
{25,	37,	36,	28,	30},
{24,	35,	32,	35,	29},
{26,	35,	33,	35,	29},
{25,	36,	33,	35,	29},
{24,	32,	34,	35,	30},
{24,	27,	34,	35,	31},
{27,	23,	14,	35,	32},
{24,	20,	35,	35,	32},
{24,	34,	29,	35,	30},
{25,	33,	34,	35,	30},
{25,	36,	33,	35,	30},
{25,	36,	33,	35,	31},
{24,	31,	35,	35,	30},
{24,	36,	34,	35,	27},
{26,	36,	34,	35,	28},
{25,	36,	34,	35,	30},
{26,	35,	34,	35,	31},
{24,	36,	35,	35,	20},
{25,	36,	35,	35,	22},
{24,	37,	36,	28,	31},
{24,	37,	36,	22,	39},
{26,	37,	36,	23,	39},
{24,	37,	36,	28,	33},
{25,	37,	36,	30,	33},
{25,	37,	36,	30,	34},
{24,	34,	36,	34,	34},
{24,	36,	36,	34,	31},
{25,	36,	36,	34,	34},
{24,	36,	34,	34,	35},
{27,	32,	36,	34,	35},
{26,	34,	36,	34,	35},
{25,	37,	34,	34,	35},
{24,	37,	36,	28,	38},
{27,	37,	36,	30,	35},
{26,	37,	36,	27,	39},
{25,	37,	36,	28,	39},
{25,	37,	36,	30,	39},
{24,	35,	36,	34,	35},
{24,	36,	36,	34,	35},
{24,	35,	35,	34,	39},
{29,	36,	34,	34,	36},
{28,	36,	34,	34,	39},
{28,	36,	35,	34,	39},
{27,	31,	36,	34,	39},
{26,	37,	34,	34,	36},
{25,	35,	36,	34,	36},
{25,	36,	36,	34,	36},
{24,	37,	35,	33,	39},
{24,	36,	36,	33,	39},
{23,	2,	0,	38,	2},
{23,	8,	2,	37,	1},
{23,	3,	0,	37,	22},
{24,	4,	3,	37,	8},
{23,	5,	0,	37,	18},
{23,	6,	11,	37,	7},
{25,	5,	12,	37,	8},
{23,	17,	4,	36,	8},
{23,	18,	11,	36,	1},
{24,	17,	17,	36,	1},
{24,	18,	9,	36,	9},
{24,	18,	11,	36,	5},
{24,	14,	16,	36,	9},
{24,	14,	9,	36,	23},
{25,	15,	3,	36,	25},
{24,	17,	9,	36,	10},
{25,	18,	5,	36,	12},
{23,	5,	10,	37,	15},
{24,	3,	7,	37,	21},
{27,	4,	11,	37,	18},
{23,	6,	23,	37,	6},
{24,	4,	21,	37,	18},
{25,	5,	23,	37,	11},
{24,	2,	15,	37,	23},
{25,	1,	15,	37,	26},
{25,	1,	24,	37,	19},
{24,	2,	22,	37,	21},
{24,	0,	24,	37,	26},
{23,	5,	28,	37,	1},
{23,	16,	11,	36,	10},
{23,	1,	33,	37,	4},
{24,	1,	32,	37,	6},
{23,	0,	35,	37,	6},
{23,	5,	22,	37,	15},
{23,	14,	16,	36,	13},
{23,	14,	11,	36,	22},
{24,	14,	16,	36,	25},
{23,	4,	18,	37,	25},
{23,	3,	8,	37,	33},
{29,	3,	15,	37,	31},
{25,	2,	15,	37,	33},
{24,	5,	1,	37,	29},
{24,	5,	10,	37,	18},
{24,	5,	6,	37,	23},
{23,	5,	1,	37,	32},
{23,	0,	0,	37,	39},
{24,	3,	0,	37,	34},
{24,	3,	5,	37,	35},
{28,	0,	13,	37,	36},
{26,	1,	3,	37,	37},
{25,	0,	15,	37,	37},
{26,	0,	12,	37,	39},
{24,	1,	12,	37,	35},
{25,	1,	12,	37,	37},
{24,	3,	12,	37,	34},
{23,	2,	0,	37,	38},
{23,	1,	25,	37,	21},
{23,	3,	27,	37,	9},
{24,	3,	25,	37,	21},
{23,	2,	30,	37,	8},
{23,	13,	3,	36,	32},
{23,	2,	12,	37,	36},
{23,	7,	36,	36,	8},
{23,	9,	36,	36,	8},
{23,	3,	16,	37,	33},
{23,	4,	16,	36,	35},
{23,	13,	34,	36,	8},
{23,	16,	34,	36,	1},
{23,	18,	33,	36,	2},
{26,	16,	15,	36,	10},
{23,	16,	30,	36,	5},
{25,	14,	20,	36,	18},
{24,	15,	22,	36,	10},
{24,	18,	32,	36,	3},
{24,	14,	24,	36,	25},
{23,	18,	35,	36,	0},
{23,	7,	16,	36,	34},
{23,	8,	6,	36,	34},
{23,	8,	12,	36,	34},
{24,	8,	25,	36,	33},
{25,	7,	27,	36,	34},
{23,	10,	12,	36,	33},
{23,	15,	9,	35,	34},
{24,	15,	32,	35,	33},
{23,	18,	7,	35,	34},
{23,	0,	21,	37,	36},
{23,	0,	24,	37,	34},
{23,	11,	13,	35,	36},
{23,	9,	32,	36,	22},
{24,	9,	34,	36,	31},
{24,	9,	35,	36,	30},
{23,	11,	28,	36,	23},
{23,	11,	18,	35,	36},
{23,	0,	37,	36,	32},
{30,	0,	37,	34,	37},
{27,	0,	37,	35,	37},
{25,	0,	37,	35,	38},
{23,	33,	36,	35,	2},
{23,	16,	22,	35,	33},
{23,	0,	37,	36,	34},
{23,	37,	35,	35,	1},
{23,	33,	36,	35,	4},
{23,	9,	36,	36,	28},
{23,	12,	36,	36,	22},
{26,	10,	36,	36,	29},
{24,	13,	33,	36,	16},
{23,	18,	36,	36,	0},
{23,	14,	29,	36,	15},
{23,	14,	29,	36,	21},
{23,	13,	31,	36,	29},
{24,	11,	35,	36,	30},
{23,	14,	27,	36,	31},
{24,	10,	20,	36,	33},
{24,	11,	14,	36,	33},
{24,	14,	30,	36,	31},
{24,	14,	33,	36,	19},
{23,	14,	15,	36,	32},
{23,	6,	34,	36,	33},
{23,	8,	28,	36,	34},
{23,	19,	23,	35,	33},
{25,	19,	35,	35,	33},
{23,	18,	10,	35,	34},
{23,	22,	9,	35,	33},
{23,	36,	36,	35,	4},
{23,	10,	33,	36,	32},
{23,	14,	32,	36,	31},
{23,	14,	36,	36,	28},
{24,	18,	36,	36,	3},
{24,	14,	35,	36,	31},
{23,	6,	35,	36,	35},
{23,	37,	36,	32,	12},
{25,	37,	36,	33,	7},
{23,	9,	34,	35,	39},
{25,	10,	35,	35,	36},
{26,	10,	35,	35,	37},
{23,	12,	33,	35,	36},
{23,	15,	33,	35,	35},
{23,	9,	36,	35,	39},
{26,	12,	36,	35,	36},
{25,	15,	36,	35,	35},
{23,	36,	36,	35,	13},
{28,	20,	36,	35,	30},
{26,	30,	36,	35,	16},
{25,	33,	36,	35,	18},
{24,	35,	36,	35,	15},
{24,	34,	36,	35,	21},
{27,	30,	36,	35,	30},
{26,	33,	36,	35,	25},
{25,	35,	36,	35,	23},
{23,	38,	35,	17,	35},
{25,	38,	35,	30,	29},
{23,	37,	36,	32,	21},
{24,	37,	36,	32,	26},
{23,	37,	35,	34,	25},
{26,	37,	35,	34,	26},
{24,	37,	36,	34,	7},
{24,	37,	35,	34,	34},
{23,	37,	36,	34,	8},
{23,	38,	35,	34,	18},
{23,	34,	33,	35,	33},
{26,	25,	35,	35,	33},
{26,	27,	36,	35,	32},
{26,	35,	32,	35,	32},
{26,	36,	33,	35,	32},
{25,	29,	36,	35,	33},
{24,	32,	34,	35,	33},
{24,	35,	34,	35,	33},
{25,	36,	34,	35,	32},
{24,	35,	35,	35,	32},
{25,	33,	36,	35,	29},
{24,	36,	34,	35,	33},
{23,	35,	36,	35,	26},
{24,	35,	36,	35,	28},
{23,	38,	35,	33,	29},
{23,	36,	35,	35,	31},
{24,	36,	35,	35,	32},
{23,	36,	36,	35,	31},
{25,	35,	36,	35,	32},
{24,	32,	36,	35,	33},
{23,	37,	34,	35,	32},
{23,	38,	35,	33,	32},
{23,	34,	36,	35,	34},
{25,	36,	34,	35,	34},
{26,	37,	34,	35,	34},
{23,	37,	36,	33,	36},
{24,	37,	36,	32,	39},
{24,	37,	36,	33,	39},
{23,	37,	36,	34,	11},
{23,	33,	36,	34,	39},
{23,	37,	34,	34,	37},
{23,	35,	36,	34,	39},
{23,	37,	34,	34,	39},
{23,	37,	35,	34,	39},
{22,	8,	2,	37,	7},
{22,	8,	8,	37,	7},
{24,	8,	13,	37,	2},
{24,	10,	11,	37,	0},
{23,	7,	20,	37,	7},
{23,	8,	15,	37,	7},
{23,	8,	30,	37,	0},
{22,	11,	12,	37,	0},
{22,	18,	5,	36,	13},
{22,	0,	37,	37,	0},
{24,	0,	37,	37,	1},
{22,	5,	2,	37,	32},
{23,	5,	6,	37,	27},
{22,	0,	36,	37,	4},
{22,	18,	18,	36,	6},
{23,	18,	19,	36,	7},
{23,	18,	36,	36,	4},
{23,	16,	35,	36,	9},
{23,	18,	27,	36,	7},
{22,	6,	0,	36,	37},
{22,	6,	1,	36,	36},
{22,	3,	17,	38,	22},
{27,	4,	9,	38,	8},
{27,	2,	6,	38,	25},
{26,	0,	19,	38,	25},
{25,	2,	1,	38,	29},
{22,	3,	19,	38,	8},
{22,	0,	1,	38,	35},
{23,	0,	6,	38,	35},
{24,	2,	7,	38,	29},
{24,	3,	14,	38,	24},
{22,	1,	0,	38,	34},
{23,	1,	4,	38,	34},
{23,	1,	4,	38,	35},
{22,	18,	6,	36,	20},
{26,	16,	4,	36,	26},
{25,	15,	9,	36,	19},
{24,	15,	21,	36,	20},
{25,	15,	27,	36,	20},
{24,	16,	19,	36,	12},
{23,	15,	9,	36,	23},
{25,	15,	5,	36,	32},
{24,	15,	26,	36,	22},
{23,	15,	35,	36,	15},
{23,	15,	35,	36,	20},
{23,	15,	33,	36,	23},
{22,	16,	11,	36,	15},
{22,	17,	14,	36,	12},
{22,	19,	11,	36,	9},
{24,	19,	6,	36,	19},
{22,	2,	13,	38,	27},
{22,	0,	34,	37,	11},
{24,	0,	30,	37,	17},
{24,	3,	27,	37,	21},
{23,	0,	36,	37,	7},
{22,	1,	34,	37,	7},
{22,	1,	35,	37,	6},
{22,	1,	36,	37,	7},
{22,	0,	36,	37,	9},
{22,	16,	12,	36,	19},
{22,	5,	23,	37,	18},
{22,	5,	17,	37,	23},
{23,	5,	18,	37,	27},
{23,	5,	23,	37,	27},
{24,	2,	26,	37,	28},
{22,	3,	18,	38,	24},
{22,	17,	23,	36,	10},
{23,	17,	35,	36,	9},
{22,	19,	36,	36,	0},
{22,	19,	18,	36,	2},
{22,	23,	33,	36,	0},
{25,	26,	15,	36,	0},
{24,	20,	8,	36,	6},
{24,	23,	35,	36,	0},
{22,	3,	21,	37,	31},
{22,	4,	17,	37,	32},
{25,	5,	21,	37,	30},
{23,	4,	14,	37,	33},
{22,	5,	12,	37,	32},
{22,	12,	6,	35,	39},
{23,	10,	24,	35,	39},
{23,	10,	32,	35,	39},
{24,	10,	36,	35,	39},
{22,	17,	30,	36,	12},
{24,	17,	36,	36,	11},
{22,	0,	29,	37,	29},
{23,	2,	28,	37,	29},
{23,	2,	30,	37,	20},
{23,	4,	28,	37,	23},
{23,	1,	34,	37,	24},
{24,	2,	30,	37,	30},
{22,	7,	28,	37,	4},
{22,	7,	18,	36,	35},
{23,	7,	31,	36,	35},
{23,	7,	35,	36,	35},
{23,	11,	32,	36,	33},
{23,	9,	35,	36,	34},
{23,	13,	2,	36,	34},
{23,	9,	36,	36,	34},
{22,	10,	9,	36,	34},
{22,	16,	25,	36,	20},
{22,	17,	21,	36,	24},
{27,	17,	26,	36,	24},
{25,	17,	36,	36,	14},
{23,	15,	8,	36,	30},
{23,	16,	17,	36,	30},
{23,	15,	19,	36,	31},
{23,	15,	32,	36,	31},
{22,	19,	7,	36,	23},
{22,	19,	9,	36,	13},
{22,	20,	7,	36,	18},
{22,	19,	9,	36,	17},
{22,	19,	12,	36,	15},
{23,	18,	14,	36,	16},
{22,	19,	10,	36,	21},
{23,	18,	14,	36,	20},
{22,	18,	21,	36,	16},
{25,	18,	32,	36,	12},
{22,	16,	7,	36,	32},
{22,	0,	23,	37,	38},
{22,	4,	28,	37,	30},
{22,	0,	32,	37,	37},
{24,	0,	33,	37,	36},
{23,	0,	34,	37,	37},
{23,	1,	34,	37,	31},
{22,	2,	37,	36,	33},
{30,	2,	37,	35,	38},
{24,	1,	37,	34,	39},
{22,	7,	35,	37,	30},
{25,	3,	36,	37,	6},
{23,	8,	2,	37,	14},
{24,	8,	35,	37,	9},
{23,	7,	12,	37,	31},
{23,	0,	36,	37,	18},
{23,	2,	36,	37,	14},
{23,	0,	35,	37,	36},
{23,	4,	35,	37,	34},
{24,	7,	35,	37,	31},
{23,	6,	0,	37,	35},
{23,	1,	24,	37,	37},
{25,	3,	20,	37,	35},
{24,	1,	35,	37,	35},
{24,	3,	32,	37,	35},
{23,	1,	34,	37,	37},
{23,	5,	35,	37,	33},
{22,	11,	1,	37,	18},
{23,	10,	1,	37,	23},
{22,	13,	2,	37,	2},
{23,	11,	9,	37,	2},
{22,	9,	5,	37,	6},
{22,	11,	5,	37,	4},
{22,	13,	3,	37,	4},
{22,	15,	3,	37,	3},
{22,	7,	36,	37,	3},
{22,	6,	18,	37,	34},
{24,	6,	29,	37,	34},
{22,	5,	19,	37,	35},
{22,	17,	32,	36,	24},
{22,	17,	35,	36,	18},
{22,	0,	35,	37,	38},
{22,	0,	37,	36,	37},
{23,	0,	36,	36,	39},
{22,	17,	32,	36,	25},
{23,	17,	5,	36,	31},
{22,	2,	37,	36,	35},
{24,	1,	37,	36,	37},
{22,	1,	35,	36,	39},
{22,	6,	34,	37,	34},
{22,	4,	33,	36,	39},
{29,	4,	35,	36,	39},
{26,	6,	4,	36,	38},
{24,	7,	2,	36,	39},
{24,	2,	14,	37,	37},
{23,	3,	36,	36,	37},
{22,	3,	1,	37,	37},
{23,	6,	0,	37,	38},
{22,	12,	36,	35,	39},
{22,	14,	36,	35,	39},
{22,	15,	7,	35,	36},
{22,	37,	35,	35,	18},
{23,	38,	35,	35,	17},
{24,	38,	35,	35,	20},
{23,	37,	35,	35,	22},
{23,	37,	35,	35,	34},
{23,	35,	36,	35,	34},
{22,	38,	35,	20,	38},
{22,	36,	36,	36,	24},
{27,	19,	31,	36,	25},
{24,	22,	20,	36,	25},
{22,	26,	15,	36,	25},
{22,	27,	20,	36,	25},
{22,	27,	23,	36,	26},
{23,	20,	36,	36,	25},
{24,	15,	36,	36,	31},
{23,	18,	35,	36,	26},
{23,	16,	35,	36,	28},
{23,	20,	25,	36,	27},
{22,	20,	28,	36,	31},
{27,	20,	36,	36,	28},
{23,	19,	8,	36,	32},
{23,	21,	15,	36,	28},
{23,	23,	11,	36,	28},
{23,	22,	24,	36,	28},
{23,	27,	17,	36,	27},
{23,	27,	21,	36,	27},
{23,	26,	29,	36,	27},
{24,	27,	36,	36,	25},
{23,	22,	36,	36,	27},
{24,	26,	36,	36,	27},
{22,	20,	12,	36,	32},
{23,	15,	22,	36,	32},
{22,	37,	34,	36,	9},
{22,	18,	31,	36,	31},
{24,	17,	36,	36,	31},
{22,	37,	34,	36,	13},
{23,	37,	34,	36,	16},
{22,	22,	35,	36,	28},
{22,	37,	34,	36,	23},
{22,	35,	35,	36,	25},
{25,	36,	36,	36,	25},
{22,	32,	36,	36,	26},
{25,	35,	32,	36,	26},
{22,	29,	21,	36,	27},
{22,	36,	34,	36,	26},
{22,	35,	35,	36,	26},
{22,	36,	36,	36,	28},
{22,	25,	36,	36,	29},
{23,	28,	18,	36,	29},
{22,	20,	36,	36,	30},
{22,	25,	35,	36,	30},
{22,	28,	18,	36,	30},
{22,	36,	36,	35,	34},
{22,	36,	37,	34,	37},
{36,	30,	37,	32,	39},
{34,	36,	37,	24,	39},
{30,	34,	37,	32,	38},
{29,	5,	37,	35,	25},
{28,	5,	37,	35,	38},
{27,	7,	37,	35,	30},
{27,	19,	37,	34,	38},
{27,	36,	37,	29,	38},
{27,	35,	37,	29,	39},
{26,	33,	37,	31,	39},
{26,	36,	37,	29,	39},
{26,	35,	37,	32,	38},
{26,	36,	37,	31,	39},
{28,	35,	37,	32,	39},
{26,	36,	37,	33,	38},
{26,	36,	37,	32,	39},
{25,	4,	37,	36,	5},
{26,	3,	37,	36,	34},
{25,	4,	37,	36,	34},
{25,	17,	37,	34,	39},
{25,	21,	37,	34,	39},
{24,	10,	37,	35,	6},
{25,	15,	37,	35,	3},
{25,	11,	37,	36,	0},
{26,	5,	37,	36,	34},
{25,	13,	37,	35,	12},
{24,	7,	37,	36,	11},
{24,	6,	37,	36,	33},
{24,	7,	37,	35,	38},
{24,	7,	37,	36,	34},
{24,	30,	37,	33,	39},
{24,	29,	37,	34,	39},
{24,	32,	37,	34,	38},
{24,	32,	37,	33,	39},
{24,	36,	36,	34,	38},
{24,	35,	37,	33,	39},
{24,	33,	37,	34,	39},
{25,	35,	37,	34,	38},
{23,	23,	37,	35,	10},
{23,	26,	37,	35,	2},
{23,	11,	37,	35,	36},
{24,	21,	37,	35,	14},
{24,	21,	37,	35,	29},
{26,	23,	37,	35,	30},
{25,	12,	37,	35,	38},
{25,	14,	37,	35,	38},
{23,	10,	37,	36,	13},
{26,	9,	37,	36,	34},
{23,	26,	37,	35,	22},
{23,	23,	37,	35,	32},
{23,	35,	37,	34,	39},
{22,	26,	37,	36,	5},
{24,	16,	37,	36,	10},
{23,	13,	37,	36,	16},
{23,	12,	37,	36,	24},
{22,	17,	37,	36,	20},
{23,	15,	37,	36,	26},
{23,	13,	37,	36,	31},
{22,	7,	37,	36,	35},
{22,	26,	37,	35,	32},
{22,	37,	36,	34,	38},
{25,	37,	36,	34,	39},
{23,	36,	37,	34,	39},
{22,	36,	36,	35,	39},
{26,	37,	34,	35,	35},
{24,	37,	34,	35,	39},
{22,	15,	37,	35,	39},
{24,	19,	37,	35,	35},
{23,	22,	37,	35,	35},
{22,	0,	37,	36,	39},
{22,	21,	37,	35,	39},
{22,	26,	37,	35,	35},
{23,	24,	37,	35,	39},
{22,	35,	37,	35,	39},
{22,	36,	37,	35,	0},
{22,	36,	37,	35,	5},
{22,	36,	37,	35,	21},
{21,	6,	0,	38,	9},
{22,	5,	19,	38,	1},
{23,	7,	5,	38,	1},
{21,	10,	3,	38,	0},
{21,	10,	1,	37,	26},
{21,	9,	11,	37,	18},
{24,	10,	9,	37,	7},
{23,	8,	25,	37,	13},
{22,	8,	21,	37,	17},
{21,	1,	37,	37,	1},
{21,	2,	6,	38,	31},
{21,	9,	9,	37,	23},
{24,	8,	5,	37,	29},
{22,	9,	5,	37,	27},
{22,	8,	20,	37,	23},
{22,	9,	22,	37,	19},
{24,	9,	31,	37,	8},
{23,	11,	28,	37,	1},
{23,	9,	21,	37,	22},
{22,	10,	21,	37,	4},
{21,	11,	19,	37,	3},
{21,	10,	23,	37,	6},
{21,	2,	13,	38,	35},
{21,	7,	36,	37,	9},
{25,	4,	36,	37,	18},
{21,	1,	37,	37,	15},
{23,	1,	37,	37,	18},
{21,	3,	37,	37,	16},
{21,	5,	37,	37,	0},
{21,	4,	37,	37,	18},
{21,	7,	21,	37,	35},
{25,	7,	35,	37,	34},
{21,	6,	1,	37,	36},
{21,	9,	3,	37,	32},
{21,	9,	5,	37,	32},
{21,	4,	37,	37,	22},
{24,	3,	36,	37,	25},
{22,	5,	36,	37,	25},
{21,	6,	36,	37,	23},
{22,	8,	36,	37,	10},
{21,	9,	36,	37,	1},
{22,	9,	34,	37,	10},
{21,	7,	36,	37,	25},
{21,	7,	37,	37,	15},
{22,	5,	37,	37,	23},
{21,	9,	37,	37,	1},
{21,	2,	37,	37,	31},
{26,	5,	37,	37,	30},
{23,	0,	36,	37,	38},
{22,	4,	36,	37,	33},
{21,	6,	28,	36,	38},
{26,	6,	33,	36,	38},
{22,	5,	35,	36,	38},
{22,	6,	35,	36,	39},
{21,	0,	37,	37,	34},
{21,	10,	29,	36,	34},
{21,	0,	37,	37,	36},
{21,	0,	36,	37,	39},
{21,	0,	38,	36,	39},
{21,	3,	38,	35,	36},
{29,	3,	38,	34,	39},
{24,	1,	38,	36,	8},
{23,	3,	38,	35,	38},
{21,	1,	38,	37,	10},
{23,	1,	38,	36,	25},
{21,	7,	34,	36,	36},
{21,	3,	38,	36,	39},
{23,	2,	38,	37,	6},
{21,	4,	38,	36,	39},
{21,	10,	37,	36,	34},
{21,	6,	37,	36,	39},
{21,	17,	37,	36,	30},
{21,	19,	37,	36,	27},
{21,	24,	37,	36,	8},
{21,	28,	28,	36,	30},
{24,	28,	35,	36,	29},
{23,	28,	34,	36,	30},
{21,	18,	37,	36,	31},
{21,	35,	34,	36,	29},
{25,	33,	36,	36,	29},
{25,	35,	36,	36,	29},
{21,	35,	34,	36,	30},
{21,	38,	35,	35,	27},
{21,	36,	34,	36,	30},
{21,	36,	36,	36,	32},
{22,	19,	37,	36,	32},
{21,	16,	35,	36,	33},
{21,	18,	6,	36,	33},
{21,	17,	36,	36,	33},
{21,	33,	37,	36,	32},
{23,	34,	37,	36,	6},
{21,	35,	37,	36,	6},
{21,	37,	34,	36,	32},
{21,	37,	35,	35,	35},
{22,	37,	35,	35,	39},
{21,	38,	35,	31,	39},
{23,	38,	35,	32,	39},
{21,	38,	35,	35,	35},
{23,	38,	35,	34,	39},
{21,	36,	38,	35,	39},
{23,	6,	38,	36,	21},
{24,	6,	38,	36,	35},
{21,	9,	38,	36,	34},
{23,	11,	38,	36,	7},
{22,	10,	38,	36,	33},
{21,	14,	38,	36,	2},
{21,	6,	38,	36,	37},
{20,	0,	1,	39,	3},
{21,	4,	1,	39,	2},
{20,	5,	3,	39,	1},
{20,	12,	4,	37,	5},
{20,	12,	6,	37,	2},
{20,	15,	6,	37,	2},
{23,	14,	5,	37,	5},
{21,	14,	9,	37,	0},
{21,	16,	4,	37,	3},
{22,	18,	5,	37,	2},
{20,	4,	5,	38,	13},
{21,	4,	6,	38,	15},
{22,	5,	0,	38,	23},
{21,	4,	10,	38,	15},
{21,	4,	14,	38,	14},
{20,	18,	6,	37,	1},
{22,	18,	9,	37,	0},
{20,	18,	10,	37,	0},
{20,	4,	5,	38,	26},
{22,	3,	19,	38,	25},
{20,	4,	1,	38,	29},
{21,	3,	9,	38,	29},
{20,	10,	2,	37,	24},
{20,	10,	15,	37,	11},
{21,	10,	13,	37,	22},
{22,	10,	6,	37,	25},
{21,	10,	9,	37,	25},
{21,	8,	12,	37,	27},
{22,	9,	9,	37,	29},
{22,	8,	7,	37,	33},
{22,	10,	1,	37,	34},
{22,	8,	18,	37,	29},
{21,	8,	6,	37,	34},
{21,	8,	23,	37,	28},
{21,	8,	36,	37,	28},
{20,	11,	3,	37,	16},
{21,	11,	4,	37,	17},
{21,	13,	4,	37,	14},
{22,	13,	3,	37,	17},
{20,	13,	5,	37,	13},
{21,	11,	5,	37,	19},
{20,	12,	6,	37,	9},
{21,	11,	14,	37,	6},
{21,	11,	9,	37,	19},
{21,	11,	12,	37,	13},
{21,	11,	6,	37,	21},
{21,	11,	5,	37,	23},
{21,	11,	3,	37,	26},
{21,	12,	6,	37,	24},
{20,	1,	2,	37,	39},
{21,	2,	8,	37,	38},
{21,	1,	32,	37,	39},
{21,	2,	14,	37,	39},
{21,	5,	1,	37,	39},
{21,	4,	2,	37,	38},
{21,	4,	3,	37,	39},
{23,	3,	14,	37,	36},
{21,	1,	36,	37,	39},
{22,	3,	36,	37,	35},
{21,	1,	38,	37,	35},
{21,	7,	36,	37,	34},
{21,	5,	37,	37,	32},
{20,	10,	21,	37,	11},
{21,	10,	20,	37,	15},
{20,	10,	16,	37,	22},
{21,	10,	20,	37,	22},
{20,	3,	12,	38,	35},
{21,	3,	19,	38,	29},
{22,	0,	18,	38,	34},
{21,	3,	19,	38,	31},
{20,	11,	7,	36,	34},
{20,	0,	14,	38,	37},
{21,	1,	6,	38,	36},
{21,	1,	3,	38,	37},
{21,	3,	3,	38,	37},
{20,	3,	4,	38,	37},
{20,	2,	6,	38,	37},
{20,	16,	35,	37,	2},
{25,	12,	12,	37,	11},
{23,	13,	36,	37,	2},
{23,	17,	35,	37,	0},
{23,	10,	32,	37,	10},
{22,	13,	11,	37,	11},
{22,	13,	32,	37,	3},
{22,	17,	32,	37,	1},
{21,	11,	37,	37,	1},
{21,	11,	30,	37,	10},
{22,	12,	17,	37,	10},
{22,	13,	24,	37,	5},
{21,	12,	18,	37,	13},
{22,	12,	19,	37,	14},
{21,	12,	7,	37,	24},
{21,	12,	22,	37,	13},
{21,	12,	20,	37,	15},
{21,	12,	10,	37,	20},
{21,	16,	37,	37,	1},
{21,	11,	36,	37,	20},
{24,	11,	36,	37,	21},
{22,	11,	30,	37,	22},
{21,	14,	36,	37,	4},
{21,	11,	19,	37,	24},
{21,	12,	23,	37,	20},
{21,	12,	21,	37,	24},
{22,	12,	36,	37,	21},
{21,	14,	30,	37,	5},
{21,	12,	36,	37,	22},
{20,	20,	10,	37,	2},
{21,	18,	13,	37,	2},
{20,	12,	9,	37,	25},
{20,	4,	13,	37,	39},
{20,	5,	8,	37,	38},
{23,	7,	4,	37,	36},
{20,	3,	23,	38,	30},
{25,	5,	28,	38,	1},
{22,	0,	23,	38,	34},
{21,	0,	31,	38,	2},
{22,	3,	30,	38,	3},
{21,	0,	22,	38,	37},
{21,	0,	24,	38,	37},
{21,	3,	25,	38,	11},
{21,	2,	27,	38,	18},
{22,	3,	29,	38,	10},
{22,	0,	28,	38,	24},
{21,	0,	33,	38,	20},
{23,	3,	34,	38,	0},
{21,	4,	30,	38,	5},
{21,	1,	32,	38,	15},
{22,	2,	34,	38,	3},
{21,	0,	25,	38,	37},
{20,	3,	35,	38,	1},
{22,	3,	35,	38,	3},
{20,	3,	36,	38,	1},
{22,	1,	36,	38,	3},
{20,	0,	36,	38,	4},
{20,	4,	27,	38,	12},
{20,	2,	32,	38,	16},
{20,	2,	33,	38,	14},
{20,	1,	36,	38,	6},
{20,	2,	32,	38,	19},
{20,	12,	37,	37,	13},
{24,	10,	37,	37,	19},
{21,	6,	37,	37,	32},
{21,	6,	37,	37,	33},
{20,	0,	28,	38,	35},
{22,	0,	32,	38,	33},
{21,	0,	27,	38,	37},
{20,	2,	26,	37,	39},
{20,	4,	20,	37,	39},
{20,	2,	34,	38,	31},
{22,	0,	34,	38,	34},
{21,	3,	27,	38,	29},
{20,	4,	27,	38,	15},
{20,	2,	29,	37,	38},
{20,	8,	28,	37,	34},
{23,	8,	36,	37,	33},
{20,	9,	9,	37,	32},
{20,	11,	30,	37,	30},
{26,	11,	35,	37,	29},
{24,	12,	36,	37,	25},
{21,	9,	15,	37,	34},
{20,	12,	6,	37,	27},
{20,	9,	28,	37,	34},
{22,	9,	36,	37,	32},
{20,	18,	23,	36,	33},
{21,	18,	35,	36,	33},
{20,	5,	34,	37,	35},
{21,	5,	36,	37,	35},
{21,	4,	35,	37,	38},
{22,	4,	31,	37,	39},
{21,	2,	36,	37,	38},
{21,	5,	36,	37,	36},
{20,	5,	33,	37,	39},
{21,	5,	35,	37,	39},
{20,	13,	38,	36,	28},
{20,	26,	38,	36,	4},
{21,	27,	38,	36,	4},
{21,	20,	38,	36,	20},
{23,	24,	38,	36,	11},
{20,	23,	38,	36,	15},
{20,	35,	37,	36,	7},
{20,	18,	28,	36,	34},
{27,	14,	36,	36,	34},
{24,	18,	36,	36,	34},
{21,	11,	38,	36,	34},
{21,	16,	38,	36,	31},
{21,	19,	36,	36,	34},
{20,	38,	35,	36,	9},
{21,	37,	35,	36,	15},
{22,	37,	35,	36,	19},
{23,	37,	35,	36,	22},
{21,	38,	35,	36,	20},
{21,	37,	35,	36,	23},
{20,	5,	38,	36,	39},
{20,	9,	35,	36,	39},
{25,	9,	37,	36,	36},
{24,	8,	36,	36,	39},
{21,	11,	1,	36,	38},
{21,	8,	37,	36,	38},
{21,	9,	37,	36,	38},
{21,	8,	37,	36,	39},
{20,	11,	4,	36,	36},
{20,	11,	3,	36,	37},
{22,	12,	2,	36,	38},
{20,	13,	2,	36,	39},
{20,	10,	25,	36,	35},
{23,	11,	7,	36,	36},
{22,	10,	35,	36,	35},
{20,	10,	34,	36,	36},
{20,	23,	27,	36,	33},
{24,	23,	33,	36,	33},
{21,	23,	35,	36,	33},
{20,	6,	38,	36,	39},
{20,	37,	36,	35,	12},
{23,	37,	36,	35,	13},
{21,	37,	36,	36,	0},
{21,	37,	36,	35,	32},
{22,	37,	36,	35,	34},
{21,	37,	36,	35,	35},
{20,	36,	37,	36,	11},
{21,	36,	37,	36,	16},
{20,	8,	38,	36,	38},
{20,	10,	38,	36,	35},
{21,	10,	37,	36,	39},
{20,	13,	34,	36,	38},
{26,	13,	36,	36,	36},
{24,	11,	37,	36,	38},
{21,	14,	3,	36,	36},
{21,	11,	38,	36,	36},
{21,	12,	35,	36,	39},
{21,	13,	30,	36,	39},
{21,	11,	37,	36,	39},
{20,	14,	13,	36,	35},
{20,	14,	36,	36,	35},
{20,	12,	38,	36,	36},
{22,	16,	38,	36,	33},
{21,	12,	37,	36,	39},
{21,	13,	36,	36,	38},
{21,	12,	38,	36,	37},
{21,	12,	38,	36,	38},
{20,	13,	36,	36,	39},
{20,	12,	38,	36,	39},
{20,	35,	37,	36,	17},
{20,	37,	37,	25,	27},
{24,	37,	37,	5,	29},
{22,	37,	37,	28,	3},
{23,	37,	37,	31,	2},
{23,	37,	37,	32,	1},
{22,	37,	37,	8,	29},
{21,	37,	37,	34,	0},
{21,	37,	37,	8,	38},
{21,	37,	37,	21,	39},
{25,	37,	37,	25,	29},
{23,	37,	37,	22,	39},
{22,	37,	37,	25,	30},
{22,	37,	37,	23,	39},
{21,	37,	37,	25,	31},
{20,	37,	37,	35,	0},
{20,	37,	37,	36,	0},
{20,	37,	37,	28,	8},
{20,	37,	37,	29,	25},
{21,	37,	37,	26,	28},
{21,	37,	37,	29,	27},
{21,	37,	37,	28,	29},
{21,	37,	37,	28,	31},
{21,	37,	37,	29,	31},
{20,	33,	38,	36,	22},
{20,	36,	38,	36,	4},
{23,	35,	38,	36,	6},
{23,	35,	38,	36,	8},
{23,	34,	38,	36,	17},
{20,	37,	37,	24,	34},
{22,	37,	37,	24,	35},
{21,	37,	37,	25,	34},
{20,	36,	37,	36,	25},
{22,	34,	38,	36,	22},
{21,	36,	37,	36,	30},
{22,	35,	37,	36,	31},
{20,	32,	38,	36,	28},
{21,	29,	38,	36,	29},
{21,	18,	38,	36,	33},
{21,	24,	38,	36,	31},
{20,	27,	38,	36,	31},
{20,	37,	35,	36,	26},
{22,	37,	35,	36,	27},
{20,	34,	38,	36,	27},
{21,	34,	38,	36,	31},
{20,	37,	37,	25,	36},
{21,	37,	37,	25,	39},
{20,	37,	37,	29,	33},
{20,	37,	37,	27,	34},
{21,	37,	37,	26,	39},
{20,	37,	35,	36,	29},
{20,	33,	36,	36,	33},
{21,	37,	34,	36,	33},
{20,	32,	37,	36,	33},
{20,	31,	38,	36,	33},
{21,	33,	38,	36,	33},
{21,	34,	38,	36,	32},
{20,	37,	37,	27,	37},
{20,	36,	34,	36,	34},
{24,	33,	35,	36,	34},
{24,	37,	34,	36,	34},
{23,	25,	36,	36,	34},
{22,	29,	36,	36,	34},
{22,	32,	38,	36,	34},
{22,	36,	35,	36,	34},
{21,	34,	38,	36,	33},
{21,	34,	36,	36,	34},
{20,	13,	38,	36,	38},
{21,	13,	38,	36,	39},
{20,	37,	35,	36,	32},
{21,	37,	35,	36,	34},
{20,	37,	37,	29,	37},
{20,	35,	37,	36,	32},
{20,	37,	37,	27,	39},
{20,	37,	37,	30,	37},
{21,	37,	37,	30,	39},
{20,	37,	37,	31,	4},
{20,	35,	36,	36,	34},
{20,	37,	37,	31,	37},
{21,	37,	37,	31,	39},
{20,	37,	37,	32,	33},
{20,	37,	37,	34,	7},
{23,	37,	37,	34,	8},
{20,	37,	37,	32,	39},
{20,	38,	35,	35,	37},
{20,	37,	37,	33,	39},
{20,	37,	36,	35,	39},
{19,	2,	0,	39,	6},
{19,	0,	7,	39,	4},
{19,	10,	1,	38,	2},
{21,	7,	5,	38,	3},
{20,	5,	21,	38,	5},
{20,	5,	13,	38,	7},
{20,	5,	12,	38,	23},
{21,	5,	8,	38,	27},
{21,	5,	3,	38,	30},
{20,	5,	17,	38,	14},
{21,	5,	23,	38,	13},
{21,	5,	16,	38,	20},
{20,	5,	7,	38,	30},
{20,	5,	7,	38,	31},
{20,	4,	25,	38,	20},
{20,	5,	21,	38,	23},
{19,	8,	12,	38,	0},
{22,	7,	30,	38,	0},
{21,	6,	26,	38,	2},
{21,	7,	13,	38,	3},
{20,	7,	13,	38,	5},
{19,	6,	7,	38,	10},
{20,	6,	4,	38,	13},
{21,	6,	12,	38,	12},
{19,	9,	14,	38,	0},
{19,	18,	6,	37,	5},
{20,	16,	9,	37,	5},
{20,	20,	9,	37,	3},
{19,	7,	17,	38,	5},
{19,	22,	10,	37,	1},
{20,	22,	11,	37,	1},
{19,	22,	10,	37,	2},
{20,	21,	12,	37,	2},
{20,	20,	14,	37,	1},
{21,	21,	16,	37,	0},
{19,	2,	31,	39,	0},
{20,	5,	6,	39,	2},
{19,	13,	3,	37,	20},
{19,	6,	17,	38,	12},
{20,	6,	23,	38,	11},
{19,	0,	35,	39,	0},
{19,	1,	36,	39,	0},
{20,	3,	36,	39,	0},
{19,	1,	37,	38,	1},
{22,	3,	37,	38,	0},
{20,	1,	37,	38,	2},
{20,	3,	37,	39,	0},
{19,	1,	38,	38,	1},
{19,	0,	36,	39,	3},
{20,	1,	15,	39,	4},
{19,	1,	37,	38,	4},
{19,	1,	3,	38,	39},
{23,	0,	17,	38,	38},
{20,	3,	3,	38,	38},
{20,	0,	15,	38,	39},
{20,	0,	34,	38,	38},
{19,	5,	36,	38,	2},
{20,	6,	37,	38,	0},
{19,	2,	35,	38,	7},
{19,	6,	37,	38,	2},
{19,	8,	38,	37,	1},
{22,	11,	38,	37,	1},
{20,	16,	38,	37,	0},
{20,	17,	38,	37,	0},
{19,	6,	4,	37,	37},
{19,	18,	26,	37,	5},
{22,	15,	37,	37,	4},
{21,	19,	30,	37,	0},
{20,	20,	10,	37,	5},
{20,	21,	21,	37,	0},
{19,	20,	12,	37,	5},
{19,	1,	11,	38,	36},
{19,	1,	8,	38,	39},
{19,	13,	31,	37,	6},
{20,	13,	15,	37,	11},
{19,	13,	15,	37,	12},
{19,	7,	12,	37,	36},
{20,	6,	20,	37,	36},
{19,	6,	6,	37,	38},
{19,	7,	6,	37,	38},
{19,	3,	16,	38,	35},
{20,	2,	17,	38,	37},
{21,	3,	23,	38,	33},
{20,	2,	13,	38,	38},
{19,	2,	11,	38,	39},
{19,	15,	3,	36,	38},
{19,	4,	28,	38,	22},
{19,	20,	35,	37,	1},
{22,	19,	20,	37,	5},
{21,	18,	38,	37,	0},
{19,	22,	24,	37,	0},
{19,	14,	6,	36,	38},
{19,	18,	38,	37,	1},
{19,	15,	38,	37,	4},
{19,	16,	38,	37,	3},
{19,	19,	32,	37,	3},
{19,	2,	18,	38,	37},
{20,	3,	23,	38,	34},
{20,	1,	34,	38,	34},
{22,	3,	25,	38,	35},
{20,	3,	29,	38,	33},
{21,	3,	31,	38,	33},
{20,	1,	33,	38,	35},
{19,	4,	33,	38,	16},
{19,	4,	35,	38,	7},
{19,	5,	35,	38,	5},
{19,	7,	14,	37,	38},
{20,	7,	18,	37,	37},
{19,	8,	7,	37,	37},
{22,	8,	15,	37,	35},
{21,	8,	10,	37,	37},
{19,	10,	1,	37,	35},
{20,	9,	4,	37,	37},
{19,	7,	10,	37,	39},
{19,	8,	15,	37,	36},
{19,	0,	37,	38,	22},
{21,	5,	35,	38,	8},
{19,	2,	37,	38,	6},
{19,	5,	27,	38,	17},
{19,	5,	33,	38,	16},
{19,	6,	37,	38,	10},
{23,	2,	35,	38,	21},
{21,	2,	37,	38,	12},
{22,	4,	36,	38,	13},
{20,	5,	35,	38,	16},
{22,	3,	35,	38,	23},
{19,	1,	36,	38,	19},
{19,	1,	37,	38,	16},
{19,	3,	36,	38,	16},
{20,	2,	36,	38,	22},
{19,	13,	37,	37,	10},
{21,	13,	35,	37,	12},
{20,	16,	35,	37,	5},
{19,	13,	23,	37,	20},
{22,	13,	32,	37,	19},
{20,	13,	7,	37,	25},
{20,	13,	5,	37,	29},
{20,	13,	11,	37,	23},
{19,	17,	12,	37,	24},
{26,	18,	8,	37,	14},
{24,	14,	19,	37,	13},
{23,	19,	6,	37,	16},
{23,	14,	28,	37,	12},
{22,	19,	12,	37,	7},
{22,	17,	17,	37,	7},
{22,	16,	28,	37,	7},
{22,	14,	22,	37,	16},
{21,	16,	13,	37,	17},
{21,	14,	11,	37,	25},
{21,	14,	14,	37,	23},
{20,	15,	37,	37,	6},
{20,	14,	35,	37,	13},
{20,	14,	35,	37,	15},
{19,	17,	18,	37,	8},
{20,	16,	26,	37,	10},
{21,	15,	37,	37,	8},
{21,	15,	34,	37,	11},
{20,	17,	14,	37,	17},
{20,	15,	35,	37,	12},
{19,	18,	15,	37,	8},
{19,	15,	5,	37,	27},
{19,	14,	3,	37,	30},
{19,	14,	18,	37,	20},
{19,	13,	16,	37,	25},
{19,	1,	38,	38,	21},
{19,	4,	38,	38,	4},
{19,	6,	38,	38,	1},
{19,	2,	37,	38,	18},
{20,	2,	38,	38,	33},
{21,	1,	35,	38,	34},
{20,	9,	38,	37,	15},
{23,	5,	38,	37,	23},
{22,	4,	38,	37,	31},
{20,	6,	38,	38,	5},
{20,	16,	38,	37,	5},
{20,	8,	38,	37,	20},
{21,	6,	38,	37,	29},
{19,	8,	20,	37,	35},
{19,	9,	19,	37,	35},
{19,	17,	35,	37,	12},
{22,	19,	33,	37,	5},
{21,	18,	23,	37,	8},
{22,	18,	36,	37,	6},
{19,	19,	20,	37,	7},
{20,	19,	35,	37,	6},
{19,	17,	15,	37,	17},
{19,	16,	25,	37,	15},
{21,	16,	21,	37,	17},
{21,	17,	34,	37,	13},
{21,	16,	35,	37,	15},
{19,	18,	35,	37,	8},
{19,	13,	23,	37,	29},
{21,	12,	35,	37,	28},
{20,	14,	18,	37,	26},
{20,	14,	21,	37,	25},
{20,	14,	35,	37,	28},
{20,	16,	34,	37,	16},
{20,	16,	32,	37,	17},
{20,	13,	30,	37,	30},
{21,	13,	35,	37,	30},
{19,	6,	27,	37,	35},
{20,	7,	29,	37,	35},
{20,	9,	24,	37,	35},
{19,	3,	32,	38,	35},
{19,	6,	36,	38,	30},
{22,	6,	17,	38,	31},
{19,	7,	17,	38,	29},
{21,	7,	20,	38,	17},
{21,	7,	13,	38,	31},
{19,	11,	1,	38,	6},
{19,	7,	0,	38,	35},
{19,	5,	1,	38,	35},
{19,	6,	0,	38,	36},
{19,	7,	20,	38,	29},
{19,	7,	23,	38,	24},
{19,	7,	35,	38,	18},
{21,	7,	36,	38,	21},
{21,	7,	37,	38,	6},
{19,	11,	37,	38,	0},
{19,	6,	29,	38,	31},
{19,	7,	31,	38,	30},
{19,	7,	32,	38,	31},
{19,	4,	38,	38,	30},
{21,	6,	37,	38,	15},
{21,	6,	37,	38,	22},
{21,	5,	38,	38,	17},
{20,	4,	38,	38,	31},
{19,	0,	35,	38,	37},
{22,	2,	35,	38,	35},
{20,	0,	35,	38,	38},
{19,	2,	36,	38,	34},
{19,	1,	38,	38,	34},
{19,	0,	38,	37,	36},
{19,	1,	37,	37,	36},
{19,	0,	37,	37,	38},
{19,	2,	39,	36,	36},
{25,	2,	39,	30,	39},
{20,	0,	39,	35,	39},
{23,	0,	39,	36,	38},
{23,	1,	39,	35,	39},
{22,	2,	39,	35,	39},
{20,	6,	39,	36,	39},
{19,	0,	37,	37,	39},
{19,	1,	37,	37,	38},
{21,	1,	37,	37,	39},
{19,	7,	35,	37,	35},
{19,	6,	35,	37,	36},
{19,	2,	37,	37,	39},
{22,	3,	38,	37,	34},
{20,	3,	37,	37,	36},
{20,	4,	38,	37,	34},
{20,	6,	38,	37,	34},
{19,	5,	37,	37,	35},
{20,	4,	37,	37,	39},
{19,	4,	38,	37,	36},
{19,	1,	38,	37,	39},
{22,	4,	38,	37,	37},
{20,	5,	38,	37,	37},
{19,	7,	36,	37,	35},
{20,	6,	37,	37,	36},
{19,	37,	36,	36,	7},
{21,	37,	36,	36,	8},
{20,	37,	36,	36,	33},
{19,	9,	36,	37,	34},
{19,	8,	36,	37,	35},
{20,	9,	33,	37,	35},
{19,	8,	25,	37,	36},
{21,	7,	35,	37,	36},
{19,	8,	32,	37,	36},
{19,	7,	36,	37,	37},
{20,	7,	31,	37,	38},
{20,	6,	32,	37,	39},
{19,	4,	38,	37,	38},
{20,	4,	38,	37,	39},
{19,	6,	38,	37,	36},
{19,	6,	36,	37,	39},
{20,	5,	37,	37,	39},
{20,	7,	36,	37,	38},
{19,	8,	38,	37,	36},
{20,	9,	38,	37,	24},
{19,	11,	37,	37,	25},
{20,	12,	37,	37,	25},
{19,	13,	37,	37,	24},
{19,	16,	36,	37,	11},
{19,	13,	36,	37,	28},
{19,	7,	37,	37,	37},
{20,	6,	37,	37,	39},
{19,	8,	36,	37,	38},
{19,	9,	4,	37,	39},
{19,	37,	37,	34,	12},
{21,	37,	37,	34,	13},
{19,	8,	36,	37,	39},
{19,	7,	38,	37,	39},
{22,	8,	38,	37,	38},
{19,	14,	34,	36,	39},
{21,	14,	37,	36,	36},
{20,	14,	36,	36,	39},
{21,	14,	38,	36,	38},
{19,	36,	38,	36,	16},
{22,	35,	38,	36,	19},
{20,	35,	38,	36,	31},
{20,	36,	38,	36,	28},
{20,	35,	38,	36,	32},
{20,	35,	38,	36,	33},
{19,	16,	36,	36,	39},
{22,	15,	38,	36,	38},
{21,	16,	38,	36,	36},
{20,	17,	17,	36,	35},
{20,	17,	37,	36,	35},
{19,	16,	37,	36,	38},
{20,	16,	37,	36,	39},
{21,	15,	38,	36,	39},
{19,	16,	38,	36,	38},
{19,	37,	37,	34,	33},
{22,	37,	37,	34,	34},
{20,	37,	37,	34,	39},
{19,	37,	37,	35,	15},
{19,	36,	36,	36,	35},
{22,	19,	38,	36,	35},
{21,	32,	38,	36,	35},
{20,	37,	34,	36,	35},
{20,	37,	35,	36,	35},
{20,	35,	38,	36,	35},
{19,	36,	38,	36,	33},
{20,	36,	37,	36,	35},
{22,	36,	38,	36,	34},
{20,	36,	38,	36,	35},
{19,	37,	36,	36,	34},
{19,	37,	36,	36,	39},
{24,	22,	37,	36,	36},
{23,	22,	38,	36,	36},
{21,	19,	37,	36,	39},
{23,	21,	37,	36,	38},
{21,	19,	38,	36,	37},
{21,	35,	37,	36,	36},
{21,	26,	38,	36,	36},
{22,	30,	38,	36,	36},
{20,	34,	38,	36,	36},
{20,	34,	37,	36,	39},
{24,	35,	37,	36,	37},
{23,	35,	37,	36,	38},
{20,	28,	38,	36,	39},
{21,	34,	38,	36,	39},
{21,	35,	38,	36,	37},
{20,	35,	37,	36,	39},
{20,	35,	38,	36,	39},
{19,	37,	37,	35,	39},
{19,	36,	37,	36,	39},
{19,	36,	38,	36,	39},
{18,	1,	14,	39,	7},
{18,	10,	1,	38,	12},
{18,	10,	2,	38,	7},
{19,	10,	28,	38,	2},
{21,	8,	35,	38,	3},
{21,	10,	36,	38,	2},
{20,	11,	10,	38,	2},
{19,	8,	7,	38,	25},
{22,	8,	12,	38,	13},
{21,	11,	4,	38,	5},
{21,	8,	26,	38,	7},
{20,	9,	6,	38,	9},
{20,	11,	4,	38,	9},
{20,	9,	6,	38,	13},
{20,	9,	6,	38,	16},
{20,	11,	4,	38,	16},
{20,	9,	8,	38,	14},
{20,	8,	20,	38,	12},
{20,	8,	3,	38,	30},
{19,	8,	1,	38,	33},
{19,	8,	7,	38,	30},
{19,	8,	36,	38,	6},
{18,	8,	3,	39,	1},
{19,	6,	9,	39,	2},
{18,	6,	13,	39,	1},
{19,	2,	32,	39,	2},
{18,	10,	9,	38,	10},
{20,	10,	9,	38,	14},
{19,	9,	34,	38,	5},
{20,	11,	11,	38,	5},
{18,	0,	21,	39,	7},
{20,	0,	32,	39,	6},
{19,	0,	35,	39,	5},
{18,	20,	7,	37,	8},
{19,	20,	12,	37,	7},
{18,	9,	7,	38,	25},
{19,	9,	9,	38,	18},
{18,	20,	7,	37,	15},
{18,	20,	8,	37,	14},
{18,	0,	36,	39,	4},
{18,	0,	21,	39,	21},
{23,	0,	25,	39,	22},
{19,	1,	3,	39,	13},
{19,	2,	0,	39,	17},
{18,	1,	4,	39,	18},
{18,	2,	4,	39,	22},
{20,	2,	7,	39,	17},
{19,	1,	14,	39,	17},
{18,	2,	21,	39,	5},
{19,	2,	13,	39,	17},
{18,	0,	3,	39,	25},
{19,	2,	7,	39,	23},
{18,	2,	13,	39,	21},
{18,	9,	15,	38,	19},
{20,	8,	20,	38,	19},
{19,	9,	20,	38,	16},
{21,	9,	23,	38,	16},
{20,	8,	36,	38,	16},
{20,	8,	36,	38,	19},
{20,	9,	24,	38,	20},
{19,	8,	24,	38,	29},
{20,	9,	13,	38,	25},
{20,	8,	34,	38,	24},
{18,	10,	13,	38,	9},
{18,	5,	37,	39,	0},
{18,	10,	2,	37,	34},
{19,	10,	2,	37,	39},
{19,	11,	35,	37,	31},
{19,	11,	2,	37,	34},
{19,	13,	14,	37,	32},
{20,	14,	3,	37,	33},
{21,	11,	4,	37,	34},
{20,	12,	35,	37,	31},
{20,	12,	29,	37,	32},
{20,	13,	26,	37,	32},
{19,	12,	6,	37,	33},
{19,	11,	21,	37,	33},
{19,	11,	26,	37,	34},
{19,	10,	21,	37,	35},
{22,	10,	6,	37,	36},
{21,	11,	4,	37,	37},
{19,	11,	8,	37,	35},
{19,	10,	30,	37,	35},
{20,	11,	34,	37,	33},
{19,	12,	36,	37,	32},
{19,	10,	37,	37,	29},
{19,	13,	37,	37,	28},
{19,	9,	37,	37,	34},
{19,	13,	37,	37,	30},
{19,	9,	38,	37,	33},
{18,	17,	4,	37,	27},
{18,	3,	9,	38,	37},
{18,	10,	37,	38,	2},
{19,	9,	37,	38,	5},
{19,	8,	37,	38,	19},
{18,	10,	37,	38,	3},
{18,	11,	18,	38,	3},
{18,	10,	18,	38,	8},
{18,	14,	3,	37,	35},
{20,	13,	2,	37,	37},
{18,	9,	17,	38,	25},
{18,	20,	28,	37,	5},
{21,	20,	35,	37,	5},
{18,	22,	13,	37,	2},
{18,	14,	8,	37,	31},
{20,	14,	18,	37,	30},
{18,	16,	4,	37,	31},
{18,	17,	7,	37,	29},
{18,	16,	8,	37,	28},
{19,	15,	12,	37,	30},
{18,	9,	37,	38,	8},
{18,	3,	15,	38,	36},
{18,	22,	34,	37,	0},
{19,	22,	35,	37,	0},
{19,	21,	37,	37,	0},
{20,	20,	36,	37,	4},
{19,	20,	38,	37,	0},
{18,	1,	18,	39,	36},
{22,	1,	20,	39,	35},
{20,	0,	24,	39,	34},
{19,	2,	15,	39,	24},
{19,	1,	4,	39,	38},
{22,	0,	13,	39,	37},
{21,	0,	18,	39,	37},
{19,	2,	7,	39,	35},
{22,	2,	18,	39,	33},
{19,	0,	20,	39,	37},
{18,	5,	15,	38,	36},
{26,	5,	23,	38,	35},
{23,	5,	31,	38,	34},
{22,	7,	5,	38,	33},
{20,	7,	14,	38,	33},
{20,	5,	19,	38,	36},
{19,	4,	38,	38,	34},
{20,	5,	36,	38,	33},
{18,	6,	3,	38,	34},
{19,	6,	3,	38,	35},
{18,	6,	8,	38,	35},
{18,	9,	17,	38,	30},
{19,	9,	23,	38,	30},
{18,	0,	39,	38,	18},
{24,	0,	39,	38,	22},
{20,	2,	39,	37,	0},
{19,	5,	39,	37,	29},
{22,	4,	39,	37,	33},
{21,	2,	39,	37,	34},
{19,	2,	39,	38,	9},
{22,	2,	39,	38,	18},
{19,	6,	39,	37,	11},
{19,	1,	39,	37,	35},
{19,	5,	39,	37,	35},
{18,	15,	13,	37,	30},
{18,	17,	13,	37,	23},
{18,	3,	19,	38,	37},
{18,	4,	11,	38,	37},
{20,	4,	4,	38,	39},
{18,	4,	17,	38,	37},
{18,	5,	16,	38,	37},
{18,	5,	3,	38,	39},
{18,	19,	35,	37,	7},
{18,	20,	31,	37,	11},
{21,	19,	35,	37,	11},
{18,	20,	16,	37,	12},
{19,	18,	18,	37,	13},
{19,	18,	30,	37,	17},
{20,	18,	35,	37,	14},
{19,	17,	32,	37,	18},
{19,	15,	17,	37,	25},
{20,	16,	16,	37,	24},
{20,	15,	19,	37,	30},
{20,	16,	19,	37,	24},
{20,	17,	30,	37,	20},
{19,	17,	16,	37,	24},
{19,	17,	21,	37,	22},
{19,	15,	25,	37,	27},
{20,	17,	23,	37,	23},
{19,	18,	35,	37,	16},
{19,	16,	32,	37,	23},
{20,	15,	32,	37,	28},
{19,	17,	34,	37,	21},
{21,	16,	35,	37,	23},
{19,	15,	35,	37,	30},
{19,	16,	25,	37,	29},
{19,	15,	27,	37,	31},
{20,	16,	11,	37,	31},
{19,	16,	10,	37,	32},
{19,	15,	14,	37,	32},
{18,	20,	8,	37,	17},
{18,	17,	10,	37,	29},
{19,	17,	13,	37,	28},
{18,	0,	24,	39,	36},
{18,	10,	37,	38,	15},
{20,	9,	26,	38,	30},
{19,	10,	32,	38,	19},
{19,	10,	11,	38,	22},
{19,	10,	1,	38,	33},
{19,	10,	33,	38,	20},
{18,	11,	26,	38,	6},
{19,	11,	34,	38,	5},
{19,	11,	36,	38,	6},
{18,	11,	37,	38,	6},
{18,	11,	35,	38,	12},
{19,	11,	37,	38,	11},
{18,	0,	23,	38,	39},
{18,	11,	32,	38,	20},
{18,	18,	36,	37,	10},
{18,	22,	31,	37,	12},
{20,	22,	35,	37,	12},
{19,	23,	32,	37,	3},
{21,	23,	35,	37,	2},
{20,	23,	22,	37,	4},
{19,	24,	19,	37,	0},
{19,	20,	36,	37,	9},
{18,	25,	17,	37,	0},
{18,	26,	15,	37,	4},
{18,	20,	23,	37,	15},
{19,	20,	34,	37,	14},
{21,	20,	35,	37,	15},
{18,	19,	18,	37,	17},
{19,	21,	35,	37,	29},
{19,	22,	9,	37,	28},
{18,	23,	10,	37,	21},
{20,	25,	13,	37,	5},
{20,	25,	13,	37,	6},
{19,	22,	12,	37,	21},
{20,	22,	19,	37,	16},
{20,	22,	30,	37,	14},
{18,	24,	11,	37,	8},
{18,	24,	12,	37,	17},
{19,	24,	12,	37,	18},
{18,	25,	14,	37,	15},
{21,	25,	13,	37,	18},
{18,	26,	14,	37,	9},
{18,	23,	10,	37,	23},
{18,	25,	14,	37,	18},
{20,	22,	20,	37,	18},
{18,	22,	13,	37,	23},
{19,	22,	20,	37,	21},
{18,	23,	37,	37,	0},
{18,	24,	36,	37,	0},
{18,	23,	10,	37,	28},
{19,	22,	19,	37,	24},
{18,	23,	34,	37,	4},
{18,	25,	14,	37,	24},
{19,	24,	12,	37,	26},
{22,	22,	19,	37,	27},
{18,	23,	34,	37,	7},
{19,	25,	16,	37,	5},
{18,	23,	23,	37,	14},
{22,	24,	16,	37,	15},
{21,	23,	16,	37,	24},
{21,	23,	18,	37,	22},
{18,	23,	27,	37,	13},
{20,	23,	35,	37,	9},
{18,	25,	14,	37,	25},
{20,	23,	16,	37,	27},
{18,	28,	36,	37,	2},
{23,	23,	36,	37,	9},
{21,	26,	18,	37,	5},
{20,	26,	20,	37,	5},
{20,	26,	20,	37,	6},
{19,	27,	16,	37,	5},
{19,	26,	25,	37,	3},
{19,	25,	34,	37,	3},
{19,	36,	36,	37,	1},
{23,	37,	34,	37,	0},
{20,	33,	34,	37,	2},
{22,	36,	33,	37,	2},
{21,	36,	34,	37,	2},
{20,	32,	37,	37,	0},
{22,	33,	37,	37,	0},
{19,	26,	37,	37,	1},
{19,	23,	37,	37,	7},
{20,	18,	38,	37,	7},
{19,	22,	37,	37,	8},
{19,	18,	38,	37,	8},
{19,	11,	38,	37,	13},
{20,	18,	38,	37,	9},
{20,	17,	38,	37,	10},
{19,	32,	35,	37,	2},
{19,	34,	35,	37,	2},
{19,	37,	34,	37,	1},
{19,	38,	35,	37,	1},
{19,	36,	36,	37,	2},
{19,	36,	35,	37,	3},
{22,	28,	19,	37,	5},
{20,	33,	36,	37,	3},
{19,	17,	37,	37,	25},
{20,	15,	37,	37,	28},
{19,	18,	38,	37,	11},
{19,	22,	36,	37,	28},
{21,	20,	37,	37,	13},
{19,	22,	37,	37,	12},
{19,	22,	32,	37,	29},
{20,	23,	13,	37,	29},
{20,	22,	36,	37,	29},
{18,	27,	20,	37,	6},
{18,	24,	17,	37,	15},
{18,	24,	17,	37,	18},
{18,	24,	18,	37,	16},
{18,	23,	25,	37,	15},
{19,	24,	19,	37,	17},
{18,	24,	21,	37,	9},
{18,	5,	26,	38,	35},
{18,	15,	20,	37,	34},
{24,	15,	27,	37,	33},
{19,	16,	4,	37,	34},
{19,	13,	7,	37,	35},
{19,	15,	22,	37,	34},
{19,	12,	37,	37,	34},
{19,	14,	31,	37,	33},
{19,	13,	31,	37,	34},
{19,	14,	31,	37,	34},
{19,	15,	35,	37,	34},
{18,	27,	36,	37,	6},
{19,	24,	25,	37,	10},
{19,	24,	33,	37,	8},
{19,	28,	36,	37,	5},
{19,	24,	37,	37,	8},
{18,	26,	34,	37,	9},
{22,	26,	36,	37,	9},
{19,	27,	17,	37,	8},
{18,	27,	16,	37,	10},
{18,	26,	14,	37,	20},
{18,	26,	15,	37,	17},
{18,	26,	18,	37,	11},
{18,	27,	17,	37,	14},
{20,	28,	17,	37,	13},
{20,	25,	20,	37,	14},
{20,	25,	20,	37,	16},
{18,	27,	35,	37,	7},
{18,	27,	30,	37,	9},
{19,	36,	36,	37,	29},
{19,	37,	34,	37,	8},
{19,	33,	37,	37,	12},
{19,	34,	38,	37,	11},
{19,	33,	37,	37,	13},
{19,	37,	35,	37,	17},
{20,	37,	34,	37,	26},
{19,	37,	36,	37,	5},
{18,	0,	36,	38,	35},
{18,	1,	36,	38,	35},
{18,	35,	38,	37,	1},
{19,	35,	37,	37,	3},
{19,	35,	38,	37,	3},
{19,	35,	37,	37,	4},
{19,	35,	37,	37,	6},
{19,	35,	38,	37,	11},
{20,	35,	37,	37,	12},
{18,	1,	35,	38,	37},
{21,	5,	22,	38,	36},
{21,	2,	34,	38,	36},
{20,	4,	27,	38,	36},
{19,	3,	33,	38,	36},
{19,	1,	35,	38,	39},
{18,	2,	19,	38,	39},
{18,	1,	37,	38,	35},
{18,	36,	37,	37,	2},
{19,	36,	37,	37,	6},
{21,	36,	37,	37,	7},
{19,	36,	37,	37,	9},
{18,	5,	33,	38,	36},
{19,	4,	35,	38,	35},
{19,	3,	35,	38,	36},
{19,	5,	35,	38,	35},
{20,	5,	36,	38,	35},
{18,	1,	36,	38,	38},
{19,	0,	36,	38,	39},
{19,	1,	36,	38,	39},
{18,	0,	37,	38,	36},
{18,	0,	37,	38,	37},
{18,	0,	38,	38,	37},
{18,	0,	37,	38,	39},
{18,	12,	34,	37,	35},
{24,	12,	36,	37,	35},
{18,	14,	31,	37,	35},
{20,	14,	34,	37,	35},
{18,	30,	37,	37,	14},
{18,	15,	37,	37,	30},
{19,	17,	37,	37,	29},
{18,	11,	37,	37,	35},
{18,	11,	38,	37,	35},
{19,	13,	38,	37,	25},
{18,	21,	38,	37,	23},
{19,	16,	38,	37,	28},
{20,	19,	38,	37,	26},
{19,	19,	38,	37,	28},
{18,	23,	38,	37,	14},
{19,	25,	38,	37,	14},
{19,	25,	38,	37,	19},
{20,	23,	37,	37,	23},
{19,	23,	38,	37,	23},
{18,	8,	37,	37,	39},
{18,	11,	35,	37,	39},
{24,	10,	38,	37,	36},
{21,	11,	38,	37,	36},
{20,	9,	38,	37,	37},
{19,	9,	36,	37,	39},
{19,	10,	36,	37,	39},
{21,	11,	37,	37,	37},
{20,	11,	38,	37,	37},
{18,	12,	9,	37,	39},
{20,	13,	4,	37,	37},
{18,	13,	5,	37,	37},
{18,	13,	9,	37,	37},
{18,	13,	6,	37,	39},
{18,	12,	15,	37,	36},
{18,	16,	37,	37,	32},
{20,	13,	36,	37,	35},
{20,	14,	36,	37,	35},
{19,	13,	37,	37,	35},
{18,	16,	38,	37,	31},
{20,	13,	38,	37,	34},
{19,	13,	38,	37,	35},
{19,	20,	38,	37,	29},
{20,	24,	37,	37,	24},
{18,	9,	38,	37,	39},
{19,	10,	38,	37,	39},
{18,	25,	37,	37,	24},
{18,	11,	39,	37,	37},
{26,	11,	39,	34,	39},
{23,	8,	39,	36,	39},
{19,	12,	39,	35,	36},
{22,	12,	39,	37,	16},
{21,	12,	39,	34,	39},
{19,	9,	39,	36,	39},
{19,	13,	39,	37,	35},
{18,	7,	39,	37,	39},
{18,	13,	39,	31,	39},
{18,	9,	39,	37,	38},
{18,	33,	37,	37,	17},
{20,	29,	37,	37,	24},
{18,	36,	37,	37,	14},
{18,	35,	38,	37,	13},
{19,	27,	38,	37,	16},
{18,	9,	39,	37,	39},
{18,	34,	37,	37,	16},
{18,	11,	39,	36,	38},
{18,	11,	39,	36,	39},
{19,	10,	39,	37,	39},
{18,	13,	39,	34,	39},
{18,	13,	37,	37,	39},
{19,	12,	38,	37,	37},
{21,	13,	39,	37,	36},
{19,	12,	38,	37,	39},
{18,	24,	35,	37,	31},
{21,	26,	14,	37,	31},
{21,	25,	35,	37,	30},
{20,	19,	38,	37,	30},
{19,	27,	16,	37,	31},
{19,	28,	17,	37,	31},
{19,	27,	19,	37,	31},
{19,	21,	36,	37,	31},
{18,	17,	10,	37,	32},
{18,	17,	37,	37,	32},
{18,	18,	30,	37,	32},
{18,	18,	5,	37,	33},
{18,	28,	31,	37,	30},
{20,	28,	35,	37,	30},
{19,	28,	20,	37,	31},
{18,	31,	23,	37,	30},
{20,	29,	21,	37,	31},
{18,	35,	38,	37,	17},
{19,	35,	38,	37,	19},
{19,	29,	38,	37,	20},
{19,	26,	38,	37,	23},
{19,	28,	38,	37,	23},
{19,	35,	37,	37,	24},
{19,	30,	37,	37,	25},
{20,	33,	37,	37,	25},
{20,	35,	37,	37,	25},
{19,	27,	37,	37,	26},
{19,	35,	38,	37,	23},
{19,	35,	38,	37,	24},
{18,	36,	37,	37,	17},
{18,	37,	37,	36,	19},
{23,	37,	37,	36,	20},
{18,	37,	37,	36,	21},
{18,	18,	39,	36,	39},
{25,	16,	39,	37,	18},
{23,	16,	39,	37,	31},
{22,	17,	39,	37,	31},
{20,	18,	39,	37,	15},
{18,	15,	39,	37,	34},
{18,	37,	37,	36,	22},
{18,	22,	39,	36,	36},
{26,	20,	39,	35,	39},
{25,	22,	39,	34,	39},
{22,	19,	39,	37,	17},
{20,	21,	39,	36,	38},
{20,	22,	39,	35,	39},
{19,	20,	39,	37,	19},
{20,	20,	39,	37,	26},
{19,	21,	39,	37,	23},
{18,	22,	39,	37,	18},
{18,	28,	38,	37,	30},
{19,	20,	39,	37,	30},
{19,	30,	37,	37,	29},
{19,	29,	38,	37,	29},
{20,	30,	38,	37,	29},
{20,	33,	38,	37,	25},
{19,	30,	38,	37,	30},
{19,	32,	38,	37,	28},
{20,	35,	38,	37,	26},
{19,	36,	36,	37,	30},
{19,	36,	35,	37,	31},
{21,	30,	36,	37,	31},
{20,	33,	36,	37,	31},
{18,	37,	36,	37,	29},
{20,	37,	35,	37,	30},
{18,	36,	37,	37,	29},
{19,	33,	38,	37,	28},
{19,	36,	37,	37,	30},
{18,	36,	38,	37,	19},
{18,	36,	38,	37,	21},
{18,	33,	38,	37,	32},
{19,	35,	37,	37,	31},
{19,	36,	37,	37,	31},
{18,	36,	35,	37,	32},
{21,	35,	37,	37,	32},
{19,	37,	35,	37,	32},
{19,	37,	36,	37,	31},
{18,	38,	36,	29,	38},
{26,	38,	36,	29,	39},
{20,	38,	36,	30,	1},
{20,	38,	36,	33,	0},
{22,	38,	36,	33,	1},
{20,	38,	36,	30,	13},
{21,	38,	36,	30,	39},
{19,	38,	36,	34,	0},
{19,	38,	36,	35,	0},
{18,	38,	36,	31,	3},
{19,	38,	36,	32,	4},
{20,	38,	36,	31,	5},
{18,	38,	36,	33,	2},
{19,	38,	36,	33,	3},
{18,	38,	36,	36,	0},
{18,	37,	38,	30,	39},
{24,	37,	38,	33,	0},
{23,	37,	38,	34,	0},
{20,	37,	38,	35,	0},
{18,	37,	38,	35,	9},
{19,	37,	38,	33,	39},
{19,	37,	38,	34,	10},
{19,	37,	38,	34,	11},
{18,	37,	38,	34,	17},
{18,	35,	39,	36,	35},
{30,	35,	39,	29,	38},
{29,	30,	39,	32,	39},
{27,	35,	39,	33,	36},
{24,	26,	39,	34,	38},
{25,	31,	39,	35,	36},
{24,	35,	39,	27,	39},
{23,	32,	39,	31,	39},
{24,	31,	39,	33,	39},
{24,	33,	39,	33,	38},
{25,	35,	39,	33,	37},
{24,	35,	39,	30,	39},
{23,	35,	39,	31,	39},
{22,	27,	39,	36,	36},
{22,	35,	39,	34,	37},
{22,	34,	39,	33,	39},
{22,	34,	39,	34,	38},
{23,	34,	39,	34,	39},
{21,	25,	39,	35,	39},
{22,	30,	39,	35,	37},
{21,	35,	39,	32,	39},
{20,	23,	39,	37,	10},
{20,	35,	39,	34,	39},
{20,	35,	39,	35,	39},
{19,	36,	39,	33,	39},
{24,	36,	39,	34,	6},
{22,	36,	39,	35,	0},
{20,	36,	39,	34,	13},
{19,	36,	39,	35,	3},
{19,	36,	39,	35,	9},
{18,	33,	39,	37,	9},
{21,	33,	39,	37,	10},
{18,	34,	39,	37,	5},
{19,	34,	39,	37,	10},
{18,	36,	39,	35,	15},
{19,	36,	39,	34,	37},
{21,	36,	39,	35,	19},
{21,	36,	39,	35,	22},
{18,	36,	39,	36,	15},
{22,	36,	39,	36,	18},
{18,	36,	39,	36,	20},
{18,	36,	39,	35,	28},
{18,	36,	39,	35,	34},
{19,	36,	39,	35,	38},
{19,	36,	39,	34,	39},
{18,	38,	36,	32,	39},
{18,	38,	36,	33,	39},
{18,	38,	36,	35,	5},
{19,	38,	36,	34,	6},
{18,	38,	36,	34,	7},
{18,	38,	36,	35,	7},
{18,	38,	36,	34,	10},
{18,	38,	36,	34,	11},
{18,	38,	35,	36,	37},
{18,	38,	36,	34,	39},
{18,	38,	36,	35,	39},
{19,	38,	35,	36,	39},
{18,	37,	37,	36,	38},
{21,	37,	37,	36,	39},
{18,	37,	38,	34,	39},
{18,	37,	38,	35,	39},
{18,	35,	39,	36,	39},
{18,	36,	39,	36,	36},
{19,	36,	39,	36,	37},
{18,	36,	39,	36,	38},
{18,	37,	38,	36,	39},
{18,	36,	39,	36,	39},
{17,	9,	8,	39,	1},
{19,	10,	15,	39,	0},
{18,	10,	37,	39,	0},
{17,	9,	1,	39,	4},
{18,	4,	1,	39,	16},
{21,	3,	21,	39,	7},
{20,	4,	0,	39,	31},
{20,	3,	1,	39,	35},
{19,	6,	1,	39,	16},
{19,	7,	0,	39,	30},
{18,	6,	1,	39,	25},
{18,	3,	6,	39,	35},
{19,	5,	3,	39,	14},
{19,	4,	19,	39,	7},
{20,	4,	5,	39,	27},
{19,	6,	2,	39,	27},
{20,	6,	6,	39,	12},
{18,	3,	8,	39,	31},
{18,	6,	8,	39,	13},
{18,	4,	18,	39,	11},
{17,	2,	28,	39,	6},
{17,	4,	8,	39,	25},
{17,	0,	37,	39,	3},
{17,	8,	8,	39,	25},
{19,	9,	2,	39,	24},
{18,	11,	1,	39,	25},
{17,	3,	36,	39,	2},
{18,	2,	37,	39,	1},
{17,	4,	25,	39,	7},
{17,	1,	35,	39,	5},
{18,	3,	31,	39,	7},
{18,	0,	27,	39,	18},
{17,	1,	36,	39,	4},
{17,	7,	7,	39,	27},
{17,	13,	18,	38,	12},
{21,	13,	3,	38,	17},
{20,	12,	14,	38,	14},
{21,	12,	21,	38,	13},
{19,	13,	3,	38,	20},
{18,	15,	3,	39,	0},
{18,	14,	10,	38,	0},
{19,	15,	10,	38,	0},
{18,	14,	19,	38,	0},
{18,	12,	35,	38,	2},
{18,	14,	38,	38,	0},
{21,	13,	37,	38,	1},
{19,	11,	38,	38,	1},
{19,	13,	36,	38,	3},
{20,	13,	23,	38,	10},
{18,	10,	38,	38,	5},
{18,	15,	37,	38,	3},
{21,	16,	4,	38,	5},
{21,	15,	3,	38,	14},
{20,	14,	9,	38,	8},
{20,	14,	18,	38,	6},
{19,	17,	4,	38,	9},
{19,	15,	38,	38,	1},
{18,	15,	22,	38,	5},
{18,	14,	38,	38,	3},
{18,	13,	34,	38,	9},
{21,	12,	37,	38,	9},
{18,	12,	30,	38,	13},
{18,	13,	30,	38,	12},
{18,	13,	37,	38,	6},
{18,	10,	38,	38,	9},
{19,	10,	38,	38,	11},
{19,	6,	38,	38,	20},
{18,	11,	38,	38,	10},
{18,	12,	29,	38,	19},
{18,	6,	38,	38,	30},
{17,	15,	9,	38,	8},
{17,	12,	2,	39,	18},
{17,	15,	9,	38,	9},
{18,	14,	25,	38,	10},
{18,	15,	13,	38,	9},
{17,	5,	3,	39,	34},
{20,	5,	8,	39,	33},
{19,	7,	3,	39,	33},
{18,	4,	7,	39,	35},
{17,	4,	39,	38,	0},
{17,	7,	1,	38,	35},
{19,	7,	3,	39,	34},
{17,	5,	38,	39,	0},
{19,	0,	38,	39,	2},
{17,	6,	2,	38,	36},
{18,	8,	1,	38,	37},
{17,	6,	3,	39,	35},
{18,	8,	1,	39,	35},
{17,	6,	2,	38,	39},
{18,	6,	5,	38,	39},
{17,	14,	22,	38,	12},
{18,	14,	27,	38,	12},
{18,	14,	38,	38,	4},
{17,	9,	38,	39,	0},
{17,	6,	9,	38,	36},
{17,	6,	9,	38,	37},
{17,	13,	24,	38,	16},
{19,	13,	32,	38,	16},
{19,	12,	38,	38,	10},
{18,	13,	5,	38,	20},
{18,	14,	33,	38,	10},
{18,	13,	36,	38,	15},
{19,	12,	37,	38,	14},
{17,	15,	4,	38,	14},
{18,	15,	11,	38,	11},
{17,	16,	4,	38,	14},
{17,	17,	4,	38,	15},
{17,	15,	4,	38,	17},
{17,	14,	5,	38,	18},
{17,	14,	8,	38,	16},
{17,	16,	6,	38,	15},
{18,	16,	7,	38,	12},
{17,	15,	8,	38,	16},
{17,	13,	7,	38,	20},
{19,	14,	9,	38,	18},
{19,	14,	16,	38,	15},
{18,	14,	11,	38,	19},
{17,	14,	14,	38,	19},
{17,	14,	21,	38,	15},
{17,	8,	39,	38,	8},
{20,	4,	39,	38,	16},
{20,	6,	39,	38,	18},
{17,	0,	37,	39,	18},
{23,	0,	36,	39,	20},
{17,	1,	36,	39,	17},
{19,	1,	22,	39,	36},
{17,	1,	37,	39,	12},
{17,	2,	25,	39,	23},
{17,	1,	37,	39,	14},
{17,	4,	20,	39,	31},
{19,	5,	10,	39,	32},
{17,	16,	8,	37,	33},
{17,	12,	17,	38,	28},
{22,	10,	25,	38,	28},
{23,	12,	24,	38,	25},
{20,	12,	24,	38,	28},
{20,	12,	28,	38,	24},
{20,	12,	32,	38,	24},
{21,	11,	32,	38,	27},
{19,	10,	22,	38,	29},
{17,	13,	15,	38,	20},
{17,	14,	14,	38,	20},
{17,	11,	9,	38,	31},
{21,	10,	17,	38,	31},
{20,	10,	26,	38,	31},
{18,	8,	9,	38,	32},
{18,	12,	11,	38,	29},
{18,	12,	21,	38,	29},
{17,	13,	18,	38,	20},
{17,	12,	13,	38,	31},
{17,	12,	3,	38,	32},
{17,	14,	37,	38,	6},
{17,	0,	37,	39,	20},
{17,	7,	16,	38,	36},
{19,	6,	16,	38,	37},
{19,	7,	29,	38,	32},
{19,	6,	18,	38,	36},
{18,	10,	22,	38,	32},
{19,	12,	7,	38,	32},
{17,	12,	6,	38,	34},
{19,	8,	2,	38,	36},
{19,	8,	10,	38,	34},
{18,	10,	10,	38,	33},
{19,	9,	16,	38,	33},
{17,	8,	3,	39,	34},
{18,	9,	2,	39,	34},
{17,	13,	2,	38,	34},
{17,	13,	8,	38,	27},
{17,	11,	10,	38,	33},
{17,	7,	12,	38,	37},
{18,	7,	4,	38,	39},
{17,	8,	15,	38,	34},
{17,	14,	39,	38,	6},
{18,	11,	39,	38,	10},
{17,	8,	17,	38,	34},
{18,	10,	23,	38,	33},
{18,	7,	18,	38,	36},
{18,	7,	19,	38,	36},
{18,	7,	23,	38,	34},
{18,	7,	22,	38,	35},
{17,	0,	37,	39,	22},
{21,	0,	34,	39,	26},
{19,	0,	33,	39,	32},
{21,	0,	29,	39,	35},
{18,	0,	27,	39,	36},
{18,	0,	27,	39,	37},
{17,	1,	30,	39,	27},
{17,	14,	26,	38,	20},
{19,	13,	27,	38,	21},
{17,	9,	18,	38,	34},
{19,	9,	23,	38,	34},
{17,	15,	14,	37,	35},
{20,	16,	5,	37,	35},
{19,	15,	18,	37,	35},
{18,	17,	5,	37,	35},
{18,	15,	36,	37,	35},
{17,	15,	5,	37,	36},
{19,	15,	3,	37,	38},
{17,	18,	5,	37,	35},
{17,	10,	37,	38,	16},
{17,	4,	23,	38,	37},
{18,	3,	27,	38,	37},
{17,	6,	18,	38,	37},
{17,	4,	21,	38,	39},
{20,	7,	8,	38,	39},
{19,	3,	27,	38,	38},
{18,	5,	18,	38,	38},
{18,	3,	35,	38,	39},
{20,	2,	36,	38,	37},
{17,	22,	11,	37,	33},
{18,	17,	17,	37,	33},
{18,	17,	37,	37,	33},
{18,	17,	39,	37,	33},
{17,	19,	7,	37,	34},
{20,	19,	8,	37,	34},
{18,	18,	34,	37,	34},
{19,	19,	18,	37,	33},
{19,	22,	18,	37,	33},
{18,	22,	23,	37,	33},
{18,	22,	25,	37,	33},
{19,	19,	37,	37,	33},
{21,	22,	30,	37,	33},
{18,	20,	36,	37,	33},
{17,	17,	6,	37,	35},
{17,	12,	21,	38,	32},
{18,	12,	14,	38,	33},
{17,	8,	37,	38,	21},
{17,	0,	29,	39,	37},
{17,	9,	24,	38,	34},
{19,	6,	27,	38,	35},
{18,	9,	26,	38,	34},
{18,	6,	31,	38,	35},
{18,	6,	30,	38,	36},
{17,	0,	37,	39,	30},
{18,	0,	34,	39,	33},
{18,	0,	36,	39,	33},
{17,	1,	37,	39,	27},
{21,	1,	36,	39,	31},
{18,	1,	37,	39,	30},
{17,	2,	26,	39,	31},
{17,	0,	29,	39,	38},
{17,	2,	36,	39,	30},
{18,	3,	36,	39,	6},
{17,	3,	30,	39,	12},
{17,	3,	29,	39,	19},
{17,	4,	28,	38,	37},
{17,	12,	33,	38,	24},
{17,	11,	38,	38,	17},
{18,	12,	34,	38,	24},
{18,	11,	37,	38,	18},
{18,	13,	34,	38,	21},
{18,	10,	37,	38,	25},
{22,	7,	37,	38,	30},
{20,	8,	38,	38,	27},
{19,	11,	36,	38,	25},
{17,	13,	35,	38,	19},
{17,	14,	35,	38,	20},
{18,	14,	39,	38,	7},
{17,	19,	20,	37,	34},
{18,	19,	24,	37,	34},
{17,	36,	38,	38,	0},
{18,	16,	29,	38,	3},
{19,	16,	37,	38,	2},
{17,	16,	9,	38,	11},
{17,	16,	39,	38,	0},
{17,	17,	38,	38,	1},
{18,	21,	11,	38,	2},
{20,	19,	21,	38,	1},
{18,	23,	10,	38,	2},
{17,	20,	39,	38,	0},
{17,	8,	38,	38,	28},
{18,	9,	35,	38,	29},
{18,	11,	29,	38,	30},
{17,	12,	26,	38,	32},
{17,	6,	34,	38,	34},
{18,	9,	34,	38,	31},
{18,	6,	36,	38,	35},
{18,	8,	36,	38,	31},
{17,	36,	39,	37,	1},
{22,	36,	39,	37,	2},
{18,	35,	39,	37,	32},
{18,	36,	39,	37,	8},
{19,	36,	39,	37,	9},
{17,	12,	38,	38,	25},
{17,	13,	29,	38,	28},
{17,	13,	36,	38,	23},
{17,	1,	38,	38,	36},
{17,	38,	36,	37,	3},
{18,	38,	36,	36,	7},
{18,	38,	36,	36,	8},
{17,	6,	38,	38,	32},
{21,	5,	38,	38,	34},
{17,	8,	38,	38,	30},
{17,	9,	36,	38,	31},
{17,	12,	36,	38,	26},
{18,	10,	36,	38,	31},
{18,	10,	38,	38,	29},
{19,	9,	38,	38,	31},
{17,	14,	35,	38,	26},
{17,	13,	35,	38,	27},
{17,	13,	35,	38,	28},
{17,	12,	31,	38,	31},
{17,	11,	37,	38,	28},
{17,	37,	37,	37,	4},
{17,	37,	38,	37,	3},
{17,	3,	38,	38,	36},
{20,	5,	37,	38,	35},
{19,	5,	37,	38,	36},
{20,	4,	38,	38,	36},
{18,	6,	35,	38,	36},
{18,	3,	36,	38,	39},
{17,	1,	37,	38,	39},
{20,	1,	38,	38,	37},
{17,	4,	36,	38,	38},
{17,	5,	35,	38,	38},
{19,	5,	36,	38,	38},
{17,	7,	19,	38,	37},
{17,	2,	37,	38,	39},
{19,	2,	38,	38,	37},
{18,	5,	38,	38,	37},
{17,	10,	36,	38,	32},
{19,	9,	38,	38,	32},
{18,	10,	30,	38,	33},
{17,	6,	37,	38,	35},
{17,	2,	38,	38,	39},
{18,	3,	38,	38,	38},
{18,	3,	37,	38,	39},
{18,	5,	38,	38,	38},
{17,	12,	35,	38,	32},
{17,	19,	28,	37,	34},
{17,	7,	38,	38,	36},
{21,	8,	36,	38,	34},
{21,	9,	36,	38,	34},
{17,	7,	22,	38,	37},
{17,	37,	38,	37,	8},
{17,	38,	36,	36,	10},
{18,	38,	36,	36,	11},
{17,	5,	38,	38,	39},
{17,	37,	38,	37,	9},
{18,	37,	37,	37,	11},
{17,	14,	33,	37,	38},
{22,	14,	35,	37,	38},
{18,	14,	35,	37,	39},
{18,	15,	4,	37,	39},
{17,	17,	4,	37,	37},
{18,	17,	5,	37,	37},
{17,	16,	6,	37,	37},
{19,	15,	7,	37,	39},
{18,	15,	9,	37,	38},
{17,	18,	5,	37,	37},
{17,	15,	10,	37,	39},
{18,	15,	34,	37,	36},
{17,	37,	38,	37,	12},
{17,	36,	39,	37,	12},
{19,	36,	39,	37,	13},
{17,	14,	36,	37,	37},
{19,	15,	36,	37,	36},
{17,	14,	38,	37,	35},
{17,	38,	36,	36,	15},
{17,	18,	36,	37,	34},
{18,	19,	36,	37,	34},
{17,	13,	38,	37,	37},
{17,	17,	39,	37,	34},
{18,	19,	37,	37,	34},
{19,	18,	39,	37,	34},
{17,	37,	37,	37,	17},
{17,	14,	38,	37,	39},
{17,	17,	39,	37,	36},
{18,	17,	7,	37,	37},
{17,	36,	38,	37,	22},
{17,	36,	38,	37,	23},
{17,	37,	37,	37,	26},
{18,	37,	37,	37,	30},
{19,	37,	37,	37,	31},
{17,	34,	36,	37,	33},
{22,	25,	37,	37,	33},
{19,	36,	34,	37,	33},
{20,	35,	36,	37,	33},
{18,	26,	39,	37,	33},
{19,	31,	38,	37,	33},
{19,	35,	38,	37,	33},
{19,	34,	39,	37,	33},
{18,	19,	39,	37,	34},
{17,	36,	35,	37,	33},
{17,	36,	35,	37,	34},
{21,	23,	36,	37,	34},
{21,	31,	36,	37,	34},
{20,	32,	36,	37,	34},
{20,	34,	36,	37,	34},
{19,	22,	38,	37,	34},
{20,	24,	37,	37,	34},
{19,	24,	38,	37,	34},
{20,	25,	38,	37,	34},
{20,	26,	38,	37,	34},
{20,	27,	38,	37,	34},
{22,	29,	37,	37,	34},
{19,	35,	36,	37,	34},
{18,	30,	37,	37,	34},
{18,	36,	36,	37,	34},
{19,	36,	37,	37,	32},
{18,	36,	37,	37,	33},
{18,	35,	38,	37,	34},
{17,	37,	34,	37,	34},
{17,	36,	39,	37,	31},
{20,	36,	38,	37,	33},
{18,	36,	38,	37,	34},
{17,	37,	38,	37,	25},
{17,	37,	36,	37,	33},
{17,	37,	35,	37,	34},
{17,	37,	36,	37,	34},
{17,	38,	36,	36,	39},
{17,	37,	39,	35,	39},
{16,	9,	5,	39,	8},
{16,	12,	3,	39,	9},
{16,	11,	15,	39,	0},
{17,	14,	5,	39,	1},
{16,	11,	4,	39,	14},
{18,	9,	8,	39,	14},
{16,	20,	10,	38,	3},
{17,	22,	10,	38,	3},
{16,	11,	4,	39,	19},
{18,	9,	8,	39,	23},
{17,	11,	5,	39,	17},
{16,	18,	7,	38,	15},
{19,	17,	9,	38,	12},
{17,	21,	8,	38,	4},
{16,	21,	10,	38,	4},
{16,	18,	9,	38,	9},
{16,	18,	13,	38,	6},
{18,	18,	15,	38,	4},
{17,	16,	13,	38,	9},
{17,	17,	36,	38,	3},
{19,	18,	21,	38,	4},
{17,	17,	35,	38,	4},
{18,	15,	28,	38,	6},
{17,	15,	32,	38,	7},
{18,	15,	36,	38,	7},
{17,	15,	38,	38,	5},
{17,	15,	35,	38,	25},
{19,	16,	21,	38,	10},
{17,	17,	12,	38,	10},
{17,	15,	36,	38,	25},
{16,	20,	10,	38,	7},
{16,	23,	10,	38,	4},
{17,	23,	10,	38,	5},
{16,	20,	11,	38,	7},
{16,	19,	13,	38,	6},
{16,	17,	9,	38,	14},
{16,	21,	15,	38,	5},
{19,	20,	14,	38,	7},
{19,	18,	21,	38,	6},
{18,	18,	15,	38,	9},
{18,	20,	21,	38,	2},
{17,	21,	20,	38,	2},
{18,	22,	21,	38,	1},
{17,	22,	20,	38,	2},
{17,	21,	21,	38,	4},
{17,	20,	18,	38,	6},
{16,	19,	14,	38,	9},
{16,	19,	7,	38,	11},
{16,	20,	7,	38,	11},
{16,	6,	0,	39,	36},
{16,	4,	1,	39,	38},
{16,	4,	36,	39,	3},
{16,	4,	27,	39,	11},
{17,	4,	21,	39,	33},
{16,	9,	24,	39,	11},
{21,	7,	22,	39,	14},
{20,	9,	32,	39,	3},
{18,	9,	11,	39,	17},
{19,	8,	22,	39,	15},
{18,	8,	9,	39,	27},
{17,	5,	14,	39,	28},
{16,	11,	15,	39,	8},
{21,	10,	14,	39,	16},
{16,	6,	27,	39,	10},
{16,	18,	20,	38,	7},
{17,	18,	19,	38,	9},
{16,	4,	4,	39,	37},
{19,	3,	7,	39,	36},
{17,	3,	8,	39,	36},
{16,	17,	23,	38,	7},
{17,	17,	33,	38,	5},
{17,	16,	37,	38,	5},
{16,	1,	38,	39,	9},
{16,	10,	3,	38,	36},
{17,	9,	1,	38,	39},
{17,	11,	3,	38,	36},
{16,	18,	22,	38,	9},
{17,	17,	36,	38,	8},
{17,	16,	38,	38,	7},
{18,	17,	37,	38,	7},
{17,	16,	35,	38,	10},
{16,	3,	9,	39,	36},
{17,	4,	10,	39,	35},
{17,	4,	13,	39,	35},
{17,	2,	22,	39,	35},
{17,	3,	22,	39,	35},
{16,	12,	2,	38,	35},
{16,	8,	7,	39,	34},
{18,	6,	12,	39,	32},
{17,	7,	12,	39,	31},
{16,	10,	10,	39,	20},
{16,	11,	6,	39,	20},
{16,	10,	9,	39,	25},
{16,	10,	11,	39,	25},
{16,	5,	8,	39,	35},
{16,	8,	12,	39,	30},
{16,	3,	11,	39,	36},
{16,	1,	38,	39,	12},
{18,	1,	38,	39,	13},
{16,	7,	38,	39,	10},
{22,	3,	36,	39,	18},
{20,	3,	38,	39,	12},
{19,	9,	36,	39,	3},
{17,	8,	38,	39,	2},
{17,	7,	28,	39,	15},
{18,	6,	34,	39,	15},
{17,	7,	35,	39,	13},
{17,	3,	36,	39,	23},
{18,	4,	27,	39,	26},
{18,	6,	34,	39,	17},
{17,	6,	20,	39,	33},
{16,	7,	24,	39,	18},
{16,	5,	15,	39,	35},
{16,	7,	9,	39,	37},
{20,	6,	16,	39,	35},
{18,	8,	1,	39,	38},
{18,	8,	11,	39,	34},
{17,	3,	8,	39,	38},
{20,	6,	6,	39,	38},
{17,	7,	6,	39,	38},
{16,	8,	5,	39,	36},
{16,	9,	9,	39,	34},
{17,	9,	12,	39,	33},
{16,	10,	6,	39,	29},
{16,	10,	12,	39,	29},
{16,	8,	9,	39,	36},
{18,	8,	12,	38,	36},
{18,	8,	32,	38,	35},
{17,	9,	22,	38,	35},
{19,	9,	35,	38,	35},
{16,	10,	5,	38,	36},
{16,	9,	7,	39,	36},
{16,	9,	8,	38,	37},
{19,	8,	6,	39,	37},
{18,	8,	5,	38,	39},
{17,	9,	9,	38,	37},
{17,	9,	13,	38,	36},
{16,	8,	6,	39,	38},
{16,	8,	18,	39,	29},
{17,	8,	14,	39,	35},
{17,	7,	38,	39,	33},
{21,	8,	24,	39,	33},
{18,	6,	22,	39,	34},
{18,	6,	25,	39,	34},
{18,	6,	29,	39,	34},
{17,	7,	17,	39,	35},
{17,	3,	23,	39,	36},
{17,	4,	17,	39,	36},
{17,	2,	27,	39,	36},
{17,	3,	27,	39,	36},
{16,	2,	13,	39,	37},
{19,	1,	19,	39,	37},
{18,	3,	14,	39,	37},
{16,	1,	13,	39,	38},
{16,	4,	13,	39,	37},
{16,	18,	38,	39,	0},
{19,	12,	28,	39,	1},
{18,	12,	8,	39,	9},
{16,	17,	8,	39,	1},
{16,	12,	38,	39,	1},
{16,	13,	38,	39,	1},
{17,	17,	13,	39,	1},
{16,	13,	16,	39,	2},
{17,	14,	3,	39,	9},
{16,	13,	2,	39,	30},
{16,	19,	38,	39,	0},
{17,	21,	38,	39,	0},
{16,	23,	11,	39,	0},
{16,	16,	39,	38,	3},
{16,	19,	39,	38,	1},
{18,	22,	37,	38,	1},
{17,	18,	37,	38,	3},
{17,	21,	37,	38,	2},
{18,	22,	36,	38,	2},
{17,	21,	24,	38,	4},
{17,	21,	39,	38,	1},
{16,	19,	23,	38,	6},
{16,	19,	26,	38,	8},
{16,	9,	13,	38,	37},
{16,	23,	37,	38,	1},
{16,	24,	13,	38,	1},
{16,	24,	12,	38,	2},
{16,	24,	12,	38,	4},
{17,	22,	23,	38,	4},
{16,	22,	16,	38,	5},
{16,	24,	12,	38,	5},
{16,	22,	28,	38,	3},
{16,	22,	35,	38,	3},
{18,	19,	39,	38,	4},
{18,	20,	37,	38,	4},
{17,	19,	36,	38,	8},
{18,	18,	35,	38,	9},
{16,	9,	16,	38,	37},
{16,	18,	34,	38,	10},
{18,	18,	36,	38,	10},
{16,	17,	39,	38,	6},
{16,	0,	39,	38,	23},
{16,	11,	36,	39,	15},
{20,	9,	30,	39,	20},
{18,	11,	38,	39,	2},
{18,	9,	19,	39,	28},
{18,	10,	36,	39,	16},
{19,	9,	36,	39,	19},
{17,	13,	36,	39,	2},
{17,	10,	15,	39,	28},
{16,	10,	38,	39,	3},
{18,	8,	37,	39,	9},
{17,	8,	37,	39,	15},
{17,	8,	38,	39,	19},
{16,	10,	17,	39,	29},
{16,	9,	37,	39,	12},
{16,	1,	25,	39,	37},
{16,	3,	23,	39,	37},
{16,	28,	36,	38,	1},
{23,	27,	38,	38,	1},
{18,	30,	21,	38,	1},
{16,	4,	25,	39,	36},
{16,	7,	19,	39,	35},
{18,	6,	24,	39,	35},
{16,	5,	39,	38,	22},
{17,	7,	39,	38,	20},
{17,	1,	39,	38,	33},
{17,	5,	39,	38,	24},
{19,	2,	39,	38,	33},
{16,	11,	39,	38,	12},
{16,	15,	38,	38,	15},
{22,	13,	38,	38,	24},
{21,	17,	38,	38,	10},
{17,	14,	37,	38,	21},
{18,	15,	37,	38,	24},
{18,	14,	38,	38,	22},
{16,	16,	39,	38,	8},
{16,	19,	38,	38,	10},
{16,	19,	39,	38,	7},
{16,	7,	24,	38,	37},
{17,	6,	38,	38,	37},
{17,	7,	37,	38,	37},
{17,	8,	26,	38,	37},
{17,	8,	35,	38,	36},
{17,	8,	32,	38,	37},
{16,	9,	21,	38,	37},
{17,	9,	25,	38,	36},
{17,	9,	36,	38,	36},
{17,	9,	30,	38,	37},
{17,	8,	38,	38,	35},
{17,	9,	37,	38,	34},
{17,	9,	37,	38,	35},
{16,	15,	16,	37,	39},
{17,	15,	36,	37,	37},
{17,	16,	35,	37,	37},
{16,	17,	9,	37,	37},
{16,	0,	31,	39,	38},
{16,	32,	38,	38,	3},
{20,	25,	16,	38,	5},
{18,	26,	16,	38,	5},
{18,	27,	18,	38,	4},
{18,	23,	35,	38,	4},
{18,	33,	27,	38,	3},
{16,	34,	36,	38,	2},
{21,	33,	37,	38,	2},
{16,	34,	32,	38,	3},
{17,	34,	35,	38,	3},
{17,	35,	35,	38,	3},
{19,	35,	36,	38,	2},
{16,	34,	37,	38,	1},
{16,	3,	39,	38,	31},
{16,	1,	37,	39,	35},
{22,	4,	36,	39,	34},
{21,	4,	37,	39,	34},
{21,	2,	37,	39,	35},
{20,	6,	36,	39,	34},
{18,	0,	38,	39,	35},
{18,	1,	38,	39,	35},
{18,	3,	37,	39,	35},
{17,	0,	32,	39,	37},
{17,	7,	37,	39,	34},
{17,	8,	23,	39,	34},
{17,	7,	27,	39,	35},
{16,	3,	31,	39,	37},
{17,	3,	37,	39,	36},
{17,	1,	33,	39,	37},
{16,	6,	30,	39,	35},
{18,	4,	36,	39,	35},
{17,	4,	37,	39,	35},
{16,	0,	39,	38,	35},
{16,	34,	37,	38,	3},
{16,	11,	38,	39,	25},
{19,	9,	35,	39,	28},
{19,	9,	38,	39,	28},
{18,	8,	33,	39,	34},
{20,	8,	38,	39,	32},
{17,	9,	31,	39,	31},
{18,	9,	36,	39,	33},
{17,	11,	21,	39,	29},
{16,	9,	13,	39,	35},
{16,	35,	36,	38,	4},
{16,	23,	38,	38,	4},
{16,	31,	37,	38,	5},
{18,	24,	38,	38,	5},
{17,	33,	37,	38,	4},
{17,	34,	37,	38,	4},
{16,	20,	19,	38,	9},
{16,	20,	15,	38,	10},
{16,	20,	38,	38,	6},
{16,	20,	32,	38,	7},
{16,	20,	32,	38,	8},
{16,	36,	36,	38,	3},
{16,	0,	38,	39,	36},
{16,	36,	35,	38,	4},
{17,	36,	36,	38,	4},
{16,	2,	38,	39,	34},
{16,	2,	39,	38,	35},
{16,	6,	39,	38,	31},
{17,	6,	39,	38,	34},
{18,	4,	39,	38,	35},
{17,	4,	39,	38,	36},
{17,	8,	39,	38,	34},
{16,	11,	39,	38,	19},
{19,	10,	39,	38,	28},
{16,	0,	39,	38,	37},
{17,	1,	39,	38,	37},
{16,	36,	37,	38,	4},
{16,	35,	38,	38,	4},
{19,	29,	38,	38,	5},
{16,	34,	39,	38,	2},
{17,	33,	39,	38,	4},
{16,	35,	39,	38,	2},
{16,	34,	39,	38,	3},
{16,	3,	36,	39,	37},
{16,	13,	32,	38,	32},
{17,	13,	35,	38,	32},
{16,	16,	4,	38,	35},
{19,	18,	5,	38,	18},
{17,	19,	6,	38,	16},
{16,	11,	4,	38,	36},
{16,	12,	8,	38,	35},
{18,	10,	7,	38,	36},
{18,	11,	10,	38,	34},
{16,	10,	6,	38,	37},
{16,	13,	9,	38,	33},
{16,	14,	11,	38,	32},
{18,	14,	34,	38,	28},
{16,	10,	13,	38,	34},
{16,	14,	13,	38,	32},
{16,	15,	24,	38,	28},
{18,	15,	8,	38,	32},
{17,	15,	7,	38,	33},
{17,	15,	11,	38,	32},
{17,	15,	35,	38,	27},
{16,	36,	38,	38,	4},
{16,	0,	39,	38,	39},
{18,	1,	39,	38,	38},
{16,	4,	37,	39,	36},
{16,	12,	36,	38,	30},
{16,	20,	37,	38,	22},
{22,	17,	38,	38,	17},
{20,	17,	7,	38,	25},
{23,	16,	28,	38,	25},
{19,	19,	7,	38,	24},
{19,	18,	11,	38,	24},
{19,	17,	8,	38,	27},
{19,	19,	7,	38,	26},
{19,	16,	7,	38,	32},
{19,	17,	10,	38,	28},
{21,	17,	21,	38,	25},
{21,	18,	35,	38,	23},
{20,	17,	35,	38,	25},
{19,	19,	11,	38,	25},
{19,	18,	38,	38,	17},
{18,	19,	38,	38,	16},
{17,	17,	5,	38,	33},
{17,	16,	12,	38,	29},
{18,	16,	11,	38,	32},
{17,	17,	10,	38,	30},
{17,	18,	6,	38,	30},
{17,	18,	6,	38,	32},
{17,	20,	38,	38,	16},
{17,	17,	36,	38,	25},
{16,	22,	10,	38,	15},
{21,	22,	9,	38,	19},
{20,	23,	12,	38,	8},
{16,	22,	17,	38,	6},
{16,	24,	23,	38,	6},
{16,	22,	10,	38,	22},
{16,	23,	10,	38,	22},
{16,	18,	8,	38,	30},
{16,	18,	6,	38,	33},
{16,	17,	7,	38,	33},
{16,	19,	22,	38,	23},
{17,	20,	24,	38,	23},
{16,	21,	37,	38,	21},
{20,	23,	24,	38,	7},
{20,	21,	38,	38,	15},
{19,	22,	12,	38,	17},
{17,	23,	35,	38,	7},
{17,	24,	35,	38,	6},
{17,	21,	36,	38,	22},
{16,	21,	39,	38,	7},
{16,	23,	39,	38,	7},
{16,	24,	38,	38,	12},
{17,	24,	13,	38,	13},
{19,	24,	11,	38,	17},
{17,	25,	14,	38,	12},
{17,	27,	16,	38,	8},
{20,	27,	19,	38,	7},
{17,	28,	18,	38,	7},
{16,	24,	11,	38,	20},
{16,	25,	21,	38,	9},
{16,	25,	38,	38,	12},
{17,	25,	39,	38,	7},
{16,	29,	23,	38,	6},
{18,	27,	36,	38,	6},
{16,	22,	38,	38,	15},
{17,	22,	22,	38,	16},
{17,	22,	23,	38,	17},
{17,	22,	35,	38,	16},
{16,	25,	37,	38,	14},
{18,	23,	21,	38,	15},
{16,	25,	38,	38,	13},
{16,	22,	35,	38,	22},
{16,	23,	12,	38,	21},
{16,	22,	21,	38,	23},
{17,	22,	36,	38,	23},
{16,	23,	11,	38,	23},
{17,	23,	13,	38,	23},
{16,	21,	14,	38,	25},
{19,	19,	25,	38,	24},
{16,	1,	39,	38,	39},
{16,	2,	39,	38,	38},
{16,	11,	35,	38,	33},
{16,	6,	38,	39,	34},
{16,	19,	36,	38,	24},
{16,	3,	39,	38,	37},
{16,	9,	37,	39,	32},
{16,	35,	38,	38,	7},
{19,	36,	35,	38,	5},
{17,	36,	33,	38,	7},
{18,	36,	35,	38,	6},
{17,	36,	36,	38,	5},
{16,	26,	21,	38,	9},
{16,	32,	37,	38,	9},
{17,	33,	27,	38,	9},
{17,	35,	34,	38,	8},
{21,	34,	36,	38,	8},
{19,	34,	37,	38,	8},
{17,	35,	35,	38,	8},
{16,	28,	38,	38,	8},
{16,	28,	38,	38,	9},
{16,	36,	35,	38,	8},
{16,	32,	38,	38,	9},
{17,	33,	38,	38,	8},
{17,	34,	38,	38,	8},
{17,	35,	38,	38,	9},
{17,	36,	33,	38,	9},
{16,	20,	36,	38,	24},
{16,	11,	33,	38,	37},
{23,	11,	35,	38,	36},
{18,	9,	35,	38,	37},
{17,	11,	36,	38,	35},
{16,	11,	2,	38,	39},
{16,	12,	6,	38,	36},
{17,	15,	3,	38,	36},
{16,	13,	4,	38,	36},
{16,	12,	2,	38,	39},
{17,	14,	3,	38,	37},
{17,	14,	3,	38,	38},
{18,	11,	7,	38,	38},
{16,	12,	5,	38,	38},
{16,	12,	9,	38,	35},
{16,	14,	3,	38,	39},
{16,	12,	5,	38,	39},
{16,	12,	21,	38,	34},
{16,	16,	15,	38,	33},
{16,	17,	13,	38,	29},
{16,	14,	17,	38,	34},
{18,	14,	5,	38,	36},
{17,	14,	7,	38,	36},
{17,	16,	35,	38,	32},
{17,	14,	21,	38,	34},
{17,	13,	34,	38,	34},
{18,	15,	23,	38,	33},
{17,	15,	36,	38,	30},
{19,	14,	36,	38,	32},
{18,	13,	36,	38,	33},
{17,	15,	37,	38,	27},
{17,	16,	36,	38,	30},
{17,	17,	36,	38,	30},
{17,	14,	35,	38,	34},
{16,	14,	4,	38,	37},
{16,	15,	7,	38,	34},
{16,	14,	5,	38,	37},
{16,	13,	6,	38,	37},
{16,	13,	8,	38,	36},
{17,	14,	8,	38,	36},
{16,	15,	7,	38,	35},
{16,	16,	7,	38,	34},
{16,	12,	8,	38,	37},
{16,	12,	12,	38,	37},
{16,	12,	13,	38,	36},
{16,	12,	17,	38,	35},
{16,	12,	20,	38,	35},
{16,	12,	24,	38,	37},
{19,	12,	27,	38,	36},
{19,	12,	35,	38,	35},
{16,	18,	28,	38,	32},
{19,	17,	15,	38,	33},
{19,	18,	36,	38,	27},
{19,	18,	36,	38,	30},
{18,	21,	10,	38,	26},
{17,	17,	35,	38,	32},
{16,	12,	37,	38,	30},
{16,	11,	39,	38,	29},
{16,	12,	38,	38,	29},
{16,	14,	30,	38,	36},
{20,	14,	35,	38,	35},
{19,	12,	35,	38,	36},
{18,	14,	33,	38,	36},
{17,	14,	36,	38,	35},
{17,	13,	37,	38,	34},
{19,	14,	37,	38,	33},
{16,	22,	37,	38,	22},
{16,	35,	37,	38,	10},
{16,	28,	18,	38,	11},
{18,	28,	21,	38,	11},
{17,	27,	16,	38,	14},
{19,	26,	27,	38,	12},
{16,	28,	21,	38,	12},
{16,	28,	17,	38,	13},
{16,	36,	34,	38,	10},
{16,	36,	35,	38,	9},
{17,	36,	35,	38,	10},
{16,	35,	39,	38,	8},
{16,	7,	36,	38,	39},
{18,	6,	37,	38,	38},
{18,	6,	37,	38,	39},
{18,	6,	38,	38,	38},
{16,	9,	12,	38,	38},
{18,	11,	11,	38,	38},
{17,	12,	11,	38,	38},
{16,	10,	12,	38,	39},
{16,	16,	33,	38,	33},
{16,	17,	27,	38,	33},
{16,	10,	35,	38,	37},
{16,	6,	38,	38,	39},
{16,	36,	36,	38,	12},
{19,	32,	37,	38,	12},
{18,	29,	38,	38,	11},
{16,	36,	38,	38,	6},
{17,	36,	37,	38,	7},
{17,	36,	37,	38,	10},
{17,	36,	37,	38,	11},
{16,	33,	37,	38,	12},
{16,	18,	37,	38,	30},
{18,	16,	37,	38,	33},
{17,	18,	36,	38,	31},
{16,	14,	35,	38,	36},
{16,	17,	37,	38,	32},
{16,	18,	35,	37,	36},
{20,	18,	36,	37,	36},
{20,	18,	37,	37,	36},
{19,	18,	8,	37,	37},
{18,	18,	39,	37,	35},
{17,	18,	12,	37,	37},
{16,	12,	39,	37,	38},
{17,	11,	39,	37,	39},
{16,	15,	37,	37,	37},
{16,	19,	36,	37,	35},
{21,	19,	39,	37,	35},
{16,	15,	36,	37,	39},
{17,	16,	38,	37,	39},
{17,	18,	6,	37,	38},
{16,	36,	37,	38,	18},
{17,	24,	15,	38,	20},
{17,	23,	18,	38,	23},
{18,	24,	35,	38,	19},
{17,	23,	38,	38,	16},
{17,	26,	38,	38,	14},
{17,	23,	36,	38,	23},
{16,	24,	36,	38,	22},
{19,	24,	37,	38,	22},
{16,	24,	13,	38,	24},
{16,	23,	35,	38,	24},
{17,	23,	37,	38,	24},
{16,	24,	14,	38,	25},
{16,	35,	39,	38,	12},
{18,	13,	39,	38,	28},
{18,	35,	38,	38,	13},
{17,	32,	39,	38,	13},
{20,	17,	39,	38,	17},
{16,	14,	39,	38,	23},
{16,	23,	39,	38,	14},
{17,	22,	39,	38,	16},
{16,	23,	39,	38,	19},
{16,	16,	38,	38,	25},
{16,	18,	38,	38,	22},
{16,	29,	38,	38,	14},
{16,	25,	39,	38,	18},
{16,	16,	38,	38,	29},
{16,	36,	38,	38,	10},
{16,	15,	38,	38,	31},
{16,	36,	38,	38,	11},
{16,	33,	39,	38,	14},
{16,	35,	39,	38,	16},
{18,	35,	38,	38,	17},
{17,	29,	39,	38,	18},
{17,	35,	38,	38,	18},
{17,	35,	39,	38,	18},
{16,	31,	37,	38,	23},
{20,	30,	38,	38,	19},
{19,	32,	25,	38,	22},
{18,	32,	34,	38,	19},
{17,	35,	36,	38,	22},
{22,	33,	37,	38,	21},
{20,	32,	32,	38,	23},
{18,	35,	37,	38,	19},
{18,	33,	37,	38,	22},
{17,	36,	34,	38,	19},
{20,	36,	33,	38,	21},
{17,	36,	37,	38,	19},
{17,	35,	38,	38,	19},
{17,	34,	39,	38,	19},
{17,	33,	38,	38,	22},
{19,	21,	38,	38,	24},
{17,	36,	37,	38,	20},
{18,	35,	38,	38,	22},
{16,	26,	14,	38,	25},
{18,	27,	16,	38,	24},
{16,	28,	17,	38,	24},
{17,	28,	20,	38,	24},
{19,	24,	37,	38,	24},
{16,	17,	36,	37,	39},
{17,	17,	37,	37,	39},
{17,	17,	38,	37,	39},
{16,	36,	33,	38,	22},
{16,	31,	37,	38,	24},
{16,	33,	30,	38,	24},
{17,	34,	30,	38,	23},
{17,	32,	37,	38,	24},
{17,	35,	36,	38,	23},
{17,	33,	33,	38,	24},
{17,	34,	35,	38,	24},
{18,	34,	36,	38,	24},
{17,	35,	37,	38,	23},
{17,	34,	38,	38,	23},
{17,	26,	38,	38,	24},
{17,	31,	38,	38,	24},
{16,	28,	37,	38,	25},
{18,	30,	21,	38,	25},
{17,	30,	23,	38,	25},
{17,	34,	36,	38,	25},
{16,	38,	35,	37,	20},
{16,	38,	36,	37,	4},
{16,	35,	32,	38,	25},
{16,	18,	39,	37,	36},
{16,	36,	33,	38,	23},
{16,	18,	37,	37,	39},
{18,	18,	38,	37,	39},
{16,	36,	37,	38,	21},
{16,	36,	34,	38,	24},
{19,	35,	34,	38,	25},
{17,	36,	36,	38,	22},
{17,	36,	36,	38,	23},
{17,	35,	35,	38,	25},
{16,	37,	39,	36,	21},
{17,	37,	39,	36,	29},
{16,	33,	37,	38,	25},
{16,	32,	38,	38,	25},
{16,	34,	37,	38,	24},
{16,	20,	38,	37,	39},
{17,	21,	8,	37,	36},
{18,	21,	8,	37,	39},
{17,	37,	38,	37,	39},
{16,	33,	37,	38,	26},
{18,	34,	30,	38,	26},
{16,	24,	38,	38,	26},
{17,	18,	38,	38,	29},
{16,	27,	38,	38,	26},
{16,	35,	36,	38,	25},
{17,	35,	37,	38,	24},
{16,	36,	36,	38,	24},
{16,	34,	37,	38,	25},
{16,	35,	38,	38,	24},
{16,	33,	38,	38,	26},
{16,	37,	39,	37,	24},
{16,	26,	39,	37,	35},
{18,	20,	39,	37,	36},
{17,	28,	39,	37,	35},
{17,	33,	39,	37,	34},
{17,	34,	39,	37,	34},
{16,	34,	38,	38,	28},
{18,	19,	6,	38,	33},
{18,	19,	9,	38,	31},
{18,	35,	35,	38,	26},
{17,	20,	8,	38,	31},
{16,	19,	36,	38,	29},
{16,	35,	34,	38,	27},
{17,	35,	35,	38,	27},
{16,	33,	39,	38,	28},
{22,	34,	39,	38,	23},
{18,	19,	39,	38,	29},
{16,	35,	39,	38,	20},
{17,	35,	39,	38,	21},
{17,	35,	39,	38,	22},
{16,	35,	39,	38,	23},
{16,	35,	38,	38,	27},
{16,	35,	36,	38,	29},
{19,	22,	39,	38,	29},
{21,	30,	37,	38,	29},
{19,	27,	38,	38,	29},
{18,	35,	37,	38,	28},
{16,	24,	36,	38,	30},
{19,	24,	37,	38,	30},
{16,	25,	15,	38,	30},
{16,	25,	36,	38,	30},
{16,	32,	39,	38,	29},
{16,	37,	39,	37,	25},
{16,	34,	37,	38,	29},
{16,	38,	35,	37,	29},
{16,	36,	37,	38,	29},
{16,	36,	36,	38,	31},
{17,	29,	37,	38,	30},
{17,	27,	39,	38,	30},
{17,	30,	38,	38,	30},
{17,	32,	37,	38,	30},
{17,	32,	39,	38,	30},
{16,	24,	37,	38,	31},
{16,	25,	38,	38,	31},
{16,	17,	39,	38,	32},
{17,	13,	38,	38,	34},
{17,	16,	38,	38,	33},
{17,	18,	39,	38,	32},
{17,	25,	39,	38,	31},
{17,	28,	39,	38,	31},
{16,	34,	37,	38,	31},
{16,	33,	38,	38,	30},
{17,	33,	39,	38,	30},
{16,	33,	38,	38,	31},
{16,	35,	37,	38,	31},
{16,	36,	36,	38,	33},
{20,	24,	37,	38,	32},
{21,	19,	38,	38,	33},
{19,	22,	39,	38,	32},
{18,	27,	38,	38,	32},
{17,	23,	37,	38,	33},
{19,	23,	38,	38,	33},
{17,	25,	37,	38,	33},
{17,	25,	38,	38,	33},
{17,	26,	38,	38,	33},
{17,	27,	38,	38,	33},
{17,	29,	38,	38,	33},
{16,	33,	37,	38,	33},
{17,	30,	38,	38,	32},
{17,	30,	38,	38,	33},
{17,	33,	38,	38,	33},
{17,	35,	37,	38,	33},
{16,	38,	35,	37,	33},
{16,	33,	39,	37,	35},
{16,	36,	39,	37,	33},
{19,	35,	39,	37,	34},
{16,	35,	39,	37,	36},
{17,	36,	39,	37,	39},
{16,	38,	35,	37,	37},
{17,	38,	35,	37,	39},
{16,	37,	39,	36,	38},
{17,	37,	39,	36,	39},
{15,	12,	7,	39,	22},
{17,	13,	3,	39,	25},
{16,	14,	3,	39,	20},
{16,	12,	8,	39,	24},
{16,	12,	15,	39,	27},
{18,	12,	37,	39,	4},
{16,	12,	27,	39,	7},
{15,	17,	12,	39,	8},
{19,	19,	6,	39,	8},
{18,	16,	7,	39,	10},
{18,	14,	19,	39,	4},
{18,	14,	15,	39,	9},
{17,	17,	14,	39,	6},
{17,	15,	3,	39,	27},
{16,	14,	6,	39,	14},
{16,	16,	19,	39,	3},
{16,	17,	15,	39,	8},
{16,	16,	34,	39,	2},
{15,	16,	4,	39,	15},
{15,	17,	16,	39,	7},
{15,	6,	39,	39,	1},
{18,	8,	39,	39,	1},
{16,	13,	39,	39,	0},
{16,	16,	39,	39,	0},
{16,	19,	39,	39,	0},
{17,	21,	39,	39,	0},
{15,	13,	16,	39,	19},
{15,	14,	10,	39,	16},
{15,	14,	21,	39,	10},
{17,	14,	24,	39,	9},
{17,	13,	19,	39,	15},
{16,	12,	36,	39,	12},
{15,	13,	6,	39,	27},
{15,	15,	3,	39,	31},
{15,	11,	2,	39,	36},
{18,	10,	10,	39,	33},
{18,	10,	11,	39,	34},
{17,	15,	3,	39,	33},
{16,	10,	7,	39,	36},
{16,	11,	4,	39,	38},
{18,	9,	7,	39,	37},
{16,	11,	7,	39,	34},
{16,	11,	11,	39,	34},
{17,	11,	21,	39,	32},
{17,	11,	21,	39,	33},
{17,	10,	26,	39,	33},
{16,	10,	36,	39,	27},
{15,	10,	2,	39,	39},
{16,	11,	4,	39,	39},
{18,	6,	6,	39,	39},
{16,	0,	10,	39,	39},
{16,	0,	28,	39,	39},
{19,	0,	31,	39,	39},
{15,	16,	37,	39,	1},
{16,	16,	38,	39,	1},
{15,	17,	35,	39,	2},
{17,	17,	38,	39,	1},
{15,	13,	14,	39,	28},
{15,	8,	12,	39,	36},
{19,	6,	15,	39,	36},
{15,	6,	10,	39,	37},
{15,	13,	12,	39,	32},
{15,	16,	7,	38,	35},
{15,	8,	13,	39,	36},
{15,	17,	37,	39,	4},
{17,	13,	36,	39,	10},
{18,	14,	36,	39,	7},
{16,	13,	29,	39,	14},
{16,	13,	37,	39,	10},
{16,	12,	38,	39,	12},
{17,	15,	38,	39,	3},
{16,	17,	38,	39,	3},
{16,	13,	38,	39,	8},
{15,	13,	24,	39,	16},
{15,	15,	35,	39,	5},
{15,	17,	24,	39,	6},
{17,	17,	36,	39,	5},
{15,	17,	25,	39,	7},
{15,	16,	24,	39,	8},
{15,	17,	32,	39,	7},
{15,	15,	6,	38,	38},
{16,	14,	7,	38,	38},
{15,	18,	5,	38,	36},
{17,	17,	5,	38,	38},
{15,	15,	5,	38,	39},
{15,	19,	6,	38,	35},
{15,	12,	24,	39,	27},
{16,	12,	28,	39,	25},
{16,	12,	38,	39,	17},
{17,	12,	38,	39,	18},
{15,	13,	24,	39,	19},
{15,	13,	35,	39,	14},
{15,	15,	16,	38,	35},
{19,	15,	24,	38,	34},
{15,	16,	9,	38,	34},
{15,	5,	23,	39,	37},
{16,	6,	19,	39,	36},
{16,	5,	33,	39,	36},
{15,	13,	35,	39,	17},
{15,	12,	22,	39,	32},
{16,	13,	16,	39,	30},
{15,	10,	20,	39,	37},
{18,	11,	22,	39,	34},
{17,	9,	23,	39,	35},
{17,	8,	28,	39,	35},
{16,	9,	38,	39,	34},
{18,	9,	30,	39,	35},
{16,	11,	24,	39,	34},
{16,	7,	29,	39,	36},
{19,	10,	22,	39,	36},
{17,	6,	23,	39,	37},
{16,	11,	37,	39,	34},
{17,	12,	35,	39,	30},
{17,	12,	38,	39,	20},
{17,	12,	36,	39,	29},
{17,	11,	38,	39,	31},
{16,	12,	35,	39,	32},
{16,	11,	38,	39,	33},
{15,	10,	6,	39,	38},
{15,	16,	17,	38,	35},
{18,	16,	34,	38,	34},
{16,	16,	36,	38,	34},
{16,	20,	36,	38,	34},
{17,	17,	8,	38,	35},
{16,	21,	8,	38,	34},
{15,	17,	13,	38,	35},
{15,	18,	10,	38,	35},
{15,	6,	24,	39,	37},
{17,	4,	31,	39,	37},
{15,	17,	17,	38,	35},
{16,	17,	35,	38,	35},
{17,	15,	36,	38,	35},
{17,	16,	36,	38,	35},
{15,	31,	38,	39,	0},
{16,	34,	36,	39,	0},
{18,	32,	38,	39,	0},
{18,	33,	37,	39,	0},
{18,	34,	37,	39,	0},
{16,	34,	38,	39,	0},
{15,	23,	38,	39,	3},
{18,	19,	15,	39,	5},
{17,	19,	11,	39,	8},
{18,	19,	16,	39,	8},
{16,	21,	8,	39,	8},
{17,	24,	11,	39,	4},
{16,	24,	38,	39,	3},
{15,	25,	18,	39,	3},
{15,	18,	26,	39,	7},
{18,	18,	38,	39,	4},
{15,	19,	31,	39,	4},
{15,	19,	31,	39,	5},
{15,	19,	18,	39,	10},
{17,	16,	32,	39,	9},
{16,	16,	29,	39,	10},
{15,	19,	20,	39,	9},
{15,	19,	39,	39,	1},
{15,	23,	33,	39,	4},
{15,	21,	12,	39,	10},
{17,	21,	16,	39,	7},
{15,	20,	22,	39,	7},
{15,	21,	23,	39,	6},
{15,	21,	27,	39,	6},
{15,	14,	26,	39,	26},
{16,	14,	31,	39,	16},
{15,	17,	5,	39,	18},
{17,	17,	4,	39,	27},
{16,	18,	16,	39,	11},
{18,	16,	31,	39,	12},
{18,	17,	14,	39,	13},
{16,	17,	6,	39,	20},
{16,	18,	18,	39,	12},
{16,	16,	31,	39,	13},
{15,	20,	13,	39,	11},
{16,	19,	17,	39,	12},
{15,	21,	11,	39,	12},
{15,	16,	6,	39,	24},
{15,	14,	7,	39,	31},
{15,	16,	4,	39,	31},
{15,	33,	34,	39,	1},
{17,	25,	36,	39,	2},
{16,	28,	36,	39,	1},
{17,	33,	37,	39,	1},
{15,	25,	37,	39,	3},
{15,	14,	38,	39,	16},
{15,	18,	38,	39,	5},
{15,	30,	39,	39,	0},
{16,	31,	39,	39,	0},
{15,	24,	39,	39,	1},
{15,	14,	38,	39,	17},
{16,	14,	33,	39,	20},
{17,	14,	34,	39,	23},
{16,	13,	36,	39,	26},
{19,	14,	36,	39,	23},
{17,	13,	36,	39,	30},
{17,	13,	35,	39,	32},
{16,	14,	37,	39,	19},
{16,	14,	35,	39,	27},
{15,	16,	19,	38,	36},
{16,	15,	34,	38,	36},
{17,	16,	21,	38,	36},
{16,	15,	36,	38,	36},
{16,	16,	35,	38,	36},
{15,	16,	7,	38,	37},
{15,	16,	8,	38,	37},
{15,	16,	7,	38,	38},
{15,	16,	9,	38,	38},
{15,	15,	11,	38,	38},
{17,	16,	11,	38,	37},
{17,	15,	13,	38,	37},
{15,	31,	38,	39,	1},
{17,	32,	38,	39,	1},
{15,	37,	34,	38,	0},
{15,	15,	37,	39,	19},
{19,	15,	20,	39,	23},
{19,	16,	11,	39,	23},
{19,	15,	38,	39,	14},
{17,	17,	36,	39,	7},
{16,	15,	21,	39,	24},
{16,	16,	11,	39,	26},
{15,	16,	15,	39,	19},
{15,	17,	37,	39,	7},
{16,	16,	37,	39,	12},
{16,	17,	37,	39,	8},
{15,	32,	39,	39,	0},
{15,	37,	34,	38,	1},
{15,	37,	36,	38,	0},
{15,	35,	37,	39,	0},
{16,	36,	38,	39,	0},
{15,	37,	34,	39,	0},
{15,	36,	35,	39,	1},
{16,	34,	37,	39,	1},
{16,	35,	37,	39,	1},
{15,	38,	35,	38,	0},
{15,	37,	37,	38,	0},
{16,	37,	38,	38,	0},
{15,	37,	36,	38,	1},
{16,	37,	37,	38,	1},
{16,	37,	38,	38,	1},
{15,	34,	39,	39,	0},
{15,	36,	39,	38,	0},
{15,	37,	36,	38,	3},
{16,	37,	34,	38,	4},
{16,	37,	34,	38,	5},
{16,	38,	35,	38,	3},
{16,	37,	34,	38,	6},
{16,	37,	34,	38,	7},
{16,	37,	34,	38,	16},
{16,	37,	34,	38,	18},
{15,	37,	37,	38,	2},
{15,	36,	38,	39,	2},
{16,	26,	15,	39,	4},
{15,	37,	36,	38,	4},
{15,	37,	38,	38,	2},
{16,	37,	38,	38,	3},
{15,	37,	35,	38,	6},
{15,	38,	36,	37,	5},
{15,	3,	38,	39,	36},
{17,	5,	38,	39,	35},
{16,	6,	36,	39,	36},
{18,	9,	34,	39,	35},
{15,	37,	36,	38,	5},
{15,	14,	36,	39,	27},
{15,	37,	37,	38,	5},
{16,	37,	37,	38,	6},
{15,	37,	35,	38,	7},
{15,	38,	36,	37,	7},
{17,	38,	36,	37,	8},
{16,	38,	36,	37,	15},
{15,	36,	39,	38,	5},
{15,	6,	36,	39,	37},
{15,	2,	39,	38,	39},
{15,	6,	38,	39,	35},
{15,	9,	35,	39,	35},
{15,	37,	38,	38,	6},
{15,	9,	36,	39,	35},
{15,	7,	38,	39,	35},
{15,	8,	36,	38,	37},
{15,	8,	35,	38,	39},
{16,	9,	29,	38,	39},
{16,	10,	17,	38,	38},
{16,	9,	35,	38,	39},
{16,	8,	36,	38,	39},
{15,	13,	34,	39,	35},
{19,	12,	3,	39,	38},
{17,	12,	35,	39,	35},
{16,	16,	4,	39,	34},
{16,	13,	35,	39,	35},
{15,	12,	4,	39,	37},
{15,	11,	34,	38,	38},
{16,	12,	26,	38,	38},
{16,	15,	12,	38,	38},
{15,	10,	19,	38,	39},
{15,	11,	37,	38,	35},
{15,	11,	36,	39,	35},
{15,	10,	35,	38,	39},
{15,	12,	39,	38,	33},
{15,	10,	39,	38,	34},
{16,	15,	39,	38,	34},
{15,	7,	39,	38,	39},
{16,	15,	39,	38,	35},
{15,	9,	39,	38,	36},
{16,	13,	37,	38,	36},
{16,	10,	39,	38,	36},
{15,	36,	39,	38,	10},
{16,	36,	39,	38,	11},
{15,	11,	36,	38,	38},
{16,	10,	36,	38,	39},
{16,	12,	36,	38,	38},
{15,	13,	35,	38,	37},
{17,	14,	18,	38,	37},
{16,	15,	15,	38,	37},
{16,	15,	16,	38,	37},
{15,	14,	20,	38,	37},
{15,	15,	19,	38,	37},
{15,	13,	36,	39,	35},
{15,	15,	36,	39,	34},
{15,	16,	7,	39,	31},
{15,	15,	16,	39,	35},
{15,	17,	4,	39,	35},
{15,	15,	22,	39,	35},
{15,	13,	36,	38,	37},
{15,	10,	38,	38,	39},
{19,	9,	39,	38,	37},
{18,	11,	37,	38,	37},
{16,	10,	39,	38,	37},
{16,	13,	37,	38,	37},
{16,	10,	39,	38,	38},
{17,	10,	39,	38,	39},
{15,	36,	38,	38,	13},
{15,	15,	36,	38,	39},
{16,	16,	8,	38,	39},
{15,	16,	30,	38,	37},
{16,	16,	34,	38,	37},
{15,	16,	12,	38,	39},
{15,	11,	37,	38,	39},
{15,	14,	37,	38,	37},
{15,	11,	39,	38,	39},
{15,	16,	36,	38,	37},
{15,	13,	38,	38,	39},
{15,	12,	39,	38,	36},
{15,	14,	38,	38,	37},
{15,	36,	38,	38,	16},
{15,	16,	36,	38,	39},
{15,	15,	38,	38,	39},
{15,	19,	39,	38,	34},
{17,	20,	37,	38,	34},
{15,	16,	39,	38,	35},
{15,	16,	37,	38,	39},
{16,	16,	38,	38,	37},
{15,	16,	38,	38,	39},
{15,	17,	38,	38,	39},
{15,	18,	36,	38,	35},
{15,	18,	38,	38,	35},
{15,	21,	39,	38,	34},
{15,	22,	9,	38,	34},
{15,	36,	38,	38,	20},
{16,	36,	38,	38,	21},
{15,	25,	37,	38,	34},
{15,	28,	36,	38,	34},
{15,	27,	37,	38,	34},
{15,	29,	36,	38,	34},
{16,	30,	21,	38,	34},
{15,	28,	37,	38,	34},
{15,	28,	39,	38,	32},
{15,	35,	38,	38,	28},
{15,	30,	38,	38,	34},
{16,	35,	37,	38,	34},
{20,	31,	38,	38,	34},
{16,	36,	33,	38,	34},
{16,	36,	35,	38,	34},
{16,	36,	36,	38,	34},
{16,	35,	38,	38,	34},
{15,	22,	39,	38,	34},
{15,	25,	39,	38,	34},
{18,	28,	39,	38,	33},
{16,	35,	39,	38,	33},
{15,	36,	39,	38,	26},
{17,	36,	39,	38,	29},
{16,	36,	38,	38,	32},
{16,	36,	39,	38,	31},
{15,	37,	39,	37,	27},
{16,	37,	39,	37,	35},
{15,	38,	36,	37,	34},
{15,	36,	37,	38,	34},
{15,	36,	38,	38,	33},
{15,	38,	36,	37,	35},
{16,	38,	36,	37,	39},
{15,	36,	38,	38,	35},
{15,	25,	39,	38,	35},
{15,	37,	34,	38,	35},
{15,	35,	39,	38,	35},
{15,	37,	39,	37,	37},
{16,	37,	39,	37,	39},
{15,	37,	38,	38,	39},
{17,	38,	35,	38,	10},
{14,	25,	13,	39,	5},
{17,	22,	16,	39,	7},
{14,	17,	11,	39,	16},
{14,	23,	20,	39,	5},
{14,	1,	12,	39,	39},
{14,	12,	5,	39,	37},
{16,	11,	6,	39,	37},
{15,	12,	5,	39,	38},
{15,	11,	9,	39,	37},
{15,	11,	10,	39,	37},
{15,	11,	11,	39,	37},
{15,	12,	29,	39,	36},
{16,	12,	8,	39,	37},
{15,	14,	9,	39,	37},
{17,	14,	10,	39,	36},
{16,	12,	11,	39,	37},
{16,	14,	21,	39,	36},
{17,	13,	24,	39,	36},
{15,	15,	5,	39,	37},
{16,	17,	4,	39,	36},
{15,	15,	3,	39,	38},
{16,	15,	4,	39,	38},
{16,	13,	6,	39,	38},
{15,	16,	5,	39,	37},
{14,	23,	27,	39,	5},
{14,	12,	6,	39,	39},
{14,	15,	6,	39,	36},
{15,	15,	12,	39,	36},
{15,	15,	8,	39,	37},
{16,	15,	6,	39,	38},
{14,	17,	5,	39,	36},
{16,	17,	7,	39,	30},
{16,	18,	5,	39,	33},
{14,	16,	7,	39,	36},
{16,	17,	8,	39,	33},
{15,	16,	9,	39,	34},
{15,	16,	8,	39,	37},
{14,	16,	5,	39,	38},
{14,	17,	8,	39,	34},
{14,	12,	11,	39,	38},
{18,	15,	8,	39,	38},
{15,	4,	9,	39,	39},
{15,	7,	11,	39,	39},
{15,	15,	9,	39,	38},
{14,	4,	12,	39,	38},
{15,	10,	13,	39,	38},
{14,	10,	8,	39,	39},
{14,	7,	12,	39,	39},
{14,	2,	19,	39,	38},
{15,	1,	21,	39,	39},
{14,	6,	13,	39,	39},
{14,	3,	15,	39,	39},
{14,	5,	15,	39,	38},
{15,	9,	14,	39,	38},
{14,	10,	10,	39,	39},
{14,	11,	10,	39,	39},
{15,	13,	9,	39,	39},
{14,	16,	7,	39,	38},
{14,	19,	6,	39,	37},
{19,	19,	12,	39,	15},
{18,	21,	8,	39,	17},
{17,	20,	7,	39,	23},
{15,	20,	13,	39,	14},
{15,	17,	8,	39,	37},
{14,	19,	8,	39,	22},
{14,	18,	7,	39,	34},
{14,	18,	37,	39,	7},
{14,	12,	12,	39,	38},
{16,	11,	13,	39,	38},
{15,	14,	12,	39,	37},
{15,	14,	13,	39,	37},
{14,	15,	10,	39,	37},
{14,	18,	37,	39,	8},
{15,	18,	36,	39,	13},
{18,	19,	26,	39,	11},
{17,	17,	37,	39,	12},
{14,	19,	29,	39,	11},
{14,	22,	37,	39,	5},
{17,	20,	35,	39,	7},
{15,	21,	38,	39,	4},
{14,	20,	38,	39,	5},
{14,	15,	11,	39,	38},
{14,	14,	13,	39,	38},
{14,	1,	26,	39,	38},
{15,	1,	29,	39,	38},
{14,	21,	36,	39,	9},
{14,	21,	37,	39,	8},
{14,	21,	38,	39,	7},
{16,	16,	38,	39,	12},
{15,	17,	38,	39,	11},
{14,	11,	19,	39,	37},
{16,	13,	14,	39,	37},
{14,	14,	15,	39,	37},
{14,	16,	38,	39,	13},
{14,	16,	37,	39,	16},
{17,	16,	26,	39,	19},
{16,	16,	35,	39,	19},
{15,	16,	38,	39,	16},
{14,	16,	28,	39,	25},
{18,	16,	35,	39,	25},
{14,	16,	19,	39,	32},
{14,	10,	22,	39,	37},
{15,	8,	35,	39,	37},
{15,	9,	24,	39,	37},
{15,	11,	25,	39,	37},
{15,	9,	28,	39,	37},
{15,	10,	35,	39,	37},
{17,	11,	35,	39,	36},
{15,	11,	27,	39,	37},
{14,	1,	29,	39,	39},
{15,	1,	31,	39,	39},
{14,	14,	38,	39,	19},
{14,	13,	22,	39,	37},
{16,	12,	24,	39,	37},
{15,	13,	24,	39,	37},
{14,	16,	37,	39,	19},
{16,	16,	36,	39,	25},
{14,	37,	34,	39,	1},
{14,	38,	36,	38,	0},
{14,	34,	36,	39,	3},
{15,	35,	38,	39,	3},
{14,	27,	18,	39,	4},
{14,	38,	36,	38,	1},
{14,	0,	36,	39,	38},
{14,	34,	39,	39,	1},
{14,	35,	39,	39,	0},
{14,	37,	38,	39,	0},
{14,	37,	35,	39,	2},
{15,	37,	38,	39,	1},
{17,	37,	36,	39,	2},
{14,	37,	39,	38,	0},
{15,	37,	39,	38,	12},
{14,	0,	37,	39,	38},
{15,	0,	38,	39,	37},
{14,	37,	35,	39,	3},
{16,	36,	36,	39,	3},
{14,	1,	36,	39,	38},
{14,	13,	26,	39,	36},
{14,	35,	37,	39,	4},
{16,	36,	36,	39,	4},
{16,	36,	37,	39,	4},
{15,	24,	28,	39,	5},
{14,	23,	36,	39,	5},
{14,	32,	38,	39,	4},
{16,	33,	38,	39,	4},
{14,	0,	38,	39,	38},
{14,	37,	37,	39,	2},
{15,	37,	38,	39,	2},
{14,	1,	37,	39,	38},
{14,	2,	36,	39,	38},
{14,	37,	36,	39,	3},
{14,	36,	38,	39,	3},
{15,	36,	38,	39,	4},
{14,	35,	38,	39,	5},
{14,	5,	37,	39,	36},
{14,	6,	37,	39,	36},
{14,	34,	38,	39,	8},
{20,	35,	36,	39,	6},
{16,	35,	32,	39,	8},
{16,	35,	37,	39,	6},
{16,	35,	37,	39,	7},
{16,	35,	38,	39,	7},
{15,	22,	10,	39,	12},
{16,	23,	19,	39,	9},
{15,	35,	38,	39,	8},
{14,	22,	15,	39,	10},
{14,	20,	17,	39,	12},
{14,	22,	31,	39,	9},
{14,	25,	20,	39,	9},
{14,	19,	38,	39,	9},
{14,	18,	38,	39,	12},
{14,	20,	37,	39,	10},
{15,	20,	38,	39,	10},
{14,	21,	38,	39,	9},
{14,	22,	37,	39,	9},
{14,	23,	32,	39,	9},
{15,	25,	36,	39,	9},
{15,	27,	35,	39,	9},
{14,	29,	19,	39,	9},
{14,	36,	38,	39,	7},
{15,	36,	38,	39,	8},
{14,	37,	35,	39,	8},
{14,	37,	37,	39,	7},
{14,	37,	36,	39,	8},
{14,	13,	32,	39,	36},
{15,	13,	36,	39,	36},
{16,	7,	36,	39,	37},
{14,	36,	38,	39,	9},
{14,	16,	38,	39,	29},
{18,	15,	38,	39,	30},
{15,	16,	35,	39,	33},
{16,	16,	38,	39,	30},
{15,	16,	36,	39,	33},
{14,	16,	22,	39,	34},
{15,	16,	37,	39,	34},
{16,	12,	38,	39,	33},
{14,	16,	12,	39,	36},
{16,	16,	15,	39,	35},
{14,	17,	9,	39,	35},
{14,	19,	9,	39,	22},
{14,	16,	11,	39,	38},
{14,	18,	36,	39,	27},
{18,	18,	12,	39,	31},
{16,	19,	9,	39,	29},
{16,	17,	11,	39,	34},
{15,	19,	17,	39,	21},
{15,	19,	22,	39,	14},
{15,	19,	20,	39,	20},
{15,	17,	11,	39,	35},
{15,	17,	37,	39,	15},
{15,	18,	37,	39,	14},
{15,	17,	36,	39,	28},
{14,	20,	14,	39,	17},
{14,	20,	19,	39,	14},
{14,	17,	37,	39,	28},
{14,	20,	38,	39,	17},
{15,	19,	25,	39,	21},
{14,	21,	38,	39,	12},
{14,	20,	37,	39,	18},
{14,	17,	38,	39,	20},
{15,	20,	38,	39,	18},
{15,	17,	38,	39,	28},
{14,	20,	36,	39,	27},
{16,	20,	8,	39,	31},
{15,	21,	8,	39,	26},
{14,	20,	7,	39,	33},
{15,	21,	8,	39,	33},
{15,	18,	9,	39,	34},
{14,	19,	9,	39,	34},
{14,	19,	37,	39,	20},
{15,	19,	37,	39,	24},
{16,	18,	38,	39,	24},
{17,	18,	38,	39,	27},
{16,	19,	37,	39,	27},
{14,	37,	37,	39,	9},
{14,	38,	35,	39,	9},
{14,	11,	37,	39,	35},
{18,	9,	38,	39,	35},
{15,	12,	38,	39,	35},
{15,	13,	37,	39,	35},
{15,	15,	38,	39,	34},
{17,	13,	38,	39,	35},
{14,	10,	36,	39,	37},
{14,	17,	37,	39,	31},
{15,	18,	38,	39,	30},
{14,	20,	16,	39,	30},
{15,	19,	36,	39,	29},
{14,	17,	35,	39,	34},
{18,	17,	37,	39,	33},
{16,	17,	37,	39,	34},
{14,	17,	12,	39,	35},
{14,	17,	14,	39,	35},
{14,	19,	36,	39,	31},
{15,	20,	17,	39,	31},
{15,	19,	37,	39,	30},
{14,	20,	36,	39,	31},
{14,	18,	38,	39,	31},
{14,	16,	38,	39,	33},
{14,	20,	38,	39,	31},
{14,	27,	37,	39,	21},
{18,	28,	18,	39,	13},
{18,	21,	12,	39,	28},
{16,	21,	9,	39,	33},
{16,	27,	38,	39,	10},
{15,	23,	10,	39,	24},
{15,	28,	17,	39,	19},
{15,	24,	38,	39,	11},
{14,	29,	20,	39,	10},
{14,	22,	17,	39,	22},
{14,	30,	27,	39,	10},
{14,	28,	21,	39,	12},
{14,	30,	29,	39,	10},
{14,	21,	38,	39,	15},
{14,	26,	38,	39,	11},
{14,	21,	38,	39,	18},
{14,	22,	35,	39,	23},
{16,	22,	37,	39,	22},
{16,	22,	37,	39,	23},
{15,	21,	22,	39,	29},
{15,	21,	37,	39,	26},
{18,	21,	35,	39,	29},
{14,	24,	38,	39,	19},
{14,	27,	38,	39,	14},
{16,	27,	38,	39,	15},
{14,	25,	38,	39,	19},
{14,	22,	37,	39,	24},
{14,	25,	38,	39,	20},
{15,	22,	38,	39,	24},
{16,	25,	38,	39,	21},
{14,	21,	33,	39,	30},
{14,	36,	38,	39,	12},
{15,	28,	29,	39,	13},
{14,	37,	35,	39,	11},
{14,	35,	38,	39,	13},
{14,	36,	37,	39,	13},
{14,	22,	37,	39,	27},
{15,	24,	11,	39,	27},
{15,	22,	38,	39,	26},
{15,	21,	37,	39,	29},
{14,	22,	9,	39,	33},
{14,	23,	36,	39,	22},
{14,	23,	38,	39,	25},
{17,	23,	24,	39,	27},
{15,	25,	13,	39,	24},
{15,	24,	27,	39,	23},
{15,	26,	18,	39,	22},
{14,	24,	27,	39,	24},
{14,	36,	38,	39,	13},
{14,	37,	39,	38,	14},
{14,	16,	39,	38,	36},
{14,	24,	37,	39,	31},
{18,	24,	38,	39,	26},
{15,	24,	38,	39,	27},
{16,	21,	38,	39,	31},
{14,	25,	13,	39,	28},
{14,	26,	37,	39,	26},
{15,	25,	25,	39,	29},
{17,	25,	37,	39,	27},
{15,	26,	16,	39,	29},
{16,	26,	22,	39,	29},
{15,	27,	16,	39,	28},
{14,	27,	35,	39,	22},
{15,	27,	17,	39,	26},
{14,	27,	36,	39,	27},
{18,	27,	37,	39,	25},
{15,	26,	29,	39,	28},
{14,	27,	38,	39,	25},
{14,	25,	38,	39,	27},
{14,	21,	38,	39,	32},
{14,	18,	14,	39,	33},
{14,	18,	11,	39,	34},
{14,	22,	36,	39,	33},
{17,	19,	13,	39,	34},
{18,	19,	17,	39,	34},
{14,	23,	13,	39,	32},
{14,	19,	38,	39,	33},
{14,	20,	37,	39,	33},
{14,	24,	38,	39,	29},
{15,	22,	38,	39,	33},
{14,	37,	39,	38,	17},
{14,	23,	38,	39,	31},
{14,	36,	38,	39,	19},
{15,	29,	36,	39,	20},
{15,	30,	26,	39,	20},
{15,	29,	38,	39,	24},
{18,	30,	25,	39,	22},
{16,	30,	32,	39,	22},
{14,	28,	18,	39,	27},
{14,	28,	18,	39,	28},
{14,	29,	23,	39,	25},
{14,	29,	20,	39,	26},
{14,	29,	28,	39,	25},
{15,	30,	30,	39,	25},
{14,	30,	30,	39,	26},
{16,	29,	36,	39,	26},
{15,	30,	33,	39,	25},
{15,	28,	38,	39,	25},
{14,	30,	36,	39,	20},
{14,	31,	38,	39,	20},
{16,	32,	29,	39,	20},
{15,	32,	25,	39,	21},
{15,	32,	25,	39,	22},
{15,	31,	25,	39,	26},
{14,	33,	28,	39,	21},
{15,	31,	28,	39,	24},
{15,	33,	27,	39,	22},
{14,	30,	37,	39,	22},
{15,	35,	37,	39,	22},
{16,	32,	38,	39,	21},
{15,	36,	33,	39,	21},
{15,	31,	38,	39,	22},
{15,	35,	38,	39,	20},
{14,	33,	29,	39,	24},
{14,	33,	30,	39,	23},
{14,	30,	36,	39,	23},
{14,	30,	37,	39,	23},
{14,	30,	37,	39,	24},
{14,	28,	36,	39,	27},
{14,	28,	27,	39,	28},
{14,	36,	33,	39,	22},
{14,	31,	37,	39,	24},
{14,	33,	32,	39,	24},
{14,	32,	36,	39,	23},
{15,	32,	36,	39,	24},
{14,	31,	36,	39,	25},
{15,	32,	27,	39,	26},
{14,	23,	37,	39,	33},
{14,	27,	37,	39,	30},
{14,	26,	15,	39,	33},
{16,	27,	19,	39,	31},
{14,	28,	37,	39,	27},
{14,	25,	37,	39,	31},
{15,	26,	31,	39,	31},
{14,	37,	39,	38,	19},
{14,	20,	39,	38,	36},
{14,	27,	38,	39,	29},
{15,	28,	38,	39,	27},
{14,	26,	38,	39,	30},
{14,	25,	38,	39,	31},
{14,	18,	39,	38,	39},
{18,	19,	39,	38,	37},
{16,	19,	39,	38,	39},
{14,	36,	38,	39,	21},
{15,	35,	38,	39,	22},
{14,	37,	39,	38,	21},
{14,	36,	38,	39,	24},
{14,	31,	38,	39,	25},
{15,	29,	38,	39,	26},
{14,	32,	38,	39,	25},
{14,	37,	39,	38,	23},
{14,	33,	37,	39,	29},
{18,	32,	38,	39,	26},
{17,	31,	38,	39,	27},
{15,	34,	29,	39,	29},
{15,	28,	38,	39,	29},
{14,	29,	19,	39,	31},
{14,	28,	37,	39,	30},
{15,	28,	38,	39,	30},
{14,	28,	37,	39,	31},
{15,	33,	37,	39,	31},
{15,	35,	37,	39,	31},
{15,	34,	38,	39,	26},
{15,	36,	37,	39,	26},
{17,	36,	38,	39,	26},
{17,	36,	33,	39,	31},
{15,	36,	37,	39,	27},
{16,	36,	34,	39,	30},
{15,	36,	36,	39,	29},
{17,	36,	35,	39,	30},
{15,	36,	37,	39,	29},
{14,	29,	38,	39,	30},
{15,	36,	38,	39,	29},
{14,	28,	38,	39,	31},
{14,	30,	37,	39,	32},
{21,	31,	36,	39,	32},
{17,	24,	25,	39,	33},
{15,	30,	38,	39,	32},
{16,	23,	38,	39,	33},
{14,	27,	16,	39,	33},
{14,	37,	39,	38,	24},
{14,	31,	38,	39,	33},
{14,	32,	38,	39,	31},
{15,	33,	38,	39,	30},
{14,	37,	39,	38,	27},
{14,	33,	38,	39,	31},
{14,	34,	38,	39,	31},
{15,	35,	38,	39,	30},
{14,	33,	37,	39,	34},
{18,	33,	38,	39,	33},
{16,	34,	30,	39,	32},
{15,	35,	36,	39,	33},
{21,	34,	37,	39,	33},
{16,	34,	38,	39,	32},
{14,	22,	35,	39,	35},
{16,	24,	12,	39,	35},
{15,	16,	36,	39,	35},
{14,	19,	7,	39,	36},
{15,	20,	7,	39,	36},
{14,	18,	10,	39,	36},
{14,	19,	9,	39,	36},
{14,	20,	9,	39,	36},
{14,	15,	24,	39,	37},
{16,	14,	27,	39,	36},
{15,	15,	14,	39,	38},
{14,	16,	14,	39,	38},
{15,	16,	15,	39,	37},
{14,	16,	20,	39,	37},
{16,	16,	23,	39,	36},
{15,	16,	35,	39,	36},
{14,	15,	26,	39,	37},
{14,	14,	36,	39,	36},
{15,	16,	36,	39,	36},
{14,	17,	36,	39,	36},
{15,	20,	36,	39,	35},
{14,	17,	11,	39,	37},
{14,	22,	36,	39,	35},
{14,	36,	33,	39,	32},
{14,	35,	34,	39,	34},
{16,	34,	36,	39,	34},
{14,	36,	38,	39,	30},
{14,	35,	35,	39,	34},
{15,	35,	37,	39,	34},
{14,	37,	39,	38,	30},
{15,	37,	39,	38,	31},
{14,	35,	38,	39,	32},
{14,	34,	38,	39,	33},
{15,	35,	38,	39,	33},
{14,	36,	37,	39,	34},
{14,	36,	38,	39,	31},
{14,	36,	38,	39,	32},
{14,	36,	38,	39,	33},
{14,	31,	39,	38,	39},
{19,	32,	39,	38,	36},
{15,	32,	39,	38,	39},
{15,	35,	39,	38,	37},
{15,	33,	39,	38,	39},
{15,	34,	39,	38,	39},
{16,	35,	39,	38,	39},
{15,	36,	39,	38,	39},
{15,	37,	39,	38,	33},
{15,	37,	39,	38,	35},
{15,	37,	39,	38,	39},
{14,	38,	37,	36,	39},
{15,	38,	37,	37,	0},
{17,	38,	37,	37,	1},
{14,	38,	37,	37,	2},
{15,	38,	37,	37,	3},
{14,	38,	37,	37,	4},
{15,	38,	37,	37,	6},
{14,	38,	37,	37,	7},
{15,	38,	37,	37,	8},
{14,	38,	37,	37,	9},
{14,	38,	37,	37,	10},
{14,	38,	37,	37,	11},
{14,	38,	37,	37,	12},
{14,	38,	37,	37,	14},
{14,	38,	37,	37,	16},
{14,	38,	37,	37,	17},
{14,	38,	37,	37,	18},
{14,	38,	37,	37,	20},
{14,	38,	37,	37,	33},
{15,	38,	37,	37,	39},
{14,	38,	38,	36,	39},
{14,	38,	38,	37,	0},
{15,	38,	38,	37,	6},
{14,	38,	38,	37,	9},
{14,	38,	38,	37,	11},
{14,	38,	38,	37,	13},
{14,	38,	38,	37,	25},
{14,	38,	38,	37,	27},
{14,	38,	38,	37,	30},
{14,	38,	38,	37,	31},
{14,	38,	38,	37,	33},
{15,	38,	38,	37,	39},
{13,	3,	18,	39,	39},
{13,	4,	17,	39,	39},
{13,	5,	17,	39,	38},
{13,	19,	6,	39,	38},
{14,	19,	10,	39,	38},
{14,	20,	8,	39,	37},
{14,	21,	10,	39,	36},
{14,	18,	11,	39,	38},
{14,	23,	10,	39,	36},
{13,	16,	9,	39,	39},
{13,	9,	17,	39,	38},
{16,	11,	16,	39,	38},
{14,	11,	17,	39,	38},
{14,	15,	15,	39,	38},
{13,	15,	10,	39,	39},
{13,	20,	7,	39,	38},
{13,	15,	12,	39,	39},
{14,	11,	14,	39,	39},
{16,	12,	15,	39,	39},
{14,	7,	17,	39,	39},
{14,	6,	18,	39,	39},
{13,	11,	16,	39,	39},
{13,	20,	8,	39,	38},
{13,	17,	12,	39,	38},
{13,	11,	18,	39,	38},
{14,	13,	18,	39,	38},
{13,	17,	14,	39,	37},
{13,	14,	18,	39,	38},
{13,	8,	39,	39,	25},
{17,	15,	39,	39,	2},
{14,	25,	39,	39,	2},
{15,	27,	39,	39,	2},
{14,	28,	39,	39,	2},
{13,	19,	39,	39,	3},
{13,	20,	39,	39,	12},
{14,	13,	39,	39,	16},
{13,	21,	39,	39,	5},
{13,	14,	39,	39,	16},
{13,	24,	12,	39,	36},
{15,	19,	11,	39,	37},
{13,	18,	12,	39,	37},
{13,	19,	13,	39,	36},
{13,	0,	34,	39,	39},
{15,	1,	34,	39,	39},
{14,	0,	35,	39,	39},
{13,	38,	37,	38,	0},
{13,	38,	36,	39,	0},
{13,	17,	39,	39,	18},
{15,	11,	39,	39,	25},
{15,	12,	39,	39,	23},
{13,	33,	39,	39,	2},
{14,	31,	39,	39,	3},
{16,	23,	39,	39,	5},
{15,	33,	39,	39,	3},
{13,	38,	38,	38,	0},
{13,	36,	39,	39,	0},
{13,	35,	39,	39,	1},
{13,	38,	38,	38,	1},
{13,	37,	39,	39,	0},
{14,	37,	39,	39,	1},
{13,	38,	36,	38,	3},
{13,	38,	37,	38,	2},
{13,	35,	39,	39,	2},
{17,	34,	39,	39,	3},
{14,	36,	39,	39,	2},
{13,	2,	37,	39,	37},
{14,	2,	37,	39,	38},
{13,	12,	27,	39,	37},
{13,	0,	38,	39,	39},
{13,	1,	36,	39,	39},
{13,	4,	34,	39,	39},
{17,	3,	36,	39,	38},
{14,	2,	36,	39,	39},
{13,	16,	20,	39,	38},
{15,	5,	22,	39,	39},
{15,	8,	21,	39,	38},
{14,	8,	22,	39,	38},
{14,	6,	36,	39,	38},
{13,	7,	21,	39,	39},
{14,	8,	21,	39,	39},
{15,	12,	17,	39,	39},
{15,	12,	19,	39,	39},
{13,	5,	28,	39,	39},
{13,	12,	24,	39,	38},
{16,	14,	23,	39,	38},
{14,	13,	25,	39,	38},
{13,	34,	39,	39,	4},
{13,	25,	39,	39,	5},
{13,	2,	38,	39,	37},
{14,	3,	38,	39,	37},
{13,	1,	38,	39,	39},
{16,	2,	38,	39,	38},
{13,	37,	38,	39,	3},
{14,	37,	38,	39,	4},
{14,	37,	38,	39,	5},
{13,	36,	39,	39,	3},
{14,	35,	39,	39,	4},
{13,	3,	37,	39,	38},
{13,	2,	37,	39,	39},
{14,	2,	38,	39,	39},
{13,	4,	37,	39,	37},
{13,	4,	38,	39,	36},
{13,	25,	39,	39,	15},
{17,	23,	39,	39,	16},
{15,	19,	39,	39,	18},
{15,	25,	39,	39,	17},
{13,	18,	39,	39,	21},
{14,	17,	39,	39,	22},
{14,	21,	39,	39,	25},
{13,	16,	26,	39,	37},
{14,	16,	21,	39,	38},
{13,	15,	22,	39,	38},
{13,	16,	22,	39,	38},
{13,	3,	38,	39,	38},
{13,	36,	39,	39,	5},
{16,	28,	39,	39,	7},
{15,	30,	39,	39,	6},
{14,	26,	39,	39,	11},
{13,	3,	38,	39,	39},
{13,	4,	37,	39,	39},
{13,	5,	37,	39,	38},
{14,	6,	37,	39,	38},
{13,	26,	39,	39,	15},
{13,	19,	24,	39,	38},
{14,	18,	32,	39,	36},
{15,	18,	36,	39,	36},
{14,	19,	30,	39,	36},
{15,	19,	36,	39,	36},
{13,	19,	19,	39,	39},
{13,	20,	8,	39,	39},
{13,	20,	21,	39,	36},
{15,	21,	13,	39,	36},
{14,	20,	26,	39,	36},
{14,	20,	34,	39,	36},
{14,	20,	36,	39,	36},
{13,	16,	25,	39,	38},
{13,	16,	26,	39,	38},
{13,	38,	36,	38,	8},
{14,	38,	36,	38,	9},
{13,	38,	38,	38,	5},
{13,	36,	39,	39,	6},
{13,	5,	37,	39,	39},
{13,	8,	37,	39,	36},
{13,	19,	25,	39,	37},
{13,	15,	29,	39,	38},
{17,	11,	30,	39,	38},
{16,	16,	27,	39,	38},
{16,	15,	30,	39,	37},
{15,	8,	32,	39,	38},
{15,	8,	34,	39,	38},
{14,	10,	35,	39,	38},
{15,	11,	32,	39,	38},
{13,	13,	30,	39,	38},
{13,	9,	37,	39,	36},
{13,	26,	39,	39,	17},
{13,	37,	38,	39,	8},
{15,	37,	38,	39,	9},
{13,	9,	38,	39,	36},
{13,	5,	38,	39,	37},
{13,	4,	38,	39,	38},
{13,	5,	38,	39,	39},
{13,	9,	37,	39,	37},
{14,	10,	37,	39,	37},
{13,	9,	36,	39,	38},
{13,	7,	36,	39,	39},
{13,	38,	36,	38,	11},
{13,	37,	36,	39,	11},
{14,	37,	38,	39,	11},
{13,	11,	37,	39,	36},
{13,	10,	38,	39,	36},
{13,	36,	39,	39,	10},
{14,	35,	39,	39,	24},
{15,	25,	39,	39,	25},
{14,	34,	39,	39,	25},
{14,	35,	39,	39,	26},
{15,	6,	39,	39,	27},
{16,	15,	39,	39,	27},
{13,	18,	29,	39,	38},
{16,	18,	30,	39,	37},
{14,	19,	29,	39,	37},
{13,	11,	37,	39,	37},
{13,	11,	34,	39,	38},
{13,	12,	37,	39,	36},
{13,	37,	35,	39,	14},
{15,	38,	35,	39,	12},
{15,	37,	35,	39,	15},
{14,	37,	38,	39,	16},
{13,	13,	35,	39,	38},
{18,	16,	32,	39,	37},
{15,	14,	35,	39,	37},
{14,	17,	32,	39,	37},
{15,	17,	33,	39,	37},
{14,	15,	35,	39,	37},
{13,	23,	27,	39,	37},
{18,	23,	36,	39,	35},
{17,	21,	36,	39,	36},
{15,	22,	33,	39,	36},
{16,	23,	30,	39,	36},
{15,	23,	28,	39,	37},
{14,	23,	30,	39,	37},
{14,	23,	33,	39,	36},
{14,	22,	35,	39,	36},
{13,	24,	11,	39,	37},
{13,	24,	12,	39,	37},
{13,	25,	14,	39,	35},
{15,	26,	14,	39,	35},
{13,	25,	13,	39,	36},
{15,	24,	14,	39,	36},
{13,	15,	39,	39,	33},
{18,	18,	39,	39,	30},
{15,	21,	39,	39,	29},
{14,	19,	39,	39,	32},
{15,	18,	39,	39,	33},
{13,	14,	39,	39,	34},
{13,	14,	38,	39,	35},
{14,	15,	38,	39,	35},
{13,	15,	36,	39,	37},
{13,	13,	36,	39,	38},
{13,	36,	39,	39,	13},
{13,	16,	38,	39,	34},
{13,	15,	39,	39,	34},
{13,	16,	38,	39,	35},
{14,	22,	37,	39,	35},
{13,	20,	32,	39,	37},
{15,	20,	33,	39,	37},
{14,	18,	36,	39,	37},
{14,	23,	32,	39,	37},
{13,	36,	39,	39,	14},
{13,	22,	39,	39,	29},
{14,	34,	39,	39,	32},
{15,	21,	39,	39,	33},
{14,	35,	39,	39,	27},
{14,	35,	39,	39,	28},
{14,	36,	39,	39,	31},
{13,	20,	34,	39,	37},
{13,	19,	35,	39,	37},
{13,	37,	38,	39,	17},
{13,	37,	36,	39,	20},
{14,	37,	38,	39,	18},
{14,	37,	34,	39,	22},
{14,	37,	38,	39,	19},
{13,	38,	35,	39,	20},
{18,	38,	35,	38,	29},
{13,	37,	36,	39,	21},
{13,	37,	35,	39,	22},
{13,	22,	36,	39,	37},
{14,	23,	35,	39,	37},
{13,	37,	38,	39,	20},
{13,	37,	36,	39,	22},
{13,	23,	36,	39,	36},
{13,	37,	36,	39,	23},
{14,	37,	34,	39,	26},
{14,	37,	36,	39,	25},
{14,	37,	35,	39,	27},
{16,	37,	36,	39,	26},
{14,	38,	35,	39,	26},
{13,	26,	35,	39,	36},
{14,	27,	16,	39,	35},
{14,	27,	16,	39,	36},
{14,	25,	36,	39,	35},
{14,	24,	36,	39,	36},
{14,	36,	37,	39,	35},
{14,	26,	36,	39,	36},
{13,	37,	38,	39,	23},
{15,	37,	37,	39,	24},
{13,	26,	38,	39,	35},
{14,	33,	38,	39,	35},
{16,	35,	38,	39,	34},
{15,	36,	38,	39,	34},
{14,	35,	38,	39,	35},
{13,	37,	37,	39,	25},
{13,	37,	37,	39,	26},
{13,	37,	35,	39,	28},
{14,	37,	37,	39,	34},
{17,	38,	35,	39,	32},
{17,	37,	34,	39,	35},
{13,	31,	39,	39,	33},
{14,	33,	39,	39,	33},
{13,	37,	38,	39,	29},
{14,	37,	38,	39,	30},
{14,	37,	38,	39,	34},
{13,	35,	39,	39,	32},
{13,	35,	36,	39,	36},
{15,	36,	36,	39,	36},
{13,	32,	38,	39,	36},
{14,	33,	37,	39,	36},
{14,	33,	38,	39,	36},
{14,	35,	37,	39,	36},
{14,	34,	38,	39,	36},
{15,	35,	38,	39,	36},
{14,	36,	37,	39,	36},
{15,	36,	38,	39,	36},
{13,	33,	39,	39,	35},
{13,	37,	36,	39,	35},
{13,	37,	37,	39,	35},
{13,	35,	39,	39,	35},
{13,	36,	39,	39,	33},
{14,	36,	39,	39,	35},
{13,	37,	38,	39,	35},
{13,	37,	38,	39,	36},
{13,	39,	37,	36,	39},
{14,	39,	37,	37,	0},
{14,	39,	37,	37,	1},
{13,	39,	37,	38,	0},
{13,	39,	37,	38,	1},
{13,	39,	37,	37,	2},
{13,	39,	37,	37,	3},
{14,	39,	37,	37,	4},
{13,	39,	37,	37,	5},
{13,	39,	37,	37,	6},
{14,	39,	37,	37,	12},
{13,	39,	37,	37,	21},
{14,	39,	37,	37,	22},
{13,	39,	37,	37,	23},
{13,	39,	37,	37,	25},
{13,	39,	37,	37,	27},
{13,	39,	37,	37,	28},
{14,	39,	37,	37,	29},
{13,	39,	37,	37,	31},
{13,	39,	37,	37,	33},
{13,	39,	37,	37,	34},
{13,	38,	39,	37,	37},
{18,	38,	39,	9,	39},
{17,	38,	39,	21,	39},
{17,	38,	39,	22,	39},
{17,	38,	39,	31,	39},
{17,	38,	39,	32,	39},
{17,	38,	39,	33,	39},
{17,	38,	39,	34,	39},
{15,	38,	39,	35,	39},
{15,	38,	39,	36,	39},
{14,	38,	39,	37,	39},
{13,	38,	36,	38,	39},
{15,	38,	35,	39,	34},
{14,	38,	35,	39,	35},
{13,	39,	37,	37,	38},
{15,	39,	37,	37,	39},
{13,	37,	38,	39,	39},
{16,	38,	35,	39,	37},
{13,	38,	35,	39,	38},
{13,	38,	38,	38,	39},
{12,	38,	37,	39,	0},
{12,	38,	36,	39,	1},
{12,	38,	38,	39,	0},
{12,	38,	39,	38,	0},
{13,	38,	39,	38,	1},
{12,	38,	37,	39,	1},
{12,	38,	36,	39,	2},
{12,	38,	38,	39,	1},
{12,	38,	36,	39,	3},
{12,	38,	38,	39,	2},
{12,	38,	37,	39,	3},
{12,	38,	39,	38,	2},
{12,	37,	39,	39,	2},
{12,	39,	37,	38,	4},
{12,	38,	39,	38,	3},
{12,	38,	36,	39,	6},
{13,	38,	36,	39,	7},
{12,	5,	39,	39,	37},
{13,	8,	39,	39,	37},
{13,	10,	39,	39,	37},
{12,	38,	39,	38,	5},
{12,	37,	39,	39,	5},
{13,	37,	39,	39,	6},
{12,	39,	37,	38,	6},
{12,	38,	39,	38,	6},
{12,	38,	39,	38,	7},
{12,	37,	39,	39,	8},
{13,	37,	39,	39,	9},
{12,	38,	39,	38,	8},
{13,	38,	39,	38,	9},
{13,	38,	39,	38,	28},
{12,	37,	39,	39,	10},
{12,	11,	39,	39,	36},
{12,	16,	39,	39,	36},
{12,	19,	39,	39,	36},
{12,	23,	39,	39,	36},
{13,	26,	39,	39,	36},
{13,	27,	39,	39,	36},
{12,	37,	39,	39,	28},
{13,	37,	39,	39,	30},
{12,	29,	39,	39,	36},
{12,	38,	39,	38,	30},
{12,	38,	39,	38,	31},
{12,	37,	39,	39,	31},
{12,	33,	39,	39,	36},
{13,	35,	39,	39,	36},
{12,	37,	39,	39,	32},
{12,	38,	39,	38,	33},
{12,	37,	39,	39,	33},
{12,	37,	39,	39,	35},
{12,	36,	39,	39,	36},
{12,	38,	39,	38,	36},
{13,	38,	39,	38,	39},
{12,	37,	39,	39,	36},
{12,	39,	38,	37,	38},
{18,	39,	38,	25,	39},
{17,	39,	38,	30,	39},
{19,	39,	38,	31,	39},
{18,	39,	38,	33,	39},
{17,	39,	38,	34,	39},
{16,	39,	38,	35,	39},
{15,	39,	38,	36,	39},
{14,	39,	38,	37,	39},
{12,	37,	39,	39,	37},
{11,	39,	38,	38,	0},
{11,	39,	37,	39,	0},
{11,	38,	39,	39,	0},
{11,	39,	37,	39,	1},
{11,	39,	38,	38,	2},
{11,	38,	39,	39,	1},
{11,	39,	38,	38,	3},
{11,	38,	38,	39,	3},
{11,	39,	37,	39,	3},
{11,	38,	37,	39,	5},
{11,	39,	38,	38,	4},
{12,	39,	38,	38,	5},
{11,	38,	38,	39,	4},
{11,	38,	39,	39,	4},
{11,	38,	38,	39,	5},
{11,	38,	37,	39,	7},
{11,	39,	38,	38,	6},
{11,	38,	39,	39,	5},
{11,	38,	36,	39,	8},
{12,	38,	36,	39,	9},
{12,	38,	36,	39,	10},
{11,	39,	38,	38,	7},
{11,	38,	37,	39,	8},
{11,	39,	37,	38,	8},
{11,	38,	38,	39,	8},
{11,	38,	39,	39,	7},
{11,	39,	38,	38,	8},
{11,	39,	37,	38,	9},
{11,	38,	37,	39,	10},
{12,	38,	38,	39,	9},
{11,	39,	38,	38,	9},
{11,	38,	39,	39,	8},
{11,	38,	36,	39,	11},
{11,	39,	37,	38,	10},
{12,	39,	38,	38,	10},
{11,	38,	38,	39,	10},
{11,	38,	37,	39,	11},
{11,	38,	39,	39,	9},
{11,	39,	38,	38,	11},
{11,	38,	37,	39,	12},
{12,	38,	36,	39,	13},
{12,	38,	36,	39,	15},
{11,	38,	38,	39,	11},
{12,	38,	38,	39,	13},
{11,	39,	38,	38,	12},
{12,	39,	37,	38,	13},
{13,	39,	38,	38,	13},
{11,	39,	37,	38,	14},
{11,	38,	37,	39,	15},
{12,	38,	38,	39,	15},
{11,	39,	38,	38,	14},
{11,	38,	36,	39,	16},
{12,	38,	38,	39,	16},
{11,	39,	37,	38,	15},
{12,	39,	37,	38,	16},
{11,	39,	38,	38,	15},
{12,	39,	38,	38,	17},
{12,	39,	38,	38,	18},
{11,	38,	36,	39,	17},
{11,	38,	39,	39,	15},
{11,	38,	36,	39,	18},
{11,	38,	38,	39,	17},
{11,	38,	36,	39,	19},
{11,	38,	37,	39,	19},
{11,	38,	38,	39,	18},
{12,	38,	38,	39,	19},
{11,	39,	38,	38,	19},
{11,	38,	36,	39,	21},
{11,	39,	38,	38,	20},
{11,	39,	37,	38,	21},
{11,	38,	38,	39,	21},
{11,	38,	37,	39,	22},
{12,	38,	36,	39,	23},
{12,	38,	36,	39,	24},
{12,	38,	36,	39,	30},
{11,	38,	37,	39,	23},
{11,	39,	37,	38,	23},
{11,	39,	38,	38,	22},
{12,	39,	38,	38,	23},
{11,	38,	38,	39,	23},
{11,	39,	38,	38,	24},
{12,	39,	38,	38,	25},
{11,	38,	38,	39,	25},
{11,	38,	37,	39,	26},
{12,	38,	38,	39,	26},
{11,	39,	38,	38,	26},
{11,	39,	38,	38,	27},
{12,	39,	38,	38,	28},
{11,	38,	39,	39,	27},
{11,	38,	37,	39,	28},
{11,	38,	38,	39,	28},
{11,	38,	37,	39,	30},
{12,	38,	38,	39,	29},
{12,	38,	38,	39,	30},
{11,	39,	38,	38,	29},
{12,	39,	37,	38,	30},
{12,	39,	37,	38,	31},
{11,	38,	36,	39,	31},
{11,	38,	39,	39,	28},
{11,	39,	38,	38,	30},
{12,	39,	38,	38,	31},
{11,	38,	37,	39,	31},
{12,	38,	38,	39,	31},
{11,	38,	36,	39,	32},
{11,	38,	39,	39,	29},
{11,	38,	37,	39,	32},
{11,	38,	36,	39,	33},
{12,	38,	36,	39,	34},
{11,	39,	37,	38,	32},
{11,	38,	38,	39,	32},
{11,	39,	37,	38,	33},
{11,	39,	38,	38,	33},
{11,	38,	38,	39,	33},
{11,	38,	36,	39,	35},
{11,	38,	39,	39,	32},
{11,	39,	37,	38,	34},
{11,	38,	39,	39,	33},
{11,	38,	38,	39,	35},
{11,	35,	39,	39,	38},
{12,	36,	39,	39,	38},
{11,	38,	35,	39,	39},
{11,	39,	37,	38,	38},
{13,	39,	37,	38,	39},
{11,	38,	37,	39,	39},
{12,	38,	38,	39,	39},
{11,	38,	39,	39,	36},
{11,	39,	38,	38,	38},
{12,	39,	38,	38,	39},
{11,	36,	39,	39,	39},
{11,	38,	39,	39,	37},
{11,	37,	39,	39,	38},
{12,	37,	39,	39,	39},
{10,	39,	38,	39,	0},
{10,	39,	38,	39,	1},
{10,	39,	38,	39,	2},
{10,	39,	38,	39,	3},
{10,	39,	37,	39,	4},
{11,	39,	37,	39,	5},
{10,	39,	37,	39,	6},
{10,	39,	38,	39,	6},
{10,	39,	37,	39,	7},
{10,	39,	38,	39,	7},
{10,	39,	37,	39,	8},
{11,	39,	38,	39,	8},
{10,	39,	38,	39,	9},
{10,	39,	38,	39,	10},
{10,	39,	38,	39,	11},
{10,	39,	38,	39,	12},
{10,	39,	37,	39,	13},
{10,	39,	38,	39,	13},
{10,	39,	38,	39,	14},
{10,	39,	38,	39,	16},
{10,	39,	37,	39,	17},
{10,	39,	37,	39,	18},
{10,	39,	38,	39,	18},
{11,	39,	38,	39,	19},
{10,	39,	37,	39,	20},
{10,	39,	38,	39,	20},
{10,	39,	38,	39,	21},
{11,	39,	37,	39,	22},
{10,	39,	38,	39,	22},
{10,	39,	37,	39,	23},
{10,	39,	38,	39,	23},
{10,	39,	37,	39,	24},
{11,	39,	38,	39,	24},
{10,	39,	38,	39,	25},
{11,	39,	37,	39,	26},
{11,	39,	38,	39,	26},
{11,	39,	37,	39,	27},
{11,	39,	37,	39,	30},
{10,	39,	38,	39,	27},
{10,	39,	38,	39,	29},
{10,	39,	38,	39,	30},
{10,	39,	38,	39,	31},
{10,	39,	38,	39,	34},
{10,	39,	38,	39,	35},
{10,	39,	37,	39,	39},
{10,	38,	39,	39,	38},
{10,	39,	38,	39,	39},
{10,	38,	39,	39,	39},
{9,	39,	39,	38,	37},
{14,	39,	39,	4,	39},
{11,	39,	39,	35,	39},
{10,	39,	39,	36,	38},
{11,	39,	39,	36,	39},
{10,	39,	39,	37,	38},
{11,	39,	39,	37,	39},
{9,	39,	39,	38,	38},
{9,	39,	39,	38,	39},
{7,	39,	39,	39,	0},
{7,	39,	39,	39,	1},
{7,	39,	39,	39,	2},
{7,	39,	39,	39,	3},
{7,	39,	39,	39,	4},
{7,	39,	39,	39,	5},
{7,	39,	39,	39,	6},
{7,	39,	39,	39,	7},
{7,	39,	39,	39,	8},
{7,	39,	39,	39,	9},
{7,	39,	39,	39,	10},
{7,	39,	39,	39,	11},
{7,	39,	39,	39,	12},
{7,	39,	39,	39,	13},
{7,	39,	39,	39,	14},
{7,	39,	39,	39,	15},
{7,	39,	39,	39,	16},
{7,	39,	39,	39,	17},
{7,	39,	39,	39,	21},
{7,	39,	39,	39,	22},
{7,	39,	39,	39,	23},
{7,	39,	39,	39,	24},
{7,	39,	39,	39,	29},
{7,	39,	39,	39,	30},
{7,	39,	39,	39,	31},
{7,	39,	39,	39,	32},
{7,	39,	39,	39,	33},
{7,	39,	39,	39,	34},
{7,	39,	39,	39,	35},
{7,	39,	39,	39,	36},
{7,	39,	39,	39,	37},
{7,	39,	39,	39,	38},
{7,	39,	39,	39,	39}};

static BtkLookupTable DefaultTable3730pop7 = {
    sizeof(DefaultParam3730pop7Entries)/ sizeof(DefaultParam3730pop7Entries[0]),
    DefaultParam3730pop7Entries,
    sizeof(DefaultTable3730pop7Entries)/ sizeof(DefaultTable3730pop7Entries[0]),
    DefaultTable3730pop7Entries
};

BtkLookupTable *
Btk_get_3730pop7_table(void)
{
    return &DefaultTable3730pop7;
}

static TraceParamEntry DefaultParamMegaBACEEntries[] = {
/*   phr3_t            phr7_t                psr_t                pres_t  */
{0.000003366210175,   0.001512401693890,   1.077935222672065,   0.025367402581773},
{0.007286314772302,   0.017035782759142,   1.117921935129192,   0.031753027199996},
{0.011756795701198,   0.028846403063469,   1.133684210526316,   0.036449652455503},
{0.016427401883398,   0.040517716754094,   1.143258426966292,   0.040361233134205},
{0.021276472115797,   0.052243434206845,   1.153972257250946,   0.043796759641943},
{0.026361924855856,   0.064318554099067,   1.167158308751230,   0.046930535326632},
{0.031685780771126,   0.076482690686726,   1.181999896163232,   0.049851996487661},
{0.037273251275538,   0.088443453043001,   1.200666666666666,   0.052617290232236},
{0.043103512436330,   0.100101333722229,   1.214331560608839,   0.055264791742237},
{0.049109633437557,   0.111344585638525,   1.230828040461068,   0.057824819968764},
{0.055141883443609,   0.122253912978680,   1.250502008032128,   0.060332146968746},
{0.061238806481527,   0.132912425016284,   1.266705836271054,   0.062772810208145},
{0.067331483788825,   0.143516335823545,   1.272922776148583,   0.065179132677587},
{0.073309961022194,   0.154073610372670,   1.285786435786436,   0.067558890519767},
{0.079361041147252,   0.164619248349969,   1.300052742616034,   0.069901372964841},
{0.085446447406713,   0.175383112461591,   1.307846153846154,   0.072240964931648},
{0.091580368455994,   0.186220900066644,   1.333548109965635,   0.074569625340434},
{0.097821174776075,   0.197639213685875,   1.357206377437591,   0.076905002171936},
{0.104145446119871,   0.209339538551660,   1.363685424127950,   0.079251839084222},
{0.110724067847976,   0.221403260809626,   1.384681545518702,   0.081609976674544},
{0.117429038796935,   0.234043375750212,   1.400222222222222,   0.083993430179944},
{0.124412182769023,   0.247268821843265,   1.416889483065954,   0.086404784145532},
{0.131679024280223,   0.261230967858893,   1.444562647754137,   0.088869602043422},
{0.139287098464756,   0.275963651210535,   1.461630474788369,   0.091386195490829},
{0.147236266925295,   0.291658809181702,   1.500130140551796,   0.093970762378815},
{0.155699884969522,   0.308238673429687,   1.545489470191736,   0.096618630040949},
{0.164565200137765,   0.326260392447095,   1.571607860011475,   0.099373245304869},
{0.174006776832708,   0.345675017952592,   1.600147492625369,   0.102211458300522},
{0.183992290064110,   0.366225874389402,   1.636440482594329,   0.105179359090380},
{0.194587663382520,   0.388347188650042,   1.666828714957058,   0.108272538120133},
{0.205965589962792,   0.412663494770505,   1.714347718253968,   0.111567419693227},
{0.218109247721366,   0.438475268101768,   1.750111111111111,   0.115062104750516},
{0.230953949596848,   0.468548920421117,   1.800124326564442,   0.118789910613398},
{0.244927485186479,   0.502459603423411,   1.857259953161593,   0.122812957330026},
{0.259918193289059,   0.540328017533539,   1.900086058519794,   0.127194658841639},
{0.276125695516817,   0.583039624480656,   2.000457875457876,   0.131988231611559},
{0.293630771425075,   0.632319205435802,   2.125253036437247,   0.137342484531710},
{0.312604134123201,   0.688831860085549,   2.200077881619937,   0.143399626742227},
{0.333445807461928,   0.753769211678968,   2.285849567099568,   0.150284645112491},
{0.357005907408851,   0.827833424257630,   2.400084961767204,   0.158147349975761},
{0.383586145403904,   0.912879499395879,   2.500380517503805,   0.167288130687241},
{0.414422577375602,   1.011689338994292,   2.666814368427272,   0.177939873470873},
{0.451054951884620,   1.128892819106070,   2.800183150183150,   0.190507423149419},
{0.496256139576305,   1.271172204909066,   3.000686813186813,   0.205664205381318},
{0.553451583781496,   1.450364046681071,   3.250615763546798,   0.225015974114636},
{0.628432147309887,   1.696217393764239,   3.500380517503805,   0.250477694973580},
{0.734901622605438,   2.061242243442544,   4.001019367991845,   0.287487664139930},
{0.886046779288623,   2.730961565206624,   4.750415282392026,   0.349248164227132},
{1.198560043839675,   4.583774514929233,   6.335680751173710,   0.469154891232325},
{411.273123192095909,1922.283145744089325, 100.000000000000000,5113.000000000000000}};


static BtkLookupEntry DefaultTableMegaBACEEntries[] = {
{34,  16,  3,  47,  56}, 
{8,  22,  8,  10,  52}, 
{8,  21,  9,  26,  49}, 
{8,  18,  14,  14,  48}, 
{26,  21,  13,  9,  48}, 
{49,  33,  15,  4,  47}, 
{8,  22,  13,  18,  47}, 
{2,  22,  9,  32,  46}, 
{34,  27,  3,  26,  46}, 
{2,  33,  15,  14,  46}, 
{26,  18,  15,  14,  45}, 
{10,  28,  4,  47,  45}, 
{11,  14,  15,  30,  44}, 
{19,  16,  11,  32,  46}, 
{23,  27,  13,  18,  45}, 
{1,  33,  12,  32,  44}, 
{37,  43,  8,  10,  42}, 
{10,  22,  12,  41,  41}, 
{19,  16,  12,  41,  41}, 
{32,  18,  7,  41,  42}, 
{34,  24,  4,  46,  43}, 
{9,  9,  18,  36,  40}, 
{0,  7,  21,  3,  42}, 
{11,  25,  13,  36,  41}, 
{34,  26,  7,  35,  40}, 
{23,  26,  13,  27,  42}, 
{41,  39,  0,  49,  40}, 
{37,  30,  15,  17,  39}, 
{33,  37,  4,  35,  42}, 
{49,  32,  13,  17,  40}, 
{18,  22,  12,  43,  39}, 
{21,  23,  6,  49,  41}, 
{5,  9,  18,  43,  39}, 
{21,  25,  18,  27,  38}, 
{36,  31,  17,  11,  41}, 
{8,  25,  15,  41,  40}, 
{10,  23,  18,  35,  40}, 
{4,  38,  15,  27,  39}, 
{43,  42,  7,  18,  38}, 
{2,  37,  9,  42,  38}, 
{27,  28,  11,  25,  37}, 
{10,  22,  16,  41,  37}, 
{27,  24,  17,  23,  37}, 
{27,  25,  12,  35,  37}, 
{1,  31,  13,  43,  37}, 
{11,  5,  23,  31,  36}, 
{14,  33,  19,  9,  39}, 
{14,  23,  21,  8,  39}, 
{3,  25,  18,  47,  36}, 
{22,  16,  12,  47,  38}, 
{12,  7,  25,  4,  36}, 
{49,  25,  30,  0,  38}, 
{21,  15,  18,  35,  36}, 
{17,  22,  15,  43,  37}, 
{49,  20,  21,  8,  36}, 
{34,  28,  8,  33,  36}, 
{37,  36,  5,  32,  36}, 
{21,  14,  8,  49,  36}, 
{37,  27,  7,  38,  36}, 
{16,  18,  18,  41,  36}, 
{1,  36,  18,  20,  36}, 
{1,  28,  18,  46,  37}, 
{36,  32,  21,  4,  36}, 
{21,  21,  16,  38,  36}, 
{27,  5,  25,  25,  35}, 
{26,  32,  10,  26,  35}, 
{22,  18,  23,  37,  34}, 
{1,  29,  21,  35,  41}, 
{9,  10,  25,  25,  38}, 
{15,  1,  21,  40,  38}, 
{49,  23,  25,  3,  36}, 
{1,  10,  19,  47,  36}, 
{1,  23,  23,  31,  36}, 
{23,  20,  21,  30,  36}, 
{18,  18,  22,  38,  35}, 
{7,  16,  25,  16,  35}, 
{21,  25,  20,  27,  35}, 
{41,  33,  4,  37,  34}, 
{49,  27,  5,  43,  35}, 
{26,  35,  8,  33,  34}, 
{27,  18,  21,  30,  34}, 
{26,  43,  9,  27,  34}, 
{42,  38,  6,  30,  34}, 
{12,  13,  25,  22,  34}, 
{1,  31,  21,  35,  34}, 
{14,  33,  27,  1,  34}, 
{26,  29,  15,  26,  34}, 
{49,  32,  13,  19,  34}, 
{42,  37,  8,  25,  34}, 
{25,  21,  12,  43,  34}, 
{32,  26,  9,  37,  34}, 
{32,  33,  12,  25,  36}, 
{32,  23,  17,  29,  37}, 
{30,  23,  14,  37,  35}, 
{35,  29,  15,  26,  34}, 
{21,  23,  22,  27,  34}, 
{30,  18,  21,  36,  34}, 
{30,  24,  17,  37,  34}, 
{1,  33,  16,  40,  34}, 
{19,  14,  25,  32,  33}, 
{21,  23,  25,  9,  35}, 
{49,  20,  25,  10,  34}, 
{24,  25,  15,  43,  33}, 
{24,  27,  8,  46,  34}, 
{27,  26,  15,  38,  33}, 
{49,  34,  8,  30,  33}, 
{49,  33,  23,  2,  33}, 
{33,  42,  12,  11,  33}, 
{32,  36,  12,  26,  33}, 
{2,  34,  15,  44,  33}, 
{30,  5,  24,  33,  33}, 
{14,  20,  21,  46,  32}, 
{7,  26,  21,  42,  34}, 
{18,  14,  18,  49,  33}, 
{3,  26,  18,  49,  33}, 
{21,  24,  20,  37,  33}, 
{15,  18,  23,  41,  32}, 
{2,  25,  23,  41,  33}, 
{49,  29,  25,  4,  34}, 
{23,  20,  23,  37,  33}, 
{7,  25,  25,  16,  34}, 
{21,  25,  23,  31,  32}, 
{21,  25,  25,  16,  33}, 
{19,  18,  25,  27,  32}, 
{31,  32,  21,  9,  32}, 
{25,  24,  23,  31,  35}, 
{49,  23,  25,  12,  33}, 
{43,  35,  13,  12,  32}, 
{32,  35,  13,  30,  32}, 
{49,  32,  10,  30,  34}, 
{40,  30,  15,  29,  34}, 
{35,  23,  19,  30,  33}, 
{26,  33,  13,  33,  33}, 
{49,  26,  10,  38,  32}, 
{30,  27,  15,  38,  32}, 
{26,  33,  13,  35,  32}, 
{42,  28,  13,  35,  33}, 
{35,  23,  25,  16,  32}, 
{29,  21,  21,  38,  32}, 
{25,  16,  18,  45,  32}, 
{32,  39,  15,  13,  32}, 
{25,  43,  25,  2,  32}, 
{30,  26,  18,  22,  32}, 
{15,  30,  17,  32,  32}, 
{18,  28,  21,  29,  32}, 
{49,  30,  20,  10,  32}, 
{49,  26,  25,  10,  32}, 
{15,  30,  23,  17,  33}, 
{39,  35,  21,  5,  32}, 
{12,  15,  25,  43,  31}, 
{19,  18,  24,  34,  32}, 
{25,  24,  24,  30,  32}, 
{21,  21,  25,  37,  31}, 
{21,  14,  27,  3,  31}, 
{22,  20,  23,  43,  31}, 
{23,  15,  21,  47,  32}, 
{32,  21,  15,  43,  31}, 
{30,  27,  10,  43,  33}, 
{29,  22,  18,  42,  32}, 
{21,  28,  23,  21,  31}, 
{29,  36,  18,  13,  32}, 
{12,  35,  23,  14,  32}, 
{12,  45,  27,  3,  32}, 
{19,  20,  15,  49,  31}, 
{49,  30,  1,  49,  31}, 
{49,  29,  4,  44,  31}, 
{49,  9,  34,  0,  31}, 
{0,  28,  19,  48,  31}, 
{29,  24,  18,  42,  31}, 
{21,  25,  20,  42,  31}, 
{20,  28,  20,  35,  31}, 
{39,  22,  25,  20,  31}, 
{40,  24,  21,  25,  31}, 
{40,  12,  27,  18,  30}, 
{40,  0,  26,  22,  33}, 
{9,  9,  29,  4,  30}, 
{41,  34,  4,  46,  30}, 
{31,  36,  6,  38,  31}, 
{29,  31,  13,  42,  31}, 
{39,  32,  10,  37,  31}, 
{49,  34,  5,  42,  31}, 
{29,  28,  18,  42,  30}, 
{25,  29,  12,  46,  30}, 
{28,  30,  9,  46,  31}, 
{40,  30,  17,  23,  30}, 
{32,  27,  18,  38,  32}, 
{40,  27,  19,  31,  31}, 
{28,  29,  21,  26,  33}, 
{27,  26,  23,  31,  33}, 
{32,  33,  21,  14,  32}, 
{35,  29,  21,  26,  32}, 
{39,  29,  23,  17,  30}, 
{38,  38,  23,  5,  30}, 
{45,  48,  11,  7,  31}, 
{1,  33,  19,  39,  30}, 
{2,  33,  17,  45,  30}, 
{43,  35,  8,  35,  30}, 
{39,  32,  13,  35,  30}, 
{28,  23,  15,  46,  30}, 
{21,  15,  25,  43,  30}, 
{23,  44,  4,  46,  30}, 
{12,  34,  27,  5,  30}, 
{15,  25,  27,  13,  30}, 
{29,  40,  12,  27,  30}, 
{26,  25,  24,  30,  30}, 
{40,  37,  18,  8,  30}, 
{12,  21,  23,  46,  29}, 
{15,  15,  25,  44,  30}, 
{5,  28,  21,  45,  30}, 
{33,  32,  21,  23,  29}, 
{2,  31,  21,  45,  30}, 
{31,  25,  27,  13,  29}, 
{42,  35,  12,  32,  29}, 
{40,  37,  13,  23,  31}, 
{34,  33,  18,  23,  30}, 
{34,  36,  18,  18,  31}, 
{30,  38,  15,  27,  31}, 
{27,  35,  18,  26,  31}, 
{10,  34,  27,  13,  29}, 
{33,  29,  24,  17,  33}, 
{12,  30,  25,  21,  31}, 
{40,  0,  27,  22,  29}, 
{31,  27,  20,  35,  29}, 
{32,  29,  19,  32,  30}, 
{28,  29,  18,  42,  30}, 
{26,  30,  19,  38,  31}, 
{31,  32,  16,  34,  32}, 
{40,  30,  18,  31,  30}, 
{6,  30,  23,  34,  29}, 
{2,  29,  25,  30,  31}, 
{29,  27,  24,  24,  30}, 
{34,  28,  23,  25,  30}, 
{31,  26,  23,  32,  30}, 
{5,  33,  25,  27,  29}, 
{49,  32,  2,  49,  29}, 
{29,  33,  12,  40,  29}, 
{39,  35,  26,  2,  29}, 
{42,  28,  16,  35,  29}, 
{49,  20,  19,  32,  29}, 
{22,  49,  11,  27,  29}, 
{42,  37,  6,  38,  29}, 
{28,  24,  20,  42,  29}, 
{28,  21,  22,  42,  29}, 
{29,  25,  22,  37,  30}, 
{26,  23,  24,  36,  29}, 
{36,  35,  13,  34,  29}, 
{30,  34,  16,  34,  30}, 
{31,  33,  18,  34,  29}, 
{43,  35,  15,  18,  29}, 
{30,  31,  16,  39,  29}, 
{39,  30,  16,  36,  29}, 
{49,  26,  16,  38,  29}, 
{26,  30,  15,  44,  29}, 
{21,  23,  15,  49,  29}, 
{33,  25,  23,  34,  29}, 
{38,  29,  21,  29,  29}, 
{26,  6,  29,  35,  28}, 
{18,  10,  27,  29,  30}, 
{26,  2,  26,  38,  30}, 
{20,  2,  27,  37,  31}, 
{31,  22,  27,  20,  29}, 
{18,  13,  27,  28,  30}, 
{7,  12,  27,  35,  31}, 
{18,  19,  27,  24,  29}, 
{10,  26,  27,  22,  29}, 
{39,  25,  27,  17,  30}, 
{14,  29,  29,  2,  29}, 
{40,  31,  11,  43,  28}, 
{39,  29,  10,  46,  29}, 
{33,  22,  15,  47,  31}, 
{49,  34,  6,  45,  30}, 
{49,  22,  16,  44,  29}, 
{22,  23,  21,  45,  29}, 
{49,  31,  15,  36,  29}, 
{32,  30,  18,  40,  29}, 
{33,  32,  24,  17,  28}, 
{33,  32,  25,  15,  29}, 
{17,  30,  27,  18,  29}, 
{38,  27,  27,  15,  29}, 
{49,  30,  15,  42,  28}, 
{22,  42,  13,  32,  28}, 
{2,  37,  13,  45,  29}, 
{22,  5,  25,  45,  28}, 
{41,  35,  18,  14,  28}, 
{37,  34,  18,  25,  29}, 
{49,  35,  15,  24,  30}, 
{49,  36,  17,  13,  29}, 
{31,  36,  16,  29,  29}, 
{33,  37,  9,  38,  30}, 
{35,  36,  13,  36,  30}, 
{33,  28,  29,  2,  28}, 
{33,  33,  21,  24,  28}, 
{49,  34,  13,  35,  28}, 
{38,  29,  16,  42,  28}, 
{38,  34,  15,  36,  28}, 
{37,  34,  16,  34,  28}, 
{34,  22,  27,  22,  28}, 
{40,  36,  18,  20,  28}, 
{22,  19,  23,  46,  28}, 
{14,  24,  30,  30,  27}, 
{22,  21,  29,  21,  34}, 
{13,  13,  29,  35,  33}, 
{25,  6,  30,  34,  32}, 
{49,  9,  33,  2,  31}, 
{42,  25,  28,  14,  30}, 
{25,  22,  27,  30,  29}, 
{22,  21,  29,  28,  30}, 
{1,  10,  32,  3,  29}, 
{0,  30,  29,  14,  29}, 
{46,  24,  29,  12,  28}, 
{25,  14,  27,  34,  28}, 
{9,  22,  28,  33,  30}, 
{12,  16,  27,  37,  28}, 
{33,  35,  30,  1,  28}, 
{14,  32,  25,  26,  28}, 
{38,  5,  32,  11,  27}, 
{13,  14,  26,  42,  27}, 
{7,  15,  27,  42,  27}, 
{10,  22,  25,  45,  27}, 
{35,  42,  21,  7,  27}, 
{33,  34,  21,  22,  28}, 
{28,  39,  25,  6,  28}, 
{19,  35,  23,  19,  28}, 
{29,  36,  21,  20,  28}, 
{45,  37,  21,  6,  28}, 
{8,  38,  21,  27,  27}, 
{29,  37,  21,  22,  28}, 
{49,  6,  35,  1,  27}, 
{43,  42,  11,  19,  27}, 
{37,  42,  15,  19,  28}, 
{1,  9,  31,  12,  27}, 
{0,  30,  19,  48,  27}, 
{26,  25,  26,  26,  27}, 
{20,  32,  28,  12,  27}, 
{9,  18,  30,  33,  27}, 
{1,  29,  23,  39,  27}, 
{12,  17,  27,  40,  27}, 
{36,  28,  15,  44,  27}, 
{33,  29,  17,  43,  28}, 
{4,  37,  15,  45,  27}, 
{20,  38,  17,  31,  27}, 
{21,  39,  21,  23,  28}, 
{32,  44,  18,  11,  27}, 
{34,  37,  12,  37,  27}, 
{10,  23,  24,  45,  27}, 
{34,  36,  20,  22,  27}, 
{37,  39,  6,  37,  27}, 
{18,  45,  7,  42,  27}, 
{16,  37,  23,  20,  27}, 
{10,  37,  25,  16,  27}, 
{21,  17,  24,  45,  27}, 
{45,  42,  14,  11,  27}, 
{8,  37,  23,  27,  27}, 
{39,  26,  23,  30,  27}, 
{39,  32,  13,  40,  27}, 
{25,  3,  32,  30,  26}, 
{1,  10,  32,  17,  27}, 
{17,  17,  21,  49,  26}, 
{41,  38,  6,  46,  26}, 
{30,  37,  12,  40,  27}, 
{4,  34,  9,  49,  27}, 
{38,  35,  13,  38,  27}, 
{18,  32,  31,  4,  26}, 
{13,  15,  32,  7,  28}, 
{1,  25,  31,  11,  27}, 
{39,  33,  31,  1,  27}, 
{38,  28,  28,  10,  27}, 
{29,  28,  24,  29,  26}, 
{27,  19,  29,  27,  27}, 
{32,  28,  23,  32,  27}, 
{24,  29,  20,  41,  28}, 
{28,  24,  24,  34,  27}, 
{2,  29,  25,  33,  28}, 
{1,  27,  24,  39,  28}, 
{7,  25,  24,  45,  28}, 
{28,  25,  24,  36,  27}, 
{22,  28,  23,  37,  27}, 
{33,  29,  21,  35,  27}, 
{20,  17,  27,  40,  26}, 
{25,  22,  27,  33,  27}, 
{14,  15,  29,  38,  26}, 
{31,  32,  21,  30,  26}, 
{16,  31,  23,  34,  27}, 
{29,  32,  24,  27,  26}, 
{29,  31,  23,  34,  30}, 
{27,  30,  25,  26,  27}, 
{38,  29,  25,  18,  27}, 
{34,  27,  24,  27,  27}, 
{25,  3,  31,  32,  26}, 
{40,  35,  20,  19,  26}, 
{37,  30,  23,  28,  26}, 
{39,  32,  23,  19,  27}, 
{35,  28,  27,  18,  26}, 
{40,  36,  21,  19,  26}, 
{41,  31,  16,  37,  26}, 
{13,  25,  27,  33,  26}, 
{49,  45,  23,  0,  26}, 
{9,  40,  8,  48,  26}, 
{21,  28,  11,  49,  28}, 
{25,  27,  12,  49,  26}, 
{23,  21,  18,  49,  27}, 
{27,  21,  16,  49,  26}, 
{49,  30,  9,  49,  26}, 
{32,  39,  5,  49,  28}, 
{36,  28,  15,  47,  26}, 
{24,  26,  21,  43,  26}, 
{44,  38,  3,  43,  26}, 
{43,  38,  13,  26,  26}, 
{35,  39,  12,  38,  26}, 
{0,  38,  15,  46,  27}, 
{36,  43,  10,  27,  27}, 
{0,  31,  19,  49,  26}, 
{37,  39,  12,  37,  26}, 
{43,  38,  13,  31,  27}, 
{37,  36,  15,  36,  27}, 
{30,  40,  15,  32,  26}, 
{23,  39,  18,  31,  26}, 
{16,  44,  15,  33,  26}, 
{41,  36,  24,  4,  26}, 
{10,  6,  30,  35,  26}, 
{23,  48,  15,  28,  26}, 
{35,  29,  18,  42,  26}, 
{35,  24,  23,  36,  26}, 
{35,  31,  21,  33,  26}, 
{38,  38,  24,  6,  26}, 
{39,  36,  22,  12,  26}, 
{38,  33,  22,  22,  26}, 
{7,  25,  29,  31,  26}, 
{25,  22,  34,  17,  25}, 
{31,  22,  31,  17,  28}, 
{33,  18,  31,  21,  27}, 
{15,  25,  32,  15,  27}, 
{25,  25,  29,  22,  28}, 
{31,  27,  31,  7,  27}, 
{9,  18,  32,  25,  26}, 
{14,  18,  31,  28,  28}, 
{34,  29,  32,  3,  26}, 
{1,  27,  27,  42,  25}, 
{26,  23,  26,  36,  29}, 
{2,  29,  27,  33,  27}, 
{1,  31,  23,  42,  27}, 
{9,  22,  28,  38,  27}, 
{13,  25,  27,  39,  26}, 
{21,  22,  26,  39,  26}, 
{31,  29,  27,  19,  26}, 
{21,  20,  24,  45,  26}, 
{11,  19,  23,  49,  25}, 
{39,  30,  13,  47,  25}, 
{29,  30,  13,  49,  26}, 
{35,  29,  18,  46,  25}, 
{26,  25,  21,  45,  27}, 
{34,  30,  18,  44,  26}, 
{31,  32,  13,  49,  25}, 
{49,  32,  9,  47,  29}, 
{30,  38,  10,  42,  27}, 
{30,  33,  12,  46,  26}, 
{30,  35,  13,  43,  27}, 
{37,  33,  10,  45,  26}, 
{37,  36,  8,  45,  26}, 
{25,  33,  16,  44,  25}, 
{38,  33,  16,  38,  27}, 
{10,  37,  24,  27,  25}, 
{0,  29,  28,  33,  25}, 
{0,  29,  29,  28,  26}, 
{25,  18,  32,  23,  25}, 
{38,  29,  20,  35,  25}, 
{38,  24,  20,  42,  25}, 
{49,  16,  22,  40,  26}, 
{49,  26,  20,  37,  26}, 
{41,  34,  21,  22,  27}, 
{41,  33,  17,  34,  26}, 
{49,  29,  21,  32,  26}, 
{10,  30,  27,  28,  25}, 
{31,  34,  15,  43,  25}, 
{31,  33,  16,  44,  26}, 
{28,  39,  28,  3,  25}, 
{25,  31,  19,  42,  25}, 
{25,  34,  18,  37,  25}, 
{49,  31,  18,  36,  25}, 
{49,  34,  17,  27,  26}, 
{49,  36,  19,  20,  25}, 
{46,  43,  5,  24,  25}, 
{42,  40,  18,  10,  25}, 
{49,  38,  13,  24,  25}, 
{49,  33,  21,  24,  25}, 
{15,  37,  25,  20,  25}, 
{22,  34,  24,  24,  26}, 
{19,  38,  25,  15,  25}, 
{36,  43,  6,  39,  25}, 
{45,  37,  17,  19,  25}, 
{31,  31,  18,  45,  25}, 
{18,  31,  20,  45,  25}, 
{37,  31,  12,  49,  25}, 
{41,  35,  25,  6,  25}, 
{36,  26,  30,  11,  25}, 
{36,  25,  32,  10,  26}, 
{39,  39,  17,  18,  25}, 
{35,  28,  15,  49,  25}, 
{49,  33,  23,  12,  25}, 
{30,  33,  24,  23,  26}, 
{30,  38,  24,  10,  25}, 
{39,  36,  23,  15,  27}, 
{29,  41,  25,  7,  25}, 
{33,  38,  12,  42,  25}, 
{11,  25,  36,  0,  25}, 
{24,  33,  28,  12,  25}, 
{43,  39,  11,  32,  25}, 
{49,  0,  37,  1,  25}, 
{14,  18,  34,  32,  24}, 
{13,  25,  32,  31,  25}, 
{20,  20,  34,  22,  26}, 
{25,  23,  31,  23,  26}, 
{19,  30,  28,  25,  25}, 
{18,  17,  29,  36,  25}, 
{25,  22,  29,  30,  26}, 
{20,  16,  29,  40,  25}, 
{27,  27,  26,  28,  25}, 
{25,  25,  29,  29,  27}, 
{10,  8,  32,  38,  24}, 
{14,  18,  31,  34,  26}, 
{6,  13,  32,  36,  25}, 
{15,  10,  29,  41,  24}, 
{27,  45,  18,  21,  24}, 
{30,  40,  19,  23,  26}, 
{31,  34,  19,  32,  26}, 
{36,  33,  23,  25,  25}, 
{13,  40,  23,  24,  24}, 
{29,  41,  25,  10,  25}, 
{20,  41,  25,  14,  25}, 
{10,  23,  23,  49,  24}, 
{23,  25,  21,  47,  27}, 
{4,  25,  26,  43,  24}, 
{4,  8,  27,  43,  25}, 
{13,  26,  28,  38,  24}, 
{22,  19,  23,  49,  24}, 
{1,  31,  23,  45,  24}, 
{18,  28,  22,  45,  24}, 
{26,  25,  23,  39,  25}, 
{5,  34,  23,  39,  24}, 
{5,  32,  23,  45,  26}, 
{28,  35,  20,  30,  25}, 
{0,  34,  18,  46,  25}, 
{2,  33,  24,  38,  24}, 
{8,  30,  28,  34,  27}, 
{28,  28,  24,  34,  27}, 
{9,  37,  24,  31,  26}, 
{3,  28,  25,  43,  25}, 
{12,  40,  21,  31,  25}, 
{26,  27,  27,  32,  24}, 
{33,  26,  28,  21,  25}, 
{30,  37,  20,  30,  24}, 
{42,  36,  19,  25,  24}, 
{35,  40,  17,  26,  24}, 
{37,  38,  15,  36,  25}, 
{43,  32,  16,  38,  24}, 
{26,  26,  29,  27,  24}, 
{38,  29,  16,  46,  24}, 
{47,  41,  14,  15,  24}, 
{37,  34,  7,  49,  24}, 
{25,  42,  21,  21,  24}, 
{29,  40,  23,  17,  25}, 
{39,  36,  23,  19,  25}, 
{37,  35,  23,  23,  25}, 
{29,  35,  25,  17,  25}, 
{32,  34,  24,  23,  26}, 
{17,  23,  34,  19,  24}, 
{36,  32,  34,  1,  24}, 
{30,  35,  36,  0,  26}, 
{36,  31,  34,  2,  24}, 
{11,  26,  27,  42,  24}, 
{21,  40,  9,  46,  24}, 
{43,  41,  5,  39,  24}, 
{3,  28,  25,  45,  24}, 
{21,  34,  32,  4,  24}, 
{19,  40,  34,  1,  26}, 
{18,  25,  32,  24,  24}, 
{20,  19,  32,  33,  24}, 
{23,  24,  30,  31,  26}, 
{7,  19,  31,  36,  25}, 
{16,  19,  34,  31,  25}, 
{25,  13,  32,  34,  24}, 
{32,  32,  23,  30,  24}, 
{42,  34,  21,  26,  25}, 
{35,  38,  20,  26,  24}, 
{36,  39,  23,  15,  26}, 
{36,  39,  24,  9,  24}, 
{43,  36,  24,  7,  25}, 
{34,  34,  24,  23,  25}, 
{42,  38,  29,  0,  24}, 
{33,  33,  20,  33,  24}, 
{39,  40,  18,  21,  24}, 
{11,  25,  32,  32,  24}, 
{44,  49,  12,  13,  24}, 
{15,  20,  27,  49,  23}, 
{20,  23,  28,  38,  25}, 
{3,  27,  27,  44,  24}, 
{8,  24,  25,  47,  24}, 
{43,  23,  36,  8,  23}, 
{28,  22,  34,  19,  25}, 
{21,  35,  36,  2,  25}, 
{34,  24,  34,  10,  24}, 
{31,  27,  34,  7,  26}, 
{34,  27,  36,  4,  25}, 
{33,  9,  35,  12,  23}, 
{0,  38,  18,  48,  23}, 
{24,  35,  16,  43,  25}, 
{6,  35,  23,  38,  24}, 
{21,  37,  16,  41,  24}, 
{12,  39,  21,  34,  25}, 
{40,  35,  14,  38,  24}, 
{43,  34,  15,  38,  24}, 
{44,  38,  7,  41,  26}, 
{49,  38,  7,  39,  25}, 
{49,  35,  8,  45,  25}, 
{49,  33,  8,  49,  25}, 
{49,  39,  11,  31,  24}, 
{39,  33,  12,  45,  24}, 
{42,  33,  16,  42,  23}, 
{49,  31,  15,  44,  25}, 
{49,  34,  10,  43,  25}, 
{49,  31,  12,  49,  24}, 
{43,  33,  12,  46,  24}, 
{37,  31,  18,  43,  24}, 
{3,  32,  25,  44,  23}, 
{5,  33,  24,  42,  25}, 
{6,  29,  28,  37,  24}, 
{6,  29,  27,  41,  24}, 
{49,  36,  18,  30,  23}, 
{33,  36,  18,  33,  24}, 
{40,  35,  16,  43,  23}, 
{43,  35,  15,  43,  25}, 
{37,  36,  14,  43,  25}, 
{31,  36,  18,  37,  25}, 
{33,  32,  18,  45,  26}, 
{40,  35,  17,  41,  26}, 
{21,  34,  19,  42,  24}, 
{30,  33,  21,  35,  25}, 
{37,  34,  21,  30,  24}, 
{20,  36,  23,  30,  24}, 
{29,  34,  24,  27,  24}, 
{33,  33,  24,  27,  24}, 
{37,  29,  24,  27,  25}, 
{33,  36,  17,  42,  24}, 
{39,  26,  24,  29,  24}, 
{26,  32,  19,  44,  24}, 
{38,  26,  20,  42,  25}, 
{30,  26,  22,  39,  24}, 
{38,  25,  19,  45,  24}, 
{31,  19,  22,  45,  25}, 
{33,  25,  21,  44,  24}, 
{29,  32,  22,  39,  23}, 
{32,  33,  23,  32,  25}, 
{37,  29,  20,  39,  25}, 
{18,  31,  23,  44,  24}, 
{27,  28,  24,  36,  24}, 
{30,  31,  23,  37,  24}, 
{49,  29,  20,  39,  24}, 
{37,  30,  22,  33,  24}, 
{37,  28,  24,  30,  24}, 
{49,  23,  24,  30,  24}, 
{49,  21,  27,  24,  24}, 
{33,  30,  25,  26,  24}, 
{45,  26,  27,  22,  24}, 
{49,  32,  23,  20,  24}, 
{49,  29,  25,  20,  24}, 
{49,  28,  24,  30,  25}, 
{49,  29,  23,  32,  24}, 
{36,  29,  23,  37,  24}, 
{36,  29,  21,  40,  24}, 
{38,  27,  20,  44,  25}, 
{24,  30,  21,  45,  24}, 
{26,  30,  23,  42,  23}, 
{34,  27,  23,  42,  23}, 
{37,  29,  22,  40,  24}, 
{27,  27,  24,  42,  23}, 
{24,  23,  25,  43,  26}, 
{20,  25,  27,  40,  25}, 
{25,  15,  29,  40,  25}, 
{24,  21,  27,  43,  24}, 
{26,  17,  28,  41,  25}, 
{21,  19,  27,  46,  25}, 
{23,  25,  28,  37,  24}, 
{15,  22,  26,  49,  24}, 
{18,  41,  27,  11,  23}, 
{15,  47,  27,  4,  24}, 
{19,  49,  34,  0,  24}, 
{26,  48,  18,  21,  24}, 
{37,  32,  21,  39,  23}, 
{37,  31,  23,  37,  25}, 
{44,  36,  18,  32,  24}, 
{38,  36,  18,  42,  23}, 
{37,  34,  19,  40,  25}, 
{39,  38,  10,  42,  24}, 
{29,  39,  24,  19,  23}, 
{9,  38,  24,  32,  25}, 
{34,  23,  24,  37,  23}, 
{49,  28,  24,  32,  24}, 
{34,  28,  24,  35,  24}, 
{32,  21,  24,  42,  24}, 
{33,  32,  18,  46,  23}, 
{29,  20,  26,  42,  23}, 
{34,  25,  25,  35,  25}, 
{33,  22,  27,  33,  23}, 
{33,  26,  27,  29,  24}, 
{29,  17,  29,  40,  23}, 
{33,  32,  23,  38,  23}, 
{46,  49,  3,  35,  23}, 
{49,  29,  21,  40,  23}, 
{49,  21,  26,  33,  24}, 
{49,  38,  4,  46,  23}, 
{44,  41,  5,  46,  23}, 
{28,  43,  9,  42,  24}, 
{4,  42,  15,  44,  23}, 
{22,  45,  15,  38,  26}, 
{27,  40,  14,  42,  24}, 
{38,  41,  4,  49,  23}, 
{33,  33,  16,  46,  23}, 
{32,  34,  16,  45,  24}, 
{43,  34,  13,  45,  23}, 
{33,  33,  13,  49,  23}, 
{32,  40,  24,  15,  23}, 
{24,  28,  27,  32,  23}, 
{13,  39,  24,  28,  23}, 
{6,  36,  25,  29,  23}, 
{5,  32,  20,  47,  23}, 
{36,  33,  23,  33,  23}, 
{16,  37,  27,  14,  23}, 
{23,  27,  29,  28,  23}, 
{49,  35,  7,  47,  23}, 
{43,  41,  4,  49,  24}, 
{49,  26,  24,  35,  23}, 
{32,  38,  20,  30,  23}, 
{39,  39,  17,  27,  23}, 
{26,  28,  24,  42,  23}, 
{12,  33,  24,  39,  23}, 
{20,  29,  24,  42,  23}, 
{27,  34,  24,  30,  23}, 
{34,  33,  24,  29,  23}, 
{31,  38,  21,  30,  23}, 
{34,  31,  24,  31,  23}, 
{18,  30,  28,  31,  23}, 
{30,  37,  32,  2,  23}, 
{36,  32,  36,  2,  23}, 
{29,  34,  34,  3,  23}, 
{29,  31,  30,  6,  24}, 
{29,  40,  21,  28,  23}, 
{24,  37,  28,  8,  23}, 
{32,  45,  12,  31,  23}, 
{20,  14,  32,  46,  22}, 
{5,  17,  31,  43,  27}, 
{24,  17,  29,  44,  25}, 
{22,  19,  30,  38,  25}, 
{7,  19,  32,  38,  24}, 
{10,  24,  32,  35,  23}, 
{3,  29,  29,  35,  24}, 
{23,  22,  28,  42,  23}, 
{2,  19,  32,  41,  24}, 
{3,  28,  28,  42,  24}, 
{5,  19,  31,  44,  23}, 
{23,  23,  26,  44,  23}, 
{23,  15,  32,  39,  23}, 
{19,  20,  32,  35,  23}, 
{21,  25,  28,  42,  23}, 
{22,  19,  26,  48,  23}, 
{18,  10,  34,  35,  22}, 
{7,  19,  34,  34,  24}, 
{12,  19,  35,  15,  22}, 
{23,  20,  36,  9,  24}, 
{6,  34,  28,  32,  22}, 
{6,  34,  26,  36,  25}, 
{15,  33,  28,  28,  25}, 
{23,  39,  28,  11,  24}, 
{23,  37,  27,  15,  23}, 
{29,  34,  27,  29,  22}, 
{27,  29,  27,  33,  26}, 
{28,  34,  32,  5,  24}, 
{33,  33,  25,  29,  24}, 
{37,  33,  28,  9,  23}, 
{32,  30,  27,  29,  25}, 
{38,  32,  30,  6,  25}, 
{34,  37,  28,  5,  23}, 
{34,  39,  25,  12,  23}, 
{34,  35,  27,  11,  23}, 
{14,  29,  32,  28,  22}, 
{1,  34,  32,  10,  25}, 
{14,  32,  29,  24,  25}, 
{11,  28,  32,  32,  25}, 
{31,  27,  34,  10,  24}, 
{14,  31,  32,  17,  24}, 
{31,  26,  32,  13,  23}, 
{22,  31,  31,  12,  23}, 
{40,  33,  25,  28,  22}, 
{38,  35,  27,  11,  25}, 
{42,  36,  25,  12,  26}, 
{42,  32,  23,  30,  24}, 
{40,  33,  23,  33,  24}, 
{42,  33,  19,  40,  24}, 
{35,  30,  27,  24,  23}, 
{42,  36,  19,  32,  23}, 
{39,  35,  23,  25,  23}, 
{40,  38,  24,  9,  23}, 
{37,  32,  24,  40,  22}, 
{28,  32,  25,  35,  25}, 
{32,  28,  24,  42,  24}, 
{34,  31,  22,  42,  26}, 
{35,  32,  25,  35,  24}, 
{31,  29,  27,  33,  24}, 
{21,  32,  25,  42,  23}, 
{40,  32,  25,  32,  23}, 
{39,  24,  25,  40,  24}, 
{27,  32,  20,  45,  23}, 
{35,  33,  20,  41,  23}, 
{35,  31,  19,  45,  23}, 
{34,  34,  24,  30,  23}, 
{27,  22,  27,  42,  23}, 
{38,  21,  27,  40,  24}, 
{32,  25,  27,  37,  24}, 
{35,  35,  23,  37,  22}, 
{14,  38,  24,  33,  24}, 
{35,  33,  22,  41,  24}, 
{29,  33,  24,  39,  24}, 
{21,  40,  21,  34,  23}, 
{28,  34,  23,  40,  23}, 
{27,  37,  23,  30,  23}, 
{5,  32,  25,  47,  22}, 
{0,  32,  23,  49,  23}, 
{8,  27,  28,  44,  23}, 
{32,  27,  29,  27,  22}, 
{31,  30,  28,  20,  24}, 
{20,  30,  32,  17,  23}, 
{33,  28,  29,  23,  24}, 
{31,  32,  31,  9,  24}, 
{30,  31,  31,  14,  23}, 
{29,  32,  29,  19,  24}, 
{27,  34,  30,  12,  24}, 
{18,  35,  32,  10,  23}, 
{29,  25,  29,  31,  23}, 
{29,  22,  28,  42,  24}, 
{30,  33,  29,  18,  23}, 
{30,  30,  29,  24,  23}, 
{28,  33,  29,  23,  23}, 
{35,  28,  29,  23,  23}, 
{35,  32,  31,  9,  23}, 
{29,  22,  29,  41,  22}, 
{7,  22,  32,  39,  25}, 
{25,  22,  30,  39,  25}, 
{10,  27,  30,  38,  23}, 
{25,  19,  32,  39,  22}, 
{24,  23,  31,  33,  24}, 
{25,  22,  31,  39,  23}, 
{21,  44,  18,  32,  22}, 
{0,  48,  16,  37,  24}, 
{26,  48,  18,  28,  23}, 
{6,  39,  25,  33,  22}, 
{49,  15,  38,  1,  22}, 
{21,  42,  18,  39,  22}, 
{36,  29,  25,  40,  22}, 
{38,  25,  27,  38,  22}, 
{38,  30,  27,  27,  25}, 
{3,  22,  30,  44,  22}, 
{39,  36,  20,  33,  22}, 
{45,  39,  14,  29,  22}, 
{41,  38,  15,  35,  23}, 
{45,  37,  9,  42,  23}, 
{40,  36,  13,  44,  22}, 
{25,  35,  18,  45,  23}, 
{16,  23,  32,  38,  22}, 
{29,  29,  28,  31,  22}, 
{33,  26,  28,  34,  22}, 
{29,  27,  29,  33,  23}, 
{28,  29,  29,  32,  23}, 
{28,  25,  28,  42,  22}, 
{13,  39,  24,  34,  22}, 
{15,  37,  23,  38,  22}, 
{39,  36,  19,  40,  22}, 
{41,  34,  23,  29,  22}, 
{38,  21,  18,  48,  22}, 
{31,  29,  29,  31,  22}, 
{35,  26,  29,  32,  23}, 
{0,  33,  21,  49,  22}, 
{21,  36,  37,  1,  22}, 
{40,  32,  20,  41,  22}, 
{49,  32,  19,  41,  23}, 
{29,  31,  32,  13,  22}, 
{32,  36,  21,  38,  22}, 
{19,  40,  23,  31,  22}, 
{7,  38,  13,  49,  22}, 
{43,  35,  8,  49,  23}, 
{38,  35,  11,  47,  22}, 
{20,  13,  34,  34,  22}, 
{26,  20,  34,  26,  22}, 
{25,  18,  34,  31,  23}, 
{31,  20,  34,  22,  23}, 
{31,  23,  34,  18,  22}, 
{27,  31,  32,  16,  23}, 
{26,  25,  31,  27,  23}, 
{24,  31,  32,  19,  25}, 
{8,  29,  30,  37,  22}, 
{34,  30,  34,  5,  22}, 
{26,  30,  33,  11,  22}, 
{29,  29,  35,  5,  22}, 
{15,  35,  34,  6,  22}, 
{49,  17,  28,  34,  22}, 
{44,  41,  23,  2,  22}, 
{46,  39,  18,  13,  23}, 
{44,  39,  18,  20,  22}, 
{40,  39,  23,  15,  22}, 
{38,  39,  25,  12,  22}, 
{1,  34,  28,  34,  22}, 
{3,  31,  27,  40,  23}, 
{24,  32,  27,  33,  23}, 
{15,  47,  30,  2,  22}, 
{19,  42,  28,  11,  23}, 
{21,  42,  23,  22,  23}, 
{26,  43,  34,  1,  23}, 
{15,  41,  25,  20,  22}, 
{15,  46,  27,  6,  22}, 
{21,  43,  26,  11,  23}, 
{15,  49,  28,  5,  23}, 
{21,  43,  25,  15,  23}, 
{14,  43,  24,  21,  23}, 
{8,  46,  25,  20,  22}, 
{25,  48,  21,  21,  25}, 
{26,  46,  25,  12,  22}, 
{26,  48,  28,  5,  22}, 
{21,  43,  27,  13,  22}, 
{29,  44,  23,  16,  22}, 
{45,  26,  27,  34,  22}, 
{39,  43,  15,  22,  22}, 
{18,  40,  20,  38,  22}, 
{23,  19,  36,  28,  21}, 
{30,  19,  36,  22,  25}, 
{30,  21,  36,  19,  24}, 
{34,  23,  36,  11,  22}, 
{16,  15,  34,  38,  21}, 
{24,  18,  34,  34,  22}, 
{34,  28,  27,  40,  21}, 
{25,  27,  28,  42,  24}, 
{38,  30,  27,  31,  22}, 
{35,  26,  28,  37,  22}, 
{46,  32,  25,  32,  21}, 
{42,  35,  20,  34,  22}, 
{47,  30,  24,  40,  21}, 
{40,  33,  23,  40,  23}, 
{40,  35,  23,  37,  22}, 
{49,  20,  27,  40,  22}, 
{49,  17,  29,  38,  22}, 
{42,  32,  25,  34,  22}, 
{42,  31,  24,  39,  23}, 
{46,  32,  21,  41,  22}, 
{36,  33,  24,  36,  22}, 
{23,  10,  36,  29,  21}, 
{11,  9,  36,  33,  21}, 
{12,  42,  23,  38,  21}, 
{24,  43,  23,  27,  24}, 
{6,  43,  25,  25,  23}, 
{12,  44,  24,  34,  21}, 
{6,  44,  25,  34,  23}, 
{2,  46,  23,  33,  22}, 
{25,  49,  21,  24,  23}, 
{21,  49,  17,  34,  23}, 
{12,  43,  18,  41,  22}, 
{6,  39,  18,  46,  22}, 
{42,  44,  21,  13,  21}, 
{49,  45,  20,  3,  22}, 
{40,  44,  25,  2,  22}, 
{30,  21,  28,  44,  21}, 
{32,  20,  24,  45,  22}, 
{26,  23,  25,  45,  23}, 
{24,  21,  22,  49,  22}, 
{25,  14,  31,  46,  22}, 
{25,  18,  31,  43,  22}, 
{25,  17,  31,  45,  22}, 
{18,  22,  32,  40,  22}, 
{2,  23,  32,  41,  22}, 
{3,  27,  29,  43,  24}, 
{3,  28,  30,  41,  22}, 
{40,  30,  24,  46,  21}, 
{40,  31,  24,  43,  26}, 
{43,  30,  23,  44,  24}, 
{26,  23,  25,  47,  24}, 
{32,  21,  24,  48,  24}, 
{31,  32,  21,  46,  24}, 
{49,  23,  25,  43,  24}, 
{40,  26,  27,  41,  25}, 
{27,  32,  24,  44,  23}, 
{40,  32,  23,  43,  23}, 
{46,  32,  22,  42,  23}, 
{24,  28,  22,  47,  23}, 
{31,  25,  26,  44,  23}, 
{27,  19,  26,  49,  23}, 
{19,  27,  19,  49,  22}, 
{24,  32,  29,  32,  21}, 
{14,  34,  29,  31,  22}, 
{24,  35,  29,  16,  22}, 
{38,  28,  21,  47,  21}, 
{29,  28,  24,  47,  24}, 
{38,  30,  16,  47,  22}, 
{32,  34,  16,  47,  22}, 
{49,  15,  24,  48,  22}, 
{41,  34,  25,  29,  21}, 
{42,  35,  25,  18,  22}, 
{49,  38,  8,  46,  21}, 
{41,  37,  12,  44,  24}, 
{41,  36,  18,  41,  22}, 
{42,  38,  10,  44,  22}, 
{11,  27,  27,  47,  21}, 
{29,  27,  29,  38,  21}, 
{23,  26,  30,  39,  24}, 
{16,  30,  31,  28,  22}, 
{8,  31,  30,  34,  22}, 
{31,  29,  27,  40,  21}, 
{21,  31,  27,  40,  23}, 
{29,  32,  26,  36,  22}, 
{28,  32,  28,  34,  22}, 
{26,  28,  29,  39,  23}, 
{29,  34,  27,  31,  22}, 
{13,  30,  32,  33,  21}, 
{15,  26,  31,  39,  23}, 
{10,  36,  23,  41,  21}, 
{8,  43,  21,  41,  22}, 
{34,  35,  29,  11,  21}, 
{29,  34,  31,  12,  22}, 
{17,  34,  32,  14,  22}, 
{49,  36,  12,  44,  21}, 
{3,  16,  42,  0,  21}, 
{47,  34,  13,  46,  21}, 
{49,  27,  21,  47,  21}, 
{40,  31,  24,  44,  21}, 
{29,  31,  24,  46,  22}, 
{19,  32,  18,  49,  21}, 
{33,  32,  20,  47,  21}, 
{26,  31,  24,  47,  22}, 
{37,  26,  24,  47,  21}, 
{28,  32,  29,  33,  21}, 
{35,  39,  15,  38,  21}, 
{42,  38,  13,  41,  23}, 
{42,  39,  12,  41,  21}, 
{5,  27,  28,  46,  21}, 
{3,  22,  31,  45,  22}, 
{27,  22,  28,  45,  22}, 
{24,  49,  22,  22,  21}, 
{8,  29,  30,  41,  21}, 
{32,  26,  29,  38,  21}, 
{40,  38,  32,  0,  21}, 
{36,  36,  37,  0,  22}, 
{33,  41,  34,  1,  23}, 
{34,  34,  34,  4,  21}, 
{49,  34,  34,  0,  21}, 
{25,  33,  20,  47,  21}, 
{24,  38,  21,  37,  21}, 
{23,  40,  23,  34,  23}, 
{22,  49,  17,  37,  22}, 
{24,  37,  21,  41,  22}, 
{31,  35,  23,  40,  22}, 
{36,  36,  24,  33,  21}, 
{30,  38,  24,  25,  24}, 
{40,  35,  25,  26,  23}, 
{35,  40,  25,  15,  23}, 
{35,  38,  23,  25,  23}, 
{34,  38,  23,  32,  22}, 
{29,  40,  24,  27,  22}, 
{21,  40,  24,  34,  22}, 
{40,  36,  23,  28,  22}, 
{29,  40,  23,  32,  22}, 
{25,  39,  23,  37,  23}, 
{25,  42,  24,  27,  22}, 
{34,  38,  24,  28,  21}, 
{25,  40,  20,  41,  21}, 
{24,  43,  19,  39,  22}, 
{26,  41,  15,  43,  22}, 
{40,  47,  21,  8,  21}, 
{29,  45,  18,  31,  22}, 
{25,  49,  25,  11,  21}, 
{25,  49,  27,  8,  21}, 
{38,  28,  31,  11,  21}, 
{36,  38,  22,  29,  21}, 
{27,  27,  27,  43,  21}, 
{30,  35,  28,  17,  21}, 
{22,  35,  28,  21,  21}, 
{36,  38,  7,  49,  21}, 
{23,  20,  33,  34,  21}, 
{3,  20,  34,  37,  21}, 
{49,  31,  23,  42,  21}, 
{9,  47,  24,  26,  21}, 
{9,  25,  32,  40,  21}, 
{11,  29,  31,  40,  21}, 
{3,  27,  31,  42,  21}, 
{40,  29,  25,  41,  21}, 
{49,  31,  25,  36,  21}, 
{31,  36,  23,  39,  21}, 
{10,  11,  35,  33,  21}, 
{43,  39,  6,  49,  21}, 
{0,  36,  19,  48,  21}, 
{3,  27,  30,  44,  21}, 
{41,  39,  15,  38,  21}, 
{36,  40,  13,  41,  21}, 
{36,  41,  12,  41,  21}, 
{40,  42,  9,  40,  21}, 
{45,  41,  11,  37,  21}, 
{43,  40,  11,  43,  21}, 
{44,  39,  15,  34,  21}, 
{44,  38,  18,  27,  22}, 
{44,  39,  16,  31,  21}, 
{42,  39,  15,  40,  21}, 
{33,  41,  14,  43,  22}, 
{34,  40,  19,  32,  22}, 
{44,  39,  18,  31,  22}, 
{37,  40,  21,  31,  22}, 
{34,  40,  24,  28,  24}, 
{41,  39,  18,  40,  21}, 
{40,  38,  21,  36,  22}, 
{39,  39,  22,  30,  24}, 
{37,  39,  21,  37,  23}, 
{42,  37,  19,  38,  22}, 
{40,  38,  23,  28,  22}, 
{41,  42,  21,  20,  21}, 
{32,  46,  18,  31,  24}, 
{30,  41,  20,  37,  22}, 
{33,  43,  20,  31,  22}, 
{33,  49,  8,  40,  22}, 
{28,  39,  23,  39,  21}, 
{39,  37,  18,  42,  21}, 
{16,  39,  23,  41,  21}, 
{33,  49,  18,  23,  21}, 
{15,  43,  25,  29,  21}, 
{36,  36,  25,  26,  21}, 
{23,  38,  27,  17,  22}, 
{26,  42,  25,  27,  24}, 
{35,  40,  25,  23,  23}, 
{35,  37,  25,  29,  22}, 
{21,  40,  25,  34,  21}, 
{36,  34,  25,  34,  22}, 
{30,  34,  24,  39,  21}, 
{36,  34,  25,  36,  21}, 
{33,  42,  21,  33,  21}, 
{26,  49,  17,  37,  21}, 
{46,  42,  11,  31,  21}, 
{16,  18,  34,  38,  21}, 
{14,  21,  33,  37,  21}, 
{31,  36,  25,  34,  21}, 
{34,  37,  27,  31,  20}, 
{21,  38,  27,  32,  26}, 
{31,  32,  29,  31,  23}, 
{38,  37,  27,  12,  22}, 
{17,  35,  28,  33,  22}, 
{35,  38,  26,  20,  22}, 
{36,  30,  29,  29,  21}, 
{33,  32,  31,  14,  23}, 
{38,  30,  28,  29,  22}, 
{33,  24,  31,  27,  21}, 
{33,  20,  34,  27,  22}, 
{29,  22,  31,  40,  21}, 
{32,  24,  30,  38,  22}, 
{30,  22,  32,  34,  22}, 
{31,  25,  32,  25,  23}, 
{34,  23,  31,  33,  21}, 
{46,  20,  34,  23,  23}, 
{49,  7,  32,  37,  22}, 
{13,  38,  27,  34,  21}, 
{32,  22,  30,  41,  21}, 
{45,  26,  31,  16,  21}, 
{20,  47,  32,  11,  20}, 
{13,  44,  29,  13,  23}, 
{15,  38,  31,  14,  22}, 
{31,  40,  30,  5,  22}, 
{15,  47,  34,  6,  21}, 
{11,  44,  33,  9,  22}, 
{16,  34,  33,  14,  21}, 
{28,  25,  33,  21,  24}, 
{28,  28,  34,  12,  22}, 
{33,  36,  29,  13,  21}, 
{28,  34,  32,  13,  21}, 
{27,  37,  32,  8,  21}, 
{26,  45,  32,  5,  21}, 
{34,  32,  32,  26,  20}, 
{4,  34,  31,  31,  24}, 
{24,  30,  32,  29,  24}, 
{14,  34,  32,  26,  24}, 
{36,  31,  31,  19,  23}, 
{34,  33,  30,  19,  22}, 
{15,  36,  32,  16,  21}, 
{14,  37,  29,  20,  21}, 
{30,  31,  32,  27,  21}, 
{12,  32,  31,  34,  21}, 
{28,  38,  28,  17,  21}, 
{9,  16,  36,  35,  20}, 
{18,  10,  36,  35,  22}, 
{23,  15,  36,  32,  23}, 
{16,  43,  28,  30,  20}, 
{8,  43,  27,  34,  23}, 
{14,  41,  29,  20,  22}, 
{34,  36,  28,  23,  21}, 
{27,  39,  28,  21,  22}, 
{24,  37,  28,  32,  21}, 
{28,  33,  29,  33,  23}, 
{33,  34,  28,  31,  22}, 
{4,  34,  32,  33,  21}, 
{24,  31,  32,  30,  21}, 
{35,  27,  30,  33,  21}, 
{32,  25,  31,  37,  22}, 
{30,  25,  32,  34,  22}, 
{19,  31,  32,  34,  23}, 
{25,  39,  28,  28,  21}, 
{19,  25,  32,  40,  21}, 
{4,  17,  38,  8,  20}, 
{25,  16,  28,  49,  20}, 
{0,  27,  28,  49,  22}, 
{41,  42,  18,  37,  20}, 
{36,  42,  21,  37,  24}, 
{38,  43,  19,  32,  22}, 
{0,  40,  21,  46,  20}, 
{23,  41,  21,  42,  23}, 
{5,  43,  19,  44,  21}, 
{40,  38,  24,  27,  20}, 
{40,  38,  25,  22,  22}, 
{9,  41,  29,  30,  20}, 
{9,  35,  32,  29,  21}, 
{9,  37,  31,  23,  22}, 
{34,  23,  36,  18,  20}, 
{3,  17,  43,  1,  20}, 
{40,  30,  26,  36,  20}, 
{40,  39,  26,  11,  23}, 
{40,  36,  27,  11,  22}, 
{46,  29,  31,  13,  23}, 
{34,  33,  26,  36,  22}, 
{40,  31,  30,  13,  21}, 
{45,  27,  30,  23,  21}, 
{46,  29,  32,  12,  21}, 
{37,  32,  32,  12,  21}, 
{39,  35,  23,  40,  20}, 
{39,  37,  21,  40,  22}, 
{26,  47,  24,  24,  20}, 
{17,  47,  29,  14,  22}, 
{22,  47,  24,  29,  21}, 
{30,  44,  23,  27,  21}, 
{28,  44,  20,  38,  21}, 
{21,  46,  25,  29,  21}, 
{17,  46,  28,  21,  21}, 
{14,  47,  29,  19,  21}, 
{30,  48,  23,  20,  21}, 
{17,  42,  32,  16,  20}, 
{11,  37,  33,  15,  21}, 
{25,  34,  34,  11,  20}, 
{21,  33,  34,  13,  21}, 
{28,  25,  34,  18,  21}, 
{11,  44,  34,  9,  21}, 
{7,  37,  34,  15,  22}, 
{19,  25,  34,  37,  20}, 
{22,  25,  34,  33,  23}, 
{27,  23,  36,  22,  22}, 
{22,  22,  35,  28,  22}, 
{19,  26,  33,  35,  22}, 
{26,  24,  36,  23,  21}, 
{29,  27,  36,  8,  22}, 
{49,  26,  35,  8,  21}, 
{28,  16,  34,  37,  21}, 
{16,  25,  34,  38,  21}, 
{23,  14,  35,  35,  21}, 
{19,  29,  35,  9,  21}, 
{9,  20,  36,  35,  20}, 
{23,  15,  38,  7,  20}, 
{21,  23,  37,  8,  23}, 
{6,  27,  38,  5,  21}, 
{32,  21,  38,  6,  22}, 
{43,  37,  10,  46,  20}, 
{31,  36,  15,  47,  24}, 
{38,  40,  10,  45,  22}, 
{39,  39,  8,  49,  21}, 
{3,  7,  40,  3,  20}, 
{36,  4,  39,  8,  20}, 
{40,  34,  25,  35,  20}, 
{25,  14,  29,  47,  20}, 
{33,  37,  16,  44,  20}, 
{40,  40,  25,  15,  20}, 
{42,  40,  25,  12,  20}, 
{44,  39,  23,  8,  21}, 
{42,  37,  25,  18,  21}, 
{49,  35,  24,  18,  20}, 
{39,  40,  24,  27,  20}, 
{43,  41,  18,  32,  20}, 
{43,  41,  12,  42,  21}, 
{47,  42,  15,  21,  21}, 
{34,  32,  34,  9,  20}, 
{38,  33,  28,  19,  20}, 
{38,  36,  27,  19,  22}, 
{37,  33,  31,  13,  21}, 
{27,  39,  32,  11,  20}, 
{35,  42,  21,  39,  20}, 
{28,  41,  21,  42,  20}, 
{34,  35,  23,  41,  21}, 
{39,  37,  19,  42,  21}, 
{33,  35,  20,  44,  22}, 
{37,  35,  21,  43,  23}, 
{39,  36,  19,  43,  21}, 
{31,  33,  21,  47,  21}, 
{27,  27,  19,  49,  20}, 
{33,  32,  17,  48,  22}, 
{49,  23,  19,  49,  21}, 
{33,  32,  16,  49,  21}, 
{49,  27,  17,  49,  21}, 
{22,  35,  30,  27,  20}, 
{19,  42,  29,  24,  23}, 
{15,  37,  32,  23,  22}, 
{19,  47,  27,  23,  21}, 
{15,  39,  31,  23,  20}, 
{17,  47,  30,  17,  21}, 
{14,  38,  32,  27,  20}, 
{4,  36,  31,  32,  22}, 
{15,  40,  32,  20,  21}, 
{19,  47,  30,  19,  21}, 
{47,  35,  13,  46,  20}, 
{30,  48,  25,  12,  20}, 
{36,  30,  18,  48,  20}, 
{40,  33,  28,  16,  20}, 
{42,  40,  18,  39,  20}, 
{20,  49,  30,  10,  20}, 
{37,  36,  38,  0,  20}, 
{31,  35,  32,  11,  20}, 
{31,  36,  34,  5,  20}, 
{31,  41,  10,  46,  20}, 
{8,  43,  18,  46,  21}, 
{44,  37,  21,  21,  20}, 
{47,  40,  19,  14,  21}, 
{7,  33,  25,  43,  20}, 
{9,  34,  27,  40,  20}, 
{27,  32,  26,  40,  22}, 
{3,  35,  27,  41,  20}, 
{35,  35,  25,  36,  22}, 
{7,  33,  27,  42,  21}, 
{3,  29,  29,  43,  21}, 
{5,  29,  28,  45,  21}, 
{13,  41,  27,  35,  20}, 
{16,  44,  24,  35,  21}, 
{3,  36,  25,  41,  21}, 
{17,  29,  35,  11,  20}, 
{17,  26,  35,  17,  21}, 
{35,  25,  36,  18,  20}, 
{32,  28,  36,  10,  21}, 
{15,  36,  37,  3,  21}, 
{45,  23,  34,  23,  21}, 
{36,  31,  33,  12,  20}, 
{27,  36,  34,  11,  20}, 
{3,  37,  24,  41,  20}, 
{26,  37,  25,  36,  21}, 
{7,  43,  25,  38,  20}, 
{17,  29,  36,  13,  20}, 
{40,  35,  24,  35,  20}, 
{24,  45,  15,  41,  20}, 
{27,  43,  20,  42,  21}, 
{37,  32,  24,  43,  20}, 
{40,  48,  21,  13,  20}, 
{29,  18,  30,  45,  20}, 
{44,  28,  26,  39,  20}, 
{38,  42,  14,  42,  20}, 
{44,  49,  1,  48,  21}, 
{45,  43,  4,  45,  21}, 
{3,  17,  41,  2,  20}, 
{31,  36,  28,  31,  20}, 
{36,  38,  24,  31,  20}, 
{26,  40,  24,  35,  20}, 
{16,  39,  29,  31,  20}, 
{40,  38,  31,  1,  20}, 
{37,  34,  32,  9,  21}, 
{37,  37,  31,  5,  22}, 
{36,  41,  32,  2,  22}, 
{36,  40,  28,  8,  21}, 
{33,  38,  28,  20,  21}, 
{42,  37,  28,  3,  20}, 
{41,  35,  28,  10,  21}, 
{46,  32,  30,  10,  22}, 
{45,  30,  28,  23,  22}, 
{49,  35,  28,  5,  20}, 
{43,  40,  26,  5,  21}, 
{43,  41,  31,  2,  20}, 
{46,  34,  29,  10,  22}, 
{42,  35,  31,  6,  22}, 
{43,  39,  27,  8,  21}, 
{42,  34,  32,  9,  20}, 
{32,  39,  30,  11,  20}, 
{36,  37,  30,  11,  21}, 
{34,  38,  32,  7,  20}, 
{35,  37,  34,  5,  21}, 
{40,  29,  27,  33,  20}, 
{45,  30,  28,  29,  21}, 
{38,  26,  30,  31,  20}, 
{49,  12,  33,  36,  21}, 
{36,  24,  33,  26,  20}, 
{26,  25,  34,  29,  21}, 
{25,  23,  36,  25,  20}, 
{16,  24,  36,  27,  21}, 
{49,  11,  32,  40,  20}, 
{43,  39,  8,  49,  20}, 
{0,  31,  25,  49,  20}, 
{34,  33,  21,  45,  20}, 
{44,  35,  15,  44,  21}, 
{41,  32,  22,  44,  21}, 
{0,  29,  27,  48,  20}, 
{11,  30,  26,  47,  20}, 
{27,  23,  35,  27,  20}, 
{30,  37,  32,  12,  20}, 
{32,  35,  33,  12,  21}, 
{40,  35,  22,  41,  20}, 
{32,  42,  19,  41,  20}, 
{49,  30,  18,  46,  20}, 
{1,  42,  25,  46,  19}, 
{4,  35,  25,  47,  22}, 
{34,  37,  21,  43,  22}, 
{7,  43,  25,  42,  21}, 
{32,  35,  23,  42,  21}, 
{41,  37,  20,  41,  20}, 
{1,  38,  23,  47,  20}, 
{32,  41,  21,  42,  20}, 
{36,  28,  24,  49,  19}, 
{16,  25,  27,  49,  21}, 
{35,  31,  21,  48,  20}, 
{41,  32,  20,  46,  20}, 
{40,  36,  15,  46,  23}, 
{40,  33,  18,  46,  20}, 
{38,  36,  14,  47,  20}, 
{41,  34,  19,  44,  20}, 
{36,  36,  20,  44,  20}, 
{40,  34,  19,  45,  20}, 
{21,  32,  22,  49,  20}, 
{37,  32,  23,  45,  20}, 
{19,  25,  34,  39,  19}, 
{23,  15,  33,  40,  20}, 
{3,  34,  29,  42,  19}, 
{4,  34,  31,  37,  24}, 
{4,  33,  32,  37,  20}, 
{22,  33,  28,  36,  20}, 
{34,  32,  27,  36,  20}, 
{33,  34,  28,  33,  22}, 
{30,  31,  27,  39,  20}, 
{37,  36,  27,  31,  19}, 
{36,  33,  29,  26,  22}, 
{38,  33,  26,  36,  21}, 
{40,  35,  25,  36,  21}, 
{32,  33,  29,  33,  20}, 
{37,  32,  31,  20,  20}, 
{38,  28,  31,  26,  20}, 
{41,  48,  24,  9,  19}, 
{34,  42,  28,  8,  20}, 
{32,  45,  31,  4,  21}, 
{34,  48,  28,  8,  20}, 
{38,  46,  27,  7,  21}, 
{36,  43,  30,  5,  20}, 
{27,  25,  32,  40,  19}, 
{26,  19,  35,  35,  19}, 
{27,  35,  32,  20,  19}, 
{35,  33,  32,  20,  21}, 
{22,  34,  32,  28,  21}, 
{31,  37,  29,  18,  20}, 
{23,  37,  32,  20,  21}, 
{42,  33,  31,  18,  19}, 
{44,  31,  31,  21,  22}, 
{41,  33,  31,  20,  20}, 
{3,  25,  31,  46,  19}, 
{25,  18,  31,  46,  20}, 
{24,  23,  30,  45,  19}, 
{28,  25,  29,  43,  21}, 
{21,  27,  30,  42,  20}, 
{20,  28,  29,  43,  20}, 
{24,  29,  27,  43,  20}, 
{11,  29,  30,  44,  20}, 
{25,  30,  27,  42,  20}, 
{30,  32,  26,  41,  20}, 
{35,  39,  26,  28,  19}, 
{33,  38,  28,  25,  20}, 
{39,  40,  25,  25,  20}, 
{37,  39,  25,  30,  21}, 
{34,  42,  28,  23,  19}, 
{30,  44,  25,  27,  22}, 
{35,  41,  27,  26,  22}, 
{42,  39,  27,  12,  21}, 
{36,  43,  29,  9,  21}, 
{29,  43,  29,  16,  22}, 
{22,  42,  31,  19,  22}, 
{31,  42,  30,  14,  21}, 
{19,  45,  31,  19,  21}, 
{25,  44,  29,  20,  20}, 
{30,  43,  27,  26,  20}, 
{30,  48,  25,  19,  20}, 
{28,  47,  26,  22,  20}, 
{28,  45,  28,  23,  20}, 
{27,  46,  29,  20,  21}, 
{31,  48,  28,  13,  20}, 
{29,  42,  32,  10,  20}, 
{42,  32,  27,  32,  19}, 
{38,  31,  31,  25,  20}, 
{35,  33,  32,  23,  21}, 
{32,  33,  31,  27,  20}, 
{33,  33,  30,  31,  19}, 
{28,  30,  32,  30,  20}, 
{39,  40,  25,  30,  19}, 
{41,  33,  28,  29,  19}, 
{47,  32,  24,  41,  19}, 
{18,  18,  30,  47,  19}, 
{5,  28,  30,  47,  19}, 
{5,  30,  30,  46,  19}, 
{22,  31,  27,  43,  20}, 
{41,  37,  25,  27,  19}, 
{41,  37,  22,  33,  20}, 
{42,  38,  23,  23,  20}, 
{43,  35,  23,  28,  21}, 
{43,  37,  21,  32,  21}, 
{42,  37,  25,  26,  20}, 
{41,  35,  23,  40,  20}, 
{42,  36,  21,  41,  21}, 
{43,  35,  23,  40,  19}, 
{44,  37,  22,  33,  21}, 
{42,  34,  25,  36,  21}, 
{43,  38,  18,  40,  21}, 
{44,  35,  24,  33,  20}, 
{43,  37,  24,  28,  21}, 
{47,  36,  13,  46,  20}, 
{42,  33,  29,  27,  19}, 
{45,  26,  31,  29,  20}, 
{42,  33,  31,  23,  20}, 
{9,  22,  35,  35,  19}, 
{23,  22,  35,  32,  20}, 
{44,  39,  25,  12,  19}, 
{44,  46,  26,  2,  20}, 
{43,  43,  31,  1,  20}, 
{24,  29,  29,  42,  19}, 
{26,  29,  30,  37,  20}, 
{36,  38,  27,  30,  19}, 
{27,  38,  29,  27,  19}, 
{34,  34,  30,  29,  21}, 
{31,  35,  30,  26,  20}, 
{25,  35,  29,  33,  20}, 
{29,  39,  32,  16,  19}, 
{31,  42,  30,  18,  21}, 
{27,  40,  31,  20,  20}, 
{39,  34,  24,  38,  19}, 
{34,  33,  24,  41,  21}, 
{47,  33,  24,  40,  19}, 
{39,  37,  30,  11,  19}, 
{42,  37,  31,  7,  21}, 
{40,  40,  28,  11,  21}, 
{35,  32,  36,  4,  19}, 
{16,  30,  36,  13,  20}, 
{30,  37,  34,  11,  19}, 
{30,  40,  34,  7,  19}, 
{26,  44,  34,  6,  20}, 
{35,  30,  26,  41,  19}, 
{10,  28,  31,  43,  19}, 
{38,  40,  16,  42,  19}, 
{30,  36,  23,  42,  19}, 
{28,  39,  23,  42,  19}, 
{4,  32,  31,  39,  19}, 
{22,  45,  24,  31,  19}, 
{6,  32,  28,  44,  19}, 
{19,  36,  34,  15,  19}, 
{22,  27,  36,  16,  21}, 
{28,  39,  24,  36,  19}, 
{39,  38,  24,  32,  20}, 
{35,  41,  24,  32,  19}, 
{34,  42,  26,  28,  20}, 
{21,  40,  28,  32,  20}, 
{4,  39,  30,  33,  19}, 
{4,  38,  31,  34,  20}, 
{6,  35,  28,  42,  20}, 
{34,  39,  34,  6,  19}, 
{41,  41,  32,  2,  19}, 
{1,  38,  18,  49,  19}, 
{33,  17,  43,  0,  19}, 
{5,  17,  43,  3,  19}, 
{40,  32,  24,  44,  19}, 
{38,  40,  8,  49,  19}, 
{26,  25,  25,  49,  19}, 
{30,  25,  26,  46,  20}, 
{25,  34,  32,  29,  19}, 
{3,  49,  9,  46,  19}, 
{39,  43,  30,  5,  19}, 
{42,  35,  32,  9,  19}, 
{43,  34,  9,  49,  19}, 
{33,  34,  15,  49,  20}, 
{34,  25,  31,  36,  19}, 
{21,  46,  26,  29,  19}, 
{3,  45,  28,  30,  19}, 
{42,  35,  27,  17,  19}, 
{39,  35,  26,  32,  20}, 
{44,  36,  27,  13,  19}, 
{44,  45,  27,  3,  20}, 
{44,  42,  31,  2,  20}, 
{45,  39,  33,  0,  22}, 
{49,  39,  33,  0,  20}, 
{49,  36,  34,  1,  19}, 
{40,  38,  33,  4,  21}, 
{38,  31,  34,  11,  20}, 
{9,  30,  27,  49,  19}, 
{37,  34,  21,  45,  19}, 
{44,  40,  18,  34,  19}, 
{44,  37,  21,  37,  19}, 
{49,  34,  23,  40,  20}, 
{36,  25,  28,  40,  19}, 
{42,  40,  23,  20,  19}, 
{43,  43,  19,  23,  19}, 
{41,  47,  18,  19,  19}, 
{39,  44,  19,  30,  21}, 
{35,  48,  20,  23,  20}, 
{44,  49,  10,  32,  21}, 
{41,  49,  10,  37,  21}, 
{36,  49,  18,  31,  19}, 
{45,  44,  7,  40,  19}, 
{36,  44,  18,  37,  19}, 
{45,  43,  6,  45,  19}, 
{44,  41,  7,  47,  19}, 
{27,  42,  34,  9,  19}, 
{49,  36,  18,  35,  19}, 
{49,  35,  23,  37,  20}, 
{44,  36,  29,  11,  19}, 
{9,  35,  25,  45,  19}, 
{0,  28,  31,  46,  19}, 
{47,  36,  14,  45,  19}, 
{49,  36,  18,  40,  19}, 
{44,  36,  21,  41,  20}, 
{41,  42,  18,  40,  19}, 
{7,  42,  26,  37,  19}, 
{39,  34,  25,  37,  19}, 
{33,  29,  24,  48,  19}, 
{34,  34,  18,  47,  19}, 
{24,  42,  28,  29,  19}, 
{33,  25,  25,  48,  19}, 
{27,  38,  30,  25,  19}, 
{32,  28,  36,  12,  19}, 
{6,  32,  38,  5,  19}, 
{42,  37,  34,  2,  19}, 
{28,  42,  23,  36,  19}, 
{21,  43,  25,  35,  19}, 
{28,  44,  24,  35,  19}, 
{34,  44,  23,  30,  20}, 
{37,  48,  21,  24,  19}, 
{26,  24,  35,  41,  18}, 
{9,  20,  36,  36,  23}, 
{29,  22,  31,  43,  21}, 
{16,  13,  34,  43,  19}, 
{20,  20,  32,  45,  19}, 
{22,  18,  34,  42,  20}, 
{5,  24,  32,  45,  20}, 
{20,  21,  34,  43,  19}, 
{26,  25,  34,  40,  19}, 
{25,  25,  31,  43,  19}, 
{33,  22,  31,  41,  19}, 
{25,  20,  36,  32,  19}, 
{30,  23,  38,  22,  18}, 
{37,  33,  38,  1,  20}, 
{37,  32,  37,  3,  20}, 
{35,  4,  39,  10,  19}, 
{6,  27,  38,  9,  19}, 
{35,  24,  37,  18,  21}, 
{26,  30,  35,  34,  18}, 
{12,  29,  35,  36,  25}, 
{32,  29,  35,  16,  23}, 
{24,  28,  36,  26,  23}, 
{29,  36,  34,  15,  22}, 
{30,  26,  36,  23,  22}, 
{24,  26,  35,  37,  22}, 
{6,  30,  34,  38,  23}, 
{31,  32,  31,  31,  20}, 
{14,  29,  35,  37,  20}, 
{33,  33,  34,  15,  20}, 
{25,  25,  35,  40,  20}, 
{24,  32,  35,  26,  19}, 
{16,  33,  34,  26,  22}, 
{29,  32,  35,  15,  21}, 
{6,  35,  34,  23,  19}, 
{12,  37,  33,  22,  20}, 
{12,  28,  34,  39,  19}, 
{29,  28,  35,  23,  19}, 
{15,  29,  31,  43,  19}, 
{26,  32,  36,  11,  19}, 
{6,  37,  34,  22,  19}, 
{20,  28,  35,  36,  19}, 
{21,  29,  31,  42,  21}, 
{37,  32,  35,  6,  19}, 
{36,  26,  31,  34,  19}, 
{38,  31,  34,  13,  19}, 
{39,  32,  32,  23,  20}, 
{45,  25,  35,  17,  19}, 
{45,  32,  32,  15,  19}, 
{44,  30,  32,  24,  20}, 
{36,  31,  31,  29,  19}, 
{39,  37,  24,  41,  18}, 
{26,  35,  28,  38,  19}, 
{25,  32,  28,  41,  20}, 
{20,  39,  26,  37,  20}, 
{32,  41,  22,  42,  19}, 
{39,  38,  23,  38,  21}, 
{35,  41,  23,  39,  19}, 
{37,  39,  24,  35,  21}, 
{33,  42,  24,  35,  20}, 
{23,  39,  27,  35,  19}, 
{29,  43,  25,  35,  21}, 
{37,  39,  25,  33,  19}, 
{11,  39,  25,  43,  19}, 
{23,  34,  22,  47,  21}, 
{30,  34,  23,  44,  21}, 
{34,  33,  24,  43,  21}, 
{28,  33,  24,  45,  20}, 
{32,  35,  24,  42,  19}, 
{21,  34,  24,  46,  20}, 
{23,  30,  31,  37,  19}, 
{20,  31,  32,  36,  19}, 
{23,  31,  29,  41,  19}, 
{24,  22,  34,  45,  18}, 
{24,  25,  32,  44,  19}, 
{16,  25,  35,  42,  19}, 
{5,  26,  32,  46,  19}, 
{12,  28,  34,  40,  19}, 
{30,  25,  28,  44,  19}, 
{37,  39,  31,  18,  18}, 
{39,  35,  31,  20,  23}, 
{38,  37,  28,  23,  22}, 
{39,  40,  26,  24,  21}, 
{34,  42,  30,  18,  20}, 
{37,  40,  28,  23,  20}, 
{42,  37,  29,  17,  19}, 
{40,  40,  28,  17,  21}, 
{42,  37,  31,  12,  19}, 
{32,  39,  32,  16,  19}, 
{0,  42,  28,  41,  18}, 
{4,  39,  29,  36,  20}, 
{10,  38,  30,  35,  19}, 
{19,  39,  28,  37,  20}, 
{10,  41,  29,  35,  19}, 
{11,  38,  28,  41,  19}, 
{25,  24,  36,  38,  18}, 
{15,  27,  36,  35,  21}, 
{9,  30,  36,  35,  20}, 
{36,  37,  27,  36,  18}, 
{41,  30,  27,  38,  20}, 
{38,  35,  26,  37,  21}, 
{34,  38,  27,  34,  19}, 
{29,  38,  28,  34,  20}, 
{37,  37,  27,  34,  19}, 
{36,  31,  27,  39,  19}, 
{38,  34,  26,  38,  19}, 
{36,  32,  26,  41,  20}, 
{29,  34,  29,  34,  19}, 
{19,  35,  29,  38,  19}, 
{0,  27,  32,  47,  18}, 
{0,  28,  31,  48,  18}, 
{9,  16,  31,  48,  19}, 
{48,  32,  22,  45,  18}, 
{47,  33,  21,  44,  20}, 
{47,  30,  24,  45,  19}, 
{49,  31,  22,  46,  19}, 
{9,  37,  28,  44,  18}, 
{32,  30,  29,  39,  18}, 
{36,  27,  28,  41,  20}, 
{34,  28,  31,  35,  19}, 
{32,  30,  31,  35,  20}, 
{29,  28,  30,  41,  19}, 
{31,  31,  29,  38,  19}, 
{32,  30,  30,  38,  19}, 
{25,  28,  27,  46,  18}, 
{21,  32,  27,  44,  20}, 
{20,  23,  29,  47,  19}, 
{24,  22,  32,  46,  20}, 
{17,  25,  32,  46,  20}, 
{15,  27,  30,  47,  19}, 
{46,  41,  12,  41,  18}, 
{47,  37,  15,  42,  20}, 
{45,  39,  16,  34,  19}, 
{47,  43,  3,  44,  19}, 
{40,  40,  15,  45,  18}, 
{36,  40,  16,  44,  19}, 
{42,  40,  18,  41,  19}, 
{40,  40,  17,  43,  20}, 
{37,  42,  19,  41,  19}, 
{36,  40,  18,  44,  19}, 
{34,  40,  23,  41,  19}, 
{39,  42,  23,  33,  18}, 
{36,  42,  23,  39,  19}, 
{39,  48,  23,  15,  19}, 
{46,  42,  19,  23,  18}, 
{47,  43,  22,  5,  20}, 
{46,  39,  16,  37,  19}, 
{47,  41,  21,  11,  19}, 
{43,  41,  23,  16,  20}, 
{44,  41,  15,  41,  19}, 
{0,  27,  34,  45,  18}, 
{26,  23,  34,  43,  19}, 
{33,  16,  43,  3,  18}, 
{47,  44,  28,  1,  18}, 
{48,  49,  25,  0,  20}, 
{32,  49,  29,  9,  19}, 
{47,  41,  32,  0,  19}, 
{14,  42,  30,  27,  18}, 
{14,  41,  32,  25,  18}, 
{34,  41,  30,  21,  18}, 
{34,  39,  29,  24,  20}, 
{42,  37,  29,  20,  19}, 
{34,  37,  30,  25,  19}, 
{33,  40,  31,  20,  19}, 
{9,  38,  30,  38,  18}, 
{0,  39,  29,  41,  19}, 
{5,  36,  29,  43,  20}, 
{3,  41,  29,  40,  19}, 
{47,  43,  24,  5,  18}, 
{42,  38,  25,  28,  18}, 
{41,  39,  27,  20,  19}, 
{38,  37,  23,  42,  18}, 
{38,  35,  24,  42,  19}, 
{35,  34,  24,  43,  19}, 
{4,  32,  32,  40,  18}, 
{40,  43,  29,  9,  18}, 
{38,  40,  29,  19,  19}, 
{42,  38,  29,  17,  19}, 
{44,  42,  29,  4,  19}, 
{35,  39,  32,  16,  18}, 
{45,  41,  18,  37,  18}, 
{44,  41,  19,  34,  19}, 
{42,  39,  21,  34,  19}, 
{40,  41,  22,  33,  19}, 
{42,  39,  25,  28,  21}, 
{42,  40,  29,  17,  18}, 
{42,  41,  31,  5,  19}, 
{20,  49,  23,  31,  18}, 
{34,  32,  20,  49,  18}, 
{30,  39,  24,  39,  18}, 
{25,  39,  26,  38,  20}, 
{38,  37,  26,  37,  18}, 
{44,  36,  28,  25,  18}, 
{44,  35,  27,  29,  22}, 
{41,  38,  27,  27,  21}, 
{35,  38,  29,  26,  20}, 
{44,  35,  28,  29,  20}, 
{39,  41,  26,  27,  18}, 
{42,  41,  29,  15,  21}, 
{38,  42,  24,  30,  19}, 
{37,  43,  27,  26,  19}, 
{41,  43,  28,  14,  21}, 
{40,  43,  26,  21,  21}, 
{33,  46,  26,  20,  20}, 
{41,  42,  22,  31,  19}, 
{35,  43,  29,  20,  19}, 
{4,  40,  31,  32,  18}, 
{16,  35,  27,  44,  18}, 
{23,  39,  25,  41,  20}, 
{16,  32,  36,  23,  18}, 
{26,  38,  27,  38,  18}, 
{25,  32,  29,  41,  18}, 
{28,  26,  35,  27,  18}, 
{38,  30,  38,  3,  18}, 
{22,  37,  38,  3,  19}, 
{4,  39,  38,  2,  20}, 
{21,  49,  35,  2,  19}, 
{38,  40,  35,  0,  20}, 
{37,  42,  34,  2,  19}, 
{4,  43,  39,  0,  19}, 
{22,  42,  35,  3,  19}, 
{30,  24,  38,  20,  19}, 
{35,  37,  36,  2,  18}, 
{30,  27,  28,  43,  18}, 
{33,  30,  23,  49,  18}, 
{33,  35,  28,  35,  18}, 
{37,  33,  29,  34,  18}, 
{39,  36,  28,  30,  20}, 
{43,  32,  29,  32,  19}, 
{45,  24,  28,  40,  19}, 
{36,  29,  31,  34,  18}, 
{49,  36,  24,  16,  18}, 
{45,  41,  23,  13,  19}, 
{49,  9,  35,  28,  18}, 
{14,  38,  29,  40,  18}, 
{25,  39,  29,  33,  18}, 
{33,  36,  29,  32,  18}, 
{39,  36,  29,  30,  18}, 
{37,  39,  29,  26,  19}, 
{23,  38,  30,  30,  18}, 
{20,  42,  30,  27,  19}, 
{38,  37,  29,  28,  18}, 
{5,  49,  20,  37,  18}, 
{44,  28,  28,  36,  18}, 
{45,  30,  29,  34,  18}, 
{41,  35,  29,  30,  18}, 
{32,  29,  35,  18,  18}, 
{33,  29,  34,  23,  18}, 
{33,  28,  33,  27,  19}, 
{31,  30,  32,  32,  20}, 
{34,  29,  32,  31,  19}, 
{32,  28,  35,  23,  18}, 
{49,  27,  21,  49,  18}, 
{43,  23,  34,  27,  18}, 
{38,  28,  32,  29,  19}, 
{35,  32,  32,  29,  20}, 
{38,  31,  32,  29,  19}, 
{34,  25,  32,  35,  18}, 
{32,  34,  25,  41,  18}, 
{42,  42,  29,  14,  18}, 
{47,  31,  24,  43,  18}, 
{43,  39,  14,  44,  18}, 
{23,  48,  24,  29,  18}, 
{24,  26,  32,  42,  18}, 
{49,  27,  25,  42,  18}, 
{42,  27,  24,  47,  18}, 
{44,  43,  19,  26,  18}, 
{42,  43,  18,  35,  19}, 
{42,  43,  14,  42,  18}, 
{42,  43,  18,  40,  19}, 
{46,  44,  9,  41,  19}, 
{47,  44,  18,  20,  18}, 
{42,  42,  23,  28,  18}, 
{19,  40,  29,  35,  18}, 
{18,  42,  30,  30,  20}, 
{3,  42,  29,  40,  19}, 
{32,  27,  38,  6,  18}, 
{33,  5,  45,  1,  18}, 
{47,  37,  14,  45,  18}, 
{46,  34,  25,  36,  18}, 
{35,  42,  22,  41,  18}, 
{41,  47,  18,  27,  18}, 
{45,  46,  15,  27,  18}, 
{44,  45,  18,  29,  19}, 
{30,  40,  25,  37,  18}, 
{24,  40,  25,  41,  19}, 
{15,  40,  25,  43,  19}, 
{23,  43,  26,  36,  18}, 
{28,  43,  26,  34,  19}, 
{16,  43,  29,  33,  18}, 
{20,  45,  30,  23,  20}, 
{3,  44,  30,  30,  19}, 
{24,  47,  29,  22,  19}, 
{14,  43,  32,  22,  18}, 
{14,  45,  31,  25,  18}, 
{14,  43,  32,  26,  20}, 
{44,  32,  32,  23,  18}, 
{38,  36,  30,  24,  18}, 
{30,  26,  27,  45,  18}, 
{49,  37,  24,  14,  18}, 
{41,  45,  24,  14,  18}, 
{47,  49,  24,  2,  18}, 
{34,  34,  34,  15,  18}, 
{49,  16,  33,  35,  18}, 
{40,  26,  32,  32,  19}, 
{34,  34,  28,  36,  18}, 
{34,  32,  29,  36,  18}, 
{26,  42,  26,  37,  18}, 
{29,  31,  29,  40,  18}, 
{30,  34,  28,  40,  18}, 
{28,  34,  26,  42,  20}, 
{29,  28,  27,  45,  19}, 
{39,  29,  25,  43,  19}, 
{31,  34,  25,  43,  19}, 
{30,  34,  29,  37,  18}, 
{19,  38,  29,  39,  18}, 
{24,  37,  28,  39,  18}, 
{34,  33,  28,  38,  18}, 
{36,  37,  27,  37,  18}, 
{35,  34,  28,  38,  18}, 
{37,  35,  28,  36,  18}, 
{37,  37,  28,  33,  18}, 
{37,  38,  29,  29,  19}, 
{20,  38,  27,  41,  18}, 
{39,  48,  25,  15,  18}, 
{49,  9,  39,  7,  18}, 
{33,  15,  43,  4,  18}, 
{41,  34,  18,  46,  18}, 
{27,  39,  15,  46,  18}, 
{27,  38,  15,  47,  18}, 
{45,  45,  23,  9,  18}, 
{44,  42,  27,  8,  19}, 
{35,  37,  38,  1,  18}, 
{35,  35,  38,  3,  19}, 
{4,  35,  23,  48,  18}, 
{24,  30,  27,  45,  18}, 
{19,  23,  39,  3,  18}, 
{9,  22,  43,  2,  18}, 
{49,  22,  40,  3,  19}, 
{33,  27,  43,  1,  18}, 
{38,  32,  40,  1,  20}, 
{33,  34,  43,  0,  20}, 
{24,  25,  40,  4,  19}, 
{7,  25,  39,  7,  18}, 
{35,  37,  39,  1,  18}, 
{26,  21,  38,  35,  17}, 
{19,  20,  40,  28,  17}, 
{24,  22,  39,  16,  21}, 
{24,  21,  40,  21,  18}, 
{30,  22,  39,  18,  19}, 
{49,  25,  39,  7,  19}, 
{23,  21,  40,  26,  18}, 
{47,  37,  18,  46,  17}, 
{31,  39,  15,  47,  20}, 
{25,  40,  18,  46,  20}, 
{49,  39,  18,  36,  19}, 
{38,  37,  15,  47,  19}, 
{44,  38,  17,  46,  18}, 
{44,  39,  14,  46,  20}, 
{47,  38,  14,  46,  19}, 
{43,  36,  21,  43,  18}, 
{40,  35,  24,  42,  20}, 
{47,  35,  19,  45,  19}, 
{38,  39,  15,  47,  18}, 
{26,  37,  18,  47,  18}, 
{1,  39,  18,  49,  18}, 
{47,  39,  15,  41,  18}, 
{43,  35,  23,  42,  18}, 
{47,  33,  20,  46,  18}, 
{44,  34,  24,  40,  18}, 
{19,  44,  34,  19,  17}, 
{26,  38,  33,  19,  21}, 
{24,  34,  34,  23,  19}, 
{30,  38,  34,  15,  19}, 
{18,  40,  34,  20,  19}, 
{22,  46,  32,  13,  19}, 
{26,  40,  34,  16,  19}, 
{7,  24,  32,  49,  17}, 
{6,  30,  29,  49,  19}, 
{48,  32,  21,  49,  17}, 
{42,  36,  15,  47,  21}, 
{42,  33,  21,  47,  20}, 
{41,  30,  22,  49,  19}, 
{38,  34,  21,  46,  18}, 
{35,  34,  23,  46,  18}, 
{43,  33,  22,  46,  19}, 
{36,  35,  23,  44,  18}, 
{31,  35,  21,  46,  19}, 
{38,  36,  23,  43,  18}, 
{43,  35,  20,  45,  18}, 
{24,  13,  41,  14,  17}, 
{1,  38,  29,  46,  17}, 
{21,  35,  26,  45,  18}, 
{0,  31,  29,  49,  18}, 
{0,  34,  28,  47,  19}, 
{0,  36,  27,  47,  18}, 
{26,  35,  24,  45,  18}, 
{23,  6,  41,  26,  17}, 
{2,  10,  41,  26,  19}, 
{29,  27,  38,  23,  17}, 
{41,  37,  34,  10,  17}, 
{37,  39,  32,  16,  20}, 
{37,  34,  34,  15,  19}, 
{43,  29,  33,  23,  19}, 
{39,  29,  34,  22,  20}, 
{39,  38,  34,  8,  19}, 
{41,  39,  31,  10,  18}, 
{41,  33,  34,  23,  17}, 
{38,  31,  33,  26,  20}, 
{32,  33,  34,  24,  19}, 
{36,  35,  33,  20,  18}, 
{35,  34,  34,  22,  20}, 
{40,  27,  34,  32,  17}, 
{28,  25,  36,  32,  21}, 
{30,  30,  34,  31,  20}, 
{34,  22,  34,  35,  20}, 
{49,  13,  34,  38,  19}, 
{34,  33,  34,  25,  19}, 
{27,  22,  34,  43,  18}, 
{29,  19,  37,  33,  18}, 
{31,  25,  34,  35,  18}, 
{27,  23,  35,  40,  18}, 
{29,  24,  36,  34,  18}, 
{31,  20,  35,  35,  19}, 
{32,  29,  35,  25,  20}, 
{44,  31,  30,  29,  18}, 
{42,  22,  35,  26,  18}, 
{49,  14,  36,  23,  19}, 
{39,  30,  34,  26,  18}, 
{14,  43,  32,  31,  17}, 
{14,  44,  32,  28,  20}, 
{23,  36,  32,  31,  18}, 
{35,  37,  31,  22,  19}, 
{19,  44,  31,  26,  19}, 
{24,  38,  31,  31,  20}, 
{35,  37,  30,  28,  19}, 
{25,  36,  34,  22,  18}, 
{21,  47,  27,  28,  18}, 
{6,  49,  25,  30,  18}, 
{23,  49,  27,  17,  19}, 
{28,  48,  28,  21,  19}, 
{12,  49,  30,  19,  19}, 
{6,  48,  30,  24,  18}, 
{8,  38,  32,  33,  18}, 
{29,  32,  29,  43,  17}, 
{22,  30,  29,  44,  18}, 
{31,  29,  26,  45,  18}, 
{23,  29,  31,  43,  18}, 
{27,  27,  39,  22,  17}, 
{35,  27,  40,  5,  19}, 
{33,  9,  43,  8,  17}, 
{3,  24,  42,  5,  18}, 
{36,  28,  27,  44,  17}, 
{49,  24,  26,  44,  20}, 
{35,  26,  26,  46,  20}, 
{45,  25,  25,  46,  19}, 
{43,  27,  28,  42,  18}, 
{35,  32,  27,  42,  18}, 
{35,  33,  28,  40,  18}, 
{41,  34,  25,  39,  19}, 
{30,  35,  28,  43,  17}, 
{30,  37,  27,  40,  21}, 
{30,  40,  25,  40,  19}, 
{25,  35,  29,  40,  19}, 
{38,  37,  25,  41,  18}, 
{36,  35,  27,  39,  19}, 
{40,  32,  25,  43,  19}, 
{46,  33,  25,  41,  18}, 
{28,  33,  29,  43,  18}, 
{47,  31,  25,  43,  18}, 
{44,  34,  28,  37,  17}, 
{40,  34,  29,  34,  19}, 
{40,  35,  28,  36,  18}, 
{43,  36,  26,  33,  18}, 
{40,  38,  24,  36,  21}, 
{41,  37,  27,  32,  20}, 
{43,  36,  23,  40,  20}, 
{40,  37,  25,  40,  19}, 
{42,  37,  26,  34,  18}, 
{44,  39,  23,  31,  18}, 
{44,  38,  21,  38,  18}, 
{43,  36,  28,  31,  18}, 
{39,  34,  28,  38,  18}, 
{43,  40,  25,  18,  18}, 
{45,  40,  24,  14,  18}, 
{35,  39,  13,  49,  17}, 
{42,  34,  13,  49,  19}, 
{43,  39,  9,  49,  18}, 
{42,  35,  18,  49,  17}, 
{40,  37,  15,  48,  19}, 
{40,  37,  16,  47,  18}, 
{40,  32,  29,  38,  17}, 
{33,  27,  29,  42,  19}, 
{45,  23,  29,  41,  18}, 
{40,  27,  29,  41,  18}, 
{0,  26,  38,  32,  17}, 
{9,  20,  40,  29,  17}, 
{5,  30,  34,  42,  17}, 
{47,  42,  27,  6,  17}, 
{45,  41,  25,  14,  18}, 
{45,  37,  31,  4,  18}, 
{43,  36,  34,  5,  19}, 
{44,  40,  33,  2,  19}, 
{45,  33,  32,  17,  18}, 
{43,  36,  20,  46,  17}, 
{32,  28,  37,  18,  17}, 
{26,  30,  36,  26,  19}, 
{12,  29,  37,  21,  18}, 
{29,  31,  36,  17,  18}, 
{28,  33,  36,  14,  17}, 
{10,  35,  36,  7,  18}, 
{9,  34,  35,  28,  17}, 
{24,  32,  35,  28,  20}, 
{33,  33,  35,  25,  17}, 
{37,  31,  35,  13,  21}, 
{23,  34,  35,  24,  19}, 
{34,  35,  35,  8,  21}, 
{33,  31,  36,  19,  19}, 
{35,  34,  36,  9,  20}, 
{30,  30,  35,  31,  18}, 
{37,  34,  35,  12,  18}, 
{33,  35,  35,  11,  19}, 
{29,  35,  35,  15,  18}, 
{19,  34,  35,  28,  18}, 
{26,  34,  34,  27,  18}, 
{35,  32,  33,  28,  18}, 
{33,  32,  35,  26,  18}, 
{19,  35,  36,  14,  18}, 
{16,  32,  35,  35,  17}, 
{26,  31,  35,  33,  21}, 
{14,  32,  34,  37,  20}, 
{12,  32,  36,  33,  20}, 
{34,  31,  30,  36,  18}, 
{23,  31,  33,  36,  18}, 
{23,  32,  34,  33,  18}, 
{10,  36,  36,  20,  17}, 
{4,  34,  36,  28,  18}, 
{23,  29,  34,  40,  17}, 
{33,  22,  32,  42,  17}, 
{33,  20,  34,  40,  20}, 
{30,  25,  32,  41,  19}, 
{33,  29,  31,  38,  18}, 
{30,  26,  32,  41,  18}, 
{30,  28,  35,  33,  19}, 
{24,  31,  33,  37,  18}, 
{31,  32,  30,  38,  19}, 
{28,  23,  35,  40,  18}, 
{31,  31,  31,  37,  18}, 
{30,  31,  33,  33,  18}, 
{44,  42,  29,  11,  17}, 
{43,  40,  28,  17,  18}, 
{44,  37,  27,  25,  19}, 
{49,  37,  25,  17,  18}, 
{45,  38,  27,  24,  17}, 
{49,  37,  23,  33,  18}, 
{45,  38,  21,  39,  20}, 
{47,  37,  20,  42,  20}, 
{49,  38,  22,  31,  19}, 
{46,  37,  28,  21,  18}, 
{49,  36,  34,  5,  19}, 
{49,  31,  29,  34,  18}, 
{49,  21,  34,  31,  19}, 
{45,  41,  25,  17,  18}, 
{45,  41,  28,  12,  18}, 
{49,  41,  28,  5,  19}, 
{49,  23,  36,  17,  18}, 
{42,  39,  27,  26,  18}, 
{46,  42,  23,  32,  17}, 
{46,  38,  26,  23,  19}, 
{41,  42,  23,  34,  19}, 
{45,  39,  27,  21,  18}, 
{45,  38,  23,  39,  17}, 
{44,  41,  23,  34,  18}, 
{42,  42,  22,  37,  17}, 
{42,  42,  19,  41,  20}, 
{43,  42,  23,  36,  18}, 
{44,  44,  12,  41,  18}, 
{42,  43,  19,  41,  18}, 
{36,  44,  20,  38,  18}, 
{46,  44,  18,  31,  18}, 
{21,  29,  35,  38,  17}, 
{25,  26,  35,  40,  19}, 
{25,  26,  35,  41,  18}, 
{13,  27,  34,  45,  19}, 
{45,  39,  32,  5,  17}, 
{42,  37,  32,  14,  18}, 
{40,  35,  32,  20,  18}, 
{49,  33,  34,  17,  17}, 
{42,  35,  34,  13,  18}, 
{44,  37,  33,  7,  18}, 
{49,  27,  35,  16,  18}, 
{41,  33,  35,  11,  17}, 
{49,  34,  36,  3,  21}, 
{39,  34,  35,  13,  19}, 
{42,  37,  37,  0,  18}, 
{41,  37,  36,  2,  19}, 
{37,  35,  35,  13,  18}, 
{26,  43,  36,  2,  17}, 
{21,  49,  38,  0,  20}, 
{42,  40,  36,  0,  19}, 
{42,  39,  36,  1,  19}, 
{45,  39,  36,  1,  17}, 
{49,  37,  34,  5,  18}, 
{49,  40,  33,  2,  18}, 
{45,  41,  34,  1,  18}, 
{43,  42,  34,  2,  18}, 
{40,  39,  34,  7,  18}, 
{46,  41,  34,  2,  18}, 
{48,  43,  34,  0,  17}, 
{47,  42,  31,  4,  17}, 
{49,  41,  31,  5,  18}, 
{46,  45,  30,  3,  17}, 
{39,  45,  29,  14,  19}, 
{36,  49,  28,  11,  19}, 
{42,  46,  29,  5,  18}, 
{28,  42,  32,  18,  17}, 
{46,  34,  29,  32,  17}, 
{29,  24,  37,  29,  17}, 
{25,  22,  38,  35,  19}, 
{19,  27,  38,  26,  18}, 
{33,  21,  40,  18,  17}, 
{9,  47,  34,  11,  17}, 
{36,  38,  38,  2,  17}, 
{40,  30,  24,  47,  17}, 
{38,  29,  24,  49,  18}, 
{49,  40,  36,  0,  17}, 
{29,  44,  32,  13,  17}, 
{33,  45,  31,  12,  20}, 
{25,  44,  32,  19,  18}, 
{35,  44,  31,  13,  18}, 
{39,  37,  26,  38,  17}, 
{36,  37,  27,  39,  18}, 
{9,  40,  23,  46,  17}, 
{14,  16,  30,  49,  17}, 
{40,  34,  29,  36,  17}, 
{46,  36,  28,  27,  17}, 
{41,  29,  24,  48,  17}, 
{44,  35,  29,  30,  17}, 
{45,  37,  29,  21,  17}, 
{46,  38,  33,  6,  18}, 
{43,  36,  30,  22,  17}, 
{41,  34,  30,  29,  17}, 
{39,  32,  34,  26,  19}, 
{38,  33,  32,  27,  18}, 
{44,  33,  32,  26,  17}, 
{40,  32,  32,  29,  19}, 
{42,  31,  34,  26,  18}, 
{42,  34,  31,  27,  17}, 
{35,  35,  34,  23,  19}, 
{36,  36,  31,  25,  18}, 
{31,  35,  32,  27,  19}, 
{35,  37,  31,  27,  18}, 
{37,  38,  31,  30,  17}, 
{35,  31,  31,  37,  21}, 
{37,  32,  32,  31,  20}, 
{37,  38,  28,  33,  18}, 
{39,  24,  33,  35,  18}, 
{37,  31,  31,  35,  18}, 
{38,  38,  34,  18,  17}, 
{40,  36,  33,  20,  21}, 
{42,  35,  34,  18,  19}, 
{39,  36,  34,  21,  18}, 
{41,  37,  32,  20,  18}, 
{34,  37,  33,  22,  19}, 
{40,  37,  34,  19,  18}, 
{31,  40,  32,  20,  18}, 
{31,  38,  32,  24,  18}, 
{20,  37,  34,  28,  17}, 
{28,  37,  33,  27,  20}, 
{31,  35,  34,  26,  19}, 
{6,  39,  33,  27,  19}, 
{19,  45,  34,  25,  17}, 
{15,  39,  34,  28,  20}, 
{15,  39,  34,  29,  18}, 
{8,  33,  34,  34,  18}, 
{24,  45,  32,  21,  18}, 
{14,  35,  35,  28,  17}, 
{10,  36,  35,  25,  18}, 
{29,  32,  35,  31,  17}, 
{36,  35,  30,  32,  17}, 
{40,  38,  34,  18,  17}, 
{42,  39,  30,  18,  19}, 
{38,  38,  30,  28,  17}, 
{42,  38,  28,  27,  18}, 
{28,  36,  28,  41,  17}, 
{34,  36,  28,  39,  18}, 
{34,  38,  28,  36,  17}, 
{30,  38,  27,  40,  18}, 
{25,  38,  28,  41,  17}, 
{33,  27,  28,  44,  17}, 
{33,  30,  28,  43,  17}, 
{32,  29,  30,  41,  19}, 
{32,  23,  34,  40,  17}, 
{31,  32,  31,  37,  17}, 
{30,  44,  9,  46,  17}, 
{33,  43,  14,  44,  18}, 
{43,  42,  19,  41,  17}, 
{45,  40,  18,  41,  17}, 
{44,  40,  17,  44,  17}, 
{42,  40,  15,  46,  18}, 
{29,  27,  38,  26,  17}, 
{23,  36,  35,  13,  17}, 
{40,  39,  30,  21,  17}, 
{42,  40,  29,  21,  17}, 
{42,  39,  28,  27,  18}, 
{28,  39,  28,  37,  18}, 
{38,  42,  27,  27,  17}, 
{41,  43,  27,  21,  19}, 
{47,  42,  25,  16,  17}, 
{46,  40,  27,  15,  17}, 
{44,  41,  29,  15,  17}, 
{39,  42,  31,  8,  17}, 
{46,  41,  30,  7,  17}, 
{44,  33,  31,  29,  17}, 
{43,  34,  30,  30,  17}, 
{39,  30,  32,  34,  17}, 
{33,  28,  33,  35,  19}, 
{38,  33,  32,  31,  17}, 
{29,  37,  32,  30,  17}, 
{35,  27,  32,  37,  17}, 
{49,  20,  35,  28,  17}, 
{31,  26,  30,  43,  17}, 
{31,  26,  32,  42,  18}, 
{21,  27,  29,  46,  17}, 
{3,  12,  49,  0,  17}, 
{49,  44,  4,  41,  17}, 
{41,  41,  29,  20,  17}, 
{33,  24,  26,  47,  17}, 
{33,  23,  26,  49,  17}, 
{25,  37,  18,  49,  17}, 
{33,  40,  38,  1,  17}, 
{26,  41,  39,  1,  18}, 
{2,  13,  41,  26,  17}, 
{47,  39,  18,  41,  17}, 
{35,  33,  28,  41,  17}, 
{45,  18,  29,  43,  17}, 
{46,  40,  26,  21,  17}, 
{49,  45,  25,  3,  17}, 
{49,  42,  24,  11,  17}, 
{49,  41,  18,  25,  18}, 
{49,  46,  5,  37,  17}, 
{37,  34,  23,  46,  17}, 
{40,  39,  24,  35,  17}, 
{39,  40,  25,  33,  18}, 
{42,  39,  25,  31,  17}, 
{31,  34,  29,  39,  17}, 
{39,  34,  29,  38,  17}, 
{33,  46,  13,  40,  17}, 
{44,  49,  12,  37,  18}, 
{37,  48,  17,  35,  18}, 
{49,  32,  40,  1,  17}, 
{21,  48,  29,  24,  17}, 
{27,  48,  25,  27,  17}, 
{40,  46,  20,  27,  17}, 
{40,  43,  23,  33,  18}, 
{44,  39,  17,  45,  17}, 
{41,  39,  18,  45,  17}, 
{38,  43,  19,  42,  18}, 
{33,  43,  17,  44,  18}, 
{28,  43,  16,  45,  18}, 
{30,  43,  28,  27,  17}, 
{38,  34,  35,  14,  17}, 
{34,  32,  36,  16,  18}, 
{27,  39,  34,  20,  17}, 
{20,  44,  33,  25,  17}, 
{24,  39,  33,  26,  18}, 
{22,  40,  31,  31,  18}, 
{30,  41,  30,  26,  20}, 
{34,  40,  31,  23,  18}, 
{29,  40,  32,  26,  19}, 
{37,  39,  31,  26,  19}, 
{25,  41,  34,  22,  17}, 
{24,  44,  33,  21,  17}, 
{26,  42,  34,  19,  17}, 
{41,  33,  36,  7,  17}, 
{43,  42,  8,  46,  17}, 
{33,  43,  15,  46,  18}, 
{43,  43,  4,  48,  17}, 
{37,  46,  6,  48,  17}, 
{39,  26,  26,  46,  17}, 
{35,  43,  24,  33,  17}, 
{34,  44,  24,  33,  17}, 
{29,  34,  19,  49,  17}, 
{39,  34,  21,  47,  17}, 
{14,  40,  38,  3,  17}, 
{19,  44,  36,  4,  17}, 
{23,  40,  35,  6,  17}, 
{26,  22,  38,  40,  16}, 
{28,  22,  38,  36,  17}, 
{45,  38,  23,  46,  16}, 
{46,  37,  23,  46,  19}, 
{36,  39,  23,  43,  19}, 
{16,  40,  24,  44,  18}, 
{25,  43,  20,  44,  19}, 
{39,  38,  21,  47,  17}, 
{27,  38,  22,  47,  18}, 
{27,  40,  23,  45,  17}, 
{38,  39,  19,  46,  18}, 
{40,  39,  18,  47,  17}, 
{38,  43,  34,  18,  16}, 
{42,  44,  34,  2,  20}, 
{30,  44,  34,  15,  18}, 
{38,  40,  31,  23,  18}, 
{39,  43,  32,  12,  18}, 
{42,  41,  31,  12,  19}, 
{40,  43,  34,  7,  19}, 
{28,  44,  34,  19,  17}, 
{28,  45,  31,  23,  17}, 
{32,  43,  31,  23,  18}, 
{31,  49,  34,  1,  17}, 
{35,  48,  30,  8,  18}, 
{42,  46,  32,  3,  19}, 
{39,  46,  31,  8,  19}, 
{36,  48,  32,  4,  18}, 
{5,  49,  34,  10,  19}, 
{22,  44,  30,  28,  17}, 
{34,  44,  26,  28,  17}, 
{49,  40,  33,  4,  17}, 
{39,  44,  34,  7,  17}, 
{41,  43,  29,  18,  17}, 
{21,  45,  34,  24,  17}, 
{24,  46,  34,  13,  19}, 
{8,  40,  36,  21,  16}, 
{8,  40,  35,  22,  17}, 
{48,  47,  36,  0,  16}, 
{32,  49,  36,  1,  19}, 
{46,  47,  32,  1,  18}, 
{47,  44,  34,  2,  18}, 
{47,  43,  32,  4,  18}, 
{45,  45,  32,  4,  17}, 
{3,  41,  32,  38,  16}, 
{40,  35,  24,  46,  16}, 
{47,  31,  24,  46,  20}, 
{36,  39,  36,  10,  16}, 
{30,  38,  35,  13,  20}, 
{24,  48,  36,  4,  18}, 
{38,  36,  36,  9,  18}, 
{38,  38,  35,  10,  18}, 
{33,  42,  35,  4,  18}, 
{18,  40,  36,  13,  18}, 
{31,  48,  35,  4,  17}, 
{28,  45,  34,  19,  18}, 
{31,  47,  34,  8,  19}, 
{41,  45,  32,  7,  17}, 
{49,  41,  32,  7,  17}, 
{30,  46,  34,  13,  17}, 
{33,  44,  36,  4,  17}, 
{42,  38,  32,  18,  17}, 
{42,  37,  33,  16,  17}, 
{33,  41,  38,  2,  17}, 
{21,  45,  38,  3,  17}, 
{12,  45,  37,  4,  17}, 
{49,  26,  36,  18,  17}, 
{35,  40,  35,  6,  17}, 
{45,  42,  36,  1,  17}, 
{36,  47,  35,  2,  17}, 
{12,  38,  37,  6,  17}, 
{38,  36,  37,  7,  17}, 
{29,  29,  37,  20,  19}, 
{40,  30,  38,  6,  18}, 
{34,  41,  38,  3,  17}, 
{40,  47,  37,  0,  19}, 
{36,  42,  38,  2,  17}, 
{43,  47,  37,  0,  17}, 
{42,  34,  37,  4,  17}, 
{20,  46,  29,  35,  16}, 
{6,  44,  32,  32,  20}, 
{23,  45,  28,  34,  19}, 
{18,  47,  29,  31,  18}, 
{11,  49,  27,  31,  19}, 
{24,  48,  26,  31,  18}, 
{18,  48,  30,  27,  17}, 
{19,  44,  31,  31,  17}, 
{24,  44,  28,  35,  17}, 
{36,  42,  28,  37,  16}, 
{35,  39,  31,  30,  21}, 
{36,  39,  27,  38,  20}, 
{34,  43,  28,  33,  20}, 
{35,  41,  31,  25,  19}, 
{25,  41,  31,  31,  18}, 
{34,  40,  29,  31,  19}, 
{38,  43,  28,  27,  18}, 
{38,  42,  25,  35,  18}, 
{40,  41,  25,  34,  18}, 
{28,  44,  30,  27,  18}, 
{29,  43,  30,  29,  18}, 
{21,  42,  29,  37,  18}, 
{26,  44,  31,  29,  18}, 
{37,  41,  28,  33,  18}, 
{38,  39,  28,  34,  19}, 
{34,  39,  25,  40,  18}, 
{36,  40,  25,  41,  17}, 
{26,  45,  32,  27,  17}, 
{26,  43,  32,  29,  18}, 
{40,  39,  28,  32,  17}, 
{39,  41,  28,  30,  18}, 
{23,  44,  28,  36,  17}, 
{27,  46,  30,  27,  17}, 
{23,  44,  25,  37,  17}, 
{23,  43,  21,  45,  18}, 
{39,  39,  29,  29,  17}, 
{30,  41,  30,  31,  17}, 
{23,  46,  23,  37,  17}, 
{31,  39,  32,  28,  17}, 
{38,  40,  32,  21,  18}, 
{39,  38,  33,  21,  18}, 
{35,  38,  33,  23,  17}, 
{40,  39,  26,  35,  17}, 
{25,  42,  34,  24,  17}, 
{1,  27,  35,  43,  16}, 
{16,  19,  35,  43,  17}, 
{29,  36,  31,  36,  16}, 
{23,  38,  32,  32,  19}, 
{35,  33,  30,  37,  18}, 
{32,  33,  31,  37,  18}, 
{20,  38,  32,  34,  17}, 
{9,  41,  32,  37,  18}, 
{14,  42,  31,  34,  18}, 
{30,  38,  31,  32,  17}, 
{2,  42,  31,  38,  17}, 
{26,  36,  31,  37,  17}, 
{28,  28,  29,  47,  16}, 
{37,  27,  26,  47,  19}, 
{28,  21,  28,  49,  18}, 
{28,  29,  29,  45,  18}, 
{18,  29,  31,  45,  18}, 
{12,  27,  36,  42,  16}, 
{42,  36,  23,  47,  16}, 
{41,  32,  23,  48,  20}, 
{42,  38,  31,  28,  16}, 
{40,  39,  31,  27,  18}, 
{40,  40,  31,  22,  18}, 
{39,  43,  33,  15,  18}, 
{46,  36,  29,  28,  17}, 
{44,  37,  25,  33,  18}, 
{44,  36,  29,  31,  17}, 
{40,  35,  29,  35,  18}, 
{39,  39,  31,  29,  17}, 
{40,  43,  31,  18,  17}, 
{47,  32,  27,  41,  16}, 
{43,  31,  27,  42,  19}, 
{49,  40,  26,  21,  18}, 
{44,  31,  29,  38,  17}, 
{38,  36,  27,  39,  17}, 
{40,  35,  24,  47,  16}, 
{40,  37,  19,  49,  16}, 
{44,  33,  19,  49,  17}, 
{43,  36,  15,  49,  17}, 
{47,  39,  15,  47,  16}, 
{44,  38,  18,  47,  18}, 
{45,  40,  4,  49,  18}, 
{46,  36,  20,  47,  18}, 
{31,  45,  16,  46,  16}, 
{20,  45,  22,  40,  19}, 
{7,  45,  23,  42,  18}, 
{32,  44,  20,  42,  17}, 
{1,  46,  18,  46,  17}, 
{29,  45,  9,  47,  17}, 
{36,  40,  11,  49,  17}, 
{1,  40,  19,  49,  18}, 
{39,  40,  16,  47,  19}, 
{2,  44,  19,  47,  19}, 
{2,  42,  23,  47,  18}, 
{7,  44,  25,  42,  17}, 
{1,  44,  18,  48,  17}, 
{0,  36,  26,  49,  16}, 
{32,  33,  22,  49,  18}, 
{42,  34,  21,  48,  18}, 
{42,  41,  22,  41,  16}, 
{41,  43,  21,  41,  17}, 
{33,  43,  28,  35,  17}, 
{34,  37,  28,  41,  16}, 
{33,  38,  27,  41,  17}, 
{40,  33,  24,  48,  16}, 
{27,  33,  24,  49,  17}, 
{39,  36,  31,  32,  16}, 
{37,  37,  29,  33,  17}, 
{33,  38,  30,  33,  18}, 
{35,  35,  30,  37,  17}, 
{35,  37,  30,  34,  18}, 
{40,  35,  30,  33,  17}, 
{18,  47,  31,  30,  16}, 
{9,  46,  32,  29,  19}, 
{28,  46,  31,  27,  18}, 
{15,  46,  31,  32,  17}, 
{15,  20,  39,  30,  16}, 
{49,  44,  32,  4,  16}, 
{48,  46,  32,  2,  18}, 
{29,  25,  38,  32,  16}, 
{15,  27,  37,  36,  16}, 
{26,  23,  37,  40,  17}, 
{43,  38,  32,  20,  16}, 
{43,  37,  31,  26,  18}, 
{44,  36,  31,  18,  17}, 
{49,  38,  32,  9,  18}, 
{44,  38,  32,  15,  17}, 
{28,  32,  40,  5,  16}, 
{8,  39,  39,  5,  17}, 
{28,  42,  38,  4,  17}, 
{28,  22,  32,  46,  16}, 
{27,  24,  34,  44,  19}, 
{29,  21,  34,  45,  17}, 
{23,  37,  33,  31,  16}, 
{32,  33,  33,  31,  17}, 
{34,  27,  27,  47,  16}, 
{34,  25,  27,  48,  17}, 
{32,  22,  30,  45,  17}, 
{27,  29,  37,  26,  16}, 
{49,  33,  32,  29,  16}, 
{49,  34,  30,  31,  18}, 
{44,  39,  30,  20,  19}, 
{49,  23,  33,  32,  17}, 
{49,  31,  30,  34,  17}, 
{49,  24,  31,  36,  17}, 
{37,  25,  32,  40,  16}, 
{36,  32,  30,  38,  17}, 
{40,  22,  34,  39,  17}, 
{36,  30,  31,  38,  17}, 
{34,  49,  19,  36,  16}, 
{27,  45,  20,  43,  18}, 
{23,  46,  22,  40,  17}, 
{32,  46,  18,  43,  18}, 
{24,  47,  27,  32,  17}, 
{29,  47,  19,  39,  17}, 
{0,  48,  15,  47,  17}, 
{5,  41,  30,  39,  16}, 
{40,  35,  25,  43,  16}, 
{35,  35,  27,  42,  18}, 
{40,  33,  26,  42,  17}, 
{44,  34,  28,  38,  17}, 
{31,  45,  31,  23,  16}, 
{34,  46,  29,  19,  17}, 
{29,  46,  33,  16,  17}, 
{29,  46,  34,  18,  16}, 
{1,  46,  34,  25,  17}, 
{34,  40,  31,  31,  16}, 
{12,  19,  32,  49,  16}, 
{49,  40,  10,  45,  16}, 
{48,  44,  9,  37,  18}, 
{47,  41,  22,  28,  17}, 
{47,  49,  9,  35,  17}, 
{41,  43,  36,  2,  16}, 
{38,  43,  35,  4,  18}, 
{41,  42,  38,  2,  16}, 
{43,  41,  38,  1,  17}, 
{32,  44,  25,  37,  16}, 
{19,  35,  28,  45,  16}, 
{9,  40,  35,  23,  16}, 
{13,  37,  35,  25,  18}, 
{30,  38,  35,  14,  17}, 
{30,  44,  32,  25,  16}, 
{46,  48,  36,  0,  16}, 
{34,  40,  29,  34,  16}, 
{23,  38,  32,  34,  17}, 
{21,  34,  32,  37,  17}, 
{30,  41,  30,  34,  16}, 
{23,  45,  31,  32,  19}, 
{30,  42,  30,  34,  17}, 
{41,  41,  31,  21,  16}, 
{44,  47,  23,  13,  16}, 
{45,  47,  27,  5,  17}, 
{37,  48,  28,  15,  17}, 
{43,  48,  31,  4,  17}, 
{46,  39,  33,  8,  16}, 
{13,  29,  37,  33,  16}, 
{24,  23,  40,  17,  16}, 
{23,  32,  40,  6,  18}, 
{40,  33,  38,  6,  17}, 
{49,  29,  26,  43,  16}, 
{44,  43,  23,  26,  16}, 
{37,  39,  29,  34,  16}, 
{42,  33,  34,  25,  16}, 
{43,  33,  33,  26,  16}, 
{40,  33,  33,  29,  16}, 
{39,  30,  33,  32,  17}, 
{29,  41,  32,  30,  16}, 
{20,  44,  32,  32,  18}, 
{25,  36,  30,  38,  16}, 
{5,  39,  29,  42,  16}, 
{46,  46,  12,  38,  16}, 
{31,  27,  29,  45,  16}, 
{32,  23,  31,  45,  17}, 
{35,  27,  28,  45,  17}, 
{25,  43,  16,  47,  16}, 
{49,  30,  35,  15,  16}, 
{39,  45,  31,  13,  16}, 
{28,  35,  32,  33,  16}, 
{30,  33,  33,  33,  17}, 
{39,  33,  32,  32,  17}, 
{39,  37,  23,  47,  16}, 
{33,  42,  32,  23,  16}, 
{34,  44,  31,  23,  17}, 
{39,  44,  17,  42,  16}, 
{42,  45,  18,  36,  16}, 
{44,  44,  20,  32,  17}, 
{45,  45,  21,  25,  17}, 
{41,  39,  31,  28,  16}, 
{45,  37,  25,  32,  16}, 
{27,  43,  22,  43,  16}, 
{29,  41,  12,  49,  16}, 
{0,  41,  23,  49,  16}, 
{0,  40,  24,  48,  17}, 
{26,  25,  32,  45,  16}, 
{49,  3,  34,  41,  16}, 
{19,  40,  25,  43,  16}, 
{43,  41,  36,  2,  16}, 
{9,  46,  32,  32,  16}, 
{25,  45,  32,  30,  16}, 
{28,  46,  23,  38,  17}, 
{34,  45,  25,  30,  17}, 
{29,  49,  21,  36,  17}, 
{34,  46,  25,  30,  16}, 
{30,  46,  29,  28,  17}, 
{30,  48,  25,  30,  17}, 
{37,  48,  27,  25,  16}, 
{41,  46,  23,  27,  19}, 
{40,  46,  26,  19,  17}, 
{36,  47,  28,  24,  17}, 
{37,  44,  31,  20,  17}, 
{30,  47,  28,  33,  16}, 
{28,  48,  27,  33,  18}, 
{34,  44,  28,  34,  17}, 
{31,  46,  26,  35,  17}, 
{30,  48,  26,  34,  18}, 
{34,  47,  24,  34,  17}, 
{35,  47,  28,  28,  18}, 
{31,  48,  25,  35,  17}, 
{7,  48,  23,  40,  17}, 
{41,  45,  27,  19,  16}, 
{24,  48,  29,  29,  16}, 
{44,  44,  25,  13,  16}, 
{49,  44,  25,  7,  17}, 
{29,  25,  40,  11,  16}, 
{26,  33,  40,  6,  16}, 
{4,  43,  40,  2,  18}, 
{40,  33,  41,  1,  17}, 
{41,  44,  21,  38,  16}, 
{39,  48,  23,  27,  16}, 
{29,  38,  32,  32,  16}, 
{29,  29,  35,  34,  16}, 
{16,  29,  34,  42,  16}, 
{28,  39,  35,  14,  16}, 
{24,  36,  37,  8,  16}, 
{19,  30,  37,  20,  17}, 
{25,  15,  41,  12,  16}, 
{49,  32,  33,  28,  16}, 
{49,  24,  33,  34,  17}, 
{49,  24,  34,  33,  16}, 
{41,  48,  25,  18,  16}, 
{21,  32,  29,  45,  16}, 
{40,  33,  35,  15,  16}, 
{49,  2,  35,  33,  16}, 
{49,  27,  25,  46,  16}, 
{46,  41,  18,  40,  16}, 
{43,  37,  16,  48,  16}, 
{41,  36,  24,  40,  16}, 
{33,  39,  23,  45,  16}, 
{36,  35,  29,  38,  16}, 
{27,  37,  29,  39,  17}, 
{23,  37,  31,  37,  16}, 
{42,  40,  24,  31,  16}, 
{44,  41,  27,  24,  16}, 
{41,  41,  24,  34,  16}, 
{40,  41,  28,  30,  16}, 
{42,  40,  28,  29,  16}, 
{44,  41,  25,  31,  16}, 
{46,  38,  24,  32,  19}, 
{43,  39,  28,  28,  17}, 
{45,  39,  28,  25,  17}, 
{45,  38,  29,  25,  16}, 
{44,  38,  31,  21,  16}, 
{42,  38,  31,  29,  16}, 
{44,  34,  31,  30,  16}, 
{41,  30,  31,  38,  16}, 
{41,  25,  31,  41,  17}, 
{34,  30,  30,  41,  16}, 
{27,  36,  30,  39,  19}, 
{27,  30,  31,  41,  17}, 
{40,  33,  33,  31,  16}, 
{8,  30,  31,  46,  16}, 
{6,  30,  31,  48,  16}, 
{31,  35,  30,  39,  16}, 
{49,  41,  24,  19,  16}, 
{20,  34,  30,  40,  16}, 
{33,  34,  31,  37,  16}, 
{26,  45,  31,  32,  16}, 
{24,  48,  29,  32,  16}, 
{42,  39,  34,  8,  16}, 
{33,  34,  35,  17,  16}, 
{40,  41,  24,  36,  16}, 
{33,  38,  28,  41,  16}, 
{37,  29,  27,  44,  16}, 
{39,  49,  21,  27,  16}, 
{42,  49,  19,  27,  17}, 
{49,  42,  21,  23,  16}, 
{41,  27,  34,  33,  16}, 
{39,  30,  34,  33,  16}, 
{40,  30,  33,  34,  16}, 
{33,  30,  35,  28,  16}, 
{31,  30,  35,  32,  17}, 
{40,  44,  25,  25,  16}, 
{39,  47,  25,  27,  17}, 
{42,  43,  25,  25,  16}, 
{42,  42,  25,  30,  16}, 
{40,  48,  25,  24,  16}, 
{39,  41,  32,  21,  16}, 
{31,  32,  35,  30,  16}, 
{36,  33,  34,  30,  17}, 
{29,  34,  34,  29,  16}, 
{44,  46,  27,  8,  16}, 
{43,  45,  32,  7,  17}, 
{49,  44,  32,  5,  16}, 
{47,  43,  31,  7,  17}, 
{42,  42,  33,  8,  16}, 
{45,  42,  29,  13,  16}, 
{44,  43,  29,  14,  16}, 
{42,  43,  31,  13,  16}, 
{37,  47,  35,  3,  16}, 
{40,  46,  33,  7,  17}, 
{35,  46,  34,  9,  16}, 
{37,  47,  33,  9,  16}, 
{24,  47,  31,  30,  17}, 
{40,  6,  36,  35,  16}, 
{35,  27,  38,  14,  16}, 
{49,  16,  43,  5,  16}, 
{4,  32,  34,  38,  16}, 
{39,  45,  35,  34,  15}, 
{20,  42,  36,  16,  22}, 
{11,  36,  35,  35,  21}, 
{41,  45,  25,  34,  21}, 
{40,  45,  28,  31,  20}, 
{41,  45,  28,  29,  20}, 
{30,  43,  36,  10,  19}, 
{45,  24,  35,  31,  19}, 
{31,  46,  36,  6,  19}, 
{12,  44,  36,  17,  20}, 
{2,  44,  33,  35,  19}, 
{41,  41,  31,  28,  18}, 
{49,  30,  35,  23,  18}, 
{42,  39,  35,  4,  18}, 
{40,  39,  30,  33,  18}, 
{40,  46,  25,  33,  18}, 
{41,  47,  23,  34,  18}, 
{8,  43,  36,  21,  18}, 
{48,  17,  35,  35,  18}, 
{41,  38,  35,  14,  17}, 
{42,  39,  35,  8,  19}, 
{42,  36,  35,  14,  18}, 
{42,  32,  35,  22,  18}, 
{41,  45,  29,  28,  17}, 
{32,  22,  35,  40,  17}, 
{48,  13,  35,  38,  18}, 
{40,  29,  35,  34,  17}, 
{4,  34,  36,  35,  17}, 
{37,  33,  31,  37,  17}, 
{45,  37,  36,  3,  17}, 
{45,  41,  35,  3,  17}, 
{34,  43,  36,  10,  17}, 
{43,  49,  18,  33,  17}, 
{45,  46,  21,  32,  18}, 
{8,  45,  38,  5,  17}, 
{40,  43,  30,  31,  17}, 
{39,  37,  32,  38,  16}, 
{23,  32,  32,  40,  19}, 
{16,  37,  35,  35,  18}, 
{31,  38,  29,  39,  18}, 
{29,  42,  29,  37,  19}, 
{30,  40,  31,  36,  19}, 
{24,  38,  32,  38,  18}, 
{44,  32,  30,  37,  18}, 
{38,  42,  27,  36,  18}, 
{44,  33,  31,  34,  17}, 
{41,  39,  30,  34,  17}, 
{40,  39,  28,  36,  18}, 
{43,  38,  29,  31,  18}, 
{25,  29,  34,  40,  17}, 
{41,  43,  27,  33,  17}, 
{41,  43,  30,  31,  17}, 
{31,  38,  32,  37,  17}, 
{43,  41,  27,  30,  17}, 
{30,  41,  31,  36,  17}, 
{27,  43,  30,  36,  18}, 
{19,  42,  32,  36,  17}, 
{45,  38,  28,  37,  16}, 
{43,  39,  28,  35,  19}, 
{41,  37,  25,  41,  18}, 
{37,  47,  35,  14,  16}, 
{21,  47,  36,  11,  19}, 
{26,  48,  30,  30,  18}, 
{22,  47,  32,  26,  18}, 
{26,  47,  34,  19,  18}, 
{39,  46,  31,  18,  18}, 
{41,  46,  30,  19,  18}, 
{28,  46,  35,  18,  17}, 
{37,  48,  31,  13,  17}, 
{43,  39,  24,  41,  16}, 
{43,  39,  25,  40,  19}, 
{40,  40,  25,  41,  17}, 
{39,  42,  28,  37,  20}, 
{44,  35,  24,  45,  16}, 
{47,  36,  24,  41,  18}, 
{47,  35,  25,  42,  17}, 
{46,  37,  24,  40,  17}, 
{44,  39,  25,  38,  17}, 
{39,  41,  31,  36,  16}, 
{33,  40,  32,  36,  19}, 
{26,  41,  32,  37,  18}, 
{26,  42,  33,  35,  17}, 
{27,  37,  32,  39,  16}, 
{39,  35,  30,  39,  16}, 
{39,  33,  29,  40,  18}, 
{44,  28,  30,  40,  17}, 
{20,  33,  31,  42,  16}, 
{5,  34,  31,  42,  18}, 
{10,  33,  32,  41,  17}, 
{21,  31,  31,  43,  17}, 
{0,  32,  31,  47,  16}, 
{7,  33,  30,  46,  17}, 
{42,  45,  35,  5,  16}, 
{15,  40,  35,  35,  16}, 
{43,  37,  32,  26,  16}, 
{49,  34,  33,  26,  18}, 
{44,  35,  34,  17,  17}, 
{47,  33,  24,  47,  16}, 
{40,  38,  35,  20,  16}, 
{42,  34,  35,  22,  18}, 
{49,  34,  35,  21,  16}, 
{47,  35,  27,  39,  16}, 
{47,  33,  27,  41,  17}, 
{45,  37,  27,  38,  17}, 
{40,  37,  27,  41,  16}, 
{36,  35,  28,  42,  17}, 
{47,  44,  28,  9,  16}, 
{1,  47,  34,  27,  16}, 
{30,  47,  34,  22,  16}, 
{28,  46,  35,  21,  17}, 
{18,  47,  35,  19,  17}, 
{39,  42,  30,  36,  16}, 
{47,  34,  26,  42,  16}, 
{9,  31,  33,  42,  16}, 
{28,  43,  37,  5,  16}, 
{28,  38,  38,  6,  17}, 
{37,  41,  29,  37,  16}, 
{36,  38,  31,  38,  18}, 
{33,  38,  30,  39,  17}, 
{42,  41,  30,  24,  16}, 
{43,  41,  29,  25,  17}, 
{43,  42,  28,  29,  16}, 
{44,  43,  29,  18,  17}, 
{46,  42,  28,  18,  17}, 
{43,  43,  29,  25,  17}, 
{47,  43,  26,  18,  16}, 
{46,  44,  28,  13,  17}, 
{49,  43,  26,  12,  17}, 
{45,  42,  28,  21,  16}, 
{44,  42,  25,  32,  18}, 
{42,  40,  26,  37,  17}, 
{44,  40,  26,  36,  16}, 
{41,  43,  34,  9,  16}, 
{47,  36,  28,  38,  16}, 
{44,  42,  25,  34,  16}, 
{45,  43,  23,  33,  17}, 
{42,  43,  29,  30,  16}, 
{44,  41,  29,  26,  16}, 
{30,  46,  29,  35,  16}, 
{45,  25,  31,  41,  16}, 
{44,  42,  23,  37,  16}, 
{42,  40,  27,  37,  16}, 
{42,  40,  29,  33,  17}, 
{39,  45,  25,  35,  16}, 
{41,  42,  31,  29,  16}, 
{39,  34,  29,  40,  16}, 
{36,  48,  25,  31,  16}, 
{33,  29,  34,  35,  16}, 
{27,  40,  34,  35,  16}, 
{27,  31,  34,  37,  18}, 
{27,  29,  33,  41,  16}, 
{25,  30,  34,  39,  16}, 
{24,  32,  31,  42,  16}, 
{10,  44,  34,  35,  16}, 
{31,  19,  37,  36,  16}, 
{33,  29,  36,  26,  16}, 
{33,  23,  38,  26,  17}, 
{11,  49,  35,  8,  16}, 
{5,  48,  35,  16,  16}, 
{44,  40,  27,  35,  16}, 
{41,  37,  30,  35,  16}, 
{49,  33,  29,  37,  16}, 
{40,  35,  32,  34,  16}, 
{42,  34,  31,  35,  16}, 
{9,  34,  31,  43,  16}, 
{6,  38,  32,  41,  16}, 
{20,  38,  31,  40,  18}, 
{0,  38,  30,  43,  17}, 
{0,  38,  30,  45,  16}, 
{6,  42,  30,  40,  16}, 
{0,  39,  31,  42,  16}, 
{6,  41,  31,  40,  16}, 
{44,  47,  21,  33,  16}, 
{36,  46,  29,  29,  16}, 
{47,  22,  35,  34,  16}, 
{38,  47,  34,  14,  16}, 
{39,  48,  28,  21,  17}, 
{41,  38,  28,  46,  15}, 
{33,  39,  25,  45,  21}, 
{35,  37,  24,  47,  20}, 
{37,  32,  25,  47,  19}, 
{42,  35,  28,  42,  18}, 
{29,  32,  29,  45,  18}, 
{34,  29,  27,  47,  18}, 
{41,  32,  26,  47,  18}, 
{45,  16,  29,  47,  18}, 
{43,  38,  24,  46,  17}, 
{47,  36,  24,  44,  18}, 
{44,  34,  25,  46,  17}, 
{27,  40,  25,  44,  17}, 
{26,  37,  25,  47,  17}, 
{49,  10,  28,  49,  17}, 
{47,  31,  26,  46,  16}, 
{36,  37,  29,  40,  16}, 
{32,  40,  25,  44,  16}, 
{32,  42,  21,  45,  17}, 
{37,  40,  24,  43,  16}, 
{33,  40,  25,  45,  16}, 
{32,  20,  32,  46,  16}, 
{47,  34,  26,  44,  16}, 
{30,  45,  18,  46,  16}, 
{47,  36,  27,  40,  16}, 
{29,  38,  24,  47,  16}, 
{31,  24,  32,  45,  16}, 
{43,  38,  27,  40,  16}, 
{37,  40,  23,  44,  16}, 
{19,  39,  26,  44,  16}, 
{43,  35,  24,  47,  16}, 
{18,  39,  24,  47,  16}, 
{34,  29,  28,  47,  16}, 
{36,  38,  32,  41,  15}, 
{39,  31,  32,  40,  17}, 
{39,  35,  29,  41,  17}, 
{43,  28,  31,  41,  17}, 
{16,  35,  29,  45,  17}, 
{28,  34,  29,  44,  17}, 
{32,  31,  33,  39,  16}, 
{33,  26,  34,  40,  18}, 
{32,  31,  34,  37,  18}, 
{32,  29,  34,  40,  18}, 
{35,  27,  34,  38,  18}, 
{43,  24,  35,  35,  17}, 
{34,  30,  34,  38,  17}, 
{31,  29,  35,  39,  16}, 
{9,  29,  36,  40,  18}, 
{34,  28,  35,  36,  17}, 
{40,  22,  35,  39,  17}, 
{25,  33,  35,  35,  17}, 
{37,  31,  29,  43,  16}, 
{36,  26,  32,  42,  17}, 
{37,  22,  32,  45,  18}, 
{37,  25,  30,  45,  18}, 
{42,  23,  29,  47,  17}, 
{42,  30,  31,  41,  16}, 
{43,  33,  29,  42,  16}, 
{18,  39,  31,  41,  16}, 
{26,  33,  31,  42,  16}, 
{37,  30,  30,  43,  16}, 
{31,  33,  31,  42,  18}, 
{36,  30,  32,  42,  16}, 
{27,  29,  34,  42,  17}, 
{31,  32,  32,  42,  17}, 
{26,  27,  34,  43,  16}, 
{28,  37,  29,  42,  16}, 
{34,  31,  35,  35,  16}, 
{43,  31,  31,  39,  16}, 
{39,  35,  31,  39,  16}, 
{40,  27,  34,  36,  16}, 
{45,  16,  33,  41,  16}, 
{43,  29,  32,  37,  16}, 
{42,  27,  33,  38,  17}, 
{21,  39,  31,  40,  16}, 
{48,  45,  44,  0,  15}, 
{43,  41,  39,  1,  18}, 
{26,  45,  38,  5,  17}, 
{49,  44,  42,  0,  17}, 
{45,  40,  39,  1,  17}, 
{46,  47,  38,  0,  17}, 
{16,  19,  34,  48,  15}, 
{28,  21,  34,  46,  20}, 
{18,  19,  32,  49,  18}, 
{19,  21,  34,  47,  17}, 
{24,  17,  32,  48,  18}, 
{24,  24,  31,  47,  18}, 
{35,  23,  32,  46,  17}, 
{38,  25,  30,  46,  17}, 
{42,  25,  32,  42,  17}, 
{45,  17,  32,  44,  17}, 
{47,  6,  30,  48,  17}, 
{43,  18,  32,  46,  16}, 
{8,  45,  36,  35,  15}, 
{20,  47,  36,  16,  18}, 
{15,  37,  36,  27,  16}, 
{9,  46,  36,  22,  16}, 
{44,  40,  24,  45,  15}, 
{40,  39,  25,  45,  16}, 
{34,  42,  21,  45,  16}, 
{47,  39,  19,  41,  16}, 
{34,  45,  17,  45,  16}, 
{36,  43,  18,  44,  17}, 
{37,  44,  12,  46,  16}, 
{36,  42,  12,  48,  16}, 
{29,  29,  38,  32,  15}, 
{23,  33,  40,  7,  17}, 
{23,  38,  38,  8,  16}, 
{24,  30,  36,  33,  16}, 
{27,  45,  36,  27,  15}, 
{30,  35,  36,  24,  19}, 
{15,  45,  36,  30,  18}, 
{35,  35,  36,  16,  17}, 
{26,  48,  36,  15,  16}, 
{36,  48,  34,  14,  19}, 
{32,  49,  34,  8,  17}, 
{38,  48,  30,  18,  17}, 
{24,  33,  36,  31,  16}, 
{39,  48,  31,  16,  16}, 
{26,  42,  36,  28,  16}, 
{12,  39,  34,  39,  15}, 
{27,  36,  33,  36,  16}, 
{34,  33,  33,  36,  16}, 
{19,  31,  34,  40,  16}, 
{25,  30,  34,  42,  16}, 
{2,  34,  32,  47,  15}, 
{13,  28,  34,  45,  18}, 
{3,  35,  32,  44,  18}, 
{33,  33,  32,  42,  17}, 
{0,  36,  32,  43,  17}, 
{46,  40,  25,  40,  15}, 
{46,  42,  23,  37,  19}, 
{46,  37,  27,  39,  18}, 
{46,  39,  28,  25,  17}, 
{45,  40,  23,  43,  17}, 
{48,  44,  34,  7,  15}, 
{44,  42,  34,  15,  15}, 
{40,  41,  35,  17,  20}, 
{43,  43,  31,  22,  18}, 
{42,  43,  32,  18,  17}, 
{41,  42,  34,  18,  17}, 
{40,  40,  32,  29,  17}, 
{41,  39,  32,  29,  17}, 
{47,  44,  30,  9,  16}, 
{42,  42,  31,  29,  16}, 
{42,  40,  32,  26,  16}, 
{40,  42,  35,  17,  16}, 
{40,  38,  33,  28,  16}, 
{44,  38,  34,  17,  16}, 
{43,  42,  31,  26,  16}, 
{44,  44,  31,  13,  16}, 
{41,  44,  32,  21,  16}, 
{42,  42,  32,  26,  16}, 
{49,  42,  31,  9,  16}, 
{46,  45,  25,  31,  15}, 
{47,  44,  26,  21,  19}, 
{43,  44,  29,  26,  17}, 
{44,  45,  31,  15,  16}, 
{45,  47,  23,  33,  16}, 
{47,  41,  26,  26,  16}, 
{44,  46,  30,  16,  16}, 
{48,  45,  26,  8,  16}, 
{48,  46,  32,  4,  18}, 
{48,  47,  26,  6,  17}, 
{46,  49,  19,  21,  16}, 
{46,  48,  25,  12,  17}, 
{43,  46,  24,  33,  16}, 
{44,  48,  25,  22,  17}, 
{47,  45,  25,  22,  16}, 
{47,  38,  24,  41,  16}, 
{49,  39,  23,  40,  16}, 
{47,  40,  23,  37,  17}, 
{8,  21,  40,  31,  15}, 
{23,  22,  40,  27,  17}, 
{19,  24,  39,  29,  18}, 
{23,  27,  39,  27,  18}, 
{49,  42,  35,  5,  15}, 
{49,  42,  36,  2,  18}, 
{47,  42,  38,  1,  18}, 
{43,  37,  36,  7,  18}, 
{49,  37,  38,  3,  16}, 
{49,  41,  37,  2,  16}, 
{44,  36,  35,  14,  16}, 
{49,  34,  38,  6,  16}, 
{27,  45,  35,  35,  15}, 
{33,  45,  31,  35,  16}, 
{30,  47,  34,  29,  15}, 
{13,  46,  33,  35,  18}, 
{36,  39,  24,  47,  15}, 
{29,  40,  24,  46,  17}, 
{44,  39,  21,  46,  16}, 
{39,  34,  29,  44,  15}, 
{34,  28,  29,  47,  17}, 
{40,  30,  29,  45,  17}, 
{41,  30,  30,  43,  16}, 
{42,  40,  35,  18,  15}, 
{42,  41,  35,  17,  18}, 
{42,  38,  35,  19,  16}, 
{43,  38,  35,  16,  16}, 
{43,  40,  35,  12,  16}, 
{49,  43,  31,  12,  15}, 
{47,  44,  28,  18,  18}, 
{49,  37,  30,  21,  17}, 
{49,  36,  32,  21,  17}, 
{49,  42,  30,  13,  16}, 
{49,  38,  27,  34,  16}, 
{45,  35,  33,  23,  16}, 
{3,  32,  38,  21,  15}, 
{3,  35,  38,  12,  19}, 
{14,  30,  39,  14,  17}, 
{27,  28,  39,  19,  17}, 
{23,  37,  39,  11,  15}, 
{27,  31,  39,  13,  19}, 
{19,  34,  37,  16,  17}, 
{19,  32,  38,  20,  17}, 
{27,  38,  37,  11,  16}, 
{33,  32,  37,  12,  17}, 
{29,  32,  38,  19,  17}, 
{29,  30,  37,  25,  17}, 
{35,  32,  38,  12,  16}, 
{32,  38,  39,  3,  16}, 
{36,  30,  39,  7,  16}, 
{30,  43,  38,  10,  15}, 
{34,  41,  38,  7,  19}, 
{19,  45,  38,  9,  18}, 
{31,  45,  38,  5,  17}, 
{49,  34,  37,  9,  16}, 
{42,  10,  41,  16,  17}, 
{49,  27,  37,  18,  18}, 
{39,  33,  38,  10,  17}, 
{43,  37,  36,  10,  17}, 
{18,  39,  39,  10,  16}, 
{39,  10,  38,  33,  16}, 
{41,  6,  41,  22,  17}, 
{43,  39,  38,  7,  15}, 
{41,  40,  37,  7,  17}, 
{49,  41,  37,  3,  18}, 
{40,  43,  36,  8,  18}, 
{49,  40,  38,  3,  17}, 
{47,  42,  36,  4,  17}, 
{37,  46,  36,  10,  16}, 
{49,  41,  37,  4,  16}, 
{49,  39,  38,  5,  17}, 
{49,  36,  36,  9,  16}, 
{43,  39,  36,  10,  16}, 
{44,  37,  36,  16,  15}, 
{37,  46,  36,  12,  18}, 
{28,  45,  36,  24,  17}, 
{43,  39,  36,  13,  16}, 
{49,  37,  38,  7,  16}, 
{29,  36,  38,  16,  15}, 
{49,  33,  37,  12,  17}, 
{26,  29,  32,  45,  15}, 
{24,  27,  31,  47,  16}, 
{25,  27,  34,  46,  15}, 
{31,  30,  40,  13,  15}, 
{4,  27,  40,  27,  17}, 
{36,  28,  39,  14,  17}, 
{26,  32,  40,  12,  17}, 
{24,  24,  40,  26,  17}, 
{39,  33,  38,  13,  16}, 
{19,  32,  40,  14,  16}, 
{29,  27,  39,  22,  16}, 
{46,  11,  39,  23,  17}, 
{27,  48,  32,  30,  15}, 
{18,  48,  35,  18,  17}, 
{38,  48,  32,  18,  16}, 
{33,  46,  32,  30,  16}, 
{34,  24,  43,  5,  15}, 
{36,  28,  41,  4,  17}, 
{34,  27,  43,  4,  16}, 
{49,  33,  39,  9,  15}, 
{30,  35,  39,  10,  16}, 
{37,  38,  39,  4,  16}, 
{31,  31,  40,  14,  16}, 
{21,  49,  36,  15,  15}, 
{6,  49,  35,  19,  17}, 
{11,  49,  34,  21,  16}, 
{5,  41,  27,  45,  15}, 
{14,  39,  28,  46,  16}, 
{35,  40,  27,  43,  15}, 
{42,  40,  26,  40,  19}, 
{23,  40,  30,  40,  18}, 
{23,  40,  28,  43,  17}, 
{41,  40,  26,  42,  17}, 
{36,  40,  29,  38,  17}, 
{27,  42,  28,  39,  17}, 
{39,  42,  25,  39,  17}, 
{19,  44,  27,  38,  16}, 
{28,  42,  24,  41,  16}, 
{28,  43,  23,  44,  19}, 
{18,  42,  28,  41,  17}, 
{29,  41,  24,  43,  17}, 
{26,  46,  23,  41,  16}, 
{9,  43,  27,  42,  16}, 
{16,  41,  27,  44,  16}, 
{44,  40,  26,  39,  16}, 
{25,  39,  32,  39,  16}, 
{33,  42,  27,  42,  15}, 
{39,  41,  25,  42,  16}, 
{12,  43,  26,  43,  16}, 
{23,  42,  26,  44,  17}, 
{41,  36,  25,  47,  15}, 
{37,  40,  32,  37,  15}, 
{30,  40,  32,  38,  17}, 
{32,  40,  30,  39,  17}, 
{34,  41,  32,  37,  16}, 
{39,  45,  32,  35,  15}, 
{39,  43,  27,  37,  16}, 
{29,  30,  38,  29,  15}, 
{9,  30,  37,  34,  16}, 
{42,  34,  26,  47,  15}, 
{38,  35,  26,  47,  16}, 
{45,  10,  38,  33,  15}, 
{42,  7,  39,  31,  17}, 
{48,  0,  37,  35,  16}, 
{47,  14,  36,  34,  16}, 
{40,  7,  40,  31,  16}, 
{9,  41,  34,  38,  15}, 
{7,  41,  33,  39,  16}, 
{39,  36,  30,  41,  15}, 
{32,  42,  29,  39,  15}, 
{35,  42,  29,  38,  16}, 
{39,  41,  26,  42,  16}, 
{35,  42,  27,  42,  16}, 
{47,  19,  36,  33,  15}, 
{39,  29,  36,  24,  18}, 
{47,  23,  36,  26,  16}, 
{41,  42,  31,  32,  15}, 
{40,  38,  33,  34,  16}, 
{42,  40,  31,  31,  16}, 
{24,  23,  34,  47,  15}, 
{45,  43,  28,  26,  15}, 
{35,  27,  26,  48,  15}, 
{33,  46,  38,  3,  15}, 
{49,  34,  33,  29,  15}, 
{35,  27,  35,  38,  15}, 
{39,  32,  32,  41,  15}, 
{45,  36,  30,  30,  15}, 
{43,  39,  31,  30,  16}, 
{49,  36,  32,  26,  16}, 
{44,  37,  31,  31,  17}, 
{44,  37,  31,  32,  16}, 
{43,  38,  29,  35,  17}, 
{44,  40,  29,  31,  16}, 
{44,  42,  31,  26,  15}, 
{44,  42,  34,  17,  17}, 
{44,  41,  31,  30,  15}, 
{47,  43,  26,  27,  15}, 
{47,  42,  23,  35,  17}, 
{47,  42,  24,  32,  16}, 
{47,  42,  28,  25,  15}, 
{49,  40,  30,  19,  15}, 
{45,  38,  31,  25,  16}, 
{45,  44,  31,  15,  16}, 
{45,  38,  32,  21,  16}, 
{49,  39,  32,  12,  16}, 
{42,  31,  33,  34,  15}, 
{41,  41,  32,  31,  18}, 
{44,  36,  32,  30,  16}, 
{42,  41,  32,  30,  16}, 
{42,  41,  34,  29,  15}, 
{43,  40,  33,  24,  18}, 
{44,  39,  33,  24,  16}, 
{41,  36,  33,  33,  16}, 
{49,  35,  32,  32,  16}, 
{41,  39,  32,  34,  16}, 
{42,  42,  34,  25,  16}, 
{44,  39,  32,  31,  15}, 
{40,  35,  35,  29,  15}, 
{42,  36,  35,  23,  17}, 
{42,  40,  35,  20,  16}, 
{13,  43,  14,  49,  15}, 
{45,  21,  37,  29,  15}, 
{34,  35,  29,  44,  15}, 
{26,  35,  29,  46,  15}, 
{17,  29,  31,  47,  16}, 
{26,  31,  30,  46,  15}, 
{35,  32,  30,  43,  16}, 
{12,  35,  29,  47,  15}, 
{30,  36,  29,  44,  15}, 
{45,  48,  27,  14,  15}, 
{40,  48,  32,  12,  16}, 
{43,  48,  30,  14,  16}, 
{37,  30,  36,  26,  15}, 
{48,  47,  34,  1,  15}, 
{47,  47,  36,  1,  15}, 
{47,  43,  36,  3,  17}, 
{44,  46,  38,  1,  15}, 
{39,  44,  38,  3,  16}, 
{42,  45,  37,  3,  16}, 
{47,  44,  29,  18,  15}, 
{47,  43,  31,  16,  15}, 
{48,  43,  20,  25,  15}, 
{49,  11,  43,  8,  15}, 
{47,  39,  24,  39,  15}, 
{41,  43,  23,  39,  15}, 
{40,  43,  24,  38,  16}, 
{32,  44,  24,  41,  15}, 
{25,  43,  24,  44,  17}, 
{24,  43,  27,  41,  15}, 
{26,  45,  25,  43,  15}, 
{13,  46,  28,  37,  19}, 
{15,  48,  27,  36,  17}, 
{2,  45,  25,  45,  16}, 
{31,  48,  24,  36,  16}, 
{28,  46,  23,  42,  15}, 
{49,  29,  36,  23,  15}, 
{45,  24,  36,  29,  16}, 
{31,  22,  33,  45,  15}, 
{30,  30,  34,  42,  15}, 
{29,  25,  35,  41,  16}, 
{29,  20,  36,  41,  16}, 
{30,  24,  34,  45,  16}, 
{38,  26,  33,  41,  15}, 
{34,  37,  39,  7,  15}, 
{49,  36,  39,  5,  15}, 
{46,  47,  21,  33,  15}, 
{45,  43,  7,  47,  15}, 
{27,  46,  31,  35,  15}, 
{33,  46,  32,  32,  16}, 
{30,  47,  34,  32,  15}, 
{23,  48,  32,  32,  15}, 
{28,  46,  36,  21,  15}, 
{47,  48,  26,  9,  15}, 
{18,  40,  29,  42,  15}, 
{28,  40,  29,  41,  16}, 
{0,  40,  30,  44,  15}, 
{16,  42,  29,  41,  15}, 
{31,  19,  29,  49,  15}, 
{26,  32,  36,  33,  15}, 
{29,  30,  38,  31,  16}, 
{11,  49,  29,  31,  15}, 
{32,  32,  41,  3,  15}, 
{37,  39,  25,  46,  15}, 
{34,  39,  26,  46,  15}, 
{44,  34,  20,  48,  15}, 
{45,  37,  9,  49,  17}, 
{48,  36,  12,  49,  16}, 
{39,  39,  29,  38,  15}, 
{32,  40,  30,  40,  15}, 
{41,  26,  30,  45,  15}, 
{29,  47,  23,  39,  15}, 
{20,  42,  27,  44,  15}, 
{19,  42,  28,  43,  16}, 
{32,  48,  35,  14,  15}, 
{22,  35,  22,  49,  15}, 
{36,  35,  20,  49,  15}, 
{33,  32,  37,  18,  15}, 
{44,  36,  37,  15,  15}, 
{40,  36,  38,  10,  17}, 
{38,  36,  38,  13,  17}, 
{43,  38,  37,  10,  17}, 
{43,  38,  38,  9,  17}, 
{34,  41,  38,  10,  16}, 
{35,  37,  38,  14,  15}, 
{32,  40,  37,  12,  18}, 
{31,  42,  37,  12,  16}, 
{43,  38,  37,  12,  16}, 
{35,  41,  37,  12,  15}, 
{4,  47,  31,  35,  15}, 
{33,  45,  28,  36,  15}, 
{33,  45,  24,  39,  15}, 
{29,  45,  24,  43,  15}, 
{35,  43,  24,  42,  15}, 
{43,  45,  29,  24,  15}, 
{45,  46,  27,  22,  16}, 
{14,  42,  24,  46,  15}, 
{31,  21,  38,  35,  15}, 
{35,  23,  38,  29,  16}, 
{36,  28,  39,  16,  16}, 
{33,  36,  38,  16,  16}, 
{11,  49,  21,  40,  15}, 
{16,  24,  37,  40,  15}, 
{10,  29,  35,  41,  15}, 
{49,  2,  48,  1,  15}, 
{45,  40,  20,  45,  15}, 
{40,  42,  28,  37,  15}, 
{42,  42,  28,  34,  16}, 
{40,  41,  26,  42,  15}, 
{43,  42,  21,  42,  16}, 
{46,  41,  23,  40,  16}, 
{29,  39,  34,  35,  15}, 
{39,  35,  34,  35,  15}, 
{40,  29,  35,  35,  17}, 
{40,  30,  33,  38,  15}, 
{38,  31,  34,  37,  18}, 
{40,  29,  35,  36,  17}, 
{42,  29,  33,  39,  16}, 
{40,  26,  35,  38,  16}, 
{38,  36,  34,  35,  15}, 
{36,  32,  35,  35,  15}, 
{29,  39,  35,  35,  16}, 
{47,  49,  21,  14,  15}, 
{45,  48,  30,  7,  15}, 
{39,  34,  38,  15,  15}, 
{46,  28,  39,  16,  15}, 
{44,  37,  38,  11,  17}, 
{46,  18,  40,  20,  16}, 
{46,  6,  41,  23,  15}, 
{18,  49,  27,  31,  15}, 
{42,  39,  19,  47,  15}, 
{45,  37,  21,  47,  16}, 
{43,  44,  29,  29,  15}, 
{42,  45,  30,  27,  15}, 
{41,  44,  31,  30,  15}, 
{42,  44,  32,  26,  16}, 
{48,  17,  35,  38,  15}, 
{45,  37,  33,  21,  15}, 
{45,  13,  38,  34,  15}, 
{21,  32,  32,  43,  15}, 
{49,  46,  29,  1,  15}, 
{49,  30,  43,  1,  15}, 
{32,  36,  39,  11,  15}, 
{31,  28,  40,  16,  15}, 
{28,  26,  40,  22,  16}, 
{32,  33,  42,  2,  15}, 
{28,  29,  43,  37,  14}, 
{32,  29,  43,  11,  20}, 
{30,  23,  43,  31,  18}, 
{24,  26,  37,  39,  18}, 
{26,  32,  41,  8,  18}, 
{29,  27,  39,  37,  17}, 
{31,  21,  43,  31,  17}, 
{33,  23,  41,  29,  18}, 
{22,  26,  38,  40,  16}, 
{27,  33,  36,  34,  16}, 
{49,  27,  40,  12,  16}, 
{30,  27,  44,  19,  15}, 
{3,  12,  48,  2,  19}, 
{37,  28,  44,  7,  18}, 
{49,  25,  43,  9,  16}, 
{32,  29,  42,  18,  15}, 
{34,  27,  44,  13,  16}, 
{44,  7,  41,  29,  15}, 
{44,  7,  40,  32,  15}, 
{25,  30,  37,  35,  15}, 
{28,  28,  36,  39,  15}, 
{27,  25,  38,  39,  16}, 
{29,  27,  42,  31,  15}, 
{34,  29,  35,  46,  14}, 
{35,  29,  33,  46,  20}, 
{4,  31,  34,  44,  18}, 
{41,  29,  30,  45,  17}, 
{39,  25,  32,  45,  17}, 
{37,  31,  29,  46,  16}, 
{24,  28,  32,  47,  16}, 
{39,  34,  29,  45,  15}, 
{32,  35,  29,  46,  17}, 
{33,  25,  31,  47,  15}, 
{26,  29,  32,  47,  16}, 
{34,  30,  29,  47,  15}, 
{31,  34,  27,  47,  16}, 
{32,  21,  34,  47,  15}, 
{25,  31,  30,  47,  15}, 
{38,  27,  34,  40,  15}, 
{41,  30,  34,  38,  16}, 
{40,  40,  34,  32,  16}, 
{41,  34,  34,  34,  16}, 
{39,  28,  35,  38,  15}, 
{27,  22,  48,  23,  14}, 
{36,  26,  47,  5,  16}, 
{27,  30,  48,  2,  18}, 
{34,  41,  48,  0,  16}, 
{41,  42,  46,  0,  17}, 
{26,  45,  49,  0,  17}, 
{40,  8,  44,  21,  15}, 
{31,  22,  48,  15,  15}, 
{42,  45,  42,  4,  14}, 
{43,  41,  41,  3,  18}, 
{41,  45,  38,  5,  18}, 
{18,  41,  39,  10,  18}, 
{36,  46,  42,  2,  17}, 
{35,  49,  40,  0,  17}, 
{44,  46,  40,  1,  17}, 
{39,  31,  41,  8,  17}, 
{29,  41,  39,  10,  16}, 
{44,  35,  41,  5,  16}, 
{34,  43,  38,  10,  16}, 
{34,  47,  41,  1,  16}, 
{33,  47,  37,  5,  17}, 
{32,  48,  40,  2,  18}, 
{32,  49,  39,  3,  16}, 
{46,  47,  38,  1,  16}, 
{38,  34,  40,  7,  16}, 
{49,  34,  42,  6,  16}, 
{37,  30,  43,  8,  16}, 
{25,  30,  43,  14,  17}, 
{19,  32,  41,  14,  16}, 
{38,  32,  40,  10,  16}, 
{46,  39,  39,  4,  16}, 
{24,  48,  37,  10,  15}, 
{48,  47,  37,  1,  15}, 
{39,  46,  46,  0,  15}, 
{43,  46,  45,  0,  16}, 
{49,  38,  39,  5,  15}, 
{42,  36,  42,  5,  15}, 
{34,  33,  39,  13,  15}, 
{49,  44,  38,  1,  15}, 
{40,  39,  34,  38,  14}, 
{27,  34,  34,  39,  19}, 
{35,  45,  33,  35,  17}, 
{43,  36,  29,  37,  16}, 
{43,  31,  33,  37,  16}, 
{29,  45,  35,  35,  16}, 
{35,  45,  34,  35,  16}, 
{36,  33,  35,  38,  15}, 
{21,  33,  35,  39,  18}, 
{11,  33,  36,  38,  17}, 
{25,  33,  36,  37,  17}, 
{25,  37,  35,  36,  16}, 
{8,  34,  36,  38,  18}, 
{29,  32,  35,  39,  16}, 
{38,  31,  35,  38,  16}, 
{34,  45,  35,  35,  15}, 
{30,  46,  34,  35,  15}, 
{49,  31,  33,  36,  15}, 
{43,  36,  33,  32,  15}, 
{32,  41,  34,  36,  15}, 
{45,  26,  32,  41,  15}, 
{41,  34,  29,  43,  15}, 
{30,  40,  33,  38,  15}, 
{49,  28,  34,  35,  15}, 
{44,  26,  35,  35,  15}, 
{41,  38,  30,  37,  15}, 
{34,  37,  34,  42,  14}, 
{5,  34,  34,  43,  17}, 
{24,  38,  32,  42,  17}, 
{38,  31,  32,  42,  16}, 
{38,  30,  34,  40,  16}, 
{9,  39,  34,  42,  15}, 
{10,  40,  32,  41,  16}, 
{4,  35,  34,  44,  15}, 
{29,  40,  33,  39,  15}, 
{34,  31,  35,  39,  15}, 
{26,  39,  32,  41,  15}, 
{20,  16,  46,  33,  14}, 
{28,  19,  46,  27,  17}, 
{3,  6,  45,  35,  16}, 
{24,  21,  45,  29,  16}, 
{23,  16,  45,  35,  15}, 
{30,  34,  35,  42,  14}, 
{33,  37,  35,  36,  19}, 
{0,  33,  35,  43,  19}, 
{34,  31,  35,  41,  17}, 
{37,  34,  35,  36,  16}, 
{32,  34,  31,  46,  14}, 
{21,  36,  32,  43,  18}, 
{35,  34,  30,  45,  17}, 
{26,  31,  32,  44,  17}, 
{20,  30,  34,  45,  17}, 
{22,  36,  30,  45,  16}, 
{0,  30,  35,  46,  15}, 
{0,  32,  35,  44,  16}, 
{21,  34,  33,  43,  15}, 
{35,  32,  31,  45,  15}, 
{12,  34,  32,  46,  15}, 
{18,  34,  30,  47,  15}, 
{38,  42,  41,  7,  14}, 
{40,  44,  40,  5,  16}, 
{37,  43,  41,  6,  17}, 
{16,  45,  41,  7,  17}, 
{44,  35,  39,  10,  16}, 
{43,  37,  41,  7,  16}, 
{39,  34,  41,  8,  16}, 
{44,  37,  39,  9,  16}, 
{41,  39,  39,  8,  16}, 
{43,  38,  39,  10,  15}, 
{34,  42,  39,  9,  16}, 
{17,  39,  42,  7,  15}, 
{39,  34,  42,  8,  15}, 
{38,  43,  40,  7,  15}, 
{40,  43,  37,  8,  15}, 
{11,  29,  36,  46,  14}, 
{20,  18,  36,  45,  17}, 
{12,  26,  38,  44,  14}, 
{18,  21,  38,  42,  16}, 
{20,  15,  38,  44,  16}, 
{26,  21,  41,  38,  14}, 
{46,  44,  25,  37,  14}, 
{43,  41,  28,  35,  17}, 
{44,  49,  16,  36,  16}, 
{42,  43,  27,  37,  16}, 
{42,  41,  26,  41,  15}, 
{47,  36,  27,  41,  17}, 
{44,  39,  25,  44,  16}, 
{43,  37,  27,  42,  16}, 
{41,  47,  23,  36,  15}, 
{47,  37,  25,  43,  15}, 
{45,  38,  24,  46,  15}, 
{46,  35,  24,  47,  17}, 
{33,  48,  26,  35,  15}, 
{37,  48,  25,  34,  16}, 
{33,  46,  23,  40,  15}, 
{34,  48,  23,  37,  15}, 
{24,  49,  23,  37,  15}, 
{21,  49,  26,  36,  15}, 
{23,  49,  32,  22,  15}, 
{47,  37,  27,  41,  15}, 
{44,  40,  26,  41,  15}, 
{4,  49,  29,  35,  15}, 
{47,  47,  41,  1,  14}, 
{45,  41,  39,  4,  16}, 
{39,  47,  46,  0,  16}, 
{32,  49,  42,  1,  17}, 
{45,  48,  41,  0,  16}, 
{19,  49,  42,  5,  15}, 
{19,  48,  38,  10,  15}, 
{34,  42,  39,  12,  14}, 
{37,  37,  39,  12,  15}, 
{36,  39,  38,  27,  14}, 
{42,  37,  36,  19,  20}, 
{36,  26,  39,  28,  19}, 
{37,  33,  37,  27,  17}, 
{30,  26,  39,  36,  17}, 
{30,  31,  37,  30,  17}, 
{35,  41,  36,  26,  16}, 
{36,  45,  36,  15,  17}, 
{28,  31,  37,  36,  16}, 
{49,  34,  37,  18,  16}, 
{44,  35,  38,  16,  17}, 
{49,  30,  37,  22,  17}, 
{42,  33,  36,  23,  17}, 
{38,  37,  38,  18,  16}, 
{49,  33,  39,  13,  16}, 
{33,  26,  41,  29,  16}, 
{42,  33,  37,  22,  16}, 
{33,  29,  40,  21,  16}, 
{34,  28,  40,  28,  16}, 
{26,  37,  38,  28,  15}, 
{13,  33,  37,  32,  17}, 
{26,  32,  38,  30,  16}, 
{32,  45,  36,  25,  15}, 
{31,  29,  42,  27,  15}, 
{40,  37,  36,  21,  15}, 
{37,  36,  37,  27,  15}, 
{38,  37,  37,  23,  16}, 
{47,  21,  38,  28,  15}, 
{46,  15,  39,  31,  16}, 
{30,  32,  36,  34,  15}, 
{44,  37,  38,  13,  15}, 
{35,  28,  39,  29,  15}, 
{35,  32,  38,  29,  15}, 
{31,  26,  38,  35,  15}, 
{32,  32,  37,  31,  17}, 
{35,  31,  36,  33,  15}, 
{32,  31,  37,  36,  15}, 
{30,  27,  44,  23,  15}, 
{30,  47,  36,  27,  14}, 
{32,  46,  35,  29,  16}, 
{15,  47,  36,  29,  17}, 
{33,  47,  36,  17,  16}, 
{30,  46,  35,  34,  15}, 
{8,  47,  36,  32,  18}, 
{33,  46,  35,  31,  17}, 
{32,  48,  36,  15,  15}, 
{32,  48,  40,  4,  15}, 
{34,  46,  40,  5,  15}, 
{40,  46,  39,  4,  15}, 
{39,  46,  35,  22,  15}, 
{36,  46,  31,  32,  16}, 
{34,  46,  35,  32,  16}, 
{34,  47,  32,  31,  15}, 
{48,  46,  34,  4,  15}, 
{45,  46,  34,  7,  17}, 
{39,  46,  31,  31,  15}, 
{38,  47,  32,  24,  16}, 
{40,  47,  29,  27,  16}, 
{46,  47,  34,  4,  15}, 
{42,  46,  32,  16,  15}, 
{34,  46,  33,  34,  15}, 
{37,  46,  36,  16,  15}, 
{44,  47,  31,  14,  15}, 
{38,  39,  37,  16,  15}, 
{40,  43,  37,  10,  15}, 
{39,  46,  36,  14,  16}, 
{38,  41,  38,  11,  15}, 
{34,  47,  38,  22,  14}, 
{34,  41,  38,  23,  18}, 
{38,  45,  37,  12,  18}, 
{31,  40,  38,  25,  18}, 
{33,  47,  35,  28,  18}, 
{37,  47,  35,  22,  17}, 
{35,  47,  36,  24,  16}, 
{36,  47,  40,  5,  16}, 
{38,  45,  37,  20,  15}, 
{38,  40,  38,  18,  18}, 
{39,  46,  36,  20,  17}, 
{41,  40,  36,  20,  16}, 
{35,  45,  38,  20,  16}, 
{39,  47,  36,  22,  15}, 
{38,  41,  37,  23,  18}, 
{17,  47,  39,  12,  15}, 
{14,  49,  39,  10,  17}, 
{35,  43,  39,  12,  16}, 
{21,  49,  37,  15,  16}, 
{32,  48,  38,  10,  15}, 
{39,  46,  42,  4,  15}, 
{29,  47,  35,  30,  15}, 
{40,  44,  38,  7,  15}, 
{37,  40,  36,  27,  15}, 
{38,  42,  36,  25,  16}, 
{38,  37,  37,  26,  16}, 
{38,  31,  37,  29,  16}, 
{41,  31,  37,  25,  16}, 
{36,  27,  40,  29,  15}, 
{18,  47,  36,  30,  15}, 
{26,  40,  38,  26,  15}, 
{20,  48,  37,  18,  15}, 
{6,  49,  36,  21,  15}, 
{40,  49,  28,  27,  14}, 
{35,  49,  25,  35,  18}, 
{32,  49,  34,  14,  17}, 
{45,  49,  27,  14,  17}, 
{30,  49,  27,  35,  16}, 
{43,  49,  23,  29,  15}, 
{33,  49,  30,  20,  15}, 
{36,  49,  34,  11,  16}, 
{44,  49,  31,  10,  17}, 
{45,  49,  29,  14,  16}, 
{40,  49,  30,  19,  15}, 
{41,  49,  32,  13,  15}, 
{41,  47,  34,  9,  15}, 
{44,  49,  32,  9,  15}, 
{45,  48,  34,  4,  15}, 
{21,  36,  35,  40,  14}, 
{49,  32,  24,  49,  14}, 
{49,  37,  28,  38,  16}, 
{38,  33,  24,  49,  15}, 
{42,  40,  14,  49,  14}, 
{43,  41,  13,  47,  15}, 
{42,  41,  13,  49,  17}, 
{42,  43,  15,  44,  16}, 
{42,  44,  11,  46,  16}, 
{39,  44,  17,  44,  16}, 
{42,  42,  20,  44,  16}, 
{44,  47,  4,  48,  16}, 
{42,  49,  7,  46,  15}, 
{41,  49,  9,  44,  16}, 
{41,  47,  12,  43,  17}, 
{34,  47,  23,  40,  16}, 
{49,  38,  11,  48,  15}, 
{34,  49,  9,  47,  15}, 
{22,  48,  12,  47,  15}, 
{41,  49,  11,  44,  16}, 
{32,  46,  18,  45,  16}, 
{32,  47,  18,  45,  15}, 
{0,  48,  18,  47,  17}, 
{32,  48,  18,  44,  16}, 
{33,  49,  23,  39,  18}, 
{28,  47,  23,  43,  15}, 
{43,  47,  12,  44,  15}, 
{47,  47,  9,  41,  15}, 
{38,  38,  21,  49,  14}, 
{44,  35,  20,  48,  15}, 
{41,  37,  21,  49,  16}, 
{39,  36,  24,  48,  14}, 
{31,  36,  24,  49,  18}, 
{43,  35,  23,  48,  16}, 
{49,  31,  32,  40,  14}, 
{46,  28,  33,  40,  15}, 
{43,  30,  31,  42,  15}, 
{39,  28,  31,  45,  15}, 
{36,  26,  33,  46,  15}, 
{39,  28,  32,  45,  15}, 
{49,  28,  32,  41,  15}, 
{49,  16,  32,  46,  15}, 
{39,  22,  35,  41,  15}, 
{27,  30,  39,  33,  14}, 
{19,  30,  43,  19,  17}, 
{34,  30,  40,  20,  16}, 
{9,  33,  38,  32,  15}, 
{35,  43,  39,  14,  14}, 
{14,  49,  39,  14,  16}, 
{46,  32,  39,  15,  16}, 
{30,  32,  41,  15,  15}, 
{33,  30,  41,  21,  16}, 
{31,  30,  43,  19,  16}, 
{33,  48,  38,  12,  15}, 
{35,  48,  42,  2,  15}, 
{43,  48,  41,  1,  15}, 
{38,  48,  36,  14,  15}, 
{35,  37,  39,  22,  14}, 
{20,  31,  39,  32,  18}, 
{31,  31,  40,  21,  16}, 
{28,  31,  40,  24,  16}, 
{37,  37,  39,  16,  15}, 
{44,  35,  39,  15,  15}, 
{26,  47,  39,  19,  14}, 
{34,  47,  40,  7,  18}, 
{31,  47,  39,  14,  17}, 
{34,  38,  39,  21,  17}, 
{26,  42,  39,  20,  16}, 
{30,  39,  39,  22,  17}, 
{25,  45,  42,  6,  15}, 
{34,  44,  39,  15,  15}, 
{31,  40,  39,  21,  16}, 
{28,  38,  39,  28,  14}, 
{17,  40,  38,  28,  17}, 
{29,  47,  36,  28,  16}, 
{24,  32,  39,  37,  14}, 
{29,  32,  38,  34,  17}, 
{5,  33,  38,  36,  16}, 
{31,  30,  37,  37,  15}, 
{28,  32,  39,  34,  15}, 
{30,  47,  38,  23,  14}, 
{27,  43,  38,  28,  14}, 
{24,  47,  38,  26,  14}, 
{27,  46,  37,  27,  17}, 
{14,  43,  45,  3,  14}, 
{41,  32,  43,  5,  17}, 
{34,  31,  43,  10,  17}, 
{21,  44,  44,  3,  17}, 
{23,  45,  46,  1,  17}, 
{21,  34,  47,  3,  16}, 
{31,  42,  44,  2,  15}, 
{23,  47,  43,  3,  17}, 
{29,  45,  46,  1,  15}, 
{41,  32,  47,  2,  16}, 
{21,  45,  48,  1,  15}, 
{41,  41,  20,  46,  14}, 
{39,  42,  21,  46,  15}, 
{40,  41,  23,  45,  16}, 
{38,  44,  17,  46,  16}, 
{35,  42,  23,  45,  15}, 
{31,  43,  23,  45,  15}, 
{42,  38,  27,  46,  14}, 
{43,  37,  27,  44,  18}, 
{49,  26,  29,  44,  17}, 
{44,  38,  27,  43,  18}, 
{18,  35,  32,  46,  14}, 
{26,  34,  32,  44,  16}, 
{31,  32,  32,  44,  16}, 
{24,  36,  32,  44,  15}, 
{31,  36,  30,  45,  16}, 
{31,  35,  31,  46,  17}, 
{34,  37,  30,  43,  16}, 
{18,  36,  32,  45,  16}, 
{5,  36,  34,  45,  14}, 
{12,  31,  35,  46,  19}, 
{18,  32,  33,  46,  15}, 
{23,  30,  35,  44,  15}, 
{48,  43,  32,  13,  14}, 
{45,  45,  34,  8,  15}, 
{32,  34,  26,  48,  14}, 
{33,  35,  25,  48,  15}, 
{34,  34,  40,  15,  14}, 
{34,  34,  41,  11,  16}, 
{30,  35,  41,  10,  15}, 
{24,  42,  40,  8,  15}, 
{43,  41,  38,  10,  14}, 
{43,  41,  36,  14,  15}, 
{42,  47,  36,  5,  15}, 
{49,  27,  26,  49,  14}, 
{36,  35,  25,  48,  15}, 
{42,  29,  25,  49,  16}, 
{42,  30,  26,  48,  16}, 
{29,  43,  34,  36,  14}, 
{39,  44,  32,  36,  14}, 
{4,  48,  29,  37,  17}, 
{4,  47,  30,  37,  16}, 
{23,  45,  34,  36,  17}, 
{44,  38,  32,  33,  14}, 
{20,  32,  38,  38,  14}, 
{32,  48,  24,  39,  14}, 
{1,  47,  25,  42,  16}, 
{28,  47,  24,  42,  16}, 
{13,  46,  28,  41,  14}, 
{13,  44,  29,  40,  17}, 
{4,  43,  32,  38,  16}, 
{13,  46,  29,  39,  15}, 
{30,  41,  34,  38,  14}, 
{22,  25,  46,  23,  14}, 
{27,  23,  48,  23,  16}, 
{2,  36,  36,  40,  14}, 
{49,  41,  34,  10,  14}, 
{46,  39,  34,  13,  16}, 
{48,  43,  19,  34,  14}, 
{49,  40,  24,  39,  16}, 
{47,  43,  24,  35,  15}, 
{47,  44,  24,  33,  15}, 
{49,  44,  27,  17,  14}, 
{48,  43,  27,  20,  16}, 
{49,  44,  19,  33,  15}, 
{49,  42,  25,  26,  15}, 
{49,  43,  29,  18,  15}, 
{45,  38,  34,  21,  14}, 
{49,  36,  37,  16,  15}, 
{44,  38,  34,  33,  14}, 
{44,  39,  34,  30,  18}, 
{49,  32,  34,  35,  16}, 
{42,  35,  34,  35,  15}, 
{49,  33,  34,  35,  16}, 
{49,  34,  35,  23,  15}, 
{45,  38,  34,  24,  15}, 
{45,  38,  32,  27,  15}, 
{49,  37,  29,  33,  16}, 
{49,  34,  35,  33,  14}, 
{44,  35,  34,  36,  14}, 
{42,  33,  33,  38,  17}, 
{47,  22,  35,  39,  16}, 
{46,  36,  29,  37,  15}, 
{44,  38,  31,  34,  15}, 
{43,  30,  34,  39,  15}, 
{42,  32,  32,  40,  15}, 
{41,  34,  32,  39,  17}, 
{46,  34,  35,  35,  14}, 
{40,  34,  35,  36,  16}, 
{39,  32,  35,  38,  16}, 
{40,  39,  35,  33,  14}, 
{41,  35,  35,  34,  16}, 
{45,  35,  35,  31,  14}, 
{45,  42,  31,  26,  14}, 
{45,  39,  33,  27,  16}, 
{45,  39,  34,  27,  15}, 
{1,  36,  28,  48,  14}, 
{6,  33,  29,  49,  15}, 
{32,  32,  27,  48,  14}, 
{42,  43,  34,  22,  14}, 
{40,  44,  35,  17,  17}, 
{41,  45,  34,  29,  14}, 
{41,  44,  33,  31,  16}, 
{43,  44,  27,  33,  15}, 
{41,  42,  34,  33,  14}, 
{41,  39,  33,  35,  16}, 
{40,  41,  31,  37,  15}, 
{20,  26,  37,  43,  14}, 
{20,  27,  36,  45,  15}, 
{37,  36,  29,  44,  14}, 
{41,  35,  29,  43,  16}, 
{40,  36,  32,  39,  16}, 
{36,  38,  29,  42,  16}, 
{35,  37,  32,  43,  14}, 
{32,  36,  31,  44,  15}, 
{46,  40,  19,  44,  14}, 
{47,  38,  24,  43,  16}, 
{47,  40,  19,  42,  15}, 
{45,  24,  37,  32,  14}, 
{38,  31,  36,  33,  16}, 
{33,  26,  40,  31,  16}, 
{34,  32,  37,  31,  15}, 
{39,  26,  36,  35,  15}, 
{35,  31,  39,  30,  14}, 
{33,  31,  39,  32,  17}, 
{32,  30,  38,  36,  17}, 
{31,  28,  43,  31,  17}, 
{34,  48,  39,  10,  14}, 
{32,  47,  39,  16,  16}, 
{24,  38,  34,  42,  14}, 
{31,  38,  34,  40,  16}, 
{37,  31,  31,  46,  14}, 
{44,  31,  31,  43,  14}, 
{42,  34,  30,  41,  15}, 
{44,  35,  31,  37,  15}, 
{17,  34,  35,  43,  14}, 
{7,  33,  34,  46,  15}, 
{44,  41,  33,  25,  14}, 
{34,  40,  27,  44,  14}, 
{12,  42,  34,  38,  14}, 
{40,  45,  33,  33,  14}, 
{43,  44,  28,  34,  17}, 
{44,  43,  27,  35,  16}, 
{25,  33,  37,  36,  14}, 
{42,  38,  28,  43,  14}, 
{38,  32,  31,  44,  14}, 
{36,  33,  30,  46,  16}, 
{37,  36,  31,  42,  15}, 
{37,  33,  32,  43,  16}, 
{43,  42,  36,  10,  14}, 
{49,  43,  19,  36,  14}, 
{47,  42,  16,  40,  15}, 
{49,  44,  15,  38,  16}, 
{35,  41,  23,  46,  14}, 
{29,  49,  22,  41,  14}, 
{5,  49,  23,  43,  15}, 
{25,  45,  25,  44,  14}, 
{25,  47,  23,  44,  14}, 
{28,  46,  21,  45,  16}, 
{9,  49,  21,  45,  15}, 
{11,  47,  24,  45,  16}, 
{49,  36,  40,  8,  14}, 
{49,  35,  40,  10,  15}, 
{46,  41,  25,  40,  14}, 
{44,  33,  24,  49,  14}, 
{45,  38,  29,  37,  14}, 
{41,  44,  37,  10,  14}, 
{41,  44,  35,  18,  14}, 
{43,  42,  36,  14,  15}, 
{45,  42,  36,  13,  14}, 
{45,  39,  39,  10,  18}, 
{49,  37,  37,  13,  15}, 
{44,  38,  37,  22,  14}, 
{39,  45,  37,  16,  17}, 
{45,  38,  36,  18,  16}, 
{43,  40,  36,  20,  15}, 
{43,  39,  38,  12,  15}, 
{40,  44,  35,  33,  14}, 
{44,  42,  35,  17,  14}, 
{44,  40,  36,  19,  15}, 
{45,  42,  35,  16,  14}, 
{49,  37,  37,  17,  14}, 
{46,  38,  34,  17,  15}, 
{49,  41,  32,  16,  15}, 
{46,  41,  33,  17,  15}, 
{47,  41,  36,  16,  14}, 
{49,  40,  37,  11,  15}, 
{49,  39,  39,  8,  15}, 
{46,  42,  36,  10,  15}, 
{41,  41,  38,  12,  15}, 
{49,  41,  36,  14,  14}, 
{49,  37,  32,  27,  14}, 
{47,  42,  30,  27,  14}, 
{49,  41,  29,  26,  15}, 
{49,  40,  32,  27,  14}, 
{49,  39,  35,  18,  16}, 
{49,  41,  33,  19,  17}, 
{49,  38,  34,  25,  16}, 
{49,  43,  32,  17,  15}, 
{47,  42,  31,  27,  15}, 
{44,  41,  37,  13,  14}, 
{34,  46,  41,  7,  14}, 
{29,  31,  43,  16,  14}, 
{3,  32,  42,  18,  15}, 
{38,  40,  27,  42,  14}, 
{38,  39,  31,  39,  14}, 
{36,  40,  30,  40,  17}, 
{35,  42,  28,  42,  15}, 
{32,  40,  29,  42,  16}, 
{34,  40,  28,  44,  15}, 
{41,  41,  28,  42,  14}, 
{41,  43,  27,  38,  17}, 
{40,  41,  30,  38,  16}, 
{35,  43,  26,  41,  15}, 
{38,  39,  30,  40,  15}, 
{42,  41,  28,  39,  15}, 
{37,  41,  32,  38,  14}, 
{35,  40,  30,  41,  14}, 
{34,  41,  34,  37,  14}, 
{35,  44,  34,  36,  17}, 
{28,  33,  38,  34,  14}, 
{23,  33,  38,  37,  16}, 
{38,  39,  30,  41,  14}, 
{37,  38,  30,  42,  15}, 
{40,  32,  35,  38,  14}, 
{35,  35,  26,  48,  14}, 
{45,  49,  24,  23,  14}, 
{30,  46,  37,  25,  14}, 
{39,  41,  37,  24,  14}, 
{35,  41,  38,  25,  16}, 
{42,  39,  37,  19,  15}, 
{39,  43,  38,  18,  14}, 
{43,  41,  38,  13,  16}, 
{40,  39,  38,  17,  15}, 
{27,  35,  35,  38,  14}, 
{25,  33,  30,  47,  14}, 
{1,  36,  32,  46,  14}, 
{40,  44,  30,  36,  14}, 
{37,  40,  24,  46,  14}, 
{34,  25,  27,  49,  14}, 
{41,  46,  39,  5,  14}, 
{18,  44,  38,  28,  14}, 
{21,  40,  17,  49,  14}, 
{6,  30,  31,  49,  14}, 
{8,  42,  39,  22,  14}, 
{7,  36,  43,  6,  14}, 
{47,  38,  18,  47,  14}, 
{39,  37,  23,  48,  14}, 
{39,  30,  32,  44,  14}, 
{34,  40,  16,  49,  14}, 
{34,  39,  21,  49,  14}, 
{41,  43,  38,  11,  14}, 
{13,  47,  36,  32,  14}, 
{28,  34,  36,  34,  16}, 
{28,  35,  39,  29,  14}, 
{23,  37,  37,  29,  15}, 
{8,  42,  38,  29,  15}, 
{18,  36,  38,  30,  15}, 
{7,  34,  38,  33,  16}, 
{28,  34,  39,  30,  15}, 
{8,  38,  37,  31,  14}, 
{21,  41,  37,  29,  14}, 
{23,  48,  43,  3,  14}, 
{38,  48,  46,  0,  15}, 
{49,  40,  25,  39,  14}, 
{49,  41,  25,  34,  14}, 
{39,  42,  28,  39,  14}, 
{47,  41,  17,  42,  14}, 
{47,  44,  15,  40,  14}, 
{49,  44,  25,  21,  14}, 
{41,  38,  37,  23,  14}, 
{43,  36,  37,  23,  14}, 
{26,  39,  34,  40,  14}, 
{45,  49,  33,  4,  14}, 
{23,  20,  38,  41,  14}, 
{18,  24,  30,  49,  14}, 
{26,  22,  30,  49,  15}, 
{18,  40,  40,  9,  14}, 
{47,  31,  27,  46,  14}, 
{42,  42,  34,  30,  14}, 
{44,  42,  31,  29,  14}, 
{42,  38,  18,  48,  14}, 
{42,  40,  16,  48,  14}, 
{41,  39,  18,  49,  15}, 
{34,  43,  26,  42,  14}, 
{25,  43,  26,  44,  14}, 
{43,  28,  35,  38,  14}, 
{46,  40,  29,  28,  14}, 
{45,  39,  34,  28,  15}, 
{49,  37,  31,  32,  15}, 
{46,  39,  34,  28,  15}, 
{46,  41,  33,  24,  15}, 
{47,  42,  26,  30,  15}, 
{49,  39,  27,  32,  15}, 
{46,  40,  27,  34,  15}, 
{48,  43,  23,  29,  14}, 
{49,  42,  28,  27,  14}, 
{49,  42,  31,  24,  14}, 
{35,  35,  24,  49,  14}, 
{49,  38,  36,  19,  14}, 
{39,  42,  13,  48,  14}, 
{37,  42,  16,  47,  15}, 
{31,  42,  15,  49,  14}, 
{35,  30,  35,  40,  14}, 
{45,  44,  32,  16,  14}, 
{25,  43,  28,  41,  14}, 
{24,  41,  32,  39,  14}, 
{45,  47,  32,  11,  14}, 
{45,  37,  38,  14,  14}, 
{27,  35,  37,  31,  14}, 
{20,  46,  36,  31,  14}, 
{9,  37,  34,  43,  14}, 
{46,  11,  42,  20,  14}, 
{21,  32,  42,  18,  14}, 
{45,  40,  26,  40,  14}, 
{47,  39,  23,  42,  14}, 
{39,  41,  23,  46,  14}, 
{41,  32,  31,  43,  14}, 
{39,  33,  35,  38,  14}, 
{23,  46,  32,  36,  14}, 
{40,  41,  38,  17,  14}, 
{32,  32,  38,  34,  14}, 
{48,  44,  31,  12,  14}, 
{48,  47,  39,  0,  14}, 
{17,  47,  25,  44,  14}, 
{13,  46,  27,  42,  14}, 
{14,  46,  36,  33,  14}, 
{48,  49,  23,  8,  14}, 
{49,  23,  48,  7,  14}, 
{32,  30,  41,  24,  14}, 
{20,  49,  39,  14,  14}, 
{4,  43,  34,  38,  14}, 
{8,  23,  34,  48,  14}, 
{1,  37,  27,  47,  14}, 
{12,  31,  42,  22,  14}, 
{36,  41,  38,  25,  14}, 
{42,  42,  34,  44,  13}, 
{11,  43,  34,  39,  18}, 
{40,  39,  26,  46,  17}, 
{49,  9,  34,  45,  17}, 
{23,  32,  35,  44,  17}, 
{39,  43,  31,  37,  17}, 
{22,  43,  34,  39,  18}, 
{28,  43,  34,  39,  16}, 
{22,  43,  32,  40,  16}, 
{44,  38,  31,  36,  16}, 
{27,  33,  35,  43,  16}, 
{30,  31,  35,  44,  17}, 
{45,  38,  29,  38,  16}, 
{35,  26,  35,  44,  16}, 
{41,  25,  34,  45,  16}, 
{43,  38,  34,  36,  15}, 
{43,  39,  33,  35,  16}, 
{34,  42,  24,  45,  15}, 
{40,  44,  35,  34,  15}, 
{40,  43,  32,  38,  15}, 
{5,  37,  34,  45,  15}, 
{44,  31,  33,  42,  15}, 
{31,  43,  26,  44,  15}, 
{44,  39,  34,  33,  15}, 
{19,  34,  34,  45,  15}, 
{44,  43,  28,  35,  15}, 
{44,  39,  34,  34,  15}, 
{45,  29,  33,  43,  15}, 
{33,  43,  32,  39,  15}, 
{45,  23,  34,  44,  15}, 
{40,  43,  33,  37,  15}, 
{40,  44,  34,  36,  15}, 
{40,  45,  34,  35,  15}, 
{43,  41,  25,  44,  15}, 
{14,  44,  34,  39,  14}, 
{15,  44,  30,  41,  16}, 
{11,  45,  32,  39,  16}, 
{34,  31,  35,  44,  14}, 
{35,  29,  35,  45,  14}, 
{44,  43,  26,  38,  14}, 
{47,  43,  19,  40,  16}, 
{43,  43,  22,  42,  15}, 
{49,  43,  19,  39,  14}, 
{9,  34,  35,  44,  14}, 
{43,  33,  29,  44,  14}, 
{35,  31,  35,  43,  14}, 
{31,  33,  35,  42,  14}, 
{35,  32,  35,  40,  14}, 
{32,  32,  35,  44,  14}, 
{26,  43,  27,  44,  14}, 
{43,  40,  26,  44,  14}, 
{44,  38,  34,  36,  14}, 
{44,  44,  17,  42,  14}, 
{41,  7,  35,  43,  14}, 
{47,  23,  35,  40,  14}, 
{5,  38,  32,  45,  14}, 
{36,  41,  25,  45,  14}, 
{14,  42,  28,  45,  14}, 
{5,  41,  32,  45,  14}, 
{11,  46,  27,  45,  14}, 
{26,  42,  26,  45,  14}, 
{40,  40,  26,  45,  14}, 
{47,  22,  35,  41,  14}, 
{41,  25,  32,  46,  14}, 
{48,  47,  39,  16,  13}, 
{49,  46,  21,  20,  17}, 
{43,  46,  42,  3,  16}, 
{49,  44,  36,  5,  16}, 
{48,  48,  30,  6,  16}, 
{42,  45,  34,  24,  16}, 
{41,  43,  37,  19,  15}, 
{41,  45,  38,  17,  16}, 
{43,  35,  39,  17,  16}, 
{47,  48,  30,  14,  15}, 
{49,  43,  38,  14,  15}, 
{44,  44,  36,  17,  15}, 
{47,  45,  31,  18,  16}, 
{43,  47,  30,  20,  15}, 
{49,  10,  44,  17,  15}, 
{46,  46,  23,  34,  15}, 
{48,  48,  39,  2,  14}, 
{47,  48,  41,  1,  15}, 
{49,  46,  38,  3,  14}, 
{42,  45,  33,  32,  14}, 
{46,  49,  36,  2,  14}, 
{44,  49,  36,  4,  16}, 
{49,  45,  33,  11,  14}, 
{49,  45,  27,  18,  15}, 
{37,  49,  35,  11,  14}, 
{40,  42,  41,  7,  14}, 
{49,  44,  38,  10,  14}, 
{47,  19,  40,  24,  14}, 
{43,  44,  33,  21,  14}, 
{49,  44,  41,  1,  14}, 
{48,  48,  40,  1,  15}, 
{46,  49,  39,  0,  14}, 
{42,  49,  34,  9,  14}, 
{40,  48,  36,  14,  16}, 
{35,  40,  39,  19,  14}, 
{42,  46,  27,  32,  14}, 
{44,  47,  25,  31,  14}, 
{41,  49,  27,  28,  15}, 
{40,  42,  36,  24,  14}, 
{48,  45,  25,  23,  14}, 
{47,  14,  40,  31,  14}, 
{33,  49,  37,  11,  14}, 
{38,  30,  40,  17,  14}, 
{46,  1,  41,  31,  14}, 
{44,  45,  38,  32,  13}, 
{45,  43,  33,  24,  17}, 
{44,  46,  27,  33,  17}, 
{39,  34,  36,  33,  17}, 
{34,  47,  36,  28,  16}, 
{45,  32,  37,  33,  15}, 
{47,  43,  31,  27,  15}, 
{47,  44,  32,  20,  17}, 
{48,  45,  28,  23,  17}, 
{49,  43,  30,  24,  16}, 
{43,  42,  33,  34,  15}, 
{41,  40,  35,  33,  15}, 
{38,  47,  38,  19,  15}, 
{43,  45,  27,  35,  15}, 
{45,  42,  34,  24,  15}, 
{46,  44,  26,  32,  15}, 
{39,  23,  38,  35,  15}, 
{39,  27,  37,  35,  15}, 
{35,  33,  37,  34,  15}, 
{42,  33,  38,  34,  14}, 
{45,  30,  36,  35,  16}, 
{44,  26,  38,  35,  15}, 
{47,  28,  37,  35,  15}, 
{47,  31,  38,  31,  15}, 
{47,  14,  37,  36,  15}, 
{45,  28,  37,  37,  14}, 
{34,  31,  37,  37,  16}, 
{42,  13,  36,  39,  16}, 
{37,  20,  36,  41,  15}, 
{33,  28,  36,  39,  16}, 
{34,  27,  36,  40,  16}, 
{41,  40,  39,  19,  14}, 
{49,  38,  39,  17,  15}, 
{44,  42,  39,  17,  16}, 
{37,  30,  39,  31,  15}, 
{37,  37,  39,  22,  15}, 
{29,  47,  39,  19,  15}, 
{33,  30,  39,  36,  14}, 
{45,  1,  41,  33,  16}, 
{31,  29,  41,  33,  16}, 
{44,  7,  44,  34,  14}, 
{32,  23,  42,  36,  19}, 
{40,  12,  43,  34,  17}, 
{41,  9,  40,  37,  15}, 
{40,  11,  42,  36,  15}, 
{42,  5,  44,  35,  16}, 
{39,  46,  39,  18,  14}, 
{39,  26,  40,  31,  14}, 
{44,  49,  27,  24,  14}, 
{46,  41,  34,  24,  14}, 
{47,  20,  36,  38,  14}, 
{37,  24,  40,  34,  14}, 
{35,  31,  39,  34,  15}, 
{45,  12,  42,  31,  14}, 
{40,  30,  36,  37,  14}, 
{40,  27,  39,  33,  14}, 
{47,  9,  37,  39,  14}, 
{38,  47,  36,  23,  14}, 
{40,  28,  38,  36,  14}, 
{24,  46,  38,  28,  14}, 
{34,  46,  37,  28,  15}, 
{21,  47,  37,  30,  14}, 
{33,  26,  42,  31,  14}, 
{23,  25,  38,  41,  14}, 
{45,  11,  41,  35,  14}, 
{41,  13,  43,  34,  14}, 
{47,  31,  36,  35,  14}, 
{48,  45,  33,  17,  14}, 
{46,  44,  33,  22,  14}, 
{45,  44,  34,  24,  14}, 
{48,  48,  27,  16,  14}, 
{21,  46,  38,  30,  14}, 
{19,  47,  38,  29,  14}, 
{46,  11,  42,  34,  14}, 
{48,  0,  39,  37,  14}, 
{47,  23,  38,  36,  14}, 
{41,  9,  39,  38,  14}, 
{31,  34,  42,  32,  13}, 
{37,  35,  39,  24,  17}, 
{31,  33,  40,  33,  17}, 
{34,  33,  41,  17,  17}, 
{44,  22,  41,  21,  15}, 
{24,  31,  40,  35,  15}, 
{33,  35,  40,  20,  14}, 
{22,  35,  40,  27,  15}, 
{33,  33,  42,  20,  15}, 
{36,  31,  41,  23,  14}, 
{36,  30,  43,  14,  15}, 
{39,  30,  41,  18,  14}, 
{49,  34,  40,  12,  15}, 
{28,  35,  41,  17,  14}, 
{36,  29,  44,  12,  14}, 
{36,  33,  42,  14,  14}, 
{38,  35,  41,  11,  15}, 
{38,  35,  40,  15,  15}, 
{45,  18,  43,  17,  14}, 
{34,  38,  39,  23,  14}, 
{32,  45,  34,  42,  13}, 
{22,  43,  34,  43,  20}, 
{40,  44,  32,  37,  18}, 
{27,  44,  28,  44,  17}, 
{23,  47,  28,  38,  16}, 
{4,  49,  28,  38,  15}, 
{33,  45,  33,  39,  15}, 
{25,  45,  28,  44,  15}, 
{15,  46,  29,  42,  15}, 
{34,  45,  33,  38,  15}, 
{40,  45,  34,  36,  14}, 
{40,  45,  32,  37,  14}, 
{37,  49,  17,  41,  17}, 
{40,  48,  20,  38,  17}, 
{37,  49,  23,  38,  15}, 
{37,  48,  23,  39,  15}, 
{46,  45,  25,  37,  14}, 
{45,  46,  23,  37,  16}, 
{43,  44,  23,  39,  14}, 
{32,  45,  24,  43,  14}, 
{37,  43,  22,  45,  15}, 
{40,  44,  23,  43,  14}, 
{43,  45,  21,  42,  14}, 
{41,  49,  18,  41,  16}, 
{44,  45,  25,  38,  16}, 
{35,  44,  24,  43,  14}, 
{45,  47,  19,  39,  14}, 
{33,  45,  31,  41,  14}, 
{25,  46,  26,  43,  14}, 
{32,  46,  26,  40,  15}, 
{33,  46,  31,  36,  15}, 
{32,  48,  27,  37,  17}, 
{32,  47,  29,  37,  16}, 
{27,  47,  26,  43,  16}, 
{14,  47,  36,  33,  15}, 
{30,  46,  28,  41,  15}, 
{27,  47,  27,  43,  15}, 
{9,  48,  30,  37,  14}, 
{40,  44,  34,  37,  14}, 
{40,  43,  34,  38,  14}, 
{29,  47,  28,  40,  14}, 
{34,  44,  34,  39,  14}, 
{7,  46,  28,  45,  14}, 
{41,  45,  35,  36,  13}, 
{1,  46,  35,  36,  16}, 
{44,  35,  35,  35,  16}, 
{42,  38,  35,  35,  16}, 
{43,  39,  35,  34,  16}, 
{3,  42,  36,  36,  16}, 
{42,  45,  28,  37,  14}, 
{42,  44,  35,  33,  14}, 
{45,  33,  35,  36,  14}, 
{41,  41,  38,  34,  13}, 
{16,  44,  37,  34,  18}, 
{44,  36,  36,  34,  16}, 
{3,  35,  37,  36,  15}, 
{22,  34,  37,  37,  16}, 
{13,  38,  37,  35,  16}, 
{43,  39,  36,  34,  15}, 
{20,  46,  36,  34,  15}, 
{25,  43,  37,  34,  15}, 
{7,  34,  39,  35,  15}, 
{3,  36,  37,  37,  15}, 
{42,  43,  37,  33,  14}, 
{34,  43,  37,  34,  16}, 
{30,  34,  39,  34,  14}, 
{44,  39,  32,  44,  13}, 
{44,  40,  27,  44,  17}, 
{44,  43,  28,  38,  17}, 
{46,  37,  29,  39,  15}, 
{44,  40,  28,  43,  15}, 
{43,  42,  27,  41,  14}, 
{20,  44,  35,  40,  13}, 
{3,  43,  36,  39,  16}, 
{3,  45,  36,  38,  16}, 
{2,  42,  36,  40,  14}, 
{18,  45,  35,  39,  14}, 
{1,  46,  36,  36,  14}, 
{15,  22,  36,  48,  13}, 
{21,  23,  35,  47,  17}, 
{26,  24,  31,  48,  15}, 
{34,  24,  28,  49,  14}, 
{22,  49,  35,  32,  13}, 
{23,  49,  36,  23,  16}, 
{8,  49,  36,  31,  15}, 
{27,  49,  37,  16,  15}, 
{27,  49,  29,  33,  14}, 
{9,  49,  31,  35,  14}, 
{36,  48,  35,  16,  14}, 
{36,  48,  35,  34,  13}, 
{39,  46,  33,  31,  17}, 
{39,  47,  29,  33,  17}, 
{0,  48,  35,  35,  16}, 
{40,  48,  28,  32,  16}, 
{38,  47,  36,  25,  15}, 
{39,  46,  36,  27,  15}, 
{27,  49,  36,  21,  15}, 
{17,  49,  32,  35,  15}, 
{32,  48,  29,  37,  14}, 
{39,  46,  35,  30,  14}, 
{29,  48,  32,  35,  14}, 
{35,  48,  31,  35,  15}, 
{19,  48,  35,  35,  14}, 
{28,  49,  37,  17,  14}, 
{28,  49,  31,  34,  14}, 
{37,  46,  37,  27,  14}, 
{1,  36,  36,  46,  13}, 
{1,  41,  32,  47,  13}, 
{23,  38,  26,  47,  15}, 
{31,  36,  26,  48,  16}, 
{21,  37,  27,  47,  14}, 
{37,  41,  31,  46,  13}, 
{42,  40,  27,  45,  16}, 
{41,  41,  28,  46,  15}, 
{34,  42,  27,  45,  15}, 
{20,  37,  33,  45,  15}, 
{21,  36,  29,  47,  15}, 
{43,  39,  25,  46,  14}, 
{44,  39,  32,  45,  13}, 
{42,  41,  30,  45,  19}, 
{44,  39,  26,  46,  17}, 
{25,  31,  35,  45,  16}, 
{22,  38,  33,  45,  15}, 
{46,  24,  32,  46,  15}, 
{41,  41,  32,  45,  14}, 
{45,  36,  29,  45,  14}, 
{47,  31,  31,  45,  17}, 
{47,  37,  29,  44,  14}, 
{47,  38,  28,  43,  14}, 
{47,  38,  27,  44,  15}, 
{46,  36,  25,  47,  14}, 
{34,  33,  32,  46,  14}, 
{31,  30,  34,  46,  16}, 
{21,  35,  33,  46,  16}, 
{46,  35,  31,  42,  14}, 
{46,  40,  26,  41,  14}, 
{47,  31,  26,  48,  14}, 
{39,  36,  25,  48,  15}, 
{47,  31,  32,  45,  14}, 
{47,  33,  25,  48,  14}, 
{46,  35,  23,  48,  15}, 
{27,  30,  35,  46,  14}, 
{43,  38,  32,  46,  13}, 
{39,  40,  31,  46,  15}, 
{44,  34,  29,  47,  14}, 
{49,  29,  29,  47,  16}, 
{32,  32,  28,  48,  14}, 
{18,  33,  28,  49,  15}, 
{36,  27,  27,  49,  14}, 
{30,  32,  28,  49,  14}, 
{25,  40,  32,  46,  14}, 
{37,  39,  32,  46,  14}, 
{9,  28,  32,  48,  14}, 
{40,  42,  25,  47,  13}, 
{40,  42,  28,  45,  17}, 
{38,  39,  26,  47,  14}, 
{33,  37,  27,  47,  15}, 
{34,  35,  29,  47,  15}, 
{46,  38,  23,  47,  14}, 
{41,  39,  21,  48,  16}, 
{34,  40,  21,  49,  14}, 
{38,  35,  28,  47,  14}, 
{10,  43,  18,  49,  14}, 
{40,  40,  21,  48,  14}, 
{30,  37,  28,  47,  14}, 
{44,  39,  21,  47,  14}, 
{24,  26,  41,  39,  13}, 
{16,  32,  39,  38,  17}, 
{27,  26,  40,  39,  15}, 
{28,  4,  39,  40,  14}, 
{30,  31,  38,  40,  13}, 
{47,  0,  39,  39,  16}, 
{18,  28,  37,  42,  16}, 
{36,  20,  40,  38,  16}, 
{25,  32,  38,  39,  16}, 
{31,  27,  38,  40,  14}, 
{29,  33,  38,  35,  14}, 
{30,  32,  37,  39,  16}, 
{36,  33,  36,  37,  17}, 
{30,  33,  36,  40,  16}, 
{32,  32,  39,  36,  16}, 
{28,  32,  40,  35,  15}, 
{34,  44,  36,  35,  14}, 
{24,  44,  38,  33,  14}, 
{36,  41,  36,  35,  14}, 
{19,  39,  36,  37,  14}, 
{6,  45,  36,  39,  14}, 
{30,  32,  37,  43,  13}, 
{26,  19,  38,  44,  19}, 
{39,  4,  38,  43,  17}, 
{23,  30,  36,  45,  17}, 
{30,  23,  36,  46,  16}, 
{36,  14,  38,  44,  15}, 
{41,  0,  38,  43,  14}, 
{31,  32,  36,  42,  14}, 
{44,  29,  36,  38,  14}, 
{39,  22,  36,  41,  14}, 
{47,  9,  38,  40,  14}, 
{37,  28,  37,  38,  14}, 
{35,  24,  38,  40,  14}, 
{34,  30,  37,  39,  15}, 
{44,  47,  34,  30,  13}, 
{41,  46,  37,  23,  17}, 
{45,  47,  33,  23,  15}, 
{40,  48,  30,  30,  15}, 
{43,  48,  28,  30,  15}, 
{45,  46,  31,  26,  15}, 
{38,  48,  32,  30,  15}, 
{37,  48,  35,  28,  16}, 
{40,  47,  33,  32,  14}, 
{41,  46,  34,  34,  14}, 
{41,  46,  31,  36,  14}, 
{42,  46,  28,  37,  15}, 
{37,  49,  25,  37,  16}, 
{33,  47,  31,  37,  14}, 
{31,  48,  31,  37,  15}, 
{44,  46,  26,  37,  14}, 
{38,  47,  38,  21,  14}, 
{1,  47,  33,  37,  14}, 
{39,  47,  36,  27,  14}, 
{29,  49,  26,  38,  14}, 
{44,  46,  32,  32,  14}, 
{43,  46,  33,  33,  15}, 
{29,  47,  32,  42,  13}, 
{32,  46,  33,  37,  16}, 
{32,  46,  32,  42,  15}, 
{37,  47,  21,  42,  14}, 
{31,  48,  20,  44,  15}, 
{34,  46,  21,  45,  14}, 
{37,  48,  18,  44,  15}, 
{39,  49,  18,  43,  14}, 
{43,  45,  43,  4,  13}, 
{41,  44,  44,  2,  17}, 
{43,  45,  45,  1,  18}, 
{42,  48,  43,  1,  16}, 
{49,  34,  44,  4,  15}, 
{29,  48,  44,  2,  14}, 
{45,  41,  43,  1,  14}, 
{30,  44,  48,  1,  14}, 
{38,  43,  45,  2,  14}, 
{37,  44,  34,  42,  13}, 
{39,  43,  28,  42,  16}, 
{41,  44,  26,  41,  16}, 
{41,  43,  26,  43,  15}, 
{39,  45,  27,  39,  15}, 
{38,  47,  25,  39,  15}, 
{39,  47,  31,  35,  15}, 
{38,  43,  25,  45,  14}, 
{33,  45,  34,  42,  14}, 
{43,  43,  28,  39,  14}, 
{46,  43,  32,  32,  13}, 
{47,  41,  31,  31,  16}, 
{49,  41,  29,  32,  17}, 
{47,  42,  32,  28,  15}, 
{45,  44,  34,  26,  15}, 
{45,  38,  34,  31,  15}, 
{38,  49,  36,  24,  13}, 
{28,  48,  38,  24,  14}, 
{3,  48,  38,  30,  16}, 
{23,  49,  37,  22,  15}, 
{23,  49,  35,  33,  14}, 
{26,  48,  39,  19,  14}, 
{39,  49,  33,  24,  14}, 
{39,  48,  34,  30,  14}, 
{5,  40,  35,  43,  13}, 
{5,  42,  35,  41,  16}, 
{2,  38,  36,  42,  14}, 
{23,  15,  48,  32,  13}, 
{24,  19,  48,  29,  15}, 
{47,  30,  29,  48,  13}, 
{33,  23,  30,  49,  15}, 
{30,  30,  29,  49,  14}, 
{28,  24,  31,  49,  14}, 
{27,  35,  35,  44,  13}, 
{20,  37,  35,  41,  15}, 
{27,  36,  35,  41,  14}, 
{24,  37,  35,  39,  15}, 
{25,  37,  36,  37,  14}, 
{35,  38,  26,  48,  13}, 
{2,  41,  26,  48,  16}, 
{36,  39,  23,  48,  14}, 
{49,  48,  39,  1,  13}, 
{49,  48,  35,  2,  14}, 
{27,  30,  34,  47,  13}, 
{14,  26,  34,  48,  15}, 
{48,  44,  41,  3,  13}, 
{47,  47,  40,  3,  17}, 
{49,  41,  40,  4,  15}, 
{47,  46,  41,  3,  14}, 
{47,  45,  40,  4,  14}, 
{47,  46,  43,  2,  13}, 
{43,  46,  43,  4,  15}, 
{47,  45,  44,  1,  15}, 
{48,  45,  43,  2,  14}, 
{44,  47,  43,  2,  14}, 
{38,  46,  45,  2,  14}, 
{48,  43,  42,  3,  14}, 
{49,  42,  44,  2,  14}, 
{49,  39,  45,  2,  14}, 
{0,  47,  25,  47,  13}, 
{33,  45,  21,  46,  17}, 
{2,  31,  36,  47,  13}, 
{47,  40,  27,  41,  13}, 
{27,  31,  38,  42,  13}, 
{24,  32,  38,  41,  14}, 
{12,  29,  38,  43,  14}, 
{26,  43,  37,  35,  13}, 
{27,  37,  34,  45,  13}, 
{30,  34,  34,  45,  15}, 
{35,  34,  34,  46,  13}, 
{36,  32,  34,  46,  14}, 
{39,  28,  34,  45,  14}, 
{49,  26,  30,  48,  13}, 
{40,  27,  31,  47,  14}, 
{49,  20,  30,  49,  14}, 
{34,  30,  30,  47,  14}, 
{43,  29,  30,  47,  14}, 
{38,  34,  31,  47,  13}, 
{40,  32,  31,  47,  14}, 
{20,  33,  32,  47,  14}, 
{35,  34,  35,  40,  13}, 
{32,  33,  35,  44,  14}, 
{42,  36,  35,  39,  13}, 
{36,  27,  37,  40,  15}, 
{38,  31,  35,  40,  15}, 
{33,  35,  36,  37,  14}, 
{39,  30,  36,  39,  14}, 
{40,  30,  35,  44,  13}, 
{40,  31,  35,  42,  17}, 
{38,  28,  35,  45,  16}, 
{47,  15,  35,  45,  18}, 
{39,  18,  37,  44,  15}, 
{42,  28,  35,  43,  15}, 
{42,  30,  35,  41,  15}, 
{41,  32,  35,  40,  15}, 
{40,  34,  35,  40,  14}, 
{41,  48,  39,  11,  13}, 
{42,  49,  35,  9,  14}, 
{47,  48,  39,  6,  13}, 
{46,  49,  35,  6,  17}, 
{45,  49,  39,  3,  14}, 
{48,  49,  27,  13,  14}, 
{48,  49,  35,  0,  16}, 
{47,  49,  41,  0,  16}, 
{44,  49,  42,  1,  14}, 
{36,  42,  31,  45,  13}, 
{23,  16,  45,  36,  13}, 
{27,  40,  35,  38,  13}, 
{25,  44,  35,  37,  15}, 
{22,  40,  35,  40,  14}, 
{39,  37,  35,  39,  13}, 
{35,  38,  35,  37,  14}, 
{29,  38,  35,  39,  14}, 
{43,  41,  31,  41,  13}, 
{43,  42,  33,  36,  16}, 
{49,  46,  34,  11,  13}, 
{32,  29,  37,  43,  13}, 
{33,  23,  37,  44,  14}, 
{27,  22,  38,  44,  14}, 
{13,  29,  37,  44,  14}, 
{43,  40,  31,  45,  13}, 
{17,  36,  40,  25,  13}, 
{38,  36,  40,  15,  14}, 
{29,  37,  40,  13,  15}, 
{31,  36,  40,  20,  15}, 
{46,  42,  40,  10,  13}, 
{48,  44,  40,  5,  16}, 
{47,  43,  40,  6,  14}, 
{34,  48,  41,  15,  13}, 
{10,  36,  42,  17,  16}, 
{37,  43,  41,  9,  16}, 
{37,  48,  37,  19,  16}, 
{46,  43,  40,  9,  15}, 
{14,  37,  40,  22,  15}, 
{38,  36,  41,  14,  15}, 
{38,  45,  40,  10,  15}, 
{22,  49,  40,  12,  15}, 
{38,  49,  37,  14,  15}, 
{39,  48,  42,  4,  15}, 
{46,  42,  40,  11,  14}, 
{36,  45,  40,  14,  17}, 
{38,  38,  41,  14,  16}, 
{35,  46,  41,  12,  15}, 
{33,  34,  42,  23,  14}, 
{25,  40,  40,  16,  14}, 
{14,  48,  42,  7,  14}, 
{39,  44,  41,  8,  14}, 
{45,  49,  37,  6,  14}, 
{47,  49,  36,  6,  14}, 
{49,  49,  29,  1,  14}, 
{39,  43,  42,  13,  13}, 
{38,  44,  42,  9,  17}, 
{26,  43,  42,  14,  16}, 
{39,  41,  41,  14,  16}, 
{49,  22,  44,  14,  15}, 
{44,  13,  44,  31,  15}, 
{41,  44,  42,  6,  14}, 
{46,  43,  41,  6,  14}, 
{47,  44,  41,  5,  15}, 
{40,  23,  42,  27,  14}, 
{49,  39,  42,  6,  14}, 
{44,  19,  43,  24,  14}, 
{33,  28,  43,  27,  16}, 
{33,  23,  43,  33,  14}, 
{42,  22,  44,  23,  14}, 
{22,  46,  40,  22,  13}, 
{25,  43,  40,  19,  15}, 
{18,  48,  40,  19,  15}, 
{8,  47,  41,  16,  14}, 
{26,  46,  39,  22,  14}, 
{26,  47,  39,  21,  14}, 
{43,  38,  43,  6,  13}, 
{37,  37,  43,  13,  13}, 
{43,  37,  43,  7,  15}, 
{49,  35,  43,  8,  15}, 
{33,  31,  44,  16,  14}, 
{31,  33,  44,  12,  15}, 
{38,  33,  43,  14,  14}, 
{40,  35,  43,  12,  15}, 
{49,  31,  44,  10,  14}, 
{40,  45,  43,  6,  13}, 
{42,  47,  40,  7,  15}, 
{34,  46,  43,  6,  14}, 
{25,  41,  39,  25,  13}, 
{37,  40,  39,  23,  13}, 
{41,  41,  25,  47,  13}, 
{47,  39,  19,  47,  13}, 
{49,  38,  35,  22,  13}, 
{45,  44,  36,  20,  13}, 
{25,  47,  41,  16,  13}, 
{22,  40,  41,  17,  14}, 
{20,  38,  42,  17,  14}, 
{24,  45,  40,  21,  14}, 
{21,  37,  41,  18,  14}, 
{13,  35,  41,  27,  14}, 
{45,  36,  31,  42,  13}, 
{24,  44,  38,  34,  13}, 
{45,  42,  15,  45,  13}, 
{45,  41,  19,  45,  14}, 
{45,  44,  21,  41,  15}, 
{44,  44,  25,  39,  14}, 
{44,  42,  25,  42,  15}, 
{42,  49,  39,  8,  13}, 
{38,  49,  39,  11,  14}, 
{4,  23,  39,  40,  13}, 
{46,  40,  28,  40,  13}, 
{46,  39,  29,  40,  14}, 
{46,  44,  28,  36,  13}, 
{47,  42,  27,  36,  15}, 
{45,  44,  28,  37,  14}, 
{49,  41,  29,  40,  13}, 
{44,  41,  31,  41,  18}, 
{45,  42,  30,  35,  16}, 
{45,  41,  30,  39,  15}, 
{44,  41,  29,  43,  14}, 
{47,  43,  23,  39,  14}, 
{49,  43,  23,  40,  13}, 
{49,  43,  12,  42,  15}, 
{44,  42,  29,  42,  13}, 
{44,  43,  28,  40,  15}, 
{43,  42,  29,  44,  14}, 
{44,  43,  23,  43,  14}, 
{43,  45,  31,  37,  13}, 
{46,  43,  29,  36,  15}, 
{44,  43,  31,  38,  14}, 
{44,  44,  30,  38,  14}, 
{43,  44,  29,  39,  14}, 
{43,  45,  33,  36,  13}, 
{49,  46,  30,  17,  13}, 
{30,  46,  35,  36,  13}, 
{40,  46,  27,  39,  13}, 
{26,  22,  32,  49,  13}, 
{47,  41,  32,  32,  13}, 
{43,  38,  21,  48,  13}, 
{45,  37,  23,  48,  13}, 
{38,  47,  38,  23,  13}, 
{48,  49,  30,  12,  13}, 
{29,  34,  40,  34,  13}, 
{44,  42,  34,  34,  13}, 
{43,  43,  35,  33,  14}, 
{45,  47,  36,  17,  13}, 
{44,  46,  35,  21,  14}, 
{44,  47,  36,  19,  14}, 
{44,  46,  39,  17,  14}, 
{42,  44,  34,  37,  13}, 
{38,  47,  35,  32,  13}, 
{28,  35,  39,  31,  13}, 
{27,  27,  40,  39,  13}, 
{21,  38,  41,  19,  13}, 
{45,  30,  26,  49,  13}, 
{32,  48,  29,  38,  13}, 
{31,  47,  30,  42,  15}, 
{36,  40,  22,  48,  13}, 
{49,  46,  8,  42,  13}, 
{49,  46,  6,  44,  14}, 
{47,  46,  34,  17,  13}, 
{47,  44,  35,  17,  14}, 
{46,  44,  35,  20,  13}, 
{49,  40,  36,  19,  16}, 
{27,  44,  29,  43,  13}, 
{15,  44,  34,  43,  14}, 
{3,  44,  30,  45,  13}, 
{3,  44,  32,  44,  13}, 
{49,  47,  37,  3,  13}, 
{6,  48,  36,  35,  13}, 
{26,  48,  44,  3,  13}, 
{2,  48,  23,  46,  13}, 
{49,  31,  34,  39,  13}, 
{45,  46,  27,  33,  13}, 
{45,  45,  30,  32,  13}, 
{33,  47,  31,  39,  13}, 
{45,  46,  34,  24,  13}, 
{47,  44,  15,  42,  13}, 
{46,  43,  23,  42,  13}, 
{45,  24,  35,  43,  13}, 
{29,  47,  27,  43,  13}, 
{29,  44,  28,  44,  13}, 
{47,  43,  35,  19,  13}, 
{48,  46,  43,  0,  13}, 
{46,  39,  40,  12,  13}, 
{47,  49,  38,  2,  13}, 
{18,  48,  38,  28,  13}, 
{38,  48,  36,  26,  14}, 
{18,  49,  37,  28,  13}, 
{41,  11,  40,  39,  13}, 
{46,  0,  41,  38,  13}, 
{19,  48,  39,  22,  13}, 
{44,  40,  29,  45,  13}, 
{43,  43,  27,  41,  13}, 
{37,  46,  33,  36,  13}, 
{42,  40,  21,  48,  13}, 
{42,  40,  18,  49,  13}, 
{37,  49,  20,  42,  13}, 
{37,  32,  33,  46,  13}, 
{39,  30,  34,  45,  13}, 
{37,  31,  34,  46,  14}, 
{45,  47,  42,  3,  13}, 
{47,  48,  43,  1,  13}, 
{26,  34,  39,  35,  13}, 
{23,  34,  40,  35,  13}, 
{39,  36,  41,  15,  13}, 
{16,  38,  36,  39,  13}, 
{20,  31,  42,  33,  13}, 
{5,  28,  34,  48,  13}, 
{0,  38,  28,  48,  13}, 
{47,  38,  29,  42,  13}, 
{45,  35,  31,  45,  13}, 
{44,  41,  32,  37,  13}, 
{42,  45,  29,  38,  13}, 
{43,  38,  23,  48,  13}, 
{44,  31,  35,  39,  13}, 
{43,  28,  33,  45,  13}, 
{49,  39,  34,  26,  13}, 
{39,  29,  35,  45,  13}, 
{41,  28,  35,  45,  13}, 
{40,  43,  19,  46,  13}, 
{45,  46,  12,  44,  13}, 
{45,  46,  21,  41,  15}, 
{46,  46,  19,  41,  13}, 
{44,  49,  16,  41,  13}, 
{47,  49,  12,  40,  13}, 
{46,  45,  21,  42,  13}, 
{28,  47,  33,  37,  13}, 
{32,  48,  38,  23,  13}, 
{30,  49,  37,  24,  14}, 
{37,  49,  37,  21,  14}, 
{24,  49,  37,  27,  13}, 
{39,  47,  7,  48,  13}, 
{0,  48,  18,  48,  13}, 
{38,  27,  40,  33,  13}, 
{47,  24,  40,  34,  13}, 
{43,  21,  44,  27,  16}, 
{44,  39,  39,  19,  14}, 
{44,  19,  41,  34,  14}, 
{44,  17,  43,  33,  14}, 
{45,  39,  40,  15,  13}, 
{40,  33,  41,  17,  14}, 
{44,  37,  40,  18,  13}, 
{45,  39,  40,  16,  16}, 
{36,  34,  41,  22,  16}, 
{36,  37,  40,  20,  15}, 
{30,  41,  41,  16,  14}, 
{42,  38,  40,  18,  14}, 
{30,  45,  40,  18,  13}, 
{36,  43,  41,  16,  13}, 
{38,  43,  40,  18,  13}, 
{45,  40,  40,  16,  14}, 
{38,  40,  41,  16,  14}, 
{38,  40,  40,  27,  13}, 
{25,  41,  40,  26,  18}, 
{39,  33,  39,  28,  17}, 
{22,  41,  39,  28,  17}, 
{34,  34,  41,  27,  16}, 
{39,  40,  39,  24,  16}, 
{35,  33,  40,  30,  16}, 
{28,  43,  40,  22,  15}, 
{33,  33,  40,  33,  15}, 
{38,  29,  41,  26,  15}, 
{27,  37,  40,  28,  15}, 
{40,  40,  39,  26,  14}, 
{47,  31,  39,  25,  15}, 
{20,  41,  40,  28,  14}, 
{20,  42,  39,  27,  14}, 
{35,  36,  40,  28,  14}, 
{34,  40,  39,  28,  14}, 
{30,  45,  40,  20,  14}, 
{43,  45,  39,  19,  13}, 
{36,  45,  40,  19,  15}, 
{32,  43,  40,  22,  13}, 
{40,  41,  39,  22,  14}, 
{36,  45,  40,  20,  13}, 
{37,  43,  40,  21,  15}, 
{39,  41,  40,  22,  13}, 
{40,  29,  41,  26,  15}, 
{47,  27,  40,  32,  13}, 
{40,  29,  39,  33,  13}, 
{38,  33,  40,  33,  13}, 
{30,  35,  40,  30,  13}, 
{47,  31,  40,  23,  13}, 
{40,  32,  39,  33,  13}, 
{44,  14,  44,  34,  13}, 
{44,  23,  44,  23,  13}, 
{41,  35,  43,  13,  13}, 
{45,  35,  43,  11,  13}, 
{44,  36,  43,  11,  13}, 
{40,  43,  42,  9,  14}, 
{41,  38,  41,  14,  14}, 
{41,  25,  44,  20,  13}, 
{37,  26,  43,  25,  14}, 
{18,  35,  41,  30,  13}, 
{26,  35,  42,  26,  13}, 
{20,  37,  42,  20,  16}, 
{32,  35,  41,  25,  13}, 
{33,  44,  40,  22,  13}, 
{34,  45,  40,  21,  13}, 
{34,  46,  39,  21,  13}, 
{26,  31,  35,  46,  13}, 
{37,  45,  41,  12,  13}, 
{27,  31,  39,  38,  13}, 
{24,  36,  26,  49,  13}, 
{28,  26,  31,  49,  13}, 
{35,  35,  41,  22,  13}, 
{15,  34,  35,  45,  13}, 
{24,  33,  35,  45,  13}, 
{24,  32,  35,  46,  13}, 
{17,  33,  38,  38,  13}, 
{6,  33,  30,  49,  13}, 
{5,  31,  34,  48,  13}, 
{6,  33,  32,  48,  14}, 
{46,  45,  27,  36,  13}, 
{38,  45,  28,  40,  13}, 
{41,  45,  22,  43,  13}, 
{35,  45,  32,  40,  13}, 
{40,  48,  18,  44,  13}, 
{49,  44,  23,  33,  13}, 
{48,  44,  28,  26,  15}, 
{45,  48,  21,  33,  13}, 
{49,  39,  35,  22,  13}, 
{45,  44,  36,  31,  13}, 
{49,  39,  35,  26,  18}, 
{46,  39,  35,  28,  15}, 
{46,  40,  35,  27,  15}, 
{46,  42,  35,  23,  15}, 
{45,  38,  38,  25,  14}, 
{46,  39,  36,  27,  14}, 
{45,  44,  33,  32,  13}, 
{45,  39,  36,  32,  13}, 
{49,  39,  34,  32,  13}, 
{49,  37,  35,  31,  13}, 
{45,  41,  12,  47,  13}, 
{44,  40,  19,  47,  14}, 
{49,  38,  38,  19,  13}, 
{49,  38,  37,  23,  14}, 
{32,  34,  35,  42,  13}, 
{30,  30,  39,  38,  13}, 
{42,  23,  43,  28,  13}, 
{27,  26,  32,  48,  13}, 
{21,  26,  34,  48,  13}, 
{37,  33,  42,  17,  13}, 
{41,  31,  44,  15,  14}, 
{29,  48,  46,  1,  13}, 
{38,  48,  45,  2,  13}, 
{15,  36,  41,  25,  13}, 
{43,  45,  41,  36,  12}, 
{44,  36,  38,  36,  19}, 
{46,  45,  41,  7,  18}, 
{30,  30,  41,  37,  17}, 
{45,  41,  40,  17,  16}, 
{44,  36,  39,  31,  16}, 
{23,  44,  36,  37,  15}, 
{28,  34,  38,  37,  15}, 
{44,  45,  40,  13,  15}, 
{46,  45,  40,  11,  16}, 
{45,  14,  39,  39,  15}, 
{47,  21,  40,  37,  15}, 
{45,  39,  42,  9,  15}, 
{40,  35,  36,  37,  15}, 
{30,  32,  42,  34,  15}, 
{38,  47,  39,  21,  14}, 
{21,  38,  37,  37,  14}, 
{44,  40,  38,  33,  14}, 
{45,  36,  41,  18,  14}, 
{30,  36,  37,  37,  14}, 
{44,  32,  41,  36,  14}, 
{28,  33,  38,  38,  14}, 
{45,  47,  38,  17,  14}, 
{9,  47,  41,  20,  14}, 
{10,  47,  40,  29,  14}, 
{28,  46,  39,  28,  15}, 
{46,  32,  40,  35,  14}, 
{42,  26,  42,  31,  14}, 
{43,  42,  42,  9,  14}, 
{43,  44,  43,  5,  14}, 
{39,  13,  44,  36,  14}, 
{46,  11,  45,  35,  13}, 
{42,  16,  48,  21,  15}, 
{46,  11,  44,  36,  14}, 
{35,  47,  40,  21,  13}, 
{27,  46,  40,  28,  15}, 
{26,  48,  40,  21,  14}, 
{28,  34,  39,  37,  13}, 
{11,  35,  40,  37,  13}, 
{28,  34,  40,  37,  14}, 
{10,  34,  41,  37,  14}, 
{34,  31,  41,  37,  13}, 
{34,  28,  40,  38,  16}, 
{43,  13,  44,  37,  13}, 
{24,  15,  45,  37,  13}, 
{44,  17,  41,  38,  13}, 
{44,  39,  39,  29,  13}, 
{39,  48,  40,  11,  13}, 
{38,  46,  41,  14,  15}, 
{46,  47,  40,  8,  13}, 
{42,  35,  36,  37,  13}, 
{36,  37,  36,  37,  13}, 
{44,  46,  42,  6,  13}, 
{41,  24,  38,  38,  13}, 
{39,  28,  40,  38,  13}, 
{41,  28,  41,  37,  15}, 
{39,  30,  39,  38,  13}, 
{39,  30,  41,  37,  13}, 
{40,  22,  42,  37,  13}, 
{47,  7,  39,  40,  13}, 
{44,  39,  37,  34,  13}, 
{46,  36,  39,  24,  13}, 
{22,  47,  36,  35,  13}, 
{35,  46,  37,  30,  13}, 
{29,  47,  36,  34,  16}, 
{33,  46,  36,  35,  13}, 
{44,  44,  42,  8,  13}, 
{30,  29,  43,  34,  13}, 
{44,  32,  44,  13,  13}, 
{38,  32,  44,  16,  13}, 
{26,  32,  43,  19,  13}, 
{33,  31,  43,  23,  13}, 
{9,  46,  41,  25,  13}, 
{38,  47,  36,  29,  13}, 
{41,  23,  41,  38,  13}, 
{49,  26,  44,  18,  13}, 
{46,  17,  42,  36,  13}, 
{46,  19,  43,  30,  15}, 
{47,  21,  44,  24,  14}, 
{45,  23,  41,  37,  14}, 
{47,  9,  43,  36,  14}, 
{48,  0,  45,  34,  15}, 
{47,  23,  41,  37,  14}, 
{46,  15,  45,  30,  13}, 
{49,  18,  47,  18,  13}, 
{31,  30,  43,  26,  13}, 
{43,  46,  40,  14,  13}, 
{30,  32,  42,  35,  13}, 
{26,  32,  42,  36,  13}, 
{49,  7,  43,  36,  13}, 
{22,  33,  39,  38,  13}, 
{9,  47,  39,  30,  13}, 
{43,  44,  35,  44,  12}, 
{44,  35,  34,  40,  17}, 
{44,  31,  35,  43,  16}, 
{46,  32,  34,  44,  17}, 
{0,  38,  36,  44,  15}, 
{33,  45,  30,  43,  14}, 
{7,  46,  29,  45,  15}, 
{33,  45,  29,  44,  14}, 
{42,  45,  23,  44,  15}, 
{44,  35,  35,  38,  14}, 
{43,  39,  34,  45,  13}, 
{43,  40,  33,  45,  14}, 
{8,  41,  34,  45,  16}, 
{46,  35,  34,  44,  13}, 
{32,  45,  32,  44,  13}, 
{2,  44,  36,  42,  13}, 
{40,  46,  19,  45,  13}, 
{0,  37,  36,  45,  13}, 
{42,  45,  29,  40,  13}, 
{42,  45,  28,  44,  13}, 
{44,  41,  33,  37,  13}, 
{45,  42,  34,  36,  13}, 
{45,  38,  32,  42,  15}, 
{45,  37,  33,  40,  16}, 
{45,  38,  30,  45,  13}, 
{47,  38,  29,  44,  14}, 
{45,  37,  34,  39,  13}, 
{44,  37,  34,  42,  16}, 
{44,  41,  35,  37,  13}, 
{44,  42,  36,  35,  14}, 
{44,  45,  36,  34,  14}, 
{44,  45,  34,  36,  14}, 
{44,  36,  35,  40,  13}, 
{45,  43,  21,  44,  13}, 
{44,  48,  8,  47,  13}, 
{47,  39,  21,  45,  13}, 
{45,  35,  37,  34,  13}, 
{21,  41,  34,  45,  13}, 
{35,  40,  34,  45,  14}, 
{12,  45,  30,  45,  13}, 
{12,  45,  24,  46,  13}, 
{34,  43,  25,  46,  14}, 
{2,  39,  36,  44,  13}, 
{44,  46,  32,  34,  13}, 
{39,  46,  21,  45,  13}, 
{49,  46,  32,  44,  12}, 
{38,  45,  33,  42,  15}, 
{44,  45,  34,  37,  16}, 
{25,  47,  28,  44,  15}, 
{49,  34,  34,  44,  14}, 
{46,  47,  34,  21,  14}, 
{47,  47,  30,  22,  15}, 
{47,  46,  35,  18,  15}, 
{48,  47,  32,  21,  14}, 
{45,  42,  34,  37,  14}, 
{45,  43,  34,  36,  14}, 
{47,  38,  34,  34,  14}, 
{46,  47,  28,  28,  14}, 
{48,  49,  12,  40,  14}, 
{35,  47,  32,  37,  14}, 
{31,  47,  27,  44,  14}, 
{45,  40,  31,  45,  13}, 
{29,  47,  31,  43,  13}, 
{9,  47,  29,  45,  14}, 
{49,  43,  33,  23,  13}, 
{49,  46,  34,  21,  13}, 
{49,  42,  35,  21,  17}, 
{49,  42,  34,  23,  14}, 
{49,  41,  33,  32,  13}, 
{46,  44,  33,  32,  13}, 
{46,  42,  35,  29,  14}, 
{46,  43,  34,  32,  15}, 
{47,  44,  34,  24,  15}, 
{46,  46,  34,  27,  15}, 
{46,  44,  35,  29,  13}, 
{49,  45,  34,  24,  13}, 
{48,  48,  30,  17,  13}, 
{38,  45,  34,  40,  13}, 
{35,  47,  33,  37,  13}, 
{31,  47,  33,  39,  13}, 
{37,  46,  33,  39,  14}, 
{32,  46,  33,  40,  14}, 
{33,  48,  35,  35,  13}, 
{14,  46,  35,  38,  13}, 
{40,  46,  33,  38,  13}, 
{33,  47,  30,  41,  13}, 
{37,  48,  23,  41,  13}, 
{46,  42,  15,  45,  13}, 
{48,  47,  27,  25,  13}, 
{48,  47,  23,  33,  14}, 
{32,  48,  25,  40,  13}, 
{39,  47,  33,  35,  13}, 
{45,  48,  18,  42,  13}, 
{45,  49,  19,  39,  13}, 
{33,  47,  34,  36,  13}, 
{4,  47,  34,  39,  14}, 
{41,  49,  23,  35,  13}, 
{40,  49,  24,  37,  13}, 
{47,  48,  28,  20,  13}, 
{41,  37,  40,  39,  12}, 
{42,  35,  37,  39,  18}, 
{30,  38,  37,  38,  16}, 
{33,  33,  36,  41,  15}, 
{23,  43,  36,  38,  15}, 
{2,  34,  38,  40,  15}, 
{19,  33,  38,  41,  15}, 
{44,  29,  37,  39,  14}, 
{42,  31,  41,  37,  14}, 
{47,  22,  36,  40,  14}, 
{44,  27,  36,  40,  14}, 
{35,  28,  38,  40,  14}, 
{35,  33,  37,  40,  14}, 
{25,  38,  39,  39,  13}, 
{45,  17,  41,  39,  13}, 
{32,  41,  36,  38,  13}, 
{29,  43,  36,  38,  14}, 
{35,  34,  37,  40,  13}, 
{9,  39,  36,  44,  15}, 
{42,  34,  36,  40,  13}, 
{19,  33,  38,  42,  13}, 
{10,  33,  38,  43,  13}, 
{8,  38,  36,  45,  13}, 
{38,  32,  37,  40,  13}, 
{33,  32,  37,  41,  13}, 
{41,  31,  37,  40,  13}, 
{33,  31,  37,  42,  13}, 
{16,  36,  36,  42,  13}, 
{31,  35,  37,  40,  14}, 
{25,  35,  38,  40,  15}, 
{33,  29,  41,  43,  12}, 
{37,  14,  41,  43,  18}, 
{13,  30,  41,  40,  15}, 
{39,  20,  41,  40,  15}, 
{43,  0,  41,  41,  14}, 
{45,  17,  41,  40,  14}, 
{41,  28,  41,  38,  14}, 
{38,  15,  41,  43,  14}, 
{25,  25,  39,  44,  13}, 
{33,  27,  37,  44,  14}, 
{38,  16,  39,  44,  14}, 
{26,  30,  41,  40,  13}, 
{47,  0,  38,  42,  13}, 
{39,  23,  41,  40,  13}, 
{31,  26,  36,  45,  13}, 
{33,  31,  38,  41,  13}, 
{33,  26,  38,  44,  13}, 
{6,  31,  40,  40,  13}, 
{42,  17,  36,  43,  13}, 
{42,  0,  40,  43,  13}, 
{43,  44,  45,  12,  12}, 
{39,  42,  43,  13,  19}, 
{34,  46,  45,  5,  17}, 
{32,  27,  45,  20,  16}, 
{22,  27,  46,  18,  16}, 
{32,  31,  45,  20,  15}, 
{10,  48,  44,  7,  15}, 
{37,  32,  47,  5,  14}, 
{37,  32,  46,  7,  14}, 
{36,  26,  47,  12,  16}, 
{19,  40,  43,  14,  14}, 
{37,  44,  46,  3,  13}, 
{40,  39,  46,  4,  18}, 
{33,  43,  47,  3,  17}, 
{35,  39,  46,  5,  14}, 
{40,  34,  46,  7,  14}, 
{39,  46,  43,  7,  13}, 
{27,  41,  48,  3,  13}, 
{41,  40,  43,  13,  13}, 
{43,  44,  42,  13,  15}, 
{39,  39,  48,  1,  13}, 
{33,  48,  45,  3,  13}, 
{49,  43,  36,  36,  12}, 
{47,  44,  35,  26,  15}, 
{47,  25,  35,  44,  15}, 
{49,  37,  34,  39,  15}, 
{49,  29,  38,  37,  14}, 
{49,  46,  34,  26,  13}, 
{47,  17,  36,  44,  13}, 
{47,  4,  36,  45,  14}, 
{49,  44,  38,  16,  13}, 
{49,  45,  37,  14,  13}, 
{46,  47,  36,  18,  13}, 
{46,  44,  36,  31,  14}, 
{49,  35,  37,  36,  13}, 
{49,  41,  38,  17,  13}, 
{47,  42,  37,  19,  13}, 
{47,  41,  39,  18,  15}, 
{49,  40,  37,  24,  13}, 
{43,  46,  29,  46,  12}, 
{45,  42,  28,  45,  17}, 
{6,  43,  28,  47,  15}, 
{44,  42,  24,  46,  15}, 
{42,  39,  31,  46,  14}, 
{44,  46,  21,  45,  14}, 
{19,  42,  31,  46,  14}, 
{28,  46,  17,  47,  13}, 
{38,  47,  15,  47,  13}, 
{44,  46,  12,  47,  16}, 
{37,  47,  17,  47,  14}, 
{20,  47,  27,  46,  15}, 
{40,  43,  22,  47,  13}, 
{35,  49,  12,  47,  13}, 
{45,  45,  21,  45,  13}, 
{24,  47,  15,  48,  13}, 
{45,  41,  30,  45,  13}, 
{44,  41,  32,  45,  14}, 
{40,  44,  40,  37,  12}, 
{26,  45,  37,  37,  14}, 
{24,  45,  35,  42,  13}, 
{4,  46,  35,  40,  13}, 
{31,  38,  39,  38,  13}, 
{25,  46,  35,  37,  13}, 
{38,  47,  41,  29,  12}, 
{46,  47,  41,  6,  16}, 
{39,  48,  42,  7,  16}, 
{33,  47,  37,  31,  14}, 
{9,  46,  40,  32,  14}, 
{25,  48,  40,  23,  14}, 
{36,  48,  40,  16,  14}, 
{37,  48,  37,  25,  14}, 
{35,  48,  38,  25,  14}, 
{33,  48,  41,  21,  13}, 
{39,  47,  41,  23,  13}, 
{43,  46,  39,  21,  14}, 
{41,  46,  40,  23,  14}, 
{28,  49,  37,  27,  13}, 
{28,  49,  35,  33,  13}, 
{15,  48,  38,  31,  13}, 
{22,  49,  37,  30,  14}, 
{42,  46,  41,  14,  13}, 
{46,  46,  37,  18,  13}, 
{42,  47,  40,  17,  13}, 
{45,  28,  40,  43,  12}, 
{49,  27,  36,  41,  17}, 
{38,  31,  36,  42,  16}, 
{39,  22,  41,  43,  16}, 
{43,  26,  37,  44,  15}, 
{45,  28,  41,  38,  15}, 
{42,  34,  39,  39,  15}, 
{45,  35,  35,  39,  14}, 
{45,  31,  35,  44,  13}, 
{44,  29,  36,  41,  13}, 
{39,  33,  36,  41,  14}, 
{42,  32,  36,  41,  14}, 
{47,  27,  38,  42,  13}, 
{45,  27,  36,  44,  13}, 
{49,  20,  41,  38,  13}, 
{37,  25,  41,  41,  13}, 
{47,  27,  40,  41,  13}, 
{41,  41,  29,  47,  12}, 
{14,  37,  31,  47,  13}, 
{33,  35,  31,  47,  14}, 
{24,  38,  30,  47,  14}, 
{9,  40,  32,  47,  14}, 
{22,  38,  31,  47,  13}, 
{16,  43,  28,  47,  13}, 
{43,  38,  34,  46,  12}, 
{29,  39,  34,  46,  18}, 
{47,  21,  35,  46,  14}, 
{29,  40,  33,  46,  13}, 
{49,  21,  35,  46,  13}, 
{48,  49,  38,  12,  12}, 
{44,  49,  39,  12,  15}, 
{47,  48,  38,  13,  14}, 
{46,  49,  39,  9,  14}, 
{45,  49,  34,  14,  14}, 
{43,  48,  39,  14,  14}, 
{38,  49,  39,  16,  13}, 
{46,  48,  34,  16,  13}, 
{41,  49,  32,  19,  13}, 
{40,  49,  39,  14,  13}, 
{40,  38,  28,  48,  12}, 
{49,  31,  28,  48,  16}, 
{46,  36,  24,  48,  14}, 
{43,  31,  29,  48,  14}, 
{47,  43,  43,  12,  12}, 
{48,  44,  40,  10,  17}, 
{48,  44,  41,  8,  17}, 
{48,  43,  43,  5,  15}, 
{46,  44,  42,  11,  14}, 
{46,  47,  42,  6,  14}, 
{49,  28,  41,  38,  13}, 
{49,  39,  41,  14,  13}, 
{45,  43,  44,  5,  13}, 
{49,  42,  42,  10,  13}, 
{21,  19,  36,  49,  12}, 
{26,  20,  34,  49,  14}, 
{23,  22,  35,  48,  14}, 
{27,  17,  35,  48,  13}, 
{37,  37,  35,  45,  12}, 
{28,  32,  35,  46,  14}, 
{36,  30,  35,  46,  13}, 
{41,  28,  35,  46,  16}, 
{35,  43,  38,  38,  12}, 
{36,  40,  38,  38,  15}, 
{41,  38,  37,  38,  16}, 
{40,  42,  36,  38,  13}, 
{38,  44,  36,  38,  13}, 
{31,  48,  42,  17,  12}, 
{31,  45,  43,  11,  16}, 
{44,  45,  42,  12,  14}, 
{41,  45,  43,  10,  15}, 
{29,  36,  42,  26,  14}, 
{32,  39,  43,  14,  14}, 
{40,  47,  42,  11,  14}, 
{39,  46,  43,  10,  14}, 
{36,  46,  45,  9,  14}, 
{40,  35,  42,  17,  14}, 
{39,  38,  42,  16,  14}, 
{34,  46,  45,  10,  14}, 
{7,  48,  45,  8,  14}, 
{38,  48,  42,  12,  13}, 
{36,  48,  41,  19,  14}, 
{45,  39,  42,  14,  13}, 
{40,  48,  41,  12,  13}, 
{49,  43,  34,  39,  12}, 
{44,  44,  33,  42,  17}, 
{44,  44,  34,  41,  16}, 
{44,  39,  35,  39,  15}, 
{49,  40,  33,  40,  15}, 
{44,  42,  33,  44,  14}, 
{44,  39,  34,  45,  13}, 
{45,  31,  34,  46,  17}, 
{49,  30,  30,  47,  14}, 
{49,  40,  34,  40,  13}, 
{49,  31,  34,  45,  13}, 
{44,  42,  35,  38,  13}, 
{43,  46,  31,  45,  12}, 
{13,  44,  34,  45,  13}, 
{21,  46,  32,  45,  16}, 
{17,  44,  34,  45,  13}, 
{28,  43,  32,  45,  13}, 
{47,  13,  44,  38,  12}, 
{20,  27,  43,  38,  18}, 
{49,  18,  42,  37,  13}, 
{46,  19,  43,  34,  13}, 
{36,  33,  31,  48,  12}, 
{27,  32,  32,  48,  17}, 
{49,  23,  31,  48,  14}, 
{33,  29,  30,  49,  13}, 
{32,  21,  32,  49,  13}, 
{49,  5,  33,  47,  13}, 
{49,  44,  36,  31,  12}, 
{48,  46,  34,  28,  15}, 
{47,  44,  37,  19,  13}, 
{46,  44,  38,  19,  13}, 
{46,  46,  39,  17,  13}, 
{46,  44,  39,  18,  13}, 
{47,  26,  34,  47,  12}, 
{48,  31,  32,  46,  14}, 
{40,  32,  32,  47,  13}, 
{46,  25,  35,  46,  13}, 
{42,  34,  41,  38,  12}, 
{24,  33,  41,  39,  15}, 
{49,  31,  38,  41,  12}, 
{39,  30,  37,  43,  15}, 
{49,  31,  40,  38,  13}, 
{48,  45,  36,  28,  12}, 
{47,  46,  39,  17,  14}, 
{48,  46,  36,  20,  13}, 
{48,  47,  36,  18,  15}, 
{48,  46,  35,  21,  13}, 
{49,  45,  36,  18,  13}, 
{26,  32,  38,  44,  12}, 
{38,  28,  37,  44,  14}, 
{20,  28,  39,  44,  14}, 
{44,  45,  39,  31,  12}, 
{46,  43,  39,  19,  13}, 
{0,  36,  38,  43,  12}, 
{25,  36,  38,  40,  14}, 
{5,  34,  37,  44,  13}, 
{42,  34,  37,  41,  12}, 
{26,  33,  38,  42,  15}, 
{9,  34,  38,  44,  13}, 
{6,  39,  36,  46,  12}, 
{33,  39,  31,  47,  12}, 
{35,  37,  31,  47,  15}, 
{40,  37,  30,  47,  13}, 
{49,  49,  38,  1,  12}, 
{49,  49,  33,  2,  13}, 
{41,  40,  24,  48,  12}, 
{46,  39,  37,  35,  12}, 
{49,  38,  37,  36,  15}, 
{32,  38,  29,  48,  12}, 
{10,  42,  25,  49,  12}, 
{2,  42,  28,  48,  14}, 
{20,  38,  25,  49,  13}, 
{47,  39,  30,  45,  12}, 
{46,  37,  26,  46,  14}, 
{46,  42,  28,  45,  13}, 
{35,  47,  41,  30,  12}, 
{25,  46,  39,  36,  12}, 
{20,  46,  40,  34,  16}, 
{38,  46,  37,  32,  13}, 
{35,  46,  39,  34,  13}, 
{6,  46,  37,  38,  13}, 
{34,  47,  38,  34,  12}, 
{18,  48,  38,  33,  15}, 
{37,  47,  37,  32,  14}, 
{23,  47,  38,  35,  14}, 
{20,  47,  38,  37,  12}, 
{4,  47,  36,  39,  15}, 
{25,  47,  37,  36,  13}, 
{33,  47,  38,  35,  13}, 
{32,  46,  38,  36,  13}, 
{37,  33,  42,  31,  12}, 
{36,  30,  43,  22,  13}, 
{33,  29,  43,  32,  13}, 
{40,  34,  42,  21,  13}, 
{49,  31,  42,  23,  13}, 
{39,  33,  42,  28,  13}, 
{47,  45,  34,  36,  12}, 
{48,  46,  34,  30,  17}, 
{47,  44,  34,  39,  13}, 
{48,  44,  36,  35,  12}, 
{49,  44,  34,  37,  15}, 
{45,  45,  35,  35,  13}, 
{14,  31,  41,  43,  12}, 
{38,  32,  40,  41,  12}, 
{27,  31,  39,  43,  16}, 
{42,  32,  39,  40,  15}, 
{20,  31,  39,  44,  13}, 
{45,  40,  38,  33,  12}, 
{49,  36,  39,  31,  13}, 
{46,  40,  37,  32,  13}, 
{46,  35,  38,  39,  12}, 
{44,  40,  36,  37,  15}, 
{49,  34,  36,  40,  14}, 
{3,  38,  39,  40,  12}, 
{15,  33,  40,  41,  15}, 
{25,  38,  37,  40,  13}, 
{20,  38,  36,  42,  15}, 
{20,  36,  38,  41,  14}, 
{25,  38,  36,  41,  13}, 
{30,  35,  37,  41,  13}, 
{26,  33,  39,  41,  13}, 
{20,  34,  40,  40,  14}, 
{28,  46,  33,  44,  12}, 
{26,  47,  33,  42,  14}, 
{11,  45,  35,  44,  13}, 
{21,  48,  42,  19,  12}, 
{44,  8,  36,  47,  12}, 
{39,  21,  36,  46,  13}, 
{49,  10,  36,  46,  13}, 
{20,  49,  42,  16,  12}, 
{40,  49,  42,  11,  12}, 
{47,  41,  39,  21,  12}, 
{46,  44,  38,  21,  13}, 
{45,  45,  39,  20,  13}, 
{46,  44,  37,  27,  12}, 
{47,  43,  37,  26,  16}, 
{45,  41,  38,  29,  14}, 
{39,  45,  15,  48,  12}, 
{25,  28,  35,  47,  12}, 
{31,  25,  35,  47,  13}, 
{14,  46,  31,  46,  12}, 
{4,  46,  32,  46,  14}, 
{5,  42,  33,  46,  13}, 
{5,  44,  31,  47,  12}, 
{47,  14,  47,  26,  12}, 
{49,  25,  45,  20,  13}, 
{34,  27,  46,  16,  13}, 
{47,  13,  47,  32,  12}, 
{38,  47,  26,  44,  12}, 
{39,  49,  19,  44,  13}, 
{38,  47,  27,  42,  13}, 
{38,  47,  20,  46,  13}, 
{44,  47,  24,  43,  12}, 
{45,  48,  21,  42,  15}, 
{44,  47,  30,  35,  13}, 
{41,  49,  25,  37,  13}, 
{44,  48,  25,  34,  13}, 
{44,  49,  27,  28,  13}, 
{37,  30,  41,  41,  12}, 
{45,  45,  27,  45,  12}, 
{46,  43,  27,  45,  13}, 
{42,  43,  32,  45,  12}, 
{31,  42,  32,  46,  12}, 
{18,  44,  32,  46,  13}, 
{39,  48,  23,  44,  12}, 
{20,  48,  23,  46,  13}, 
{37,  49,  19,  46,  12}, 
{37,  48,  17,  47,  13}, 
{28,  29,  46,  20,  12}, 
{42,  29,  47,  9,  13}, 
{31,  28,  48,  14,  12}, 
{26,  29,  48,  16,  15}, 
{31,  32,  48,  7,  13}, 
{30,  41,  49,  3,  12}, 
{26,  17,  49,  6,  15}, 
{30,  46,  38,  37,  12}, 
{43,  45,  35,  37,  13}, 
{33,  46,  36,  37,  14}, 
{39,  45,  38,  37,  13}, 
{31,  46,  35,  43,  12}, 
{33,  47,  34,  39,  16}, 
{38,  45,  33,  44,  15}, 
{32,  45,  35,  42,  14}, 
{36,  46,  33,  43,  13}, 
{32,  46,  34,  44,  13}, 
{24,  45,  35,  44,  14}, 
{37,  46,  34,  40,  13}, 
{35,  47,  34,  39,  14}, 
{35,  47,  29,  43,  14}, 
{25,  47,  35,  38,  13}, 
{0,  46,  35,  44,  13}, 
{34,  46,  35,  42,  12}, 
{34,  46,  34,  44,  14}, 
{36,  45,  35,  40,  13}, 
{41,  45,  35,  38,  13}, 
{34,  45,  40,  37,  12}, 
{41,  33,  38,  41,  12}, 
{42,  34,  38,  40,  14}, 
{49,  46,  35,  18,  12}, 
{49,  47,  35,  5,  13}, 
{21,  46,  38,  38,  12}, 
{33,  45,  37,  38,  14}, 
{40,  46,  39,  28,  12}, 
{40,  47,  36,  33,  12}, 
{40,  46,  38,  31,  14}, 
{44,  47,  38,  20,  14}, 
{40,  47,  34,  35,  13}, 
{40,  47,  39,  26,  13}, 
{0,  37,  38,  43,  12}, 
{0,  38,  38,  41,  13}, 
{46,  43,  40,  16,  12}, 
{49,  39,  41,  16,  13}, 
{44,  39,  41,  21,  13}, 
{44,  37,  41,  29,  12}, 
{47,  44,  41,  13,  12}, 
{47,  41,  40,  17,  13}, 
{49,  39,  40,  19,  14}, 
{46,  40,  41,  17,  13}, 
{47,  45,  40,  13,  13}, 
{11,  42,  34,  46,  12}, 
{48,  30,  32,  47,  12}, 
{43,  30,  31,  48,  12}, 
{43,  39,  25,  47,  12}, 
{49,  37,  25,  47,  13}, 
{49,  39,  23,  46,  13}, 
{48,  37,  31,  45,  13}, 
{45,  42,  21,  46,  13}, 
{45,  43,  14,  47,  13}, 
{45,  45,  18,  46,  13}, 
{43,  40,  24,  47,  13}, 
{42,  39,  29,  47,  12}, 
{49,  35,  21,  49,  12}, 
{49,  48,  35,  4,  12}, 
{49,  49,  30,  4,  13}, 
{42,  38,  36,  39,  12}, 
{35,  38,  37,  39,  14}, 
{30,  38,  39,  39,  13}, 
{34,  38,  36,  41,  12}, 
{37,  36,  36,  41,  13}, 
{38,  35,  37,  40,  14}, 
{41,  35,  37,  40,  13}, 
{49,  35,  36,  41,  13}, 
{39,  36,  37,  40,  13}, 
{27,  37,  37,  41,  13}, 
{16,  37,  37,  42,  13}, 
{30,  42,  36,  39,  12}, 
{34,  39,  36,  40,  16}, 
{15,  39,  36,  43,  14}, 
{46,  46,  37,  22,  12}, 
{48,  46,  36,  24,  12}, 
{43,  47,  35,  24,  15}, 
{24,  41,  34,  46,  12}, 
{49,  43,  37,  23,  12}, 
{49,  40,  14,  47,  12}, 
{49,  42,  3,  48,  13}, 
{47,  42,  15,  46,  13}, 
{44,  24,  36,  45,  12}, 
{45,  20,  36,  46,  14}, 
{49,  46,  37,  16,  12}, 
{27,  44,  24,  47,  12}, 
{17,  44,  29,  47,  14}, 
{37,  44,  22,  47,  13}, 
{13,  45,  25,  47,  13}, 
{36,  46,  21,  47,  13}, 
{37,  48,  19,  47,  14}, 
{17,  33,  40,  42,  12}, 
{26,  33,  39,  42,  13}, 
{46,  45,  35,  35,  12}, 
{47,  45,  36,  30,  13}, 
{46,  44,  38,  23,  12}, 
{45,  44,  38,  28,  12}, 
{27,  47,  39,  33,  12}, 
{30,  42,  20,  48,  12}, 
{41,  41,  17,  49,  13}, 
{33,  43,  19,  48,  15}, 
{35,  45,  18,  48,  13}, 
{41,  35,  28,  48,  12}, 
{49,  36,  25,  48,  12}, 
{47,  44,  33,  40,  12}, 
{42,  33,  39,  40,  12}, 
{37,  35,  39,  40,  12}, 
{28,  37,  38,  40,  13}, 
{17,  38,  38,  41,  14}, 
{31,  49,  21,  46,  12}, 
{33,  49,  23,  44,  13}, 
{47,  49,  43,  0,  12}, 
{28,  49,  46,  1,  13}, 
{9,  47,  40,  34,  12}, 
{26,  48,  48,  1,  12}, 
{47,  40,  26,  45,  12}, 
{44,  47,  38,  22,  12}, 
{49,  40,  9,  48,  12}, 
{44,  40,  19,  48,  12}, 
{44,  40,  15,  49,  13}, 
{27,  49,  23,  46,  12}, 
{31,  47,  24,  46,  15}, 
{17,  34,  40,  41,  12}, 
{4,  37,  39,  41,  14}, 
{6,  36,  39,  42,  12}, 
{8,  47,  31,  46,  12}, 
{37,  37,  31,  47,  12}, 
{34,  30,  38,  43,  12}, 
{48,  48,  39,  8,  12}, 
{48,  15,  46,  30,  12}, 
{37,  27,  43,  28,  12}, 
{42,  29,  47,  12,  12}, 
{45,  21,  47,  20,  12}, 
{45,  43,  29,  45,  12}, 
{49,  41,  21,  45,  12}, 
{43,  41,  24,  47,  12}, 
{46,  40,  22,  46,  12}, 
{48,  47,  26,  28,  12}, 
{49,  43,  38,  18,  12}, 
{46,  39,  40,  21,  12}, 
{31,  48,  37,  28,  12}, 
{34,  28,  38,  44,  12}, 
{26,  34,  36,  43,  12}, 
{31,  27,  32,  48,  12}, 
{12,  46,  40,  36,  12}, 
{18,  31,  41,  43,  12}, 
{33,  31,  41,  41,  12}, 
{44,  44,  34,  42,  12}, 
{45,  40,  37,  35,  12}, 
{40,  46,  40,  29,  12}, 
{44,  32,  40,  39,  12}, 
{43,  48,  18,  44,  12}, 
{42,  48,  18,  45,  12}, 
{39,  47,  24,  45,  12}, 
{39,  49,  21,  45,  12}, 
{35,  47,  25,  46,  12}, 
{38,  47,  26,  45,  12}, 
{36,  38,  39,  38,  12}, 
{32,  43,  30,  46,  12}, 
{24,  45,  31,  46,  13}, 
{49,  23,  30,  49,  12}, 
{46,  41,  41,  17,  12}, 
{46,  44,  41,  14,  13}, 
{44,  45,  41,  21,  12}, 
{44,  45,  40,  27,  12}, 
{44,  43,  40,  30,  12}, 
{44,  42,  40,  31,  12}, 
{40,  48,  41,  14,  12}, 
{17,  45,  33,  45,  12}, 
{15,  49,  29,  38,  12}, 
{42,  29,  48,  10,  12}, 
{34,  27,  45,  23,  12}, 
{20,  29,  47,  21,  14}, 
{31,  38,  46,  6,  12}, 
{21,  39,  46,  7,  12}, 
{44,  49,  45,  40,  11}, 
{46,  26,  44,  38,  19}, 
{46,  46,  36,  30,  17}, 
{39,  49,  28,  41,  16}, 
{48,  27,  44,  33,  16}, 
{23,  44,  36,  41,  16}, 
{47,  26,  45,  35,  16}, 
{46,  40,  43,  15,  15}, 
{47,  23,  43,  39,  15}, 
{45,  49,  36,  16,  15}, 
{47,  48,  38,  15,  15}, 
{47,  45,  45,  0,  15}, 
{47,  48,  41,  3,  15}, 
{47,  46,  34,  33,  15}, 
{44,  45,  33,  43,  14}, 
{49,  42,  46,  0,  14}, 
{6,  40,  38,  41,  14}, 
{44,  47,  30,  41,  14}, 
{42,  49,  28,  41,  15}, 
{43,  47,  32,  41,  15}, 
{46,  47,  39,  18,  14}, 
{47,  42,  42,  14,  14}, 
{45,  42,  44,  12,  14}, 
{47,  48,  31,  21,  14}, 
{44,  47,  29,  42,  14}, 
{45,  35,  39,  40,  14}, 
{23,  46,  36,  41,  14}, 
{27,  33,  41,  41,  14}, 
{36,  49,  24,  44,  13}, 
{40,  46,  35,  41,  13}, 
{46,  45,  43,  7,  13}, 
{45,  48,  43,  6,  14}, 
{45,  49,  30,  27,  13}, 
{29,  18,  48,  31,  13}, 
{48,  18,  46,  32,  14}, 
{15,  43,  36,  42,  13}, 
{45,  43,  42,  16,  13}, 
{16,  40,  38,  41,  13}, 
{42,  29,  46,  17,  13}, 
{35,  29,  46,  23,  13}, 
{45,  27,  46,  23,  13}, 
{45,  37,  45,  16,  13}, 
{49,  39,  47,  0,  13}, 
{45,  45,  36,  40,  12}, 
{46,  44,  35,  37,  14}, 
{49,  36,  37,  40,  14}, 
{45,  23,  46,  36,  12}, 
{45,  27,  46,  27,  13}, 
{48,  24,  46,  33,  16}, 
{20,  24,  48,  30,  14}, 
{33,  26,  46,  31,  13}, 
{47,  22,  47,  29,  13}, 
{38,  49,  32,  42,  12}, 
{44,  48,  32,  41,  15}, 
{28,  48,  33,  42,  15}, 
{43,  48,  31,  42,  13}, 
{21,  48,  25,  46,  13}, 
{40,  48,  24,  45,  14}, 
{21,  49,  24,  46,  14}, 
{8,  48,  29,  45,  13}, 
{40,  48,  26,  44,  16}, 
{36,  49,  27,  43,  15}, 
{42,  49,  32,  41,  13}, 
{30,  48,  28,  44,  13}, 
{33,  48,  31,  44,  12}, 
{32,  49,  31,  43,  16}, 
{40,  47,  28,  44,  14}, 
{37,  47,  31,  44,  14}, 
{31,  27,  42,  41,  12}, 
{27,  26,  43,  41,  12}, 
{43,  16,  43,  41,  14}, 
{7,  45,  36,  44,  12}, 
{41,  33,  40,  41,  12}, 
{47,  27,  47,  27,  12}, 
{42,  28,  47,  23,  13}, 
{40,  34,  39,  41,  12}, 
{30,  36,  38,  41,  14}, 
{45,  48,  40,  16,  12}, 
{46,  39,  38,  34,  12}, 
{46,  37,  38,  36,  13}, 
{46,  44,  38,  25,  13}, 
{46,  40,  40,  24,  12}, 
{46,  44,  40,  19,  13}, 
{45,  42,  41,  19,  14}, 
{45,  39,  41,  25,  13}, 
{45,  40,  40,  30,  12}, 
{45,  43,  40,  28,  12}, 
{45,  42,  41,  24,  14}, 
{46,  43,  39,  25,  13}, 
{43,  47,  26,  45,  12}, 
{47,  46,  36,  30,  12}, 
{36,  49,  25,  45,  12}, 
{45,  39,  42,  24,  12}, 
{47,  41,  39,  23,  12}, 
{40,  31,  41,  41,  12}, 
{45,  35,  40,  38,  12}, 
{47,  42,  38,  24,  12}, 
{46,  24,  46,  35,  12}, 
{47,  45,  44,  2,  12}, 
{45,  44,  44,  11,  13}, 
{45,  44,  45,  7,  12}, 
{46,  37,  35,  39,  12}, 
{45,  31,  40,  41,  12}, 
{45,  45,  40,  21,  12}, 
{45,  44,  40,  28,  13}, 
{49,  38,  43,  17,  12}, 
{46,  47,  40,  13,  12}, 
{47,  47,  40,  10,  13}, 
{47,  46,  40,  15,  12}, 
{47,  46,  42,  6,  12}, 
{48,  44,  43,  4,  13}, 
{45,  48,  44,  6,  12}, 
{39,  45,  46,  2,  12}, 
{47,  45,  33,  39,  12}, 
{41,  47,  27,  45,  12}, 
{46,  25,  43,  40,  12}, 
{45,  49,  33,  23,  12}, 
{47,  48,  33,  21,  13}, 
{45,  48,  34,  27,  12}, 
{46,  48,  37,  21,  12}, 
{45,  48,  37,  27,  12}, 
{45,  49,  35,  25,  14}, 
{45,  49,  32,  28,  12}, 
{26,  49,  25,  46,  12}, 
{47,  48,  41,  4,  12}, 
{14,  43,  36,  43,  12}, 
{49,  38,  47,  1,  12}, 
{49,  40,  46,  2,  12}, 
{45,  27,  48,  15,  12}, 
{46,  39,  46,  3,  12}, 
{49,  34,  48,  3,  13}, 
{30,  25,  48,  27,  12}, 
{25,  26,  48,  30,  12}, 
{48,  25,  47,  28,  12}, 
{41,  40,  38,  46,  11}, 
{45,  31,  36,  44,  18}, 
{41,  42,  36,  41,  16}, 
{22,  42,  36,  44,  16}, 
{33,  46,  36,  41,  15}, 
{41,  41,  37,  41,  14}, 
{43,  25,  37,  46,  14}, 
{21,  41,  38,  42,  13}, 
{41,  41,  37,  42,  13}, 
{5,  42,  37,  43,  13}, 
{34,  41,  36,  44,  13}, 
{0,  44,  37,  42,  13}, 
{42,  40,  34,  46,  13}, 
{42,  29,  38,  45,  13}, 
{49,  35,  37,  41,  13}, 
{42,  42,  32,  46,  12}, 
{43,  42,  37,  41,  12}, 
{33,  43,  37,  41,  15}, 
{43,  39,  38,  41,  14}, 
{33,  46,  37,  41,  12}, 
{44,  38,  38,  41,  12}, 
{22,  42,  37,  43,  12}, 
{44,  44,  35,  41,  12}, 
{44,  41,  35,  42,  12}, 
{45,  35,  35,  43,  12}, 
{42,  41,  36,  42,  12}, 
{44,  36,  38,  42,  12}, 
{46,  35,  37,  42,  14}, 
{43,  40,  36,  42,  13}, 
{42,  32,  38,  44,  12}, 
{43,  37,  36,  43,  13}, 
{22,  43,  37,  42,  12}, 
{30,  33,  39,  42,  12}, 
{43,  39,  32,  46,  12}, 
{37,  29,  40,  43,  12}, 
{45,  29,  40,  42,  12}, 
{19,  43,  36,  44,  12}, 
{44,  49,  47,  25,  11}, 
{45,  44,  46,  8,  16}, 
{49,  42,  47,  1,  16}, 
{39,  39,  48,  4,  16}, 
{45,  40,  47,  13,  15}, 
{45,  33,  46,  26,  14}, 
{30,  46,  48,  2,  14}, 
{31,  44,  48,  4,  14}, 
{27,  43,  49,  4,  15}, 
{28,  32,  48,  14,  14}, 
{47,  45,  47,  0,  13}, 
{46,  35,  46,  22,  13}, 
{39,  39,  48,  5,  13}, 
{27,  49,  49,  1,  13}, 
{28,  32,  46,  31,  12}, 
{8,  32,  46,  34,  15}, 
{33,  31,  46,  30,  13}, 
{41,  32,  46,  28,  14}, 
{44,  31,  46,  29,  13}, 
{45,  44,  46,  12,  12}, 
{46,  39,  46,  9,  12}, 
{36,  33,  46,  28,  12}, 
{46,  44,  46,  2,  12}, 
{40,  28,  47,  29,  12}, 
{26,  34,  47,  26,  12}, 
{25,  30,  48,  26,  12}, 
{25,  32,  48,  20,  13}, 
{44,  38,  35,  47,  11}, 
{45,  30,  36,  45,  15}, 
{48,  37,  27,  47,  14}, 
{26,  39,  32,  47,  14}, 
{3,  36,  36,  47,  14}, 
{43,  40,  27,  47,  14}, 
{48,  28,  34,  47,  14}, 
{5,  33,  34,  48,  14}, 
{42,  39,  31,  47,  13}, 
{10,  41,  34,  47,  13}, 
{45,  28,  36,  46,  13}, 
{44,  39,  32,  46,  13}, 
{49,  36,  28,  47,  13}, 
{45,  30,  35,  47,  13}, 
{49,  23,  35,  47,  14}, 
{49,  36,  30,  46,  13}, 
{44,  32,  36,  46,  12}, 
{42,  41,  28,  47,  12}, 
{43,  42,  26,  47,  12}, 
{43,  43,  22,  47,  13}, 
{49,  8,  36,  47,  12}, 
{44,  37,  36,  43,  12}, 
{40,  42,  41,  41,  11}, 
{22,  42,  38,  42,  13}, 
{41,  42,  38,  41,  12}, 
{44,  30,  47,  40,  11}, 
{22,  30,  48,  33,  18}, 
{18,  32,  47,  35,  15}, 
{18,  32,  46,  38,  14}, 
{29,  33,  47,  29,  13}, 
{24,  32,  46,  38,  13}, 
{44,  31,  46,  36,  13}, 
{24,  31,  48,  32,  13}, 
{34,  32,  46,  33,  13}, 
{41,  32,  46,  32,  13}, 
{36,  32,  47,  29,  12}, 
{21,  32,  48,  33,  12}, 
{46,  28,  47,  34,  12}, 
{48,  31,  35,  48,  11}, 
{49,  18,  33,  49,  16}, 
{49,  18,  35,  49,  14}, 
{48,  35,  35,  44,  14}, 
{46,  34,  35,  46,  14}, 
{47,  31,  38,  43,  13}, 
{49,  8,  36,  48,  12}, 
{49,  20,  36,  46,  12}, 
{49,  19,  35,  49,  12}, 
{49,  44,  34,  44,  11}, 
{49,  36,  37,  41,  15}, 
{45,  38,  36,  41,  12}, 
{46,  37,  35,  41,  12}, 
{34,  48,  35,  44,  11}, 
{5,  47,  33,  45,  14}, 
{20,  48,  36,  41,  13}, 
{0,  47,  36,  44,  12}, 
{29,  49,  34,  41,  12}, 
{40,  44,  46,  30,  11}, 
{22,  49,  46,  26,  16}, 
{21,  37,  46,  32,  15}, 
{41,  41,  46,  28,  14}, 
{29,  35,  47,  28,  14}, 
{41,  34,  47,  27,  14}, 
{42,  46,  46,  26,  13}, 
{28,  45,  46,  30,  16}, 
{40,  34,  46,  31,  13}, 
{34,  33,  47,  30,  13}, 
{36,  35,  46,  32,  12}, 
{32,  34,  47,  31,  12}, 
{16,  46,  46,  29,  12}, 
{37,  37,  40,  43,  11}, 
{21,  38,  40,  42,  15}, 
{40,  34,  40,  42,  14}, 
{40,  37,  39,  42,  14}, 
{14,  34,  39,  44,  14}, 
{22,  32,  41,  43,  13}, 
{36,  31,  39,  44,  12}, 
{28,  33,  39,  44,  14}, 
{20,  35,  41,  43,  12}, 
{15,  40,  40,  42,  12}, 
{31,  39,  39,  42,  13}, 
{43,  18,  39,  44,  12}, 
{43,  23,  44,  43,  11}, 
{26,  26,  44,  42,  16}, 
{35,  27,  43,  41,  15}, 
{36,  15,  45,  41,  13}, 
{47,  7,  43,  42,  13}, 
{28,  24,  43,  43,  13}, 
{17,  35,  42,  42,  12}, 
{15,  38,  42,  41,  14}, 
{34,  27,  43,  42,  13}, 
{23,  37,  42,  41,  13}, 
{35,  26,  45,  41,  12}, 
{45,  28,  41,  41,  12}, 
{47,  20,  42,  43,  12}, 
{39,  46,  40,  41,  11}, 
{29,  43,  41,  41,  13}, 
{43,  44,  37,  41,  12}, 
{49,  45,  38,  29,  11}, 
{47,  40,  38,  32,  13}, 
{49,  46,  38,  16,  13}, 
{49,  46,  36,  23,  13}, 
{48,  46,  39,  17,  13}, 
{49,  45,  40,  10,  12}, 
{49,  48,  39,  2,  14}, 
{48,  45,  43,  5,  13}, 
{49,  48,  42,  2,  12}, 
{48,  46,  40,  10,  14}, 
{49,  46,  40,  7,  14}, 
{48,  45,  39,  21,  12}, 
{47,  45,  39,  23,  15}, 
{47,  47,  39,  18,  13}, 
{49,  43,  43,  8,  12}, 
{45,  43,  39,  30,  12}, 
{45,  44,  38,  31,  13}, 
{48,  47,  39,  18,  12}, 
{49,  44,  39,  20,  12}, 
{49,  46,  41,  6,  12}, 
{48,  48,  42,  3,  13}, 
{48,  47,  41,  6,  14}, 
{48,  46,  43,  3,  13}, 
{47,  44,  37,  39,  11}, 
{49,  37,  37,  41,  14}, 
{49,  42,  35,  37,  14}, 
{45,  42,  38,  34,  13}, 
{49,  41,  37,  38,  12}, 
{49,  42,  37,  36,  13}, 
{49,  44,  37,  31,  13}, 
{45,  43,  39,  32,  12}, 
{46,  43,  38,  32,  13}, 
{47,  42,  38,  32,  13}, 
{45,  38,  40,  36,  12}, 
{45,  40,  39,  36,  14}, 
{45,  42,  40,  32,  12}, 
{42,  42,  32,  47,  11}, 
{11,  42,  34,  47,  15}, 
{33,  39,  33,  47,  13}, 
{42,  40,  34,  47,  12}, 
{33,  29,  41,  44,  11}, 
{26,  31,  40,  44,  12}, 
{3,  34,  40,  44,  13}, 
{41,  36,  43,  41,  11}, 
{2,  34,  43,  42,  13}, 
{20,  30,  44,  42,  13}, 
{40,  44,  38,  42,  11}, 
{48,  48,  25,  42,  11}, 
{45,  47,  32,  38,  14}, 
{46,  47,  26,  43,  14}, 
{47,  49,  26,  28,  13}, 
{46,  49,  23,  40,  13}, 
{46,  47,  29,  35,  13}, 
{47,  48,  29,  25,  13}, 
{48,  49,  26,  22,  12}, 
{46,  48,  34,  23,  12}, 
{40,  44,  34,  45,  11}, 
{23,  42,  34,  46,  12}, 
{31,  39,  39,  44,  11}, 
{19,  36,  40,  44,  16}, 
{48,  49,  38,  18,  11}, 
{48,  49,  30,  21,  13}, 
{47,  49,  35,  20,  14}, 
{49,  45,  27,  45,  11}, 
{48,  47,  3,  48,  12}, 
{39,  44,  29,  47,  11}, 
{38,  45,  19,  48,  12}, 
{40,  44,  28,  47,  12}, 
{43,  44,  23,  47,  14}, 
{44,  47,  15,  47,  13}, 
{46,  48,  23,  44,  13}, 
{48,  49,  12,  44,  13}, 
{45,  47,  28,  44,  12}, 
{45,  47,  32,  41,  12}, 
{45,  47,  29,  43,  12}, 
{44,  45,  17,  47,  12}, 
{47,  43,  35,  41,  11}, 
{46,  39,  36,  41,  14}, 
{47,  44,  35,  40,  12}, 
{38,  23,  46,  42,  11}, 
{40,  24,  46,  41,  13}, 
{20,  28,  45,  42,  12}, 
{45,  46,  38,  38,  11}, 
{46,  46,  39,  21,  13}, 
{45,  39,  38,  40,  12}, 
{46,  46,  35,  33,  12}, 
{45,  42,  39,  35,  12}, 
{45,  49,  36,  39,  11}, 
{45,  48,  34,  40,  14}, 
{45,  48,  38,  29,  13}, 
{45,  48,  40,  24,  12}, 
{45,  49,  38,  25,  12}, 
{47,  45,  47,  6,  11}, 
{47,  43,  44,  11,  15}, 
{49,  42,  45,  7,  14}, 
{46,  42,  47,  9,  13}, 
{45,  48,  47,  4,  12}, 
{46,  46,  47,  1,  13}, 
{45,  44,  47,  12,  12}, 
{47,  46,  45,  3,  12}, 
{47,  41,  47,  8,  12}, 
{23,  31,  49,  22,  11}, 
{35,  29,  49,  13,  14}, 
{29,  35,  49,  7,  14}, 
{40,  32,  35,  48,  11}, 
{4,  33,  35,  48,  13}, 
{43,  32,  32,  48,  12}, 
{29,  44,  32,  47,  11}, 
{42,  44,  32,  46,  11}, 
{33,  45,  31,  46,  13}, 
{42,  40,  36,  46,  11}, 
{43,  40,  35,  45,  13}, 
{42,  35,  37,  44,  12}, 
{37,  49,  46,  28,  11}, 
{27,  46,  46,  30,  13}, 
{6,  37,  34,  48,  11}, 
{17,  37,  31,  48,  15}, 
{29,  34,  31,  48,  13}, 
{4,  34,  35,  48,  13}, 
{29,  36,  30,  48,  12}, 
{41,  36,  30,  48,  11}, 
{36,  34,  31,  48,  14}, 
{38,  38,  29,  48,  12}, 
{44,  38,  29,  48,  11}, 
{45,  37,  28,  48,  15}, 
{45,  38,  24,  48,  13}, 
{43,  39,  25,  48,  12}, 
{43,  35,  30,  48,  12}, 
{48,  37,  32,  47,  11}, 
{45,  41,  32,  45,  12}, 
{47,  35,  33,  47,  12}, 
{48,  42,  32,  45,  11}, 
{2,  42,  36,  46,  11}, 
{34,  47,  39,  41,  11}, 
{32,  46,  47,  27,  11}, 
{32,  36,  47,  31,  16}, 
{46,  49,  31,  38,  11}, 
{48,  48,  32,  38,  11}, 
{47,  49,  28,  32,  13}, 
{48,  48,  27,  40,  13}, 
{47,  47,  28,  42,  14}, 
{47,  47,  34,  26,  13}, 
{48,  47,  28,  42,  12}, 
{28,  47,  37,  42,  11}, 
{34,  47,  36,  42,  13}, 
{28,  48,  36,  42,  13}, 
{37,  37,  39,  44,  11}, 
{44,  42,  20,  48,  11}, 
{44,  45,  11,  48,  14}, 
{41,  42,  13,  49,  12}, 
{44,  40,  23,  48,  12}, 
{43,  45,  14,  48,  12}, 
{4,  37,  32,  49,  11}, 
{5,  27,  34,  49,  13}, 
{33,  35,  28,  49,  12}, 
{48,  31,  34,  49,  11}, 
{39,  33,  28,  49,  13}, 
{47,  33,  26,  49,  12}, 
{39,  32,  30,  49,  12}, 
{43,  37,  25,  49,  11}, 
{35,  38,  26,  49,  14}, 
{34,  39,  25,  49,  13}, 
{49,  36,  20,  49,  13}, 
{43,  41,  17,  49,  12}, 
{35,  41,  38,  43,  11}, 
{44,  45,  48,  2,  11}, 
{44,  41,  48,  4,  14}, 
{49,  35,  48,  7,  13}, 
{42,  39,  48,  6,  13}, 
{35,  44,  48,  11,  11}, 
{29,  41,  49,  7,  15}, 
{39,  39,  48,  11,  15}, 
{26,  45,  48,  8,  13}, 
{29,  36,  49,  11,  12}, 
{10,  45,  49,  7,  12}, 
{17,  43,  49,  9,  12}, 
{34,  39,  49,  9,  12}, 
{41,  39,  49,  2,  13}, 
{44,  40,  48,  7,  12}, 
{49,  44,  41,  13,  11}, 
{48,  46,  40,  14,  13}, 
{49,  41,  40,  19,  12}, 
{49,  43,  43,  10,  12}, 
{20,  31,  43,  43,  11}, 
{28,  26,  43,  43,  12}, 
{20,  33,  42,  43,  12}, 
{46,  44,  43,  15,  11}, 
{49,  42,  44,  14,  11}, 
{47,  40,  45,  14,  15}, 
{49,  39,  47,  14,  13}, 
{49,  38,  46,  16,  12}, 
{46,  36,  38,  42,  11}, 
{48,  40,  35,  44,  11}, 
{47,  41,  35,  43,  14}, 
{44,  40,  35,  45,  13}, 
{45,  44,  35,  42,  12}, 
{47,  42,  35,  43,  13}, 
{47,  43,  35,  42,  14}, 
{45,  39,  36,  42,  12}, 
{44,  44,  37,  42,  11}, 
{45,  42,  36,  42,  13}, 
{41,  42,  38,  42,  12}, 
{45,  47,  47,  8,  11}, 
{48,  46,  42,  8,  12}, 
{17,  42,  47,  30,  11}, 
{2,  41,  31,  48,  11}, 
{46,  49,  34,  33,  11}, 
{46,  48,  35,  32,  12}, 
{47,  47,  35,  26,  12}, 
{35,  41,  33,  47,  11}, 
{35,  42,  33,  46,  14}, 
{35,  34,  31,  49,  11}, 
{21,  49,  32,  44,  11}, 
{49,  49,  37,  3,  11}, 
{32,  39,  40,  42,  11}, 
{36,  38,  40,  42,  12}, 
{40,  38,  39,  42,  13}, 
{46,  45,  37,  38,  11}, 
{47,  46,  36,  31,  12}, 
{47,  45,  37,  36,  11}, 
{47,  45,  38,  30,  12}, 
{46,  48,  45,  4,  11}, 
{46,  46,  47,  5,  13}, 
{46,  47,  45,  6,  12}, 
{44,  45,  27,  46,  11}, 
{44,  44,  22,  47,  13}, 
{45,  44,  23,  46,  12}, 
{49,  42,  23,  46,  11}, 
{44,  39,  38,  42,  11}, 
{45,  45,  47,  13,  11}, 
{45,  48,  42,  10,  13}, 
{45,  45,  43,  17,  11}, 
{45,  45,  41,  20,  13}, 
{46,  44,  41,  17,  12}, 
{42,  47,  26,  46,  11}, 
{44,  47,  18,  47,  12}, 
{42,  48,  18,  47,  13}, 
{45,  45,  35,  41,  11}, 
{43,  45,  37,  41,  14}, 
{43,  49,  48,  1,  11}, 
{43,  44,  26,  47,  11}, 
{43,  40,  25,  48,  11}, 
{27,  40,  25,  49,  12}, 
{47,  42,  36,  40,  11}, 
{46,  48,  39,  21,  11}, 
{45,  40,  37,  42,  11}, 
{45,  43,  37,  40,  12}, 
{23,  39,  48,  15,  11}, 
{32,  40,  48,  13,  13}, 
{37,  35,  48,  14,  12}, 
{34,  36,  49,  12,  12}, 
{49,  39,  24,  46,  11}, 
{48,  49,  29,  30,  11}, 
{48,  49,  24,  38,  12}, 
{47,  49,  29,  35,  12}, 
{49,  46,  35,  27,  11}, 
{42,  22,  48,  32,  11}, 
{18,  39,  30,  48,  11}, 
{41,  39,  27,  48,  11}, 
{35,  39,  28,  48,  13}, 
{30,  40,  26,  48,  13}, 
{3,  40,  34,  48,  11}, 
{3,  41,  28,  49,  11}, 
{26,  45,  38,  42,  11}, 
{3,  34,  36,  48,  11}, 
{24,  32,  46,  40,  11}, 
{44,  31,  46,  40,  11}, 
{47,  44,  29,  45,  11}, 
{28,  49,  34,  42,  11}, 
{45,  45,  42,  20,  11}, 
{5,  48,  33,  45,  11}, 
{34,  46,  37,  42,  11}, 
{49,  47,  8,  45,  11}, 
{49,  47,  23,  21,  12}, 
{49,  48,  15,  31,  13}, 
{49,  48,  24,  9,  12}, 
{49,  48,  31,  9,  11}, 
{49,  49,  34,  5,  11}, 
{49,  49,  21,  23,  11}, 
{47,  8,  46,  38,  11}, 
{45,  44,  38,  39,  11}, 
{47,  48,  31,  39,  11}, 
{47,  49,  29,  39,  11}, 
{47,  49,  23,  43,  11}, 
{40,  49,  28,  43,  11}, 
{38,  49,  25,  46,  11}, 
{45,  49,  23,  44,  12}, 
{40,  49,  26,  44,  12}, 
{36,  49,  26,  46,  11}, 
{9,  49,  28,  46,  13}, 
{39,  49,  28,  44,  11}, 
{39,  48,  27,  45,  12}, 
{46,  40,  36,  42,  11}, 
{47,  39,  36,  42,  12}, 
{45,  25,  46,  40,  11}, 
{37,  29,  40,  44,  11}, 
{39,  40,  21,  49,  11}, 
{45,  47,  46,  10,  11}, 
{25,  26,  36,  47,  11}, 
{49,  20,  36,  47,  11}, 
{45,  39,  38,  41,  11}, 
{42,  43,  28,  47,  11}, 
{48,  46,  36,  28,  11}, 
{45,  40,  23,  47,  11}, 
{47,  48,  44,  2,  11}, 
{49,  49,  23,  18,  11}, 
{23,  46,  23,  47,  11}, 
{18,  38,  47,  31,  11}, 
{32,  38,  46,  31,  11}, 
{8,  43,  21,  49,  11}, 
{44,  43,  35,  43,  11}, 
{48,  33,  35,  47,  11}, 
{46,  46,  36,  34,  11}, 
{47,  46,  34,  36,  13}, 
{46,  49,  34,  35,  11}, 
{39,  46,  46,  28,  11}, 
{34,  46,  47,  26,  11}, 
{45,  49,  39,  15,  11}, 
{34,  30,  40,  44,  11}, 
{47,  44,  43,  11,  11}, 
{18,  45,  36,  43,  11}, 
{11,  41,  35,  46,  11}, 
{45,  20,  49,  18,  11}, 
{3,  38,  36,  47,  11}, 
{11,  40,  48,  16,  11}, 
{46,  47,  29,  43,  11}, 
{46,  48,  31,  41,  11}, 
{45,  48,  26,  43,  12}, 
{48,  49,  23,  42,  11}, 
{42,  48,  29,  43,  11}, 
{35,  48,  32,  44,  13}, 
{47,  30,  40,  42,  11}, 
{49,  28,  39,  43,  11}, 
{48,  31,  36,  46,  11}, 
{49,  40,  36,  42,  11}, 
{47,  42,  36,  41,  11}, 
{47,  47,  34,  29,  11}, 
{47,  48,  36,  28,  11}, 
{47,  49,  38,  19,  12}, 
{46,  47,  39,  22,  12}, 
{47,  48,  38,  22,  11}, 
{31,  45,  38,  42,  11}, 
{46,  48,  37,  23,  11}, 
{49,  38,  39,  28,  11}, 
{49,  47,  15,  43,  11}, 
{36,  35,  47,  30,  11}, 
{45,  42,  6,  49,  11}, 
{27,  40,  26,  49,  11}, 
{29,  46,  18,  48,  11}, 
{49,  49,  36,  4,  11}, 
{34,  41,  48,  13,  11}, 
{11,  44,  48,  15,  12}, 
{20,  29,  44,  43,  11}, 
{30,  27,  48,  30,  11}, 
{35,  40,  49,  6,  11}, 
{13,  39,  28,  49,  11}, 
{21,  32,  34,  49,  11}, 
{45,  49,  41,  47,  10}, 
{46,  38,  29,  47,  17}, 
{46,  29,  40,  47,  16}, 
{47,  36,  36,  46,  15}, 
{46,  35,  36,  47,  14}, 
{47,  39,  34,  45,  13}, 
{46,  45,  31,  45,  13}, 
{47,  32,  44,  32,  13}, 
{48,  37,  35,  45,  13}, 
{49,  40,  36,  44,  12}, 
{47,  37,  36,  46,  13}, 
{46,  45,  37,  39,  12}, 
{13,  49,  18,  48,  12}, 
{40,  49,  8,  48,  12}, 
{46,  32,  45,  34,  12}, 
{45,  46,  43,  17,  12}, 
{45,  49,  42,  18,  12}, 
{46,  49,  45,  4,  13}, 
{45,  49,  47,  5,  13}, 
{46,  49,  29,  41,  12}, 
{47,  49,  26,  42,  12}, 
{46,  29,  36,  48,  11}, 
{44,  19,  36,  49,  14}, 
{48,  25,  36,  48,  12}, 
{47,  42,  32,  46,  11}, 
{46,  39,  34,  46,  12}, 
{47,  40,  35,  46,  11}, 
{46,  40,  36,  46,  14}, 
{46,  42,  36,  46,  11}, 
{47,  42,  34,  45,  13}, 
{48,  42,  33,  45,  12}, 
{47,  43,  34,  45,  11}, 
{46,  49,  40,  13,  11}, 
{47,  49,  39,  18,  11}, 
{48,  48,  39,  13,  12}, 
{48,  48,  42,  5,  11}, 
{47,  42,  36,  43,  11}, 
{46,  33,  46,  29,  11}, 
{43,  36,  46,  30,  11}, 
{45,  46,  47,  12,  11}, 
{45,  31,  46,  38,  11}, 
{47,  31,  44,  37,  11}, 
{44,  41,  46,  26,  11}, 
{46,  49,  47,  0,  11}, 
{44,  49,  49,  40,  10}, 
{45,  34,  47,  34,  12}, 
{46,  43,  48,  5,  11}, 
{45,  48,  48,  4,  12}, 
{46,  49,  49,  0,  12}, 
{45,  34,  49,  34,  11}, 
{49,  49,  41,  36,  10}, 
{48,  48,  42,  9,  16}, 
{49,  49,  21,  39,  16}, 
{49,  45,  34,  38,  14}, 
{48,  49,  43,  0,  14}, 
{49,  39,  40,  37,  13}, 
{49,  47,  25,  40,  13}, 
{49,  41,  44,  15,  13}, 
{46,  49,  42,  13,  12}, 
{47,  48,  42,  12,  12}, 
{49,  33,  38,  44,  12}, 
{47,  44,  41,  38,  11}, 
{47,  41,  38,  39,  14}, 
{46,  45,  40,  38,  13}, 
{49,  41,  40,  37,  12}, 
{46,  49,  39,  38,  11}, 
{48,  46,  34,  38,  15}, 
{46,  49,  40,  37,  13}, 
{48,  48,  34,  37,  12}, 
{47,  49,  34,  37,  12}, 
{46,  47,  41,  37,  12}, 
{46,  45,  40,  39,  11}, 
{46,  42,  40,  41,  11}, 
{49,  45,  35,  37,  11}, 
{47,  46,  39,  38,  11}, 
{47,  48,  37,  37,  14}, 
{49,  46,  35,  37,  13}, 
{48,  47,  36,  38,  11}, 
{49,  43,  38,  37,  12}, 
{49,  42,  36,  39,  11}, 
{46,  43,  41,  39,  11}, 
{47,  49,  42,  12,  11}, 
{49,  49,  42,  1,  12}, 
{47,  49,  43,  4,  12}, 
{48,  49,  43,  6,  11}, 
{47,  47,  43,  12,  11}, 
{46,  43,  39,  41,  11}, 
{49,  47,  25,  41,  11}, 
{47,  46,  41,  37,  11}, 
{47,  49,  37,  37,  11}, 
{49,  47,  27,  39,  11}, 
{46,  34,  46,  34,  11}, 
{46,  48,  42,  15,  11}, 
{47,  48,  43,  9,  11}, 
{45,  48,  47,  9,  11}, 
{49,  46,  36,  37,  11}, 
{48,  49,  28,  39,  11}, 
{40,  42,  44,  45,  10}, 
{43,  23,  44,  45,  18}, 
{17,  36,  45,  41,  15}, 
{36,  27,  45,  42,  14}, 
{43,  26,  44,  43,  13}, 
{41,  39,  43,  41,  13}, 
{7,  47,  42,  41,  12}, 
{7,  43,  42,  43,  13}, 
{28,  34,  42,  47,  11}, 
{28,  36,  45,  42,  11}, 
{36,  31,  45,  42,  13}, 
{40,  31,  46,  41,  11}, 
{38,  44,  42,  41,  11}, 
{25,  47,  42,  41,  14}, 
{34,  27,  42,  47,  11}, 
{45,  21,  43,  45,  11}, 
{30,  31,  42,  47,  11}, 
{28,  33,  46,  41,  11}, 
{44,  21,  45,  41,  11}, 
{43,  46,  34,  48,  10}, 
{18,  49,  21,  48,  15}, 
{44,  39,  29,  48,  14}, 
{39,  48,  15,  48,  12}, 
{44,  39,  30,  48,  12}, 
{18,  41,  26,  49,  12}, 
{18,  48,  23,  48,  12}, 
{43,  47,  24,  48,  11}, 
{30,  48,  24,  48,  12}, 
{31,  42,  25,  49,  11}, 
{44,  42,  30,  48,  11}, 
{44,  33,  30,  49,  11}, 
{41,  41,  21,  49,  11}, 
{35,  42,  22,  49,  12}, 
{29,  35,  31,  49,  11}, 
{5,  49,  25,  48,  11}, 
{30,  49,  24,  48,  11}, 
{49,  34,  30,  48,  11}, 
{48,  33,  33,  48,  13}, 
{43,  32,  35,  48,  11}, 
{45,  46,  9,  48,  11}, 
{14,  37,  32,  49,  11}, 
{49,  46,  36,  44,  10}, 
{47,  43,  35,  45,  13}, 
{46,  48,  36,  39,  13}, 
{47,  47,  36,  39,  12}, 
{46,  48,  34,  41,  11}, 
{46,  47,  35,  42,  11}, 
{46,  44,  36,  45,  11}, 
{46,  44,  40,  40,  11}, 
{47,  47,  34,  41,  11}, 
{48,  47,  30,  42,  11}, 
{47,  42,  36,  45,  11}, 
{46,  47,  33,  43,  11}, 
{48,  48,  29,  41,  11}, 
{47,  49,  28,  42,  11}, 
{48,  49,  45,  18,  10}, 
{45,  40,  45,  20,  15}, 
{48,  45,  42,  19,  14}, 
{48,  46,  46,  0,  13}, 
{46,  45,  47,  9,  13}, 
{47,  46,  46,  7,  13}, 
{49,  43,  46,  3,  12}, 
{45,  44,  47,  18,  11}, 
{46,  42,  47,  14,  12}, 
{46,  45,  47,  14,  11}, 
{48,  44,  48,  0,  11}, 
{47,  47,  49,  0,  11}, 
{45,  45,  44,  19,  11}, 
{48,  46,  46,  2,  11}, 
{46,  40,  46,  18,  11}, 
{46,  37,  46,  21,  11}, 
{47,  49,  48,  0,  11}, 
{45,  49,  44,  37,  10}, 
{46,  36,  45,  34,  14}, 
{45,  36,  42,  40,  13}, 
{45,  38,  46,  26,  13}, 
{45,  36,  43,  40,  12}, 
{45,  35,  46,  40,  11}, 
{45,  41,  47,  22,  11}, 
{45,  42,  42,  39,  11}, 
{44,  22,  49,  45,  10}, 
{12,  33,  49,  41,  15}, 
{33,  28,  45,  43,  15}, 
{44,  23,  46,  44,  14}, 
{40,  28,  45,  43,  15}, 
{47,  13,  45,  44,  14}, 
{45,  22,  46,  45,  13}, 
{37,  31,  47,  41,  12}, 
{28,  28,  45,  44,  12}, 
{26,  33,  49,  41,  11}, 
{44,  24,  44,  45,  11}, 
{44,  23,  49,  42,  11}, 
{49,  48,  43,  23,  10}, 
{46,  45,  44,  22,  16}, 
{49,  49,  42,  3,  13}, 
{47,  45,  44,  20,  13}, 
{49,  48,  44,  3,  12}, 
{49,  47,  44,  14,  12}, 
{49,  47,  45,  11,  12}, 
{49,  45,  46,  2,  12}, 
{49,  45,  45,  16,  12}, 
{48,  49,  43,  20,  11}, 
{46,  49,  43,  22,  13}, 
{46,  46,  42,  24,  11}, 
{46,  37,  43,  33,  13}, 
{46,  41,  43,  26,  11}, 
{46,  45,  44,  23,  11}, 
{46,  43,  40,  46,  10}, 
{47,  43,  28,  46,  13}, 
{48,  48,  10,  46,  13}, 
{49,  45,  14,  46,  13}, 
{46,  34,  39,  47,  12}, 
{48,  49,  6,  47,  12}, 
{47,  44,  14,  47,  12}, 
{47,  43,  20,  47,  11}, 
{49,  48,  8,  47,  11}, 
{49,  49,  12,  44,  12}, 
{38,  36,  46,  43,  10}, 
{40,  26,  47,  43,  15}, 
{9,  35,  45,  44,  14}, 
{40,  36,  46,  41,  13}, 
{29,  32,  48,  42,  12}, 
{39,  31,  47,  42,  15}, 
{36,  33,  47,  42,  12}, 
{32,  33,  45,  44,  11}, 
{40,  29,  45,  44,  11}, 
{40,  24,  45,  45,  11}, 
{45,  25,  46,  42,  11}, 
{41,  28,  47,  42,  12}, 
{41,  36,  42,  42,  11}, 
{41,  27,  47,  43,  11}, 
{48,  49,  48,  8,  10}, 
{45,  46,  48,  13,  15}, 
{49,  44,  48,  5,  12}, 
{46,  49,  49,  1,  12}, 
{46,  46,  47,  14,  11}, 
{49,  45,  42,  34,  10}, 
{47,  41,  43,  25,  13}, 
{46,  43,  43,  26,  13}, 
{47,  43,  43,  25,  13}, 
{49,  43,  43,  24,  12}, 
{47,  46,  43,  24,  11}, 
{49,  45,  43,  25,  11}, 
{49,  43,  43,  26,  11}, 
{49,  49,  46,  6,  10}, 
{46,  47,  40,  42,  10}, 
{47,  47,  37,  39,  11}, 
{46,  48,  40,  39,  11}, 
{47,  46,  38,  43,  10}, 
{47,  43,  37,  44,  12}, 
{47,  43,  38,  44,  11}, 
{37,  46,  43,  41,  10}, 
{40,  45,  42,  41,  11}, 
{47,  45,  34,  46,  10}, 
{46,  44,  36,  46,  11}, 
{44,  41,  24,  49,  10}, 
{37,  39,  26,  49,  12}, 
{43,  42,  21,  49,  11}, 
{43,  39,  25,  49,  11}, 
{47,  36,  23,  49,  11}, 
{47,  44,  28,  47,  10}, 
{47,  40,  29,  47,  13}, 
{48,  40,  28,  47,  12}, 
{49,  41,  21,  47,  11}, 
{49,  49,  49,  1,  10}, 
{47,  49,  49,  6,  10}, 
{44,  41,  34,  48,  10}, 
{45,  35,  34,  48,  13}, 
{48,  27,  35,  49,  10}, 
{34,  22,  36,  49,  11}, 
{15,  29,  35,  49,  11}, 
{6,  45,  25,  49,  10}, 
{31,  44,  15,  49,  11}, 
{49,  49,  49,  3,  10}, 
{48,  44,  49,  6,  12}, 
{46,  45,  42,  37,  10}, 
{46,  38,  42,  40,  11}, 
{47,  38,  35,  47,  10}, 
{36,  36,  47,  42,  10}, 
{29,  36,  48,  41,  14}, 
{26,  35,  49,  41,  11}, 
{4,  42,  31,  49,  10}, 
{42,  41,  42,  42,  10}, 
{45,  29,  42,  43,  11}, 
{49,  49,  42,  21,  10}, 
{47,  43,  41,  39,  10}, 
{47,  38,  40,  43,  12}, 
{49,  41,  39,  44,  10}, 
{47,  44,  39,  41,  13}, 
{47,  47,  42,  30,  10}, 
{46,  48,  43,  24,  11}, 
{47,  45,  47,  13,  10}, 
{49,  41,  46,  14,  12}, 
{47,  45,  49,  11,  10}, 
{49,  41,  49,  13,  15}, 
{46,  30,  49,  35,  12}, 
{47,  46,  49,  10,  11}, 
{48,  45,  48,  9,  11}, 
{46,  41,  49,  14,  11}, 
{47,  8,  49,  39,  11}, 
{47,  49,  49,  9,  10}, 
{48,  49,  48,  9,  13}, 
{47,  49,  46,  10,  11}, 
{46,  48,  49,  10,  12}, 
{45,  48,  48,  14,  11}, 
{45,  49,  46,  17,  11}, 
{46,  47,  47,  13,  11}, 
{46,  45,  44,  27,  10}, 
{46,  37,  44,  35,  13}, 
{49,  41,  43,  27,  12}, 
{46,  40,  44,  28,  11}, 
{46,  43,  43,  35,  10}, 
{45,  38,  33,  48,  10}, 
{48,  36,  37,  47,  10}, 
{47,  42,  39,  45,  10}, 
{47,  44,  39,  42,  12}, 
{48,  40,  39,  45,  11}, 
{48,  42,  34,  45,  12}, 
{25,  46,  44,  41,  10}, 
{38,  43,  44,  41,  11}, 
{45,  41,  25,  48,  10}, 
{45,  39,  10,  49,  11}, 
{47,  48,  36,  39,  10}, 
{47,  48,  34,  40,  11}, 
{35,  26,  47,  44,  10}, 
{14,  24,  49,  45,  11}, 
{46,  47,  42,  34,  10}, 
{45,  37,  42,  41,  10}, 
{43,  39,  42,  41,  11}, 
{42,  28,  48,  42,  10}, 
{38,  33,  45,  44,  10}, 
{42,  42,  24,  49,  10}, 
{47,  36,  25,  49,  10}, 
{7,  38,  42,  46,  10}, 
{46,  49,  42,  28,  10}, 
{43,  42,  42,  41,  10}, 
{47,  36,  33,  48,  10}, 
{21,  34,  49,  42,  10}, 
{49,  42,  40,  37,  10}, 
{46,  43,  44,  30,  10}, 
{47,  44,  37,  44,  10}, 
{46,  44,  38,  46,  10}, 
{46,  45,  40,  44,  10}, 
{46,  46,  37,  44,  12}, 
{46,  47,  35,  43,  10}, 
{48,  46,  37,  37,  10}, 
{46,  46,  43,  27,  10}, 
{47,  46,  43,  26,  10}, 
{48,  27,  45,  37,  10}, 
{47,  20,  45,  44,  11}, 
{49,  44,  14,  47,  10}, 
{46,  41,  47,  17,  10}, 
{46,  41,  46,  19,  11}, 
{46,  44,  46,  18,  11}, 
{46,  46,  46,  16,  11}, 
{47,  41,  47,  15,  11}, 
{49,  36,  33,  47,  10}, 
{49,  36,  38,  46,  10}, 
{44,  24,  49,  43,  10}, 
{47,  40,  44,  25,  10}, 
{49,  48,  44,  11,  10}, 
{36,  40,  26,  49,  10}, 
{49,  44,  49,  7,  10}, 
{35,  35,  29,  49,  10}, 
{49,  42,  8,  48,  10}, 
{14,  38,  32,  49,  10}, 
{46,  37,  44,  36,  10}, 
{46,  37,  46,  27,  10}, 
{45,  37,  46,  32,  10}, 
{30,  32,  49,  42,  10}, 
{40,  33,  31,  49,  10}, 
{34,  48,  22,  48,  10}, 
{30,  30,  36,  48,  10}, 
{5,  28,  46,  44,  10}, 
{46,  36,  40,  47,  10}, 
{49,  44,  43,  26,  10}, 
{48,  28,  49,  31,  10}, 
{49,  32,  44,  36,  11}, 
{44,  42,  21,  49,  10}, 
{29,  36,  49,  41,  10}, 
{49,  39,  49,  15,  10}, 
{35,  25,  48,  44,  10}, 
{25,  35,  45,  44,  10}, 
{49,  37,  10,  49,  10}, 
{10,  45,  23,  49,  10}, 
{26,  43,  25,  49,  10}, 
{29,  44,  22,  49,  12}, 
{45,  39,  30,  48,  10}, 
{47,  49,  48,  47,  9}, 
{8,  36,  49,  44,  13}, 
{31,  22,  49,  46,  13}, 
{49,  43,  43,  29,  13}, 
{48,  34,  48,  33,  13}, 
{48,  41,  45,  24,  13}, 
{12,  33,  49,  45,  13}, 
{21,  36,  49,  43,  13}, 
{48,  39,  39,  47,  12}, 
{48,  49,  16,  45,  12}, 
{47,  49,  49,  10,  12}, 
{28,  29,  49,  45,  12}, 
{33,  41,  49,  41,  11}, 
{46,  41,  49,  24,  11}, 
{48,  39,  49,  25,  14}, 
{25,  33,  49,  46,  11}, 
{30,  33,  49,  45,  13}, 
{29,  43,  49,  41,  11}, 
{48,  46,  20,  46,  11}, 
{48,  38,  44,  37,  11}, 
{44,  26,  49,  44,  11}, 
{46,  43,  49,  14,  11}, 
{36,  46,  49,  43,  10}, 
{33,  32,  49,  45,  11}, 
{48,  47,  36,  42,  10}, 
{48,  48,  31,  41,  13}, 
{48,  48,  31,  42,  11}, 
{49,  41,  42,  41,  10}, 
{48,  26,  46,  42,  12}, 
{41,  41,  49,  42,  10}, 
{43,  37,  49,  42,  11}, 
{48,  40,  39,  47,  10}, 
{45,  42,  49,  26,  10}, 
{46,  40,  49,  29,  11}, 
{45,  40,  49,  35,  11}, 
{48,  42,  45,  24,  10}, 
{48,  48,  45,  21,  10}, 
{49,  46,  17,  46,  10}, 
{40,  36,  49,  43,  10}, 
{44,  39,  49,  41,  10}, 
{41,  42,  49,  41,  10}, 
{49,  39,  41,  43,  10}, 
{48,  28,  42,  47,  10}, 
{49,  33,  38,  47,  10}, 
{49,  49,  9,  46,  10}, 
{42,  41,  49,  41,  10}, 
{48,  36,  45,  41,  10}, 
{49,  34,  42,  44,  10}, 
{48,  49,  22,  43,  10}, 
{48,  47,  35,  44,  10}, 
{48,  49,  20,  46,  11}, 
{44,  43,  39,  48,  9}, 
{46,  34,  35,  48,  12}, 
{45,  31,  37,  48,  12}, 
{44,  44,  24,  48,  11}, 
{45,  30,  39,  48,  11}, 
{25,  1,  40,  48,  10}, 
{45,  37,  35,  48,  10}, 
{44,  46,  23,  48,  10}, 
{48,  23,  39,  48,  10}, 
{48,  49,  47,  40,  9}, 
{48,  42,  48,  21,  14}, 
{48,  49,  28,  42,  13}, 
{49,  46,  42,  32,  13}, 
{49,  42,  38,  41,  12}, 
{48,  49,  48,  16,  11}, 
{48,  43,  48,  29,  11}, 
{49,  43,  39,  40,  11}, 
{49,  43,  43,  38,  11}, 
{49,  45,  42,  37,  11}, 
{49,  44,  38,  40,  11}, 
{49,  49,  34,  37,  10}, 
{48,  49,  25,  45,  10}, 
{48,  49,  28,  43,  11}, 
{49,  46,  37,  40,  10}, 
{49,  47,  40,  37,  10}, 
{49,  44,  39,  40,  10}, 
{49,  45,  40,  38,  10}, 
{49,  42,  37,  44,  10}, 
{48,  48,  27,  45,  10}, 
{49,  42,  38,  43,  10}, 
{49,  45,  38,  40,  10}, 
{42,  49,  34,  48,  9}, 
{43,  49,  25,  48,  12}, 
{43,  49,  49,  44,  9}, 
{44,  37,  49,  44,  13}, 
{40,  32,  49,  45,  11}, 
{44,  43,  49,  42,  10}, 
{49,  35,  36,  49,  9}, 
{47,  36,  28,  49,  11}, 
{19,  42,  28,  49,  10}, 
{47,  36,  36,  48,  10}, 
{40,  39,  26,  49,  10}, 
{41,  37,  29,  49,  10}, 
{18,  42,  29,  49,  11}, 
{13,  42,  31,  49,  10}, 
{48,  46,  42,  44,  9}, 
{49,  46,  37,  41,  13}, 
{49,  43,  41,  43,  12}, 
{49,  44,  38,  42,  13}, 
{49,  44,  40,  40,  11}, 
{48,  47,  38,  42,  10}, 
{47,  49,  49,  30,  9}, 
{48,  38,  49,  33,  11}, 
{48,  34,  49,  39,  10}, 
{46,  47,  49,  42,  9}, 
{47,  44,  49,  31,  11}, 
{46,  49,  49,  31,  10}, 
{39,  33,  39,  49,  9}, 
{47,  23,  38,  49,  10}, 
{37,  40,  49,  47,  9}, 
{39,  35,  49,  47,  12}, 
{48,  47,  34,  46,  9}, 
{49,  44,  34,  45,  10}, 
{17,  18,  46,  48,  9}, 
{43,  44,  35,  48,  9}, 
{48,  45,  44,  43,  9}, 
{48,  40,  45,  44,  11}, 
{49,  48,  28,  43,  9}, 
{48,  48,  48,  32,  9}, 
{48,  49,  48,  23,  12}, 
{49,  38,  35,  48,  9}, 
{46,  39,  24,  48,  11}, 
{49,  39,  20,  48,  11}, 
{47,  37,  25,  49,  10}, 
{49,  39,  15,  49,  11}, 
{46,  41,  8,  49,  12}, 
{49,  47,  36,  41,  9}, 
{49,  47,  30,  42,  12}, 
{49,  48,  31,  40,  10}, 
{49,  48,  29,  42,  10}, 
{46,  49,  49,  40,  9}, 
{36,  42,  29,  49,  9}, 
{40,  39,  28,  49,  13}, 
{41,  39,  28,  49,  10}, 
{49,  45,  43,  38,  9}, 
{49,  44,  36,  45,  9}, 
{44,  47,  31,  48,  9}, 
{43,  47,  33,  48,  11}, 
{43,  49,  27,  48,  10}, 
{48,  45,  46,  41,  9}, 
{48,  41,  45,  43,  10}, 
{49,  47,  25,  45,  9}, 
{49,  48,  25,  44,  10}, 
{49,  44,  32,  46,  9}, 
{49,  46,  25,  46,  10}, 
{48,  48,  32,  45,  9}, 
{48,  49,  45,  41,  9}, 
{48,  49,  34,  42,  11}, 
{48,  48,  40,  42,  9}, 
{48,  49,  29,  46,  9}, 
{25,  3,  40,  49,  9}, 
{49,  45,  34,  45,  9}, 
{49,  41,  40,  45,  9}, 
{49,  40,  40,  46,  10}, 
{48,  48,  36,  43,  9}, 
{48,  48,  34,  45,  10}, 
{48,  49,  34,  44,  9}, 
{41,  37,  30,  49,  9}, 
{17,  37,  33,  49,  10}, 
{17,  36,  34,  49,  10}, 
{49,  49,  32,  38,  9}, 
{49,  45,  41,  39,  9}, 
{49,  47,  42,  32,  9}, 
{49,  47,  43,  24,  11}, 
{47,  42,  49,  34,  9}, 
{48,  46,  44,  42,  9}, 
{27,  45,  23,  49,  9}, 
{49,  43,  42,  43,  9}, 
{49,  48,  36,  37,  9}, 
{8,  38,  34,  49,  9}, 
{49,  43,  43,  41,  9}, 
{49,  45,  37,  42,  9}, 
{49,  37,  36,  48,  9}, 
{25,  5,  45,  48,  9}, 
{45,  49,  44,  48,  8}, 
{47,  23,  44,  48,  12}, 
{49,  3,  40,  49,  10}, 
{27,  18,  46,  48,  10}, 
{27,  28,  46,  48,  9}, 
{49,  49,  49,  36,  8}, 
{48,  41,  48,  40,  12}, 
{47,  39,  49,  42,  12}, 
{49,  44,  46,  37,  11}, 
{49,  45,  45,  37,  11}, 
{48,  42,  48,  39,  10}, 
{48,  49,  48,  37,  10}, 
{48,  43,  48,  40,  11}, 
{49,  45,  45,  38,  10}, 
{49,  43,  48,  38,  9}, 
{47,  49,  49,  47,  8}, 
{44,  44,  36,  49,  8}, 
{32,  45,  23,  49,  10}, 
{45,  37,  32,  49,  9}, 
{48,  49,  44,  45,  8}, 
{49,  44,  37,  45,  9}, 
{49,  48,  44,  41,  8}, 
{49,  46,  45,  38,  11}, 
{49,  44,  45,  40,  10}, 
{49,  49,  37,  42,  8}, 
{49,  49,  22,  44,  13}, 
{49,  47,  38,  42,  10}, 
{49,  49,  22,  45,  9}, 
{49,  49,  38,  38,  9}, 
{49,  43,  32,  48,  8}, 
{46,  45,  25,  48,  10}, 
{48,  45,  26,  47,  10}, 
{48,  49,  21,  47,  13}, 
{48,  47,  31,  47,  9}, 
{48,  49,  28,  47,  9}, 
{46,  45,  31,  48,  9}, 
{47,  41,  15,  49,  9}, 
{45,  43,  13,  49,  10}, 
{48,  45,  32,  47,  9}, 
{48,  45,  9,  48,  9}, 
{48,  47,  40,  46,  8}, 
{49,  44,  37,  46,  9}, 
{48,  45,  46,  44,  8}, 
{48,  41,  47,  42,  10}, 
{48,  46,  45,  42,  10}, 
{48,  47,  45,  42,  9}, 
{46,  44,  36,  48,  8}, 
{46,  49,  34,  48,  8}, 
{48,  48,  9,  48,  9}, 
{48,  49,  48,  40,  8}, 
{49,  48,  46,  38,  8}, 
{49,  44,  46,  39,  9}, 
{49,  43,  47,  40,  9}, 
{48,  45,  48,  42,  8}, 
{29,  27,  48,  48,  8}, 
{46,  33,  45,  48,  8}, 
{30,  29,  46,  48,  13}, 
{49,  36,  37,  48,  11}, 
{48,  36,  39,  48,  11}, 
{30,  30,  46,  48,  10}, 
{30,  28,  47,  48,  10}, 
{37,  34,  45,  48,  9}, 
{47,  34,  41,  48,  9}, 
{49,  49,  39,  40,  8}, 
{48,  48,  45,  44,  8}, 
{49,  44,  33,  47,  8}, 
{49,  45,  23,  47,  10}, 
{48,  41,  40,  47,  8}, 
{45,  38,  35,  49,  8}, 
{46,  39,  16,  49,  9}, 
{45,  39,  33,  49,  9}, 
{49,  49,  29,  43,  8}, 
{49,  49,  25,  44,  9}, 
{46,  41,  37,  48,  8}, 
{47,  44,  32,  48,  8}, 
{48,  45,  47,  43,  8}, 
{48,  45,  34,  47,  8}, 
{49,  48,  22,  46,  8}, 
{49,  48,  15,  47,  10}, 
{49,  49,  12,  47,  9}, 
{1,  35,  46,  48,  8}, 
{49,  45,  32,  46,  8}, 
{49,  43,  47,  43,  8}, 
{49,  47,  44,  42,  8}, 
{49,  44,  40,  44,  8}, 
{49,  45,  40,  43,  8}, 
{49,  44,  43,  43,  8}, 
{48,  48,  33,  46,  8}, 
{49,  45,  35,  45,  8}, 
{48,  42,  45,  45,  8}, 
{49,  47,  25,  46,  8}, 
{49,  40,  48,  44,  8}, 
{48,  49,  30,  46,  8}, 
{49,  45,  25,  47,  8}, 
{49,  44,  15,  48,  8}, 
{49,  45,  45,  39,  8}, 
{48,  34,  41,  48,  8}, 
{45,  40,  21,  49,  8}, 
{49,  40,  15,  49,  8}, 
{49,  43,  34,  47,  8}, 
{46,  49,  49,  48,  7}, 
{42,  46,  41,  49,  7}, 
{43,  31,  41,  49,  14}, 
{45,  29,  41,  49,  13}, 
{45,  31,  41,  49,  11}, 
{45,  35,  38,  49,  9}, 
{43,  39,  37,  49,  10}, 
{44,  34,  41,  49,  8}, 
{43,  40,  37,  49,  8}, 
{43,  35,  39,  49,  8}, 
{46,  26,  40,  49,  8}, 
{49,  49,  46,  45,  7}, 
{49,  47,  27,  46,  13}, 
{49,  41,  47,  45,  10}, 
{48,  49,  48,  42,  8}, 
{48,  47,  47,  43,  9}, 
{39,  49,  36,  49,  7}, 
{36,  47,  37,  49,  8}, 
{49,  49,  49,  41,  7}, 
{49,  42,  49,  42,  9}, 
{48,  47,  49,  42,  8}, 
{48,  49,  44,  46,  7}, 
{49,  43,  36,  48,  7}, 
{47,  49,  36,  48,  7}, 
{46,  43,  32,  49,  7}, 
{49,  40,  21,  49,  10}, 
{47,  41,  19,  49,  8}, 
{42,  36,  42,  49,  7}, 
{45,  31,  42,  49,  11}, 
{48,  49,  48,  44,  7}, 
{49,  44,  45,  46,  7}, 
{49,  28,  42,  48,  8}, 
{49,  47,  48,  43,  7}, 
{48,  47,  36,  47,  7}, 
{48,  42,  43,  47,  7}, 
{49,  40,  45,  47,  8}, 
{48,  49,  27,  48,  7}, 
{49,  45,  23,  48,  9}, 
{48,  49,  47,  45,  7}, 
{49,  49,  28,  46,  7}, 
{39,  47,  38,  49,  7}, 
{49,  46,  34,  46,  7}, 
{43,  41,  38,  49,  7}, 
{43,  42,  37,  49,  9}, 
{45,  44,  32,  49,  7}, 
{48,  45,  45,  46,  7}, 
{49,  44,  47,  45,  7}, 
{47,  35,  38,  49,  7}, 
{48,  31,  42,  49,  7}, 
{48,  48,  32,  47,  7}, 
{47,  39,  27,  49,  7}, 
{43,  37,  39,  49,  7}, 
{47,  41,  23,  49,  7}, 
{47,  37,  33,  49,  7}, 
{44,  32,  42,  49,  7}, 
{46,  38,  33,  49,  7}, 
{45,  47,  48,  49,  6}, 
{47,  33,  43,  49,  11}, 
{40,  49,  34,  49,  9}, 
{47,  36,  47,  49,  8}, 
{48,  30,  48,  49,  8}, 
{40,  49,  36,  49,  7}, 
{49,  49,  46,  47,  6}, 
{49,  41,  47,  47,  8}, 
{49,  41,  48,  47,  7}, 
{49,  49,  49,  46,  6}, 
{49,  41,  49,  47,  8}, 
{49,  42,  47,  47,  7}, 
{47,  48,  48,  48,  6}, 
{48,  40,  39,  48,  9}, 
{48,  41,  39,  48,  8}, 
{49,  42,  37,  48,  7}, 
{48,  40,  41,  48,  7}, 
{45,  49,  41,  49,  6}, 
{48,  49,  39,  48,  6}, 
{44,  45,  49,  49,  6}, 
{44,  49,  42,  49,  6}, 
{49,  43,  42,  48,  6}, 
{49,  34,  42,  49,  7}, 
{48,  48,  47,  47,  6}, 
{49,  43,  49,  47,  6}, 
{47,  49,  42,  48,  6}, 
{48,  46,  48,  47,  6}, 
{48,  44,  49,  47,  7}, 
{46,  43,  34,  49,  6}, 
{48,  43,  14,  49,  6}, 
{47,  43,  22,  49,  7}, 
{49,  37,  34,  49,  6}, 
{49,  29,  49,  49,  6}, 
{46,  49,  49,  49,  5}, 
{47,  38,  41,  49,  6}, 
{48,  49,  49,  48,  5}, 
{49,  46,  36,  48,  5}, 
{49,  46,  49,  47,  5}, 
{49,  43,  27,  49,  5}, 
{49,  49,  27,  48,  5}, 
{47,  43,  30,  49,  5}, 
{49,  48,  29,  48,  5}, 
{49,  43,  43,  48,  5}, 
{48,  38,  44,  49,  5}, 
{49,  40,  29,  49,  5}, 
{48,  49,  49,  49,  4}, 
{49,  49,  49,  48,  4}, 
{49,  43,  40,  49,  4}, 
{49,  44,  49,  49,  3}, 
{49,  49,  49,  49,  2}};

static BtkLookupTable DefaultTableMegaBACE = {
    sizeof(DefaultParamMegaBACEEntries)/ sizeof(DefaultParamMegaBACEEntries[0]),
    DefaultParamMegaBACEEntries,
    sizeof(DefaultTableMegaBACEEntries)/ sizeof(DefaultTableMegaBACEEntries[0]),
    DefaultTableMegaBACEEntries
};

BtkLookupTable *
Btk_get_mbace_table(void)
{
    return &DefaultTableMegaBACE;
}


