/*-------------------------------------------------------------------------*\

	FILE........: DFT.C
	TYPE........: C Module
	COMPANY.....: VoiceTronix
	AUTHOR......: David Rowe
	DATE CREATED: 17/6/96

	DFT calling function.

\*-------------------------------------------------------------------------*/

#include "four_sh3.h"
#include "shift.h"
#include "dftwin.h"
#include "dft.h"

// windows a Nsam vector of speech samples.
static inline void window(int Wn[], int sn[], int Nsam, int window_table[],int nrsh)
/*  int	 Wn[];			output frame of windowed samples	*/
/*  int  sn[];			input frame of speech samples		*/
/*  int	 Nsam;			number of samples			*/
/*  int	 window_table[];	LOOK-UP TABLE				*/
/*  int  nrsh;			number of right shifts	(only)		*/
{
    /* nrsh = 18 for hanning, and 15 for DFT 	*/

    int i = 0;
    for(; i<Nsam; ++i)
	Wn[i] = (long)sn[i] * (long)window_table[i] >> nrsh; /*(1l<<15);*/
}

/*--------------------------------------------------------------------------*\

	FUNCTION....: dft()

	AUTHOR......: David Rowe & John Kostogiannis
	DATE CREATED: 27/6/96

	Centres, windows and DFTs a block of speech samples.
	Changed to fixed point.

        int   x[];	NDFT real input samples
        COMPF X[];	NDFT/2 + 2 complex output samples

\*--------------------------------------------------------------------------*/

void dft(int x[], COMPF X[])
{
    int   Sn_fix[NDFT] = { [0 ... NDFT-1] = 0 };  /* windowed input signal */

    /* window speech samples */
    window(Sn_fix, x, NDFT, dftwin, 15);

    /* find DFT of Sn_fix[] */
    four_sh3(&X[-1].imag,&Sn_fix[-1],NDFT,twiddle);

    /* scaling such that energy in frequency domain equals energy in time */
    shift_vector((int*)X, (int*)X, -2, NDFT);
}

