/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.mvc.condition.AbstractMediaTypeExpression;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.MediaTypeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProducesRequestCondition
extends AbstractRequestCondition<ProducesRequestCondition> {
    private final List<ProduceMediaTypeExpression> expressions;
    private final ContentNegotiationManager contentNegotiationManager;
    private final List<ProduceMediaTypeExpression> MEDIA_TYPE_ALL_LIST = Collections.singletonList(new ProduceMediaTypeExpression("*/*"));

    public ProducesRequestCondition(String ... produces) {
        this(produces, (String[])null);
    }

    public ProducesRequestCondition(String[] produces, String[] headers) {
        this(produces, headers, (ContentNegotiationManager)null);
    }

    public ProducesRequestCondition(String[] produces, String[] headers, ContentNegotiationManager manager) {
        this.expressions = new ArrayList<ProduceMediaTypeExpression>(this.parseExpressions(produces, headers));
        Collections.sort(this.expressions);
        this.contentNegotiationManager = manager != null ? manager : new ContentNegotiationManager();
    }

    private Set<ProduceMediaTypeExpression> parseExpressions(String[] produces, String[] headers) {
        LinkedHashSet<ProduceMediaTypeExpression> result = new LinkedHashSet<ProduceMediaTypeExpression>();
        if (headers != null) {
            for (String header : headers) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!"Accept".equalsIgnoreCase(expr.name)) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)((String)expr.value))) {
                    result.add(new ProduceMediaTypeExpression(mediaType, expr.isNegated));
                }
            }
        }
        if (produces != null) {
            for (String produce : produces) {
                result.add(new ProduceMediaTypeExpression(produce));
            }
        }
        return result;
    }

    private ProducesRequestCondition(Collection<ProduceMediaTypeExpression> expressions, ContentNegotiationManager manager) {
        this.expressions = new ArrayList<ProduceMediaTypeExpression>(expressions);
        Collections.sort(this.expressions);
        this.contentNegotiationManager = manager != null ? manager : new ContentNegotiationManager();
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getProducibleMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result.add(expression.getMediaType());
        }
        return result;
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected List<ProduceMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ProducesRequestCondition combine(ProducesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    public ProducesRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.isEmpty()) {
            return this;
        }
        LinkedHashSet<ProduceMediaTypeExpression> result = new LinkedHashSet<ProduceMediaTypeExpression>(this.expressions);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ProduceMediaTypeExpression expression = (ProduceMediaTypeExpression)iterator.next();
            if (expression.match(request)) continue;
            iterator.remove();
        }
        return result.isEmpty() ? null : new ProducesRequestCondition(result, this.contentNegotiationManager);
    }

    @Override
    public int compareTo(ProducesRequestCondition other, HttpServletRequest request) {
        try {
            List<MediaType> acceptedMediaTypes = this.getAcceptedMediaTypes(request);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                int otherIndex;
                int thisIndex = this.indexOfEqualMediaType(acceptedMediaType);
                int result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfEqualMediaType(acceptedMediaType));
                if (result != 0) {
                    return result;
                }
                thisIndex = this.indexOfIncludedMediaType(acceptedMediaType);
                result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfIncludedMediaType(acceptedMediaType));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        catch (HttpMediaTypeNotAcceptableException e) {
            throw new IllegalStateException("Cannot compare without having any requested media types");
        }
    }

    private List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> mediaTypes = this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private int indexOfEqualMediaType(MediaType mediaType) {
        for (int i = 0; i < this.getExpressionsToCompare().size(); ++i) {
            MediaType currentMediaType = this.getExpressionsToCompare().get(i).getMediaType();
            if (!mediaType.getType().equalsIgnoreCase(currentMediaType.getType()) || !mediaType.getSubtype().equalsIgnoreCase(currentMediaType.getSubtype())) continue;
            return i;
        }
        return -1;
    }

    private int indexOfIncludedMediaType(MediaType mediaType) {
        for (int i = 0; i < this.getExpressionsToCompare().size(); ++i) {
            if (!mediaType.includes(this.getExpressionsToCompare().get(i).getMediaType())) continue;
            return i;
        }
        return -1;
    }

    private int compareMatchingMediaTypes(ProducesRequestCondition condition1, int index1, ProducesRequestCondition condition2, int index2) {
        int result = 0;
        if (index1 != index2) {
            result = index2 - index1;
        } else if (index1 != -1 && index2 != -1) {
            ProduceMediaTypeExpression expr2;
            ProduceMediaTypeExpression expr1 = condition1.getExpressionsToCompare().get(index1);
            result = expr1.compareTo(expr2 = condition2.getExpressionsToCompare().get(index2));
            result = result != 0 ? result : expr1.getMediaType().compareTo(expr2.getMediaType());
        }
        return result;
    }

    private List<ProduceMediaTypeExpression> getExpressionsToCompare() {
        return this.expressions.isEmpty() ? this.MEDIA_TYPE_ALL_LIST : this.expressions;
    }

    class ProduceMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ProduceMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        ProduceMediaTypeExpression(String expression) {
            super(expression);
        }

        protected boolean matchMediaType(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
            List acceptedMediaTypes = ProducesRequestCondition.this.getAcceptedMediaTypes(request);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!this.getMediaType().isCompatibleWith(acceptedMediaType)) continue;
                return true;
            }
            return false;
        }
    }
}

