# 10 Would laissez-faire capitalism be stable?

Unsurprisingly, right-libertarians combine their support for "absolute
property rights" with a whole-hearted support for laissez-faire capitalism. In
such a system (which they maintain, to quote Ayn Rand, is an _"unknown
ideal"_) everything would be private property and there would be few (if any)
restrictions on "voluntary exchanges." "Anarcho"-capitalists are the most
extreme of defenders of pure capitalism, urging that the state itself be
privatised and no voluntary exchange made illegal (for example, children would
be considered the property of their parents and it would be morally right to
turn them into child prostitutes -- the child has the option of leaving home
if they object).

As there have been no example of "pure" capitalism it is difficult to say
whether their claims about are true (for a discussion of a close approximation
see the section [10.3](append1310.html#secf103)). This section of the FAQ is
an attempt to discover whether such a system would be stable or whether it
would be subject to the usual booms and slumps. Before starting we should note
that there is some disagreement within the right-libertarian camp itself on
this subject (although instead of stability they usually refer to
"equilibrium" -- which is an economics term meaning that all of a societies
resources are fully utilised).

In general terms, most right-Libertarians' reject the concept of equilibrium
as such and instead stress that the economy is inherently a dynamic (this is a
key aspect of the Austrian school of economics). Such a position is correct,
of course, as such noted socialists as Karl Marx and Michal Kalecki and
capitalist economists as Keynes recognised long ago. There seems to be two
main schools of thought on the nature of disequilibrium. One, inspired by von
Mises, maintains that the actions of the entrepreneur/capitalist results in
the market co-ordinating supply and demand and another, inspired by Joseph
Schumpeter, who question whether markets co-ordinate because entrepreneurs are
constantly innovating and creating new markets, products and techniques.

Of course both actions happen and we suspect that the differences in the two
approaches are not important. The important thing to remember is that
"anarcho"-capitalists and right-libertarians in general reject the notion of
equilibrium -- but when discussing their utopia they do not actually indicate
this! For example, most "anarcho"-capitalists will maintain that the existence
of government (and/or unions) causes unemployment by either stopping
capitalists investing in new lines of industry or forcing up the price of
labour above its market clearing level (by, perhaps, restricting immigration,
minimum wages, taxing profits). Thus, we are assured, the worker will be
better off in "pure" capitalism because of the unprecedented demand for labour
it will create. However, full employment of labour is an equilibrium in
economic terms and that, remember, is impossible due to the dynamic nature of
the system. When pressed, they will usually admit there will be periods of
unemployment as the market adjusts or that full unemployment actually means
under a certain percentage of unemployment. Thus, if you (rightly) reject the
notion of equilibrium you also reject the idea of full employment and so the
labour market becomes a buyers market and labour is at a massive disadvantage.

The right-libertarian case is based upon logical deduction, and the premises
required to show that laissez-faire will be stable are somewhat incredible. If
banks do not set the wrong interest rate, if companies do not extend too much
trade credit, if workers are willing to accept (real wage related) pay cuts,
if workers altruistically do not abuse their market power in a fully employed
society, if interest rates provide the correct information, if capitalists
predict the future relatively well, if banks and companies do not suffer from
isolation paradoxes, then, perhaps, laissez-faire will be stable.

So, will laissez-faire capitalism be stable? Let us see by analysing the
assumptions of right-libertarianism -- namely that there will be full
employment and that a system of private banks will stop the business cycle. We
will start on the banking system first (in section
[10.1](append1310.html#secf101)) followed by the effects of the labour market
on economic stability (in section [10.2](append1310.html#secf102)). Then we
will indicate, using the example of 19th century America, that actually
existing ("impure") laissez-faire was very unstable.

Explaining booms and busts by state action plays an ideological convenience as
it exonerates market processes as the source of instability within capitalism.
We hope to indicate in the next two sections why the business cycle is
inherent in the system (see also sections [C.7](secC7.html), [C.8](secC8.html)
and [C.9](secC9.html)).



## 10.1 Would privatising banking make capitalism stable?

It is claimed that the existence of the state (or, for minimal statists,
government policy) is the cause of the business cycle (recurring economic
booms and slumps). This is because the government either sets interest rates
too low or expands the money supply (usually by easing credit restrictions and
lending rates, sometimes by just printing fiat money). This artificially
increases investment as capitalists take advantage of the artificially low
interest rates. The real balance between savings and investment is broken,
leading to over-investment, a drop in the rate of profit and so a slump (which
is quite socialist in a way, as many socialists also see over-investment as
the key to understanding the business cycle, although they obviously attribute
the slump to different causes -- namely the nature of capitalist production,
not that the credit system does not play its part -- see section
[C.7](secC7.html)).

In the words of Austrian Economist W. Duncan Reekie, _"[t]he business cycle is
generated by monetary expansion and contraction . . . When new money is
printed it appears as if the supply of savings has increased. Interest rates
fall and businessmen are misled into borrowing additional founds to finance
extra investment activity . . . This would be of no consequence if it had been
the outcome of [genuine saving] . . . -but the change was government induced.
The new money reaches factor owners in the form of wages, rent and interest .
. . the factor owners will then spend the higher money incomes in their
existing consumption:investment proportions . . . Capital goods industries
will find their expansion has been in error and malinvestments have been
inoccured."_ [**Markets, Entrepreneurs and Liberty**, pp. 68-9]

In other words, there has been _"wasteful mis-investment due to government
interference with the market."_ [**Op. Cit.**, p. 69] In response to this
(negative) influence in the workings of the market, it is suggested by right-
libertarians that a system of private banks should be used and that interest
rates are set by them, via market forces. In this way an interest rate that
matches the demand and supply for savings will be reached and the business
cycle will be no more. By truly privatising the credit market, it is hoped by
the business cycle will finally stop.

Unsurprisingly, this particular argument has its weak points and in this
section of the FAQ we will try to show exactly why this theory is wrong.

Let us start with Reckie's starting point. He states that the _"main problem"_
of the slump is _"why is there suddenly a '**cluster**' of business errors?
Businessmen and entrepreneurs are market experts (otherwise they would not
survive) and why should they all make mistakes simultaneously?"_ [**Op.
Cit.**, p. 68] It is this _"cluster"_ of mistakes that the Austrians' take as
evidence that the business cycle comes from outside the workings of the market
(i.e. is exogenous in nature). Reekie argues that an _"error cluster only
occurs when all entrepreneurs have received the wrong signals on potential
profitability, and all have received the signals simultaneously through
government interference with the money supply."_ [**Op. Cit.**, p. 74] But is
this **really** the case?

The simple fact is that groups of (rational) individuals can act in the same
way based on the same information and this can lead to a collective problem.
For example, we do not consider it irrational that everyone in a building
leaves it when the fire alarm goes off and that the flow of people can cause
hold-ups at exits. Neither do we think that its unusual that traffic jams
occur, after all those involved are all trying to get to work (i.e. they are
reacting to the same desire). Now, is it so strange to think that capitalists
who all see the same opportunity for profit in a specific market decide to
invest in it? Or that the aggregate outcome of these individually rational
decisions may be irrational (i.e. cause a glut in the market)?

In other words, a "cluster" of business failures may come about because a
group of capitalists, acting in isolation, over-invest in a given market. They
react to the same information (namely super profits in market X), arrange
loans, invest and produce commodities to meet demand in that market. However,
the aggregate result of these individually rational actions is that the
aggregate supply far exceeds demand, causing a slump in that market and,
perhaps, business failures. The slump in this market (and the potential
failure of some firms) has an impact on the companies that supplied them, the
companies that are dependent on their employees wages/demand, the banks that
supplied the credit and so forth. The accumulative impact of this slump (or
failures) on the chain of financial commitments of which they are but one link
can be large and, perhaps, push an economy into general depression. Thus the
claim that it is something external to the system that causes depression is
flawed.

It could be claimed the interest rate is the problem, that it does not
accurately reflect the demand for investment or relate it to the supply of
savings. But, as we argued in section [C.8](secC8.html), it is not at all
clear that the interest rate provides the necessary information to
capitalists. They need investment information for their specific industry, but
the interest rate is cross-industry. Thus capitalists in market X do not know
if the investment in market X is increasing and so this lack of information
can easily cause "mal-investment" as over-investment (and so over-production)
occurs. As they have no way of knowing what the investment decisions of their
competitors are or now these decisions will affect an already unknown future,
capitalists may over-invest in certain markets and the net effects of this
aggregate mistake can expand throughout the whole economy and cause a general
slump. In other words, a cluster of business failures can be accounted for by
the workings of the market itself and **not** the (existence of) government.

This is **one** possible reason for an internally generated business cycle but
that is not the only one. Another is the role of class struggle which we
discuss in the [next section](append1310.html#secf102) and yet another is the
endogenous nature of the money supply itself. This account of money (proposed
strongly by, among others, the post-Keynesian school) argues that the money
supply is a function of the demand for credit, which itself is a function of
the level of economic activity. In other words, the banking system creates as
much money as people need and any attempt to control that creation will cause
economic problems and, perhaps, crisis (interestingly, this analysis has
strong parallels with mutualist and individualist anarchist theories on the
causes of capitalist exploitation and the business cycle). Money, in other
words, emerges from **within** the system and so the right-libertarian attempt
to "blame the state" is simply wrong.

Thus what is termed "credit money" (created by banks) is an essential part of
capitalism and would exist without a system of central banks. This is because
money is created from within the system, in response to the needs of
capitalists. In a word, money is endogenous and credit money an essential part
of capitalism.

Right-libertarians do not agree. Reekie argues that _"[o]nce fractional
reserve banking is introduced, however, the supply of money substitutes will
include fiduciary media. The ingenuity of bankers, other financial
intermediaries and the endorsement and **guaranteeing of their activities by
governments and central banks** has ensured that the quantity of fiat money is
immense."_ [**Op. Cit.**, p. 73]

Therefore, what "anarcho"-capitalists and other right-libertarians seem to be
actually complaining about when they argue that "state action" creates the
business cycle by creating excess money is that the state **allows** bankers
to meet the demand for credit by creating it. This makes sense, for the first
fallacy of this sort of claim is how could the state **force** bankers to
expand credit by loaning more money than they have savings. And this seems to
be the normal case within capitalism -- the central banks accommodate bankers
activity, they do not force them to do it. Alan Holmes, a senior vice
president at the New York Federal Reserve, stated that:

> _"In the real world, banks extend credit, creating deposits in the process,
and look for the reserves later. The question then becomes one of whether and
how the Federal Reserve will accommodate the demand for reserves. In the very
short run, the Federal Reserve has little or no choice about accommodating
that demand, over time, its influence can obviously be felt."_ [quoted by Doug
Henwood, **Wall Street**, p. 220]

(Although we must stress that central banks are **not** passive and do have
many tools for affecting the supply of money. For example, central banks can
operate "tight" money policies which can have significant impact on an economy
and, via creating high enough interest rates, the demand for money.)

It could be argued that because central banks exist, the state creates an
"environment" which bankers take advantage off. By not being subject to "free
market" pressures, bankers could be tempted to make more loans than they would
otherwise in a "pure" capitalist system (i.e. create credit money). The
question arises, would "pure" capitalism generate sufficient market controls
to stop banks loaning in excess of available savings (i.e. eliminate the
creation of credit money/fiduciary media).

It is to this question we now turn.

As noted above, the demand for credit is generated from **within** the system
and the comments by Holmes reinforce this. Capitalists seek credit in order to
make money and banks create it precisely because they are also seeking profit.
What right-libertarians actually object to is the government (via the central
bank) **accommodating** this creation of credit. If only the banks could be
forced to maintain a savings to loans ration of one, then the business cycle
would stop. But is this likely? Could market forces ensure that bankers pursue
such a policy? We think not -- simply because the banks are profit making
institutions. As post-Keynesianist Hyman Minsky argues, _"[b]ecause bankers
live in the same expectational climate as businessmen, profit-seeking bankers
will find ways of accommodating their customers. . . Banks and bankers are not
passive managers of money to lend or to invest; they are in business to
maximise profits. . ."_ [quoted by L. Randall Wray, **Money and Credit in
Capitalist Economies**, p. 85]

This is recognised by Reekie, in passing at least (he notes that _"fiduciary
media could still exist if bankers offered them and clients accepted them"_
[**Op. Cit.**, p. 73]). Bankers will tend to try and accommodate their
customers and earn as much money as possible. Thus Charles P. Kindleberger
comments that monetary expansion _"is systematic and endogenous rather than
random and exogenous"_ seem to fit far better the reality of capitalism that
the Austrian and right-libertarian viewpoint [**Manias, Panics, and Crashes**,
p. 59] and post-Keynesian L. Randall Wray argues that _"the money supply . . .
is more obviously endogenous in the monetary systems which predate the
development of a central bank."_ [**Op. Cit.**, p. 150]

In other words, the money supply cannot be directly controlled by the central
bank since it is determined by private decisions to enter into debt
commitments to finance spending. Given that money is generated from **within**
the system, can market forces ensure the non-expansion of credit (i.e. that
the demand for loans equals the supply of savings)? To begin to answer this
question we must note that investment is _"essentially determined by expected
profitability."_ [Philip Arestis, **The Post-Keynesian Approach to
Economics**, p. 103] This means that the actions of the banks cannot be taken
in isolation from the rest of the economy. Money, credit and banks are an
essential part of the capitalist system and they cannot be artificially
isolated from the expectations, pressures and influences of that system.

Let us assume that the banks desire to maintain a loans to savings ratio of
one and try to adjust their interest rates accordingly. Firstly, changes in
the rate of interest _"produce only a very small, if any, movement in business
investment"_ according to empirical evidence [**Op. Cit.**, pp. 82-83] and
that _"the demand for credit is extremely inelastic with respect to interest
rates."_ [L. Randall Wray, **Op. Cit.**, p. 245] Thus, to keep the supply of
savings in line with the demand for loans, interest rates would have to
increase greatly (indeed, trying to control the money supply by controlling
the monetary bases in this way will only lead to very big fluctuations in
interest rates). And increasing interest rates has a couple of paradoxical
effects.

According to economists Joseph Stiglitz and Andrew Weiss (in _"Credit
Rationing in Markets with Imperfect Knowledge"_, **American Economic Review**,
no. 71, pp. 393-410) interest rates are subject to what is called the _"lemons
problem"_ (asymmetrical information between buyer and seller). Stiglitz and
Weiss applied the "lemons problem" to the credit market and argued (and
unknowingly repeated Adam Smith) that at a given interest rate, lenders will
earn lower return by lending to bad borrowers (because of defaults) than to
good ones. If lenders try to increase interest rates to compensate for this
risk, they may chase away good borrowers, who are unwilling to pay a higher
rate, while perversely not chasing away incompetent, criminal, or malignantly
optimistic borrowers. This means that an increase in interest rates may
actually increase the possibilities of crisis, as more loans may end up in the
hands of defaulters.

This gives banks a strong incentive to keep interest rates lower than they
otherwise could be. Moreover, _"increases in interest rates make it more
difficult for economic agents to meet their debt repayments"_ [Philip Arestis,
**Op. Cit.**, pp. 237-8] which means when interest rates **are** raised,
defaults will increase and place pressures on the banking system. At high
enough short-term interest rates, firms find it hard to pay their interest
bills, which cause/increase cash flow problems and so _"[s]harp increases in
short term interest rates . . .leads to a fall in the present value of gross
profits after taxes (quasi-rents) that capital assets are expected to earn."_
[Hyman Minsky, **Post-Keynesian Economic Theory**, p. 45]

In addition, _"production of most investment goods is undertaken on order and
requires time for completion. A rise in interest rates is not likely to cause
firms to abandon projects in the process of production . . . This does not
mean . . . that investment is completely unresponsive to interest rates. A
large increase in interest rates causes a 'present value reversal', forcing
the marginal efficiency of capital to fall below the interest rate. If the
long term interest rate is also pushed above the marginal efficiency of
capital, the project may be abandoned."_ [Wray, **Op. Cit.**, pp. 172-3] In
other words, investment takes **time** and there is a lag between investment
decisions and actual fixed capital investment. So if interest rates vary
during this lag period, initially profitable investments may become white
elephants.

As Michal Kalecki argued, the rate of interest must be lower than the rate of
profit otherwise investment becomes pointless. The incentive for a firm to own
and operate capital is dependent on the prospective rate of profit on that
capital relative to the rate of interest at which the firm can borrow at. The
higher the interest rate, the less promising investment becomes.

If investment is unresponsive to all but very high interest rates (as we
indicated above), then a privatised banking system will be under intense
pressure to keep rates low enough to maintain a boom (by, perhaps, creating
credit above the amount available as savings). And if it does this, over-
investment and crisis is the eventual outcome. If it does not do this and
increases interest rates then consumption and investment will dry up as
interest rates rise and the defaulters (honest and dishonest) increase and a
crisis will eventually occur.

This is because increasing interest rates may increase savings **but** it also
reduce consumption (_"high interest rates also deter both consumers and
companies from spending, so that the domestic economy is weakened and
unemployment rises"_ [Paul Ormerod, **The Death of Economics**, p. 70]). This
means that firms can face a drop off in demand, causing them problems and
(perhaps) leading to a lack of profits, debt repayment problems and failure.
An increase in interest rates also reduces demand for investment goods, which
also can cause firms problems, increase unemployment and so on. So an increase
in interest rates (particularly a sharp rise) could reduce consumption and
investment (i.e. reduce aggregate demand) and have a ripple effect throughout
the economy which could cause a slump to occur.

In other words, interest rates and the supply and demand of savings/loans they
are meant to reflect may not necessarily move an economy towards equilibrium
(if such a concept is useful). Indeed, the workings of a "pure" banking system
without credit money may increase unemployment as demand falls in both
investment and consumption in response to high interest rates and a general
shortage of money due to lack of (credit) money resulting from the "tight"
money regime implied by such a regime (i.e. the business cycle would still
exist). This was the case of the failed Monetarist experiments on the early
1980s when central banks in America and Britain tried to pursue a "tight"
money policy. The "tight" money policy did not, in fact, control the money
supply. All it did do was increase interest rates and lead to a serious
financial crisis and a deep recession (as Wray notes, _"the central bank uses
tight money polices to raise interest rates"_ [**Op. Cit.**, p. 262]). This
recession, we must note, also broke the backbone of working class resistance
and the unions in both countries due to the high levels of unemployment it
generated. As intended, we are sure.

Such an outcome would not surprise anarchists, as this was a key feature of
the Individualist and Mutualist Anarchists' arguments against the "money
monopoly" associated with specie money. They argued that the "money monopoly"
created a "tight" money regime which reduced the demand for labour by
restricting money and credit and so allowed the exploitation of labour (i.e.
encouraged wage labour) and stopped the development of non-capitalist forms of
production. Thus Lysander Spooner's comments that workers need _"**money
capital** to enable them to buy the raw materials upon which to bestow their
labour, the implements and machinery with which to labour . . . Unless they
get this capital, they must all either work at a disadvantage, or not work at
all. A very large portion of them, to save themselves from starvation, have no
alternative but to sell their labour to others . . ."_ [**A Letter to Grover
Cleveland**, p. 39] It is interesting to note that workers **did** do well
during the 1950s and 1960s under a "liberal" money regime than they did under
the "tighter" regimes of the 1980s and 1990s.

We should also note that an extended period of boom will encourage banks to
make loans more freely. According to Minsky's _"financial instability model"_
crisis (see _"The Financial Instability Hypothesis"_ in **Post-Keynesian
Economic Theory** for example) is essentially caused by risky financial
practices during periods of financial tranquillity. In other words,
_"stability is destabilising."_ In a period of boom, banks are happy and the
increased profits from companies are flowing into their vaults. Over time,
bankers note that they can use a reserve system to increase their income and,
due to the general upward swing of the economy, consider it safe to do so (and
given that they are in competition with other banks, they may provide loans
simply because they are afraid of losing customers to more flexible
competitors). This increases the instability within the system (as firms
increase their debts due to the flexibility of the banks) and produces the
possibility of crisis if interest rates are increased (because the ability of
business to fulfil their financial commitments embedded in debts
deteriorates).

Even if we assume that interest rates **do** work as predicted in theory, it
is false to maintain that there is one interest rate. This is not the case.
_"Concentration of capital leads to unequal access to investment funds, which
obstructs further the possibility of smooth transitions in industrial
activity. Because of their past record of profitability, large enterprises
have higher credit ratings and easier access to credit facilities, and they
are able to put up larger collateral for a loan."_ [Michael A. Bernstein,
**The Great Depression**, p. 106] As we noted in section
[C.5.1](secC5.html#secc51), the larger the firm, the lower the interest rate
they have to pay. Thus banks routinely lower their interest rates to their
best clients even though the future is uncertain and past performance cannot
and does not indicate future returns. Therefore it seems a bit strange to
maintain that the interest rate will bring savings and loans into line if
there are different rates being offered.

And, of course, private banks cannot affect the underlying fundamentals that
drive the economy -- like productivity, working class power and political
stability -- any more than central banks (although central banks can influence
the speed and gentleness of adjustment to a crisis).

Indeed, given a period of full employment a system of private banks may
actually speed up the coming of a slump. As we argue in the [next
section](append1310.html#secf101), full employment results in a profits
squeeze as firms face a tight labour market (which drives up costs) and,
therefore, increased workers' power at the point of production and in their
power of exit. In a central bank system, capitalists can pass on these
increasing costs to consumers and so maintain their profit margins for longer.
This option is restricted in a private banking system as banks would be less
inclined to devalue their money. This means that firms will face a profits
squeeze sooner rather than later, which will cause a slump as firms cannot
make ends meet. As Reekie notes, inflation _"can temporarily reduce employment
by postponing the time when misdirected labour will be laid off"_ but as
Austrian's (like Monetarists) think _"inflation is a monetary phenomenon"_ he
does not understand the real causes of inflation and what they imply for a
"pure" capitalist system [**Op. Cit.**, p. 67, p. 74]. As Paul Ormerod points
out _"the claim that inflation is always and everywhere purely caused by
increases in the money supply, and that there the rate of inflation bears a
stable, predictable relationship to increases in the money supply is
ridiculous."_ And he notes that _"[i]ncreases in the rate of inflation tend to
be linked to falls in unemployment, and vice versa"_ which indicates its
**real** causes -- namely in the balance of class power and in the class
struggle. [**The Death of Economics**, p. 96, p. 131]

Moreover, if we do take the Austrian theory of the business cycle at face
value we are drawn to conclusion that in order to finance investment savings
must be increased. But to maintain or increase the stock of loanable savings,
inequality must be increased. This is because, unsurprisingly, rich people
save a larger proportion of their income than poor people and the proportion
of profits saved are higher than the proportion of wages. But increasing
inequality (as we argued in section [3.1](append133.html#secf31)) makes a
mockery of right-libertarian claims that their system is based on freedom or
justice.

This means that the preferred banking system of "anarcho"-capitalism implies
increasing, not decreasing, inequality within society. Moreover, most firms
(as we indicated in section [C.5.1](secC5.html#secc51)) fund their investments
with their own savings which would make it hard for banks to loan these
savings out as they could be withdrawn at any time. This could have serious
implications for the economy, as banks refuse to fund new investment simply
because of the uncertainty they face when accessing if their available savings
can be loaned to others (after all, they can hardly loan out the savings of a
customer who is likely to demand them at any time). And by refusing to fund
new investment, a boom could falter and turn to slump as firms do not find the
necessary orders to keep going.

So, would market forces create "sound banking"? The answer is probably not.
The pressures on banks to make profits come into conflict with the need to
maintain their savings to loans ration (and so the confidence of their
customers). As Wray argues, _"as banks are profit seeking firms, they find
ways to increase their liabilities which don't entail increases in reserve
requirements"_ and _"[i]f banks share the profit expectations of prospective
borrowers, they can create credit to allow [projects/investments] to
proceed."_ [**Op. Cit.**, p. 295, p. 283] This can be seen from the historical
record. As Kindleberger notes, _"the market will create new forms of money in
periods of boom to get around the limit"_ imposed on the money supply [**Op.
Cit.**, p. 63]. Trade credit is one way, for example. Under the Monetarist
experiments of 1980s, there was _"deregulation and central bank constraints
raised interest rates and created a moral hazard -- banks made increasingly
risky loans to cover rising costs of issuing liabilities. Rising competition
from nonbanks and tight money policy forced banks to lower standards and
increase rates of growth in an attempt to 'grow their way to profitability'"_
[**Op. Cit.**, p. 293]

Thus credit money ("fiduciary media") is an attempt to overcome the scarcity
of money within capitalism, particularly the scarcity of specie money. The
pressures that banks face within "actually existing" capitalism would still be
faced under "pure" capitalism. It is likely (as Reekie acknowledges) that
credit money would still be created in response to the demands of business
people (although not at the same level as is currently the case, we imagine).
The banks, seeking profits themselves and in competition for customers, would
be caught between maintaining the value of their business (i.e. their money)
and the needs to maximise profits. As a boom develops, banks would be tempted
to introduce credit money to maintain it as increasing the interest rate would
be difficult and potentially dangerous (for reasons we noted above). Thus, if
credit money is not forth coming (i.e. the banks stick to the Austrian claims
that loans must equal savings) then the rise in interest rates required will
generate a slump. If it is forthcoming, then the danger of over-investment
becomes increasingly likely. All in all, the business cycle is part of
capitalism and **not** caused by "external" factors like the existence of
government.

As Reekie notes, to Austrians _"ignorance of the future is endemic"_ [**Op.
Cit.**, p. 117] but you would be forgiven for thinking that this is not the
case when it comes to investment. An individual firm cannot know whether its
investment project will generate the stream of returns necessary to meet the
stream of payment commitments undertaken to finance the project. And neither
can the banks who fund those projects. Even **if** a bank does not get tempted
into providing credit money in excess of savings, it cannot predict whether
other banks will do the same or whether the projects it funds will be
successful. Firms, looking for credit, may turn to more flexible competitors
(who practice reserve banking to some degree) and the inflexible bank may see
its market share and profits decrease. After all, commercial banks _"typically
establish relations with customers to reduce the uncertainty involved in
making loans. Once a bank has entered into a relationship with a customer, it
has strong incentives to meet the demands of that customer."_ [Wray, **Op.
Cit.**, p. 85]

There are example of fully privatised banks. For example, in the United States
(_"which was without a central bank after 1837"_) _"the major banks in New
York were in a bind between their roles as profit seekers, which made them
contributors to the instability of credit, and as possessors of country
deposits against whose instability they had to guard."_ [Kindleberger, **Op.
Cit.**, p. 85]

In Scotland, the banks were unregulated between 1772 and 1845 but _"the
leading commercial banks accumulated the notes of lessor ones, as the Second
Bank of the United States did contemporaneously in [the USA], ready to convert
them to specie if they thought they were getting out of line. They served,
that is, as an informal controller of the money supply. For the rest, as so
often, historical evidence runs against strong theory, as demonstrated by the
country banks in England from 1745 to 1835, wildcat banking in Michigan in the
1830s, and the latest experience with bank deregulation in Latin America."_
[**Op. Cit.**, p. 82] And we should note there were a few banking "wars"
during the period of deregulation in Scotland which forced a few of the
smaller banks to fail as the bigger ones refused their money and that there
was a major bank failure in the Ayr Bank.

Kendleberger argues that central banking _"arose to impose control on the
instability of credit"_ and did not cause the instability which right-
libertarians maintain it does. And as we note in section
[10.3](append1310.html#secf103), the USA suffered massive economic instability
during its period without central banking. Thus, **if** credit money **is**
the cause of the business cycle, it is likely that a "pure" capitalism will
still suffer from it just as much as "actually existing" capitalism (either
due to high interest rates or over-investment).

In general, as the failed Monetarist experiments of the 1980s prove, trying to
control the money supply is impossible. The demand for money is dependent on
the needs of the economy and any attempt to control it will fail (and cause a
deep depression, usually via high interest rates). The business cycle,
therefore, is an endogenous phenomenon caused by the normal functioning of the
capitalist economic system. Austrian and right-libertarian claims that _"slump
flows boom, but for a totally unnecessary reason: government inspired mal-
investment"_ [Reekie, **Op. Cit.**, p. 74] are simply wrong. Over-investment
**does** occur, but it is **not** _"inspired"_ by the government. It is
_"inspired"_ by the banks need to make profits from loans and from businesses
need for investment funds which the banks accommodate. In other words, by the
nature of the capitalist system.

## 10.2 How does the labour market effect capitalism?

In many ways, the labour market is the one that affects capitalism the most.
The right-libertarian assumption (like that of mainstream economics) is that
markets clear and, therefore, the labour market will also clear. As this
assumption has rarely been proven to be true in actuality (i.e. periods of
full employment within capitalism are few and far between), this leaves its
supporters with a problem -- reality contradicts the theory.

The theory predicts full employment but reality shows that this is not the
case. Since we are dealing with logical deductions from assumptions, obviously
the theory cannot be wrong and so we must identify external factors which
cause the business cycle (and so unemployment). In this way attention is
diverted away from the market and its workings -- after all, it is assumed
that the capitalist market works -- and onto something else. This "something
else" has been quite a few different things (most ridiculously, sun spots in
the case of one of the founders of marginalist economics, William Stanley
Jevons). However, these days most pro-free market capitalist economists and
right-libertarians have now decided it is the state.

In this section of the FAQ we will present a case that maintains that the
assumption that markets clear is false at least for one, unique, market --
namely, the market for labour. As the fundamental assumption underlying "free
market" capitalism is false, the logically consistent superstructure built
upon comes crashing down. Part of the reason why capitalism is unstable is due
to the commodification of labour (i.e. people) and the problems this creates.
The state itself can have positive and negative impacts on the economy, but
removing it or its influence will not solve the business cycle.

Why is this? Simply due to the nature of the labour market.

Anarchists have long realised that the capitalist market is based upon
inequalities and changes in power. Proudhon argued that _"[t]he manufacturer
says to the labourer, 'You are as free to go elsewhere with your services as I
am to receive them. I offer you so much.' The merchant says to the customer,
'Take it or leave it; you are master of your money, as I am of my goods. I
want so much.' Who will yield? The weaker."_ He, like all anarchists, saw that
domination, oppression and exploitation flow from inequalities of
market/economic power and that the _"power of invasion lies in superior
strength."_ [**What is Property?**, p. 216, p. 215]

This applies with greatest force to the labour market. While mainstream
economics and right-libertarian variations of it refuse to acknowledge that
the capitalist market is a based upon hierarchy and power, anarchists (and
other socialists) do not share this opinion. And because they do not share
this understanding with anarchists, right-libertarians will never be able to
understand capitalism or its dynamics and development. Thus, when it comes to
the labour market, it is essential to remember that the balance of power
within it is the key to understanding the business cycle. Thus the economy
must be understood as a system of power.

So how does the labour market effect capitalism? Let us consider a growing
economy, on that is coming out of a recession. Such a growing economy
stimulates demand for employment and as unemployment falls, the costs of
finding workers increase and wage and condition demands of existing workers
intensify. As the economy is growing and labour is scare, the threat
associated with the hardship of unemployment is weakened. The share of profits
is squeezed and in reaction to this companies begin to cut costs (by reducing
inventories, postponing investment plans and laying off workers). As a result,
the economy moves into a downturn. Unemployment rises and wage demands are
moderated. Eventually, this enables the share of profits first of all to
stabilise, and then rise. Such an _"interplay between profits and unemployment
as the key determinant of business cycles"_ is _"observed in the empirical
data."_ [Paul Ormerod, **The Death of Economics**, p. 188]

Thus, as an economy approaches full employment the balance of power on the
labour market changes. The sack is no longer that great a threat as people see
that they can get a job elsewhere easily. Thus wages and working conditions
increase as companies try to get new (and keep) existing employees and output
is harder to maintain. In the words of economist William Lazonick, labour
_"that is able to command a higher price than previously because of the
appearance of tighter labour markets is, by definition, labour that is highly
mobile via the market. And labour that is highly mobile via the market is
labour whose supply of effort is difficult for managers to control in the
production process. Hence, the advent of tight labour markets generally
results in more rapidly rising average costs . . .as well as upward shifts in
the average cost curve. . ."_ [**Business Organisation and the Myth of the
Market Economy**, p. 106]

In other words, under conditions of full-employment _"employers are in danger
of losing the upper hand."_ [Juliet B. Schor, **The Overworked American**, p.
75] Schor argues that _"employers have a structural advantage in the labour
market, because there are typically more candidates ready and willing to
endure this work marathon [of long hours] than jobs for them to fill."_ [p.
71] Thus the labour market is usually a buyers market, and so the sellers have
to compromise. In the end, workers adapt to this inequality of power and
instead of getting what they want, they want what they get.

But under full employment this changes. As we argued in section
[B.4.4](secB4.html#secb44) and section [C.7](secC7.html), in such a situation
it is the bosses who have to start compromising. And they do not like it. As
Schor notes, America _"has never experienced a sustained period of full
employment. The closest we have gotten is the late 1960s, when the overall
unemployment rate was under 4 percent for four years. But that experience does
more to prove the point than any other example. The trauma caused to business
by those years of a tight labour market was considerable. Since then, there
has been a powerful consensus that the nation cannot withstand such a low rate
of unemployment."_ [**Op. Cit.**, pp. 75-76]

So, in other words, full employment is not good for the capitalist system due
to the power full employment provides workers. Thus unemployment is a
necessary requirement for a successful capitalist economy and not some kind of
aberration in an otherwise healthy system. Thus "anarcho"-capitalist claims
that "pure" capitalism will soon result in permanent full employment are
false. Any moves towards full employment will result in a slump as capitalists
see their profits squeezed from below by either collective class struggle or
by individual mobility in the labour market.

This was recognised by Individualist Anarchists like Benjamin Tucker, who
argued that mutual banking would _"give an unheard of impetus to business, and
consequently create an unprecedented demand for labour, -- a demand which
would always be in excess of the supply, directly contrary of the present
condition of the labour market."_ [**The Anarchist Reader**, pp. 149-150] In
other words, full employment would end capitalist exploitation, drive non-
labour income to zero and ensure the worker the full value of her labour -- in
other words, end capitalism. Thus, for most (if not all) anarchists the
exploitation of labour is only possible when unemployment exists and the
supply of labour exceeds the demand for it. Any move towards unemployment will
result in a profits squeeze and either the end of capitalism or an economic
slump.

Indeed, as we argued in the [last section](append1310.html#secf101), the
extended periods of (approximately) full employment until the 1960s had the
advantage that any profit squeeze could (in the short run anyway) be passed
onto working class people in the shape of inflation. As prices rise, labour is
made cheaper and profits margins supported. This option is restricted under a
"pure" capitalism (for reasons we discussed in the [last
section](append1310.html#secf101)) and so "pure" capitalism will be affected
by full employment faster than "impure" capitalism.

As an economy approaches full employment, _"hiring new workers suddenly
becomes much more difficult. They are harder to find, cost more, and are less
experiences. Such shortages are extremely costly for a firm."_ [Schor, **Op.
Cit.**, p. 75] This encourages a firm to pass on these rises to society in the
form of price rises, so creating inflation. Workers, in turn, try to maintain
their standard of living. _"Every general increase in labour costs in recent
years,"_ note J. Brecher and J. Costello in the late 1970s, _"has followed,
rather than preceded, an increase in consumer prices. Wage increases have been
the result of workers' efforts to catch up after their incomes have already
been eroded by inflation. Nor could it easily be otherwise. All a businessman
has to do to raise a price . . . [is to] make an announcement. . . Wage rates
. . . are primarily determined by contracts"_ and so cannot be easily adjusted
in the short term. [**Common Sense for Bad Times**, p, 120]

These full employment pressures will still exist with "pure" capitalism (and
due to the nature of the banking system will not have the safety value of
inflation). This means that periodic profit squeezes will occur, due to the
nature of a tight labour market and the increased power of workers this
generates. This in turn means that a "pure" capitalism will be subject to
periods of unemployment (as we argued in section [C.9](secC9.html)) and so
still have a business cycle. This is usually acknowledged by right-
libertarians in passing, although they seem to think that this is purely a
"short-term" problem (it seems a strange "short-term" problem that continually
occurs).

But such an analysis is denied by right-libertarians. For them government
action, combined with the habit of many labour unions to obtain higher than
market wage rates for their members, creates and exacerbates mass
unemployment. This flows from the deductive logic of much capitalist
economics. The basic assumption of capitalism is that markets clear. So if
unemployment exists then it can only be because the price of labour (wages) is
too high (Austrian Economist W. Duncan Reekie argues that unemployment will
_"disappear provided real wages are not artificially high"_ [**Markets,
Entrepreneurs and Liberty**, p. 72]).

Thus the assumption provokes the conclusion -- unemployment is caused by an
unclearing market as markets always clear. And the cause for this is either
the state or unions. But what if the labour market **cannot** clear without
seriously damaging the power and profits of capitalists? What if unemployment
is required to maximise profits by weakening labours' bargaining position on
the market and so maximising the capitalists power? In that case unemployment
is caused by capitalism, not by forces external to it.

However, let us assume that the right-libertarian theory is correct. Let us
assume that unemployment is all the fault of the selfish unions and that a
job-seeker _"who does not want to wait will always get a job in the unhampered
market economy."_ [von Mises, **Human Action**, p. 595]

Would crushing the unions reduce unemployment? Let us assume that the unions
have been crushed and government has been abolished (or, at the very least,
become a minimum state). The aim of the capitalist class is to maximise their
profits and to do this they invest in labour saving machinery and otherwise
attempt to increase productivity. But increasing productivity means that the
prices of goods fall and falling prices mean increasing real wages. It is high
real wages that, according to right-libertarians, that cause unemployment. So
as a reward for increasing productivity, workers will have to have their money
wages cut in order to stop unemployment occurring! For this reason some
employers might refrain from cutting wages in order to avoid damage to morale
- potentially an important concern.

Moreover, wage contracts involve **time** \-- a contract will usually agree a
certain wage for a certain period. This builds in rigidity into the market,
wages cannot be adjusted as quickly as other commodity prices. Of course, it
could be argued that reducing the period of the contract and/or allowing the
wage to be adjusted could overcome this problem. However, if we reduce the
period of the contract then workers are at a suffer disadvantage as they will
not know if they have a job tomorrow and so they will not be able to easily
plan their future (an evil situation for anyone to be in). Moreover, even
without formal contracts, wage renegotiation can be expensive. After all, it
takes time to bargain (and time is money under capitalism) and wage cutting
can involve the risk of the loss of mutual good will between employer and
employee. And would **you** give your boss the power to "adjust" your wages as
he/she thought was necessary? To do so would imply an altruistic trust in
others not to abuse their power.

Thus a "pure" capitalism would be constantly seeing employment increase and
decrease as productivity levels change. There exist important reasons why the
labour market need not clear which revolve around the avoidance/delaying of
wage cuts by the actions of capitalists themselves. Thus, given a choice
between cutting wages for all workers and laying off some workers without
cutting the wages of the remaining employees, it is unsurprising that
capitalists usually go for the later. After all, the sack is an important
disciplining device and firing workers can make the remaining employees more
inclined to work harder and be more obedient.

And, of course, many employers are not inclined to hire over-qualified
workers. This is because, once the economy picks up again, their worker has a
tendency to move elsewhere and so it can cost them time and money finding a
replacement and training them. This means that involuntary unemployment can
easily occur, so reducing tendencies towards full employment even more. In
addition, one of the assumptions of the standard marginalist economic model is
one of decreasing returns to scale. This means that as employment increases,
costs rise and so prices also rise (and so real wages fall). But in reality
many industries have **increasing** returns to scale, which means that as
production increases unit costs fall, prices fall and so real wages rise. Thus
in such an economy unemployment would increase simply because of the nature of
the production process!

Moreover, as we argued in-depth in section [C.9](secC9.html), a cut in money
wages is not a neutral act. A cut in money wages means a reduction in demand
for certain industries, which may have to reduce the wages of its employees
(or fire them) to make ends meet. This could produce a accumulative effect and
actually **increase** unemployment rather than reduce it.

In addition, there are no "self-correcting" forces at work in the labour
market which will quickly bring employment back to full levels. This is for a
few reasons. Firstly, the supply of labour cannot be reduced by cutting back
production as in other markets. All we can do is move to other areas and hope
to find work there. Secondly, the supply of labour can sometimes adjust to
wage decreases in the wrong direction. Low wages might drive workers to offer
a greater amount of labour (i.e. longer hours) to make up for any short fall
(or to keep their job). This is usually termed the _"efficiency wage"_ effect.
Similarly, another family member may seek employment in order to maintain a
given standard of living. Falling wages may cause the number of workers
seeking employment to **increase**, causing a full further fall in wages and
so on (and this is ignoring the effects of lowering wages on demand discussed
in section [C.9](secC9.html)).

The paradox of piece work is an important example of this effect. As Schor
argues, _"piece-rate workers were caught in a viscous downward spiral of
poverty and overwork. . . When rates were low, they found themselves compelled
to make up in extra output what they were losing on each piece. But the extra
output produced glutted the market and drove rates down further."_ [Juliet C.
Schor, **The Overworked American**, p, 58]

Thus, in the face of reducing wages, the labour market may see an accumulative
move away from (rather than towards) full employment, The right-libertarian
argument is that unemployment is caused by real wages being too high which in
turn flows from the assumption that markets clear. If there is unemployment,
then the price of the commodity labour is too high -- otherwise supply and
demand would meet and the market clear. But if, as we argued above,
unemployment is essential to discipline workers then the labour market
**cannot** clear except for short periods. If the labour market clears,
profits are squeezed. Thus the claim that unemployment is caused by "too high"
real wages is false (and as we argue in section [C.9](secC9.html), cutting
these wages will result in deepening any slump and making recovery longer to
come about).

In other words, the assumption that the labour market must clear is false, as
is any assumption that reducing wages will tend to push the economy quickly
back to full employment. The nature of wage labour and the "commodity" being
sold (i.e. human labour/time/liberty) ensure that it can never be the same as
others. This has important implications for economic theory and the claims of
right-libertarians, implications that they fail to see due to their vision of
labour as a commodity like any other.

The question arises, of course, of whether, during periods of full employment,
workers could not take advantage of their market power and gain increased
workers' control, create co-operatives and so reform away capitalism. This was
the argument of the Mutualist and Individualist anarchists and it does have
its merits. However, it is clear (see section [J.5.12](secJ5.html#secj512))
that bosses hate to have their authority reduced and so combat workers'
control whenever they can. The logic is simple, if workers increase their
control within the workplace the manager and bosses may soon be out of a job
and (more importantly) they may start to control the allocation of profits.
Any increase in working class militancy may provoke capitalists to stop/reduce
investment and credit and so create the economic environment (i.e. increasing
unemployment) necessary to undercut working class power.

In other words, a period of full unemployment is not sufficient to reform
capitalism away. Full employment (nevermind any struggle over workers'
control) will reduce profits and if profits are reduced then firms find it
hard to repay debts, fund investment and provide profits for shareholders.
This profits squeeze would be enough to force capitalism into a slump and any
attempts at gaining workers' self-management in periods of high employment
will help push it over the edge (after all, workers' control without control
over the allocation of any surplus is distinctly phoney). Moreover, even if we
ignore the effects of full employment may not last due to problems associated
with over-investment (see section [C.7.2](secC7.html#secc72)), credit and
interest rate problems (see section [10.1](append1310.html#secf101)) and
realisation/aggregate demand disjoints. Full employment adds to the problems
associated with the capitalist business cycle and so, if class struggle and
workers power did not exist or cost problem, capitalism would still not be
stable.

If equilibrium is a myth, then so is full employment. It seems somewhat ironic
that "anarcho"-capitalists and other right-libertarians maintain that there
will be equilibrium (full employment) in the one market within capitalism it
can never actually exist in! This is usually quietly acknowledged by most
right-libertarians, who mention in passing that some "temporary" unemployment
**will** exist in their system -- but "temporary" unemployment is not full
employment. Of course, you could maintain that all unemployment is "voluntary"
and get round the problem by denying it, but that will not get us very far.

So it is all fine and well saying that "libertarian" capitalism would be based
upon the maxim _"From each as they choose, to each as they are chosen."_
[Robert Nozick, **Anarchy, State, and Utopia**, p. 160] But if the labour
market is such that workers have little option about what they "choose" to
give and fear that they will **not** be chosen, then they are at a
disadvantage when compared to their bosses and so "consent" to being treated
as a resource from the capitalist can make a profit from. And so this will
result in any "free" contract on the labour market favouring one party at the
expense of the other -- as can be seen from "actually existing capitalism".

Thus any "free exchange" on the labour market will usually **not** reflect the
true desires of working people (and who will make all the "adjusting" and end
up wanting what they get). Only when the economy is approaching full
employment will the labour market start to reflect the true desires of working
people and their wage start to approach its full product. And when this
happens, profits are squeezed and capitalism goes into slump and the resulting
unemployment disciplines the working class and restores profit margins. Thus
full employment will be the exception rather than the rule within capitalism
(and that is a conclusion which the historical record indicates).

In other words, in a normally working capitalist economy any labour contracts
will not create relationships based upon freedom due to the inequalities in
power between workers and capitalists. Instead, any contracts will be based
upon domination, **not** freedom. Which prompts the question, how is
libertarian capitalism **libertarian** if it erodes the liberty of a large
class of people?

## 10.3 Was laissez-faire capitalism stable?

&gt; Firstly, we must state that a pure laissez-faire capitalist system has
not existed. This means that any evidence we present in this section can be
dismissed by right-libertarians for precisely this fact -- it was not "pure"
enough. Of course, if they were consistent, you would expect them to shun all
historical and current examples of capitalism or activity within capitalism,
but this they do not. The logic is simple -- if X is good, then it is
permissible to use it. If X is bad, the system is not pure enough.

However, as right-libertarians **do** use historical examples so shall we.
According to Murray Rothbard, there was _"quasi-laissez-faire
industrialisation [in] the nineteenth century"_ [**The Ethics of Liberty**, p.
264] and so we will use the example of nineteenth century America -- as this
is usually taken as being the closest to pure laissez-faire -- in order to see
if laissez-faire is stable or not.

Yes, we are well aware that 19th century USA was far from laissez-faire --
there was a state, protectionism, government economic activity and so on --
but as this example has been often used by right-Libertarians' themselves (for
example, Ayn Rand) we think that we can gain a lot from looking at this
imperfect approximation of "pure" capitalism (and as we argued in section
[8](append138.html), it is the "quasi" aspects of the system that counted in
industrialisation, **not** the laissez-faire ones).

So, was 19th century America stable? No, it most definitely was not.

Firstly, throughout that century there were a continual economic booms and
slumps. The last third of the 19th century (often considered as a heyday of
private enterprise) was a period of profound instability and anxiety. Between
1867 and 1900 there were 8 complete business cycles. Over these 396 months,
the economy expanded during 199 months and contracted during 197. Hardly a
sign of great stability (since the end of world war II, only about a fifth of
the time has spent in periods of recession or depression, by way of
comparison). Overall, the economy went into a slump, panic or crisis in 1807,
1817, 1828, 1834, 1837, 1854, 1857, 1873, 1882, and 1893 (in addition, 1903
and 1907 were also crisis years).

Part of this instability came from the eras banking system. _"Lack of a
central banking system,"_ writes Richard Du Boff, _"until the Federal Reserve
act of 1913 made financial panics worse and business cycle swings more
severe"_ [**Accumulation and Power**, p. 177] It was in response to this
instability that the Federal Reserve system was created; and as Doug Henwood
notes _"the campaign for a more rational system of money and credit was not a
movement of Wall Street vs. industry or regional finance, but a broad movement
of elite bankers and the managers of the new corporations as well as academics
and business journalists. The emergence of the Fed was the culmination of
attempts to define a standard of value that began in the 1890s with the
emergence of the modern professionally managed corporation owned not by its
managers but dispersed public shareholders."_ [**Wall Street**, p. 93] Indeed,
the Bank of England was often forced to act as lender of last resort to the
US, which had no central bank.

In the decentralised banking system of the 19th century, during panics
thousands of banks would hoard resources, so starving the system for liquidity
precisely at the moment it was most badly needed. The creation of trusts was
one way in which capitalists tried to manage the system's instabilities (at
the expense of consumers) and the corporation was a response to the outlawing
of trusts. _"By internalising lots of the competitive system's gaps -- by
bring more transactions within the same institutional walls -- corporations
greatly stabilised the economy."_ [Henwood, **Op. Cit.**, p. 94]

All during the hey-day of laissez faire we also find popular protests against
the money system used, namely specie (in particular gold), which was
considered as a hindrance to economic activity and expansion (as well as being
a tool for the rich). The Individualist Anarchists, for example, considered
the money monopoly (which included the use of specie as money) as the means by
which capitalists ensured that _"the labourers . . . [are] kept in the
condition of wage labourers,"_ and reduced _"to the conditions of servants;
and subject to all such extortions as their employers . . . may choose to
practice upon them"_, indeed they became the _"mere tools and machines in the
hands of their employers"_. With the end of this monopoly, _"[t]he amount of
money, capable of being furnished . . . [would assure that all would] be under
no necessity to act as a servant, or sell his or her labour to others."_
[Lysander Spooner, **A Letter to Grover Cleveland**, p. 47, p. 39, p. 50, p.
41] In other words, a specie based system (as desired by many
"anarcho"-capitalists) was considered a key way of maintaining wage labour and
exploitation.

Interestingly, since the end of the era of the Gold Standard (and so commodity
money) popular debate, protest and concern about money has disappeared. The
debate and protest was in response to the **effects** of commodity money on
the economy -- with many people correctly viewing the seriously restrictive
monetary regime of the time responsible for economic problems and crisis as
well as increasing inequalities. Instead radicals across the political
spectrum urged a more flexible regime, one that did not cause wage slavery and
crisis by reducing the amount of money in circulation when it could be used to
expand production and reduce the impact of slumps. Needless to say, the
Federal Reserve system in the USA was far from the institution these populists
wanted (after all, it is run by and for the elite interests who desired its
creation).

That the laissez-faire system was so volatile and panic-ridden suggests that
"anarcho"-capitalist dreams of privatising everything, including banking, and
everything will be fine are very optimistic at best (and, ironically, it was
members of the capitalist class who lead the movement towards state-managed
capitalism in the name of "sound money").

[‹ 9 Is Medieval Iceland an example of "anarcho"-capitalism working in
practice?](/afaq/append139.html "Go to previous page" )
[up](/afaq/append13.html "Go to parent page" ) [11 What is the myth of
"Natural Law"? ›](/afaq/append1311.html "Go to next page" )

