# What was the Kronstadt Rebellion?

The Kronstadt rebellion took place in the first weeks of March, 1921.
Kronstadt was (and is) a naval fortress on an island in the Gulf of Finland.
Traditionally, it has served as the base of the Russian Baltic Fleet and to
guard the approaches to the city of St. Petersburg (which during the first
world war was re-named Petrograd, then later Leningrad, and is now St.
Petersburg again) thirty-five miles away.

The Kronstadt sailors had been in the vanguard of the revolutionary events of
1905 and 1917. In 1917, Trotsky called them the _"pride and glory of the
Russian Revolution."_ The inhabitants of Kronstadt had been early supporters
and practitioners of soviet power, forming a free commune in 1917 which was
relatively independent of the authorities. In the words of Israel Getzler, an
expert on Kronstadt, _"it was in its commune-like self-government that Red
Kronstadt really came into its own, realising the radical, democratic and
egalitarian aspirations of its garrison and working people, their insatiable
appetite for social recognition, political activity and public debate, their
pent up yearning for education, integration and community. Almost overnight,
the ship's crews, the naval and military units and the workers created and
practised a direct democracy of base assemblies and committees."_ [**Kronstadt
1917-1921**, p. 248] In the centre of the fortress an enormous public square
served as a popular forum holding as many as 30,000 persons. The Kronstadters
_"proved convincingly the capacity of ordinary people to use their 'heads,
too' in governing themselves, and managing Russia's largest navel base and
fortress."_ [Getzler, **Op. Cit.**, p. 250]

The Russian Civil War had ended in Western Russia in November 1920 with the
defeat of General Wrangel in the Crimea. All across Russia popular protests
were erupting in the countryside and in the towns and cities. Peasant
uprisings were occurring against the Communist Party policy of grain
requisitioning (a policy the Bolsheviks and their argued had been thrust upon
them by the circumstances but which involved extensive, barbaric and counter-
productive repression). In urban areas, a wave of spontaneous strikes occurred
and in late February a near general strike broke out in Petrograd.

On February 26th, in response to these events in Petrograd, the crews of the
battleships **_Petropavlovsk_** and **_Sevastopol_** held an emergency meeting
and agreed to send a delegation to the city to investigate and report back on
the ongoing strike movement. On their turn two days later, the delegates
informed their fellow sailors of the strikes (with which they had full
sympathy with) and the government repression directed against them. Those
present at this meeting on the **_Petropavlovsk_** then approved a resolution
which raised 15 demands which included free elections to the soviets, freedom
of speech, press, assembly and organisation to workers, peasants, anarchists
and left-socialists (see [section 3](append42.html#app3) for full details). Of
the 15 demands, only two were related to what Marxists like to term the
"petty-bourgeoisie" (the peasantry and artisans) and these demanded _"full
freedom of action"_ for all peasants and artisans who did not hire labour.
Like the Petrograd workers, the Kronstadt sailors demanded the equalisation of
wages and the end of roadblock detachments restricting travel and the ability
of workers to bring food into the city.

A mass meeting of fifteen to sixteen thousand people was held in Anchor Square
on March 1st and what has became known as the **_Petropavlovsk_** resolution
was passed after the _"fact-finding"_ delegation had made its report. Only two
Bolshevik officials voted against the resolution. At this meeting it was
decided to send another delegation to Petrograd to explain to the strikers and
the city garrison of the demands of Kronstadt and to request that non-partisan
delegates be sent by the Petrograd workers to Kronstadt to learn first-hand
what was happening there. This delegation of thirty members was arrested by
the Bolshevik government.

As the term of office of the Kronstadt soviet was about to expire, the mass
meeting also decided to call a _"Conference of Delegates"_ for March 2nd. This
was to discuss the manner in which the new soviet elections would be held.
This conference consisted of two delegates from the ship's crews, army units,
the docks, workshops, trade unions and Soviet institutions. This meeting of
303 delegates endorsed the **_Petropavlovsk_** resolution and elected a five-
person _"Provisional Revolutionary Committee"_ (this was enlarged to 15
members two days later by another conference of delegates). This committee was
charged with organising the defence of Kronstadt, a move decided upon in part
by the threats of the Bolshevik officials there and the groundless rumour that
the Bolsheviks had dispatched forces to attack the meeting. Red Kronstadt had
turned against the Communist government and raised the slogan of the 1917
revolution _"All Power to the Soviets"_, to which was added _"and not to
parties."_ They termed this revolt the _"Third Revolution"_ and would complete
the work of the first two Russian Revolutions in 1917 by instituting a true
toilers republic based on freely elected, self-managed, soviets.

The Communist Government responded with an ultimatum on March 2nd. This
asserted that the revolt had _"undoubtedly been prepared by French
counterintelligence"_ and that the **_Petropavlovsk_** resolution was a _"SR-
Black Hundred"_ resolution (SR stood for "Social Revolutionaries", a party
with a traditional peasant base and whose right-wing had sided with White
forces; the "Black Hundreds" were a reactionary, indeed proto-fascist, force
dating back to before the revolution which attacked Jews, labour militants,
radicals and so on). They argued that the revolt had been organised by an ex-
Tsarist officers led by ex-General Kozlovsky (who had, ironically, been placed
in the fortress as a military specialist by Trotsky). This was the official
line through-out the revolt.

During the revolt, Kronstadt started to re-organise itself from the bottom up.
The trade union committees were re-elected and a Council of Trade Unions
formed. The Conference of Delegates met regularly to discuss issues relating
to the interests of Kronstadt and the struggle against the Bolshevik
government (specifically on March 2nd, 4th and 11th). Rank and file Communists
left the party in droves, expressing support for the revolt and its aim of
_"all power to the soviets and not to parties."_ About 300 Communists were
arrested and treated humanly in prison (in comparison, at least 780 Communists
left the party in protest of the actions it was taking against Kronstadt and
its general role in the revolution). Significantly, up to one-third of the
delegates elected to Kronstadt's rebel conference of March 2nd were
Communists. [Avrich, **Op. Cit.**, pp. 184-7 and p. 81]

The Kronstadt revolt was a non-violent one, but from the start the attitude of
the authorities was not one of serious negotiation but rather one of
delivering an ultimatum: either come to your senses or suffer the
consequences. Indeed, the Bolsheviks issued the threat that they would shoot
the rebels _"like partridges"_ and took the families of the sailors hostage in
Petrograd. Towards the end of the revolt Trotsky sanctioned the use of
chemical warfare against the rebels and if they had not been crushed, a gas
attack would have carried out. [Paul Avrich, **Kronstadt 1921**, p. 146 and
pp. 211-2] No real attempt was made to settle the revolt peacefully. While
there was at least three to four weeks before the ice was due to melt after
the March 2nd _"Conference of Delegates"_ meeting which marked the real start
of the revolt, the Bolsheviks started military operations at 6.45pm on March
7th.

There were possible means for a peaceful resolution of the conflict. On March
5th, two days before the bombardment of Kronstadt had begun, anarchists led by
Emma Goldman and Alexander Berkman offered themselves as intermediates to
facilitate negotiations between the rebels and the government (anarchist
influence had been strong in Kronstadt in 1917). [Emma Goldman, **Living My
Life**, vol. 2, pp. 882-3] This was ignored by the Bolsheviks. Years later,
the Bolshevik Victor Serge (and eye-witness to the events) acknowledged that
_"[e]ven when the fighting had started, it would have been easy to avoid the
worst: it was only necessary to accept the mediation offered by the anarchists
(notably Emma Goldman and Alexander Berkman) who had contact with the
insurgents. For reasons of prestige and through an excess of authoritarianism,
the Central Committee refused this course."_ [**The Serge-Trotsky Papers**, p.
164]

Another possible solution, namely the Petrograd Soviet suggestion of March 6th
that a delegation of party and non-party members of the Soviet visit Kronstadt
was not pursued by the government. The rebels, unsurprisingly enough, had
reservations about the **real** status of the non-party delegates and asked
that the elections to the delegation take place within the factories, with
observers from Kronstadt present (in itself a very reasonable request).
Nothing came of this (unsurprisingly, as such a delegation would have reported
the truth that Kronstadt was a popular revolt of working people so exposing
Bolshevik lies and making the planned armed attack more difficult). A
delegation _"sent by Kronstadt to explain the issues to the Petrograd Soviet
and people was in the prisons of the Cheka."_ [Victor Serge, **Memoirs of a
Revolutionary**, p. 127] According to Serge, _"right from the first moment, at
a time when it was easy to mitigate the conflict, the Bolshevik leaders had no
intention of using anything but forcible methods."_ [**Ibid.**] This is
confirmed by latter research. The refusal to pursue these possible means of
resolving the crisis peacefully is explained by the fact that the decision to
attack Kronstadt had already been made. Basing himself on documents from the
Soviet Archives, historian Israel Getzler states that _"[b]y 5 March, if not
earlier, the Soviet leaders had decided to crush Kronstadt. Thus, in a cable
to . . . [a] member of the Council of Labour and Defence, on that day, Trotsky
insisted that 'only the seizure of Kronstadt will put an end to the political
crisis in Petrograd.' On the same day, acting as chairman of the RVSR [the
Revolutionary Military Council of the Army and Navy of the Republic], he
ordered the reformation and mobilisation of the Seventh Army 'to suppress the
uprising in Kronstadt,' and appointed General Mikhail Tukhachevskii as its
commander changed with suppressing the uprising in Kronstadt 'in the shortest
possible time.'"_ [_"The Communist Leaders' Role in the Kronstadt Tragedy of
1921 in the Light of Recently Published Archival Documents"_, **Revolutionary
Russia**, pp. 24-44, Vol. 15, No. 1, June 2002, p. 32]

As Alexander Berkman noted, the Communist government would _"make no
concessions to the proletariat, while at the same time they were offering to
compromise with the capitalists of Europe and America."_ [Berkman, **The
Russian Tragedy**, p. 62] While happy to negotiate and compromise with foreign
governments, they treated the workers and peasants of Kronstadt (like that of
the rest of Russia) as the class enemy (indeed, at the time, Lenin was
publicly worrying whether the revolt was a White plot to sink these
negotiations!).

The revolt was isolated and received no external support. The Petrograd
workers were under martial law and could little or no action to support
Kronstadt (assuming they refused to believe the Bolshevik lies about the
uprising). The Communist government started to attack Kronstadt on March 7th.
The first assault was a failure. _"After the Gulf had swallowed its first
victims,"_ Paul Avrich records, _"some of the Red soldiers, including a body
of Peterhof **kursanty**, began to defect to the insurgents. Others refused to
advance, in spite of threats from the machine gunners at the rear who had
orders to shoot any wavers. The commissar of the northern group reported that
his troops wanted to send a delegation to Kronstadt to find out the
insurgents' demands."_ [Avrich, **Op. Cit.**, pp. 153-4] After 10 days of
constant attacks the Kronstadt revolt was crushed by the Red Army. On March
17th, the final assault occurred. Again, the Bolsheviks had to force their
troops to fight. On the night of 16-17 March, for example, _"the extraordinary
**troika** of Aleksei Nikolaev had arrested over 100 so-called instigators, 74
of whom he had publicly shot."_ [Getzler, **Op. Cit.**, p. 35] Once the
Bolshevik forces finally entered the city of Kronstadt _"the attacking troops
took revenge for their fallen comrades in an orgy of bloodletting."_ [Avrich,
**Op. Cit.**, p. 211] The next day, as an irony of history, the Bolsheviks
celebrated the fiftieth anniversary of the Paris Commune.

The repression did not end there. According to Serge, the _"defeated sailors
belonged body and sole to the Revolution; they had voiced the suffering and
the will of the Russian people"_ yet _"[h]undreds of prisoners were taken away
to Petrograd; months later they were still being shot in small batches, a
senseless and criminal agony"_ (particularly as they were _"prisoners of war .
. . and the Government had for a long time promised an amnesty to its
opponents on condition that they offered their support"_). _"This protracted
massacre was either supervised or permitted by Dzerzhinsky"_ (the head of the
Cheka). The _"responsibilities of the Bolshevik Central Committee had been
simply enormous"_ and _"the subsequent repression . . . needlessly
barbarous."_ [**Memoirs of a Revolutionary**, p. 131 and p. 348]

The Soviet forces suffered over 10,000 casualties storming Kronstadt. There
are no reliable figures for the rebels loses or how many were later shot by
the Cheka or sent to prison camps. The figures that exist are fragmentary.
Immediately after the defeat of the revolt, 4,836 Kronstadt sailors were
arrested and deported to the Crimea and the Caucasus. When Lenin heard of this
on the 19th of April, he expressed great misgivings about it and they were
finally sent to forced labour camps in the Archangelsk, Vologda and Murmansk
regions. Eight thousand sailors, soldiers and civilians escaped over the ice
to Finland. The crews of the **_Petropavlovsk_** and **_Sevastopol_** fought
to the bitter end, as did the cadets of the mechanics school, the torpedo
detachment and the communications unit. A statistical communiqué of the
Special Section of the Extraordinary **Troikas** of 1st May stated that 6,528
rebels had been arrested, of whom 2,168 had been shot (33%), 1,955 had been
sentenced to forced labour (of whom 1,486 received a five year sentence), and
1,272 were released. A statistical review of the revolt made in 1935-6 listed
the number arrested as 10,026 and stated that it had "not been possible to
establish accurately the number of the repressed." The families of the rebels
were deported, with Siberia considered as _"undoubtedly the only suitable
region"_ for them. Significantly, one of the members of the **troika** judging
the rebels complained that they had to rely exclusively on information
provided by the Special Section of the **Vecheka** as _"neither commissars nor
local Communists provided any material."_ [Israel Getzler, _"The Communist
Leaders' Role in the Kronstadt Tragedy of 1921 in the Light of Recently
Published Archival Documents"_, **Revolutionary Russia**, pp. 24-44, Vol. 15,
No. 1, June 2002, pp. 35-7]

After the revolt had been put down, the Bolshevik government reorganised the
fortress. While it had attacked the revolt in the name of defending _"Soviet
Power"_ Kronstadt's newly appointed military commander _"abolish[ed] the
[Kronstadt] soviet altogether"_ and ran the fortress _"with the assistance of
a revolutionary troika"_ (i.e. an appointed three man committee). [Getzler,
**Op. Cit.**, p. 244] Kronstadt's newspaper was renamed **_Krasnyi
Kronshtadt_** (from **_Izvestiia_**) and stated in an editorial that the
_"fundamental features"_ of Kronstadt's restored _"dictatorship of the
proletariat"_ during its _"initial phases"_ were _"[r]estrictions on political
liberty, terror, military centralism and discipline and the direction of all
means and resources towards the creation of an offensive and defensive state
apparatus."_ [quoted by Getzler, **Op. Cit.**, p. 245] The victors quickly
started to eliminate all traces of the revolt. Anchor square became
"Revolutionary Square" and the rebel battleships **_Petropavlovsk_** and
**_Sevastopol_** were renamed the **_Marat_** and the **_Paris Commune_**,
respectively.

That, in a nutshell, was the Kronstadt revolt. Obviously we cannot cover all
the details and we recommend readers to consult the books and articles we list
at the end of this section for fuller accounts of the events. However, that
presents the key points in the rebellion. Now we must analyse the revolt and
indicate why it is so important in evaluating Bolshevism in both practice and
as a revolutionary theory.

In the sections which follow, we indicate why the revolt is so important
([section 1](append42.html#app1)) and place it in historical context ([section
2](append42.html#app2)). We then present and discuss the Kronstadt demands,
indicating their sources in working class rebellion and radicalism (see
sections [3](append42.html#app3) and [4](append42.html#app4)). We indicate the
lies the Bolsheviks said about the rebellion at the time ( [section
5](append42.html#app5)), whether it was, in fact, a White plot ([ section
6](append42.html#app6)) and indicate the revolts real relationship to the
Whites ([section 7](append42.html#app7)). We also disprove Trotskyist
assertions that the sailors in 1921 were different from those in 1917
([section 8](append42.html#app8)) or that their political perspectives had
fundamentally changed ([section 9](append42.html#app9)). We indicate that
state coercion and repression was the significant in why the Kronstadt revolt
did not spread to the Petrograd workers ([section 10](append42.html#app10)).
Then we discuss the possibility of White intervention during and after the
revolt ([section 11](append42.html#app11)). We follow this with a discussion
of arguments that the country was too exhausted to allow soviet democracy
([section 12](append42.html#app12)) or that soviet democracy would have
resulted in the defeat of the revolution ([section 13](append42.html#app13)).
In the process, we will also show the depths to which supporters of Leninism
will sink to defend their heroes (in particular, see [section
14](append42.html#app14)). Lastly, we discuss what the Kronstadt revolt tells
us about Leninism ([section 15](append42.html#app15))

As we will hope to prove, Kronstadt was a popular uprising from below by the
same sailors, soldiers and workers that made the 1917 October revolution. The
Bolshevik repression of the revolt **can** be justified in terms of defending
the state power of the Bolsheviks but it cannot be defended in terms of
socialist theory. Indeed, it indicates that Bolshevism is a flawed political
theory which cannot create a socialist society but only a state capitalist
regime based on party dictatorship. This is what Kronstadt shows above all
else: given a choice between workers' power and party power, Bolshevism will
destroy the former to ensure the latter (see [ section
15](append42.html#app15) in particular). In this, Kronstadt is no isolated
event (as we indicate in [section 2](append42.html#app2)).

There are many essential resources on the revolt available. The best in depth
studies of the revolt are Paul Avrich's **Kronstadt 1921** and Israel
Getzler's **Kronstadt 1917-1921**. Anarchist works include Ida Mett's **The
Kronstadt Uprising** (by far the best), Alexander Berkman's **The Kronstadt
Rebellion** (which is a good introduction and included in his **The Russian
Tragedy**), Voline's **The Unknown Revolution** has a good chapter on
Kronstadt (and quotes extensively from the Kronstadters' paper
**_Izvestiia_**) and volume two of Daniel Guerin's **No Gods, No Masters** has
an excellent section on the rebellion which includes a lengthy extract from
Emma Goldman's autobiography **Living my Life** on the events as well as
extracts from the Kronstadters' paper. Anton Ciliga's (a libertarian
socialist/Marxist) **Kronstadt Revolt** is also a good introduction to the
issues relating to the uprising. Eye-witness accounts include chapters in
Berkman's **The Bolshevik Myth** as well as Goldman's **My Disillusionment in
Russia**. Goldman's autobiography **Living My Life** also has useful material
on the events.

For the Leninist analysis, the anthology **Kronstadt** contains Lenin and
Trotsky's articles on the revolt plus supplementary essays refuting anarchist
accounts. This work is recommended for those seeking the official Trotskyist
version of events as it contains all the relevant documents by the Bolshevik
leaders. Emma Goldman's **Trotsky Protests Too Much** is a great reply to
Trotsky's comments and one of his followers contained in this work. Victor
Serge was another eye-witness to the Kronstadt revolt. An individualist
anarchist turned Bolshevik, his **Memoirs of a Revolutionary** is worth
looking at to discover why he supported what the Bolsheviks did, albeit
reluctantly.

## 1 Why is the Kronstadt rebellion important?

The Kronstadt rebellion is important because, as Voline put it, it was _"the
first entirely independent attempt of the people to liberate itself from all
yokes and achieve the Social Revolution, an attempt made directly, resolutely,
and boldly by the working masses themselves without political shepherds,
without leaders or tutors. It was the first step towards the third and social
revolution."_ [**The Unknown Revolution**, pp. 537-8]

The Kronstadt sailors, solders and workers in 1917 had been the one of the
first groups to support the slogan _"All power to the Soviets"_ as well as one
of the first towns to put it into practice. The focal point of the 1921 revolt
-- the sailors of the warships **_Petropavlovsk_** and **_Sevastopol_** \--
had, in 1917, been supporters of the Bolsheviks. The sailors had been
considered, until those fateful days in 1921, the pride and glory of the
revolution and considered by all to be thoroughly revolutionary in spirit and
action. They were the staunchest supporters of the Soviet system but, as the
revolt showed, they were opposed to the dictatorship of any political party.

Therefore Kronstadt is important in evaluating the honesty of Leninist claims
to be in favour of soviet democracy and power. The civil war was effectively
over, yet the regime showed no signs of stopping the repression against
working class protest or rights. Opposing re-elections to soviets, the
Bolshevik regime was repressing strikers in the name of _"soviet power"_ and
_"the political power of the proletariat."_ In the countryside, the Bolsheviks
continued their futile, evil and counterproductive policies against the
peasants (ignoring the fact that their government was meant to be at the head
of a workers **and** peasants' state). Occurring as it did after the end of
the civil war, Kronstadt played a key role in opening the eyes of anarchists
like Emma Goldman and Alexander Berkman to the real role of Bolshevism in the
revolution. Until then, they (like many others) supported the Bolsheviks,
rationalising their dictatorship as a temporary measure necessitated by the
civil war. Kronstadt smashed that illusion, _"broke the last thread that held
me to the Bolsheviki. The wanton slaughter they had instigated spoke more
eloquently against than aught else. Whatever the pretences of the past, the
Bolsheviki now proved themselves the most pernicious enemies of the
Revolution. I would have nothing further to do with them."_ [Emma Goldman,
**My Disillusionment in Russia**, p. 200]

The events at Kronstadt cannot be looked at in isolation, but rather as part
of a general struggle of the Russian working people against "their"
government. Indeed, as we indicate in the [ next section](append42.html#app2),
this repression **after** the end of the Civil War followed the same pattern
as that started **before** it. Just as the Bolsheviks had repressed soviet
democracy in Kronstadt in 1921 in favour of party dictatorship, they had done
so regularly elsewhere in early 1918.

The Kronstadt revolt was a popular movement from below aiming at restoring
soviet power. As Alexander Berkman notes, the _"spirit of the Conference [of
delegates which elected the Provisional Revolutionary Committee] was
thoroughly Sovietist: Kronstadt demanded Soviets free from interference by any
political party; it wanted non-partisan Soviets that should truly reflect the
needs and express the will of the workers and peasants. The attitude of the
delegates was antagonistic to the arbitrary rule of bureaucratic commissars,
but friendly to the Communist Party as such. They were staunch adherents of
the Soviet **system** and they were earnestly seeking to find, by means
friendly and peaceful, a solution of the pressing problems"_ facing the
revolution. [**The Russian Tragedy**, p. 67] The attitude of the Bolsheviks
indicated that, for them, soviet power was only useful in so far as it ensured
their party's power and if the two came into conflict then the latter must
survive over the corpse of the former. Thus Berkman:

> _"But the 'triumph' of the Bolsheviks over Kronstadt held within itself the
defeat of Bolshevism. It exposes the true character of the Communist
dictatorship. The Communists proved themselves willing to sacrifice Communism,
to make almost any compromise with international capitalism, yet refused the
just demands of their own people -- demands that voiced the October slogans of
the Bolsheviks themselves: Soviets elected by direct and secret ballot,
according to the Constitution of the Russian Socialist Federal Soviet
Republic; and freedom of speech and press for the revolutionary parties."_
[**Op. Cit.**, p. 90]

Investigating the Kronstadt revolt forces intelligent and honest minds into a
critical examination of Bolshevik theories and practices. It exploded the
Bolshevik myth of the Communist State being the "Workers' and Peasants'
Government". It proved that the Communist Party dictatorship and the Russian
Revolution are opposites, contradictory and mutually exclusive. While it may
be justifiable to argue that the repression directed by the Bolsheviks against
working class people **during** the civil war could be explained by the needs
of the war, the same cannot be said for Kronstadt. Similarly, the Leninist
justifications for their power and actions at Kronstadt have direct
implications for current activity and future revolutions. As we argue in [
section 15](append42.html#app15), the logic of these rationales simply mean
that modern day Leninists will, if in the same position, destroy soviet
democracy to defend "soviet power" (i.e. the power of their party).

In effect, Kronstadt was the clash between the reality of Leninism and its
image or rhetoric. It raises many important issues as regards Bolshevism and
the rationale it has produced to justify certain actions. _"The Kronstadt
experience,"_ as Berkman argues, _"proves once more that government, the State
-- whatever its name or form -- is ever the mortal enemy of liberty and
popular self-determination. The state has no soul, no principles. It has but
one aim -- to secure power and hold it, at any cost. That is the political
lesson of Kronstadt."_ [**Op. Cit.**, p. 89]

Kronstadt is also important in that it, like most of the Russian Revolution
and Civil War, confirmed anarchist analysis and predictions. This can be seen
when **_Izvestiia_** (the paper produced during the rebellion by the
Provisional Revolutionary Committee) argued that in Kronstadt _"there have
been laid the foundations of the Third Revolution, which will break the last
chains of the workers and lay open the new highway to socialist
construction."_ [quoted by Voline, **The Unknown Revolution**, p. 508]

This confirmed the arguments of Russian anarchists in 1917, who had predicted
that _"if the 'transfer of power to the soviets' comes in fact to signify the
seizure of political authority by a new political party with the aim of
guiding reconstruction from above, 'from the centre'"_ then _"there is no
doubt that this 'new power' can in no way satisfy even the most immediate
needs and demands of the people, much less begin the task of 'socialist
reconstruction' . . . Then, after a more or less prolonged interruption, the
struggle will inevitably be renewed. Then will begin a third and last stage of
the Great Revolution. There will begin a struggle between the living forces
arising from the creative impulse of the popular masses on the spot, on the
one hand, namely the local workers' and peasants' organisations acting
directly . . . and the centralist Social Democratic power defending its
existence, on the other; a struggle between authority and freedom."_ [quoted
by Paul Avrich, **Anarchists in the Russian Revolution**, p. 94]

Thus Kronstadt is a symbol of the fact that state power cannot be utilised by
the working class and always becomes a force for minority rule (in this case
of former workers and revolutionaries, as Bakunin predicted).

There is another reason why the study of Kronstadt is important. Since the
suppression of the revolt, Leninist and Trotskyist groups have continually
**justified** the acts of the Bolsheviks. Moreover, they have followed Lenin
and Trotsky in slandering the revolt and, indeed, have continually lied about
it. When Trotskyist John Wright states that the supporters of Kronstadt have
_"distort[ed] historical facts, monstrously exaggerat[ed] every subsidiary
issue or question . . . and throw[n] a veil . . . over the **real** program
and aims of the mutiny"_ he is, in fact, describing his and his fellow
Trotskyists. [Lenin and Trotsky, **Kronstadt**, p. 102] Indeed, as we will
prove, anarchist accounts have been validated by later research while
Trotskyist assertions have been exploded time and time again. Indeed, it would
be a useful task to write a companion to Trotsky's book **The Stalin School of
Falsification** about Trotsky and his followers activities in the field of re-
writing history.

Similarly, when Trotsky argues that anarchists like Goldman and Berkman _"do
not have the slightest understanding of the criteria and methods of scientific
research"_ and just _"quote the proclamations of the insurgents like pious
preachers quoting Holy Scriptures"_ he is, in fact, just describing himself
and his followers (as we shall see, the latter just repeat his and Lenin's
assertions regardless of how silly or refuted they are). Ironically, he states
that _"Marx has said that it is impossible to judge either parties or peoples
by what they say about themselves."_ [Lenin and Trotsky, **Op. Cit.**, p. 88]
As Emma Goldman argued, _"[h]ow pathetic that he does not realise how much
this applies to him!"_ [**Trotsky Protests Too Much**] Kronstadt shows what
the Bolsheviks said about their regime was the opposite of what it really was,
as show by its actions.

What will also become clear from our discussion is the way Trotskyists have
doctored the academic accounts to fit their ideological account of the
uprising. The reason for this will become clear. Simply put, the supporters of
Bolshevism cannot help lie about the Kronstadt revolt as it so clearly exposes
the **real** nature of Bolshevik ideology. Rather than support the Kronstadt
call for soviet democracy, the Bolsheviks crushed the revolt, arguing that in
so doing they were defending "soviet power." Their followers have repeated
these arguments.

This expression of Leninist double-think (the ability to know two
contradictory facts and maintain both are true) can be explained. Once it is
understood that _"workers' power"_ and _"soviet power"_ actually mean **party
power** then the contradictions disappear. Party power had to be maintained at
all costs, including the destruction of those who desired real soviet and
workers' power (and so soviet democracy).

For example, Trotsky argued that in 1921 _"the proletariat had to hold
political power in its hands"_ yet later Trotskyists argue that the
proletariat was too exhausted, atomised and decimated to do so. [Lenin and
Trotsky, **Kronstadt**, p. 81] Similarly, the Trotskyist Pierre Frank states
that for the Bolsheviks, _"the dilemma was posed in these terms: either keep
the workers' state under their leadership, or see the counterrevolution begin,
in one or other political disguise, ending in a counterrevolutionary reign of
terror that would leave not the slightest room for democracy."_ [**Op. Cit.**,
p. 15] Of course the fact that there was _"not the slightest room for
democracy"_ under Lenin is not mentioned, nor is the fact that the
_"dictatorship of the party"_ had been a fundamental aspect of Bolshevik
idelogy since early 1919 and practice since mid-1918 (by the latest). Nor does
Frank consider it important to note that a _"reign of terror"_ did develop
under Stalin from the terror, repression and dictatorship practised in 1921 by
Lenin and Trotsky.

Most Leninists follow Frank and argue that the suppression of the rebellion
was essential to defend the _"gains of the revolution."_ What exactly were
these gains? Not soviet democracy, freedom of speech, assembly and press,
trade union freedom and so on as the Kronstadters were crushed for demanding
these. No, apparently the "gains" of the revolution was a Bolshevik government
pure and simple. Never mind the fact it was a one-party dictatorship, with a
strong and privileged bureaucratic machine and no freedom of speech, press,
association or assembly for working people. The fact that Lenin and Trotsky
were in power is enough for their followers to justify the repression of
Kronstadt and subscribe to the notion of a "workers' state" which excludes
workers from power.

Thus the double-think of Bolshevism is clearly seen from the Kronstadt events.
The Bolsheviks and their supporters argue that Kronstadt was suppressed to
defend soviet power yet argue that the Kronstadt demand for free soviet
elections was _"counter-revolutionary"_, _"backward"_, _"petty-bourgeois"_ and
so on. How soviet power could mean anything without free elections is never
explained. Similarly, they argue that it was necessary to defend the _"workers
state"_ by slaughtering those who called for workers to have some kind of say
in how that state operated. It appears that the role of workers in a workers'
state was simply that of following orders without question (indeed, Trotsky
was arguing in the 1930s that the Russian working class was still the ruling
class under Stalin -- _"So long as the forms of property that have been
created by the October Revolution are not overthrown, the proletariat remains
the ruling class."_ [**The Class Nature of the Soviet State**]).

How can the Bolshevik repression be justified in terms of defending workers
power when the workers were powerless? How can it be defended in terms of
soviet power when the soviets were rubber stamps of the government?

The logic of the Bolsheviks and their latter-day apologists and supporters is
the same character as that of the U.S. Officer during the Vietnam War who
explained that in order to save the village, they first had to destroy it. In
order to save soviet power, Lenin and Trotsky had to destroy soviet democracy.

One last point, while the Kronstadt revolt is a key event in the Russian
Revolution, one that signified its end, we must not forget that it is just one
in a long series of Bolshevik attacks on the working class. As we indicated in
the appendix on ["What happened during the Russian
Revolution?"](append41.html) (and provide an overview in the [next
section](append42.html#app2)), the Bolshevik state had proven itself to be
anti-revolutionary continually since October 1917. However, Kronstadt is
important simply because it so clearly pitted soviet democracy against "soviet
power" and occurred **after** the end of the civil war. As it brings the
Russian Revolution to an end, it deserves to be remembered, analysed and
discussed by all revolutionaries who seek to understand the past in order not
to repeat the same mistakes again.

## 2 What was the context of the Kronstadt revolt?

The Kronstadt revolt cannot be understood in isolation. Indeed, to do so
misses the real reason why Kronstadt is so important. Kronstadt was the end
result of four years of revolution and civil war, the product of the
undermining of soviet democracy by a combination of Bolshevism and war. The
actions of the Bolsheviks in 1921 and their ideological justifications for
their actions (justifications, of course, when they got beyond lying about the
revolt -- see [section 5](append42.html#app5)) merely reproduced in
concentrated form what had been occurring ever since they had seized power.

Therefore it is necessary to present a short summary of Bolshevik activities
before the events of Kronstadt (see ["What happened during the Russian
Revolution?"](append41.html) for fuller details). In addition, we have to
sketch the developing social stratification occurring under Lenin and the
events immediate before the revolt which sparked it off (namely the strike
wave in Petrograd). Once this has been done, we will soon see that Kronstadt
was not an isolated event but rather an act of solidarity with the oppressed
workers of Petrogard and an attempt to save the Russian Revolution from
Communist dictatorship and bureaucracy.

Alexander Berkman provides an excellent overview of what had happened in
Russia after the October Revolution:

> _"The elective system was abolished, first in the army and navy, then in the
industries. The Soviets of peasants and workers were castrated and turned into
obedient Communist Committees, with the dreaded sword of the Cheka [political
para-military police] ever hanging over them. The labour unions
governmentalised, their proper activities suppressed, they were turned into
mere transmitters of the orders of the State. Universal military service,
coupled with the death penalty for conscientious objectors; enforced labour,
with a vast officialdom for the apprehension and punishment of 'deserters';
agrarian and industrial conscription of the peasantry; military Communism in
the cities and the system of requisitioning in the country . . . ; the
suppression of workers' protests by the military; the crushing of peasant
dissatisfaction with an iron hand. . ."_ [**The Russian Tragedy**, p. 27]

We discussed each of these features in more detail in the appendix on ["What
happened during the Russian Revolution?"](append41.html). Here we will simply
indicate that the Bolsheviks had systematically undermined the effective power
of the soviets. Both locally and nationally, post-October power was
centralised into the hands of the soviet executives rather than the general
assemblies. At the top, power was concentrated even further with the creation
of a Bolshevik government **above** the Central Executive Council elected by
the (then) quarterly soviet congress. This is not all. Faced with growing
opposition to their policies, the Bolsheviks responded in two ways. Either the
soviet was gerrymandered to make the workplace soviet elections irrelevant (as
in, say, Petrograd) or they simply disbanded any soviet elected with a non-
Bolshevik majority (as in **all** provincial soviets for which records exist).
So Bolshevik opposition to the soviet democracy demanded by the Kronstadt
revolt had a long pedigree. It had started a few months after the Bolsheviks
seizure of power in the name of the soviets.

They repressed opposition parties to maintain their position (for example,
suppressing their newspapers). Similarly, the Bolsheviks attacked the
anarchists in Moscow on the 11-12 of April, 1918, using armed detachments of
the Cheka (the political police). The Kronstadt soviet, incidentally,
condemned the action by a vote of 81 to 57 against (with 15 abstentions).
[Getzler, **Kronstadt 1917-1921**, p. 186] This repression was political in
nature, aiming to neutralise a potential political threat and was not the only
example of political repression in this period (see the appendix on ["What
happened during the Russian Revolution?"](append41.html)).

This is just a summary of what was happening in Russia in early 1918 (see
[section 3](append43.html#app3) of the appendix on ["What caused the
degeneration of the Russian Revolution?"](append43.html) for more details).
This Bolshevik assault on the soviets occurred during the spring of 1918 (i.e.
in March, April and May). That is **before** the Czech rising and the onset of
full scale civil war which occurred in late May. Clearly, any attempt to blame
the Civil War for the elimination of soviet power and democracy seems woefully
weak given the actions of the Bolsheviks in the spring of 1918. And, equally
clearly, the reduction of local soviet influence cannot be fully understood
without factoring in the Bolshevik prejudice in favour of centralisation (as
codified in the Soviet Constitution of 1918) along with this direct
repression. Indeed, the net effect of the Russian Civil War helped the
Bolsheviks as it would make many dissident workers support the Bolsheviks
during the war. This, however, did not stop mass resistance and strikes
breaking out periodically during the war when workers and peasants could no
longer put up with Bolshevik policies or the effects of the war (see [section
5](append44.html#app5) of the appendix on ["What caused the degeneration of
the Russian Revolution?"](append44.html)).

Which, incidentally, answers Brian Bambery's rhetorical question of _"why
would the most militant working class in the world, within which there was a
powerful cocktail of revolutionary ideas, and which had already made two
revolutions (in 1905 and in February 1917), allow a handful of people to seize
power behind its back in October 1917?"_ [_"Leninism in the 21st Century"_,
**Socialist Review**, no. 248, January 2001] Once the Russian workers realised
that a handful of people **had** seized power they **did** protest the
usurpation of their power and rights by the Bolsheviks. The Bolsheviks
repressed them. With the start of the Civil War, the Bolsheviks played their
trump card -- _"Us or the Whites."_ This ensured their power as the workers
had few choices but to agree. Indeed, it may explain why the Bolsheviks
finally eliminated opposition parties and groups **after** the end of the
Civil War and only repressed them during it. With the Whites gone, the
opposition were rising in influence again and the _"White card"_ could no
longer be played.

Economically, the Bolshevik regime imposed a policy later called _"War
Communism"_ (although, as Victor Serge noted, _"any one who, like myself, went
so far as to consider it purely temporary was locked upon with disdain."_
[**Memoirs of a Revolutionary**, p. 115] This regime was marked by extreme
hierarchical and dictatorial tendencies. The leading lights of the Communist
Party were expressing themselves on the nature of the "socialist" regime they
desired. Trotsky, for example, put forward ideas for the _"militarisation of
labour"_ (as expounded in his infamous work **Terrorism and Communism**). Here
are a few representative selections from that work:

> _"The very principle of compulsory labour service is for the Communist quite
unquestionable. . . . But hitherto it has always remained a mere principle.
Its application has always had an accidental, impartial, episodic character.
Only now, when along the whole line we have reached the question of the
economic re-birth of the country, have problems of compulsory labour service
arisen before us in the most concrete way possible. The only solution of
economic difficulties that is correct from the point of view both of principle
and of practice is to treat the population of the whole country as the
reservoir of the necessary labour power . . . and to introduce strict order
into the work of its registration, mobilisation, and utilisation."_
[**Terrorism and Communism**, p. 135]

>

> _"The introduction of compulsory labour service is unthinkable without the
application, to a greater or less degree, of the methods of militarisation of
labour."_ [**Op. Cit.**, p. 137]

>

> _"Why do we speak of militarisation? Of course, this is only an analogy --
but an analogy very rich in content. No social organisation except the army
has ever considered itself justified in subordinating citizens to itself in
such a measure, and to control them by its will on all sides to such a degree,
as the State of the proletarian dictatorship considers itself justified in
doing, and does."_ [**Op. Cit.**, p. 141]

>

> _"Both economic and political compulsion are only forms of the expression of
the dictatorship of the working class in two closely connected regions . . .
under Socialism there will not exist the apparatus of compulsion itself,
namely, the State: for it will have melted away entirely into a producing and
consuming commune. None the less, the road to Socialism lies through a period
of the highest possible intensification of the principle of the State . . .
Just as a lamp, before going out, shoots up in a brilliant flame, so the
State, before disappearing, assumes the form of the dictatorship of the
proletariat, i.e., the most ruthless form of State, which embraces the life of
the citizens authoritatively in every direction. . . No organisation except
the army has ever controlled man with such severe compulsion as does the State
organisation of the working class in the most difficult period of transition.
It is just for this reason that we speak of the militarisation of labour."_
[**Op. Cit.**, pp. 169-70]

This account was written as a policy to be followed now that the _"internal
civil war is coming to an end."_ [**Op. Cit.**, p. 132] It was not seen as a
temporary policy imposed upon the Bolsheviks by the war but rather, as can be
seen, as an expression of _"principle"_ (perhaps because Marx and Engels had
written about the _"[e]stablishment of industrial armies"_ in the **Communist
Manifesto**? [Selected Writings, p. 53]).

In the same work, Trotsky justified the elimination of soviet power and
democracy by party power and dictatorship (see sections
[10](append42.html#app10) and [15](append42.html#app15)). Thus we have the
application of state serfdom by the Bolsheviks (indeed, Trotsky was allowed to
apply his ideas on the militarisation of labour to the railways).

This vision of strict centralisation and top-down military structures built
upon Bolshevik policies of the first months after the October revolution. The
attempts at workers' self-management organised by many factory committees was
opposed in favour of a centralised state capitalist system, with Lenin arguing
for appointed managers with _"dictatorial"_ powers (see Maurice Brinton's
**The Bolsheviks and Workers' Control** for full details as well as ["What
happened during the Russian Revolution?"](append41.html)).

Strikes were repressed by force. In early May, 1918, a major wave of labour
protest started which climaxed in early July. In Petrograd it included
strikes, demonstrations and anti-Bolshevik factory meetings. Of the meetings
unconnected to the Petrograd Soviet elections, _"the greatest number by far
were protests against some form of Bolshevik repression: shootings, incidents
of 'terrorist activities', and arrests."_ During the opposition organised
strike of July 2nd, _"Zinoviev and others took quick counteraction . . . Any
sign of sympathy for the strike was declared a criminal act. More arrests were
made . . . On July 1 . . . machine guns were set up at main points throughout
Petrograd and Moscow railroad junctions, and elsewhere in both cities as well.
Controls were tightened in the factories. Meetings were forcefully
dispersed."_ [William G. Rosenberg, **Russian Labour and Bolshevik Power**,
pp. 123-4 and p. 127]

In 1918, workers who took strike action _"were afraid to lose their jobs"_ as
_"a strike inevitably led to a closure of the factory, a dismissal of the
workers, and a careful screening of those rehired to determine their political
preferences."_ By 1920, as well as these methods, workers also faced arrest by
the Cheka and _"internment in a concentration camp."_ During the first six
months of 1920 there were strikes in 77 percent of the medium- and large-size
enterprises in Russia. As an example of the policies used to crush strikes, we
can take the case of a strike by the workers of the Ryazan-Urals railroad in
May 1921 (i.e. **after** the end of the Civil War). The authorities _"shut
down the depot, brought in troops, and arrested another hundred workers"_ in
addition to the strikers delegates elected to demand the release of a railroad
worker (whose arrest had provoked the strike). Ironically, those _"who had
seized power in 1917 in the name of the politically conscious proletariat were
in fact weeding out all these conscious workers."_ [V. Brovkin, **Behind the
Front Lines of the Civil War**, pp. 287-8, pp. 290-1 and p. 298]

In the Red Army and Navy, anti-democratic principles were again imposed. At
the end of March, 1918, Trotsky reported to the Communist Party that _"the
principle of election is politically purposeless and technically inexpedient,
and it has been, in practice, abolished by decree."_ Soldiers did not have to
fear this system of top-down appointment as _"political power is in the hands
of the same working class from whose ranks the Army is recruited"_ (i.e. in
the hands of the Bolshevik party). There could _"be no antagonism between the
government and the mass of the workers, just as there is no antagonism between
the administration of the union and the general assembly of its members, and,
therefore, there cannot be any grounds for fearing the **appointment** of
members of the commanding staff by the organs of the Soviet Power."_ [**Work,
Discipline, Order**] Of course, as any worker in struggle can tell you, they
almost always come into conflict with the union's bureaucracy (as Trotskyists
themselves often point out).

In the Navy, a similar process occurred -- much to the disgust and opposition
of the sailors. As Paul Avrich notes, _"Bolshevik efforts to liquidate the
ship committees and impose the authority of the centrally appointed commissars
aroused a storm of protest in the Baltic Fleet. For the sailors, whose
aversion to external authority was proverbial, any attempt to restore
discipline meant a betrayal of the freedoms for which they had struggles in
1917."_ [**Kronstadt 1921**, p. 66] This process _"began in earnest on 14 May
1918 with the **appointment** of Ivan Flerovsky as general commissar of the
Baltic Fleet and chairman of its Council of Commissars, a body which replaced
the disbanded elective Central Committee of the Baltic Fleet. Flerovsky
promptly appointed bridge commissars to whom all ships' committees were
subordinated . . . Naval democracy was finally destroyed on 18 January 1919
when Trotsky . . . decreed the abolition of all ships' committees, the
appointment of commissars to all ships, and the setting up of revolutionary
tribunals to maintain discipline, a function previously vested in elected
'comradely courts.'"_ [I. Getzler, **Kronstadt 1917-1921**, p. 191]

In the countryside, grain requisitioning was resulting in peasant uprisings as
food was taken from the peasants by force. While the armed detachments were
_"instructed to leave the peasants enough for their personal needs, it was
common for the requisitioning squads to take at gun-point grain intended for
personal consumption or set aside for the next sowing."_ The villagers
predictably used evasive tactics and cut back on the amount of land they
tilled as well as practising open resistance. Famine was a constant problem as
a result. [Avrich, **Op. Cit.**, pp. 9-10]

Thus Voline:

> _"the Bolshevik government evidently understood the slogan 'power to the
soviets' in a peculiar way. It applied it in reverse. Instead of giving
assistance to the working masses and permitting them to conquer and enlarge
their own autonomous activity, it began by taking all 'power' from them and
treating them like subjects. It bent the factories to its will and liberated
the workers from the right to make their own decisions; it took arbitrary and
coercive measures, without even asking the advice of the workers' concerned;
it ignored the demands emanating from the workers' organisations. And, in
particular, it increasingly curbed, under various pretexts, the freedom of
action of the Soviets and of other workers' organisations, everywhere imposing
its will arbitrarily and even by violence."_ [**The Unknown Revolution**, pp.
459-60]

From before the start of Civil War, the Russian people had been slowly but
surely eliminated from any meaningful say in the progress of the revolution.
The Bolsheviks undermined (when not abolishing) workers' democracy, freedom
and rights in the workplaces, the soviets, the unions, the army and the navy.
Unsurprisingly, the lack of any real control from below heightened the
corrupting effects of power. Inequality, privilege and abuses were everywhere
in the ruling party and bureaucracy (_"Within the party, favouritism and
corruption were rife. The Astoria Hotel, where many high officials lived, was
the scene of debauchery, while ordinary citizens went without the bare
necessities."_ [Paul Avrich, **Bolshevik Opposition to Lenin: G. T. Miasnikov
and the Workers' Group**]).

With the end of the Civil War in November 1920, many workers expected a change
of policy. However, months passed and the same policies were followed. _"The
Communist State,"_ as Alexander Berkman summarised, _"showed no intention of
loosening the yoke. The same policies continued, with labour militarisation
still further enslaving the people, embittering them with added oppression and
tyranny, and in consequence paralysing every possibility of industrial
revival."_ [**The Russian Tragedy**, p. 61] Finally, in the middle of
February, 1921, _"a rash of spontaneous factory meetings"_ began in Moscow.
Workers called for the immediate scrapping of War Communism. These meetings
were _"succeeded by strikes and demonstrations."_ Workers took to the streets
demanding _"free trade"_, higher rations and _"the abolition of grain
requisitions."_ Some demanded the restoration of political rights and civil
liberties. Troops had to be called in to restore order. [Paul Avrich, **Op.
Cit.**, pp. 35-6]

Then a far more serious wave of strikes and protests swept Petrograd. The
Kronstadt revolt was sparked off by these protests. Like Moscow, these
_"street demonstrations were heralded by a rash of protest meetings in
Petrograd's numerous but depleted factories and shops."_ Like Moscow, speakers
_"called for an end to grain requisitioning, the removal of roadblocks, the
abolition of privileged rations, and permission to barter personal possessions
for food."_ On the 24th of February, the day after a workplace meeting, the
Trubochny factory workforce downed tools and walked out the factory.
Additional workers from nearby factories joined in. The crowd of 2,000 was
dispersed by armed military cadets. The next day, the Trubochny workers again
took to the streets and visited other workplaces, bringing them out on strike
too. [Avrich, **Op. Cit.**, pp. 37-8]

The strikers started to organise themselves. _"As in 1918, workers from
various plants elected delegates to the Petrograd Assembly of
Plenipotentiaries."_ [V. Brovkin, **Behind the Front Lines of the Civil War**,
p. 393]

A three-man Defence Committee was formed and Zinoviev _"proclaimed martial
law"_ on February 24th. [Avrich, **Op. Cit.**, p. 39] A curfew of 11pm was
proclaimed, all meetings and gatherings (indoor and out) were banned unless
approved of by the Defence Committee and all infringements would _"be dealt
with according to military law."_ [Ida Mett, **The Kronstadt Uprising**, p.
37]

The workers _"were ordered to return to their factories, failing which they
would be denied their rations. That, however, had no impact: but in addition,
a number of trade unions was disbanded, their leaders and the most die-hard
strikers tossed into prison."_ [Emma Goldman, **No Gods, No Masters**, vol. 2,
p. 168]

As part of this process of repression, the Bolshevik government had to rely on
the _**kursanty**_ (Communist officer cadets) as the local garrisons had been
caught up the general ferment and could not be relied upon to carry out the
government's orders. Hundreds of _**kursanty**_ were called in from
neighbouring military academies to patrol the city. _"Overnight Petrograd
became an armed camp. In every quarter pedestrians were stopped and their
documents checked . . . the curfew [was] strictly enforced."_ The Petrograd
Cheka made widespread arrests. [Avrich, **Op. Cit.**, pp. 46-7]

The Bolsheviks also stepped up their propaganda drive. The strikers were
warned not to play into the hands of the counterrevolution. As well as their
normal press, popular party members were sent to agitate in the streets,
factories and barracks. They also made a series of concessions such as
providing extra rations. On March 1st (after the Kronstadt revolt had started)
the Petrograd soviet announced the withdrawal of all road-blocks and
demobilised the Red Army soldiers assigned to labour duties in Petrograd.
[Avrich, **Op. Cit.**, pp. 48-9]

Thus a combination of force, propaganda and concessions was used to defeat the
strike (which quickly reached a near general strike level). As Paul Arvich
notes, _"there is no denying that the application of military force and the
widespread arrests, not to speak of the tireless propaganda waged by the
authorities had been indispensable in restoring order. Particularly impressive
in this regard was the discipline shown by the local party organisation.
Setting aside their internal disputes, the Petrograd Bolsheviks swiftly closed
ranks and proceeded to carry out the unpleasant task of repression with
efficiency and dispatch."_ [**Op. Cit.**, p. 50]

This indicates the immediate context of the Kronstadt rebellion. Yet
Trotskyist J. G. Wright wonders whether the Kronstadt's paper _"lied when in
the very first issue . . . it carried a sensational headline: 'General
Insurrection in Petrograd'"_ and states that people _"spread . . . lies about
the insurrection in Petrograd."_ [Lenin and Trotsky, **Kronstadt**, p. 109]
Yes, of course a near general strike, accompanied by mass meetings and
demonstrations and repressed by force and martial law, is a everyday
occurrence and has nothing in common with an _"insurrection"_! If such events
occurred in a state not headed by Lenin and Trotsky it is unlikely Mr. Wright
would have such difficulty in recognising them for what there were. Historian
V. Brovkin states the obvious when he wrote _"[t]o anyone who had lived
through the events of February 1917, this chain of events appeared strikingly
similar. It looked as if a popular insurrection had begun."_ [Brovkin, **Op.
Cit.**, p. 393]

It was these labour protests and their repression which started the events in
Kronstadt. While many sailors had read and listened to the complaints of their
relatives in the villages and had protested on their behalf to the Soviet
authorities, it took the Petrograd strikes to be the catalyst for the revolt.
Moreover, they had other political reasons for protesting against the policies
of the government. Navy democracy had been abolished by decree and the soviets
had been turned into fig-leaves of party dictatorship.

Unsurprisingly, the crew of the battleships _**Petropavlovsk**_ and
**_Sevastopol_** decided to act once _"the news of strikes, lockouts, mass
arrests and martial law"_ in Petrograd reached them. They _"held a joint
emergency meeting in the face of protests and threats of their commissars . .
. [and] elected a fact-finding delegation of thirty-two sailors which, on 27
February, proceeded to Petrograd and made the round of the factories. . . They
found the workers whom they addressed and questioned too frightened to speak
up in the presence of the hosts of Communist factory guards, trade union
officials, party committee men and Chekists."_ [Gelzter, **Kronstadt
1917-1921**, p. 212]

The delegation returned the next day and reported its findings to a general
meeting of the ship's crews and adopted the resolutions which were to be the
basis of the revolt (see [next section](append42.html#app3)). The Kronstadt
revolt had started.

## 3 What was the Kronstadt Programme?

It is rare for a Trotskyist to actually list the demands of the Kronstadt
revolt in their entirety. For example, John Rees does not provide even a
summary of the 15 point programme. He asserts that the _"sailors represented
the exasperated of the peasantry with the War Communism regime"_ while, rather
lamely, noting that _"no other peasant insurrection reproduced the
Kronstadters demands."_ [_"In Defence of October"_, pp. 3-82, **International
Socialism**, no. 52, p. 63] Similarly, it is only the _"Editorial Preface"_ in
the Trotskyist work **Kronstadt** which presents even a summary of the
demands. This summary states:

> _"The resolution demanded free elections in the soviets with the
participation of anarchists and Left SRs, legalisation of the socialist
parties and the anarchists, abolition of the Political Departments [in the
fleet] and the Special Purpose Detachments, removal of the **zagraditelnye
ottyady** [Armed troops used to prevent unauthorised trade], restoration of
free trade, and the freeing of political prisoners."_ [Lenin and Trotsky,
**Kronstadt**, pp. 5-6]

They assert in the _"Glossary"_ that it _"demanded political and economic
changes, many of which were soon realised with the adoption of the NEP."_
[**Op. Cit.**, p. 148] Which, ironically enough, contradicts Trotsky who
claimed that it was an _"illusion"_ to think _"it would have been sufficient
to inform the sailors of the NEP decrees to pacify them."_ Moreover, the
_"insurgents did not have a conscious program, and they could not have had one
because of the very nature of the petty bourgeoisie. They themselves did not
clearly understand that their fathers and brothers needed first of all was
free trade."_ [**Op. Cit.**, p. 91-2]

So we have a uprising which was peasant in nature, but whose demands did not
have anything in common with other peasant revolts. It apparently demanded
free trade and did not demand it. It was similar to the NEP, but the NEP
decrees would not have satisfied it. It produced a platform of political and
economic demands but did not, apparently, have a _"conscious program."_ The
contradictions abound. Why these contradictions exist will become clear after
we list the 15 demands.

The full list of demands are as follows:

> _ "1. Immediate new elections to the Soviets. The present Soviets no longer
express the wishes of the workers and peasants. The new elections should be by
secret ballot, and should be preceded by free electoral propaganda._

> _ 2\. Freedom of speech and of the press for workers and peasants, for the
Anarchists, and for the Left Socialist parties._

> _ 3\. The right of assembly, and freedom for trade union and peasant
organisations._

> _ 4\. The organisation, at the latest on 10th March 1921, of a Conference of
non-Party workers, solders and sailors of Petrograd, Kronstadt and the
Petrograd District._

> _ 5\. The liberation of all political prisoners of the Socialist parties,
and of all imprisoned workers and peasants, soldiers and sailors belonging to
working class and peasant organisations._

> _ 6\. The election of a commission to look into the dossiers of all those
detained in prisons and concentration camps._

> _ 7\. The abolition of all political sections in the armed forces. No
political party should have privileges for the propagation of its ideas, or
receive State subsidies to this end. In the place of the political sections
various cultural groups should be set up, deriving resources from the State._

> _ 8\. The immediate abolition of the militia detachments set up between
towns and countryside._

> _ 9\. The equalisation of rations for all workers, except those engaged in
dangerous or unhealthy jobs._

> _ 10\. The abolition of Party combat detachments in all military groups. The
abolition of Party guards in factories and enterprises. If guards are
required, they should be nominated, taking into account the views of the
workers._

> _ 11\. The granting to the peasants of freedom of action on their own soil,
and of the right to own cattle, provided they look after them themselves and
do not employ hired labour._

> _ 12\. We request that all military units and officer trainee groups
associate themselves with this resolution. _

> _ 13\. We demand that the Press give proper publicity to this resolution._

> _ 14\. We demand the institution of mobile workers' control groups._

> _ 15\. We demand that handicraft production be authorised provided it does
not utilise wage labour."_ [quoted by Ida Mett, **The Kronstadt Revolt**, pp.
37-8]

This is the program described by the Soviet government as a _"SR-Black
Hundreds resolution"_! This is the program which Trotsky maintains was drawn
up by _"a handful of reactionary peasants and soldiers."_ [Lenin and Trotsky,
**Kronstadt**, p. 65 and p. 98] As can be seen, it was nothing of the kind.
Indeed, this resolution is largely in the spirit of the political slogans of
the Bolsheviks before they seized of power in the name of the soviets.
Moreover, it reflected ideals expounded in 1917 and were formalised in the
Soviet State's 1918 constitution. In the words of Paul Avrich, _"[i]n effect,
the **_Petropavlovsk_** resolution was an appeal to the Soviet government to
live up to its own constitution, a bold statement of those very rights and
freedom which Lenin himself had professed in 1917. In spirit, it was a
throwback to October, evoking the old Leninist watchword of 'All power to the
soviets.'"_ [**Kronstadt 1921**, pp. 75-6] Hardly an example of
_"reactionary"_ politics, unless the slogans of 1917 and the 1918 constitution
of the U.S.S.R. are also _"reactionary."_

While these fifteen demands are central to the revolt, looking at the paper
produced by the revolt helps us understand the nature of these demands and
place them in a fuller political context. _"The pages of **_Izvestiia_**,"_ as
Voline argued, _"give abundant proof of th[e] general enthusiasm, which re-
appeared once the masses felt they had regained, in the free Soviets, the true
road to emancipation and the hope of achieving the real revolution."_
[**Unknown Revolution**, p. 495] For example, food rations were equalised,
except for the sick and to children, who received a larger one. Left-wing
political parties were legalised. The Provisional Revolutionary Committee was
elected by a _"Conference of Delegates"_ made up of over two hundred delegates
from military units and workplaces. This body elected the Provisional
Revolutionary Committee on March 2nd and enlarged it (again by election) on
March 4th.

The March 4th Conference of Delegates also _"decided that all workers, without
exception, should be armed and put in charge of guarding the interior of the
city"_ and to organise re-elections for _"the administrative commissions of
all the unions and also of the Council of Unions"_ (which could _"become the
principle organ of the workers"_). [**_Izvestiia_** quoted by Voline, **The
Unknown Revolution**, p. 494]

In the article _"The Goals for Which We Fight,"_ the rebels argue that
_"[w]ith the aid of state unions"_ the Communists have _"chained the workers
to the machines, and transformed work into a new slavery instead of making it
pleasant."_ Moreover, to the _"protests of the peasants, which have gone so
far as spontaneous revolts, to the demands of the workers, compelled by the
very conditions of their life to resort to strikes, they reply with mass
shootings and a ferocity that the Tsarist generals might have envied."_ An
_"inevitable third revolution"_ was coming, shown by _"increasing"_ workers'
strikes, which will be _"achieved by the labouring masses themselves."_ This
would be based on _"freely elected soviets"_ and the reorganisation of _"the
state unions into free associations of workers, peasants and intellectuals."_
[**_Izvestiia_** quoted by Voline, **Op. Cit.**, pp. 507-8]

Thus the rebels saw clearly the real nature of nationalisation. Rather than
being the basis of socialism, it simply produced more wage slavery, this time
to the state (_"From a slave of the capitalist the worker was transformed into
a slave of state enterprises."_ [**_Izvestiia_** quoted by Voline, **Op.
Cit.**, p. 518]). They clearly saw the need to replace wage slavery to the
state (via nationalised property) with free associations of free workers and
peasants. Such a transformation would come from the collective direct action
and self-activity of working people, as expressed in the strikes which had so
recently swept across the country.

This transformation from the bottom up was stressed elsewhere. The unions,
**_Izvestiia_** argued, would _"fulfil the great and urgent task of educating
the masses for an economic and cultural renovation of the country. . . The
Soviet Socialist Republic cannot be strong unless its administration be
exercised by the working class, with the help of renovated unions."_ These
should _"become real representatives of the interests of the people."_ The
current unions did _"nothing"_ to promote _"economic activity of a co-
operative nature"_ or the _"cultural education"_ of their members due
centralised system imposed by the Communist regime. This would change with
_"true union activity by the working class."_ [**_Izvestiia_** quoted by
Voline, **Op. Cit.**, p. 510] A strong syndicalist perspective clearly can be
seen here, urging self-managed unions to be at the forefront of transforming
the economy into a free association of producers. They opposed any "socialist"
system in which the peasant _"has been transformed into a serf in the 'soviet'
economy,"_ the worker _"a simple wage-worker in the State factories"_ and
those who protest are _"thrown into the jails of the Cheka."_ [**_Izvestiia_**
quoted by Voline, **Op. Cit.**, p. 512]

The rebels saw that soviet power cannot exist while a political party
dominated the soviets. They argued that Russia was just _"State Socialism with
Soviets of functionaries who vote docilely what the authorities and their
infallible commissars dictate to them."_ Without real working class power,
without _"the will of the worker"_ expressed in their free soviets, corruption
had become rampant (_"Communists . . . live in ease and the commissars get
fat."_). Rather than a _"time of free labour in the fields, factories and
workshops,"_ where _"power"_ was in _"the hands of the workers,"_ the
_"Communists ha[d] brought in the rule of the commissars, with all the
despotism of personal power."_ [**_Izvestiia_**, quoted by Voline, **Op.
Cit.**, p. 519, p. 518, p. 511 and p. 518]

In opposition to this, the rebels argued that _"Revolutionary Kronstadt . . .
fights for the true Soviet Republic of the workers in which the producer
himself will be owner of the products of his labour and can dispose of them as
he wishes."_ They desired _"a life animated by free labour and the free
development of the individual"_ and so proclaimed _"All power to the Soviets
and not to the parties"_ and _"the power of the free soviets."_
[**_Izvestiia_** quoted by Voline, **Op. Cit.**, p. 519]

As can be seen, while the 15 demands are the essence of the revolt, looking at
**_Izvestiia_** confirms the revolutionary nature of the demands. The rebels
of 1921, as in 1917, looked forward to a system of free soviets in which
working people could transform their society into one based on free
associations which would encourage individual freedom and be based on working
class power. They looked to a combination of renewed and democratic soviets
and unions to transform Russian society into a **real** socialist system
rather than the system of state capitalism the Bolsheviks had imposed (see
Maurice Brintin's **The Bolsheviks and Workers' Control** for details of
Lenin's commitment to building state capitalism in Russia from 1917 onwards).

Clearly, Kronstadt's political programme was deeply socialist in nature. It
opposed the new wage slavery of the workers to the state and argued for free
associations of free producers. It was based on the key slogan of 1917, _"All
power to the soviets"_ but built upon it by adding the rider _"but not to
parties."_ The sailors had learned the lesson of the October revolution,
namely that if a party held power the soviets did not. The politics of the
revolt were not dissimilar to those of libertarian socialists and, as we argue
in [section 9](append42.html#app9), identical to the dominant ideas of
Kronstadt in 1917.

The question now arises, whose interests did these demands and politics
represent. According to Trotskyists, it is the interests of the peasantry
which motivated them. For anarchists, it is an expression of the interests of
all working people (proletarian, peasant and artisan) against those who would
exploit their labour and govern them (be it private capitalists or state
bureaucrats). We discuss this issue in the [next section](append42.html#app4).

## 4 Did the Kronstadt rebellion reflect _"the exasperation of the
peasantry"_?

This is a common argument of Trotskyists. While rarely providing the Kronstadt
demands, they always assert that (to use John Rees' words) that the sailors
_"represented the exasperation of the peasantry with the War Communist
regime."_ [_"In Defence of October"_, **International Socialism** no. 52, p.
63]

As for Trotsky, the ideas of the rebellion _"were deeply reactionary"_ and
_"reflected the hostility of the backward peasantry toward the worker, the
self-importance of the soldier or sailor in relation to 'civilian' Petrograd,
the hatred of the petty bourgeois for revolutionary discipline."_ The revolt
_"represented the tendencies of the land-owning peasant, the small speculator,
the kulak."_ [Lenin and Trotsky, **Kronstadt**, p. 80 and p. 81]

How true is this? Even a superficial analysis of the events of the revolt and
of the **_Petropavlovsk_** resolution (see [last section](append42.html#app3))
can allow the reader to dismiss Trotsky's assertions.

Firstly, according to the definition of _"kulak"_ proved by the Trotskyists'
themselves, we discover that kulak refers to _"well-to-do peasants who owned
land and hired poor peasants to work it."_ [Lenin and Trotsky, **Op. Cit.**,
p. 146] Point 11 of the Kronstadt demands explicitly states their opposition
to rural wage labour. How could Kronstadt represent _"the kulak"_ when it
called for the abolition of hired labour on the land? Clearly, the revolt did
not represent the _"small speculator, the kulak"_ as Trotsky asserted. Did it
represent the land-owning peasant? We will return to this issue shortly.

Secondly, the Kronstadt revolt started after the sailors at Kronstadt sent
delegates to investigate the plight of striking workers in Petrograd. Their
actions were inspired by solidarity for these workers and civilians. This
clearly shows that Trotsky's assertion that the revolt _"reflected the
hostility of the backward peasantry toward the worker, the self-importance of
the soldier or sailor in relation to 'civilian' Petrograd"_ to be utter and
total nonsense.

As for the being _"deeply reactionary,"_ the ideas that motivated the revolt
clearly were not. They were the outcome of solidarity with striking workers
and called for soviet democracy, free speech, assembly and organisation for
workers and peasants. These express the demands of most, if not all, Marxist
parties (including the Bolsheviks in 1917) before they take power. They simply
repeat the demands and facts of the revolutionary period of 1917 and of the
Soviet Constitution. As Anton Ciliga argues, these demands were _"impregnated
with the spirit of October; and no calumny in the world can cast a doubt on
the intimate connection existing between this resolution and the sentiments
which guided the expropriations of 1917."_ [_"The Kronstadt Revolt"_, **The
Raven**, no, 8, pp. 330-7, p. 333] If the ideas of the Kronstadt revolt are
reactionary, then so is the slogan _"all power to the soviets."_

Not that the Kronstadters had not been smeared before by their opponents. The
ex-Bolshevik turned Menshevik Vladimir Voitinsky who had visited the base in
May 1917 later remembered them as being _"degraded and demoralised"_ and
_"lack[ing] proletarian class-consciousness. It has the psychology of a
**Lumpenproletariat**, a stratum that is a danger to a revolution rather than
its support."_ They were _"material suitable for a rebellion **a la**
Bakunin."_ [quoted by I. Getzler, **Kronstadt 1917-1921**, p. 253]

So did the demands represent the interests of the (non-kulak) peasantry? To do
so we must see whether the demands reflected those of industrial workers or
not. If the demands do, in fact, match those of striking workers and other
proletarian elements then we can easily dismiss this claim. After all, if the
demands of the Kronstadt rebellion reflected those of proletarians then it is
impossible to say that they simply reflected the needs of peasants (of course,
Trotskyists will argue that these proletarians were also _"backward"_ but, in
effect, they are arguing that any worker who did not quietly follow Bolshevik
orders was _"backward"_ \-- hardly a sound definition of the term!!).

We can quickly note that demands echoed those raised during the Moscow and
Petrograd strikes that preceded the Kronstadt revolt. For example, Paul Avrich
records that the demands raised in the February strikes included _"removal of
roadblocks, permission to make foraging trips into the countryside and to
trade freely with the villagers, [and] elimination of privileged rations for
special categories of working men."_ The workers also _"wanted the special
guards of armed Bolsheviks, who carried out a purely police function,
withdrawn from the factories"_ and raised _"pleas for the restoration of
political and civil rights."_ One manifesto which appeared (unsigned but bore
earmarks of Menshevik origin) argued that _"the workers and peasants need
freedom. They do not want to live by the decrees of the Bolsheviks. They want
to control their own destinies."_ It urged the strikers to demand the
liberation of all arrested socialists and nonparty workers, abolition of
martial law, freedom of speech, press and assembly for all who labour, free
elections of factory committees, trade unions, and soviets. [Avrich,
**Kronstadt 1921**, pp. 42-3]

In the strikes of 1921, according to Lashevich (a Bolshevik Commissar) the
_"basic demands are everywhere the same: free trade, free labour, freedom of
movement, and so on."_ Two key demands raised in the strikes dated back to at
least 1920. These were _"for free trade and an end to privilege."_ In March
1919, _"the Rechkin coach-building plant demanded equal rations for all
**workers**"_ and that one of the _"most characteristic demands of the
striking workers at that time were for the free bringing-in of food."_ [Mary
McAuley, **Bread and Justice**, p. 299 and p. 302]

As can be seen, these demands related almost directly to points 1, 2, 3, 5, 8,
9, 10, 11 and 13 of the Kronstadt demands. As Paul Avrich argues, the
Kronstadt demands _"echoed the discontents not only of the Baltic Fleet but of
the mass of Russians in towns and villages throughout the country. Themselves
of plebeian stock, the sailors wanted relief for their peasant and worker
kinfolk. Indeed, of the resolution's 15 points, only one -- the abolition of
the political departments in the fleet -- applied specifically to their own
situation. The remainder . . . was a broadside aimed at the policies of War
Communism, the justification of which, in the eyes of the sailors and of the
population at large, had long since vanished."_ Avrich argues that many of the
sailors had returned home on leave to see the plight of the villagers with
their own eyes played at part in framing the resolution (particularly of point
11, the **only** peasant specific demand raised) but _"[b]y the same token,
the sailors' inspection tour of Petrograd's factories may account for their
inclusion of the workingmen's chief demands -- the abolition of road-blocks,
of privileged rations, and of armed factory squads -- in their program."_
[Avrich, **Op. Cit.**, pp. 74-5] Simply put, the Kronstadt resolution _"merely
reiterated long standing workers' demands."_ [V. Brovkin, **Behind the Front
Lines of the Civil War**, p. 395]

Which means, of course, that Ida Mett had been correct to argue that the
_"Kronstadt revolution had the merit of stating things openly and clearly. But
it was breaking no new ground. Its main ideas were being discussed everywhere.
For having, in one way or another, put forward precisely such ideas, workers
and peasants were already filling the prisons and the recently set up
concentration camps."_ [**The Kronstadt Uprising**, p. 39]

Nor can it be claimed that these workers were non-proletarians (as if class is
determined by thought rather than social position). Rather than being those
workers with the closest relations with the countryside who were protesting,
the opposite was the case. By 1921 _"[a]ll who had relatives in the country
had rejoined them. The authentic proletariat remained till the end, having the
most slender connections with the countryside."_ [Ida Mett, **Op. Cit.**, p.
36]

Thus the claims that the Kronstadt demands reflected peasant needs is
mistaken. They reflected the needs of the whole working population, including
the urban working class who raised these demands continually throughout the
Civil War period in their strikes. Simply put, the policies of the Bolsheviks
as regards food were not only evil, they did not work and were counter-
productive. As many of the Russian working class recognised from the start and
took strike action over again and again.

Moreover, by focusing on the _"free trade"_ issue, Leninists distort the real
reasons for the revolt. As Ida Mett points out, the Kronstadt rebellion did
not call for _"free trade"_ as the Trotskyists argue, but rather something far
more important:

> _"In the Kronstadt Isvestia of March 14th we find a characteristic passage
on this subject. The rebels proclaimed that 'Kronstadt is not asking for
freedom of trade but for genuine power to the Soviets.' The Petrograd strikers
were also demanding the reopening of the markets and the abolition of the road
blocks set up by the militia. But they too were stating that freedom of trade
by itself would not solve their problems."_ [**Op. Cit.**, p. 77]

Thus we have the Petrograd (and other) workers calling for _"free trade"_ (and
so, presumably, expressing their economic interests or those of their fathers
and brothers) while the Kronstadt sailors were demanding first and foremost
soviet power! Their programme called for the _"granting to the peasants of
freedom of action on their own soil, and of the right to own cattle, provided
they look after them themselves and do not employ hired labour."_ This was
point 11 of the 15 demands, which showed the importance it ranked in their
eyes. This would have been the basis of trade between town and village, but
trade between worker and peasant and not between worker and kulak. So rather
than call for _"free trade"_ in the abstract (as many of the workers were) the
Kronstadters (while reflecting the needs of both workers and peasants) were
calling for the free exchange of products between workers, not workers and
rural capitalists (i.e. peasants who hired wage slaves). This indicates a
level of political awareness, an awareness of the fact that wage labour is the
essence of capitalism.

Thus Ante Ciliga:

> _"People often believe that Kronstadt forced the introduction of the New
Economic Policy (NEP) -- a profound error. The Kronstadt resolution pronounced
in favour of the defence of the workers, not only against the bureaucratic
capitalism of the State, but also against the restoration of private
capitalism. This restoration was demanded -- in opposition to Kronstadt -- by
the social democrats, who combined it with a regime of political democracy.
And it was Lenin and Trotsky who to a great extent realised it (but without
political democracy) in the form of the NEP. The Kronstadt resolution declared
for the opposite since it declared itself against the employment of wage
labour in agriculture and small industry. This resolution, and the movement
underlying, sought for a revolutionary alliance of the proletarian and peasant
workers with the poorest sections of the country labourers, in order that the
revolution might develop towards socialism. The NEP, on the other hand, was a
union of bureaucrats with the upper layers of the village against the
proletariat; it was the alliance of State capitalism and private capitalism
against socialism. The NEP is as much opposed to the Kronstadt demands as, for
example, the revolutionary socialist programme of the vanguard of the European
workers for the abolition of the Versailles system, is opposed to the
abrogation of the Treaty of Versailles achieved by Hitler."_ [**Op. Cit.**,
pp. 334-5]

Point 11 did, as Ida Mett noted, _"reflected the demands of the peasants to
whom the Kronstadt sailors had remained linked -- as had, as a matter of fact,
the whole of the Russian proletariat . . . In their great majority, the
Russian workers came directly from the peasantry. This must be stressed. The
Baltic sailors of 1921 were, it is true, closely linked with the peasantry.
But neither more nor less than had been the sailors of 1917."_ To ignore the
peasantry in a country in which the vast majority were peasants would have
been insane (as the Bolsheviks proved). Mett stresses this when she argued
that a _"workers and peasants' regime that did not wish to base itself
exclusively on lies and terror, had to take account of the peasantry."_ [**Op.
Cit.**, p. 40]

Given that the Russian industrial working class were also calling for free
trade (and often without the political, anti-capitalist, riders Kronstadt
added) it seems dishonest to claim that the sailors purely expressed the
interests of the peasantry. Perhaps this explains why point 11 becomes
summarised as _"restoration of free trade"_ by Trotskyists. [_"Editorial
Preface"_, Lenin and Trotsky, **Kronstadt**, p. 6] John Rees does not even
mention any of the demands (which is amazing in a work which, in part, tries
to analyse the rebellion).

Similarly, the working class nature of the resolution can be seen from who
agreed to it. The resolution passed by the sailors on the battleships was
ratified by a mass meeting and then a delegate meeting of workers, soldiers
and sailors. In other words, by workers **and** peasants.

J.G. Wright, following his guru Trotsky without question (and using him as the
sole reference for his "facts"), stated that _"the incontestable facts"_ were
the _"sailors composed the bulk of the insurgent forces"_ and _"the garrison
and the civil population remained passive."_ [Lenin and Trotsky, **Op. Cit.**,
p. 123] This, apparently, is evidence of the peasant nature of the revolt. Let
us contest these _"incontestable facts"_ (i.e. assertions by Trotsky).

The first fact we should mention is that the meeting of 1st March in Anchor
Square involved _"some fifteen to sixteen thousand sailors, soldiers and
civilians."_ [Getzler, **Op. Cit.**, p. 215] This represented over 30% of
Kronstadt's total population. This hardly points to a "passive" attitude on
behalf of the civilians and soldiers.

The second fact is that the conference of delegates had a _"membership that
fluctuated between which two and three hundred sailors, soldiers, and working
men."_ This body remained in existence during the whole revolt as the
equivalent of the 1917 soviet and, like that soviet, had delegates from
Kronstadt's _"factories and military units."_ It was, in effect, a _"prototype
of the 'free soviets' for which the insurgents had risen in revolt."_ In
addition, a new Trade Union Council was created, free from Communist
domination. [Avrich, **Op. Cit.**, p. 159 and p. 157] Trotsky expects us to
believe that the soldiers and civilians who elected these delegates were
"passive"? The very act of electing these delegates would have involved
discussion and decision making and so active participation. It is extremely
doubtful that the soldiers and civilians would have so apathetic and
apolitical to not have taken an active part in the revolt.

Thirdly, the declarations by sailors, soldiers and workers printed in
**_Izvestiia_** which expressed their support for the revolt and those which
announced they had left the Communist Party also present evidence which
clearly contests Trotsky's and Wright's _"incontestable facts."_ One
declaration of the _"soldiers of the Red Army from the fort Krasnoarmeietz"_
stated they were _"body and soul with the Revolutionary Committee."_ [quoted
by Voline, **The Unknown Revolution**, p. 500]

Lastly, given that the Red Army troops manned the main bastion and the
outlying forts and gun emplacements at Kronstadt and that the Bolshevik troops
had to take these forts by force, we can safely argue that the Red Army
soldiers did not play a "passive" role during the rebellion. [Paul Avrich,
**Op. Cit.**, p. 54 and pp. 205-6]

This is confirmed by later historians. Based on such facts, Paul Avrich states
that the townspeople _"offered their active support"_ and the Red Army troops
_"soon fell into line."_ [**Op. Cit.**, p. 159] Fedotoff-White notes that the
_"local land forces of the Kronstadt garrison . . . fell in and joined the
seamen."_ [**The Growth of the Red Army**, p. 154] Getzler notes that
elections were held for the Council of Trade Unions on the 7th and 8th of
March and this was a _"Council committee consisting of representatives from
all trade unions."_ He also notes that the Conference of Delegates _"had been
elected by Kronstadt's body politic at their places of work, in army units,
factories, workshops and Soviet institutions."_ He adds that the revolutionary
troikas (the equivalent of the commissions of the Executive Committee of the
Soviet in 1917) were also _"elected by the base organisations."_ Likewise,
_"the secretariats of the trade unions and the newly founded Council of Trade
Unions were both elected by the entire membership of trade unions."_ [**Op.
Cit.**, pp. 238-9 and p. 240]

That is a lot of activity for "passive" people.

In other words, the **_Petropavlovsk_** resolution not only reflected the
demands of proletarians in Petrograd, it gained the support of proletarians in
Kronstadt in the fleet, the army and the civilian workforce. Thus the claim
that the Kronstadt resolution purely reflected the interests of the peasantry
is, yet again, refuted.

As can be seen, the Kronstadters' (like the Petrograd workers) raised economic
and political demands in 1921 just as they had four years earlier when they
overthrew the Tsar. Which, again, refutes the logic of defenders of
Bolshevism. For example, Wright excelled himself when he argued the following:

> _"The supposition that the soldiers and sailors could venture upon an
insurrection under an abstract political slogan of 'free soviets' is absurd in
itself. It is doubly absurd in the view of the fact [!] that the rest of the
Kronstadt garrison consisted of backward and passive people who could not be
used in the civil war. These people could have been moved to an insurrection
only by profound economic needs and interests. These were the needs and
interests of the fathers and brothers of these sailors and soldiers, that is,
of peasants as traders in food products and raw materials. In other words the
mutiny was the expression of the petty bourgeoisie's reaction against the
difficulties and privations imposed by the proletarian revolution. Nobody can
deny this class character of the two camps."_ [Lenin and Trotsky, **Op.
Cit.**, pp. 111-2]

Of course, no worker or peasant could possibly reach beyond a trade union
consciousness by their own efforts, as Lenin so thoughtfully argued in **What
is to be Done?**. Neither could the experience of two revolutions have an
impact on anyone, nor the extensive political agitation and propaganda of
years of struggle. Indeed, the sailors were so backward that they had no
_"profound economic needs and interests"_ of their own but rather fought for
their fathers and brothers interests! Indeed, according to Trotsky they did
not even understand that (_"They themselves did not clearly understand that
what their fathers and brothers needed first of all was free trade."_ [Lenin
and Trotsky, **Op. Cit.**, p. 92])! And these were the sailors the Bolsheviks
desired to man some of the most advanced warships in the world?

Sadly for Wright's assertions history has proven him wrong time and time
again. Working people have constantly raised political demands which were far
in advance of those of the "professional" revolutionaries (a certain German
and the Paris Commune springs to mind, never mind a certain Russian and the
soviets). The fact that the Kronstadt sailors not only _"venture[d] upon an
insurrection under an abstract political slogan of 'free soviets'"_ but
actually **created** one (the conference of delegates) goes unmentioned.
Moreover, as we prove in [section 8](append42.html#app8), the majority of
sailors in 1921 had been there in 1917. This was due to the fact that the
sailors could not be quickly or easily replaced due to the technology required
to operate Kronstadt's defences and battleships.

Given that the _"a smaller proportion of the Kronstadt sailors were of peasant
origin than was the case of the Red Army troops supporting the government,"_
perhaps we will discover Trotskyists arguing that because _"ordinary Red Army
soldiers . . . were reluctant and unreliable fighters against Red Kronstadt,
although driven at gunpoint onto the ice and into battle"_ that also proves
the peasant nature of the revolt? [Sam Farber, **Op. Cit.**, p. 192; Israel
Getzler, **Kronstadt 1917-1921**, p. 243] Given the quality of the previous
arguments presented, it is only a matter of time before this one appears!

Indeed, Trotskyists also note this non-peasant nature of the Kronstadt demands
(as indicated in the [last section](append42.html#app3)). Thus was have John
Rees pathetically noting that _"no other peasant insurrection reproduced the
Kronstadters' demands."_ [Rees, **Op. Cit.**, p. 63] As we have indicated
above, **proletarian** strikes, resolutions and activists all produced demands
similar or identical to the Kronstadt demands. These facts, in themselves,
indicate the truth of Trotskyist assertions on this matter. Rees mentions the
strikes in passing, but fails to indicate that Kronstadt's demands were raised
after a delegation of sailors had returned from visiting Petrograd. Rather
than their _"motivation"_ being _"much closer to that of the peasantry"_ that
to the _"dissatisfaction of the urban working class"_ the facts suggest the
opposite (as can be seen from the demands raised). [Rees, **Op. Cit.**, p. 61]
The motivation for the resolution was a product of the strikes in Petrograd
and it also, naturally enough, included the dissatisfaction of the peasantry
(in point 11). For the Kronstadters, it was a case of the needs of **all** the
toilers and so their resolution reflected the needs and demands of both.

Unfortunately for Rees, another revolt **did** reproduce the Kronstadt demands
and it was by urban workers, **not** peasants. This revolt took place in
Ekaterinoslavl (in the Ukraine) in May, 1921. It started in the railway
workshops and became _"quickly politicised,"_ with the strike committee
raising a _"series of political ultimatums that were very similar in content
to the demands of the Kronstadt rebels."_ Indeed, many of the resolutions put
to the meeting almost completely coincided with the Kronstadt demands. The
strike _"spread to the other workshops"_ and on June 1st the main large
Ekaterinoslavl factories joined the strike. The strike was spread via the use
of trains and telegraph and soon an area up to fifty miles around the town was
affected. The strike was finally ended by the use of the Cheka, using mass
arrests and shootings. Unsurprisingly, the local communists called the revolt
a _little Kronstadt."_ [Jonathan Aves, **Workers Against Lenin**, pp. 171-3]

Therefore to claim that Kronstadt solely reflected the plight or interests of
the peasantry is nonsense. Nor were the **economic** demands of Kronstadt
alarming to the Bolshevik authories. After all, Zinovioev was about to grant
the removal of the roadblock detachments (point 8) and the government was
drafting what was to become known as the New Economic Policy (NEP) which would
satisfy point 11 partially (the NEP, unlike the Kronstadters, did not end wage
labour and so, ironically, represented the interests of the Kulaks!). It was
the **political** demands which were the problem. They represented a clear
challenge to Bolshevik power and their claims at being the _"soviet power."_

## 5 What lies did the Bolsheviks spread about Kronstadt?

From the start, the Bolsheviks lied about the uprising. Indeed, Kronstadt
provides a classic example of how Lenin and Trotsky used slander against their
political opponents. Both attempted to paint the revolt as being organised and
lead by the Whites. At every stage in the rebellion, they stressed that it had
been organised and run by White guard elements. As Paul Avrich notes, _"every
effort was made to discredit the rebels"_ and that the _"chief object of
Bolshevik propaganda was to show that the revolt was not a spontaneous
outbreak of mass protest but a new counterrevolutionary conspiracy, following
the pattern established during the Civil War. According to the Soviet press,
the sailors, influenced by Mensheviks and SR's in their ranks, had shamelessly
cast their lot with the 'White Guards,' led by a former tsarist general named
Kozlovsky . . . This, in turn, was said to be part of a carefully laid plot
hatched in Paris by Russian emigres in league with French
counterintelligence."_ [**Op. Cit.**, p. 88 and p. 95]

Lenin, for example, argued in a report to the Tenth Congress of the Communist
Party on March 8th that _"White Guard generals were very active over there.
There is ample proof of this"_ and that it was _"the work of Social
Revolutionaries and White Guard emigres."_ [Lenin and Trotsky, **Kronstadt**,
p. 44]

The first government statement on the Kronstadt events was entitled _"The
Revolt of Ex-General Kozlovsky and the Warship Petropavlovsk"_ and read, in
part, that the revolt was _"expected by, and undoubtedly prepared by, French
counterintelligence."_ It continues by stating that on the morning of March 2
_"the group around ex-General Kozlovsky . . . had openly appeared on the scene
. . . [he] and three of his officers . . . have openly assumed the role of
insurgents. Under their direction . . . a number of . . . responsible
individuals, have been arrested. . . Behind the SRs again stands a tsarist
general."_ [**Op. Cit.**, pp. 65-6]

Victor Serge, a French anarchist turned Bolshevik, remembered that he was
first told that _"Kronstadt is in the hands of the Whites"_ and that _"[s]mall
posters stuck on the walls in the still empty streets proclaimed that the
counter-revolutionary General Kozlovsky had seized Kronstadt through
conspiracy and treason."_ Later the _"truth seeped through little by little,
past the smokescreen put out by the Press, which was positively berserk with
lies"_ (indeed, he states that the Bolshevik press _"lied systematically"_).
He found out that the Bolshevik's official line was _"an atrocious lie"_ and
that _"the sailors had mutinied, it was a naval revolt led by the Soviet."_
However, the _"worse of it all was that we were paralysed by the official
falsehoods. It had never happened before that our Party should lie to us like
this. 'It's necessary for the benefit of the public,' said some . . . the
strike [in Petrograd] was now practically general"_ (we should note that
Serge, a few pages previously, mentions _"the strenuous calumnies put out by
the Communist Press"_ about Nestor Makhno, _"which went so far as to accuse
him of signing pacts with the Whites at the very moment when he was engaged in
a life-and-death struggle against them"_ which suggests that Kronstadt was
hardly the first time the Party had lied to them). [**Memoirs of a
Revolutionary**, pp. 124-6 and p. 122] (In the interests of honesty, it should
be noted that Serge himself contributed to the Bolshevik lie machine about
Kronstadt. For example, in March 1922 he happily repeated the Soviet regime's
falsifications about the rebels. [**The Serge-Trotsky Papers**, pp. 18-9]).

Even Isaac Deutscher, Trotsky's biographer said that the Bolsheviks
_"denounced the men of Kronstadt as counter-revolutionary mutineers, led by a
White general. The denunciation appears to have been groundless."_ [**The
Prophet Armed**, p. 511]

Thus the claim that the Kronstadt rebellion was the work of Whites and led by
a White/Tzarist General was a lie -- a lie deliberately and consciously
spread. This was concocted to weaken support for the rebellion in Petrograd
and in the Red Army, to ensure that it did not spread. Lenin admitted as much
on the 15th of March when he stated at the Tenth Party Conference that in
Kronstadt _"they did not want the White Guards, and they do not want our power
either."_ [quoted by Avrich, **Op. Cit.**, p. 129]

If you agree with Italian Marxist Antonio Gramsci that _"to tell the truth is
a communist and revolutionary act"_ then its clear that the Bolsheviks in 1921
(and for a long time previously) were not communist or revolutionary (and as
the subsequent Leninist accounts of Kronstadt show, Bolshevism is still
neither). In stark contrast to the Bolsheviks, the Kronstadt paper
**_Izvestiia_** published Bolshevik leaflets, paper articles and radio
broadcasts so that the inhabitants of the island could see exactly what lies
the Bolsheviks were telling about them.

The Trotskyist editors of **Kronstadt** show the same contempt for their
readers as the Bolsheviks showed for the truth. They include an
_"Introduction"_ to their work by Pierre Frank in which he argues that the
Bolsheviks merely _"state that [White] generals, counterrevolutionaries,
sought to manipulate the insurgents"_ and that anarchists _"turn this into a
claim that these generals had launched the rebellion and that 'Lenin, Trotsky
and the whole Party leadership knew quite well that this was no mere
'generals' revolt.'"_ [quoting Ida Mett] This apparently shows how
_"[a]nything having to do with the facts"_ gets treated by such authors. He
states that Mett and others _"merely distort the Bolsheviks' positions."_
[Lenin and Trotsky, **Op. Cit.**, p. 22]

This is argued in the same work that quotes Lenin actually stating on March
8th, 1921, that _"the familiar figures of White Guard generals"_ were _"very
quickly revealed,"_ that _"White generals were very active"_ there, that it
was _"quite clear that it is the work of Social Revolutionaries and White
Guard emigres"_ and that Kronstadt was _"bound up initially"_ with _"the White
Guards."_ Lenin is also quoted, on March 9th, arguing that _"the Paris
newspapers reported the events two weeks before they actually occurred, and a
White general appeared on the scene. That is what actually happened."_ [**Op.
Cit.**, pp. 44-5 and p. 48] This is stated in spite of presenting the
government statement we have quoted above in which the Bolshevik government
clearly argued that two Communist leaders had been arrested under Kozlovsky's
_"direction"_ and he _"stands"_ behind the right-SRs whose agitation had
started the revolt (according to the Bolsheviks).

Nor can it be said that Ida Mett claims that the Lenin and Trotsky had said a
general had _"launched"_ the revolt. She quotes Moscow radio as stating that
the revolt (_"Just like other White Guard insurrections"_) was in fact _"the
mutiny of ex-General Kozlovsky and the crew of the battle ship
'Petropavlovsk'"_ had been organised by Entene spies, while Socialist
Revolutionaries had _"prepared"_ the ground and that their real master was a
_"Tsarist general"_ on the page **before** that quoted by Frank, so indicating
who the Bolsheviks did claim had launched the revolt. [Mett, **Op. Cit.**, p.
43] It seems strange that Frank complains that others _"distort"_ the
Bolsheviks position when, firstly, the person he quotes does not and,
secondly, he distorts that persons' actual position.

Mett simply acknowledging the Bolshevik lies spewed out at the time. Then she
said that _"Lenin, Trotsky and the whole Party leadership knew quite well that
this was no mere 'generals' revolt."_ [**Op. Cit.**, p. 43] She **then** turns
to General Kozlovsky whom the Bolsheviks indicated by name as the leader of
the revolt and had outlawed in the statement of March 2nd quoted above. Who
was he and what part did he play? Mett sums up the evidence:

> _"He was an artillery general, and had been one of the first to defect to
the Bolsheviks. He seemed devoid of any capacity as a leader. At the time of
the insurrection he happened to be in command of the artillery at Kronstadt.
The communist commander of the fortress had defected. Kozlovsky, according to
the rules prevailing in the fortress, had to replace him. He, in fact,
refused, claiming that as the fortress was now under the jurisdiction of the
Provisional Revolutionary Committee, the old rules no longer applied.
Kozlovsky remained, it is true, in Kronstadt, but only as an artillery
specialist. Moreover, after the fall of Kronstadt, in certain interviews
granted to the Finnish press, Kozlovsky accused the sailors of having wasted
precious time on issues other than the defence of the fortress. He explained
this in terms of their reluctance to resort to bloodshed. Later, other
officers of the garrison were also to accuse the sailors of military
incompetence, and of complete lack of confidence in their technical advisers.
Kozlovsky was the only general to have been present at Kronstadt. This was
enough for the Government to make use of his name. _

>

> _"The men of Kronstadt did, up to a point, make use of the military know how
of certain officers in the fortress at the time. Some of these officers may
have given the men advice out of sheer hostility to the Bolsheviks. But in
their attack on Kronstadt, the Government forces were also making use of ex
Tsarist officers. On the one side there were Kozlovsky, Salomianov, and
Arkannihov; On the other, ex-Tsarist officers and specialists of the old
regime, such as Toukhatchevsky. Kamenev, and Avrov. On neither side were these
officers an independent force."_ [**Op. Cit.**, p. 44]

Not that this is good enough for Trotskyists. Wright, for example, will have
none of it. He quotes Alexander Berkman's statement that there was _"a former
general, Kozlovsky, in Kronstadt. It was Trotsky who had placed him there as
an Artillery specialist. He played no role whatever in the Kronstadt events."_
[**The Russian Tragedy**, p. 69]

Wright protests that this is not true and, as evidence, quotes from an
interview by Kozlovsky and states that _"[f]rom the lips of the
counterrevolutionary general himself . . . we get the unambiguous declaration
that **from the very first day**, he and his colleagues had openly associated
themselves with the mutiny, had elaborated the 'best' plans to capture
Petrograd . . . If the plan failed it was only because Kozlovsky and his
colleagues were unable to convince the 'political leaders', i.e. his SR allies
[!], that the moment was propitious for exposing their true visage and
program."_ [Lenin and Trotsky, **Kronstadt**, p. 119]

In other words, because the Provisional Revolutionary Committee **failed** to
take the advice of the military specialists it proves that, in fact, they were
in league! That is very impressive. We wonder if the Kronstadters **had**
taken their advice then this would have proved that they were not, in fact, in
league with them after all? Similarly, by failing to take over the command of
the fortress Kozlovsky **must** have shown how he was leading the revolt as
the Bolshevik radio said!

Every non-Leninist account agrees that Kozlovsky played no part in the revolt.
Paul Avrich notes that when trouble erupted _"the Bolsheviks at once denounced
him as the evil genius of the movement,"_ _"outlawed"_ him and seized his
family as hostages. He confirms that the military specialists _"threw
themselves into the task of planning military operations on behalf of the
insurrection"_ and that Kozlovsky had refused to succeed as the commander of
the fortress after the old one had fled to the mainland (as demanded by
military rules). He stresses that _"the officers remained in a purely advisory
capacity throughout the rebellion. They had no share, as far as one can tell,
in initiating or directing the revolt, or in framing its political program,
which was alien to their way of thinking."_ Their role _"was confined to
providing technical advice, just as it had been under the Bolsheviks."_ The
Provisional Revolutionary Committee _"showed its distrust of the specialists
by repeatedly rejecting their counsel, however sound and appropriate it might
be."_ And, of course, we should mention that _"[f]or all the government's
accusations that Kronstadt was a conspiracy of White Guard generals, ex-
tsarist officers played a much more prominent role in the attacking force than
among the defenders."_ [**Op. Cit.**, p. 99, p. 100, p. 101 and p. 203]

Indeed, Kozlovsky _"had served the Bolsheviks so loyally that on 20 October
1920 the chief commander of the Baltic Fleet . . . had awarded him a watch
'for courage and feat of arms in the battle against Yudenich'"_ [I. Getzler,
**Kronstadt 1917-1921**, p. 219] This was simply officially confirming the
award made on the 3rd of December, 1919, by the Petrograd Soviet _"for
military feats and energetic activities during the attack of the Yudenich
bands on Petrograd."_ Indeed, he was one of the first generals who entered
into service of the Bolsheviks and the Kronstadt soviet had elected him Chief-
of-Staff of the fortress in the wake of the February revolution. All this did
not stop the Bolsheviks claiming on March 3rd, 1921, that Kozlovsky was a
_"supporter of Yudenich and Kolchak"_! [quoted by Israel Getzler, _"The
Communist Leaders' Role in the Kronstadt Tragedy of 1921 in the Light of
Recently Published Archival Documents"_, **Revolutionary Russia**, pp. 24-44,
Vol. 15, No. 1, June 2002, p. 43 and p. 31]

Berkman was clearly correct. Kozlovsky took no role in the revolt. What he did
do was offer his expertise to the Kronstadt rebels (just as he had to the
Bolsheviks) and make plans which were rejected. If associating yourself with
an event and making plans which are rejected by those involved equals a role
in that event then Trotsky's role in the Spanish revolution equalled that of
Durruti's!

Finally, it should be noted that Victor Serge reported that it _"was probably
[the leading Bolshevik] Kalinin who, on his return to Petrograd [from
attending the initial rebel meetings at Kronstadt], invented 'the White
General Kozlovsky.'"_ [**Memoirs of a Revolutionary**, p. 127] The ironic
thing is, if the Kronstadt rebels **had** been following Kozlovsky and the
other Bolshevik appointed "military specialists" then the defences of
Kronstadt would have been strengthened considerably. However, as Kozlovsky
later explained, the sailors refused to co-operate because of their congenital
mistrust of officers. [Paul Avrich, **Op. Cit.**, pp. 138-9]

It is hard to find a Leninist who subscribes to this particular Bolshevik lie
about Kronstadt. It has, for the main, been long abandoned by those who follow
those who created it, despite the fact it was the cornerstone of the official
Bolshevik account of the rebellion. As the obvious falseness of the claims
became more and more well-known, Trotsky and his followers turned to other
arguments to slander the uprising. The most famous is the assertion that the
_"Kronstadt sailors were quite a different group from the revolutionary heroes
of 1917."_ [Wright, **Op. Cit.**, p. 129] We turn to this question in the
[section 8](append42.html#app8) and indicate that research as refuted it (and
how Trotskyists have misused this research to present a drastically false
picture of the facts). However, first we must discuss whether the Kronstadt
revolt was, in fact, a White conspiracy (the [next
section](append42.html#app6)) and its real relationship to the Whites
([section 7](append42.html#app7)).

## 6 Was the Kronstadt revolt a White plot?

At the time, the Bosheviks portrayed the Kronstadt revolt as a White plot,
organised by the counter-revolution (see [last section](append42.html#app5)
for full details). In particular, they portrayed the revolt as a conspiracy,
directed by foreign spies and executed by their SR and White Guardist allies.

For example, Lenin argued on March 8th that _"White Guard generals were very
active"_ at Kronstadt. _"There is ample proof of this. Two weeks before the
Kronstadt events, the Paris newspapers reported a mutiny at Kronstadt. It is
quite clear that it is the work of Social Revolutionaries and White Guard
emigres."_ [Lenin and Trotsky, **Kronstadt**, p. 44]

Trotsky, on March 16th, made the same point, arguing that _"in a number of
foreign newspapers . . . news of an uprising in Kronstadt appeared as far back
as the middle of February . . . How [to] explain this? Very simply . . . The
Russian counterrevolutionary organisers promised to stage a mutiny at a
propitious moment, while the impatient yellow and financial press write about
it as an already accomplished fact."_ [**Op. Cit.**, p. 68]

This appears to be the greatest "evidence" for Lenin and Trotsky as regards
the White-Guardist nature of the revolt. Indeed, Trotsky on the _"basis of the
dispatch . . . sent a warning to Petrograd to my naval colleagues."_
[**Ibid.**]

However, to see the truth of these claims it is simply a case of looking at
how the Bolsheviks reacted to this announcement of an uprising in Kronstadt.
They did nothing. As the Trotskyist editors of a book justifying the
repression note, the _"Red Army command was caught unprepared by the
rebellion."_ [**Op. Cit.**, p. 6] J.G. Wright, in his defence of Trotsky's
position (a defence recommended by Trotsky himself), acknowledged that the
_"Red Army command"_ was _"[c]aught off guard by the mutiny."_ [**Op. Cit.**,
p. 123] This clearly shows how little weight the newspaper reports were held
**before** the rebellion. Of course, **during** and **after** the rebellion
was a different matter and they quickly became a focal point for Bolshevik
smears.

Moreover, as proof of a White plot, this evidence is pathetic. As Ida Mett
argued out, the _"publication of false news about Russia was nothing
exceptional. Such news was published before, during and after the Kronstadt
events. . . To base an accusation on a 'proof' of this kind is inadmissible
and immoral."_ [Mett, **The Kronstadt Uprising**, p. 76]

Even Trotsky admitted that _"the imperialist press . . . prints . . . a great
number of fictitious reports about Russia"_ but maintained that the reports on
Kronstadt were examples of _"forecasts"_ of _"attempts at overturns in
specific centres of Soviet Russia"_ (indeed, the _"journalistic agents of
imperialism only 'forecast' that which is entrusted for execution to other
agents of this very imperialism."_). Lenin also noted, in an article entitled
_"The Campaign of Lies"_, that _"the West European press [had] indulged in
such an orgy of lies or engaged in the mass production of fantastic inventions
about Soviet Russia in the last two weeks"_ and listed some of them (such as
_"Petrograd and Moscow are in the hands of the insurgents"_). [Lenin and
Trotsky, **Kronstadt**, p. 69, p. 50 and p. 51]

Yet this same press can be used as evidence for a White conspiracy in
Kronstadt? Unsurprisingly, as Mett notes, _"[i]n 1938 Trotsky himself was to
drop this accusation."_ [Mett, **Op. Cit.**, p. 76] Little wonder, given its
pathetic nature -- although this does not stop his loyal follower John G.
Wright from asserting these reports are the _"irrefutable facts"_ of the
_"connection between the counterrevolution and Kronstadt."_ [Lenin and
Trotsky, **Op. Cit.**, p. 115] The question of **why** the
counterrevolutionary plotters would given their enemies advance notice of
their plans never crossed his mind.

As can be seen, at the time **no** evidence was forthcoming that the Whites
organised or took part in the revolt. As Ida Mett argues:

> _"If, at the time the Bolshevik Government had proofs of these alleged
contacts between Kronstadt and the counter-revolutionaries why did it not try
the rebels publicly? Why did it not show the working masses of Russia the
'real' reasons for the uprising? If this wasn't done it was because no such
proofs existed."_ [Mett, **Op. Cit.**, p. 77]

Unsurprisingly, the first soviet investigation into the revolt came to the
conclusion that it was spontaneous. Iakov Agranov, a special plenipotentiary
of the Secret-Operation Department of the **Vecheka** (and later to become its
head), was sent the presidium of that body to Kronstadt soon after the
crushing of the uprising. His mandate was _"to ascertain the role of various
parties and groups in the start and development of the uprising and the ties
of its organisers and inspirers with counter-revolutionary parties and
organisations operating both in and outside Soviet Russia."_ He produced a
report on the 5th of April, 1921, which expressed his considered opinion that
the _"uprising was entirely spontaneous in origin and drew into its maelstrom
almost the entire population and the garrison of the fortress. . . the
investigation failed to show the outbreak of the mutiny was preceded by the
activity of any counter-revolutionary organisation at work among the
fortress's command or that it was the work of the **entente.** The entire
course of the movement speaks against that possibility. Had the mutiny been
the work of some secret organisation which predated its outbreak, then that
organisation would not have planned it for a time when the reserves of fuel
and provisions were hardly sufficient for two weeks and when the thawing of
the ice was still far off."_ He notes that the _"masses"_ in Kronstadt _"were
fully aware of the spontaneity of their movement."_ [quoted by Israel Getzler,
_"The Communist Leaders' Role in the Kronstadt Tragedy of 1921 in the Light of
Recently Published Archival Documents"_, **Revolutionary Russia**, pp. 24-44,
Vol. 15, No. 1, June 2002, p. 25]

Agranov's conclusion was also that of Aleksei Nikolaev's, who, as chairman of
the Extraordinary **Troika** of the First and Second Special Section, was
given the double assignment of _"the punishment of the mutineers and the
unmasking of all the organisations that prepared and led the mutiny."_ He
reported on April 20th, 1921, that _"in spite of all efforts we have been
unable to discover the presence of any organisation and to seize any agents."_
[quoted by Getzler, **Op. Cit.**, p. 26] Ironically enough, a prominent SR
leader and head of the SR Administrative Centre in Finland wrote a letter on
the 18th of March that stated the revolt was _"absolutely spontaneous,"_ that
the _"movement began spontaneously, without any organisation and quite
unexpectedly. After all, a month later, Kronstadt would have been inaccessible
to the Bolsheviks and a hundred times more dangerous to them."_ [quoted by
Getzler, **Op. Cit.**, pp. 25-6]

This did not stop the Bolsheviks reiterating the official line that the revolt
was a White plot, with SR help (nor has it stopped their latter-day supporters
repeating these lies since). For example, Bukharin was still pedalling the
official lies in July 1921, stating that, as regards Kronstadt, the
_"documents which have since been brought to light show clearly that the
affair was instigated by purely White Guard centres."_ [contained in **In
Defence of the Russian Revolution**, Al Richardson (ed.), p. 192] It is
redundant to note that said "documents" were not "brought to light" then or
since.

It should be noted here that the Bolsheviks were quite willing to invent
"evidence" of a conspiracy. Trotsky, for example, raised, on the 24th of March
1921, the possibility of a _"Political Trial of Kronstadters and
Makhnovites."_ This show trial would be part of the _"struggle"_ against
_"anarchism (Kronstadt and Makhno)."_ This was _"presently an important task"_
and so it _"seems . . . appropriate to organise trials of Kronstadters . . .
and of Makhnovites."_ The _"effect of the reports and the speeches of the
prosecutor etcetera would be far more powerful than the effects of brochures
and leaflets about . . . anarchism."_ [quoted by Getzler, **Op. Cit.**, pp.
39] While Trotsky's show trial was never staged, the fact that the idea was
taken seriously can be seen from the invented summaries of the testimonies of
three men considered by the Bolsheviks as ringleaders of the revolt. Perhaps
the fact that the three (Kozlovsky, Petrichenko, Putilin) managed to escape to
Finland ensured that Trotsky's idea was never carried out. Stalin, of course,
utilised the _"powerful"_ nature of such trials in the 1930s.

Decades later historian Paul Avrich **did** discover an unsigned hand written
manuscript labelled _"Top Secret"_ and entitled _"Memorandum on the Question
of Organising an Uprising in Kronstadt."_ Trotskyist Pierre Frank considered
it _"so convincing"_ that he _"reproduced it in its entirety"_ to prove a
White Conspiracy existed behind the Kronstadt revolt. Indeed, he considers it
as an _"indisputable"_ revelation and that Lenin and Trotsky _"were not
mistaken in their analysis of Kronstadt."_ [Lenin and Trotsky, **Op. Cit.**,
p. 26 and p. 32]

However, reading the document quickly shows that Kronstadt was not a product
of a White conspiracy but rather that the White _"National Centre"_ aimed to
try and use a spontaneous _"uprising"_ it thought was likely to _"erupt there
in the coming spring"_ for its own ends. The report notes that _"among the
sailors, numerous and unmistakable signs of mass dissatisfaction with the
existing order can be noticed."_ Indeed, the _"Memorandum"_ states that _"one
must not forget that even of the French Command and the Russian anti-Bolshevik
organisations do not take part in the preparation and direction of the
uprising, a revolt in Kronstadt will take place all the same during the coming
spring, but after a brief period of success it will be doomed to failure."_
[quoted by Avrich, **Kronstadt 1921**, p. 235 and p. 240]

As Avrich notes, an _"underlying assumption of the Memorandum is that the
revolt would not occur until after the springtime thaw, when the ice had
melted and Kronstadt was immune from an invasion from the mainland."_
[**Kronstadt 1921**, pp. 106-7] Voline stated the obvious when he argued that
the revolt _"broke out spontaneously"_ for if it _"had been the result of a
plan conceived and prepared in advance, it would certainly not have occurred
at the beginning of March, the least favourable time. A few weeks later, and
Kronstadt, freed of ice, would have become an almost impregnable fortress . .
. The greatest opportunity of Bolshevik government was precisely the
spontaneity of the movement and the absence of any premeditation, of any
calculation, in the action of the sailors."_ [**The Unknown Revolution**, p.
487] As can be seen, the _"Memorandum"_ also recognised this need for the ice
to thaw and it was the basic assumption behind it. In other words, the revolt
**was** spontaneous and actually undercut the assumptions behind the
_"Memorandum."_

Avrich rejects the idea that the _"Memorandum"_ explains the revolt:

> _"Nothing has come to light to show that the Secret Memorandum was ever put
into practice or that any links had existed between the emigres and the
sailors before the revolt. On the contrary, the rising bore the earmarks of
spontaneity . . . there was little in the behaviour of the rebels to suggest
any careful advance preparation. Had there been a prearranged plan, surely the
sailors would have waited a few weeks longer for the ice to melt . . . The
rebels, moreover, allowed Kalinin [a leading Communist] to return to
Petrograd, though he would have made a valuable hostage. Further, no attempt
was made to take the offensive . . . Significant too, is the large number of
Communists who took part in the movement. . . _

>

> _"The Sailors needed no outside encouragement to raise the banner of
insurrection. . . Kronstadt was clearly ripe for a rebellion. What set it off
were not the machinations of emigre conspirators and foreign intelligence
agents but the wave of peasant risings throughout the country and the labour
disturbances in neighbouring Petorgrad. And as the revolt unfolded, it
followed the pattern of earlier outbursts against the central government from
1905 through the Civil War."_ [**Op. Cit.**, pp. 111-2]

He explicitly argues that while the National Centre had _"anticipated"_ the
revolt and _"laid plans to help organise it,"_ they had _"no time to put these
plans into effect."_ The _"eruption occurred too soon, several weeks before
the basic conditions of the plot . . . could be fulfilled."_ It _"is not
true,"_ he stresses, _"that the emigres had engineering the rebellion."_ The
revolt was _"a spontaneous and self-contained movement from beginning to
end."_ [**Op. Cit.**, pp. 126-7]

Moreover, whether the Memorandum played a part in the revolt can be seen from
the reactions of the White _"National Centre"_ to the uprising. Firstly, they
failed to deliver aid to the rebels nor get French aid to them. Secondly,
Professor Grimm, the chief agent of the National Centre in Helsingfors and
General Wrangel's official representative in Finland, stated to a colleague
after the revolt had been crushed that if a new outbreak should occur then
their group must not be caught unawares again. Avrich also notes that the
revolt _"caught the emigres off balance"_ and that _"[n]othing . . . had been
done to implement the Secret Memorandum, and the warnings of the author were
fully borne out."_ [Paul Avrich, **Op. Cit.**, p. 212 and p. 123]

If Kronstadt was a White conspiracy then how could the organisation of the
conspiracy have been caught unawares?

Clearly, the attempts of certain later-day Trotskyists to justify and prove
their heroes slanders against Kronstadt are pathetic. No evidence of a White-
Guardist plot existed until 1970 when Paul Avrich produced his study of the
revolt and the single document in question clearly does not support the claim
that the Whites organised the revolt. Rather, the Whites aimed to use a
sailors "uprising" to further their cause, an "uprising" which they predicted
would occur in the spring (with or without them). The predicted revolt **did**
take place, but earlier than expected and was not a product of a conspiracy.
Indeed, the historian who discovered this document explicitly argues that it
proves nothing and that the revolt was spontaneous in nature.

Therefore, the claim that Kronstadt was a White plot cannot be defended with
anything but assertions. No evidence exists to back up such claims.

## 7 What was the **real** relationship of Kronstadt to the Whites?

As we proved in the [last section](append42.html#app6), the Kronstadt revolt
was not a White conspiracy. It was a popular revolt from below. However, some
Trotskyists still try and smear the revolt by arguing that it was, in fact,
really or "objectively" pro-White. We turn to this question now.

We must first stress that the Kronstadters' rejected every offer of help from
the National Centre and other obviously pro-White group (they did accept help
towards the end of the rebellion from the Russian Red Cross when the food
situation had become critical). Historian Israel Getzler stressed that _"the
Kronstadters were extremely resentful of all gestures of sympathy and promises
of help coming from the White-Guardist emigres."_ He quotes a Red Cross
visitor who stated that Kronstadt _"will admit no White political party, no
politician, with the exception of the Red Cross."_ [Getzler, **Kronstadt
1917-1921**, p. 235]

Avrich notes that the Kronstadter's _"passionately hated"_ the Whites and that
_"both during and afterwards in exile"_ they _"indignantly rejected all
government accusations of collaboration with counterrevolutionary groups
either at home or abroad."_ As the Communists themselves acknowledged, no
outside aid ever reached the insurgents. [Avrich, **Op. Cit.**, p. 187, p. 112
and p. 123]

In other words, there was no relationship between the revolt and the Whites.

Needless to say, the Whites **were** extremely happy that Kronstadt revolted.
There is no denying that. However, it would be weak politics indeed that based
itself on the reactions of reactionaries to evaluate social struggles. If we
did then we would have to conclude that the overthrow of Stalinism in 1989 was
nothing more than a counter-revolution rather than a popular revolt against a
specific form of capitalism (namely state capitalism). Indeed, many orthodox
Trotskyists took this position (and supported the attempted coup organised by
a section of the Stalinist bureaucracy to re-impose its dictatorship).

Indeed, the Kronstadters themselves acknowledged that the Whites were happy to
support their actions (indeed, **any** actions against the Bolsheviks) but
that this joy was for different reasons than theirs:

> _"The . . . Kronstadt sailors and workers have wrested the tiller from the
Communists' hands and have taken over the helm . . . Comrades, keep a close
eye upon the vicinity of the tiller: enemies are even now trying to creep
closer. A single lapse and they will wrest the tiller from you, and the soviet
ship may go down to the triumphant laughter from tsarist lackeys and henchmen
of the bourgeoisie. _

>

> _"Comrades, right now you are rejoicing in the great, peaceful victory over
the Communists' dictatorship. Now, your enemies are celebrating too. _

>

> _"Your grounds for such joy, and theirs, are quite contradictory. _

>

> _"You are driven by a burning desire to restore the authentic power of the
soviets, by a noble hope of seeing the worker engage in free labour and the
peasant enjoy the right to dispose, on his land, of the produce of his
labours. **They** dream of bringing back the tsarist knout and the privileges
of the generals. _

>

> _"Your interests are different. They are not fellow travellers with you. _

>

> _"You needed to get rid of the Communists' power over you in order to set
about creative work and peaceable construction. Whereas they want to overthrow
that power to make the workers and peasants their slaves again. _

>

> _"You are in search of freedom. They want to shackle you as it suits them.
Be vigilant! Don't let the wolves in sheep's clothing get near the tiller."_
[**No Gods, No Masters**, vol. 2, pp. 187-8]

Of course, this is not enough for the followers of Lenin and Trotsky. John
Rees, for example, quotes Paul Avrich to support his assertion that the
Kronstadt revolt was, in fact, pro-White. He argues as follows:

> _"Paul Avrich . . . says there is 'undeniable evidence' that the leadership
of the rebellion came to an agreement with the Whites after they had been
crushed and that 'one cannot rule out the possibility that this was the
continuation of a longstanding relationship.'"_ [**Op. Cit.**, p. 64]

What Rees **fails** to mention is that Avrich **immediately** adds _"[y]et a
careful search has yielded no evidence to support such a belief."_ He even
states that _"[n]othing has come to light to show that . . . any links had
existed between the emigres and the sailors before the revolt."_ [Avrich,
**Op. Cit.**, p. 111] How strange that Rees fails to quote or even mention
Avrich's conclusion to his own speculation! As for the post-revolt links
between the "leadership" of the rebellion and the Whites, Avrich correctly
argues that _"[n]one of this proves that there were any ties between the
[National] Centre and the Revolutionary Committee either before or during the
revolt. It would seem, rather, that the mutual experience of bitterness and
defeat, and a common determination to overthrow the Soviet regime, led them to
join hands in the aftermath."_ [**Op. Cit.**, p. 129] Seeing you friends and
fellow toilers murdered by dictators may affect your judgement, unsurprisingly
enough.

Let us, however, assume that certain elements in the "leadership" of the
revolt were, in fact, scoundrels. What does this mean when evaluating the
Kronstadt revolt?

Firstly, we must point out that this "leadership" was elected by and under the
control of the "conference of delegates," which was in turn elected by and
under the control of the rank-and-file sailors, soldiers and civilians. This
body met regularly during the revolt _"to receive and debate the reports of
the Revolutionary committee and to propose measures and decrees."_ [Getzler,
**Op. Cit.**, p. 217] The actions of the "leadership" were not independent of
the mass of the population and so, regardless of their own agendas, had to
work under control from below. In other words, the revolt cannot be reduced to
a discussion of whether a few of the "leadership" were "bad men" or not.
Indeed, to do so just reflects the elitism of bourgeois history.

And Rees does just that and reduces the Kronstadt revolt and its "ideology"
down to just one person (Petrichenko). Perhaps we can evaluate Bolshevism with
this method? Or Italian Socialism. After all, influential figures in both
these movements ended up making contacts and deals with extremely suspect
organisations and acting in ways we (and the movements they sprang from) would
oppose. Does that mean we gain an insight into their natures by mentioning
Stalin's or Mussolini's later activities? Or evaluating their revolutionary
nature from such individuals? Of course not. Indeed, Rees's article is an
attempt to argue that objective circumstances rather than Bolshevism as such
lead to Stalinism. Rather than do the same for Kronstadt, he prefers to
concentrate on an individual. This indicates a distinctly bourgeois
perspective:

> _"What passes as socialist history is often only a mirror image of bourgeois
historiography, a percolation into the ranks of the working class movement of
typically bourgeois methods of thinking. In the world of this type of
'historian' leaders of genius replace the kings and queens of the bourgeois
world. . . . The masses never appear independently on the historic stage,
making their own history. At best they only 'supply the steam', enabling
others to drive the locomotive, as Stalin so delicately put it . . . This
tendency to identify working class history with the history of its
organisations, institutions and leaders is not only inadequate -- it reflects
a typically bourgeois vision of mankind, divided in almost pre-ordained manner
between **the few** who will manage and decide, and **the many**, the
malleable mass, incapable of acting consciously on its own behalf . . . Most
histories of the degeneration of the Russian Revolution rarely amount to more
than this."_ [_"Solidarity's Preface"_ to Ida Mett's **The Kronstadt
Uprising**, pp. 18-9]

Secondly, the question is one of whether workers are in struggle and what they
aim for and definitely **not** one of whether some of the "leaders" are fine
upstanding citizens. Ironically, Trotsky indicates why. In 1934, he had argued
_"[a]nyone who had proposed that we not support the British miners' strike of
1926 or the recent large-scale strikes in the United States with all available
means on the ground that the leaders of the strikes were for the most part
scoundrels, would have been a traitor to the British and American workers."_
[_"No Compromise on the Russian Question"_, **Writings of Leon Trotsky:
Supplement (1934-40)**, p. 539]

The same applies to Kronstadt. Even if we assume that some of the "leadership"
did have links with the National Centre (an assumption we must stress has no
evidence to support it), this in no way invalidates the Kronstadt revolt. The
movement was not produced by the so-called "leaders" of the revolt but rather
came from below and so reflected the demands and politics of those involved.
If it was proved, as KGB and other soviet sources argued, that some of the
"leaders" of the Hungary uprising of 1956 had CIA links or were CIA agitators,
would that make the revolution and its workers' councils somehow invalid? Of
course not. If some of the "leadershp" were scoundrels, as Trotsky argued,
this does not invalid the revolt itself. The class criteria is the decisive
one.

(As an aside, we must point out that Trotsky was arguing against those
claiming, correctly, that to unconditionally defend the Soviet Union was to
give an endorsement to Stalinism. He stated immediately after the words we
have quoted above: _"Exactly the same thing applies to the USSR!"_ However,
there was a few obvious differences which invalidates his analogy. Firstly,
the Stalinist leadership was exploiting and oppressing the workers by means of
state power. Trade Union bureaucrats, for all their faults, are not mass
murdering butchers at a head of a dictatorship defended by troops and secret
police. Secondly, strikes are examples of proletarian direct action which can,
and do, get out of control of union structures and bureaucrats. They can be
the focal point of creating new forms of working class organisation and power
which can end the power of the union bureaucrats and replace it with self-
managed strikers assemblies and councils. The Stalinist regime was organised
to repress any attempts at unseating them and was not a form of working class
self-defence in even the limited form that trade unions are.)

John Rees continues by arguing that:

> _"As it became clear that the revolt was isolated Petrichenko was forced to
come to terms with the reality of the balance of class forces. On 13 March
Petrichenko wired David Grimm, the chief of the National Centre and General
Wrangel's official representative in Finland, for help in gaining food. On 16
March Petrichenko accepted an offer of help from Baron P V Vilkin, an
associate of Grimm's whom 'the Bolsheviks rightly called a White agent.' None
of the aid reached the garrison before it was crushed, but the tide of events
was pushing the sailors into the arms of the Whites, just as the latter had
always suspected it would."_ [**Op. Cit.**, p. 64]

We should note that it was due to the _"food situation in Kronstadt . . .
growing desperate"_ that Petrichenko contacted Grimm. [Avrich, **Op. Cit.**,
p. 121] If the revolt had spread to Petrograd and the striking workers there,
such requests would have been unnecessary. Rather than isolation being due to
_"the reality of the balance of class forces"_ it was due to the reality of
coercive forces -- the Bolsheviks had successfully repressed the Petrograd
strikes and slandered the Kronstadt revolt (see [section
10](append42.html#app10)). As historian V. Brovkin notes, the _"key here us
that the Communists suppressed the workers uprising in Petrograd in the first
days of March. The sailors' uprising in Kronstadt, which was an outgrowth of
the uprising in Petrograd, was now cut off from its larger social base and
localised on a small island. From this moment on the Kronstadt sailors were on
the defensive."_ [**Behind the Lines during the Civil War**, pp. 396-7]

So, given that the Bolshevik dictatorship had lied to and repressed the
Petrograd working class, the Kronstadters had few options left as regards aid.
Rees's argument smacks of the "logic" of Right as regards the Spanish Civil
War, the Cuban revolution and the Sandinistas. Isolated, each of these revolts
turned to the Soviet Union for aid thus proving what the Right had always
known from the start, namely their objectively Communist nature and their part
in the International Communist Conspiracy. Few revolutionaries would evaluate
these struggles on such a illogical and narrow basis but Rees wants us to do
so with Kronstadt.

The logic of Rees arguments was used by the Stalinists later. Indeed, he would
have to agree with Stalinists that the fact the Hungarian revolution of 1956
called on Western aid against the Red Army shows that it was objectively
counter-revolutionary and pro-capitalist, just as the Communist Party
bureaucrats had argued. The fact that during that revolt many messages of
support for the rebels also preached bourgeois values would also, according to
Rees's logic, damn that revolt in the eyes of all socialists. Similarly, the
fact that the Polish union **Solidarity** got support from the West against
the Stalinist regime does not mean that its struggle was counter-
revolutionary. So the arguments used by Rees are identical to those used by
Stalinists to support their repression of working class revolt in the Soviet
Empire. Indeed, orthodox Trotskyists also called _"Solidarnosc"_ a company
union of the CIA, bankers, the Vatican and Wall Street for capitalist
counterrevolution in Poland and considered the fall of the Soviet Union as a
defeat for the working class and socialism, in other words, a
counterrevolution. As evidence they pointed to the joy and support each
generated in Western elite circles (and ignored the popular nature of those
revolts).

In reality, of course, the fact that others sought to take advantage of these
(and other) situations is inevitable and irrelevant. The important thing is
whether working class people where in control of the revolt and what the main
objectives of it were. By this class criteria, it is clear that the Kronstadt
revolt was a **revolutionary** revolt as, like Hungry 1956, the core of the
revolt was working people and their councils. It was they who were in control
and called the tune. That Whites tried to take advantage of it is as
irrelevant to evaluating the Kronstadt revolt as the fact that Stalinists
tried to take advantage of the Spanish struggle against Fascism.

Moreover, in his analysis of the _"balance of class forces"_, Rees fails to
mention the class which had real power (and the related privileges) in Russia
at the time -- the state and party bureaucracy. The working class and
peasantry were officially powerless. The only influence they exercised in the
"workers' and peasants state" was when they rebelled, forcing "their" state to
make concessions or to repress them (sometimes both happened). The balance of
class forces was between the workers and peasants and ruling bureaucracy. To
ignore this factor means to misunderstand the problems facing the revolution
and the Kronstadt revolt itself.

Lastly, we must comment upon the fact that members of Kronstadt's
revolutionary Committee took refuge in Finland along with _"[s]ome 8,000
people (some sailors and the most active part of the civilian population)."_
[Mett, **Op. Cit.**, p. 57] This was as the Bolsheviks had predicted on March
5th (_"At the last minute, all those generals, the Kozlovskvs, the Bourksers,
and all that riff raff, the Petrichenkos, and the Tourins will flee to
Finland, to the White guards"_ [cited by Mett, **Op. Cit.**, p. 50]). However,
this does not indicate any "White guardist" connections. After all, where else
**could** they go? Anywhere else would have been in Soviet Russia and so a
Bolshevik prison and ultimately death. The fact that active participants in
the revolt ended up in the only place they could end up to avoid death has no
bearing to that nature of that revolt nor can it be used as "evidence" of a
"white conspiracy."

In other words, the attempts of Trotskyists to smear the Kronstadt sailors
with having White links is simply false. The actions of some rebels **after**
the Bolsheviks had crushed the revolt cannot be used to discredit the revolt
itself. The real relationship of the revolt to the Whites is clear. It was one
of hatred and opposition.



## 8 Did the rebellion involve new sailors?

The most common Trotskyist assertion to justify the repression of the
Kronstadt revolt is that of Trotsky. It basically consists of arguing that the
sailors in 1921 were different than those in 1917. Trotsky started this line
of justification during the revolt when he stated on March 16th that the
Baltic Fleet had been _"inevitably thinned out with respect to personnel"_ and
so a _"great many of the revolutionary sailors"_ of 1917 had been
_"transferred"_ elsewhere. They had been _"replaced in large measure by
accidental elements."_ This _"facilitated"_ the work of the
_"counterrevolutionary organisers"_ who had _"selected"_ Kronstadt. He
repeated this argument in 1937 and 1938 [Lenin and Trotsky, **Kronstadt**, pp.
68-9, p. 79, p. 81 and p. 87]

His followers repeated his assertions. Wright argues that _"the personnel of
the fortress could not possibly have remained static throughout the years
between 1917 and 1921."_ He doubts that the revolutionary sailors of 1917
could have remained behind in the fortress while their comrades fought the
Whites. [**Op. Cit.**, pp. 122-3] These sailors had been replaced by peasant
conscripts. John Rees, continuing this line of rationale, argued that _"the
composition of the garrison had changed . . . it seems likely that the
peasants had increased their weight in the Kronstadt, as Trotsky suggested."_
[Rees, **Op. Cit.**, p. 61]

As can be seen, the allegation that the Kronstadt sailors were a _"grey mass"_
and had changed in social composition is a common one in Trotskyist circles.
What are we to make of these claims?

Firstly, we must evaluate what are the facts as regards the social composition
and turnover of personnel in Kronstadt. Secondly, we must see how Trotskyists
have misused these sources in order to indicate how far they will abuse the
truth.

The first task is now, thanks to recent research, easy to do. Were the
majority of the sailors during the uprising new recruits or veterans from
1917? The answer is that it was predominantly the latter. Academic Israel
Getzler investigated this issue and demonstrated that of those serving in the
Baltic fleet on 1st January 1921 at least 75.5% were drafted before 1918. Over
80% were from Great Russian areas, 10% from the Ukraine and 9% from Finland,
Estonia, Latvia and Poland. He argues that the _"veteran politicised Red
sailor still predominated in Kronstadt at the end of 1920"_ and presents more
_"hard statistical data"_ like that just quoted. He investigated the crews of
the two major battleships, the **_Petropavlovsk_** and the **_Sevastopol_**
(both renown since 1917 for their revolutionary zeal and revolutionary
allegiance and, in Paul Avrich's words, _"the powder kegs of the rising."_
[Avrich, **Op. Cit.**, p. 93]). His findings are conclusive, showing that of
the 2,028 sailors where years of enlistment are known, 93.9% were recruited
into the navy before and during the 1917 revolution (the largest group, 1,195,
joined in the years 1914-16). Only 6.8% of the sailors were recruited in the
years 1918-21 (including three who were conscripted in 1921) and they were the
only ones who had not been there during the 1917 revolution. [Getzler,
**Kronstadt 1917-1921**, pp. 207-8] Historian Fedotoff-White indicates that
the cruiser **Rossiia** had joined in the decision to re-elect the Kronstadt
Soviet and its _"crew consisted mostly of old seamen."_ [**The Growth of the
Red Army**, p. 138]

Moreover, the majority of the revolutionary committee were veterans of the
Kronstadt Soviet and the October revolution. [Ida Mett, **Op. Cit.**, p. 42]
_"Given their maturity and experience, not to speak of their keen
disillusionment as former participants in the revolution, it was only natural
that these seasoned bluejackets should be thrust into the forefront of the
uprising."_ [Avrich, **Op. Cit.**, p. 91]

Getzler stresses that it was _"certainly the case"_ that the _"activists of
the 1921 uprising had been participants of the 1917 revolutions"_ for the
_"1,900 veteran sailors of the **_Petropavlovsk_** and the **_Sevastopol_**
who spearheaded it. It was certainly true of a majority of the Revolutionary
Committee and of the intellectuals . . . Likewise, at least three-quarters of
the 10,000 to 12,000 sailors -- the mainstay of the uprising -- were old hands
who had served in the navy through war and revolution."_ [**Op. Cit.**, p.
226]

Little wonder, then, that Paul Avrich argues (in a review of Getzler's book)
that _"Getzler draws attention to the continuity in institutions, ideology,
and personnel linking 1921 with 1917. In doing so he demolishes the allegation
of Trotsky and other Bolshevik leaders that the majority of veteran Red
sailors had, in the course of the Civil War, been replaced by politically
retarded peasant recruits from the Ukraine and Western borderlands, thereby
diluting the revolutionary character of the Baltic fleet. He shows, on the
contrary, that no significant change had taken place in the fleet's political
and social composition, that at least three-quarters of the sailors on active
duty in 1921 had been drafted before 1918 and were drawn predominantly from
Great Russian areas."_ [**Soviet Studies**, vol. XXXVI, 1984, pp. 139-40]

Other research confirms Getzler's work. Evan Mawdsley argues that _"it seems
reasonable to challenge the previous interpretation"_ that there had been a
_"marked change in the composition of the men in the fleet . . . particularly
. . . at the Kronstadt Naval Base."_ _"The composition of the DOT [Active
Detachment],"_ he concludes, _"had not fundamentally changed, and anarchistic
young peasants did not predominate there. The available data suggests that the
main difficulty was not . . . that the experienced sailors were being
demobilised. Rather, they were not being demobilised rapidly enough."_ The
_"relevant point is length of service, and available information indicates
that as many as three-quarters of the DOT ratings -- the Kronstadt mutineers
-- had served in the fleet at least since the World War."_ In a nutshell,
_"the majority of men seem to have been veterans of 1917."_ He presents data
which shows that of the _"2,028 ratings aboard the DOT battleships
**Petropavlovsk** and **Sevastopol** at the time of the uprising, 20.2% had
begun service before 1914, 59% between 1914 and 1916, 14% in 1917, and 6.8%
from 1918 to 1921."_ For the DOT as a whole on 1st January, 1921, 23.5% could
have been drafted before 1911, 52% from 1911 to 1918 and 24.5% after 1918.
[_"The Baltic Fleet and the Kronstadt Mutiny"_, pp. 506-521, **Soviet
Studies**, vol. 24, no. 4, pp. 508-10]

This is not the end of the matter. Unfortunately for Trotsky recently released
documents from the Soviet Archives also refutes his case. A report by Vasilii
Sevei, Plenipotentiary of the Special Section of the **Vecheka,** dated March
7th, 1921, stated that a _"large majority"_ of the sailors of Baltic Fleet
_"were and still are professional revolutionaries and could well form the
basis for a possible third revolution."_ He notes that the _"disease from
which they suffer has been too long neglected."_ What is significant about
this social-political profile of the _"large majority"_ of sailors was that it
was **not** written in response of the Kronstadt revolt but that it was
formulated well before. As its author put it in the report, _"I stated these
views more than a month ago in my memorandum to comrade Krestinskii"_ (then
secretary of the Communist Party). [quoted by Israel Getzler, _"The Communist
Leaders' Role in the Kronstadt Tragedy of 1921 in the Light of Recently
Published Archival Documents"_, **Revolutionary Russia**, pp. 24-44, Vol. 15,
No. 1, June 2002, pp. 32-3]

In other words, some time in January, 1921, a leading member of the Cheka was
of the opinion that the _"large majority"_ of sailors in the Baltic fleet
_"were and still are professional revolutionaries."_ No mention was made of
new recruits, indeed the opposite is implied as the sailors' _"disease"_ had
been _"too long neglected."_ And the recipient of this March 7th, 1921,
report? Leon Trotsky. Unsurprisingly, Trotsky did not mention this report
during the crisis or any time afterward.

Needless to say, this statistical information was unavailable when anarchists
and others wrote their accounts of the uprising. All they could go on were the
facts of the uprising itself and the demands of the rebels. Based on these, it
is little wonder that anarchists like Alexander Berkman stressed the
continuity between the Red Kronstadters of 1917 and the rebels of 1921.
Firstly, the rebels in 1921 took action in **_solidarity_** with the striking
workers in Petrograd. In the words of Emma Goldman, it was _"after the report
of their Committee of the real state of affairs among the workers in Petrograd
that the Kronstadt sailors did in 1921 what they had done in 1917. They
immediately made common cause with the workers. The part of the sailors in
1917 was hailed as the red pride and glory of the Revolution. Their identical
part in 1921 was denounced to the whole world as counter-revolutionary
treason"_ by the Bolsheviks. [**Trotsky Protests Too Much**] Secondly, their
demands were thoroughly in-line with the aspirations and politics of 1917 and
clearly showed a socialist awareness and analysis. Thirdly, Emma Goldman spoke
to some of those wounded in the attack on Kronstadt. She records how one _"had
realised that he had been duped by the cry of 'counter-revolution.' There were
no Tsarist generals in Kronstadt, no White Guardists -- he found only his own
comrades, sailors and soldiers who had heroically fought for the Revolution."_
[**My Disillusionment in Russia**, pp. 199-200]

The later research has just confirmed what is obvious from an analysis of such
facts, namely that the rebels in 1921 were acting in the spirit of their
comrades of 1917 and this implies a significant continuity in personnel (which
perhaps explains the unwillingness of Leninists to mention that the revolt was
in solidarity with the strikers or the demands of the rebels). Thus the
research provides empirical evidence to support the political analysis of the
revolt conducted by revolutionaries like Berkman, Voline and so on.

In summary, the bulk of the sailors at the start of 1921 had been there since
1917. Even if this was not the case and we assume that a majority of the
sailors at Kronstadt were recent recruits, does this invalidate the rebellion?
After all, the Red sailors of 1917 were once raw recruits. They had become
politicised over time by debate, discussion and struggle. So had the workers
in Petrograd and elsewhere. Would Leninists have denounced strikers in 1905 or
1917 if it was discovered that most of them were recent peasant arrivals in
the city? We doubt it.

Indeed, the Bolsheviks were simply repeating old Menshevik arguments. Between
1910 and 1914, the industrial workforce grew from 1,793,000 workers to
2,400,000. At the same time, the influence of the Bolsheviks grew at Menshevik
expense. The Mensheviks considered this a _"consequence of the changes that
were taking place in the character of urban Russia"_ with peasants joining the
labour force. [_"introduction"_, **The Mensheviks in the Russian Revolution**,
Abraham Archer (Ed.), p. 24] Somewhat ironically, given later Leninist
arguments against Kronstadt, the Mensheviks argued that the Bolsheviks gained
their influence from such worker-peasant industrial _"raw recruits"_ and not
from the genuine working class. [Orlando Figes, **A People's Tragedy**, p.
830] As Robert Service noted in his study of the Bolshevik party during the
1917 revolution, _"Menshevik critics were fond of carping that most Bolshevik
newcomers were young lads fresh from the villages and wanting in long
experience of industrial life and political activity. It was not completely
unknown for Bolshevik spokesmen to come close to admitting this."_ [**The
Bolshevik Party in Revolution**, p. 44] And, of course, it was the industrial
"raw recruits" who had taken part in the 1905 and 1917 revolutions. They
helped formulate demands and organise soviets, strikes and demonstrations.
They helped raised slogans which were to the left of the Bolsheviks. Does this
process somehow grind to a halt when these "raw recruits" oppose Trotsky? Of
course not.

Given the political aspects of the Kronstadt demands we can safely argue that
even if the rebellion had been the work of recent recruits they obviously had
been influenced by the veteran sailors who remained. They, like the peasant-
workers of 1905 and 1917, would have been able to raise their own political
demands and ideas while, at the same time, listening to those among them with
more political experience. In other words, the assumption that the sailors
could not raise revolutionary political demands if they were "raw recruits"
only makes sense if we subscribe to Lenin's dictum that the working class, by
its own efforts, can only reach a trade union consciousness (i.e. that toiling
people cannot liberate themselves). In other words, this Trotsky inspired
sociology misses the point. Sadly, we have to address it in order to refute
Leninist arguments.

Therefore, Getzler's research refutes the claims of Trotskyists such as Chris
Harman who follow Trotsky and argue that _"Kronstadt in 1921 was not Kronstadt
of 1917. The class composition of its sailors had changed. The best socialist
elements had long ago gone off to fight in the army in the front line. They
were replaced in the main by peasants whose devotion to the revolution was
that of their class."_ [quoted by Sam Farber, **Before Stalinism**, p. 192] As
can be seen, the ship crews were remarkably consistent over the period in
question. It is, however, useful to discuss this question further in order to
show what passes as analysis in Trotskyist circles.

Harman is, of course, following Trotsky. Writing in 1937 Trotsky argued that
Kronstadt had _"been completely emptied of proletarian elements"_ as _"[a]ll
the sailors"_ belonging to the ships' crews _"had become commissars,
commanders, chairmen of local soviets."_ Later, realising the stupidity of
this claim, he changed it to Kronstadt being _"denuded of all revolutionary
forces"_ by _"the winter of 1919."_ He also acknowledged that _"a certain
number of qualified workers and technicians"_ remained to _"take care of the
machinery"_ but these were _"politically unreliable"_ as proven by the fact
they had not been selected to fight in the civil war. As evidence, he mentions
that he had wired a _"request at the end of 1919, or in 1920, to 'send a group
of Kronstadt sailors to this or that point'"_ and they had answered _"No one
left to send."_ [Lenin and Trotsky, **Kronstadt**, p. 87, p. 90 and p. 81]
Obviously, the Communist commander at Kronstadt had left his fortress and its
ships totally unmanned! Such common sense is sadly lacking from Trotsky (as
indicated above, the evidence supports the common sense analysis and not
Trotsky's claims).

Moreover, does this claim also apply to the Communist Party membership at
Kronstadt? Is Trotsky **really** arguing that the Bolsheviks in Kronstadt
after the winter of 1919 were not revolutionary? Given that the bulk of them
had joined the CP during or after this time, we must obviously conclude that
the recruiters let anyone join. Moreover, there had been a _"rigorous local
purge"_ of the party conducted in the autumn of 1920 by the commander of the
Baltic Fleet. [I. Getzler, **Kronstadt 1917-1921**, p. 211 and p. 205] Must we
also conclude that this purge did not have revolutionary politics as a factor
when determining whether a party member should be expelled or not?

Trotsky claims too much. Based on his claims we must conclude one of two
possibilities. The first possibility is that the Kronstadt Communist Party was
not revolutionary and was made up of politically backward individuals,
careerists and so on. If that was the case in Kronstadt then it must also have
been the case elsewhere in Russia and this discredits any attempt to argue
that the Bolshevik party dictatorship was revolutionary. The second
possibility is that it **did** have revolutionary elements. If so, then the
fact that hundreds of these members left the party during the revolt and only
a minority of them opposed it makes the claim that the rebellion was _
"counter-revolutionary"_ difficult (indeed, impossible) to maintain (of the
2,900 members of the Communist Party in Kronstadt, 784 officially resigned and
327 had been arrested). And it also makes Trotsky's claims that Kronstadt was
_"denuded"_ of revolutionary elements false.

J.G. Wright, as noted above, thought that it was _"impossible"_ to believe
that the sailors of 1917 could leave their comrades to fight the Whites while
they stayed at Kronstadt. This may have been a valid argument **if** the
Soviet armed forces were democratically run. However, as we indicated in
[section 2](append42.html#app2), it was organised in a typically bourgeois
fashion. Trotsky had abolished democratic soldiers and sailors councils and
the election of officers in favour of appointed officers and hierarchical,
top-down, military structures. This meant that the sailors would have stayed
in Kronstadt if they had been ordered to. The fact that they had to defend
Petrograd combined with the level of technical knowledge and experience
required to operate the battleships and defences at Kronstadt would have meant
that the 1917 sailors would have been irreplaceable and so had to remain at
Kronstadt. This is what, in fact, did happen. In the words of Israel Gelzter:

> _"One reason for the remarkable survival in Kronstadt of these veteran
sailors, albeit in greatly diminished numbers, was precisely the difficulty of
training, in war-time conditions, a new generation competent in the
sophisticated technical skills required of Russia's ultra-modern battleships,
and, indeed, in the fleet generally."_ [**Op. Cit.**, p. 208]

We should also note here that _"by the end of 1919 thousands of veteran
sailors, who had served on many fronts of the civil war and in the
administrative network of the expanding Soviet state, had returned to the
Baltic Fleet and to Kronstadt, most by way of remobilisation."_ [Getzler,
**Op. Cit.**, pp. 197-8] Thus the idea that the sailors left and did not come
back is not a valid one.

Trotsky obviously felt that this (recently refuted) argument of changing
social composition of the sailors would hold more water than claims White
Guards organised it. He continued this theme:

> _"The best, most self-sacrificing sailors were completely withdrawn from
Kronstadt and played an important role at the fronts and in the local soviets
throughout the country What was left was the grey mass with big pretensions
('We are from Kronstadt'), but without the political education and unprepared
for revolutionary sacrifice. The country was starving. The Kronstadters
demanded privileges. The uprising was dictated by a desire to get privileged
food rations."_ [Lenin and Trotsky, **Kronstadt**, p. 79]

This was Trotsky's first comment on the uprising for 16 years and it contained
a lie. As Ida Mett notes, _"[s]uch a demand was never put forward by the men
of Kronstadt"_ and so Trotsky _"started his public accusations with a lie."_
[**The Kronstadt Uprising**, p. 73] He repeated the claim again, six months
later [Lenin and Trotsky, **Op. Cit.**, p. 92] Unfortunately for him, the
opposite was the case. Point 9 of the Kronstadt demands explicitly called for
an **end** of privileges by the _"equalisation of rations for all workers."_
This was implemented during the uprising.

As an aside, Trotsky later states that _"[w]hen conditions became very
critical in hungry Petrograd, the Political Bureau more than once discussed
the possibility of securing an 'internal loan' from Kronstadt, where a
quantity of old provisions still remained. But delegates of the Petrograd
workers answered: 'You will get nothing from them by kindness. They speculate
in cloth, coal, and bread. At present in Kronstadt every kind of riffraff has
raised its head.'"_ [Lenin and Trotsky, **Op. Cit.**, pp. 87-8] As Ida Mett
pointed out, _"[w]e should add that before the insurrection these 'stores'
were in the hands of communist functionaries and that it was upon these people
alone that consent to the proposed 'loan' depended. The rank and file sailor,
who took part in the insurrection, had no means open to him whereby he could
have opposed the loan, even if he had wanted to."_ [**The Kronstadt
Uprising**, pp. 74-5] If Trotsky's words were true, then they were a crushing
indictment of Bolshevik practice, **not** the Kronstadt sailors.

As for Trotsky's claim of a _"lack of political education,"_ the 15 point
resolution voted upon by the sailors exposes this as nonsense and the fact the
sailors fought the Red Army to the end indicates that there were prepared to
die for their ideals. Similarly, Trotsky's argument that _"in 1917-18, the
Kronstadt sailor stood considerably higher than the average level of the Red
Army"_ but by 1921 they _"stood . . . on a level considerably lower, in
general, than the average level of the Red Army."_ In fact, as we indicate in
[section 9](append42.html#app9), the political programme of the revolt was
fundamentally the same as Kronstadt's soviet democracy of 1917 and, we should
note, opposed the introduction of wage labour, a basic socialist idea (and one
missing from the Bolshevik's NEP policies). Moreover, the mass meeting that
agreed the resolution did so unanimously, meaning old and new sailors agreed
to it. So much for Trotsky's assertions.

Others have pointed out the weak nature of Trotsky's arguments as regards the
changing nature of the sailors. We will quote Emma Goldman's evaluation of
Trotsky's assertions. As will be seen, Trotsky's assertions seem to be based
on expediency (and, significantly, were not uttered before the revolt):

> _"Now, I do not presume to argue what the Kronstadt sailors were in 1918 or
1919. I did not reach Russia until January, 1920. From that time on until
Kronstadt was 'liquidated' the sailors of the Baltic fleet were held up as the
glorious example of valour and unflinching courage. Time on end I was told not
only by Anarchists, Mensheviks and social revolutionists, but by many
Communists, that the sailors were the very backbone of the Revolution. On the
1st of May, 1920, during the celebration and the other festivities organised
for the first British Labour Mission, the Kronstadt sailors presented a large
clear-cut contingent, and were then pointed out as among the great heroes who
had saved the Revolution from Kerensky, and Petrograd from Yudenich. During
the anniversary of October the sailors were again in the front ranks, and
their re-enactment of the taking of the Winter Palace was wildly acclaimed by
a packed mass. _

>

> _"Is it possible that the leading members of the party, save Leon Trotsky,
were unaware of the corruption and the demoralisation of Kronstadt, claimed by
him? I do not think so. Moreover, I doubt whether Trotsky himself held this
view of the Kronstadt sailors until March, 1921. His story must, therefore, be
an afterthought, or is it a rationalisation to justify the senseless
'liquidation' of Kronstadt?"_ [**Trotsky Protests Too Much**]

Ante Ciliga quoted the testimony regarding Kronstadt of a fellow political
prisoner in Soviet Russia:

> _"'It is a myth that, from the social point of view, Kronstadt of 1921 had a
wholly different population from that of 1917,' [a] man from Petrograd, Dv.,
said to me in prison. In 1921 he was a member of the Communist youth, and was
imprisoned in 1932 as a 'decist' (a member of Sapronov's group of 'Democratic
Centralists')."_ [**Op. Cit.**, pp. 335-6]

Since then, both Paul Avrich and Israel Gelzter have analysed this question
and confirmed the arguments and accounts of Goldman and Ciliga. Moreover,
continuity between the sailors of 1917 and 1921 can also been seen from their
actions (rising in solidarity with the Petrograd workers) and in their
politics (as expressed in their demands and in their paper).

Now we turn to our second reason for looking into this issue, namely the
misuse of these sources to support their case. This indicates well the nature
of Bolshevik ethics. _"While the revolutionaries,"_ argued Ciliga with regards
to the Bolsheviks, _"remaining such only in words, accomplished in fact the
task of the reaction and counter-revolution, they were compelled, inevitably,
to have recourse to lies, to calumny and falsification."_ [**Op. Cit.**, p.
335] Defending these acts also pays its toll on those who follow this
tradition, as we shall see.

Needless to say, such evidence as provided by Avrich and Getzler is rarely
mentioned by supporters of Bolshevism. However, rather than ignore new
evidence, the Trotskyists use it in their own way, for their own purposes.
Every new work about Kronstadt has been selectively quoted from by Trotskyists
to support their arguments, regardless of the honesty of such activity. We can
point to two works, Paul Avrich's **Kronstadt 1921** and **Kronstadt
1917-1921** by Israel Getzler, which have been used to support Bolshevist
conclusions when, in fact, they do the opposite. The misuse of these
references is quite unbelievable and shows the mentality of Trotskyism well.

Pierre Frank argues that Paul Avrich's work has _"conclusions"_ which are
_"similar to Trotsky's"_ and _"confirms the changes in the composition of the
Kronstadt garrison that took place during the civil war, although with a few
reservations."_ [Lenin and Trotsky, **Op. Cit.**, p. 25] A quick look at these
reservations shows how false Frank is. It is worth quoting Avrich at length to
show this:

> _"There can be little doubt that during the Civil War years a large turnover
had indeed taken place within the Baltic Fleet, and that many of the old-
timers had been replaced by conscripts from rural districts who brought with
them the deeply felt discontent of the Russian peasantry. By 1921, according
to official figures, more than three-quarters of the sailors were of peasant
origin, a substantially higher proportion that in 1917 . . . Yet this does not
necessarily mean that the behavioural patterns of the fleet had undergone any
fundamental change. On the contrary, alongside the technical ratings, who were
largely drawn from the working class, there had always been a large and unruly
peasant element among the sailors . . . Indeed, in 1905 and 1917 it was these
very youths from the countryside who had given Kronstadt its reputation as a
hotbed of revolutionary extremism. And throughout the Civil War the
Kronstadters had remained an independent and headstrong lot, difficult to
control and far from constant in their support for the government. It was for
this reason so many of them . . . had found themselves transferred to new
posts remote from the centres of Bolshevik powers. Of those who remained, many
hankered for the freedoms they had won in 1917 before the new regime began to
establish its one-party dictatorship throughout the country. _

>

> _"Actually, there was little to distinguish the old-timers from the recent
recruits in their midst. Both groups were largely of peasant background . . .
Not unexpectedly, when the rebellion finally erupted, it was the older seamen,
veterans of many years of service (dating in some cases before the First World
War) who took the lead . . . Given their maturity and experience, not to speak
of their keen disillusionment as former participants of the revolution, it was
only natural that these seasoned bluejackets should be thrust into the
forefront of the uprising . . . The proximity of Petrograd, moreover, with its
intense intellectual and political life, had contributed towards sharpening
their political awareness, and a good many had engaged in revolutionary
activity during 1917 and after. . . _

>

> _"As late as the autumn of 1920, Emma Goldman recalled, the sailors were
still held up by the Communists themselves as a glowing example of valour and
unflinching courage; on November 7, the third anniversary of the Bolshevik
seizure of power, they were in the front ranks of the celebrations . . . No
one at the time spoke of any 'class degeneration' at Kronstadt. The allegation
that politically retarded **muzhiks** had diluted the revolutionary character
of the fleet, it would seem, was largely a device to explain away dissident
movements among the sailors, and had been used as such as early as October
1918, following the abortive mutiny at the Petrograd naval station, when the
social composition of the fleet could not yet have undergone any sweeping
transformation."_ [**Kronstadt 1921**, pp. 89-92]

As can be seen, Avrich's _"reservations"_ are such as to make clear he does
**not** share Trotsky's _"conclusions"_ as regards the class make-up of
Kronstadt and, indeed, noted the ideological bias in this "explanation."

Moreover, Avrich points to earlier revolts which the Bolsheviks had also
explained in terms of a diluting of the revolutionary sailors of the Baltic
Fleet by peasants. In April 1918 _"the crews of several Baltic vessels passed
a strongly worded resolution"_ which _"went so far as to call for a general
uprising to dislodge the Bolsheviks and install a new regime that would adhere
more faithfully to the principles of the revolution."_ In October that year,
_"a mass meeting at the Petrograd naval base adopted a resolution"_ which
included the sailors going _"on record against the Bolshevik monopoly of
political power. Condemning the suppression of the anarchists and opposition
socialists, they called for free elections to the soviets . . . [and]
denounced the compulsory seizure of gain."_ Their demands, as Avrich notes,
_"strikingly anticipated the Kronstadt programme of 1921, down to the slogans
of 'free soviets' and 'Away with the commissarocracy.'"_ He stresses that a
_"glance at the behaviour of the Baltic Fleet from 1905 to 1921 reveals many
elements of continuity."_ [Avrich, **Op. Cit.**, pp. 63-4]

However, a worse example of Trotskyist betrayal of the truth is provided by
the British SWP's John Rees. The evidence Rees musters for the claim that the
_"composition"_ of the Kronstadt sailors _"had changed"_ between 1917 and 1921
is a useful indication of the general Leninist method when it comes to the
Russian revolution. Rees argues as follows:

> _"In September and October 1920 the writer and the Bolshevik party lecturer
Ieronymus Yasinksky went to Kronstadt to lecture 400 naval recruits. They were
'straight from the plough'. And he was shocked to find that many, 'including a
few party members, were politically illiterate, worlds removed from the highly
politicised veteran Kronstadt sailors who had deeply impressed him'. Yasinsky
worried that those steeled in the revolutionary fire' would be replaced by
'inexperienced freshly mobilised young sailors'."_ [**Op. Cit.**, p. 61]

This quote is referenced to Israel Getzler's **Kronstadt 1917-1921**. Rees
account is a fair version of the first half of Yasinskys' report. The quote
however continues exactly as reproduced below:

> _"Yasinsky was apprehensive about the future when, 'sooner or later,
Kronstadt's veteran sailors, who were steeled in revolutionary fire and had
acquired a clear revolutionary world-view would be replaced by inexperienced,
freshly mobilised young sailors'. Still he comforted himself with the hope
that Kronstadt's sailors would gradually infuse them with their 'noble spirit
of revolutionary self-dedication' to which Soviet Russia owed so much. As for
the present he felt reassured that 'in Kronstadt the red sailor still
predominates.'"_ [Getzler, **Op. Cit.**, p. 207]

Rees handy 'editing' of this quote transforms it from one showing that three
months before the rising that Kronstadt had retained its revolutionary spirit
to one implying the garrison had indeed been replaced.

Rees tries to generate _"[f]urther evidence of the changing class
composition"_ by looking at the _"social background of the Bolsheviks at the
base."_ However, he goes on to contradict himself about the composition of the
Bolshevik party at the time. On page 61 he says the _"same figures for the
Bolshevik party as a whole in 1921 are 28.7% peasants, 41% workers and 30.8%
white collar and others"_. On page 66 however he says the figures at the end
of the civil war (also 1921) were 10% factory workers, 25% army and 60% in
_"the government or party machine"_. An endnote says even of those classed as
factory workers _"most were in administration."_ [**Op. Cit.**, p. 61 and p.
78] The first set of figures is more useful for attacking Kronstadt and so is
used.

What is the basis of Rees _"further evidence"_? Simply that in _"September
1920, six months before the revolt, the Bolsheviks had 4,435 members at
Kronstadt. Some 50 per cent of these were peasants, 40 percent workers and 10
percent intellectuals . . . Thus the percentage of peasants in the party was
considerably higher than nationally . . . If we **assume** [our emphasis] that
the Bolshevik party was more working class in composition than the base as a
whole, then it seems **likely** [our emphasis] that the peasants had increased
their weight in the Kronstadt, as Trotsky suggested."_ [**Op. Cit.**, p. 61]

So on the basis of an assumption, it may be _"likely"_ that Trotsky was
correct! Impressive _"evidence"_ indeed!

The figures Rees uses are extracted from D. Fedotoff-White's **The Growth of
the Red Army**. Significantly, Rees fails to mention that the Kronstadt
communists had just undergone a _"re-registration"_ which saw about a quarter
of the 4,435 members in August 1920 voluntarily resigning. By March 1921, the
party had half as many members as in the previous August and during the
rebellion 497 members (again, about one-quarter of the total membership)
voluntarily resigned, 211 were excluded after the defeat of the rebellion and
137 did not report for re-registration. [Fedotoff-White, **The Growth of the
Red Army**, p. 140] It seems strange that the party leadership had not taken
the opportunity to purge the Kronstadt party of "excessive" peasant influence
in August 1920 when it had the chance.

Other questions arise from Rees' argument. He uses the figures of Communist
Party membership in an attempt to prove that the class composition of
Kronstadt had changed, favouring the peasantry over the workers. Yet this is
illogical. Kronstadt was primarily a military base and so its "class
composition" would be skewed accordingly. Since the Bolshevik military machine
was made up mostly of peasants, can we be surprised that the Communist Party
in Kronstadt had a higher percentage of peasants than the national average?
Significantly, Rees does not ponder the fact that the percentage of workers in
the Kronstadt Communist Party was around the national average (indeed,
Fedotoff-White notes that it _"compares favourably in that respect with some
of the large industrial centres."_ [**Op. Cit.**, p. 142]).

Also, given that Rees acknowledges that by December 1920 only 1,313 new
recruits had arrived in the Baltic Fleet, his pondering of the composition of
the Communist organisation at Kronstadt smacks more of desperation than
serious analysis. By arguing that we _"do not know how many more new recruits
arrived in the three months before Kronstadt erupted,"_ Rees fails to see that
this shows the irrelevance of his statistical analysis. [**Op. Cit.**, p. 61]
After all, how many of these _"new recruits"_ would been allowed to join the
Communist Party in the first place? Given that the Bolshevik membership had
halved between August 1920 and March 1921, his analysis is simply pointless, a
smokescreen to draw attention away from the weakness of his own case.

Moreover, as evidence of **changing** class composition these figures are not
very useful. This is because they do not compare the composition of the
Kronstadt Bolsheviks in 1917 to those in 1921. Given that the Kronstadt base
always had a high percentage of peasants in its ranks, it follows that in 1917
the percentage of Bolsheviks of peasant origin could have been higher than
normal as well. If this was the case, then Rees argument falls. Simply put, he
is not comparing the appropriate figures.

It would have been very easy for Rees to inform his readers of the real facts
concerning the changing composition of the Kronstadt garrison. He could quoted
Getzler's work on this subject. As noted above, Getzler demonstrates that the
crew of the battleships _**Petropavlovsk**_ and _**Sevastopol**_, which formed
the core of the rising, were recruited into the navy before 1917, only 6.9%
having been recruited between 1918 and 1921. These figures are on the same
page as the earlier quotes Rees uses but are ignored by him. Unbelievably Rees
even states _"[w]e do not know how many new recruits arrived in the three
months before Kronstadt erupted"_ in spite of quoting a source which indicates
the composition of the two battleships which started the revolt! [**Op.
Cit.**, p. 61]

Or, then again, he could have reported Samuel Farber's summary of Getzler's
(and others) evidence. Rees rather lamely notes that Farber _"does not look at
the figures for the composition of the Bolsheviks"_ [**Op. Cit.**, p. 62] Why
should he when he has the appropriate figures for the sailors? Here is
Farber's account of the facts:

> _"this [Trotsky's class composition] interpretation has failed to meet the
historical test of the growing and relatively recent scholarship on the
Russian Revolution. . . . In fact, in 1921, a smaller proportion of Kronstadt
sailors were of peasant social origin than was the case of the Red Army troops
supporting the government . . . recently published data strongly suggest that
the class composition of the ships and naval base had probably remained
unchanged since before the Civil War. We now know that, given the war-time
difficulties of training new people in the technical skills required in
Russia's ultra-modern battleships, very few replacements had been sent to
Kronstadt to take the place of the dead and injured sailors. Thus, at the end
of the Civil War in late 1920, no less than 93.9 per cent of the members of
the crews of the **_Petropavlovsk_** and the **_Sevastopol_** . . . were
recruited into the navy before and during the 1917 revolutions. In fact, 59
per cent of these crews joined the navy in the years 1914-16, while only 6.8
per cent had been recruited in the years 1918-21 . . . of the approximately
10,000 recruits who were supposed to be trained to replenish the Kronstadt
garrison, only a few more than 1,000 had arrived by the end of 1920, and those
had been stationed not in Kronstadt, but in Petrograd, where they were
supposed to be trained."_ '[**Before Stalinism**, pp. 192-3]

And Rees bemoans Farber for not looking at the Bolshevik membership figures!
Yes, assumptions and _"likely"_ conclusions drawn from assumptions are more
important than hard statistical evidence!

After stating _"if, for the sake of argument, we accept Sam Farber's
interpretation of the evidence"_ (evidence Rees refuses to inform the reader
of) Rees then tries to save his case. He states Farber's _"point only has any
validity if we take the statistics in isolation. But in reality this change
[!] in composition acted on a fleet whose ties with the peasantry had recently
been strengthened in other ways. In particular, the Kronstadt sailors had
recently been granted leave for the first time since the civil war. Many
returned to their villages and came face to face with the condition of the
countryside and the trials of the peasantry faced with food detachments."_
[**Op. Cit.**, p. 62]

Of course, such an argument has **nothing to do with Rees original case.** Let
us not forget that he argued that the class composition of the garrison had
changed, **not** that its **political** composition had changed. Faced with
overwhelming evidence against his case, he not only does not inform his
readers of it, he changes his original argument! Very impressive.

So, what of this argument? Hardly an impressive one. Let us not forget that
the revolt came about in response to the wave of strikes in Petrograd, **not**
a peasant revolt. Moreover, the demands of the revolt predominantly reflected
workers demands, **not** peasant ones (Rees himself acknowledges that the
Kronstadt demands were not reproduced by any other "peasant" insurrection).
The political aspects of these ideas reflected the political traditions of
Kronstadt, which were not, in the main, Bolshevik. The sailors supported
soviet power in 1917, not party power, and they again raised that demand in
1921 (see [section 9](append42.html#app9) for details). In other words, the
**political** composition of the garrison was the same as in 1917. Rees is
clearly clutching at straws.

The fact that the class composition of the sailors was similar in 1917 and in
1921 **and** that the bulk of the sailors at the heart of the revolt were
veterans of 1917, means that Trotskyists can only fall back on their
ideological definition of class. This perspective involves defining a specific
"proletarian" political position (i.e. the politics of Bolshevism) and arguing
that anyone who does not subscribe to that position is "petty-bourgeois"
regardless of their actual position in society (i.e. their class position). As
Ida Mett notes:

> _"When Trotsky asserts that all those supporting the government were
genuinely proletarian and progressive, whereas all others represented the
peasant counterrevolution, we have a right to ask of him that he present us
with a serious factual analysis in support of his contention."_ [**Op. Cit.**,
pp. 75-6]

As we show in the [next section](append42.html#app9), the political
composition of the Kronstadt rebels, like their class composition, was
basically unchanged in 1921 when compared to that which pre-dominated in 1917.



## 9 Was Kronstadt different politically?

As we proved in the [last section](append42.html#app8), the Kronstadt garrison
had not fundamentally changed by 1921. On the two battleships which were the
catalyst for the rebellion, over 90% of the sailors for whom years of
enlistment are know had been there since 1917. However, given that most
Leninists mean "support the party" by the term "class politics," it is useful
to compare the political perspectives of Kronstadt in 1917 to that expressed
in the 1921 revolt. As will soon become clear, the political ideas expressed
in 1921 were essentially similar to those in 1917. This similarly also proves
the continuity between the Red sailors of 1917 and the rebels of 1921.

Firstly, we must point out that Kronstadt in 1917 was **never** dominated by
the Bolsheviks. At Kronstadt, the Bolsheviks were always a minority and a
_"radical populist coalition of Maximalists and Left SRs held sway, albeit
precariously, **within** Kronstadt and its Soviet"_ (_"**externally**
Kronstadt was a loyal stronghold of the Bolshevik regime"_). [I. Getzler,
**Kronstadt 1917-1921**, p. 179] In 1917 Trotsky even stated that the
Kronstadters _"are anarchists."_ [quoted by Getzler, **Op. Cit.**, p. 98]
Kronstadt was in favour of soviet power and, unsurprisingly, supported those
parties which claimed to support that goal.

Politically, the climate in Kronstadt was _"very close to the politics of the
Socialist Revolutionary Maximalists, a left-wing split-off from the SR Party,
politically located somewhere between the Left SRs and the Anarchists."_
[Farber, **Before Stalinism**, p. 194] In Kronstadt this group was led by
Anatolii Lamanov and according to Getzler, _"it rejected party factionalism"_
and _"stood for pure sovietism"_. They sought an immediate agrarian and urban
social revolution, calling for the _"socialisation of power, of the land and
of the factories"_ to be organised by a federation of soviets based on direct
elections and instant recall, as a first step towards socialism. [Getzler,
**Op. Cit.**, p. 135] The similarities with anarchism are clear.

During the October revolution, the Bolsheviks did not prevail in the Kronstadt
soviet. Instead, the majority was made up of SR Maximalists and Left SRs.
Kronstadt's delegates to the third Congress of Soviets were an Left-SR (157
votes), a SR-Maximalist (147 votes) and a Bolshevik (109 votes). It was only
in the January elections in 1918 that the Bolsheviks improved their position,
gaining 139 deputies compared to their previous 96. In spite of gaining their
highest ever vote during the era of multi-party soviets the Bolsheviks only
gained 46 percent of seats in the soviet. Also elected at this time were 64
SRs (21 percent), 56 Maximalists (19 percent), 21 non-party delegates (7
percent), 15 Anarchists (5 percent) and 6 Mensheviks (2 percent). The soviet
elected a Left SR as its chairman and in March it elected its three delegates
to the Fourth Congress of Soviets, with the Bolshevik delegate receiving the
lowest vote (behind a Maximalist and an anarchist with 124, 95 and 79 votes
respectively). [I. Getzler, **Op. Cit.**, pp. 182-4]

By the April 1918 elections, as in most of Russia, the Bolsheviks found their
support had decreased. Only 53 Bolsheviks were elected (29 per cent) as
compared to 41 SR Maximalists (22 percent), 39 Left SRs (21 percent), 14
Menshevik Internationalists (8 percent), 10 Anarchists (5 percent) and 24 non-
party delegates (13 percent). Indeed, Bolshevik influence at Kronstadt was so
weak that on April 18th, the Kronstadt soviet denounced the Bolsheviks attack
against the anarchists in Moscow, April 12th by a vote of 81 to 57. The
_"Bolshevisation"_ of Kronstadt _"and the destruction of its multi-party
democracy was not due to internal developments and local Bolshevik strength,
but decreed from outside and imposed by force."_ [Getzler, **Op. Cit.**, p.
186]

Thus the dominant political perspective in 1917 was one of _"sovietism"_ \--
namely, all power to the soviets and not to parties. This was the main demand
of the 1921 uprising. Politically, Kronstadt had not changed.

In addition to the soviet, there was the _"general meetings in Anchor square,
which were held nearly every day."_ [Avrich, **Op. Cit.**, p. 57] The
Kronstadt Soviet was itself constantly pressurised by mass meetings, generally
held in Anchor Square. For example, on 25 May 1917, a large crowd, inspired by
Bolshevik and anarchist speakers, marched to the Naval Assembly and forced the
leaders of the Soviet to rescind their agreement with the more moderate
Petrograd Soviet. In February 1921, the Kronstadt rebels met in Anchor square
to pass the **_Petropavlovsk_** resolution -- just as happened before in 1917.
And as in 1917, they elected a _"conference of delegates"_ to manage the
affairs of the Kronstadt. In other words, the sailors re-introduced exactly
the same political forms they practised in 1917.

These facts suggest that any claims that the majority of sailors, soldiers and
workers in Kronstadt had changed ideas politically are unfounded. This,
ironically enough, is confirmed by Trotsky.

Trotsky's memory (which, after all, seems to be the basis of most of his and
his followers arguments) does play tricks on him. He states that there _"were
no Mensheviks at all in Kronstadt."_ As for the anarchists, _"most"_ of them
_"represented the city petty bourgeoisie and stood at a lower level than the
SRs."_ The Left SRs _"based themselves on the peasant part of the fleet and of
the shore garrison."_ All in all, _"in the days of the October insurrection
the Bolsheviks constituted less than one-half of the Kronstadt soviet. The
majority consisted of SRs and anarchists."_ [Lenin and Trotsky, **Kronstadt**,
p. 86]

So we have Trotsky arguing that the majority of the _"pride and glory"_ of the
revolution in 1917 voted for groups of a _"lower level"_ than the Bolsheviks
(and for a party, the Mensheviks, Trotsky said did not exist there!).

Looking at the politics of these groups, we discover some strange
inconsistencies which undermine the validity of Trotsky's claims.

For example, in the beginning of 1918, _"the working population of Kronstadt,
after debating the subject at many meetings, decided to proceed to socialise
dwelling places. . . A final monster meeting definitely instructed several
members of the Soviet -- Left Social-Revolutionaries and Anarcho-Syndicalists
-- to raise the question at the next [soviet] plenary session."_ While the
Bolshevik delegates tried to postpone the decision (arguing in the soviet that
the decision was too important and should be decided by the central
government) the _"Left Social-Revolutionaries, Maximalists and Anarcho-
Syndicalists asked for an immediate discussion and carried the vote."_
[Voline, **The Unknown Revolution**, pp. 460-1]

This fits in exactly with the communist-anarchist programme of socialisation
but it is hardly an expression of representatives of _"the city petty
bourgeoisie."_

Let us quote a _"representative"_ of the _"city petty bourgeoisie"_:

> _"I am an anarchist because contemporary society is divided into two
opposing classes: the impoverished and dispossessed workers and peasants . . .
and the rich men, kings and presidents . . . _

>

> _"I am an anarchist because I scorn and detest all authority, since all
authority is founded on injustice, exploitation and compulsion over the human
personality. Authority dehumanises the individual and makes him a slave. _

>

> _"I am an opponent of private property when it is held by individual
capitalist parasites, for private property is theft. . . _

>

> _"I am an anarchist because I believe only in the creative powers and
independence of a united proletariat and not of the leaders of political
parties of various kinds. _

>

> _"I am an anarchist because I believe that the present struggle between the
classes will end only when the toiling masses, organised as a class, gain
their true interests and conquer, by means of a violent social revolution, all
the riches of the earth . . . having abolished all institutions of government
and authority, the oppressed class must proclaim a society of free producers .
. . The popular masses themselves will conduct their affairs on equal and
communal lines in free communities."_ [N. Petrov, cited by Paul Avrich,
**Anarchists in the Russian Revolution**, pp. 35-6]

Very "petty bourgeois"! Of course Trotsky could argue that this represented
the minority of _"real revolutionaries,"_ the _"elements most closely linked
to the Bolsheviks"_ among the anarchists, but such an analysis cannot be taken
seriously considering the influence of the anarchists in Kronstadt. [Lenin and
Trotsky, **Op. Cit.**, p. 86] For example, a member of the Petrograd Committee
and the Helsingfors party organisation in 1917 recalled that the Anarchist-
Communists had great influence in Kronstadt. Moreover, according to historian
Alexander Rabinowitch, they had an _"undeniable capacity to influence the
course of events"_ and he speaks of _"the influential Anarcho-Syndicalist
Communists [of Kronstadt] under Iarchuk."_ Indeed, anarchists _"played a
significant role in starting the July uprising"_ in 1917. [**Prelude to
Revolution**, p. 62, p. 63, p. 187 and p. 138] This confirms Paul Avrich's
comments that the _"influence of the anarchists . . . had always been strong
within the fleet"_ and _"the spirit of anarchism"_ had been _"powerful in
Kronstadt in 1917"_ (and _"had by no means dissipated"_ in 1921). [Arvich,
**Op. Cit.**, p. 168 and p. 169]

A similar analysis of the Maximalists would produce the same results for
Trotsky's claims. Paul Avrich provides a useful summary of their politics. He
notes the Maximalists occupied _"a place in the revolutionary spectrum between
the Left SR's and the anarchists while sharing elements of both."_ They
_"preached a doctrine of total revolution"_ and called for a _"'toilers'
soviet republic' founded on freely elected soviets, with a minimum of central
state authority. Politically, this was identical with the objective of the
Kronstadters [in 1921], and 'Power to the soviets but not the parties' had
originally been a Maximalist rallying-cry."_ [**Op. Cit.**, p. 171]

Economically, the parallels _"are no less striking."_ They denounced grain
requisitioning and demanded that _"all the land be turned over to the
peasants."_ For industry they rejected the Bolshevik theory and practice of
_"workers' control"_ over bourgeois administrators in favour of the _"social
organisation of production and its systematic direction by representatives of
the toiling people."_ Opposed to nationalisation and centralised state
management in favour of socialisation and workers' self-management of
production. Little wonder he states that the _"political group closest to the
rebels in temperament and outlook were the SR Maximalists."_ [Paul Avrich,
**Op. Cit.**, pp. 171-2]

Indeed, _"[o]n nearly every important point the Kronstadt program, as set
forth in the rebel **_Izvestiia_**, coincided with that of the Maximalists."_
[Avrich, **Op. Cit.**, p. 171] This can be quickly seen from reading both the
**_Petropavlovsk_** resolution and the Kronstadt newspaper **_Izvestiia_**
(see **No Gods, No Masters**, vol. 2, pp. 183-204). The political continuity
is striking between 1917 and 1921.

As can be seen, the Maximalists were in advance of the Bolsheviks too. They
argued for soviet power, not party power, as well as workers' self-management
to replace the state capitalism of the Bolsheviks.

Clearly, the political outlook of the Kronstadt rebels had not changed
dramatically. Heavily influenced by anarchist and semi-anarchists in 1917, in
1921 the same political ideas came to the fore again once the sailors,
soldiers and civilians had freed themselves from Bolshevik dictatorship and
created the _"conference of delegates."_

According to the logic of Trotsky's argument, the Kronstadt sailors were
revolutionary simply because of the actions of the Bolshevik minority, as a
_"revolution is 'made' directly by a **minority.** The success of a revolution
is possible, however, only where this minority finds more or less support . .
. on the part of the majority. The shift in different stages of the revolution
. . . is directly determined by changing political relations between the
minority and the majority, between the vanguard and the class."_ It is this
reason that necessitates _"the dictatorship of the proletariat"_ as the level
of the masses cannot be _"equal"_ and of _"extremely high development."_
Trotsky argued that the _"political composition of the Kronstadt Soviet
reflected the composition of the garrison and the crews."_ [Lenin and Trotsky,
**Op. Cit.**, p. 85, p. 92 and p. 86]

In other words, with the vanguard (the minority of Bolsheviks) gone, the
majority of the Kronstadters fell back to their less developed ways. So, if
the political composition of the revolt reflected the composition of the
crews, then Trotsky's argument suggests that this composition was remarkably
unchanged! It also suggests that this _"composition"_ had changed in the early
months of 1918 as the Bolsheviks saw their vote nearly half between late
January and April 1918!

Similarly, we find John Rees, in contradiction to his main argument,
mentioning that the _"ideology of the Kronstadt garrison was one factor"_ in
the revolt because _"in its heroic days the garrison had an ultra-left air."_
[Rees, **Op. Cit.**, p. 62] If, as he maintains, the sailors **were** new, how
could they had time to be influenced by this ideology, the ideology of sailors
he claims were not there? And if the new recruits he claims were there **had**
been influenced by the sailors of 1917 then it is hard to maintain that the
revolt was alien to the spirit of 1917.

This can also be seen from Rees' comment that while we did not know the
composition of the sailors, we did _"know about the composition of some of the
other units based at Kronstadt, like the 2,5000 Ukrainians of the 160th Rifle
Regiment, recruited from areas particularly friendly to the Makhno guerrillas
and with less than 2 percent of Bolsheviks in its ranks."_ [**Op. Cit.**, p.
61] In other words, we know the origin of **one** other unit at Kronstadt, not
the class _"composition"_ of _"some of the other units"_ there. However, Rees
does not see how this fact undermines his argument. Firstly, Rees does not
think it important to note that Communists numbered less than 2 per cent of
metal-workers in Petrograd and only 4 per cent of 2,200 employed in metal
works in Moscow. [D. Fedotoff-White, **The Growth of the Red Army**, p. 132]
As such the low figure for Communists in the 160th Rifle Regiment does not
tell us much about its class composition. Secondly, as Fedotoff-White (the
source of Rees' information) notes, while _"the soldiers were also disaffected
and had no love of the Communists and the commissars,"_ they were _"unable to
formulate their grievances clearly and delineate the issues at stake . . .
They did not have it in them to formulate a plan of action. All that was done
at Kronstadt was the work of the bluejackets [the sailors], who were the
backbone of the movement."_ [**Op. Cit.**, p. 154]

If, as Rees argues, that "new recruits" explain the uprising, then how can we
explain the differences between the army and navy? We cannot. The difference
can be explained only in terms of what Rees is at pains to deny, namely the
existence and influence of sailors who had been there since 1917. As Fedotoff-
White speculates, _"the younger element among the seamen"_ would _"easily
[fall] under the spell of the . . . older men they served with on board
ships"_ and of the _"large number of old-ex-sea men, employed in the
industrial enterprises of Kronstadt."_ He notes that _"a good many"_ of the
rebels _"had had ample experience in organisational and political work since
1917. A number had long-standing associations with Anarchists and the
Socialist Revolutionaries of the Left."_ Thus the _"survival of the
libertarian pattern of 1917 . . . made it possible for the bluejackets not
only to formulate, but carry out a plan of action, no doubt under a certain
amount of influence of the Anarchists, and those who had left the party in
such great numbers during the September 1920 re-registration."_ [**Op. Cit.**,
p. 155] The political continuity of the Kronstadt rebellion is clear from the
way the revolt developed and who took a leading role in it.

All of which raises an interesting question. If revolutions are made by a
minority who gain the support of the majority, what happens when the majority
reject the vanguard? As we indicate in sections [13](append42.html#app13) and
[15](append42.html#app15), Trotsky was not shy in providing the answer --
party dictatorship. In this he just followed the logic of Lenin's arguments.
In 1905, Lenin argued (and using Engels as an authority) _"the principle,
'only from below' is an **anarchist** principle."_ For Lenin, Marxists must be
in favour of _"From above as well as from below"_ and _"renunciation of
pressure also from above is **anarchism.**"_ According to Lenin, _"[p]ressure
from below is pressure by the citizens on the revolutionary government.
Pressure from above is pressure by the revolutionary government on the
citizens."_ [Marx, Engels and Lenin, **Anarchism and Anarcho-Syndicalism**, p.
192, p. 196 and pp. 189-90]

As Kronstadt shows, _"pressure from above"_ has a slight advantage over
_"pressure from below"_ as it has the full power of the state apparatus to use
against the citizens. In other words, the seeds for Bolshevik dictatorship and
the repression of Kronstadt lie in Trotsky's argument and arguments like it
(see [section 15](append42.html#app15) for further details).

Simply put, the evidence shows that the political ideas dominant in Kronstadt,
like the bulk of the personnel themselves, had not changed (indeed, it is
these politics which visibly show the statistical evidence we present in the
[last section](append42.html#app8)). The revolt of 1921 reflected the politics
and aspirations of those active in 1917. It were these politics which had made
Kronstadt the _"pride and glory"_ of the revolution in 1917 and, four years
later, made it so dangerous to the Bolsheviks.



## 10 Why did the Petrograd workers not support Kronstadt?

For Trotskyists, the inaction of the Petrograd workers during the revolt is a
significant factor in showing its _"backward peasant"_ character. Trotsky, for
example, argued that from _"the class point of view"_ it is _"extremely
important to contrast the behaviour of Kronstadt to that of Petrograd in those
critical days."_ He argues that the _"uprising did not attract the Petrograd
workers. It repelled them. The stratification proceeded along class lines. The
workers immediately felt that the Kronstadt mutineers stood on the opposite
side of the barricades -- and they supported the Soviet power. The political
isolation of Kronstadt was the cause of its internal uncertainty and its
military defeat."_ [Lenin and Trotsky, **Kronstadt**, pp. 90-1]

Firstly, it should be noted that Trotsky's claims in 1937 are at odds with his
opinion during the crisis. In a cable dated March 5th, 1921, to a member of
the Council of Labour and Defence Trotsky insisted that _"only the seizure of
Kronstadt will put an end to the political crisis in Petrograd."_ [quoted by
Israel Getzler, _"The Communist Leaders' Role in the Kronstadt Tragedy of 1921
in the Light of Recently Published Archival Documents"_, **Revolutionary
Russia**, pp. 24-44, Vol. 15, No. 1, June 2002, p. 32] Thus, in 1921, Trotsky
was well aware of the links between the Kronstadt revolt and the Petrograd
strikes, seeing the destruction of the former as a means to defeating the
latter. Simply put, the crushing of Kronstadt would give the rebel workers in
Petrograd a clear message of what to expect if they persisted in their
protests.

Secondly, needless to say, Trotsky's later arguments leave a lot to be
desired. For example, he fails to note (to use Victor Serge's words -- see
[section 5](append42.html#app5)) that the state and Communist Press _"was
positively berserk with lies."_ The press and radio campaign directed against
Kronstadt stated that the revolt had been organised by foreign spies and was
led by ex-Tsarist generals.

On 5th March the Petrograd Defence Committee put out a call to the insurgents,
inviting them to surrender. It stated:

> _"You are being told fairy tales when they tell you that Petrograd is with
you or that the Ukraine supports you. These are impertinent lies. The last
sailor in Petrograd abandoned you when he learned that you were led by
generals like Kozlovskv. Siberia and the Ukraine support the Soviet power. Red
Petrograd laughs at the miserable efforts of a handful of White Guards and
Socialist Revolutionaries."_ [cited by Mett, **The Kronstadt Uprising**, p.
50]

These lies would, of course, alienate many workers in Petrograd. Two hundred
emissaries were sent from Kronstadt to distribute their demands but only a few
avoided capture. The Party had brought the full weight of its propaganda
machine to bear, lying about the revolt and those taking part in it. The
government also placed a _"careful watch"_ on the _"trains from Petrograd to
mainland points in the direction of Kronstadt to prevent any contact with the
insurgents."_ [Avrich, **Op. Cit.**, p. 140 and p. 141]

Unsurprising, in such circumstances many workers, soldiers and sailors would
have been loath to support Kronstadt. Isolated from the revolt, the Petrograd
workers had to reply on official propaganda (i.e. lies) and rumours to base
any judgement on what was happening there. However, while this is a factor in
the lack of active support, it is by no means the key one. This factor, of
course, was state repression. Emma Goldman indicates the situation in
Petrograd at the time:

> _"An exceptional state of martial law was imposed throughout the entire
province of Petrograd, and no one except officials with special passes could
leave the city now. The Bolshevik press launched a campaign of calumny and
venom against Kronstadt, announcing that the sailors and soldiers had made
common cause with the 'tsarist General Kozlovsky;' they were thereby declaring
the Kronstadters outlaws."_ [**No Gods, No Masters**, vol. 2, p. 171]

Given what everyone knew what happened to people outlawed by the Bolsheviks,
is it surprising that many workers in Petrograd (even if they knew they were
being lied to) did not act? Moreover, the threat made against Kronstadt could
be seen on the streets of Petrograd:

> _"On March 3 [the day after the revolt] the Petrograd Defence Committee, now
vested with absolute power throughout the entire province, took stern measures
to prevent any further disturbances. The city became a vast garrison, with
troops patrolling in every quarter. Notices posted on the walls reminded the
citizenry that all gatherings would be dispersed and those who resisted shot
on the spot. During the day the streets were nearly deserted, and, with the
curfew now set at 9 p.m., night life ceased altogether."_ [Avrich, **Op.
Cit.**, p. 142]

Berkman, an eyewitness to the repression, states that:

> _"The Petrograd committee of defence, directed by Zinoviev, its chairman,
assumed full control of the city and Province of Petrograd. The whole Northern
District was put under martial law and all meetings prohibited. Extraordinary
precautions were taken to protect the Government institutions and machine guns
were placed in the Astoria, the hotel occupied by Zinoviev and other high
Bolshevik functionaries. The proclamations posted on the street bulletin
boards ordered the immediate return of all strikers to the factories,
prohibited suspension of work, and warned the people against congregating on
the streets. 'In such cases', the order read, 'the soldiery will resort to
arms. In case of resistance, shooting on the spot.' _

>

> _"The committee of defence took up the systematic 'cleaning of the city.'
Numerous workers, soldiers and sailors suspected of sympathising with
Kronstadt, placed under arrest. All Petrograd sailors and several Army
regiments thought to be 'politically untrustworthy' were ordered to distant
points, while the families of Kronstadt sailors living in Petrograd were taken
into custody as **hostages.**"_ [**The Russian Tragedy**, p. 71]

However, part of the Petrograd proletariat continued to strike during the
Kronstadt events. Strikes were continuing in the biggest factories of
Petrograd: Poutilov, Baltisky, Oboukhov, Nievskaia Manoufactura, etc. However,
the Bolsheviks acted quickly shut down some of the factories and started the
re-registration of the workers. For workers to be locked out of a factory
meant to be _"automatically deprived of their rations."_ [Avrich, **Op.
Cit.**, p. 41]

At the "Arsenal" factory, _"the workers organised a mass meeting on 7th March,
(the day the bombardment of Kronstadt began). This meeting adopted a
resolution of the mutinous sailors! It elected a commission which was to go
from factory to factory, agitating for a general strike."_ [Mett, **Op.
Cit.**, p. 52] The Cheka confirms this event, reporting to Zinoviev on March
8th that _"[a]t a rally of workers of the Arsenal Plant a resolution was
passed to join the Kronstadt uprising. The general meeting had elected a
delegation to maintain contact with Kronstadt."_ This delegation had already
been arrested. This was a common practice and during this period the Cheka
concentrated its efforts on the leaders and on disrupting communication: all
delegates to other workplaces, all Mensheviks and SRs who could be found, all
speakers at rallies were being arrested day after day. On the day the
Bolsheviks attacked Kronstadt (March 7th) the Cheka reported that it was
launching _"decisive actions against the workers."_ [quoted by Brovkin,
**Behind the Front Lines of the Civil War**, p. 396]

These _"decisive actions"_ involved a _"massive purge of Petrograd factories
and plants."_ The Communists _"suppressed the workers' uprising in Petrograd
in the first days of March."_ Unlike the Kronstadt sailors, the workers did
not have weapons and _"were essentially defenceless vis-a-vis the Cheka."_
[Brovkin, **Op. Cit.**, p. 396]

The state of siege was finally lifted on the 22nd of March, five days after
the crushing of Kronstadt.

In these circumstances, is it surprising that the Petrograd workers did not
join in the rebellion?

Moreover, the Petrograd workers had just experienced the might of the
Bolshevik state. As we noted in [section 2](append42.html#app2), the events in
Kronstadt were in solidarity with the strike wave in Petrograd at the end of
February. Then the Bolsheviks had repressed the workers with _"arrests, the
use of armed patrols in the streets and in the factories, and the closing and
re-registration of an enterprise labour force."_ [Mary McAuley, **Op. Cit.**,
p. 409]

A three-man Defence Committee was formed and Zinoviev _"proclaimed martial
law"_ on February 24th (this was later _"vested with absolute power throughout
the entire province"_ on March 3rd). [Avrich, **Op. Cit.**, p. 39 and p. 142]
As part of this process, they had to rely on the _**kursanty**_ (Communist
officer cadets) as the local garrisons had been caught up the general ferment
and could not be relied upon to carry out the government's orders. Hundreds of
_**kursanty**_ were called in from neighbouring military academies to patrol
the city. _"Overnight Petrograd became an armed camp. In every quarter
pedestrians were stopped and their documents checked . . . the curfew [was]
strictly enforced."_ The Petrograd Cheka made widespread arrests. [Avrich,
**Op. Cit.**, pp. 46-7]

As can be seen, Trotsky is insulting the intelligence of his readers by
arguing that the lack of support in Petrograd for Kronstadt reflected _"class
lines."_ Indeed, by failing to mention (to use Emma Goldman's words) _"the
campaign of slander, lies and calumny against the sailors"_ conducted by the
Soviet Press (which _"fairly oozed poison against the sailors"_) or that
_"Petrograd was put under martial law"_ Trotsky, quite clearly, _"deliberately
falsifies the facts."_ [**Trotsky Protests Too Much**]

Ida Mett states the obvious:

> _"Here again Trotsky is saying things which are quite untrue. Earlier on we
showed how the wave of strikes had started in Petrograd and how Kronstadt had
followed suit. It was against the strikers of Petrograd that the Government
had to organise a special General Staff: the Committee of Defence. The
repression was first directed against the Petrograd workers and against their
demonstrations, by the despatch of armed detachments of Koursantys. _

>

> _"But the workers of Petrograd had no weapons. They could not defend
themselves as could the Kronstadt sailors. The military repression directed
against Kronstadt certainly intimidated the Petrograd workers. The demarcation
did not take place 'along class lines' but according to the respective
strengths of the organs of repression. The fact that the workers of Petrograd
did not follow those of Kronstadt does not prove that they did not sympathise
with them. Nor, at a later date, when the Russian proletariat failed to follow
the various 'oppositions' did this prove that they were in agreement with
Stalin! In such instances it was a question of the respective strengths of the
forces confronting one another."_ [Mett, **Op. Cit.**, p. 73]

So, unlike the Kronstadt sailors, the Petrograd workers did not have arms and
so could not take part in an "armed revolt" against the well armed Red Army
unless part of that force sided with the strikers. The Communist leaders
recognised this danger, with untrustworthy troops being confined to their
barracks and in place of regular troops they had shipped in _**kursanty**_
(they had obviously learned the lessons of the 1917 February revolution!).
Ultimately, the city was _"appeased by concessions and cowed by the presence
of troops."_ [Avrich, **Op. Cit.**, p. 200]

Not that this was the first time Trotsky confused force with class. In his
infamous work **Terrorism and Communism** he defended the fact of Communist
Party dictatorship (i.e. _"of having substituted for the dictatorship of the
Soviets the dictatorship of our party"_). He argued that _"it can be said with
complete justice that the dictatorship of the Soviets became possible only by
means of the dictatorship of the party"_ and that there is _"no substitution
at all"_ when the _"power of the party"_ replaces that of the working class.
The rule of the party _"has afforded to the Soviets the possibility of
becoming transformed from shapeless parliaments of labour into the apparatus
of the supremacy of labour."_ [**Terrorism and Communism**, p. 109] He
continued by arguing:

> _"But where is your guarantee, certain wise men ask us, that it is just your
party that expresses the interests of historical development? Destroying or
driving underground the other parties, you have thereby prevented their
political competition with you, and consequently you have deprived yourselves
of the possibility of testing your line of action. _

>

> _"This idea is dictated by a purely liberal conception of the course of the
revolution. In a period in which all antagonisms assume an open character, and
the political struggle swiftly passes into a civil war, the ruling party has
sufficient material standard by which to test its line of action, without the
possible circulation of Menshevik papers. Noske crushes the Communists, but
they grow. We have suppressed the Mensheviks and the S.R.s-and they have
disappeared. This criterion is sufficient for us."_ [**Op. Cit.**, pp. 109-10]

An interesting criterion, to say the least. The faulty logic he displayed with
regards to Petrograd and Kronstadt had a long history. By this logic Hitler
expressed the _"interests of historical development"_ when the German
Communists and Trotskyists _"disappeared"_ by leaps and bounds. Similarly, the
Trotskyists in Russia _"disappeared"_ under Stalin. Is this a Trotskyist
justification of Stalinism? All it proves is the power of the repressive
system -- just as the "passivity" of the Petrograd workers during the
Kronstadt revolt indicates the power of the Bolshevik regime rather than the
class basis of the Kronstadt uprising.

On this theme, we can see the depths which Trotskyists go to re-write history
from Pierre Frank's _"Introduction"_ to the work **Kronstadt**. He decides to
quote Paul Avrich's work (after, of course, warning the reader that Avrich
_"is not a Bolshevik or a Trotskyist"_ and his _"political features are
blurred"_). Frank states that Avrich _"done his work conscientiously, without
skipping over the facts."_ It is a shame that the same cannot be said of
Frank! Frank states that Avrich _"discusses the strikes in Petrograd preceding
Kronstadt and comes to the following conclusion"_:

> _"For many intellectuals and workers, moreover, the Bolsheviks, with all
their faults, were still the most effective barrier to a White resurgence and
the downfall of the revolution. _

>

> _"For these reasons, the strikes in Petrograd were fated to lead a brief
existence. Indeed, they ended almost as suddenly as they had begun, never
having reached the point of armed revolt against the regime."_ [Lenin and
Trotsky, **Op. Cit.**, pp. 24-35]

It is the _"moreover"_ in the first paragraph that gives the game away. Avrich
lists a few more reasons than the one listed by Frank. Here is what Avrich
actually lists as the reasons for the end of the strike wave:

> _"after several days of tense excitement, the Petrograd disturbances petered
out . . . The concessions had done their work, for more than anything else it
was cold and hunger which had stimulated popular disaffection. Yet there is no
denying that the application of military force and the widespread arrests, not
to speak of the tireless propaganda waged by the authorities had been
indispensable in restoring order. Particularly impressive in this regard was
the discipline shown by the local party organisation. Setting aside their
internal disputes, the Petrograd Bolsheviks swiftly closed ranks and proceeded
to carry out the unpleasant task of repression with efficiency and dispatch .
. . _

>

> _"Then, too, the collapse of the movement would not have come so soon but
for the utter demoralisation of Petrograd's inhabitants. The workers were
simply too exhausted to keep up any sustained political activity . . . What is
more, they lacked effective leadership and a coherent program of action. In
the past these had been supplied by the radical intelligentsia . . . [but
they] were themselves in no condition to lend the workers any meaningful
support, let alone active guidance . . . they now felt too weary and
terrorised . . . to raise their voices in opposition. With most of their
comrades in prison or exile, and some already executed, few of the survivors
were willing to risk the same fate, especially when the odds against them were
so overwhelming and when the slightest protest might deprive their families of
their rations. For many intellectuals and workers, moreover, the Bolsheviks,
with all their faults, were still the most effective barrier to a White
resurgence and the downfall of the revolution. _

>

> _"For these reasons, the strikes in Petrograd were fated to lead a brief
existence. Indeed, they ended almost as suddenly as they had begun, never
having reached the point of armed revolt against the regime."_ [Paul Avrich,
**Kronstadt**, pp. 49-51]

As can be seen, Frank _"skips over"_ most of Avrich's argument and the basis
of his conclusion. Indeed, what Frank calls Avrich's "conclusion" cannot be
understood by providing, as Frank does, the **last** reason Avrich gives for
it.

The dishonesty is clear, if not unexpected nor an isolated case. John Rees, to
use another example, states that the revolt was _"preceded by a wave of
serious but quickly resolved strikes."_ [Rees, **Op. Cit.**, p. 61] No mention
that the strikes were _"resolved"_ by force nor that the Kronstadt revolt was
not only _"preceded"_ by the strikes but was directly inspired by them, was in
**solidarity with them** and raised many of the same demands!

Similarly, he argues that the Kronstadters' _"insistence that they were
fighting for a 'third revolution', freedom of expression and for 'soviets
without parties' [although, in fact, they **never** raised that slogan and so
we have to wonder who Rees is quoting here] has convinced many historians that
this revolt was fundamentally distinct from the White Rebellions."_ But this,
apparently, is not the case as _"one must be careful to analyse the difference
between the conscious aims of the rebels and the possible outcome of their
actions. The Bolshevik regime still rested on the shattered remnants of the
working class. The Kronstadt sailors' appeals to the Petrograd workers had met
with little or no response."_ [**Op. Cit.**, p. 63]

One has to wonder what planet Rees is on. After all, **if** the Bolsheviks
**had** rested on the _"shattered remnants of the working class"_ then they
would **not** have had to turn Petrograd into an armed camp, repress the
strikes, impose martial law and arrest militant workers. The Kronstadt sailors
appeals _"met with little or no response"_ due to the Bolshevik coercion
exercised in those fateful days. To not mention the Bolshevik repression in
Petrograd is to deliberately deceive the reader. That the Kronstadt demands
would have met with strong response in Petrograd can be seen from the actions
of the Bolsheviks (who did not rest upon the workers but rather arrested
them). Given that the Kronstadt demands simply reflected those raised by the
Petrograd strikers **themselves** we can safely say that Rees is talking
nonsense (see [section 4](append42.html#app4)). Moreover, the sailors'
resolution **had** meet with strong support from the workers of Kronstadt.
Thus Rees' "class analysis" of the Kronstadt revolt is pathetic and has no
bearing to the reality of the situation in Petrograd nor to the history of the
revolt itself.

As can be seen, any attempt to use the relative inaction of the Petrograd
workers as evidence of the class nature of the revolt has to do so by ignoring
all the relevant facts of the situation. This can go so far as to selectively
quote from academic accounts to present a radically false conclusion to that
of the misused author's.



## 11 Were the Whites a threat during the Kronstadt revolt?

The lack of foreign intervention during the Kronstadt revolt suggests more
than just the fact that the revolt was not a "White conspiracy." It also
suggests that the White forces were in no position to take advantage of the
rebellion or even support it.

This is significant simply because the Bolsheviks and their supporters argue
that the revolt had to be repressed simply because the Soviet State was in
danger of White and/or foreign intervention. How much danger was there?
According to John Rees, a substantial amount:

> _"The Whites, even though their armies had been beaten in the field, were
still not finished -- as the emigre response to the Kronstadt rising shows . .
. They had predicted a rising at Kronstadt and the White National Centre
abroad raised a total of nearly 1 million French Francs, 2 million Finnish
marks, £5000, $25,000 and 900 tons of flour in just two weeks; Indeed, the
National Centre was already making plans for the forces of the French navy and
those of General Wrangel, who still commanded 70,000 men in Turkey, to land in
Kronstadt if the revolt were to succeed."_ [**Op. Cit.**, pp. 63-4]

To back up his argument, Rees references Paul Avrich's book. We, in turn, will
consult that work to evaluate his argument.

Firstly, the Kronstadt revolt broke out months after the end of the Civil War
in Western Russia. Wrangel had fled from the Crimea in November 1920. The
Bolsheviks were so afraid of White invasion that by early 1921 they
demobilised half the Red Army (some 2,500,000 men). [Paul Avrich, **Op.
Cit.**, p. 13]

Secondly, the Russian emigres _"remained as divided and ineffectual as before,
with no prospect of co-operation in sight."_ [Avrich, **Op. Cit.**, p. 219]

Thirdly, as far as Wrangel, the last of the White Generals, goes, his forces
were in no state to re-invade Russia. His troops were _"dispersed and their
moral sagging"_ and it would have taken _"months . . . merely to mobilise his
men and transport them from the Mediterranean to the Baltic."_ A second front
in the south _"would have meant almost certain disaster."_ Indeed, in a call
issued by the Petrograd Defence Committee on March 5th, they asked the rebels:
_"Haven't you heard what happened to Wrangel's men, who are dying like flies,
in their thousands of hunger and disease?"_ The call goes on to add _"[t]his
is the fate that awaits you, unless you surrender within 24 hours."_ [Avrich,
**Op. Cit.**, p. 219, p. 146 and p. 105]

Clearly, the prospect of a White invasion was slim. This leaves the question
of capitalist governments. Avrich has this to say on this:

> _"Apart from their own energetic fund-raising campaign, the emigres sought
the assistance of the Entene powers. . . . the United States government, loath
to resume the interventionist policies of the Civil War, turned a deaf ear to
all such appeals. The prospects of British aid were even dimmer . . . The best
hope of foreign support came from France . . . the French refused to interfere
either politically or militarily in the crisis."_ [**Op. Cit.**, pp. 117-9]

The French government had also _"withdrew its recognition of Wrangel's defunct
government"_ in November 1920 _"but continued to feed his troops on 'humane
grounds,' meanwhile urging him to disband."_ [**Op. Cit.**, p. 105]

Thus, the claim that foreign intervention was likely seems without basis.
Indeed, the Communist radio was arguing that _"the organisation of
disturbances in Kronstadt have the sole purpose of influencing the new
American President and changing his policy toward Russia. At the same time the
London Conference is holding its sessions, and the spreading of similar
rumours must influence also the Turkish delegation and make it more submissive
to the demands of the Entente. The rebellion the **_Petropavlovsk_** crew is
undoubtedly part of a great conspiracy to create trouble within Soviet Russia
and to injure our international position."_ [quoted by Berkman, **The Russian
Tragedy**, p. 71] Lenin himself argued on March 16th that _"the enemies"_
around the Bolshevik state were _"no longer able to wage their war of
intervention"_ and so were launching a press campaign _"with the prime object
of disrupting the negotiations for a trade agreement with Britain, and the
forthcoming trade agreement with America."_ [Lenin and Trotsky, **Op. Cit.**,
p. 52] The demobilising of the Red Army seems to confirm this perspective.

Moreover, these governments had to take into account of its own working class.
It was doubtful that they would, after years of war, been able to intervene,
particularly if there was a clearly socialist revolt coming from below. Their
own working class, in such a situation, would have prevented intervention by
foreign capitalist states (a fact Lenin acknowledged in July 1921 [Lenin and
Trotsky, **Op. Cit.**, p. 62]).

So in spite of massive social unrest and the revolt of a key fortress
protecting Petrograd, the Western powers took no action. The Whites were
disorganised and could only raise non-military supplies (none of which reached
Kronstadt). Could this situation have changed if Kronstadt had spread to the
mainland? It is doubtful simply because the Western governments, as Lenin
argued, had to take into account the anti-interventionist position of their
own working classes. The Whites had no military forces available (as the
Bolsheviks themselves argued). Avrich notes it would have taken months for
these forces to reach Kronstadt by which time soviet democracy would have been
consolidated and ready to protect itself.

Even if we assume that Kronstadt had survived until the ice melted while
Petrograd remained under Bolshevik dictatorship it, again, is doubtful that it
would have been the basis for renewed White attacks. Neither Wrangel's troops
nor foreign government forces would have been welcomed by Red Kronstadt. While
non-military aid would have been welcome (i.e. food supplies and so on), it is
hard to believe that the Conference of Delegates would have allowed troops to
arrive or pass them by to attack Petrograd. Simply put, the Kronstadters were
fighting for soviet power and were well aware that others may try to support
the revolt for their own, anti-revolutionary, reasons (see [section
7](append42.html#app7)).

So it seems that the possibility of foreign intervention was not a real threat
at the time. The arguments of Lenin at the time, plus the demobilisation of
the Red Army, points in that direction. Moreover, the total lack of response
by Western governments during the revolt indicates that they were unlikely to
take advantage of continuing unrest in Kronstadt, Petrograd and other towns
and cities. Their working classes, sick of war and class consciousness enough
to resist another intervention in Russia, would have been a factor in this
apathetic response. Wrangel's troops, as the Bolsheviks were aware, were not a
threat.

The only real threat to Bolshevik power was internal -- from the workers and
peasants the Bolsheviks claimed to be representing. Many of the ex-soldiers
swelled the ranks of peasant guerrilla forces, fighting the repressive (and
counter-productive) food collection squads. In the Ukraine, the Bolsheviks
were fighting the remnants of the Makhnovist army (a fight, incidentally,
brought upon the Bolsheviks by themselves as they had betrayed the agreements
made with the anarchist forces and attacked them once Wrangel had been
defeated).

Thus the only potential danger facing the "soviet power" (i.e. Bolshevik
power) was soviet democracy, a danger which had existed since the October
revolution. As in 1918, when the Bolsheviks disbanded and repressed any soviet
electorate which rejected their power, they met the danger of soviet democracy
with violence. The Bolsheviks were convinced that their own dictatorship was
equivalent to the revolution and that their power was identical to that of the
working class. They considered themselves to be the embodiment of "soviet
power" and it obviously did not bother them that the demand for free soviets
can hardly be considered as actions against the power of the soviets.

In such circumstances, the Bolshevik government viewed the Kronstadt revolt
**not** as socialists should but rather as a ruling class. It was suppressed
for "reasons of state" and not to defend a revolutionary regime (which was, by
this stage, revolutionary in name only). As Bakunin had argued decades before,
the "workers' state" would not remain controlled by the workers for long and
would soon became a dictatorship **over** the proletariat by an elite which
claimed to know the interests of the working class better than they did
themselves (see [section 15](append42.html#app15)).

The only possible justification for maintaining the party dictatorship was the
argument that soviet democracy would have lead to the defeat of the Communists
at the polls (which would mean recognising it was a dictatorship **over** the
proletariat and had been for some time). This would, it is argued, have
resulted in (eventually) a return of the Whites and an anti-working class
dictatorship that would have slaughtered the Russian workers and peasants en
mass.

Such a position is self-serving and could have been used by Stalin to justify
**his** regime. Unsurprisingly enough, the Hungarian Stalinists argued after
crushing the 1956 revolution that _"the dictatorship of the proletariat, if
overthrown, cannot be succeeded by any form of government other than fascist
counter-revolution."_ [quoted by Andy Anderson, **Hungary '56**, p. 101] And,
of course, an even more anti-working class dictatorship than Lenin's did
appear which did slaughter the Russian workers and peasants en mass, namely
Stalinism. No other option was possible, once party dictatorship was fully
embraced in 1921 (repression against dissidents was **more** extreme after the
end of the Civil War than during it). It is utopian in the extreme to believe
that the good intentions of the dictators would have been enough to keep the
regime within some kind of limits. Thus this argument is flawed as it
seriously suggests that dictatorship and bureaucracy can reform itself (we
discuss this in more detail in [section 13](append42.html#app13)).



## 12 Was the country too exhausted to allow soviet democracy?

Trotskyists have, in general, two main lines of attack with regards the
Kronstadt revolt. The main one is the claim that the garrison in 1921 was not
of the same class composition as the one in 1917. This meant that the 1921
revolt expressed the peasant counter-revolution and had to be destroyed. We
have indicated that, firstly, the garrison was essentially the same in 1921 as
it had been in 1917 (see [section 8](append42.html#app8)). Secondly, we have
shown that politically the ideas expressed in its program were the same as
those in 1917 (see [section 9](append42.html#app9)). Thirdly, that this
program had many of the same points as strikers resolutions in Petrograd and,
indeed, were **more** socialist in many cases by clearly calling for soviet
democracy rather the constituent assembly (see [section
4](append42.html#app4)).

Now we turn to the second excuse, namely that the country was too exhausted
and the working class was decimated. In such circumstances, it is argued,
objective conditions meant that soviet democracy was impossible and so the
Bolsheviks had to maintain their dictatorship at all costs to defend what was
left of the revolution. Leninist Pat Stack of the British SWP is typical of
this approach. It is worth quoting him at length:

> _"Because anarchists dismiss the importance of material reality, events such
as the 1921 Kronstadt rising against the Bolshevik government in Russia can
become a rallying cry. The revolutionary Victor Serge was not uncritical of
the Bolshevik handling of the rising, but he poured scorn on anarchist claims
for it when he wrote, 'The third revolution it was called by certain
anarchists whose heads were stuffed by infantile delusions.' _

>

> _"This third revolution, it was argued, would follow the first one in
February 1917 and the second in October. The second had swept away the
attempts to create capitalist power, had given land to the peasants and had
extracted Russia from the horrible imperialist carnage of the First World War.
The revolution had introduced a huge literacy programme, granted women
abortion rights, introduced divorce and accepted the rights of the various
Russian republics to self determination. It had done so, however, against a
background of a bloody and horrendous civil war where the old order tried to
regain power. Sixteen imperialist powers sent armies against the regime, and
trade embargoes were enforced. _

>

> _"The reality of such actions caused huge suffering throughout Russia. The
regime was deprived of raw materials and fuel, transportation networks were
destroyed, and the cities began running out of food. By 1919 the regime only
had 10 percent of the fuel that was available in 1917, and the production of
iron ore in the same year stood at 1.6 percent of that in 1914. By 1921
Petrograd had lost 57 percent of its population and Moscow 44.5 percent.
Workers were either dead, on the frontline of the civil war, or were fleeing
the starvation of the city. The force that had made the revolution possible
was being decimated. . . _

>

> _"The choice facing the regime in Russia was either to crush the uprising
and save the revolution, or surrender to the rising and allow the forces of
reaction to march in on their back. There was no material basis for a third
way. A destroyed economy and infrastructure, a population faced with
starvation and bloody war, and a hostile outside world were not circumstances
in which the revolution could move forward. Great efforts would have to be
made to solve these problems. There were no overnight solutions and preserving
the revolutionary regime was crucial. Ultimately real solutions could only be
found if the revolution were to spread internationally, but in the meantime to
have any chance of success the regime had to survive. Only the right and the
imperialist powers would have benefited from its destruction."_ [_"Anarchy in
the UK?"_, **Socialist Review**, no. 246, November 2000]

Anarchists, in spite of Stack's assertions, were and are well aware of the
problems facing the revolution. Alexander Berkman (who was in Petrograd at the
time) pointed out the _"[l]ong years of war, revolution, and civil struggle"_
which _"had bled Russia to exhaustion and brought her people to the brink of
despair."_ [**The Russian Tragedy**, p. 61] Like every worker, peasant, sailor
and soldier in Russia, anarchists knew (and know) that reconstruction would
not take place _"overnight."_ The Kronstadters' recognised this in the first
issue of their newspaper **Izvestiia**:

> _"Comrades and citizens, our country is passing through a tough time. For
three years now, famine, cold and economic chaos have trapped us in a vice-
like grip. The Communist Party which governs the country has drifted away from
the masses and proved itself powerless to rescue them from a state of general
ruination . . . All workers, sailors and Red soldiers today can clearly see
that only concentrated efforts, only the concentrated determination of the
people can afford the country bread, wood and coal, can clothe and shoe the
people and rescue the Republic from the impasse in which it finds itself."_
[cited in **No Gods, No Masters**, vol. 2, p. 183]

In the Kronstadt **_Izvestiia_** of March 8 they wrote that it was _"here in
Kronstadt that the foundation stone was laid of the Third Revolution that will
smash the last shackles on the toiler and open up before him the broad new
avenue to socialist construction."_ They stress that the _"new revolution will
rouse the toiling masses of the Orient and Occident. For it will offer the
example of fresh socialist construction as opposed to mechanical, governmental
'Communist' construction."_ [**Op. Cit.**, p. 194] Clearly, the Kronstadt
rebels knew that construction would take time and were arguing that the only
means of rebuilding the country was via the participation of what of left of
the working class and peasantry in free class organisations like freely
elected soviets and unions.

The experience of the revolt provides evidence that this analysis was far from
"utopian." A Finish reporter at Kronstadt was struck by the _"enthusiasm"_ of
its inhabitants, by their renewed sense of purpose and mission. Avrich argues
that for a _"fleeting interval Kronstadt was shaken out if its listlessness
and despair."_ [**Kronstadt**, p. 159] The sailors, soldiers and civilians
sent their delegates to delegates, started to re-organise their trade unions
and so on. Freedom and soviet democracy was allowing the masses to start to
rebuild their society and they took the opportunity. The Kronstadter's faith
in _"direct mass democracy of and by the common people through free soviets"_
did seem to be justified in the response of the people of Kronstadt. This
suggests that a similar policy implemented by the workers who had just
organised general strikes, demonstrations and protest meetings all across
Russia's industrial centres was not impossible or doomed to failure.

Indeed, this wave of strikes refutes Stack's claim that _"[w]orkers were
either dead, on the frontline of the civil war, or were fleeing the starvation
of the city. The force that had made the revolution possible was being
decimated."_ Clearly, a sizeable percentage of the workers were still working
and so not dead, on the frontline or fleeing the cities. As we discuss below,
approximately one-third of factory workers were still in Petrograd (the
overall decrease of urban working people throughout Russia exceeded 50 percent
[Avrich, **Op. Cit.**, p. 24]). The working class, in other words, still
existed and were able to organise strikes, meetings and mass demonstrations in
the face of state repression. The fact, of course, is that the majority of
what remained of the working class would not have voted Communist in free
soviet elections. Thus political considerations have to be factored in when
evaluating Stack's arguments.

The question for anarchists, as for the Kronstadt rebels, was what the
necessary pre-conditions for this reconstruction were. Could Russia be re-
built in a socialist way while being subject to a dictatorship which crushed
every sign of working class protest and collective action? Surely the first
step, as Kronstadt shows, would have to be the re-introduction of workers'
democracy and power for only this would give allow expression to the creative
powers of the masses and interest them in the reconstruction of the country.
Continuing party dictatorship would never do this:

> _"by its very essence a dictatorship destroys the creative capacities of a
people. . . The revolutionary conquest could only be deepened through a
genuine participation of the masses. Any attempt to substitute an 'elite' for
those masses could only be profoundly reactionary. _

>

> _"In 1921 the Russian Revolution stood at the cross roads. The democratic or
the dictatorial way, that was the question. By lumping together bourgeois and
proletarian democracy the Bolsheviks were in fact condemning both. They sought
to build socialism from above, through skilful manoeuvres of the Revolutionary
General Staff. While waiting for a world revolution that was not round the
corner, they built a state capitalist society, where the working class no
longer had the right to make the decisions most intimately concerning it."_
[Mett, **Op. Cit.**, pp. 82-3]

The Russian revolution had faced economic crisis all through 1917 and 1918.
Indeed, by the spring of 1918 Russia was living through an almost total
economic collapse, with a general scarcity of all resources and mass
unemployment. According to Tony Cliff (the leader of the SWP) in the spring of
1918 Russia's _"[w]ar-damaged industry continued to run down. 'The bony hand
of hunger' . . . gripped the whole population . . . One of the causes of the
famine was the breakdown of transport. . . Industry was in a state of complete
collapse. Not only was there no food to feed the factory workers; there was no
raw materials or fuel for industry. The oilfields of the Baku, Grozny and Emba
regions came to a standstill. The situation was the same in the coalfields.
The production of raw materials was in no better a state . . . The collapse of
industry meant unemployment for the workers."_ [**Lenin: The Revolution
Besieged**, vol. 3, pp. 67-9] The industrial workforce dropped to 40% of its
1917 levels. The similarities to Stack's description of the situation in early
1921 is striking.

Does this mean that, for Leninists, soviet democracy was impossible in early
1918 (of course, the Bolsheviks **in practice** were making soviet democracy
impossible by suppressing soviets that elected the wrong people)? After all,
in the start of 1918 the Russian Revolution also faced a _"destroyed economy
and infrastructure, a population faced with starvation and bloody war, and a
hostile outside world."_ If these _"were not circumstances in which the
revolution could move forward"_ then it also applied in 1918 as well as in
1921. And, if so, then this means admitting that soviet democracy is
impossible during a revolution, marked as it will always be marked by
exceptionally difficult circumstances. Which, of course, means to defend party
power and not soviet power and promote the dictatorship of the party over the
working class, positions Leninists deny holding.

Incredibly, Stack fails to even mention the power and privileges of the
bureaucracy at the time. Officials got the best food, housing and so on. The
lack of effective control or influence from below ensured that corruption was
widespread. One of the leaders of the Workers' Opposition gives us an insight
of the situation which existed at the start of 1921:

> _"The rank and file worker is observant. He sees that so far . . . the
betterment of the workers' lot has occupied the last place in our policy . . .
We all know that the housing problem cannot be solved in a few months, even
years, and that due to our poverty, its solution is faced with serious
difficulties. But the facts of ever-growing inequality between the privileged
groups of the population in Soviet Russia and the rank and file workers, 'the
frame-work of the dictatorship', breed and nourish the dissatisfaction. _

>

> _"The rank and file worker sees how the Soviet official and the practical
man lives and how he lives . . . [It will be objected that] 'We could not
attend to that; pray, there was the military front.' And yet whenever it was
necessary to make repairs to any of the houses occupied by the Soviet
institutions, they were able to find both the materials and the labour."_
[Alexandra Kollontai, **The Workers' Opposition**, p. 10]

A few months earlier, the Communist Yoffe wrote to Trotsky expressing the same
concerns. _"There is enormous inequality,"_ he wrote, _"and one's material
position largely depends on one's post in the party; you'll agree that this is
a dangerous situation."_ [quoted by Orlando Figes, **A People's Tragedy**, p.
695] To talk about anarchists dismissing the importance of material reality
and a _"revolutionary regime"_ while ignoring the inequalities in power and
wealth, and the bureaucratisation and despotism which were their root, is
definitely a case of the pot calling the kettle black!

Under the harsh material conditions facing Russia at the time, it goes without
saying that the bureaucracy would utilise its position to gather the best
resources around it. Indeed, part of the factors resulting in Kronstadt was
_"the privileges and abuses of commissars, senior party functionaries and
trade union officials who received special rations, allocations and housing
and . . . quite openly enjoying the good life."_ [Getzler, **Op. Cit.**, p.
210] Stack fails to mention this and instead talks about the necessity of
defending a "workers' state" in which workers had no power and where
bureaucratic abuses were rampant. If anyone is denying reality, it is him!
Thus Ciliga:

> _"The Soviet Government and the higher circles in the Communist Party
applied their own solution [to the problems facing the revolution] of
**increasing the power of the bureaucracy**. The attribution of powers to the
'Executive Committees' which had hitherto been vested in the soviets, the
replacement of the dictatorship of the class by the dictatorship of the party,
the shift of authority even within the party from its members to its cadres,
the replacement of the double power of the bureaucracy and the workers in the
factory by the sole power of the former - to do all this was to 'save the
Revolution!' [. . .] The Bureaucracy prevented the bourgeois restoration . . .
by eliminating the proletarian character of the revolution."_ [**Op. Cit.**,
p. 331]

Perhaps, in light of this, it is significant that, in his list of
revolutionary gains from October 1917, Stack fails to mention what anarchists
would consider the most important, namely workers' power, freedom, democracy
and rights. But, then again, the Bolsheviks did not rate these gains highly
either and were more than willing to sacrifice them to ensure their most
important gain, state power (see [section 15](append42.html#app15) for a
fuller discussion of this issue). Again, the image of revolution gains a
victory over its content!

When Stack argues that it was necessary to crush Kronstadt to _"save the
revolution"_ and _"preserv[e] the revolutionary regime"_ we feel entitled to
ask what was there left to save and preserve? The dictatorship and decrees of
"Communist" leaders? In other words, party power. Yes, by suppressing
Kronstadt Lenin and Trotsky saved the revolution, saved it for Stalin. Hardly
something to be proud of.

Ironically, given Stack's assertions that anarchists ignore _"material
reality"_, anarchists had predicted that a revolution would be marked by
economic disruption. Kropotkin, for example, argued that it was _"certain that
the coming Revolution . . . will burst upon us in the middle of a great
industrial crisis . . . There are millions of unemployed workers in Europe at
this moment. It will be worse when Revolution has burst upon us . . . The
number of the out-of-works will be doubled as soon as barricades are erected
in Europe and the United States . . . we know that in time of Revolution
exchange and industry suffer most from the general upheaval . . . A Revolution
in Europe means, then, the unavoidable stoppage of at least half the factories
and workshops."_ He stressed that there would be _"the complete
disorganisation"_ of the capitalist economy and that during a revolution
_"[i]nternational commerce will come to a standstill"_ and _"the circulation
of commodities and of provisions will be paralysed."_ [**The Conquest of
Bread**, pp. 69-70 and p. 191]

Elsewhere, he argued that a revolution would _"mean the stoppage of hundreds
of manufactures and workshops, and the impossibility of reopening them.
Thousands of workmen will find no employment . . . The present want of
employment and misery will be increased tenfold."_ He stressed that _"the
reconstruction of Society in accordance with more equitable principles
**will** necessitate a disturbed period"_ and argued that any revolution will
be isolated to begin with and so (with regards to the UK) _"the imports of
foreign corn will decrease"_ as will _"exports of manufactured wares."_ A
revolution, he argued, _"is not the work of one day. It means a whole period,
mostly lasting for several years, during which the country is in a state of
effervescence."_ To overcome these problems he stressed the importance of
reconstruction from the bottom up, organised directly by working people, with
local action being the basis of wider reconstruction. The _"immense problem --
the re-organisation of production, redistribution of wealth and exchange,
according to new principles -- cannot be solved by . . . any kind of
government. It must be a natural growth resulting from the combined efforts of
all interested in it, freed from the bonds of the present institutions. It
must grow naturally, proceeding from the simplest up to complex federations;
and it cannot be something schemed by a few men and ordered from above. In
this last shape it surely would have no chance of living at all."_ [**Act for
Yourselves**, pp. 71-2, p. 67, pp, 72-3, pp. 25-6 and p. 26]

Anarchists had predicted the problems facing the Russian Revolution decades
previously and, given the lack of success of Bolshevik attempts to solve these
problems via centralism, had also predicted the only way to solve them. Far
from ignoring _"material reality"_ it is clear that anarchists have long been
aware of the difficulties a revolution would face and had organised our
politics around them. In contrast, Stack is arguing that these inevitable
effects of a revolution create _"circumstances"_ in which the revolution
cannot _"move forward"_! If this is so, then revolution is an impossibility as
it will always face economic disruption and isolation at some stage in its
development, for a longer or shorter period. If we base our politics on the
"best-case scenario" then they will soon be proven to be lacking.

Ultimately, Stack's arguments (and those like it) are the ones which ignore
_"material reality"_ by arguing that Lenin's state was a _"revolutionary
regime"_ and reconstruction could be anything but to the advantage of the
bureaucracy without the active participation of what was left of the working
class. Indeed, the logic of his argument would mean rejecting the idea of
socialist revolution **as such** as the problems he lists will affect
**every** revolution and had affected the Russian Revolution from the start.

The problems facing the Russian working class were difficult in the extreme in
1921 (some of which, incidentally, were due to the results of Bolshevik
economic policies which compounded economic chaos via centralisation), but
they could never be solved by someone else bar the thousands of workers taking
strike action all across Russia at the time: _"And if the proletariat was that
exhausted how come it was still capable of waging virtually total general
strikes in the largest and most heavily industrialised cities?"_ [Ida Mett,
**Op. Cit.**, p. 81]

So, as far as _"material reality"_ goes, it is clear that it is Stack who
ignores it, not anarchists or the Kronstadt rebels. Both anarchists and
Kronstadters recognised that the country was in dire straits and that a huge
effort was required for reconstruction. The material basis at the time offered
two possibilities for reconstruction -- either from above or from below. Such
a reconstruction could **only** be socialist in nature if it involved the
direct participation of the working masses in determining what was needed and
how to do it. In other words, the process had to start **from below** and no
central committee utilising a fraction of the creative powers of the country
could achieve it. Such a bureaucratic, top-down re-construction would rebuild
the society in a way which benefited a few. Which, of course, was what
happened.

John Rees joins his fellow party member by arguing that the working class base
of the workers' state had _"disintegrated"_ by 1921. The working class was
reduced _"to an atomised, individualised mass, a fraction of its former size,
and no longer able to exercise the collective power that it had done in
1917."_ The _"bureaucracy of the workers' state was left suspended in mid-air,
its class base eroded and demoralised."_ He argues that Kronstadt was
_"utopian"_ as _"they looked back to the institutions of 1917 when the class
which made such institutions possible no longer had the collective capacity to
direct political life."_ [Rees, **Op. Cit.**, p. 65 and p. 70]

There are two problems with this kind of argument. Firstly, there are factual
problems with it. Second, there are ideological problems with it. We will
discuss each in turn.

The factual problems are clear. All across Russia in February 1921 the Russian
working class were going on strike, organising meetings and demonstrations. In
other words, **taking collective action** based on demands collectively agreed
in workplace meetings. One factory would send delegates to others, urging them
to join the movement which soon became a general strike in Petrograd and
Moscow. In Kronstadt, workers, soldiers and sailors went the next step and
organised a delegate conference. In other places they tried to do so, with
various degrees of success. During the strikes in Petrograd _"workers from
various plants elected delegates to the Petrograd Assembly of
Plenipotentiaries"_ which raised similar demands as that of Kronstadt. Its
activities and other attempts to organise collectively were obviously hindered
by the fact the Cheka arrested _"all delegates to other enterprises"_ the
strikers sent. Brovkin states that following the example of Petrograd,
_"workers in some cities set up assemblies of plenipotentiaries"_ as well. In
Saratov _"such a council grew out of a strike co-ordination committee."_ [V.
Brovkin, **Behind the Lines of the Russian Civil War**, p. 393, p. 396 and p.
398]

Any claim that the Russian working class had no capacity for collective action
seems invalidated by such events. Not that Rees is not unaware of these
strikes. He notes that the Kronstadt revolt was _"preceded by a wave of
serious but quickly resolved strikes."_ [**Op. Cit.**, p. 61] An _"atomised,
individualised mass"_ which was _"no longer able to exercise the collective
power"_ being able to conduct a _"wave of serious . . . strikes"_ all across
Russia? That hardly fits. Nor does he mention the repression which _"quickly
resolved"_ the strikes and which, by its very nature, atomised and
individualised the masses in order to break the collective action being
practised.

The fact that these strikes did not last longer of course suggests that the
strikers could not sustain this activity indefinitely. However, this was more
a product of state repression and the lack of rations while on strike than any
objectively predetermined impossibility of collective decision making. The
workers may have been too exhausted to wage indefinite general strikes against
a repressive state but that does not imply they could not practice continual
collective decision making in less extreme circumstances in a soviet
democracy.

Of course, these striking workers would have been unlikely to voted Communist
en mass if free soviet elections were organised (in Kronstadt, Communists made
up one-third of the conference of delegates). Thus there were pressing
**political** reasons to deny free elections rather than an objective
impossibility. Moreover, the actions of the Soviet state were designed to
break the collective resistance of the working force. The use of armed patrols
on the streets and in the factories, and the closing and re-registration of an
enterprise labour force were designed to break the strike and atomise the
workforce. These actions would not have been needed if the Russian working
class was, in fact, atomised and incapable of collective action and decision
making.

The size of the working class in 1921 **was** smaller in 1921 than it was in
1917. However, the figures for May 1918 and 1920 were nearly identical. In
1920, the number of factory workers in Petrograd was 148,289 (which was 34% of
the population and 36% of the number of workers in 1910). [Mary McAuley, **Op.
Cit.**, p. 398] In January 1917, the number was 351,010 and in April 1918, it
was 148,710. [S.A. Smith, **Red Petrograd**, p. 245] Thus factory worker
numbers were about 40% of the pre-Civil War number and remained so throughout
the Civil War. A proletarian core remained in every industrial town or city in
Russia.

Nor was this work force incapable of collective action or decision making. All
through the civil war they organised strikes and protests for specific demands
(and faced Bolshevik repression for so doing). In March 1919, for example,
tens of thousands of workers went on strike in Petrograd. The strikes were
broken by troops. Strikes regularly occurred throughout 1919 and 1920 (and,
again, usually met with state repression). In 1921, the strike wave resurfaced
and became near general strikes in many cities, including Petrograd and Moscow
(see [section 2](append42.html#app2)). If the workers could organise strikes
(and near general strikes in 1921), protest meetings and committees to co-
ordinate their struggles, what could stop them starting to manage their own
destinies? Does soviet democracy become invalid once a certain number of
workers is reached?

Given that Rees gets the key slogan of Kronstadt wrong (they called for all
power to the soviets and not to parties rather than Rees' _"soviets without
parties"_) it is hard to evaluate whether Rees claims that without Bolshevik
dictatorship the Whites would inevitably have taken power. After all, the
Kronstadt delegate meeting had one-third Communists in it. Ultimately, he is
arguing that working people cannot manage their own fates themselves without
it resulting in a counter-revolution!

In addition, the logic of Rees' argument smacks of double-think. On the one
hand, he argues that the Bolsheviks represented the _"dictatorship of the
proletariat."_ On the other hand, he argues that free soviet elections would
have seen the Bolsheviks replaced by _"moderate socialists"_ (and eventually
the Whites). In other words, the Bolsheviks did not, in fact, represent the
Russian working class and their dictatorship was **over**, not **of**, the
proletariat. The basic assumption, therefore, is flawed. Rees and his fellow
Trotskyists seriously want us to believe that a dictatorship will not become
corrupt and bureaucratic, that it can govern in the interests of its subjects
and, moreover, reform itself. And he calls the Kronstadters _"utopians"_!

Given these factors, perhaps the real reason for the lack of soviet democracy
and political freedom and rights was that the Bolsheviks knew they would lose
any free elections that would be held? As we noted in [section
2](append42.html#app2), they had not been shy in disbanding soviets with non-
Bolshevik majorities before the start of the civil war nor in suppressing
strikes and workers' protests before, during and after the Civil War. In
effect, the Bolsheviks would exercise the dictatorship of the proletariat over
and above the wishes of that proletariat if need be (as Trotsky made clear in
1921 at the Tenth Party Congress). Thus the major factor restricting soviet
democracy was Bolshevik power -- this repressed working class collective
action which promoted atomisation in the working class and the
unaccountability of the Bolshevik leadership. The bureaucracy was _"left
suspended in mid-air"_ simply because the majority of the workers and peasants
did not support it and when they protested against the party dictatorship they
were repressed.

Simply put, objective factors do not tell the whole story.

Now we turn to these objective factors, the economic breakdown affecting
Russia in 1921. This is the basis for the ideological problem with Rees'
argument.

The ideological problem with this argument is that both Lenin and Trotsky had
argued that revolution inevitably implied civil war, _"exceptional
circumstances"_ and economic crisis. For example, in **Terrorism and
Communism** Trotsky argued that _"[a]ll periods of transition have been
characterised by . . . tragic features"_ of an _"economic depression"_ such as
exhaustion, poverty and hunger. Every class society _"is violently swept off
[the arena] by an intense struggle, which immediately brings to its
participants even greater privations and sufferings than those against which
they rose."_ He gave the example of the French Revolution _"which attained its
titanic dimensions under the pressure of the masses exhausted with suffering,
itself deepened and rendered more acute their misfortunes for a prolonged
period and to an extraordinary extent."_ He asked: _"Can it be otherwise?"_
[**Terrorism and Communism**, p. 7]

Indeed, he stressed that _"revolutions which drag into their whirlpool
millions of workers"_ automatically affect the _"economic life of the
country."_ By _"[d]ragging the mass of the people away from labour, drawing
them for a prolonged period into the struggle, thereby destroying their
connection with production, the revolution in all these ways strikes deadly
blows at economic life, and inevitably lowers the standard which it found at
its birth."_ This affects the socialist revolution as the _"more perfect the
revolution, the greater are the masses it draws in; and the longer it is
prolonged, the greater is the destruction it achieves in the apparatus of
production, and the more terrible inroads does it make upon public resources.
From this there follows merely the conclusion which did not require proof --
that a civil war is harmful to economic life."_ [**Ibid.**]

Lenin in 1917 argued the similarly, mocking those who argued that revolution
was out of the question because _"the circumstances are exceptionally
complicated."_ He noting that any revolution, _"in its development, would give
rise to exceptionally complicated circumstances"_ and that it was _"the
sharpest, most furious, desperate class war and civil war. Not a single great
revolution in history has escaped civil war. No one who does not live in a
shell could imagine that civil war is conceivable without exceptionally
complicated circumstances. If there were no exceptionally complicated
circumstances there would be no revolution."_ [**Will the Bolsheviks Maintain
Power?**, p. 80 and p. 81]

A few months early, Lenin argues that _"[w]hen unavoidable disaster is
approaching, the most useful and indispensable task confronting the people is
that of organisation. Marvels of proletarian organisation -- this is our
slogan at the present, and shall become our slogan and our demand to an even
greater extent, when the proletariat is in power. . . There are many such
talents [i.e. organisers] among the people. These forces lie dormant in the
peasantry and the proletariat, for lack of application. They must be mobilised
from below, by practical work . . ."_ [**The Threatening Catastrophe and how
to avoid it**, pp. 49-50]

The problem in 1921 (as during the war), of course, was that when the
proletariat **did** organise itself, it was repressed as counterrevolutionary
by the Bolsheviks. The reconstruction from below, the organisation of the
proletariat, automatically came into conflict with party power. The workers
and peasants could not act because soviet and trade union democracy would have
ended Bolshevik dictatorship.

Therefore, Rees' and Stack's arguments fail to convince. As noted, their
ideological gurus clearly argued that revolution without civil war and
economic exhaustion was impossible. Sadly, the means to mitigate the problems
of Civil War and economic crisis (namely workers' self-management and power)
inevitably came into conflict with party power and could not be encouraged. If
Bolshevism cannot meet the inevitable problems of revolution and maintain the
principles it pays lip-service to (i.e. soviet democracy and workers' power)
then it clearly does not work and should be avoided.

Stack's and Rees' argument, in other words, represents the bankruptcy of
Bolshevik ideology rather than a serious argument against the Kronstadt
revolt.



## 13 Was there a real alternative to Kronstadt's _"third revolution"_?

Another Trotskyist argument against Kronstadt and in favour of the Bolshevik
repression is related to the country was exhausted argument we discussed in
the [last section](append42.html#app12). It finds its clearest expression in
Victor Serge's argument:

> _"the country was exhausted, and production practically at a standstill;
there was no reserves of any kind, not even reserves of stamina in the hearts
of the masses. The working-class **elite** that had been moulded in the
struggle against the old regime was literally decimated. The Party, swollen by
the influx of power-seekers, inspired little confidence . . . Soviet democracy
lacked leadership, institutions and inspiration . . . _

>

> _"The popular counter-revolution translated the demand for freely-elected
soviets into one for 'Soviets without Communists.' If the Bolshevik
dictatorship fell, it was only a short step to chaos, and through chaos to a
peasant rising, the massacre of the Communists, the return of the emigres, and
in the end, through the sheer force of events, another dictatorship, this time
anti-proletarian."_ [**Memoirs of a Revolutionary**, pp. 128-9]

Serge supported the Bolsheviks, considering them as the only possible means of
defending the revolution. Some modern day Leninists follow this line of
reasoning and want us to believe that the Bolsheviks were defending the
remaining gains of the revolution. What gains, exactly? The only gains that
remained were Bolshevik power and nationalised industry -- both of which
excluded the real gains of the Russian Revolution (namely soviet power, the
right to independent unions and to strike, freedom of assembly, association
and speech for working people, the beginnings of workers' self-management of
production and so on). Indeed, both "gains" were the basis for the Stalinist
bureaucracy's power.

Anarchists and libertarian Marxists who defend the Kronstadt revolt and oppose
the actions of the Bolsheviks are not foolish enough to argue that Kronstadt's
_"third revolution"_ would have definitely succeeded. Every revolution is a
gamble and may fail. As Ante Ciliga correctly argues:

> _"Let us consider, finally, one last accusation which is commonly
circulated: that action such as that at Kronstadt could have **indirectly**
let loose the forces of the counter-revolution. It is **possible** indeed that
even by placing itself on a footing of workers' democracy the revolution might
have been overthrown; but what is **certain** is that it has perished, and
that it has perished on account of the policy of its leaders. The repression
of Kronstadt, the suppression of the democracy of workers and soviets by the
Russian Communist party, the elimination of the proletariat from the
management of industry, and the introduction of the NEP, already signified the
death of the Revolution."_ [**Op. Cit.**, p. 335]

No revolution is guaranteed to succeed. The same with Kronstadt's _"Third
Revolution."_ Its call for soviet power may have lead to defeat via renewed
intervention. That is possible -- just as it was possible in 1917. One thing
is sure, by maintaining the Bolshevik dictatorship the Russian Revolution
**was** crushed.

The only alternative to the _"third revolution"_ would have been self-reform
of the party dictatorship and, therefore, of the soviet state. Such an attempt
was made after 1923 by the **Left Opposition** (named _"Trotskyist"_ by the
Stalinists because Trotsky was its main leader). John Rees discusses the
**Left Opposition**, arguing that _"without a revival of struggle in Russia or
successful revolution elsewhere"_ it _"was doomed to failure."_ [**Op. Cit.**,
p. 68] Given the logic of Serge's arguments, this is the only option left for
Leninists.

How viable was this alternative? Could the soviet dictatorship reform itself?
Was soviet democracy more of a danger than the uncontrolled dictatorship of a
party within a state marked by already serious levels of corruption,
bureaucracy and despotism? History provides the answer with the rise of
Stalin.

Unfortunately for the **Left Opposition**, the bureaucracy had gained
experience in repressing struggle in breaking the wave of strikes in 1921 and
crushing the Kronstadt rebellion. Indeed, Rees incredulously notes that by
1923 _"the well-head of renewal and thorough reform -- the activity of the
workers -- had dried to a trickle"_ and yet does not see that this decline was
aided by the example of what had happened to Kronstadt and the repression of
the 1921 strike wave. The **Left Opposition** received the crop that Lenin and
Trotsky sowed the seeds of in 1921.

Ironically, Rees argues that the Stalinist bureaucracy could betray the
revolution without _"an armed counter-revolutionary seizure of power"_ (and so
_"no martial law, no curfew or street battles"_) because of _"the atomisation
of the working class."_ However, the atomisation was a product of the armed
counter-revolutionary activities of Lenin and Trotsky in 1921 when they broke
the strikes and crushed Kronstadt by means of martial law, curfew and street
battles. The workers had no interest in which branch of the bureaucracy would
govern and exploit them and so remained passive. Rees fails to see that the
Stalinist coup simply built upon the initial counter-revolution of Lenin.
There **was** martial law, curfew and street battles but they occurred in
1921, not 1928. The rise of Stalinism was the victory of one side of the new
bureaucratic class over another but that class had defeated the working class
in March 1921.

As for the idea that an external revolution could have regenerated the Soviet
bureaucracy, this too was fundamentally utopian. In the words of Ida Mett:

> _"Some claim that the Bolsheviks allowed themselves such actions (as the
suppression of Kronstadt) in the hope of a forthcoming world revolution, of
which they considered themselves the vanguard. But would not a revolution in
another country have been influenced by the spirit of the Russian Revolution?
When one considers the enormous moral authority of the Russian Revolution
throughout the world one may ask oneself whether the deviations of this
Revolution would not eventually have left an imprint on other countries. Many
historical facts allow such a judgement. One may recognise the impossibility
of genuine socialist construction in a single country, yet have doubts as to
whether the bureaucratic deformations of the Bolshevik regime would have been
straightened out by the winds coming from revolutions in other countries."_
[**Op. Cit.**, p. 82]

The Bolsheviks had already been manipulating foreign Communist Parties in the
interests of their state for a number of years. That is part of the reason why
the Left-Communists around Pannekoek and Gorter broke with the Third
International later in 1921. Just as the influence of Lenin had been a key
factor in fighting the anti-Parliamentarian and libertarian communist
tendencies in Communist Parties all across the world, so the example and
influence of the Bolsheviks would have made its impact on any foreign
revolution. The successful revolutionaries would have applied such "lessons"
of October such as the dictatorship of the proletariat being impossible
without the dictatorship of the communist party, centralism, militarisation of
labour and so on. This would have distorted any revolution from the start
(given how obediently the Communist Parties around the world followed the
insane policies of Stalinism, can we doubt this conclusion?).

Not that the Left Opposition's political platform could have saved the
revolution. After all, it was utopian in that it urged the party and state
bureaucracy to reform itself as well as contradictory. It did not get at the
root of the problem, namely Bolshevik ideology. The theoretical limitations of
the "Left Opposition" can be found in more detail in [section
3](append45.html#app3) of the appendix on ["Were any of the Bolshevik
oppositions a real alternative?"](append45.html). Here we will restrict
ourselves to looking at **The Platform of the Opposition** written in 1927
(unless otherwise specified all quotes come from this document).

It urged a _"consistent development of a workers' democracy in the party, the
trade unions, and the soviets"_ and to _"convert the urban soviets into real
institutions of proletarian power."_ It states that _"Lenin, as long ago as in
the revolution of 1905, advanced the slogan of soviets as organs of the
democratic dictatorship of the proletariat and the peasants."_ The Kronstadt
sailors argued the same, of course, and were branded _"White Guardists"_ and _
"counter-revolutionary"_. At the same time as this call for democracy, we find
affirmation of the _"Leninist principle"_ (_"inviolable for every Bolshevik"_)
that _"the dictatorship of the proletariat is and can be realised only through
the dictatorship of the party."_ It repeats the principle by mentioning that
_"the dictatorship of the proletariat demands a single and united proletarian
party as the leader of the working masses and the poor peasantry."_ It
stresses that a _"split in our party, the formation of two parties, would
represent an enormous danger to the revolution."_ This was because:

> _"Nobody who sincerely defends the line of Lenin can entertain the idea of
'two parties' or play with the suggestion of a split. Only those who desire to
replace Lenin's course with some other can advocate a split or a movement
along the two-party road. _

>

> _"We will fight with all our power against the idea of two parties, because
the dictatorship of the proletariat demands as its very core a single
proletarian party. It demands a single party. It demands a proletarian party
-- that is, a party whose policy is determined by the interests of the
proletariat and carried out by a proletarian nucleus. Correction of the line
of our party, improvement of its social composition -- that is not the two-
party road, but the strengthening and guaranteeing of its unity as a
revolutionary party of the proletariat."_

We can note, in passing, the interesting notion of party (and so
_"proletarian"_ state) policy _"determined by the interests of the proletariat
and carried out by a proletarian nucleus"_ but which is **not** determined
**by** the proletariat itself. Which means that the policy of the "workers'
state" must be determined by some other (unspecified) group and not by the
workers. What possibility can exist that this other group actually knows what
is in the interests of the proletariat? None, of course, as any form of
democratic decision can be ignored when those who determine the policy
consider the protests of the proletariat to be not _"in the interests of the
proletariat."_

This was the opinion of Trotsky, who argued against the Workers' Opposition
faction of the Communist Party who urged re-introducing some elements of
democracy at the Tenth Party Conference at the time of the Kronstadt uprising
(while, of course, keeping the Communist Party dictatorship intact). As he put
it, they _"have come out with dangerous slogans. They have made a fetish of
democratic principles. They have placed the workers' right to elect
representatives above the party. As if the Party were not entitled to assert
its dictatorship even if that dictatorship clashed with the passing moods of
the workers' democracy!"_ He continued by stating that the _"Party is obliged
to maintain its dictatorship . . . regardless of temporary vacillations even
in the working class . . . The dictatorship does not base itself at every
moment on the formal principle of a workers' democracy."_ [quoted by M.
Brinton, **The Bolsheviks and Workers' Control**, p. 78]

Thus the call for democracy is totally annulled by other arguments in the
Platform, arguments which logically eliminates democracy and results in such
acts as the repression of Kronstadt (see [section 15](append42.html#app15)).

The question, of course, arises as to how democracy can be introduced in the
soviets and unions when party dictatorship is essential for the
_"realisation"_ of the "proletarian" dictatorship and there can only be
**one** party? What happens if the proletariat vote for someone else (as they
did in Kronstadt)? If "proletarian" dictatorship is impossible without the
dictatorship of the party then, clearly, proletarian democracy becomes
meaningless. All the workers would be allowed to do would be to vote for
members of the same party, all of whom would be bound by party discipline to
carry out the orders of the party leadership. Power would rest in the party
hierarchy and definitively **not** in the working class, its unions or its
soviets (both of which would remain mere fig-leafs for party rule).
Ultimately, the only guarantee that the party dictatorship would govern in the
interests of the proletariat would be the good intentions of the party.
However, being unaccountable to the masses, such a guarantee would be
worthless -- as history shows.

Kronstadt is the obvious end result of such politics. The starting point was
the disbanding of soviets which had been elected with a majority of "wrong"
parties (as the Bolsheviks did in early 1918, **before** the start of the
civil war). While the Platform may be useful as an expression of the usual
Leninist double-think on the "workers' state", its practical suggestions are
useless. Unlike the Kronstadt Platform, it was doomed to failure from the
start. The new bureaucratic class could only be removed by a "third
revolution" and while this, possibly, could have resulted in a bourgeois
counter-revolution the alternative of maintaining Bolshevik dictatorship would
**inevitably** have resulted in Stalinism. When supporters of Bolshevism argue
that Kronstadt would have opened the gate to counter-revolution, they do not
understand that the Bolsheviks **were** the counter-revolution in 1921 and
that by suppressing Kronstadt the Bolsheviks not only opened the gate to
Stalinism but invited it in and gave it the keys to the house.

The Platform, moreover, smacks of the re-writing of history Trotsky correctly
accused Stalinism of.

It argues, for example, that the urban soviets _"in recent years have been
losing importance. This undoubtedly reflects a shift in the relation of class
forces to the disadvantage of the proletariat."_ In fact, the soviets had lost
their importance since the October revolution (see [section
2](append42.html#app2) for details). The _"shift"_ in the relation of class
forces started immediately after the October revolution, when the **real**
gains of 1917 (i.e. soviet democracy, workers' rights and freedom) were slowly
and surely eliminated by the bureaucratic class forming around the new state
-- a class who could justify their actions by claiming it was in the
_"interests"_ of the masses whose wishes they were ignoring.

As regards the Communist Party itself, it argues for introducing (_"in deeds
and not words"_) _"a democratic regime. Do away with administrative pressure
tactics. Stop the persecution and expulsion of those who hold independent
opinions about party questions."_ No mention, of course, that these tactics
were used by Lenin and Trotsky against Left-wing dissidents after the October
revolution.

The Left-Communists in early 1918 were subject to such pressure. For example,
they were ousted from leading positions in the Supreme Economic Council in
March 1918. After their views were denounced by Lenin a _"campaign was whipped
up in Leningrad which compelled **Kommunist** [their paper] to transfer
publication to Moscow . . . After the appearance of the first issue of the
paper a hastily convened Leningrad Party Conference produced a majority for
Lenin and 'demanded that the adherents of **Kommunist** cease their separate
organisational existence.'"_ The paper lasted four issues, with the last
having to be published as a private factional paper. The issue had been
settled by a high pressure campaign in the Party organisation, backed by a
barrage of violent invective in the Party press and in the pronouncements of
the Party leaders. [Maurice Brinton, **Op. Cit.**, pp. 39-40]

Similarly, the Workers' Opposition three years later also experienced them. At
the Tenth Party congress, A. Kollontai (author of their platform) stated that
the circulation of her pamphlet had been deliberately impeded. _"So irregular
were some of these that the Moscow Party Committee at one stage voted a
resolution **publicly** censuring the Petrograd organisation 'for not
observing the rules of proper controversy.'"_ The success of the Leninist
faction in getting control of the party machine was such that _"there is
serious doubt as to whether they were not achieved by fraud."_ [Brinton, **Op.
Cit.**, p. 75 and p. 77] Victor Serge witnessed the rigging of an election to
ensure Lenin's victory in the trade union debate. [**Memoirs of a
Revolutionary**, p. 123] Kollontai herself mentions (in early 1921) that
comrades _"who dare to disagree with decrees from above are **still** being
persecuted."_ [our emphasis, **The Workers' Opposition**, p. 22]

The Platform states that _"the dying out of inner-party democracy leads to a
dying out of workers' democracy in general -- in the trade unions, and in all
other nonparty mass organisations."_ In fact, the opposite causation is
correct. The dying out of workers' democracy in general leads to a dying out
of inner-party democracy. The dictatorship of the party by necessity clashes
with the _"democratic dictatorship of the working masses and the poor
peasantry."_ As the party dictatorship replaces the working masses,
eliminating democracy by the dictatorship of a single party, democracy in that
party must wither. If the workers can join that party and influence its
policies then the same problems that arose in the soviets and unions appear in
the party (i.e. voting for the wrong policies and people). This necessitates a
corresponding centralisation in power within the party as occurred in the
soviets and unions, all to the detriment of rank and file power and control.

As Ida Mett argued:

> _"There is no doubt that the discussion taking place within the [Communist]
Party at this time [in early 1921] had profound effects on the masses. It
overflowed the narrow limits the Party sought to impose on it. It spread to
the working class as a whole, to the solders and to the sailors. Heated local
criticism acted as a general catalyst. The proletariat had reasoned quite
logically: if discussion and criticism were permitted to Party members, why
should they not be permitted to the masses themselves who had endured all the
hardships of the Civil War? _

>

> _"In his speech to the Tenth Congress -- published in the Congress
Proceedings -- Lenin voiced his regret at having 'permitted' such a
discussion. 'We have certainly committed an error,' he said, 'in having
authorised this debate. Such a discussion was harmful just before the Spring
months that would be loaded with such difficulties.'"_ [**The Kronstadt
Uprising**, pp. 34-5]

Unsurprisingly, the Tenth Congress voted to ban factions within the Party. The
elimination of discussion in the working class led to its ban in the party.
Having the rank-and-file of the Party discuss issues would give false hopes to
the working class as a whole who may attempt to influence policy by joining
the party (and, of course, vote for the wrong people or policies).

Thus the only alternative to Kronstadt's _"Third Revolution"_ and free soviets
was doomed to failure.

Lastly, we should draw some parallels between the fates of the Kronstadt
sailors and the Left Opposition.

John Rees argues that the Left Opposition had _"the whole vast propaganda
machine of the bureaucracy . . . turned against them,"_ a machine used by
Trotsky and Lenin in 1921 against Kronstadt. Ultimately, the Left Opposition
_"were exiled, imprisoned and shot,"_ again like the Kronstadters and a host
of revolutionaries who defended the revolution but opposed the Bolshevik
dictatorship. [**Op. Cit.**, p. 68]

As Murray Bookchin argued:

> _"All the conditions for Stalinism were prepared for by the defeat of the
Kronstadt sailors and Petrograd strikers."_ [_"Introduction"_, Ida Mett, **The
Kronstadt Uprising**, p. 13]

Thus, the argument that Kronstadt was _"utopian"_ is false. The third
revolution was the only **real** alternative in Bolshevik Russia. Any struggle
from below post-1921 would have raised the same problems of soviet democracy
and party dictatorship which Kronstadt raised. Given that the **Left
Opposition** subscribed to the _"Leninist principle"_ of _"the dictatorship of
the party,"_ they could not appeal to the masses as they would not vote for
them. The arguments raised against Kronstadt that soviet democracy would lead
to counter-revolution are equally applicable to movements which appealed, as
Rees desires, to the Russian working class post-Kronstadt.

In summary, the claim that Kronstadt would inevitably have lead to an anti-
proletarian dictatorship fails. Yes, it might have but the Bolshevik
dictatorship itself was anti-proletarian (it had repressed proletarian
protest, organisation, freedom and rights on numerous occasions) and it could
never be reformed from within by the very logic of its _"Leninist principle"_
of _"the dictatorship of the party."_ The rise of Stalinism was inevitable
after the crushing of Kronstadt.



## 14 How do modern day Trotskyists misrepresent Kronstadt?

We have discussed how Trotskyists have followed their heroes Lenin and Trotsky
in abusing the facts about the Kronstadt sailors and uprising in previous
sections. In [section 8](append42.html#app8), we have indicated how they have
selectively quoted from academic accounts of the uprising and suppressed
evidence which contradicts their claims. In [section 7](append42.html#app7) we
have shown how they have selectively quoted from Paul Avrich's book on the
revolt to paint a false picture of the connections between the Kronstadt
sailors and the Whites. Here we summarise some of the other misrepresentations
of Trotskyists about the revolt.

John Rees, for example, asserts that the Kronstadters were fighting for
_"soviets without parties."_ Indeed, he makes the assertion twice on one page.
[**Op. Cit.**, p. 63] Pat Stack goes one further and asserts that the
_"central demand of the Kronstadt rising though was 'soviets without
Bolsheviks', in other words, the utter destruction of the workers' state."_
[_"Anarchy in the UK?"_, **Socialist Review**, no. 246, November 2000] Both
authors quote from Paul Avrich's book **Kronstadt 1921** in their articles.
Let us turn to that source:

> _"'Soviets without Communists' was not, as is often maintained by both
Soviet and non-Soviet writers, a Kronstadt slogan."_ [**Kronstadt 1921**, p.
181]

Nor did they agitate under the banner _"soviets without parties."_ They argued
for _"all power to the soviets and not to parties."_ Political parties were
not to be excluded from the soviets, simply stopped from dominating them and
substituting themselves for them. As Avrich notes, the Kronstadt program _"did
allow a place for the Bolsheviks in the soviets, alongside the other left-wing
organisations . . . Communists . . . participated in strength in the elected
conference of delegate, which was the closest thing Kronstadt ever had to the
free soviets of its dreams."_ [**Ibid.**] The index for Avrich's work handily
includes this page in it, under the helpful entry _"soviets: 'without
Communists.'"_

The central demand of the uprising was simply soviet democracy and a return to
the principles that the workers and peasants had been fighting the whites for.
In other words, both Leninists have misrepresented the Kronstadt revolt's
demands and so misrepresented its aims.

Rees goes one step further and tries to blame the Bolshevik massacre on the
sailors themselves. He argues _"in Petrograd Zinoviev had already essentially
withdrawn the most detested aspects of War Communism in response to the
strikes."_ Needless to say, Zinoviev did not withdraw the **political**
aspects of War Communism, just some of the **economic** ones and, as the
Kronstadt revolt was mainly **political**, these concessions were not enough
(indeed, the repression directed against workers rights and opposition
socialist and anarchist groups **increased**). He then states the Kronstadters
_"response [to these concessions] was contained in their **What We Are
Fighting For**"_ and quotes it as follows:

> _"there is no middle ground in the struggle against the Communists . . .
They give the appearance of making concessions: in Petrograd province road-
block detachments have been removed and 10 million roubles have been allotted
for the purchase of foodstuffs. . . But one must not be deceived . . . No
there can be no middle ground. Victory or death!"_

What Rees fails to inform the reader is that this was written on March 8th,
while the Bolsheviks had started military operations on the previous evening.
Moreover, the fact the _"response"_ clearly stated _"[w]ithout a single shot,
without a drop of blood, the first step has been taken [of the "Third
Revolution"]. The toilers do not need blood. They will shed it only at a
moment of self-defence"_ is not mentioned. [Avrich, **Op. Cit.**, p. 243] In
other words, the Kronstadt sailors reaffirmed their commitment to non-violent
revolt. Any violence on their part was in self-defence against Bolshevik
actions. Not that you would know that from Rees' work. Indeed, as one of Rees'
sources indicates, the rebels _"had refrained from taking any communist lives.
The Soviet Government, on the other hand, as early as March 3, already had
executed forty-five seamen at Oranienbaum -- a quite heavy proportion of the
total personnel of the men at the Naval Aviation Detachment. These men had
voted for the Kronstadt resolution, but did not take arms against the
government. This mass execution was merely a prelude to those that took place
after the defeat of the mutineers."_ These executions at Oranienbaum, it
should be noted, exceeded the total of 36 seamen who had paid with their lives
for the two large rebellions of the 1905 revolution at Kronstadt and Sveaborg.
[D. Fedotoff-White, **The Growth of the Red Army**, p. 156]

Ted Grant, of the UK's **Socialist Appeal** re-writes history significantly in
his work **Russia: From revolution to counter-revolution**. For example, he
claims (without providing any references) that the _"first lie"_ of anti-
Bolshevik writers on the subject _"is to identify the Kronstadt mutineers of
1921 with the heroic Red sailors of 1917."_ As we have indicated in [section
8](append42.html#app8), research has **proven** that over 90% of the sailors
on the two battleships which started the revolt had been recruited before and
during the 1917 revolution and at least three-quarters of the sailors were old
hands who had served in the navy through war and revolution. So was the
majority of the Provisional Revolutionary Committee. Grant asserts that the
sailors in 1917 and 1921 _"had nothing in common"_ because those _"of 1917
were workers and Bolsheviks."_ In fact, as we indicated [section
9](append42.html#app9), the Bolsheviks were a minority in Kronstadt during
1917 (a fact even Trotsky admitted in 1938). Moreover, the demands raised in
the revolt matched the politics dominant in 1917.

Grant then claims that _"almost the entire Kronstadt garrison volunteered to
fight in the ranks of the Red Army during the civil war."_ Are we to believe
that the Bolshevik commanders left Kronstadt (and so Petrograd) defenceless
during the Civil War? Or drafted the skilled and trained (and so difficult to
replace) sailors away from their ships, so leaving them unusable? Of course
not. Common sense refutes Grant's argument (and statistical evidence supports
this common sense position -- on 1st January, 1921, at least 75.5% of the
Baltic Fleet was likely to have been drafted before 1918 and over 80% were
from Great Russian areas and some 10% from the Ukraine. [Gelzter, **Op.
Cit.**, p. 208]).

Not to be outdone, he then states that the _"Kronstadt garrison of 1921 was
composed mainly of raw peasant levies from the Black Sea Fleet. A cursory
glance at the surnames of the mutineers immediately shows that they were
almost all Ukrainians."_ According to Paul Avrich, _"[s]ome three or four
hundred names appear in the journal of the rebel movement . . . So far as one
can judge from these surnames alone . . . Great Russians are in the
overwhelming majority."_ Of the 15 person Provisional Revolutionary Committee,
_"three . . . bore patently Ukrainian names and two others. . . Germanic
names."_ [Paul Avrich, **Op. Cit.**, pp. 92-3] Of the three Ukrainians, two
were sailors of long standing and _"had fought on the barricades in 1917."_
[Avrich, **Op. Cit.**, p. 91] So much for a _"cursory glance at the surnames
of the mutineers."_ To top it off, he states: _"That there were actual
counter-revolutionary elements among the sailors was shown by the slogan
'Soviets without Bolsheviks'."_ Which, of course, the Kronstadt sailors
**never** raised as a slogan!

And **Grant** talks about the _"[m]any falsifications. . . written about this
event,"_ that it _"has been virtually turned into a myth"_ and that _"these
allegations bear no relation to the truth."_ Truly amazing. As can be seen,
his words apply to his own inventions.

Another SWP member, Abbie Bakan, asserts that, for example, _"more than three
quarters of the sailors"_ at Kronstadt _"were recent recruits of peasant
origin"_ but refuses to provide a source for this claim. [_"A Tragic
Necessity"_, **Socialist Worker Review**, no. 136, November 1990, pp. 18-21]
As noted in [section 8](append42.html#app8), such a claim is false. The likely
source for the assertion is Paul Avrich, who noted that more than three-
quarters of the sailors were of peasant origin but Avrich does **not** say
they were all recent recruits. While stating that there could be _"little
doubt"_ that the Civil War produced a _"high turnover"_ and that _"many"_ old-
timers had been replaced by conscripts from rural areas, he does not indicate
that all the sailors from peasant backgrounds were new recruits. He also notes
that _"there had always been a large and unruly peasant element among the
sailors."_ [**Op. Cit.**, pp. 89-90]

Bakan asserts that anti-semitism _"was vicious and rampant"_ yet fails to
provide **any** official Kronstadt proclamations expressing this perspective.
Rather, we are to generalise from the memoirs of **one** sailor and the anti-
semitic remark of Vershinin, a member of the Revolutionary Committee. Let us
not forget that the opinions of these sailors and others like them were
irrelevant to the Bolsheviks when they drafted them in the first place. And,
more importantly, this _"vicious and rampant"_ anti-semitism failed to mark
the demands raised nor the Kronstadt rebels' newspaper or radio broadcasts.
Nor did the Bolsheviks mention it at the time.

Moreover, it is true that the _"worse venom of the Kronstadt rebels was
levelled against Trotsky and Zinoviev"_ but it was **not** because, as Bakan
asserts, they were _"treated as Jewish scapegoats."_ Their ethnical background
was not mentioned by the Kronstadt sailors. Rather, they were strong
**political** reasons for attacking them. As Paul Avrich argues, _"Trotsky in
particular was the living symbol of War Communism, of everything the sailors
had rebelled against. His name was associated with centralisation and
militarisation, with iron discipline and regimentation."_ As for Zinoviev, he
had _"incurred the sailors' loathing as the party boss who had suppressed the
striking workers and who had stooped to taking their own families as
hostages."_ Good reasons to attack them and nothing to do with them being
Jewish. [**Op. Cit.**, p. 178 and p. 176]

Bakan states that the _"demands of the Kronstadt sailors reflected the ideas
of the most backward section of the peasantry."_ As can be seen from [section
3](append42.html#app3), such a comment cannot be matched with the actual
demands of the revolt (which, of course, he does not provide). So what ideas
did these demands of the _"most backward section of the peasantry"_ state?
Free elections to the Soviets, freedom of speech and of the press for workers
and peasants, right of assembly, freedom for trade union and peasant
organisations, a conference of workers, soldiers and sailors, liberation of
all political, worker and peasant prisoners, equalisation of rations, freedom
for peasants as long as they do not employ hired labour, and so on. What
would, in other words, be included in most socialist parties programmes and
was, in fact, key elements of Bolshevik rhetoric in 1917. And, of course, all
of the political aspects of the Kronstadt demands reflected key aspects of the
Soviet Constitution.

How _"backward"_ can you get! Indeed, these _"backward"_ peasants send a radio
message marking International Woman's Day, hoping that women would _"soon
accomplish"_ their _"liberation from every form of violence and oppression."_
[quoted by Alexander Berkman, **The Russian Tragedy**, p. 85]

Bakan pathetically acknowledges that their demands included _"calls for
greater freedoms"_ yet looks at the _"main economic target"_ (not mentioning
they were points 8, 10 and 11 of the 15 demands, the bulk of the rest are
political). These, apparently, were aimed at _"the programme of forced
requisitioning of peasant produce and the roadblock detachments that halted
the black market in grain."_ Given that he admits that the Bolsheviks were
_"already discussing"_ the end of these features (due to their lack of
success) it must be the case that the Bolsheviks also _"reflected the ideas of
the most backward section of the peasantry"_! Moreover, the demand to end the
roadblocks was also raised by the Petrograd and Moscow workers during their
strikes, as were most of the other demands raised by Kronstadt. [Paul Avrich,
**Op. Cit.**, p. 42] Surely the _"most backward section of the peasantry"_ was
getting around in those days, appearing as they were in the higher reaches of
the Bolshevik party bureaucracy and the factories of Petrograd and other major
cities!

In reality, of course, the opposition to the forced requisitioning of food was
a combination of ethical and practical considerations -- it was evil and it
was counterproductive. You did not have to be a peasant to see and know this
(as the striking workers show). Similarly, the roadblocks were also a failure.
Victor Serge, for example, recollected he would _"have died without the sordid
manipulations of the black market."_ [**Memoirs of a Revolutionary**, p.79] He
was a government official. Think how much worse it would have been for an
ordinary worker. The use of roadblock detachments harmed the industrial
workers -- little wonder they struck for their end and little wonder the
sailors expressed solidarity with them and included it in their demands.
Therefore, **nothing** can be drawn from these demands about the class nature
of the revolt.

In an interesting example of double-think, Bakan then states that the sailors
_"called for the abolition of Bolshevik authority in the army, factories and
mills."_ What the resolution demanded was, in fact, _"the abolition Party
combat detachments in all military groups"_ as well as _"Party guards in
factories and enterprises"_ (point 10). In other words, to end the
intimidation of workers and soldiers by armed communist units in their amidst!
When Bakan states that _"the real character of the rebellion"_ can be seen
from the opening declaration that _"the present soviets do not express the
will of the workers and peasants"_ he could not have made a truer comment. The
Kronstadt revolt was a revolt for soviet democracy and against party
dictatorship. And soviet democracy would only abolish _"Bolshevik authority"_
if the existing soviets, as the resolution argued, did not express the will of
their electors!

Similarly, he asserts that the Provisional Revolutionary Committee was _"non-
elected"_ and so contradicts every historian who acknowledges it was elected
by the conference of delegates on March 2nd and expanded by the next
conference a few days later. He even considers the fact the delegate meeting's
_"denial of party members' usual role in chairing the proceedings"_ as one of
many _"irregularities"_ while, of course, the **real** irregularity was the
fact that **one** party (the government party) had such a _"usual role"_ in
the first place! Moreover, given that that Petrograd soviet meeting to discuss
the revolt had Cheka guards (Lenin's political police) on it, his notion that
sailors guarded the conference of delegates meeting (a meeting held in
opposition to the ruling party) was _"irregular"_ seems ironic.

Lastly, he raises the issue of the _"Memorandum"_ of the White _"National
Centre"_ and uses it as evidence that _"Lenin's suspicion of an international
conspiracy linked up with the Kronstadt events has been vindicated."_ Needless
to say, he fails to mention that the historian who discovered the document
rejected the notion that it proved that Kronstadt was linked to such a
conspiracy (see [section 6](append42.html#app6) for a full discussion).
Ironically, he mentions that _"[t]wo weeks after the Kronstadt rebellion the
ice was due to melt."_ Two weeks **after** the rebellion was crushed, of
course, and he fails to mention that the _"Memorandum"_ he uses as evidence
assumes that the revolt would break out **after** the ice had melted, not
before. While he claims that _"[h]olding out until the ice melted was
identified as critical in the memorandum,"_ this is not true. The Memorandum
in fact, as Paul Avrich notes, _"assumes that the rising will occur after the
ice has melted."_ [**Op. Cit.**, p. 237f] No other interpretation can be
gathered from the document.

Altogether, Bakan's article shows how deeply the supporters of Leninism will
sink to when attempting to discuss the Kronstadt rebellion. Sadly, as we have
indicated many, many times, this is not an isolated occurrence.



## 15 What does Kronstadt tell us about Bolshevism?

The rationales used by Lenin, Trotsky and their followers are significant aids
to getting to the core of the Bolshevik Myth. These rationales and activities
allow us to understand the limitations of Bolshevik theory and how it
contributed to the degeneration of the revolution.

Trotsky stated that the _"Kronstadt slogan"_ was _"soviets without
Communists."_ [Lenin and Trotsky, **Kronstadt**, p. 90] This, of course, is
factually incorrect. The Kronstadt slogan was _"all power to the soviets but
not to the parties"_ (or _"free soviets"_). From this incorrect assertion,
Trotsky argued as follows:

> _"to free the soviets from the leadership [!] of the Bolsheviks would have
meant within a short time to demolish the soviets themselves. The experience
of the Russian soviets during the period of Menshevik and SR domination and,
even more clearly, the experience of the German and Austrian soviets under the
domination of the Social Democrats, proved this. Social Revolutionary-
anarchist soviets could only serve as a bridge from the proletarian
dictatorship. They could play no other role, regardless of the 'ideas' of
their participants. The Kronstadt uprising thus had a counterrevolutionary
character."_ [**Op. Cit.**, p. 90]

Interesting logic. Let us assume that the result of free elections would have
been the end of Bolshevik _"leadership"_ (i.e. dictatorship), as seems likely.
What Trotsky is arguing is that to allow workers to vote for their
representatives would _"only serve as a bridge from the proletarian
dictatorship"_! This argument was made (in 1938) as a **general point** and is
**not** phrased in terms of the problems facing the Russian Revolution in
1921. In other words Trotsky is clearly arguing for the dictatorship of the
party and contrasting it to soviet democracy. So much for _"All Power to the
Soviets"_ or _"workers' power"_!

Indeed, Trotsky was not shy in explicitly stating this on occasion. As we
noted in [section 13](append42.html#app13), the **Left Opposition** based
itself on _"Leninist principle"_ (_"inviolable for every Bolshevik"_) that
_"the dictatorship of the proletariat is and can be realised only through the
dictatorship of the party."_ Trotsky stressed ten years later that the whole
working class cannot determine policy in the so-called "workers' state" (as
well as indicating his belief that one-party dictatorship is an inevitable
stage in a "proletarian" revolution):

> _"The revolutionary dictatorship of a proletarian party is for me not a
thing that one can freely accept or reject: It is an objective necessity
imposed upon us by the social realities -- the class struggle, the
heterogeneity oof the revolutionary class, the necessity for a selected
vanguard in order to assure the victory. The dictatorship of a party belongs
to the barbarian prehistory as does the state itself, but we can not jump over
this chapter, which can open (not at one stroke) genuine human history. . .
The revolutionary party (vanguard) which renounces its own dictatorship
surrenders the masses to the counter-revolution . . . Abstractly speaking, it
would be very well if the party dictatorship could be replaced by the
'dictatorship' of the whole toiling people without any party, but this
presupposes such a high level of political development among the masses that
it can never be achieved under capitalist conditions. The reason for the
revolution comes from the circumstance that capitalism does not permit the
material and the moral development of the masses."_ [Trotsky, **Writings
1936-37**, pp. 513-4]

This is the very essence of Bolshevism. Trotsky is clearly arguing that the
working class, as a class, is incapable of making a revolution or managing
society itself -- hence the party must step in on its behalf and, if
necessary, ignore the wishes of the people the party claims to represent. To
re-quote Trotsky's comments against the **Workers' Opposition** at the Tenth
Party Congress in early 1921: _"They have made a fetish of democratic
principles! They have placed the workers' right to elect representatives above
the Party. As if the Party were not entitled to assert its dictatorship even
if that dictatorship clashed with the passing moods of the workers'
democracy!"_ He stressed that the _"Party is obliged to maintain its
dictatorship . . . regardless of temporary vacillations even in the working
class . . . The dictatorship does not base itself at every moment on the
formal principle of a workers' democracy."_ [quoted by M. Brinton, **The
Bolsheviks and Workers' Control**, p. 78]

In 1957, after crushing the 1956 workers' revolution, the Hungarian Stalinists
argued along **exactly** the same lines as Trotsky had after the Bolsheviks
had crushed Kronstadt. The leader of the Hungarian Stalinist dictatorship
argued that _"the regime is aware that the people do not always know what is
good for them. It is therefore the duty of the leadership to act, not
according to the **will** of the people, but according to what the leadership
knows to be in the best **interests** of the people."_ [quoted by Andy
Anderson, **Hungary '56**, p. 101]

Little wonder, then, that Samuel Farber notes that _"there is no evidence
indicating that Lenin or any of the mainstream Bolshevik leaders lamented the
loss of workers' control or of democracy in the soviets, or at least referred
to these losses as a retreat, as Lenin declared with the replacement of War
Communism by NEP in 1921."_ [**Before Stalinism**, p. 44]

Such a perspective cannot help have disastrous consequences for a revolution
(and explains why the Bolsheviks failed to pursue a peaceful resolution to the
Kronstadt revolt). The logic of this argument clearly implies that when the
party suppressed Kronstadt, when it disbanded non-Bolshevik soviets in early
1918 and robbed the workers and soviets of their power, the Bolsheviks were
acting in the best interests of masses! The notion that Leninism is a
revolutionary theory is invalidated by Trotsky's arguments. Rather than aim
for a society based on workers' power, they aim for a "workers' state" in
which workers **delegate** their power to the leaders of the party. Which
confirmed Bakunin's argument that Marxism meant _"the highly despotic
government of the masses by a new and very small aristocracy of real or
pretended scholars. The people are not learned, so they will be liberated from
the cares of government and included in entirety in the governed herd."_
[**Statism and Anarchy**, pp. 178-9]

Such an approach is doomed to failure -- it cannot produce a socialist society
as such a society (as Bakunin stressed) can only be built from below by the
working class itself.

As Vernon Richards argues:

> _"The distinction between the libertarian and authoritarian revolutionary
movements in their struggle to establish the free society, is the means which
each proposes should be used to this end. The libertarian maintains that the
initiative must come from below, that the free society must be the result of
the will to freedom of a large section of the population. The authoritarian .
. . believes that the will to freedom can only emerge once the existing
economic and political system has be replaced by a dictatorship of the
proletariat [as expressed by the dictatorship of the party, according to
Trotsky] which, as the awareness and sense of responsibility of the people
grows, will wither away and the free society emerge. _

>

> _"There can be no common ground between such approaches. For the
authoritarian argues that the libertarian approach is noble but 'utopian' and
doomed to failure from the start, while the libertarian argues on the evidence
of history, that the authoritarian **methods** will simply replace one
coercive state by another, equally despotic and remote from the people, and
which will no more 'wither away' than its capitalist predecessor."_ [**Lessons
of the Spanish Revolution**, p. 206]

Modern day Leninists follow Trotsky's arguments (although they rarely
acknowledge where they logically led or that their heroes explicitly
acknowledged this conclusion and justified it). They do not state this
position as honestly as did Trotsky.

Chris Bambery of the British SWP, for example, argues in his article
_"Leninism in the 21st century"_ that _"in Lenin's concept of the party,
democracy is balanced by centralism"_ and the first of three reasons for this
is:

> _"The working class is fragmented. There are always those who wish to fight,
those who will scab and those in between. Even in the soviets those divisions
will be apparent. Revolutionary organisation does not aspire to represent the
working class as a whole. It bases itself on those workers who want to
challenge capitalism, and seeks to organise those to win the majority of
workers to the need to take power."_ [**Socialist Review**, no. 248, January
2001]

This, of course, has **exactly** the same basis of Trotsky's defence of the
need of party dictatorship and why Kronstadt was counterrevolutionary. Bambery
notes that even _"in the soviets"_ there will be _"divisions."_ Thus we have
the basic assumption which, combined with centralisation, vanguardism and
other aspects of Bolshevism, leads to events like Kronstadt and the
destruction of soviet power by party power. The arguments for centralisation
mean, in practice, the concentration of power in the centre, in the hands of
the party leaders, as the working masses cannot be trusted to make the correct
("revolutionary") decisions. This centralised power is then used to impose the
will of the leaders, who use state power against the very class they claim to
represent:

> _"Without revolutionary coercion directed against the avowed enemies of the
workers and peasants, it is impossible to break down the resistance of these
exploiters. On the other hand, revolutionary coercion is bound to be employed
towards the wavering and unstable elements among the masses themselves."_
[Lenin, **Collected Works**, vol. 42, p. 170]

In other words, whoever protests against the dictatorship of the party.

Of course, it will be replied that the Bolshevik dictatorship used its power
to crush the resistance of the bosses (and _"backward workers"_). Sadly, this
is not the case. First, we must stress that anarchists are **not** against
defending a revolution or expropriating the power and wealth of the ruling
class, quite the reverse as this is about **how** a revolution does this.
Lenin's argument is flawed as it confuses the defence of the revolution with
the defence of the party in power. These are two totally different things.

The _"revolutionary coercion"_ Lenin speaks of is, apparently, directed
against one part of the working class. However, this will also intimidate the
rest (just as bourgeois repression not only intimidates those who strike but
those who may think of striking). As a policy, it can have but one effect --
to eliminate **all** workers' power and freedom. It is the violence of an
oppressive minority against the oppressed majority, not vice versa. Ending
free speech harmed working class people. Militarisation of labour did not
affect the bourgeoisie. Neither did eliminating soviet democracy or union
independence. As the dissident (working class) Communist Gavriii Miasnokov
argued in 1921 (in reply to Lenin):

> _"The trouble is that, while you raise your hand against the capitalist, you
deal a blow to the worker. You know very well that for such words as I am now
uttering hundreds, perhaps thousands, of workers are languishing in prison.
That I myself remain at liberty is only because I am a veteran Communist, have
suffered for my beliefs, and am known among the mass of workers. Were it not
for this, were I just an ordinary mechanic from the same factory, where would
I be now? In a Cheka prison or, more likely, made to 'escape,' just as I made
Mikhail Romanov 'escape.' Once more I say: You raise your hand against the
bourgeoisie, but it is I who am spitting blood, and it is we, the workers,
whose jaws are being cracked."_ [quoted by Paul Avrich, **G. T. Miasnikov and
the Workers' Group**]

This can be seen from the make-up of Bolshevik prisoners. Of the 17 000 camp
detainees on whom statistical information was available on 1 November 1920,
peasants and workers constituted the largest groups, at 39% and 34%
respectively. Similarly, of the 40 913 prisoners held in December 1921 (of
whom 44% had been committed by the Cheka) nearly 84% were illiterate or
minimally educated, clearly, therefore, either peasants of workers. [George
Leggett, **The Cheka: Lenin's Political Police**, p. 178] Unsurprisingly,
Miasnikov refused to denounce the Kronstadt insurgents nor would he have
participated in their suppression had he been called upon to do so.

Thus, the ideas of centralisation supported by Leninists are harmful to the
real gains of a revolution, namely working class freedom and power (as we
noted in [section 12](append42.html#app12), some of them do not even mention
these when indicating the gains of 1917). Indeed, this can be seen all through
the history of Bolshevism.

Bambery states (correctly) that _"Lenin and the Bolsheviks initially opposed"_
the spontaneously formed soviets of 1905. Incredulously, however, he assigns
this opposition to the assertion that their _"model of revolution was still
shaped by that of the greatest previous revolution in France in 1789."_
[**Ibid.**] In reality, it was because they considered, to quote a leading
Bolshevik, that _"only a strong party along class lines can guide the
proletarian political movement and preserve the integrity of its program,
rather than a political mixture of this kind, an indeterminate and vacillating
political organisation such as the workers council represents and cannot help
but represent."_ [P. N. Gvozdev, quoted by, Oskar Anweilier, **The Soviets**,
p. 77]

The soviet, in other words, could not represent the interests of the working
class because it was elected by them! Trotsky repeated this argument almost
word for word in 1920 when he argued that _"it can be said with complete
justice that the dictatorship of the Soviets became possible only by means of
the dictatorship of the party"_ and that there is _"no substitution at all"_
when the _"power of the party"_ replaces that of the working class. The party,
he stressed, _"has afforded to the Soviets the possibility of becoming
transformed from shapeless parliaments of labour into the apparatus of the
supremacy of labour."_ [**Communism and Terrorism**] How labour could express
this _"supremacy"_ when it could not even vote for its delegates (never mind
manage society) is never explained.

In 1905, the Bolsheviks saw the soviets as a rival to their party and demanded
it either accept their political program or simply become a trade-union like
organisation. They feared that it pushed aside the party committee and thus
led to the _"subordination of consciousness to spontaneity."_ [Oskar
Anweilier, **Op. Cit.**, p. 78] This was following Lenin in **What is to be
Done?**, where he had argued that the _"**spontaneous** development of the
labour movement leads to it being subordinated to bourgeois ideology."_
[**Essential Works of Lenin**, p. 82] This perspective is at the root of all
Bolshevik justifications for party power after the October revolution.

Such a combination of political assumptions inevitably leads to such events as
Kronstadt. With the perception that spontaneous developments inevitably leads
to bourgeois domination, any attempt to revoke Bolshevik delegates and elect
others to soviets **must** represent counter-revolutionary tendencies. As the
working class is divided and subject to _"vacillations"_ due to _"wavering and
unstable elements among the masses themselves,"_ working class people simply
cannot manage society themselves. Hence the need for _"the Leninist
principle"_ of _"the dictatorship of the party."_ And, equally logically, to
events like Kronstadt.

Thus Cornellius Castoriadis:

> _"To manage the work of others -- this is the beginning and the end of the
whole cycle of exploitation. The 'need' for a specific social category to
manage the work of others in production (and the activity of others in
politics and in society), the 'need' for a separate business management and
for a Party to rule the State -- this is what Bolshevism proclaimed as soon as
it seized power, and this is what it zealously laboured to impose. We know
that it achieved its ends. Insofar as ideas play a role in the development of
history -- and, **in the final analysis**, they play an enormous role -- the
Bolshevik ideology (and with it, the Marxist ideology lying behind it) was a
decisive factor in the birth of the Russian bureaucracy."_ [**Political and
Social Writings**, vol. 3, p. 104]

Moreover, the logic of the Bolshevik argument is flawed:

> _"if you consider these worthy electors as unable to look after their own
interests themselves, how is it that they will know how to choose for
themselves the shepherds who must guide them? And how will they be able to
solve this problem of social alchemy, of producing a genius from the votes of
a mass of fools? And what will happen to the minorities which are still the
most intelligent, most active and radical part of a society?"_ [Malatesta,
**Anarchy**, p. 53]

Hence the need for soviet democracy and self-management, of the demands of the
Kronstadt revolt. As Malatesta put it, _"[o]nly freedom or the struggle for
freedom can be the school for freedom."_ [**Life and Ideas**, p. 59] The
_"epic of Kronstadt"_ proves _"**conclusively** that what belongs really to
**the workers and peasants** can be **neither governmental nor statist**, and
what is **governmental and statist** can belong **neither to the workers nor
the peasants.**"_ [Voline, **The Unknown Revolution**, p. 503]

Anarchists are well aware that differences in political perspective exists
within the working class. We are also aware of the importance of
revolutionaries organising together to influence the class struggle, raising
the need for revolution and the creation of working class organisations which
can smash and replace the state with a system of self-managed communes and
workers' councils. However, we reject the Bolshevik conclusion for centralised
power (i.e. power delegated to the centre) as doomed to failure. Rather, we
agree with Bakunin who argued that revolutionary groups must _"not seek
anything for themselves, neither privilege nor honour nor power"_ and reject
_"any idea of dictatorship and custodial control."_ The _"revolution
everywhere must be created by the people, and supreme control must always
belong to the people organised into a free federation of agricultural and
industrial associations . . . organised from the bottom upwards by means of
revolutionary delegations . . . [who] will set out to administer public
services, not to rule over peoples."_ [**Michael Bakunin: Selected Writings**,
p. 172]

Anarchists seek to influence working people directly, via their natural
influence in working class organisations like workers' councils, unions and so
on. Only by discussion, debate and self-activity can the political
perspectives of working class people develop and change. This is impossible in
a centralised system based on party dictatorship. Debate and discussion are
pointless if they have no effect on the process of the revolution nor if
working people cannot elect their own delegates. Nor can self-activity be
developed if the government uses _"revolutionary coercion"_ against _"waving
or unstable elements"_ (i.e. those who do not unquestioningly follow the
orders of the government or practice initiative).

In other words, the fact Bolshevism uses to justify its support for party
power is, in fact, the strongest argument against it. By concentrating power
in the hands of a few, the political development of the bulk of the population
is hindered. No longer in control of their fate, of **their** revolution, they
will become pray to counter-revolutionary tendencies.

Nor was the libertarian approach impossible to implement during a revolution
or civil war. Anarchists applied their ideas very successfully in the
Makhnovist movement in the Ukraine. In the areas they protected, the
Makhnovists refused to dictate to the workers and peasants what to do:

> _"The freedom of the peasants and workers, said the Makhnovists, resides in
the peasants and workers themselves and may not be restricted. In all fields
of their lives it is up to the workers and peasants to construct whatever they
consider necessary. As for the Makhnovists -- they can only assist them with
advice, by putting at their disposal the intellectual or military forced they
need, but under no circumstances can the Makhnovists prescribe for them in
advance."_ [Peter Arshinov, **The History of the Makhnovist Movement**, p.
148]

The Makhnovists urged workers to form free soviets and labour unions and to
use them to manage their own fates. They organised numerous conferences of
workers' and peasants' delegates to discuss political and military
developments as well as to decide how to re-organise society from the bottom
up in a self-managed manner. After they had liberated Aleksandrovsk, for
example, they _"invited the working population to participant in a general
conference of the workers of the city . . . and it was proposed that the
workers organise the life in the city and the functioning of the factories
with their own forces and their own organisations."_ [**Op. Cit.**, p. 149] In
contrast, the Bolsheviks tried to **ban** congresses of workers', peasants'
and soldiers' delegates organised by the Makhnovists (once by Dybenko and once
by Trotsky). [**Op. Cit.**, pp. 98-104 and 120-5]

The Makhnovists replied by holding the conferences anyway, asking _"[c]an
there exist laws made by a few people who call themselves revolutionaries,
which permit them to outlaw a whole people who are more revolutionary than
they are themselves?"_ and _"[w]hose interests should the revolution defend:
those of the Party or those of the people who set the revolution in motion
with their blood?"_ Makhno himself stated that he _"consider[ed] it an
inviolable right of the workers and peasants, a right won by the revolution,
to call conferences on their own account, to discuss their affairs."_ [**Op.
Cit.**, p. 103 and p. 129]

These actions by the Bolsheviks should make the reader ponder if the
elimination of workers' democracy during the civil war can be fully explained
by the objective conditions facing Lenin's government or whether Leninist
ideology played an important role in it. Indeed, the Kronstadt revolt
occurred, in part, because in February 1921 the administration of the Baltic
Fleet and the Communist Party organisation had collapsed, so allowing
_"unauthorised meetings of ships' crews . . . [to] tak[e] place behind the
backs of their commissars, there being too few loyal rank and file party
members left to nip them in the bud."_ [I. Getzler, **Kronstadt 1917-1921**,
p. 212]

Thus, the anarchist argument is no utopian plan. Rather, it is one which has
been applied successfully in the same circumstances which Trotskyists argue
forced the Bolsheviks to act as they did. As can be seen, a viable alternative
approach existed and was applied (see the appendix on ["Why does the
Makhnovist movement show there is an alternative to
Bolshevism?"](append46.html) for more on the Makhnovists).

The terrible objective circumstances facing the revolution obviously played a
key role in the degeneration of the revolution. However, this is not the whole
story. The **ideas** of the Bolsheviks played a key role as well. The
circumstances the Bolsheviks faced may have shaped certain aspects of their
actions, but it cannot be denied that the impulse for these actions were
rooted in Bolshevik theory.

In regards to this type of analysis, the Trotskyist Pierre Frank argues that
anarchists think that bureaucratic conceptions _"beget bureaucracy"_ and that
_"it is ideas, or deviations from them, that determine the character of
revolutions. The most simplistic kind of philosophical idealism has laid low
historical materialism."_ This means, apparently, that anarchists ignore
objective factors in the rise of the bureaucracy such as _"the country's
backwardness, low cultural level, and the isolation of the revolution."_
[Lenin and Trotsky, **Kronstadt**, pp. 22-3]

Nothing could be further from the truth, of course. What anarchists argue
(like Lenin before the October revolution) is that **every** revolution will
suffer from isolation, uneven political development, economic problems and so
on (i.e. _"exceptional circumstances,"_ see [section
12](append42.html#app12)). The question is whether your revolution can survive
them and whether your political ideas can meet these challenges without aiding
bureaucratic deformations. As can be seen from the Russian Revolution,
Leninism fails that test.

Moreover, Frank is being incredulous. If we take his argument seriously then
we have to conclude that Bolshevik ideology played **no** role in how the
revolution developed. In other words, he subscribes to the contradictory
position that Bolshevik politics were essential to the success of the
revolution and yet played no role in its outcome.

The facts of the matter is that people are faced with choices, choices that
arise from the objective conditions they face. What decisions they make will
be influenced by the ideas they hold -- they will not occur automatically, as
if people were on auto-pilot -- and their ideas are shaped by the social
relationships they experience. Thus, someone placed into a position of power
over others will act in certain ways, have a certain world view, which would
be alien to someone subject to egalitarian social relations.

So, obviously "ideas" matter, particularly during a revolution. Someone in
favour of centralisation, centralised power and who equates party rule with
class rule (like Lenin and Trotsky), will act in ways (and create structures)
totally different from someone who believes in decentralisation and
federalism. In other words, political ideas do matter in society. Nor do
anarchists leave our analysis at this obvious fact, we also argue that the
types of organisation people create and work in shapes the way they think and
act. This is because specific kinds of organisation have specific authority
relations and so generate specific social relationships. These obviously
affect those subject to them -- a centralised, hierarchical system will create
authoritarian social relationships which shape those within it in totally
different ways than a decentralised, egalitarian system. That Frank denies
this obvious fact suggests he knows nothing of materialist philosophy and
subscribes to the distinctly lobotomised (and bourgeois) "historical
materialism" of Lenin (see Anton Pannekoek's **Lenin as Philosopher** for
details).

The attitude of Leninists to the Kronstadt event shows quite clearly that, for
all their lip-service to history from below, they are just as fixated with
leaders as is bourgeois history. As Cornellius Castoriadis argues:

> _"Now, we should point out that it is not workers who write history. It is
always the **others**. And these others, whoever they may be, have a
historical existence only insofar as the masses are passive, or active simply
to support them, and this is precisely what 'the others' will tell us at every
opportunity. Most of the time these others will not even possess eyes to see
and ears to hear the gestures and utterances that express people's autonomous
activity. In the best of instances, they will sing the praises of this
activity so long as it **miraculously** coincides with their own line, but
they will radically condemn it, and impute to it the basest motives, as soon
as it strays therefrom. Thus Trotsky describes in grandiose terms the
anonymous workers of Petrograd moving ahead of the Bolshevik party or
mobilising themselves during the Civil War, but later on he was to
characterise the Kronstadt rebels as 'stool pigeons' and 'hirelings of the
French High Command.' They lack the categories of thought -- the brain cells,
we might dare say -- necessary to understand, or even to record, this activity
as it really occurs: to them, an activity that is not instituted, that has
neither boss nor program, has no status; it is not even clearly perceivable,
except perhaps in the mode of 'disorder' and 'troubles.' The autonomous
activity of the masses belongs by definition to what is **repressed** in
history."_ [**Op. Cit.**, p. 91]

The Trotskyist accounts of the Kronstadt revolt, with their continual attempts
to portray it as a White conspiracy, proves this analysis is correct. Indeed,
the possibility that the revolt was a spontaneous mass revolt with political
aims was dismissed by one of them as _"absurd"_ and instead was labelled the
work of _"backward peasants"_ being mislead by SRs and spies. Like the
capitalist who considers a strike the work of "outside agitators" and
"communists" misleading their workers, the Trotskyists present an analysis of
Kronstadt reeking of elitism and ideological incomprehension. Independence on
behalf of the working class is dismissed as "backward" and to be corrected by
the "proletarian dictatorship." Clearly Bolshevik ideology played a key role
in the rise of Stalinism.

Lastly, the supporters of Bolshevism argue that in suppressing the revolt
_"the Bolsheviks only did their duty. They defended the conquests of the
revolution against the assaults of the counterrevolution."_ [Wright, **Op.
Cit.**, p. 123] In other words, we can expect more Kronstadts if these
"revolutionaries" gain power. The _"temporary vacillations"_ of future
revolutions will, like Kronstadt, be rectified by bullets when the Party
_"assert[s] its dictatorship even if its dictatorship clashes even with the
passing moods of the workers' democracy."_ [Trotsky, quoted by M. Brinton,
**Op. Cit.**, p. 78] No clearer condemnation of Bolshevism as a socialist
current is required.

And, we must ask, what, exactly, **were** these "conquests" of the revolution
that must be defended? The suppression of strikes, independent political and
labour organisations, elimination of freedom of speech, assembly and press
and, of course, the elimination of soviet and union democracy in favour of
part dictatorship? Which, of course, for all Leninists, is the **real**
revolutionary conquest. Any one who attacks that is, of course, a counter-
revolutionary (even if they are workers). Thus:

> _"Attitudes to the Kronstadt events, expressed . . . years after the event
often provide deep insight into the political thinking of contemporary
revolutionaries. They may in fact provide a deeper insight into their
conscious or unconscious aims than many a learned discussion about economics,
or philosophy or about other episodes of revolutionary history. _

>

> _"It is a question of one's basic attitude as to what socialism is all
about. what are epitomised in the Kronstadt events are some of the most
difficult problems of revolutionary strategy and revolutionary ethics: the
problems of ends and means, of the relations between Party and masses, in fact
whether a Party is necessary at all. Can the working class by itself only
develop a trade union consciousness? . . . _

>

> _"Or can the working class develop a deeper consciousness and understanding
of its interests than can any organisations allegedly acting on its behalf?
When Stalinists or Trotskyists speak of Kronstadt as 'an essential action
against the class enemy' when some more 'sophisticated' revolutionaries refer
to it as a 'tragic necessity,' one is entitled to pause for thought. One is
entitled to ask how seriously they accept Marx's dictum that 'the emancipation
of the working class is the task of the working class itself.' Do they take
this seriously or do they pay mere lip service to the words? Do they identify
socialism with the autonomy (organisational and ideological) of the working
class? Or do they see themselves, with their wisdom as to the 'historic
interests' of others, and with their judgements as to what should be
'permitted,' as the leadership around which the future elite will crystallise
and develop? One is entitled not only to ask . . . but also to suggest the
answer!"_ [_"Preface"_, Ida Mett's **The Kronstadt Uprising**, pp. 26-7]

The issue is simple -- either socialism means the self-emancipation of the
working class or it does not. Leninist justifications for the suppression of
the Kronstadt revolt simply means that for the followers of Bolshevism, when
necessary, the party will paternalistically repress the working class for
their own good. The clear implication of this Leninist support of the
suppression of Kronstadt is that, for Leninism, it is dangerous to allow
working class people to manage society and transform it as they see fit as
they will make wrong decisions (like vote for the wrong party). If the party
leaders decide a decision by the masses is incorrect, then the masses are
overridden (and repressed). So much for _"all power to the soviets"_ or
_"workers' power."_

Ultimately, Wright's comments (and those like it) show that Bolshevism's
commitment to workers' power and democracy is non-existent. What is there left
of workers' self-emancipation, power or democracy when the "workers state"
represses the workers for trying to practice these essential features of any
real form of socialism? It is the experience of Bolshevism in power that best
refutes the Marxist claim that the workers' state "will be democratic and
participatory." The suppression of Kronstadt was just one of a series of
actions by the Bolsheviks which began, **before** the start of the Civil War,
with them abolishing soviets which elected non-Bolshevik majorities,
abolishing elected officers and soldiers soviets in the Red Army and Navy and
replacing workers' self-management of production by state-appointed managers
with _"dictatorial"_ powers (see sections [H.4](secH4.html) and
[2](append42.html#app2) for details).

As Bakunin predicted, the "workers' state" did not, could not, be
"participatory" as it was still a state. Kronstadt is part of the empirical
evidence which proves Bakunin's predictions on the authoritarian nature of
Marxism. These words by Bakunin were confirmed by the Kronstadt rebellion and
the justifications made at the time and afterwards by the supporters of
Bolshevism:

> _"What does it mean, 'the proletariat raised to a governing class?' Will the
entire proletariat head the government? The Germans number about 40 million.
Will all 40 million be members of the government? The entire nation will rule,
but no one would be ruled. Then there will be no government, there will be no
state; but if there is a state, there will also be those who are ruled, there
will be slaves._

> _ "In the Marxists' theory this dilemma is resolved in a simple fashion. By
popular government they mean government of the people by a small number of
representatives elected by the people. So-called popular representatives and
rulers of the state elected by the entire nation on the basis of universal
suffrage -- the last word of the Marxists, as well as the democratic school --
is a lie behind which the despotism of a ruling minority is concealed, a lie
all the more dangerous in that it represents itself as the expression of a
sham popular will._

> _ "So . . . it always comes down to the same dismal result: government of
the vast majority of the people by a privileged minority. But this minority,
the Marxists say, will consist of workers. Yes, perhaps, of **former**
workers, who, as soon as they become rulers or representatives of the people
will cease to be workers and will begin to look upon the whole workers' world
from the heights of the state. They will no longer represent the people but
themselves and their own pretensions to govern the people. . . _

> _ "They say that this state yoke, this dictatorship, is a necessary
transitional device for achieving the total liberation of the people: anarchy,
or freedom, is the goal, and the state, or dictatorship, the means. Thus, for
the masses to be liberated they must first be enslaved. . . . They claim that
only a dictatorship (theirs, of course) can create popular freedom. We reply
that no dictatorship can have any other objective than to perpetuate itself,
and that it can engender and nurture only slavery in the people who endure it.
Liberty can only be created by liberty, by an insurrection of all the people
and the voluntary organisation of the workers from below upward."_ [**Statism
and Anarchy**, pp. 178-9]

[‹ What happened during the Russian Revolution?](/afaq/append41.html "Go to
previous page" ) [up](/afaq/append4.html "Go to parent page" ) [What caused
the degeneration of the Russian Revolution? ›](/afaq/append43.html "Go to next
page" )

